<?php

namespace Modules\Category\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Modules\Category\Entities\Category;
use Modules\Post\Entities\Post;
use Modules\Product\Entities\Product;

class ProductCategoryController extends Controller
{
    use SEOTools;

    public function index()
    {
        $this->seo()->setTitle('همه دسته بندی ها');
        $categories = Category::with('children')
            ->whereNull('parent_id')
            ->where('category_type'  , Product::class)
            ->simplePaginate(15);
        return view('category::backend.products.all', compact('categories'));
    }


    public function create()
    {
        $this->seo()->setTitle('ایجاد دسته بندی جدید');
        $categories = Category::with('children')
            ->where('category_type'  , Product::class)
            ->whereNull('parent_id')->get();
        return view('category::backend.products.create' , compact('categories'));
    }


    public function store(Request $request)
    {
        $validData = $request->validate([
            'name' => 'required',
            'parent_id' => 'nullable',
            'slug' => 'unique:categories|nullable',
            'image' => 'nullable',
            'keywords' => 'nullable',
            'cat_desc' => 'nullable'
        ]);
        $category = new Category();
        $category->name = $validData['name'];
        $category->parent_id = $validData['parent_id'];
        $category->cat_image = $validData['image'];
        $category->keywords = $validData['keywords'];
        $category->cat_desc = $validData['cat_desc'];
        if ($request->input('slug') != "") {
            $category->slug = str_slug($validData['slug']);
        } else {
            $category->slug = str_slug($validData['name']);
        }
        $category->category_type = Product::class;
        $category->save();
        alert()->success('دسته بندی با موفقیت ساخته شد.' , 'موفق');
        return back();
    }

    public function edit(Category $categories_product)
    {
        $this->seo()->setTitle("ویرایش دسته بندی $categories_product->name");

        $categories = Category::with('children')
            ->where('category_type'  , Product::class)
            ->whereNull('parent_id')
            ->get();

        return view('category::backend.products.edit' , compact(['categories_product','categories']));
    }

    public function update(Request $request, Category $categories_product)
    {
        $validData = $request->validate([
            'name' => 'required',
            'parent_id' => 'nullable',
            'slug' => [
                Rule::unique('categories')->ignore($categories_product->id)
            ],
            'image' => 'nullable',
            'cat_desc' => 'nullable',
            'keywords' => 'nullable'
        ]);
        $selected_cat = Category::find($validData['parent_id']);

        if ($validData['parent_id'] == $categories_product->id){
            alert()->error('دسته بندی نمیتواند زیر دسته ی خودش باشد' , 'خطا');
            return back();
        }
        foreach ($categories_product->children as $val){
            if ($validData['parent_id'] == $val->id){
                alert()->error('دسته بندی نمیتواند زیر دسته ی خودش باشد' , 'خطا');
                return back();
            }
        }
        if ($categories_product->slug === $validData['slug']) {
            unset($validData['slug']);
            $categories_product->update([
                'name' => $validData['name'],
                'parent_id' => $validData['parent_id'],
                'cat_image' => $validData['image'],
                'cat_desc' => $validData['cat_desc'],
                'keywords' => $validData['keywords'],
            ]);
        } else {
            $categories_product->update([
                'name' => $validData['name'],
                'parent_id' => $validData['parent_id'],
                'slug' => str_slug($validData['slug']),
                'cat_image' => $validData['image'],
                'keywords' => $validData['keywords'],
                'cat_desc' => $validData['cat_desc'],
            ]);
        }
        $categories_product->update($validData);
        alert()->success('دسته بندی با موفقیت ویرایش شد.' , 'موفق');
        return back();
    }

    public function destroy(Category $categories_product)
    {
        if ($categories_product->children()->count()){
            alert()->error('این دسته بندی دارای زیر دسته است و نمیتواند حذف شود' , 'خطا');
            return back();
        }
        $categories_product->delete();
        alert()->success('دسته بندی با موفقیت حذف شد.' , 'موفق');
        return redirect(route('admin.categories-products.index'));
    }
}
