<?php

namespace Modules\Category\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Discount\Entities\Discount;
use Modules\Post\Entities\Post;
use Modules\Product\Entities\Product;

class Category extends Model
{
    use HasFactory;

    protected $fillable = ['name' , 'parent_id' , 'keywords' , 'slug' , 'is_on_pin' , 'pin_price' , 'pin_count' , 'cat_image' , 'cat_desc'];


    //many to many polymorphic relationship with Posts table

    public function posts()
    {
        return $this->morphedByMany(Post::class , 'categorizable');
    }

    public function products()
    {
        return $this->morphedByMany(Product::class , 'categorizable');
    }

    public function discounts()
    {
        return $this->hasMany(Discount::class);
    }

    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id' , 'id');
    }

    public function childrenRecursive()
    {
        return $this->children()->with('childrenRecursive');
    }
}
