<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;

Route::prefix('cart')->namespace('Front')->group(function() {
    Route::get('/' , 'CartController@cart')->name('cart.show');
    Route::post('/add/{product}' , 'CartController@addToCart')->name('cart.add');
    Route::patch('/quantity/change' , 'CartController@quantityChange')->name('cart.quantity.change');
    Route::delete('/delete/{cart}' , 'CartController@deleteFromCart')->name('cart.destroy');
});

Route::prefix('checkout')->namespace('Front')->group(function() {
    Route::get('/' , 'CheckoutController@index')->name('checkout.show');
});
