@component('backend.layouts.components.main',['title' => 'مدیریت نقش','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش نقش</li>
        <li class="breadcrumb-item">{{$role->name}}</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات نقش</h4>
            </div>
            <div class="card-body">

                <div class="">
                    <form action="{{route('admin.roles.update' , $role)}}" method="post" id="update">
                        @csrf
                        @method('patch')
                        <div class="form-group">
                            <input name="name" type="text"
                                   class="form-control input-rounded @error('name') is-invalid @enderror" placeholder="عنوان"
                                   form="update" required
                                   value="{{old('name') ? old('name') : $role->name}}"/>
                            @error('name')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">توضیحات</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control input-rounded" name="label"
                                value="{{old('label') ? old('label') : $role->label}}"/>
                                @error('label')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دسترسی ها</label>
                            <div class="col-sm-9">
                                <select type="text" class="form-control default-select input-rounded" name="permissions[]" multiple>
                                    @foreach($permissions as $permission)
                                        <option value="{{$permission->id}}"
                                        {{in_array($permission->id , $role->permissions->pluck('id')->toArray()) ? 'selected' : ''}}
                                        >نام : {{$permission->name}} |  توضیح:  {{$permission->label}}</option>
                                    @endforeach
                                </select>
                                @error('permissions')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.roles.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال تغییرات روی دکمه ی به روز رسانی کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-warning ml-1"></i>
                    در صورت حذف، آیتم مورد نظر برای همیشه حذف شده و راهی برای بازگشت آن وجود ندارد.
                </p>
                <div class="row">
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('update').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}

@endcomponent
