@component('backend.layouts.components.main',['title' => 'مدیریت مجوز ها', 'titleBar'=>true , 'button' => 'افزودن مجوز' , 'route' => 'admin.permissions.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">مجوز ها</li>


    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست مجوز ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>توضیحات</th>
                            <th>عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($permissions as $permission)
                            <tr>
                                <td>
                                    {{$permission->name}}
                                </td>
                                <td>
                                    {{$permission->label}}
                                </td>
                                <td>
                                    <form action="{{route('admin.permissions.destroy', $permission->id)}}" method="post"
                                          id="delete-{{$permission->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    <a href="{{route('admin.permissions.edit', $permission->id)}}" role="button"
                                       class="btn btn-success light sharp" title="ویرایش">
                                        <i class="fa fa-pencil"
                                           onclick="document.getElementById('edit-{{$permission->id}}').submit()"></i>
                                    </a>
                                    <button onclick="document.getElementById('delete-{{$permission->id}}').submit()"
                                            role="button" class="btn btn-danger light sharp" title="حذف">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>

                </div>
                {{$permissions->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
