<?php

namespace Modules\ACL\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\ACL\Entities\Permission;
use Modules\ACL\Entities\Role;

class RoleController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه ی نقش ها');

        $roles = Role::query();
        if ($key = \request('search')) {
            $roles = $roles->where('name' , 'like' , "%$key%");
        }
        $roles = $roles->latest()->simplePaginate(15);
        return view('acl::backend.roles.all' , compact('roles'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $this->seo()->setTitle('ایجاد نقش جدید');
        $permissions = Permission::all();
        return view('acl::backend.roles.create' , compact('permissions'));
    }


    public function store(Request $request)
    {
        $validData = $request->validate([
            'name' => 'required|string|unique:roles',
            'label' => 'required',
            'permissions' => 'required|array'
        ]);

        $role = Role::create($validData);
        $role->permissions()->sync($validData['permissions']);
        alert()->success('نقش با موفقیت ساخته شد.');
        return back();
    }


    public function show($id)
    {
        return view('acl::show');
    }


    public function edit(Role $role)
    {
        $this->seo()->setTitle("ویرایش نقش $role->name");
        $permissions = Permission::all();
        return view('acl::backend.roles.edit' , compact(['role' , 'permissions']));
    }


    public function update(Request $request, Role $role)
    {
        $validData = $request->validate([
            'name' => 'required|string',
            'label' => 'required',
            'permissions' => 'required|array'
        ]);
        $role->update($validData);
        $role->permissions()->sync($validData['permissions']);
        alert()->success('نقش با موفقیت ویرایش شد.');
        return back();
    }


    public function destroy(Role $role)
    {
        $role->delete();
        alert()->success('نقش با موفقیت حذف شد.');
        return back();
    }
}
