let changeAttributeValues = (event, id) => {
    let valueBox = $(`select[name='attributes[${id}][value]']`);


    //
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': document.head.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json'
        }
    })
    //
    $.ajax({
        type: 'POST',
        url: '/icworld-fa/attribute/values',
        data: JSON.stringify({
            name: event.target.value
        }),
        success: function (res) {
            valueBox.html(`
                            <option value="" selected>انتخاب کنید</option>
                            ${
                res.data.map(function (item) {
                    return `<option value="${item}">${item}</option>`
                })
            }
                        `);
        }
    });
}

let createNewAttr = ({attributes, id}) => {

    return `
                    <div class="row" id="attribute-${id}">
                        <div class="col-5">
                            <div class="form-group">
                                 <label>عنوان ویژگی</label>
                                 <select name="attributes[${id}][name]" onchange="changeAttributeValues(event, ${id});" class="attribute-select form-control">
                                    <option value="">انتخاب کنید</option>
                                    ${
        attributes.map(function (item) {
            return `<option value="${item}">${item}</option>`
        })
    }
                                 </select>
                            </div>
                        </div>
                        <div class="col-5">
                            <div class="form-group">
                                 <label>مقدار ویژگی</label>
                                 <select name="attributes[${id}][value]" class="attribute-select form-control">
                                        <option value="">انتخاب کنید</option>
                                 </select>
                            </div>
                        </div>
                         <div class="col-2">
                            <label >اقدامات</label>
                            <div>
                                <button type="button" class="btn btn-sm btn-warning" onclick="document.getElementById('attribute-${id}').remove()">حذف</button>
                            </div>
                        </div>
                    </div>
                `
}

$('#add_product_attribute').click(function () {
    let attributesSection = $('#attribute_section');
    let id = attributesSection.children().length;

    let attributes = $('#attributes').data('attributes');
    console.log(attributes);
    attributesSection.append(
        createNewAttr({
            attributes,
            id
        })
    );

    $('.attribute-select').select2({tags: true});
});

