

<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>
<div class="section-wrap-body">
    <div class="single-section">
        <h4 class="section-title">Please configure your PHP settings  to match following requirements</h4>
        <div class="primary-table">
            <div class="table-responsive">
                <table class="table table-borderless">
                    <thead>
                      <tr>
                        <th scope="col">PHP Settings</th>
                        <th scope="col">Current Version</th>
                        <th scope="col">Required Version</th>
                        <th scope="col">Status</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td>PHP Version</td>
                        <td><strong><?php echo e(phpversion()); ?></strong></td>
                        <td><strong>^8.1.0</strong></td>
                        <td><span class="status <?php echo e(phpversion() < 8.1 ? 'error' : ''); ?>"><?php echo e(phpversion() < 8.1 ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="single-section">
        <h4 class="section-title">Please make sure the extension/settings listed below are installed/enabled</h4>
        <div class="primary-table">
            <div class="table-responsive">
                <table class="table table-borderless">
                    <thead>
                      <tr>
                        <th scope="col">Extensions/Settings</th>
                        <th scope="col">Current Settings</th>
                        <th scope="col">Required Settings</th>
                        <th scope="col">Status</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td>MySQLi</td>
                        <td><strong><?php echo e(!extension_loaded('mysqli') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('mysqli') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('mysqli') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>GD</td>
                        <td><strong><?php echo e(!extension_loaded('gd') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('gd') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('gd') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>cURL</td>
                        <td><strong><?php echo e(function_exists('curl_version') ? 'On' : 'Off'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(function_exists('curl_version') ? '' : 'error'); ?>"><?php echo e(function_exists('curl_version') ? 'Ok' : 'Error'); ?></span></td>
                      </tr>
                      <tr>
                        <td>allow_url_fopen</td>
                        <td><strong><?php echo e(ini_get('allow_url_fopen') ? 'On' : 'Off'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(ini_get('allow_url_fopen') ? '' : 'error'); ?>"><?php echo e(ini_get('allow_url_fopen') ? 'Ok' : 'Error'); ?></span></td>
                      </tr>
                      <tr>
                        <td>OpenSSL PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('openssl') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('openssl') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('openssl') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>PDO PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('pdo') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('pdo') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('pdo') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>BCMAth PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('bcmath') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('bcmath') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('bcmath') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>Ctype PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('ctype') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('ctype') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('ctype') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>Fileinfo PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('fileinfo') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('fileinfo') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('fileinfo') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>MBstring PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('mbstring') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('mbstring') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('mbstring') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>Tokenizer PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('tokenizer') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('tokenizer') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('tokenizer') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>XML PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('xml') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('xml') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('xml') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      <tr>
                        <td>Json PHP Extension</td>
                        <td><strong><?php echo e(!extension_loaded('json') ? 'Off' : 'On'); ?></strong></td>
                        <td><strong>On</strong></td>
                        <td><span class="status <?php echo e(!extension_loaded('json') ? 'error' : ''); ?>"><?php echo e(!extension_loaded('json') ? 'Error' : 'Ok'); ?></span></td>
                      </tr>
                      
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="single-section">
        <h4 class="section-title">Please make sure you have set  the Writable permission on the following folders/files :</h4>
        <ul class="permission-lsit">




            <li>
                <span class="permission-text">./resources</span>
                <span class="status <?php echo e(File::exists(base_path('resources')) && $resource_value == 1 ? '' : 'error'); ?>"><?php echo e(File::exists(base_path('resources')) && $resource_value == 1 ? 'Ok' : 'Error'); ?></span>
            </li>
            <li>
                <span class="permission-text">./public</span>
                <span class="status <?php echo e(File::exists(base_path('public')) && $public_value == 1 ? '' : 'error'); ?>"><?php echo e(File::exists(base_path('public')) && $public_value == 1 ? 'Ok' : 'Error'); ?></span>
            </li>
            <li>
                <span class="permission-text">./storage</span>
                <span class="status <?php echo e(File::exists(base_path('storage')) && $storage_value == 1 ? '' : 'error'); ?>"><?php echo e(File::exists(base_path('storage')) && $storage_value == 1 ? 'Ok' : 'Error'); ?></span>
            </li>
            <li>
                <span class="permission-text">.env</span>
                <span class="status <?php echo e(File::exists(base_path('.env')) && $env_value == 1 ? '' : 'error'); ?>"><?php echo e(File::exists(base_path('.env')) && $env_value == 1 ? 'Ok' : 'Error'); ?></span>
            </li>
        </ul>
    </div>
    <div>
        <div class="row">
            <div class="col-6">
                <a href="<?php echo e(route('ZaiInstaller::pre-install')); ?>" class="primary-btn">Close</a>
            </div>
            <div class="col-6">
                <form action="<?php echo e(route('ZaiInstaller::server-validation')); ?>" method="post">
                    <?php echo csrf_field(); ?>

                    <input type="hidden" name="resources" value="<?php echo e(File::exists(base_path('resources')) && $resource_value == 1 ? 1 : 0); ?>">
                    <input type="hidden" name="public" value="<?php echo e(File::exists(base_path('public')) && $public_value == 1 ? 1 : 0); ?>">
                    <input type="hidden" name="storage" value="<?php echo e(File::exists(base_path('storage')) && $storage_value == 1 ? 1 : 0); ?>">
                    <input type="hidden" name="env" value="<?php echo e(File::exists(base_path('.env')) && $env_value == 1 ? 1 : 0); ?>">
                    <button class="primary-btn next" type="submit">Next</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('zainiklab.installer.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khavarii/test.khavarii.com/resources/views/zainiklab/installer/pre-install.blade.php ENDPATH**/ ?>