<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="page-content-wrapper bg-white p-30 radius-20">
                    <div class="row">
                        <div class="col-12">
                            <div
                                class="page-title-box d-sm-flex align-items-center justify-content-between border-bottom mb-20">
                                <div class="page-title-left">
                                    <h3 class="mb-sm-0"><?php echo e($pageTitle); ?></h3>
                                </div>
                                <div class="page-title-right">
                                    <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"
                                                title="<?php echo e(__('Dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                                        <li class="breadcrumb-item" aria-current="page"><?php echo e(__('Users')); ?></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($pageTitle); ?></li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 col-xl-8 col-xxl-6">
                            <div class="subscription-plan-box bg-white theme-border radius-4 p-20 mb-3">


                                <div class="d-flex">
                                    <img class="rounded avatar-md tbl-user-image" src="<?php echo e($user->image); ?>" alt="">
                                    <div class="ms-3">
                                        <?php echo e($user->name); ?> <br>
                                        <?php echo e($user->email); ?> <br>
                                        <?php echo e($user->contact_number); ?> <br>
                                        <?php if($user->status == ACTIVE): ?>
                                            <div class="status-btn status-btn-green font-13 radius-4">
                                                <?php echo e(__('Active')); ?></div>
                                        <?php else: ?>
                                            <div class="status-btn status-btn-red font-13 radius-4">
                                                <?php echo e(__('Deactivate')); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                            </div>
                            <div class="subscription-plan-box bg-white theme-border radius-4 p-20 mb-3">
                                <div class="current-plan d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <p><?php echo e(__('Current Plan')); ?></p>
                                        <h4><?php echo e($userPlan?->name ?? 'No plan'); ?></h4>
                                    </div>
                                    <div class="flex-shrink-0 ms-3">
                                        <button type="button" class="theme-btn" id="assignPackage"
                                            title="<?php echo e(__('Upgrade Plan')); ?>"><?php echo e(__('Upgrade Plan')); ?></button>
                                    </div>
                                </div>
                                <?php if(!is_null($userPlan)): ?>
                                    <div class="current-plan plan-usage d-flex align-items-center pt-20 mt-20">
                                        <div class="flex-grow-1">
                                            <p><?php echo e(__('Usage')); ?></p>
                                            <div class="plan-usage-list">
                                                <div class="d-flex">
                                                    <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                                    <h4 class="flex-grow-1"><?php echo e(getCharUsed()); ?> /
                                                        <?php echo e($userPlan->generate_characters); ?> <?php echo e('characters'); ?></h4>
                                                </div>

                                                <div class="d-flex">
                                                    <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                                    <h4 class="flex-grow-1"><?php echo e(getUseCase($userPlan->access_use_cases)); ?>

                                                        <?php echo e('use cases'); ?></h4>
                                                </div>

                                                <div class="d-flex">
                                                    <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                                    <h4 class="flex-grow-1"><?php echo e(__('All')); ?>

                                                        <?php echo e(__('languages')); ?></h4>
                                                </div>

                                                <div class="d-flex">
                                                    <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                                    <h4 class="flex-grow-1"><?php echo e(__('All')); ?>

                                                        <?php echo e('tones'); ?></h4>
                                                </div>

                                                <?php if($userPlan->access_community): ?>
                                                    <div class="d-flex">
                                                        <span
                                                            class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                                        <h4 class="flex-grow-1"><?php echo e($userPlan->access_community); ?></h4>
                                                    </div>
                                                <?php endif; ?>

                                                <?php if($userPlan->support): ?>
                                                    <div class="d-flex">
                                                        <span
                                                            class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                                        <h4 class="flex-grow-1"><?php echo e($userPlan->support); ?></h4>
                                                    </div>
                                                <?php endif; ?>

                                                <div class="d-flex">
                                                    <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                                    <h4 class="flex-grow-1"><?php echo e(__('Plan started at ')); ?>

                                                        <?php echo e($userPlan->start_date); ?></h4>
                                                </div>
                                                <div class="d-flex">
                                                    <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                                    <h4 class="flex-grow-1"><?php echo e(__('Plan end in ')); ?>

                                                        <?php echo e($userPlan->end_date); ?></h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="current-plan plan-usage d-flex align-items-center pt-20 mt-20">
                                        <div class="d-flex justify-content-center">
                                            <h4 class="mb-20"><?php echo e(__('No plan assigned')); ?></h4>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <!-- Subscription Page Plan Box row -->

                        </div>

                        <div class="col-md-12 col-xl-8 col-xxl-6">
                            <div class="subscription-plan-box bg-white theme-border radius-4 p-20 mb-3">
                                <div class="current-plan d-flex align-items-center pb-20">
                                    <div class="flex-grow-1">
                                        <h4><?php echo e(__('Billing Information & Invoices')); ?></h4>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="table-responsive">
                                        <table id="allDataTable" class="table theme-border dt-responsive">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('SL')); ?></th>
                                                    <th><?php echo e(__('Package')); ?></th>
                                                    <th><?php echo e(__('Amount')); ?></th>
                                                    <th><?php echo e(__('Start Date')); ?></th>
                                                    <th><?php echo e(__('End Date')); ?></th>
                                                    <th><?php echo e(__('Download')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e($loop->iteration); ?></td>
                                                        <td><?php echo e($invoice->packageName); ?></td>
                                                        <td><?php echo e($invoice->orders_total == 'Admin' ? 'Admin' : currencyPrice($invoice->orders_total)); ?>

                                                        </td>
                                                        <td><?php echo e(timeFormat($invoice->start_date)); ?></td>
                                                        <td><?php echo e(timeFormat($invoice->end_date)); ?></td>
                                                        <td>
                                                            <a href="<?php echo e(route('user.subscription.invoice.print', $invoice->id)); ?>"
                                                                target="_blank" class="p-1 tbl-action-btn"
                                                                title="download"><span class="iconify"
                                                                    data-icon="fa6-solid:download"></span></a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="6" class="text-center">
                                                            <?php echo e(__('No Invoice Found')); ?>

                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                            <div class="subscription-plan-box bg-white theme-border radius-4 p-20 mb-3">
                                <div class="current-plan d-flex align-items-center pb-20">
                                    <div class="flex-grow-1">
                                        <h4><?php echo e(__('Orders')); ?></h4>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="table-responsive">
                                        <table id="allDataTable" class="table theme-border dt-responsive">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('SL')); ?></th>
                                                    <th><?php echo e(__('Package')); ?></th>
                                                    <th><?php echo e(__('Amount')); ?></th>
                                                    <th><?php echo e(__('Gateway')); ?></th>
                                                    <th><?php echo e(__('Status')); ?></th>
                                                    <th><?php echo e(__('Download')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e($loop->iteration); ?></td>
                                                        <td><?php echo e($order->packageName); ?></td>
                                                        <td><?php echo e(currencyPrice($order->total)); ?></td>
                                                        <td><?php echo e($order->gatewayTitle); ?></td>
                                                        <td>
                                                            <?php if($order->payment_status == ORDER_PAYMENT_STATUS_PAID): ?>
                                                                <div class="status-btn status-btn-blue font-13 radius-4">
                                                                    <?php echo e(__('Paid')); ?></div>
                                                            <?php elseif($order->payment_status == ORDER_PAYMENT_STATUS_PENDING): ?>
                                                                <div class="status-btn status-btn-red font-13 radius-4">
                                                                    <?php echo e(__('Pending')); ?></div>
                                                            <?php else: ?>
                                                                <div class="status-btn status-btn-orange font-13 radius-4">
                                                                    <?php echo e(__('Cancelled')); ?></div>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <?php if($order->gatewaySlug == 'bank'): ?>
                                                                <a href="<?php echo e(getFileUrl($order->folder_name, $order->file_name)); ?>"
                                                                    class="p-1 tbl-action-btn" title="<?php echo e(__('Download')); ?>"
                                                                    download>
                                                                    <span class="iconify"
                                                                        data-icon="fa6-solid:download"></span></a>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <tr>
                                                        <td colspan="6" class="text-center">
                                                            <?php echo e(__('No Invoice Found')); ?>

                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="userPackageAssignModal" tabindex="-1" aria-labelledby="userPackageAssignModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="userPackageAssignModalLabel"><?php echo e(__('Package Assign')); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span class="iconify" data-icon="akar-icons:cross"></span>
                    </button>
                </div>
                <form class="ajax" action="<?php echo e(route('admin.packages.assign')); ?>" method="post"
                    data-handler="getShowMessage">
                    <input type="hidden" value="<?php echo e($user->id); ?>" name="user_id">
                    <div class="modal-body">
                        <div class="modal-inner-form-box bg-off-white theme-border radius-4 p-20 mb-20 pb-0">
                            <div class="row">
                                <div class="col-md-12 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Packages')); ?></label>
                                    <select class="form-select flex-shrink-0" name="package_id">
                                        <option value=""><?php echo e(__('Select Package')); ?></option>
                                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($package->id); ?>"><?php echo e($package->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="<?php echo e(__('Back')); ?>"><?php echo e(__('Back')); ?></button>
                        <button type="submit" class="theme-btn me-3"
                            title="<?php echo e(__('Submit')); ?>"><?php echo e(__('Submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('backend/assets/js/custom/user-package-assign.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/khavarii/test.khavarii.com/resources/views/admin/users/details.blade.php ENDPATH**/ ?>