

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-content">
            <div class="container-fluid">
                <div class="page-content-wrapper bg-white p-30 radius-20">
                    <div class="row">
                        <div class="col-12">
                            <div
                                class="page-title-box d-sm-flex align-items-center justify-content-between border-bottom mb-20">
                                <div class="page-title-left">
                                    <h3 class="mb-sm-0"><?php echo e(__('Settings')); ?></h3>
                                </div>

                                <div class="page-title-right">
                                    <ol class="breadcrumb mb-0">
                                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"
                                                title="Dashboard"><?php echo e(__('Dashboard')); ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__(@$pageTitle)); ?></li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="settings-page-layout-wrap position-relative">
                        <div class="row">
                            <!-- Account settings Left Side Start-->
                            <?php echo $__env->make('admin.setting.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <!-- Account settings Left Side End-->
                            <!-- Account settings Area Right Side Start-->
                            <div class="col-md-12 col-lg-12 col-xl-8 col-xxl-9">
                                <div class="account-settings-rightside bg-off-white theme-border radius-4 p-25">
                                    <!-- Language Settings Page Start -->
                                    <div class="language-settings-page-area">
                                        <!-- Account Settings Content Box Start -->
                                        <div class="account-settings-content-box">
                                            <div class="account-settings-title border-bottom mb-20 pb-20">
                                                <div class="row align-items-center">
                                                    <div class="col-md-6">
                                                        <h4><?php echo e(__(@$pageTitle)); ?></h4>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="property-details-right text-end">
                                                            <button type="button" class="theme-btn" id="add"
                                                                title="<?php echo e(__('Add Language')); ?>">
                                                                <?php echo e(__('Add Language')); ?>

                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Language List Table Area Start -->
                                            <div class="language-list-table-area">
                                                <!-- datatable Start -->
                                                <div class="table-responsive bg-off-white theme-border radius-4 p-25">
                                                    <table id="allDataTable"
                                                        class="table bg-off-white theme-border p-20 dt-responsive">
                                                        <thead>
                                                            <tr>
                                                                <th class="all"><?php echo e(__('SL')); ?></th>
                                                                <th class="all"><?php echo e(__('Flag')); ?></th>
                                                                <th class="all"><?php echo e(__('Name')); ?></th>
                                                                <th class="desktop"><?php echo e(__('Code')); ?></th>
                                                                <th class="desktop"><?php echo e(__('RTL')); ?></th>
                                                                <th class="all"><?php echo e(__('Status')); ?></th>
                                                                <th class="desktop"><?php echo e(__('Action')); ?></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <td><?php echo e($loop->iteration); ?></td>
                                                                    <td>
                                                                        <div
                                                                            class="tenants-tbl-info-object tbl-info-property-img d-flex align-items-center">
                                                                            <div class="flex-shrink-0 ">
                                                                                <img src="<?php echo e($language->icon); ?>"
                                                                                    class="rounded avatar-xs tbl-user-image">
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                    <td><?php echo e($language->name); ?></td>
                                                                    <td><?php echo e($language->code); ?></td>
                                                                    <td>
                                                                        <?php if($language->rtl == 1): ?>
                                                                            <span
                                                                                class="status-btn status-btn-green"><?php echo e(__('Yes')); ?></span>
                                                                        <?php else: ?>
                                                                            <span
                                                                                class="status-btn status-btn-red"><?php echo e(__('No')); ?></span>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td>
                                                                        <?php if($language->status == 1): ?>
                                                                            <span
                                                                                class="status-btn status-btn-green"><?php echo e(__('Published')); ?></span>
                                                                        <?php else: ?>
                                                                            <span
                                                                                class="status-btn status-btn-red"><?php echo e(__('Unpublished')); ?></span>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td>
                                                                        <div class="tbl-action-btns d-inline-flex">
                                                                            <button
                                                                                class="p-1 tbl-action-btn editLanguageBtn"
                                                                                data-data="<?php echo e($language); ?>"
                                                                                title="Edit" data-bs-toggle="modal"
                                                                                data-bs-target="#editLanguageModal">
                                                                                <span class="iconify"
                                                                                    data-icon="clarity:note-edit-solid"></span>
                                                                            </button>

                                                                            <a href="#"
                                                                                class="p-1 tbl-action-btn deleteItem"
                                                                                data-formid="delete_row_form_<?php echo e($language->id); ?>"
                                                                                title="Delete"><span class="iconify"
                                                                                    data-icon="ep:delete-filled"></span></a>
                                                                            <form
                                                                                action="<?php echo e(route('admin.language.delete', [$language->id])); ?>"
                                                                                method="post"
                                                                                id="delete_row_form_<?php echo e($language->id); ?>">
                                                                                <?php echo e(method_field('DELETE')); ?>

                                                                                <input type="hidden" name="_token"
                                                                                    value="<?php echo e(csrf_token()); ?>">
                                                                            </form>
                                                                            <a href="<?php echo e(route('admin.language.translate', [$language->id])); ?>"
                                                                                class="btn-action" title="Edit">
                                                                                <span class="status-btn status-btn-blue">
                                                                                    <?php echo e(__('Translator')); ?></span>
                                                                            </a>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!-- datatable End -->
                                            </div>
                                            <!-- Language List Table Area End -->
                                        </div>
                                        <!-- Account Settings Content Box End -->
                                    </div>
                                    <!-- Language Settings Page End -->
                                </div>
                            </div>
                            <!-- Account settings Area Right Side End-->
                        </div>
                    </div>
                    <!-- Settings Page Layout Wrap Area row End -->
                </div>
                <!-- Page Content Wrapper End -->
            </div>
        </div>
        <!-- End Page-content -->
    </div>
    
    <div class="modal fade" id="addLanguageModal" tabindex="-1" aria-labelledby="addLanguageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form action="<?php echo e(route('admin.language.store')); ?>" method="POST" enctype="multipart/form-data"
                    class="ajax" data-handler="getShowMessage">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h4 class="modal-title" id="addLanguageModalLabel"><?php echo e(__('Add Language')); ?></h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span
                                class="iconify" data-icon="akar-icons:cross"></span></button>
                    </div>
                    <div class="modal-body">
                        <!-- Modal Inner Form Box Start -->
                        <div class="modal-inner-form-box">
                            <div class="row">
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Name')); ?></label>
                                    <input type="text" name="name" class="form-control"
                                        placeholder="<?php echo e(__('Name')); ?>">
                                    <span class="text-danger"></span>
                                </div>
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Language')); ?></label>
                                    <select name="code" id="code" class="form-control">
                                        <?php $__currentLoopData = languageIsoCode(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('RTL')); ?></label>
                                    <select class="form-select flex-shrink-0" name="rtl">
                                        <option value="0"><?php echo e(__('No')); ?></option>
                                        <option value="1"><?php echo e(__('Yes')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Default')); ?></label>
                                    <select class="form-select flex-shrink-0" name="default">
                                        <option value="0"><?php echo e(__('No')); ?></option>
                                        <option value="1"><?php echo e(__('Yes')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Status')); ?></label>
                                    <select class="form-select flex-shrink-0" name="status">
                                        <option value="1"><?php echo e(__('Active')); ?></option>
                                        <option value="0"><?php echo e(__('Deactive')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <label class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Icon')); ?></label>
                                <!-- Upload Profile Photo Box Start -->
                                <div class="upload-profile-photo-box">
                                    <div class="profile-user position-relative d-inline-block">
                                        <img src="<?php echo e(asset('assets/images/no-image.jpg')); ?>"
                                            class="rounded-circle avatar-md language-icon-image" alt="">
                                        <div class="avatar-xs p-0 rounded-circle language-icon-edit">
                                            <input id="language-icon-img-file-input" type="file" name="icon"
                                                class="language-icon-img-file-input">
                                            <label for="language-icon-img-file-input"
                                                class="language-icon-edit avatar-xs">
                                                <span class="avatar-title rounded-circle" title="Upload Image">
                                                    <i class="ri-camera-fill"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="language-icon-recommend-size font-13 mt-2"><?php echo e(__('Recommend Size')); ?>: 30
                                        x 30 (1MB)</div>
                                </div>
                                <!-- Upload Profile Photo Box End -->
                            </div>
                        </div>
                        <!-- Modal Inner Form Box End -->
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="Back"><?php echo e(__('Back')); ?></button>
                        <button type="submit" class="theme-btn me-3" title="Submit"><?php echo e(__('Submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="editLanguageModal" tabindex="-1" aria-labelledby="editLanguageModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form action="" method="POST" enctype="multipart/form-data" class="ajax"
                    data-handler="getShowMessage">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h4 class="modal-title" id="editLanguageModalLabel"><?php echo e(__('Edit Language')); ?></h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span
                                class="iconify" data-icon="akar-icons:cross"></span></button>
                    </div>
                    <div class="modal-body">
                        <!-- Modal Inner Form Box Start -->
                        <div class="modal-inner-form-box">
                            <div class="row">
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Name')); ?></label>
                                    <input type="text" name="name" class="form-control"
                                        placeholder="<?php echo e(__('Name')); ?>">
                                    <span class="text-danger"></span>
                                </div>
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Language')); ?></label>
                                    <input type="text" name="code" class="form-control" disabled>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('RTL')); ?></label>
                                    <select class="form-select flex-shrink-0" name="rtl">
                                        <option value="0"><?php echo e(__('No')); ?></option>
                                        <option value="1"><?php echo e(__('Yes')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Default')); ?></label>
                                    <select class="form-select flex-shrink-0" name="default">
                                        <option value="0"><?php echo e(__('No')); ?></option>
                                        <option value="1"><?php echo e(__('Yes')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-25">
                                    <label
                                        class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Status')); ?></label>
                                    <select class="form-select flex-shrink-0" name="status">
                                        <option value="1"><?php echo e(__('Active')); ?></option>
                                        <option value="0"><?php echo e(__('Deactive')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <label class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Icon')); ?></label>
                                <!-- Upload Profile Photo Box Start -->
                                <div class="upload-profile-photo-box">
                                    <div class="profile-user position-relative d-inline-block">
                                        <img src="<?php echo e(asset('backend/assets/images/no-image.jpg')); ?>"
                                            class="rounded-circle avatar-md language-icon-image-edit" alt=""
                                            id="editImageShow">
                                        <div class="avatar-xs p-0 rounded-circle language-icon-edit">
                                            <input id="language-icon-img-file-input-edit" type="file" name="icon"
                                                class="language-icon-img-file-input-edit">
                                            <label for="language-icon-img-file-input-edit"
                                                class="language-icon-edit avatar-xs">
                                                <span class="avatar-title rounded-circle" title="Upload Image">
                                                    <i class="ri-camera-fill"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="language-icon-recommend-size font-13 mt-2"><?php echo e(__('Recommend Size')); ?>: 30
                                        x 30 (1MB)</div>
                                </div>
                                <!-- Upload Profile Photo Box End -->
                            </div>
                        </div>
                        <!-- Modal Inner Form Box End -->
                    </div>
                    <div class="modal-footer justify-content-start">
                        <button type="button" class="theme-btn-back me-3" data-bs-dismiss="modal"
                            title="Back"><?php echo e(__('Back')); ?></button>
                        <button type="submit" class="theme-btn me-3" title="Submit"><?php echo e(__('Submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div id="addLanguageRoute" data-route="<?php echo e(route('admin.language.store')); ?>"></div>
    <div id="editLanguageRoute" data-route="<?php echo e(route('admin.language.update', '@')); ?>"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <?php echo $__env->make('admin.layouts.datatable-style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('admin.layouts.datatable-script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="<?php echo e(asset('backend/assets/js/pages/alldatatables.init.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/pages/add-language-icon.init.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/custom/language.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/miladali/public_html/forums/resources/views/admin/language/index.blade.php ENDPATH**/ ?>