<div id="comments">
    <div class="row">
        <div class="col-12">
            <h4>نظر خود را ثبت کنید</h4>
            <?php
            /**
             * The template for displaying Comments.
             *
             * The area of the page that contains comments and the comment form.
             *
             * @package WordPress
             * @subpackage Radiance
             * @since Radiance 1.0
             */

            /*
             * If the current post is protected by a password and the visitor has not yet
             * entered the password we will return early without loading the comments.
             */
            if ( post_password_required() )
                return;
            ?>

            <div id="comments" class="comments-area">
                <?php
                $args = array(
                    'class_submit'  => 'btn btn-sm btn-success',
                    'title_reply'   => '',
                    'comment_field' => '<textarea name="comment" class="form-control mb-1" id="comment" rows="3" maxlength="65525"></textarea>',
                    'fields' => array(
                        'author' => '<div class="col-12 col-sm-3 p-0 d-inline-block"><p class="comment-form-author">' . '<label for="author">' . __( 'Name' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                            '<input id="author" class="form-control" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" maxlength="245"' . $aria_req . $html_req . ' /></p></div>',
                        'email'  => '<div class="col-12 col-sm-4 p-0 d-inline-block"><p class="comment-form-email"><label for="email">' . __( 'Email' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                            '<input id="email" class="form-control" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" maxlength="100" aria-describedby="email-notes"' . $aria_req . $html_req  . ' /></p></div>',
                        'url'    => '<div class="col-12 col-sm-4 p-0 d-inline-block"><p class="comment-form-url"><label for="url">' . __( 'Website' ) . '</label> ' .
                            '<input id="url" class="form-control" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" maxlength="200" /></p></div>',
                    )
                );

                comment_form($args);
                ?>

                <hr>
                <h4>
                    نظرات کاربران
                    <sup> (<?php echo get_comments_number() ?> نظر ارسال شده)</sup>
                </h4>
                <hr>
                <?php
                //Get only the approved comments
                $args = array(
                    'status' => 'approve',
                    'post__in' => get_the_ID(),
                );

                // The comment Query
                $comments_query = new WP_Comment_Query;
                $comments = $comments_query->query( $args );

                // Comment Loop
                if ( $comments ) :
                    foreach ( $comments as $comment ) {
                        ?>
                        <div class="comment-body table-bordered rounded mt-2" itemtype="http://schema.org/UserComments">
                            <footer class="comment-meta rounded p-2">
                                <div class="comment-author">
                                    <img alt="" src="<?php echo get_avatar_url($comment->comment_author_email) ?>" class="avatar rounded" height="40">
                                    <b class="fn" itemprop="creator" itemtype="http://schema.org/Person"><?php echo $comment->comment_author ?></b>
                                    <div class="comment-metadata pt-2">
                                        <time datetime="<?php echo $comment->comment_date ?>">
                                            <?php echo $comment->comment_date ?>
                                        </time>
                                    </div>
                                </div>
                            </footer>
                            <div class="comment-content px-2 py-1 mt-2">
                                <?php echo $comment->comment_content; ?>
                            </div>
                            <!--
                            <div class="reply py-1 px-2">
                                <a rel="nofollow"  href="#comment-45" data-commentid="45" data-postid="919" data-belowelement="div-comment-45" data-respondelement="respond" aria-label="پاسخ به <?php echo $comment->comment_author ?>">ارسال پاسخ</a>
                            </div>
                            -->
                        </div>
                    <?php } ?>
                    <!-- .comment-list -->

                    <?php if ( ! comments_open() && get_comments_number() ) : ?>
                    <p class="no-comments"><?php _e( 'بخش نظرات بسته شده است.' , 'radiance' ); ?></p>
                <?php endif; ?>

                <?php
                else:
                    echo 'هیچ نظری ارسال نشده است. شما اولین نظر را ارسال کنید.';
                    ?>

                <?php endif; // have_comments() ?>

            </div><!-- #comments -->

        </div>
    </div>
</div>