<?php
get_header(); ?>

<h1 id="site-title"><?php echo bloginfo('title') ?></h1>
<!-- Header Section -->
<?php get_template_part( 'template-parts/inner-pages/inner-pages', 'header' ); ?>
<!-- Header Section -->

<!-- Page Content Section -->
<section id="inner-page-container">
    <div id="page-top"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="container p-0">
                    <div class="col-12 px-0">
                        <span class="section-title-line"></span>
                        <h1 class="section-title" style="font-size: 24px;"><?php echo bloginfo('title') ?></h1>
                        <h2 class="section-subtitle" style="font-size: 20px;"><?php the_title() ?></h2>
                        <div id="content-box" class="p-3 p-lg-5">
                            <div class="row">

                                <?php get_template_part( 'template-parts/blog/blog', 'side-panel' ); ?>

                                <div class="col-12 <?php echo is_active_sidebar('sidebar-primary')? 'col-lg-9 pr-lg-5':'col-lg-12'; ?>" id="posts-list">
                                    <div class="post-box">
                                        <div class="row">
                                            <div class="col-12">
                                                <a href=""><h3><?php the_title() ?></h3></a>
                                                <div class="post-details">
                                                    <div class="d-inline"><i class="fa fa-calendar"></i> <?php echo get_the_date(); ?></div>
                                                    <div class="d-inline">| <i class="fa fa-user"></i> توسط <strong><a href=""><?php echo get_the_author_meta( 'display_name', $post->post_author ); ?></a></strong></div>
                                                    <div class="d-inline">| <i class="fa fa-eye"></i> <?php echo gt_get_post_view(); ?>بازدید</div>
                                                    <div class="d-inline">| <i class="fa fa-comment"></i> <?php comments_number() ?></div>
                                                </div>
                                                <br>
                                                <img src="<?php echo get_the_post_thumbnail_url() ?>" alt="<?php the_title(); ?>" width="100%">
                                                <br><br>
                                                <?php echo $post->post_content; ?>
                                                <hr>
                                                <div id="keywords">
                                                    <?php
                                                    $post_tags = get_the_tags();
                                                    if (!empty($post_tags))
                                                        foreach ($post_tags as $tag)
                                                            echo '<a href="'. get_tag_link($tag->term_id) . '" class="badge badge-info mx-1">'. $tag->name .'</a>';
                                                    ?>
                                                </div>
                                                <hr>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    // If comments are open or we have at least one comment, load up the comment template.
                                    if ( comments_open() || get_comments_number() ) {
                                        comments_template();
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /Page Content Section -->

<!-- Footer Section -->
<?php get_template_part( 'template-parts/footer/footer', 'widgets' ); ?>
<!-- /Footer Section -->

<?php gt_set_post_view(); ?>
<?php get_footer(); ?>
