<?php
function wr_search_form( $form ) {
    $form = '<li>
                <form role="search" method="get" id="frm-search" class="searchform" action="' . home_url( '/' ) . '" >
                    <input type="text" class="form-control" placeholder="جستجو کنید..." value="' . get_search_query() . '" name="s" id="s">
                    <input type="submit" class="btn btn-warning" id="searchsubmit" value="&#xf002;">
                </form>
            </li>';
    return $form;
}

add_filter( 'get_search_form', 'wr_search_form', 100 );

/**
 * Extend Recent Posts Widget
 *
 * Adds different formatting to the default WordPress Recent Posts Widget
 */

Class My_Recent_Posts_Widget extends WP_Widget_Recent_Posts {

    function widget($args, $instance) {

        extract( $args );

        $title = apply_filters('widget_title', empty($instance['title']) ? __('Recent Posts') : $instance['title'], $instance, $this->id_base);

        if( empty( $instance['number'] ) || ! $number = absint( $instance['number'] ) )
            $number = 10;

        $counter = 1;
        $r = new WP_Query( apply_filters( 'widget_posts_args', array( 'posts_per_page' => $number, 'no_found_rows' => true, 'post_status' => 'publish', 'ignore_sticky_posts' => true ) ) );
        if( $r->have_posts() ) :

            echo $before_widget;
            if( $title ) echo $before_title . $title . $after_title; ?>

            <?php while( $r->have_posts() ) : $r->the_post(); ?>
                <li class="post-item <?php echo $counter > 1? 'mt-2 mt-lg-0':'' ?>">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                        <div class="row">
                            <div class="col-3 col-sm-2 col-lg-3 pl-2"><img src="<?php the_post_thumbnail_url(); ?>" class="rounded" width="100%" alt=""></div>
                            <div class="col-9 pr-0 pt-1">
                                <h3><?php the_title(); ?></h3>
                                <sup><?php the_date(); ?></sup>
                            </div>
                        </div>
                    </a>
                </li>
            <?php endwhile; ?>

            <?php
            echo $after_widget;

            wp_reset_postdata();

        endif;
    }
}
function my_recent_widget_registration() {
    unregister_widget('WP_Widget_Recent_Posts');
    register_widget('My_Recent_Posts_Widget');
}
add_action('widgets_init', 'my_recent_widget_registration');