<section class="menu-section-area">
    <!-- Navigation -->
    <nav class="navbar sticky-header navbar-expand-lg" aria-label="Dark offcanvas navbar" id="mainNav">
        <div class="container">
            <a class="navbar-brand mobile-navbar-brand" href="<?php echo e(route('frontend')); ?>">
                <img class="img-fluid" src="<?php echo e(getSettingImage('app_logo')); ?>" alt="<?php echo e(getOption('app_name')); ?>">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasNavbarDark" aria-controls="offcanvasNavbarDark">
                <span class="iconify" data-icon="heroicons-outline:menu"></span>
            </button>

            <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbarDark"
                aria-labelledby="offcanvasNavbarDarkLabel">
                <div class="offcanvas-header">
                    <h5 class="offcanvas-title" id="offcanvasNavbarDarkLabel">
                        <img class="img-fluid" src="<?php echo e(getSettingImage('app_logo')); ?>"
                            alt="<?php echo e(getOption('app_name')); ?>">
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                </div>
                <div class="offcanvas-body">
                    <div class="col-md-2">
                        <a class="navbar-brand desktop-navbar-brand" href="<?php echo e(route('frontend')); ?>">
                            <img class="img-fluid" src="<?php echo e(getSettingImage('app_logo')); ?>"
                                alt="<?php echo e(getOption('app_name')); ?>">
                        </a>
                    </div>
                    <ul class="navbar-nav mb-2 mb-lg-0 col-md-7 navbar-nav-middle">
                        <li class="nav-item">
                            <a class="nav-link" aria-current="page"
                                href="<?php echo e(route('frontend')); ?>#feature"><span><?php echo e(__('Feature')); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link"
                                href="<?php echo e(route('frontend')); ?>#faqs"><span><?php echo e(__('Faqs')); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link"
                                href="<?php echo e(route('frontend')); ?>#pricing"><span><?php echo e(__('Pricing')); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link"
                                href="<?php echo e(route('frontend')); ?>#how-it-works"><span><?php echo e(__('How Its Works')); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('contact.us')); ?>"><span><?php echo e(__('Contact')); ?></span></a>
                        </li>
                    </ul>
                    <ul class="navbar-nav mb-2 mb-lg-0 col-md-3 navbar-nav-right">
                        <li class="nav-item">
                            <?php if(auth()->guard()->guest()): ?>
                                <a href="<?php echo e(route('login')); ?>" class="nav-link"><span><?php echo e(__('Sign In')); ?></span></a>
                            <?php endif; ?>
                            <?php if(auth()->guard()->check()): ?>
                                <?php if(auth()->user()->role == USER_ROLE_USER): ?>
                                    <a href="<?php echo e(route('user.dashboard')); ?>"
                                        class="nav-link"><span><?php echo e(__('Dashboard')); ?></span></a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('admin.dashboard')); ?>"
                                        class="nav-link"><span><?php echo e(__('Dashboard')); ?></span></a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item">
                            <?php if(auth()->guard()->guest()): ?>
                                <a href="<?php echo e(route('register')); ?>" class="theme-btn-outline"><?php echo e(__('Get Free Trial')); ?></a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <!-- Navigation -->
</section>
<?php /**PATH /Users/masumbd/project/ZaiwriteAI/resources/views/frontend/layouts/menu.blade.php ENDPATH**/ ?>