<!DOCTYPE html>
<html lang="en">

<head>
    <?php echo $__env->make('frontend.layouts.meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <title><?php echo $__env->yieldPushContent('title' ?? ''); ?> <?php echo e(getOption('app_name')); ?></title>

    <?php echo $__env->make('frontend.layouts.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- FAVICONS -->
    <link rel="icon" href="<?php echo e(getSettingImage('app_fav_icon')); ?>.png" type="image/png" sizes="16x16">
    <link rel="shortcut icon" href="<?php echo e(getSettingImage('app_fav_icon')); ?>" type="image/x-icon">
    <link rel="shortcut icon" href="<?php echo e(getSettingImage('app_fav_icon')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/toastr.min.css')); ?>">
    <?php if(getOption('analytics_enable', 0)): ?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(getOption('google_analytics_measurement_id')); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', "<?php echo e(getOption('google_analytics_measurement_id')); ?>");
    </script>
    <?php endif; ?>
</head>

<body class="<?php echo e(selectedLanguage()->rtl == 1 ? 'direction-rtl' : 'direction-ltr'); ?>">
    <?php if(getOption('app_preloader_status') == 1): ?>
        <div id="preloader">
            <div id="preloader-status"><img src="<?php echo e(getSettingImage('app_preloader')); ?>" alt="img"></div>
        </div>
    <?php endif; ?>
    <?php echo $__env->make('frontend.layouts.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <main data-bs-spy="scroll" data-bs-target="#mainNav" data-bs-root-margin="0px 0px -40%" data-bs-smooth-scroll="true"
        tabindex="0">

        <?php echo $__env->yieldContent('content'); ?>

        <?php echo $__env->make('frontend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </main>
    <?php echo $__env->make('frontend.layouts.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /home/khavarii/test.khavarii.com/resources/views/frontend/layouts/app.blade.php ENDPATH**/ ?>