<section id="services">
    <div id="services-anchor"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="container">
                    <h1 class="section-title" id="services-title"><?php echo get_theme_mod('radiance_services_title') ?></h1>
                    <div class="row py-5">
                        <div class="col-12 col-lg-5 text-center">
                            <img src="<?php echo (get_theme_mod('radiance_services_image'))? get_theme_mod('radiance_services_image'):get_template_directory_uri().'/assets/images/services-image.webp' ?>" alt="Image">
                        </div>
                        <div class="col-12 col-lg-7 pt-5 pt-lg-0">
                            <?php
                            // the query
                            $wpb_all_query = new WP_Query(array('post_type'=>'service', 'post_status'=>'publish', 'posts_per_page'=>-1)); ?>

                            <?php if ( $wpb_all_query->have_posts() ) : ?>

                                <!-- the loop -->
                                <?php $counter = 1; ?>
                                <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="service-box p-3 <?php echo ($counter > 1)? 'my-3':'' ?>">
                                            <h2 class="service-title"><?php the_title(); ?></h2>
                                            <h3 class="service-description pt-2"><?php the_excerpt(); ?></h3>
                                            <span class="small"><i class="fa fa-chevron-circle-left"></i> بیشتر بدانید...</span>
                                        </div>
                                    </a>
                                    <?php $counter++; ?>
                                <?php endwhile; ?>
                                <!-- end of the loop -->

                                <?php wp_reset_postdata(); ?>

                            <?php else : ?>
                                <p><?php _e( 'هیچ خدماتی ایجاد نشده است!' ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>