<section id="blog">
    <div id="blog-top"></div>
    <div id="blog-anchor"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="container">
                    <h1 class="section-title" id="blog-title"><?php echo get_theme_mod('radiance_blog_title') ?></h1>
                    <div class="row pt-1">
                        <?php
                        // the query
                        $wpb_all_query = new WP_Query(array('post_type'=>'post', 'post_status'=>'publish', 'posts_per_page'=>3)); ?>

                        <?php if ( $wpb_all_query->have_posts() ) : ?>

                            <!-- the loop -->
                            <?php $counter = 1; ?>
                            <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>
                                <div class="col-12 col-md-12 col-lg-4 pt-4 blog-post">
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="blog-post-top" style="background-image: url('<?php echo get_the_post_thumbnail_url() ?>)">
                                            <div class="inner-shadow"></div>
                                            <sub>ارسال شده در <?php echo get_the_date(); ?></sub>
                                        </div>
                                        <div class="blog-post-bottom pt-3">
                                            <h2 class="post-title px-3"><?php the_title(); ?></h2>
                                            <?php the_excerpt(); ?>
                                        </div>
                                    </a>
                                </div>
                                <?php $counter++; ?>
                            <?php endwhile; ?>
                            <!-- end of the loop -->

                            <?php wp_reset_postdata(); ?>

                        <?php else : ?>
                            <p><?php _e( 'هیچ پستی ارسال نشده است!' ); ?></p>
                        <?php endif; ?>

                        <div class="col-12">
                            <a href="<?php echo get_site_url() . '/blog'; ?>" id="archive-link" class="hvr-icon-back">
                                سایر مطالب <i class="fa fa-chevron-circle-left hvr-icon"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>