<?php get_header(); ?>

<h1 id="site-title"><?php echo bloginfo('title') ?></h1>
<!-- Header Section -->
<?php get_template_part( 'template-parts/inner-pages/inner-pages', 'header' ); ?>
<!-- Header Section -->

<!-- Page Content Section -->
<section id="inner-page-container">
    <div id="page-top"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="container p-0">
                    <div class="col-12 px-0">
                        <span class="section-title-line"></span>
                        <span class="section-title-shadow">بلاگ</span>
                        <h1 class="section-title">بلاگ</h1>
                        <span class="section-subtitle-shadow"><?php echo get_queried_object()->name; ?></span>
                        <h2 class="section-subtitle"><?php echo get_queried_object()->name; ?></h2>
                        <div id="content-box" class="p-3 p-lg-5">
                            <div class="row">

                                <?php get_template_part( 'template-parts/blog/blog', 'side-panel' ); ?>

                                <div class="col-12 col-lg-9 pr-lg-5" id="posts-list">
                                    <h2 class="page-title pb-3">
                                        <?php
                                        /* translators: Search query. */
                                        printf( __( 'نتایج جستجوی عبارت: %s', 'radiance' ), '<span>' . get_search_query() . '</span>' );
                                        ?>
                                    </h2>

                                    <?php if ( have_posts() ) : ?>

                                        <div class="post-box">
                                            <div class="row">
                                                <div class="col-12 col-md-5">
                                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo get_the_post_thumbnail_url() ?>" width="100%" alt=""></a>
                                                </div>
                                                <div class="col-12 col-md-7 pt-3 pt-md-0">
                                                    <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?></h3></a>
                                                    <div class="post-details">
                                                        <div class="d-inline"><i class="fa fa-calendar"></i> <?php echo get_the_date(); ?></div>
                                                        <div class="d-inline">| <i class="fa fa-user"></i> توسط <strong><a href=""><?php echo get_the_author_meta( 'display_name', $post->post_author ); ?></a></strong></div>
                                                        <div class="d-inline">| <i class="fa fa-eye"></i> <?php echo gt_get_post_view(); ?>بازدید</div>
                                                        <div class="d-inline">| <i class="fa fa-comment"></i> <?php comments_number() ?></div>
                                                    </div>
                                                    <?php the_excerpt() ?>
                                                    <a href="<?php the_permalink(); ?>" class="more-link hvr-icon-back">
                                                        ادامه مطلب <i class="fa fa-chevron-circle-left hvr-icon"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                    <?php else : ?>

                                        <h4 class="page-title"><?php _e( 'متاسفانه هیچ پستی یافت نشد!', 'radiance' ); ?></h4>

                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /Page Content Section -->

<!-- Footer Section -->
<section id="footer" class="py-5">
    <div id="footer-bg"></div>
    <div id="footer-anchor"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="container">
                    <div class="row pt-5">
                        <?php get_template_part( 'template-parts/footer/footer', 'widgets' ); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /Footer Section -->

<?php gt_set_post_view(); ?>
<?php get_footer(); ?>
