<?php $__env->startSection('content'); ?>
<!-- Right Content Start -->
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- Page Content Wrapper Start -->
            <div class="page-content-wrapper bg-light p-30 radius-10">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <div class="page-title-left">
                                <h2 class="mb-sm-0"><?php echo e(__("My Subscriptions")); ?></h2>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <!-- Subscription Page Plan Box row -->
                <div class="row">
                    <div class="col-md-12 col-xl-8 col-xxl-6">
                        <?php if(!is_null($userPlan)): ?>
                        <div class="subscription-plan-box bg-white theme-border radius-4 p-20 mb-3">
                            <div class="current-plan d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p>Current Plan</p>
                                    <h4><?php echo e($userPlan->name); ?></h4>
                                </div>
                                <div class="flex-shrink-0 ms-3">
                                    <button type="button" class="theme-btn" id="chooseAPlan"
                                        title="Upgrade Plan">Upgrade Plan</button>
                                </div>
                            </div>
                            <div class="current-plan plan-usage d-flex align-items-center pt-20 mt-20">
                                <div class="flex-grow-1">
                                    <p>Usage</p>
                                    <div class="plan-usage-list">
                                        <div class="d-flex">
                                            <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                            <h4 class="flex-grow-1"><?php echo e(getCharUsed()); ?> / <?php echo e($userPlan->generate_characters); ?> <?php echo e(("characters")); ?></h4>
                                        </div>
                                        

                                        <div class="d-flex">
                                            <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                            <h4 class="flex-grow-1"><?php echo e(count($userPlan->access_use_cases)); ?> <?php echo e(("use cases")); ?></h4>
                                        </div>

                                        <div class="d-flex">
                                            <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                            <h4 class="flex-grow-1"><?php echo e($userPlan->write_languages); ?> <?php echo e(("languages")); ?></h4>
                                        </div>
                                        

                                        <div class="d-flex">
                                            <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                            <h4 class="flex-grow-1"><?php echo e($userPlan->access_tones); ?> <?php echo e(("tones")); ?></h4>
                                        </div>
                                        
                                        

                                        <div class="d-flex">
                                            <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                            <h4 class="flex-grow-1"><?php echo e($userPlan->access_community); ?></h4>
                                        </div>
                                        
                                        

                                        <div class="d-flex">
                                            <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                            <h4 class="flex-grow-1"><?php echo e($userPlan->support); ?></h4>
                                        </div>
                                        

                                        <div class="d-flex">
                                            <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                            <h4 class="flex-grow-1"><?php echo e(__('Plan started at ')); ?> <?php echo e($userPlan->start_date); ?></h4>
                                        </div>
                                        <div class="d-flex">
                                            <span class="plan-usage-list-dot flex-shrink-0 radius-50 me-2"></span>
                                            <h4 class="flex-grow-1"><?php echo e(__('Plan end in ')); ?> <?php echo e($userPlan->end_date); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Subscription Page Plan Box row -->
                        <?php else: ?>
                        <div class="row">
                            <div class="col-md-12 col-xl-8 col-xxl-6">
                                <h4 class="mb-20"><?php echo e(("Currencly you doesn't have any plan")); ?></h4>
                            </div>

                        </div>
                        <?php endif; ?>
                        <div class="subscription-plan-box bg-white theme-border radius-4 p-20 mb-3">
                            <div class="current-plan d-flex align-items-center pb-20">
                                <div class="flex-grow-1">
                                    <h4>Billing Information & Invoices</h4>
                                </div>
                                <div class="flex-shrink-0 ms-3 d-none">
                                    <a href="#" class="theme-btn" title="Upgrade Plan">View</a>
                                </div>
                            </div>
                            <div class="row">
                                <div class="table-responsive">
                                    <table id="allDataTable" class="table theme-border dt-responsive">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__("SL")); ?></th>
                                                <th><?php echo e(__("Package")); ?></th>
                                                <th><?php echo e(__("Amount")); ?></th>
                                                <th><?php echo e(__("Start Date")); ?></th>
                                                <th><?php echo e(__("End Date")); ?></th>
                                                <th><?php echo e(__("Download")); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($invoice->packageName); ?></td>
                                                <td><?php echo e(currencyPrice($invoice->total)); ?></td>
                                                <td><?php echo e(timeFormat($invoice->start_date)); ?></td>
                                                <td><?php echo e(timeFormat($invoice->end_date)); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route("user.subscription.invoice.print", $invoice->id)); ?>" target="_blank" class="p-1 tbl-action-btn"
                                                        title="download"><span class="iconify"
                                                            data-icon="fa6-solid:download"></span></a>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="6" class="text-center"><?php echo e(__("No Invoice Found")); ?></td>
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>

                        <?php if(!is_null($userPlan)): ?>
                        <div class="cancel-subscription mt-25 pt-2">
                            <div>
                                <form action="<?php echo e(route('user.subscription.cancel')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="theme-btn-red"
                                        title="Cancel your subscription"><?php echo e(__("Cancel
                                        your subscription")); ?></button>
                                </form>
                            </div>
                            <p class="mt-3"><?php echo e(__("Please be aware that cancelling your subscription will cause you to
                                lose all
                                your saved content and earned words on your subscription.")); ?></p>
                        </div>
                        <?php endif; ?>

                    </div>

                    <?php if(!is_null($userPlan)): ?>
                    <div class="col-md-12 col-xl-8 col-xxl-6">
                        <div class="subscription-plan-box bg-white theme-border radius-4 p-20 mb-3">
                            <div class="current-plan d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <h4 class="mb-15"><?php echo e(__("Plan Rules")); ?></h4>
                                    <?php if($userPlan->status == INITIATE): ?>
                                    <div class="alert alert-info" role="alert"><?php echo e(__("Update plan rules before proceed. After update this you can not change it.
                                        After the change it you have to buy new plan if you want to change.")); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="pt-20 mt-20">
                                <form class="ajax" action="<?php echo e(route('user.user_packages.update', $userPlan->id)); ?>"
                                    method="post" enctype="multipart/form-data" data-handler="userPackageUpdated">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-md-12 mb-25">
                                            <label class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Access
                                                Language')); ?><span class="ms-2 text-muted">(<?php echo e(__("Your Limit")." : ".$userPlan->write_languages); ?>)</span></label>
                                            <div class="my-custom-select-box">
                                                <select name="write_languageses[]" <?php echo e($userPlan->status == ACTIVE ?
                                                    'disabled' : ''); ?> class="my-custom-select form-select selectpicker
                                                    w-100 write_languageses" multiple>
                                                    <?php $__currentLoopData = getOpenAiLanguage(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($language); ?>" <?php echo e(in_array($language, $userPlan->
                                                        write_languageses ?? []) ? 'selected' : ''); ?>><?php echo e($language); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12 mb-25">
                                            <label class="label-text-title color-heading font-medium mb-2"><?php echo e(__('Access
                                                Tones')); ?><span class="ms-2 text-muted">(<?php echo e(__("Your Limit")." : ".$userPlan->access_tones); ?>)</span></label>
                                            <div class="my-custom-select-box">
                                                <select name="use_toneses[]" <?php echo e($userPlan->status == ACTIVE ? 'disabled'
                                                    : ''); ?> class="my-custom-select form-select selectpicker w-100
                                                    use_toneses" multiple>
                                                    <?php $__currentLoopData = getTones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($tone); ?>" <?php echo e(in_array($tone, $userPlan->
                                                        access_toneses ?? []) ? 'selected' : ''); ?>><?php echo e($tone); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <?php if($userPlan->status == INITIATE): ?>
                                        <div class="col-md-12 text-end">
                                            <button type="submit" class="theme-btn" title="<?php echo e(__('Update')); ?>"><?php echo e(__('Update')); ?></button>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                </div>

                <!-- Page Content Wrapper End -->

            </div>

        </div>
        <!-- End Page-content -->

    </div>
</div>
<!-- Right Content End -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('user/assets/js/custom/package.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/masumbd/project/ZaiwriteAI/resources/views/user/subscriptions/index.blade.php ENDPATH**/ ?>