<header id="page-topbar">
    <div class="navbar-header">
        <div class="d-flex align-items-center">
            <div class="navbar-brand-box">
                <a href="<?php echo e(auth()->user()->role == USER_ROLE_ADMIN ? route('admin.dashboard') : route('user.dashboard')); ?>"
                    class="logo logo-light">
                    <img class="light-logo" src="<?php echo e(getSettingImage('app_logo_black')); ?>"
                        alt="<?php echo e(getOption('app_name')); ?>">
                    <img class="dark-logo" src="<?php echo e(getSettingImage('app_logo')); ?>" alt="<?php echo e(getOption('app_name')); ?>">
                </a>
            </div>
            <button type="button" class="btn-sm px-3 font-24 header-item" id="vertical-menu-btn">
                <i class="ri-indent-decrease"></i>
            </button>
            <!-- App Search-->
            

            <?php echo $__env->make('user.layouts.header-plan-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <div class="d-flex">
            <div class="dropdown d-inline-block d-lg-none ms-2 mobile-search-dropdown d-none">
                <button type="button" class="header-item noti-icon" id="page-header-search-dropdown"
                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="ri-search-line"></i>
                </button>

                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0"
                    aria-labelledby="page-header-search-dropdown">
                    <form class="p-3">
                        <div class="m-0">
                            <div class="input-group radius-4">
                                <input type="text" class="form-control" placeholder="Search ...">
                                <div class="mobile-search-btn">
                                    <button class="bg-primary-color text-white h-100 px-3" type="submit"><i
                                            class="ri-search-line"></i></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="nav-item mode-change">
                <a class="header-item zai-theme-customizer-container-body-item-svg theme-light active"
                    data-theme="light" title="Go Light Mode">
                    <span class="iconify" data-icon="fluent:brightness-low-28-regular"></span>
                </a>
                <a class="header-item zai-theme-customizer-container-body-item-svg theme-dark" data-theme="dark"
                    title="Go Dark Mode">
                    <span class="iconify" data-icon="fluent:brightness-low-28-filled"></span>
                </a>
            </div>

            <div class="dropdown d-inline-block">
                <button type="button" class="header-item noti-icon" id="page-header-languages-dropdown"
                    data-bs-toggle="dropdown" aria-expanded="false">
                    <img src="<?php echo e(asset(selectedLanguage()->icon)); ?>" alt="<?php echo e(selectedLanguage()->name ?? 'English'); ?>"
                        title="<?php echo e(selectedLanguage()->name ?? 'English'); ?>" class="rounded-circle avatar-xs fit-image">
                </button>

                <div class="dropdown-menu <?php echo e(selectedLanguage()->rtl == 1 ? 'dropdown-menu-start' : 'dropdown-menu-end'); ?>"
                    aria-labelledby="page-header-languages-dropdown">
                    <div>
                        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('local', $language->code)); ?>" class="dropdown-item" title="EN">
                                <div class="d-flex">
                                    <img src="<?php echo e($language->icon); ?>" class="me-3 rounded-circle avatar-xs"
                                        alt="user-pic">
                                    <div class="flex-1"><?php echo e($language->name); ?></div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <div class="dropdown d-inline-block user-dropdown">
                <button type="button" class="header-item noti-icon" id="page-header-user-dropdown" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <img class="rounded-circle avatar-xs fit-image header-profile-user"
                        src="<?php echo e(auth()->user()->image); ?>">
                    <span class="user-name d-none d-xl-inline-block font-medium"><?php echo e(auth()->user()->name); ?></span>
                    <i class="mdi mdi-chevron-down d-xl-inline-block font-17"></i>
                </button>
                <div class="dropdown-menu <?php echo e(selectedLanguage()->rtl == 1 ? 'dropdown-menu-start' : 'dropdown-menu-end'); ?>" aria-labelledby="page-header-user-dropdown">
                    <a class="dropdown-item" href="<?php echo e(route('user.profile')); ?>"><span class="iconify font-16 me-1"
                            data-icon="ri:user-3-line"></span> <?php echo e(__('Profile')); ?></a>
                    <a class="dropdown-item" href="<?php echo e(route('user.change-password')); ?>"><span
                            class="iconify font-16 me-1" data-icon="material-symbols:key-outline"></span>
                        <?php echo e(__('Change Password')); ?></a>
                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"><span class="iconify font-16 me-1"
                            data-icon="heroicons-outline:logout"></span> <?php echo e(__('Logout')); ?></a>
                </div>
            </div>
        </div>
    </div>
</header>
<?php /**PATH /home/khavarii/test.khavarii.com/resources/views/user/layouts/header.blade.php ENDPATH**/ ?>