<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="title" content="<?php echo e(getOption('app_name')); ?>">
    <meta name="description" content="<?php echo e(getOption('meta_description')); ?>">
    <meta name="keywords" content="<?php echo e(getOption('meta_keyword')); ?>">
    <meta name="author" content="<?php echo e(getOption('meta_author')); ?>">

    <meta property="og:type" content="Property">
    <meta property="og:title" content="<?php echo e(getOption('app_name')); ?>">
    <meta property="og:description" content="<?php echo e(getOption('meta_description')); ?>">
    <meta property="og:image" content="<?php echo e(getSettingImage('app_logo')); ?>">

    <meta name="twitter:card" content="<?php echo e(getOption('app_name')); ?>">
    <meta name="twitter:title" content="<?php echo e(getOption('app_name')); ?>">
    <meta name="twitter:description" content="<?php echo e(getOption('meta_description')); ?>">
    <meta name="twitter:image" content="<?php echo e(getSettingImage('app_logo')); ?>">

    <meta name="msapplication-TileImage" content="<?php echo e(getSettingImage('app_logo')); ?>">

    <meta name="msapplication-TileColor" content="#F8F8F8">
    <meta name="theme-color" content="#3686FC">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <title><?php echo e(getOption('app_name') . ' - ' . @$pageTitle); ?></title>

    <?php if(getOption('analytics_enable', 0)): ?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(getOption('google_analytics_measurement_id')); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', "<?php echo e(getOption('google_analytics_measurement_id')); ?>");
    </script>
    <?php endif; ?>

    <?php echo $__env->make('user.layouts.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('style'); ?>
</head>

<body class="<?php echo e(selectedLanguage()->rtl == 1 ? 'direction-rtl' : 'direction-ltr'); ?>">

    <?php if(getOption('app_preloader_status') == 1): ?>
        <div id="preloader">
            <div id="preloaderInner"><img src="<?php echo e(getSettingImage('app_preloader')); ?>" alt="img"></div>
        </div>
    <?php endif; ?>

    <div id="layout-wrapper">
        <?php echo $__env->make('user.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('user.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <?php echo $__env->make('user.layouts.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('user.layouts.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- App Custom js -->
    <script src="<?php echo e(asset('user/assets/js/custom.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('script'); ?>
</body>

</html>
<?php /**PATH /home/ehsanpor/hosh.ehsan-pornemat.ir/resources/views/user/layouts/app.blade.php ENDPATH**/ ?>