<?php

if (!function_exists('str_contains')) die('Please upgrade your PHP version to 8 or above');

// بررسی اینکه آیا درخواست از سمت مرورگر هست یا نه
$isTextHTML = str_contains(($_SERVER['HTTP_ACCEPT'] ?? ''), 'text/html');

// آدرس پایه سرور مقصد
const BASE_URL = "https://marz.bestirspeed.top:8000"; // Replace IP address and port

// گرفتن مسیر کامل همراه با query string
$path = $_SERVER['REQUEST_URI'] ?? '';
$URL = BASE_URL . $path;
$URL .= $isTextHTML ? '/info' : '';

// ارسال درخواست به سرور مقصد
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $URL);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 17);
curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT'] ?? 'Mozilla/5.0');
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);

if (curl_error($ch)) {
    die('Error !' . __LINE__ . '<br>Please check <a href="https://github.com/AC-Lover/AC-Subcription/wiki/Error-!27">this</a>');
}

curl_close($ch);

// جدا کردن هدرها از بدنه‌ی پاسخ
$header_text = substr($response, 0, strpos($response, "\r\n\r\n"));
$response = trim(str_replace($header_text, '', $response));

// اگر درخواست از مرورگر بود، ارسال داده به view-service با فرم مخفی
if ($isTextHTML) {
    ?>
    <form id="myForm" action="../view-service/" method="post">
        <input type="hidden" name="userData" value="<?= htmlentities(base64_encode($response)) ?>">
    </form>
    <script type="text/javascript">
        document.getElementById('myForm').submit();
    </script>
    <?php
    return;
}

// اگر درخواست از اپ یا کلاینت بود، بررسی هدرهای مهم و ارسال آن‌ها
$isOK = false;
foreach (explode("\r\n", $header_text) as $i => $line) {
    if ($i === 0) continue;
    if (str_contains($line, ': ')) {
        list($key, $value) = explode(': ', $line, 2);
        if (in_array(strtolower($key), ['content-disposition', 'content-type', 'subscription-userinfo', 'profile-update-interval'])) {
            header("$key: $value");
            $isOK = true;
        }
    }
}

// اگر نه مرورگر بود و نه هدرهای لازم دریافت شد، ارور بده
if (!$isTextHTML && !$isOK) die('Error !' . __LINE__);

// نمایش محتوای دریافت‌شده
echo $response;
