#!/bin/bash
VPS_NAME=$1
NEW_VPS_NAME=$2
SPEED=$3
TO_SSH_PORT=$4
TO_IP=$5
LOGFILE=$6
ACTUAL_TRANSFER_LOG=$7
DISABLE_GZIP=$8
PGZIP=$9
TO_PGZIP=${10}

while [ $# -gt 0 ]
do
	case $1 in
		--vpsn) #1
		VPS_NAME=$2;
		shift;shift;
		;;
		
		--nvpsn) #2
		NEW_VPS_NAME=$2;
		shift;shift;
		;;
		
		--speed) #3
		SPEED=$2;
		shift;shift;
		;;
		
		--tosshp) #4
		TO_SSH_PORT=$2;
		shift;shift;
		;;
		
		--toip) #5
		TO_IP=$2;
		shift;shift;
		;;
		
		--logf) #6
		LOGFILE=$2;
		shift;shift;
		;;
		
		--atlogf) #7
		ACTUAL_TRANSFER_LOG=$2;
		shift;shift;
		;;
		
		--disgzip) #8
		DISABLE_GZIP=$2;
		shift;shift;
		;;
		
		--pgzip) #9
		PGZIP=$2;
		shift;shift;
		;;
		
		--topgzip) #10
		TO_PGZIP=$2;
		shift;shift;
		;;
		
		--tovirt) #10
		TO_VIRT=$2;
		shift;shift;
		;;
		
		*) # Required to move to next parameter passed
		shift;
		;;
	esac
done;

RET=1;
touch $LOGFILE

if [ "$DISABLE_GZIP" != "" ]; then
	ln -s $LOGFILE $ACTUAL_TRANSFER_LOG
fi
echo "TO VIRT: " $TO_VIRT;
if [ "$TO_VIRT" != "" -a "$TO_VIRT" != "openvz" ]
then
	case $TO_VIRT in
		"vzo")
			echo "In cross virt tansfer: ovz";
			bash $(dirname $0)/ovztransfer.sh --tossho "-o Port=$TO_SSH_PORT -i /var/virtualizor/ssh-keys/id_rsa" --speed "$SPEED" --logf "$LOGFILE" --atlogf "$ACTUAL_TRANSFER_LOG" --disgzip "$DISABLE_GZIP" --pgzip "$PGZIP" --topgzip "$TO_PGZIP" >> $LOGFILE --endpar $TO_IP $VPS_NAME:$NEW_VPS_NAME 2>&1
			RET=$?;
			;;
		*)
			echo "Unknown TO VIRT option: "$TO_VIRT;
			;;
	esac
else

	# Copy the conf file so that it can be sent to new server
	cp /etc/vz/conf/$VPS_NAME.conf /vz/private/$VPS_NAME/$NEW_VPS_NAME.conf;

	# Change directory to source directory
	cd /vz/private/$VPS_NAME;

	# Lets start the TAR -> Throttle -> UNTAR
	#echo "tar cf - ./ 2>$LOGFILE | throttle -v -w 2 -M $SPEED 2>$ACTUAL_TRANSFER_LOG | gzip -1 | throttle -v -w 2 -M $SPEED 2>$LOGFILE | ssh -i /var/virtualizor/ssh-keys/id_rsa -q -p $TO_SSH_PORT root@$TO_IP 'mkdir -p /vz/private/$NEW_VPS_NAME && gzip -d | tar xf - -C /vz/private/$NEW_VPS_NAME && mv /vz/private/$NEW_VPS_NAME/$NEW_VPS_NAME.conf /etc/vz/conf/$NEW_VPS_NAME.conf' 2>$LOGFILE"

	if [ "$DISABLE_GZIP" != "" ]; then

		tar cf - ./ 2>>$LOGFILE | throttle -v -w 2 -M $SPEED 2>>$LOGFILE | ssh -oStrictHostKeyChecking=no -i /var/virtualizor/ssh-keys/id_rsa -q -p $TO_SSH_PORT root@$TO_IP "mkdir -p /vz/private/$NEW_VPS_NAME && tar xf - -C /vz/private/$NEW_VPS_NAME && mv /vz/private/$NEW_VPS_NAME/$NEW_VPS_NAME.conf /etc/vz/conf/$NEW_VPS_NAME.conf" 2>>$LOGFILE

	else

		tar cf - ./ 2>>$LOGFILE | throttle -v -w 2 -M $SPEED 2>>$ACTUAL_TRANSFER_LOG | $PGZIP -1 | throttle -v -w 2 -M $SPEED 2>>$LOGFILE | ssh -oStrictHostKeyChecking=no -i /var/virtualizor/ssh-keys/id_rsa -q -p $TO_SSH_PORT root@$TO_IP "mkdir -p /vz/private/$NEW_VPS_NAME && $TO_PGZIP -d | tar xf - -C /vz/private/$NEW_VPS_NAME && mv /vz/private/$NEW_VPS_NAME/$NEW_VPS_NAME.conf /etc/vz/conf/$NEW_VPS_NAME.conf" 2>>$LOGFILE
		
	fi
	
	PIPESTATUS2=${PIPESTATUS[@]};
	echo "$PIPESTATUS2" >>$LOGFILE
	
	RET=0;
	
	for i in $PIPESTATUS2; do
		RET=$(expr $RET + $i);
	done;
	
fi

echo $RET >>$LOGFILE;
echo "mig_completed" >>$LOGFILE
