#!/bin/bash
SOURCE_DISK_PATH=$1
DEST_DISK_PATH=$2
SPEED=$3
LOGFILE=$4
ACTUAL_TRANSFER_LOG=$5
DISABLE_GZIP=$6
SPARSE=$7
PGZIP=$8
THROTTLE_BLOCK_SIZE=$9
QCOW2_TO_RAW=${10}
RAW_TO_QCOW2=${11}

SPARSE_IT="";
if [[ "$SPARSE" -eq "1" ]]
then
	SPARSE_IT=" conv=sparse "
fi

ln -s $LOGFILE $ACTUAL_TRANSFER_LOG

if [[ "$QCOW2_TO_RAW" -eq "1" ]] 
then
	qemu-img convert -f qcow2 -O raw $SOURCE_DISK_PATH  $DEST_DISK_PATH -p 2>>$LOGFILE

elif [[ "$RAW_TO_QCOW2" -eq "1" ]]
then
	qemu-img convert -f raw -O qcow2 $SOURCE_DISK_PATH  $DEST_DISK_PATH -p 2>>$LOGFILE
else
	if [[ "$DISABLE_GZIP" -eq "1" ]]
	then
		dd if=$SOURCE_DISK_PATH bs=24M | throttle -v -w 2 -M $SPEED  | dd  $SPARSE_IT of=$DEST_DISK_PATH bs=24M 2>>$LOGFILE
	else
		dd if=$SOURCE_DISK_PATH bs=24M | throttle -v -s $THROTTLE_BLOCK_SIZE -w 2 -M $SPEED 2>>$ACTUAL_TRANSFER_LOG | $PGZIP -1 | throttle -v -s $THROTTLE_BLOCK_SIZE -w 2 -M $SPEED 2>>$LOGFILE | $PGZIP -d | dd $SPARSE_IT of=$DEST_DISK_PATH bs=24M 2>>$LOGFILE	
	fi
fi

PIPESTATUS2=${PIPESTATUS[@]};
echo "$PIPESTATUS2" >>$LOGFILE

RET=0;

for i in $PIPESTATUS2; do
	RET=$(expr $RET + $i);
done;
echo $RET >>$LOGFILE;
echo "mig_completed" >>$LOGFILE

