#!/bin/bash
NEW_VPSNAME=$1
TO_IP=$2
TO_SSH_PORT=$3
SPEED=$4
VPS_NAME=$5
SETMAXDOWNTIME=$6
shared_st_mig=$7
XML_FILE=$8
LOGFILE=$9


echo Live Migration
echo 1 NEW_VPSNAME $NEW_VPSNAME
echo 2 TO_IP $TO_IP
echo 3 TO_SSH_PORT $TO_SSH_PORT
echo 4 SPEED $SPEED
echo 5 VPS_NAME $VPS_NAME
echo 6 SETMAXDOWNTIME $SETMAXDOWNTIME
echo 7 SHARED_ST_MIG $shared_st_mig
echo 8 XML_FILE $XML_FILE
echo 9 LOGFILE $LOGFILE

# Set live migration speed
virsh migrate-setspeed $VPS_NAME --bandwidth $SPEED

# Set live migration setmaxdowntime
virsh migrate-setmaxdowntime $VPS_NAME --downtime $SETMAXDOWNTIME

if [ "$shared_st_mig" -eq "1" ]; then

    echo "shared storage"
    # Start live migration without storage
    virsh migrate --live --verbose  --dname $NEW_VPSNAME --xml $XML_FILE --desturi qemu+ssh://root@$TO_IP:$TO_SSH_PORT/system?keyfile=/var/virtualizor/ssh-keys/id_rsa $VPS_NAME 2>&1 >> $LOGFILE


else

    # Start live migration with storage
    virsh migrate --live --verbose --copy-storage-all --dname $NEW_VPSNAME --xml $XML_FILE --desturi qemu+ssh://root@$TO_IP:$TO_SSH_PORT/system?keyfile=/var/virtualizor/ssh-keys/id_rsa $VPS_NAME 2>&1 >> $LOGFILE

fi


# Get return code
RET=$?

echo $RET >>$LOGFILE
echo "mig_completed" >>$LOGFILE
exit $RET
