<?php

//////////////////////////////////////////////////////////////
//===========================================================
// globals.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

$globals['hf_loaded'] = 0;
$globals['charset'] = 'UTF-8';
$globals['showntimetaken'] = 1;
$globals['version'] = '3.2.0';
$globals['patch'] = '7';
$globals['license'] = '00000-00000-00000-00000-00000';//Dummy License
$globals['port'] = 4082;
$globals['vpsid'] = 0;
$globals['index'] = 'index.php?';
$globals['server'] = 0;
$globals['queries'] = 0;
$globals['overcommit'] = (empty($globals['overcommit']) ? 0 : $globals['overcommit']);
$globals['docs'] = 'https://www.virtualizor.com/docs/admin/';
$globals['apiurl'] = 'https://api.virtualizor.com/';
$globals['openvzos'] = '/vz/template/cache';
$globals['xenos'] = '/var/virtualizor/xen';
$globals['kvmos'] = '/var/virtualizor/kvm';
$globals['xcpos'] = '/var/virtualizor/xcp';
$globals['lxcos'] = '/var/virtualizor/lxc';
$globals['proxoos'] = '/var/virtualizor/proxo';
$globals['proxkos'] = '/var/virtualizor/proxk';
$globals['proxlos'] = '/var/virtualizor/proxl';
$globals['vzoos'] = '/vz/template/cache';
$globals['vzkos'] = '/var/virtualizor/vzk';
$globals['vmwareos'] = '/var/virtualizor/vmware';
$globals['isos'] = '/var/virtualizor/iso';
$globals['euisos'] = '/var/virtualizor/euiso';
$globals['virtualboxos'] = '/var/virtualizor/virtualbox';
$globals['var'] = '/var/virtualizor';
$globals['lxc_path'] = '/var/lib/lxc/';
$globals['virts']['openvz'] = 'openvz';
$globals['virts']['xen'] = 'xen';
$globals['virts']['xenhvm'] = 'xenhvm';
$globals['virts']['kvm'] = 'kvm';
$globals['virts']['xcp'] = 'xcp';
$globals['virts']['xcphvm'] = 'xcphvm';
$globals['virts']['lxc'] = 'lxc';
$globals['virts']['proxo'] = 'proxo';
$globals['virts']['proxk'] = 'proxk';
$globals['virts']['proxl'] = 'proxl';
$globals['virts']['vzk'] = 'vzk';
$globals['virts']['vzo'] = 'vzo';
$globals['vmware_var'] = '/vmfs/volumes/datastore1/virtualizor';

$globals['mainfiles'] = $globals['path'].'/main';
$globals['adminfiles'] = $globals['path'].'/admin';
$globals['themes'] = $globals['path'].'/enduser/themes';
$globals['runtime_theme'] = $globals['theme_folder'];
$globals['kernelfiles'] = $globals['path'].'/kernel';
$globals['scriptfiles'] = $globals['path'].'/scripts';
$globals['vexec_ignore'] = 'virsh list|cpuinfo|ifconfig|chattr|virt-top|\/proc\/stat|lsmod|ifconfig|uname|df -P';
//seperated by | for eg wget -O|lvs|\/bin\/ls
$globals['cmd_no_out'] = 'wget -O|chattr -R -a -i|vncterm';

$globals['no_disable_templates'] = array('twofactauth_otp', 
				'twofactauth_passcode', 
				'twofactauth_otp', 
				'reset_pass', 
				'registered_mail', 
				'new_account_creation', 
				'reg_mail_admin', 
				'reg_res_mail');

//Webuzo Related
$globals['webuzo_scripts'] = '/var/virtualizor/webuzo_scripts';

$globals['login_ban_time'] = empty($globals['login_ban_time']) ? 15 : $globals['login_ban_time'];
$globals['login_attempts'] = empty($globals['login_attempts']) ? 5 : $globals['login_attempts'];

$globals['_disabled_scripts'] = empty($globals['disabled_scripts']) ? array() : explode(',', @$globals['disabled_scripts']);

$globals['max_ips'] = empty($globals['max_ips']) ? 250 : (int) $globals['max_ips'];
$globals['os'] = (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN' ? 'windows' : (strtoupper(substr(PHP_OS, 0, 3)) == 'DAR' ? 'darwin' : 'linux'));

$globals['allowed_sync_tables'] = array('vps' => array(), 
										'ips' => array(), 
										'ippool' => array(), 
										'os' => array(),
										'iso' => array(),
										'enduser_iso' => array(),
										'console_sessions' => array(), 
										'ippool_servers' => array(),
										'backup_servers' => array(),
										'os_distros' => array(),
										'haproxy' => array(),
										'backup_plans' => array(),
										'plans' => array(),
										'email_templates' => array(),
										'vps_meta' => array(),
										'passthrough' => array(),
										'firewall_plans' => array()
										);

// Log Folder
define('V_LOG_DIR', '/var/virtualizor/log');

// For short name of VPS
if(!empty($globals['vm_short'])){
	define('VM_SHORT', $globals['vm_short']);
}else{
	define('VM_SHORT', 'VPS');
}

// For long name of VPS
if(!empty($globals['vm_long'])){
	define('VM_LONG', $globals['vm_long']);
}else{
	define('VM_LONG', 'Virtual Server');
}

// Set the environment variables for the binaries
if(strtoupper(substr(PHP_OS, 0, 3)) != 'WIN'){
	putenv('PATH=/usr/kerberos/sbin:/usr/kerberos/bin:/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin:/root/bin:/usr/local/emps/bin:/usr/local/emps/sbin:/usr/local/virtualizor-bin/bin');
}

// Libguestfs environment variables for proxmox
if(preg_match('/proxk/is', $globals['kernel'])){
	if(strtoupper(substr(PHP_OS, 0, 3)) != 'WIN'){
		putenv('LIBGUESTFS_PATH=/usr/local/virtualizor-bin/lib/guestfs/appliance');
	}
}

if(!empty($globals['vzo_temp_converter_dir'])){
  if(!is_dir($globals['vzo_temp_converter_dir'])){
    mkdir($globals['vzo_temp_converter_dir'], 0755, 1);
  }
  putenv('TMPDIR='.$globals['vzo_temp_converter_dir']);
}

$release_ver = '';
$add_opt_lvcreate = 0;
if(is_file('/etc/redhat-release')){
	// For centos 7.5
	$release_ver = @file_get_contents('/etc/redhat-release');
	if(preg_match('/release (8|9)(.[0-9])?/is', $release_ver)){
		$add_opt_lvcreate = 1;
	}
	if(preg_match('/release (7|8|9)(.[0-9])?/is', $release_ver)){
		putenv('LIBGUESTFS_BACKEND=direct');
	}
}elseif(is_file('/etc/debian_version')){
	$release_ver = @file_get_contents('/etc/os-release');
	if(preg_match('/Ubuntu 22(.[0-9])?|Debian(.*)11/is', $release_ver)){
		$add_opt_lvcreate = 1;
	}
}

if(!empty($globals['libguestfs_backend_settings'])){
	putenv('LIBGUESTFS_BACKEND_SETTINGS='.$globals['libguestfs_backend_settings']);
}

//check for centos 8 and add -y option 
$lv_option = '';
if(!empty($add_opt_lvcreate) || $globals['distro'] == 'proxmox'){
	$lv_option = ' -y ';
}

$globals['com']['vgdisplay'] = (is_file('/sbin/vgdisplay') ? '/sbin/vgdisplay' : '/usr/sbin/vgdisplay');
$globals['com']['lvdisplay'] = (is_file('/sbin/lvdisplay') ? '/sbin/lvdisplay' : '/usr/sbin/lvdisplay');
$globals['com']['lvscan'] = (is_file('/sbin/lvscan') ? '/sbin/lvscan' : '/usr/sbin/lvscan');
$globals['com']['lvcreate'] = (is_file('/sbin/lvcreate') ? '/sbin/lvcreate '.$lv_option : '/usr/sbin/lvcreate '.$lv_option);
$globals['com']['lvremove'] = (is_file('/sbin/lvremove') ? '/sbin/lvremove '.$lv_option : '/usr/sbin/lvremove');
$globals['com']['resizefs'] = (is_file('/sbin/resize4fs') ? '/sbin/resize4fs' : '/sbin/resize2fs');
$globals['com']['php'] = '/usr/local/emps/bin/php';
$globals['com']['pgzip'] = (is_file('/usr/bin/pigz') ? '/usr/bin/pigz' : (is_file('/bin/gzip') ?  '/bin/gzip' : '/usr/bin/gzip'));
$globals['com']['sshpass'] = '/usr/bin/sshpass';
$globals['com']['sftp'] = '/usr/bin/sftp';
$globals['com']['rbdmap'] = '/usr/bin/rbdmap';
$globals['com']['lzo_compression'] = is_file('/usr/bin/lzop') ? '/usr/bin/lzop' : '';
$globals['com']['zstd_compression'] = is_file('/usr/bin/zstd') ? '/usr/bin/zstd' : '';
$globals['com']['lz4_compression'] = is_file('/usr/bin/lz4') ? '/usr/bin/lz4' : '';
$globals['com']['xfs_resize'] = is_file('/usr/sbin/xfs_growfs') ? '/usr/sbin/xfs_growfs' : '/usr/bin/xfs_growfs';
$globals['com']['xfs_repair'] = is_file('/usr/sbin/xfs_repair') ? '/usr/sbin/xfs_repair' : '/usr/bin/xfs_repair';


// virtualizor-bin paths
$globals['com']['chattr'] = (is_file('/usr/local/virtualizor-bin/bin/chattr') ? '/usr/local/virtualizor-bin/bin/chattr' : 'chattr');
$globals['com']['e2fsck'] = (is_file('/usr/local/virtualizor-bin/sbin/e2fsck') ? '/usr/local/virtualizor-bin/sbin/e2fsck' : '/sbin/e2fsck');
$globals['com']['dumpe2fs'] = (is_file('/usr/local/virtualizor-bin/sbin/dumpe2fs') ? '/usr/local/virtualizor-bin/sbin/dumpe2fs' : 'dumpe2fs');
$globals['com']['fsck'] = (is_file('/usr/local/virtualizor-bin/sbin/fsck') ? '/usr/local/virtualizor-bin/sbin/fsck' : '/sbin/fsck');
$globals['com']['resizefs'] = (is_file('/usr/local/virtualizor-bin/sbin/resize2fs') ? '/usr/local/virtualizor-bin/sbin/resize2fs' : $globals['com']['resizefs']);




// Array of Timezone to map with our previous option which were OFFSET only.
// This chnages we have made to adjuts the timezone with DST
$mapped_timezones = array('-12' => 'Pacific/Kwajalein',
				'-11' => 'Pacific/Pago_Pago',
				'-10' => 'Pacific/Tahiti',
				'-9' => 'Pacific/Gambier',
				'-8' => 'Pacific/Pitcairn',
				'-7' => 'America/Whitehorse',
				'-6' => 'Pacific/Galapagos',
				'-5' => 'Pacific/Easter',
				'-4' => 'America/Tortola',
				'-3' => 'Atlantic/Stanley',
				'-2' => 'Atlantic/South_Georgia',
				'-1' => 'Atlantic/Cape_Verde',
				'0' => 'UTC',
				'1' => 'Europe/London',
				'2' => 'Europe/Zurich',
				'3' => 'Indian/Mayotte',
				'3.5' => 'Asia/Tehran',
				'4' => 'Indian/Reunion',
				'4.5' => 'Asia/Kabul',
				'5' => 'Indian/Maldives',
				'5.5' => 'Asia/Kolkata',
				'6' => 'Indian/Chagos',
				'6.5' => 'Indian/Cocos',
				'7' => 'Indian/Christmas',
				'8' => 'Australia/Perth',
				'9' => 'Pacific/Palau',
				'9.5' => 'Australia/Darwin',
				'10' => 'Pacific/Saipan',
				'11' => 'Pacific/Pohnpei',
				'12' => 'Pacific/Wallis');
	
if(empty($globals['timezone'])){
	date_default_timezone_set('Europe/London');
}elseif(array_key_exists($globals['timezone'], $mapped_timezones)){
	date_default_timezone_set($mapped_timezones[$globals['timezone']]);
}else{
	date_default_timezone_set($globals['timezone']);
}

@ini_set('memory_limit', '128M');

if(!empty($globals['memory_limit'])){
	@ini_set('memory_limit', $globals['memory_limit']);
}

if(!isset($globals['notupdated_task']) || empty($globals['notupdated_task'])){
	$globals['notupdated_task'] = 1*24*60*60;
}

// Default disk copy speed limit (in MB/s) during VPS create
if(!isset($globals['dd_copy_speed'])){
	$globals['dd_copy_speed'] = 250;
}

//print_r($globals);

// Is there a bridge ?
if(empty($globals['bridge'])){
	$globals['bridge'] = 'viifbr0';
}

// List of keys which are Master and Slave or only slave or only Master
// m = ONLY MASTER, s = ONLY SLAVE, ms = SLAVE SETTING WILL OVERERIDE MASTERS SETTING.
$SETTINGS['sn'] = 'm';
$SETTINGS['logo_url'] = 'm';
$SETTINGS['notification_num_limit'] = 'm';
$SETTINGS['enable_internal_logs'] = 'm';
$SETTINGS['mob_logo_url'] = 'm';
$SETTINGS['logo_login_url'] = 'm';
$SETTINGS['admin_mob_logo_url'] = 'm';
$SETTINGS['favicon_url'] = 'm';
$SETTINGS['disable_login_logo'] = 'm';
$SETTINGS['gzip'] = 'm';
$SETTINGS['support'] = 'm';
$SETTINGS['copyright'] = 'm';
$SETTINGS['sess_len'] = 'm';
$SETTINGS['theme_folder'] = 'm';
$SETTINGS['language'] = 'm';
$SETTINGS['band_suspend'] = 'm';
$SETTINGS['band_calc_creation'] = 'm';
$SETTINGS['novnc'] = 'm';
$SETTINGS['novnc_master_only'] = 'm';
$SETTINGS['disable_icons_monitor'] = 'm';
$SETTINGS['disable_icons_cp'] = 'm';
$SETTINGS['enable_enduser_vnc'] = 'm';
$SETTINGS['show_server'] = 'm';
$SETTINGS['login_attempts'] = 'm';
$SETTINGS['login_ban_time'] = 'm';
$SETTINGS['queue_creation'] = 'm';
$SETTINGS['email_update_client'] = 'm';
$SETTINGS['noc_apikey'] = 'm';
$SETTINGS['noc_apipass'] = 'm';
$SETTINGS['disable_webuzo'] = 'm';
$SETTINGS['disabled_scripts'] = 'm';
$SETTINGS['dbbackup_email'] = 'm';
$SETTINGS['dbbackup_cron'] = 'm';
$SETTINGS['dbbackup_type'] = 'ms';
$SETTINGS['dbbackup_server'] = 'ms';
$SETTINGS['dbbackup_server_dir'] = 'ms';
$SETTINGS['is_cloud'] = 'm';
$SETTINGS['no_ebtables_on_plans'] = 'm';
$SETTINGS['enable_rdns'] = 'm';
$SETTINGS['admin_logs'] = 'm';
$SETTINGS['vps_logs'] = 'm';
$SETTINGS['login_logs'] = 'm';
$SETTINGS['system_logs'] = 'm';
$SETTINGS['status_logs'] = 'm';
$SETTINGS['bandwidth_logs'] = 'm';
$SETTINGS['auto_add_zone'] = 'm';
$SETTINGS['enable_console'] = 'm';
$SETTINGS['disable_apicredential'] = 'm';
$SETTINGS['curl_timeout'] = 'm';
$SETTINGS['del_novps_user'] = 'm';
$SETTINGS['disable_master_vpsname'] = 'm';
$SETTINGS['showsearch'] = 'm';
$SETTINGS['site_domain'] = 'm';
$SETTINGS['use_new_theme'] = 'm';
$SETTINGS['turnon_virtdf'] = 'm';
$SETTINGS['disable_newtheme'] = 'm';
$SETTINGS['disable_recipes'] = 'm';
$SETTINGS['eu_allow_virtio'] = 'm';
$SETTINGS['disable_rescue'] = 'm';
$SETTINGS['disable_change_hostname'] = 'm';
$SETTINGS['disable_change_password'] = 'm';
$SETTINGS['disable_change_vnc_password'] = 'm';
$SETTINGS['disable_vps_config'] = 'm';
$SETTINGS['disable_os_reinstall'] = 'm';
$SETTINGS['disable_ssh'] = 'm';
$SETTINGS['enable_virtio'] = 'm';
$SETTINGS['disable_suspend_email'] = 'm';
$SETTINGS['disable_integrity_check'] = 'm';
$SETTINGS['enable_idsort'] = 'm';
$SETTINGS['del_tasks'] = 'm';
$SETTINGS['disable_self_shutdown'] = 'm';
$SETTINGS['disable_server_location'] = 'm';
$SETTINGS['disable_enduser_sshkeys'] = 'm';
$SETTINGS['disable_vga'] = 'm';
$SETTINGS['disable_java_vnc'] = 'm';
$SETTINGS['hidden_enable_multi_curl'] = 'm';
$SETTINGS['enable_nic'] = 'm';
$SETTINGS['enable_cb'] = 'm';
$SETTINGS['cb_use_https'] = 'm';
$SETTINGS['cb_url'] = 'm';
$SETTINGS['cb_suspend'] = 'm';
$SETTINGS['cb_unsuspend'] = 'm';
$SETTINGS['cb_hostname'] = 'm';
$SETTINGS['cb_terminate'] = 'm';
$SETTINGS['cb_changeips'] = 'm';
$SETTINGS['cb_bandwidth_overusage'] = 'm';
$SETTINGS['default_sg_name'] = 'm';
$SETTINGS['default_sg_reseller_name'] = 'm';
$SETTINGS['default_sg_desc'] = 'm';
$SETTINGS['custom_mac'] = 'm';
$SETTINGS['cloud_allow_virtio'] = 'm';
$SETTINGS['2fa_email_otp'] = 'm';
$SETTINGS['pass_strength'] = 'm';
$SETTINGS['haproxy_cron_logs'] = 'm';
$SETTINGS['backup_queue'] = 'm';
$SETTINGS['restore_queue'] = 'm';
$SETTINGS['disable_backup_cp'] = 'm';
$SETTINGS['enable_eu_iso_boot'] = 'm';
$SETTINGS['enable_eu_iso'] = 'm';
$SETTINGS['eu_iso_size'] = 'm';
$SETTINGS['eu_iso_limit'] = 'm';
$SETTINGS['eu_iso_space'] = 'm';
$SETTINGS['eu_iso_del_hr'] = 'm';
$SETTINGS['secure_allowed_ips'] = 'm';
$SETTINGS['secure_allowed_api_ips'] = 'm';
$SETTINGS['backup_email'] = 'm';
$SETTINGS['backup_disable_success_mail'] = 'm';
$SETTINGS['set_def_hvm'] = 'm';
$SETTINGS['vps_bandwidth_threshold'] = 'm';
$SETTINGS['update'] = 'm';
$SETTINGS['email_update'] = 'm';
$SETTINGS['notupdated_task'] = 'm';
$SETTINGS['prox_mig_if_hiload'] = 'm';
$SETTINGS['max_ipv4s'] = 'm';
$SETTINGS['max_ipv6s'] = 'm';
$SETTINGS['max_ipv6_subnets'] = 'm';
$SETTINGS['max_internal_ips'] = 'm';
$SETTINGS['allow_cloud_dom_name'] = 'm';
$SETTINGS['allow_cloud_ebt_disable'] = 'm';
$SETTINGS['enable_backup_delete'] = 'm';
$SETTINGS['enable_backup_delete_cron'] = 'm';
$SETTINGS['disable_2tb_check'] = 'm';
$SETTINGS['disable_ebtables'] = 'm';
$SETTINGS['disable_ebtables_internal'] = 'm';
$SETTINGS['disable_domain_forward'] = 'm';
$SETTINGS['show_vps_active_time'] = 'm';
$SETTINGS['power_only_option'] = 'm';
$SETTINGS['resource_preference'] = 'm';
$SETTINGS['rescue_disk_size'] = 'm';
$SETTINGS['disable_logs'] = 'm';
$SETTINGS['disable_change_primary_ip'] = 'm';
$SETTINGS['script_timeout'] = 'm';
$SETTINGS['throttle_block_size'] = 'm';
$SETTINGS['hide_acc_password'] = 'm';
$SETTINGS['hide_forgot_password'] = 'm';
$SETTINGS['disable_sess'] = 'm';
$SETTINGS['disable_recipe_reinstall'] = 'm';
$SETTINGS['disable_enduser_panel'] = 'm';
$SETTINGS['hide_enduser_vnc_info'] = 'm';
$SETTINGS['server_ram_threshold'] = 'm';
$SETTINGS['server_disk_threshold'] = 'm';
$SETTINGS['libguestfs_backend_settings'] = 'm';
$SETTINGS['vm_short'] = 'm';
$SETTINGS['vm_long'] = 'm';
$SETTINGS['disable_sess'] = 'm';
$SETTINGS['temp_storage_fs'] = 'm';
$SETTINGS['openvz7_auto_vnc'] = 'm';
$SETTINGS['rows_to_display'] = 'm';
$SETTINGS['vz6_style_suspend'] = 'm';
$SETTINGS['zfs_volblocksize'] = 'm';
$SETTINGS['compression_algo'] = 'm';
$SETTINGS['default_mig_speed'] = 'm';
$SETTINGS['show_server_selection_logs'] = 'm';
$SETTINGS['use_win_script'] = 'm';
$SETTINGS['disable_notifications'] = 'm';
$SETTINGS['del_notifications'] = 'm';
$SETTINGS['del_api_logs'] = 'm';
$SETTINGS['disable_terminal_access'] = 'm';
$SETTINGS['disable_volume_enduser'] = 'm';
$SETTINGS['disable_lb_enduser'] = 'm';
$SETTINGS['disable_virttype'] = 'm';
$SETTINGS['setmaxdowntime'] = 'm';
$SETTINGS['from_email'] = 'm';
$SETTINGS['inhouse_billing'] = 'm';
$SETTINGS['lightbit_replica'] = 'm';
$SETTINGS['lightbit_compression'] = 'm';
$SETTINGS['hide_eu_tasks'] = 'm';
$SETTINGS['add_ptr_record'] = 'm';
$SETTINGS['enable_ver_scaling'] = 'm';
$SETTINGS['ver_max_ram'] = 'm';
$SETTINGS['ver_ram_threshold'] = 'm';
$SETTINGS['ver_ram_inc_by'] = 'm';
$SETTINGS['ver_max_cpu'] = 'm';
$SETTINGS['ver_cpu_threshold'] = 'm';
$SETTINGS['ver_cpu_inc_by'] = 'm';
$SETTINGS['hidden_backuply_extra_space'] = 'm';
$SETTINGS['hidden_prox_onboot_disable'] = 'm';
$SETTINGS['hidden_dont_add_vm_hostname'] = 'm';
$SETTINGS['hidden_prox_firewall'] = 'm';
$SETTINGS['save_vm_pass'] = 'm';
$SETTINGS['dont_delete_bw_from_db'] = 'm';
$SETTINGS['enable_ldap_auth'] = 'm';
$SETTINGS['ldap_server'] = 'm';
$SETTINGS['ldap_port'] = 'm';
$SETTINGS['ldap_admin_username'] = 'm';
$SETTINGS['ldap_admin_password'] = 'm';
$SETTINGS['ldap_admin_password_salt'] = 'm';
$SETTINGS['ldap_search_base'] = 'm';
$SETTINGS['disable_balloon'] = 'm';
$SETTINGS['cron_timeout'] = 'm';
$SETTINGS['cronh_timeout'] = 'm';
$SETTINGS['cronm_timeout'] = 'm';
$SETTINGS['cb_timeout'] = 'm';
$SETTINGS['firewall_rule_limit'] = 'm';
$SETTINGS['firewall_rule_limit_enduser'] = 'm';
$SETTINGS['vzo_config_file_name'] = 'm';
$SETTINGS['sort_server_grp_by'] = 'm';

// ONLY SLAVE Setting (Which will be overridden by MASTER)
$SETTINGS['pv_on_hvm'] = 'ms';
$SETTINGS['novnc_server_name'] = 'ms';
$SETTINGS['cpu_nm'] = 'ms';
$SETTINGS['soft_email'] = 'ms';
$SETTINGS['timezone'] = 'ms';
$SETTINGS['interface'] = 'ms';
$SETTINGS['xen_dom0mem'] = 'ms';
$SETTINGS['alert_load_limit'] = 'ms';
$SETTINGS['alert_disk_limit'] = 'ms';
$SETTINGS['ping_ip'] = 'ms';
$SETTINGS['enable_tuntap_cp'] = 'ms';
$SETTINGS['enable_ppp_cp'] = 'ms';
$SETTINGS['addvs_cpu_prio'] = 'ms';
$SETTINGS['enable_ppp_cp'] = 'ms';
$SETTINGS['addvs_io_prio'] = 'ms';
$SETTINGS['addvs_io_class'] = 'ms';
$SETTINGS['vswap'] = 'ms';
$SETTINGS['ploop'] = 'ms';
$SETTINGS['node_bandwidth'] = 'ms';
$SETTINGS['del_slave_ostemplate'] = 'ms';
$SETTINGS['openvz_suspend_load'] = 'ms';
$SETTINGS['keep_orphan_template'] = 'ms';
$SETTINGS['haproxy_enable'] = 'ms';
$SETTINGS['haproxy_reservedports'] = 'ms';
$SETTINGS['haproxy_reservedports_http'] = 'ms';
$SETTINGS['haproxy_allowedports'] = 'ms';
$SETTINGS['mail'] = 'ms';
$SETTINGS['mail_server'] = 'ms';
$SETTINGS['mail_port'] = 'ms';
$SETTINGS['mail_user'] = 'ms';
$SETTINGS['mail_pass'] = 'ms';
$SETTINGS['mail_smtp_secure'] = 'ms';
$SETTINGS['mail_debug'] = 'ms';
$SETTINGS['mail_connect_timeout'] = 'ms';
$SETTINGS['speed_cap_disable'] = 'ms';
$SETTINGS['enable_fuse_cp'] = 'ms';
$SETTINGS['enable_ipip_cp'] = 'ms';
$SETTINGS['enable_ipgre_cp'] = 'ms';
$SETTINGS['enable_nfs_cp'] = 'ms';
$SETTINGS['enable_quotaugidlimit_cp'] = 'ms';
$SETTINGS['enable_iolimit_cp'] = 'ms';
$SETTINGS['enable_iopslimit_cp'] = 'ms';
$SETTINGS['disable_virttop'] = 'ms';
$SETTINGS['disable_virtsparsify'] = 'ms';
$SETTINGS['disable_slave_db_backup'] = 'ms';
$SETTINGS['set_vps_config_mtu'] = 'ms';
$SETTINGS['memory_limit'] = 'ms';
$SETTINGS['temporary_st_directory'] = 'ms';
$SETTINGS['disable_guest_agent'] = 'ms';

// Slave
$SETTINGS['cron_time'] = 's';
$SETTINGS['emps_cron_time'] = 's';
$SETTINGS['cookie_name'] = 's';
$SETTINGS['vpslimit'] = 's';
$SETTINGS['overcommit'] = 's';
$SETTINGS['vnc_ip'] = 's';
$SETTINGS['xen_pvbridge'] = 's';
$SETTINGS['xen_hvmbridge'] = 's';
$SETTINGS['use_xl'] = 's';
$SETTINGS['change_ssh_port'] = 's';
$SETTINGS['max_ssh_login'] = 's';
$SETTINGS['vcores'] = 's';
$SETTINGS['proxmox_server_name'] = 's';
$SETTINGS['proxmox_server_pass'] = 's';
$SETTINGS['proxmox_server_pass_salt'] = 's';
$SETTINGS['proxmox_tfa_secret'] = 's';
$SETTINGS['disable_nw_config'] = 's';
$SETTINGS['haproxy_src_ips'] = 's';
$SETTINGS['server_country_code'] = 's';
$SETTINGS['server_state'] = 's';
$SETTINGS['server_city'] = 's';
$SETTINGS['ftp_mode'] = 's';
$SETTINGS['dd_copy_speed'] = 's';
$SETTINGS['node_cpu_threshold'] = 's';
$SETTINGS['node_ram_threshold'] = 's';
$SETTINGS['bw_cal_config'] = 's';

// LE settings
$SETTINGS['le_primary_domain'] = 's';
$SETTINGS['le_contact_email'] = 's';
$SETTINGS['le_key_size'] = 's';
$SETTINGS['le_renew_days'] = 's';
$SETTINGS['le_staging'] = 's';
$SETTINGS['le_enable_force'] = 's';
$SETTINGS['le_ssl_type'] = 's';


// Connect to the Database
if(empty($globals['dbconnect'])){
	
	// Check if the PDO is there 
	if(class_exists('PDO')){
		try{
			$globals['pdo_conn'] = new PDO('mysql:host='.$globals['dbhost'].';dbname='.$globals['db'].';charset=utf8', $globals['dbuser'], $globals['dbpass'], array(PDO::MYSQL_ATTR_MULTI_STATEMENTS => false));
		}catch(PDOException $e){
			die("Error!: " . $e->getMessage());
		}
		
		// Do we have to OVERRIDE the SLAVE Settings ?
		// First get the settings saved for SLAVE.
		$stmt = $globals['pdo_conn']->prepare("SELECT settings FROM servers WHERE serid = 0");
		$stmt->execute();
		
		if($stmt->rowCount() > 0){
			$tmp_settings = $stmt->fetch(PDO::FETCH_ASSOC);
			$tmp_settings = @unserialize($tmp_settings['settings']);
			
			// Did it unserialize
			if(!empty($tmp_settings)){
			
				foreach($SETTINGS as $sk => $sv){
					if(array_key_exists($sk, $tmp_settings)){
						$globals[$sk] = $tmp_settings[$sk];
					}
				}
			}
		}
		
	// If PDO is not there we will have to use the mysql
	}else{
		
		$globals['conn'] = @mysqli_connect($globals['dbhost'], $globals['dbuser'], $globals['dbpass'], $globals['db']) or die( "Unable to select database");
	
		// Do we have to OVERRIDE the SLAVE Settings ?
		// First get the settings saved for SLAVE.
		$res = mysqli_query($globals['conn'], "SELECT settings FROM servers WHERE serid = 0");
		
		if(mysqli_num_rows($res) > 0){
			$tmp_settings = mysqli_fetch_assoc($res);
			$tmp_settings = @unserialize($tmp_settings['settings']);
			
			// Did it unserialize
			if(!empty($tmp_settings)){
			
				foreach($SETTINGS as $sk => $sv){
					if(array_key_exists($sk, $tmp_settings)){
						$globals[$sk] = $tmp_settings[$sk];
					}
				}
			}
		}
	}
}

// Billing setting !
if(empty($globals['cp_url'])){
	$globals['cp_url'] = @(!empty($_SERVER['HTTPS']) ? 'https://' : 'http://').(@$_SERVER['HTTP_HOST']);
}

$globals['billing_warn_bal'] = empty($globals['billing_warn_bal']) ? 80 : $globals['billing_warn_bal'];

//Default rules limit is 10
$globals['firewall_rule_limit'] = empty($globals['firewall_rule_limit']) ? 10 : $globals['firewall_rule_limit'];

//Default rules limit is 10
$globals['firewall_rule_limit_enduser'] = empty($globals['firewall_rule_limit_enduser']) ? 10 : $globals['firewall_rule_limit_enduser'];

$globals['resource_types'] = array('space', 'cores', 'ram', 'ips', 'ipv6', 'ipsint', 'ipv6subnet');
$globals['allow_cloud_dom_name'] = 1;

$globals['throttle_block_size'] = (empty($globals['throttle_block_size']) ? 0 : $globals['throttle_block_size']);

//check for valid compression algo
$valid_compression = array('lzo', 'lz4', 'zstd');

if(!empty($globals['compression_algo'])){
	if(!in_array($globals['compression_algo'], $valid_compression)){
		$globals['compression_algo'] = '';
	}
}

//path for secure efi ubuntu
if (is_file('/usr/share/OVMF/OVMF_CODE.secboot.fd')) {
	$globals['secure_efi_path'] = '/usr/share/OVMF/OVMF_CODE.secboot.fd';
}
//path for secure efi centos
if (is_file('/usr/share/edk2/ovmf/OVMF_CODE.secboot.fd')) {
	$globals['secure_efi_path'] = '/usr/share/edk2/ovmf/OVMF_CODE.secboot.fd';
}
//path for unsecure efi centos
if (is_file('/usr/share/edk2/ovmf/OVMF_CODE.cc.fd')) {
	$globals['unsecure_efi_path'] = '/usr/share/edk2/ovmf/OVMF_CODE.cc.fd';
}
//path for unsecure efi ubuntu
if (is_file('/usr/share/OVMF/OVMF_CODE.fd')) {
	$globals['unsecure_efi_path'] = '/usr/share/OVMF/OVMF_CODE.fd';
}
$globals['shells'] = array('Default(sh shell)' => '#!/bin/sh', 'Bash' => '#!/bin/bash', 'Ksh' => '#!/bin/ksh', 'Zsh' => '#!/bin/zsh');

$globals['vgabios_path'] = '/usr/share/';

// PASSTHROUGH 
// $globals['mail_savedPassthroughs_unavailable'] = 1;
// $globals['pci_manage'] = 0;
// We are recognizing these USB controllers :
$globals['usb_models'] = [
	//2.0 driver
	'ehci' => [
		'name' => 'ehci',
		'attributes' => [
			'port_attribute_option' => 0,
			'port_start' => 2,
			'port_end' => 2,
		],
	],
	//3.0 driver
	'xhci' => [
		'name' => 'nec-xhci',
		'attributes' => [
			'port_attribute_option' => 1,
			'port_start' => 2,
			'port_end' => 10,
		],
	],
];

//supported OSes for Load Balancer
$globals['load_balancer_os'] = array("almalinux", "ubuntu-20.04", "ubuntu-22.04");