<?php

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function getSortHeader($header_name, $sort_column, $sort_column_by, $column, $size='90'){

	global $theme, $globals;
	$str = '<div class="d-inline-flex align-items-center" style="width:'.$size.'px;">
		<div class="mr-2">
			<span class="" >'.$header_name.'</span>
		</div>
		<span class="sorter">
			<a class="text-always-white" href="'.$globals['index'].'act=vps_stats&sortcolumn='.$column.'&sortby=asc"><i class="fas fa-sort-up"></i></a><br>
			<a class="text-always-white" href="'.$globals['index'].'act=vps_stats&sortcolumn='.$column.'&sortby=desc"><i class="fas fa-sort-down"></i></a>
		</span>
	</div>';
	return $str;
}

// Each Vps Stats
function vps_stats_theme(){

	global $theme, $globals, $ckernel, $user, $l, $vps_stats, $pie_data, $vps_data, $sort_column, $sort_column_by, $notice, $servers, $kernel;
	
	//Wrap up each vps data in td
	$table_data = '';
	
	softheader($l['<title>']);
	
	if(!empty($notice['no_vps'])){
		
		echo '<div class="bg">
				<div class="row my-3 mx-auto">
				<div class="col-10">
				<h4 class="text-dark"><i class="fas fa-chart-area"></i> '.$l['page_head'].'</h4>
				</div>
			</div><br><br><br>';
		
		echo '<div class="row mx-auto w-100"><div class="col-sm-4"></div><div class="col-sm-4">';
			server_select();
		echo '</div></div>';
		show_alert($l['no_vps'] ,"2");
		echo '<div class="notice" id="note_box">
			<b>NOTE : </b>&nbsp; '.$l['no_vps'].'</div></div>';
		
			
	}else{
		
		//Initialize the pie chart values of vps bandwidth, cpu and ram
		$values_cpu = $values_ram = $values_bandwidth = $labels = array();
		
		// Total CPU and Bandwidth of all VPSs
		$total_cpu = 0;
		$total_band = 0;
		//log_message('/tmp/'.substr(basename(__FILE__), 0, -4).'-'.__FUNCTION__.'.log','Line Number : '.__LINE__.'$vps_data:'.print_r($vps_data,1));
		foreach($vps_data as $key => $values_chart){
			$pie_cpu[$values_chart['vps_name']] = (int) $values_chart['used_cpu'];
			$pie_ram[$values_chart['vps_name']] = (int) $values_chart['used_ram'];
			$pie_bandwidth[$values_chart['vps_name']] = round((int) $values_chart['used_bandwidth'],2);
			$pie_hex_color[] = '#' . str_pad(dechex(rand(0x000000, 0xFFFFFF)), 6, 0, STR_PAD_LEFT);
		}
		
		foreach($vps_data as $k => $v){
			
			// Values to plot the PIE
			$k = str_replace("K_", "", $k);
			$values_ram[$v['vpsid']] = '{"label" : "VPS ID : '.$v['vpsid'].' VPS Name : '.$v['vps_name'].'", data: '.$v['used_ram'].'}';
			
			$total_cpu += $v['used_cpu'];
			$values_cpu[$v['vpsid']] = '{"label" : "VPS ID : '.$v['vpsid'].' VPS Name : '.$v['vps_name'].'", data: '.$v['used_cpu'].'}';
			
			$total_band += $v['used_bandwidth'];
			$values_bandwidth[$v['vpsid']] = '{"label" : "VPS ID : '.$v['vpsid'].' VPS Name : '.$v['vps_name'].'", data: '.$v['used_bandwidth'].'}';
			
			//Check the status of the vps
			if($v['status'] == 1){
				$tmp = '<td align="center" id="spcpu_'.$k.'" ><div class="spcpu">'.(float)$v['used_cpu'].','.(100 - $v['used_cpu']).'</div><div class="small_txt">'.(float)$v['used_cpu'].'%</div></td>
								'.($kernel->features('vps_ram_info', $v['virt']) ? '<td align="center" id="spram_'.$k.'" ><div class="spram">'.(int)$v['used_ram'].','.((int)$v['ram'] - (int)$v['used_ram']).'</div><div class="small_txt">'.(int)$v['used_ram'].' / '.(int)$v['ram'].' MB</div></td>' : '<td align="center" id="spram_'.$k.'" >N/A</td>').'
								<td align="center" id="spdisk_'.$k.'"><div class="spdisk">'.($v['used_disk']).','.($v['disk'] - $v['used_disk']).'</div><div class="small_txt">'.round($v['used_disk'], 2).' / '.$v['disk'].' GB</div></td>
								'.(empty($v['inode']) ? '<td align="center" id="spinode_'.$k.'"> N/A </td>' : '<td align="center" id="spinode_'.$k.'"><div class="spinode">'.$v['used_inode'].','.($v['inode'] - $v['used_inode']).'</div><div class="small_txt">'.$v['used_inode'].' / '.$v['inode'].'</div></td>');
				$status_td = '<td align="center" id="status_'.$k.'"><i class="fas fa-circle fa-circle-green" title="'.$l['vps_stat_on'].'"></i></td>';				
			}elseif($v['status'] == 2){
				$status_td = '<td align="center" id="status_'.$k.'"><i class="fas fa-circle fa-circle-gray" title="'.$l['vps_stat_suspend'].'"></i></td>';
				$tmp = '<td colspan="4" class="text-center" id="nodata_'.$k.'">'.$l['no_data'].'</td>';
			}else{
				$status_td = '<td align="center" id="status_'.$k.'"><i class="fas fa-circle fa-circle-red" title="'.$l['vps_stat_off'].'"></i></td>';
				$tmp = '<td colspan="4" class="text-center" id="nodata_'.$k.'">'.$l['no_data'].'</td>';
			}
			
			//Check if speed cap is enabled
			if($v['speed_cap'] == '0' || $v['speed_cap'] == NULL){
				$speedCap = '<td align="center"><span><i class="fas fa-circle fa-circle-red" title="'.$l['vps_speed_cap_disabled'].'"></i></span></td>';
			}else{
				$speed_cap = explode(',',$v['speed_cap']);
				$speedCap = '<td align="center">'.$speed_cap[1].' KB <img src="'.$theme['images'].'admin/arrow_up.png" title="'.$l['vps_upload_speed'].'"><br>'.$speed_cap[0].' KB <img src="'.$theme['images'].'admin/arrow_down.png" title="'.$l['vps_download_speed'].'"></td>';
			}
				
			$table_data .= '<tr>
								'.$status_td.'
								<td id="vpsid_'.$k.'">'.$v['vpsid'].'</td>
								<td id="hostname_'.$k.'" '.(strlen($v['hostname']) >= 20 ? 'tooltip="'.$v['hostname'].'"' : '').'><script>document.write(wordwrapper(20,"'.$v['hostname'].'"))</script>('.$v['vps_name'].')</td>
								'.$tmp.'
								<td>
										<div class="spband" align="center" id="band_'.$k.'">
											'.$v['used_bandwidth'].','.(!empty($v['bandwidth']) ? $v['bandwidth'] - $v['used_bandwidth'] : 9999999).'
										</div>
										<div class="small_txt" align="center" id="band2_'.$k.'">
											'.$v['used_bandwidth'].'/'.(!empty($v['bandwidth']) ? $v['bandwidth'] - $v['used_bandwidth'] : $l['unlimited']).' GB
										</div>
								</td>
								<td align="center" id="netin_'.$k.'">'.byte_convert($v['net_in'], 2).'</td>
								<td align="center" id="netout_'.$k.'">'.byte_convert($v['net_out'], 2).'</td>
								<td align="center" id="io_read_'.$k.'">'.byte_convert($v['io_read'], 2).'</td>
								<td align="center" id="io_write_'.$k.'">'.byte_convert($v['io_write'], 2).'</td>
								'.$speedCap.'
								<td align="center"><span onclick="show_graph('.$v['vpsid'].')"><i class="fas fa-chart-bar fa-2x p-1 cursor-pointer"></i></span></td>
							</tr>';  
			
		}
		
		// Handle Server Ram 
		foreach($pie_data['server_ram'] as $k => $v){
			
			if($k == 0 && !empty($v['used_ram'])){
				$pie_hex_color[] = '#' . str_pad(dechex(rand(0x000000, 0xFFFFFF)), 6, 0, STR_PAD_LEFT);
				$values_ram[$k] = '{"label" : "Server '.$l['free'].'&nbsp;'.$l['ram'].'", data: '.($v['ram'] - $v['used_ram']).'}';
				$pie_ram[$k] = $v['ram'] - $v['used_ram'];
			// DOM-0 RAM for XEN and XCP	
			}elseif($k == -1 && !empty($v['used_ram'])){
				$values_ram[$k] = '{"label" : "Dom0 '.$l['used'].'&nbsp;'.$l['ram'].'", data: '.$v['used_ram'].'}';
				$values_ram[-2] = '{"label" : "Dom0 '.$l['free'].'&nbsp;'.$l['ram'].'", data: '.($v['ram'] - $v['used_ram']).'}';
				$pie_ram[$k] = $v['used_ram'];
				$pie_ram[-2] = $v['ram'] - $v['used_ram'];
			}
		}
		
		// Handle Server CPU
		if(!empty($pie_data['server_cpu'])){
			
			// The actual CPU % free on main node retuned from server stats
			$values_cpu['Server'] = '{"label" : "Server '.$l['free'].'", data: '.$pie_data['server_cpu']['percent_free'].'}';
			$pie_hex_color[] = '#' . str_pad(dechex(rand(0x000000, 0xFFFFFF)), 6, 0, STR_PAD_LEFT);
			$pie_cpu['Server'] = $pie_data['server_cpu']['percent_free'];
			// There is a possibility of total CPU % of all VPSs being greater than the actual CPU used % of the server
			if($total_cpu < $pie_data['server_cpu']['percent']){
				// CPU % utlized by the server itself apart from the VPSs
				$values_cpu['Server'] = '{"label" : "Server '.$l['used'].'", data: '.($pie_data['server_cpu']['percent'] - $total_cpu).'}';
				$pie_cpu['Server'] = $pie_data['server_cpu']['percent'] - $total_cpu;
			}
			
		}
		
		// Handle Server Bandwidth
		if(!empty($pie_data['server_bandwidth'])){
			
			$pie_hex_color[] = '#' . str_pad(dechex(rand(0x000000, 0xFFFFFF)), 6, 0, STR_PAD_LEFT);
			$values_bandwidth[0] = '{"label" : "Server '.$l['used'].'", data: '.$pie_data['server_bandwidth']['used_gb'].'}';
			$pie_bandwidth['Server'] = $pie_data['server_bandwidth']['used_gb'];
			$free = 0; // Server Free GB
			// Show Free bandwidth if there is any
			if($pie_data['server_bandwidth']['limit_gb'] > ($total_band + $pie_data['server_bandwidth']['used_gb'])){
				$free = $pie_data['server_bandwidth']['limit_gb'] - ($total_band + $pie_data['server_bandwidth']['used_gb']);
				$values_bandwidth[-1] = '{"label" : "Server '.$l['free'].'", data: '.$free.'}';
				$pie_bandwidth[-1] = $free;
			}
		}
		$j_pie_data = json_encode(array_keys($pie_cpu));
		$j_pie_cpu = json_encode(array_values($pie_cpu));
		$j_pie_ram = json_encode(array_values($pie_ram));
		$j_pie_bandwidth = json_encode(array_values($pie_bandwidth));
		$j_pie_hex_color = json_encode(array_values($pie_hex_color));
		echo '<style type="text/css">
		
		.spcpu, .spram, .spdisk, .spinode, .spband {
			margin-bottom: 4px;
		}
		
		.small_txt {
			font-size: 11px;
		}
		
		</style>
		<script src="'.$theme['url'].'/js/chart.js"> </script>
		<script language="javascript" type="text/javascript">
		
		//Assign a global variable to remember the vpsid when page loads
		vpsid = 0;
		
		var monthFullNames = ["'.$l['january'].'", "'.$l['february'].'", "'.$l['march'].'", "'.$l['april'].'", "'.$l['may'].'", "'.$l['june'].'", "'.$l['july'].'", "'.$l['august'].'", "'.$l['september'].'", "'.$l['october'].'", "'.$l['november'].'", "'.$l['december'].'" ];
		
		// Show the data for bandwidth, CPU, RAM
		function plot_pie(id, data){
			
			var plot = $.plot(id, data,{
				series: {
					pie: { 
						show: true,
						radius: 3/4,
						label: {
							show: false
						},
						stroke: { 
							width: 0.1,
							color: "#408080"
						}
					}
				},
				grid: {
					hoverable: true,
					clickable: true
				},
				legend: {
					show: false
				}
			});
			
			id.bind("plothover", pieHover);
		}

		var previousPoint = null;
		function pieHover(event, pos, obj){
			
			if (!obj){
				$("#tooltip").remove();
				previousPoint = null;
				return;
			}
			
			if (previousPoint != obj.seriesIndex) {
				previousPoint = obj.seriesIndex;
				$("#tooltip").remove();
			
				var tmp = ""+obj.series.data;
				var ram = tmp.split(",");
				
				var idOfPie = event.target.getAttribute(\'id\');
				idOfPie = idOfPie.split("_");
				var pieChartName = "";
				var pieChartSign = "";
				
				if(idOfPie[1] == "cpu"){
					pieChartName = "CPU";
					pieChartSign = "%";

				}else if(idOfPie[1] == "ram"){
					pieChartName = "RAM";
					pieChartSign = "MB";
					
				}else if(idOfPie[1] == "bandwidth"){
					pieChartName = "Bandwidth";
					pieChartSign = "GB";
				}
				
				showTooltip(pos.pageX, pos.pageY, obj.series.label+"<br /> "+pieChartName+" : "+ram[1]+" "+pieChartSign);		
			}		
		}
			
		function show_graph(id){
			
			vpsid = id;
			//CPU as default window
			change_monitor_tabs("cpuinfo");
			var dialogTitle = \'<i class="fas fa-chart-bar"></i>&nbsp;&nbsp; <h5 class="m-0"> VPSID \'+id+\' </h5> &nbsp;&nbsp;<span id="img_loading"></span>\';
			
			$("#dialog-header").html(dialogTitle+"<button type=\"button\" class=\"close text-always-white\" data-dismiss=\"modal\">×</button>");
			$("#dialog").modal();
			
			
			
			//Display loading image
			$("#img_loading").html("<div class=\"loader\"></div>");
			
			$.post("'.$globals['index'].'act=vps_stats&jsnohf=1&api=json&svs="+id+"", function(data){
					data = JSON.parse(data);
					
					if(data.vps_stats){
						show_monthly_graph(data.vps_stats, data.month);
					}else{
						var req_month = parseInt(data.month.current_month.toString().substring(4));
						$("#note_box").css("display","block");
						$("#for_month").html(monthFullNames[req_month - 1]);
					}
					$("#img_loading").html("");
			});
		};	
			
		// Show monthly graph
		function show_monthly_graph(monthly_data, month){
			
			if(monthly_data){
				
				$("#note_box").css("display","none");
			
				var cpu_data = new Array();
				var inode_data = new Array();
				var ram_data = new Array();
				var disk_data = new Array();
				var ntw_in_data = new Array();
				var ntw_out_data = new Array();
				var ntw_total_data = new Array();
				var io_read_data = new Array();
				var io_write_data = new Array();
				
				if(monthly_data){
				
					$.each(monthly_data,function(key,val){
						
						//Array is in format [0:vpsid, 1:time, 2:status, 3:disk, 4:inode, 5:ram,  6:cpu, 7:actual_cpu, 8:net_in, 9:net_out]
					
						cpu_data.push([val[1], val[7]]);
							
						inode_data.push([val[1], val[4]]);
							
						ram_data.push([val[1], val[5]]);	
						
						disk_data.push([val[1], (val[3]/1024)]);
						
						ntw_in_data.push([val[1], val[8]]);
						
						ntw_out_data.push([val[1], val[9]]);
						
						ntw_total_data.push([val[1], parseInt(val[8]) + parseInt(val[9])]);

						io_read_data.push([val[1], val[10]]);

						io_write_data.push([val[1], val[11]]);
					});
				
				}
				
				// LEFT TO check
				cpu_data.sort(function(a, b){ 
					return a[0]-b[0]; 
				});
				
				var cpu_graph = [
							{ label: "'.$l['cpu_utilization'].'",  data: cpu_data}
						];
						
				var inode_graph = [
						{ label: "'.$l['inode'].'",  data: inode_data, color: "#80b3ff"}
					];	
					
				var ram_graph = [
						{ label: "'.$l['ram_utilization'].'",  data: ram_data, color: "#ccff33"}
					];	
					
				var disk_graph = [
						{ label: "'.$l['disk'].'",  data: disk_data, color: "#ff6600"}
					];	

				var io_read_graph = [
					{ label: "'.$l['io_read_spd'].'",  data: io_read_data, color: "#0077FF"},
				];

				var io_write_graph = [
					{ label: "'.$l['io_write_spd'].'",  data: io_write_data, color: "#FF6600"},
				];
						
				var ntw_graph = [
						{ label: "'.$l['download_graph_title'].'",  data: ntw_in_data, color: "#0077FF"},
						{ label: "'.$l['upload_graph_title'].'",  data: ntw_out_data , color: "#0000A0"},
						{ label: "'.$l['total_graph_title'].'",  data: ntw_total_data}
					];	
				
				selection_zooming("cpu_plot", cpu_graph);
				live_resource_graph("cpu_plot", cpu_graph, flot_options("cpu_plot"), "% at ",true);

				selection_zooming("ram_plot", ram_graph);
				live_resource_graph("ram_plot", ram_graph, flot_options("ram_plot"), "MB at ",true);
				
				selection_zooming("disk_plot", disk_graph);
				live_resource_graph("disk_plot", disk_graph, flot_options("disk_plot"), "GB at ",true);

				selection_zooming("inode_plot", inode_graph);
				live_resource_graph("inode_plot", inode_graph, flot_options("inode_plot"), "Blocks at ",true);
			
				selection_zooming("io_read_plot", io_read_graph);
				live_resource_graph("io_read_plot", io_read_graph, flot_options("io_read_plot"), "Mb/s at ",true);
				
				selection_zooming("io_write_plot", io_write_graph);
				live_resource_graph("io_write_plot", io_write_graph, flot_options("io_write_plot"), "Mb/s at ",true);
				
				selection_zooming("ntw", ntw_graph);
				live_resource_graph("ntw", ntw_graph, flot_options("ntw"), "",true);
				
				var monthNames = ["'.$l['jan'].'", "'.$l['feb'].'", "'.$l['mar'].'", "'.$l['apr'].'", "'.$l['may'].'", "'.$l['jun'].'", "'.$l['jul'].'", "'.$l['aug'].'", "'.$l['sep'].'", "'.$l['oct'].'", "'.$l['nov'].'", "'.$l['dec'].'" ];
				
				var current_year = month.current_month.substring(0,4);
				var current_month = parseInt(month.current_month.substring(4));
				$("#month_holder2").html(monthNames[current_month - 1] +" "+ current_year);
				$("#next_month").html(\'<input type="button" class="btn w-50" onclick="search_result(\'+ month.next_month +\')" value="'.$l['next_month'].'" />\');
				$("#prev_month").html(\'<input type="button" class="btn w-50" onclick="search_result(\'+ month.prev_month +\')" value="'.$l['prev_month'].'" />\');
						
			}else{
				$("#note_box").css("display","block");
			}
		}
		
		function search_result(mon){
			
			//Display loading image
			$("#img_loading").html("<div class=\"loader\"></div>");
			$.post("'.$globals['index'].'act=vps_stats&jsnohf=1&api=json&svs="+ vpsid +"&show=" + mon +"", function(data){
				data = JSON.parse(data);
				if(data.vps_stats){
					show_monthly_graph(data.vps_stats, data.month);
				}else{
					var req_month = parseInt(mon.toString().substring(4));
					$("#note_box").css("display","block");
					$("#for_month").html(monthFullNames[req_month - 1]);
				}
				$("#img_loading").html("");
			}); 
			
		};
			
		// Handle for selection and zooming
		function selection_zooming (id, data){

			$("#"+id).bind("plotselected", function (event, ranges) {
				if (ranges.xaxis.to - ranges.xaxis.from < 0.00001) {
					ranges.xaxis.to = ranges.xaxis.from + 0.00001;
				}
				if (ranges.yaxis.to - ranges.yaxis.from < 0.00001) {
					ranges.yaxis.to = ranges.yaxis.from + 0.00001;
				}
				options = flot_options(id);
				plot = $.plot("#"+id, data,
					$.extend(true, {}, options, {
						xaxis: { min: ranges.xaxis.from, max: ranges.xaxis.to },
						yaxis: { min: ranges.yaxis.from, max: ranges.yaxis.to }
					})
				);
				
				//Lets append zoom out button if its not present
				if($("#zoomOut_"+id) != undefined){
					$("#zoomOut_"+id).fadeOut().remove();
				}
				
				$("<input type=\'button\' style=\'position:absolute;right:15px;top:15px;opacity:0.9;\' class=\'btn\' id=\'zoomOut_\'"+ id +" value=\'Zoom Out\'>").appendTo($("#"+id)).click(function(e){
					e.preventDefault();
					options = flot_options(id);
					$.plot("#"+id, data, options);
					$("#zoomOut_"+id).fadeOut().remove();
				});	
			});
		};
		
		// Call for the options
		function flot_options(optionOf){
			var options = {
					grid: {
						borderWidth:0,
						labelMargin:0,
						axisMargin:0,
						minBorderMargin:0
					},
					legend: {
						show: true,
						noColumns: 3,
					},
					series: {
						lines: {
							show: true,
							lineWidth: 0.07,
							fill: true
						}
					},
					xaxis: {
						show:true,
						mode: "time",
						tickFormatter: function (v, axis) {
							return nDate(v,"m/d");
						},
						labelWidth: 25,
						axisLabelUseCanvas: true,
						axisLabelFontSizePixels: 12,
						axisLabelFontFamily: "Verdana, Arial",
						axisLabelPadding: 10,
					},
					yaxis: {
						show:true,
						min: 0,
						max: null,
						labelWidth: 50,
						axisLabelUseCanvas: true,
						axisLabelFontSizePixels: 12,
						axisLabelFontFamily: "Verdana, Arial",
					},
					selection: {
						mode: "x"
					},	
					grid: {
						borderWidth: 1,
						borderColor: "#FFF",
						hoverable: true,
					}
				};
				
			if(optionOf == "cpu_plot"){
			
				//Appending options for cpu
				options.yaxis.tickFormatter = function (v) {
					if(v <= 1024)
						return Math.round(v) + " %";
				};
				options.legend.container = $("#legend_cpu");
			
			}else if(optionOf == "ram_plot"){
				
				//Appending options for ram
				options.yaxis.tickFormatter = function (v) {
					if(v <= 1024)
						return Math.round(v) + " MB";
					if(v > 1024 && v < (1024*1024))
						return Math.round(v /1024) + " GB";
					if(v > (1024*1024))
						return Math.round(v / (1024*1024)) + " TB"
				};
				options.legend.container = $("#legend_ram");
				
			}else if(optionOf == "disk_plot"){
			
				//Appending options for Disk
				options.yaxis.tickFormatter = function (v) {
					if(v <= 1024)
						return Math.round(v) + " GB";
					if(v > 1024 && v < (1024*1024))
						return Math.round(v /1024) + " TB";
				};
				options.legend.container = $("#legend_disk");
			
			}else if(optionOf == "inode_plot"){
			
				//Appending option for INodes
				options.yaxis.tickFormatter = "";
				options.legend.container = $("#legend_inode");
			
			}else if(optionOf == "io_read_plot" || optionOf == "io_write_plot"){
			
				//Appending option for INodes
				options.yaxis.tickFormatter = function (v) {
					if(v <= 1024)
						return Math.round(v) + " B/s";
					if(v > 1024 && v < (1024*1024))
						return Math.round(v /1024) + " KB/s";
					if(v > (1024*1024) && v < (1024*1024*1024))
						return Math.round(v / (1024*1024)) + " MB/s"
					if(v > (1024*1024*1024))
						return Math.round(v / (1024*1024*1024)) + " GB/s"
				};
				options.legend.container = (optionOf == "io_read_plot" ? $("#legend_io_read") : $("#legend_io_write"));
			
			}else if(optionOf == "ntw"){
			
				//Appending  option for Network
				options.yaxis.tickFormatter = function (v) {
					if(v <= 1024)
						return Math.round(v) + " B/s";
					if(v > 1024 && v < (1024*1024))
						return Math.round(v / 1024) + " KB/s";
					if(v > (1024*1024) && v < (1024*1024*1024))
						return Math.round(v / (1024*1024)) + " MB/s";
					if(v > (1024*1024*1024))
						return Math.round(v / (1024*1024*1024)) + " GB/s";
				};
				options.legend.container = $("#legend_ntw");
				
			}
				
			return options;
		};
			
		function change_monitor_tabs(id){
			$("#cpuinfo_win, #raminfo_win, #diskinfo_win, #ntwinfo_win, #ioinfo_win").hide();
			$("#"+id+"_win").show();
		};
		
		function ploter(id,yValues,xValues,hexvalues){

				function res_callback(tooltipItem, type){
					console.log(tooltipItem);
					if(type == "holder_ram"){
						return " "+((tooltipItem.raw)/1024).toFixed(2) + "GB";
					}
					if(type == "holder_cpu"){
						return " "+tooltipItem.raw.toFixed(2) + "%";
					}
					if(type == "holder_bandwidth"){
						return " "+tooltipItem.raw.toFixed(2) + "GB";
					}
				}

				new Chart(id, {
					type: "pie",
					data: {
					labels: xValues,
					datasets: [{
						backgroundColor: hexvalues,
						data: yValues
					}]
				},
				options: {
					responsive: false,
					maintainAspectRatio: false,
					plugins: { legend: { display: false},
						tooltip: {
							callbacks: {
								label: function(tooltipItem) {
									console.log("TOOLTIP :"+tooltipItem);
									return res_callback(tooltipItem, id);
								},
								title: function(tooltipItem) {
									return " "+tooltipItem[0].label;
								}
							}
						}
					}
				}
			});
		}

		$(document).ready(function(){
			cleartime = setTimeout(function(){
			   //window.location.reload(1);
			   refresh_stats();
			}, 30000);
			
			// Call the function to display RAM pie chart
			var data = ['.implode(', ', $values_ram).'];
			
			// Call the function to display CPU pie chart
			var data = ['.implode(', ', $values_cpu).'];
			//TODO set cpu values here document.ready
			var cpu_xvalues = JSON.parse(\''.$j_pie_cpu.'\');
			var cpu_yvalues = JSON.parse(\''.$j_pie_data.'\');
			var ram_xvalues = JSON.parse(\''.$j_pie_ram.'\');
			var bw_xvalues = JSON.parse(\''.$j_pie_bandwidth.'\');
			var cpu_hex = JSON.parse(\''.$j_pie_hex_color.'\');
			ploter("holder_cpu",cpu_xvalues,cpu_yvalues,cpu_hex);
			ploter("holder_ram",ram_xvalues,cpu_yvalues,cpu_hex);
			ploter("holder_bandwidth",bw_xvalues,cpu_yvalues,cpu_hex);


			
			// Call the function to display Bandwidth pie chart
			var data = ['.implode(', ', $values_bandwidth).'];
			
			manage_sparkline();
			
		}); 
		
		function refresh_stats(){
			
			$.ajax({
				url: window.location.href +"&api=json",
				success: function(resp){
				
					resp = JSON.parse(resp);
					var total_cpu = 0;
					var total_band = 0;
					var v_ram = [];
					var v_cpu = [];
					var v_bandwidth = [];
					var table_data = "";
					var tmp = "";
					var status_td = "";
					
					$.each(resp.vps_data, function(i, t){
					
						v_ram.push({"label" : "VPS ID : "+t.vpsid+" VPS Name : "+t.vps_name, data: parseFloat(t.used_ram)});
						i = i.replace("K_", "");
						total_cpu += parseFloat(t.used_cpu);
						v_cpu.push(parseFloat(t.used_cpu));
						
						total_band += parseFloat(t.used_bandwidth);
						v_bandwidth.push({"label" : "VPS ID : "+t.vpsid+" VPS Name : "+t.vps_name, data: parseFloat(t.used_bandwidth)});
							
						if(t.status == 1){
							tmp += "<td align=\"center\" id=\"spcpu_"+i+"\" ><div class=\"spcpu\">"+parseFloat(t.used_cpu)+","+(100 - t.used_cpu)+"</div><div class=\"small_txt\">"+parseFloat(t.used_cpu)+" %</div></td>";
							tmp += ((t.vps_ram_info) ? "<td align=\"center\" id=\"spram_"+i+"\" ><div class=\"spram\">"+parseInt(t.used_ram)+","+(parseInt(t.ram) - parseInt(t.used_ram))+"</div><div class=\"small_txt\">"+parseInt(t.used_ram)+" / "+parseInt(t.ram)+" MB</div></td>" : "<td align=\"center\" id=\"spram_"+i+"\" >N/A</td>");
							tmp += "<td align=\"center\" id=\"spdisk_"+i+"\"><div class=\"spdisk\">"+(t.used_disk)+","+(t.disk - t.used_disk)+"</div><div class=\"small_txt\">"+(t.used_disk.toFixed(2))+" / "+(t.disk)+" GB</div></td>";
							tmp += ((t.inode == "") ? "<td align=\"center\" id=\"spinode_"+i+"\"> N/A </td>" : "<td align=\"center\" id=\"spinode_"+i+"\"><div class=\"spinode\">"+t.used_inode+","+(t.inode - t.used_inode)+"</div><div class=\"small_txt\">"+t.used_inode+" / "+(t.inode)+"</div></td>");
								
							status_td = "<td align=\"center\" id=\"status_"+i+"\"><i class=\"fas fa-circle fa-circle-green\" title=\"'.$l['vps_stat_on'].'\" ></i></td>";
								
						}else if(t.status == 2){
							status_td = "<td align=\"center\" id=\"status_"+i+"\"><i class=\"fas fa-circle fa-circle-gray\" title=\"'.$l['vps_stat_suspend'].'\" ></i></td>";
							tmp += "<td colspan=\"4\" class=\"text-center\" id=\"nodata_"+i+"\">'.$l['no_data'].'</td>";
						}else{
							status_td = "<td align=\"center\" id=\"status_"+i+"\"><i class=\"fas fa-circle fa-circle-red\" title=\"'.$l['vps_stat_off'].'\" ></i></td>";
							tmp += "<td colspan=\"4\" class=\"text-center\" id=\"nodata_"+i+"\">'.$l['no_data'].'</td>";
						}

						if(t.speed_cap == "0" || t.speed_cap == 0 || t.speed_cap == null){
							speedCap = "<td align=\"center\"><span><i class=\"fas fa-circle fa-circle-red\" title=\"'.$l['vps_speed_cap_disabled'].'\" ></i></span></td>";
						}else{
							tmp_data = t.speed_cap.split(",");
							speedCap = "<td align=\"center\">"+tmp_data[1]+" KB <img src=\"'.$theme['images'].'admin/arrow_up.png\" title=\"'.$l['vps_upload_speed'].'\"><br>"+tmp_data[0]+" KB <img src=\"'.$theme['images'].'admin/arrow_down.png\" title=\"'.$l['vps_download_speed'].'\"></td>";
						}
							
						table_data += "<tr>";
						table_data += status_td;
						table_data += "<td id=\"vpsid_"+i+"\">"+t.vpsid+"</td>";
						table_data += "<td id=\"hostname_"+i+"\" tooltip=\""+t.hostname+"\" >"+wordwrapper(20,t.hostname)+" ("+t.vps_name+")</td>";
						table_data += tmp;
						table_data += "<td>";
						table_data += "<div class=\"spband\" align=\"center\" id=\"band_"+i+"\">";
						table_data += t.used_bandwidth+","+((t.bandwidth != "") ? (t.bandwidth - t.used_bandwidth).toFixed(2) : 9999999);
						table_data += "</div>";
						table_data += "<div class=\"small_txt\" align=\"center\" id=\"band2_"+i+"\">";
						table_data += t.used_bandwidth+"/"+((t.bandwidth != "") ? (t.bandwidth - t.used_bandwidth).toFixed(2) : "'.$l['unlimited'].'")+" GB";
						table_data += "</div>";
						table_data += "</td>";
						table_data += "<td align=\"center\" id=\"netin_"+i+"\">"+byte_convert(t.net_in, 2)+"</td>";
						table_data += "<td align=\"center\" id=\"netout_"+i+"\">"+byte_convert(t.net_out, 2)+"</td>";
						table_data += "<td align=\"center\" id=\"io_read_"+i+"\">"+byte_convert(t.io_read, 2)+"</td>";
						table_data += "<td align=\"center\" id=\"io_write_"+i+"\">"+byte_convert(t.io_write, 2)+"</td>";
						table_data += speedCap;
						table_data += "<td align=\"center\"><span onclick=\"show_graph("+t.vpsid+")\"><i class=\"fas fa-chart-bar fa-2x p-1 cursor-pointer\"></i></span></td>";
						table_data += "</tr>";
									
						tmp = "";
					});
					show_tooltip();
					var pie_data = resp.pie_data;
						
					// Handle Server Ram
					$.each(pie_data.server_ram, function(i, t){
						if(i == 0 && (t.used_ram != "")){
							v_ram.push({"label" : "Server '.$l['free'].'&nbsp;'.$l['ram'].'", data: parseFloat(t.ram - t.used_ram)});
								
						// DOM-0 RAM for XEN and XCP
						}else if(i == -1 && (t.used_ram != "")){
							v_ram.push({"label" : "Dom0 '.$l['used'].'&nbsp;'.$l['ram'].'", data: parseFloat(t.used_ram)});
							v_ram.push({"label" : "Dom0 '.$l['free'].'&nbsp;'.$l['ram'].'", data: (parseFloat(t.ram) - parseFloat(t.used_ram))});
						}
					});
						
					// Handle Server CPU
					if(pie_data.server_cpu != ""){
						v_cpu.push(parseFloat(pie_data.server_cpu.percent_free));
							
						if(total_cpu < pie_data.server_cpu.percent){
							v_cpu.pop();
							v_cpu.push(parseFloat(pie_data.server_cpu.percent) - parseFloat(total_cpu));
						}
					}
						
					// Handle Server Bandwidth
					if(pie_data.server_bandwidth != ""){
							
						v_bandwidth.push({"label" : "Server '.$l['used'].'", data: parseFloat(pie_data.server_bandwidth.used_gb)});
							
						var free = 0; // Server Free GB
						// Show Free bandwidth if there is any
						if(pie_data.server_bandwidth.limit_gb > (total_band + pie_data.server_bandwidth.used_gb)){
							free = parseFloat(pie_data.server_bandwidth.limit_gb) - (total_band + parseFloat(pie_data.server_bandwidth.used_gb));
							v_bandwidth.push({"label" : "Server '.$l['free'].'", data: free});
						}
					}
						
					$("#servers_list_table > tbody").html("");
						
					$("#servers_list_table > tbody").html(table_data);
						
					// Call the function to display RAM pie chart
						
					// Call the function to display CPU pie chart
					//TODO ajax call
					chartcpu = Chart.getChart("holder_cpu");
					if (chartcpu != undefined) {
						chartcpu.data.datasets[0].data = v_cpu;
						chartcpu.update();
					} 
				
					// Call the function to display Bandwidth pie chart
						
					manage_sparkline();
					
					setTimeout(function(){
					   //window.location.reload(1);
					   refresh_stats();
					}, 30000);
				}
				
				
			});
		}
		
		function manage_sparkline(){
		
			// CPU Sparklines
			$("#servers_list_table .spcpu").sparkline("html", {
															type:"pie",
															sliceColors: ["#6E85B7", "#c8d8ff"],
															tooltipClassname: "spPieToolTip jqstooltip",
															tooltipFormatter: function(a, b, fields){
																return "<div class=\'p-1\'>"+fields["value"]+" % "+(fields["offset"] == 0 ? "'.$l['used'].'" : "'.$l['free'].'")+"</div>";
															}
														}
													);
				
			// RAM Sparklines
			$("#servers_list_table .spram").sparkline("html", {
															type:"pie",
															sliceColors: ["#6E85B7", "#c8d8ff"],
															tooltipClassname: "spPieToolTip jqstooltip",
															tooltipFormatter: function(a, b, fields){
																return "<div class=\'p-1\'>"+fields["value"]+" MB "+(fields["offset"] == 0 ? "'.$l['used'].'" : "'.$l['free'].'")+" ("+fields["percent"].toFixed(2)+"%)</div>";
															}
														}
													);
				
			// Disk Sparklines
			$("#servers_list_table .spdisk").sparkline("html", {
															type:"pie",
															sliceColors: ["#6E85B7", "#c8d8ff"],
															tooltipClassname: "spPieToolTip jqstooltip",
															tooltipFormatter: function(a, b, fields){
																return "<div class=\'p-1\'>"+fields["value"].toFixed(2)+" GB "+(fields["offset"] == 0 ? "'.$l['used'].'" : "'.$l['free'].'")+" ("+fields["percent"].toFixed(2)+"%)</div>";
															}
														}
													);
																
			// Inode Sparklines
			$("#servers_list_table .spinode").sparkline("html", {
														type:"pie",
															sliceColors: ["#6E85B7", "#c8d8ff"],
															tooltipClassname: "spPieToolTip jqstooltip",
															tooltipFormatter: function(a, b, fields){
																return "<div class=\'p-1\'>"+fields["value"]+" "+(fields["offset"] == 0 ? "'.$l['used'].'" : "'.$l['free'].'")+" ("+fields["percent"].toFixed(2)+"%)</div>";
															}
														}
													);
																
			// Bandwidth Sparklines
			$(".spband").sparkline("html", {
										type:"pie",
										sliceColors: ["#6E85B7", "#c8d8ff"],
										tooltipClassname: "spPieToolTip jqstooltip",
										tooltipFormatter: function(a, b, fields){
											return "<div class=\'p-1\'>&nbsp;"+(fields["offset"] == 1 ? (fields["value"] == "9999999") ? a.values[0]+"/'.$l['unlimited'].'"+" GB"  : fields["value"]+" GB '.$l['free'].'" : fields["value"]+" GB '.$l['used'].'")+"("+((fields["offset"] == 1 && fields["value"] == "9999999") ? "0.01" : fields["percent"].toFixed(2))+" %)</div>";
										}
									}
								);
						
			$(".spcpu, .spram, .spdisk, .spinode, .spband").bind("sparklineClick", function(ev) {
				if(window.sparkClickClrTimer){
					 clearTimeout(window.sparkClickClrTimer);
				}	
				var elementPosition = $(ev.target).position();
				$(".jqstooltip").css({"left":(elementPosition.left+85)+\'px\'});
				$(".jqstooltip").css({"visibility": "visible"});
				window.sparkClickClrTimer = setTimeout(function(){ $(".jqstooltip").css({"visibility": "hidden"}); }, 3000);
			});
		
		}
			
		function byte_convert(bytes, round_upto = 0){
				
			// Is it in TBs
			if(bytes > (1024*1024*1024*1024)){
				return Math.round(bytes / (1024*1024*1024*1024), round_upto)+" TB";
			}
				
			// Is it in GBs
			if(bytes > (1024*1024*1024)){
				return Math.round(bytes / (1024*1024*1024), round_upto)+" GB";
			}
				
			// Is it in MBs
			if(bytes > (1024*1024)){
				return Math.round(bytes / (1024*1024), round_upto)+" MB";
			}
				
			// Is it in KBs
			if(bytes > 1024 && bytes < (1024*1024)){
				return Math.round(bytes /1024, round_upto)+" KB";
			}
				
			// Is it in GBs
			if(bytes <= 1024){
				return Math.round(bytes, round_upto)+" B";
			}
		}
		</script>
		<style>
		th{
			width:auto !important; padding:5px 5px !important;
			background:#eeeef0;
			vertical-align:middle !important;
		}
		</style>
		<div class="bg">
			<div class="row my-3 mx-auto">
				<div class="col-10">
				<h4 class="text-dark"><i class="fas fa-chart-area"></i> '.$l['page_head'].'</h4>
				</div>
			</div>';
			
			echo '<div class="row mx-auto w-100"><div class="col-sm-4"></div><div class="col-sm-4">';
			server_select();
			echo '</div></div>
			<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<div class="mx-auto d-flex justify-content-center">
							<canvas id="holder_cpu" align="center" style="width:150px; height: 150px"></canvas>
						</div>
						<div class="mx-auto d-flex justify-content-center">
							<span class="p-2 h5">'.$l['cpu_utilization'].'</span>
						</div>	
					</div>	
					<div class="col-sm-4">
						<div class="mx-auto d-flex justify-content-center">
							<canvas id="holder_ram" align="center" style="width:150px; height: 150px"></canvas>
						</div>	
						<div class="mx-auto d-flex justify-content-center">
							<span class="p-2 h5">'.$l['ram_utilization'].'</span>
						</div>	
					</div>	
					<div class="col-sm-4">
						<div class="mx-auto d-flex justify-content-center">
							<canvas id="holder_bandwidth" align="center" style="width:150px; height: 150px"></canvas>
						</div>	
						<div class="mx-auto d-flex justify-content-center">
							<span class="p-2 h5">'.$l['bandwidth_utilization'].'</span>
						</div>	
					</div>
			</div><br/>
			<div class="notice" align="left"><b>'.$l['note'].' : </b> &nbsp; '.$l['resources_note'].'</div>
			<br /> 
			<div class="row mx-auto w-100 mt-3">
				<div class="col-sm-12 col-lg-12 col-md-6 mb-3 p-0">';
					page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
				echo'
				</div>
			</div>
				<div class="mx-auto scrollbar-virt task_table">
					<table class="table table-hover tablesorter tasks_table" id="servers_list_table">
					<thead>
							<tr>
								<th >'.$l['status'].'</th>
								<th >'.getSortHeader($l['vpsid'], $sort_column, $sort_column_by, 'vpsid','55').'</th>
								<th >'.$l['hostname'].' (VID)</th>
								<th >'.getSortHeader($l['cpu'], $sort_column, $sort_column_by, 'cpu','40').'</th>
								<th >'.getSortHeader($l['ram'], $sort_column, $sort_column_by, 'ram','40').'</th>
								<th >'.getSortHeader($l['disk'], $sort_column, $sort_column_by, 'disk','40').'</th>
								<th >'.getSortHeader($l['inode'], $sort_column, $sort_column_by, 'inode','55').'</th>
								<th >'.getSortHeader($l['bandwidth'], $sort_column, $sort_column_by, 'bandwidth','80').'</th>
								<th >'.getSortHeader($l['net_in'], $sort_column, $sort_column_by, 'net_in','80').'</th>
								<th >'.getSortHeader($l['net_out'], $sort_column, $sort_column_by, 'net_out','65').'</th>
								<th >'.getSortHeader($l['io_read'], $sort_column, $sort_column_by, 'io_read','70').'</th>
								<th >'.getSortHeader($l['io_write'], $sort_column, $sort_column_by, 'io_write','70').'</th>
								<th >'.getSortHeader($l['speed_cap'], $sort_column, $sort_column_by, 'speed_cap').'</th>
								<th ></th>
							</tr>
						</thead>
						'.$table_data.'
					</table>
				</div>
				<div class="row mx-auto w-100 mt-5">
					<div class="col-sm-12 col-lg-12 col-md-6 mb-3 p-0">';
						page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
					echo'
				</div>
			</div>
		</div>'; // bg div End
		
		// Modal html for Individual VPS
		echo '<div id="dialog" style="display:none" class="modal fade">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header align-items-center" id="dialog-header"></div>
				<div class="modal-body">
					<div class="card m-3 p-3">
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-1"></div>
							<div class="col-sm-2 text-center">
								<a href="javascript:void(0);" class="tab pan-button" id="cpuinfo" onclick="change_monitor_tabs(this.id);">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
										<path d="M6 3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3zm0 2a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6zm2 2h4a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1zm1 2v2h2V9H9zM6 0a1 1 0 0 1 1 1v2a1 1 0 1 1-2 0V1a1 1 0 0 1 1-1zM1 5h2a1 1 0 1 1 0 2H1a1 1 0 1 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 9h2a1 1 0 1 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 13h2a1 1 0 0 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM6 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zm8-16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zM10 0a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1z"></path>
									</svg>
								</a>
								<label for="input text" class="help-block">'.$l['cpu'].'</label>
							</div>
							<div class="col-sm-2 text-center">
								<a href="javascript:void(0);" class="tab pan-button" id="raminfo" onclick="change_monitor_tabs(this.id);">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
										<path d="m14.95 7.879-.707-.707a1 1 0 0 1 1.414-1.415l.707.707 1.414-1.414-2.828-2.828L2.222 14.95l2.828 2.828 1.414-1.414L5.05 14.95a1 1 0 0 1 1.414-1.414L7.88 14.95l1.414-1.414-.707-.708A1 1 0 0 1 10 11.414l.707.707 1.414-1.414-1.414-1.414a1 1 0 0 1 1.414-1.414l1.415 1.414 1.414-1.414zM.808 13.536 13.536.808a2 2 0 0 1 2.828 0l2.828 2.828a2 2 0 0 1 0 2.828L6.464 19.192a2 2 0 0 1-2.828 0L.808 16.364a2 2 0 0 1 0-2.828z"></path>
									</svg>
								</a>
								<label for="input text" class="help-block">'.$l['ram'].'</label>
							</div>
							<div class="col-sm-2 text-center">
								<a href="javascript:void(0);" class="tab pan-button" id="diskinfo" onclick="change_monitor_tabs(this.id);">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
									<path d="M10 20C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zm0-2a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm7-8a6.99 6.99 0 0 1-2.89 5.666l-.53-.796L13 14a4.992 4.992 0 0 0 2-4 4.992 4.992 0 0 0-2-4l1.2-1.6A6.99 6.99 0 0 1 17 10zm-7 3a3 3 0 1 1 0-6 3 3 0 0 1 0 6zm0-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2z"/>
								</svg>
								</a>
								<label for="input text" class="help-block">'.$l['disk'].'/'.$l['inode'].'</label>
							</div>
							<div class="col-sm-2 text-center">
								<a href="javascript:void(0);" class="tab pan-button" id="ioinfo" onclick="change_monitor_tabs(this.id);">
								
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
								<path d="M.832 14A9.966 9.966 0 0 1 0 10C0 4.477 4.477 0 10 0s10 4.477 10 10a9.966 9.966 0 0 1-.832 4H.832zm16.916-2a8 8 0 1 0-15.497 0h15.497zM10 5a1 1 0 1 1 0-2 1 1 0 0 1 0 2zM5 9a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm10 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm-5-3a1 1 0 0 1 1 1v3a1 1 0 0 1-2 0V7a1 1 0 0 1 1-1z"/>
								</svg>
								</a>
								<label for="input text" class="help-block">'.$l['disk_io'].'</label>
							</div>
							<div class="col-sm-2 text-center">
								<a href="javascript:void(0);" class="tab pan-button" id="ntwinfo" onclick="change_monitor_tabs(this.id);">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
								<path d="M10 13.992a1 1 0 1 1 0-2 1 1 0 0 1 0 2zM7.894 11.44a1 1 0 0 1-1.788-.894 4.355 4.355 0 0 1 7.788 0 1 1 0 1 1-1.788.894 2.353 2.353 0 0 0-4.212 0zM4.8 8.595a1 1 0 0 1-1.6-1.2 8.503 8.503 0 0 1 13.6 0 .999.999 0 1 1-1.6 1.2 6.503 6.503 0 0 0-10.4 0zm-3.057-2.93A1 1 0 0 1 .257 4.329c4.843-5.377 13.13-5.813 18.512-.973.342.307.667.632.974.973a.999.999 0 1 1-1.486 1.338 10.91 10.91 0 0 0-.826-.826C12.871.74 5.847 1.108 1.743 5.666z"/>
								</svg>
								</a>
								<label for="input text" class="help-block">'.$l['header_ntw_speed'].'</label>
							</div>
						</div>

						<div class="row mx-auto w-100 my-3" id="by_month">
							<div id="prev_month" class="col-sm-4 "></div>
							<div id="month_holder2" class="col-sm-4 h5 m-0 text-center"></div>
							<div id="next_month" class="col-sm-4 d-flex justify-content-end"></div>	
						</div><br/>
						
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-12">
								<div class="notice" id="note_box" style="display: none;">
									<b>NOTE : </b>&nbsp; '.$l['no_data'].'&nbsp;'.$l['for'].'&nbsp;<span id="for_month"></span>
								</div>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="cpuinfo_win">
							<div class="col-sm-12">
								<div id="legend_cpu" class="legend_container"></div>
								<div id="cpu_plot" style="width:650px; height:400px;">
								</div>
							</div>
						</div>
						
						<div id="raminfo_win" style="display:none" class="row mx-auto w-100 my-3">
							<div class="col-sm-12">
								<div id="legend_ram" class="legend_container"></div>
								<div id="ram_plot" style="width:650px; height:400px;">
								</div>
							</div>
						</div>
						
						<div class="row mx-auto w-100 my-3" id="diskinfo_win" style="display:none">
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-12">
									<div id="legend_disk" class="legend_container"></div>
									<div id="disk_plot" style="width:650px; height:400px;">
									</div>
								</div>
							</div>	
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-12" >
									<div id="legend_inode" class="legend_container"></div>
									<div id="inode_plot" style="width:650px; height:400px;">
									</div>
								</div>
							</div>	
						</div>
						
						<div id="ioinfo_win" style="display:none;" class="form-group">
							<div class="col-sm-12">
								<div id="legend_io_read" class="legend_container"></div>
								<div id="io_read_plot" style="width:650px; height:400px;">
								</div>
							</div>
							<div class="col-sm-12">
								<div id="legend_io_write" class="legend_container"></div>
								<div id="io_write_plot" style="width:650px; height:400px;">
								</div>
							</div>
						</div>
						
						<div id="ntwinfo_win" style="display:none;" class="row mx-auto w-100 my-3">
							<div class="col-sm-12">
								<div id="legend_ntw" class="legend_container"></div>
								<div id="ntw" style="width:650px; height:400px;">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>	
	</div>';
	}
	
	softfooter();
}

//Function to convert given Bytes to KB, MB, GB or TB
function byte_convert($bytes, $round_upto = 0){
	
	// Is it in TBs
	if($bytes > (1024*1024*1024*1024)){
		return round($bytes / (1024*1024*1024*1024), $round_upto)." TB";
	}
	
	// Is it in GBs
	if($bytes > (1024*1024*1024)){
		return round($bytes / (1024*1024*1024), $round_upto)." GB";
	}
	
	// Is it in MBs
	if($bytes > (1024*1024)){
		return round($bytes / (1024*1024), $round_upto)." MB";
	}
	
	// Is it in KBs
	if($bytes > 1024 && $bytes < (1024*1024)){
		return round($bytes /1024, $round_upto)." KB";
	}
	
	// Is it in GBs
	if($bytes <= 1024){
		return round($bytes, $round_upto)." B";
	}
}
	
?>