<?php

//////////////////////////////////////////////////////////////
//===========================================================
// volume.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Pawan Battu
// Date:       December 2020
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if (!defined('VIRTUALIZOR')) {

	die('Hacking Attempt');
}

function volumes_theme()
{

	global $theme, $globals, $kernel, $user, $l, $error, $storage_disk, $storage_servers, $servers, $servergroups, $done, $storages, $cluster, $vpses, $users, $format_type;

	softheader($l['<title>']);
	echo '
<div class="bg" >
<div class="row my-3 mx-auto">
	<div class="col-10">
		<h4 class="text-dark"><i class="fas fa-hdd"></i> ' . $l['heading'] . '</h4>
	</div>
	<div class="col-2 d-flex align-items-center justify-content-end text-right">
		<span class="mr-2 icon-fix d-flex align-items-center justify-content-center">
		<a href="'.$globals['docs'].'volume/" target="_blank" tooltip="'.$l['wiki_help'].'"><i class="fas fa-question text-always-white" ></i></a>
		</span>&nbsp;
		<a href="javascript:showsearch();" class="search_btn py-1 text-light icon-fix d-flex align-items-center justify-content-center" id="search_btn"><i class="fas fa-search"></i></a>
		</span>
	</div>
</div>';

	error_handle($error);

	// Is it offline ?
	$hypervisor_status = $cluster->statewise($globals['server']);
	if ($hypervisor_status == 0 || $hypervisor_status == 2) {

		echo '<div class="e_notice"><b>' . $l['note'] . ' : </b> &nbsp; ' . $l['server_status_' . $hypervisor_status] . '</div>';
	} else {
		// Check which stid belongs to which servers
		foreach ($storage_disk as $p => $q) {
			if ($q['serid'] == -1) {
				$ipgp[$q['did']][] = $l['all_servers'];
			} else {
				foreach ($servers as $x => $y) {
					if ($q['serid'] == $y['serid'] || $q['sgid'] == $y['sgid']) {
						$ipgp[$q['did']][] = $y['server_name'];
					}
				}
			}
		}

echo '<script language="javascript" type="text/javascript">
var list_vpses = new Object();

';
echo '
function add_vol(){
			
	var params = $("#addvolform").serialize();

	$("#progress_bar").show();
	$("#createvol").modal("hide");
	$.ajax({
		type: "POST",
		url: "' . $globals['index'] . 'act=volumes&api=json",
		data:params+"&addvolume=1",
		dataType : "json",
		success: function(data){

			if("error" in data) {
				var err = "";
				$.each(data["error"], function(key, value) {
					err += value + "<br>";
				});
				showalert(err ,"1");
				$("#progress_bar").hide();
				return false;
			}

			if("voladd_done" in data["done"]){
				setTimeout(function(){ showalert("'.$l['started_background'].'");
					$("#alert-modal").on("hidden.bs.modal", function (e) {
					location.reload(true);
					});
				return; } ,200);
			}
		
		},
		complete: function(data) {
			$("#progress_bar").hide();
		}
	});
	
	return false;
}

function show_addvol_window(){
	$("#createvol").modal("show");
	$("#newserid").val("-1").change();
	$("#vpsid").empty();
}

function getvps_list(el){

	var serid_val = $(el).val();
	serid_val = serid_val || 0;

	$("#vps_loader").show();

	$("#vpsid").empty();

	if(serid_val == "-1"){
		return false;
	}

	$.ajax({
		type: "POST",
		url: "' . $globals['index'] . 'act=volumes&api=json",
		data : {
			serid_val: serid_val,
		},
		dataType : "json", 
		success: function(data){
			
			$("#vps_loader").hide();

			// Are there any errors ?
			if(typeof(data["error"]) != "undefined"){
				var errors = "";
				for(x in data["error"]){
					errors = errors + data["error"][x];
				}
				showalert(errors,"1");
				return false;
			}
		
			var vpsdata = data["store_vps_data"];

			list_vpses = vpsdata["vpses"];

			let vpses = "<option value=\"0\">' . $l['vps_id'] . '</option>";
			let storage = "";

			$.each(vpsdata["vpses"], function(id, vps){
				vpses += "<option value="+id+">"+vps["vps_name"]+" - "+vps["hostname"]+"</option>";
			});

			$("#vpsid").html(vpses);    

			$.each(vpsdata["newstorage"], function(k, v) {
			
				var label = "";
				if(empty(v["oversell"])){
					label="' . $l['free'] . '";
				}else{
					label="";
				}

				storage += "<option value="+v["st_uuid"]+">"+v["name"]+"&nbsp;("+v["free"]+" GB "+label+")";
			
			});
				
			$("#storage_disk").html(storage);     

			show_tooltip();
			//ajax user handling 
			load_ajax_user("uid", "' . $globals['index'] . 'act=vpsrestore&api=json&load_ajax_user=1");

		},
		error: function(data) {
			$("#vps_loader").hide();
			//alert(data.description);
			return false;
		}
	});       

}


function editvol(did, action, vpsid = 0, header=""){
	
	var action_arr = { "1": "attach", "2": "detach", "3": "resize" };

	if(!action_arr[action]){
		showalert("'.$l['no_action'].'","1");
		return false;
	}
	
	$.ajax({
		type: "POST",
		url: "' . $globals['index'] . 'act=volumes&api=json",
		data : {
			disk_did: did,
			action: action,
			vpsid: vpsid
		},
		dataType : "json", 
		success: function(data){
			
			// Are there any errors ?
			if(typeof(data["error"]) != "undefined"){
				
				var errors = "";
				for(x in data["error"]){
				
					errors = errors + data["error"][x];
				}
				showalert(errors,"1");
				
				return false;
			}

			list_vpses = data["disk_data"]["vps"];
			$("#modal_header").html(header);
			$("#todo").val(data["disk_data"]["action"]);
			$("#disk_did_action").val(data["disk_data"]["disk"]["did"]);
			
			if(!empty(data["disk_data"]["vps"])){
				let vpses = "<option value=0></option>";
				$.each(data["disk_data"]["vps"], function(k, v) {
				 	vpses += "<option value="+v["vpsid"]+">"+v["vps_name"]+ "-" +v["hostname"]+"</option>";
			
				});
				
				$("#vpsid_attach").html(vpses);  
			}else{
				$("#vpsid_attach").css("display", "none");
			}  

			let servers = "";
			$.each(data["disk_data"]["servers"], function(k, v) {
			
				servers += "<option value="+v["serid"]+">"+v["server_name"]+"</option>";
			});

			$("#edit_newserid").html(servers);    
			
			$("#disk_name").val(data["disk_data"]["disk"]["disk_name"]);

			$(".edit_disk_size").css("visibility", "hidden");

			if(data["disk_data"]["action"] == 3){
		
				$(".edit_disk_size").css("visibility", "visible");
				$("#edit_size").val(data["disk_data"]["disk"]["size"]);
			}

			$("#resize_vps").show();

			if(action == 3){
				$("#resize_vps").hide();	
			}

			if(action == 2){
				$("#vpsid_attach").val(vpsid).change();
				todo_vol();
			}else{
				$("#edit_modal").modal({keyboard: true});
				$("#edit_modal").modal({show:true});
				show_tooltip();
			}
		},
		error: function(data) {
			
			//alert(data.description);
			return false;
		}
	});  

}

function Delstorage(stid, ele){

	stid = stid || 0;
	
	// List of ids to delete
	var storage_list = new Array();
	
	if(stid < 1){
		
		if($(ele).parent().prev().find("select").val() != 1){
			showalert("' . $l['no_action'] . '","1");
			return false;
		}
		
		$(".ios:checked").each(function() {
			storage_list.push($(this).val());
		});
		
	}else{
		
		storage_list.push(stid);
		
	}
	
	if(storage_list.length < 1){
		showalert("' . $l['nothing_selected'] . '","1");
		return false;
	}

	showalert("' . $l['del_conf'] . '" ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			var finalData = new Object();
			finalData["delete"] = storage_list.join(",");
			
			$("#progress_bar").show();
			
			$.ajax({
				type: "POST",
				url: "' . $globals['index'] . 'act=volumes&api=json",
				data : finalData,
				dataType : "json",
				success: function(data){
					$("#progress_bar").hide();
					if("done" in data){
						setTimeout(function(){showalert("' . $l['action_completed'] . '");$("#alert-modal").on("hidden.bs.modal", function (e) {
						location.reload(true);
						});} ,200);
					}
					if("error" in data){
						setTimeout(function(){showalert(data["error"],"1");
						$("#alert-modal").on("hidden.bs.modal", function (e) {
						location.reload(true);
						});} ,200);
					
					if("fatal_error_text" in data){
						setTimeout(function(){showalert(data["fatal_error_text"],"1");} ,200);
					}
					
					}
				},
				error: function(data) {
					$("#progress_bar").hide();
					//alert(data.description);
					return false;
				}
			});
		}
	});
	return false;
};


function todo_vol(){

	let serid = $("#edit_newserid").val();
	let action = $("#todo").val();
	let vpsid = $("#vpsid_attach").val();
	let disk_did = $("#disk_did_action").val();
	let disk_size = $("#edit_size").val();
	
	var action_arr = { "1": "attach", "2": "detach", "3": "resize" };

	if(!action_arr[action]){
		showalert("'.$l['no_action'].'","1");
		return false;
	}

	$("#progress_bar2").show();
	$("#load_"+disk_did).show();
	
	$.ajax({
		type: "POST",
		url: "' . $globals['index'] . 'act=volumes&api=json",
		data : {
			e_todo: action,
			disk_did_action: disk_did,
			e_serid: serid,
			e_vpsid: vpsid,
			e_disk_size: disk_size
		},
		dataType : "json", 
		success: function(data){
			$("#load_"+disk_did).hide();
			$("#progress_bar2").hide();
			// Are there any errors ?
			if(typeof(data["error"]) != "undefined"){
				var errors = "";
				for(x in data["error"]){
					errors = errors + data["error"][x] + "<br>";
				}
				showalert(errors,"1");
				return false;
			}

			if("action_done" in data["done"]){
				setTimeout(function(){ showalert("'.$l['action_completed'].'");
					$("#alert-modal").on("hidden.bs.modal", function (e) {
					location.reload(true);
					});
				return; } ,200);
			}
			
		},
		error: function(data) {
			$("#progress_bar2").hide();
			//alert(data.description);
			return false;
		}
	});  


}

function check_guest_agent(vpsid){

	if(empty(vpsid)){
		return false;
	}

	if(empty(list_vpses[vpsid])){
		showalert("'.$l['no_vps'].'",1);
		return false;
	}

	let data = JSON.parse(list_vpses[vpsid]["data"]);

	if(empty(data["enable_guest_agent"])){
		showalert("'.$l['cant_mount_enable_guest_agent'].'",1);
	}

}

</script>
<div id="showsearch" class="mt-3" style="display:' . (optREQ('search') || (!empty($storage) && !empty($globals['showsearch'])) ? "" : "none") . ';">
<br>
<form accept-charset="' . $globals['charset'] . '" name="volumes" method="GET" action="" class="form-horizontal">
<input type="hidden" name="act" value="volumes">
		
<div class="form-group_head">
  <div class="row mx-auto w-100">
	<div class="col-sm-4">
		<label>' . $l['sbyname'] . '</label>
		<input type="text" class="form-control" name="name" id="name" size="30" value="' . REQval('name', '') . '"/>
	</div>
	<div class="col-sm-4">
		<label>' . $l['sbypath'] . '</label>
		<input type="text" class="form-control" name="path" id="path" size="30" value="' . REQval('path', '') . '" />
	</div>
    <div class="col-sm-4">
		<label>' . $l['sbyemail'] . '</label>
		<input type="text" class="form-control" name="user_email" id="user_email" size="30" value="' . REQval('user_email', '') . '" />
	</div>
  </div>
  <div class="row mx-auto w-100 my-2">
  	<div class="col-sm-12 text-center"><button type="submit" name="search" class="go_btn mt-2" value="Search"/>' . $l['search'] . '</button></div> 
  </div>
</div>
</form>
</div>';

		if (!empty($done)) {
			show_alert($l['saved']);
			//echo '<div class="notice"><b>NOTE : </b>&nbsp; '..'</div>';
		}

		if (empty($storage_disk)) {
			optREQ('search') ? show_alert($l['no_res'], "2") : show_alert($l['no_backupservers'], "2");
			echo '<div class="notice"><b>'.$l['note'].' : </b>&nbsp; ' . $l['no_volumes'] . '</div>';
		} else {
			echo '<div class="row mx-auto w-100 mt-3">
	    <div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">';
			page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
			echo '
	    </div>
	    <div class="col-sm-4 col-lg-4 col-md-6 text-right mb-3">
		    <div class="bottom-menu float-right w-100">
                <div class="row my-auto">
                    <div class="p-0">
                        <label>' . $l['with_selected'] . '</label>
                    </div>
                    <div class="col p-0">
					    <select name="storage_task_select" id="storage_task_select" class="custom-select">
						    <option value="0">---</option>
						    <option value="1">' . $l['ms_delete'] . '</option>
					    </select>
                    </div>
                    <div class="pl-2">
					    <input type="submit" id ="storage_submit" class="go_btn" name="storage_submit" value="' . $l['go'] . '" onclick="Delstorage(0, this); return false;">
                    </div>
                </div>
		    </div>
	    </div>
        
</div>
<form accept-charset="' . $globals['charset'] . '" name="multi_storage" id="multi_storage" method="post" action="" class="form-horizontal">
<div class="w-100 mx-auto sticky">
'.get_num_records(count($storage_disk)).'
<table class="table table-hover tablesorter">
<tr>
	<th align="center" class="min_width">' . $l['st_id'] . '</th>
	<th align="center" width="15%">' . $l['st_name'] . '</th>
	<th align="center">' . $l['st_servers'] . '</th>
	<th align="center">' . $l['st_mnt'] . '</th>
	<th align="center">' . $l['st_type'] . '</th>
	<th align="center">' . $l['st_path'] . '</th>
	<th align="center">' . $l['st_size'] . '</th>
	<th align="center">' . $l['st_vm'] . '</th>
	<th align="center">' . $l['st_user'] . '</th>
	<th colspan="3">' . $l['manage'] . '</th>
	<th class="z-index-1 min_width">
		' . get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all') . '
	</th>
</tr>';
			foreach ($storage_disk as $k => $v) {
				echo '<tr>
	<td>' . $v['did'] . '</td>
	<td><div class="d-flex">' . $v['disk_name'] . '<div class="loader ml-2" id="load_'.$v['did'].'" style="display:none;"></div></div></td>
	<td>' . @implode(", ", $ipgp[$v['did']]) . '</td>
	<td>' . $v['mnt_point'] . '</td>
	<td>' . storage_type_text($v['type']) . '</td>
	<td><span class="text-monospace font-weight-bold">' . $v['path'] . '</span></td>
	<td>' . $v['size'] . ' GB</td>
	<td>' . $v['vpsid'] . '</td>
	<td><span class="userflare">' . $v['user_email'] . '</span></td>
	<td>';

		if (empty($v['vpsid'])) {
			echo '<a href="javascript:void(0);" onclick="return editvol(' . $k . ', 1, ' . (!empty($v['vpsid']) ? $v['vpsid'] : 0) . ', \''. $l['vol_edit'] .'\');" title="' . $l['attach_vol'] . '"><i class="fas fa-link text-warning pr-2"></i></a>';
		} else {
			echo '<a href="javascript:void(0);" onclick="return editvol(' . $k . ', 2, ' . (!empty($v['vpsid']) ? $v['vpsid'] : 0) . ', \''.$l['detach_vol'].'\');" title="' . $l['detach_vol'] . '"><i class="fas fa-unlink text-warning pr-2"></i></a>';
		}
		echo '
	</td>
	<td><a href="javascript:void(0);" onclick="return editvol(' . $k . ', 3, ' . (!empty($v['vpsid']) ? $v['vpsid'] : 0) . ', \''.$l['resize_vol'].'\');" title=' . $l['resize_vol'] . '><i class="fas fa-expand-arrows-alt text-warning pr-2" ></i></a></td>
	<td><a href="javascript:void(0);" onclick="return Delstorage(' . $k . ');" title="Delete"><i class="fas fa-trash text-danger"></i></a></td>
	<td width="20" valign="top" align="center">
		' . get_checkbox('storage_list[]', '', '', array('chk_it' => 0), $k) . '
	</td>
	</tr>';
			}
			echo '</table>
</div>';
			echo '<div class="row mx-auto w-100 mt-5">
	<div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">';
			page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
			echo '
	</div>
	<div class="col-sm-4 col-lg-4 col-md-6 text-right mb-3">
		<div class="bottom-menu float-right w-100">
            <div class="row my-auto">
                <div class="p-0">
                    <label>' . $l['with_selected'] . '</label>
                </div>
                <div class="col p-0">
					<select name="storage_task_select" id="storage_task_select" class="custom-select">
						<option value="0">---</option>
						<option value="1">' . $l['ms_delete'] . '</option>
					</select>
                </div>
                <div class="pl-2">
					<input type="submit" id ="storage_submit" class="go_btn" name="storage_submit" value="' . $l['go'] . '" onclick="Delstorage(0, this); return false;">
                </div>
            </div>
		</div>
	</div>
</div>
</form>
<div id="progress_bar" style="display:none;">
	<br />
	<center>
		<font id="progress_txt" size="4">' . $l['action_msg'] . '</font>
	</center>
	<div class="my-2" align="center">
		<div class="progress w-50">
			<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100">
			</div>
		</div>
	</div>
	<center>
		' . $l['notify_msg'] . '
	</center>
</div>
<center>
<a href="javascript:show_addvol_window();" class="link_btn">'.$l['add_vol'].'</a>
</center>
</div><br>';
		}
		echo '
<!--Volume Edit modal Start-->

<div class="modal fade" role="dialog" id="edit_modal">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header text-center" id="edit_modal_head">		
				<span class="fhead text-always-white" id="modal_header"></span>
				<button class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body" id="edit_modal_body" >
			<div class="card p-3 m-2">
				<form id="editvolform" action="" method="post" >
					<div id="form-container">
						<input type="hidden" id="todo" name="todo" value="" />
						<input type="hidden" id="disk_did_action" name="disk_did_action" value="" />
			   			<div class="row mx-auto w-100 my-3">
				   			<div class="col-sm-4">
					   			<label class="control-label">' . $l['vs_server'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['edit_exp_server'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
				   			</div>
				   			<div class="col-sm-6">
				   				<select name="edit_newserid" class="virt-select edit_newserid" id="edit_newserid">
					   			</select>
								<div class="loader mt-1 ml-2" style="display:none;" id="vps_loader"></div>
				   			</div>
			   			</div>
			   			<div class="row mx-auto w-100 my-3" id="resize_vps">
				   			<div class="col-sm-4">
					   			<label class="control-label">' . $l['vps'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['edit_vps_exp']  . '"><i class="fas text-primary fa-info-circle"></i></a></label>
				   			</div>
				   			<div class="col-sm-6" id="td_vpsid">
					   			<div class="select_vps">
						   			<select name="vpsid_attach" id="vpsid_attach" class="custom-select virt-select" onchange="check_guest_agent(this.value)">
								
									</select>
					   			</div>
				   			</div>
			  			</div>
			   			<div class="row mx-auto w-100 my-3">
							<div class="col-sm-4">
						   		<label class="control-label">' . $l['vol_name'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['vol_name_edit_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
					   		</div>
					   		<div class="col-sm-6 disks">
								<input class="form-control size" type="text" name="disk_name" id="disk_name" disabled="disabled">
					   		</div>
				   		</div>
			   			<div class="row mx-auto w-100 my-3 edit_disk_size" style="visibility:hidden;">
							<div class="col-sm-4"> 
								<div class="d-flex align-items-center">
									<label class="control-label">' . $l['vol_space'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['e_vol_space_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
							</div> 
							<div class="col-sm-6"> 
								<input class="form-control edit_size" type="number" name="edit_size" id="edit_size" step="0.001" size="30">
							</div> 
			   			</div>
			   			<br /><br />
			   			<center><input class="go_btn" value="' . $l['vol_submit'] . '" type="button" onclick="todo_vol();"></center>
			   		</div>
			   		<div id="progress_bar2" style="display:none;"> 
					<br /> 
					<center>
					<font id="progress_txt" size="4">' . $l['action_msg'] . '</font> 
					</center> 
					<div class="my-2" align="center">
						<div class="progress w-50"> 
							<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100"> 
						</div> 
					</div> 
				</div>
				<center>
					' . $l['notify_msg'] . ' 
				</center> 
				<br>
			</div> 
			</form>
			</div>
			</div>
		</div>
	</div>
</div>

<!--Volume Edit modal END-->

<!--Volume creation modal start-->

<div class="modal fade" id="createvol">
<div class="modal-dialog modal-lg">
	<div class="modal-content">
		<div class="modal-header d-flex align-items-center">
			<span class="modal-title"><label class="control-label">' . $l['add_volume_disk'] . '</label></span>
			<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
		</div>
		<div class="modal-body" id="createvol_body">
		<div class="card m-3 p-2">
		<form id="addvolform" action="" method="post" onsubmit="return add_vol()">
			
			<div id="form-container">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<label class="control-label">' . $l['vs_server'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['exp_server'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6">
					<select id="newserid" name="newserid" class="virt-select newserid" onchange="getvps_list(this);">';
						echo '<option value="-1" selected="selected">'.$l['select_server'].'</option>';
						foreach ($servers as $k => $v) {

							$multi_virt = str_replace(' ', '_', $servers[$k]['virt']);
							echo '<option value = ' . $servers[$k]['serid'] . ' data-virt=' . $multi_virt . '>' . $servers[$k]['server_name'] . ' (' . $servers[$k]['ip'] . ')</option>';
						}
						echo '
					</select>
						<div class="loader mt-1 ml-2" style="display:none;" id="vps_loader"></div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<label class="control-label">' . $l['vps'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['vs_user_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6" id="td_vpsid">
						<div class="">
							<select name="vpsid" id="vpsid" class="custom-select virt-select" onchange="check_guest_agent(this.value)">
								<option value="0">' . $l['vps_id'] . '</option>';
								foreach ($vpses as $k => $v) {
									echo '<option value=' . $k . '>' .$v['vps_name']. ' - ' .$v["hostname"] . '</option>';
								}
							echo '
							</select>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<label class="control-label pt-1">' . $l['vol_space'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['vol_space_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 disks">
						<div class="row">
							<div class="col-sm-4 pt-1" id="size_div"> 
								<input class="form-control size" type="number" name="size" id="hdd_0" step="0.001" size="30">
							</div>
							<div class="col-sm-8 pt-1" id="disk_div">
								<select class="custom-select st_uuid" id="storage_disk" name="st_uuid">';
								foreach ($storages as $storage) {
									echo '<option value="' . $storage['st_uuid'] . '">' . $storage['name'] . '&nbsp;(' . $storage['free'] . ' GB ' . (empty($storage['oversell']) ? $l['free'] : $l['oversell_free']) . ')</option>';
								}
								echo '</select>
							</div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<label class="control-label">' . $l['vol_name'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['vol_name_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6 disks">
						<input class="form-control size" type="text" name="disk_name" id="disk_name">
					</div>
				</div>
				
				<div class="row mx-auto w-100 my-3 mount_point_div" id="mount_point_div">
					<div class="col-4">
						<label class="control-label">' . $l['mount_volume'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['mount_volume_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6">
						<input class="form-control mnt_point" type="text" name="mnt_point" id="mnt_point">
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 format_type_div" id="format_type_div">
					<div class="col-4">
						<label class="control-label">' . $l['format_type'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['format_type_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6">
					<select class="custom-select virt-select" name="format_type" id="format_type" ">';
						foreach ($format_type as $k => $v) {
							echo '<option value="' . $v . '" >' . $v . '</option>';
						}
					echo '</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 format_primary_div" id="format_primary_div">
					<div class="col-4">
						<label class="control-label">' . $l['attach_volume'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['attach_volume_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-6">
						' . get_checkbox('attach', '', 'attach', array('chk_it' => 1, 'val' => 1)) . '
					</div>
				</div>
				<br /><br />
				<center>	<input class="go_btn" value="' . $l['create_vol'] . '" type="submit"></center>
				</div>
				<div id="progress_bar3" style="display:none;"> 
				<br /> 
				<center>
					<font id="progress_txt" size="4">' . $l['action_msg'] . '</font> 
				</center>
				<div class="my-2" align="center">
					<div class="progress w-50"> 
						<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100"> </div> 
					</div> 
				</div>
				<center>
					' . $l['notify_msg'] . ' 
				</center> 
				<br>
			</div> 
		</form>
		</div>
	</div>
</div>

<!--Volume creation modal End-->

</div></div>';
		
		echo '</div>';
		softfooter();
	}
}
