<?php

//////////////////////////////////////////////////////////////
//===========================================================
// servers_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function getSortHeader($header_name, $column ,$size = 90){
	
	global $theme, $globals;

		$link = $globals['index'].'act=servers&sortcolumn='.$column;
		$str = '<div class="d-inline-flex align-items-center" style="width:'.$size.'px;">
			<div class="mr-2"> 
				<span class="" >'.$header_name.'</span>
			</div>
			<span class="sorter">
				<i class="fas fa-sort-up" onclick=sort_servers_entry("'.$link.'&orderby=asc"); style="cursor: pointer;" ></i><br>
				<i class="fas fa-sort-down" onclick=sort_servers_entry("'.$link.'&orderby=desc"); style="cursor: pointer;"></i>
			</span>
		</div>';
		
		return $str;
}

function servers_theme(){

global $theme, $globals, $kernel, $user, $l, $cluster, $servers, $servs, $error, $done, $force_delete, $servergroups, $distros, $remove_ha, $delete, $servers_data, $server_cached;

softheader($l['<title>']);

echo '
<div class="bg">
<div class="row my-3 mx-auto">
	<div class="col-10">
		<h4 class="text-dark"><i class="icon icon-servers"></i> '.$l['page_head'].'</h4>
	</div>
	<div class="col-2 text-right d-flex align-items-center justify-content-end">
		<span class="search_btn icon-fix d-flex align-items-center justify-content-center"><a href="javascript:showsearch();"><i class="fas fa-search text-light"></i></a></span>
	</div>
</div>

';

error_handle($error);


if(!empty($done)){
	show_alert($l['done']);
}

if(!empty($force_delete) && empty($done)){
	echo '<div class="notice"><a href="'.$globals['ind'].'act=servers&force='.$force_delete.'&remove_ha='.(!empty($remove_ha) ? '1' : 0).'"><span class="text-center">'.$l['force_unslave'].'</span></a><br> <span class="text-center">'.$l['ha_force_unslave_warn'].'</span></div>';
	return;
}

if(!empty($remove_ha) && empty($done)){
	$link = $globals['ind'].'act=servers&delete='.$delete.'&remove_ha=';
	echo '<div class="notice"><span class="text-center">'.$l['ha_remove_warning'].'</span><center><input type="button" value="'.$l['yes'].'" class="link_btn" onclick="window.location =\''.$link.'1\';">&nbsp;&nbsp;<input type="button" value="'.$l['no'].'" class="link_btn" onclick="window.location =\''.$link.'0\';"></center></div>';
	return;
}
	
echo '
<script src="'.$theme['url'].'/js/chart.js"> </script>
<script language="javascript" type="text/javascript"><!-- // --><![CDATA[

function mouse_over(el){
	el.className = "server_over";
	el.onmouseout = function(){el.className="";}
};

function pie_ploter(xValues, yValues, id, per_name, per_value, uptime = "", serid = ""){
	hexvalues = ["#515dbc","#eaa32f","#1D1CE5","#395144","#FF8787","#2192FF"];
	new Chart(id, {
			type: "pie",
			data: {
				labels: xValues,
				datasets: [{
					backgroundColor: hexvalues,
					data: yValues
				}]
			},
			options: {
				responsive: false,
				maintainAspectRatio: true,
				plugins: { 
						legend: { display: false}, 
						tooltip: { enabled: false, 
								external: externalTooltipHandler
						}
	 			}
			}
		});

		if(per_value != undefined){
			$("#"+per_name).html(per_value+"%");
		}

		if(!empty(uptime) && uptime != "-- / --"){
			var uptime_array = uptime.split(",");
			$("#uptime_"+serid).html(uptime_array[0]+"-"+uptime_array[1]);
		}else{
			$("#uptime_"+serid).html(uptime);
		}

}

function pie_updater(id,yValues,per_name,per_value,uptime = "",i = ""){
	var chart = Chart.getChart(id);
	if (chart != undefined) {
		chart.data.datasets[0].data = yValues;
		chart.update();
		$("#"+per_name).html(per_value+"%");
	} 
	if(!empty(uptime)){
		var uptime_array = uptime.split(",");
		$("#uptime_"+i).html(uptime_array[0]+"-"+uptime_array[1]);
	}
}

function sort_servers_entry(link){

	var server_ip_value = $("#serverip").val();
	var server_name_value = $("#servername").val();
	var p_type_id = $("#ptypeid").val();

	if(!empty(server_ip_value)){
		link += "&serverip="+server_ip_value;
	}
	
	if(!empty(server_name_value)){
		link += "&servername="+server_name_value;
	}

	if(!empty(p_type_id)){
		link += "&ptype="+p_type_id;
	}

	window.location.href = link;
	
}

function conf_del(id){
	showalert("'.$l['conf_del'].'" ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			window.location.href="'.$globals['ind'].'act=servers&delete="+id;
		}
	});
};

function sync_server(id){
	var finalData = new Object();
	finalData["sync_serid"] = id;
	var htm = $("#sync_td_"+id).html();
	$("#sync_td_"+id).html(\'<div class="loader"></div>\');
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=servers&api=json",
		data : finalData,
		dataType : "json",
		success: function(data){
			$("#sync_td_"+id).html(htm);
			if("error" in data){
				errors = "";
				for(x in data["error"]){
					errors = errors + data["error"][x]+ "<br>";
				}
				showalert(errors, 1);
			}else{
				showalert("'.$l['sync_done'].'");
			}
		}
	});
};

function lockServer(serid ,ele){

	var action = $(ele).parent().prev().find("select").val();
	
	serid = serid || 0;
	
	// List of server ids to lock
	var server_list = new Array();
		
	if($(ele).parent().prev().find("select").val() == 0){
		showalert("'.$l['no_action'].'","1");
		return false;
	}
	
	$(".ios:checked").each(function() {
		server_list.push($(this).val());
	});
	
	if(server_list.length < 1){
		showalert("'.$l['nothing_selected'].'","1");
		return false;
	}
	
	ServerAlert(action, server_list);

	return false;
};

function get_live_data(){
	url = new URL(window.location);
	$.ajax({
		type: "POST",
		url: url.href+"&server_update=true&api=json",
		dataType : "json",
		success: function(data){
			$.each(data.servers_data, function(i, t){
				if(t != null){
					cpu_val = [t.cpu.percent,t.cpu.percent_free];
					ram_val = [t.ram.percent,t.ram.percent_free];
					if(!empty(t.io)){
						iowait_val = [t.io.avg_cpu.iowait,t.io.avg_cpu.idle,t.io.avg_cpu.nice,t.io.avg_cpu.steal,t.io.avg_cpu.system,t.io.avg_cpu.user];
					}
					disk_val = [t.disk.percent,t.disk.percent_free];
					pie_updater("cpu_graph_"+i,cpu_val,"cpu_per_"+i,t.cpu.percent.toFixed(),t.uptime,i);
					pie_updater("ram_graph_"+i,ram_val,"ram_per_"+i,t.ram.percent.toFixed());
					pie_updater("io_graph_"+i,iowait_val,"io_per_"+i,(100 - t.io.avg_cpu.idle).toFixed());
					pie_updater("disk_graph_"+i,disk_val,"disk_per_"+i,t.disk.percent);
				}else{
					show_toast("Failed to connect to Server ID: "+i,5);
				}

			});
		},
		error: function(data) {
			return false;
		}
	});
 	setTimeout(function(){
		get_live_data();
	 }, 30000); 

};

  //todo change structure(Done)
  const externalTooltipHandler = (context) => {
	// Tooltip Element
   let tooltipEl = document.getElementById(\'chartjs-tooltip\');

   // Create element on first render
   if (!tooltipEl) {
	   tooltipEl = document.createElement(\'div\');
	   tooltipEl.id = \'chartjs-tooltip\';
	   tooltipEl.innerHTML = \'<table></table>\';
	   document.body.appendChild(tooltipEl);
   }

   // Hide if no tooltip
   const tooltipModel = context.tooltip;
   if (tooltipModel.opacity === 0) {
	   tooltipEl.style.opacity = 0;
	   return;
   }

   // Set caret Position
   tooltipEl.classList.remove(\'above\', \'below\', \'no-transform\');
   if (tooltipModel.yAlign) {
	   tooltipEl.classList.add(tooltipModel.yAlign);
   } else {
	   tooltipEl.classList.add(\'no-transform\');
   }

   function getBody(bodyItem) {
	   return bodyItem.lines;
   }

   // Set Text
   if (tooltipModel.body) {
	   const titleLines = tooltipModel.title || [];
	   const bodyLines = tooltipModel.body.map(getBody);

	   let innerHtml = \'<thead>\';
	   var tt_array = tooltipModel.chart.canvas.id.split("_");
	   extension_type = "%";
	   innerHtml += \'<tr><th>\' + tt_array[0].toUpperCase() + \'</th></tr>\';
	   
	   innerHtml += \'</thead><tbody>\';

	   bodyLines.forEach(function(body, i) {
		  
		   const colors = tooltipModel.labelColors[i];
		   let style = \'background:\' + colors.backgroundColor;
		   style += \'; border-color:\' + colors.borderColor;
		   style += \'; border-width: 2px\';
		   const span = \'<span style="\' + style + \'"></span>\';
		   innerHtml += \'<tr><td>\' + span + body + extension_type +\'</td></tr>\';
	   });
	   innerHtml += \'</tbody>\';

	   let tableRoot = tooltipEl.querySelector(\'table\');
	   tableRoot.innerHTML = innerHtml;
   }

   const position = context.chart.canvas.getBoundingClientRect();
   const bodyFont = Chart.helpers.toFont(tooltipModel.options.bodyFont);

   // Display, position, and set styles for font
   tooltipEl.style.background = \'rgb(0, 0, 0)\';
   tooltipEl.style.borderRadius = \'3px\';
   tooltipEl.style.color = \'white\';
   tooltipEl.style.transform = \'translate(-50%, 0)\';
   tooltipEl.style.transition = \'all .1s ease\';
   tooltipEl.style.opacity = 1;
   tooltipEl.style.position = \'absolute\';
   tooltipEl.style.left = position.left + window.pageXOffset + tooltipModel.caretX + \'px\';
   tooltipEl.style.top = position.top + window.pageYOffset + tooltipModel.caretY + \'px\';
   tooltipEl.style.font = bodyFont.string;
   tooltipEl.style.padding = tooltipModel.padding + \'px \' + tooltipModel.padding + \'px\';
   tooltipEl.style.pointerEvents = \'none\';
  };

function ServerAlert(action, server_list){

	var l = Array();
	l["lock_lang"] = "'.$l['lock_conf'].'<br />'.$l['reason_txt'].' : <input type=\"text\" class=\"form-control\" id=\"lock_reason\" name=\"reason\">";
	l["unlock_lang"] = "'.$l['unlock_conf'].'";
	l["reset_key_lang"] = "'.$l['reset_conf'].'";
	l["update_servers_lang"] = "'.$l['update_servers_conf'].'";
	
	showalert(l[action+"_lang"] ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			var finalData = new Object();
			var reason = $("#lock_reason").val();
			finalData[action] = server_list.join(",");
			finalData["reason"] = reason;
			//alert(JSON.stringify(finalData));
			//return false;
			
			$("#progress_bar").show();
			
			$.ajax({
				type: "POST",
				url: "'.$globals['index'].'act=servers&api=json",
				data : finalData,
				dataType : "json",
				success: function(data){
					$("#progress_bar").hide();
					if("done" in data){
						let msg = "'.$l['action_completed'].'";
						if("done_msg" in data && !empty(data["done_msg"])){
							msg = data["done_msg"];
						}
						setTimeout(function(){showalert(msg);
						$("#alert-modal").on("hidden.bs.modal", function (e) {
							location.reload(true);
						})} ,200);
					}
					if("error" in data){
						errors = "";
						for(x in data["error"]){
							errors = errors + data["error"][x]+ "<br>";
						}
						showalert(errors, 1);
					}
				},
				error: function(data) {
					$("#progress_bar").hide();
					//alert(data.description);
					return false;
				}
			});
		}
	});

	return false;
};

function show_virt_name(virt){

	let full_name = "";
	let full_name_tt = "";
	switch (virt) {
		case \'kvm\':
			full_name_tt = "KVM";
			break;
		case \'kvm lxc\':
			full_name_tt = "KVM & LXC";
			break;
		case \'openvz\':
			full_name_tt = "Openvz";
			break;
		case \'proxk proxl\':
			full_name_tt = "<span style=\"color:#e57000\">Proxmox</span>";
			break;
		case \'vzk vzo\':
			full_name_tt = "<span style=\"color:#F96666\">Virtuozzo</span>";
			break;
		case \'xcp\':
			full_name_tt = "XCP";
			break;
		case \'xcphvm\':
			full_name_tt = "XCP HVM";
			break;
		case \'xenhvm\':
			full_name_tt = "XEN HVM";
			break;
		case \'xen\':
			full_name_tt = "XEN";
			break;
		case \'lxc\':
			full_name_tt = "LXC";
			break;
		case \'msonly\':
			full_name_tt = "<span style=\"color:#42b355\"> Master Only</span>";
		}
		let ret = \'<span class="font-weight-light text-admin px-1" >\'+full_name_tt+\'</span>\';
		return ret;
}

function sso(serid){
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=servers&sso="+serid+"&api=json",
		dataType : "json",
		success: function(data){
			if(empty(data["fatal_error_text"])){
				window.open("https://"+data["servers"][serid]["ip"]+":4085/"+data["sso_link"]["token_key"]+"/?as="+data["sso_link"]["sid"],"_blank");
			}else{
				showalert(data["fatal_error_text"], 1);
			}
		}
	});
}

// ]]></script>

<div id="showsearch" class="mt-4" style="display:'.(optREQ('search') || (!empty($servs) && !empty($globals['showsearch'])) ? "" : "none").';">
<form accept-charset="'.$globals['charset'].'" name="servers" method="GET" action="" class="form-horizontal">
<input type="hidden" name="act" value="servers">
		
<div class="form-group_head">
	<div class="row mx-auto w-100">
		<div class="col-sm-4"><label>'.$l['sbyservername'].'</label><input type="text" class="form-control" name="servername" id="servername" size="30" value="'.REQval('servername', '').'" /></div>
		<div class="col-sm-4"><label>'.$l['sbyserverip'].'</label><input type="text" class="form-control" name="serverip" id="serverip" size="30" value="'.REQval('serverip','').'"/></div>
		<div class="col-sm-4"><label>'.$l['sbyservertype'].'</label>
			<select name="ptype" class="form-control virt-select" id="ptypeid">
				<option value="">All</option>
				<option value="openvz" '.REQselect('ptype', 'openvz').'>Openvz</option>
				<option value="xen" '.REQselect('ptype', 'xen').'>Xen</option>
				<option value="kvm" '.REQselect('ptype', 'kvm').'>KVM</option>
				<option value="xcp" '.REQselect('ptype', 'xcp').'>XCP</option>
				<option value="lxc" '.REQselect('ptype', 'lxc').'>LXC</option>
				<option value="vzo" '.REQselect('ptype', 'vzo').'>Virtuozzo Openvz</option>
				<option value="vzk" '.REQselect('ptype', 'vzk').'>Virtuozzo KVM</option>
				<option value="proxk" '.REQselect('ptype', 'proxk').'>Proxmox KVM</option>
				<option value="proxl" '.REQselect('ptype', 'proxl').'>Proxmox LXC</option>
				<option value="proxo" '.REQselect('ptype', 'proxo').'>Proxmox OpenVZ</option>
				<!--<option value="vmware" '.REQselect('ptype', 'vmware').'>VMWARE ESXi</option>-->
			</select>
		</div>
		
	</div>
	<div class="row mx-auto w-100 my-2">
		<div class="col-sm-12 text-center"><button type="submit" name="search" class="go_btn mt-2" value="Search"/>'.$l['submit'].'</button></div>
	</div>
</div>
</form>

</div>';

if(!empty($saved)){
	show_alert($l['done']);
	echo '<div class="notice"><b>'.$l['note'].' : </b> &nbsp; '.$l['done'].'</div>';
}

if(empty($servs)){
	show_alert($l['no_res'],"2");
	echo '<div class="notice"><b>'.$l['note'].' : </b> &nbsp; '.$l['no_res'].'</div>';
}else{
	echo'<div class="row mx-auto w-100 mt-3">
		<div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">';
			page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
		echo'
		</div>
		<div class="col-sm-4 col-lg-4 col-md-6 text-right mb-3">
			<div class="bottom-menu float-right w-100">
				<div class="row my-auto">
					<div class="p-0">
						<label>'.$l['with_selected'].'</label>
					</div>
					<div class="col p-0">
						<select name="server_task_select" class="custom-select">
							<option value="0">---</option>
							<option value="lock">'.$l['ms_lock'].'</option>
							<option value="unlock">'.$l['ms_unlock'].'</option>';
							if(is_master()){
								echo'<option value="reset_key">'.$l['reset_keys'].'</option>';
								echo'<option value="update_servers">'.$l['update_servers'].'</option>';
							}
							echo'
						</select>
					</div>
					<div class="pl-2">
						<input type="submit" id ="server_submit" class="go_btn" name="server_submit" value="'.$l['go'].'" onclick="lockServer(0 ,this); return false;">
					</div>
				</div>
			</div>
		</div>
	</div>
<form accept-charset="'.$globals['charset'].'" name="multi_server" id="multi_server" method="post" action="" class="form-horizontal">
<div class="w-100 mx-auto sticky">
'.get_num_records($globals['num_res']).'
<table class="table table-hover tablesorter ">
	<tr>
		<th width="2%">'.getSortHeader($l['server_id'], 'serid' ,25).'</th>
		<th width="3%">'.$l['server_type'].'</th>
		<th width="3%">'.$l['os'].'</th>
		<th width="10%">'.getSortHeader($l['server_name'], 'server_name' ,25).'</th>
		<th width="30%">'.getSortHeader($l['server_ip'], 'ip' ,25).'</th>
		<th width="30%">'.getSortHeader($l['lm_ram'], 'alloc_ram' ,25).'</th>
		<th width="30%">'.getSortHeader($l['lm_disk'], 'space' ,25).'</th>
		<th>'.$l['lm_cpu'].'</th>
		<th>'.VM_SHORT.'</th>
		<th width="25%" class="z-index-1">'.$l['resources_live'].'</th>
		<th width="10%">'.$l['version'].'</br> & '.$l['expires_on'].'</th>
		<th>'.$l['server_group'].'</th>
		<th colspan="6" class="min_width">'.$l['manage'].'</th>
		<th class="z-index-1 min_width">
			'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
		</th>		
	</tr>';		
			
	$i = 1;

	foreach($servs as $k => $v){
		
		if(preg_match('/CentOS/is', $v['os'])){
			$servers_ditro = 'centos';
		}elseif(preg_match('/AlmaLinux/is', $v['os'])){
			$servers_ditro = 'almalinux';
		}elseif(preg_match('/Rocky/is', $v['os'])){
			$servers_ditro = 'rocky';
		}elseif(preg_match('/oracle/is', $v['os'])){
			$servers_ditro = 'oracle';
		}elseif(preg_match('/ubuntu/is', $v['os'])){
			$servers_ditro = 'ubuntu';
		}elseif(preg_match('/vmware/is', $v['os'])){
			$servers_ditro = 'vmware';
		}else{
			$servers_ditro = 'others';
		}

		if(($v['serid'] == 0) && !empty($globals['is_master_only'])){
			$v['virt'] = 'msonly';
		}
		
		echo '<tr>
		<td class="pl-2">'.$v['serid'].'</td>
		<td align="center"><script>document.write(show_virt_name("'.$v['virt'].(empty($v['hvm']) ? '' : 'hvm').'"));</script></td>
		<td ><img src="'.distro_logo($servers_ditro,'',1).'" title="'.$v['os'].'" width="35px"/></td>
		<td ><span class="text-admin" id ="server'.$v['serid'].'">'.$v['server_name'].'</span>';
		if(!empty($v['locked'])){

				$tmp_tooltip = $tooltip = '';
				if(is_array($v['locked'])){
					foreach($v['locked']['reason'] as $k1 => $v1){
						$tmp_tooltip .= $v1;
						$tmp_tooltip .= '<br>';
					}
					$tooltip .= 'tooltip="'.$tmp_tooltip.'"';
				}
				
				echo ' &nbsp;<i class="fas fa-lock" id="lock'.$v['serid'].'" '.$tooltip.'></i>';
				unset($tooltip);
				unset($tmp_tooltip);
				
		}
		echo '</br><span id="uptime_'.$v['serid'].'"></span></td>
		<td><span>'.$v['ip'].'</span></td>
		<td>'.(!empty($v['alloc_ram']) ? $v['alloc_ram'] : '0').' MB / '.$v['total_ram'].' MB'.'</td>
		<td>'.(!empty($v['space']) ? $v['space'] : '0').' GB / '.$v['total_space'].' GB</td>
		<td>'.(!empty($v['vcores']) ? $v['vcores'] : '0').'</td>
		<td>'.(!empty($v['numvps']) ? $v['numvps'] : '0').'</td>
		<td><div class="d-flex align-items-center justify-content-center" align="center">
				<div class="p-1">
					<small class="pl-1">CPU</small>
					<canvas align="center" id="cpu_graph_'.$v['serid'].'" style="height:30px; width:30px"></canvas>
					<small class="pl-1" id="cpu_per_'.$v['serid'].'">--%</small>
					</div>
				<div class="p-1">
					<small class="pl-1">RAM</small>
					<canvas align="center" id="ram_graph_'.$v['serid'].'" style="height:30px; width:30px"></canvas>
					<small class="pl-1" id="ram_per_'.$v['serid'].'">--%</small>
					</div>
				<div class="p-1">
					<small class="pl-1">DISK</small>
					<canvas align="center" id="disk_graph_'.$v['serid'].'" style="height:30px; width:30px"></canvas>
					<small class="pl-1" id="disk_per_'.$v['serid'].'">--%</small>
				</div>
				<div class="p-1">
					<small class="pl-1">IO</small>
					<canvas align="center" id="io_graph_'.$v['serid'].'" style="height:30px; width:30px"></canvas>
					<small class="pl-1" id="io_per_'.$v['serid'].'">--%</small>
				</div>
		</div></td>
		<td ><big><span class="text-admin">'.$v['version'].' ('.$v['patch'].')</span></big></br>'.$v['lic_expires'].'</td>
		<td >'.$servergroups[$v['sgid']]['sg_name'].'</td><td width="30" align="center">';
		if(empty($globals['disable_terminal_access'])){
			echo '<a href="'.$globals['ind'].'act=terminal&serid='.$k.'&auto_redirect=1" target="_blank" tooltip="'.$l['terminal'].'"><i class="fas fa-terminal h6 m-0 text-dark"></i></a>';			
		}
		echo '
		</td>
		<td width="30" align="center"><a href="'.$globals['ind'].'act=manageserver&changeserid='.$k.'"><i class="fas fa-tools h6 m-0 text-admin"></i></a></td>
		<td width="30" align="center"><a href="'.$globals['ind'].'act=editserver&serid='.$k.'"><i class="fas fa-edit text-warning"></i></a></td>
		<td width="30" align="center" id="sync_td_'.$k.'">';
		
		if(!empty($k)){
			echo '<a href="javascript:void(0)" title = "Sync" onclick="sync_server(\''.$k.'\');"><i class="fas h6 m-0 fa-sync-alt text-primary"></i></a>';			
		}
		echo '</td>
		<td width="30" align="center">';
		
		if(!empty($k)){
			echo '<a href="javascript:void(0)" onclick="conf_del(\''.$k.'\');"><i class="fas fa-trash text-danger"></i></a>';			
		}
		echo '</td>
		<td width="30" align="center">';
		
		if(!empty($k)){
			echo '<a href="javascript:void(0)" onclick="sso(\''.$k.'\');"><i class="fas fa-sign-in-alt"></i></a>';			
		}
		echo '</td>
		<td width="20" valign="middle" align="center">
			'.get_checkbox('servers_list[]', '', '', array('chk_it' => 0), $v['serid']).'
		</td>
		</tr>';
		$i++;
		echo '
		<script>
			var resources = JSON.parse(\''.json_encode($server_cached).'\');
			var serid = '.$v['serid'].';
			var xValues = ["Used","Free"];
			var xValues_5 = ["iowait","idle","nice","steal","system","user"];
			if(empty(resources)){
				resources = new Object();
				resources[serid] = new Object();
			}
			
			if(empty(resources[serid]) || empty(resources[serid]["resource"])){
				cpu_percent = ram_percent = disk_percent = iowait_percent = idle_percent = steal_percent = nice_percent = system_percent =  user_percent = 0 ;
				cpu_percent_free = ram_percent_free =  disk_percent_free =  100;
				uptime = "-- / --";
			}else{
				cpu_percent = resources[serid].resource.cpu.percent;
				cpu_percent_free = resources[serid].resource.cpu.percent_free;
				ram_percent = resources[serid].resource.ram.percent;
				ram_percent_free = resources[serid].resource.ram.percent_free;
				disk_percent = resources[serid].resource.disk.percent;
				disk_percent_free = resources[serid].resource.disk.percent_free;
				iowait_percent = resources[serid].resource.io["avg_cpu"].iowait;
				idle_percent = resources[serid].resource.io["avg_cpu"].idle;
				steal_percent = resources[serid].resource.io["avg_cpu"].steal;
				nice_percent = resources[serid].resource.io["avg_cpu"].nice;
				user_percent = resources[serid].resource.io["avg_cpu"].user;
				system_percent = resources[serid].resource.io["avg_cpu"].system;
				uptime = resources[serid].resource.uptime;
			}

			var cpuyValues = [cpu_percent,cpu_percent_free];
			var ramyValues = [ram_percent,ram_percent_free];
			var diskyValues = [disk_percent,disk_percent_free];
			var ioValues = [iowait_percent,idle_percent,nice_percent,steal_percent,system_percent,user_percent];

			pie_ploter(xValues_5,ioValues,"io_graph_'.$v['serid'].'","io_per_"+serid,100 - iowait_percent.toFixed(),uptime,serid);
			pie_ploter(xValues,cpuyValues,"cpu_graph_'.$v['serid'].'","cpu_per_"+serid,cpu_percent.toFixed());
			pie_ploter(xValues,ramyValues,"ram_graph_'.$v['serid'].'","ram_per_"+serid,ram_percent.toFixed());
			pie_ploter(xValues,diskyValues,"disk_graph_'.$v['serid'].'","disk_per_"+serid,disk_percent.toFixed());

		</script>';
	}
	
	echo '</table>
	</div>';
	echo'<div class="row mx-auto w-100 mt-5">
	<div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">';
		page_links($globals['num_res'], $globals['cur_page'], $globals['reslen']);
	echo'
	</div>
	<div class="col-sm-4 col-lg-4 col-md-6 text-right mb-3">
		<div class="bottom-menu float-right w-100">
            <div class="row my-auto">
                <div class="p-0">
                    <label>'.$l['with_selected'].'</label>
                </div>
                <div class="col p-0">
					<select name="server_task_select" class="custom-select">
						<option value="0">---</option>
						<option value="lock">'.$l['ms_lock'].'</option>
						<option value="unlock">'.$l['ms_unlock'].'</option>';
						if(is_master()){
							echo'<option value="reset_key">'.$l['reset_keys'].'</option>';
							echo'<option value="update_servers">'.$l['update_servers'].'</option>';
						}
						echo'
					</select>
                </div>
                <div class="pl-2">
					<input type="submit" id ="server_submit" class="go_btn" name="server_submit" value="'.$l['go'].'" onclick="lockServer(0 ,this); return false;">
                </div>
            </div>
		</div>
	</div>
</div>
</form>
<script>
//TODO Convert this into fixed array
$(document).ready(function() {
	get_live_data();
});
</script>
<div id="progress_bar" style="display:none;">
	<br />
	<center>
		<font id="progress_txt" size="4">'.$l['action_msg'].'</font>
	</center>
	<div class="my-2" align="center">
		<div class="progress w-50">
			<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100">
			</div>
		</div>
	</div>
	<center>
		'.$l['notify_msg'].'
	</center>
</div>';

}
echo '<br>
<center>
<a href="index.php?act=addserver" class="link_btn">'.$l['add_server'].'</a></center></div>';

softfooter();

}

?>