<?php

//////////////////////////////////////////////////////////////
//===========================================================
// migrate_disk_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Pawan Battu
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if (!defined('VIRTUALIZOR')) {

	die('Hacking Attempt');
}

function migrate_disk_theme(){
	global $theme, $globals, $l, $error, $cluster, $servers, $disk_storages, $vps_list, $__vps;
	global $migrate_status, $migrate_done, $mprog, $actid;

	//Is Ajax Mode on?
	if (optREQ('do')) {

		$do = optREQ('do');
		// Is there any error
		if (!empty($error)) {
			$json['error'] = $error;
		}
		if ($do == 'get_resources') {
			$json['disk_storages'] = $disk_storages;
			$json['vpsinfo'] = $__vps['disks'];
			echo array2json($json);
		}

		return true;
	}

	softheader($l['<title>']);

// Is it offline ?
$hypervisor_status = $cluster->statewise($globals['server']);
if($hypervisor_status == 0 || $hypervisor_status == 2){
	echo '
	<div class="bg">
		<div class="row my-3 mx-auto">
			<div class="col-10">
				<h4 class="text-dark"><i class="fas fa-server"></i> '.$l['<dtitle>'].'</h4>
			</div>
			<div class="col-2 text-right">
				<span><a href="'.$globals['docs'].'disk-migration/" target="_blank" tooltip="'.$l['wiki_help'].'"><i class="icon-help text-dark" ></i></a></span>
			</div>
		</div>';
	server_select();
	echo '<div class="e_notice"><b>NOTE : </b>'.$l['server_status_'.$hypervisor_status].'</div>';
	echo '</div>';
}else{

	echo '
	<div class="bg">
		<div class="row my-3 mx-auto">
			<div class="col-10">
				<h4 class="text-dark"><i class="fas fa-server"></i> '.$l['<title>'].'</h4>
			</div>
			<div class="col-2 text-right">
				<span><a href="'.$globals['docs'].'disk-migration/" target="_blank" tooltip="'.$l['wiki_help'].'"><i class="icon-help text-dark" ></i></a></span>
			</div>
		</div>';
		
	error_handle($error);

	echo '<script language="javascript" type="text/javascript"><!-- // --><![CDATA[

			var vps_list = '.array2json($vps_list).';
			var actid = '.(isset($actid) ? $actid : "-1").';
			var progress = 0;
			var progress_update = "";
			var update_status_txt = "";
			var timer = null;

			function getdisk_list(){
				var vpsopts = "";	
				vpsopts +=\'<option value="0">None</option>\';
				for(x in vps_list){
					vpsopts +=\'<option value="\'+vps_list[x]["vpsid"]+\'">\'+vps_list[x]["vpsid"]+\' - \'+vps_list[x]["hostname"]+\'</option>\';
				}
				
				$("#vpsid").html(vpsopts);
				
				$("#vpsid").select2({
					width:"100%"
				});
				
			}

			function toggle_resources(){
				$_("storage_row").style.display = "flex";	
			}

			function get_resources(){

				var vps_id = $("#vpsid").val();				
				// If there are no VPS we check for that and return from here only. As there is nothing to do !
				if(!vps_id){
					return false;
				}
							
				$("#storage").html("");
				
				toggle_resources();
					
				$("#storage").html("<img src=\"' . $theme['images'] . 'loading_35.gif\"/>");
				
				$.ajax({
					type: "POST",
					dataType: "json",
					url: "index.php?act=migrate_disk&do=get_resources",
					data: $("#migrate_form").serialize(),
					success: function(data, textStatus, jqXHR){
						
						// Are there any errors ?
						if(typeof(data["error"]) != "undefined"){
							var errors = "";
							for(x in data["error"]){
								errors = errors + data["error"][x];
							}	
						}
						
						var storageopts = "";
						
						if(data["disk_storages"] == undefined ){
							var msg = "' . $l["no_storage_select"] . '";
							$("#storage").html(msg);
							return;
						}
						
						if(data["disk_storages"]["no_storage_select"]){
							$("#storage").html(data["disk_storages"]["no_storage_select"]);
							return;
						}
						
						
						// Build the Storage List
						for(x in data["disk_storages"]){
							
							var num = parseInt(x);
							var size = data["vpsinfo"][x]["size"];

							size = parseFloat(size).toFixed(2);
							num++;
							
							var format = data["vpsinfo"][x]["format"];
							
							if(format == ""){
								if(data["vpsinfo"][x]["type"] == "block"){
									format = "raw";
								}else if(data["vpsinfo"][x]["type"] == "file"){
									format = "qcow2";
								}
							}
							
							storageopts += \'<tr><td><label class="control-label" > DISK&nbsp;\' + num + \'</label> (&nbsp;\'+size+\'&nbsp;GB&nbsp;)<br />\' + format.toUpperCase() +\'</td>\';
							
							if(typeof data["disk_storages"][x] == "object"){
								storageopts +=  \'<td><select class="custom-select" name="storage[\'+x+\']">\';
								
									for(y in data["disk_storages"][x]){
										
										storageopts += \'<option value="\'+y+\'" \'+(data["disk_storages"][x][y]["primary_storage"] == 1 ? "selected=selected" : "")+\'>\'+y+\' - \'+data["disk_storages"][x][y]["name"]+\' (\'+data["disk_storages"][x][y]["free"]+\'GB Free)</option>\';
									}
								storageopts += \'</td></div><td class="pr-2"><input class="form-check-input mt-2" type="checkbox" value="\'+data["vpsinfo"][x]["did"]+\'" id="disk_did_\'+data["vpsinfo"][x]["did"]+\'" name="disk_did[]" ></td>\'; 
								
							}else if(typeof data["disk_storages"][x] == "string"){
								storageopts += \'<td><div class="col-sm-9"><span class="text-danger">\'+data["disk_storages"][x]+\'</span></div></div></td>\';
							}
						}
						
						if(storageopts == ""){
							storageopts = errors;
						}
						
						$("#mig_all_row").show();
						$("#migdisk_storage_table").html(storageopts);
					}
				});
			
			}

			function check_handle(ele) {
				var checkboxes =  document.getElementsByName("disk_did[]");
				if (ele.checked) {
					for (var i = 0; i < checkboxes.length; i++) {
						checkboxes[i].checked = true;
					}
				} else {
					for (var i = 0; i < checkboxes.length; i++) {
						checkboxes[i].checked = false;
					}
				}
			}

			// Clean IDs
			function ids_clean(str){
				
				str = str.replace(/\./gi, "_"); 
				str = str.replace(/\:/gi, "_"); 
				return str;
				
			}

			// Draw a Resource Graph
			function resource_graph(id, data){

				$.plot($("#"+id), data, 
				{
					series: {
						pie: { 
							innerRadius: 0.7,
							radius: 1,
							show: true,
							label: {
								show: true,
								radius: 0,
								formatter: function(label, series){
									if(label != "Completed") return "";
										return \'<div class="h6 text-center p-1 text-center">\'+Math.round(series.percent)+\'%</div><div class="small">\'+label+\'</div>\';	
									}
								}	
							}
						},
					legend: {
						show: false
						}
					});
			}


			function donefunc(data){

				if(data == 1){

					showalert(\'' . $l['migration_complete'] . '\');
					$("#form-container").show();
					$("#running").hide();
					$("#progress-cont").hide();

				}else{

					animate_task("' . $l['migrate_disk_task'] . '");
					$("#form-container").hide();
					progress_onload();
					$("#complete").hide();
					$("#running").show();
					$("#progress-cont").show();

				}
			};

			function startusage(){

				toggle_resources();
				timer = setTimeout("get_progress(\'migrate_disk\')", 1500);

			}
			
			function make_mig_table(id, data){
				
				try{
					data = JSON.parse(data);
				}catch(e){
					return;
				}
				var j = 1;
				var html = "<center><table o><tr>";
				$.each(data, function(i, item){
					
					html += "<td>&nbsp;&nbsp;<b>"+i+"&nbsp;&nbsp;&nbsp;</b></td><td>"+item+"</td>";
					if(j % 2 == 0){
						html += "</tr><tr>";
					}
					j++;
				});
	
				html += "</tr></table></center>";
				$(id).html(html);
			};
			
			addonload("getdisk_list(); '.(!empty($migrate_status) || !empty($migrate_done) ? "startusage();donefunc(2);$('#progressbar').progressbar();" : "").'");
			

			// ]]></script>
<div id="form-container">
	<form accept-charset="' . $globals['charset'] . '" name="migrate_form" method="post" action="" id="migrate_form" class="form-horizontal">
		
		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-4">
				<label class="control-label">'.$l['server_select'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['server_select_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-4">
				<select id="server-select" class="server-select">';	
					foreach($servers as $k => $v) {
						echo '<option value="'.$k.'" data-icon="'.$theme['images'].'admin/'.$v['virt'].'_28.png" '.($k == $globals['server'] ? 'selected' : '').'><span><img src="'.$theme['images'].'admin/'.$v['virt'].'_28.png" class="mb-1"/>'.$v['server_name'].' ('.$v['ip'].')'.($v['locked'] == 0 ? '' : ' (Locked)').'</span></option>';
					}
		
				echo '</select>
			</div>
			
		</div>

		<div class="row mx-auto w-100 my-3">
			<div class="col-sm-4">
				<label class="control-label">' . $l['select_vps_disk'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['select_vps_disk_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-4">
				<div class="">
					<select name="vpsid" id="vpsid" class="form-control w-100 custom-select" onchange="get_resources();">
						<option value="0">' . $l['select_vps_disk'] . '</option>
					</select>
					<div class="help-block"></div>
				</div>
				<div class="loader" id="prog_img" style="display:none;"></div>
			</div>	
		</div>

		<div class="row mx-auto w-100 my-3" id="mig_all_row" style="display:none">
			<div class="col-4" id="migrate_all_row">
				<label class="control-label">' . $l['migrate_all'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['migrate_all_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-4">
				' . get_checkbox('migrate_all', '', 'migrate_all', '', '', '',  array('onchange="check_handle(this)"')) . '
			</div>
		</div>

		<div class="row mx-auto w-100 my-3" id="storage_row" style="display:none;">
			<div class="col-sm-4">
				<label class="control-label">' . $l['select_storage'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['select_storage_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-sm-4" id="storage_row">
				<div class="row mx-auto w-100 my-0">
					<table class="table" id="migdisk_storage_table">
						<tbody id="storage">
						
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="row mx-auto w-100 my-3">
			<div class="col-4 ">
				<label class="control-label">' . $l['speed_limit'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['speed_limit_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-4">
				<input type="number" class="form-control" name="speed_limit" id="speed_limit" value="' . POSTval('speed_limit') . '"/>
			</div>
		</div>

		<div class="row mx-auto w-100 my-3">
			<div class="col-4 ">
				<label class="control-label">' . $l['disable_gzip'] . '&nbsp;<a class="info" data-placement="right" tooltip="' . $l['disable_gzip_exp'] . '"><i class="fas text-primary fa-info-circle"></i></a></label>
			</div>
			<div class="col-4">
				' . get_checkbox('disable_compression', '', '', array('chk_it' => 1, 'val' => 1)) . '
			</div>
		</div>
		<br />
		<br />
		<br />
		<input type="hidden" name="migratedisk" value="1" />
		<center><input type="submit" class="go_btn" name="migrate_it"  id="migrate_it" value="' . $l['migrate_it'] . '"/></center>
		</div>
		<br /><br />
	</form>';

	if(!empty($mprog)){
		echo '
		<div id="progress_onload"></div>
		<br />
		<div class="notice" id="complete" style="display:none;"><b>'.$l['note'].' : </b> &nbsp; '.$l['migration_complete'].'</div>
		<br />
		
		<div class="notice" id="running"><b>'.$l['note'].' : </b> &nbsp; '.$l['existing'].' '.$l['mnote3'].'</div>
		<br />';
	}
	echo '</div>';
}// End of Server Offline if

	softfooter();
}
