<?php

//////////////////////////////////////////////////////////////
//===========================================================
// managevps_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function managevps_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $cluster, $servers, $oslist, $done, $virt, $machine_type, $pcis, $usbs, $cpu_info;
global $plans, $ips, $ips6, $ips6_subnet, $ips_int, $ipools, $vps, $servers, $ostemplates, $users, $isos, $resources, $mgs, $servergroups, $scripts, $iscripts, $storages, $stid, $disk_space, $os_check, $storage_uuids, $disks, $primary_ip, $dnsplans, $common_logs, $supported_nics, $cpu_modes, $SESS, $backup_plans, $bus_driver, $recipes;
global $server_config, $iscripts_allowed, $webuzo_apps, $webuzo_templates, $ha_enabled, $vm_backup_plan, $ajax_user, $console, $load_balancer, $admin_firewall_plans, $enduser_firewall_plans;

//Is Ajax Mode on?
if(optGET('ajax')){	
	$planid = optGET('plan');
	$uid  = (int) optGET('uid');
	$vpsid = (int) optGET('vpsid');
	$vps = getvps($vpsid);
	if(!empty($uid)){
		useriso($uid);
		$options = '';		
		$iso = array('iso', 'sec_iso');
		$res = array();
		foreach($iso as $isov){
			$options_eu_iso = $options_iso = '';
			$options = '<option value="0">'.$l['none'].'</option>';
			foreach($isos as $k => $v){
				if(!empty($v['isuseriso'])){
					$options_eu_iso .= '<option value="'.$k.'" '.($vps[$isov] == $k ? 'selected="selected"' : "").'>'.$v['name'].'</option>';
				}else{
					$options_iso .= '<option value="'.$k.'" '.($vps[$isov] == $k ? 'selected="selected"' : "").'>'.$v['name'].'</option>';
				}
			}

			if(!empty($options_iso)){
				$options .= '<optgroup label="'.$l['admin_iso'].'">'.$options_iso.'</optgroup>';
			}			
			if(!empty($options_eu_iso)){
				$options .= '<optgroup label="'.$l['eu_iso'].'">'.$options_eu_iso.'</optgroup>';
			}
			$res[$isov] = $options;
		}		
		if(!empty($res)){
			echo json_encode($res);
		}
		return true;
	}
	
	echo 'var $plan = new Object();';
	foreach($plans[$planid] as $k => $v){
		
		if($k == 'dns_nameserver'){
			$tmp_dns = unserialize($v);
			echo '$plan["dns_nameserver"] = '.json_encode($tmp_dns).';';
			continue;
		}
		
		if($k == 'mgs'){
			$tmp_mgs = cexplode(',', $v);
			echo '$plan["mgs"] = '.json_encode($tmp_mgs).';';
			continue;
		}
		
		if($k == 'speed_cap'){
			
			if(!empty($v)){
				$v = _unserialize($v);
			}else{
				$v['down'] = $v['up'] = 0; 
			}
			echo '$plan["speed_cap_down"] = '.$v['down'].';
				  $plan["speed_cap_up"] = '.$v['up'].';
			';
			
		}

		if($k == 'data' && !empty($v)){

			$tmp_data = json_decode($v,1);

			if(!empty($tmp_data['demo'])){
				$tmp_expiry_demo = strtotime('+'.$tmp_data['demo']['duration_days'].' days');
				echo '
				$plan["dtime1"] = \''.datify($tmp_expiry_demo, 1, 1, 'H:i:s').'\';
				$plan["date1"] = \''.datify($tmp_expiry_demo, 1, 1, 'd/m/Y').'\';';
			}

			echo '$plan["data"] = '.json_encode(json_decode($v,1)).';';
			continue;
		}

		if($k == 'ippoolid'){
			echo '$plan["plan_ips"] = '.json_encode($ips).';';
			echo '$plan["internal_ips"] = '.json_encode($ips_int).';';
			echo '$plan["ipsv6"] = '.json_encode($ips6).';';
			echo '$plan["ipsv6_subnet"] = '.json_encode($ips6_subnet).';';
			continue;
		}

		echo '$plan["'.$k.'"] = "'.str_replace('"', '\"', $v).'";';
	}
	
	return true;
}

if(optGET('api') == 'json'){
	
	if(optGET('enable_rescue') || optGET('disable_rescue') || optGET('install_script') || optGET('loadscripts') || optGET('scriptreqid')){
		
		if(!empty($error)){
			$response['error'] = $error;
		}
		
		if(!empty($done['rescue_enabled']) || !empty($done['rescue_disabled']) || 
			!empty($done['webuzo_enabled']) || !empty($done['allowed_scripts']) || 
			!empty($done['webuzo_apps'])){
			$response['done'] = $done;
		}
		
		echo array2json($response);
	}
	
}
function __make_li($carr, $item){
	return $carr .= '<li>'.$item.'</li>';
}

$ipv6_div = '<div><ul class="ip_lists m-0 p-0">'.array_reduce($vps['ipv6'], '__make_li', '').'</ul></div>';

softheader($l['<title>']);


// Is it offline ?
$hypervisor_status = $cluster->statewise($globals['server']);
if($hypervisor_status == 0 || $hypervisor_status == 2){
	echo '<div class="bg">';
	echo '<div class="row my-3 mx-auto">
				<div class="col-12 d-flex align-items-center">
					<h4 class="text-dark"><i class="fas fa-server"></i> '.$l['heading'].'</h4>
				</div>
			</div>'.get_breadcrumb([
				['act' => 'vs'],
				['act' => 'managevps']
			]);
			show_alert($l['server_status_'.$hypervisor_status] ,"1");
	echo '<div class="e_notice"><b>'.$l['note'].' : </b> &nbsp; '.$l['server_status_'.$hypervisor_status].'</div>';
	echo '</div>';
}else{

echo '
<div class="bg">
<div class="row my-3 mx-auto">
<div class="col-10 pr-0 d-flex align-items-center">
<h4 class="text-dark"><i class="fas fa-server"></i> '.$l['heading'].'</h4>
</div>
</div>'.get_breadcrumb([
	['act' => 'vs'],
	['act' => 'managevps']
]);

error_handle($error);

// Rescume mode checking. VPS edit not allowed if Rescue Mode is ON
if(!empty($vps['rescue'])){
	show_alert($l['rescue_edit_no_allowed'] ,"2");
	echo '<div class="notice"><b>'.$l['note'].' : </b> &nbsp; '. $l['rescue_edit_no_allowed'].'</div>';	
}

if(!empty($vps['locked'])){
	show_alert($l['err_vps_locked'] ,"1");
	echo '<div class="notice"><b>'.$l['note'].' : </b> &nbsp; '. $l['err_vps_locked'].'&nbsp;'.'('.$vps['locked']['reason'].')'.'</div>';
}

$no_bridge = ($cluster->get_vps_bridge($vps['serid'], $vps['vpsid']));
if(!empty($no_bridge)){
	echo '<div class="notice"><b>'.$l['note'].' : </b> &nbsp; '. $l['no_bridge'].'&nbsp;'.'('.$l['no_bridge_ips'].' '.(implode(',', $no_bridge)).')'.'</div>';
}

echo '<div class="notice" id="done_msg" style="display:none"></div><div id="working_div" class="working_div" style="display:none">
<div class="loading" style="display:block: !important">
<div class="line"></div>
<div class="line"></div>
<div class="line"></div>
<div class="line"></div><br>
</div>
</div><div style="display:none" id="display_error" class="error alert alert-danger">
</div>';

if(!empty($done)){
		
	$msg= '';
	$msg .= (!empty($done['done']) ? $l['done'] : '');
	
	// if any changes done then reboot msg dispaly
	if(!empty($done['mac']) || !empty($done['dns'])){
		$msg .= '<br />'.$l['reboot'];
	}
	show_alert($msg);
	echo '<div class="notice"><b>'.$l['note'].' : </b> &nbsp; '.$msg.'</div>';	
}

echo '<script type="text/javascript" charset="utf8" src="'.$theme['url'].'/js2/jquery.dataTables.min.js"></script>';

echo '<script language="javascript" type="text/javascript">';

// Parse and include haproxy.js file
echo parse_lang(file_get_contents($theme['url'].'/js/haproxy.js'));

echo '

// For rescue mode operation
var actid = null;
var progress = 0;
var progress_update = "";

check_user_billing('.$vps['uid'].');

var vpsPrimaryIp = new Object();
var ips = new Object();';

foreach($ips as $k => $v){
	echo 'ips['.$k.'] = "'.$v['ip'].'";';
}
foreach($vps['ips'] as $k => $v){
	echo 'ips['.$k.'] = "'.$v.'";';
}

//Get current Primary ip along with it's index
if(!empty($vps['ips'])){
	$primary_ip_index = array_search($primary_ip, $vps['ips']);
	echo 'vpsPrimaryIp['.$primary_ip_index.'] = "'.$primary_ip.'";';
}

$server_public_ip = server_publicip($vps['serid']);
echo 'function addrow(id, val){

	var t = $_(id);
	var lastRow = (t.rows.length);
	var x= t.insertRow(lastRow);
	var y = x.insertCell(0);
	y.innerHTML = \'<input type="text" class="form-control w-90 float-left post_data" name="ips[]" value="\'+(val || "")+\'" onblur="checkippool()" size="20" /></td><td><a class="delip" title="'.$l['rem_from_ips'].'"><i class="fas fa-times text-danger cursor-pointer py-2"></i></a>\';
	
	ipdel();

};

function prox_cpu_flags(){
	let cpu = $("#cpu_mode").val();
	$(".hide_all_cpu_flags").hide();
	$("."+cpu).show();
}

//Console
function show_console_window(action){
	action = action || "";
	$("#console_div").html("");
	if(!empty(action)){
		action = "&"+action+"=1";
	}

	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=managevps&consoleserial=1"+action+"&vpsid='.$vps['vpsid'].'&api=json",
		dataType : "json",
		success:function(res){
			
			var vps_console = res["console"];
			if(empty(vps_console) || !("time_left" in vps_console)){
				var cs_html = \'<div class="notice">'.$l['cs_none'].'</div><div class="text-center"><a href="javascript:void(0);" class="btn blue_btn py-1 px-2" id="cs_create" onclick="create_cosole_session('.$vps['vpsid'].')">'.$l['cs_create'].'</a></div>\';
			}else{
				var cs_html = \'<div class="notice">'.$l['cs_details'].'</div><div class="row mb-2"><div class="col-md-8"><div class="session-details mb-2"><div><label class="form-label d-inline-block mr-3">'.$l['cs_expires'].' :</label><span class="current-value" id="console_time"></span></div><div><label class="form-label d-inline-block mr-3">'.$l['cs_ip'].' :</label><span class="current-value">'.$server_public_ip.'</span></div><div><label class="form-label d-inline-block mr-3">'.$l['cs_port'].' :</label><span class="current-value">\' + vps_console["port"] + \'</span></div><div><label class="form-label d-inline-block mr-3">'.$l['cs_username'].' :</label><span class="current-value">\' + vps_console["username"] + \'</span></div><div><label class="form-label d-inline-block mr-3">'.$l['cs_password'].' :</label><span class="current-value">\' + vps_console["password"] + \'</span></div></div></div></div><a href="javascript:void(0);" class="btn blue_btn py-1 px-2" id="cs_destroy" onclick="destroy_cosole_session();">'.$l['cs_destroy'].'</a><br/><br/>\';
	
				var fiveMinutes = vps_console["time_left"];
	
				updateTime(fiveMinutes);
			}
			$("#console_div").html(cs_html);
	
		}
	});

};

function create_cosole_session(vpsid){
	show_console_window("create");
};
function destroy_cosole_session(vpsid){
	$("#console_time").text("");
	show_console_window("destroy");
};

function updateTime(fiveMinutes) {

	var display = $("#console_time"), mins, seconds;
	mins = parseInt(fiveMinutes / 60);
	seconds = parseInt(fiveMinutes % 60);
	seconds = (seconds < 10) ? "0" + seconds : seconds;
	display.text(mins + ":" + seconds);
	fiveMinutes--;
	
	if (fiveMinutes >= 0) {
		setTimeout(function(){updateTime(fiveMinutes);}, 1000);
	}
};
// Console end

function changestatus(action){
		
	var status = '.$vps["stats"]["status"].';
	
	if(action){
		if(action == "start" ||  action == "unsuspend" || action == "restart"){
			status = 1;
		}else if(action == "stop" ||  action == "poweroff"){
			status = 0;
		}else if (action == "suspend"){
			status = 2;
		}else if(action == "suspend_net"){
			status = 3;
		}
		$("#vps_status").removeClass();
		$("#vps_status").addClass("status_txt");
	}
	
	if(status == 0){
		$("#vps_status").html("'.$l['status_offline'].'").addClass("offline");
	}else if (status == 1){
		$("#vps_status").html("'.$l['status_online'].'").addClass("online");
	}else if (status == 2){
		$("#vps_status").html("'.$l['status_suspended'].'").addClass("suspended");
	}else if (status == 3){
		$("#vps_status").html("'.$l['status_net_suspended'].'").addClass("suspended");
	}
};

function cputopology(){
	if(is_checked("enable_cpu_topology")){
		$("#cpu_topology_option").show();
	}else{
		$("#cpu_topology_option").hide();
		$("#topology_sockets").val(0);
		$("#topology_cores").val(0);
		$("#topology_threads").val(0);
	}
}

function adduser(){
	var uid = parseInt($_("uid").value);
	
	if(uid < 1){
		$(".user_details_f").show();
		$(".user_details").show();
	}else{
		$(".user_details").hide();
		$(".user_details_f").hide();
	}

	check_user_billing(uid);

	loadiso(uid);
	get_user_ips(uid);
}
'.(($kernel->features('load_balancer', $virt) && 
!preg_match('/windows/is', $ostemplates[$vps['osid']]['name'])) ? 'function get_user_lb(uid){
	var uid = parseInt($_("uid").value);
	$("#load_balancer_card").show();
	$("#ajax_user_loader").show()
	$.ajax({
		url: "'.$globals['index'].'&act=load_balancer&search=1&uid="+uid+"&sgid='.$servers[$globals['server']]['sgid'].'&check_user_billing=1&api=json",
		dataType : "json",
		method : "post",
		success:function(data){
			$("#ajax_user_loader").hide()
			if("load_balancer" in data){
				var options = `<option value="0">'.$l['none'].'</option>`;
				if(!empty(data["load_balancer"])){
					$.each(data["load_balancer"], function(k, v){
						options += "<option value\'"+k+"\'>"+v["vpsid"]+" - "+v["hostname"]+"</option>";
					});
				}
				$("#load_balancer").html(options);
			}
			if("no_billing_user" in data){
				$("#load_balancer_card").hide();
			}
		}
	});
}' : '').'

let og_plid = '.$vps['plid'].'
let og_uid = '.$vps['uid'].'
function check_user_billing(uid){
	$("#ajax_user_loader").show()
	$.ajax({
		url: "'.$globals['index'].'&act=users&check_user_billing="+uid+"&api=json",
		dataType : "json",
		method : "post",
		success:function(data){
			$("#ajax_user_loader").hide()
			if(!empty(data["has_billing_enabled"])){
				$("#vertical_scaling_settings").css("display", "flex");
				enable_vertical_scaling('.$globals['enable_ver_scaling'].');
			}else{
				$("#vertical_scaling_settings").css("display", "none");
				$("[href=\"#general_tab\"]").trigger("click")
			}
		}
	});
}

function get_user_ips(uid){
	var plid = $("#plid").val();
	if(plid > 0){
		//no need to load plan onload
		//loadplan(plid, 1)
	}else{
		$("#ajax_user_loader").show();
		$.ajax({
			type: "POST",
			url: "'.$globals['index'].'act=managevps&vpsid='.$vps['vpsid'].'&get_user_ips=1&api=json&uid="+uid+"&plid="+plid,
			dataType : "json",
			success:function(data){
				
				$("#ajax_user_loader").hide();
				$("#iplist").html("");
				if(!empty(data["ips"])){
					ips = [];
					$.each(data["ips"], function( ind, val ){
						let row = "<option value="+ind+">"+val.ip+"</option>";
						$("#iplist").append(row);
						ips[ind] = val.ip;
					});	
				}
				if(!empty(data["vpsips"])){
					$.each(data["vpsips"], function( ind, val ){
						ips[ind] = val;
					});
				}
				if(!empty(data["ips6"])){
					ips6 = [];
					$.each(data["ips6"], function( ind, val ){
						let row = "<option value="+ind+">"+val.ip+"</option>";
						$("#ipv6").append(row);
						ips6[ind] = val.ip;
					});	
					countipv6(\'ipv6count\')
				}
				if(!empty(data["ips6_subnet"])){
					ips6_subnet = [];
					$.each(data["ips6_subnet"], function( ind, val ){
						let row = "<option value="+ind+">"+val.ip+"</option>";
						$("#ipv6_subnet").append(row);
						ips6_subnet[ind] = val.ip;
					});	
				}
					
			}
		});
	}
}

function loadiso(uid){
	
	if(uid == 0){
		return false;
	}	
	if(AJAX("'.$globals['index'].'act=managevps&vpsid='.$vps['vpsid'].'&ajax=true&uid="+uid, "isodetails(re)")){
		return false;
	}else{
		return true;
	}
};

change_bootorder = (ele) => {
    
    const select = document.getElementById("bootorder"); 

	if(select){
		if(select.options.length > 1){

			var selected = {};
			let prev = "";
			let pos = 0;
			let current = "";
			for (var option of select.options){
				if(option.selected) {
					prev = pos;
				}
				selected[pos] = option.value;
				pos+=1
			}
			
			if(prev !== ""){
				current = selected[prev];  
				let v1 = "";
				if(ele.id == "up"){
					v1 = selected[prev - 1];  
					if(v1 != undefined){
						selected[prev-1] = current;
					}
				}else if(ele.id == "down"){
					v1 = selected[prev + 1];  
					if(v1 != undefined){
						selected[prev+1] = current;
					}
				}   
				if(v1 != undefined){
					selected[prev] = v1;
				}
			}
			
			select.innerHTML = "";
			
			for (var key in selected) {
				
				let newOption = new Option(selected[key].toUpperCase(), selected[key], false, false);
				
				if(current === selected[key]){
					newOption = new Option(selected[key].toUpperCase(), selected[key], true, true);
				}
				select.add(newOption);
			}
		}
	}
}

function isodetails(re){
	var re = $.parseJSON(re);
	$.each(re, function(k,v){
		if((k == "iso") && ($("#iso").length > 0)){
			$("#iso").empty().append(v).trigger("chosen:updated");
		}
		if((k == "sec_iso") && ($("#sec_iso").length > 0)){
			$("#sec_iso").empty().append(v).trigger("chosen:updated");
		}
	});
};

function load_scripts(){
	processing_symb(1);
	if(AJAX("'.$globals['index'].'act=managevps&vpsid='.$vps['vpsid'].'&loadscripts=1&api=json", "scriptdetails(re)")){
		return false;
	}else{
		return true;
	}
}

function load_sshkeys(){
	$("#sshkey_list").html(\'<div class="d-flex justify-content-center my-3 w-100"><div class="loader-lg"></div></div>\');
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=users&list_ssh_keys=1&api=json&uid='.$vps['uid'].'",
		dataType : "json",
		success:function(data){
			$("#sshkey_list").empty();
			var badge = \'<div class="col-md-4 col-6 p-0">\
					<div class="row p-2 m-2 align-items-center cursor-pointer use_sshkey roundflare">\
						<i class="fas fa-key fa-1x d-inline-block mr-2"></i>\
						<span class="key_name m-0 text-break d-inline-block"> </span>\
					</div>\
					<input type="hidden" name="sshkeys[]" value="" disabled="true" />\
				</div>\';
			
			if(empty(data["ssh_keys"])) {
				$("#sshkey_list").html(\'<div class="notice w-100 mx-3"><b>'.$l['note'].' : </b> &nbsp; '.$l['sshkey_no_keys'].'</div>\');
				return false;
			}
			var button = \'<div class="mt-3 text-center add_ssh_btn"><input type="button" class="go_btn" value="Add Key" onclick="add_sshkeys(\\\'ssh_keys_form\\\')"></div>\'
			$("#sshkey_list").after(button);
			$.each(data["ssh_keys"], function(k, v){
				var $tmp = $(badge).clone();
				$tmp.data("keyid", v["keyid"]);
				$tmp.find(".key_name").text(v["keyid"]+". "+v["name"]);
				
				$tmp.click(function() {
					$(this).find(".use_sshkey").toggleClass("selected ");
					
					var selected = $(this).find(".use_sshkey").hasClass("selected");
					
					$(this).find("input").attr("disabled", !selected)
							.val(v["keyid"]);
				});
				
				$("#sshkey_list").append($tmp);
			});
		}
	});
	$("#sshkeysmodal").on("hidden.bs.modal", function (e) {
		$("#sshkey_list").empty().html(\'<div class="d-flex justify-content-center my-3 w-100"><div class="loader-lg"></div></div>\');
		$("#ssh_keys_form .add_ssh_btn").remove();
	});
}

function add_sshkeys(ele){
	processing_symb(1);
	var uid = $("#uid").val();
	var data = $("#"+ele).serialize();
	if(empty(data)){
		processing_symb(0);
		return false;
	}
	$.ajax({
		type: "POST",
		url: "'.$globals['index'].'act=managevps&add_ssh_keys=1&vpsid='.$vps['vpsid'].'&api=json",
		dataType : "json",
		data:$("#"+ele).serialize(),
		success:function(res){
			processing_symb(0);
			if("done" in res){
				showalert(res["done"]["msg"]);
			}

			// Are there any errors ?
			if(typeof(res["error"]) != "undefined"){
				setTimeout(function(){ var errors = "";
				for(x in res["error"]){
					errors = errors + res["error"][x]+ "<br>";
				}
				$("#webuzo_operation").show();
				showalert(errors ,"1"); } ,200);
			}
		}
	});
}

function install_webuzo(){
	showalert("'.$l['webuzo_install_data_lost_warn'].'" ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			var iscript_data = $("#install_script").serialize();
			$("#webuzo_operation").hide();
			processing_symb(1);	
			$.ajax({
				type: "POST",
				url: "'.$globals['index'].'act=managevps&install_script=1&vpsid='.$vps['vpsid'].'&api=json",
				dataType : "json",
				data : iscript_data,
				success:function(response){
					processing_symb();
					if("done" in response){
					setTimeout(function(){ showalert("'.$l['webuzo_install_start'].'");
						$("#webuzo_operation").hide();
						$("#alert-modal").on("hidden.bs.modal", function (e) {
						location.reload(true);
						});
					return; } ,200);
					}
					
					// Are there any errors ?
					if(typeof(response["error"]) != "undefined"){
						setTimeout(function(){ var errors = "";
						for(x in response["error"]){
							errors = errors + response["error"][x]+ "<br>";
						}
						$("#webuzo_operation").show();
						showalert(errors ,"1"); } ,200);
					}
				}
			});
		}
	});	
	
}

function webuzo_apps(stack){
	stack = stack || 0;
	if($("#stack1").data("demo") === "1"){
		$("#webuzo_stack_tr").hide();
		return;
	}
	$("#webuzo_stack_tr").slideDown("slow");	
	if(stack == \'lamp\'){
		$("#webuzo_webserver_tr").show();
	}else{
		$("#webuzo_webserver_tr").hide();
	}
}

function script_req(sid){
	
	if(sid == 0 || $("#script_isfree").val() > 0){
		return;
	}
	$("#stack1, #stack2, #stack3").prop("checked", false);
	processing_symb(1);
	if(AJAX("'.$globals['index'].'act=managevps&vpsid='.$vps['vpsid'].'&api=json&scriptreqid="+sid, "scriptdetails(re, true)")){
		return false;
	}else{
		return true;
	}
};

function scriptdetails(re, scriptreq){
	
	processing_symb();
	
	var re = $.parseJSON(re);
	scriptreq = scriptreq || false;
	
	if("error" in re){
		showalert(re["error"] ,"1");
		$("#webuzo_operation").hide();
		$("#webuzo_unsupport").show().text(re["error"]);
	}else{
		$("#webuzo_operation").show();
		$("#webuzo_unsupport").hide().text("");
	}
		
	if("webuzo_apps" in re["done"]){
		for(x in re["done"][\'webuzo_apps\']){
			var id = \'webuzo_\'+x;
			var str = "";
			var val = re["done"][\'webuzo_apps\'][x];
			str += \'<div class="row mx-auto w-100 my-2 my-0">\';
			for(k in val){
				str += \'<div class="col-4 p-0">\
				<label class="custom-control custom-radio">\
					<input type="radio" class="custom-control-input" name="\'+x+\'" id="serverver_\'+k+\'" value="\'+val[k][\'softname\']+\'">\
					<span class="custom-control-label" for="serverver_\'+k+\'">\'+val[k][\'fullname\']+\'</span>\
				</label></div>\';
			}
			str += \'</div>\';
			$("#"+id).html(str);
		}
	}
	
	if("isfree" in re["done"]){
		$("#stack2_tr, #stack3_tr").hide();
		$("#stack1").prop("checked", true).data("demo", "1");
		$("#script_isfree").val(1);
	}else{
		$("#stack2_tr, #stack3_tr").show();
		$("#stack1").data("demo", "0");
	}
	
	if(scriptreq == true){
		return;
	}
	
	var options = \'<option value="0">'.$l['none'].'</option>\';
	if("allowed_scripts" in re["done"]){	
		for(x in re["done"][\'allowed_scripts\']){
			options += \'<optgroup label="\'+x+\'">\';
			var val = re["done"][\'allowed_scripts\'][x];
			for(k in val){
				options += \'<option value="\'+k+\'">\'+val[k][\'name\']+\'</option>\';
			}
			options += \'</optgroup>\';
		}
	}
	$("#webuzo_scriptlist").html(options)
}

let toggle_bios = () => {
	
	let ele = $("#bios").val();

	if(ele === "uefi"){
		$("#tpm_row").show();
		showalert("'.$l['uefi_note'].'","2");
	}else{
		$("#tpm_row").hide();
	}		
	
}

function navigateto(window, div, tab){
	
	tab = tab || "";
	div = div || "";
	window = window || "";
	
	// If there is no window passed we will return as we do not have anything to process
	if(window == ""){
		return false;
	}	
	
	if ($("#"+window).is(":hidden")){
		$("#"+window).slideDown("fast");
		$("#"+window+"_toggle_indicator").text(" - ");
	}
	
	// If it is advanced tab we will first need to show the tab
	if(window == "advanced" && tab != ""){	
		$(".nav-tabs a[href=\"#"+tab+"\"]").tab("show");
	}
	
	// If there is not div passed we assume we have to navigate to the window itself
	if(div == ""){
		div = window;
	}
	
	setTimeout("showdiv(\'"+div+"\');", 200);
}

function showdiv(navdiv){
		
	$("body, html").animate({ 
        scrollTop: $(\'#\'+navdiv).offset().top - ($(window).height() / 2)
	}, "fast");
	
	var originalColor = $("#"+navdiv).css("background");
	
	$("#"+navdiv).css("background", "#ffffb7");
	$("#"+navdiv).css("padding", "5px");
	
	setTimeout(function(){
		$("#"+navdiv).css("background", originalColor);
	}, 3000);
}

function show_pci_warning(){
	if(document.getElementById("pci_warning_note")){
		document.getElementById("pci_warning_note").style.display = "block";
	}
}

// Flag to determine whether to apply plan changes if plan is changed
// 1: apply, 0: dont apply
var f_apply_plan = 0;

$(document).ready(function(){

	$("#gram").on("keyup change", function(e) {
		var gram = $("#gram").val();
		$("#min_ram").val(gram);
	});
	
	$("#ipv6").select2({
		width:"100%",
		placeholder:"'.$l['ips6'].'"
	});

	$("#ipv6_subnet").select2({
		width:"100%"
	});
	
	$("#editvs input, #editvs select, #editvs textarea").each(function(){
			
		var elem = $(this);
		
	   // Save current value of element
	   elem.data("oldVal", elem.val());
	  	     
	});
	
	$("input[type=checkbox]").each(function () {
			
		var elem = $(this);
		
		// Save current value of element
		if(elem.is(":checked")){
		   elem.data("ischecked", 1);
		}else{
			elem.data("ischecked", 0);
		}
		
	});
	
	var numdisks = $(".size").length;
	var numips = $(".ips").length;
	
	$("#hdd").data("numdisks", numdisks);
	$("#iplist").data("numips", numips);	
	
	$("#editvs").submit(function(){
		
		
		$("#working_div").show();
		var space = new Array();
		var size = new Array();
		var storage = new Array();
		var disk_uuid = new Array();
		var tmp_space = new Object();
		var bootord = new Array();
		let set_bootord = 0;
		let select = document.getElementById("bootorder"); 
		
		if(select){
			for (var option of select.options){
				bootord.push(option.value);
			}
		}
		
		size = $(".size").map(function(){
			return this.value;
		}).get();
		
		storage = $(".storages_list").map(function(){
			return this.value;
		}).get();
		
		disk_uuid = $(".disk_uuids").map(function(){
			return this.value;
		}).get();
		
		if($(".bus_driver")){
			bus_driver = $(".bus_driver").map(function(){
				return this.value;
			}).get();
		
			bus_driver_num = $(".bus_driver_num").map(function(){
				return this.value;
			}).get();
		}
		
		 for(i = 0; i < $(".size").length; i++){
			 
			 if($(".bus_driver")){
			 	tmp_space[i] = {size: size[i], st_uuid: storage[i], disk_uuid : disk_uuid[i], bus_driver: bus_driver[i], bus_driver_num: bus_driver_num[i]};
			 }else{
			 	tmp_space[i] = {size: size[i], st_uuid: storage[i], disk_uuid : disk_uuid[i]};
			 }
			space.push(tmp_space[i]);
		}
			
		var json_data = JSON.stringify(space);
		$("#hdd").val(json_data);
		
		var newnumdisks = $(".size").length;
		var newnumips = $(".ips").length;
		
		var ips = document.getElementsByName("ips[]");
		
		try{
			
			if($("#hdd").data("numdisks") != newnumdisks){
				$("#hdd").addClass("post_data");	
			}
			
			handle_multiselect_post($(".ips"), $("#iplist").data("numips"), newnumips, "ips[]");
								
		}catch(ere){
			
		}
		
		// This variable is used as a flag, if true (any one IP changed), then we have to post all IPs
		var toPostAllIPs = false;
		
		// This variable is used as a flag, if true (any one topology param, or cores changed),
		// then we will have to post all topology parameters
		var toPostTopology = false;
		
		$("#editvs input, #editvs select, #editvs textarea").each(function(){
			var elem = $(this);
			
			if (elem.data("oldVal") != elem.val()){
						
				var newval = elem.val();
				var oldval = elem.data("oldVal");
				
				// Is it an Object ? We need a separate handle for objects
				if(typeof(newval) == "object" || typeof(oldval) == "object"){
					
					if(handle_multiselect_post(elem, oldval, newval, elem.attr("name"))){
						
						if(["ips[]", "ipv6[]", "ipv6_subnet[]", "ips_int[]"].indexOf(elem.attr("name")) != -1){
							toPostAllIPs = true;
						}
					}
									
				}else {
					
					
					if(["ips[]", "ipv6[]", "ipv6_subnet[]", "ips_int[]"].indexOf(elem.attr("name")) != -1){
						toPostAllIPs = true;
					}else if(["topology_sockets", "topology_cores", "topology_threads", "cores"].indexOf(elem.attr("name")) != -1){
						toPostTopology = true;
					}
					
					
					
					if(elem.attr("name") == "tmp_space[]"){				
						$("#hdd").addClass("post_data");
					} else if(elem.attr("name") == "space" || elem.attr("name") == "ipv6count") {
						// Do nothing
					} else {
						elem.addClass("post_data");
					}
				}
			}
		});

		$("#hdd").addClass("post_data");
		$("#kvm_vga").addClass("post_data");
		$("#dtime1").addClass("post_data");
		$("#date1").addClass("post_data");

		// If any one IP has changed, post all IPs (IPv4, IPv6, IPv6 Subnets and Internal IPs)
		if(toPostAllIPs){
			$("input[name=\'ips[]\']").each(function(i,t){
				$(t).addClass("post_data");
			});
			$("select[name=\'ipv6[]\'], select[name=\'ipv6_subnet[]\'], select[name=\'ips_int[]\']").addClass("post_data");
		}
		
		// If any one of topology paramters including CPU core has changed, then submit "topology_sockets", "topology_cores",
		// "topology_threads" and "cores" data too
		if(toPostTopology){
			$("input[name=\'topology_sockets\'], input[name=\'topology_cores\'], input[name=\'topology_threads\'], input[name=\'cores\']").addClass("post_data");
		}
		
		var params = $(".post_data").serialize();
		
		$("input[type=checkbox]").each(function(){
			
			var elem = $(this);
			
			var ischecked = elem.is(":checked") ? 1 : 0;
			
			if((elem.data("ischecked") != ischecked)){
				
				if(elem.attr("name").includes("cpupin") && ischecked > 0){
					ischecked = elem.attr("value");
				}
				
				params = params + "&" + elem.attr("name") + "=" + ischecked;
			}	
			
		});

		if($("#disk_driver_none").is(\':checked\')){
			params = params + "&virtio=0";
		}
		if($("#virtio").is(\':checked\')){
			params = params + "&virtio=1";
		}
		if($("#scsi").is(\':checked\')){
			params = params + "&virtio=2";
		}

		if($("#demo_delete_action").is(\':checked\')){
			params = params + "&demo_action=0";
		}

		if($("#demo_suspend_action").is(\':checked\')){
			params = params + "&demo_action=1";
		}
		
		$.ajax({
			type : "POST",
			url : "'.$globals['index'].'act=managevps&api=json&vpsid='.$vps['vpsid'].'",
			data : params + "&editvps=1&theme_edit=1"+(f_apply_plan == 1 ? "&apply_plan=1" : "")+"&bootord="+bootord,
			dataType : "json",
			success: function(data){
				var done_msg = \''.$l['done'].'\';
				if("done" in data){
					if(!empty(data.done["change_pass_msg"])){
						done_msg += "<br /><b>'.$l['cpas_change_onboot'].'</b>";
					}
					var msg = "<b>'.$l['note'].' </b> &nbsp; :"+done_msg;
					showalert(msg);
					$("#alert-modal").on("hidden.bs.modal", function (e) {
					location.reload(true);
					animate_task("'.$l['edit_vps_task'].'");
					});
				}
				
				if("error" in data){

					var errors = "'.$l['following_errors_occured'].'" + "<ul>";
					for(x in data["error"]){
						if(typeof data["error"][x]  == "object"){
							$.each(data["error"][x], function(k, v){
								errors = errors + "<li>"+ v + "</li>";	
							});	
						}else{
							errors = errors + "<li>" + data["error"][x] + "</li>";
						}			
					}
					errors =  errors + "</ul>";
					showalert(errors ,"1");
				}
				$("#working_div").css("display", "none");
			}
		});
		
		window.scrollTo(0, 0);
		$("#display_error").css("display", "none");
		return false;
	});
	
});

// Constant Types, used in v_ObjCompare and v_compare
var OBJ_TYPE = "[object Object]";
var ARR_TYPE = "[object Array]";

// Compare two objects or arrays
function v_obj_compare(v1, v2){
	
	// Get both arguments type
	var typeV1 = Object.prototype.toString.call(v1);
	var typeV2 = Object.prototype.toString.call(v2);
	
	// Compare types
	if(typeV1 !== typeV2){
		return false;
	}
	
	// Check they are comparable objects or array
	if([OBJ_TYPE, ARR_TYPE].indexOf(typeV1) < 0 || [OBJ_TYPE, ARR_TYPE].indexOf(typeV2) < 0){
		return false;
	}
	
	// Compare their lengths
	var v1Len = typeV1 == ARR_TYPE ? v1.length : Object.keys(v1).length;
	var v2Len = typeV2 == ARR_TYPE ? v2.length : Object.keys(v2).length;
	
	if(v1Len !== v2Len){
		return false;
	}
	
	// Compare their values
	if(typeV1 == ARR_TYPE){
		
		for(var i = 0; i < v1.length; i++){
			if(v_compare(v1[i], v2[i]) == false){
				return false;
			}
		}
		
	}else{
		
		for(var i in v1){
			if(v_compare(v1[i], v2[i]) == false){
				return false;
			}
		}
		
	}
	return true;
	
}

// Compare any two objects or arrays or values
// Two passed arguments are equal only if their type, number of elements and values matches.
// Returns true if equal and false otherwise
// This function calls v_obj_compare() if arguments passed are array or object
function v_compare(v1, v2){
	
	// Get type
	var typeV1 = Object.prototype.toString.call(v1);
	
	// If type is Object or Array
	if([ARR_TYPE, OBJ_TYPE].indexOf(typeV1) >= 0){
		// make call to array/obj compare
		return v_obj_compare(v1,v2);
	}
	
	if(v1 !== v2){
		return false;
	}
	
	return true;
	
}

function handle_multiselect_post(ele, oldvalue, newvalue, ele_name){
	
	var changed = 0;
	
	if((oldvalue && newvalue && !v_compare(oldvalue, newvalue)) || (!oldvalue && newvalue)){
		ele.addClass("post_data");
		changed = 1;
	}else if(oldvalue && !newvalue){
		$("#editvs").append(\'<input type="text" name="\'+ele_name+\'" style="display:none" class="post_data" value="" />\');
		changed = 1;
	}
	return changed;
	
}

function add_storage_list(id, val){
	
	var z1 = id.insertCell(2);
	var y = id.insertCell(3);
	var z = id.insertCell(4);

	var str = \'<select class="custom-select storages_list" name="storages[]">\';';
	
	foreach($storages as $sk => $sv){
		echo 'str += \'<option value="'.$sv['st_uuid'].'" '.($sv['st_uuid'] == $storages[$stid]['st_uuid'] ? 'selected="selected"' : '').'>'.$sv['name'].'&nbsp;('.$sv['disk_space'].' GB '.(empty($sv['oversell']) ? $l['free'] : $l['oversell_free']).')</option>\';';
	}
	
	echo 'str += \'</select>\';
	y.innerHTML = str;
	y.style.paddingTop = "10px";
	z.style.paddingTop = "10px";
	z1.style.paddingTop = "10px";
	z1.innerHTML = "";
	z.innerHTML = \'<a class="delstorage" title="'.$l['rem_storage'].'"><i class="fas fa-times cursor-pointer py-2 text-danger"></i></a>\';
	storagedel();

	
};

add_bootorder = (iscdrom = 0) => {
	
	const select = document.getElementById("bootorder"); 
	let newOption = "";
	let val = "";
	if(select){
		if(select.options.length > 1){
			let disk = cd = 1;
				for (var option of select.options){
					if(option.value.match(/cdrom/gi)){
						cd += 1;	
					}else if(option.value.match(/disk/gi)){
						disk += 1;
					}
				}
			
			if(iscdrom){
				for(i= 1; i < cd; i++){
					val = "cdrom"+i.toString();
					newOption += "<option value=\""+val+"\">"+val.toUpperCase()+"</option>";
				}
			}
			
			if(disk > 2){
				for(i = 1; (i < disk-1); i++){
					val = "disk"+i.toString();
					newOption += "<option value=\""+val+"\">"+val.toUpperCase()+"</option>";
				}
			}else{
				val = "disk1";
				newOption += "<option value=\""+val+"\">"+val.toUpperCase()+"</option>";
			}

			if(!iscdrom){
				for(i= 1; i < cd; i++){
					val = "cdrom"+i.toString();
					newOption += "<option value=\""+val+"\">"+val.toUpperCase()+"</option>";
				}
			}

				select.innerHTML = "";
				select.innerHTML = newOption;
		}
	}
}

cdrom_bootorder = () =>{
	const select = document.getElementById("bootorder"); 
	if(document.getElementById("sec_iso") && !empty(select)){
		document.getElementById("sec_iso").onchange = function() {  
			
			if(!empty(this.value) && empty(select.querySelector("option[value=\"cdrom2\"]"))){
				let newOption = new Option("CDROM"+"2", "cdrom"+"2", false, false);
				select.add(newOption);
			}
			if(empty(this.value) && !empty(select.querySelector("option[value=\"cdrom2\"]"))){
				select.removeChild(select.querySelector("option[value=\"cdrom2\"]"));
			}
		};  
	}
	if(document.getElementById("iso") && !empty(select)){
		document.getElementById("iso").onchange = function() {  
			if(!empty(this.value) && empty(select.querySelector("option[value=\"cdrom1\"]"))){
				let newOption = new Option("CDROM"+"1", "cdrom"+"1", false, false);
				select.add(newOption);
			}
			if(empty(this.value) && !empty(select.querySelector("option[value=\"cdrom1\"]"))){
				select.removeChild(select.querySelector("option[value=\"cdrom1\"]"));
			}
		}; 
	}
}

function add_storage(id, val){

	var t = $_(id);
	var lastRow = (t.rows.length);
	var x = t.insertRow(lastRow);
	var y = x.insertCell(0);
	var z = x.insertCell(1);

	y.innerHTML = \'<input name="size" class="form-control size" type="number" min="0" size="15" value="" />\';
	z.innerHTML = \'<div class="square">'.$l['space_gb'].'</div>\';

	y.style.paddingTop = "10px";
	z.style.paddingTop = "10px";

	add_storage_list(x);

	const select = document.getElementById("bootorder"); 
	if(!empty(select)){
		let count = (parseInt(lastRow) + 1).toString();
		let newOption = new Option("DISK"+count, "disk"+count, false, false);
		select.add(newOption);
	}
	
};

function add_storage_bus(id, val){

	var t = $_(id);
	var lastRow = (t.rows.length);
	var x = t.insertRow(lastRow);
	var y = x.insertCell(0);
	var p = x.insertCell(1);
	var r = x.insertCell(2);
	var s = x.insertCell(3);
	var j = x.insertCell(4);
	var k = x.insertCell(5);
	var tot_num_disks = parseInt($("#num_disks").val()) + 1;
	$("#num_disks").val(tot_num_disks);


	var str1 = \'<select class="custom-select bus_driver" name="bus_driver[]" onchange="toggle_driver_num(this.value)" >\';';
						
	foreach($bus_driver as $bdk => $bdv){
		echo 'str1 += \'<option value="'.$bdk.'">'.$bdv.'</option>\';';
	}
							
	echo 'str1 += \'</select>\';

	var str2 = \'<select class="custom-select bus_driver_num" name="bus_driver_num[]">\';';
	
	echo 'str2 += \'<option class="sata virtio scsi" value="0" >0</option>\';';
	echo 'str2 += \'<option class="sata virtio scsi" value="1" >1</option>\';';
	echo 'str2 += \'<option class="ide sata virtio scsi" value="2" >2</option>\';';
	echo 'str2 += \'<option class="ide sata virtio scsi" value="3" >3</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="4" >4</option>\';';
	echo 'str2 += \'<option class="sata virtio scsi" value="5" >5</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="6" >6</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="7" >7</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="8" >8</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="9" >9</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="10" >10</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="11" >11</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="12" >12</option>\';';
	echo 'str2 += \'<option class="virtio scsi" value="13" >13</option>\';';
	echo 'str2 += \'<option class="virtio" value="14" >14</option>\';';
	echo 'str2 += \'<option class="virtio" value="15" >15</option>\';';


	echo 'str2 += \'</select>\';
	
	r.innerHTML = \'<input name="size" class="form-control size" type="number" min="0" size="15" value="" />\';
	s.innerHTML = \'<span class="square">'.$l['space_gb'].'</span>\';
					
	var str4 = \'<select class="custom-select storages_list" name="storages[]">\';';
	
	foreach($storages as $sk => $sv){
		echo 'str4 += \'<option value="'.$sv['st_uuid'].'" '.($sv['st_uuid'] == $storages[$stid]['st_uuid'] ? 'selected="selected"' : '').'>'.$sv['name'].'&nbsp;('.$sv['disk_space'].' GB '.(empty($sv['oversell']) ? $l['free'] : $l['oversell_free']).')</option>\';';
	}
	
	echo 'str4 += \'</select>\';
	
	y.innerHTML = str1;
	y.style.paddingTop = "10px";
	p.innerHTML = str2;
	p.style.paddingTop = "10px";
	j.innerHTML = str4;
	j.style.paddingTop = "10px";
	j.style.width="50%";
	k.style.paddingTop = "10px";
	k.innerHTML = \'<a class="delstorage" title="'.$l['rem_storage'].'"><i class="fas fa-times text-danger cursor-pointer py-2"></i></a>\';
	toggle_driver_num("sata");
	storagedel();
};

function ipdel(){
	$(".delip").each(function(){
		$(this).unbind("click");
		$(this).click(function(){
			var parent = $(this).parent().parent();
			parent.remove();
			checkippool();
		});
	});
}

function remove_all_ips(){
	$("#iptable").html("");
	$("#iplist").html("");
	let primaryIpIndex = "";
		
	if(!empty(vpsPrimaryIp)){
		primaryIpIndex = Object.keys(vpsPrimaryIp)[0];
		let row = "<option value="+primaryIpIndex+">"+vpsPrimaryIp[primaryIpIndex]+"</option>";
		$("#iplist").append(row);
	}
	
	if(!empty(ips)){

		for(x in ips){

			if(!empty(vpsPrimaryIp)){
				if(ips[x] == vpsPrimaryIp[primaryIpIndex]){
					continue;
				}
			}

			let row = "<option value="+x+">"+ips[x]+"</option>";
			$("#iplist").append(row);
		}

	}

}

function enable_accel(){
	
	if(is_checked("kvm_vga")){
		$("#enable_acceleration").show();
		$("#vga_vram_div").show();
	}else{
		$("#enable_acceleration").hide();
		$("#vga_vram_div").hide();
	}
	
}

function storagedel(){
	$(".delstorage").each(function(){
		$(this).unbind("click");
		$(this).click(function(){
			var parent = $(this).parent();
			var tot_num_disks = parseInt($("#num_disks").val()) - 1;
				$("#num_disks").val(tot_num_disks);

			if($(this).parent().prev().find("select").attr("disabled") == "disabled"){
				showalert("'.$l['del_storage_warn'].'" ,"3" ,function(confirm){
					if(confirm == false){
						return false;
					}else{
						var granparent = parent.parent();
						parent.remove();
						granparent.remove();
						add_bootorder();
					}
				});
				
			}else{
							
				var granparent = parent.parent();
				parent.remove();
				granparent.remove();
				add_bootorder();

			}
			scsi_controller();
		});
	});
}

function toggle_driver_num(driver_type){
	$(".ide, .sata, .virtio, .scsi").hide();
	$("." + driver_type).show();
	$("#bus_driver_num").val(0);
	if(driver_type == "ide"){
		$("#bus_driver_num").val(2);
	}

	if(driver_type == "virtio"){
		$("#ssd_emulation").prop("checked", false);
		$(".ssd_emulation").hide();
	}else{
		$(".ssd_emulation").show();
	}
	scsi_controller();
};

function scsi_controller(){
	var bus_driver = new Array(); 
	bus_driver = $(".bus_driver").map(function(){
		return this.value;
	}).get();
	if(bus_driver.includes("scsi")){
		$(".scsi_controller").show();
	}else{
		$(".scsi_controller").hide();
		$("#scsi_controller").val("");
	}
}
$(document).ready(function(){
	ipdel();
	storagedel();
	prox_cpu_flags();
	scsi_controller();
	
	var num_disk = "'.count($vps['disks']).'" ;
	var bus_driver = "'.$vps['disks'][0]['bus_driver'].'";

	if(bus_driver == "virtio" && num_disk == 1 ){
		$(".ssd_emulation").hide();
	}

	var bios = $("#bios").val();
	if(bios == "uefi"){
		$("#tpm_row").show();
	}
		
});

function adddnsrow(id, val){
	var t = $_(id);
	var ele = document.createElement("div");
    ele.setAttribute("class","row mx-auto w-100 my-1");
	ele.innerHTML=\'<div class="col-11 p-0"><input type="text" class="form-control" name="dns[]"  value="\'+(val || "")+\'"  size="20" /></div><div class="col-1 pr-0 pl-1 pt-2"><a class="deldns" ><i class="fas fa-times text-danger cursor-pointer"></i></a></div>\';
	t.appendChild(ele);
	
	del_dns_div("deldns");
	
};

function checkippool(){
	try{
		// Clear the Select
		while($_("iplist").options.length != 0){
			$_("iplist").remove(0);
		}
		
		vpsips = curips();
		
		for(x in ips){
			is_cur = 0;	
			for(xx in vpsips){
				if(vpsips[xx] == ips[x]){
					is_cur = 1;
				}
			}
			if(is_cur == 0){
				createOption(x, ips[x]);
			}
		}
	}catch(e){	}
	
	if($("#iplist option").length === 0){
		$("#iplist_parent").hide();
	}else{
		$("#iplist_parent").show();
	}
};

function addtoips(){
	try{
	for(i=0; i < $_("iplist").options.length; i++) {
		if ($_("iplist").options[i].selected) {
			addrow("iptable", ips[$_("iplist").options[i].value]);
		}
	}
	
	checkippool();
	
	// Make the Table again
	while($_("iptable").rows.length != 0){
		$_("iptable").deleteRow(0);
	}
	
	for(x in vpsips){
		addrow("iptable", vpsips[x]);
	}
	}catch(e){	}
};

function createOption(val, txt){
	var opt = document.createElement("option");
	opt.text = txt;
	opt.value = val;
	
	if(document.all && !window.opera){
		$_("iplist").add(opt);
	}else{
		$_("iplist").add(opt, null);
	}
};

function curips(){
	var vpsips = new Object();
	var cur_ips = document.getElementsByName("ips[]");
	for(i=0; i < cur_ips.length; i++){
		if(cur_ips.item(i).value != ""){
			vpsips[i] = cur_ips.item(i).value;
		}
	}
	return vpsips;
};

function planips(num){
	if(num > 0){
		try{
			for(i=0; i < num; i++) {
				$_("iplist").options[i].selected = true;
			}
		}catch(e){	}
		addtoips();
	}
};

function countipv6(){
	try{
		var num = 0;
		for(i=0; i < $_("ipv6").options.length; i++) {
			if($_("ipv6").options[i].selected){
				$_("ipv6").options[i].selected = true;
				num = num + 1;
			}
		}
		$_("ipv6count").value = num;
	}catch(e){	}
};

function loadplan(planid, no_confirm = 0){
	if(planid == 0){
		var uid = parseInt($_("uid").value);
		get_user_ips(uid);
		return false;
	}
	if(empty(no_confirm)){
		$("#processing_symb").show();
	}
	var uid = $("#uid").val();
	if(AJAX("'.$globals['index'].'act=managevps&pool_uid="+uid+"&vpsid='.$vps['vpsid'].'&ajax=true&plan="+planid+"&plid="+planid, "plandetails(re"+","+no_confirm+")")){
		return false;
	}else{
		return true;	
	}
};

function plandetails(re, no_confirm = 0){
	
	// Initially dont apply plan changes
	f_apply_plan = cdrom_for_boot = 0;

	// Change resources only as per plan
	eval(re);
	$.each($plan, function( index, value ){
		if(index == "plan_ips" && (typeof value == "object")){
			$("#iplist").html("");
			ips = [];
			$.each(value, function( ind, val ){
				let row = "<option value="+ind+">"+val.ip+"</option>";
				$("#iplist").append(row);
				ips[ind] = val.ip;
			});			
		}else if(index == "internal_ips" && (typeof value == "object")){
			$("#ips_int").html("");
			ips_int = [];
			$.each(value, function( ind, val ){
				let row = "<option value="+val.ip+">"+val.ip+"</option>";
				$("#ips_int").append(row);
			});
		}else if(index == "ipsv6" && (typeof value == "object")){
			//$("#ipv6").html("");
			ipv6 = [];
			$.each(value, function( ind, val ){
				let row = "<option value="+val.ip+">"+val.ip+"</option>";
				$("#ipv6").append(row);
			});
		}
		else if(index == "virtio"){
			if(value == 0){
				$("#disk_driver_none").prop(\'checked\', true);
			}else if(value == 1){
				$("#virtio").prop(\'checked\', true);
			}else if(value == 2){
				$("#scsi").prop(\'checked\', true);
			}
		}else if(index == "ipsv6_subnet" && (typeof value == "object")){
			$("#ipv6_subnet").html("");
			ipv6_subnet = [];
			$.each(value, function( ind, val ){
				let row = "<option value="+val.ip+">"+val.ip+"</option>";
				$("#ipv6_subnet").append(row);
			});
		}
	});
	$("#processing_symb").hide();
	if(!empty(no_confirm)) return false;
	showalert("'.$l['conf_apply_plan'].'" ,"3" ,function(confirm){
		
		if(confirm == false){
			return false;
		}else{
			// We need to apply plan changes too
			f_apply_plan = 1;
			var topology_enabled = 0;
			try{
				if($plan["virtio"] == 1){
					if(!$_("virtio").checked){
						virtio_warning();
					}
				}else{
					if($_("virtio").checked){
						virtio_warning();
					}
				}
			}catch(e){
				// Do not do anything !
			}
			
			$.each($plan, function( index, value ){
				
				if(index == "io") index = "priority";
				if(index == "swap") index = "swapram";
				
				if(index == "data"){
					
					if(!empty($plan["data"])){
						$.each($plan["data"], function(d_k, d_v){
							$("#editvs").field(d_k, d_v);
							if($("#"+d_k).prop("type") == "checkbox" || $("#"+d_k).prop("type") == "radio"){
								$("#"+d_k).prop("checked", (!empty(d_v) ? 1 : 0));
							}
						});
						if(!empty($plan["dtime1"])){
							$("#dtime1").val($plan["dtime1"]);
							$("#date1").val($plan["date1"]);
							$("#demo_edit").prop("checked", 1);
							if(!empty($plan["data"]["demo"]["action"])){
								$("#demo_suspend_action").prop("checked", true);
							}else{
								$("#demo_delete_action").prop("checked", true);
							}
						}else{
							$("#demo_edit").prop("checked", 0);
							$("#dtime1").val("");
							$("#date1").val("");
						}

						enable_vertical_scaling('.$globals['enable_ver_scaling'].');
						if(!empty($plan["data"]["vga_vram"])){
							enable_accel();
						}

						if(!empty($plan["data"]["cpu_flags"])){
				
							var cpu = $("#cpu_mode").val();
							prox_cpu_flags();
							var cpu_flag =  $plan["data"]["cpu_flags"];
							var cpu_info = '.json_encode($cpu_info).';
							var cpu_keys = '.json_encode(array_keys($cpu_info)).';
							$.each(cpu_keys, function(k, v){
								if(cpu_info[v]["cpu_mode"].includes(cpu)){
								
									var mapper = [];
									mapper[0] = "default";
									mapper[1] = "on";
									mapper[2] = "off";
									let execptions = [];
									if(!empty(cpu_info[v]["exception"])){
										$.each(cpu_info[v]["exception"], function(k,v){
											if(v in cpu_flag){
												execptions.push(v);
												$("#"+v+"-"+mapper[cpu_flag[v]]).prop(\'checked\', true);
											}
										})
									}
			
									$.each(cpu_info[v]["cpu_flags"], function(k,v){
										if(!(v in execptions)){
											$("#"+v+"-"+mapper[cpu_flag[v]]).prop(\'checked\', true);
										}
									})
							
								}
							})
						}

					}

				}

				if(index == "mgs"){
					$("#mg option:selected").removeAttr("selected");
					for(var i=0; i<$_("mg").options.length; i++){
						$_("mg").options[i].style.display = "";
						if(value.includes($_("mg").options[i].value)){
							$($_("mg").options[i]).prop("selected", true);
						}
					}
				}else if(index == "dns_nameserver" && (typeof value == "object")){
					$("#dnstable").html("");
					$.each(value, function( ind, val ){
						adddnsrow(\'dnstable\', val);
					});
				}else if(index == "plan_ips" && (typeof value == "object")){
					$("#iplist").html("");
					ips = [];
					$.each(value, function( ind, val ){
						let row = "<option value="+ind+">"+val.ip+"</option>";
						$("#iplist").append(row);
						ips[ind] = val.ip;
					});			
				}else if(index == "internal_ips" && (typeof value == "object")){
					$("#ips_int").html("");
					ips_int = [];
					$.each(value, function( ind, val ){
						let row = "<option value="+val.ip+">"+val.ip+"</option>";
						$("#ips_int").append(row);
					});
				}else if(index == "ipsv6" && (typeof value == "object")){
					$("#ipv6").html("");
					ipv6 = [];
					$.each(value, function( ind, val ){
						let row = "<option value="+val.ip+">"+val.ip+"</option>";
						$("#ipv6").append(row);
					});
				}else if(index == "ipsv6_subnet" && (typeof value == "object")){
					$("#ipv6_subnet").html("");
					ipv6_subnet = [];
					$.each(value, function( ind, val ){
						let row = "<option value="+val.ip+">"+val.ip+"</option>";
						$("#ipv6_subnet").append(row);
					});
				}else if(index == "load_balancer"){
					//do nothing
				}else{	
					$("#editvs").field( index, value);
					if(!empty($plan["data"]["custom_cpu_model"])){
						$("#cpu_mode").val($plan["data"]["custom_cpu_model"]);
					}

					scsi_controller();
					
					if((index == "topology_sockets" || index == "topology_cores" || index == "cpu_threads") && (!empty(value)) && (empty(topology_enabled))){
						$("#enable_cpu_topology").prop("checked", true);
						topology_enabled = 1;
					}
				}

				if(index == "iso" ){
					$("#iso").trigger("change"); // trigger onchange so that we can add bootorder
					cdrom_for_boot = 1;
				}
				
				if(index == "sec_iso"){
					$("#sec_iso").trigger("change");
					cdrom_for_boot = 1;
				}
				
			});

			if(cdrom_for_boot){
				add_bootorder(1);
			}
			
			$_("hdd_0").value = $plan["space"];

			$("#ipv6count").val(parseInt($plan["ips6"]));
			ipchoose("ipv6", $plan["ips6"]);
			ipchoose("ips_int", $plan["ips_int"]);
			ipchoose("ipv6_subnet", $plan["ips6_subnet"]);
			
			if(document.getElementsByName("ips[]").length < $plan["ips"]){
				var diff = $plan["ips"] - document.getElementsByName("ips[]").length;
				planips(diff);
			}
			
			$(".virt-select, .chosen").select2({width:"100%"});
			checkvnc();
			checkdemo();
			cputopology();
			handle_capping();
			enable_vertical_scaling('.$globals['enable_ver_scaling'].');
			checkcputhreshold();
			setTimeout("toggle_bios()", 1000);

		}
	});
		
	if(!empty($plan["bus_driver"])){
		toggle_driver_num($plan["bus_driver"])
	}
	
};

function changepriority(priority){
	if(!$_("prior")){
		return false;
	}
	$_("prior").value = priority;
};

function pincheck(){
	if(!$_("allcores")){
		return false;
	}
	if(is_checked("allcores")){';
		for($i=0; $i < $resources['cpucores']; $i++){
			echo '$_("pin'.$i.'").checked = 0;';
		}
		echo '$("#pincores").hide();
	}else{
		$("#pincores").show();
	}
};

function toggle_option(option){
	if ($("#"+option).is(":hidden")){
		$("#"+option).slideDown("slow");
		$("#"+option+"_toggle_indicator").text(" - ");
	}else{
		$("#"+option).slideUp("slow");
		$("#"+option+"_toggle_indicator").text(" + ");
	}
}

function setpwd(size){
	var pwd = randstr(size, 1, '.(!empty($globals['pass_strength']) ? $globals['pass_strength'] : 0).');
	$("#newpass").val(pwd);
	$("#conf").val(pwd);
}

// Match the passwords
function pass_match(){
	var newpass = $("#newpass").val();
	var conf = $("#conf").val();
	
	if(newpass != conf){
		$("#message").text("'.$l['pass_match'].'");
		$("#message").css("color", "red");
	}else{
		$("#message").text("");
	}
}

function plus_onmouseover(){
	$("#plus").attr("src", "'.$theme['images'].'admin/plus_hover.gif");
}

function plus_onmouseout(){
	$("#plus").attr("src", "'.$theme['images'].'admin/plus.gif");
}

function checkvnc(){
	
	if(!$("#vnc")){
		return false;
	}
	
	if(is_checked("vnc")){
		$("#vncpassrow").show();
		$("#launchvnc").show();
		$("#vnckeymap").show();
		
	}else{
		$("#vncpassrow").hide();
		$("#launchvnc").hide();
		$("#vnckeymap").hide();
	}
};

function change_checkbox(id){	
	if(is_checked(id)){
		$("#hidden_"+id).val(1);
	}else{
		$("#hidden_"+id).val(0);
	}
}

function checkdemo(){
	if(!$("#demo_edit")){
		return false;
	}
	if(is_checked("demo_edit")){
		$("#demotime").show();
		$("#demodate").show();
		$("#demo_action_options").show();
	}else{
		$("#demotime").hide();
		$("#demodate").hide();
		$("#demo_action_options").hide();
	}
	change_checkbox("demo_edit");
};

function ispvonhvm(){
	
	var pv_on_hvm = false;
	if(!$("#pv_on_hvm")){
		pv_on_hvm = false;
	}else{
		if(is_checked("pv_on_hvm")){
			pv_on_hvm =  true;
		}
	}
	
	if($("#tr_viftype")){
		if(pv_on_hvm){
			$("#tr_viftype").hide();
		}else{
			$("#tr_viftype").show();
		}
	}
	return true;
};

var lang = Array();
lang["bad"] = "'.$l['bad'].'";
lang["good"] = "'.$l['good'].'";
lang["strong"] = "'.$l['strong'].'";
lang["short"] = "'.$l['short'].'";
lang["strength_indicator"] = "'.$l['strength_indicator'].'";

//save the state of disk driver.
var saved_disk_driver;

$(document).ready(function(){
	if($("#disk_driver_none").is(\':checked\')){
		saved_disk_driver = $("#disk_driver_none");
	}else if($("#virtio").is(\':checked\')){
		saved_disk_driver = $("#virtio");
	}else if($("#scsi").is(\':checked\')){
		saved_disk_driver = $("#scsi");
	}
	enable_vertical_scaling('.$globals['enable_ver_scaling'].');
	';
	
	if(!$kernel->features('multiple_disk_support', $vps['_virt'])){
		echo '$_("add_storage").style.display = "none";';
	}

echo'});

function virtio_warning(e){

	var isenabled = $(saved_disk_driver).is(\':checked\');
	
	var r = confirm("'.$l['virtio_warning'].'");
	
	if(!r){
		
		// preserve the state if user click on cancel
		// we do this invertly as isenabled get the state as after change bcoz event is called on onchange.
		if(isenabled){
			$(saved_disk_driver).prop(\'checked\', false);
		}else{
			$(saved_disk_driver).prop(\'checked\', true);
		}
	}else{
		saved_disk_driver = e;
	}
	
};

function checkcputhreshold(){
	if($("#enable_cpu_threshold").prop("checked")){
		$("#cputhresholdpercentage").css("display", "");
		$("#enable_cpu_threshold").val(1);
	}else{
		$("#cputhresholdpercentage").css("display", "none");
		$("#cpu_threshold").val(0);
		$("#cpu_threshold_time").val(0);
	}
	change_checkbox("enable_cpu_threshold");
};

function custom_valert(output_msg, title_msg)
{
	if (!title_msg)
		title_msg = "Success!";

	if (!output_msg)
		output_msg = "No Message to Display.";

	$("<div></div>").html(output_msg).dialog({
		title: title_msg,
		resizable: true,
		buttons: {
            "Close": function() 
            {
                $(this).dialog( "close" );
            }
        },
		modal: true,
		width: 350,
		maxHeight: 250
	});
}


function edit_action(action){
	var id = '.$vps['vpsid'].'; 
	$("#small-loader").fadeIn();
	if(action == "lock" || action == "unlock"){
		var lock_mgs = new Array();
		lock_mgs["lock"] = "'.$l['title_lock'].'";
		lock_mgs["unlock"] = "'.$l['title_unlock'].'";
		$("#"+action).empty();
	}
	
	if(action == "start" || action == "stop" || action == "restart" || action == "poweroff"){
		var lang = new Array();
		lang["start"] = "'.$l['title_start'].'";
		lang["restart"] = "'.$l['title_restart'].'";
		lang["stop"] = "'.$l['title_stop'].'";
		lang["poweroff"] = "'.$l['title_poweroff'].'";
		animate_task(lang[action]+" '.$l['vpsaction_task'].'");
	}

	if(action == "start" || action == "stop" || action == "restart" || action == "poweroff" || action == "ssh" || action == "suspend" || action == "unsuspend" || action == "suspend_net" || action == "unsuspend_net" || action == "lock"|| action == "unlock"){
		
			var reason = $("#lock_reason").val();
			var suspendreason = $("#suspend_reason").val();
			var finalreason = ((!reason) ? ("'.$globals['index'].'act=vs&action="+action+"&vpsid="+id+"&api=json&suspend_reason="+suspendreason+"&random="+Math.random()) : ("'.$globals['index'].'act=vs&action="+action+"&vpsid="+id+"&api=json&reason="+reason+"&random="+Math.random()));
			$.ajax({type: "POST",
			url: finalreason,
			success:function(response){
				response_data = JSON.parse(response);
				if(action == "lock" || action == "unlock"){
					location.reload(true);
				}
				if(response_data.error_msg){
					showalert(response_data.error_msg + "\n" + response_data.vsop["output"] + "<br>" ,"1","", response_data.vsop["taskid"]);
				}else if(response_data.done_msg){
					changestatus(action);
					showalert(response_data.done_msg, "", "", response_data.vsop.taskid);
				}else{
					showalert("'.$l['alert_failure'].'", "1");
				}

				$("#small-loader").fadeOut();
			}
		});
		gettaskscount();
	}
};

function bwresert(){
	
	var id = '.$vps['vpsid'].';
	
	showalert("'.$l['conf_bwreset'].'" ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			$("#bwresert_img").attr("src","'.$theme['images'].'loading_50.gif");
			$("#small-loader").fadeIn();
			$.ajax({type: "POST",
				url: "'.$globals['index'].'act=managevps&bwreset="+id+"&api=json&vpsid="+id,
				success:function(response){
					$("#small-loader").fadeOut();
					response_data = JSON.parse(response);
					
					if(response_data.error_msg){
						setTimeout(function(){showalert(response_data.error_msg, "1");} ,200);
					}else if(response_data.done_msg){
						setTimeout(function(){showalert(response_data.done_msg);} ,200);
					}else{
						setTimeout(function(){showalert("'.$l['alert_failure'].'", "1");} ,200);
					}
					$("#bwresert_img").attr("src","'.$theme['images'].'bandwidth.png");
				}
			});	
		}
	});	
}

function launchvnc(type){
	if(type === 1){
		var thisURL = window.location.href;
		thisURL = thisURL.toString();
		thisURL = thisURL.replace("http:", "https:");
		thisURL = thisURL.replace(":4084", ":4085");
		window.open("'.$globals['index'].'act=vnc&novnc='.$vps['vpsid'].'", "_blank", "height=400,width=720");
	}else if(type === 2){
		AJAX("'.$globals['index'].'act=vnc&ajax='.$vps['vpsid'].'", "vnchandle(re)");
	}
};

function netspeed(r){
	$_("network_speed").value = r;
	handle_capping();
}
function upspeed(r){
	$_("upload_speed").value = r;
	handle_capping();
}

function vnchandle(resp){
	$("#vnc_launcher").html(resp);
}

function update_progress(id, per){
	
	$("#"+id).css("width", per+"%");
	if(per < 40){
			$("#"+id).addClass("progress-bar bg-success");
	}else if(per < 60){
			$("#"+id).addClass("progress-bar bg-info");
	}else if(per < 80){
			$("#"+id).addClass("progress-bar bg-warning");
	}else{
			$("#"+id).addClass("progress-bar bg-danger");
	}
	
	$("#"+id).html(per+"%");

}

function rescue_ops(){
	var vpsid = '.$vps['vpsid'].';
	
	var rescue = '.$vps['rescue'].';
	
	// Disable rescue
	if(rescue == 1){
		
		var content = $("#rescue_content").html();
		var loading = \'<center><br /><br /><br /><div class="loader-lg"></div><br /><br /><br /><label class="val">'.$l['disabling_rescue'].'</label></center>\';
		
		$("#rescue_content").empty();
		$("#rescue_content").append(loading);
		$("#rescue_operation").hide();	
		
		animate_task("'.$l['dis_rescue_task'].'");

		$.ajax({type: "POST",
				url: "'.$globals['index'].'act=managevps&disable_rescue="+vpsid+"&vpsid="+vpsid+"&api=json",
				dataType : "json",
				success:function(response){
					
					if("done" in response){
						actid = response["actid"];
						progress_update = "'.$l['disabling_rescue'].'";
						
						$("#rescue_content").html("<div id=\"progress_onload\"></div><br /><br />");
						progress_onload();
						
						$("#progress-cont").show();
						$("#progressbar").progressbar({value: 0});
						
						setTimeout("get_progress(\'disable_rescuevs\')", 500);
						
						return;
					}
					
					// Are there any errors ?
					if(typeof(response["error"]) != "undefined"){
						var errors = "";
						for(x in response["error"]){
							errors = errors + response["error"][x];
						}
						showalert(errors ,"1");
					}
					
					$("#rescue_content").empty();
					$("#rescue_content").append(content);
					$("#rescue_operation").removeAttr("disabled");
					
				}
		});
	
		
	// Enable rescue	
	}else{
		
		var loading = \'<center><br /><br /><br /><div class="loader-lg"></div><br /><br /><br /><label class="val">'.$l['enabling_rescue'].'</label></center>\';
		
		var content = $("#rescue_content").html();
		
		var rescuedata = new Object();
		
		rescuedata["rescue_pass"] = $("#rescue_pass").val();
		rescuedata["conf_rescue_pass"] = $("#conf_rescue_pass").val();
		
		$("#rescue_content").empty();
		$("#rescue_content").append(loading);
		$("#rescue_operation").hide();
		
		animate_task("'.$l['ena_rescue_task'].'");

		$.ajax({type: "POST",
				url: "'.$globals['index'].'act=managevps&enable_rescue="+vpsid+"&vpsid="+vpsid+"&api=json",
				dataType : "json",
				data : rescuedata,
				success:function(response){
					
					if("done" in response){
						actid = response["actid"];
						progress_update = "'.$l['enabling_rescue'].'";
						
						$("#rescue_content").html("<div id=\"progress_onload\"></div><br /><br />");
						progress_onload();
						
						$("#progress-cont").show();
						$("#progressbar").progressbar({value: 0});
						
						setTimeout("get_progress(\'enable_rescuevs\')", 500);
						
						return;
					}
					
					// Are there any errors ?
					if(typeof(response["error"]) != "undefined"){
						var errors = "";
						for(x in response["error"]){
							errors = errors + response["error"][x];
						}
						showalert(errors ,"1");
					}
					
					$("#rescue_content").empty();
					$("#rescue_content").append(content);
					$("#rescue_operation").removeAttr("disabled");
				}
		});
		
	}
	
}

function rescuedonefunc(act, error){
	
	error = error || 0;
	
	if(act == "enable_rescuevs"){
		
		if(empty(error)){
			showalert("'.$l['success_enable_rescue'].'");
		}else{
			showalert("'.$l['err_enable_rescue'].'" ,"1");
		}
		
	}else if(act == "disable_rescuevs"){
		
		if(empty(error)){
			showalert("'.$l['success_disable_rescue'].'");
		}else{
			showwalert("'.$l['err_disable_rescue'].'" ,"1");
		}
	}
	
	$("#alert-modal").on("hidden.bs.modal", function (e) {
		location.reload(true);
	});
}

var cancel_renew_flag = 0;
function backup_single_vm(URL, ele) {
	var og_img = $(ele).find("img").attr("src");
	$(ele).find("img").attr("src","'.$theme['images'].'loading_50.gif");
	showalert("'.$l['bak_now_confirm'].'", "3" ,function(confirm){
		if(confirm == false){
			if(empty(cancel_renew_flag)){
				cancel_renew_flag = 0;
				$(ele).find("img").attr("src",og_img);
			}
			return false;
		}else{
			cancel_renew_flag = 1;
			$("#small-loader").fadeIn();
			$.ajax({
				type: "POST",
				url: URL,
				dataType : "json",
				success: function(response){
						$("#small-loader").fadeOut();
						$(ele).find("img").attr("src",og_img);
						animate_task("'.$l['back_now_task'].'");
						if(!response["error"]){
							showalert(response["done"]["msg"]);
						}else{
							showalert(response["error"][0], "1");
						}
						
					}
			});
		}
	});
};

function show_loading(id) {
	$("#" + id).html("<div class=\"d-flex justify-content-center py-5 my-5\"><div class=\"loader-lg\"></div></div>");
}

function data_table(selector) {
	$(selector).dataTable({
		"language": {
			"lengthMenu": "'.$l['show'].' _MENU_ '._ucfirst($l['entries']).'",
			"search": "'.$l['search'].':",
			"info": "'.$l['showing'].' _START_ '.$l['to'].' _END_ '.$l['of'].' _TOTAL_ '.$l['entries'].'",
			"infoEmpty": "'.$l['showing'].' 0 '.$l['to'].' 0 '.$l['of'].' 0 '.$l['entries'].'",
			"zeroRecords": "'.$l['no_data_avail'].'",
			"emptyTable": "'.$l['no_data_avail'].'",
			"infoFiltered": "('.$l['filtered_from'].' _MAX_ '.$l['total_entries'].')",
			"paginate": {
				"first":      "'.$l['first'].'",
				"last":       "'.$l['last'].'",
				"next":       "'.$l['next'].'",
				"previous":   "'.$l['previous'].'"
			}
		}
	});
}

function show_subnets() {
	show_loading("manage_subnets_body");
	
	$.ajax({
		type : "GET",
		url : "'.$globals['index'].'act=managevps&managesubnets=1&api=json&vpsid='.$vps['vpsid'].'",
		dataType : "json",
		success: function(data){
			$("#manage_subnets_body").html("");
			
			if("error" in data) {
				if(typeof data["error"] != "object"){
					data["error"] = [data["error"]];
				}
		
				var error = "<ul>";
				$.each(data["error"], function(k, err){
					error += "<li>"+err+"</li>";
				});
				error += "</ul>";
				showalert(error, 1);
				
				return;
			}
			
			var subnet_table = "<table class=\"table table-hover tablesorter data-table\" width=\"100%\"><thead><tr><th width=\"70%\">'.$l['ips6_subnet'].'</th><th>'.$l['edit'].'</th></tr></thead>";

			// Prepare the list
			for(x in data["ips2"]){

				$v = data["ips2"][x];

				subnet_table += "<tr><td align=\"center\">" + $v["ip"] + "/" + $v["ipr_netmask"] + "</td><td align=\"center\" id=\"data-subnet\" data-subnet=\"" + $v["ip"] + "/" + $v["ipr_netmask"] + "\" class=\"manage_subnet\"><i class=\"fas fa-edit cursor-pointer text-warning\" onclick=\"get_subnet_ips(this);\"></i></td></tr>";

			}

			subnet_table += "</table>";

			$("#manage_subnets_body").html(subnet_table);
			
			data_table(".data-table");
		}
	});
}

function get_subnet_ips(el) {
	var subnet = $(el).closest("td").data("subnet");
	
	show_loading("manage_subnets_body");
	
	$.ajax({
		type : "POST",
		url : "'.$globals['index'].'act=managevps&managesubnets=1&api=json&vpsid='.$vps['vpsid'].'",
		data : "subnet="+subnet,
		dataType : "json",
		success: function(data){
			show_subnet_ips(data);
		}
	});
}

function show_subnet_ips(data) {
	$("#show_subnets_loader").hide();
	if("error" in data) {
		if(typeof data["error"] != "object"){
			data["error"] = [data["error"]];
		}

		var error = "<ul>";
		$.each(data["error"], function(k, err){
			error += "<li>"+err+"</li>";
		});
		error += "</ul>";
		showalert(error, 1);
		
		return;
	}
	
	$("#manage_subnets_body").html("");
	
	if(data["ipr_ips"]) {
		var html = "<table class=\"table table-hover tablesorter data-table\" width=\"100%\"><thead><tr><th width=\"70%\">'.$l['ips6_subnet'].'</th><th>'.$l['delete'].'</th></tr></thead>";
		
		var inputs = "";
		
		if($.isArray(data["ipr_ips"]["ipv6"])) {
			var ipv6 = data["ipr_ips"]["ipv6"];

			// Prepare the list
			for(x in ipv6){
				
				$v = ipv6[x];

				html += "<tr><td align=\"center\"><div class=\"d-flex align-items-center justify-content-center\">" + $v + "<div class=\"ml-2 loader\" style=\"display:none;\" id=\"subnet_loader_"+x+"\"></div></div></td><td align=\"center\" id=\"data-subnet\" data-ip=\"" + $v + "\" class=\"manage_subnet\"><i class=\"fas fa-trash cursor-pointer text-danger\" onclick=\"delete_ip(\'" + $v + "\', \'subnet_loader_"+x+"\');\"></i></td></tr>";
				
				inputs += "<input type=\"hidden\" name=\"new_ipv6[]\" value=\"" + $v + "\" />";
			}
		}

		html += "</table><form id=\"manage_subnets_form\">" + inputs + "<input type=\"hidden\" name=\"new_ipv6[]\" value=\"\" id=\"input_new_ipv6\" disabled/><input type=\"hidden\" name=\"ipv6_addr\" value=\"" + data["ipr_ips"]["ipv6_addr"] + "\" /><input type=\"hidden\" name=\"ipv6_subnet_mask\" value=\"" + data["ipr_ips"]["ipv6_subnet_mask"] + "\" /></form>";
	
		// Show add ip form
		var ipv6_parts_arr = data["ipr_ips"]["ipv6_addr"].split(":");
		var subnet_length = 8 - data["ipr_ips"]["ipv6_subnet_mask_value"];

		var ipv6_input_boxes = new Array();
		
		for(var i = 0; i < subnet_length; i++){
			ipv6_input_boxes[i] = "<input type=\"text\" class=\"form-control d-inline-block w-auto input-sm ipv6_parts\" name=\"ipv6_parts[]\" value=\"" + ipv6_parts_arr[i] + "\" disabled=\"disabled\" size=\"4\" maxlength=\"4\"></input>";
		}
		
		for(i = i; i < 8; i++){
			ipv6_input_boxes[i] = "<input type=\"text\" class=\"form-control d-inline-block w-auto input-sm ipv6_parts\" name=\"ipv6_parts[]\" value=\"\" size=\"4\" maxlength=\"4\"></input>";
		}
		
		html += "<br /><table class=\"table table-responsive shadow-none\"><tr><td width=\"150\"><label>'.$l['add_an_ipv6_addr'].'</label></td><td><div class=\"d-flex align-items-center w-100\">";
		
		html += ipv6_input_boxes.join("&nbsp;:&nbsp;");
		
		html += "<div class=\"ml-2 loader\" style=\"display:none;\" id=\"show_subnets_loader\"></div></div></td></tr></table><br /><center><button class=\"go_btn\" onclick=\"add_ipv6(); return false;\">'.$l['manage_subnets_add_ip'].'</button>&nbsp;&nbsp;<button class=\"btn\" onclick=\"show_subnets(); return false;\">'.$l['back'].'</button></center>";

		$("#manage_subnets_body").html(html);
		
		data_table(".data-table");
	}
}

function add_ipv6() {
	var parts = new Array();
	
	$(".ipv6_parts").each(function() {
		parts.push($(this).val());
	});
	
	$("#show_subnets_loader").show();
	$("#input_new_ipv6").prop("disabled", false);
	$("#input_new_ipv6").val(parts.join(":"));
	$.ajax({
		type : "POST",
		url : "'.$globals['index'].'act=managevps&managesubnets=1&api=json&vpsid='.$vps['vpsid'].'",
		data : $("#manage_subnets_form").serialize(),
		dataType : "json",
		success: function(data){
			show_subnet_ips(data);
		}
	});
}

function delete_ip(ip, loader_id) {
	$("#manage_subnets_form input[value=\'" + ip + "\']").remove();
	$("#"+loader_id).show();
	$.ajax({
		type : "POST",
		url : "'.$globals['index'].'act=managevps&managesubnets=1&api=json&vpsid='.$vps['vpsid'].'",
		data : $("#manage_subnets_form").serialize(),
		dataType : "json",
		success: function(data){
			$("#"+loader_id).hide();
			show_subnet_ips(data);
		}
	});
}

//-----------------------------------MANAGE VDF------------------------------

vdf_vpsuuid = "'.$vps['uuid'].'";
vdf_serid = '.$vps['serid'].';
var is_editvs = 1;
vdf_edit_ico = "fa fa-edit";
vdf_save_ico = "fas fa-save";
vdf_delete_ico = "fa fa-trash";
vdf_revert_ico = "fas fa-undo";

function show_managevdf_window(){
	//show_loading("managevdf_body");
	vdf_url = "'.$globals['index'].'act=managevps&managevdf=1&api=json&vpsid='.$vps['vpsid'].'";
	processing_symb(1);
	$.ajax({
		type : "GET",
		url : vdf_url,
		method : "post",
		dataType : "json",
		success: function(data){
			processing_symb(0);
			$arr_haproxy_src_ips = data["arr_haproxy_src_ips"];
			$supported_protocols = data["supported_protocols"];
			$haproxydata = data["haproxydata"];
			$vpses = data["vpses"];
			$arr_haproxy_src_ips = data["arr_haproxy_src_ips"];
			$server_haconfigs = data["server_haconfigs"];
			
			//List current VDF entries
			listvpsforwardertbl();
			
			// Hide add VDF form if it was visible previously and show add vdf form button
			$("#addvdf_form_div").hide();
			$("#showaddvdfformbtn").show();
			// Adjust button margin
			$("#showaddvdfformbtn button").css("margin-right", "10px");
			
		}
	});
}

//---------------------------MANAGE VDF ENDS------------------------------

function copy_password(){
	
	showalert("'.$l['copy_pass'].'<br><a id=\"a_newpass_txt\" href=\"javascript:copy($(\'#a_newpass_txt\'),\'a_newpass_txt\')\"><span class=\"copyflare\" style=\"font-size:14px\">"+$("#newpass").val()+"</span></a>" ,"2");
	$("#alert-modal").on("hidden.bs.modal", function (e) {
		return false;
	});
};

function create_inf(){
	window.open("'.$globals['index'].'act=managevps&create_inf=1&vpsid='.$vps['vpsid'].'","_self");
	//showalert("'.$vps['vpsid'].'_'.parse_backup_hostname($vps['hostname']).'.inf'.' file saved in /var/virtualizor/vps_inf/");
}

$(document).ready(function(){

	var band_per = '.(!empty($vps['band_per']) ? $vps['band_per'] : 0).';
	update_progress("bandwidth_bar", band_per);
	
	var disk_per = '.(!empty($vps['disk_per']) ? $vps['disk_per'] : 0).';
	update_progress("disk_bar", disk_per);
	
	var cpu_per = '.(!empty($vps['stats']['used_cpu']) ? $vps['stats']['used_cpu'] : 0).';
	update_progress("cpu_bar", cpu_per);
	
	var ram_per = '.(!empty($vps['stats']['used_ram_per']) ? $vps['stats']['used_ram_per'] : 0).';
	update_progress("ram_bar", ram_per);
	
	if($("#iplist option").length === 0){
		$("#iplist_parent").hide();
	}';

	if(!$kernel->features('multiple_disk_support', $vps['_virt'])){
		echo '$("#add_storage").css("display", "none");';
	}

	echo'
	$("#manage_subnets").on("show.bs.modal", function (event) {
		show_subnets();
	});
	$("#managevdf").on("show.bs.modal", function (event) {
		show_managevdf_window();
	});	
	
	$("#reos").click(function(){
	
		$("#rebuild_error_row").hide();
		
		showalert("'.$l['rebuild_data_lost_warn'].'" ,"3" ,function(confirm){
			if(confirm == false){
				return false;		
			}else{
				progress = 0;
				var params = "";
				newvs_rootpass = $("#newpass").val();
			
				conf = $("#conf").val();
				
				if(newvs_rootpass != conf){
					showalert("'.$l['pass_match'].'");
					return false;
				}
				
				var vpsid = '.$vps['vpsid'].';
				
				var serid = '.$vps['serid'].';
				
				var osid = $("#osid option:selected").val();
						
				var recipe = $("#recipe").val();	
				
				var sshkey = $("#sshkey").val();

				remove_old_ssh_keys = 0;
				if(document.getElementById("remove_old_ssh_keys").checked){
					remove_old_ssh_keys = 1;
				}

				eu_send_rebuild_email = 0;
				if(document.getElementById("eu_send_rebuild_email").checked){
					eu_send_rebuild_email = 1;
				}	

				format_primary = 0;
				if($("#format_primary").length > 0 && document.getElementById("format_primary").checked){
					format_primary = 1;
				}
				
				params = "osid="+osid+"&newpass="+encodeURIComponent(newvs_rootpass)+"&conf="+encodeURIComponent(conf)+"&reos=1&vpsid="+vpsid+"&remove_old_ssh_keys="+remove_old_ssh_keys+"&eu_send_rebuild_email="+eu_send_rebuild_email+"&format_primary="+format_primary+(recipe != null ? "&recipe[]="+recipe.join("&recipe[]=") : "");
				if(!empty(sshkey)){
					params += "&sshkey="+encodeURIComponent(sshkey)
				}
				
				//var content = $("#form-container").html();
				var loading = \'<center><br /><br /><br /><img height="70px" width="70px" src="'.$theme['images'].'loading_50.gif" /><br /><br /><br /><label class="val">'.$l['checking_data'].'</label></center>\';
				
				$("#form-container").parent().hide();
				$("#rebuild_content").html(loading);
				//$("#reos").attr("disabled","disabled");
				$.ajax({type: "POST",
					url: "'.$globals['index'].'jsnohf=1&act=rebuild&changeserid="+serid,
					data:params,
					success:function(response){
						if(!isNaN(response)){
							animate_task("'.$l['rebuild_task'].'");	
							gettaskscount();
							actid = response;					
							$("#rebuild_content").html("<div id=\"progress_onload\"></div>");
							progress_onload();
							$("#pbar").html("'.$l['checking_data'].'" + " ( 0% ) ");
							$("#progress-cont").show();
							$("#progress-cont").append("<br /><br />");
							$("#progressbar").progressbar({value: 0});
							
							setTimeout("get_progress(\'rebuild\')", 500);
							
							return;
						}else{
							gettaskscount();
							$("#rebuild_content").empty();			
							$("#form-container").parent().show();
							$("#rebuild_error_row").show();
							$("#rebuild_error").html($(response).find("#error_box"));
						}
					}
				});	
			}
		});
	});

	$("#rebuildmodal").on("show.bs.modal", function (e) {
		// do something...
		$("#rebuild_content").empty();
		$("#rebuild_error_row").hide();
		$("#form-container").trigger("reset");
		$("#form-container").parent().show();
	});
	
	load_ajax_user("uid", "'.$globals['index'].'act=managevps&vpsid='.$vps['vpsid'].'&api=json&load_ajax_user=1");
});


var lang_no_limit = "'.$l['no_limit'].'";

addonload("handle_capping(); fillspeedkBps(); planips(0); checkippool(); adduser(); changepriority(\''.POSTval('priority', $vps['io']).'\'); checkvnc(); countipv6(); pincheck(); ispvonhvm();check_pass_strength(\'rootpass\');enable_accel();cputopology();changestatus();check_pass_strength();cdrom_bootorder();checkdemo();checkcputhreshold();");

</script>
<!--<div class="alert alert-warning" style="text-align:center;font-size:14px;">'.$l['managevps_beta_warn'].'</div>-->
<div id="vnc_launcher" style="position:absolute;width:0px;left:-100%"></div>
<div class="modal" id="vncModal">
    <div class="modal-dialog">
		<div class="modal-content" >
			<div class="modal-header d-flex align-items-center">
			  <img width="20" src="'.$theme['svg'].'vnc.svg" />&nbsp;<span class="modal-title"><label class="control-label">VNC</label></span>
			  <button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body" >
			'.(!empty($vps['data']['vnc_auto_port']) && ($kernel->features('vnc_auto_port', $vps['virt'])) ? '<div class="notice" style="text-align: center;">'.$l['vnc_auto_exp'].'</div>' : '' ).'
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12">
						<center><label class="h3 m-0">'.$l['vnc_info'].'</label></center>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-6">
						<label class="h4">'.$l['vnc_ip'].'&nbsp;:</label>&nbsp;&nbsp;<span class="val">'.$vps['vnc_ip'].'</span>
					</div>
					<div class="col-sm-6">
					<label class="h4">'.$l['vnc_port'].'&nbsp;:</label>&nbsp;&nbsp;<span class="val">'.(empty($vps['vncport']) ? 'auto' : $vps['vncport']).'</span>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<label class="h4">'.$l['launch_vnc'].'</label>
					</div>
					<div class="col-sm-4">'
						.(!empty($globals['novnc']) ? '<center><a href="javascript:void(0)" id="novncURL" class="vncButton" onclick="launchvnc(1)"><img class="roundflare px-3 bg-primary" src="'.$theme['svg'].'vnc.svg" title="'.(!empty($l['vpmenu_novnc'])?$l['vpmenu_novnc']:'').'" width="45px;"/><br />'.$l['title_novnc'].'</a></center>' : '').'
					</div>
				</div>
			</div>
		</div>
    </div>
</div>

<!-- console modal -->
<div class="modal" id="consoleModal">
    <div class="modal-dialog">
		<div class="modal-content" >
			<div class="modal-header d-flex align-items-center">
				&nbsp;<span class="modal-title"><label class="control-label">'.$l['serial_console'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body" id="console_div"></div>
		</div>
	</div>
</div>
<!-- console modal ends-->

<div class="modal" id="rescuemodal">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header d-flex align-items-center">
				<img width="20" src="'.$theme['svg'].'rescue.svg" />&nbsp;<span class="modal-title"><label class="control-label">'.$l['rescue_mode'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body" id="rescue_content">
				<div class="card p-3 m-2">
				<span class="help-block">'.$l['rescue_exp'].'</span>
				<div class="row mx-auto w-100 my-3">
					<center><label class="control-label">'.(empty($vps['rescue']) ? $l['rescue_disabled'] : $l['rescue_enabled']).'</label></center>
				</div>
				'.(empty($vps['rescue']) ? '<div class="row mx-auto w-100 my-3">
						<div class="col-sm-4 p-0">
							<label class="control-label">'.$l['rootpass'].'</label>
						</div>
						<div class="col-sm-8 p-0">
							<input type="password" class="form-control" name="rescue_pass" id="rescue_pass" size="30" value="'.POSTval('rescue_pass', '').'" />
						</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4 p-0">
						<label class="control-label">'.$l['conf_pass'].'</label>
					</div>
					<div class="col-sm-8 p-0">
						<input type="password" class="form-control" name="conf_rescue_pass" id="conf_rescue_pass" size="30" value="'.POSTval('conf_rescue_pass', '').'" />
					</div>
					<div class="col-sm-2"></div>
				</div>' : '' ).'
				</div>
			</div>
			<div class="modal-footer">
				<center><a href="javascript:void(0)" class="go_btn" target="" name="rescue_operation" id="rescue_operation" onclick="rescue_ops();">'.(empty($vps['rescue']) ? $l['enable_rescue'] : $l['disable_rescue']).'</a></center>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="webuzomodal">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header d-flex align-items-center">
				<span class="modal-title"><label class="control-label">'.$l['webuzo_mode'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body" id="webuzo_content">
				<div class="card m-2 p-3">
				<span class="help-block">'.$l['webuzo_exp'].'</span><br />';
				if(empty($vps['locked'])){
				echo '
					<form accept-charset="'.$globals['charset'].'" action="" method="post" id="install_script" name="install_script" class="form-horizontal">
						<div class="p-0">
							<div class="row mx-auto w-100 my-3 mx-auto w-100">
								<div class="col-sm-12 p-0">
									<label class="control-label">'.$l['webuzo_spasswd'].'</label><br />
									
									<div class="input-group ">
									<input class="form-control" type="text" name="webuzo_spasswd" id="webuzo_spasswd" onkeyup="check_pass_strength(\'webuzo_spasswd\');"  placeholder="'.$l['webuzo_spasswd_p'].'" 
									value="'.POSTval('webuzo_spasswd', '').'" autocomplete="off">
									  <div class="input-group-append">
										<div id="webuzo_spasswd_pass-strength-result" class="">'.$l['strength_indicator'].'</div>
										<a href="javascript: void(0);" onclick="$_(\'webuzo_spasswd\').value=randstr(12, 1, '.(!empty($globals['pass_strength']) ? $globals['pass_strength'] : 0).');check_pass_strength(\'webuzo_spasswd\');return false;" class="btn-primary rounded-right" title="'.$l['randpass'].'"><i class="fas fa-key p-2"></i></a>
									  </div>
									</div>
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-12 p-0">
									<label class="control-label">'.$l['webuzo_pd'].'</label><br />
									<input class="form-control" type="textbox" name="webuzo_pd" id="webuzo_pd" placeholder="'.$l['webuzo_pd_p'].'" 
									value="'.POSTval('webuzo_pd', '').'">	
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-12 p-0">
									<label class="control-label">'.$l['webuzo_scriptlist'].'</label><br /><select id="webuzo_scriptlist" class="chosen" onchange="script_req(this.value);" name="webuzo_script">
									</select>
								</div>
							</div>
							<div class="row mx-auto w-100">
								<div class="col-sm-12 p-0">
									<label class="control-label">'.$l['webuzo_os'].'</label><br />
									<div class="row mx-auto w-100 my-3">';
									foreach($webuzo_templates as $k => $v){
										echo '
										<div class="col-sm-6 p-0 my-1">
											<label class="custom-control custom-radio">
												<input for="input radio" type="radio" class="custom-control-input" name="webuzo_os" id="webuzoos_'.$k.'" value="'.$k.'" '.(!empty($v['hvm']) ? 'hvm="1"' : '').' distro="'.$v['distro'].'">
												<span class="custom-control-label" for="webuzoos_'.$k.'">'.$v['name'].'</span>
											</label> 
										</div>';
									}
									echo '</div>
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-3 p-0">
									<label class="control-label">'.$l['webuzo_appstack'].'</label><br />
								</div>
								<div class="col-3 p-0" id="stack1_tr">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" name="webuzo_stack" id="stack1" value="lamp" onclick="webuzo_apps(this.value);" checked>
										<span class="custom-control-label" for="stack1">LAMP</span>
									</label>
								</div>
								<div class="col-3 p-0" id="stack2_tr" style="display:none;">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" name="webuzo_stack" id="stack2" value="lemp" onclick="webuzo_apps(this.value);">
										<span class="custom-control-label" for="stack2">LEMP</span>
									</label> 
								</div>
								<div class="col-3 p-0" id="stack3_tr" style="display:none;">
									<label class="custom-control custom-radio">
										<input type="radio" class="custom-control-input" name="webuzo_stack" id="stack3" value="llmp" onclick="webuzo_apps(this.value);">
										<span class="custom-control-label" for="stack3">LLMP</span>
									</label>
								</div>
							</div>
							<div class="border border-secondary pl-2" id="webuzo_stack_tr">
								<input type="hidden" id="script_isfree" value="0" />
								<div class="row mx-auto w-100 my-1" id="webuzo_webserver_tr">
									<div class="col-sm-3 p-0">
										<label class="control-label">'.$l['webuzo_apache'].'</label><br />
									</div>
									<div class="col-sm-9 p-0 mt-n2" id="webuzo_webserver">
										<div class="row mx-auto w-100 my-3 my-0">';
										foreach($webuzo_apps['webserver'] as $wk => $wv){
											echo '
											<div class="col-4 p-0">
												<label class="custom-control custom-radio">
													<input type="radio" class="custom-control-input" name="webserver" id="serverver_'.$wk.'" value="'.$wv['softname'].'">
													<span class="custom-control-label" for="serverver_'.$wk.'">'.$wv['fullname'].'</span>
												</label>					
											</div>';
										}
									echo '</div></div>
								</div><hr>
								<div class="row mx-auto w-100 my-1">
									<div class="col-sm-3 p-0">
										<label class="control-label">'.$l['webuzo_mysql'].'</label>
									</div>						
									<div class="col-sm-9 p-0 mt-n2" id="webuzo_mysql">
										<div class="row mx-auto w-100 my-3 my-0">';
										foreach($webuzo_apps['mysql'] as $wk => $wv){
											echo '
												<div class="col-4 p-0">
														<label class="custom-control custom-radio">
														<input type="radio" class="custom-control-input" name="mysql" id="serverver_'.$wk.'" value="'.$wv['softname'].'">
														<span class="custom-control-label" for="serverver_'.$wk.'">'.$wv['fullname'].'</span>
													</label> 			
												</div>';
										}
									echo '</div></div>				
								</div><hr>
								<div class="row mx-auto w-100 my-1">
									<div class="col-sm-3 p-0">
										<label class="control-label">'.$l['webuzo_php'].'</label>
									</div>	
									<div class="col-sm-9 p-0 mt-n2" id="webuzo_php">
									<div class="row mx-auto w-100 my-3 my-2">';
										foreach($webuzo_apps['php'] as $wk => $wv){
											echo '
											<div class="col-4 p-0">
												<label class="custom-control custom-radio">
													<input type="radio" class="custom-control-input" name="php" id="serverver_'.$wk.'" value="'.$wv['softname'].'">
													<span class="custom-control-label" for="serverver_'.$wk.'">'.$wv['fullname'].'</span>
												</label> 	
															
											</div>';
										}
									echo '</div></div>
								</div>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="roundheader w-100 cursor-pointer" onclick="toggle_option(\'webuzo_advance\');return false;" >
								<label id="webuzo_advance_toggle_indicator" class="min_width">-</label>
								<label for="input text">'.$l['webuzo_advanced'].'</label>
							</div>';
							$vps['dns_nameserver'] = unserialize($vps['dns_nameserver']);					
							$ns1 = $ns2 = '';
							if(!empty($vps['dns_nameserver'])){
								$ns1 = (!empty($vps['dns_nameserver'][0]) ? $vps['dns_nameserver'][0] : '');
								$ns2 = (!empty($vps['dns_nameserver'][1]) ? $vps['dns_nameserver'][1] : '');
							}
							echo '
							<div id="webuzo_advance" class="bgaddv col-sm-12">
								<div class="row mx-auto w-100 my-3" id="webuzo_ns1_tr">
									<div class="col-sm-4">
										<label for="input text">'.$l['webuzo_ns1'].'</label>
									</div>
									<div class="col-sm-7">
										<input class="form-control" type="textbox" name="webuzo_ns1" id="webuzo_ns1" placeholder="'.$l['webuzo_ns1_p'].'"
										value="'.POSTval('webuzo_ns1', $ns1).'" />
									</div>
								</div><br />
								<div class="row mx-auto w-100 my-3" id="webuzo_ns2_tr">
									<div class="col-sm-4">
										<label for="input text">'.$l['webuzo_ns2'].'</label>
									</div>
									<div class="col-sm-7">
										<input class="form-control" type="textbox" name="webuzo_ns2" id="webuzo_ns2" placeholder="'.$l['webuzo_ns2_p'].'" 
										value="'.POSTval('webuzo_ns2', $ns2).'" />
									</div>
								</div><br />
							</div>
						</div>
					</form>';
				}else{
					echo $l['vm_locked_install_script'];
				}
				echo '</div></div>
			<div class="modal-footer">';
				echo (empty($vps['locked'])) ? '<center><a href="javascript:void(0)" class="btn" target="" name="webuzo_operation" id="webuzo_operation" onclick="install_webuzo();">'.$l['webuzo_submit'].'</a></center>' : '';
				
				echo '<div id="webuzo_unsupport" class="notice" style="display:none;">'.$l['webuzo_unsupport'].'</div>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="suspendreasonmodal">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header d-flex align-items-center">
				<span class="modal-title"><label class="control-label">'.$l['title_suspend'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<div class="card p-3 m-2">
					'.$l['reason_txt'].': <input class="form-control" type="text" id="suspend_reason" name="suspendreason"><br>
					<button type="button" onclick="edit_action(\'suspend\')" data-dismiss="modal" class="btn green_btn py-1 px-2 mt-2 w-100" style="display: block;">OK</button>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="sshkeysmodal">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header d-flex align-items-center">
				<span class="modal-title"><label class="control-label">'.$l['sshkeys'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<form id="ssh_keys_form">
				<div class="row" id="sshkey_list"></div>
				</form>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="lockreasonmodal">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header d-flex align-items-center">
				<span class="modal-title"><label class="control-label">'.$l['title_lock'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<div class="card p-3 m-2">
					'.$l['reason_txt'].': <input class="form-control" type="text" id="lock_reason" name="reason"><br>
					<button type="button" onclick="edit_action(\'lock\')" data-dismiss="modal" class="btn green_btn py-1 px-2 mt-2 w-100" style="display: block;">OK</button>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="rebuildmodal">
	<div class="modal-dialog modal-lg">		
		<div class="modal-content">
			<div class="modal-header d-flex align-items-center">
				<span class="modal-title"><label class="control-label">'.$l['rebuildvs'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
			<div id="rebuild_content"></div>
			<div class ="card m-2 p-3">
			<form id="form-container" accept-charset="'.$globals['charset'].'" action="" method="post" name="rebuild" class="form-horizontal">
				<div class="row mx-auto w-100 my-3" id="rebuild_error_row" style="display:none;">
					<div id="rebuild_error" class="col-sm-12 p-0"></div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4 p-0">
						<label class="control-label">'.$l['vsos'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_os'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-8 p-0">
						<select class="custom-select virt-select" id="osid" name="osid">
							<option value="0" '.(POSTval('osid')== 0 ?  'selected="selected"' :($vps['osid']== 0 ? 'selected="selected"' : '')).'>'.$l['select_os'].'</option>';
							if(!empty($ostemplates)){
								foreach($ostemplates as $k => $v){
									// Does this VPS support this $_virt ?
									if($vps['virt'] != $v['type']){
										continue;
									}							
									echo '<option value="'.$k.'" '.(POSTval('osid') == $k ? 'selected="selected"' : ($vps['osid'] == $k ? 'selected="selected"' : '')).' '.(!empty($v['hvm']) ? 'hvm="1"' : '').' virt="'.$v['type'].(!empty($v['hvm']) ? 'hvm' : '').'">'.(!empty($v['hvm']) ? 'HVM - ' : '').''.$v['name'].is_custom_os($k).'</option>';
								}
							}
					echo'</select>
					</div>
				</div>
				<div class="row mx-auto w-100 mb-0 mt-2">
					<div class="col-sm-4 p-0">
						<label class="control-label">'.$l['new_pass'].'</label>
					</div>
					<div class="col-sm-8 p-0">
						<div class="input-group ">
							<input type="password" class="form-control" name="newpass" onkeyup="check_pass_strength(\'newpass\');" id="newpass" size="30" value="" />
						  <div class="input-group-append">
							<a href="javascript:void(0);" onclick="setpwd(12);check_pass_strength(\'newpass\');pass_match();copy_password();return false;" class="btn-primary rounded-right"  title="'.$l['randpass'].'"><i class="fas fa-key p-2"></i></a>
						  </div>
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 mb-2 mt-0">
					<div class="col-sm-4 p-0">
					</div>
					<div class="col-sm-8 p-0">
						<div id="newpass_pass-strength-result" class="">'.$l['strength_indicator'].'</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4 p-0"><label class="control-label">'.$l['retype_pass'].'</label></div>
					<div class="col-sm-8 p-0"><input type="password" class="form-control" onblur="pass_match();" name="conf" id="conf" size="30" value="" /><div id="message"></div></div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4 p-0">
						<label class="control-label">'.$l['recipe'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['recipe_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-8 server-select-lg p-0">
						<select class="form-control virt-select" name="recipe[]" id="recipe" multiple="multiple">
							<option value="0" '.POSTselect('recipe', 'none').'>None</option>';
							
							foreach($recipes as $k => $v){
								echo '<option value="'.$k.'" '.POSTselect('recipe', $k).'>'.$v['name'].'</option>';
							}
							
						echo '</select>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4 p-0">
						<label class="control-label">'.$l['add_ssh_key'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['add_ssh_key_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-8 p-0">
						<textarea class="form-control font-monospace w-100" name="sshkey" id="sshkey" rows="8">'.POSTval('sshkey', '').'</textarea>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-4 p-0">
						<label class="control-label">'.$l['remove_old_ssh_keys'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['remove_old_ssh_keys_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-8 p-0">
						'.get_checkbox('remove_old_ssh_keys', '', 'remove_old_ssh_keys').'
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-4 p-0">
						<label class="control-label">'.$l['eu_send_rebuild_email'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['eu_send_rebuild_email_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-8 p-0">
						'.get_checkbox('eu_send_rebuild_email', '', 'eu_send_rebuild_email', array('chk_it' => 1, 'val' => 1)).'
					</div>
				</div>';
				if($kernel->features('format_primary', $vps['virt'])){
					echo '
					<div class="row mx-auto w-100 my-3">
						<div class="col-4 p-0">
							<label class="control-label">'.$l['format_primary'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['format_primary_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-4 p-0">
							'.get_checkbox('format_primary', '', 'format_primary').'
						</div>
					</div>';
				}
				echo'
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12">
						<center><input type="button" class="go_btn" name="reos" id="reos" value="'.$l['reinstall'].'"/></center>
					</div>	
				</div>	
				<div class="notice" align="left">
					<b>'.$l['note'].' : </b> &nbsp; '.$l['format_primary_warn'].'
				</div>
			</form>
			</div>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="manage_subnets">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<div class="modal-header d-flex align-items-center">
				<span class="modal-title"><label class="control-label">'.$l['manage_ipv6_subnets'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body" id="manage_subnets_body"></div>
		</div>
	</div>
</div>
<div class="modal" id="managevdf">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<div class="modal-header d-flex align-items-center">
				&nbsp;<span class="modal-title"><label class="control-label">'.$l['managevdf'].'</label></span>
				<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body" id="managevdf_body">
				<div class="row my-3 mx-auto" id="showaddvdfformbtn">
					<div class="col-10"></div>
					<div class="col-2 d-flex align-items-center justify-content-end text-right">
						<span class="mr-2">
						<a href="javascript:void(0)" onclick="$(\'#vdf_infobox\').slideToggle();">
							<i class="icon-info icon-head text-dark" ></i>
						</a>
						</span>&nbsp;
						<span class="mr-2">
							<a href="'.$globals['docs'].'Manage_VPS_Domain_Forwarding" target="_blank" tooltip="'.$l['wiki_help'].'"><i class="icon-help icon-head text-dark" ></i></a>
						</span>&nbsp;
							<button class="btn text-center mt-n3" onclick="showvdfform();">'.$l['new'].'</button>
						</span>
					</div>
				</div>
				<div id="vdf_infobox" style="display:none;">
					<div class="heading">'.$l['vdf_info'].'</div>
					<div class="body">
						<div>
							<b>'.$l['vdf_info_reservedports'].':</b> '.$server_config['haproxy_reservedports'].'<br/>
							<b>'.$l['vdf_info_reservedports_http'].':</b> '.$server_config['haproxy_reservedports_http'].'<br/>
							<b>'.$l['vdf_info_allowedports'].':</b> '.$server_config['haproxy_allowedports'].'<br/>
						</div><br/>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3" id="addvdf_form_div" style="display: none;">
					<div class="row title">
						<div class="col-xs-12">'.$l['vdf_add_title'].'</div>
					</div>
					<form name="addvdf" id="addvdf" method="post" action="" onsubmit="return false;">
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-2 form-group">
								<div class="col-sm-12">
									<label class="control-label" for="protocol">'.$l['vdf_proto'].'</label>
									<select class="custom-select chosen" id="protocol" name="protocol" onchange="processaddvdfform(this);" ></select>
								</div>
							</div>
							<div class="col-sm-4 form-group">
								<div class="col-sm-12">
									<label class="control-label" for="src_hostname" >'.$l['vdf_src_hname'].'</label>
									<select class="custom-select chosen" id="src_hostname" name="src_hostname" ></select>
								</div>
							</div>
						
							<div class="col-sm-2 form-group">
								<div class="col-sm-12">
									<label class="control-label" for="src_port">'.$l['vdf_src_port'].'</label>
									<input type="text" class="form-control" id="src_port" name="src_port" />
								</div>
							</div>
							<div class="col-sm-2 form-group">
								<div class="col-sm-12">
									<label class="control-label" for="dest_ip">'.$l['vdf_dest_ip'].'</label>
									<select class="custom-select chosen" id="dest_ip" name="dest_ip" ></select>
								</div>
							</div>
							<div class="col-sm-2 form-group">
								<div class="col-sm-12">
									<label class="control-label" for="dest_port">'.$l['vdf_dest_port'].'</label>
									<input type="text" class="form-control" id="dest_port" name="dest_port" />
								</div>
							</div>
						</div>
						<div class="row mx-auto w-100">
							<div class="col-sm-12 text-center">
								<button id="submitaddvdf" onclick="processaddvdfform(this);" class="btn text-center" name="submitaddvdf">'.$l['add'].'</button>&nbsp;&nbsp;
								<button class="btn text-center" onclick=\'$("#addvdf_form_div").css("display", "none");$("#showaddvdfformbtn").css("display","flex");\' >'.$l['close'].'</button>
								<input type="hidden" value="addvdf" name="action" />
							</div>
						</div>
					</form><hr />
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="scrollbar-virt col-sm-12 sticky">
						<div id="vdf_tbl_div"></div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-8 col-lg-7 col-md-6 mb-3">
					</div>
					<div class="col-sm-4 col-lg-5 col-md-6 text-right">
						<div class="bottom-menu float-right w-100">
							<div class="row my-auto">
								<div class="p-0">
									<label>'.$l['with_selected'].'</label>
								</div>
								<div class="col p-0">
									<select name="haproxy_multiselect_action" id="haproxy_multiselect_action_1" class="custom-select">
										<option value="0">---</option>
										<option value="1">'.$l['delete'].'</option>
									</select>
								</div>
								<div class="pl-2">
									<input type="submit" id="haproxy_task_submit" class="go_btn" name="haproxy_task_submit" value="'.$l['go'].'" onclick="vdf_confirm(0, 1); return false;" />
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div id="edivs-form-container">
<form  accept-charset="'.$globals['charset'].'" action="" method="post" id="editvs" name="editvs" class="form-horizontal">
<div class="row mx-auto w-100 my-3">
	<div class="col-sm-6 col-xs-12">
	
		<!---------------------
		// VPS INFO Window
		---------------------->
		
		<div class="roundheader cursor-pointer" onclick="toggle_option(\'vps_info\');"><label id="vps_info_toggle_indicator" class="min_width">-</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp'.$l['vps_info'].'</div>
		<div id="vps_info" class="bgaddv">
			<div class="row mx-auto w-100 my-1">
				<div class="col-6 p-0">
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['vs_server'].'</label>
							<br><span class="text-muted">'.$servers[$vps['serid']]['server_name'].' ('.$l['vs_ser_id'].': <i>'.$vps['serid'].'</i>)</span>
							<input type="hidden" name="serid" value="'.$vps['serid'].'" />
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['id'].'</label><br>
							<span class="text-muted">'.$vps['vpsid'].' (UUID: '.$vps['uuid'].')</span>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['vid'].'</label><br>
							<span class="text-muted">'.$vps['vps_name'].'</span>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['create_date'].'</label><br>
							<span class="text-muted">'.(empty($vps['time']) ? 'N/A' : datify($vps['time'])).'</span>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['last_edited'].'</label><br>
							<span class="text-muted">'.(empty($vps['edittime']) ? 'N/A' : datify($vps['edittime'])).'</span>
						</div>
					</div>
				</div>
				<div class="col-6 p-0">
					<div class="row mx-auto w-100 my-3" id="primary_ip">
						<div class="col-12">
							<label class="control-label">'.$l['primary_ip'].'</label><br>
							<span class="text-muted">'.$primary_ip.'</span>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['disk_space'].'</label><br>
							<span class="text-muted">'.$vps['space'].'&nbsp;GB</span>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['ram'].'</label><br>
							<span class="text-muted">'.$vps['ram'].'&nbsp;MB</span>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['num_ipv4'].'</label><br>
							<span class="text-muted">'.count($vps['ips']).'</span>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-12">
							<label class="control-label">'.$l['num_ipv6'].'</label><br>
							<div class="w-auto d-flex align-items-center">
								<span class="text-muted">'.count($vps['ipv6']).'</span>
								'.(count($vps['ipv6']) > 0 ? '&nbsp;<br><a class="info" data-placement="right" tooltip="'.htmlizer($ipv6_div).'"><i class="fas text-primary fa-info-circle"></i></a>': '').'</div>
						</div>
					</div>';
					if($kernel->features('unprivileged', $virt)){
						$ct_type = '';
						(empty($vps['data']['unprivileged'])) ? ($ct_type = $l['priv_ct']) : ($ct_type = $l['unpriv_ct']);
						echo '
						<div class="row mx-auto w-100 my-3">
							<div class="col-12">
								<label class="control-label">'.$l['container_type'].'</label>
								<br><span class="text-muted">'.$ct_type.'</span>
							</div>
						</div>';
					}
					echo'
			
				</div>
			</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-6 col-6 d-flex align-items-center"><img class="mr-2" src="'.distro_logo(distro_find($vps['os_name']),'','1').'" title="'.$vps['os_name'].'" width="40px"/>
					<span class="roundflare">'.$vps['os_name'].'</span>
				</div>
				<div class="col-sm-6 col-6 d-flex align-items-center">
					<span class="status_txt" id="vps_status"></span>
				</div>
			</div>
		</div><br>
		
		<!---------------------
		// VPS Manage Window
		---------------------->
		
		<div class="roundheader cursor-pointer" onclick="toggle_option(\'manage\');"><label id="manage_toggle_indicator" class="min_width">-</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp'.$l['manage'].'
		</div>
		<div id="manage" class="bgaddv" style="position:relative;">
		<div class="loading_overlay" id="small-loader" style="display:none">
		<div class="loader-lg"></div>
		</div>
			<div class="row mx-auto w-100 my-3">
				<div class="col-3 pan-button">
					<center><a href="javascript: void(0);" target="" onclick="edit_action(\'start\')">
						<svg id="start" xmlns="http://www.w3.org/2000/svg" viewBox="-1,-5,22,28" width="60" height="60" fill="currentColor">
							<path d="M10 20C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zm0-2a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm4.126-6.254-4.055 2.898c-.905.646-2.13.389-2.737-.576A2.201 2.201 0 0 1 7 12.898V7.102C7 5.942 7.883 5 8.972 5c.391 0 .774.124 1.099.356l4.055 2.898c.905.647 1.146 1.952.54 2.917a2.042 2.042 0 0 1-.54.575zM8.972 7.102v5.796L13.027 10 8.972 7.102z"/>
						</svg>
						</a>
						<div class="text-admin">'.$l['title_start'].'</div>
					</center>
				</div>
				<div class="col-3 pan-button">
					<center><a id="stop" href="javascript: void(0);" target="" onclick="edit_action(\'stop\')">
					<svg  xmlns="http://www.w3.org/2000/svg" viewBox="-3,-5,22,24" width="60" height="60" fill="currentColor"><path d="M4 2a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H4zm0-2h8a4 4 0 0 1 4 4v8a4 4 0 0 1-4 4H4a4 4 0 0 1-4-4V4a4 4 0 0 1 4-4z"/>
					</svg>
					</a>
					<div class="text-admin">'.$l['title_stop'].'</div>
					</center>
				</div>
				<div class="col-3 pan-button">

					<center><a id="restart" href="javascript: void(0);" target="" onclick="edit_action(\'restart\')">
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-5,28,30" width="60" height="60" fill="currentColor"><path d="m5.308 7.612 1.352-.923a.981.981 0 0 1 1.372.27 1.008 1.008 0 0 1-.266 1.388l-3.277 2.237a.981.981 0 0 1-1.372-.27L.907 6.998a1.007 1.007 0 0 1 .266-1.389.981.981 0 0 1 1.372.27l.839 1.259C4.6 3.01 8.38 0 12.855 0c5.458 0 9.882 4.477 9.882 10s-4.424 10-9.882 10a.994.994 0 0 1-.988-1c0-.552.443-1 .988-1 4.366 0 7.906-3.582 7.906-8s-3.54-8-7.906-8C9.311 2 6.312 4.36 5.308 7.612z"/>
					</svg>
					</a>
					<div class="text-admin">'.$l['title_restart'].'</div>
					</center>
				</div>
				<div class="col-3 pan-button">

					<center><a id="poweroff" href="javascript: void(0);" target="" onclick="edit_action(\'poweroff\')">
					<svg id="poweroff" xmlns="http://www.w3.org/2000/svg" viewBox="-1,-5,22,28" width="60" height="60" fill="currentColor"><path d="M12 4.1a.973.973 0 0 1-.617-.898c0-.536.448-.972 1-.972.116 0 .228.02.332.055.001-.003.002-.004.004-.003C15.834 3.658 18 6.708 18 10.252 18 15.082 13.97 19 9 19s-9-3.917-9-8.749C0 6.732 2.137 3.7 5.218 2.31a1.022 1.022 0 0 1 .392-.076c.552 0 1 .435 1 .971a.972.972 0 0 1-.61.896c-2.365 1.092-4 3.436-4 6.15 0 3.758 3.134 6.805 7 6.805s7-3.047 7-6.805c0-2.714-1.635-5.058-4-6.15zM9 0a1 1 0 0 1 1 1v6a1 1 0 1 1-2 0V1a1 1 0 0 1 1-1z"/>
					</svg>
					</a>
					<div class="text-admin">'.$l['title_poweroff'].'</div>
					</center>
				</div>	
				<div class="col-3 pan-button">
					<center><a href="javascript: void(0);" target="" data-toggle="modal" data-target="#suspendreasonmodal">
					<svg id="poweroff" xmlns="http://www.w3.org/2000/svg" viewBox="-3,-5,22,28" width="60" height="60" fill="currentColor"><path d="M2 0h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2zm0 2v14h2V2H2zm10-2h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2zm0 2v14h2V2h-2z"/>
					</svg>
					</a>
					<div class="text-admin">'.$l['title_suspend'].'</div>
					</center>
				</div>

				<div class="col-3 pan-button">
					<center><a id="unsuspend" href="javascript: void(0);" target="" onclick="edit_action(\'unsuspend\')">

					<svg  xmlns="http://www.w3.org/2000/svg" viewBox="-3,-5,22,28" width="60" height="60" fill="currentColor"><path d="M13.82 9.523a.976.976 0 0 0-.324-1.363L3.574 2.128a1.031 1.031 0 0 0-.535-.149c-.56 0-1.013.443-1.013.99V15.03c0 .185.053.366.153.523.296.464.92.606 1.395.317l9.922-6.031c.131-.08.243-.189.325-.317zm.746 1.997-9.921 6.031c-1.425.867-3.3.44-4.186-.951A2.918 2.918 0 0 1 0 15.03V2.97C0 1.329 1.36 0 3.04 0c.567 0 1.123.155 1.605.448l9.921 6.032c1.425.866 1.862 2.696.975 4.088-.246.386-.58.712-.975.952z"/>
					</svg>
					</a>
					<div class="text-admin">'.$l['title_unsuspend'].'</div>
					</center>

				</div>
				<div class="col-3 pan-button">
					<center><a id="create_inf" href="javascript:void(0);" onclick="create_inf();">
					
					<svg  xmlns="http://www.w3.org/2000/svg" viewBox="-4,-5,22,22" width="60" height="60" fill="currentColor"><path d="m8 6.641 1.121-1.12a1 1 0 0 1 1.415 1.413L7.707 9.763a.997.997 0 0 1-1.414 0L3.464 6.934A1 1 0 1 1 4.88 5.52L6 6.641V1a1 1 0 1 1 2 0v5.641zM1 12h12a1 1 0 0 1 0 2H1a1 1 0 0 1 0-2z"/>
					</svg>
					</a>
					<div class="text-admin">'.$l['download_inf'].'</div>
					</center>
				</div>
				<div class="col-3 pan-button">
					<center><a id="reinstall" href="javascript: void(0);" data-toggle="modal" data-target="#rebuildmodal">
					
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-5,22,28" width="60" height="60" fill="currentColor"><path d="M10 20C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zm0-2a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm7-8a6.99 6.99 0 0 1-2.89 5.666l-.53-.796L13 14a4.992 4.992 0 0 0 2-4 4.992 4.992 0 0 0-2-4l1.2-1.6A6.99 6.99 0 0 1 17 10zm-7 3a3 3 0 1 1 0-6 3 3 0 0 1 0 6zm0-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2z"/>
					</svg></a>
					<div class="text-admin">'.$l['rebuildvs'].'</div>
					</center>
					
				</div>';
				
				if($kernel->features('rescue_support', $vps['virt'])){
					echo '<div class="col-3 pan-button">
						<center><a id="rescue" href="javascript: void(0);" data-toggle="modal" data-target="#rescuemodal">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-5,22,28" width="60" height="60" fill="currentColor"><path d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 2C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zm3.446-12.032a4.007 4.007 0 0 0-1.414-1.414l3.625-3.625 1.414 1.414-3.625 3.625zm-5.478 5.478-3.625 3.625-1.414-1.414 3.625-3.625a4.007 4.007 0 0 0 1.414 1.414zm0-6.892a4.007 4.007 0 0 0-1.414 1.414L2.929 4.343 4.343 2.93l3.625 3.625zm4.736 6.394a4 4 0 1 1 .244-.244c.193-.21.359-.435.498-.672l2.874 2.874a8.048 8.048 0 0 1-1.414 1.414l-2.874-2.874c.237-.14.462-.305.672-.498zM10 12a2 2 0 1 0 0-4 2 2 0 0 0 0 4z"/>
						</svg></a>
						<div class="text-admin">'.$l['rescue_mode'].'</div>
						</center>
					</div>';
				}
				
				if(!empty($vps['vnc'])){
					echo '<div class="col-3 pan-button">
						<center><a href="javascript:void(0)" id="java" class="vncButton" data-toggle="modal" data-target="#vncModal">

						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-6,22,26" width="60" height="60" fill="currentColor"><path d="M1 14h18a1 1 0 0 1 0 2H1a1 1 0 0 1 0-2zM2 0h16a2 2 0 0 1 2 2v10a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1V2a2 2 0 0 1 2-2zm16 11V2H2v9h16z"/>
						</svg></a>
						<div class="text-admin">'.$l['title_vnc'].'</div>
						</center>

					</div>';
				}
				
				echo '
				<div class="col-3 pan-button">
					<center><a id="suspend_net" href="javascript: void(0);" target="" onclick="edit_action(\'suspend_net\')">
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0,-2,25,30" width="60" height="60" fill="currentColor">
					<style>
					.s0 { fill: currentColor } 
					.s1 { fill: #ff6b6b } 
				</style>
				<path id="Layer" class="s0" d="m12 19q-0.4 0-0.7-0.3-0.3-0.3-0.3-0.7 0-0.4 0.3-0.7 0.3-0.3 0.7-0.3 0.4 0 0.7 0.3 0.3 0.3 0.3 0.7 0 0.4-0.3 0.7-0.3 0.3-0.7 0.3zm-2.1-2.6q-0.2 0.4-0.6 0.5-0.4 0.1-0.7 0-0.4-0.2-0.5-0.6-0.2-0.4 0-0.8c0.4-0.7 0.9-1.3 1.6-1.7 0.7-0.4 1.5-0.7 2.3-0.7 0.8 0 1.6 0.3 2.3 0.7 0.7 0.4 1.2 1 1.6 1.7 0.1 0.3 0.1 0.6 0.1 0.8-0.1 0.3-0.3 0.5-0.5 0.6-0.3 0.1-0.6 0.2-0.8 0.1-0.3-0.1-0.5-0.3-0.6-0.6q-0.3-0.6-0.9-0.9-0.5-0.4-1.2-0.4-0.7 0-1.2 0.4-0.6 0.3-0.9 0.9zm-3.1-2.8q-0.3 0.3-0.7 0.4-0.4 0-0.7-0.2-0.3-0.3-0.4-0.7 0-0.4 0.2-0.7c0.8-1.1 1.8-1.9 3-2.5 1.2-0.6 2.5-0.9 3.8-0.9 1.3 0 2.6 0.3 3.8 0.9 1.2 0.6 2.2 1.4 3 2.5q0.2 0.3 0.2 0.7-0.1 0.4-0.4 0.7-0.3 0.2-0.7 0.2-0.4-0.1-0.7-0.4c-0.6-0.8-1.4-1.5-2.3-1.9-0.9-0.5-1.9-0.7-2.9-0.7-1 0-2 0.2-2.9 0.7-0.9 0.4-1.7 1.1-2.3 1.9zm-3.1-2.9q-0.2 0.2-0.6 0.3-0.4 0-0.7-0.3-0.3-0.3-0.4-0.7 0-0.4 0.3-0.7c4.8-5.3 13.1-5.8 18.5-0.9q0.5 0.4 0.9 0.9 0.3 0.3 0.3 0.8 0 0.4-0.3 0.6-0.3 0.3-0.8 0.3-0.4 0-0.6-0.3-0.1-0.1-0.2-0.2-0.1-0.2-0.2-0.3-0.1-0.1-0.3-0.2-0.1-0.1-0.2-0.2c-4.5-4.1-11.6-3.7-15.7 0.9z"/>
				<path id="Shape 1" class="s1" d="m3.6 19c-0.3-0.4-0.2-1 0.2-1.4l16-12c0.4-0.3 1-0.2 1.4 0.2 0.3 0.4 0.2 1.1-0.2 1.4l-16 12c-0.4 0.4-1.1 0.3-1.4-0.2z"/>
					</svg></a>
					<div class="text-admin">'.$l['title_suspend_net'].'</div>
					</center>

				</div>

				<div class="col-3 pan-button">
					<center><a id="unsuspend_net" href="javascript: void(0);" target="" onclick="edit_action(\'unsuspend_net\')">

					<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-6,22,28" width="60" height="60" fill="currentColor"><path d="M10 13.992a1 1 0 1 1 0-2 1 1 0 0 1 0 2zM7.894 11.44a1 1 0 0 1-1.788-.894 4.355 4.355 0 0 1 7.788 0 1 1 0 1 1-1.788.894 2.353 2.353 0 0 0-4.212 0zM4.8 8.595a1 1 0 0 1-1.6-1.2 8.503 8.503 0 0 1 13.6 0 .999.999 0 1 1-1.6 1.2 6.503 6.503 0 0 0-10.4 0zm-3.057-2.93A1 1 0 0 1 .257 4.329c4.843-5.377 13.13-5.813 18.512-.973.342.307.667.632.974.973a.999.999 0 1 1-1.486 1.338 10.91 10.91 0 0 0-.826-.826C12.871.74 5.847 1.108 1.743 5.666z"/>
					</svg></a>
					<div class="text-admin">'.$l['title_unsuspend_net'].'</div>
					</center>
					
				</div>

				<div class="col-3 pan-button">

					<center><a id="bwresert_img" href="javascript: void(0);" target="" onclick="bwresert();">
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor"><path d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 2C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zM9 1h2v10H9V1zm0 8h10v2H9V9z"/>
					</svg></a>
					<div class="text-admin">'.$l['title_bwreset'].'</div>
					</center>


				</div>';
				
				if($kernel->features('serial_console', $vps['_virt'])){
					echo '<div id="dd" class="col-3 pan-button" onclick="show_console_window();">
						<center><a href="javascript:void(0)" data-toggle="modal" data-target="#consoleModal">

						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor"><path d="m5.243 7.071-4.95-4.95A1 1 0 1 1 1.707.707l5.657 5.657a1 1 0 0 1 0 1.414l-5.657 5.657a1 1 0 0 1-1.414-1.414l4.95-4.95zM6.929 12h8a1 1 0 0 1 0 2h-8a1 1 0 0 1 0-2z"/>
						</svg></a>
						<div class="text-admin">'.$l['serial_console'].'</div>
						</center>
					</div>';
				}
				
				if(!empty($vps['ips6_subnet'])) {
					echo '<div class="col-3 pan-button">
							<center><a href="javascript:void(0);" target="" data-toggle="modal" data-target="#manage_subnets">

							<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor"><path d="M3 18a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm1-7.002v3.173a3.001 3.001 0 1 1-2 0V5.829a3.001 3.001 0 1 1 2 0v2.34c.312-.11.647-.17.997-.171l6.037-.006a1 1 0 0 0 .999-1V5.84A3.001 3.001 0 0 1 13 0a3 3 0 0 1 1.033 5.817v1.175a3 3 0 0 1-2.997 3l-6.037.006a1 1 0 0 0-.999 1zM3 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2zm10 0a1 1 0 1 0 0-2 1 1 0 0 0 0 2z"/>
							</svg></a>
							<div class="text-admin">'.$l['manage_ipv6_subnets'].'</div>
							</center>
						</div>';
				}
				
				if(!empty($globals['haproxy_enable'])) {
					echo '<div class="col-3 pan-button">
						<center><a href="javascript:void(0);" target="" data-toggle="modal" data-target="#managevdf">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor"><path d="M2.252 8A8.014 8.014 0 0 0 2 10c0 .69.088 1.36.252 2H5.1a19.83 19.83 0 0 1 0-4H2.252zm.818-2h2.346c.266-1.217.65-2.307 1.121-3.214A8.035 8.035 0 0 0 3.07 6zm14.678 2H14.9a19.83 19.83 0 0 1 0 4h2.848a8.047 8.047 0 0 0 0-4zm-.818-2a8.035 8.035 0 0 0-3.467-3.214c.472.907.855 1.997 1.121 3.214h2.346zM7.112 8A17.763 17.763 0 0 0 7 10c0 .685.038 1.355.112 2h5.776a17.763 17.763 0 0 0 0-4H7.112zm.358-2h5.06a10.758 10.758 0 0 0-.783-2.177C11.119 2.568 10.447 2 10 2c-.448 0-1.119.568-1.747 1.823-.315.632-.58 1.367-.783 2.177zm-4.4 8a8.035 8.035 0 0 0 3.467 3.214c-.472-.907-.855-1.997-1.121-3.214H3.07zm13.86 0h-2.346c-.266 1.217-.65 2.307-1.121 3.214A8.035 8.035 0 0 0 16.93 14zm-9.46 0c.203.81.468 1.545.783 2.177C8.881 17.432 9.553 18 10 18c.448 0 1.119-.568 1.747-1.823.315-.632.58-1.367.783-2.177H7.47zM10 20C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10z"/>
						</svg></a>
						<div class="text-admin">'.$l['managevdf'].'</div>
						</center>

					</div>';
				}

				if(!empty($vm_backup_plan)){
					echo '<div class="col-3 col-xs-4 pan-button">
						<center><a href="javascript:void(0);" target="" onclick="backup_single_vm(\'index.php?act=managevps&vpsid='.$vps['vpsid'].'&cbackup=1&api=json\', this)">
						
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">	<defs>
						<image width="24" height="25" id="img1" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii01IC00LjUgMjQgMjQiIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgZmlsbD0iY3VycmVudENvbG9yIj48cGF0aCBkPSJtNiA0LjA3MS0zLjk1IDMuOTVBMSAxIDAgMCAxIC42MzYgNi42MDdMNi4yOTMuOTVhLjk5Ny45OTcgMCAwIDEgMS40MTQgMGw1LjY1NyA1LjY1N0ExIDEgMCAwIDEgMTEuOTUgOC4wMkw4IDQuMDd2OS41ODZhMSAxIDAgMSAxLTIgMFY0LjA3eiIvPjwvc3ZnPg=="/>
						</defs>
						<style>
							.s0 { fill: currentColor } 
							#arrow-up {
								filter: invert(50%);
							}
						</style>
						<path id="Layer" fill-rule="evenodd" class="s0" d="m7 19c-1.5 0-2.9-0.6-3.8-1.8-1-1.1-1.4-2.5-1.1-4 0.2-1.4 1.1-2.7 2.3-3.5 1.2-0.7 2.8-0.9 4.2-0.5 0.6-1.4 1.7-2.7 3.2-3.4 1.4-0.7 3-1 4.6-0.7 1.6 0.4 3 1.2 4 2.5 1 1.2 1.6 2.8 1.6 4.4q0 1.4-0.5 2.7-0.6 1.3-1.6 2.2-0.9 1-2.2 1.6-1.3 0.5-2.7 0.5zm0-2h8c1.8 0 3.5-1 4.4-2.6 0.9-1.7 0.8-3.6-0.2-5.2-1-1.5-2.8-2.3-4.7-2.2-1.8 0.2-3.4 1.3-4.1 3l-0.7 1.7-1.8-0.6c-0.8-0.2-1.7-0.1-2.5 0.3-0.7 0.5-1.2 1.3-1.4 2.1-0.1 0.9 0.2 1.8 0.7 2.4 0.6 0.7 1.4 1.1 2.3 1.1z"/>
						<use id="arrow-up" href="#img1" transform="matrix(.458,0,0,.459,8,7)"/>
						</a></svg>
						<div class="text-admin">'.($kernel->features('inc_backup', $vps['virt']) && has_plugin_license('backuply') ? (($vm_backup_plan['data']['backup_scheme'] == 'always_full' && $vm_backup_plan['frequency'] != 'manual') ? $l['take_full_backup'] : $l['take_inc_backup']) : $l['bak_now']).'</div>
						</center>
					</div>';
				}

				if($kernel->features('inc_backup', $vps['virt']) && has_plugin_license('backuply') && !empty($vm_backup_plan) && $vm_backup_plan['frequency'] == 'manual'){
					echo '<div class="col-3 col-xs-4 pan-button">
						<center><a href="javascript:void(0);" target="" onclick="backup_single_vm(\'index.php?act=managevps&vpsid='.$vps['vpsid'].'&cbackup=1&api=json&take_full_backup=1\', this)">
						
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">	<defs>
						<image width="24" height="25" id="img1" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii01IC00LjUgMjQgMjQiIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgZmlsbD0iY3VycmVudENvbG9yIj48cGF0aCBkPSJtNiA0LjA3MS0zLjk1IDMuOTVBMSAxIDAgMCAxIC42MzYgNi42MDdMNi4yOTMuOTVhLjk5Ny45OTcgMCAwIDEgMS40MTQgMGw1LjY1NyA1LjY1N0ExIDEgMCAwIDEgMTEuOTUgOC4wMkw4IDQuMDd2OS41ODZhMSAxIDAgMSAxLTIgMFY0LjA3eiIvPjwvc3ZnPg=="/>
						</defs>
						<style>
							.s0 { fill: currentColor } 
							#arrow-up {
								filter: invert(50%);
							}
						</style>
						<path id="Layer" fill-rule="evenodd" class="s0" d="m7 19c-1.5 0-2.9-0.6-3.8-1.8-1-1.1-1.4-2.5-1.1-4 0.2-1.4 1.1-2.7 2.3-3.5 1.2-0.7 2.8-0.9 4.2-0.5 0.6-1.4 1.7-2.7 3.2-3.4 1.4-0.7 3-1 4.6-0.7 1.6 0.4 3 1.2 4 2.5 1 1.2 1.6 2.8 1.6 4.4q0 1.4-0.5 2.7-0.6 1.3-1.6 2.2-0.9 1-2.2 1.6-1.3 0.5-2.7 0.5zm0-2h8c1.8 0 3.5-1 4.4-2.6 0.9-1.7 0.8-3.6-0.2-5.2-1-1.5-2.8-2.3-4.7-2.2-1.8 0.2-3.4 1.3-4.1 3l-0.7 1.7-1.8-0.6c-0.8-0.2-1.7-0.1-2.5 0.3-0.7 0.5-1.2 1.3-1.4 2.1-0.1 0.9 0.2 1.8 0.7 2.4 0.6 0.7 1.4 1.1 2.3 1.1z"/>
						<use id="arrow-up" href="#img1" transform="matrix(.458,0,0,.459,8,7)"/>
						</svg></a>
						<div class="text-admin">'.$l['take_full_backup'].'</div>
						</center>
					
					</div>';
				}
				
				// Webuzo block
				echo '<div class="col-3 pan-button">
						<center><a href="javascript: void(0);" data-toggle="modal" data-target="#webuzomodal" onclick="'.(!empty($vps['locked']) ? '' : 'load_scripts();').'">
						<img id="webuzo" src="'.$theme['svg'].'webuzo.svg" width="60" height="60"/><br />
						</a>
						<div class="text-admin">'.$l['webuzo_mode'].'</div>
						</center>
					</div>';

				// ssh keys block
				echo '<div class="col-3 pan-button">
						<center><a href="javascript: void(0);" data-toggle="modal" data-target="#sshkeysmodal" onclick="'.(!empty($vps['locked']) ? '' : 'load_sshkeys();').'">
						
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor"><path d="m8.612 16.337 3.746-3.747 1.027.183a5 5 0 1 0-4.039-4.039l.184 1.028-6.994 6.994.177 2.651 2.651.177 1.833-1.833-.707-.707a1 1 0 0 1 1.415-1.414l.707.707zm.707-13.435a7 7 0 1 1 3.715 11.84L6.137 21.64l-4.43-.295a1 1 0 0 1-.932-.932l-.295-4.43 6.898-6.898a6.992 6.992 0 0 1 1.94-6.183zm4.242 5.656A2 2 0 1 1 16.39 5.73a2 2 0 0 1-2.829 2.828z"/>
						</svg></a>
						<div class="text-admin">'.$l['sshkeys'].'</div>
						</center>

					</div>';

				//Lock & Unlock Block
				if(empty($vps['locked'])){
					echo'<div class="col-3 pan-button">
						<center><a href="javascript: void(0);" target="" data-toggle="modal" data-target="#lockreasonmodal">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-4,-3,22,28" width="60" height="60" fill="currentColor"><path d="M2 12v6h10v-6H2zm10-2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2V5a5 5 0 1 1 10 0v5zm-2 0V5a3 3 0 1 0-6 0v5h6zm-3 7a2 2 0 1 1 0-4 2 2 0 0 1 0 4z"/>
						</svg></a>
						<div class="text-admin">'.$l['title_lock'].'</div>
						</center>
						</div>';
				}else{
					echo'<div class="col-3 pan-button">
						<center><a id="unlock" href="javascript: void(0);" target="" onclick="edit_action(\'unlock\')">
						
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor"><path d="M2 12v6h10v-6H2zm8-7a3 3 0 1 0-6 0v5h8a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2V5a5 5 0 1 1 10 0 1 1 0 0 1-2 0zM7 17a2 2 0 1 1 0-4 2 2 0 0 1 0 4z"/>
						</svg></a>
						<div class="text-admin">'.$l['title_unlock'].'</div>
						</center>
						</div>';
				}
			echo '</div>
			</div><br />
		
		<!------------------------
		// Advanced Options Window
		------------------------->
		
		<div class="roundheader cursor-pointer" onclick="toggle_option(\'advanced\');"><label id="advanced_toggle_indicator" class="min_width">-</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp'.$l['advanced'].'</div>
		<div id="advanced" class="bgaddv">
			<ul class="nav nav-tabs">
				<li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#general_tab">'.$l['general'].'</a></li>
				'.($kernel->features('cpu_pinning', $vps['virt']) || $kernel->features('cpu_mode', $vps['virt']) || $kernel->features('cpu_topology', $vps['virt'])? '<li class="nav-item"><a data-toggle="tab" class="nav-link"  href="#cpu_tab">'.$l['cpu'].'</a></li>' : '').'
				<li class="nav-item"><a class="nav-link"  data-toggle="tab" href="#media_tab">'.$l['media'].'</a></li>
				<li class="nav-item"><a class="nav-link"  data-toggle="tab" href="#network_tab">'.$l['network'].'</a></li>
				'.($kernel->features('virtio', $vps['virt']) ? '<li class="nav-item"><a class="nav-link"  data-toggle="tab" href="#disk_tab">'.$l['disk'].'</a></li>' : '').'
				'.($kernel->features('video', $vps['virt']) ? '<li class="nav-item"><a class="nav-link"  data-toggle="tab" href="#video_tab"> Video </a></li>' : '').''.(check_licensepro() && $kernel->features('vertical_scaling', $vps['virt']) ? '<li class="nav-item"><a class="nav-link"  data-toggle="tab" href="#scaling_tab" id="vertical_scaling_settings"> Scaling </a></li>' : '').'
				'.($kernel->features('passthrough', $vps['virt']) ? '<li class="nav-item"><a class="nav-link"  data-toggle="tab" href="#passthrough_tab"> '.$l['passthrough'].' </a></li>' : '').'
			</ul><hr>
			
			<div class="tab-content">
			
				<!---- // General //---------->
				
				<div id="general_tab" class="tab-pane active">';
				
					if((($vps['virt'] == 'xen' || $vps['virt'] == 'xcp') && !empty($vps['hvm'])) || $vps['virt'] == 'kvm'){
						if($vps['virt'] != 'proxk'){
						
						echo '<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">ACPI&nbsp;<a class="info" data-placement="right" tooltip="'.$l['acpi_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
								'.get_checkbox('acpi', '', '', array('chk_it' => 1, 'val' => $vps['acpi'])).'
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">APIC&nbsp;<a class="info" data-placement="right" tooltip="'.$l['apic_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
								'.get_checkbox('apic', '', '', array('chk_it' => 1, 'val' => $vps['apic'])).'
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">PAE&nbsp;<a class="info" data-placement="right" tooltip="'.$l['pae_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
								'.get_checkbox('pae', '', '', array('chk_it' => 1, 'val' => $vps['pae'])).'
							</div>
						</div>';
						}
					}
					
					if($kernel->features('iso_support', $vps['_virt'])){
						if($kernel->features('boot_order', $vps['_virt'])){
							echo '<div class="row mx-auto w-100 my-3" id="boot_order_row">
								<div class="col-sm-6">
									<label class="control-label">'.$l['boot_order'].'</label>
								</div>
								<div class="col-sm-6">
									<div class="input-group w-100">
										<select class="form-control" name="boot" id="bootorder" size="4">';
											foreach($vps['boot'] as $k){
												echo '<option value='.$k.'>'.strtoupper($k).'</option>';
											}
										echo'
										</select>
										<div class="input-group-append w-50">
											<div class="d-flex flex-column mb-3">
												<div class="p-2">
													<button type="button" id="up" onclick="change_bootorder(this)" class="btn"><i class="fas fa-arrow-up"></i></button>
												</div>
												<div class="p-2">
													<button type="button" id="down" onclick="change_bootorder(this)" class="btn"><i class="fas fa-arrow-down"></i></button>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>';
						}else{
							echo '<div class="row mx-auto w-100 my-3" id="boot_order_row">
								<div class="col-sm-6">
									<label class="control-label">'.$l['boot_order'].'</label>
								</div>
								<div class="col-sm-6">
									<select class="custom-select chosen" name="boot">
										<option value="cda" '.(POSTval('boot') == 'cda' || (empty($_POST) && $vps['boot'] == 'cda') ? 'selected="selected"' : '').'>1) Hard Disk 2) CD Drive</option>
										<option value="dca" '.(POSTval('boot') == 'dca' || (empty($_POST) && $vps['boot'] == 'dca') ? 'selected="selected"' : '').'>1) CD Drive 2) Hard Disk</option>
									</select>
								</div>
							</div>';
						}
					}
					$os_type = $kernel->features('os_type', $vps['_virt']);
					if(!empty($os_type)){			
						echo '
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.$l['os_type'].'</label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select chosen post_data" name="os_type" id="os_type">';
								foreach($os_type as $os_value => $os_full_form){
									echo '<option value="'.$os_value.'" '.(($vps['data']['os_type'] == $os_value) ? 'selected = "selected"' : '').'>'.$os_full_form.'</option>';
								}	
							echo '
								</select>
							</div>
						</div>
						';
					}
					
					if($kernel->features('rtc', $vps['_virt'])){
						
						$rtc = array('1' => $l['ms_enable'],
										'0' => $l['ms_disable']
									);
						echo '
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.$l['rtc'] .'</label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select chosen post_data" name="rtc" id="rtc">';
								
								foreach($rtc as $bol => $options){
									echo '<option value="'.$bol.'" '.(($vps['data']['rtc'] == $bol) ? 'selected = "selected"' : '').'>'.$options.'</option>';
								}	
							echo '
								</select>
							</div>
						</div>';	
					}
					
					// Only available for XEN-HVM
					if(($vps['virt'] == 'xen' && !empty($vps['hvm'])) && distro_check(0, 1, 1, 0, 1)){
						
						// PV-on-HVM drivers
						
						echo '<div class="row mx-auto w-100 my-3">
							<div class=" col-6">
								<label class="control-label">'.$l['pv_on_hvm'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_pv_on_hvm'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class=" col-6">
								'.get_checkbox('pv_on_hvm', '', 'pv_on_hvm', array('chk_it' => 1, 'val' => $vps['pv_on_hvm']), 1, '', array('onchange="ispvonhvm();"')).'
							</div>
					   </div>';
					}

					// TUN/TAP 
					if($kernel->features('tun_tap', $virt)){
						echo '<div class="row hide_for_plan mx-auto w-100 my-2">
							<div class=" col-6">
								<label class="control-label">'.$l['tuntap'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_tuntap'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class=" col-6">
								'.get_checkbox('tuntap', '', 'tuntap', array('chk_it' => 1, 'val' => $vps['tuntap'])).'
							</div>
						</div>';
					}
					
					// TUN/TAP 
					if($kernel->features('openvz_features', $virt)){
						
						$openvz_features = $vps['openvz_features'];
				
						echo '
							<div class="row hide_for_plan mx-auto w-100 my-2">
								<div class=" col-6">
									<label class="control-label">'.$l['ppp'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_ppp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class=" col-6">
									'.get_checkbox('ppp', '', 'ppp', array('chk_it' => 1, 'val' => $vps['ppp'])).'
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class=" col-6">
									<label class="control-label">'.$l['fuse'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['fuse_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class=" col-6">
										'.get_checkbox('fuse', '', 'fuse', array('chk_it' => 1, 'val' => $openvz_features['fuse'])).'
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class=" col-6">
									<label class="control-label">'.$l['ipip'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ipip_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class=" col-6">
									'.get_checkbox('ipip', '', 'ipip', array('chk_it' => 1, 'val' => $openvz_features['ipip'])).'
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class=" col-6">
									<label class="control-label">'.$l['ipgre'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ipgre_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class=" col-6">
									'.get_checkbox('ipgre', '', 'ipgre', array('chk_it' => 1, 'val' => $openvz_features['ipgre'])).'
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class=" col-6">
									<label class="control-label">'.$l['nfs'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['nfs_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class=" col-6">
									'.get_checkbox('nfs', '', 'nfs', array('chk_it' => 1, 'val' => $openvz_features['nfs'])).'
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">'.$l['quotaugidlimit'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['quotaugidlimit_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6">
									<input type="number" class="form-control" name="quotaugidlimit" id="quotaugidlimit" size="30" value="'.POSTval('quotaugidlimit', $openvz_features['quotaugidlimit']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">'.$l['iolimit'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['iolimit_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6">
									<input type="number" class="form-control" name="iolimit" id="iolimit" size="30" value="'.POSTval('iolimit', $openvz_features['iolimit']).'" />
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">'.$l['iopslimit'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['iopslimit_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6">
									<input type="number" class="form-control" name="iopslimit" id="iopslimit" size="30" value="'.POSTval('iopslimit', $openvz_features['iopslimit']).'" />
								</div>
							</div>';
								$netfilter = array('full' => "Full",
								'stateful' => "Stateful"
								);
								echo '
								<div class="row mx-auto w-100 my-3">
									<div class="col-sm-6">
										<label class="control-label">'.$l['netfilter'] .'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['netfilter_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
									</div>
									<div class="col-sm-6">
										<select class="custom-select chosen" name="netfilter" id="netfilter">';
										foreach($netfilter as $netfilter_key => $netfilter_value){
											echo '<option value="'.$netfilter_key.'" '.(($openvz_features['netfilter'] == $netfilter_key) ? 'selected = "selected"' : '').'>'.$netfilter_value.'</option>';
										}	
									echo '
										</select>
									</div>
								</div>';		
					}
					
					if($kernel->features('ebtables_support', $vps['_virt'])){
					
						echo '<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">'.$l['disable_ebtables'].'</label>
							</div>
							<div class="col-6">
								'.get_checkbox('disable_ebtables', '', 'disable_ebtables', array('chk_it' => 1, 'val' => $vps['disable_ebtables'])).'
							</div>
						</div>';
					
					}
					
					if($kernel->features('xenserver_tools', $vps['_virt'])){
						
						$xen_tools_flag = (!empty($vps['install_xentools']) ? 'disabled="disabled"' : '');
						echo '<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">'.$l['install_xentools'].'</label>
								<span class="help-block"></span>
							</div>
							<div class="col-6">
								'.get_checkbox('install_xentools', '', 'install_xentools', array('chk_it' => 1, 'val' => $vps['install_xentools']), 1, '', array($xen_tools_flag)).'
							</div>
						</div>';
					
					}
					
					if($kernel->features('win_support', $vps['_virt'])){
						
						echo '<div class="row mx-auto w-100 hide_for_plan">
							<div class=" col-6">
								<label class="control-label">'.$l['rdp'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_rdp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class=" col-6">
								'.get_checkbox('rdp', '', 'rdp', array('chk_it' => 1, 'val' => $vps['rdp'])).'
							</div>	
					   </div>';
					
					}
					
					if(!empty($vps['vnc']) && $kernel->features('vnc_key_map', $vps['_virt'])){
						
						echo '<div class="row mx-auto w-100 my-3" id="vnckeymap">
							<div class="col-sm-6">
								<label class="control-label">'.$l['vnc_keymap'].'</span>
							</div>
							<div class="col-sm-6">
								<select class="custom-select chosen" name="vnc_keymap" id="vnc_keymap" >
									<option value="en-us" '.ex_POSTselect('vnc_keymap', 'en-us', $vps['vnc_keymap']).'>en-us</option>
									<option value="de-ch" '.ex_POSTselect('vnc_keymap', 'de-ch', $vps['vnc_keymap']).'>de-ch</option>
									<option value="ar" '.ex_POSTselect('vnc_keymap', 'ar', $vps['vnc_keymap']).'>ar</option>
									<option value="da" '.ex_POSTselect('vnc_keymap', 'da', $vps['vnc_keymap']).'>da</option>
									<option value="et" '.ex_POSTselect('vnc_keymap', 'et', $vps['vnc_keymap']).'>et</option>
									<option value="fo" '.ex_POSTselect('vnc_keymap', 'fo', $vps['vnc_keymap']).'>fo</option>
									<option value="fr-be" '.ex_POSTselect('vnc_keymap', 'fr-be', $vps['vnc_keymap']).'>fr-be</option>
									<option value="fr-ch" '.ex_POSTselect('vnc_keymap', 'fr-ch', $vps['vnc_keymap']).'>fr-ch</option>
									<option value="hu" '.ex_POSTselect('vnc_keymap', 'hu', $vps['vnc_keymap']).'>hu</option>
									<option value="it" '.ex_POSTselect('vnc_keymap', 'it', $vps['vnc_keymap']).'>it</option>
									<option value="lt" '.ex_POSTselect('vnc_keymap', 'lt', $vps['vnc_keymap']).'>lt</option>
									<option value="mk" '.ex_POSTselect('vnc_keymap', 'mk', $vps['vnc_keymap']).'>mk</option>
									<option value="nl" '.ex_POSTselect('vnc_keymap', 'nl', $vps['vnc_keymap']).'>nl</option>
									<option value="no" '.ex_POSTselect('vnc_keymap', 'no', $vps['vnc_keymap']).'>no</option>
									<option value="pt" '.ex_POSTselect('vnc_keymap', 'pt', $vps['vnc_keymap']).'>pt</option>
									<option value="ru" '.ex_POSTselect('vnc_keymap', 'ru', $vps['vnc_keymap']).'>ru</option>
									<option value="sv" '.ex_POSTselect('vnc_keymap', 'sv', $vps['vnc_keymap']).'>sv</option>
									<option value="tr" '.ex_POSTselect('vnc_keymap', 'tr', $vps['vnc_keymap']).'>tr</option>
									<option value="de" '.ex_POSTselect('vnc_keymap', 'de', $vps['vnc_keymap']).'>de</option>
									<option value="en-gb" '.ex_POSTselect('vnc_keymap', 'en-gb', $vps['vnc_keymap']).'>en-gb</option>
									<option value="es" '.ex_POSTselect('vnc_keymap', 'es', $vps['vnc_keymap']).'>es</option>
									<option value="fi" '.ex_POSTselect('vnc_keymap', 'fi', $vps['vnc_keymap']).'>fi</option>
									<option value="fr" '.ex_POSTselect('vnc_keymap', 'fr', $vps['vnc_keymap']).'>fr</option>
									<option value="fr-ca" '.ex_POSTselect('vnc_keymap', 'fr-ca', $vps['vnc_keymap']).'>fr-ca</option>
									<option value="hr" '.ex_POSTselect('vnc_keymap', 'hr', $vps['vnc_keymap']).'>hr</option>
									<option value="is" '.ex_POSTselect('vnc_keymap', 'is', $vps['vnc_keymap']).'>is</option>
									<option value="ja" '.ex_POSTselect('vnc_keymap', 'ja', $vps['vnc_keymap']).'>ja</option>
									<option value="lv" '.ex_POSTselect('vnc_keymap', 'lv', $vps['vnc_keymap']).'>lv</option>
									<option value="nl-be" '.ex_POSTselect('vnc_keymap', 'nl-be', $vps['vnc_keymap']).'>nl-be</option>
									<option value="pl" '.ex_POSTselect('vnc_keymap', 'pl', $vps['vnc_keymap']).'>pl</option>
									<option value="pt-br" '.ex_POSTselect('vnc_keymap', 'pt-br', $vps['vnc_keymap']).'>pt-br</option>
									<option value="sl" '.ex_POSTselect('vnc_keymap', 'sl', $vps['vnc_keymap']).'>sl</option>
									<option value="th" '.ex_POSTselect('vnc_keymap', 'th', $vps['vnc_keymap']).'>th</option>
								</select>
							</div>
						</div>';
					}
					
				echo '<div class="row mx-auto w-100 my-3">';
							$disabled = '';
							if($vps['load_balancer'] == -1){
								$disabled = 'disabled=true';
							}
							echo'
						<div class="col-6">
							<label class="control-label">'.$l['admin_managed'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_admin_managed'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6">
							'.get_checkbox('admin_managed', '', '', array('chk_it' => 1, 'val' => $vps['admin_managed']), 1, '', $disabled).'
						</div>
					</div>';
					
					if($kernel->features('nw_config', $vps['virt'])){
					
						echo '
					<div class="row mx-auto w-100 my-3">
						<div class="col-6">
							<label class="control-label">'.$l['disable_nw_config'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_disable_nw_config'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6">
							'.get_checkbox('disable_nw_config', '', 'disable_nw_config', array('chk_it' => 1, 'val' => $vps['disable_nw_config'])).'
						</div>
					</div>';
					
					}

					if($kernel->features('enable_guest_agent', $vps['virt'])){
						$disabled = '';
						
						// If this VM itself is a load balancer
						if($vps['load_balancer'] == -1){
							$disabled = 'disabled=true';
							echo '
							<div class="row mx-auto w-100 my-3">
								<div class="col-6">
									<label class="control-label">'.$l['disable_guest_agent'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_disable_guest_agent'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-6">
									'.get_checkbox('disable_guest_agent', '', 'disable_guest_agent', array('chk_it' => 1, 'val' => $vps['data']['disable_guest_agent']), '1', 'post_data', [$disabled]).'
								</div>
							</div>';
						}

					}

					if($kernel->features('bios', $vps['virt'])){
									
						echo '
						<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">'.$l['bios'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_bios'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							</div>
							<div class="col-6">
								<select class="custom-select chosen post_data" name="bios" id="bios" onchange="toggle_bios();">
									<option value="seabios" '.(optREQ('bios') === 'seabios' || (empty($vps['data']['bios']) || (!empty($vps['data']['bios']) && $vps['data']['bios'] === 'seabios')) ? 'selected="selected"' : '').'>SeaBios (Default)</option>
									<option value="uefi" '.(optREQ('bios') === 'uefi' || (!empty($vps['data']['bios']) && $vps['data']['bios'] === 'uefi') ? 'selected="selected"' : '').'>UEFI (OVMF)</option>
								</select>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3" id="tpm_row" style="display:none">
							<div class="col-6 ">
								<label class="control-label">'.$l['add_tpm'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['add_tpm_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-6">
								'.get_checkbox('enable_tpm', '', 'enable_tpm', array('chk_it' => 1, 'val' => $vps['data']['enable_tpm']),'1', 'post_data').'
							</div>
						</div>';
					}

					// Check whether we can add this under any load balancer if its not under any load balancer already
					if($kernel->features('load_balancer', $vps['virt']) && !preg_match('/windows/is', $ostemplates[$vps['osid']]['name']) && empty($vps['load_balancer'])){

						echo '
						<div class="row mx-auto w-100 my-3" id="load_balancer_card">
							<div class="col-sm-12 col-lg-6 col-xl-6 col-md-6 col-xs-12">
								<label class="control-label">'.$l['select_lb'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_lb_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
							</div>
							<div class="col-sm-12 col-lg-6 col-xl-6 col-md-6 col-xs-12">
								<select name="load_balancer" class="virt-select post_data" id="load_balancer">
										<option value="0">'.$l['none'].'</option>';
										if(!empty($load_balancer)){
											foreach($load_balancer as $vpsuuid => $lbv){
												echo '<option value="'.$vpsuuid.'" '.ex_POSTselect('load_balancer', $vpsuuid, $vps['load_balancer']).'>'.$lbv['vpsid'].' - '.$lbv['hostname'].'</option>';
											}
										}
										echo '
								</select>
							</div>
						</div>';
			
					}	
					if($kernel->features('nested_virt', $vps['_virt'])){
						echo '
						<div class="row mx-auto w-100 hide_for_plan">
							<div class=" col-6">
								<label class="control-label">'.$l['nested_vit'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['nested_vit_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class=" col-6">
								'.get_checkbox('nested_virt', '', 'nested_virt', array('chk_it' => 1, 'val' => $vps['data']['nested_virt']), '1', 'post_data').'
							</div>	
						</div>';
					}
					
				echo '</div>
				
				<!---- // CPU //---------->
				<div id="cpu_tab" class="tab-pane">';
				
					if($kernel->features('cpu_pinning', $vps['virt'])){
						$cpu_pinning_flag = (!empty($_POST) ? (is_array($_POST['cpupin']) ? '' : 'checked="checked"') : ($vps['cpupin'] == -1 ? 'checked="checked"' : ''));
						echo '
					<div class="row mx-auto w-100 my-3">
						<div class="col-6">
							<label class="control-label">'.$l['cpupin'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['cpupin_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6">
							'.get_checkbox('allcores', '', 'allcores', array('chk_it' => 0), 1, '', array('onchange="pincheck()"', $cpu_pinning_flag));
						echo '</div>
					</div>
					<div class="row mx-auto w-100 my-3" id="pincores">
						<div class="col-sm-6">
							<label class="control-label">'.$l['cpupin_select'].'</label>
						</div>
							
						<div class="col-sm-6">';
						for($i=0; $i < $resources['cpucores']; $i++){
							$cpucores_flag = (!empty($_POST) ? (in_array($i, $_POST['cpupin']) || in_array((string)$i, $_POST['cpupin']) ? 'checked="checked"' : '') : (in_array($i, $vps['_cpupin']) || in_array((string)$i, $vps['_cpupin']) ? 'checked="checked"' : ''));
							
							echo get_checkbox('cpupin['.$i.']', 'vCPU '.($i+1), 'pin'.$i, array('chk_it' => 0), $i, '', array($cpucores_flag));
						}
							
						echo '</div>
					</div>';
					}
				
					if($kernel->features('numa',  $vps['_virt'])){
						echo '
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.$l['usenuma'].'</label>
							</div>
							<div class="col-sm-6">
								'.get_checkbox('numa', '', 'numa', array('chk_it' => 1, 'val' => $vps['numa'])).'
							</div>
						</div>';
					}
					
					if($kernel->features('machine_type', $vps['_virt'])){

						echo'<div class="row mx-auto w-100 my-3">
							 <div class="col-sm-6">
								 <label class="control-label">'.$l['machine_type'].'</label>
							 </div>
							 <div class="col-sm-6">
								 <select class="custom-select chosen" name="machine_type" id="machine_type" post_data>';
									 echo '<option value="" selected="selected">'.$l['none'].'</option>';
									 foreach($machine_type as $k => $v){
										echo '<option value="'.$k.'" '.(optREQ('machine_type') == $k || $vps['data']['machine_type'] === $k ? 'selected="selected"' : '').'>'.$v.'</option>';
									 }
									 echo '
								 </select>
							 </div>
							 </div>';

					 }
					
					if($kernel->features('cpu_topology', $vps['_virt'])){
						$cpu_topology_flag = (!empty($vps['topology_sockets']) ? 'checked="checked"' : '' );
						echo '
						<div class="row mx-auto w-100 my-3">
							<div class="col-6">
								<label class="control-label">'.$l['cpu_topology'].'</label>
							</div>
							<div class="col-6">
								'.get_checkbox('enable_cpu_topology', '', 'enable_cpu_topology', array('chk_it' => 0), 1, '', array(' onclick="cputopology();"', $cpu_topology_flag)).'
							</div>
						</div>
						<div id="cpu_topology_option">
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">Sockets</label>
								</div>
								<div class="col-sm-6">
									<input type="text" name="topology_sockets" id="topology_sockets" class="form-control numbersonly" size="6" value="'.POSTval('topology_sockets', $vps['topology_sockets']).'" >
								</div>
							</div>
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">Cores</label>
								</div>
								<div class="col-sm-6">
									<input type="number" class="form-control numbersonly" name="topology_cores" id="topology_cores" size="6" value="'.POSTval('topology_cores', $vps['topology_cores']).'" >
								</div>
							</div>';
							
						if($kernel->features('cpu_threads', $vps['virt'])){
							echo '
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">Threads</label>
								</div>
								<div class="col-sm-6">
									<input type="number" class="form-control numbersonly" name="topology_threads" id="topology_threads" size="6" value="'.POSTval('topology_threads', $vps['topology_threads']).'" >
								</div>
							</div>';
						}
						
						echo '
						</div>';
					}
										
					if($kernel->features('cpu_mode',  $vps['_virt'])){	
						echo '<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.$l['cpu_mode'].'</label>
							</div>
							<div class="col-sm-6">
								<select class="custom-select chosen post_data" name="cpu_mode" id="cpu_mode"  '.(($kernel->features('cpu_flags', $vps['_virt']) && $cluster->check_feature($vps['serid'], $vps['_virt'], 'cpu_flags')) ? 'onchange="prox_cpu_flags()"' : "").'>';
						
								foreach($cpu_modes as $ck => $cv){
									echo '<option value="'.$ck.'" '.ex_POSTselect('cpu_mode', $ck, $vps['cpu_mode']).'>'.$cv.'</option>';
								}
								
								echo '
								</select>
							</div>
						</div>';
					}

					if($kernel->features('cpu_flags',  $vps['_virt']) && $cluster->check_feature($vps['serid'], $vps['_virt'], 'cpu_flags')){	

						$cpu_flags = array(
							'md-clear',
							'pcid',
							'spec-ctrl',
							'ssbd',
							'ibpb',
							'virt-ssbd',
							'amd-ssbd', 
							'amd-no-ssb',
							'pdpe1gb',
							'hv-tlbflush',
							'hv-evmcs',
							'aes' 
						);
				
						echo '<div class="mx-3">
								<div class="row mx-auto w-100 my-3 extra_cpu_flags" style="display:none;">
									<div class="col-12 p-0">
										<label class="control-label"><small>'.$l['extra_cpu_flag'].'</small></label>
									</div>
								</div>';
								foreach($cpu_flags as $flag){
									$class = '';
									if( !empty($cpu_info['amd_cpu']['exception'][$flag])){
										$class .= ' '.implode(' ', $cpu_info['amd_cpu']['exception'][$flag]);
									}elseif(in_array($flag, $cpu_info['amd_cpu']['cpu_flags'])){
										$class .= ' '.implode(' ', $cpu_info['amd_cpu']['cpu_mode']);
									}

									if( !empty($cpu_info['intel_cpu']['exception'][$flag])){
										$class .= ' '.implode(' ', $cpu_info['intel_cpu']['exception'][$flag]);
									}elseif(in_array($flag, $cpu_info['intel_cpu']['cpu_flags'])){
										$class .= ' '.implode(' ', $cpu_info['intel_cpu']['cpu_mode']);
									}

									if( !empty($cpu_info['other_cpu']['exception'][$flag])){
										$class .= ' '.implode(' ', $cpu_info['other_cpu']['exception'][$flag]);
									}elseif(in_array($flag, $cpu_info['other_cpu']['cpu_flags'])){
										$class .= ' '.implode(' ', $cpu_info['other_cpu']['cpu_mode']);
									}
									echo '
										<div class="row mx-auto w-100 my-3 '.$flag.' '.$class.' hide_all_cpu_flags" style="display:none">
											<div class="col-5">
												<label class="control-label">'.$l[$flag].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l[$flag.'-info'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
											</div>
											<div class="col-2">
												<label class="custom-control custom-radio">
													<input type="radio" class="custom-control-input post_data" id="'.$flag.'-on" name="'.$flag.'" value="1" '. ($vps['data']['cpu_flags'][$flag] == 1 ? 'checked="checked"' : '') .'>
													<span class="custom-control-label" for="'.$flag.'">'.$l['on'].'</span>
												</label>
											</div>
											<div class="col-3">
												<label class="custom-control custom-radio">
													<input type="radio" class="custom-control-input post_data" id="'.$flag.'-default" name="'.$flag.'" value="0" '. ($vps['data']['cpu_flags'][$flag] == 0 ? 'checked="checked"' : '') .'>
													<span class="custom-control-label" for="'.$flag.'">'.$l['default'].'</span>
												</label>
											</div>
											<div class="col-2">
												<label class="custom-control custom-radio">
													<input type="radio" class="custom-control-input post_data" id="'.$flag.'-off" name="'.$flag.'" value="2" '. ($vps['data']['cpu_flags'][$flag] == 2 ? 'checked="checked"' : '') .'>
													<span class="custom-control-label" for="'.$flag.'">'.$l['off'].'</span>
												</label>
											</div>
										</div>';
								
								}
						echo '</div>';

					}

					$cpu_threshold_perc = (!empty($vps['data']['enable_cpu_threshold']) ? 'checked="checked"' : '');
					echo'<div class="row mx-auto w-100 my-3">
							<div class=" col-6">
								<label class="control-label">'.$l['cpu_threshold'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['cpu_threshold_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								'.get_checkbox('enable_cpu_threshold', '', 'enable_cpu_threshold', array('chk_it' => 1), 1, '', array('onchange="checkcputhreshold();"', $cpu_threshold_perc)).'
							</div>
						</div>
						<div id="cputhresholdpercentage" class="input-group" style="display:'.(!empty($vps['data']['enable_cpu_threshold']) ? 'block' : 'none').'">
							<div class="row mx-auto w-100 my-3">
								<div class="col-sm-6">
									<label class="control-label">'.$l['cpu_percentage'].'</label>
								</div>
								<div class="col-sm-6 input-group">
									<input type="number" min="0" max="100" class="form-control" name="cpu_threshold" id="cpu_threshold" size="6" value="'.POSTval('cpu_threshold', intval($vps['data']['cpu_threshold'])).'"/> 
									<span class="input-group-text">%</span>
								</div>
							</div>
							<div class="row mx-auto w-100">
								<div class="col-sm-6">
									<label class="control-label">'.$l['cpu_thre_time'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['cpu_thre_time_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-6 input-group">
									<input type="number" min="0" class="form-control" name="cpu_threshold_time" id="cpu_threshold_time" size="30" value="'.POSTval('cpu_threshold_time', intval($vps['data']['cpu_threshold_time'])).'"/> 
									<span class="input-group-text">
										<i class="fas fa-stopwatch" style="color: #000000;"></i>
									</span>
								</div>
							</div>
						</div>
					</div>
				
				<!---- // Media //---------->
				<div id="media_tab" class="tab-pane">';
					
					// Is webuzo enabled ?
					if(!empty($iscripts) && $ostemplates[$vps['osid']]['distro'] == 'webuzo'){

						echo '<div class="row mx-auto w-100 my-3">
							<div class="col-sm-5">
								<label class="control-label">'.$l['apps'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['apps_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-7">
							<select class="custom-select" name="sid" id="sid">
							<option value="0" '.(POSTval('sid') == 0 ? 'selected="selected"' : '').'>'.$l['none'].'</option>';
							
							foreach($iscripts as $k => $v){		
								echo '<option value="'.$k.'" '.(POSTval('sid', $vps['webuzo']) == $k ? 'selected="selected"' : '').'>'.$scripts[$k]['name'].'</option>';
							}		
							 echo'</select>
							</div>
						</div>';
					}
				
					echo '<div class="row mx-auto w-100 my-3">
						<div class="col-sm-5">
							<label class="control-label">'.$l['mg'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['mg_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-7">
							<select class="virt-select" name="mgs[]" id="mg" multiple="multiple">';
								
								foreach($mgs as $mk => $mv){
									if($vps['_virt'] != $mv['mg_type']) continue;
									echo '<option value="'.$mk.'" type="'.$mv['mg_type'].'" '.(in_array($mk, (empty($_POST['editvps']) ? $vps['mg'] : @$_POST['mgs'])) ? 'selected="selected"' : '').'>'.$mv['mg_name'].'</option>';
								}
								
							echo '</select>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-5">
							<label class="control-label">'.$l['osreinstall'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_osreinstall'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-7">
							<input type="text" class="form-control" name="osreinstall_limit" id="osreinstall_limit"  value="'.POSTval('osreinstall_limit', $vps['osreinstall_limit']).'" />
						</div>
					</div>';
					
					if(!empty($isos) && $kernel->features('iso_support', $vps['_virt'])){
						echo '<div class="row mx-auto w-100 my-3" id ="iso_row">
							<div class="col-sm-5">	
								<label class="control-label">'.$l['vsiso'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['vsiso_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-7">';
							
							echo '<select class="custom-select chosen" name="iso" id="iso">
							<option value="0" '.(POSTval('iso') == 0 ? 'selected="selected"' : '').'>'.$l['none'].'</option>';
							
							$options_eu_iso = $options_iso = '';
							foreach($isos as $k => $v){
								if(!empty($v['isuseriso'])){
									$options_eu_iso .= '<option value="'.$k.'" '.(POSTval('iso') == $k ? 'selected="selected"' : ($vps['iso'] == $k ? 'selected="selected"' : '')). '>'.$v['name'].'</option>';
								}else{
									$options_iso .= '<option value="'.$k.'" '.(POSTval('iso') == $k ? 'selected="selected"' : ($vps['iso'] == $k ? 'selected="selected"' : '')).'>'.$v['name'].'</option>';
								}
							}
							if(!empty($options_iso)){
								echo '<optgroup label="'.$l['admin_iso'].'">'.$options_iso.'</optgroup>';
							}
							
							if(!empty($options_eu_iso)){
								echo '<optgroup label="'.$l['eu_iso'].'">'.$options_eu_iso.'</optgroup>';
							}
							 echo'</select>
							</div>
						</div>';
					}
							
					if(!empty($isos) && $kernel->features('sec_iso_support', $vps['_virt'])){
						echo '<div class="row mx-auto w-100 my-3">
							<div class="col-sm-5">
								<label class="control-label">'.$l['sec_vsiso'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['sec_vsiso_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-7">
							
							<select class="custom-select chosen" name="sec_iso" id="sec_iso">
							<option value="0" '.(POSTval('sec_iso') == 0 ? 'selected="selected"' : '').'>'.$l['none'].'</option>';
							$options_eu_iso = $options_iso = '';
							foreach($isos as $k => $v){
								if(!empty($v['isuseriso'])){
									$options_eu_iso .= '<option value="'.$k.'" '.(POSTval('sec_iso') == $k ? 'selected="selected"' : ($vps['sec_iso'] == $k ? 'selected="selected"' : '')).'>'.$v['name'].'</option>';
								}else{
									$options_iso .= '<option value="'.$k.'" '.(POSTval('sec_iso') == $k ? 'selected="selected"' : ($vps['sec_iso'] == $k ? 'selected="selected"' : '')).'>'.$v['name'].'</option>';
								}
							}

							if(!empty($options_iso)){
								echo '<optgroup label="'.$l['admin_iso'].'">'.$options_iso.'</optgroup>';
							}
							if(!empty($options_eu_iso)){
								echo '<optgroup label="'.$l['eu_iso'].'">'.$options_eu_iso.'</optgroup>';
							}
							echo'</select>
							</div>
						</div>';
					}
					
				echo '</div>
				
				<!---- // Networking //---------->
				
				<div id="network_tab" class="tab-pane">
					
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">	
							<label class="control-label">'.$l['band'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_band'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-lg-5 col-md-5 col-11 pr-0">
						<input type="number" class="form-control" name="bandwidth" id="band" size="30" value="'.POSTval('bandwidth', $vps['bandwidth']).'" onchange="handle_capping();" />
						</div>
						<div class="col-1 p-0 pt-1 pl-1">'.$l['band_gb'].'</div>
					</div>

					<script type="text/javascript">
					function netspeed(r){
						$_("network_speed").value = r;
						handle_capping();
					}
					function upspeed(r){
						$_("upload_speed").value = r;
						handle_capping();
					}
					</script>

					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-12">
							<label class="control-label">'.$l['network_speed'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['network_speed_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-12">
							<div class="input-group w-100">
								<input type="number" class="form-control rounded" name="network_speed" id="network_speed" size="8" value="'.POSTval('network_speed', $vps['network_speed']).'" onchange="handle_capping();"/>
								<div class="input-group-append w-50">
									<span class="input-group-text mr-1">'.$l['net_kb'].'</span>
									<select class="custom-select speedkBps virt-select" name="network_speed2" id="network_speed2" onchange="netspeed(this.value)"></select>
								</div>
							</div>
						 </div>
					</div>
					
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-12">
							<label class="control-label">'.$l['upload_speed'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['upload_speed_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-12">
							<div class="input-group ">
								<input type="number" class="form-control rounded" name="upload_speed" id="upload_speed" size="8" value="'.POSTval('upload_speed', $vps['upload_speed']).'" onchange="handle_capping();" />
								<div class="input-group-append w-50">
									<span class="input-group-text mr-1">'.$l['net_kb'].'</span>
									<select class="virt-select speedkBps" name="upload_speed2" id="upload_speed2" onchange="upspeed(this.value)"></select>
								</div>
							</div>
						</div>
					</div>
					
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6">
							<label class="control-label">'.$l['band_suspend'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_band_suspend'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-6">
							'.get_checkbox('band_suspend', '', 'band_suspend', array('chk_it' => 1, 'val' => $vps['band_suspend']), 1, '', array('onchange="handle_capping();"')).'
						</div>	
					</div>
					<div id="speed_cap_limit">
						<div class="row mx-auto w-100 my-3">
							<div class=" col-sm-12">
								<label class="control-label">'.$l['speed_cap_down'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_speed_cap_down'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-12">
								<div class="input-group ">
									<input type="number" class="form-control rounded" name="speed_cap_down" value="'.POSTval('speed_cap_down', $vps['speed_cap']['down']).'" id="speed_cap_down" onmouseout="blur();" />			
									<div class="input-group-append w-50">
										<span class="square mr-1">'.$l['net_kb'].'</span>
										<select class="virt-select speedkBps" name="speed_cap_down2" id="speed_cap_down2" onchange="$(\'#speed_cap_down\').val(this.value)"></select>
									</div>
								</div>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class=" col-sm-12">
								<label class="control-label">'.$l['speed_cap_up'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_speed_cap_up'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class=" col-sm-12">
								<div class="input-group ">
									<input type="number" class="form-control rounded" name="speed_cap_up" value="'.POSTval('speed_cap_up', $vps['speed_cap']['up']).'" id="speed_cap_up" onmouseout="blur();" />
									<div class="input-group-append w-50">
										<span class="square mr-1">'.$l['net_kb'].'</span>
										<select class="virt-select speedkBps" name="speed_cap_up2" id="speed_cap_up2" onchange="$(\'#speed_cap_up\').val(this.value)"></select>
									</div>
								</div>
							</div>
						</div>
					</div>';
				   
					// Internal IP
					if(!empty($ips_int) || !empty($vps['ips_int'])){
					
						echo '<div class="row mx-auto w-100 my-3" id="internal_ip_row">
						<div class="col-sm-6">
							<label class="control-label">'.$l['ips_int'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ips_int_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
						<select id="ips_int" class="form-control" name="ips_int[]" size="5" multiple="multiple">';
					
						$_ips_int = array();

						// This is to put the Posted IPs first
						if(!empty($_POST['ips_int'])){
							foreach($_POST['ips_int'] as $k => $v){
								$_ips_int[$v] = $v;
							}
						}
						
						// Then the VPS IPs
						foreach($vps['ips_int'] as $k => $v){
							$_ips_int[$v] = $v;
						}
						
						// Then the extra IPs
						foreach($ips_int as $k => $v){
							$_ips_int[$v['ip']] = $v['ip'];
						}
						
						$_ips_int = array_unique($_ips_int);
						
						foreach($_ips_int as $k => $v){	 
							echo '<option value="'.$v.'" '.(isset($_POST['editvps']) ? (@in_array($v, $_POST['ips_int']) ? 'selected="selected"' : '') : (@in_array($v, $vps['ips_int']) ? 'selected="selected"' : '')).'>'.$v.'</option>';
						}
								
						echo '</select>
						</div>
						</div>';
						
					}
					
					if(!empty($vps['mac'])){
						echo '<div class="row mx-auto w-100 my-3" id="mac_row">
							<div class="col-sm-6">
								<label class="control-label">'.$l['mac'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_mac'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<input type="text" class="form-control" name="mac" id="mac" value="'.POSTval('mac', $vps['mac']).'">
							</div>
						</div>';
					}
				
					if(!empty($supported_nics)){
						
						echo '<div class="row mx-auto w-100 my-3" id="nic_row">
							<div class="col-sm-6">
								<label class="control-label">'.$l['changenic'].'</label>
							</div>
							<div class="col-sm-6">
								<select class="form-control custom-select" name="nic_type" id="nic_type" >';
							
								foreach($supported_nics as $k => $v){
					
									echo '<option value="'.$v.'" '.ex_POSTselect('nic_type', $v, $vps['nic_type']).'>'.(!empty($l['nic_'.$v]) ? $l['nic_'.$v] : $v).'</option>';
								}
								
								echo '</select>
							</div>
						</div>';
					}
					/*
					if($kernel->features('vlan_tag', $virt)){

						echo'<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.$l['vlan_tag'].'</label><br>
							</div>
							<div class="col-sm-6">
								<input type="number" max="4094" class="form-control post_data" name="vlan_tag" id="vlan_tag"  value="'.POSTval('vlan_tag', $vps['data']['vlan_tag']).'"/>
							</div>
						</div>';
	
					}
					*/
				
					if($vps['virt'] == 'xen' && !empty($vps['hvm'])){
						echo '<div class="row mx-auto w-100 my-3" id="tr_viftype">
							<div class="col-sm-6">
								<label class="control-label">'.$l['change_vif_type'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_change_vif_type'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
							</div>
							<div class="col-sm-6">
								<select name="vif_type" class="form-control" id="vif_type">
									<option value="netfront" '.ex_POSTselect('vif_type', 'netfront', $vps['vif_type']).'>'.$l['viftype_netfront'].'</option>
									<option value="ioemu" '.ex_POSTselect('vif_type', 'ioemu', $vps['vif_type']).'>'.$l['viftype_ioemu'].'</option>
								</select>
							</div>
						</div>';
					}
					
					echo '<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.$l['dns'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_dns'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<div class="row mx-auto w-100 my-1">
								<div class="col-sm-12 p-0" id="dnstable">';
								 
									$_dns = @(empty($_POST['dns']) ? $vps['dns'] : $_POST['dns']);

									if(is_array($_dns) && !empty($_dns)){
										foreach($_dns as $d => $ds){
											if(empty($ds)){
												unset($_dns[$d]);
											}
										}
									}
										
									if(empty($_dns)){
										$_dns = array(NULL);
									}
									 
									foreach($_dns as $dn){
										echo '<div class="row mx-auto w-100 my-1">
										<div class="col-11 p-0 d-inline-flex">
											<input type="text" class="form-control" name="dns[]" value="'.$dn.'" />
										</div>
										</div>';
									}
										
								echo '
								</div>	
								</div>
								<input type="button" onclick="adddnsrow(\'dnstable\')" class="btn blue_btn py-1 px-2" value="'.$l['add_dns'].'"/>

						</div>
					</div>
				</div>
				
				<!---- // DISK //---------->
				<div id="disk_tab" class="tab-pane">';
				
				if($kernel->features('virtio', $vps['_virt'])){
					
					echo '
					<div class="row mx-auto w-100 my-3">
						<div class=" col-sm-6">
							<label class="control-label">'.$l['disk_driver'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_disk_driver'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class=" col-2">
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" name="virtio" value="0" id="disk_driver_none" '.(POSTval('virtio', $vps['virtio']) == '0' ? 'checked="checked"' : '').'>
								<span class="custom-control-label" for="disk_driver_none">'.$l['none_plan'].'</span>
							</label> 
						</div>
						<div class="col-2">
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" name="virtio" value="1" id="virtio" '.(POSTval('virtio', $vps['virtio']) == '1' ? 'checked="checked"' : '').'>
								<span class="custom-control-label" for="virtio">'.$l['virtio'].'</span>
							</label>
						</div>
						<div class="col-2">
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" name="virtio" value="2" id="scsi" '.(POSTval('virtio', $vps['virtio']) == '2' ? 'checked="checked"' : '').'>
								<span class="custom-control-label" for="scsi">'.$l['scsi'].'</span>
							</label>
						</div>
					</div>';
				}	

				if($kernel->features('discard', $virt)){

					echo'<div class="row mx-auto w-100 my-3">
						<div class="col-6">
							<label class="control-label">'.$l['enable_discard'].'</label><br>
						</div>
						<div class="col-6">
							'.get_checkbox('discard', '', 'discard', array('chk_it' => 1, 'val' => $vps['data']['discard']), 1, 'post_data').'
						</div>
					</div>';

				}

				if($kernel->features('kvm_cache', $vps['virt'])){
					
					echo '
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.$l['kvm_cache'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_kvm_cache'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<select class="custom-select chosen" name="kvm_cache" id="kvm_cache">
								<option value="0" '.ex_POSTselect('kvm_cache', 'none', $vps['kvm_cache']).'>None</option>
								<option value="writeback" '.ex_POSTselect('kvm_cache', 'writeback', $vps['kvm_cache']).'>Writeback</option>
								<option value="writethrough" '.ex_POSTselect('kvm_cache', 'writethrough', $vps['kvm_cache']).'>Writethrough</option>
								<option value="directsync" '.ex_POSTselect('kvm_cache', 'directsync', $vps['kvm_cache']).'>Direct Sync</option>
								<option value="default" '.ex_POSTselect('kvm_cache', 'default', $vps['kvm_cache']).'>Default</option>
							</select>
						</div>
					</div>';
				}
					
				if($kernel->features('io_mode', $vps['_virt'])){
					
					echo '
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-6">
							<label class="control-label">'.$l['io_mode'].'</label>
						</div>
						<div class="col-sm-6">
							<select class="custom-select chosen" name="io_mode" id="io_mode">
								<option value="0" '.ex_POSTselect('io_mode', 'default', $vps['io_mode']).'>Default</option>
								<option value="native" '.ex_POSTselect('io_mode', 'native', $vps['io_mode']).'>Native</option>
								<option value="threads" '.ex_POSTselect('io_mode', 'threads', $vps['io_mode']).'>Threads</option>
							</select>
						</div>
					</div>';
				}
					
					if($kernel->features('iops_sec', $virt)){
						echo '<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.$l['total_iops_sec'].'</label>
							</div>
							<div class="col-sm-4">
								<input type="number" class="form-control" name="total_iops_sec" value="'.POSTval('total_iops_sec', $vps['total_iops_sec']).'" />
							</div>
							<div class="col-sm-2"></div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.$l['read_bytes_sec'].'</label>
							</div>
							<div class="col-4">
								<div class="input-group">
									<input type="number" class="form-control" name="read_bytes_sec" value="'.POSTval('read_bytes_sec', $vps['read_bytes_sec']).'" />
									<div class="input-group-append">
										<span class="input-group-text" id="basic-addon2">MB/s</span>
									</div>
								</div>
							</div>
						</div>
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6">
								<label class="control-label">'.$l['write_bytes_sec'].'</label>
							</div>
							<div class="col-4">
								<div class="input-group">
									<input type="number" class="form-control" name="write_bytes_sec" value="'.POSTval('write_bytes_sec', $vps['write_bytes_sec']).'" />
									<div class="input-group-append">
										<span class="input-group-text" id="basic-addon2">MB/s</span>
									</div>
								</div>
							</div>
						</div>';
					}
		
					if($kernel->features('ssd_emulation', $virt)){
						echo'
						<div class="row mx-auto w-100 my-3">
							<div class="col-sm-6 ssd_emulation">
								<label class="control-label">'.$l['ssd_emulation'].'</label>
							</div>
							<div class="col-4 ssd_emulation">
								'.get_checkbox('ssd_emulation', '', 'ssd_emulation', array('chk_it' => 1, 'val' => $vps['data']['ssd_emulation']), 1, 'post_data').'
							</div>
						</div>';	
					}
					
					
				echo '</div>
				
				<!---- // Video //---------->
				<div id="video_tab" class="tab-pane">
					<div class="row mx-auto w-100 my-3">
						<div class=" col-6">
							<label class="control-label">'.$l['kvm_vga'].'</label>
						</div>
						<div class=" col-6">
							'.get_checkbox('kvm_vga', '', 'kvm_vga', array('chk_it' => 1, 'val' => $vps['kvm_vga']), 1, '', array('onchange="enable_accel();"')).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3" id="vga_vram_div" style="display:none;">
						<div class=" col-6">
							<label class="control-label">'.$l['vga_vram'].'</label>
						</div>
						<div class="col-4">
							<input type="text" class="form-control post_data" name="vga_vram" id="vga_vram"  value="'.POSTval('vga_vram', $vps['data']['vga_vram']).'" />
						</div>
						<div class="col-2 pt-2">MB</div>
					</div>
					
					<div class="row mx-auto w-100 my-3" id="enable_acceleration" style="display:none;">
						<div class=" col-6">
							<label class="control-label">'.$l['acceleration'].'</label>
						</div>
						<div class=" col-6">
							'.get_checkbox('acceleration', '', 'acceleration', array('chk_it' => 1, 'val' => $vps['acceleration'])).'
						</div>
					</div>
				</div>';

				if($kernel->features('passthrough', $vps['virt'])){
				echo '
					<div id="passthrough_tab" class="tab-pane">';
						if($kernel->features('pci_passthrough', $vps['virt'])){
							echo 
							'<div class="row mx-auto w-100 my-3" id="pci">
								<div class="col-sm-5">
									<label class="control-label">'.$l['pci'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['pci_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-7">
									<select class="chosen post_data" id="pcis" name="pcis[]" multiple="multiple" onchange="show_pci_warning();">';

										foreach($pcis as $iommu_grp_num => $v){
							
											echo '<optgroup label=" '.$l['iommu_grp'].' '.$iommu_grp_num.'">';
													foreach($v as $sk => $sv){
														echo'<option value="'.$sk.'" '.(!empty($vps['pci'][$iommu_grp_num][$sk]) ? 'selected = "selected"': '').'>'.substr(trim($sv), 0, -1).'</option>';
													}
											echo'</optgroup>';
										}

										echo
									'</select>
									<span id="pci_warning_note" class="text-danger" style="display:none">'.$l['passthrough_poweroff_warning'].'</span>
								</div>
							</div>';
						}
					
						if($kernel->features('usb_passthrough', $vps['virt'])){
							echo 
							'<div class="row mx-auto w-100 my-3" id="usb">
								<div class="col-sm-5">
									<label class="control-label">'.$l['usb'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['usb_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
								</div>
								<div class="col-sm-7">
									<select class="chosen post_data" id="usbs" name="usbs[]" multiple="multiple">';
										foreach($usbs as $k => $v){	
											echo "<option value='$k' ".(array_key_exists($k, $vps['usb']) ? 'selected': '').">[{$k}] - {$v['name']}</option>";
										};
										echo
									'</select>
								</div>
							</div>';
						}
						echo
					'</div>';
				}

				if(check_licensepro()){
					echo '
					<div id="scaling_tab" class="tab-pane">
						<div class="row mx-auto w-100">
							<div class="col-sm-12 p-2">';
								if(empty($globals['enable_ver_scaling'])){
									echo'
									<div class="row mx-auto w-100">
										<div class="col-6 p-0">
											<label class="control-label">'.$l['enable_ver_scaling'].'</label>
										</div>
										<div class="col-6 p-0">
											'.get_checkbox('enable_ver_scaling', '', 'enable_ver_scaling', array('chk_it' => 1, 'val' => $vps['data']['enable_ver_scaling']), 1, 'post_data').'
										</div>
									</div>';
								}
								echo'
								<fieldset class="ver_scale_settings">
									<div class="row mx-auto w-100">
										<div class="col-sm-12 notice">
											'.$l['ver_scaling_note'].'
										</div>
									</div>
									<h5>'.$l['ver_ram_settings'].'</h5>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="control-label">'.$l['ver_max_ram'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ver_max_ram_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control post_data" name="ver_max_ram" value="'.POSTval('ver_max_ram', $vps['data']['ver_max_ram']).'" placeholder="'.(!empty($globals['ver_max_ram']) ? $l['default'].' '.$globals['ver_max_ram'] : '').'" />
										</div>
									</div>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="control-label">'.$l['ver_ram_threshold'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ver_ram_threshold_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control post_data" name="ver_ram_threshold" value="'.POSTval('ver_ram_threshold', $vps['data']['ver_ram_threshold']).'" placeholder="'.(!empty($globals['ver_ram_threshold']) ? $l['default'].' '.$globals['ver_ram_threshold'] : '').'" />
										</div>
									</div>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="control-label">'.$l['ver_ram_inc_by'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ver_ram_inc_by_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control post_data" name="ver_ram_inc_by" value="'.POSTval('ver_ram_inc_by', $vps['data']['ver_ram_inc_by']).'" placeholder="'.(!empty($globals['ver_ram_inc_by']) ? $l['default'].' '.$globals['ver_ram_inc_by'] : '').'" />
										</div>
									</div>
									<hr>
									<h5>'.$l['ver_cpu_settings'].'</h5>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="control-label">'.$l['ver_max_cpu'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ver_max_cpu_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control post_data" name="ver_max_cpu" value="'.POSTval('ver_max_cpu', $vps['data']['ver_max_cpu']).'" placeholder="'.(!empty($globals['ver_max_cpu']) ? $l['default'].' '.$globals['ver_max_cpu'] : '').'" />
										</div>
									</div>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="control-label">'.$l['ver_cpu_threshold'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ver_cpu_threshold_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control post_data" name="ver_cpu_threshold" value="'.POSTval('ver_cpu_threshold', $vps['data']['ver_cpu_threshold']).'" placeholder="'.(!empty($globals['ver_cpu_threshold']) ? $l['default'].' '.$globals['ver_cpu_threshold'] : '').'" />
										</div>
									</div>
									<div class="row mx-auto w-100 my-3">
										<div class="col-sm-12 p-0">
											<label class="control-label">'.$l['ver_cpu_inc_by'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ver_cpu_inc_by_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
											<input type="text" class="form-control post_data" name="ver_cpu_inc_by" value="'.POSTval('ver_cpu_inc_by', $vps['data']['ver_cpu_inc_by']).'" placeholder="'.(!empty($globals['ver_cpu_inc_by']) ? $l['default'].' '.$globals['ver_cpu_inc_by'] : '').'" />
										</div>
									</div>
								</fieldset>
							</div>
						</div>
					</div>';
				}
				echo '
			</div>
		</div><br />
		<!-----------------------------
		//  VPS Notes Window
		------------------------------>
		
		
		<div class="roundheader cursor-pointer" onclick="toggle_option(\'notes\');"><label id="notes_toggle_indicator" class="min_width">-</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp'.$l['notes'].'</div>
		<div id="notes" class="bgaddv">
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-12">
					<textarea  name="notes" id="notes" rows="10" class="form-control">'.POSTval('notes', $vps['notes']).'</textarea>
				</div>
			</div>
		</div>
		
		
		
		
	</div>
	<div class="col-sm-6 col-xs-12">
		
		<!-----------------------------
		//  Resource Utilization Window
		------------------------------>
		
		<div class="roundheader cursor-pointer" onclick="toggle_option(\'resource_utilization\');"><label id="resource_utilization_toggle_indicator" class="min_width">-</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp'.$l['resource_utilization'].'</div>
		<div id="resource_utilization" class="bgaddv p-3">
			<label class="control-label"> CPU :</label>
			<div class="progress">
				<div id="cpu_bar" class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="width:0%">
					0%
				</div>
			</div>
			<span class="help-block">'.$l['cores'].' : '.$vps['cores'].'&nbsp; | &nbsp;'.$l['percent'].' : '.$vps['cpu_percent'].'</span><br><br>
			<label class="control-label">'.$l['band'].' :</label>
			<div class="progress">
				<div id="bandwidth_bar" class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="width:0%">
					0%
				</div>
			</div>
			<span class="help-block">'.$l['band_used'].' : '.$vps['used_bandwidth'].'&nbsp; | &nbsp;'.$l['band_limit'].' : '.$vps['bandwidth'].'</span><br><br>
			<label class="control-label">'.$l['disk'].' :</label>
			<div class="progress">
				<div id="disk_bar" class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="width:0%">
					0%
				</div>
			</div>';
			
			// File system for non OpenVZ 
			if(!$kernel->features('openvz', $vps['_virt'])){
				echo '<span class="help-block">'.$l['file_system'].' : '.$vps['cached_disk']['disk']['Filesystem'].'</span>';
			}
			
			echo '<span class="help-block">'.$l['utilized'].' : '.$vps['stats']['used_disk'].'&nbsp;GB &nbsp; | &nbsp; '.$l['avaiable'].' : '.$vps['stats']['avaiable_disk'].'&nbsp;GB</span><br><br>';
			
			if($kernel->features('vps_ram_info', $vps['_virt'])){
			
				if(!empty($vps['stats']['used_ram']) && (($vps['_virt'] == 'kvm' && !empty($vps['data']['enable_guest_agent'])) || $vps['_virt'] != 'kvm')){
				
					echo '<label class="control-label">'.$l['ram'].' :</label>
					<div class="progress">
						<div id="ram_bar" class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" style="width:0%">
							0%
						</div>
					</div>
					<span class="help-block">'.$l['allocated_ram'].' : '.$vps['ram'].' MB &nbsp; | &nbsp; '.$l['used_ram'].' : '.$vps['stats']['used_ram'].' MB</span>';
				}elseif($vps['_virt'] == 'kvm' && empty($vps['data']['enable_guest_agent'])){
					echo '<label class="control-label"><div class="roundflare bg-info text-always-white">'.$l['ram'] .' : '. $l['guest_agent_nt_instl'].'.</div class="roundflare bg-warning"></label>';
				}
			}
			
		echo '</div><br>
		
		<!--------------------------
		//  Edit User Window
		--------------------------->
		
		<div class="roundheader cursor-pointer" onclick="toggle_option(\'edit_user\');"><label id="edit_user_toggle_indicator" class="min_width">-</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp'.$l['edit_user'].'</div>
		<div id="edit_user" class="bgaddv">
			<div class="row mx-auto w-100 my-3" id="change_user_row">
				<div class="col-sm-12">
					<div class="d-flex align-items-center">
						<label class="control-label">'.$l['vs_user'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['vs_user_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>&nbsp;&nbsp;<a href="https://'.$globals ['HTTP_HOST'].':4083/'.$SESS['token_key'].'/index.php?suid='.$vps['uid'].'" target="_blank" title="'.$l['svs_admin_login'].'">
						<i class="fas fa-external-link-alt text-dark info" tooltip="'.$l['svs_admin_login'].'"></i></a></label>
						<div class="loader ml-2" style="display:none;" id="ajax_user_loader"></div>
					</div>
					<select class="custom-select chosen post_data" name="uid" id="uid" onchange="adduser();'.(($kernel->features('load_balancer', $virt) && 
					!preg_match('/windows/is', $ostemplates[$vps['osid']]['name'])) ? 'get_user_lb()' : '').'">
					<option value="0" '.(isset($_POST['editvps']) && $_POST['uid'] == 0 ? 'selected="selected"' : '').'>'.$l['add_user'].'</option>';

						foreach($users as $k => $v){
							$parent = !empty($users[$v['pid']]['email']) ? "(".$users[$v['pid']]['email'].")" : "";
							echo '<option value="'.$k.'" '.ex_POSTselect('uid', $k, $vps['uid']).'>'.$v['email'].' '.$parent.'</option>';
						}
				
					echo'</select>
				</div>
			</div>
			
			<div class="row mx-auto w-100 my-3 user_details_f" id="user_details_f">
				<div class="col-sm-12">
					<fieldset class="user_details_f" style="display:none">
						<legend class="user_details_f mb-0">'.$l['user_details'].'</legend>
						<div class="row user_details my-2" style="display:none">
							<div class="col-sm-12">
								<label class="control-label">'.$l['user_email'].'</label>
								<input type="text" class="form-control" name="user_email" size="30" value="'.(isset($_POST['editvps']) && !empty($_POST['user_email']) ? $_POST['user_email'] : '').'" />
								<span class="help-block"></span>
							</div>
						</div>
						<div class="row user_details my-2" style="display:none">
							<div class="col-sm-12">
								<label class="control-label">'.$l['user_pass'].'</label>
								<div class="input-group ">
									<input type="text" class="form-control" name="user_pass" size="30" value="'.(isset($_POST['editvps']) && !empty($_POST['user_pass']) ? $_POST['user_pass'] : '').'" id="rand_user_pass" autocomplete="off"/>
								  <div class="input-group-append">
									<a href="javascript: void(0);" class="btn-primary rounded-right" onclick="$_(\'rand_user_pass\').value=rand_pass(12);check_pass_strength(\'rand_user_pass\');return false;" title="'.$l['randpass'].'"><i class="fas fa-key p-2"></i></a>
								  </div>
								</div>
								
							</div>
						</div>
						
						<div class="row user_details my-2" style="display:none">
							<div class="col-sm-12">
								<label class="control-label">'.$l['fname'].'</label>
								<input type="text" class="form-control" name="fname" size="30" value="'.(isset($_POST['editvps']) && !empty($_POST['fname']) ? $_POST['fname'] : '').'" />
							</div>
							<div class="col-sm-1"></div>
						</div>
						
						<div class="row user_details my-2" style="display:none">
							<div class="col-sm-12">
								<label class="control-label">'.$l['lname'].'</label>
								<input type="text" class="form-control" name="lname" size="30" value="'.(isset($_POST['editvps']) && !empty($_POST['lname']) ? $_POST['lname'] : '').'" />
							</div>
							<div class="col-sm-1"></div>
						</div>
					</fieldset>
				</div>
			</div>
			<div class="row user_details my-2 mx-auto w-100" style="display:none">
				<div class="col-sm-12">
					<label class="control-label">'.$l['dnsplid'].'</label>
					<span class="help-block">'.$l['dnsplid_exp'].'</span>		
					<select class="custom-select chosen" name="dnsplid">';
						 foreach($dnsplans as $dk => $dv){		 
							echo '<option value="'.$dk.'" '.(isset($_POST['editvps']) && $_POST['dnsplid'] == $dk ? 'selected="selected"' : '').'>'.$dv['plan_name'].'</option>';
						}
				
					echo '</select>
				</div>
			</div>
		</div><br />
		
		<!--------------------------
		//  Edit VPS Window
		--------------------------->
		
		<div class="roundheader cursor-pointer" onclick="toggle_option(\'edit_vps\');"><label id="edit_vps_toggle_indicator" class="min_width">-</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp'.$l['edit_vps'].'</div>
		<div id="edit_vps" class="bgaddv">
			<div class="row mx-auto w-100 my-3"> 
				<div class="col-sm-12">
					<label class="control-label">'.$l['vs_plan'].'</label>
					<br /><select class="custom-select chosen" id="plid" name="plid" onchange="loadplan(this.value)">';
				 foreach($plans as $k => $v){
					echo '<option value="'.$k.'" '.(POSTval('plid') == $k ? 'selected="selected"' : ($vps['plid'] == $k ? 'selected="selected"' : '')).'>'.$v['plan_name'].'</option>';
				}
				
			echo '</select>
				</div>
			</div>';
			
			if(!empty($backup_plans)){
					
				$bpid = !empty($_POST) ? POSTval('bpid') : $vps['bpid'];
			
				echo '<div class="row mx-auto w-100 my-3"> 
				<div class="col-sm-12">
					<label class="control-label">'.$l['backup_plan'].'</label>
					<br /><select class="custom-select chosen" name="bpid">
					<option value="0" '.($bpid == 0 ? 'selected="selected"' : '').'>'.$l['none'].'</option>
					<option value="-1" '.($bpid == -1 ? 'selected="selected"' : '').'>'.$l['same_as_vps_plan'].'</option>';
					
					foreach($backup_plans as $k => $v){
						echo '<option value="'.$k.'" '.($bpid == $k ? 'selected="selected"' : '').'>'.$v['plan_name'].'</option>';
					}
				
				echo '</select>
				</div>
			</div>';
			
			}
			
			if(!empty($admin_firewall_plans)){
				$fwpid = (!empty($_POST) ? POSTval('admin_fwid') : $vps['admin_fwid']);
				echo '
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12">
						<label class="control-label">'.$l['admin_firewall_plan'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['admin_firewall_plan_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						<br /><select class="custom-select chosen" id="admin_fwid" name="admin_fwid">
						<option value="0" '.(empty($fwpid) ? 'selected="selected"' : '').'>'.$l['none'].'</option>';
						foreach($admin_firewall_plans as $k => $v){
							
							echo '<option value="'.$k.'" '.($fwpid == $k ? 'selected="selected"' : '').'>'.$v['fw_plan_name'].'</option>';
						}
					echo '</select>
					</div>
				</div>';
			}

			if(!empty($enduser_firewall_plans)){
				$fwpid = (!empty($_POST) ? POSTval('fwid') : $vps['fwid']);
				echo '
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12">
						<label class="control-label">'.$l['firewall_plan'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['firewall_plan_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						<br /><select class="custom-select chosen" id="fwid" name="fwid">
						<option value="0" '.(empty($fwpid) ? 'selected="selected"' : '').'>'.$l['none'].'</option>';
						foreach($enduser_firewall_plans as $k => $v){
							
							echo '<option value="'.$k.'" '.($fwpid == $k ? 'selected="selected"' : '').'>'.$v['fw_plan_name'].'</option>';
						}
					echo '</select>
					</div>
				</div>';
			}
			 echo '<div class="row mx-auto w-100 my-3" id="hostname_row">
				<div class="col-sm-12">
					<label class="control-label">'.$l['hostname'].'&nbsp;&nbsp;<a href="https://'.$globals ['HTTP_HOST'].':4083/'.$SESS['token_key'].'/index.php?#!svs='.$vps['vpsid'].'" target="_blank" title="'.$l['svs_adm_login'].'">
					<i class="fas fa-external-link-alt text-dark info" tooltip="'.$l['svs_admin_login'].'"></i></a></label>
					<input type="text" class="form-control" name="hostname" id="hostname" size="30" value="'.POSTval('hostname', $vps['hostname']).'" />
				</div>
			</div>';
			if($kernel->features('win_support', $vps['_virt'])){

				echo'<div class="row mx-auto w-100 my-3" id="windows_username_row">
						<div class="col-sm-12">
							<div class="d-flex align-items-center">
								<label class="control-label">'.$l['vm_username'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['vm_username_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>&nbsp;&nbsp;</label>
							</div>
						</div>
						<div class="col-sm-12" id="windows__username">
							<input type="text" class="form-control" name="vm_admin_name" id="vm_admin_name">
						</div>
					</div>';
			}
			echo'
			<div class="row mx-auto w-100 my-3" id="rootpass_row">
				<div class="col-sm-12">
					<label class="control-label">'.$l['rootpass'].'</label><br />
					<div class="input-group ">
						<input type="text" class="form-control" name="rootpass" id="rootpass" size="30" onkeyup="check_pass_strength(\'rootpass\');" value="'.POSTval('rootpass', '').'" autocomplete="off"/>
					  <div class="input-group-append">
						<div id="rootpass_pass-strength-result" class="w-auto strong d-flex align-items-center">'.$l['strength_indicator'].'</div><a href="javascript: void(0);" class="btn-primary rounded-right" onclick="$_(\'rootpass\').value=randstr(12, 1, '.(!empty($globals['pass_strength']) ? $globals['pass_strength'] : 0).');check_pass_strength(\'rootpass\');return false;" title="'.$l['randpass'].'"><i class="fas fa-key p-2"></i></a>
					  </div>
					</div>
					
				</div>
			</div>

			<div class="row mx-auto w-100 my-3" id="ipv4_row">
				<div class="col-sm-12">
					<label class="control-label mb-2">'.$l['ip'].'</label>
				</div>
				<div class="col-sm-6 pb-2 pr-1">
					<table border="0" cellpadding="0" cellspacing="0" class="w-100 shadow-none">
					<tr>
						<td valign="top">
							<div class="ips_scroll">
							<table cellpadding="3" cellspacing="0" class="w-100 shadow-none" id="iptable">';
					 
							$_ips = @(empty($_POST['ips']) ? $vps['ips'] : $_POST['ips']);
							
							if(is_array($_ips) && !empty($_ips)){
								foreach($_ips as $k => $ip){
									if(empty($ip)){
										unset($_ips[$k]);
									}
								}
							}
							
							if(empty($_ips)){
								$_ips = array(NULL);
							}
						 
							foreach($_ips as $ip){
								echo '<tr>
									<td>
										<input type="text" class="form-control ips float-left w-90 post_data" name="ips[]" value="'.$ip.'" onblur="checkippool();" size="15" />
										<a class="delip" title="'.$l['rem_from_ips'].'"><i class="fas fa-times text-danger cursor-pointer py-2"></i></a>
									</td>
								</tr>';
							}
							
						echo '</table>
							</div>
							<input type="button" class="btn blue_btn mt-2 py-1 px-2" onclick="javascript:addrow(\'iptable\');" value="'.$l['add_ip'].'"/>
						</td>
					</tr>
					</table>
				</div>
				<div class="col-sm-6">
					<div id="iplist_parent">
						<select class="form-control" id="iplist" size="5" multiple="multiple">';
						if(!empty($ips)){
							foreach($ips as $k => $v){	 
								echo '<option value="'.$k.'">'.$v['ip'].'</option>';
							}		
						}
						echo'</select>
						<div class="d-flex mt-1 align-items-center">
							<a class="btn blue_btn py-1 px-2" onclick="javascript:addtoips(\'iptable\');">'.$l['add_to_ips'].'</a>&nbsp;&nbsp;
							<a class="btn blue_btn py-1 px-2" onclick="javascript:remove_all_ips();">'.$l['remove_all_ips'].'</a>
						</div>
				
					</div>
				</div>
			</div>';

			if(!empty($ips6_subnet) || !empty($vps['ips6_subnet'])){

			echo '<div class="row mx-auto w-100 my-3" id="ips6_subnet_row">
				<div class="col-sm-12">
					<label class="control-label">'.$l['ips6_subnet'].'</label>
				</div>
				<div class="col-sm-12">';	
				// Then the VPS IPs
				foreach($vps['ips6_subnet'] as $k => $v){
					$tmp = explode('/', $v);
					$_ipv6_subnet[$k] = array('ip' => $tmp[0], 'ipr_netmask' => $tmp[1]);
				}
				
				// Then the extra IPs
				foreach($ips6_subnet as $k => $v){
					$_ipv6_subnet[$k] = array('ip' => $v['ip'], 'ipr_netmask' => $v['ipr_netmask']);
				}
				
				// This is to put the Posted IPs first
				if(!empty($_POST['ipv6_subnet'])){

					$posted_subnet = array();
					
					foreach($_POST['ipv6_subnet'] as $k => $v){
						//$_ipv6_subnet[$v] = $v;
						
						foreach($_ipv6_subnet as $_k => $_v){
							if($v == $_v['ip']){
								$posted_subnet[$_k] = $_k;
								$__ipv6_subnet[$_k] = $_ipv6_subnet[$_k];
							}
						}
									
					}
					
				}
				
				// Then the remaining IPs
				foreach($_ipv6_subnet as $k => $v){
					$__ipv6_subnet[$k] = $v;
				}
				
				echo '<select id="ipv6_subnet" class="form-control" name="ipv6_subnet[]" size="5" multiple="multiple">';
				foreach($__ipv6_subnet as $k => $v){
					echo '<option value="'.$v['ip'].'" '.(isset($_POST['editvps']) ? (!empty($posted_subnet[$k]) ? 'selected="selected"' : '') : (!empty($vps['ips6_subnet'][$k]) ? 'selected="selected"' : '')).'>'.$v['ip'].' / '.$v['ipr_netmask'].'</option>';
				}		
				echo'</select>
				</div>
			</div>';

			}

			// IPv6
			if(!empty($ips6) || !empty($vps['ips6'])){

			echo '<div class="row mx-auto w-100 my-3" id="ipv6_row">
				<div class="col-sm-12">
					<label class="control-label">'.$l['ips6'].'</label><br />
				</div>
				<div class="col-sm-12">
					<input type="number" class="form-control" name="ipv6count" id="ipv6count" size="10" onblur="ipchoose(this.name, this.value)" /><br />
				</div>
				<div class="col-sm-12">
					<select id="ipv6" class="form-control" name="ipv6[]" size="5" multiple="multiple" onchange="countipv6(\'ipv6count\');">';
					
					$_ipv6 = array();
					
					// This is to put the Posted IPs first
					if(!empty($_POST['ipv6'])){
						foreach($_POST['ipv6'] as $k => $v){
							$_ipv6[$v] = $v;
						}
					}
					
					// Then the VPS IPs
					foreach($vps['ips6'] as $k => $v){
						$_ipv6[$v] = $v;
					}
					
					// Then the extra IPs
					foreach($ips6 as $k => $v){
						$_ipv6[$v['ip']] = $v['ip'];
					}
					
					$_ipv6 = array_unique($_ipv6);
					
					foreach($_ipv6 as $k => $v){	 
						echo '<option value="'.$v.'" '.(isset($_POST['editvps']) ? (@in_array($v, $_POST['ipv6']) ? 'selected="selected"' : '') : (@in_array($v, $vps['ips6']) ? 'selected="selected"' : '')).'>'.$v.'</option>';
					}
						
					echo '</select>
				</div>
			</div>';

			}

			echo '

<style>
.uuid{
font-size: 11px;
}
</style>';	
			if($bus_driver){
			echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12">
						<label class="control-label mr-2">'.$l['hdd'].'</label> '.virthelp('add-new-storage').'
					</div>
					<div class="col-sm-12">
						<table name="storages" id="storages" cellpadding="3" cellspacing="" class="border-0 shadow-none">';
							
							// Find the disk information 
							if(empty($disks)){
								
								if(!empty($vps['disks'])){
									$disks = $vps['disks'];
								}else{
									$disks[0]['size'] = $vps['space'];
									$disks[0]['st_uuid'] = $storages[$stid]['st_uuid'];
								}
							}
							
							if($vps['virt'] == 'xen' && empty($vps['hvm'])){
								unset($disks[1]);
							}
							
							foreach($disks as $k => $v){
								echo '<tr>
									<td width="20%">
										<select class="custom-select bus_driver w-90 post_data" id = "bus_driver" name="bus_driver[]" disabled="disabled">';
											
										echo '<option value="'.$v['bus_driver'].'">'.strtoupper($v['bus_driver']).'</option>';
												
									echo '</select>
									</td>
									<td width="15%">
										<select class="custom-select bus_driver_num w-90 post_data" id = "bus_driver_num" name="bus_driver_num[]" disabled="disabled">';
											
										echo '<option value="'.$v['bus_driver_num'].'">'.$v['bus_driver_num'].'</option>';
												
									echo '</select>
									</td>
									<td width="15%">
										<div class=" ml-1 row">
											<input type="number" step="0.001" id="hdd_'.$k.'" class="form-control size w-90 post_data" name="tmp_space[]" size="15" value="'.$v['size'].'"/>
										</div>
									</td>
									<td width="10%">
										<div class="square">'.$l['space_gb'].'</div>
									</td>
									<td width="35%">
										<select class="custom-select storages_list w-100 float-left" name="storages[]" id="storages'.$k.'" disabled="disabled">';
										
											foreach($storages as $sk => $sv){
												echo '<option value="'.$sv['st_uuid'].'" '.($sv['st_uuid'] == $v['st_uuid'] ? 'selected="selected"' : '').'>'.$sv['name'].'&nbsp;('.$sv['disk_space'].'GB '.(empty($sv['oversell']) ? $l['free'] : $l['oversell_free']).')</option>';
											}
										echo '</select>'.(($k != 0 && empty($v['user_uid'])) ? '<td><a class="delstorage" title="'.$l['rem_storage'].'"><i class="fas fa-times text-danger cursor-pointer py-2"></i></a></td>' : '').
										(!empty($v['user_uid']) ? '<td><i class="fas fa-hdd text-primary cursor-pointer py-2" title="'.$l['volume_disk'].'"></i></a></td>' : '').
										'<input class="disk_uuids" type="hidden" name="disk_uuids[]" value="'.$v['disk_uuid'].'">
									</td>
									<td width="5%">
										'.($v['disk_uuid'] ? '<i class="fas text-primary fa-info-circle" tooltip="Disk UUID : '.$v['disk_uuid'].'"></i>': '').'
							   		</td>
								</tr>';
							}
						echo '</table><input type="hidden" id="hdd" name="space" />
						<input type="hidden" id="num_disks" name="num_disks" class="post_data" value="'.count($disks).'"/>	
						<a id="add_storage"  href="javascript:add_storage_bus(\'storages\');" class="btn blue_btn py-1 px-2">'.$l['add_ip'].'</a>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3 scsi_controller">
					<div class="col-sm-12">
						<label class="control-label">'.$l['scsi_controller'].'</label>
						<select id="scsi_controller" name="scsi_controller" class="custom-select">
							<option value="">'.$l['none'].'</option>
							<option value="virtio-scsi-pci" '.(($vps['data']['scsi_controller'] == 'virtio-scsi-pci') ? 'selected = "selected"' : '').'> VirtIO SCSI </option>
							<option value="lsi" '.(($vps['data']['scsi_controller'] == 'lsi') ? 'selected = "selected"' : '').'> LSI 53C895A </option>
							<option value="lsi53c810" '.(($vps['data']['scsi_controller'] == 'lsi53c810') ? 'selected = "selected"' : '').'> LSI 53C810 </option>
							<option value="megasas" '.(($vps['data']['scsi_controller'] == 'megasas') ? 'selected = "selected"' : '').'> MegaRAID SAS 8708EM2 </option>
							<option value="virtio-scsi-single" '.(($vps['data']['scsi_controller'] == 'virtio-scsi-single')? 'selected = "selected"' : '').'> VirtIO SCSI single </option>
							<option value="pvscsi" '.(($vps['data']['scsi_controller'] == 'pvscsi') ? 'selected = "selected"' : '').'> VMware PVSCSI </option>
						</select>
					</div>
				</div>';
			}else{
			echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12">
						<label class="control-label mr-2">'.$l['hdd'].'</label>'.virthelp('add-new-storage').'
					</div>
					<div class="col-sm-12">
						<table name="storages" id="storages" cellpadding="3" cellspacing="" class="border-0 shadow-none">';
							
							// Find the disk information 
							if(empty($disks)){
								
								if(!empty($vps['disks'])){
									$disks = $vps['disks'];
								}else{
									$disks[0]['size'] = $vps['space'];
									$disks[0]['st_uuid'] = $storages[$stid]['st_uuid'];
								}
							}
							
							if($vps['virt'] == 'xen' && empty($vps['hvm'])){
								unset($disks[1]);
							}
							
							foreach($disks as $k => $v){
								echo '<tr>
									<td width="25%">
										<input type="number" step="0.001" id="hdd_'.$k.'" class="form-control size" name="tmp_space[]" size="15" value="'.$v['size'].'" />
									</td>
									<td width="3%"><div class="square">'.$l['space_gb'].'</div></td>
									<td>'.($v['disk_uuid'] ? '<span class="roundflare"><a class="uuid" href="javascript:void(0)" title="Disk UUID : '.$v['disk_uuid'].'">'.$v['disk_uuid'].'</a></span>': '').'</td>
									<td>
										<select class="custom-select storages_list w-100 float-left" name="storages[]" id="storages'.$k.'" disabled="disabled">';
										
											foreach($storages as $sk => $sv){
												echo '<option value="'.$sv['st_uuid'].'" '.($sv['st_uuid'] == $v['st_uuid'] ? 'selected="selected"' : '').'>'.$sv['name'].'&nbsp;('.$sv['disk_space'].'GB '.(empty($sv['oversell']) ? $l['free'] : $l['oversell_free']).')</option>';
											}
										echo '</select>'.($k != 0 && empty($v['user_uid']) ? '<td><a class="delstorage" title="'.$l['rem_storage'].'"><i class="fas fa-times text-danger cursor-pointer py-2"></i></a></td>' : '').
										(!empty($v['user_uid']) ? '<td><i class="fas fa-hdd text-primary cursor-pointer py-2" title="'.$l['volume_disk'].'"></i></a></td>' : '').
										'<input class="disk_uuids" type="hidden" name="disk_uuids[]" value="'.$v['disk_uuid'].'">
									</td>
								</tr>';
							}
							
						echo '</table><input type="hidden" id="hdd" name="space" />
						<a id="add_storage" href="javascript:add_storage(\'storages\');" class="btn blue_btn py-1 px-2">'.$l['add_ip'].'</a>
					</div>
				</div>';
			}

			echo '
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-12">
					<label class="control-label">'.$l['gram'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_gram'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-12">
					<div class="input-group">
						<input type="number" class="form-control" name="ram" min="0" id="gram" size="30" value="'.POSTval('ram', $vps['ram']).'" />
						<div class="input-group-append">
							<span class="input-group-text" id="basic-addon2">'.(empty($resources['overcommit']) ? $resources['ram'] : ($resources['overcommit'] - $servers[$globals['server']]['alloc_ram'])).' '.$l['ram_mb'].' '.(empty($resources['overcommit']) ? $l['free'] : $l['overcomit_free']).'&nbsp</span>
						</div>
					</div>
				</div>
			</div>';
			
			if($kernel->features('balloon', $vps['_virt']) && $cluster->check_feature($vps['serid'], $vps['_virt'], 'min_ram')){
				echo '<div class="row mx-auto w-100 my-3">
						<div id="minram" class="col-sm-12 hide_for_plan">
							<label class="control-label">'.$l['min_ram'].'</label>
						</div>
						<div class="col-9 input-group ">
							<input type="number" min="0" class="form-control rounded" name="min_ram" id="min_ram" size="30" value="'.POSTval('min_ram', $vps['data']['min_ram']).'" />
							<div class="input-group-append">
								<span class="input-group-text">'.$l['ram_mb'].'</span>
							</div>
						</div>
					</div>';
			}
			
			if($vps['virt'] == 'openvz' || $vps['virt'] == 'proxo'){

				echo '<div class="row mx-auto w-100 my-3" id="burst">
					<div class="col-sm-12">
					<label class="control-label">'.$l['bram'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_bram'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
					</div>
					<div class="col-9 input-group">
						<input type="number" min="0" class="form-control" name="burst" id="bram" size="30" value="'.POSTval('burst', $vps['burst']).'" />
						<span class="input-group-text">'.$l['ram_mb'].'</span>
					</div>
				</div>';

			}
			
			if($vps['virt'] != 'openvz' && $vps['virt'] != 'proxo'){

				echo '<div class="row mx-auto w-100 my-3" id="swappedram">
					<div class="col-sm-12">
						<label class="control-label">'.$l['swap'].'</label><br />
					</div>
					<div class="col-9 input-group">
						<input type="number" min="0" class="form-control" name="swapram" id="swap" size="30" value="'.POSTval('swapram', $vps['swap']).'" />
						<span class="input-group-text">'.$l['ram_mb'].'</span>
					</div>
				</div>';

			}

			echo '
			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-12">
				<label class="control-label">'.$l['cpunit'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['cpalloc'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
				<a href="'.$globals['docs'].'creating-a-vps/#cpu-parameters" target="_blank" tooltip="'.$l['open_guide'].'"><i class="fas fa-external-link-alt info"></i></a>
				</div>
				<div class="col-9 input-group">
					<input type="number" min="0" class="form-control" name="cpu" id="cpunit" size="30" value="'.POSTval('cpu', $vps['cpu']).'" />
					<span class="input-group-text">'.$l['units'].'</span>
				</div>
			</div>

			<div class="row mx-auto w-100 my-3">
				<div class="col-sm-12">
					<label class="control-label">'.$l['cores'].'&nbsp;</label>
					<a href="'.$globals['docs'].'creating-a-vps/#cpu-parameters" target="_blank" tooltip="'.$l['open_guide'].'"><i class="fas fa-external-link-alt info"></i></a>
				</div>
				<div class="col-9">
					<input type="number" min="0" class="form-control" name="cores" id="cores" size="30" value="'.POSTval('cores', $vps['cores']).'" />
				</div>
			</div>';
			
			if($vps['virt'] != 'lxc'){
				echo '
			<div class="row mx-auto w-100 my-3" id="cpupercent">
				<div class="col-sm-12">
					<label class="control-label">'.$l['percent'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['cpuperutil'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					<a href="'.$globals['docs'].'creating-a-vps/#cpu-parameters" target="_blank" tooltip="'.$l['open_guide'].'"><i class="fas fa-external-link-alt info"></i></a>
				</div>
				<div class="col-9 input-group">
					<input type="number" min="0" class="form-control" name="cpu_percent" id="percent" size="30" value="'.POSTval('cpu_percent', intval($vps['cpu_percent'])).'" />
					<span class="input-group-text">%</span>
				</div>
			</div>';
			}

			if($kernel->features('io_priority', $vps['_virt'])){		
					
				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12">
						<label class="control-label">'.$l['io'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['io0-7'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
					</div>
					<div class="col-9">
						<select id="prior" name="priority" class="custom-select">
							<option value="0">0</option>
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
							<option value="4">4</option>
							<option value="5">5</option>
							<option value="6">6</option>
							<option value="7">7</option>
						</select>
					</div>
				</div>';
			}

			if($vps['virt'] == 'openvz'){

				if(!distro_check(1)){
					$ploop_flag = (!empty($vps['ploop']) ? 'disabled=disabled' : '');
					echo '<div class="row mx-auto w-100 my-3">
						<div class="col-6">
							<label class="control-label">'.$l['ploop'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ploop_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
						</div>
						<div class="col-6">
							'.get_checkbox('ploop', '', '', array('chk_it' => 1, 'val' => $vps['ploop']), 1, '', $ploop_flag).'
						</div>
					</div>';
				}
				echo '<div class="row mx-auto w-100 my-3" id="ubc">
					<div class="col-6">
						<label class="control-label">'.$l['ubcsettings'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_ubc'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br /><a href="'.$globals['index'].'act=ubc&vpsid='.$vps['vpsid'].'">'.$l['ubcsettings'].'</a>
					</div>
					<div class="col-6">
						'.get_checkbox('ubcsettings').'
					</div>
				</div>';

			}

			if($vps['virt'] == 'xen' && !empty($vps['hvm'])){
					
				echo '<div class="row mx-auto w-100 my-3">
					<div class="col-sm-12">
						<label class="control-label">'.$l['shadow'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['shadow_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
					</div>
					<div class="col-9 input-group">
						<input type="number" class="form-control" name="shadow" id="shadow" size="30" value="'.POSTval('shadow', $vps['shadow']).'" />
						<span class="input-group-text">'.$l['ram_mb'].'</span>
					</div>
				</div>';

			}

			if($kernel->features('vnc_support', $vps['_virt'])){

				$vncpasslen = $kernel->features('vncpasslen', $virt);
				echo '
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4 p-0">
						<div class="row mx-auto w-100">
							<div class="col-4">
								<label class="control-label">VNC</label>
							</div>
							<div class="col-1">
								'.get_checkbox('vnc', '', 'vnc', array('chk_it' => 1, 'val' => $vps['vnc']), 1, '', array('onchange="checkvnc();"')).'
							</div>
						</div>
					</div>
					<div class="col-sm-8 p-0">
						<div class="row mx-auto w-100 my-0" id="vncpassrow">
							<div class="col-sm-12 p-0">
								<label class="control-label">'.$l['vncpass'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['vncpass_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br />
							</div>
							<div class="col-sm-10 p-0">
								<input type="text" class="form-control" name="vncpass" id="vncpass" size="30" value="'.POSTval('vncpass', '').'" autocomplete="off"/>
							</div>
							<div class="col-sm-2 p-0 pl-1">
								<a href="javascript: void(0);" onclick="$_(\'vncpass\').value=randstr('.$vncpasslen.');return false;" title="'.$l['vncpass'].'"><i class="fas pt-2 fa-key"></i></a>
							</div>
						</div>
					</div>
					
				</div>
				';
			}
			$tmp_demo_time = '';
			$tmp_demo_action = '';
			$tmp_demo = $vps['data']['demo'];

			if(!empty($tmp_demo) && is_int($tmp_demo)){
				$tmp_demo_time = $tmp_demo;
				$tmp_demo_action = 0;
			}else if(!empty($tmp_demo) && is_array($tmp_demo)){
				$tmp_demo_time = $tmp_demo['time'];
				$tmp_demo_action = $tmp_demo['action'];
			}

			echo '
			<div class="row mx-auto w-100 my-3 ">
				<div class="col-sm-4 p-0 pt-1 pr-2 pl-0">
					<div class="row mx-auto w-100">
						<div class="col-9 hide_for_plan d-flex align-items-center">
							<label class="control-label">'.$l['enable_demo'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['demo'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>	
						<div class="col-3 p-0">
							'.get_checkbox('demo_edit', '', 'demo_edit', array('chk_it' => 1, 'name' => 'demo_edit','val' => (!empty($tmp_demo_time) ? 1 : '')), 1, '', array('onchange="checkdemo();"')).'
							<input type="hidden" name="demo_edit" id="hidden_demo_edit">
						</div>	
					</div>
				</div>
				
				<div id="demotime" class="col-sm-4 p-1">
					<label class="control-label">'.$l['time'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['demo_time'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
					<div class="input-group ">
					<input type="text" class="form-control" placeholder="HH:MM:SS" name="demo_time" id="dtime1" size="30" value="'.POSTval('demo_time', (!empty($tmp_demo_time)) ? datify($tmp_demo_time, 0, 0, 'H:i:s') : '').'"  />
						<div class="input-group-append">
							<span class="input-group-text"><a class="text-white" onclick="$_(\'dtime1\').value=\''.datify(time(), 0, 1, 'H:i:s').'\'" value="'.$l['current_time'].'" /><i class="fas fa-clock"></i></a></span>
						</div>
					</div>	
				</div>
				<div id="demodate" class="col-sm-4 p-1">
					<label class="control-label">'.$l['date'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['demo_date'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
					<div class="input-group ">
						<input type="text" class="form-control" placeholder="DD/MM/YYYY" name="demo_date" id="date1" size="30" value="'.POSTval('demo_date',(!empty($tmp_demo_time)) ? datify($tmp_demo_time, 0, 0, 'd/m/Y')  : '' ).'"  />
						<div class="input-group-append">
							<span class="input-group-text">	<a class="text-white" onclick="$_(\'date1\').value=\''.datify(time(), 0, 1, 'd/m/Y').'\'" /><i class="fas fa-calendar-week"></i></a></span>
						</div>
					</div>	
				</div>
			</div>
			<div class="row mx-auto w-100 my-3" id="demo_action_options">
				<div class="col-sm-4">
					<label class="control-label">'.$l['demo_action'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['demo_action_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
				</div>
				<div class="col-sm-8 p-1">
					<label class="custom-control custom-radio">
						<input type="radio" class="custom-control-input" name="demo_action" value="0" id="demo_delete_action" '.(POSTval('demo_action', $tmp_demo_action) == 0 ? 'checked="checked"' : '').'>
						<span class="custom-control-label" for="demo_delete_action">'.$l['demo_delete_action'].'</span>
					</label>
					<label class="custom-control custom-radio">
						<input type="radio" class="custom-control-input" name="demo_action" value="1" id="demo_suspend_action" '.(POSTval('demo_action', $tmp_demo_action) == 1 ? 'checked="checked"' : '').'>
						<span class="custom-control-label" for="demo_suspend_action">'.$l['demo_suspend_action'].'</span>
					</label>
				</div>
			</div>';

			
			if($kernel->features('ha', $vps['_virt']) && array_key_exists($globals['server'], $ha_enabled)){
				echo '<div class="row mx-auto w-100 my-3 hide_for_plan">
						<div class="col-6">
							<label class="control-label">'.$l['ha'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ha_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-6">
							'.get_checkbox('ha', '', 'ha', array('chk_it' => 1, 'val' => $vps['ha']), 1, '', array('disable="disable"')).'
						</div>
				</div>';
			}
			
		echo '
		</div><br>
		
	</div>
</div><br />
<center><input id="editvps" type="submit" name="editvps" value="'.$l['submit'].'" class="go_btn"/></center>

<!-- <div class="notice"><b>'.$l['note'].' : </b> &nbsp; <a href="'.$globals['ind'].'act=oldeditvs&vpsid='.$vps['vpsid'].'" >'.$l['old_editvs_note'].'</a></div> -->

<br /><br />
</form>
</div>
</div>';

}// End of Server Offline if
softfooter();
echo '
<div id="processing_symb"><div class="loader-lg"></div></div>
';
}

?>