<?php

//////////////////////////////////////////////////////////////
//===========================================================
// addpassthrough_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.7
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Sumeet Boga
// Date:       1th jan 2022
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function addpassthrough_theme(){

global $theme, $globals, $l, $error, $cluster, $servers, $done, $passthroughs, $passthrough_types, $gpu_roms;
		
	softheader($l['<title>']);

	echo '

	<div class="bg">
	<div class="row my-3 mx-auto">
		<div class="col-12">
			<h4 class="text-dark"><i class="fab fa-usb"></i> '.$l['add_passthrough'].'</h4>
		</div>
	</div>';

	error_handle($error);

	// Is it offline ?
	$hypervisor_status = $cluster->statewise($globals['server']);
	if($hypervisor_status == 0 || $hypervisor_status == 2){
		show_alert($l['server_status_'.$hypervisor_status], "1");
	}

	error_handle($error);

	if(!empty($done)){
		show_alert($l['done'], '0', 'addpassthrough');
	}else{		
		if(empty($cluster->pci_manager($globals['server'], array(), 'iommu_support'))){
			$warning_note[] = $l['no_iommu_support'];
		}

		// we do not require this for now to show to users 	
		$cpu = $cluster->cpu($globals['server']);
		if(empty($cluster->pci_manager($globals['server'], $cpu, 'interrupt_remapping'))){
			$warning_note[] = $l['no_interrupt_remapping'];
		}


		echo 
		"	<script>

				var show_passthrough_type = ".((preg_match('/pci/is', $_POST['passthrough_type']) || empty($_POST['passthrough_type'])) ? "'pci'" : "'usb'").";


				function checkxml(){
					if(is_checked('xml_check')){
						$('#pci_key').trigger('click');
						$('#xml_info').show();
					}else{
						$('#xml_info').hide();
					}
				};

				function checkgpu(){
					if(is_checked('isgpu')){
						$('#row_gpufile').show();
					}else{
						$('#row_gpufile').hide();
					}
				};

				$(document).ready(function(){		
					
					if(show_passthrough_type == 'pci'){
						$('#pci_support').show();
						$('#div_pci').show();
						$('#div_usb').hide();
						if(!is_checked('xml_check')){
							$('#xml_info').hide();
						}
					}else{
						$('#pci_support').hide();
						$('#div_pci').hide();
						$('#div_usb').show();
					}

					$('#passthrough_type').on('change', function(){
						var selected_type = $(this).val();
						console.log(selected_type);
						if(selected_type == 'usb'){
							$('#pci_support').hide();
							$('#div_pci').hide();
							$('#div_usb').show();
						}else{
							$('#pci_support').show();
							$('#div_pci').show();
							$('#div_usb').hide();
						}					
					});

					var pci_dumpxmls = ".(empty($passthroughs['pcis']['dumpxml']) ? '' :json_encode($passthroughs['pcis']['dumpxml'])).";
					$('#pci_key').on('click | change', function(){
						var pci_key = $(this).val();
						if(is_checked('xml_check')){
							$('#pci_dumpxml').text('');
							$.each(pci_dumpxmls, function(k, v){
								if(k == pci_key){
									var text = $('#pci_dumpxml').val();
									(text == '') ? (document.getElementById('pci_dumpxml').innerHTML = v) : (document.getElementById('pci_dumpxml').innerHTML = text + \" \\n \" +v);								
								}
							});				
						}
					});
				});
			</script>"
		;
		
		if(count($warning_note) > 1){
			echo "<div id='pci_support' class='alert alert-warning' role='alert'><ul>";
			foreach($warning_note as $k=>$v)
				echo "<li>$v</li>";
			echo "</ul></div>";
		}elseif(count($warning_note) == 1){
			echo "<div id='pci_support' class='alert alert-warning' role='alert'>{$warning_note[0]}</div>";
		}

		echo '		 
		<form id="addpassthroughform" accept-charset="'.$globals['charset'].'" action="" method="post" name="addpassthrough" class="form-horizontal">
			<div id="form-container">
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<label class="control-label">'.$l['passthrough_type'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['passthrough_type_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6">
						<div class="input-group">
							<select name="passthrough_type" id="passthrough_type" class="form-control virt-select">';
								foreach($passthrough_types as $k => $v)

									echo '<option value="'.$k.'" '.POSTselect('passthrough_type', $k).'>'.$v.'</option>';
							
							echo '</select>
						</div>
					</div>
				</div>
				<div id="div_pci" style="display:none;">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-4">
							<label class="control-label">'.$l['pci_devices'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['pci_devices_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<div class="input-group">
								<select name="pci_key" id="pci_key" class="form-control virt-select">
									<option value="-1" '.POSTselect('pci_key', 'none').'>None</option>';	
										
									foreach($passthroughs['pcis']['node_pcis'] as $k => $v)
										echo '<option value="'.$k.'" '.POSTselect('pci_key', $k).'>'.substr(strstr($v,' '), 1).'</option>';
								
								echo '</select>
							</div>
						</div>
					</div>
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-4">
							<label class="control-label">'.$l['pci_dumpxml'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['pci_dumpxml_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-4">
							'.get_checkbox('show_xml', '', 'xml_check', array('chk_it' => 1, 'name' => 'xml'), 1, '', array('onchange="checkxml();"')).'
						</div>
					</div>		

					<div id="xml_info" class="row mx-auto w-100 my-3">
						<div class="col-sm-4">
						</div>
						<div class="input-group col-sm-6">
							<textarea class="form-control font-monospace" id="pci_dumpxml" rows="15" spellcheck="false" value="'.POSTval('pci_dumpxml', '').'"></textarea>
						</div>
					</div>	

					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-4">
							<label class="control-label">'.$l['pci_isgpu'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_pci_isgpu'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-4">
							'.get_checkbox('isgpu', '', 'isgpu', array('chk_it' => 1, 'name' => 'isgpu'), 1, '', array('onchange="checkgpu();"')).'
						</div>
					</div>

					<div class="row mx-auto w-100 my-3 row_gpufile" id="row_gpufile" style="display:none;">
						<div class="col-sm-4">
							<label class="control-label">'.$l['gpu_rom_file'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_gpu_rom_file'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<select class="form-control virt-select" name="gpu_rom_file" id="gpu_rom_file" style="width:100%;">
								<option value="0" '.POSTselect('gpu_rom_file', 'none').'>None</option>';	
								foreach($gpu_roms as $gpu_rom => $v){
									echo '<option value="'.$v.'" >'.$v.'</option>';
								}
						echo'<select>
						</div>
					</div>
									
				</div>
				<div id="div_usb" style="display:none;">
					<div class="row mx-auto w-100 my-3">
						<div class="col-sm-4">
							<label class="control-label">'.$l['usb_devices'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['usb_devices_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
						</div>
						<div class="col-sm-6">
							<div class="input-group">
								<select name="usb_key" class="form-control virt-select">
									<option value="0" '.POSTselect('usb_key', 'none').'>None</option>';	
										
									foreach($passthroughs['usbs']['node_usbs'] as $k => $v)
										echo '<option value="'.$k.'" '.POSTselect('usb_key', $k).'>'.$v.'</option>';
								
								echo '</select>
							</div>
						</div>
					</div>
				</div>	
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<label class="control-label">'.$l['passthrough_customname'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['passthrough_customname_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6">
						<div class="input-group ">
							<input type="text" class="form-control" name="name" id="name" size="30" value="'.POSTval('name', '').'" />
						</div>
					</div>
				</div>
				<div class="row mx-auto w-100 my-3">
					<div class="col-sm-4">
						<label class="control-label">'.$l['passthrough_desc'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['passthrough_desc_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
					</div>
					<div class="col-sm-6">
						<div class="input-group ">
							<textarea class="form-control" name="description" id="description" rows="5" value="'.POSTval('description', '').'"></textarea>
						</div>
					</div>
				</div>
				
				<br><br>
				<center><input type="submit" id="addpassthrough" name="addpassthrough" value="'.$l['sub_but'].'" class="go_btn"></center>
			</div>
		</form>';
	}
	softfooter();

}

?>