<?php

//////////////////////////////////////////////////////////////
//===========================================================
// addippool_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function addippool_theme(){

global $theme, $globals, $kernel, $user, $l, $cluster, $error, $servers, $done, $ips, $virt, $servergroups, $users, $pdns_servers;

softheader($l['<title>']);

echo '
<div class="bg">
<div class="row my-3 mx-auto">
	<div class="col-10 d-flex align-items-center">
		<h4 class="text-dark"><i class="icon icon-ippool"></i> '.$l['addippool'].'</h4>
	</div>
	<div class="col-2 text-right d-flex align-items-center justify-content-end">
		<span class="icon-fix d-flex align-items-center justify-content-center"><a href="'.$globals['docs'].'add-ip-pool/" target="_blank" tooltip="'.$l['wiki_help'].'"><i class="fas fa-question text-always-white" ></i></a></span>
	</div>
</div>'.get_breadcrumb([
	['act' => 'ippool'],
	['act' => 'addippool']
]);

error_handle($error);

if(!empty($done)){
	show_alert($l['done'],"0","ippool");

	if(!empty($done['ipv6_subnet'])){
		show_alert(lang_vars_name($l['done_ipv6_subnet'], array('ippid' => $done['ipv6_subnet'])),"0","ippool");
	}
	
}else{

echo '<script language="javascript" type="text/javascript">

$(document).ready(function(){
	$("#uid").on("change", function(){		
		var temp = new Array("routing", "internal", "nat", "vlan");
		$("#internal").prop("disabled", false);
		$.each(temp, function(k , v){
			if($("#"+v).prop("checked") == true){
				changeipsettings(v);
			}
		})
		handle_user()
	});
})

function handle_user(){
	if($("#uid").val() > 0){
		if($("#internal").prop("checked") == true){
			$("#internal").trigger("click");
		}else{
			$("#internal").prop("checked", false);
		}
		$("#internal").prop("disabled", true);
		$("#internal_bridge_tr").hide();
	}
}

function addrow(id){
	var t = $_(id);

	var row = document.createElement("div");
	row.className = "row mx-auto w-100 my-3";
	var col1 = document.createElement("div");
	col1.className = "col-5 ip-mac p-0 d-flex align-items-center";
	var col2 = document.createElement("div");
	col2.className = "col-6 ip-mac p-0 d-flex align-items-center";

	col1.innerHTML = \'<label class="p-0">'.$l['ip'].' :&nbsp;&nbsp;</label><input type="text" class="form-control w-75 m-0" name="ips[]"/>\';
	col2.innerHTML = \'<label class="p-0">'.$l['mac_addr'].' :&nbsp;&nbsp;</label><input type="text" class="form-control w-75 m-0" name="macs[]"/><a class="delip pl-1" ><i class="fas fa-times text-danger cursor-pointer py-2"></i></a>\';
	
	row.appendChild(col1);
	row.appendChild(col2);
	t.appendChild(row);
	$(".delip").each(function(){
		$(this).unbind("click");
		$(this).click(function(){
			var parent = $(this).parent();
			var parent2 = $(this).parent().parent();
			parent.remove();
			parent2.remove();
		});
	});
};

function ipv6_subnet_gen(){
	if(is_checked("ipv6_subnet")){
		$("#ipv6_range").hide();
		$("#ipv6_num").hide();
	}else{
		$("#ipv6_range").show();
		$("#ipv6_num").show();
	}
}
	
function changetype(iptype){
	$_("ipv4").className = "nav-link";
	$_("ipv6").className = "nav-link";
	var namesever = "";
	if (iptype == 4){
		$(".ipv4").show();
		$(".ipv6").hide();
		$("#ns1").attr("tooltip", "'.$l['unsure_1'].'");
		$("#ns2").attr("tooltip", "'.$l['unsure_2'].'");
		$_("ns_1").value="";
		$_("ns_2").value="";
		$_("gateway").value="";
		if($("#internal").attr("checked")){
			$_("internal_bridge_tr").style.display="";
		}
		if($("#vlan").attr("checked")){
			$_("vlan_bridge_tr").style.display="";
		}
		$_("netmask").style.width="100%";
		$("#4_space").addClass("help-block");
		handle_user()
	}else{

		$(".ipv4").hide();
		$(".ipv6").show();
		$("#ns1").attr("tooltip", "'.$l['unsure_1_6'].'");
		$("#ns2").attr("tooltip", "'.$l['unsure_2_6'].'");
		$_("ns_1").value="";
		$_("ns_2").value="";
		$_("gateway").value="";
		if($("#vlan").attr("checked")){
			$_("vlan_bridge_tr").style.display="";
		}
		$_("netmask").style.width="90%";
		ipv6_subnet_gen();
		$("#4_space").removeClass("help-block");
	}	
	
	$_("ipv"+iptype).className = "active nav-link";
	$_("iptype").value = iptype;
	show_tooltip();
	
};

function changeDNS(ips){
	ip = ips.split(\',\');
	$("input[type=text][name=ns1]").val(ip[0]);
	$("input[type=text][name=ns2]").val(ip[1]);
}

function handletr(){
	
	var serid = $("#serid").val();
	if(serid == "-1"){
		$("#nat_tr").hide();
		$("#routing_tr").hide();
	}else{
		if($_("iptype").value == 4){
			$("#nat_tr").show();
		}
		$("#routing_tr").show();
	}
};

function changeipsettings(id){
	
	var temp = new Array("routing", "internal", "nat", "vlan");
				
	if(is_checked(id)){
		$("#"+id).removeAttr("disabled");
		
		if(id == "internal"){
			$("#internal_bridge_tr").show();
		}
		
		if(id == "vlan"){
			$("#vlan_bridge_tr").show();
		}
		
		for(x in temp){
			if(temp[x] != id){
				$("#"+temp[x]).attr("disabled", "disabled");
				if(temp[x] == "internal"){
					$("#internal_bridge_tr").hide();
				}
				if(temp[x] == "vlan"){
					$("#vlan_bridge_tr").hide();
				}
			}
		}
		
	}else{
		
		for(x in temp){
			$("#"+temp[x]).removeAttr("disabled");
			if(temp[x] == "internal"){
				$("#internal_bridge_tr").hide();
			}
			if(temp[x] == "vlan"){
				$("#vlan_bridge_tr").hide();
			}
		}
		
	}
	handle_user()
		
};

addonload("changetype('.POSTval('iptype', 4).');handletr();");
</script>
<div class="card p-5 m-3">
<div id="form-container">
<form accept-charset="'.$globals['charset'].'" name="addippool" method="post" action="" class="form-horizontal">

<input type="hidden" id="iptype" name="iptype" value="'.POSTval('iptype', 4).'">

<ul class="nav nav-tabs">
	<li class="col-4"><label class="control-label mx-auto my-3">'.$l['iptype'].'</label></li>
	<li class="col-4 nav-item text-center"><a href="javascript:changetype(4);" class="nav-link active" id="ipv4"><h4>IPv4</h4></a></li>
	<li class="col-4 nav-item text-center"><a href="javascript:changetype(6);" class="nav-link" id="ipv6"><h4>IPv6</h4></a></li>
</ul>
<div class="row mx-auto w-100 my-3">
	<div class="col-sm-4">
		<label class="control-label">'.$l['pool_server'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_server'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4">';
	
		$POSTserid = @$_POST['serid'];
		$POSTserid = empty($POSTserid) ? array() : $POSTserid;
		
		echo '<select class="form-control" name="serid[]" id="serid" size="8" onchange="handletr();" multiple="multiple">
			<option value="-1" '.(in_array(-1, $POSTserid) ? 'selected="selected"' : '').'>'.$l['all_servers'].'</option>';
			
			foreach ($servergroups as $k => $v){
				echo '<option class="fhead" value="'.$k.'_group" '.(in_array($k.'_group', $POSTserid) ? 'selected="selected"' : '').'>[Group]&nbsp;'.$v['sg_name'].'</option>';
				
				foreach ($servers as $m => $n){
					if($n['sgid'] == $k){
						echo '<option value="'.$n['serid'].'" '.(in_array((string)$n['serid'], $POSTserid) ? 'selected="selected"' : '').'>&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;'.$n['server_name'].'</option>';
					}
				}
			}
	echo '</select>
		</div>
</div>
<span class="help-block"></span>
<div class="row mx-auto w-100 my-3">
	<div class="col-sm-4">
		<label class="control-label">'.$l['ippool_name'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['nameofip'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4"><input type="text" class="form-control" name="ippool_name" id="ippool_name" size="30" value="'.POSTval('ippool_name', '').'" /></div>
	<div class="col-sm-4"></div>
</div>

<div class="row mx-auto w-100 my-3">
	<div class="col-sm-4"><label class="control-label">'.$l['gateway'].'</label></div>
	<div class="col-sm-4"><input type="text" class="form-control" id="gateway" name="gateway" value="'.POSTval('gateway', '').'" size="30"></div>
	<div class="col-sm-4"></div>
</div>
<span class="help-block"></span>
<div class="row mx-auto w-100 my-3">
	<div class="col-sm-4">
		<label class="control-label">'.$l['netmask'].'</label>
		<span class="ipv6" id="netmask_6">
			<label class="control-label">'.$l['routing_prefix'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['netmask_6'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
		</span>
	</div>
	<div class="col-sm-4"><label id="6_slash" class="float-left pr-3 pt-1 ipv6">/</label><input id="netmask" type="text" class="form-control" name="netmask" value="'.POSTval('netmask', '').'" size="30">
	</div>
</div>
<span id="4_space"></span>
<div class="row mx-auto w-100 my-3">
	<div class="col-sm-4">
		<label class="control-label">'.$l['nameserver'].' 1&nbsp;<a class="info" data-placement="right"   id="ns1"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4">
		<input type="text" class="form-control" id = "ns_1" name="ns1" value="'.POSTval('ns1', '').'" size="30">
	</div>
	<div class="col-sm-4">
		<span class="ipv4" id="ipv4_ns"><a href="javascript:changeDNS(\'8.8.8.8,8.8.4.4\');">[Google]</a>&nbsp;<a href="javascript:changeDNS(\'208.67.222.222,208.67.220.220\');">[Open DNS]</a>&nbsp;<a href="javascript:changeDNS(\'8.26.56.26,8.20.247.20\');">[Comodo]</a>&nbsp;<a href="javascript:changeDNS(\'208.76.50.50,208.76.51.51\');">[Smart Viper]</a></span>
		<span class="ipv6" id="ipv6_ns"><a href="javascript:changeDNS(\'2001:4860:4860::8888,2001:4860:4860::8844\');">[Google]</a></span>
	</div>
</div>

<div class="row mx-auto w-100 my-3">
	<div class="col-sm-4">
		<label class="control-label">'.$l['nameserver'].' 2&nbsp;<a class="info" data-placement="right" id="ns2"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4">
		<input type="text" class="form-control" id = "ns_2" name="ns2" value="'.POSTval('ns2', '').'" size="30">
	</div>
</div>

<div class="row mx-auto w-100 my-3 ipv4" id="firstip">
	<div class="col-sm-4">
		<label class="control-label">'.$l['first_IP'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['optional_firstip'].'"><i class="fas text-primary fa-info-circle"></i></a></label> 
	</div>
	<div class="col-sm-4"><input type="text" class="form-control" name="firstip" value="'.POSTval('firstip', '').'" size="30"></div>
</div>

<div class="row mx-auto w-100 my-3 ipv4" id="lastip">
	<div class="col-sm-4">
		<label class="control-label">'.$l['last_IP'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['optional_lastip'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4"><input type="text" class="form-control" name="lastip" value="'.POSTval('lastip', '').'" size="30"></div>
</div>';
if(!empty($users)){
	echo'
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-4">
			<label class="control-label">'.$l['select_user'].' &nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_user_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
		</div>
		<div class="col-sm-4">
			<select name="uid" class="virt-select" id="uid">
			<option value="0">--</option>';
			foreach($users as $uk => $uv){
				echo '<option value="'.$uk.'" '.POSTselect('uid', $uk).'>'.$uv['email'].'</option>';
			}
			echo'
			</select>
		</div>
	</div>';
}
if(!empty($pdns_servers)){
	echo'
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-4">
			<label class="control-label">'.$l['select_pdns_server'].' &nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_pdns_server_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
		</div>
		<div class="col-sm-4">
			<select name="pdns_id" class="virt-select" id="pdns_id">
			<option value="0">--</option>';
			foreach($pdns_servers as $pk => $pv){
				echo '<option value="'.$pk.'" '.POSTselect('pdns_id', $pk).'>'.$pv['name'].'</option>';
			}
			echo'
			</select>
		</div>
	</div>';
}
echo'
<div class="row mx-auto w-100 my-3 ipv4" id="internal_tr">
	<div class="col-4">
		<label class="control-label">'.$l['internal'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['internal_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-4">
		'.get_checkbox('internal', '', 'internal', array('chk_it' => 1), 1, '', array('onchange="changeipsettings(this.id);"')).'
	</div>
</div>

<div class="row mx-auto w-100 my-3" id="internal_bridge_tr" style="display:none;">
	<div class="col-sm-4">
		<label class="control-label">'.$l['internal_bridge'].'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer($l['internal_bridge_exp']).'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
		<a target="_blank" href="'.$globals['docs'].'Internal_Network">'.$l['refer_this'].'</a>
	</div>
	<div class="col-sm-4">
		<input type="text" class="form-control" name="internal_bridge" value="'.POSTval('internal_bridge', '').'" size="30">
	</div>
</div>

<div class="row mx-auto w-100 my-3" id="vlan_tr">
	<div class="col-4">
		<label class="control-label">'.$l['vlan'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['vlan_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label><br>
		<a href="'.$globals['docs'].'VLAN" target="_blank">'.$l['refer_this'].'</a>
	</div>
	<div class="col-4">
		'.get_checkbox('vlan', '', 'vlan', array('chk_it' => 1), 1, '', array('onchange="changeipsettings(this.id);"')).'
	</div>
</div>

<div class="row mx-auto w-100 my-3" id="vlan_bridge_tr" style="display:none;">
	<div class="col-sm-4">
		<label class="control-label">'.$l['vlan_bridge'].'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer($l['vlan_bridge_exp']).'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4">
		<input type="text" class="form-control" name="vlan_bridge" value="'.POSTval('vlan_bridge', '').'" size="30">
	</div>
</div>

<div class="row mx-auto w-100 my-3 ipv4">
	<div class="col-sm-4">
		<label class="control-label">'.$l['vlan_tag'].'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer($l['vlan_tag_exp']).'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4">
		<input type="text" class="form-control" name="vlan_tag" value="'.POSTval('vlan_tag', '').'" size="30">
	</div>
</div>

<div class="row mx-auto w-100 my-3 ipv4" id="nat_tr" style="display:none;">
	<div class="col-4">
		<label class="control-label">'.$l['subnet'].'&nbsp;<a class="info" data-placement="right" tooltip="'.htmlizer($l['exp_subnet']).'"><i class="fas text-primary fa-info-circle"></i></a></label><br><a target="_blank" href="'.$globals['docs'].'nat/">'.$l['refer_this'].'</a>
	</div>
	<div class="col-4">
		'.get_checkbox('nat', '', 'nat', array('chk_it' => 1), 1, '', array('onchange="changeipsettings(this.id);"')).'
	</div>
</div>

<div class="row mx-auto w-100 mt-3" id="routing_tr" style="display:none;">
	<div class="col-4">
		<label class="control-label">'.$l['add_route'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_add_route'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-4">
		'.get_checkbox('routing', '', 'routing', array('chk_it' => 1), 1, '', array('onchange="changeipsettings(this.id);"')).'
	</div>
</div>

<div class="row mx-auto w-100 my-1 ipv4" id="or"><div class="col-sm-12 h3 m-0" align="center">'.$l['or'].'</div></div>

<div class="row mx-auto w-100 mb-3 ipv4" id="ips">
	<div class="col-sm-4">
		<label class="control-label">Enter IP&nbsp;<a class="info" data-placement="right" tooltip="Enter IP and its associated MAC address<br>'.$l['entermac_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-8">
		<div id="iptable">';
			
			if(is_array($ips) && !empty($ips)){
				foreach($ips as $k => $ip){
					if(empty($ip['ip'])){
						unset($ip['ip']);
					}
					if(empty($ip['mac_addr'])){
						unset($ip['mac_addr']);
					}
				}
			}
			
			if(empty($ips)){
				$ips = array(NULL);
			}
		 
		 	foreach($ips as $ip){
				echo '
				<div class="row mx-auto w-100 my-3">
					<div class="col-5 ip-mac p-0 ip-mac d-flex align-items-center">
						<label class="p-0">'.$l['ip'].' :&nbsp;&nbsp;</label><input type="text" class="form-control w-75 m-0" name="ips[]" value="'.$ip['ip'].'"/>
					</div>
					<div class="col-6 ip-mac p-0 ip-mac d-flex align-items-center">
						<label class="p-0">'.$l['mac_addr'].' :&nbsp;&nbsp;</label><input type="text" class="form-control w-75 m-0" name="macs[]" value="'.$ip['mac_addr'].'"/>
					</div>
				</div>';
			}
  echo '</div>
  <a onclick="addrow(\'iptable\');" class="go_btn blue_btn px-2 py-1">'.$l['add_more_ips'].'</a>
	</div>
</div>

<div class="row mx-auto w-100 my-3 ipv6" id="ipv6_subnet_row">
	<div class="col-4">
		<label class="control-label">'.$l['ipv6_subnet'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ipv6_subnet_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-4">
		'.get_checkbox('ipv6_subnet', '', 'ipv6_subnet', array('chk_it' => 1), 1, 'select_all', array('onchange="ipv6_subnet_gen();"')).'
	</div>	
</div>

<div class="row mx-auto w-100 my-3 ipv6" id="ipv6_range">
	<div class="col-sm-4">
		<label class="control-label">'.$l['ipv6_range'].'</label>
	</div>
	<div class="col-sm-8">
		<div class="ipv6-range">
			<div> <input type="text" class="form-control" name="ipv6_1" value="'.POSTval('ipv6_1', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_2" value="'.POSTval('ipv6_2', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_3" value="'.POSTval('ipv6_3', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_4" value="'.POSTval('ipv6_4', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_5" value="'.POSTval('ipv6_5', '').'" size="4" maxlength="4"><label> : </label></div>
			<div> <input type="text" class="form-control" name="ipv6_6" value="'.POSTval('ipv6_6', '').'" size="4" maxlength="4"></div>
			<div><label> : auto : auto </label></div>
		</div>
	</div>
	
</div>
<span class="help-block"></span>
<div class="row mx-auto w-100 my-3 ipv6" id="ipv6_num">
	<div class="col-sm-4">
		<label class="control-label">'.$l['ipv6_num'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['ipv6_num_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4">
		<input type="text" class="form-control" name="ipv6_num" value="'.POSTval('ipv6_num', 50).'" size="10">
	</div>	
</div>
<div class="row mx-auto w-100 my-3" id="mtu">
	<div class="col-sm-4">
		<label class="control-label">'.$l['mtu'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['exp_mtu'].'"><i class="fas text-primary fa-info-circle"></i></a></label>
	</div>
	<div class="col-sm-4">
		<input type="number" class="form-control" name="mtu" value="'.POSTval('mtu').'" size="10">
	</div>	
	<div class="col-sm-4 col-sm-4 d-flex align-items-center">Bytes</div>
</div>
</div>
<br>
<center><input type="submit" value="'.$l['sub_but'].'" class="go_btn" name="addippool"></center>
<br><br>
</form>
</div>';

}

echo '</div>
</div>';
softfooter();

}

?>