<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
class xen
{
    public $loaded = 0;
    public $status = [];
    public $status_statewise = [];
    public $forcestatus = [];
    public $type = "xen";
    public $bandwidth_device = "eth0";
    public $user = [];
    public function __construct()
    {
        if(!empty($GLOBALS["globals"]["interface"])) {
            $this->bandwidth_device = $GLOBALS["globals"]["interface"];
        }
        if(!empty($GLOBALS["globals"]["use_xl"])) {
            define("VXM", "xl");
        } else {
            define("VXM", "xm");
        }
    }
    public function conf($vpsid, $conf_name, $virt = "")
    {
        if(in_array($conf_name, ["onboot_changepass", "onboot_hostname", "onboot_cp", "cpu_pinning", "vnc_support", "vnc_key_map"])) {
            return true;
        }
        if(in_array($conf_name, ["disks_support", "rescue_support", "format_primary", "use_dd_migrate"])) {
            return true;
        }
        if(in_array($conf_name, ["build_dhcp", "mac_support", "change_dns", "ebtables_support", "nw_config"])) {
            return true;
        }
        if(in_array($conf_name, ["iso_support", "multiple_disk_support", "win_support", "hvm_support", "perf_ops"]) && preg_match("/hvm/", $virt)) {
            return true;
        }
        if($conf_name == "vncpasslen") {
            return 8;
        }
        if($conf_name == "nic") {
            $nictypes["default"] = 1;
            $nictypes["e1000"] = 1;
            $nictypes["ne2k_pci"] = 1;
            return array_keys($nictypes);
        }
        if($conf_name == "storage_types") {
            return ["block", "file", "thin block", "zfs block", "zfs thin block", "zfs block compressed", "zfs thin block compressed"];
        }
        if($conf_name == "possible_mig_virts" && preg_match("/hvm/", $virt)) {
            return ["kvm"];
        }
        return false;
    }
    public function dom0mem($mb = 768)
    {
        vexec(VXM . " sched-credit -d 0 -w 9999", $output, $ret);
        if(empty($mb) || $mb < 512) {
            $mb = 768;
        }
        vexec(VXM . " mem-set Domain-0 " . xss($mb), $output, $ret);
        return $ret;
    }
    public function new_vps_name($suggested_name = "")
    {
        vexec(VXM . " list", $output, $return);
        $ret = empty($suggested_name) ? 1001 : str_replace("v", "", $suggested_name);
        $names = [];
        foreach ($output as $k => $v) {
            $v = preg_split("/[\\s]+/", trim($v));
            $v[0] = trim($v[0]);
            $names[$v[0]] = $v[0];
        }
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\tAND virt = 'xen'\n\t\t\t\t\t\tORDER BY vps_name DESC");
        if(0 < vsql_num_rows($res)) {
            for ($x = 0; $x < vsql_num_rows($res); $x++) {
                $row = vsql_fetch_assoc($res);
                $row["vps_name"] = trim($row["vps_name"]);
                $names[$row["vps_name"]] = $row["vps_name"];
                $tmp_int = (int) $row["vps_name"];
                if($ret < $tmp_int && $tmp_int < 2000) {
                    $ret = $tmp_int + 1;
                }
            }
        }
        $x = 0;
        while ($x < 100000) {
            if(in_array("v" . $ret, $names) || in_array($ret, $names)) {
                $ret = $ret + 1;
                $x++;
                break;
            }
        }
        return "v" . $ret;
    }
    public function get_raw_conf($vpsid)
    {
        $vps_name = $this->getname($vpsid);
        return file_get_contents("/etc/xen/auto/" . $vps_name . ".cfg");
    }
    public function getconf($vid)
    {
        $vps_name = $this->getname($vid);
        if(empty($this->conf[$vid])) {
            $r = [];
            $tmp = file("/etc/xen/auto/" . $vps_name . ".cfg");
            foreach ($tmp as $k => $l) {
                $tmp[$k] = trim(preg_replace("/(\\#(.*))/is", "", trim($l)));
                if(empty($tmp[$k])) {
                } elseif(preg_match("/=/is", $tmp[$k])) {
                    $t = explode("=", $tmp[$k]);
                    $r[trim($t[0])] = trim($t[1]);
                }
            }
            foreach ($r as $k => $v) {
                $r[$k] = trim($v, "\"");
            }
            $this->conf[$vid] = $r;
        }
        return $r;
    }
    public function getname($vid)
    {
        global $user;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            return $user["vps"]["vps_name"];
        }
        if($vps = getvps($vid)) {
            return $vps["vps_name"];
        }
        return false;
    }
    public function stop($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("stop_vps", "", 0, $vid, $vps["uid"], 0, $l["stop_vps"]);
        task_start($actid);
        task_update($actid, $l["stop_vps"], 57);
        $vps_name = $this->getname($vid);
        oexec(VXM . " shutdown " . xss($vps_name), $output);
        writefile(logdir("stop") . $vid . ".log", $output, 1);
        task_update($actid, $l["stop_vps_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function start($vid, &$sret = "")
    {
        global $user;
        global $l;
        $vps = getvps($vid);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        if($this->status($vid, 1) == 1) {
            return false;
        }
        $actid = vps_task("start_vps", "", 0, $vid, $vps["uid"], 0, $l["attempting_start_vps"]);
        task_start($actid);
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0\n\t\t\t\t\t\tORDER BY actid ASC", [":vid" => $vid]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $tasks[$row["actid"]] = $row;
            }
        }
        task_update($actid, $l["beginning_start_vps"], 5);
        $this->onstartup($vid);
        if(!empty($tasks)) {
            foreach ($tasks as $k => $v) {
                if($v["action"] == "changepassword") {
                    _task_update($actid, $l["change_password"], 22, $v["actid"]);
                    $this->changepassword($vid, base64_decode($v["data"]), $v["actid"]);
                    logs_vps("changepassword", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "remotedesktop") {
                    _task_update($actid, $l["remotedesktop"], 24, $v["actid"]);
                    $this->remotedesktop($vid, $v["data"], $v["actid"]);
                    logs_vps("remotedesktop", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "hostname") {
                    _task_update($actid, $l["change_hostname"], 27, $v["actid"]);
                    $this->changehostname($vid, $v["data"], $v["actid"]);
                    logs_vps("hostname", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_cp") {
                    _task_update($actid, $l["install_cp"], 29, $v["actid"]);
                    $this->install_cp($vid, $v["data"], $v["actid"]);
                    logs_vps("install_cp", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "change_dnsnameserver") {
                    _task_update($actid, $l["change_dnsnameserver"], 31, $v["actid"]);
                    $this->change_dnsnameserver($v["data"], $v["actid"]);
                    logs_vps("change_dnsnameserver", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "resizevps") {
                    _task_update($actid, $l["resize_vps"], 33, $v["actid"]);
                    $this->resizevps($vid, $v["actid"]);
                    logs_vps("resizevps", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "delete_vpsdisks") {
                    _task_update($actid, $l["delete_vpsdisks"], 35, $v["actid"]);
                    $del_data = _unserialize($v["data"]);
                    $this->delete_vpsdisks($vid, $del_data, $v["actid"]);
                    logs_vps("delete_vpsdisks", $del_data, 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_recipe") {
                    _task_update($actid, $l["install_recipe"], 37, $v["actid"]);
                    $recipe = _unserialize($v["data"]);
                    $this->install_recipe($vid, $recipe, $v["actid"]);
                    logs_vps("install_recipe", !array_key_exists("rid", $recipe) ? implode(", ", array_keys($recipe)) : $recipe["rid"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "change_winips") {
                    $this->change_winips($vid, [], $v["actid"]);
                    logs_vps("change_winips", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "addsshkeys") {
                    _task_update($actid, $l["add_sshkeys"], 40, $v["actid"]);
                    $ssh_keys = _unserialize($v["data"]);
                    $this->addsshkeys($vid, $ssh_keys, $v["actid"]);
                    logs_vps("addsshkeys", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "removesshkeys") {
                    _task_update($actid, $l["remove_sshkeys"], 41, $v["actid"]);
                    $ssh_keys = _unserialize($v["data"]);
                    $this->removesshkeys($vid, $ssh_keys, $v["actid"]);
                    logs_vps("removesshkeys", $v["data"], 1, $vid, $user["uid"]);
                }
            }
        }
        task_update($actid, $l["call_hook_before_startvps"], 50);
        apply_filters("before_startvps", $vps);
        $vps_name = $this->getname($vid);
        oexec(VXM . " create /etc/xen/auto/" . xss($vps_name) . ".cfg 2>&1", $output, $sret);
        writefile(logdir("start") . $vid . ".log", $output, 1);
        sleep(1);
        _task_update($actid, $l["tc_rule_create"], 72, "group");
        $this->tc_create($vid);
        _task_update($actid, $l["tc_rule_create"], 72, "group_end");
        if(!empty($vps["nw_suspended"])) {
            $this->suspend_vps_net($vps["vpsid"]);
        }
        $this->ebtables_remove($vid);
        $vif_name = $this->vifname($vid);
        $mac_addr = $this->getmac($vid);
        vs_ebtables_add($vid, $vif_name, $mac_addr);
        task_update($actid, $l["call_hook_after_startvps"], 88);
        apply_filters("after_startvps", $vps);
        task_update($actid, $l["start_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function restart($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("restart_vps", "", 0, $vid, $vps["uid"], 0, $l["restart_vps"]);
        task_start($actid);
        task_update($actid, $l["restart_vps"], 57);
        $vps = getvps($vid);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        if($this->status($vid) == 0) {
            task_update($actid, $l["restart_vps_done"], 100);
            return $this->start($vid);
        }
        $vps_name = $this->getname($vid);
        oexec(VXM . " reboot " . xss($vps_name), $output);
        if(!empty($vps["nw_suspended"])) {
            $this->suspend_vps_net($vps["vpsid"]);
        }
        task_update($actid, $l["restart_vps_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function onstartup($vid)
    {
        global $globals;
        global $user;
        global $ostemplates;
        global $l;
        if($this->status($vid, 1) == 1) {
            return -1;
        }
        $vps = getvps($vid);
        if(!empty($vps["hvm"])) {
            return $this->onstartup_hvm($vid);
        }
        $vps_name = $vps["vps_name"];
        if(empty($oslist)) {
            oslist();
        }
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $mount = mount_direct($vid);
        if(is_array($mount)) {
            $pygrub = empty($ostemplates[$vps["osid"]]["pygrub"]) ? 0 : 1;
            if(empty($pygrub)) {
                oexec("uname -r", $uname);
                $uname = trim($uname);
                if(is_safe_file($mount["mount_point"] . "/lib/modules/" . $uname) && file_exists($mount["mount_point"] . "/lib/modules")) {
                    vexec("/bin/cp -Rf " . xss("/lib/modules/" . $uname) . " " . xss($mount["mount_point"] . "/lib/modules/" . $uname));
                }
            }
            vexec("df -P " . xss($mount["mount_point"]) . " 2>/dev/null", $tmp_out, $tmp_ret);
            $elements = preg_split("/\\s+/", $tmp_out[1]);
            $vps_disk_usage = ["Filesystem" => $elements[0], "1K-blocks" => $elements[1], "Used" => $elements[2], "Available" => $elements[3], "Use%" => $elements[4], "mounted_on" => $elements[5]];
            vexec("df -Pi " . xss($mount["mount_point"]) . " 2>/dev/null", $itmp_out, $itmp_ret);
            $elements = preg_split("/\\s+/", $itmp_out[1]);
            $vps_inode_usage = ["Filesystem" => $elements[0], "Inodes" => $elements[1], "IUsed" => $elements[2], "IFree" => $elements[3], "IUse%" => $elements[4], "mounted_on" => $elements[5]];
            if(!empty($vps_disk_usage) || !empty($vps_inode_usage)) {
                $tmp_data = ["disk" => $vps_disk_usage, "inode" => $vps_inode_usage];
                to_master("vps", "cached_disk", $vps["vpsid"], "vpsid", serialize($tmp_data));
            }
            if(file_exists($mount["mount_point"] . "/etc/shadow") && empty($globals["disable_nw_config"]) && empty($vps["disable_nw_config"])) {
                if(empty($ips[0])) {
                    $umount = umount($mount);
                    return false;
                }
                $routing = $ips[0]["routing"];
                $post = [];
                if(!empty($vps["dns_nameserver"])) {
                    $dns = unserialize($vps["dns_nameserver"]);
                    $post["dns"] = $dns;
                }
                network_configure($mount["mount_point"], $ips, $post, $routing);
            }
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["xen_err_unmount"];
                return false;
            }
        }
        return true;
    }
    public function onstartup_hvm($vid)
    {
        global $globals;
        global $user;
        global $ostemplates;
        global $l;
        if($this->status($vid, 1) == 1) {
            return -1;
        }
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $mount = mount($vid, "", 1);
        if(is_array($mount)) {
            vexec("df -P " . xss($mount["mount_point"]) . " 2>/dev/null", $tmp_out, $tmp_ret);
            $elements = preg_split("/\\s+/", $tmp_out[1]);
            $vps_disk_usage = ["Filesystem" => $elements[0], "1K-blocks" => $elements[1], "Used" => $elements[2], "Available" => $elements[3], "Use%" => $elements[4], "mounted_on" => $elements[5]];
            vexec("df -Pi " . xss($mount["mount_point"]) . " 2>/dev/null", $itmp_out, $itmp_ret);
            $elements = preg_split("/\\s+/", $itmp_out[1]);
            $vps_inode_usage = ["Filesystem" => $elements[0], "Inodes" => $elements[1], "IUsed" => $elements[2], "IFree" => $elements[3], "IUse%" => $elements[4], "mounted_on" => $elements[5]];
            if(!empty($vps_disk_usage) || !empty($vps_inode_usage)) {
                $tmp_data = ["disk" => $vps_disk_usage, "inode" => $vps_inode_usage];
                to_master("vps", "cached_disk", $vps["vpsid"], "vpsid", serialize($tmp_data));
            }
            if(file_exists($mount["mount_point"] . "/etc/shadow") && empty($globals["disable_nw_config"]) && empty($vps["disable_nw_config"])) {
                if(empty($ips[0])) {
                    return false;
                }
                $routing = $ips[0]["routing"];
                $post = [];
                if(!empty($vps["dns_nameserver"])) {
                    $dns = unserialize($vps["dns_nameserver"]);
                    $post["dns"] = $dns;
                }
                network_configure($mount["mount_point"], $ips, $post, $routing);
            }
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["xen_err_unmount"];
                return false;
            }
        }
        return true;
    }
    public function ebtables_remove($vid)
    {
        global $globals;
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        $vif_name = $this->vifname($vid);
        vs_ebtables_remove($vps_name, $vif_name);
    }
    public function changehostname($vid, $host, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("hostname", $host, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "hostname", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $vps_name = $vps["vps_name"];
        $conf = file("/etc/xen/auto/" . $vps_name . ".cfg");
        foreach ($conf as $k => $v) {
            if(preg_match("/hostname(\\s*?)=(\\s*?)('|\")(.*?)('|\")/is", $v)) {
                $conf[$k] = "hostname=\"" . $host . "\"" . "\n";
            }
        }
        writefile("/etc/xen/auto/" . $vps_name . ".cfg", implode("", $conf), 1);
        if(!empty($vps["hvm"])) {
            return $this->hvm_changehostname($vid, $host, $vps);
        }
        $mount = mount_direct($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            hostname_configure($mount["mount_point"], $host);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function hvm_changehostname($vid, $host, $vps)
    {
        global $globals;
        global $l;
        $vps_name = $vps["vps_name"];
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($GLOBALS["current_taskid"], $l["mount_undetermined"], -1);
                return true;
            }
            task_update($GLOBALS["current_taskid"], $l["kvm_err_mount"], -1);
            return false;
        }
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            hostname_configure($mount["mount_point"], $host);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            task_update($GLOBALS["current_taskid"], $l["kvm_err_unmount"], -1);
            return false;
        }
        task_update($GLOBALS["current_taskid"], $l["completed"], 100);
        return true;
    }
    public function resizevps($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("resizevps", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "resizevps", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        if(!empty($vps["hvm"])) {
            return $this->hvm_resizevps($vps);
        }
        $disks = get_vps_DISKS($vid);
        foreach ($disks as $dk => $DISK) {
            $disk_size = vpsdisk_size($DISK);
            if(empty($disk_size) || $DISK["size"] <= $disk_size) {
            } else {
                $resize = vpsdisk_resize($vid, $DISK["path"]);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($actid, $l["vpsdisk_resize_err"], -1);
                    return false;
                }
                if(!empty($DISK["path"]) && preg_match("/vs" . $vps["vps_name"] . "swap-/i", $DISK["path"])) {
                    $SWAPmkfs = vpsdisk_mkfs_direct($DISK, "swap");
                    if(!empty($SWAPmkfs)) {
                        $error = merge_error($error, $SWAPmkfs);
                        return false;
                    }
                }
                if(!empty($DISK["primary"])) {
                    $mount = mount_direct($vid);
                    if(is_array($mount)) {
                        if(file_exists($mount["mount_point"] . "/etc/redhat-release") || file_exists($mount["mount_point"] . "/etc/oracle-release")) {
                            $rc_path = "/rc.d/rc.local";
                        } elseif(file_exists($mount["mount_point"] . "/etc/debian_version")) {
                            $rc_path = "/rc.local";
                        }
                        if(is_safe_file($mount["mount_point"] . "/etc" . $rc_path) && is_safe_file($mount["mount_point"] . "/etc" . $rc_path . ".original") && file_exists($mount["mount_point"] . "/etc" . $rc_path)) {
                            $resizefsbin = is_file($mount["mount_point"] . "/sbin/resize4fs") ? "/sbin/resize4fs" : "/sbin/resize2fs";
                            copy($mount["mount_point"] . "/etc" . $rc_path, $mount["mount_point"] . "/etc" . $rc_path . ".original");
                            if(file_exists($mount["mount_point"] . "/etc/debian_version")) {
                                $rcdata = file($mount["mount_point"] . "/etc" . $rc_path);
                                $poped = array_pop($rcdata);
                                if(trim($poped) == "exit 0") {
                                    $rcfile = implode("", $rcdata);
                                    writefile($mount["mount_point"] . "/etc" . $rc_path, $rcfile, 1);
                                }
                            }
                            vexec("/bin/echo \"mv " . xss("/etc" . $rc_path . ".original") . " " . xss("/etc" . $rc_path) . "; " . xss($resizefsbin) . " /dev/xvda1; " . xss($resizefsbin) . " /dev/sda1; " . xss($resizefsbin) . " /dev/hda1 &\" >> " . xss($mount["mount_point"] . "/etc" . $rc_path));
                            @chmod($mount["mount_point"] . "/etc" . $rc_path, 493);
                        }
                        $umount = umount($mount);
                        if(!empty($umount)) {
                            $error[] = $l["xen_err_unmount"];
                            task_update($actid, $l["kvm_err_unmount"], -1);
                            return false;
                        }
                    }
                }
            }
        }
        task_update($actid, $l["completed"], 100);
    }
    public function hvm_resizevps($vps)
    {
        global $globals;
        global $l;
        global $error;
        $vid = $vps["vpsid"];
        $disks = get_vps_DISKS($vid);
        foreach ($disks as $dk => $DISK) {
            $disk_size = vpsdisk_size($DISK);
            if(empty($disk_size) || $DISK["size"] <= $disk_size) {
            } else {
                $resize = vpsdisk_resize($vid, $DISK["path"]);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($GLOBALS["current_taskid"], $l["vpsdisk_resize_err"], -1);
                    return false;
                }
                if(empty($resize["altered_partitions"])) {
                } elseif(!empty($DISK["primary"])) {
                    $DISK["diskinfo"] = $resize["diskinfo"];
                    $fs_resize = vpsdisk_resize_filesystem($DISK);
                    if(!empty($fs_resize["error"])) {
                        $error = merge_error($error, $fs_resize["error"]);
                        task_update($GLOBALS["current_taskid"], $l["kvm_err_resizefs"], -1);
                        return false;
                    }
                }
            }
        }
        task_update($GLOBALS["current_taskid"], $l["completed"], 100);
        return true;
    }
    public function change_dnsnameserver($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("change_dnsnameserver", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "change_dnsnameserver", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        if(!empty($vps["hvm"])) {
            return $this->hvm_change_dnsnameserver($vps);
        }
        $mount = mount_direct($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        dns_configure($mount["mount_point"], $vps);
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function hvm_change_dnsnameserver($vps)
    {
        global $globals;
        global $l;
        $vid = $vps["vpsid"];
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($GLOBALS["current_taskid"], $l["mount_undetermined"], -1);
                return true;
            }
            task_update($GLOBALS["current_taskid"], $l["kvm_err_mount"], -1);
            return false;
        }
        dns_configure($mount["mount_point"], $vps);
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            task_update($GLOBALS["current_taskid"], $l["kvm_err_unmount"], -1);
            return false;
        }
        task_update($GLOBALS["current_taskid"], $l["completed"], 100);
        return true;
    }
    public function editvps($vid)
    {
        return $this->createvps($vid, 0);
    }
    public function createvps($vid, $create = 1, $format_primary = 0)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        global $error;
        global $l;
        $vps = getvps($vid, 0);
        $action = "edit_vps";
        if(!empty($create)) {
            $action = "create_vps";
        }
        $actid = vps_task($action, "", 0, $vid, $vps["uid"], 0, $l["beginning_creation"]);
        task_start($actid);
        if(!empty($vps["hvm"])) {
            return $this->hvm_createvps($vid, $create, $vps, $format_primary, $actid);
        }
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        if(empty($oslist)) {
            oslist();
        }
        $disks = get_vps_DISKS($vid);
        if(!empty($create) && !defined("DONT_DD_OS_TEMPLATE")) {
            if(!empty($vps["osid"])) {
                task_update($actid, $l["downloading_os"], 20);
                getos($ostemplates[$vps["osid"]]["filename"], "xenos");
            }
            if(empty($ostemplates[$vps["osid"]]) || !file_exists($globals["xenos"] . "/" . $ostemplates[$vps["osid"]]["filename"])) {
                $error[] = $l["build_no_os"];
                task_update($actid, $l["build_no_os"], -1);
                return false;
            }
        }
        $internal = 0;
        $internal_mac = 0;
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
            if(!empty($ips[$i]["internal"])) {
                $internal = $ips[$i]["bridge"];
                if(!empty($ips[$i]["mac_addr"]) && empty($internal_mac)) {
                    $internal_mac = $ips[$i]["mac_addr"];
                }
            }
            if(!empty($ips[$i]["vlan"])) {
                $vlan_bridge = $ips[$i]["bridge"];
            }
        }
        if(empty($ips[0])) {
            $error[] = $l["build_no_ip"];
            task_update($actid, $l["build_no_ip"], -1);
            return false;
        }
        if(!empty($internal) && empty($globals["xen_pvbridge"])) {
            if(vexec("ifconfig viifbr0") == 0) {
                $globals["xen_pvbridge"] = "viifbr0";
            } elseif(vexec("ifconfig xenbr0") == 0) {
                $globals["xen_pvbridge"] = "xenbr0";
            } elseif(vexec("ifconfig xenbr1") == 0) {
                $globals["xen_pvbridge"] = "xenbr1";
            } else {
                $error[] = "Could not find Xen Bridge with internal bridge";
                return false;
            }
        }
        $nat = $ips[0]["nat"];
        $nat_name = $ips[0]["nat_name"];
        $routing = $ips[0]["routing"];
        $cfg = "/etc/xen/auto/" . $vps["vps_name"] . ".cfg";
        $mac_flag = 0;
        if(!empty($create)) {
            if(empty($ips[0]["mac_addr"])) {
                $mac = substr_replace(new_mac(), !empty($globals["custom_mac"]) ? $globals["custom_mac"] : "00:16:3e", 0, 8);
                $mac_flag = 1;
            } else {
                $mac = $ips[0]["mac_addr"];
            }
            $vncport = 0;
            if(!empty($vps["vnc"])) {
                $vncport = !empty($GLOBALS["use_vnc_port"]) ? $GLOBALS["use_vnc_port"] : $this->_newVncPort();
            }
        } else {
            $tmp = file($cfg);
            $vncdetails = $this->vncDetails($vid);
            $vncpass = $vncdetails["password"];
            $vncport = 0;
            if(!empty($vps["vnc"])) {
                $vncport = $vncdetails["port"];
                $vncport = empty($vncport) ? $this->_newVncPort() : $vncport;
            }
            if(preg_match("/mac=/i", implode("", $tmp))) {
                preg_match_all("/mac(\"|\\=)(.*?)(\"|\\,|\\\"|')/is", implode("", $tmp), $matches);
                $rest = $matches[2][0];
            }
            if(!empty($rest)) {
                $mac = $rest;
            } elseif(empty($ips[0]["mac_addr"])) {
                $mac = substr_replace(new_mac(), !empty($globals["custom_mac"]) ? $globals["custom_mac"] : "00:16:3e", 0, 8);
                $mac_flag = 1;
            } else {
                $mac = $ips[0]["mac_addr"];
            }
        }
        if(!empty($vps["mac"])) {
            $mac = $vps["mac"];
        }
        if(!empty($ips[0]["mac_addr"])) {
            $mac = $ips[0]["mac_addr"];
        }
        if(!empty($ostemplates[$vps["osid"]])) {
            $pygrub = empty($ostemplates[$vps["osid"]]["pygrub"]) ? 0 : 1;
            $drive = empty($ostemplates[$vps["osid"]]["drive"]) ? "sda" : $ostemplates[$vps["osid"]]["drive"];
        } else {
            $tmp_conf = $this->getconf($vid);
            $pygrub = preg_match("/pygrub/", $tmp_conf["bootloader"]) ? 1 : 0;
            preg_match("/\\/dev\\/(.*)1/", $tmp_conf["root"], $drive_match);
            $drive = empty($drive_match[1]) ? "sda" : $drive_match[1];
        }
        $fstype = empty($ostemplates[$vps["osid"]]["fstype"]) ? "ext3" : $ostemplates[$vps["osid"]]["fstype"];
        task_update($actid, $l["preparing_config_file"], 23);
        $extra = empty($ostemplates[$vps["osid"]]["extra"]) ? "" : $ostemplates[$vps["osid"]]["extra"];
        $vncpass = empty($vncpass) ? generateRandStr(10) : $vncpass;
        $vncport = 0;
        if(!empty($vps["vnc"])) {
            $vncport = $vncport <= 5900 ? $this->_newVncPort() : $vncport;
            $vncport = $vncport - 5900;
        }
        if($globals["distro"] == "ubuntu") {
            $image_dir = "/var/lib/xen/images/ubuntu-virt";
        } else {
            $image_dir = "/boot";
        }
        $vps["cpu_percent"] = (int) $vps["cpu_percent"];
        $conf = ($pygrub ? "#" : "") . "kernel = \"" . $image_dir . "/vmlinuz-virtualizor\"\n" . ($pygrub ? "#" : "") . "ramdisk = \"" . $image_dir . "/initrd-virtualizor.img\"\n" . ($pygrub ? "" : "#") . "bootloader = \"" . (VXM == "xl" ? "" : "/usr/bin/") . "pygrub\"\nname = \"" . $vps["vps_name"] . "\"\nmemory = \"" . $vps["ram"] . "\"\nhostname = \"" . $vps["hostname"] . "\"\n" . (!empty($vps["cpu"]) ? "cpu_weight = \"" . $vps["cpu"] . "\"" . "\n" : "") . (!empty($vps["cpu_percent"]) ? "cap = \"" . $vps["cpu_percent"] . "\"" . "\n" : "") . "\nvcpus = \"" . $vps["cores"] . "\"\n" . ($vps["cpupin"] != -1 ? "cpus = \"" . $vps["cpupin"] . "\"" . "\n" : "") . "\n" . (empty($vps["vnc"]) ? "#" : "") . "vfb = [\"type=vnc,vncdisplay=" . $vncport . ",vnclisten=" . server_vncip($vps["serid"]) . ",vncpasswd=" . $vncpass . ",vncunused=0\"]\nvif = [\"";
        if(!empty($vps["nic_type"]) && $vps["nic_type"] != "default") {
            $conf .= "model=" . $vps["nic_type"] . ", ";
        }
        $conf .= "ip=" . implode(" ", $_ips) . ", ";
        if(empty($nat)) {
            $conf .= "vifname=vif" . $vps["vps_name"] . ".0 ";
            if(!empty($vlan_bridge)) {
                $conf .= ", bridge=" . $vlan_bridge;
            } elseif(!empty($globals["xen_pvbridge"])) {
                $conf .= ", bridge=" . $globals["xen_pvbridge"];
            }
        } else {
            $conf .= "bridge=" . $nat_name . ", vifname=vif" . $vps["vps_name"] . ", script=vif-bridge";
        }
        $conf .= ", mac=" . $mac . "\" ";
        if(!empty($internal)) {
            $conf .= ", \"";
            if(!empty($vps["nic_type"]) && $vps["nic_type"] != "default") {
                $conf .= "model=" . $vps["nic_type"] . ", ";
            }
            $conf .= " vifname=vinf" . $vps["vps_name"] . ".0, bridge=" . $internal;
            if(!empty($internal_mac)) {
                $conf .= ", mac=" . $internal_mac;
            }
            $conf .= "\"";
        }
        $conf .= "]\ndisk = [\"" . $this->_disk_conf($disks[0]) . ":" . vm_disk_path($vps) . "," . $drive . "1,w\" " . (empty($disks[1]["size"]) ? "" : ", \"" . $this->_disk_conf($disks[0]) . ":" . $disks[1]["path"] . "," . $drive . "2,w\"") . "]\nroot = \"/dev/" . $drive . "1 ro\"\nserial = \"pty\"\nkeymap = \"" . (empty($vps["vnc_keymap"]) ? "en-us" : $vps["vnc_keymap"]) . "\"\n" . $extra . "\n";
        if(VXM == "xl") {
            $conf = preg_replace("/vifname=vi(n?)f" . $vps["vps_name"] . "(\\.0?)(\\s*),/is", "", $conf);
        }
        writefile($cfg, $conf, 1);
        task_update($actid, $l["written_config_file"], 25);
        apply_filters("after_config_write", $vps);
        to_master("vps", "vncport", $vps["vpsid"], "vpsid", $vncport);
        if(!empty($mac_flag)) {
            to_master("vps", "mac", $vps["vpsid"], "vpsid", $mac);
        }
        $task_disk_num = 1;
        $task_disk_progress = 25;
        if(!empty($create)) {
            foreach ($disks as $dk => $DISK) {
                task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                $storage_create = vpsdisk_create($DISK);
                if(!empty($storage_create)) {
                    $error = merge_error($error, $storage_create);
                    task_update($actid, print_r($error, 1), -1);
                    return false;
                }
                $task_disk_num++;
                $task_disk_progress = $task_disk_progress + ceil(30 / count($disks));
            }
            $DISK = get_vps_disk($vid);
            $mkfs = vpsdisk_mkfs_direct($DISK, $fstype);
            task_update($actid, $l["mkfs_direct"], 55);
            if(!empty($mkfs)) {
                $error = merge_error($error, $mkfs);
                task_update($actid, print_r($error, 1), -1);
                return false;
            }
            if(!empty($disks[1])) {
                $SWAPDISK = $disks[1];
                $SWAPmkfs = vpsdisk_mkfs_direct($SWAPDISK, "swap");
                task_update($actid, $l["swap_disk"], 57);
                if(!empty($SWAPmkfs)) {
                    $error = merge_error($error, $SWAPmkfs);
                    return false;
                }
            }
            task_update($actid, $l["mount"], 60);
            $mount = mount_direct($vid);
            if(!is_array($mount)) {
                if($mount == -1) {
                    return true;
                }
                return false;
            }
            if(!defined("DONT_DD_OS_TEMPLATE")) {
                task_update($actid, $l["untar_os"], 67);
                $ret = vexec("cd " . xss($mount["mount_point"]) . "; tar -zxf " . xss($globals["xenos"] . "/" . $ostemplates[$vps["osid"]]["filename"]));
                if($ret != "0") {
                    $error[] = $l["xen_err_untar"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    task_update($actid, $l["xen_err_untar"], -1);
                    $umount = umount($mount);
                    return false;
                }
            }
            if(!empty($fstype) && $fstype != "ext3" && !empty($mount["mount_point"]) && is_safe_file($mount["mount_point"] . "/etc/fstab")) {
                $tmpf = file($mount["mount_point"] . "/etc/fstab");
                if(!empty($tmpf)) {
                    foreach ($tmpf as $k => $v) {
                        $tmp = preg_split("/\\s+/", trim($v));
                        if($tmp[2] == "ext3") {
                            $tmp[2] = $fstype;
                            $tmpf[$k] = implode("\t", $tmp);
                        }
                    }
                    writefile($mount["mount_point"] . "/etc/fstab", implode("\n", $tmpf), 1);
                }
            }
            if(empty($pygrub)) {
                oexec("uname -r", $uname);
                $uname = trim($uname);
                if(file_exists($mount["mount_point"] . "/lib/modules")) {
                    vexec("/bin/cp -Rf " . xss("/lib/modules/" . $uname) . " " . xss($mount["mount_point"] . "/lib/modules/" . $uname));
                }
            }
            $post = [];
            if(!empty($vps["dns_nameserver"])) {
                $dns = unserialize($vps["dns_nameserver"]);
                $post["dns"] = $dns;
            }
            task_update($actid, $l["net_config"], 70);
            network_configure($mount["mount_point"], $ips, $post, $routing);
            task_update($actid, $l["hostname_config"], 76);
            hostname_configure($mount["mount_point"], $vps["hostname"]);
            task_update($actid, $l["sshkey_clean"], 82);
            sshkey_clean($mount["mount_point"]);
            task_update($actid, $l["umount"], 95);
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["xen_err_unmount"];
                task_update($actid, $l["xen_err_unmount"], -1);
                return false;
            }
            task_update($actid, $l["create_done"], 100);
        } else {
            _task_update($actid, $l["tc_rule_create"], 30, "group");
            $this->tc_create($vid);
            _task_update($actid, $l["tc_rule_create"], 30, "group_end");
            $resize_break = 0;
            foreach ($disks as $dk => $DISK) {
                $disk_size = vpsdisk_size($DISK);
                if($disk_size == 0 && 0 < $DISK["size"]) {
                    task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                    vpsdisk_create($DISK);
                }
                if(!empty($disk_size) && $disk_size < $DISK["size"] && empty($resize_break)) {
                    $this->resizevps($vid);
                    $resize_break = 1;
                }
                $task_disk_num++;
                $task_disk_progress = $task_disk_progress + ceil(40 / count($disks));
            }
            _task_update($actid, $l["change_dnsnameserver"], 82, "group");
            _task_update($actid, "", 82, "change_dnsnameserver");
            $this->change_dnsnameserver($vid);
            _task_update($actid, "", 82, "group_end");
            $vps_status = $this->status($vid, 1);
            if($vps_status == 1) {
                $vif_name = $this->vifname($vid);
                $mac_addr = $this->getmac($vid);
                task_update($actid, $l["eb_rules"], 88);
                vs_ebtables_add($vid, $vif_name, $mac_addr);
            }
            task_update($actid, $l["edit_done"], 100);
        }
        apply_filters("after_createvps", $vps);
        return true;
    }
    public function hvm_createvps($vid, $create, $vps, $format_primary = 0, $actid = 0)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        global $error;
        global $l;
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        if(empty($oslist)) {
            oslist();
        }
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        $isopath = $isotype = "";
        if(!empty($vps["iso"])) {
            $isopath = iso_path($vps["uid"], $vps["iso"], $isotype);
            task_update($actid, $l["downloading_iso"], 10);
            getos($isopath, $isotype);
        }
        if(!empty($create) && !defined("DONT_DD_OS_TEMPLATE")) {
            if(!empty($vps["osid"])) {
                task_update($actid, $l["downloading_os"], 20);
                getos($ostemplates[$vps["osid"]]["filename"], "xenos");
            }
            if(empty($ostemplates[$vps["osid"]]) || !file_exists($globals["xenos"] . "/" . $ostemplates[$vps["osid"]]["filename"])) {
                $noos = true;
            }
            if(empty($vps["iso"]) || !file_exists($globals[$isotype] . "/" . $isopath)) {
                $noiso = true;
            }
            if(isset($noos) && isset($noiso)) {
                $error[] = $l["build_no_os_iso"];
                task_update($actid, $l["build_no_os_iso"], -1);
                return false;
            }
        }
        $internal = 0;
        $internal_mac = 0;
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
            if(!empty($ips[$i]["internal"])) {
                $internal = $ips[$i]["bridge"];
                if(!empty($ips[$i]["mac_addr"]) && empty($internal_mac)) {
                    $internal_mac = $ips[$i]["mac_addr"];
                }
            }
            if(!empty($ips[$i]["vlan"])) {
                $vlan_bridge = $ips[$i]["bridge"];
            }
        }
        if(empty($ips[0])) {
            $error[] = $l["build_no_ip"];
            task_update($actid, $l["build_no_ip"], -1);
            return false;
        }
        if(!empty($internal) && empty($globals["xen_hvmbridge"])) {
            if(vexec("ifconfig viifbr0") == 0) {
                $globals["xen_hvmbridge"] = "viifbr0";
            } elseif(vexec("ifconfig xenbr0") == 0) {
                $globals["xen_hvmbridge"] = "xenbr0";
            } elseif(vexec("ifconfig xenbr1") == 0) {
                $globals["xen_hvmbridge"] = "xenbr1";
            } else {
                $error[] = "Could not find Xen Bridge with internal bridge";
                return false;
            }
        }
        $nat = $ips[0]["nat"];
        $nat_name = $ips[0]["nat_name"];
        $routing = $ips[0]["routing"];
        $cfg = "/etc/xen/auto/" . $vps["vps_name"] . ".cfg";
        $mac_flag = 0;
        if(!empty($create)) {
            if(empty($ips[0]["mac_addr"])) {
                $mac = substr_replace(new_mac(), !empty($globals["custom_mac"]) ? $globals["custom_mac"] : "00:16:3e", 0, 8);
                $mac_flag = 1;
            } else {
                $mac = $ips[0]["mac_addr"];
            }
            $vncport = 0;
            if(!empty($vps["vnc"])) {
                $vncport = !empty($GLOBALS["use_vnc_port"]) ? $GLOBALS["use_vnc_port"] : $this->_newVncPort();
            }
        } else {
            $tmp = file($cfg);
            $vncdetails = $this->vncDetails($vid);
            $vncpass = $vncdetails["password"];
            $vncport = 0;
            if(!empty($vps["vnc"])) {
                $vncport = $vncdetails["port"];
                $vncport = empty($vncport) ? $this->_newVncPort() : $vncport;
            }
            if(preg_match("/mac=/i", implode("", $tmp))) {
                preg_match_all("/mac(\"|\\=)(.*?)(\"|\\,|\\\"|')/is", implode("", $tmp), $matches);
                $rest = $matches[2][0];
            }
            if(!empty($rest)) {
                $mac = $rest;
            } elseif(empty($ips[0]["mac_addr"])) {
                $mac = substr_replace(new_mac(), !empty($globals["custom_mac"]) ? $globals["custom_mac"] : "00:16:3e", 0, 8);
                $mac_flag = 1;
            } else {
                $mac = $ips[0]["mac_addr"];
            }
        }
        if(!empty($vps["mac"])) {
            $mac = $vps["mac"];
        }
        if(!empty($ips[0]["mac_addr"])) {
            $mac = $ips[0]["mac_addr"];
        }
        task_update($actid, $l["preparing_config_file"], 23);
        $extra = empty($ostemplates[$vps["osid"]]["extra"]) ? "" : $ostemplates[$vps["osid"]]["extra"];
        $vncpass = empty($vncpass) ? generateRandStr(10) : $vncpass;
        $vncport = 0;
        if(!empty($vps["vnc"])) {
            $vncport = $vncport <= 5900 ? $this->_newVncPort() : $vncport;
            $vncport = $vncport - 5900;
        }
        $vps["cpu_percent"] = (int) $vps["cpu_percent"];
        $lib_arch = os_arch() == 64 ? "lib64" : "lib";
        $dev_d = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"];
        $__disks = [];
        $i = 1;
        foreach ($disks as $k => $v) {
            $_dev = $dev_d[$i];
            if(!empty($v["primary"])) {
                $_dev = "a";
            } else {
                $i++;
            }
            $__disks[] = "\"" . $this->_disk_conf($v) . ":" . $v["path"] . ",hd" . $_dev . ",w\"";
        }
        if(empty($globals["xen_dm_version"])) {
            $qemu_dm_version = "qemu-xen-traditional";
        } else {
            $qemu_dm_version = "qemu-xen";
        }
        $__disks[] = "\"" . (empty($vps["iso"]) ? "" : "file:" . $globals[$isotype] . "/" . $isopath) . ",hd" . $dev_d[$i + 0] . ":cdrom,r\"";
        $conf = "name = \"" . $vps["vps_name"] . "\"\nbuilder = \"hvm\"\n" . (VXM == "xl" ? "#" : "") . "kernel = \"/usr/lib/xen/boot/hvmloader\"\nmemory = \"" . $vps["ram"] . "\"\nshadow_memory = \"" . $vps["shadow"] . "\"\nhostname = \"" . $vps["hostname"] . "\"\n" . (!empty($vps["cpu"]) ? "cpu_weight = \"" . $vps["cpu"] . "\"" . "\n" : "") . (!empty($vps["cpu_percent"]) ? "cap = \"" . $vps["cpu_percent"] . "\"" . "\n" : "") . "\nvcpus = \"" . $vps["cores"] . "\"\n" . ($vps["cpupin"] != -1 ? "cpus = \"" . $vps["cpupin"] . "\"" . "\n" : "") . "\nvif = [\"" . (empty($vps["pv_on_hvm"]) ? "type=" . (empty($vps["vif_type"]) ? "netfront" : $vps["vif_type"]) . "," : "") . (!empty($vps["nic_type"]) && $vps["nic_type"] != "default" ? "model=" . $vps["nic_type"] . "," : "") . " ip=" . implode(" ", $_ips) . ", " . (empty($nat) ? "vifname=vif" . $vps["vps_name"] . ".0" . (!empty($vlan_bridge) ? ", bridge=" . $vlan_bridge : (!empty($globals["xen_hvmbridge"]) ? ", bridge=" . $globals["xen_hvmbridge"] : "")) : "bridge=" . $nat_name . ", vifname=vif" . $vps["vps_name"] . ", script=vif-bridge") . ", mac=" . $mac . "\" " . (empty($internal) ? "" : ", \"" . (!empty($vps["nic_type"]) && $vps["nic_type"] != "default" ? "model=" . $vps["nic_type"] . ", " : "") . " vifname=vinf" . $vps["vps_name"] . ".0, bridge=" . $internal . (!empty($internal_mac) ? ", mac=" . $internal_mac : "") . "\"") . "]\n" . (empty($vps["pv_on_hvm"]) ? "" : "xen_platform_pci = 1") . "\ndisk = [" . implode(", ", $__disks) . "]\n" . (VXM == "xl" ? "#" : "") . "device_model = \"/usr/" . $lib_arch . "/xen/bin/qemu-dm\"\n" . (VXM == "xl" ? "device_model_version = \"" . $qemu_dm_version . "\"" : "") . "\nboot = \"" . (preg_match("/[^cda]/is", $vps["boot"]) ? "cda" : $vps["boot"]) . "\"\nacpi = " . $vps["acpi"] . "\napic = " . $vps["apic"] . "\nvnc = " . $vps["vnc"] . "\nvncdisplay = " . $vncport . "\nvncviewer = 0\nvncconsole = 1\nvncunused = 0\nvnclisten = \"" . server_vncip($vps["serid"]) . "\"\nvncpasswd = \"" . $vncpass . "\"\nserial = \"pty\"\naudio = 1\n" . (VXM == "xl" ? "#" : "") . "soundhw = \"all\"\nsdl = 0\nusbdevice = \"tablet\"\n" . (!empty($vps["pae"]) ? "pae = " . $vps["pae"] : "") . "\nkeymap = \"" . (empty($vps["vnc_keymap"]) ? "en-us" : $vps["vnc_keymap"]) . "\"\n" . $extra . "\n";
        if(VXM == "xl") {
        }
        task_update($actid, $l["written_config_file"], 28);
        writefile($cfg, $conf, 1);
        apply_filters("after_config_write", $vps);
        to_master("vps", "vncport", $vps["vpsid"], "vpsid", $vncport);
        if(!empty($mac_flag)) {
            to_master("vps", "mac", $vps["vpsid"], "vpsid", $mac);
        }
        $task_disk_num = 1;
        $task_disk_progress = 35;
        if(empty($create)) {
            _task_update($actid, $l["tc_rule_create"], 35, "group");
            $this->tc_create($vid);
            _task_update($actid, $l["tc_rule_create"], 35, "group_end");
            if(preg_match("/windows/is", $vps["os_name"]) && ($ostemplates[$vps["osid"]]["perf_ops"] && $globals["use_win_script"])) {
                $this->change_winips($vid);
            }
            $resize_break = 0;
            foreach ($disks as $dk => $DISK) {
                $disk_size = vpsdisk_size($DISK);
                if(empty($disk_size) && 0 < $DISK["size"] && empty($DISK["primary"])) {
                    task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                    $storage_create = vpsdisk_create($DISK);
                    if(!empty($storage_create)) {
                        $error = merge_error($error, $storage_create);
                        task_update($actid, print_r($error, 1), -1);
                        return false;
                    }
                }
                if(!empty($disk_size) && $disk_size < $DISK["size"] && empty($resize_break)) {
                    $this->resizevps($vid);
                    $resize_break = 1;
                }
                $task_disk_num++;
                $task_disk_progress = $task_disk_progress + ceil(40 / count($disks));
            }
            _task_update($actid, $l["change_dnsnameserver"], 83, "group");
            _task_update($actid, "", 83, "change_dnsnameserver");
            $this->change_dnsnameserver($vps["vpsid"]);
            _task_update($actid, "", 83, "group_end");
            $vps_status = $this->status($vid, 1);
            if($vps_status == 1) {
                $vif_name = $this->vifname($vid);
                $mac_addr = $this->getmac($vid);
                vs_ebtables_add($vid, $vif_name, $mac_addr);
            }
            task_update($actid, $l["edit_done"], 100);
            return true;
        } else {
            foreach ($disks as $dk => $DISK) {
                $os_template = "";
                if(!empty($format_primary) && empty($DISK["primary"])) {
                } else {
                    if(!empty($DISK["primary"]) && !empty($vps["osid"])) {
                        $os_template = $globals["xenos"] . "/" . $ostemplates[$vps["osid"]]["filename"];
                    }
                    task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                    $storage_create = vpsdisk_create($DISK, $os_template);
                    if(!empty($storage_create)) {
                        $error = merge_error($error, $storage_create);
                        task_update($actid, print_r($error, 1), -1);
                        return false;
                    }
                    $task_disk_num++;
                    $task_disk_progress = $task_disk_progress + ceil(30 / count($disks));
                }
            }
            if(!empty($vps["osid"])) {
                task_update($actid, $l["resizing_disk"], 60);
                $resize = vpsdisk_resize($vid);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($actid, print_r($error, 1), -1);
                    return false;
                }
                task_update($actid, $l["resizing_disk_done"], 65);
                $disk = $resize["diskinfo"];
                $DISK = get_vps_disk($vid);
                $DISK["diskinfo"] = $resize["diskinfo"];
                if(empty($disk["parttype"])) {
                    $DISK["diskinfo"] = get_ostype_from_disk($DISK, $disk);
                    $disk = $DISK["diskinfo"];
                }
                if(empty($ostemplates[$vps["osid"]]["noresizefs"])) {
                    task_update($actid, $l["resizing_fs"], 70);
                    $fs_resize = vpsdisk_resize_filesystem($DISK);
                    if(!empty($fs_resize["error"])) {
                        $error = merge_error($error, $fs_resize["error"]);
                        task_update($actid, print_r($error, 1), -1);
                        return false;
                    }
                    task_update($actid, $l["resizing_fs_done"], 75);
                }
                if(!empty($disk["parttype"][0]["type"]) && preg_match("/" . $disk["parttype"][0]["type"] . "/is", "islinux")) {
                    if(!empty($ostemplates[$vps["osid"]]["perf_ops"])) {
                        $mount = mount($vid);
                        if(!is_array($mount)) {
                            $error[] = $l["xen_err_mount"];
                            task_update($actid, $l["xen_err_mount"], -1);
                            return false;
                        }
                        apply_filters("perform_operations", $mount);
                        $post = [];
                        if(!empty($vps["dns_nameserver"])) {
                            $dns = unserialize($vps["dns_nameserver"]);
                            $post["dns"] = $dns;
                        }
                        task_update($actid, $l["net_config"], 85);
                        network_configure($mount["mount_point"], $ips, $post, $routing);
                        task_update($actid, $l["hostname_config"], 90);
                        hostname_configure($mount["mount_point"], $vps["hostname"]);
                        task_update($actid, $l["sshkey_clean"], 95);
                        sshkey_clean($mount["mount_point"]);
                        $umount = umount($mount);
                        if(!empty($umount)) {
                            $error[] = $l["xen_err_unmount"];
                            task_update($actid, $l["xen_err_unmount"], -1);
                            return false;
                        }
                    }
                } elseif(!empty($disk["parttype"][0]["type"]) && preg_match("/" . $disk["parttype"][0]["type"] . "/is", "iswindows")) {
                }
            }
            if(preg_match("/windows/is", $vps["os_name"]) && !empty($ostemplates[$vps["osid"]]["perf_ops"]) && $globals["use_win_script"]) {
                $this->change_winips($vid);
            }
            task_update($actid, $l["calling_after_createvps"], 96);
            apply_filters("after_createvps", $vps);
            task_update($actid, $l["create_done"], 100);
            return true;
        }
    }
    public function destroyvps($vid, $format_primary = 0)
    {
        global $globals;
        global $l;
        global $error;
        $vps = getvps($vid);
        $actid = vps_task("deletevs", "", 0, $vid, $vps["uid"], 0, $l["del_vps"]);
        task_start($actid);
        $data = ["serid" => $vps["serid"]];
        task_update($actid, $l["start_del_vps"], 5, serialize($data));
        $vps_name = $vps["vps_name"];
        task_update($actid, $l["call_hook_before_delvps"], 25);
        apply_filters("before_deletevps", $vps);
        _task_update($actid, $l["del_ebtables"], 35, "group");
        $this->ebtables_remove($vid);
        ebtables_save();
        _task_update($actid, "", 35, "group_end");
        task_update($actid, $l["stop_vps"], 45);
        vexec(VXM . " destroy " . xss($vps_name));
        sleep(1);
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\t\tAND action = 'delete_vpsdisks'\n\t\t\t\t\t\tORDER BY actid ASC", [":vid" => $vid]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $tasks[$row["actid"]] = $row;
                $del_data = _unserialize($row["data"]);
                $this->delete_vpsdisks($vid, $del_data, $row["actid"]);
                logs_vps("delete_vpsdisks", $del_data, 1, $vid, $user["uid"]);
            }
        }
        $disks = get_vps_DISKS($vid);
        foreach ($disks as $dk => $DISK) {
            if(!empty($format_primary) && empty($DISK["primary"])) {
            } else {
                umount($DISK);
                task_update($actid, $l["del_kpartx"], 55);
                kpartx_delete($vid, $DISK["path"]);
                task_update($actid, $l["del_storage"], 65);
                $storage_destroy = vpsdisk_destroy($DISK);
                if(!empty($storage_destroy)) {
                    $error = merge_error($error, $storage_destroy);
                }
            }
        }
        task_update($actid, $l["del_config"], 75);
        @unlink("/etc/xen/auto/" . $vps_name . ".cfg");
        @unlink("/etc/xen/auto/" . $vps_name . ".cfg.bak");
        if(is_dir("/home/" . $vps["vps_name"])) {
            vexec("rm -rf /home/" . $vps["vps_name"]);
        }
        task_update($actid, $l["call_hook_after_delvps"], 88);
        apply_filters("after_deletevps", $vps);
        task_update($actid, $l["del_vps_done"], 100);
        return true;
    }
    public function osreinstall($vid, $format_primary = 0)
    {
        $vps_name = $this->getname($vid);
        $vnc = $this->vncDetails($vid);
        if(!empty($vnc["port"])) {
            $GLOBALS["use_vnc_port"] = $vnc["port"];
        }
        $this->destroyvps($vid, $format_primary);
        if(!$this->createvps($vid, 1, $format_primary)) {
            return false;
        }
        if(!empty($vnc["password"])) {
            $this->changeVncPass($vid, $vnc["password"]);
        }
        return true;
    }
    public function changepassword($vid, $newpassword, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("changepassword", base64_encode($newpassword), 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "changepassword", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "change_password", [$newpassword]);
    }
    public function remotedesktop($vid, $rdp, $actid = 0)
    {
        global $globals;
        global $l;
        global $user;
        global $oslist;
        global $ostemplates;
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("remotedesktop", $rdp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "remotedesktop", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "remote_desktop", [$rdp]);
    }
    public function filelist($vid, $dir = "", $searchSubdirs = 1, $directoriesonly = 0, $maxlevel = "all", $level = 1)
    {
        return -1;
    }
    public function processes($vid)
    {
        $processes = [];
        return $processes;
    }
    public function os($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $vps = getvps($vid);
        $osid = $vps["osid"];
        if(empty($ostemplates)) {
            oslist();
        }
        $osinfo = $ostemplates[$vps["osid"]];
        if(empty($osinfo)) {
            $osinfo["name"] = $vps["os_name"];
            $osinfo["distro"] = distro_find($vps["os_name"]);
        }
        return $osinfo;
    }
    public function hostname($vid)
    {
        $vps = getvps($vid);
        return $vps["hostname"];
    }
    public function listips($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $ips = [];
        $res = makequery("SELECT * FROM `ips`\n\t\t\t\t\tWHERE vpsid = :vid\t\t\t\t\t\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(in_array($row["ip"], $ips)) {
            } else {
                $ips[] = $row["ip"];
            }
        }
        return $ips;
    }
    public function cpu($vid)
    {
        global $user;
        $ret = [];
        $ret["manu"] = "unknown";
        $ret["limit"] = 0;
        $ret["used"] = 0;
        oexec("cat /proc/cpuinfo", $tmp);
        if(preg_match("/intel/is", $tmp)) {
            $ret["manu"] = "intel";
        } elseif(preg_match("/amd/is", $tmp)) {
            $ret["manu"] = "amd";
        }
        virt_preg_replace("/cpu(\\s*?)MHz(\\s*?)\\:(\\s*?)(.*?)(\\s*?)\\n/is", $tmp, $mhz, 4);
        $vps = getvps($vid);
        if($this->status($vid) !== 0) {
            $vps_name = $this->getname($vid);
            $_cpu_stats = $this->_cpu_stats();
            $ret["used"] = trim($_cpu_stats[$vps_name]["cpu"]);
        }
        $vps_cores = $vps["cores"];
        $node_cores = get_cores();
        $ret["percent"] = $node_cores / $vps_cores * $ret["used"];
        if(100 < $ret["percent"]) {
            $ret["percent"] = 100;
        }
        $ret["percent_free"] = 100 - $ret["percent"];
        if(!empty($mhz)) {
            $ret["limit"] = $mhz;
            $ret["used"] = $ret["percent"] * $mhz / 100;
            $ret["free"] = $ret["limit"] - $ret["used"];
        } else {
            $ret["limit"] = 100;
            $ret["used"] = $ret["percent"];
            $ret["free"] = $ret["limit"] - $ret["used"];
        }
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function ram($vid)
    {
        global $user;
        $ret = [];
        $ret["used"] = 0;
        $ret["limit"] = 0;
        $ret["guaranteed"] = 0;
        $ret["swap"] = 0;
        if(!empty($user["vps"])) {
            $vps = $user["vps"];
        } else {
            $vps = getvps($vid);
        }
        if(!empty($vps)) {
            $ret["limit"] = $vps["ram"];
            $ret["guaranteed"] = $vps["ram"];
            $ret["swap"] = $vps["swap"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function disk($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            $vps = $user["vps"];
            $ret["limit"] = $user["vps"]["space"] * 1024;
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["space"] * 1024;
        }
        if(!empty($vps["cached_disk"]["disk"]["Used"])) {
            $ret["used"] = $vps["cached_disk"]["disk"]["Used"] / 1024;
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["limit_gb"] = $ret["limit"] / 1024;
        $ret["used_gb"] = $ret["used"] / 1024;
        $ret["free_gb"] = $ret["limit_gb"] - $ret["used_gb"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function inodes($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            $vps = $user["vps"];
            $ret["limit"] = $user["vps"]["inodes"];
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["inodes"];
        }
        if(empty($ret["limit"]) && !empty($vps["cached_disk"]["inode"]["Inodes"])) {
            $ret["limit"] = $vps["cached_disk"]["inode"]["Inodes"];
        }
        if(!empty($vps["cached_disk"]["inode"]["IUsed"])) {
            $ret["used"] = $vps["cached_disk"]["inode"]["IUsed"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function network_speed($vid, $dev1 = [], $dev2 = [])
    {
        $vps = getvps($vid);
        $ret["speed"] = 0;
        $ret["upload"] = 0;
        $ret["download"] = 0;
        $value = $this->_network_usage($vid, $dev1);
        if(empty($value["in"]) && empty($value["out"])) {
        } else {
            if(empty($dev2)) {
                usleep(1000000);
            }
            $value2 = $this->_network_usage($vid, $dev2);
        }
        if($value2["in"] < $value["in"]) {
            $value2["in"] = $value["in"];
            $value2["out"] = $value["out"];
        }
        $ret["download"] = $value2["in"] - $value["in"];
        $ret["upload"] = $value2["out"] - $value["out"];
        $ret["speed"] = $ret["upload"] + $ret["download"];
        return $ret;
    }
    public function status($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            vexec(VXM . " list", $output);
            unset($output[0]);
            foreach ($output as $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                $vid = array_search($v[0], $vs);
                if(!empty($vid) && !preg_match("/p/is", $v[4])) {
                    $this->status[$vid] = 1;
                    $on[$vid] = 1;
                }
            }
        }
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = !empty($on[$k]) ? 1 : 0;
            } else {
                $ret[$k] = !empty($this->status[$k]) ? 1 : 0;
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function vps_status_statewise($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status_statewise[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            vexec(VXM . " list", $output);
            unset($output[0]);
            foreach ($output as $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                $vid = array_search($v[0], $vs);
                if(!empty($vid) && !preg_match("/p/is", $v[4])) {
                    $this->status_statewise[$vid] = 1;
                    $on[$vid] = 1;
                } else {
                    $this->status_statewise[$vid] = 2;
                    $on[$vid] = 2;
                }
            }
        }
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = $on[$k] == 1 ? 1 : ($on[$k] == 2 ? 2 : 0);
            } else {
                $ret[$k] = $this->status_statewise[$k] == 1 ? 1 : ($this->status_statewise[$k] == 2 ? 2 : 0);
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function uptime($vid)
    {
        return false;
    }
    public function services($vid)
    {
        $services = [];
        return $services;
    }
    public function startservice($vid, $ser)
    {
        return true;
    }
    public function restartservice($vid, $ser)
    {
        return true;
    }
    public function stopservice($vid, $ser)
    {
        return true;
    }
    public function listautoservices($vid)
    {
        $services = [];
        return $services;
    }
    public function killprocess($vid, $pid)
    {
        return true;
    }
    public function install_cp($vid, $cp, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("install_cp", $cp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "install_cp", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "install_cp", [$cp]);
    }
    public function install_recipe($vid, $recipe, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $recipe_data = serialize($recipe);
            $actid = vps_task("install_recipe", $recipe_data, 0, $vid, $user["uid"], 0, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "install_recipe", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "install_recipe", $recipe);
    }
    public function change_winips($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("change_winips", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["change_onboot"], 57);
        perform_vps_operation($vid, 0, "config_network", ["config_network" => ["pub" => $this->getmac($vid), "int" => $this->getmac($vid)]]);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vscpu($ids, $speed = 1000000, $times = 2)
    {
        $vs_status = $this->status($ids);
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        $vpsnames = [];
        $usage = [];
        $cpu_usage = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpsnames[$row["vps_name"]] = $row["vpsid"];
            $usage[$row["vpsid"]] = 0;
        }
        $cpu_usage = $this->_cpu_stats();
        foreach ($vpsnames as $key => $val) {
            if($vs_status[$val] !== 0 && array_key_exists($key, $cpu_usage)) {
                $usage[$val] = $cpu_usage[$key]["cpu"];
            } else {
                $usage[$val] = 0;
            }
        }
        return $usage;
    }
    public function vsram($ids)
    {
        $free_ram = 0;
        $ram[0]["used"] = 0;
        $ram[0]["ram"] = 0;
        vexec("/usr/bin/free -m", $output, $return);
        if(!empty($output[2])) {
            preg_match("/(\\d+)(.*?)(\\d+)/is", $output[2], $tmp);
            if(!empty($tmp[1])) {
                $ret["used"] = (double) trim($tmp[1]);
            }
            if(!empty($tmp[3])) {
                $ret["limit"] = (double) (trim($tmp[3]) + $ret["used"]);
            }
        }
        $ram[-1]["used"] = (int) $ret["used"];
        $ram[-1]["ram"] = (int) $ret["limit"];
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        $output = [];
        vexec(VXM . " list", $output);
        unset($output[0]);
        foreach ($output as $v) {
            $v = preg_split("/[\\s]+/", trim($v));
            if($v[0] == $vps_name) {
                $this->status[$vid] = 1;
            }
        }
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $status = 0;
            foreach ($output as $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                if($v[0] == $row["vps_name"]) {
                    $status = 1;
                }
            }
            if($status != 1) {
                $row["ram"] = 0;
            }
            $ram[$row["vpsid"]]["used"] = $row["ram"];
            $ram[$row["vpsid"]]["label"] = "VPS : " . $row["vps_name"];
            $ram[$row["vpsid"]]["ram"] = $row["ram"];
        }
        vexec(VXM . " info | grep -i _memory", $output, $return);
        foreach ($output as $k => $v) {
            $tmp = explode(":", $v);
            if(trim($tmp[0]) == "total_memory") {
                $ret["total_ram"] = (double) trim($tmp[1]);
            }
            if(trim($tmp[0]) == "free_memory") {
                $ret["free_ram"] = (double) trim($tmp[1]);
            }
        }
        $free_ram = $ret["total_ram"] - $ret["free_ram"];
        $ram[0]["used"] = (int) $free_ram;
        $ram[0]["ram"] = (int) $ret["total_ram"];
        return $ram;
    }
    public function backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit)
    {
        global $globals;
        global $error;
        global $l;
        if(!empty($vps["hvm"])) {
            return $this->hvm_backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit);
        }
        $append = empty($disk_num) ? "" : "_" . $disk_num;
        $append .= "_" . parse_backup_hostname($vps["hostname"]);
        $compression = get_compression_algo(0, 1);
        $final_backup = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . $compression["file_ext"];
        $DISK = vpsdisk_snapshot_create($vps["vpsid"], "backup-" . $vps["vps_name"], $disk_num);
        if(empty($DISK)) {
            $error[] = $l["temp_snap_err"];
            return false;
        }
        $mount = mount_snapshot($DISK);
        if(!is_array($mount)) {
            $error[] = $l["xen_err_mount"];
            return false;
        }
        $throttle_block_size = get_throttle_block_size();
        $ret = vexec("cd " . xss($mount["mount_point"]) . "; /bin/tar " . $compression["compression_algo"] . " - * " . (empty($io_limit) ? "" : "| throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " > " . xss($temp_backup_dir . "/" . $final_backup));
        if($ret != "0") {
            $error[] = $l["xen_err_tar"];
            return false;
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            return false;
        }
        $snapshot_delete = vpsdisk_snapshot_delete($DISK);
        if(!empty($snapshot_delete)) {
            $error = merge_error($error, $snapshot_delete);
            return false;
        }
        if(@vfilesize($temp_backup_dir . "/" . $final_backup) < 1 || !store_backup_inf($vps, $temp_backup_dir)) {
            return false;
        }
        return $final_backup;
    }
    public function hvm_backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit)
    {
        global $globals;
        global $error;
        global $l;
        $append = empty($disk_num) ? "" : "_" . $disk_num;
        $append .= "_" . parse_backup_hostname($vps["hostname"]);
        $compression = get_compression_algo(1, 0);
        $compressed_backup = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . $compression["file_ext"];
        $uncompressed_backup = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . ".img";
        $DISK = vpsdisk_snapshot_create($vps["vpsid"], "backup-" . $vps["vps_name"], $disk_num);
        if(empty($DISK)) {
            $error[] = $l["temp_snap_err"];
            return false;
        }
        $sparse = "";
        if(preg_match("/thin block/i", $DISK["type"])) {
            $sparse = "conv=sparse";
        }
        $throttle_block_size = get_throttle_block_size();
        if(empty($disable_compress)) {
            $ret = vexec("/bin/dd if=" . xss($DISK["snapshot_path"]) . " bs=24M " . (!empty($globals["disable_dd_flags"]) ? "" : "iflag=direct ") . " | " . $compression["compression_algo"] . " " . (empty($io_limit) ? "" : "| throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " | dd " . $sparse . " of=" . xss($temp_backup_dir . "/" . $compressed_backup) . " bs=24M 2>&1;");
            $ret_backup_filename = $compressed_backup;
        } else {
            $ret = vexec("/bin/dd if=" . xss($DISK["snapshot_path"]) . " bs=24M " . (!empty($globals["disable_dd_flags"]) ? "" : "iflag=direct ") . (empty($io_limit) ? "" : " | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit . " | dd bs=24M ") . " " . $sparse . " of=" . xss($temp_backup_dir . "/" . $uncompressed_backup) . " 2>&1", $o, $r);
            $ret_backup_filename = $uncompressed_backup;
        }
        if($ret != 0) {
            $error["err_backup_command_fail"] = $l["err_backup_command_fail"] . $ret;
        }
        $snapshot_delete = vpsdisk_snapshot_delete($DISK);
        if(!empty($snapshot_delete)) {
            $error = merge_error($error, $snapshot_delete);
            return false;
        }
        if(!empty($error)) {
            return false;
        }
        if(@vfilesize($temp_backup_dir . "/" . $ret_backup_filename) < 1 || !store_backup_inf($vps, $temp_backup_dir)) {
            return false;
        }
        return $ret_backup_filename;
    }
    public function restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit, $storagename = "")
    {
        global $globals;
        global $error;
        global $l;
        $last_actid = $GLOBALS["current_taskid"];
        $this->poweroff($vps["vpsid"]);
        $GLOBALS["current_taskid"] = $last_actid;
        if(!empty($vps["hvm"])) {
            return $this->hvm_restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit);
        }
        $DISK = get_vps_disk($vps["vpsid"], "", $disk_num);
        vexec("/sbin/mkfs -t ext3 " . xss($DISK["path"]));
        vexec("/sbin/e2fsck -f -y " . xss($DISK["path"]));
        $mount = mount_direct($vps["vpsid"]);
        if(!is_array($mount)) {
            $error[] = $l["xen_err_mount"];
            return false;
        }
        $uncompression = get_decompression_algo($backup_filename, 0, 1);
        if(!empty($uncompression["compression_algo"])) {
            $ret = vexec("cd " . xss($mount["mount_point"]) . "; " . $uncompression["compression_algo"] . " " . $uncompression["params"] . " < " . xss($temp_restore_dir . "/" . $backup_filename) . " | tar -xf - ");
        } else {
            $ret = vexec("/bin/tar -xzf " . xss($temp_restore_dir . "/" . $backup_filename) . " " . (preg_match("/thin block/i", $DISK["type"]) ? "-S" : "") . " -C " . xss($mount["mount_point"]));
        }
        if($ret != "0") {
            $error[] = $l["backup_err_untar"];
            return false;
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            return false;
        }
        return true;
    }
    public function hvm_restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit)
    {
        global $globals;
        global $error;
        global $l;
        $DISK = get_vps_disk($vps["vpsid"], "", $disk_num);
        $sparse = "";
        if(preg_match("/thin block/i", $DISK["type"])) {
            $sparse = "conv=sparse";
        }
        $throttle_block_size = get_throttle_block_size();
        $uncompression = get_decompression_algo($backup_filename, 1, 0);
        if(!empty($uncompression["compression_algo"])) {
            vexec($uncompression["compression_algo"] . " " . $uncompression["params"] . " " . xss($temp_restore_dir . "/" . $backup_filename) . (empty($io_limit) ? "" : " | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " | dd " . $sparse . " of=" . xss($DISK["path"]) . " bs=24M 2>&1", $o, $ret);
        } else {
            vexec("/bin/dd " . $sparse . " if=" . xss($temp_restore_dir . "/" . $backup_filename) . (empty($io_limit) ? "" : " bs=24M | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit . " | dd") . " of=" . xss($DISK["path"]) . " bs=24M 2>&1", $o, $ret);
        }
        if($ret != "0") {
            $error[] = $l["xen_err_dd"];
            return false;
        }
        return true;
    }
    public function vncDetails($vid)
    {
        global $globals;
        $vps = getvps($vid);
        if(!empty($vps["hvm"])) {
            return $this->hvm_vncDetails($vid, $vps);
        }
        $vps_name = $vps["vps_name"];
        $port = 0;
        $conf = file("/etc/xen/auto/" . $vps_name . ".cfg");
        foreach ($conf as $k => $v) {
            if(preg_match("/vncdisplay(\\s*?)=(\\s*?)(\\d.*)/", $v, $match)) {
                $match[3] = str_replace(["\"", "'"], "", $match[3]);
                $port = (int) $match[3];
            }
            if(preg_match("/vncpasswd(\\s*?)\\=(\\s*?)(\\w*)(\\,|'|\")/is", $v, $passtmp)) {
                $vncpass = $passtmp[3];
            }
        }
        $info["port"] = 5900 + $port;
        $info["ip"] = server_vncip($vps["serid"]);
        $info["password"] = $vncpass;
        return $info;
    }
    public function hvm_vncDetails($vid, $vps)
    {
        global $globals;
        $vps_name = $vps["vps_name"];
        $port = 0;
        $conf = file("/etc/xen/auto/" . $vps_name . ".cfg");
        foreach ($conf as $k => $v) {
            if(preg_match("/vncdisplay(\\s*?)=(\\s*?)(\\d.*)/", $v, $match)) {
                $match[3] = str_replace(["\"", "'"], "", $match[3]);
                $port = (int) $match[3];
            }
            if(preg_match("/vncpasswd(\\s*?)\\=(\\s*?)('|\")(\\w*)('|\")/is", $v, $passtmp)) {
                $vncpass = $passtmp[4];
            }
        }
        $info["port"] = 5900 + $port;
        $info["ip"] = server_vncip($vps["serid"]);
        $info["password"] = $vncpass;
        return $info;
    }
    public function changeVncPass($vid, $newpassword)
    {
        global $globals;
        $vps = getvps($vid);
        if(!empty($vps["hvm"])) {
            return $this->hvm_changeVncPass($vid, $newpassword, $vps);
        }
        $vps_name = $vps["vps_name"];
        $vncdetails = $this->vncDetails($vid);
        $conf = file("/etc/xen/auto/" . $vps_name . ".cfg");
        foreach ($conf as $k => $v) {
            if(preg_match("/vncpasswd(\\s*?)\\=(\\s*?)(\\w*)(\\,|'|\")/is", $v)) {
                $conf[$k] = preg_replace("/vncpasswd(\\s*?)\\=(\\s*?)(\\w*)(\\,|'|\")/is", "vncpasswd=" . $newpassword . "\$4", $v);
                $done = true;
            }
        }
        if(empty($done)) {
            $vncport = $vncdetails["port"];
            $conf[] = (empty($vps["vnc"]) ? "#" : "") . "vfb = [\"type=vnc,vncdisplay=" . $vncport . ",vnclisten=" . server_vncip($vps["serid"]) . ",vncpasswd=" . $newpassword . "\"]" . "\n";
        }
        writefile("/etc/xen/auto/" . $vps_name . ".cfg", implode("", $conf), 1);
        return true;
    }
    public function hvm_changeVncPass($vid, $newpassword, $vps)
    {
        global $globals;
        $vps_name = $vps["vps_name"];
        $conf = file("/etc/xen/auto/" . $vps_name . ".cfg");
        foreach ($conf as $k => $v) {
            if(preg_match("/(\\#?)(\\s*?)vncpasswd(\\s*?)=(\\s*?)('|\")(.*?)('|\")/is", $v)) {
                $conf[$k] = "vncpasswd = \"" . $newpassword . "\"" . "\n";
                $done = true;
            }
        }
        if(empty($done)) {
            $conf[] = "vncpasswd = \"" . $newpassword . "\"" . "\n";
        }
        writefile("/etc/xen/auto/" . $vps_name . ".cfg", implode("", $conf), 1);
        return true;
    }
    public function suspendvps($vpsid)
    {
        global $l;
        if($this->vps_status_statewise($vpsid, 1) == 2 || $this->vps_status_statewise($vpsid, 1) == 0) {
            return true;
        }
        $actid = vps_task("suspend_vps", "", 0, $vpsid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        $vps_name = $this->getname($vpsid);
        if($this->vps_status_statewise($vpsid, 1) == 0) {
            $this->start($vpsid);
        }
        vexec(VXM . " pause " . xss($vps_name), $output, $ret);
        if($ret == "0") {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["suspend_error"], -1);
        return false;
    }
    public function unsuspendvps($vpsid)
    {
        global $l;
        $vps_name = $this->getname($vpsid);
        file_put_contents(logdir("unsuspend") . $vpsid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        $actid = vps_task("unsuspend_vps", "", 0, $vpsid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        vexec(VXM . " unpause " . xss($vps_name), $output, $ret);
        if($ret == "0") {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["unsuspend_error"], -1);
        return false;
    }
    public function suspend_vps_net($vid)
    {
        $vps_name = $this->getname($vid);
        $vifName = $this->vifname($vid);
        vexec("ifconfig " . xss($vifName) . " down", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function unsuspend_vps_net($vid)
    {
        $vifName = $this->vifname($vid);
        file_put_contents(logdir("nw_unsuspend") . $vid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        vexec("ifconfig " . xss($vifName) . " up", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function vps_net_status($vpsid)
    {
        $vifName = $this->vifname($vpsid);
        $value = 0;
        if(!empty($vpsid)) {
            vexec("ifconfig", $output, $ret);
            $output = implode("\n", $output);
            $value = preg_match("/" . $vifName . "/is", $output) ? 1 : 0;
        }
        return $value;
    }
    public function createtemplate($vid, $name)
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vid);
        if(!empty($vps["hvm"])) {
            return $this->hvm_createtemplate($vid, $name, $vps);
        }
        $path = $globals["xenos"] . "/" . $name . ".tar.gz";
        if(file_exists($path)) {
            $error[] = $l["temp_exists"];
            return false;
        }
        $DISK = vpsdisk_snapshot_create($vid, "template-" . $vps["vps_name"]);
        if(empty($DISK)) {
            $error[] = $l["temp_snap_err"];
            return false;
        }
        $mount = mount_snapshot($DISK);
        if(!is_array($mount)) {
            if($mount == -1) {
                return true;
            }
            return false;
        }
        vexec("cd " . xss($mount["mount_point"]) . "; /bin/tar -pzcf " . xss($path) . " *");
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            return false;
        }
        $snapshot_delete = vpsdisk_snapshot_delete($DISK);
        if(!empty($snapshot_delete)) {
            $error = merge_error($error, $snapshot_delete);
            return false;
        }
        if(@vfilesize($path) < 1) {
            return false;
        }
        return $name . ".tar.gz";
    }
    public function hvm_createtemplate($vid, $name, $vps)
    {
        global $globals;
        global $error;
        global $l;
        $path = $globals["xenos"] . "/" . $name . ".img";
        if(file_exists($path)) {
            $error[] = $l["temp_exists"];
            return false;
        }
        $DISK = vpsdisk_snapshot_create($vid, "template-" . $vps["vps_name"]);
        if(empty($DISK)) {
            $error[] = $l["temp_snap_err"];
            return false;
        }
        vexec("/bin/dd if=" . xss($DISK["snapshot_path"]) . " of=" . xss($path) . " bs=24M 2>&1");
        $snapshot_delete = vpsdisk_snapshot_delete($DISK);
        if(!empty($snapshot_delete)) {
            $error = merge_error($error, $snapshot_delete);
            return false;
        }
        if(@vfilesize($path) < 1) {
            return false;
        }
        return $name . ".img";
    }
    public function check_kernel()
    {
        global $l;
        global $globals;
        oexec("uname -r", $uname);
        if(@preg_match("/xen/is", $uname)) {
            return true;
        }
        if($globals["distro"] == "ubuntu") {
            oexec(VXM . " info", $xm);
            if(!preg_match("/xen_major/is", $xm)) {
                return $l["wrong_xm"];
            }
            return true;
        }
        if(file_exists("/etc/redhat-release")) {
            oexec(VXM . " info", $xm);
            $release = file_get_contents("/etc/redhat-release");
            if(preg_match("/release (6|7)/is", $release) && preg_match("/xen_major/is", $xm)) {
                oexec("/sbin/ifconfig", $viif);
                if(@preg_match("/" . $globals["bridge"] . "/is", $viif)) {
                    return true;
                }
                return $l["kvm_network"];
            }
            return $l["wrong_kernel"] . "<b>" . $uname . "</b>." . $l["correct_kernel"];
        }
        return $l["wrong_kernel"] . "<b>" . $uname . "</b>." . $l["correct_kernel"];
    }
    public function resources()
    {
        global $globals;
        $ret["licnumvs"] = $globals["licnumvs"];
        $ret["ram"] = 0;
        $ret["space"] = 0;
        $ret["total_ram"] = 0;
        $ret["total_space"] = 0;
        $ret["check_kernel"] = $this->check_kernel();
        $ret["lv"] = $globals["lv"];
        $ret["thin_lv"] = $globals["thin_lv"];
        $ret["disk_path"] = $globals["disk_path"];
        vexec(VXM . " info | grep -i _memory", $output, $return);
        foreach ($output as $k => $v) {
            $tmp = explode(":", $v);
            if(trim($tmp[0]) == "total_memory") {
                $ret["total_ram"] = (double) trim($tmp[1]);
            }
            if(trim($tmp[0]) == "free_memory") {
                $ret["ram"] = (double) trim($tmp[1]);
            }
        }
        if(!empty($globals["disk_path"])) {
            vexec("df " . xss($globals["disk_path"]), $disk);
            if(!empty($disk[1])) {
                $tmp = preg_split("/[\\s]+/", trim($disk[1]));
                $free_Kblocks = (double) trim($tmp[3]);
                $one_Kblocks = (double) trim($tmp[1]);
                $ret["total_space"] = @round($one_Kblocks / 1024 / 1024, 2);
                $ret["space"] = @round($free_Kblocks / 1024 / 1024, 2);
            }
        } elseif(!empty($globals["thin_lv"])) {
            vexec("lvdisplay -C --nosuffix --units k \"/dev/" . $globals["lv"] . "/" . $globals["thin_lv"] . "\"", $disk);
            if(!empty($disk[1])) {
                $tmp = preg_split("/[\\s]+/", trim($disk[1]));
                $used_percentage = (double) trim($tmp[4]);
                $free_percentage = 100 - $used_percentage;
                $total_space_kb = (double) trim($tmp[3]);
                $ret["total_space"] = @round($total_space_kb / 1024 / 1024, 2);
                $ret["space"] = @round($total_space_kb * $free_percentage / 100 / 1024 / 1024, 2);
            }
        } elseif(!empty($globals["lv"])) {
            vexec($globals["com"]["vgdisplay"] . " -C --nosuffix --units k \"" . $globals["lv"] . "\"", $disk);
            if(!empty($disk[1])) {
                $tmp = explode(" ", $disk[1]);
                $ret["space"] = @round((double) @trim($tmp[@count($tmp) - 1]) / 1024 / 1024, 2);
                $ret["total_space"] = @round((double) @trim($tmp[@count($tmp) - 2]) / 1024 / 1024, 2);
            }
        }
        if(preg_match("/xen/is", $globals["kernel"])) {
            vexec(VXM . " info | grep hvm", $ishvm);
            if(!empty($ishvm) && 0 < count($ishvm)) {
                $ret["hvm"] = 1;
            }
        }
        $ret["cpucores"] = $this->get_cores();
        return $ret;
    }
    public function getmac($vpsid)
    {
        $vps = getvps($vpsid);
        $cfg = "/etc/xen/auto/" . $vps["vps_name"] . ".cfg";
        $data = file($cfg);
        foreach ($data as $line) {
            if(preg_match("/mac=/is", $line)) {
                virt_preg_replace("/mac(\"|\\=|')(.*?)(\"|\\,|\\\"|')/is", $line, $rest, 2);
            }
        }
        return $rest;
    }
    public function change_mac_address($vpsid, $mac_address)
    {
        $vps = getvps($vpsid);
        $cfg = "/etc/xen/auto/" . $vps["vps_name"] . ".cfg";
        $data = file($cfg);
        foreach ($data as $line) {
            if(preg_match("/\\bmac=/is", $line)) {
                $rest = "/" . substr($line, strpos($line, "mac=") + 4, 17) . "/";
            }
        }
        $buff = preg_replace($rest, $mac_address, implode("", $data));
        writefile($cfg, $buff, 1);
        return true;
    }
    public function poweroff($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("poweroff_vps", "", 0, $vid, $vps["uid"], 0, $l["power_off_vps"]);
        task_start($actid);
        task_update($actid, $l["power_off_vps"], 57);
        $status = $this->vps_status_statewise($vid);
        if($status == 2) {
            return false;
        }
        $vps_name = $this->getname($vid);
        oexec(VXM . " destroy " . xss($vps_name), $output);
        writefile(logdir("poweroff") . $vid . ".log", $output, 1);
        task_update($actid, $l["power_off_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function cron()
    {
        global $globals;
        global $l;
        global $kernel;
        $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_1";
        $vpses = get_bw_vps("xen");
        $dev1 = file("/proc/net/dev");
        usleep(1000000);
        $dev2 = file("/proc/net/dev");
        $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_2";
        $cpu_usage = $this->_cpu_stats();
        $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_3";
        $status = $this->vps_status_statewise(array_keys($vpses));
        $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_4";
        $node_cores = get_cores();
        $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_5";
        $io_usage = $this->get_io_usage();
        foreach ($vpses as $k => $v) {
            if(!empty($globals["cb_bandwidth_overusage"]) && !empty($vpses[$k]["bandwidth"]) && $vpses[$k]["bandwidth"] < $vpses[$k]["used_bandwidth"]) {
                $callback["act"][] = "bandwidth_overusage";
                $callback["data"]["email"] = $vpses[$k]["email"];
                $callback["data"]["overused"] = $vpses[$k]["used_bandwidth"] - $vpses[$k]["bandwidth"];
                $service_period = get_vps_service_period($k);
                $before = $service_period["end"] - 480;
                $current = time();
                if($before < $current && $current <= $service_period["end"]) {
                    vps_task("bandwidth_overusage_callback", serialize($callback), 0, $k, $vpses[$k]["uid"], 0, $l["task_pending"]);
                }
            }
            $vpses[$k]["status"] = $status[$k];
            $vpses[$k]["cpu"] = $node_cores / $v["cores"] * $cpu_usage[$v["vps_name"]]["cpu"];
            if(100 < $vpses[$k]["cpu"]) {
                $vpses[$k]["cpu"] = 100;
            }
            $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_6";
            $vpses[$k]["net_speed"] = $this->network_speed($k, $dev1, $dev2);
            $vpses[$k]["disk"] = 0;
            $vpses[$k]["inode"] = 0;
            if(!empty($v["cached_disk"])) {
                $temp_disk = unserialize($v["cached_disk"]);
                $vpses[$k]["disk"] = $temp_disk["disk"]["Used"] / 1024;
                $vpses[$k]["inode"] = $temp_disk["inode"]["IUsed"];
            }
            makequery("INSERT INTO status SET\n\t\t\t\t\t\t`vpsid` = :vpsid, \n\t\t\t\t\t\t`time` = :time,\n\t\t\t\t\t\t`status` = :status,\n\t\t\t\t\t\t`disk` = :disk,\n\t\t\t\t\t\t`inode` = :inode,\n\t\t\t\t\t\t`ram` = :ram,\n\t\t\t\t\t\t`cpu` = :cpu,\n\t\t\t\t\t\t`actual_cpu` = :actual_cpu,\n\t\t\t\t\t\t`net_in` = :net_in,\n\t\t\t\t\t\t`net_out` = :net_out,\n\t\t\t\t\t\t`io_read` = :io_read,\n\t\t\t\t\t\t`io_write` = :io_write", [":vpsid" => $v["vpsid"], ":time" => $globals["cron_timestamp"], ":status" => $vpses[$k]["status"], ":disk" => $vpses[$k]["disk"], ":inode" => $vpses[$k]["inode"], ":ram" => 0, ":cpu" => $vpses[$k]["cpu"], ":actual_cpu" => $cpu_usage[$v["vps_name"]]["cpu"], ":net_in" => $vpses[$k]["net_speed"]["download"], ":net_out" => $vpses[$k]["net_speed"]["upload"], ":io_read" => $io_usage[$k]["read"], ":io_write" => $io_usage[$k]["write"]]);
            $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_7";
            $vpses[$k]["net_status"] = $this->vps_net_status($k);
            if(!empty($vpses[$k]["suspended"]) && $vpses[$k]["status"] != 2) {
                if(time() - filemtime(logdir("unsuspend") . $k . ".log") <= 60) {
                    echo "VPSID : " . $k . " was just unsuspended and we will wait for the next CRONM\n";
                } else {
                    echo "Suspending VPSID " . $k . " as it should have been suspended\n";
                    $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_8";
                    $this->suspendvps($v["vpsid"]);
                    logs_vps("suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                }
            }
            if(!empty($v["nw_suspended"])) {
                $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vpsid \n\t\t\t\t\t\tAND action = 'bandwidth_unsuspend'\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0", [":vpsid" => $v["vpsid"]]);
                $tmp_uvps = [];
                if(0 < vsql_num_rows($res)) {
                    $tmp_uvps = vsql_fetch_assoc($res);
                }
                $vs_nw_sus_dat = _unserialize($v["nw_suspended"]);
                if(!empty($tmp_uvps) && check_unsusp_vps_net($v["time"], $vs_nw_sus_dat["date"])) {
                    if($v["suspended"] == 1 && $v["suspend_reason"] == "bw") {
                        $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_9";
                        $this->unsuspendvps($v["vpsid"]);
                        $res = makequery("UPDATE vps SET \n\t\t\t\t\t\t\t\tsuspended = '0',\n\t\t\t\t\t\t\t\tsuspend_reason = ''\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        to_master("vps", "suspended", $v["vpsid"], "vpsid", "0");
                        to_master("vps", "suspend_reason", $v["vpsid"], "vpsid", "");
                    }
                    $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_10";
                    if($this->unsuspend_vps_net($v["vpsid"])) {
                        task_start($tmp_uvps["actid"]);
                        $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\tSET nw_suspended = NULL\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        logs_vps("bandwidth_unsuspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                        to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", NULL);
                        task_update($tmp_uvps["actid"], $l["completed"], 100);
                    }
                } elseif($vpses[$k]["net_status"]) {
                    if(time() - filemtime(logdir("nw_unsuspend") . $k . ".log") <= 60) {
                        echo "VPSID : " . $k . " NETWORK was just unsuspended and we will wait for the next CRONM\n";
                    } else {
                        echo "Suspending network of VPSID " . $k . " as its network should have been suspended\n";
                        $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_11";
                        $this->suspend_vps_net($v["vpsid"]);
                        logs_vps("bandwidth_suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    }
                }
            }
            $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_12";
            $bandwidth_val = $kernel->bandwidth($v["vpsid"]);
            $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_13";
            $service_period = get_vps_service_period($v["vpsid"]);
            $timestamp_threshold = @file_get_contents($globals["var"] . "/eubwthreshold/" . $v["vpsid"]);
            $used_percent_bandw = round(100 * $bandwidth_val["used_gb"] / $bandwidth_val["limit_gb"]);
            $user_threshold_bandw = $v["preferences"]["vps_bandwidth_threshold"];
            $set_threshold_bandw = !empty($user_threshold_bandw) ? $user_threshold_bandw : $globals["vps_bandwidth_threshold"];
            if($user_threshold_bandw < 0) {
                $set_threshold_bandw = 0;
            }
            if(!empty($bandwidth_val["limit_gb"]) && !empty($set_threshold_bandw) && $set_threshold_bandw < $used_percent_bandw && $timestamp_threshold < $service_period["start"]) {
                $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "vps_bandwidth_threshold" => $set_threshold_bandw, "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                if(!empty($v["email"])) {
                    send_emailtemp_mail("bandwidth_threshold", $v["email"], $email_vars, 1);
                    writefile($globals["var"] . "/eubwthreshold/" . $v["vpsid"], time(), 1);
                }
                $data["title"] = $l["bandwidth_threshold_mail_sub"];
                $data["data"] = lang_vars_name($l["bandwidth_threshold_notify"], $email_vars);
                save_notification("vps_band_thershold", $data);
            }
            if($bandwidth_val["limit_gb"] < $bandwidth_val["used_gb"] && !empty($bandwidth_val["limit_gb"]) && $v["band_suspend"] == 1 && empty($v["nw_suspended"]) && empty($globals["band_suspend"])) {
                $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_14";
                if($this->suspend_vps_net($v["vpsid"])) {
                    echo "Suspending network of VPSID " . $k . " as bandwidth has been overused. Used : " . $bandwidth_val["used_gb"] . " Allowed : " . $bandwidth_val["limit_gb"] . "\n";
                    $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                    if(!empty($v["email"]) && empty($globals["disable_suspend_email"])) {
                        send_emailtemp_mail("bandwidth", $v["email"], $email_vars, 1);
                    }
                    $data["title"] = $l["bandwidth_mail_sub"];
                    $data["data"] = lang_vars_name($l["bandwidth_mail_message_notify"], $email_vars);
                    save_notification("vps_band_suspended", $data);
                    $reason = serialize(["id" => "2", "reason" => "bw", "date" => time()]);
                    $res = makequery("UPDATE vps \n\t\t\t\t\t\t\tSET nw_suspended = :reason\n\t\t\t\t\t\t\tWHERE vpsid=:vpsid", [":vpsid" => $v["vpsid"], ":reason" => $reason]);
                    $v["nw_suspended"] = $reason;
                    vps_task("bandwidth_unsuspend", $v["vps_name"], 0, $v["vpsid"], $v["uid"], 1);
                    logs_vps("bandwidth_suspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", $reason);
                }
            }
            $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_15";
            handle_speed_cap($v, $this, $bandwidth_val);
            $GLOBALS["cronm_exit_ret"]["xen"][] = "xen_kernel_cronm_16";
        }
    }
    public function cronh()
    {
        $vps_disk_usage = get_vps_disk_usage("xen");
        foreach ($vps_disk_usage as $vpsid => $disk_usage) {
            to_master("vps", "cached_disk", $vpsid, "vpsid", serialize($disk_usage));
        }
    }
    public function create_internal_network($ippid, $bind_ip)
    {
        vexec("/sbin/ifconfig " . xss(!empty($GLOBALS["globals"]["interface"]) ? $GLOBALS["globals"]["interface"] . ":" . $ippid : "eth0:" . $ippid) . " " . xss($bind_ip) . " up");
    }
    public function destroy_internal_network($ippid)
    {
        vexec("/sbin/ifconfig " . xss(!empty($GLOBALS["globals"]["interface"]) ? $GLOBALS["globals"]["interface"] . ":" . $ippid : "eth0:" . $ippid) . " down");
    }
    public function vifname($vid)
    {
        $vps = getvps($vid);
        $found = 0;
        $vif = "vif" . $vps["vps_name"] . ".0";
        oexec(VXM . " list -l " . xss($vps["vps_name"]), $out, $ret);
        $xlvmjson = json_decode($out, 1);
        if(empty($ret) && is_array($xlvmjson) && !empty($xlvmjson[0]["config"]["nics"][0]["ifname"])) {
            $vif = $xlvmjson[0]["config"]["nics"][0]["ifname"];
            $found = 1;
        }
        if(empty($found)) {
            $cfg = "/etc/xen/auto/" . $vps["vps_name"] . ".cfg";
            $data = file($cfg);
            foreach ($data as $line) {
                if(preg_match("/vifname=/is", $line)) {
                    virt_preg_replace("/vifname(\"|\\=)(.*?)(\"|\\,|\\\")/is", $line, $rest, 2);
                }
            }
            if(empty($rest)) {
                oexec(VXM . " domid " . xss($vps["vps_name"]), $out, $ret);
                if($ret == 0) {
                    $domid = trim($out);
                    $rest = "vif" . $domid . ".0";
                }
            }
            if($vps["vif_type"] == "ioemu" && !empty($rest)) {
                $rest = $rest . "-emu";
            }
            if(!empty($rest)) {
                $vif = $rest;
                $found = 1;
            }
        }
        return $vif;
    }
    public function tc_create($vid)
    {
        $interface = $this->vifname($vid);
        return vs_tc_create($vid, $interface);
    }
    public function tc_destroy($vid)
    {
        $interface = $this->vifname($vid);
        return vs_tc_destroy($interface);
    }
    public function create_rescue_disk($vid, $root_password)
    {
        global $globals;
        global $error;
        global $l;
        oslist();
        $vps = getvps($vid, 0);
        $actid = vps_task("enable_rescuevs", "", 0, $vid, $vps["uid"], 0, $l["enable_rescuevs"]);
        task_start($actid);
        task_update($actid, $l["enabling_rescue"], 5);
        $GLOBALS["rescue"]["xen"] = $GLOBALS["ostemplates_rescue"]["xen"]["size"];
        $GLOBALS["rescue"]["xen_hvm"] = $GLOBALS["ostemplates_rescue"]["xen_hvm"]["size"];
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        if(empty($vps["rescue"])) {
            $error[] = $l["rescue_not_synced"];
            return false;
        }
        $vps_name = $vps["vps_name"];
        if(!empty($vps["hvm"])) {
            $templ_name = $GLOBALS["ostemplates_rescue"]["xen_hvm"]["file"];
            $lvsize = $GLOBALS["ostemplates_rescue"]["xen_hvm"]["disk_size"];
        } else {
            $templ_name = $GLOBALS["ostemplates_rescue"]["xen"]["file"];
            $lvsize = $GLOBALS["ostemplates_rescue"]["xen"]["disk_size"];
        }
        $type = !empty($vps["hvm"]) ? "xen_hvm" : "xen";
        if(!file_exists($globals["xenos"] . "/" . $templ_name) || filesize($globals["xenos"] . "/" . $templ_name) != $GLOBALS["rescue"][$type]) {
            task_update($actid, $l["download_rescue_temp"], 25);
            @unlink($globals["xenos"] . "/" . $templ_name);
            $getfile = save_web_file("http://files.virtualizor.com/rescue.php?file=" . $templ_name, $globals["xenos"] . "/" . $templ_name);
            if(empty($getfile) || filesize($globals["xenos"] . "/" . $templ_name) != $GLOBALS["rescue"][$type]) {
                $error[] = $l["err_downloading"];
                task_update($actid, $l["err_downloading"], -1);
                return false;
            }
        }
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $routing = $ips[0]["routing"];
        task_update($actid, $l["creating_disk"], 35);
        $storage_create = vpsdisk_create($DISK);
        if(!empty($storage_create)) {
            $error[] = $l["xen_err_lvm"];
            $error = merge_error($error, $storage_create);
            task_update($actid, $l["xen_err_lvm"], -1);
            return false;
        }
        if(!empty($vps["hvm"])) {
            task_update($actid, $l["copy_rescue"], 55);
            if(preg_match("/qcow2/is", $DISK["format"])) {
                $template_in_raw = substr($globals["xenos"] . "/" . $templ_name, 0, -3);
                if(!(file_exists($template_in_raw) && is_safe_file($template_in_raw))) {
                    vexec($globals["com"]["pgzip"] . " -dc " . xss($globals["xenos"] . "/" . $templ_name) . " > " . xss($template_in_raw), $o, $ret);
                }
                vexec("qemu-img convert -f raw -O qcow2 " . xss($template_in_raw) . " " . xss($DISK["path"]), $o, $ret);
            } elseif(preg_match("/raw/is", $DISK["format"])) {
                vexec($globals["com"]["pgzip"] . " -dc " . xss($globals["xenos"] . "/" . $templ_name) . " | /bin/dd of=" . xss($DISK["path"]) . " bs=24M 2>&1", $o, $ret);
            }
            if($ret != "0") {
                $error[] = $l["kvm_err_rescue_dd"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                vpsdisk_destroy($DISK);
                task_update($actid, $l["kvm_err_rescue_dd"], -1);
                return false;
            }
            task_update($actid, $l["resizing_disk"], 60);
            $resize = vpsdisk_resize($vid);
            if(!empty($resize["error"])) {
                $error = merge_error($error, $resize["error"]);
                task_update($actid, implode("<br>", $error), -1);
                return false;
            }
            $DISK["diskinfo"] = $resize["diskinfo"];
            task_update($actid, $l["resizing_fs"], 63);
            $fs_resize = vpsdisk_resize_filesystem($DISK);
            if(!empty($fs_resize["error"])) {
                $error = merge_error($error, $fs_resize["error"]);
                task_update($actid, implode("<br>", $error), -1);
                return false;
            }
            task_update($actid, $l["mount"], 65);
            $mount = mount($vid);
            if(!is_array($mount)) {
                $error[] = $l["xen_err_mount"];
                task_update($actid, $l["kvm_err_mount"], -1);
                return false;
            }
        } else {
            task_update($actid, $l["format_disk"], 55);
            $ret = vexec("/sbin/mkfs -t ext3 " . xss($DISK["path"]));
            if($ret != "0") {
                $error[] = $l["xen_err_mkfs"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                task_update($actid, $l["xen_err_mkfs"], -1);
                return false;
            }
            task_update($actid, $l["mount"], 65);
            $mount = mount_direct($vid);
            if(!is_array($mount)) {
                $error[] = $l["xen_err_mount"];
                task_update($actid, $l["xen_err_mount"], -1);
                return false;
            }
            task_update($actid, $l["untar_os"], 70);
            $ret = vexec("cd " . xss($mount["mount_point"]) . "; tar -zxf " . xss($globals["xenos"] . "/" . $templ_name));
            if($ret != "0") {
                $error[] = $l["xen_err_untar"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                task_update($actid, $l["xen_err_untar"], -1);
                return false;
            }
        }
        $post = [];
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            $shadow = file($mount["mount_point"] . "/etc/shadow");
            $tmp = explode(":", $shadow[0]);
            $tmp[1] = crypt($root_password);
            $shadow[0] = implode(":", $tmp);
            writefile($mount["mount_point"] . "/etc/shadow", implode("", $shadow), 1);
        }
        if(!empty($vps["dns_nameserver"])) {
            $dns = unserialize($vps["dns_nameserver"]);
            $post["dns"] = $dns;
        }
        task_update($actid, $l["net_config"], 70);
        network_configure($mount["mount_point"], $ips, $post, $routing);
        task_update($actid, $l["hostname_config"], 75);
        hostname_configure($mount["mount_point"], "rescue");
        task_update($actid, $l["sshkey_clean"], 80);
        sshkey_clean($mount["mount_point"]);
        task_update($actid, $l["umount"], 85);
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            task_update($actid, $l["xen_err_unmount"], -1);
            return false;
        }
        $this->poweroff($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "poweroff_vps");
        _task_update($actid, $l["power_off_vps"], 90, $next_actid);
        copy("/etc/xen/auto/" . $vps_name . ".cfg", "/etc/xen/auto/" . $vps_name . ".cfg.bak");
        $config = file("/etc/xen/auto/" . $vps_name . ".cfg");
        $new_config = "";
        if($globals["distro"] == "ubuntu") {
            $image_dir = "/var/lib/xen/images/ubuntu-virt";
        } else {
            $image_dir = "/boot";
        }
        $dev_r = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"];
        $_disks = [];
        $i = 1;
        if(!empty($vps["hvm"])) {
            foreach ($disks as $dk => $D) {
                $dev = $dev_r[$i];
                if(!empty($D["primary"])) {
                    $dev = "a";
                } else {
                    $i++;
                }
                $_disks[] = "\"" . $this->_disk_conf($D) . ":" . $D["path"] . ",hd" . $dev . ",w\"";
            }
            $isotype = $isopath = "";
            $isopath = iso_path($vps["uid"], $vps["iso"], $isotype);
            $_disks[] = "\"" . (empty($vps["iso"]) ? "" : "file:" . $globals[$isotype] . "/" . $isopath) . ",hd" . $dev_r[$i + 0] . ":cdrom,r\"";
            foreach ($config as $k => $line) {
                if(preg_match("/disk =/", $line)) {
                    $new_config .= "disk = [" . implode(", ", $_disks) . "]\n";
                } else {
                    $new_config .= $line;
                }
            }
        } else {
            foreach ($disks as $dk => $D) {
                $dev = "xvdb" . $i;
                if(!empty($D["primary"])) {
                    array_unshift($_disks, "\"phy:" . $D["path"] . ",xvda1,w\"");
                } else {
                    $i++;
                    $_disks[] = "\"phy:" . $D["path"] . "," . $dev . ",w\"";
                }
            }
            foreach ($config as $k => $line) {
                if(preg_match("/^kernel =/", $line)) {
                    $new_config .= "#kernel = \"" . $image_dir . "/vmlinuz-virtualizor\"\n";
                } elseif(preg_match("/^ramdisk =/", $line)) {
                    $new_config .= "#ramdisk = \"" . $image_dir . "/initrd-virtualizor.img\"\n";
                } elseif(preg_match("/^#bootloader =/", $line)) {
                    $new_config .= "bootloader = \"/usr/bin/pygrub\"\n";
                } elseif(preg_match("/\\bdisk\\b =/", $line)) {
                    $new_config .= "disk = [" . implode(", ", $_disks) . "]\n";
                } elseif(preg_match("/root =/", $line)) {
                    $new_config .= "root = \"/dev/xvda1 ro\"\n";
                } else {
                    $new_config .= $line;
                }
            }
        }
        task_update($actid, $l["written_config_file"], 93);
        writefile("/etc/xen/auto/" . $vps_name . ".cfg", $new_config, 1);
        if(!empty($vps["suspended"])) {
            return true;
        }
        $this->start($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "start_vps");
        _task_update($actid, $l["beginning_start_vps"], 95, $next_actid);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function delete_rescue_disk($vid = 0)
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vid, 0);
        $actid = vps_task("disable_rescuevs", "", 0, $vid, $vps["uid"], 0, $l["disable_rescuevs"]);
        task_start($actid);
        task_update($actid, $l["disabling_rescue"], 5);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        $this->poweroff($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "poweroff_vps");
        _task_update($actid, $l["power_off_vps"], 35, $next_actid);
        $DISK = get_vps_disk($vid);
        if(!empty($DISK["rescue"])) {
            task_update($actid, $l["delete_vpsdisks"], 45);
            $storage_destroy = vpsdisk_destroy($DISK);
            if(!empty($storage_destroy)) {
                $error = merge_error($error, $storage_destroy);
                task_update($actid, implode("<br>", $error), -1);
                return false;
            }
        }
        task_update($actid, $l["disabling_rescue"], 55);
        @unlink("/etc/xen/auto/" . $vps_name . ".cfg");
        rename("/etc/xen/auto/" . $vps_name . ".cfg.bak", "/etc/xen/auto/" . $vps_name . ".cfg");
        if(!empty($vps["suspended"])) {
            return true;
        }
        $this->start($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "start_vps");
        _task_update($actid, $l["beginning_start_vps"], 75, $next_actid);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vm_location($vids, $live = false)
    {
        return $vids;
    }
    public function _newVncPort()
    {
        $files = filelist("/etc/xen/auto/", 0);
        $vncport = 5900;
        foreach ($files as $k => $v) {
            if(!empty($v["dir"])) {
                unset($files[$k]);
            } elseif(substr($k, -3) != "cfg") {
                unset($files[$k]);
            } else {
                $conf = file_get_contents($k);
                $porttmp = [];
                if(preg_match("/vncdisplay(\\s*?)=(\\s*?)(\\d.*)/", $conf, $porttmp)) {
                    $porttmp[3] = str_replace(["\"", "'"], "", $porttmp[3]);
                    $port = (int) $porttmp[3];
                    $port = 5900 + $porttmp[3];
                    if($vncport < $port) {
                        $vncport = $port;
                    }
                }
            }
        }
        for ($i = 1; $i < 1000; $i++) {
            $vncport = $vncport + 1;
            if(vexec("lsof -i:" . $vncport) != 0) {
                break;
            }
        }
        return $vncport;
    }
    public function _disk_conf($DISK)
    {
        if(preg_match("/file/is", $DISK["type"])) {
            if(preg_match("/vhd/is", $DISK["format"])) {
                return "tap2:tapdisk:vhd";
            }
            if(preg_match("/qcow2/is", $DISK["format"])) {
                return "tap2:qcow2";
            }
            return "tap2:tapdisk:aio";
        }
        return "phy";
    }
    public function hvmtap($vpsname)
    {
        global $globals;
        $tmp = file("/etc/xen/auto/" . $vpsname . ".cfg");
        $tmp = preg_grep("/vif(\\s*?)\\=/is", $tmp);
        if(preg_match("/mac\\=(\\w{2}\\:\\w{2}\\:\\w{2}\\:\\w{2}\\:\\w{2}\\:\\w{2})/is", implode("", $tmp), $matches)) {
            $mac = trim(strtolower($matches[1]));
            vexec("/usr/sbin/brctl showmacs " . (empty($globals["xen_hvmbridge"]) ? "xenbr0" : $globals["xen_hvmbridge"]), $brctlmacs);
            unset($brctlmacs[0]);
            $macs = [];
            foreach ($brctlmacs as $k => $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                if(trim(strtolower($v[1])) == $mac) {
                    $port = $v[0];
                }
                $macs[$v[0]][] = trim(strtolower($v[1]));
            }
            if(!empty($port) && !empty($macs[$port])) {
                foreach ($macs[$port] as $k => $v) {
                    if(trim(strtolower($mac)) == $v) {
                    } else {
                        $tapmac = $v;
                    }
                }
            }
            $taps = [];
            if(!empty($tapmac)) {
                vexec("/sbin/ifconfig | grep -i " . xss($tapmac), $taps);
            }
            foreach ($taps as $k => $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                $tap = trim($v[0]);
            }
        }
        if(empty($tap)) {
            return NULL;
        }
        return $tap;
    }
    public function storage_check($data)
    {
        if($data["type"] == "block") {
            exec("vgdisplay " . xss($data["path"]) . " >> /dev/null 2>&1", $vgout, $vgret);
            if($vgret != 0) {
                return "The Volume Group doesn't exist";
            }
            return "";
        }
        if(preg_match("/ceph/is", $data["type"])) {
            exec("ceph osd lspools", $cephout, $cephret);
            foreach ($cephout as $k => $v) {
                if(preg_match("/" . basename($data["path"]) . "/is", $v)) {
                    return "";
                }
            }
            return "The Ceph Pool doesn't exist";
        } else {
            if(!preg_match("/zfs/is", $data["type"]) && preg_match("/thin/is", $data["type"]) && preg_match("/block/is", $data["type"])) {
                $size = storage_size($data["path"], $data["type"]);
                if($size["size"] < 1) {
                    return "The Thin LVM Pool doesn't exist";
                }
                return "";
            }
            if(preg_match("/zfs/is", $data["type"])) {
                exec("zfs list >> /dev/null 2>&1", $vgout, $vgret);
                if($vgret != 0) {
                    return "ZFS module is either not installed or not configured properly on this server.";
                }
                exec("zpool status " . basename($data["path"]), $out, $ret);
                if($ret != 0) {
                    return "This ZFS pool does not exist on the server.";
                }
                return "";
            }
            if(strtolower($data["type"]) == "file" && VXM != "xl") {
                return "File storage needs XL support for Xen";
            }
            if(!file_exists($data["path"])) {
                return "The storage doesn't exist";
            }
            return "";
        }
    }
    public function _network_usage($vid, $dev = [])
    {
        $vps = getvps($vid);
        if(empty($dev)) {
            $dev = file("/proc/net/dev");
        }
        $devices = [];
        foreach ($dev as $k => $x) {
            $_dev = preg_split("/[\\s]+/", str_replace(":", ": ", trim($x)));
            $_dev[0] = trim($_dev[0], ":");
            foreach ($_dev as $kk => $vv) {
                $tmp[$kk] = trim($vv);
            }
            $devices[$tmp[0]] = $tmp;
        }
        $value = $devices["vif" . $vps["vps_name"] . ".0"];
        if(empty($value[1]) && empty($value[9]) && VXM == "xl") {
            $vif_name = $this->vifname($vid);
            $value = $devices[$vif_name];
        }
        if(empty($value[1]) && empty($value[9])) {
            $value = $devices[$vps["vps_name"]];
        }
        if(empty($value[1]) && empty($value[9]) && !empty($vps["hvm"])) {
            $value = $devices["vif" . $vps["vps_name"] . ".0-emu"];
        }
        if(empty($value[1]) && empty($value[9]) && !empty($vps["hvm"])) {
            $value = $devices["tap-vif" . $vps["vps_name"] . ".0"];
        }
        if(empty($value[1]) && empty($value[9])) {
            if(!empty($vps["hvm"])) {
                $tap = $this->hvmtap($vps["vps_name"]);
                if($tap) {
                    $value = $devices[$tap];
                }
            }
            if(empty($value[1]) && empty($value[9])) {
                $value[1] = 0;
                $value[9] = 0;
            }
        }
        list($c["out"], $c["in"]) = $value;
        return $c;
    }
    public function _cpu_stats()
    {
        vexec("xentop -d 2 -i 2 -b", $tmp_out, $tmp_ret);
        $i = 0;
        foreach ($tmp_out as $tk => $tv) {
            if($i == 2) {
                $tmp_data = explode(" ", $tv);
                $final_data = [];
                foreach ($tmp_data as $tkk => $tvv) {
                    if(empty($tvv)) {
                    } else {
                        $final_data[] = $tvv;
                    }
                }
                $res["name"] = empty($final_data[0]) ? 0 : trim($final_data[0]);
                $ret[$res["name"]]["mem"] = empty($final_data[5]) ? 0 : trim($final_data[5]);
                $ret[$res["name"]]["cpu"] = empty($final_data[3]) ? 0 : trim($final_data[3]);
            }
            if(preg_match("/Domain-0/is", $tv)) {
                $i++;
            }
        }
        return $ret;
    }
    public function delete_vpsdisks($vpsid, $data, $actid = 0)
    {
        global $error;
        global $user;
        global $l;
        $status = no_log_status($vpsid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("delete_vpsdisks", $disk_data, 0, $vpsid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "delete_vpsdisks", "vpsid" => $vpsid, "actid" => $actid]);
                $disk_data = serialize($data);
                return -1;
            }
        }
        task_start($actid);
        foreach ($data as $k => $DISK) {
            $DISK["vpsid"] = $vpsid;
            $disk_destroy = vpsdisk_destroy($DISK);
            if(!empty($disk_destroy)) {
                $error = merge_error($error, $disk_destroy);
                task_update($actid, $l["disk_destroy_err"], -1);
                return false;
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vs_ntw_speed($vpsids)
    {
        $ret = [];
        $dev1 = file("/proc/net/dev");
        usleep(1000000);
        $dev2 = file("/proc/net/dev");
        foreach ($vpsids as $k => $v) {
            $ret[$v] = $this->network_speed($v, $dev1, $dev2);
        }
        return $ret;
    }
    public function vs_disk_usage($vpsids)
    {
        $ret = [];
        $res = makequery("SELECT * FROM vps WHERE vpsid IN (" . implode(",", $vpsids) . ")");
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $tmp = unserialize($row["cached_disk"]);
            $ret[$row["vpsid"]]["disk"]["used"] = empty($tmp["disk"]["Used"]) ? 0 : $tmp["disk"]["Used"] / 1024 / 1024;
            $ret[$row["vpsid"]]["disk"]["allocated"] = $row["space"];
            $ret[$row["vpsid"]]["inode"]["used"] = empty($tmp["inode"]["IUsed"]) ? 0 : $tmp["inode"]["IUsed"];
            $ret[$row["vpsid"]]["inode"]["allocated"] = empty($tmp["inode"]["Inodes"]) ? 0 : $tmp["inode"]["Inodes"];
        }
        return $ret;
    }
    public function migrate($vpsid, $data, $migrate_disk = 0)
    {
        global $globals;
        global $error;
        global $l;
        $speed = (int) (!empty($globals["default_mig_speed"]) ? $globals["default_mig_speed"] : 100);
        $sparse = 0;
        if(!empty($data["speed_limit"])) {
            $speed = $data["speed_limit"];
        }
        if(empty($data["disable_gzip"])) {
            $data["disable_gzip"] = 0;
        }
        if($data["dest_disks"][$data["disk_num"]]["type"] == "file" || $data["dest_disks"][$data["disk_num"]]["type"] == "thin block") {
            $sparse = 1;
        }
        $throttle_block_size = get_throttle_block_size();
        if(empty($migrate_disk)) {
            vexec("bash " . $globals["path"] . "/scripts/migrate_dd.sh " . $data["orig_disks"][$data["disk_num"]]["path"] . " " . $data["dest_disks"][$data["disk_num"]]["path"] . " " . $speed . " " . $data["to_ssh_port"] . " " . $data["to_ip"] . " " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log " . logdir($data["selected_act"]) . $data["vpsid"] . "-actual_transfer.log " . $data["disable_gzip"] . " " . $sparse . " " . xss($data["from_pgzip"]) . " " . xss($data["to_pgzip"]) . " " . xss($throttle_block_size) . " > " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $r);
        } else {
            $qcow2_to_raw = $raw_to_qcow2 = 0;
            if($data["dest_disks"][$data["disk_num"]]["qcow2_to_raw"]) {
                $qcow2_to_raw = 1;
            }
            if($data["dest_disks"][$data["disk_num"]]["raw_to_qcow2"]) {
                $raw_to_qcow2 = 1;
            }
            vexec("bash " . $globals["path"] . "/scripts/migrate_disk_dd.sh " . $data["orig_disks"][$data["disk_num"]]["path"] . " " . $data["dest_disks"][$data["disk_num"]]["path"] . " " . $speed . " " . logdir("migrate_disk") . $data["vpsid"] . "-transfer.log " . logdir("migrate_disk") . $data["vpsid"] . "-actual_transfer.log " . $data["disable_gzip"] . " " . $sparse . " " . xss($data["to_pgzip"]) . " " . $throttle_block_size . " " . $qcow2_to_raw . " " . $raw_to_qcow2 . " > " . logdir("migrate_disk") . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $r);
        }
        if($r != 0) {
            $error[] = $l["mig_err_bg_exec"];
            return false;
        }
        return true;
    }
    public function get_vps_bridge($vpsid)
    {
        $ret = [];
        if(empty($vpsid)) {
            return $ret;
        }
        $ips = [];
        $res = makequery("SELECT i.ippid, ip.ippid, ip.bridge, ip.ovs_bridge FROM `ips` \n\t\t\t\t\t\ti LEFT JOIN ippool ip ON (ip.ippid = i.ippid) WHERE i.vpsid = :vid \n\t\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vpsid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(!empty($row["bridge"])) {
                $ips[$row["bridge"]] = trim($row["bridge"]);
            }
        }
        if(!empty($ips)) {
            foreach ($ips as $k => $v) {
                oexec("/sbin/ifconfig " . $v . " 2>&1", $out, $return);
                if($return != "0") {
                    $ret[$v] = $v;
                }
            }
        }
        return $ret;
    }
    public function get_cores()
    {
        global $globals;
        vexec(VXM . " info | grep nr_cpus", $output, $ret);
        $cpu = explode(":", trim($output[0]));
        return (int) trim($cpu[1]);
    }
    public function migrate_disk_used($vpsid)
    {
        global $globals;
        global $error;
        $vps = getvps($vpsid);
        $ret = [];
        foreach ($vps["disks"] as $k => $DISK) {
            if(empty($vps["hvm"]) && $k == 1) {
            } else {
                $tmp_disk_size = vpsdisk_real_size($DISK);
                $ret[$k] = $tmp_disk_size / 1024 / 1024;
            }
        }
        return $ret;
    }
    public function addsshkeys($vid, $ssh_keys, $actid = 0)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("addsshkeys", serialize($ssh_keys), 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "addsshkeys", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10);
        if(!empty($vps["hvm"])) {
            $mount = mount($vid);
        } else {
            $mount = mount_direct($vid);
        }
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return false;
            }
            task_update($actid, $l["xen_err_mount"], -1);
            return false;
        }
        if(!addsshkeys($mount["mount_point"], $ssh_keys)) {
            $error[] = $l["err_add_sshkeys"];
            task_update($actid, $l["err_add_sshkeys"], -1);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            task_update($actid, $l["xen_err_unmount"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function removesshkeys($vid, $keys_to_remove, $actid = 0)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("removesshkeys", serialize($keys_to_remove), 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "removesshkeys", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10);
        if(!empty($vps["hvm"])) {
            $mount = mount($vid);
        } else {
            $mount = mount_direct($vid);
        }
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return false;
            }
            task_update($actid, $l["xen_err_mount"], -1);
            return false;
        }
        if(!removesshkeys($mount["mount_point"], $keys_to_remove)) {
            $error[] = $l["err_remove_sshkeys"];
            task_update($actid, $l["err_remove_sshkeys"], -1);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xen_err_unmount"];
            task_update($actid, $l["xen_err_unmount"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function get_io_usage($vid = 0)
    {
        $delay = 3;
        $vpses = [];
        $io_usage = [];
        $token_val = [];
        $query = "SELECT vpsid, vps_name FROM vps\n\t\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\t\tAND virt = 'xen'";
        if(!empty($vid)) {
            $query .= " AND vpsid = :vid";
            $token_val[":vid"] = $vid;
        }
        $res = makequery($query, $token_val);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
            $io_usage[$row["vpsid"]] = ["read" => 0, "write" => 0];
        }
        vexec("xentop -b -d " . $delay . " -i 2 2> /dev/null", $out, $ret);
        if($ret != 0) {
            return false;
        }
        foreach ($out as $line) {
            $parts = preg_split("/\\s+/is", trim($line));
            if(count($parts) < 19) {
            } else {
                foreach ($vpses as $v) {
                    if($v["vps_name"] == $parts[0]) {
                        $vps = $v;
                        if(empty($vps)) {
                        } else {
                            $vpsid = $vps["vpsid"];
                            $io_usage[$vpsid]["read"] = $parts[16] - $io_usage[$vpsid]["read"];
                            $io_usage[$vpsid]["write"] = $parts[17] - $io_usage[$vpsid]["write"];
                        }
                    }
                }
            }
        }
        $sector_size = 512;
        foreach ($io_usage as $vpsid => $usage) {
            $io_usage[$vpsid]["read"] = round($io_usage[$vpsid]["read"] * $sector_size / $delay);
            $io_usage[$vpsid]["write"] = round($io_usage[$vpsid]["write"] * $sector_size / $delay);
        }
        return $io_usage;
    }
}

?>