<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
class xcp
{
    public $loaded = 0;
    public $status = [];
    public $status_statewise = [];
    public $forcestatus = [];
    public $type = "xcp";
    public $bandwidth_device = "peth0";
    public $user = [];
    public function __construct()
    {
        if(!empty($GLOBALS["globals"]["interface"])) {
            $this->bandwidth_device = $GLOBALS["globals"]["interface"];
        }
    }
    public function conf($vpsid, $conf_name, $virt = "")
    {
        if(in_array($conf_name, ["onboot_changepass", "onboot_hostname", "onboot_cp", "vnc_support", "vnc_store_pass", "cpu_topology", "xenserver_tools"])) {
            return true;
        }
        if(in_array($conf_name, ["build_dhcp", "change_dns", "nw_config", "mac_support", "ebtables_support"])) {
            return true;
        }
        if(in_array($conf_name, ["get_vps_DISKS", "vpsdisk_create", "vpsdisk_destroy", "vpsdisk_resize", "disks_support", "rescue_support", "vbd_plug", "vbd_unplug", "migrate_pre_create_vps", "use_dd_migrate", "vdbkpartx", "vhd_umount"])) {
            return true;
        }
        if(in_array($conf_name, ["multiple_disk_support"]) && preg_match("/hvm/", $virt)) {
            return true;
        }
        if(in_array($conf_name, ["iso_support", "win_support", "hvm_support", "perf_ops"]) && preg_match("/hvm/", $virt)) {
            return true;
        }
        if($conf_name == "vncpasslen") {
            return 8;
        }
        if($conf_name == "nic") {
            $nictypes["default"] = 1;
            $nictypes["e1000"] = 1;
            return array_keys($nictypes);
        }
        if($conf_name == "storage_types") {
            return ["block", "file", "thin block", "zfs block", "zfs thin block", "zfs block compressed", "zfs thin block compressed"];
        }
        return false;
    }
    public function get_vps_DISKS($vpsid, $disks)
    {
        $vm_uuid = $this->getVM_uuid($vpsid);
        $vbd_list = "";
        if(!empty($GLOBALS["xcp_drives"][$vpsid])) {
            $vbd_list = $GLOBALS["xcp_drives"][$vpsid]["vbd_list"];
        } else {
            oexec("xe vbd-list vm-uuid=" . $vm_uuid . " params=all", $vbd_list, $vbd_ret);
            $GLOBALS["xcp_drives"][$vpsid]["vbd_list"] = $vbd_list;
        }
        $vbd_list = explode("\n\n", $vbd_list);
        $vbds = [];
        $_vbds = [];
        $_dev = [];
        foreach ($vbd_list as $k => $v) {
            $v = trim($v);
            if(empty($v)) {
            } else {
                $xcp_data = xcp_data_parser($v);
                $__vbd = current($xcp_data);
                if(strtolower($__vbd["type"]) != "disk") {
                } else {
                    $lines = explode("\n", $v);
                    $userdevice = -2;
                    $vdi_uuid = "";
                    $vbd_uuid = "";
                    $uuid_disk = "";
                    foreach ($lines as $line) {
                        if(preg_match("/^uuid/is", $line)) {
                            $vbd_uuid = substr($line, -36);
                        }
                        if(preg_match("/vdi\\-uuid/is", $line)) {
                            $vdi_uuid = substr($line, -36);
                        }
                        if(preg_match("/userdevice/is", $line)) {
                            $userdevice = trim(substr($line, -2));
                        }
                        if(preg_match("/virtualizor\\-disk\\_uuid\\:(.*)?;/is", $line, $matches) && !empty($matches[1])) {
                            $uuid_disk = trim($matches[1]);
                        }
                        $line = trim($line);
                        if(preg_match("/^device(.*)\$/is", $line)) {
                            $alpha = trim(substr($line, -1));
                            if(!empty($alpha)) {
                                $_dev[ord($alpha) - ord("a")] = $vdi_uuid;
                            }
                        }
                    }
                    if(preg_match("/virtualizor\\-device\\-key\\:(\\s*?)([\\-\\d]{1,3})/is", $v, $matches)) {
                        $userdevice = $matches[2];
                    } else {
                        oexec("xe vbd-param-add uuid=" . $vbd_uuid . " param-name=other-config virtualizor-device-key=" . $userdevice, $vbd_param_add, $vbd_param_add_ret);
                    }
                    if(-2 < $userdevice && !empty($vdi_uuid)) {
                        $vbds[$userdevice] = $vdi_uuid;
                        $vbdUUIDs[$userdevice] = $vbd_uuid;
                    }
                    if(!empty($uuid_disk) && !empty($vdi_uuid)) {
                        $_vbds[$uuid_disk] = $vdi_uuid;
                    }
                }
            }
        }
        foreach ($disks as $k => $v) {
            $lv_prefix = "LV";
            if($v["format"] == "lv-vhd") {
                $lv_prefix = "VHD";
            }
            if(preg_match("/block/is", $v["type"])) {
                if(empty($_vbds[$v["disk_uuid"]]) && !empty($v["primary"]) && empty($v["rescue"])) {
                    $disks[$k]["path"] = dirname($v["path"]) . "/" . $lv_prefix . "-" . $vbds[0];
                } else {
                    $disks[$k]["path"] = dirname($v["path"]) . "/" . $lv_prefix . "-" . $_vbds[$v["disk_uuid"]];
                }
                if(!empty($v["rescue"]) && !empty($v["primary"]) && $k == "-1") {
                    $disks[$k]["path"] = dirname($v["path"]) . "/" . $lv_prefix . "-" . $vbds[-1];
                }
            }
            if(preg_match("/file/is", $v["type"])) {
                if(empty($_vbds[$v["disk_uuid"]]) && !empty($v["primary"])) {
                    $disks[$k]["path"] = dirname($v["path"]) . "/" . $vbds[0] . ".vhd";
                } else {
                    $disks[$k]["path"] = dirname($v["path"]) . "/" . $_vbds[$v["disk_uuid"]] . ".vhd";
                }
                if(!empty($v["rescue"]) && !empty($v["primary"]) && $k == "-1") {
                    $disks[$k]["path"] = dirname($v["path"]) . "/" . $vbds[-1] . ".vhd";
                }
            }
            $disks[$k]["uuid"] = $_vbds[$v["disk_uuid"]];
            $disks[$k]["vbd_uuid"] = $vbdUUIDs[$k];
            if((empty($v["rescue"]) || empty($v["primary"])) && empty($_vbds[$v["disk_uuid"]])) {
                if(preg_match("/file/is", $v["type"])) {
                    $disks[$k]["path"] = dirname($v["path"]) . "/" . $_dev[$k] . ".vhd";
                }
                if(preg_match("/block/is", $v["type"])) {
                    $disks[$k]["path"] = dirname($v["path"]) . "/" . $lv_prefix . "-" . $_dev[$k];
                }
            }
            if(empty($v["rescue"]) && empty($disks[$k]["uuid"])) {
                $disks[$k]["uuid"] = $_dev[$k];
            }
        }
        return $disks;
    }
    public function vpsdisk_create($vpsid, $DISK, $os_template)
    {
        global $globals;
        $return = [];
        $vid = $DISK["vpsid"];
        $vps = getvps($vid);
        $vm_uuid = $this->getVM_uuid($vid);
        $DISK["size"] = (int) $DISK["size"];
        if(preg_match("/block/is", $DISK["type"])) {
            $srpath = cleanpath(dirname($DISK["path"]));
            $sruuid = substr($srpath, strlen($srpath) - 36);
            $DISK["format"] = empty($DISK["format"]) ? "raw" : $DISK["format"];
            vexec("/usr/bin/xe vdi-create virtual-size=" . $DISK["size"] . "GiB type=user sr-uuid=" . $sruuid . " sm-config:type=" . $DISK["format"] . " " . xss("name-label=" . $this->getVDI_name_label($vid)), $vdi_uuid_out, $ret);
            if($ret != "0") {
                $return[] = $GLOBALS["l"]["xcp_err_vdi"];
                $return["derr"] = array_end($GLOBALS["logr"]);
                return $return;
            }
            vexec("vgchange -ay");
            $lv_prefix = $DISK["format"] == "vhd" ? "VHD" : "LV";
            $DISK["path"] = cleanpath(dirname($DISK["path"])) . "/" . $lv_prefix . "-" . $vdi_uuid_out[0];
        }
        if(preg_match("/file/is", $DISK["type"]) && $DISK["format"] == "vhd") {
            $srpath = cleanpath(dirname($DISK["path"]));
            $tmp_sruuid = explode("/", $srpath);
            $sruuid = end($tmp_sruuid);
            vexec("/usr/bin/xe vdi-create virtual-size=" . $DISK["size"] . "GiB type=user sr-uuid=" . $sruuid . " " . xss("name-label=" . $this->getVDI_name_label($vid)), $vdi_uuid_out, $ret);
            if($ret != "0") {
                $return[] = $GLOBALS["l"]["xcp_err_vdi"];
                $return["derr"] = array_end($GLOBALS["logr"]);
                return $return;
            }
            $DISK["path"] = cleanpath(dirname($DISK["path"])) . "/" . $vdi_uuid_out[0] . ".vhd";
        }
        if(!empty($os_template) && !defined("CREATE_DISK_MIGRATE") && !defined("DONT_DD_OS_TEMPLATE")) {
            if($DISK["format"] == "vhd" && $DISK["type"] == "file") {
                $_os_template = str_replace($globals["xcpos"], $globals["xcpos"] . "_vhd", $os_template);
                $template_name = $_os_template . ".vhd";
                if(!empty($vps["hvm"])) {
                    if(!file_exists($template_name)) {
                        @mkdir_recursive($globals["xcpos"] . "_vhd", 493);
                        copy($os_template, $_os_template);
                        vexec("cd /usr/local/virtualizor-bin/xcp/blktap2/vhd; export LD_LIBRARY_PATH=lib/; ./vhd-util convert -s 0 -t 1 -i " . $_os_template . " -o " . $_os_template . ".tmp; ./vhd-util convert -s 1 -t 2 -i " . $_os_template . ".tmp -o " . $template_name, $o, $ret);
                        unlink($_os_template . ".tmp.bak");
                    }
                } elseif(!file_exists($template_name)) {
                    @mkdir_recursive($globals["xcpos"] . "_vhd", 493);
                    vexec($globals["com"]["pgzip"] . " -dc " . $os_template . " > " . $_os_template, $o, $ret);
                    vexec("cd /usr/local/virtualizor-bin/xcp/blktap2/vhd; export LD_LIBRARY_PATH=lib/; ./vhd-util convert -s 0 -t 1 -i " . $_os_template . " -o " . $_os_template . ".tmp; ./vhd-util convert -s 1 -t 2 -i " . $_os_template . ".tmp -o " . $template_name, $o, $ret);
                    unlink($_os_template . ".tmp.bak");
                }
                copy($template_name, $DISK["path"]);
            } else {
                if($DISK["format"] == "vhd") {
                    $DISK = $this->vbd_plug($vid, $DISK);
                }
                $dd_speed_limit = "";
                if(isset($globals["dd_copy_speed"]) && 1 < $globals["dd_copy_speed"]) {
                    $throttle_block_size = get_throttle_block_size();
                    $dd_speed_limit = " bs=24M | throttle -s " . $throttle_block_size . " -w 2 -m " . (int) $globals["dd_copy_speed"] * 8 . " | dd ";
                }
                if(!empty($vps["hvm"])) {
                    vexec("/bin/dd if=\"" . $os_template . "\" " . $dd_speed_limit . " of=" . $DISK["path"] . " bs=24M 2>&1", $o, $ret);
                } else {
                    vexec($globals["com"]["pgzip"] . " -dc " . $os_template . " " . ($dd_speed_limit ? $dd_speed_limit : "| dd ") . "of=" . $DISK["path"] . " bs=24M 2>&1", $o, $ret);
                }
            }
            if($ret != "0") {
                $return[] = $GLOBALS["l"]["kvm_err_dd"];
                $return["derr"] = array_end($GLOBALS["logr"]);
                return false;
            }
        }
        if(!defined("EDIT_DISK_MIGRATE")) {
            $command = "/usr/bin/xe vbd-create bootable=" . (0 < $DISK["key"] ? "false" : "true") . " mode=RW type=Disk device=" . $this->getVBD_available_device($vid) . " vm-uuid=" . $vm_uuid . " vdi-uuid=" . $vdi_uuid_out[0];
            vexec($command, $vbd_disk_uuid_out, $ret);
            if($ret != "0") {
                $return[] = "Error creating VBD";
                $return["derr"] = array_end($GLOBALS["logr"]);
                return $return;
            }
            if(isset($DISK["key"])) {
                oexec("xe vbd-param-add uuid=" . trim($vbd_disk_uuid_out[0]) . " param-name=other-config virtualizor-device-key=" . $DISK["key"], $vbd_param_add, $vbd_param_add_ret);
            }
        } else {
            $res = makequery("SELECT * FROM `disks` WHERE \n\t\t\t\t\t\t\t\tdisk_uuid = :disk_uuid", [":disk_uuid" => $DISK["disk_uuid"]]);
            $disk_did = vsql_fetch_assoc($res);
            to_master("disks", "path", $disk_did["did"], "did", $DISK["path"]);
        }
        if(isset($DISK["disk_uuid"])) {
            oexec("xe vbd-param-add uuid=" . trim($vbd_disk_uuid_out[0]) . " param-name=other-config virtualizor-disk_uuid=" . $DISK["disk_uuid"], $vbd_param_add, $vbd_param_add_ret);
        }
        vexec("vgchange -ay");
        unset($GLOBALS["xcp_drives"][$vid]);
        return $return;
    }
    public function vpsdisk_destroy($vid, $DISK)
    {
        $vdi_uuid = $this->getVDI_uuid_from_path($DISK);
        if($DISK["format"] == "vhd") {
            $this->vbd_unplug($DISK);
        }
        oexec("/usr/bin/xe vdi-destroy uuid=" . $vdi_uuid, $output2);
        unset($GLOBALS["xcp_drives"][$vid]);
    }
    public function vpsdisk_resize($vpsid, $DISK)
    {
        $vdi_uuid = $this->getVDI_uuid_from_path($DISK);
        vexec("/usr/bin/xe vdi-resize uuid=" . $vdi_uuid . " disk-size=" . (int) $DISK["size"] . "GiB", $o, $ret);
        unset($GLOBALS["xcp_drives"][$vpsid]);
    }
    public function getVBD_available_device($vid)
    {
        global $globals;
        $vm_uuid = $this->getVM_uuid($vid);
        oexec("/usr/bin/xe vm-param-get param-name=allowed-VBD-devices uuid=" . $vm_uuid, $allowed_list, $ret);
        if(!empty($allowed_list)) {
            $list = explode(";", $allowed_list);
            $tmp = trim($list[0]);
            if(is_numeric($tmp)) {
                return $tmp;
            }
        }
        oexec("/usr/bin/xe vbd-list params=all vm-uuid=" . $vm_uuid, $_vbd_list, $ret);
        $_vbd_list = xcp_data_parser($_vbd_list);
        $userdevice = -1;
        foreach ($_vbd_list as $k => $v) {
            if($userdevice < $v["userdevice"]) {
                $userdevice = $v["userdevice"];
            }
        }
        return $userdevice + 1;
    }
    public function getVDI_name_label($vpsid)
    {
        global $globals;
        $vps = getvps($vpsid);
        return $vps["vps_name"];
    }
    public function getVDI_uuid($vid)
    {
        vexec("/usr/bin/xe vdi-list " . xss("name-label=" . $this->getVDI_name_label($vid)) . " --minimal", $uuid);
        return $uuid[0];
    }
    public function getVDI_uuid_from_path($DISK)
    {
        $path = !empty($DISK["orig_path"]) ? $DISK["orig_path"] : $DISK["path"];
        if(preg_match("/file/is", $DISK["type"]) && $DISK["format"] == "vhd") {
            return substr($path, -40, 36);
        }
        return substr($path, -36);
    }
    public function getVIF_uuid($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/bin/xe vif-list " . xss("vm-name-label=" . $vps_name) . " --minimal", $uuid);
        return $uuid[0];
    }
    public function getSR_uuid($vid)
    {
        global $globals;
        $sruuid = substr($globals["lv"], strlen($globals["lv"]) - 36);
        return $sruuid;
    }
    public function getPOOL_uuid()
    {
        vexec("/usr/bin/xe pool-list --minimal", $uuid);
        return $uuid[0];
    }
    public function getNetwork_uuid($bridgeName)
    {
        vexec("/usr/bin/xe network-list " . xss("bridge=" . $bridgeName) . " --minimal", $uuid);
        return $uuid[0];
    }
    public function getVM_uuid($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/bin/xe vm-list " . xss("name-label=" . $vps_name) . " --minimal", $uuid);
        return $uuid[0];
    }
    public function getVBD_uuid($vid)
    {
        vexec("/usr/bin/xe vbd-list vm-uuid=" . $this->getVM_uuid($vid) . " --minimal", $uuid);
        return $uuid[0];
    }
    public function getDOMU_id($vpsid)
    {
        $vid = "";
        vexec("/usr/bin/xe vm-param-get param-name=dom-id uuid=" . $this->getVM_uuid($vpsid), $output, $ret);
        $vid = $output[0];
        if(!$vid) {
            return "";
        }
        return $vid;
    }
    public function getmac($vpsid)
    {
        vexec("/usr/bin/xe vif-param-get param-name=MAC uuid=" . $this->getVIF_uuid($vpsid) . " --minimal", $output, $ret);
        return $output[0];
    }
    public function addVIF($vid, $macAdd, $bridgeName)
    {
        vexec("/usr/bin/xe vif-create mac=" . $macAdd . " network-uuid=" . $this->getNetwork_uuid($bridgeName) . " device=0 vm-uuid=" . $this->getVM_uuid($vid), $output, $ret);
    }
    public function ipspoof_remove($vid)
    {
        global $globals;
        vexec("/usr/bin/xe vif-param-set ipv4-allowed=0.0.0.0 uuid=" . $this->getVIF_uuid($vid));
        vexec("/usr/bin/xe vif-param-set ipv6-allowed=00:00:00::00:00 uuid=" . $this->getVIF_uuid($vid));
    }
    public function cd_device_check($vps_name)
    {
        vexec("/usr/bin/xe vbd-list type=CD " . xss("vm-name-label=" . $vps_name) . " --minimal", $out);
        if(!empty($out[0]) && 1 < strlen($out[0])) {
            return true;
        }
        return false;
    }
    public function new_vps_name($suggested_name = "")
    {
        global $globals;
        vexec("/usr/bin/xe vm-list params=name-label --minimal", $output, $return);
        $ret = empty($suggested_name) ? 1001 : str_replace("v", "", $suggested_name);
        $output = explode(",", $output[0]);
        foreach ($output as $v) {
            if(0 < strpos($v, "domain on host")) {
            } else {
                $v = trim($v);
                if(empty($v)) {
                } else {
                    $names[$v] = $v;
                }
            }
        }
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\tAND virt = 'xcp'\n\t\t\t\t\t\tORDER BY vps_name DESC");
        if(0 < vsql_num_rows($res)) {
            for ($x = 0; $x < vsql_num_rows($res); $x++) {
                $row = vsql_fetch_assoc($res);
                $row["vps_name"] = trim($row["vps_name"]);
                $names[$row["vps_name"]] = $row["vps_name"];
                $tmp_int = (int) $row["vps_name"];
                if($ret < $tmp_int && $tmp_int < 2000) {
                    $ret = $tmp_int + 1;
                }
            }
        }
        $x = 0;
        while ($x < 100000) {
            if(in_array("v" . $ret, $names) || in_array($ret, $names)) {
                $ret = $ret + 1;
                $x++;
                break;
            }
        }
        return "v" . $ret;
    }
    public function dom0mem($mb = 768)
    {
        if(empty($mb) || $mb < 512) {
            $mb = 768;
        }
        vexec("/opt/xensource/libexec/xen-cmdline --set-xen dom0_mem=" . $mb . "M,max:" . $mb . "M", $output, $ret);
        return $ret;
    }
    public function start($vid, &$sret = "")
    {
        global $l;
        $vps = getvps($vid);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        if($this->status($vid, 1) == 1) {
            return false;
        }
        $actid = vps_task("start_vps", "", 0, $vid, $vps["uid"], 0, $l["attempting_start_vps"]);
        task_start($actid);
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0\n\t\t\t\t\t\tORDER BY actid ASC", [":vid" => $vid]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $tasks[$row["actid"]] = $row;
            }
        }
        task_update($actid, $l["beginning_start_vps"], 5);
        vexec("vgchange -ay");
        if(!empty($tasks)) {
            foreach ($tasks as $k => $v) {
                if($v["action"] == "changepassword") {
                    _task_update($actid, $l["change_password"], 20, $v["actid"]);
                    $this->changepassword($vid, base64_decode($v["data"]), $v["actid"]);
                    logs_vps("changepassword", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "remotedesktop") {
                    _task_update($actid, $l["remotedesktop"], 22, $v["actid"]);
                    $this->remotedesktop($vid, $v["data"], $v["actid"]);
                    logs_vps("remotedesktop", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "hostname") {
                    _task_update($actid, $l["change_hostname"], 25, $v["actid"]);
                    $this->changehostname($vid, $v["data"], $v["actid"]);
                    logs_vps("hostname", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_cp") {
                    _task_update($actid, $l["install_cp"], 27, $v["actid"]);
                    $this->install_cp($vid, $v["data"], $v["actid"]);
                    logs_vps("install_cp", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "change_dnsnameserver") {
                    _task_update($actid, $l["change_dnsnameserver"], 30, $v["actid"]);
                    $this->change_dnsnameserver($v["data"], $v["actid"]);
                    logs_vps("change_dnsnameserver", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "resizevps") {
                    _task_update($actid, $l["resize_vps"], 33, $v["actid"]);
                    $this->resizevps($v["data"], $v["actid"]);
                    logs_vps("resizevps", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "editxcpvs") {
                    _task_update($actid, $l["edit_vps"], 35, $v["actid"]);
                    $this->editvps($vid, $v["actid"]);
                    logs_vps("editxcpvs", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "delete_vpsdisks") {
                    _task_update($actid, $l["delete_vpsdisks"], 37, $v["actid"]);
                    $del_data = _unserialize($v["data"]);
                    $this->delete_vpsdisks($vid, $del_data, $v["actid"]);
                    logs_vps("delete_vpsdisks", $del_data, 1, $vid, $user["uid"]);
                }
                if($v["action"] == "installxentools") {
                    _task_update($actid, $l["install_tools"], 40, $v["actid"]);
                    $this->install_xentools($vid, $v["actid"]);
                    logs_vps("installxentools", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_recipe") {
                    _task_update($actid, $l["install_recipe"], 42, $v["actid"]);
                    $recipe = _unserialize($v["data"]);
                    $this->install_recipe($vid, $recipe, $v["actid"]);
                    logs_vps("install_recipe", !array_key_exists("rid", $recipe) ? implode(", ", array_keys($recipe)) : $recipe["rid"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "addsshkeys") {
                    _task_update($actid, $l["install_recipe"], 45, $v["actid"]);
                    $ssh_keys = _unserialize($v["data"]);
                    $this->addsshkeys($vid, $ssh_keys, $v["actid"]);
                    logs_vps("addsshkeys", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "removesshkeys") {
                    _task_update($actid, $l["remove_sshkeys"], 46, $v["actid"]);
                    $ssh_keys = _unserialize($v["data"]);
                    $this->removesshkeys($vid, $ssh_keys, $v["actid"]);
                    logs_vps("removesshkeys", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "change_winips") {
                    $this->change_winips($vid, [], $v["actid"]);
                    logs_vps("change_winips", "", 1, $vid, $user["uid"]);
                }
            }
        }
        _task_update($actid, $l["performing_startup_process"], 43, "group");
        $this->onstartup($vid);
        _task_update($actid, "", 45, "group_end");
        task_update($actid, $l["call_hook_before_startvps"], 45);
        apply_filters("before_startvps", $vps);
        $vps_name = $this->getname($vid);
        oexec("/usr/bin/xe vm-start " . xss("name-label=" . $vps_name) . " on=\$(hostname) 2>&1", $output, $sret);
        writefile(logdir("start") . $vid . ".log", $output, 1);
        sleep(1);
        _task_update($actid, $l["tc_rule_create"], 72, "group");
        $this->tc_create($vid);
        _task_update($actid, $l["tc_rule_create"], 72, "group_end");
        if(!empty($vps["nw_suspended"])) {
            $this->suspend_vps_net($vps["vpsid"]);
        }
        vexec("/usr/bin/xe pool-param-set uuid=" . $this->getPOOL_uuid() . " other-config:auto_poweron=true", $out, $ret);
        vexec("/usr/bin/xe vm-param-set uuid=" . $this->getVM_uuid($vid) . " other-config:auto_poweron=true", $out, $ret);
        task_update($actid, $l["call_hook_after_startvps"], 88);
        apply_filters("after_startvps", $vps);
        task_update($actid, $l["start_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function stop($vsid)
    {
        global $l;
        $vps = getvps($vsid);
        $actid = vps_task("stop_vps", "", 0, $vsid, $vps["uid"], 0, $l["stop_vps"]);
        task_start($actid);
        task_update($actid, $l["stop_vps"], 57);
        $vps_name = $this->getname($vsid);
        $this->kill_socat($vsid);
        $vid = $this->getDOMU_id($vsid);
        if(!$vid) {
            return false;
        }
        vexec("/usr/bin/xe vm-param-set uuid=" . $this->getVM_uuid($vsid) . " other-config:auto_poweron=false", $vmauto_out, $ret);
        oexec("/usr/bin/xe vm-shutdown vm=" . $vps_name, $output, $ret);
        writefile(logdir("stop") . $vsid . ".log", $output, 1);
        task_update($actid, $l["stop_vps"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function restart($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("restart_vps", "", 0, $vid, $vps["uid"], 0, $l["restart_vps"]);
        task_start($actid);
        task_update($actid, $l["restart_vps"], 57);
        $vps = getvps($vid);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        $this->kill_socat($vid);
        if($this->status($vid) == 0) {
            task_update($actid, $l["restart_vps_done"], 100);
            return $this->start($vid);
        }
        $vps_name = $this->getname($vid);
        oexec("/usr/bin/xe vm-reboot " . xss("vm=" . $vps_name) . " --force", $output);
        if(!empty($vps["nw_suspended"])) {
            $this->suspend_vps_net($vps["vpsid"]);
        }
        task_update($actid, $l["restart_vps_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function poweroff($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("poweroff_vps", "", 0, $vid, $vps["uid"], 0, $l["power_off_vps"]);
        task_start($actid);
        task_update($actid, $l["power_off_vps"], 57);
        $status = $this->vps_status_statewise($vid);
        if($status == 2) {
            return false;
        }
        $this->kill_socat($vid);
        vexec("/usr/bin/xe vm-param-set uuid=" . $this->getVM_uuid($vid) . " other-config:auto_poweron=false", $vmauto_out, $ret);
        $vps_name = $this->getname($vid);
        oexec("xe vm-shutdown force=true " . xss("vm=" . $vps_name), $output);
        writefile(logdir("poweroff") . $vid . ".log", $output, 1);
        task_update($actid, $l["power_off_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function onstartup($vid)
    {
        global $globals;
        global $user;
        global $ostemplates;
        global $l;
        if($this->status($vid, 1) == 1) {
            return -1;
        }
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        $vdi_UUID = $this->getVDI_uuid($vid);
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $this->ipspoof_remove($vid);
        $ipv4_arr = [];
        $ipv6_arr = [];
        if(!empty($ips[0])) {
            foreach ($ips as $k => $v) {
                if(empty($v["ipv6"])) {
                    $ipv4_arr[] = $v["ip"];
                } else {
                    $ipv6_arr[] = $v["ip"];
                    if(!empty($v["ipr_ips"])) {
                        $tmp_ips = unserialize($v["ipr_ips"]);
                        $ipv6_arr = array_merge($tmp_ips, $ipv6_arr);
                    }
                }
            }
            if(0 < count($ipv4_arr)) {
                vexec("/usr/bin/xe vif-param-set ipv4-allowed=" . xss(implode(",", $ipv4_arr)) . " uuid=" . $this->getVIF_uuid($vid));
            }
            if(0 < count($ipv6_arr)) {
                vexec("/usr/bin/xe vif-param-set ipv6-allowed=" . xss(implode(",", $ipv6_arr)) . " uuid=" . $this->getVIF_uuid($vid));
            }
            vexec("/usr/bin/xe vif-param-set locking-mode=locked uuid=" . $this->getVIF_uuid($vid));
        }
        $mount = mount($vid, "", 1);
        if(is_array($mount)) {
            vexec("df -P " . $mount["mount_point"] . " 2>/dev/null", $tmp_out, $tmp_ret);
            $elements = preg_split("/\\s+/", $tmp_out[1]);
            $vps_disk_usage = ["Filesystem" => $elements[0], "1K-blocks" => $elements[1], "Used" => $elements[2], "Available" => $elements[3], "Use%" => $elements[4], "mounted_on" => $elements[5]];
            vexec("df -Pi " . $mount["mount_point"] . " 2>/dev/null", $itmp_out, $itmp_ret);
            $elements = preg_split("/\\s+/", $itmp_out[1]);
            $vps_inode_usage = ["Filesystem" => $elements[0], "Inodes" => $elements[1], "IUsed" => $elements[2], "IFree" => $elements[3], "IUse%" => $elements[4], "mounted_on" => $elements[5]];
            if(!empty($vps_disk_usage) || !empty($vps_inode_usage)) {
                $tmp_data = ["disk" => $vps_disk_usage, "inode" => $vps_inode_usage];
                to_master("vps", "cached_disk", $vps["vpsid"], "vpsid", serialize($tmp_data));
            }
            if(file_exists($mount["mount_point"] . "/etc/shadow") && empty($globals["disable_nw_config"]) && empty($vps["disable_nw_config"])) {
                if(empty($ips[0])) {
                    $umount = umount($mount);
                    return false;
                }
                $routing = $ips[0]["routing"];
                $post = [];
                if(!empty($vps["dns_nameserver"])) {
                    $dns = unserialize($vps["dns_nameserver"]);
                    $post["dns"] = $dns;
                }
                network_configure($mount["mount_point"], $ips, $post, $routing);
            }
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["kvm_err_unmount"];
                return false;
            }
        }
        return true;
    }
    public function status($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            vexec("/usr/bin/xe vm-list", $output);
            $vm_names_array = [];
            $power_state_array = [];
            foreach ($output as $v) {
                if(preg_match("/name-label/is", $v)) {
                    $vm_names = explode(":", $v);
                    array_push($vm_names_array, trim($vm_names[1]));
                }
                if(preg_match("/power-state/is", $v)) {
                    $power_state = explode(":", $v);
                    array_push($power_state_array, trim($power_state[1]));
                }
            }
            $output = array_combine($vm_names_array, $power_state_array);
            foreach ($output as $k => $v) {
                $vid = array_search($k, $vs);
                if(!empty($vid) && preg_match("/running/is", $v)) {
                    $this->status[$vid] = 1;
                    $on[$vid] = 1;
                }
                if(!empty($vid) && preg_match("/suspended/is", $v)) {
                    $this->status[$vid] = 2;
                    $on[$vid] = 2;
                }
                if(!empty($vid) && preg_match("halted/is", $v)) {
                    $this->status[$vid] = 0;
                    $on[$vid] = 0;
                }
            }
        }
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = !empty($on[$k]) ? 1 : 0;
            } else {
                $ret[$k] = !empty($this->status[$k]) ? 1 : 0;
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function vps_status_statewise($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status_statewise[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            vexec("/usr/bin/xe vm-list", $output);
            $vm_names_array = [];
            $power_state_array = [];
            foreach ($output as $v) {
                if(preg_match("/name-label/is", $v)) {
                    $vm_names = explode(":", $v);
                    array_push($vm_names_array, trim($vm_names[1]));
                }
                if(preg_match("/power-state/is", $v)) {
                    $power_state = explode(":", $v);
                    array_push($power_state_array, trim($power_state[1]));
                }
            }
            $output = array_combine($vm_names_array, $power_state_array);
            foreach ($output as $k => $v) {
                $vid = array_search($k, $vs);
                if(!empty($vid)) {
                    if(preg_match("/running/is", $v)) {
                        $this->status_statewise[$vid] = 1;
                        $on[$vid] = 1;
                    }
                    if(preg_match("/suspended/is", $v)) {
                        $this->status_statewise[$vid] = 2;
                        $on[$vid] = 2;
                    }
                    if(preg_match("halted/is", $v)) {
                        $this->status_statewise[$vid] = 0;
                        $on[$vid] = 0;
                    }
                }
            }
        }
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = $on[$k] == 1 ? 1 : ($on[$k] == 2 ? 2 : 0);
            } else {
                $ret[$k] = $this->status_statewise[$k] == 1 ? 1 : ($this->status_statewise[$k] == 2 ? 2 : 0);
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function vm_location($vids, $live = false)
    {
        global $cluster;
        $impvids = implode(", ", array_keys($vids));
        $res = makequery("SELECT vpsid, vps_name, serid FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $vs_serid_db[$row["vpsid"]] = $row["serid"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        $vms_on_hosts = [];
        oexec("/usr/bin/xe host-list params=uuid --minimal", $xcphosts);
        $xcphosts = explode(",", $xcphosts);
        foreach ($xcphosts as $xcphost) {
            $vms_on_hosts[$xcphost] = [];
        }
        $hosts_uuid = [];
        $res = makequery("SELECT serid, unique_txt FROM `servers`;");
        if(0 < vsql_num_rows($res)) {
            while ($row = vsql_fetch_assoc($res)) {
                $hosts_uuid[$row["unique_txt"]] = $row["serid"];
            }
        }
        $vs_serid_cur = [];
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            oexec("/usr/bin/xe vm-list params=name-label,power-state,resident-on", $outputs);
            $outputs = explode("\n\n", $outputs);
            foreach ($outputs as $out) {
                $out = trim($out);
                if(!empty($out)) {
                    $output = explode("\n", $out);
                    $v = explode(":", trim($output[0]));
                    $vid = array_search(trim($v[1]), $vs);
                    if(!empty($vid)) {
                        $host_uuid = explode(":", trim($output[2]));
                        $host_uuid = trim($host_uuid[1]);
                        if(isset($hosts_uuid[$host_uuid])) {
                            $vs_serid_cur[$vid] = $hosts_uuid[$host_uuid];
                            $vids[$vid] = $hosts_uuid[$host_uuid];
                        }
                    }
                }
            }
        }
        $do_sync = [];
        foreach ($vs_serid_db as $vk => $vserid) {
            if($vserid != $vs_serid_cur[$vk] && isset($vs_serid_cur[$vk])) {
                $do_sync[$vserid] = $vserid;
                $do_sync[$vs_serid_cur[$vk]] = $vs_serid_cur[$vk];
                $vms_list[$vs_serid_cur[$vk]][$vk] = $vk;
            }
        }
        if(!empty($do_sync)) {
            foreach ($do_sync as $host_serid => $tmp) {
                if(!empty($vms_list[$host_serid])) {
                    $token_val = vsql_in_tokens($vms_list[$host_serid]);
                    makequery("UPDATE vps \n\t\t\t\t\t\tSET serid = :serid\n\t\t\t\t\t\tWHERE vpsid IN (" . $token_val["query"] . ");", array_merge([":serid" => $host_serid], $token_val["tokens"]));
                }
                $cluster->sync($host_serid);
            }
        }
        return $vids;
    }
    public function destroy($vid)
    {
        $vps = getvps($vid);
        apply_filters("before_deletevps", $vps);
        oexec("/usr/bin/xe vm-destroy uuid= " . $this->getVM_uuid($vid), $output1);
        apply_filters("after_deletevps", $vps);
        return $output1;
    }
    public function destroyvps($vid)
    {
        global $globals;
        global $l;
        global $error;
        $vps = getvps($vid);
        $actid = vps_task("deletevs", "", 0, $vid, $vps["uid"], 0, $l["del_vps"]);
        task_start($actid);
        $data = ["serid" => $vps["serid"]];
        task_update($actid, $l["start_del_vps"], 5, serialize($data));
        $vps_name = $vps["vps_name"];
        $disks = get_vps_DISKS($vid);
        task_update($actid, $l["stop_vps"], 30);
        oexec("/usr/bin/xe vm-shutdown uuid=" . $this->getVM_uuid($vid) . " force=true", $output);
        task_update($actid, $l["del_vps"], 40);
        oexec("/usr/bin/xe vm-destroy uuid=" . $this->getVM_uuid($vid), $output1);
        vexec("/usr/sbin/userdel -f -r " . xss("vs" . $vps_name));
        if($output != 0 || $output1 != 0) {
            return false;
        }
        sleep(1);
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\t\tAND action = 'delete_vpsdisks'\n\t\t\t\t\t\tORDER BY actid ASC", [":vid" => $vid]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $tasks[$row["actid"]] = $row;
                $del_data = _unserialize($row["data"]);
                $this->delete_vpsdisks($vid, $del_data, $row["actid"]);
                logs_vps("delete_vpsdisks", $del_data, 1, $vid, $user["uid"]);
            }
        }
        foreach ($disks as $dk => $DISK) {
            umount($DISK);
            task_update($actid, $l["del_kpartx"], 40);
            kpartx_delete($vid, $DISK["path"]);
            task_update($actid, $l["del_storage"], 55);
            $storage_destroy = vpsdisk_destroy($DISK);
            if(!empty($storage_destroy)) {
                $error = merge_error($error, $storage_destroy);
            }
        }
        if(is_dir("/home/" . $vps["vps_name"])) {
            vexec("rm -rf /home/" . $vps["vps_name"]);
        }
        task_update($actid, $l["call_hook_after_delvps"], 88);
        apply_filters("after_deletevps", $vps);
        task_update($actid, $l["del_vps_done"], 100);
        return true;
    }
    public function getname($vid)
    {
        global $user;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            return $user["vps"]["vps_name"];
        }
        if($vps = getvps($vid)) {
            return $vps["vps_name"];
        }
        return false;
    }
    public function listips($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $ips = [];
        $res = makequery("SELECT * FROM `ips`\n\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(in_array($row["ip"], $ips)) {
            } else {
                $ips[] = $row["ip"];
            }
        }
        return $ips;
    }
    public function cpu($vid)
    {
        global $user;
        $ret = [];
        $ret["manu"] = "unknown";
        $ret["limit"] = 0;
        $ret["used"] = 0;
        oexec("cat /proc/cpuinfo", $tmp);
        if(preg_match("/intel/is", $tmp)) {
            $ret["manu"] = "intel";
        } elseif(preg_match("/amd/is", $tmp)) {
            $ret["manu"] = "amd";
        }
        virt_preg_replace("/cpu(\\s*?)MHz(\\s*?)\\:(\\s*?)(.*?)(\\s*?)\\n/is", $tmp, $mhz, 4);
        $vps = getvps($vid);
        if($this->status($vid) !== 0) {
            $vps_name = $this->getname($vid);
            $_cpu_stats = $this->_cpu_stats();
            $ret["used"] = trim($_cpu_stats[$vps_name]["cpu"]);
        }
        $ret["percent"] = $ret["used"] / $vps["cores"];
        if(100 < $ret["percent"]) {
            $ret["percent"] = 100;
        }
        $ret["percent_free"] = 100 - $ret["percent"];
        if(!empty($mhz)) {
            $ret["limit"] = $mhz;
            $ret["used"] = $ret["percent"] * $mhz / 100;
            $ret["free"] = $ret["limit"] - $ret["used"];
        } else {
            $ret["limit"] = 100;
            $ret["used"] = $ret["percent"];
            $ret["free"] = $ret["limit"] - $ret["used"];
        }
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function ram($vid)
    {
        global $user;
        $ret = [];
        $ret["used"] = 0;
        $ret["limit"] = 0;
        $ret["guaranteed"] = 0;
        $ret["swap"] = 0;
        if(!empty($user["vps"])) {
            $vps = $user["vps"];
        } else {
            $vps = getvps($vid);
        }
        if(!empty($vps)) {
            $ret["limit"] = $vps["ram"];
            $ret["guaranteed"] = $vps["ram"];
            $ret["swap"] = $vps["swap"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function disk($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            $vps = $user["vps"];
            $ret["limit"] = $user["vps"]["space"] * 1024;
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["space"] * 1024;
        }
        if(!empty($vps["cached_disk"]["disk"]["Used"])) {
            $ret["used"] = $vps["cached_disk"]["disk"]["Used"] / 1024;
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["limit_gb"] = $ret["limit"] / 1024;
        $ret["used_gb"] = $ret["used"] / 1024;
        $ret["free_gb"] = $ret["limit_gb"] - $ret["used_gb"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function inodes($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            $vps = $user["vps"];
            $ret["limit"] = $user["vps"]["inodes"];
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["inodes"];
        }
        if(empty($ret["limit"]) & !empty($vps["cached_disk"]["inode"]["Inodes"])) {
            $ret["limit"] = $vps["cached_disk"]["inode"]["Inodes"];
        }
        if(!empty($vps["cached_disk"]["inode"]["IUsed"])) {
            $ret["used"] = $vps["cached_disk"]["inode"]["IUsed"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function vncDetails($vid)
    {
        global $globals;
        $vps = getvps($vid);
        $info["port"] = $vps["vncport"];
        $port = 0;
        if(os_check("xcp", ">=", "7.6")) {
            if(!empty($vps["hvm"])) {
                $this->kill_socat($vid);
            }
            if(empty($info["port"])) {
                $info["port"] = $this->_newVncPort();
                to_master("vps", "vncport", $vps["vpsid"], "vpsid", $info["port"]);
            }
            vexec("lsof -i:" . $info["port"], $o, $r);
            if($r != 0 && !empty($vps["hvm"])) {
                vexec("ps aux | grep \"[U]NIX-CONNECT:/var/run/xen/vnc-" . $this->getDOMU_id($vid) . "\"", $out, $ret);
                if($ret != 0) {
                    vexec("sh " . $globals["path"] . "/scripts/xcp_vnc.sh " . $info["port"] . " " . $this->getDOMU_id($vid) . " 2>&1 > /dev/null &");
                }
            }
            if(empty($vps["hvm"])) {
                vexec("ps aux | grep \"[v]ncterm -x /local/domain/" . $this->getDOMU_id($vid) . "/console\"", $out, $ret);
                if(!empty($out)) {
                    foreach ($out as $v) {
                        $tmp = cexplode(" ", $v, 0, 1);
                        $tmp = array_values($tmp);
                        vexec("kill -9 " . $tmp[1] . " 2>&1 > /dev/null &");
                    }
                }
                $vnc_term = "/usr/bin/vncterm";
                if(!file_exists($vnc_term)) {
                    $vnc_term = "/usr/lib64/xen/bin/vncterm";
                }
                vexec($vnc_term . " -x /local/domain/" . $this->getDOMU_id($vid) . "/console -T -v 127.0.0.1:" . ($info["port"] - 5900) . " 2>&1 > /dev/null &");
            }
        } else {
            vexec("/usr/bin/xenstore-read /local/domain/" . $this->getDOMU_id($vid) . "/console/vnc-port", $output, $ret);
            $port = $output[0];
            $info["port"] = $port;
        }
        $info["ip"] = server_vncip($vps["serid"]);
        return $info;
    }
    public function _newVncPort()
    {
        global $globals;
        $vncport = 5900;
        $res = makequery("SELECT vpsid, vncport FROM vps \n\t\t\t\t\t\tWHERE serid = 0 \n\t\t\t\t\t\tAND virt = 'xcp'\n\t\t\t\t\t\tAND vnc != 0\n\t\t\t\t\t\tORDER BY vncport ASC");
        if(0 < vsql_num_rows($res)) {
            for ($x = 0; $x < vsql_num_rows($res); $x++) {
                $row = vsql_fetch_assoc($res);
                if(!empty($row["vncport"])) {
                    $used_vncports[] = (int) trim($row["vncport"]);
                }
            }
        }
        for ($i = 1; $i <= 1000; $i++) {
            $vncport = $vncport + 1;
            if(in_array($vncport, $used_vncports)) {
            } elseif(vexec("lsof -i:" . $vncport) != 0) {
            }
        }
        return $vncport;
    }
    public function suspendvps($vpsid)
    {
        global $l;
        if($this->vps_status_statewise($vpsid, 1) == 2 || $this->vps_status_statewise($vpsid, 1) == 0) {
            return true;
        }
        $actid = vps_task("suspend_vps", "", 0, $vpsid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        $vps_name = $this->getname($vpsid);
        if($this->vps_status_statewise($vpsid, 1) == 0) {
            $this->start($vpsid);
        }
        $vid = $this->getDOMU_id($vpsid);
        if(!$vid) {
            return false;
        }
        vexec("/usr/bin/xe vm-suspend vm=\"" . $vps_name . "\"", $output, $ret);
        if($ret == "0") {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["suspend_error"], -1);
        return false;
    }
    public function unsuspendvps($vpsid)
    {
        global $l;
        $vps_name = $this->getname($vpsid);
        $vid = $this->getDOMU_id($vpsid);
        if(!$vid) {
            return false;
        }
        file_put_contents(logdir("unsuspend") . $vpsid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        $actid = vps_task("unsuspend_vps", "", 0, $vpsid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        vexec("/usr/bin/xe vm-resume vm=\"" . $vps_name . "\" --force", $output, $ret);
        if($ret == "0") {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["unsuspend_error"], -1);
        return false;
    }
    public function suspend_vps_net($vid)
    {
        $vifName = "vif" . $this->getDOMU_id($vid) . ".0";
        vexec("ifconfig " . xss($vifName) . " down", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function unsuspend_vps_net($vid)
    {
        $vifName = "vif" . $this->getDOMU_id($vid) . ".0";
        file_put_contents(logdir("nw_unsuspend") . $vid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        vexec("ifconfig " . xss($vifName) . " up", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function vps_net_status($vpsid)
    {
        $vifName = "vif" . $this->getDOMU_id($vpsid) . ".0";
        $value = 0;
        if(!empty($vpsid)) {
            vexec("ifconfig", $output, $ret);
            $output = implode("\n", $output);
            $value = preg_match("/" . $vifName . "/is", $output) ? 1 : 0;
        }
        return $value;
    }
    public function hostname($vid)
    {
        $vps = getvps($vid);
        return $vps["hostname"];
    }
    public function uptime($vid)
    {
        return true;
    }
    public function change_mac_address($vpsid, $mac_address)
    {
        return true;
    }
    public function os($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $vps = getvps($vid);
        $osid = $vps["osid"];
        if(empty($ostemplates)) {
            oslist();
        }
        $osinfo = $ostemplates[$vps["osid"]];
        if(empty($osinfo)) {
            $osinfo["name"] = $vps["os_name"];
            $osinfo["distro"] = distro_find($vps["os_name"]);
        }
        return $osinfo;
    }
    public function changepassword($vid, $newpassword, $actid = 0)
    {
        global $globals;
        global $l;
        global $user;
        global $oslist;
        global $ostemplates;
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("changepassword", base64_encode($newpassword), 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "changepassword", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "change_password", [$newpassword]);
    }
    public function remotedesktop($vid, $rdp, $actid = 0)
    {
        global $globals;
        global $l;
        global $user;
        global $oslist;
        global $ostemplates;
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("remotedesktop", $rdp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "remotedesktop", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "remote_desktop", [$rdp]);
    }
    public function createtemplate($vid, $name)
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vid);
        if(!empty($vps["hvm"])) {
            $path = $globals["xcpos"] . "/" . $name . ".img";
        } else {
            $path = $globals["xcpos"] . "/" . $name . ".img.gz";
        }
        if(file_exists($path)) {
            $error[] = $l["temp_exists"];
            return false;
        }
        $DISK = vpsdisk_snapshot_create($vid, "template-" . $vps["vps_name"]);
        if(empty($DISK)) {
            $error[] = $l["temp_snap_err"];
            return false;
        }
        vexec("vgchange -ay");
        if(!empty($vps["hvm"])) {
            vexec("/bin/dd if=" . $DISK["snapshot_path"] . " of=\"" . $path . "\" bs=24M 2>&1");
        } else {
            vexec("/bin/dd if=" . $DISK["snapshot_path"] . " bs=24M | " . $globals["com"]["pgzip"] . " -c > " . $path);
        }
        $snapshot_delete = vpsdisk_snapshot_delete($DISK);
        if(!empty($snapshot_delete)) {
            $error = merge_error($error, $snapshot_delete);
            return false;
        }
        if(@vfilesize($path) < 1) {
            return false;
        }
        if(!empty($vps["hvm"])) {
            return $name . ".img";
        }
        return $name . ".img.gz";
    }
    public function changehostname($vid, $host, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        global $error;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("hostname", $host, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "hostname", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            hostname_configure($mount["mount_point"], $host);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function resizevps($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("resizevps", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "resizevps", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $disks = get_vps_DISKS($vid);
        foreach ($disks as $dk => $DISK) {
            $disk_size = vpsdisk_size($DISK);
            if(empty($disk_size) || (int) $DISK["size"] <= $disk_size) {
            } else {
                $resize = vpsdisk_resize($vid, $DISK["path"]);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($actid, $l["vpsdisk_resize_err"], -1);
                    return false;
                }
                if(empty($resize["altered_partitions"])) {
                } elseif(!empty($DISK["primary"])) {
                    $DISK["diskinfo"] = $resize["diskinfo"];
                    $fs_resize = vpsdisk_resize_filesystem($DISK);
                    if(!empty($fs_resize)) {
                        $error = merge_error($error, $fs_resize);
                        task_update($actid, $l["kvm_err_resizefs"], -1);
                        return false;
                    }
                }
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function install_cp($vid, $cp, $actid = 0)
    {
        global $globals;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("install_cp", $cp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "install_cp", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "install_cp", [$cp]);
    }
    public function install_recipe($vid, $recipe, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $recipe_data = serialize($recipe);
            $actid = vps_task("install_recipe", $recipe_data, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "install_recipe", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "install_recipe", $recipe);
    }
    public function change_winips($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("change_winips", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["change_onboot"], 57);
        perform_vps_operation($vid, 0, "config_network", ["config_network" => ["pub" => $this->getmac($vid), "int" => $this->getmac($vid)]]);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function change_dnsnameserver($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("change_dnsnameserver", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "change_dnsnameserver", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        dns_configure($mount["mount_point"], $vps);
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function osreinstall($vid, $format_primary = 0)
    {
        $vps_name = $this->getname($vid);
        $this->destroyvps($vid);
        if(!$this->createvps($vid)) {
            return false;
        }
        return true;
    }
    public function check_kernel()
    {
        global $l;
        global $globals;
        oexec("uname -r", $uname);
        if(@preg_match("/xen/is", $uname)) {
            return true;
        }
        if($globals["distro"] == "ubuntu") {
            oexec("xl info", $xm);
            if(!preg_match("/xen_major/is", $xm)) {
                return $l["wrong_xm"];
            }
            return true;
        }
    }
    public function vscpu($ids, $speed = 1000000, $times = 2)
    {
        $vs_status = $this->status($ids);
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        $vpsnames = [];
        $usage = [];
        $_cpu_stats = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpsnames[$row["vpsid"]] = $row["vps_name"];
            $usage[$row["vpsid"]] = 0;
        }
        if(empty($vpsnames)) {
            return false;
        }
        $_cpu_stats = $this->_cpu_stats();
        foreach ($vpsnames as $k => $vpsname) {
            if($vs_status[$k] !== 0 && array_key_exists($vpsname, $_cpu_stats)) {
                $usage[$k] = trim($_cpu_stats[$vpsname]["cpu"]);
            } else {
                $usage[$k] = 0;
            }
        }
        return $usage;
    }
    public function vsram($ids)
    {
        $used_ram = 0;
        $ram[0]["used"] = 0;
        $ram[0]["ram"] = 0;
        vexec("/usr/bin/free -m", $output, $return);
        if(!empty($output[2])) {
            preg_match("/(\\d+)(.*?)(\\d+)/is", $output[2], $tmp);
            if(!empty($tmp[1])) {
                $ret["used"] = (double) trim($tmp[1]);
            }
            if(!empty($tmp[3])) {
                $ret["limit"] = (double) (trim($tmp[3]) + $ret["used"]);
            }
        }
        $ram[-1]["used"] = (int) $ret["used"];
        $ram[-1]["ram"] = (int) $ret["limit"];
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        $output = [];
        vexec("/usr/bin/xe vm-list params=name-label --minimal", $output);
        $output = explode(",", trim($output[0]));
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $status = 0;
            foreach ($output as $v) {
                if(0 < strpos($v, "domain on host")) {
                } elseif($v == $row["vps_name"]) {
                    $status = 1;
                }
            }
            if($status != 1) {
                $row["ram"] = 0;
            }
            $ram[$row["vpsid"]]["used"] = $row["ram"];
            $ram[$row["vpsid"]]["label"] = "VPS : " . $row["vps_name"];
            $ram[$row["vpsid"]]["ram"] = $row["ram"];
        }
        vexec("/usr/bin/xe host-list uuid=\$(xe host-list name-label=\$(hostname) --minimal) params=memory-total,memory-free", $output, $return);
        foreach ($output as $k => $v) {
            $tmp = explode(":", $v);
            if(strpos(trim($tmp[0]), "memory-total") !== false) {
                $ret["total_ram"] = @round((double) @trim($tmp[1]) / 1024 / 1024);
            }
            if(strpos(trim($tmp[0]), "memory-free") !== false) {
                $ret["free_ram"] = @round((double) @trim($tmp[1]) / 1024 / 1024);
            }
        }
        $used_ram = $ret["total_ram"] - $ret["free_ram"];
        $ram[0]["used"] = (int) $used_ram;
        $ram[0]["ram"] = (int) $ret["total_ram"];
        return $ram;
    }
    public function editvps($vid, $actid = 0)
    {
        global $globals;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("editxcpvs", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "editxcpvs", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        if($vps["vnc"] == 0) {
            vexec("/usr/sbin/userdel -f -r " . xss("vs" . $vps["vps_name"]));
        }
        $this->tc_create($vid);
        $ret = $this->createvps($vid, 0);
        task_update($actid, $l["completed"], 100);
        return $ret;
    }
    public function createvps($vid, $create = 1)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        global $error;
        global $l;
        global $cluster;
        $vps = getvps($vid);
        $action = "edit_vps";
        if(!empty($create)) {
            $action = "create_vps";
        }
        $actid = vps_task($action, "", 0, $vid, $vps["uid"], 0, $l["beginning_creation"]);
        task_start($actid);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        if(empty($oslist)) {
            oslist();
        }
        $isopath = $isotype = $isoname = "";
        task_update($actid, $l["beginning_creation"], 5);
        if(!empty($vps["iso"])) {
            $isopath = iso_path($vps["uid"], $vps["iso"], $isotype);
            task_update($actid, $l["downloading_iso"], 10);
            getos($isopath, $isotype);
            $isoname = basename($isopath);
        }
        if(!empty($create) && !defined("CREATE_DISK_MIGRATE") && !defined("DONT_DD_OS_TEMPLATE")) {
            if(!empty($vps["osid"])) {
                task_update($actid, $l["downloading_os"], 20);
                getos($ostemplates[$vps["osid"]]["filename"], "xcpos");
            }
            if(empty($ostemplates[$vps["osid"]]) || !file_exists($globals["xcpos"] . "/" . $ostemplates[$vps["osid"]]["filename"])) {
                $noos = true;
            }
            if(empty($vps["iso"]) || !file_exists($globals[$isotype] . "/" . $isopath)) {
                $noiso = true;
            }
            if(isset($noos) && isset($noiso)) {
                $error[] = $l["build_no_os_iso"];
                task_update($actid, $l["build_no_os_iso"], -1);
                return false;
            }
        }
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
            if(!empty($ips[$i]["vlan"])) {
                $vlan_bridge = $ips[$i]["bridge"];
            }
        }
        if(empty($ips[0]) && !defined("CREATE_DISK_MIGRATE")) {
            $error[] = $l["build_no_ip"];
            task_update($actid, $l["build_no_ip"], -1);
            return false;
        }
        $nat = $ips[0]["nat"];
        $nat_name = $ips[0]["nat_name"];
        $routing = $ips[0]["routing"];
        $mac_flag = 0;
        if(empty($ips[0]["mac_addr"])) {
            if(!empty($vps["mac"])) {
                $mac = $vps["mac"];
            } else {
                $mac = substr_replace(new_mac(), !empty($globals["custom_mac"]) ? $globals["custom_mac"] : "00:16:3e", 0, 8);
                $mac_flag = 1;
            }
        } else {
            $mac = $ips[0]["mac_addr"];
        }
        $bridgeName = "xenbr0";
        if(!empty($vlan_bridge)) {
            $bridgeName = $vlan_bridge;
        } elseif(!empty($vps["hvm"]) && !empty($globals["xen_hvmbridge"])) {
            $bridgeName = $globals["xen_hvmbridge"];
        } elseif(!empty($globals["xen_pvbridge"])) {
            $bridgeName = $globals["xen_pvbridge"];
        }
        vexec("/usr/bin/xe sr-scan uuid=\$(/usr/bin/xe sr-list name-label=ISO-Repo --minimal)");
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        $sruuid = cleanpath(dirname($DISK["path"]));
        $sruuid = substr($sruuid, -36);
        $task_disk_num = 1;
        $task_disk_progress = 25;
        if(!empty($create)) {
            vexec("/usr/bin/xe vm-install template=Other\\ install\\ media sr-uuid=" . $sruuid . " " . xss("new-name-label=" . $vps["vps_name"]), $vm_uuid_out, $ret);
            if($ret != "0") {
                $error[] = "Failed to create VPS";
                $error["derr"] = array_end($GLOBALS["logr"]);
                return false;
            }
            foreach ($disks as $dk => $DISK) {
                $os_template = "";
                if(!empty($DISK["primary"]) && !empty($vps["osid"])) {
                    $os_template = $globals["xcpos"] . "/" . $ostemplates[$vps["osid"]]["filename"];
                }
                task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                $storage_create = vpsdisk_create($DISK, $os_template);
                if(!empty($storage_create)) {
                    $error = merge_error($error, $storage_create);
                    task_update($actid, print_r($error, 1), -1);
                    return false;
                }
                $task_disk_num++;
                $task_disk_progress = $task_disk_progress + ceil(30 / count($disks));
            }
            $disks = get_vps_DISKS($vid);
            $DISK = get_vps_disk($vid);
            foreach ($vps["disks"] as $k => $v) {
                $vps["disks"][$k]["path"] = $disks[$k]["path"];
                to_master("disks", "path", $vps["disks"][$k]["did"], "did", $vps["disks"][$k]["path"]);
            }
            $this->addVIF($vid, $mac, $bridgeName);
            vexec("/usr/bin/xe pool-param-set uuid=" . $this->getPOOL_uuid() . " other-config:auto_poweron=true", $poolauto_out, $ret);
            vexec("/usr/bin/xe vm-param-set uuid=" . $this->getVM_uuid($vid) . " other-config:auto_poweron=true", $vmauto_out, $ret);
            vexec("/usr/bin/xe host-list name-label=\$(hostname) --minimal", $hostuuid);
            vexec("/usr/bin/xe vm-param-set uuid=" . $this->getVM_uuid($vid) . " affinity=" . $hostuuid[0]);
            task_update($actid, $l["tc_rule_create"], 55);
            $this->tc_create($vid);
        }
        $vdi_UUID = $this->getVDI_uuid($vid);
        $vm_UUID = $this->getVM_uuid($vid);
        vexec("/usr/bin/xe vm-memory-limits-set static-min=" . $vps["ram"] . "MiB static-max=" . $vps["ram"] . "MiB dynamic-max=" . $vps["ram"] . "MiB dynamic-min=" . $vps["ram"] . "MiB uuid=" . $vm_UUID, $ram_out, $ret);
        task_update($actid, $l["set_ram"], 58);
        if(1 < $vps["cpu"]) {
            vexec("/usr/bin/xe vm-param-set uuid=" . $vm_UUID . " VCPUs-params:weight=" . $vps["cpu"], $cpu_out, $ret);
            task_update($actid, $l["setting_cpu"], 60);
        }
        if(1 < $vps["cpu_percent"]) {
            vexec("/usr/bin/xe vm-param-set uuid=" . $vm_UUID . " VCPUs-params:cap=" . $vps["cpu_percent"], $cpucap_out, $ret);
            task_update($actid, $l["setting_cpu_per"], 63);
        }
        if(0 < $vps["cores"]) {
            task_update($actid, $l["setting_cpu_cores"], 65);
            oexec("/usr/bin/xe vm-param-get  param-name=VCPUs-max uuid=" . $vm_UUID, $out);
            $orig_cores = (int) $out;
            if($orig_cores < $vps["cores"]) {
                vexec("/usr/bin/xe vm-param-set VCPUs-max=" . $vps["cores"] . " VCPUs-at-startup=" . $vps["cores"] . " uuid=" . $vm_UUID, $cpucores_out, $ret);
            } else {
                vexec("/usr/bin/xe vm-param-set VCPUs-at-startup=" . $vps["cores"] . " VCPUs-max=" . $vps["cores"] . " uuid=" . $vm_UUID, $cpucores_out, $ret);
            }
            if(!empty($vps["topology_cores"])) {
                vexec("/usr/bin/xe vm-param-set platform:cores-per-socket=" . $vps["topology_cores"] . " uuid=" . $vm_UUID, $cpucores_out, $ret);
            }
        }
        vexec("vgchange -ay");
        if(!empty($vps["hvm"])) {
            $n_disks = $this->getVBD_available_device($vid);
            if(!empty($vps["iso"]) && !empty($create)) {
                vexec("/usr/bin/xe vm-cd-add vm=" . $vm_UUID . " " . xss("cd-name=" . $isoname) . " device=\"" . $n_disks . "\"", $cdoutput, $ret);
                task_update($actid, $l["add_iso"], 68);
                if($ret != "0") {
                    $error[] = $l["xcp_err_iso"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    return false;
                }
            } elseif(!empty($vps["iso"]) && empty($create) && !$this->cd_device_check($vps["vps_name"])) {
                vexec("/usr/bin/xe vm-cd-add vm=" . $vm_UUID . " " . xss("cd-name=" . $isoname) . " device=\"" . $n_disks . "\"", $cdoutput, $ret);
                task_update($actid, $l["add_iso"], 68);
                if($ret != "0") {
                    $error[] = $l["xcp_err_iso"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    return false;
                }
            } elseif(!empty($vps["iso"]) && empty($create)) {
                vexec("/usr/bin/xe vm-cd-eject vm=" . $vm_UUID, $cdoutput, $ret);
                vexec("/usr/bin/xe vm-cd-insert vm=" . $vm_UUID . " " . xss("cd-name=" . $isoname), $cdoutput, $ret);
                task_update($actid, $l["add_iso"], 68);
            } elseif(empty($vps["iso"]) && empty($create)) {
                task_update($actid, $l["rem_iso"], 70);
                vexec("/usr/bin/xe vm-cd-eject vm=" . $vm_UUID, $cdoutput, $ret);
            }
            vexec("/usr/bin/xe vm-param-set uuid=" . $vm_UUID . " HVM-boot-policy=BIOS\\ order HVM-boot-params:order=" . substr($vps["boot"], 0, 2), $bootorderout, $ret);
            task_update($actid, $l["setting_boot_policy"], 72);
            if(!empty($mac_flag)) {
                to_master("vps", "mac", $vps["vpsid"], "vpsid", $mac);
            }
        }
        if(os_check("xcp", ">=", "7.6") && !empty($vps["vnc"])) {
            $vncport = empty($vps["vncport"]) ? $this->_newVncPort() : $vps["vncport"];
            to_master("vps", "vncport", $vps["vpsid"], "vpsid", $vncport);
        }
        if(empty($create)) {
            $task_disk_num = 1;
            $task_disk_progress = 72;
            if($vps["vnc"] == 0) {
                vexec("/usr/sbin/userdel -f -r " . xss("vs" . $vps["vps_name"]));
            }
            if(preg_match("/windows/is", $vps["os_name"]) && ($ostemplates[$vps["osid"]]["perf_ops"] && $globals["use_win_script"])) {
                $this->change_winips($vid);
            }
            $resize_break = 0;
            $disks = get_vps_DISKS($vid);
            foreach ($disks as $dk => $DISK) {
                $disk_size = vpsdisk_size($DISK);
                if(empty($disk_size) && 0 < (int) $DISK["size"] && empty($DISK["primary"])) {
                    task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                    $storage_create = vpsdisk_create($DISK);
                    if(!empty($storage_create)) {
                        $error = merge_error($error, $storage_create);
                        task_update($actid, print_r($error, 1), -1);
                        return false;
                    }
                    $task_disk_num++;
                    $task_disk_progress = $task_disk_progress + ceil(20 / count($disks));
                    $created_new_disk = 1;
                }
                if(!empty($disk_size) && $disk_size < (int) $DISK["size"] && empty($resize_break)) {
                    $this->resizevps($vid);
                    task_update($actid, $l["resize_vps"], 92);
                    $resize_break = 1;
                }
            }
            if(!empty($created_new_disk)) {
                $disks = get_vps_DISKS($vid);
                $DISK = get_vps_disk($vid);
                foreach ($vps["disks"] as $k => $v) {
                    $vps["disks"][$k]["path"] = $disks[$k]["path"];
                    to_master("disks", "path", $vps["disks"][$k]["disk_uuid"], "disk_uuid", $vps["disks"][$k]["path"]);
                }
                getvps($vid, 0);
            }
            _task_update($actid, $l["change_dnsnameserver"], 95, "group");
            _task_update($actid, "", 95, "change_dnsnameserver");
            $this->change_dnsnameserver($vps["vpsid"]);
            _task_update($actid, "", 95, "group_end");
            vexec("/usr/bin/xe vm-param-set platform:pae=" . (!$vps["pae"] ? "false" : "true") . " uuid=" . $vm_UUID);
            vexec("/usr/bin/xe vm-param-set platform:apic=" . (!$vps["apic"] ? "false" : "true") . " uuid=" . $vm_UUID);
            vexec("/usr/bin/xe vm-param-set platform:acpi=" . $vps["acpi"] . " uuid=" . $vm_UUID);
            vexec("/usr/bin/xe vif-destroy uuid=" . $this->getVIF_uuid($vid), $out, $ret);
            if($ret != "0") {
                $error[] = $l["xcp_err_vif"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                task_update($actid, print_r($error, 1), -1);
                return false;
            }
            $this->addVIF($vid, $mac, $bridgeName);
            if(!empty($vps["iso"]) && !empty($vps["hvm"])) {
                vexec("/usr/bin/xe vm-param-set uuid=" . $vm_UUID . " HVM-boot-policy=BIOS\\ order HVM-boot-params:order=" . substr($vps["boot"], 0, 2), $bootorderout, $ret);
            }
            task_update($actid, $l["edit_done"], 100);
            return true;
        } else {
            if(!empty($vps["osid"]) && !defined("CREATE_DISK_MIGRATE")) {
                $resize = vpsdisk_resize($vid);
                task_update($actid, $l["resizing_disk"], 75);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($actid, print_r($error, 1), -1);
                    return false;
                }
                task_update($actid, $l["resizing_disk_done"], 76);
                $disk = $resize["diskinfo"];
                $DISK = get_vps_disk($vid);
                $DISK["diskinfo"] = $resize["diskinfo"];
                if(empty($disk["parttype"])) {
                    $DISK["diskinfo"] = get_ostype_from_disk($DISK, $disk);
                    $disk = $DISK["diskinfo"];
                }
                if(empty($ostemplates[$vps["osid"]]["noresizefs"])) {
                    $fs_resize = vpsdisk_resize_filesystem($DISK);
                    task_update($actid, $l["resizing_fs"], 78);
                    if(!empty($fs_resize)) {
                        $error = merge_error($error, $fs_resize);
                        task_update($actid, print_r($error, 1), -1);
                        return false;
                    }
                    task_update($actid, $l["resize_fs_done"], 81);
                }
                if(!empty($disk["parttype"][0]["type"]) && preg_match("/" . $disk["parttype"][0]["type"] . "/is", "islinux")) {
                    if(!empty($ostemplates[$vps["osid"]]["perf_ops"])) {
                        $mount = mount($vid);
                        task_update($actid, $l["mount"], 82);
                        if(!is_array($mount)) {
                            $error[] = $l["kvm_err_mount"];
                            task_update($actid, $l["kvm_err_mount"], -1);
                            return false;
                        }
                        apply_filters("perform_operations", $mount);
                        $post = [];
                        if(!empty($vps["dns_nameserver"])) {
                            $dns = unserialize($vps["dns_nameserver"]);
                            $post["dns"] = $dns;
                        }
                        task_update($actid, $l["net_config"], 85);
                        network_configure($mount["mount_point"], $ips, $post, $routing);
                        task_update($actid, $l["hostname_config"], 88);
                        hostname_configure($mount["mount_point"], $vps["hostname"]);
                        task_update($actid, $l["sshkey_clean"], 92);
                        sshkey_clean($mount["mount_point"]);
                        task_update($actid, $l["unmount"], 95);
                        $umount = umount($mount);
                        if(!empty($umount)) {
                            $error[] = $l["kvm_err_unmount"];
                            task_update($actid, $l["kvm_err_unmount"], -1);
                            return false;
                        }
                    }
                } elseif(!empty($disk["parttype"][0]["type"]) && preg_match("/" . $disk["parttype"][0]["type"] . "/is", "iswindows")) {
                }
            }
            if(empty($vps["hvm"])) {
                vexec("/usr/bin/xe vm-param-set uuid=" . $vm_UUID . " HVM-boot-policy=\"\"", $output, $ret);
                vexec("/usr/bin/xe vbd-param-set uuid=" . $this->getVBD_uuid($vid) . " bootable=true", $output, $ret);
                vexec("/usr/bin/xe vm-param-set uuid=" . $vm_UUID . " PV-bootloader=pygrub", $output, $ret);
            }
            if(!empty($vps["hvm"]) && preg_match("/windows/is", $vps["os_name"]) && !empty($ostemplates[$vps["osid"]]["perf_ops"]) && $globals["use_win_script"]) {
                $this->change_winips($vid);
            }
            task_update($actid, $l["create_done"], 100);
            apply_filters("after_createvps", $vps);
            if(empty($create)) {
                $cluster->reverse_sync($vps["serid"]);
            }
            return true;
        }
    }
    public function cron()
    {
        global $globals;
        global $l;
        global $kernel;
        $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_1";
        $vpses = get_bw_vps("xcp");
        $dev1 = file("/proc/net/dev");
        usleep(1000000);
        $dev2 = file("/proc/net/dev");
        $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_2";
        $cpu_usage = $this->_cpu_stats();
        $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_3";
        $status = $this->vps_status_statewise(array_keys($vpses));
        $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_4";
        $io_usage = $this->get_io_usage();
        foreach ($vpses as $k => $v) {
            if(!empty($globals["cb_bandwidth_overusage"]) && !empty($vpses[$k]["bandwidth"]) && $vpses[$k]["bandwidth"] < $vpses[$k]["used_bandwidth"]) {
                $callback["act"][] = "bandwidth_overusage";
                $callback["data"]["email"] = $vpses[$k]["email"];
                $callback["data"]["overused"] = $vpses[$k]["used_bandwidth"] - $vpses[$k]["bandwidth"];
                $service_period = get_vps_service_period($k);
                $before = $service_period["end"] - 480;
                $current = time();
                if($before < $current && $current <= $service_period["end"]) {
                    vps_task("bandwidth_overusage_callback", serialize($callback), 0, $k, $vpses[$k]["uid"], 0, $l["task_pending"]);
                }
            }
            $vpses[$k]["status"] = $status[$k];
            $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_5";
            $vpses[$k]["net_speed"] = $this->network_speed($k, $dev1, $dev2);
            $vpses[$k]["disk"] = 0;
            $vpses[$k]["inode"] = 0;
            if(!empty($v["cached_disk"])) {
                $temp_disk = unserialize($v["cached_disk"]);
                $vpses[$k]["disk"] = $temp_disk["disk"]["Used"] / 1024;
                $vpses[$k]["inode"] = $temp_disk["inode"]["IUsed"];
            }
            $vpses[$k]["cpu"] = $cpu_usage[$v["vps_name"]]["cpu"] / $vpses[$k]["cores"];
            if(100 < $vpses[$k]["cpu"]) {
                $vpses[$k]["cpu"] = 100;
            }
            makequery("INSERT INTO status SET\n\t\t\t\t\t\t`vpsid` = :vpsid, \n\t\t\t\t\t\t`time` = :time,\n\t\t\t\t\t\t`status` = :status,\n\t\t\t\t\t\t`disk` = :disk,\n\t\t\t\t\t\t`inode` = :inode,\n\t\t\t\t\t\t`ram` = :ram,\n\t\t\t\t\t\t`cpu` = :cpu,\n\t\t\t\t\t\t`actual_cpu` = :actual_cpu,\n\t\t\t\t\t\t`net_in` = :net_in,\n\t\t\t\t\t\t`net_out` = :net_out,\n\t\t\t\t\t\t`io_read` = :io_read,\n\t\t\t\t\t\t`io_write` = :io_write", [":vpsid" => $v["vpsid"], ":time" => $globals["cron_timestamp"], ":status" => $vpses[$k]["status"], ":disk" => $vpses[$k]["disk"], ":inode" => $vpses[$k]["inode"], ":ram" => 0, ":cpu" => $vpses[$k]["cpu"], ":actual_cpu" => $cpu_usage[$v["vps_name"]]["cpu"], ":net_in" => $vpses[$k]["net_speed"]["download"], ":net_out" => $vpses[$k]["net_speed"]["upload"], ":io_read" => $io_usage[$k]["read"], ":io_write" => $io_usage[$k]["write"]]);
            $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_6";
            $vpses[$k]["net_status"] = $this->vps_net_status($k);
            if(!empty($vpses[$k]["suspended"]) && $vpses[$k]["status"] != 2) {
                if(time() - filemtime(logdir("unsuspend") . $k . ".log") <= 60) {
                    echo "VPSID : " . $k . " was just unsuspended and we will wait for the next CRONM\n";
                } else {
                    echo "Suspending VPSID " . $k . " as it should have been suspended\n";
                    $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_7";
                    $this->suspendvps($v["vpsid"]);
                    logs_vps("suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                }
            }
            if(!empty($v["nw_suspended"])) {
                $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vpsid \n\t\t\t\t\t\tAND action = 'bandwidth_unsuspend'\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0", [":vpsid" => $v["vpsid"]]);
                $tmp_uvps = [];
                if(0 < vsql_num_rows($res)) {
                    $tmp_uvps = vsql_fetch_assoc($res);
                }
                $vs_nw_sus_dat = _unserialize($v["nw_suspended"]);
                if(!empty($tmp_uvps) && check_unsusp_vps_net($v["time"], $vs_nw_sus_dat["date"])) {
                    if($v["suspended"] == 1 && $v["suspend_reason"] == "bw") {
                        $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_8";
                        $this->unsuspendvps($v["vpsid"]);
                        $res = makequery("UPDATE vps SET \n\t\t\t\t\t\t\t\tsuspended = '0',\n\t\t\t\t\t\t\t\tsuspend_reason = ''\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        to_master("vps", "suspended", $v["vpsid"], "vpsid", "0");
                        to_master("vps", "suspend_reason", $v["vpsid"], "vpsid", "");
                    }
                    $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_9";
                    if($this->unsuspend_vps_net($v["vpsid"])) {
                        task_start($tmp_uvps["actid"]);
                        $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\tSET nw_suspended = NULL\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        logs_vps("bandwidth_unsuspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                        to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", NULL);
                        task_update($tmp_uvps["actid"], $l["completed"], 100);
                    }
                } elseif($vpses[$k]["net_status"]) {
                    if(time() - filemtime(logdir("nw_unsuspend") . $k . ".log") <= 60) {
                        echo "VPSID : " . $k . " NETWORK was just unsuspended and we will wait for the next CRONM\n";
                    } else {
                        echo "Suspending network of VPSID " . $k . " as its network should have been suspended\n";
                        $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_10";
                        $this->suspend_vps_net($v["vpsid"]);
                        logs_vps("bandwidth_suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    }
                }
            }
            $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_11";
            $bandwidth_val = $kernel->bandwidth($v["vpsid"]);
            $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_12";
            $service_period = get_vps_service_period($v["vpsid"]);
            $timestamp_threshold = @file_get_contents($globals["var"] . "/eubwthreshold/" . $v["vpsid"]);
            $used_percent_bandw = round(100 * $bandwidth_val["used_gb"] / $bandwidth_val["limit_gb"]);
            $user_threshold_bandw = $v["preferences"]["vps_bandwidth_threshold"];
            $set_threshold_bandw = !empty($user_threshold_bandw) ? $user_threshold_bandw : $globals["vps_bandwidth_threshold"];
            if($user_threshold_bandw < 0) {
                $set_threshold_bandw = 0;
            }
            if(!empty($bandwidth_val["limit_gb"]) && !empty($set_threshold_bandw) && $set_threshold_bandw < $used_percent_bandw && $timestamp_threshold < $service_period["start"]) {
                $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "vps_bandwidth_threshold" => $set_threshold_bandw, "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                if(!empty($v["email"])) {
                    send_emailtemp_mail("bandwidth_threshold", $v["email"], $email_vars, 1);
                    writefile($globals["var"] . "/eubwthreshold/" . $v["vpsid"], time(), 1);
                }
                $data["title"] = $l["bandwidth_threshold_mail_sub"];
                $data["data"] = lang_vars_name($l["bandwidth_threshold_notify"], $email_vars);
                save_notification("vps_band_thershold", $data);
            }
            if($bandwidth_val["limit_gb"] < $bandwidth_val["used_gb"] && !empty($bandwidth_val["limit_gb"]) && $v["band_suspend"] == 1 && empty($v["nw_suspended"]) && empty($globals["band_suspend"])) {
                $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_13";
                if($this->suspend_vps_net($v["vpsid"])) {
                    echo "Suspending network of VPSID " . $k . " as bandwidth has been overused. Used : " . $bandwidth_val["used_gb"] . " Allowed : " . $bandwidth_val["limit_gb"] . "\n";
                    $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                    if(!empty($v["email"]) && empty($globals["disable_suspend_email"])) {
                        send_emailtemp_mail("bandwidth", $v["email"], $email_vars, 1);
                    }
                    $data["title"] = $l["bandwidth_mail_sub"];
                    $data["data"] = lang_vars_name($l["bandwidth_mail_message_notify"], $email_vars);
                    save_notification("vps_band_suspended", $data);
                    $reason = serialize(["id" => "2", "reason" => "bw", "date" => time()]);
                    $res = makequery("UPDATE vps \n\t\t\t\t\t\t\tSET nw_suspended = :reason\n\t\t\t\t\t\t\tWHERE vpsid=:vpsid", [":vpsid" => $v["vpsid"], ":reason" => $reason]);
                    $v["nw_suspended"] = $reason;
                    vps_task("bandwidth_unsuspend", $v["vps_name"], 0, $v["vpsid"], $v["uid"], 1);
                    logs_vps("bandwidth_suspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", $reason);
                }
            }
            $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_14";
            handle_speed_cap($v, $this, $bandwidth_val);
            $GLOBALS["cronm_exit_ret"]["xcp"][] = "xcp_kernel_cronm_15";
        }
    }
    public function cronh()
    {
        $vps_disk_usage = get_vps_disk_usage("xcp");
        foreach ($vps_disk_usage as $vpsid => $disk_usage) {
            to_master("vps", "cached_disk", $vpsid, "vpsid", serialize($disk_usage));
        }
    }
    public function network_speed($vid, $dev1 = [], $dev2 = [])
    {
        $vps = getvps($vid);
        $ret["speed"] = 0;
        $ret["upload"] = 0;
        $ret["download"] = 0;
        $value = $this->_network_usage($vid, $dev1);
        if(empty($value["in"]) && empty($value["out"])) {
        } else {
            if(empty($dev2)) {
                usleep(1000000);
            }
            $value2 = $this->_network_usage($vid, $dev2);
        }
        if($value2["in"] < $value["in"]) {
            $value2["in"] = $value["in"];
            $value2["out"] = $value["out"];
        }
        $ret["download"] = $value2["in"] - $value["in"];
        $ret["upload"] = $value2["out"] - $value["out"];
        $ret["speed"] = $ret["upload"] + $ret["download"];
        return $ret;
    }
    public function resources()
    {
        global $globals;
        $ret["licnumvs"] = $globals["licnumvs"];
        $ret["ram"] = 0;
        $ret["space"] = 0;
        $ret["total_ram"] = 0;
        $ret["total_space"] = 0;
        $ret["check_kernel"] = $this->check_kernel();
        $ret["lv"] = $globals["lv"];
        $ret["thin_lv"] = $globals["thin_lv"];
        $ret["disk_path"] = $globals["disk_path"];
        oexec("xe host-list name-label=\$(hostname) --minimal", $output);
        $ret["unique_txt"] = trim($output);
        vexec("/usr/bin/xe host-list uuid=\$(xe host-list name-label=\$(hostname) --minimal) params=memory-total,memory-free", $output, $return);
        foreach ($output as $k => $v) {
            $tmp = explode(":", $v);
            if(strpos(trim($tmp[0]), "memory-total") !== false) {
                $ret["total_ram"] = @round((double) @trim($tmp[1]) / 1024 / 1024);
            }
            if(strpos(trim($tmp[0]), "memory-free") !== false) {
                $ret["ram"] = @round((double) @trim($tmp[1]) / 1024 / 1024);
            }
        }
        if(!empty($globals["lv"])) {
            vexec($globals["com"]["vgdisplay"] . " -C --nosuffix --units k \"" . $globals["lv"] . "\"", $disk);
            if(!empty($disk[1])) {
                $tmp = explode(" ", $disk[1]);
                $ret["space"] = @round((double) @trim($tmp[@count($tmp) - 1]) / 1024 / 1024, 2);
                $ret["total_space"] = @round((double) @trim($tmp[@count($tmp) - 2]) / 1024 / 1024, 2);
            }
        }
        if(preg_match("/xcp/is", $globals["kernel"])) {
            vexec("/usr/bin/xe host-list uuid=\$(xe host-list name-label=\$(hostname) --minimal) params=all | grep hvm", $ishvm);
            if(!empty($ishvm) && 0 < count($ishvm)) {
                $ret["hvm"] = 1;
            }
        }
        $ret["cpucores"] = get_cores();
        return $ret;
    }
    public function changeVncPass($vid, $newpassword)
    {
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        vexec("/usr/sbin/useradd " . xss("vs" . $vps["vps_name"]) . " -s /usr/local/virtualizor/scripts/tunnel_shell -M");
        vexec("/bin/echo " . xss($newpassword) . " | passwd --stdin " . xss("vs" . $vps_name));
        return true;
    }
    public function vifname($vid)
    {
        return "vif" . $this->getDOMU_id($vid) . ".0";
    }
    public function tc_create($vid)
    {
        $interface = $this->vifname($vid);
        return vs_tc_create($vid, $interface);
    }
    public function tc_destroy($vid)
    {
        $interface = $this->vifname($vid);
        return vs_tc_destroy($interface);
    }
    public function restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit, $storagename = "")
    {
        global $globals;
        global $error;
        global $l;
        $last_actid = $GLOBALS["current_taskid"];
        $this->poweroff($vps["vpsid"]);
        $GLOBALS["current_taskid"] = $last_actid;
        vexec("vgchange -ay");
        $DISK = get_vps_disk($vps["vpsid"], "", $disk_num);
        if(preg_match("/file/is", $DISK["type"]) && preg_match("/vhd/is", $DISK["format"])) {
            $backup_filename_raw = "";
            $uncompression = get_decompression_algo($backup_filename, 1, 0);
            if(in_array($uncompression["file_ext"], ["gz", "lzo", "zst", "lz4"])) {
                $backup_filename_raw = basename($backup_filename, "." . $uncompression["file_ext"]);
                vexec($uncompression["compression_algo"] . " " . $uncompression["params"] . " " . xss($temp_restore_dir . "/" . $backup_filename) . " > " . xss($temp_restore_dir . "/" . $backup_filename_raw) . ($uncompression["file_ext"] == "zst" ? " " : " 2>&1"), $o, $ret);
                if($ret != "0") {
                    if(file_exists($temp_restore_dir . "/" . $backup_filename_raw)) {
                        @unlink($temp_restore_dir . "/" . $backup_filename_raw);
                    }
                    $error[] = $l["xen_err_dd"];
                    return false;
                }
            }
            vexec("/usr/bin/xe vdi-import uuid=" . $DISK["uuid"] . " filename=" . $temp_restore_dir . "/" . (!empty($backup_filename_raw) ? $backup_filename_raw : $backup_filename) . "", $o, $ret);
            if($ret != "0") {
                $error[] = $l["xen_err_dd"];
                return false;
            }
            $tmp_backup_filename_raw = !empty($backup_filename_raw) ? $backup_filename_raw : $backup_filename;
            if(file_exists($temp_restore_dir . "/" . $tmp_backup_filename_raw)) {
                @unlink($temp_restore_dir . "/" . $tmp_backup_filename_raw);
            }
        } else {
            $sparse = "";
            if(preg_match("/thin block/i", $DISK["type"])) {
                $sparse = "conv=sparse";
            }
            $throttle_block_size = get_throttle_block_size();
            $uncompression = get_decompression_algo($backup_filename, 1, 0);
            if(!empty($uncompression["compression_algo"])) {
                vexec($uncompression["compression_algo"] . " " . $uncompression["params"] . " " . $temp_restore_dir . "/" . $backup_filename . (empty($io_limit) ? "" : " | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " | dd " . $sparse . " of=" . $DISK["path"] . " bs=24M 2>&1", $o, $ret);
            } else {
                vexec("/bin/dd " . $sparse . " if=" . $temp_restore_dir . "/" . $backup_filename . (empty($io_limit) ? "" : " bs=24M | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit . " | dd") . " of=" . $DISK["path"] . " bs=24M 2>&1", $o, $ret);
            }
            if($ret != "0") {
                $error[] = $l["xen_err_dd"];
                return false;
            }
        }
        return true;
    }
    public function backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit)
    {
        global $globals;
        global $error;
        global $l;
        $append = empty($disk_num) ? "" : "_" . $disk_num;
        $append .= "_" . parse_backup_hostname($vps["hostname"]);
        $DISK = get_vps_disk($vps["vpsid"], "", $disk_num);
        $compression = get_compression_algo(1, 0);
        if(preg_match("/file/is", $DISK["type"]) && preg_match("/vhd/is", $DISK["format"])) {
            $filename = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . "." . "img";
            vexec("/usr/bin/xe vdi-clone uuid=" . $DISK["uuid"] . " 2>&1", $output, $ret);
            if($ret != "0") {
                $error[] = $l["temp_snap_err"];
                return false;
            }
            $snap_shot_uuid = $output[0];
            vexec("/usr/bin/xe vdi-export uuid=" . $snap_shot_uuid . " filename=" . xss($temp_backup_dir . "/" . $filename) . " format=raw --progress 2>&1", $out, $ret);
            if($ret != "0") {
                $error[] = $l["log_xcp_err_drive_backup"];
                vexec("/usr/bin/xe vdi-destroy uuid=" . $snap_shot_uuid . " 2>&1", $output, $ret);
                if($ret != "0") {
                    $error[] = $output[0];
                }
            }
            if(!empty($error)) {
                return false;
            }
            if(empty($disable_compress)) {
                if(preg_match("/" . $compression["file_ext"] . "/is", ".img.zst") || preg_match("/" . $compression["file_ext"] . "/is", ".img.lz4") || preg_match("/" . $compression["file_ext"] . "/is", ".img.lzo") || preg_match("/" . $compression["file_ext"] . "/is", ".img.gz")) {
                    $compression["file_ext"] = "." . substr(strrchr($compression["file_ext"], "."), 1);
                }
                if(preg_match("/" . $compression["file_ext"] . "/is", ".zst")) {
                    $compression["compression_algo"] = preg_replace("/-c/is", "", $compression["compression_algo"]);
                    vexec($compression["compression_algo"] . " " . xss($temp_backup_dir . "/" . $filename) . " 2>&1", $o, $r);
                } else {
                    vexec($compression["compression_algo"] . " " . xss($temp_backup_dir . "/" . $filename) . " > " . xss($temp_backup_dir . "/" . $filename . $compression["file_ext"]) . " 2>&1", $o, $r);
                }
                unlink($temp_backup_dir . "/" . $filename);
                $filename = $filename . $compression["file_ext"];
                if($r != 0) {
                    $error["err_backup_command_fail"] = $l["err_backup_command_fail"] . $ret;
                }
            }
            vexec("/usr/bin/xe vdi-destroy uuid=" . $snap_shot_uuid . " 2>&1", $output, $ret);
            if($ret != "0") {
                $error[] = $output[0];
            }
            $ret_backup_filename = $filename;
        } else {
            $compressed_backup = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . $compression["file_ext"];
            $uncompressed_backup = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . ".img";
            vexec("vgchange -ay");
            $DISK = vpsdisk_snapshot_create($vps["vpsid"], "backup-" . $vps["vps_name"], $disk_num);
            if(empty($DISK)) {
                $error[] = $l["temp_snap_err"];
                return false;
            }
            $sparse = "";
            if(preg_match("/thin block/i", $DISK["type"])) {
                $sparse = "conv=sparse";
            }
            $throttle_block_size = get_throttle_block_size();
            if(empty($disable_compress)) {
                $ret = vexec("/bin/dd if=" . $DISK["snapshot_path"] . " bs=24M " . (!empty($globals["disable_dd_flags"]) ? "" : "iflag=direct ") . " | " . $compression["compression_algo"] . " " . (empty($io_limit) ? "" : "| throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " | dd " . $sparse . " of=\"" . $temp_backup_dir . "/" . $compressed_backup . "\" bs=24M 2>&1;");
                $ret_backup_filename = $compressed_backup;
            } else {
                $ret = vexec("/bin/dd if=" . $DISK["snapshot_path"] . " bs=24M " . (!empty($globals["disable_dd_flags"]) ? "" : "iflag=direct ") . (empty($io_limit) ? "" : " | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit . " | dd bs=24M ") . " " . $sparse . " of=\"" . $temp_backup_dir . "/" . $uncompressed_backup . "\" 2>&1");
                $ret_backup_filename = $uncompressed_backup;
            }
            if($ret != 0) {
                $error["err_backup_command_fail"] = $l["err_backup_command_fail"] . $ret;
            }
            $snapshot_delete = vpsdisk_snapshot_delete($DISK);
            if(!empty($snapshot_delete)) {
                $error = merge_error($error, $snapshot_delete);
                return false;
            }
        }
        if(!empty($error)) {
            return false;
        }
        if(@vfilesize($temp_backup_dir . "/" . $ret_backup_filename) < 1 || !store_backup_inf($vps, $temp_backup_dir)) {
            return false;
        }
        return $ret_backup_filename;
    }
    public function create_rescue_disk($vid = 0, $root_password = "")
    {
        global $globals;
        global $error;
        global $l;
        oslist();
        $vps = getvps($vid);
        $actid = vps_task("enable_rescuevs", "", 0, $vid, $vps["uid"], 0, $l["enable_rescuevs"]);
        task_start($actid);
        task_update($actid, $l["enabling_rescue"], 5);
        $GLOBALS["rescue"]["xcp"] = $GLOBALS["ostemplates_rescue"]["xcp"]["size"];
        $GLOBALS["rescue"]["xcp_hvm"] = $GLOBALS["ostemplates_rescue"]["xcp_hvm"]["size"];
        $templ_name = $GLOBALS["ostemplates_rescue"]["xcp_hvm"]["file"];
        $type = "xcp_hvm";
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        if(empty($vps["rescue"])) {
            $error[] = $l["rescue_not_synced"];
            return false;
        }
        $vps_name = $vps["vps_name"];
        $temp_loc = $globals["xcpos"] . "/" . $templ_name;
        if(!file_exists($temp_loc) || vfilesize($temp_loc) != $GLOBALS["rescue"][$type]) {
            task_update($actid, $l["download_rescue_temp"], 25);
            @unlink($temp_loc);
            $getfile = save_web_file("http://files.virtualizor.com/rescue.php?file=" . $templ_name, $temp_loc);
            if(empty($getfile) || vfilesize($temp_loc) != $GLOBALS["rescue"][$type]) {
                $error[] = $l["err_downloading"];
                task_update($actid, $l["err_downloading"], -1);
                return false;
            }
        }
        $this->poweroff($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "poweroff_vps");
        _task_update($actid, $l["power_off_vps"], 35, $next_actid);
        if(!empty($vps["suspended"])) {
            return true;
        }
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $routing = $ips[0]["routing"];
        task_update($actid, $l["creating_disk"], 40);
        $storage_create = vpsdisk_create($DISK);
        if(!empty($storage_create)) {
            $error[] = $l["kvm_err_lvm"];
            $error = merge_error($error, $storage_create);
            task_update($actid, $l["kvm_err_lvm"], -1);
            return false;
        }
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        krsort($disks);
        foreach ($disks as $dk => $dv) {
            oexec("xe vbd-param-set uuid=" . $dv["vbd_uuid"] . " userdevice=" . ($dk + 1));
        }
        task_update($actid, $l["copy_rescue"], 55);
        if(preg_match("/qcow2/is", $DISK["format"])) {
            $template_in_raw = substr($temp_loc, 0, -3);
            if(!(file_exists($template_in_raw) && is_safe_file($template_in_raw))) {
                vexec($globals["com"]["pgzip"] . " -dc " . xss($temp_loc) . " > " . xss($template_in_raw), $o, $ret);
            }
            vexec("qemu-img convert -f raw -O qcow2 " . xss($template_in_raw) . " " . xss($DISK["path"]), $o, $ret);
        } elseif(preg_match("/raw/is", $DISK["format"])) {
            vexec($globals["com"]["pgzip"] . " -dc " . xss($temp_loc) . " | /bin/dd of=" . xss($DISK["path"]) . " bs=24M 2>&1", $o, $ret);
        }
        if($ret != "0") {
            $error[] = $l["kvm_err_rescue_dd"];
            $error["derr"] = array_end($GLOBALS["logr"]);
            vpsdisk_destroy($DISK);
            task_update($actid, $l["kvm_err_rescue_dd"], -1);
            return false;
        }
        task_update($actid, $l["resizing_disk"], 60);
        $resize = vpsdisk_resize($vid);
        if(!empty($resize["error"])) {
            $error = merge_error($error, $resize["error"]);
            task_update($actid, implode("<br>", $error), -1);
            return false;
        }
        $DISK["diskinfo"] = $resize["diskinfo"];
        task_update($actid, $l["resizing_fs"], 63);
        $fs_resize = vpsdisk_resize_filesystem($DISK);
        if(!empty($fs_resize["error"])) {
            $error = merge_error($error, $fs_resize["error"]);
            task_update($actid, implode("<br>", $error), -1);
            return false;
        }
        task_update($actid, $l["mount"], 65);
        $mount = mount($vid);
        if(!is_array($mount)) {
            $error[] = $l["kvm_err_mount"];
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        $post = [];
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            $shadow = file($mount["mount_point"] . "/etc/shadow");
            $tmp = explode(":", $shadow[0]);
            $tmp[1] = crypt($root_password);
            $shadow[0] = implode(":", $tmp);
            writefile($mount["mount_point"] . "/etc/shadow", implode("", $shadow), 1);
        }
        if(!empty($vps["dns_nameserver"])) {
            $dns = unserialize($vps["dns_nameserver"]);
            $post["dns"] = $dns;
        }
        task_update($actid, $l["net_config"], 70);
        network_configure($mount["mount_point"], $ips, $post, $routing);
        task_update($actid, $l["hostname_config"], 75);
        hostname_configure($mount["mount_point"], "rescue");
        task_update($actid, $l["sshkey_clean"], 80);
        sshkey_clean($mount["mount_point"]);
        task_update($actid, $l["umount"], 85);
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        $this->start($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "start_vps");
        _task_update($actid, $l["beginning_start_vps"], 95, $next_actid);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function delete_rescue_disk($vid = 0)
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("disable_rescuevs", "", 0, $vid, $vps["uid"], 0, $l["disable_rescuevs"]);
        task_start($actid);
        task_update($actid, $l["disabling_rescue"], 5);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        $this->poweroff($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "poweroff_vps");
        _task_update($actid, $l["power_off_vps"], 35, $next_actid);
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        if(!empty($DISK["rescue"])) {
            task_update($actid, $l["delete_vpsdisks"], 45);
            $storage_destroy = vpsdisk_destroy($DISK);
            if(!empty($storage_destroy)) {
                $error = merge_error($error, $storage_destroy);
                task_update($actid, implode("<br>", $error), -1);
                return false;
            }
        }
        ksort($disks);
        unset($disks[-1]);
        foreach ($disks as $dk => $dv) {
            oexec("xe vbd-param-set uuid=" . $dv["vbd_uuid"] . " userdevice=" . $dk);
        }
        if(!empty($vps["suspended"])) {
            return true;
        }
        $this->start($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "start_vps");
        _task_update($actid, $l["beginning_start_vps"], 75, $next_actid);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function storage_check($data)
    {
        if($data["type"] == "block") {
            exec("vgdisplay " . $data["path"] . " >> /dev/null 2>&1", $vgout, $vgret);
            if($vgret != 0) {
                return "The Volume Group doesn't exist";
            }
            return "";
        }
        if(preg_match("/ceph/is", $data["type"])) {
            exec("ceph osd lspools", $cephout, $cephret);
            foreach ($cephout as $k => $v) {
                if(preg_match("/" . basename($data["path"]) . "/is", $v)) {
                    return "";
                }
            }
            return "The Ceph Pool doesn't exist";
        } else {
            if(!preg_match("/zfs/is", $data["type"]) && preg_match("/thin/is", $data["type"]) && preg_match("/block/is", $data["type"])) {
                return "The Thin LVM Pool is not supported on XenServer";
            }
            if(preg_match("/zfs/is", $data["type"])) {
                exec("zfs list >> /dev/null 2>&1", $vgout, $vgret);
                if($vgret != 0) {
                    return "ZFS module is either not installed or not configured properly on this server.";
                }
                exec("zpool status " . basename($data["path"]), $out, $ret);
                if($ret != 0) {
                    return "This ZFS pool does not exist on the server.";
                }
                return "";
            }
            if($data["format"] != "raw" && $data["format"] != "vhd") {
                return "Only Raw / VHD format is supported on XenServer";
            }
            if($data["type"] != "block" && $data["type"] != "file") {
                return "Only Block / File Storage Type is supported on XenServer";
            }
            if(!file_exists($data["path"])) {
                return "The storage doesn't exist";
            }
            return "";
        }
    }
    public function _network_usage($vid, $dev = [])
    {
        if(empty($dev)) {
            $dev = file("/proc/net/dev");
        }
        $devices = [];
        foreach ($dev as $k => $x) {
            $_dev = preg_split("/[\\s]+/", str_replace(":", ": ", trim($x)));
            $_dev[0] = trim($_dev[0], ":");
            foreach ($_dev as $kk => $vv) {
                $tmp[$kk] = trim($vv);
            }
            $devices[$tmp[0]] = $tmp;
        }
        $value = $devices["vif" . $this->getDOMU_id($vid) . ".0"];
        if(empty($value[1]) && empty($value[9])) {
            $value[1] = 0;
            $value[9] = 0;
        }
        list($c["out"], $c["in"]) = $value;
        return $c;
    }
    public function _cpu_stats()
    {
        vexec("xentop -d 2 -i 2 -b", $tmp_out, $tmp_ret);
        $i = 0;
        foreach ($tmp_out as $tk => $tv) {
            if($i == 2) {
                $tmp_data = explode(" ", $tv);
                $final_data = [];
                foreach ($tmp_data as $tkk => $tvv) {
                    if(empty($tvv)) {
                    } else {
                        $final_data[] = $tvv;
                    }
                }
                $res["name"] = empty($final_data[0]) ? 0 : trim($final_data[0]);
                $ret[$res["name"]]["mem"] = empty($final_data[5]) ? 0 : trim($final_data[5]);
                $ret[$res["name"]]["cpu"] = empty($final_data[3]) ? 0 : trim($final_data[3]);
            }
            if(preg_match("/Domain-0/is", $tv)) {
                $i++;
            }
        }
        return $ret;
    }
    public function delete_vpsdisks($vpsid, $data, $actid = 0)
    {
        global $error;
        global $user;
        global $l;
        $status = no_log_status($vpsid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("delete_vpsdisks", $disk_data, 0, $vpsid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "delete_vpsdisks", "vpsid" => $vpsid, "actid" => $actid]);
                $disk_data = serialize($data);
                return -1;
            }
        }
        task_start($actid);
        foreach ($data as $k => $DISK) {
            $DISK["vpsid"] = $vpsid;
            $disk_destroy = vpsdisk_destroy($DISK);
            if(!empty($disk_destroy)) {
                $error = merge_error($error, $disk_destroy);
                task_update($actid, $l["disk_destroy_err"], -1);
                return false;
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vs_ntw_speed($vpsids)
    {
        $ret = [];
        $dev1 = file("/proc/net/dev");
        usleep(1000000);
        $dev2 = file("/proc/net/dev");
        foreach ($vpsids as $k => $v) {
            $ret[$v] = $this->network_speed($v, $dev1, $dev2);
        }
        return $ret;
    }
    public function vs_disk_usage($vpsids)
    {
        $ret = [];
        $res = makequery("SELECT * FROM vps WHERE vpsid IN (" . implode(",", $vpsids) . ")");
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $tmp = _unserialize($row["cached_disk"]);
            $ret[$row["vpsid"]]["disk"]["used"] = empty($tmp["disk"]["Used"]) ? 0 : $tmp["disk"]["Used"] / 1024 / 1024;
            $ret[$row["vpsid"]]["disk"]["allocated"] = $row["space"];
            $ret[$row["vpsid"]]["inode"]["used"] = empty($tmp["inode"]["IUsed"]) ? 0 : $tmp["inode"]["IUsed"];
            $ret[$row["vpsid"]]["inode"]["allocated"] = empty($tmp["inode"]["Inodes"]) ? 0 : $tmp["inode"]["Inodes"];
        }
        return $ret;
    }
    public function install_xentools($vid, $actid = 0, $mount_point = "")
    {
        global $globals;
        global $l;
        global $user;
        $mounted = 1;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("installxentools", "", 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "installxentools", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $vm_UUID = $this->getVM_uuid($vid);
        vexec("/usr/bin/xe vm-param-get param-name=PV-drivers-version uuid=" . $vm_UUID, $output, $ret);
        $xentools = cexplode(";", $output[0]);
        $ver = -1;
        foreach ($xentools as $xk => $xver) {
            if(preg_match("/database/i", $xentools)) {
            } else {
                $xver = cexplode(":", $xver);
                if(array_key_exists("major", $xver)) {
                    to_master("vps", "install_xentools", $vps["vpsid"], "vpsid", 1);
                    task_update($actid, $l["completed"], 100);
                    return true;
                }
                if($xver[0] == "micro") {
                    $ver = (int) $xver[1];
                }
            }
            if(0 <= $ver) {
                to_master("vps", "install_xentools", $vps["vpsid"], "vpsid", 1);
                task_update($actid, $l["completed"], 100);
                return true;
            }
            if(empty($mount_point)) {
                $mounted = 0;
                $mount = mount($vid, "", 1);
                if(!is_array($mount)) {
                    if($mount == -1) {
                        task_update($actid, $l["mount_undetermined"], -1);
                        return true;
                    }
                    task_update($actid, $l["kvm_err_mount"], -1);
                    return false;
                }
            } else {
                $mount["mount_point"] = $mount_point;
            }
            vexec("find /opt -name *.iso | grep guest-tools-*", $output, $ret);
            $guest_tool = trim($output[0]);
            if(empty($guest_tool)) {
                vexec("find / -name *.iso | grep guest-tools-*", $output, $ret);
                $guest_tool = trim($output[0]);
            }
            if(empty($guest_tool)) {
                task_update($actid, $l["xcp_xentools_missing"], -1);
                return false;
            }
            copy($guest_tool, $mount["mount_point"] . "/var/guest-tools.iso");
            if(file_exists($mount["mount_point"] . "/etc/redhat-release") || file_exists($mount["mount_point"] . "/etc/oracle-release")) {
                $rc_path = "/rc.d/rc.local";
            } elseif(file_exists($mount["mount_point"] . "/etc/debian_version")) {
                $rc_path = "/rc.local";
            }
            if(is_safe_file($mount["mount_point"] . "/etc" . $rc_path) && is_safe_file($mount["mount_point"] . "/root") && is_safe_file($mount["mount_point"] . "/etc/rc.local.original") && is_safe_file($mount["mount_point"] . "/etc/selinux/config") && is_safe_file($mount["mount_point"] . "/etc/selinux/config.orignal") && file_exists($mount["mount_point"] . "/etc" . $rc_path)) {
                if(!file_exists($mount["mount_point"] . "/etc/rc.local.original")) {
                    copy($mount["mount_point"] . "/etc" . $rc_path, $mount["mount_point"] . "/etc/rc.local.original");
                }
                $orig_rc = file_get_contents($mount["mount_point"] . "/etc" . $rc_path);
                $orig_rc = str_replace("exit 0", "#exit 0", $orig_rc);
                writefile($mount["mount_point"] . "/etc" . $rc_path, $orig_rc . "\nmount /var/guest-tools.iso /mnt -o loop\nyes | /mnt/Linux/install.sh\numount /mnt\nrm -f /var/guest-tools.iso\nmv /etc/rc.local.original /etc" . $rc_path, 1);
                chmod($mount["mount_point"] . "/etc" . $rc_path, 493);
                copy($mount["mount_point"] . "/etc/selinux/config", $mount["mount_point"] . "/etc/selinux/config.orignal");
                vexec("/bin/echo \"SELINUX=disabled\" > " . xss($mount["mount_point"] . "/etc/selinux/config"));
            }
            if($mounted) {
                task_update($actid, $l["completed"], 100);
                return true;
            }
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["xen_err_unmount"];
                task_update($actid, $l["xen_err_unmount"], -1);
                return false;
            }
            task_update($actid, $l["completed"], 100);
            to_master("vps", "install_xentools", $vps["vpsid"], "vpsid", 1);
            return true;
        }
    }
    public function migrate($vpsid, $data, $migrate_disk = 0)
    {
        global $globals;
        global $error;
        global $l;
        $speed = (int) (!empty($globals["default_mig_speed"]) ? $globals["default_mig_speed"] : 100);
        $sparse = 0;
        vexec("vgchange -ay");
        if(!empty($data["speed_limit"])) {
            $speed = $data["speed_limit"];
        }
        if(empty($data["disable_gzip"])) {
            $data["disable_gzip"] = 0;
        }
        if($data["dest_disks"][$data["disk_num"]]["type"] == "file" || $data["dest_disks"][$data["disk_num"]]["type"] == "thin block") {
            $sparse = 1;
        }
        $throttle_block_size = get_throttle_block_size();
        if(empty($migrate_disk)) {
            vexec("bash " . $globals["path"] . "/scripts/migrate_dd.sh " . $data["orig_disks"][$data["disk_num"]]["path"] . " " . $data["dest_disks"][$data["disk_num"]]["path"] . " " . $speed . " " . $data["to_ssh_port"] . " " . $data["to_ip"] . " " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log " . logdir($data["selected_act"]) . $data["vpsid"] . "-actual_transfer.log " . $data["disable_gzip"] . " " . $sparse . " " . xss($data["from_pgzip"]) . " " . xss($data["to_pgzip"]) . " " . xss($throttle_block_size) . " > " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $r);
        } else {
            $qcow2_to_raw = $raw_to_qcow2 = 0;
            if($data["dest_disks"][$data["disk_num"]]["qcow2_to_raw"]) {
                $qcow2_to_raw = 1;
            }
            if($data["dest_disks"][$data["disk_num"]]["raw_to_qcow2"]) {
                $raw_to_qcow2 = 1;
            }
            vexec("bash " . $globals["path"] . "/scripts/migrate_disk_dd.sh " . $data["orig_disks"][$data["disk_num"]]["path"] . " " . $data["dest_disks"][$data["disk_num"]]["path"] . " " . $speed . " " . logdir("migrate_disk") . $data["vpsid"] . "-transfer.log " . logdir("migrate_disk") . $data["vpsid"] . "-actual_transfer.log " . $data["disable_gzip"] . " " . $sparse . " " . xss($data["to_pgzip"]) . " " . $throttle_block_size . " " . $qcow2_to_raw . " " . $raw_to_qcow2 . " > " . logdir("migrate_disk") . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $r);
        }
        if($r != 0) {
            $error[] = $l["mig_err_bg_exec"];
            return false;
        }
        return true;
    }
    public function get_vps_bridge($vpsid)
    {
        $ret = [];
        if(empty($vpsid)) {
            return $ret;
        }
        $ips = [];
        $res = makequery("SELECT i.ippid, ip.ippid, ip.bridge, ip.ovs_bridge FROM `ips` \n\t\t\t\t\t\ti LEFT JOIN ippool ip ON (ip.ippid = i.ippid) WHERE i.vpsid = :vid \n\t\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vpsid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(!empty($row["bridge"])) {
                $ips[$row["bridge"]] = trim($row["bridge"]);
            }
        }
        if(!empty($ips)) {
            foreach ($ips as $k => $v) {
                oexec("/sbin/ifconfig " . $v . " 2>&1", $out, $return);
                if($return != "0") {
                    $ret[$v] = $v;
                }
            }
        }
        return $ret;
    }
    public function migrate_disk_used($vpsid)
    {
        global $globals;
        global $error;
        $vps = getvps($vpsid);
        $ret = [];
        foreach ($vps["disks"] as $k => $DISK) {
            $tmp_disk_size = vpsdisk_real_size($DISK);
            $ret[$k] = $tmp_disk_size / 1024 / 1024;
        }
        return $ret;
    }
    public function addsshkeys($vid, $ssh_keys, $actid = 0)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("addsshkeys", serialize($ssh_keys), 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "addsshkeys", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return false;
            }
            task_update($actid, $l["xcp_err_mount"], -1);
            return false;
        }
        if(!addsshkeys($mount["mount_point"], $ssh_keys)) {
            $error[] = $l["err_add_sshkeys"];
            task_update($actid, $l["err_add_sshkeys"], -1);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xcp_err_unmount"];
            task_update($actid, $l["xcp_err_unmount"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function removesshkeys($vid, $keys_to_remove, $actid = 0)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("removesshkeys", serialize($keys_to_remove), 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "removesshkeys", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return false;
            }
            task_update($actid, $l["xcp_err_mount"], -1);
            return false;
        }
        if(!removesshkeys($mount["mount_point"], $keys_to_remove)) {
            $error[] = $l["err_remove_sshkeys"];
            task_update($actid, $l["err_remove_sshkeys"], -1);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["xcp_err_unmount"];
            task_update($actid, $l["xcp_err_unmount"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function vbd_plug($vpsid, $DISK)
    {
        global $error;
        if($DISK["format"] != "vhd") {
            return true;
        }
        if($DISK["type"] != "file") {
            vexec("vgchange -ay");
        }
        $vm_uuid = $this->getVM_uuid($vpsid);
        $vdi_uuid = $this->getVDI_uuid_from_path($DISK);
        $srpath = cleanpath(dirname($DISK["path"]));
        $sruuid = substr($srpath, strlen($srpath) - 36);
        vexec("/usr/bin/list_domains -domid 0 -minimal", $h_o, $h_r);
        $host_uuid = $h_o[0];
        oexec("/usr/bin/xe vbd-list vdi-uuid=" . xss($vdi_uuid) . " params=all", $vbd_list, $vbd_ret);
        $vbd_list = xcp_data_parser($vbd_list);
        foreach ($vbd_list as $k => $v) {
            if($v["currently-attached"] == "true") {
                $DISK["orig_path"] = $DISK["path"];
                $DISK["path"] = "/dev/" . $v["device"];
                return $DISK;
            }
        }
        oexec("xe vbd-list params=uuid,userdevice vm-uuid=" . xss($host_uuid), $dev_list, $dev_ret);
        $dev_list = xcp_data_parser($dev_list);
        $used_devices = [];
        foreach ($dev_list as $k => $v) {
            $v["userdevice"] = (int) $v["userdevice"];
            $used_devices[$v["userdevice"]] = $v["userdevice"];
        }
        for ($i = 1; $i <= 1000; $i++) {
            if(empty($used_devices[$i])) {
                $dev_number = $i;
                break;
            }
        }
        vexec("/usr/bin/xe vdi-list sr-uuid=" . xss($sruuid) . " uuid=" . xss($vdi_uuid) . " --minimal", $vdi_uuid_o, $vdi_uuid_r);
        $vdi_uuid = $vdi_uuid_o[0];
        vexec("/usr/bin/xe vbd-create vm-uuid=" . xss($host_uuid) . " vdi-uuid=" . xss($vdi_uuid) . " device=" . $dev_number, $nvuuid_o, $nvuuid_r);
        $new_vbd_uuid = $nvuuid_o[0];
        $plugged = vexec("/usr/bin/xe vbd-plug uuid=" . xss($new_vbd_uuid), $plug_out, $plug_ret);
        if($plug_ret != 0) {
            $error[] = "[vbd_plug] Could not plug the VBD for mount";
            return false;
        }
        vexec("/usr/bin/xe vbd-list uuid=" . xss($new_vbd_uuid) . " params=device --minimal", $plug_out, $plug_ret);
        $plugged_path = $plug_out[0];
        $DISK["orig_path"] = $DISK["path"];
        $DISK["path"] = "/dev/" . $plugged_path;
        return $DISK;
    }
    public function vbd_unplug($DISK)
    {
        if($DISK["format"] != "vhd") {
            return true;
        }
        $vdi_uuid = $this->getVDI_uuid_from_path($DISK);
        oexec("/usr/bin/xe vbd-list vdi-uuid=" . xss($vdi_uuid) . " params=all", $vbd_list, $vbd_ret);
        $vbd_list = xcp_data_parser($vbd_list);
        foreach ($vbd_list as $k => $v) {
            if($v["currently-attached"] == "true" && !empty($v["device"])) {
                $vbd_uuid = $k;
                $device = $v["device"];
                if(empty($vbd_uuid)) {
                    echo "\n[vbd_unplug] Returning as no UUID found";
                    return false;
                }
                if($DISK["format"] == "vhd") {
                    vexec("/sbin/kpartx -d " . $DISK["path"], $kpart, $kparted);
                } else {
                    kpartx_delete($DISK);
                }
                $unplugged = vexec("xe vbd-unplug uuid=" . xss($vbd_uuid), $unplug_out, $unplug_ret);
                if($unplug_ret != 0) {
                    $error[] = "\n[vbd_unplug] Could not unplug the device !!";
                    return false;
                }
                vexec("xe vbd-destroy uuid=" . xss($vbd_uuid));
                return true;
            }
        }
    }
    public function get_io_usage($vid = 0)
    {
        $delay = 3;
        $vpses = [];
        $io_usage = [];
        $token_val = [];
        $query = "SELECT vpsid, vps_name FROM vps\n\t\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\t\tAND virt = 'xcp'";
        if(!empty($vid)) {
            $query .= " AND vpsid = :vid";
            $token_val[":vid"] = $vid;
        }
        $res = makequery($query, $token_val);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
            $io_usage[$row["vpsid"]] = ["read" => 0, "write" => 0];
        }
        vexec("xentop -b -d " . $delay . " -i 2 2> /dev/null", $out, $ret);
        if($ret != 0) {
            return false;
        }
        foreach ($out as $line) {
            $parts = preg_split("/\\s+/is", trim($line));
            if(count($parts) < 19) {
            } else {
                foreach ($vpses as $v) {
                    if($v["vps_name"] == $parts[0]) {
                        $vps = $v;
                        if(empty($vps)) {
                        } else {
                            $vpsid = $vps["vpsid"];
                            $io_usage[$vpsid]["read"] = $parts[16] - $io_usage[$vpsid]["read"];
                            $io_usage[$vpsid]["write"] = $parts[17] - $io_usage[$vpsid]["write"];
                        }
                    }
                }
            }
        }
        $sector_size = 512;
        foreach ($io_usage as $vpsid => $usage) {
            $io_usage[$vpsid]["read"] = round($io_usage[$vpsid]["read"] * $sector_size / $delay);
            $io_usage[$vpsid]["write"] = round($io_usage[$vpsid]["write"] * $sector_size / $delay);
        }
        return $io_usage;
    }
    public function kill_socat($vid)
    {
        $vps = getvps($vid);
        $vnc_port = $vps["vncport"];
        if(os_check("xcp", ">=", "7.6")) {
            vexec("ps aux | grep \"[s]ocat TCP-LISTEN:" . $vnc_port . "\"", $out, $ret);
            if($ret == 0 && !empty($out)) {
                foreach ($out as $ok => $kill_proc) {
                    $tmp = preg_split("/\\s+/", $kill_proc);
                    vexec("kill -9 " . trim($tmp[1]));
                }
            }
        }
    }
    public function vdbkpartx($vid, $DISK)
    {
        if(empty($DISK["path"])) {
            return false;
        }
        if($DISK["type"] == "file") {
            return true;
        }
        if(!empty($DISK["type"]) && $DISK["type"] == "block" && $DISK["format"] == "vhd") {
            $disk_name = "";
        } else {
            $disk_name = trim(basename($DISK["path"]));
        }
        if(!empty($disk_name)) {
            vexec("cd " . dirname($DISK["path"]) . "; /sbin/kpartx -l " . $disk_name, $kpart, $kparted);
        } else {
            vexec("/sbin/kpartx -l " . $DISK["path"], $kpart, $kparted);
        }
        sleep(1);
        $is_centos5 = os_check("centos", "<", 6);
        $kpartx_s = !empty($is_centos5) ? "" : "s";
        unset($kparted);
        if(!empty($disk_name)) {
            vexec("cd " . dirname($DISK["path"]) . "; /sbin/kpartx -av" . $kpartx_s . " " . $disk_name, $_kpart, $kparted);
        } else {
            vexec("/sbin/kpartx -av" . $kpartx_s . " " . $DISK["path"], $_kpart, $kparted);
        }
        sleep(1);
        if($kparted != 0) {
            return "";
        }
        $maps = [];
        foreach ($_kpart as $k => $v) {
            $tmp = explode(" ", $v);
            if($tmp[0] != "add") {
            } else {
                $maps[] = "/dev/mapper/" . $tmp[2];
            }
        }
        $KPARTX["maps"] = $maps;
        $KPARTX["raw_list"] = $kpart;
        return $KPARTX;
    }
    public function vhd_umount($vpsid, $DISK)
    {
        if($DISK["type"] != "file" || $DISK["format"] != "vhd" || empty($DISK["path"])) {
            return true;
        }
        $tries = 0;
        $kret = 1;
        while ($kret != 0) {
            usleep(500000);
            if($tries != 0 && 3 < $tries) {
                break;
            }
            $tries++;
            vexec("/sbin/kpartx -d " . $DISK["path"], $ko, $kret);
        }
        $this->vbd_unplug($DISK);
        return true;
    }
    public function change_disk($vpsid, $DISK)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vpsid);
        $disk_data = serialize($DISK);
        $actid = vps_task("changedisk", $disk_data, 0, $vpsid, $vps["uid"], 0, $l["Change_disk"]);
        task_start($actid);
        task_update($actid, $l["setting_disk"], 57);
        $vm_uuid = $this->getVM_uuid($vpsid);
        foreach ($DISK as $sk => $sv) {
            $vdi_uuid = $this->getVDI_uuid_from_path($DISK[$sk]);
            $command = "/usr/bin/xe vbd-create bootable=" . (0 < $sv["key"] ? "false" : "true") . " mode=RW type=Disk device=" . $this->getVBD_available_device($vpsid) . " vm-uuid=" . $vm_uuid . " vdi-uuid=" . $vdi_uuid;
            vexec($command, $vbd_disk_uuid_out, $ret);
            if($ret != "0") {
                $error[] = "Error creating VBD";
                task_update($actid, $l["Error creating VBD"], -1);
                return false;
            }
            $vdi_uuid = $command = $ret = "";
        }
        task_update($actid, $l["completed"], 100);
        if(empty($error)) {
            return true;
        }
    }
}
function xcp_data_parser($outputs, $index_key = "uuid")
{
    $outputs = explode("\n\n\n", $outputs);
    $return = [];
    foreach ($outputs as $rk => $out) {
        $vps_data = xcp_data_exploder($out);
        if(empty($vps_data)) {
        } else {
            $return[$vps_data[$index_key]] = $vps_data;
        }
    }
    return $return;
}
function xcp_data_exploder($out, $delim = "\n", $strip5 = 1)
{
    if(empty($out)) {
        return NULL;
    }
    $output = explode($delim, $out);
    $vps_data = [];
    foreach ($output as $k => $v) {
        $v = trim($v);
        if(empty($v)) {
        } else {
            $temp_string = explode(":", trim($v));
            if($strip5) {
                $temp_string[0] = trim(substr(trim($temp_string[0]), 0, -5));
            }
            if(2 < count($temp_string)) {
                $_temp_string = $temp_string;
                unset($_temp_string[0]);
                $temp_string[1] = implode(":", $_temp_string);
            }
            $vps_data[$temp_string[0]] = trim($temp_string[1]);
        }
    }
    return $vps_data;
}

?>