<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once dirname(dirname(__FILE__)) . "/scripts/inc.php";
$release = file_get_contents("/etc/redhat-release");
if(preg_match("/release 5/is", $release)) {
    $av = "av";
} else {
    $av = "avs";
}
$stid = storage_get_primary("kvm");
if(!preg_match("/block/is", $storages[$stid]["type"])) {
    mydie("Storage Type not supported");
}
$thinpool = "";
if(preg_match("/thin/is", $storages[$stid]["type"])) {
    $thinpool = storage_thin_path($storages[$stid]);
    $tmp = explode("/", $thinpool);
    array_pop($tmp);
    $vg = implode("/", $tmp);
} else {
    $vg = $storages[$stid]["path"];
}
echo "The Volume Group is " . $vg . " \n";
$createin = $globals[server_primary_virt(0) . "os"];
list($block, $name) = $argv;
echo "The block device is " . $block . " \n\nThe template will be created with the name " . $name . " \n\n";
if(!file_exists($block)) {
    exit("\n\nNo block device found");
}
if(file_exists($createin . "/" . $name)) {
    exit("\n\nA file with the same template exists : " . $createin . "/" . $name);
}
if(file_exists($createin . "/" . basename($block) . ".img")) {
    exit("\n\nThe block device base name file " . basename($block) . ".img already exists");
}
cloneblock($block, $oblock);
resize_ntfs($vg . "/WINTOOL");
vexec("/sbin/kpartx -l " . $block, $kpart, $kparted);
vexec("/sbin/kpartx -" . $av . " " . $block, $_kpart, $kparted);
if($kparted != "0") {
    mydie("There was an error KPARTING the BLOCK Device");
}
$tmp = explode(" ", $kpart[0]);
$mapper = $tmp[0];
passthru("ntfsclone --force --save-image --output " . $createin . "/" . basename($block) . ".img /dev/mapper/" . $mapper . " 2>&1", $ret);
if($ret != "0") {
    mydie("Could not clone the partition");
}
if(vexec("/sbin/kpartx -d " . $block) != 0) {
    mydie("Could not DELETE the MAPPER of the BLOCK device");
}
$size = ceil(vfilesize($createin . "/" . basename($block) . ".img") / 1024 / 1024 / 1024) + 2;
echo "\n\nThe template size will be " . $size . " G" . "\nCreating the template ... \n\n";
oexec("dd if=/dev/zero of=" . $createin . "/" . $name . " bs=24M count=" . ceil($size * 1024 / 24) . " 2>&1", $dd, $ret);
if($ret != "0") {
    mydie("Could not CREATE the ZERO SPACED files\n" . $dd);
}
oexec("losetup -f", $loop_device, $ret);
oexec("losetup " . $loop_device . " " . $createin . "/" . $name, $losetup, $ret);
if($ret != "0") {
    $loop_device_name = explode("/", $loop_device);
    mydie("Could not create the " . $loop_device_name[2] . " device. Please delete an losetup on " . $loop_device . "");
}
oexec("dd if=" . $block . " of=" . $loop_device . " bs=512 count=1 2>&1", $mbr, $ret);
if($ret != "0") {
    mydie("Could not copy the MBR");
}
$disk = diskinfo("" . $loop_device . "");
echo "\nDump of '." . $loop_device . ".'\n";
r_print($disk);
vexec("sfdisk " . $loop_device . " -uS --force << EOF\n" . $disk["parts"][0]["start"] . ",," . $disk["parts"][0]["hextype"] . "," . $disk["parts"][0]["boot"] . "\n0,0\n0,0\n0,0\nEOF", $o, $ret);
if($ret != "0") {
    mydie("Could not REFORMAT the MBR");
}
echo "\nKparting '." . $loop_device . ".'\n";
vexec("/sbin/kpartx -l " . $loop_device . "", $kpart, $kparted);
vexec("/sbin/kpartx -" . $av . " " . $loop_device . "", $_kpart, $kparted);
if($kparted != "0") {
    mydie("There was an error KPARTING the LOOP Device");
}
echo "\nKparting '." . $loop_device . ".'\n";
$tmp = explode(" ", $kpart[0]);
$mapper = $tmp[0];
oexec("ntfsclone --restore-image --overwrite /dev/mapper/" . $mapper . " " . $createin . "/" . basename($block) . ".img 2>&1", $ntfsclone, $ret);
if($ret != "0") {
    mydie("Could not clone the partition to the LOOP Template\n" . $ntfsclone);
}
sleep(5);
if(vexec("/sbin/kpartx -d " . $loop_device . "") != 0) {
    mydie("Could not DELETE the MAPPER of the BLOCK device");
}
oexec("losetup -d " . $loop_device . "", $losetup, $ret);
if($ret != "0") {
    exit("Could not delete the losetup but the template was created");
}
unlink($GLOBALS["createin"] . "/" . basename($GLOBALS["block"]) . ".img");
vexec($globals["com"]["lvremove"] . " -f " . $vg . "/WINTOOL");
echo "\n\nThe template was created successfully at " . $createin . "/" . $name . "\n\n";
if(defined("debug")) {
    r_print($GLOBALS["logr"]);
}
function cloneblock(&$block, &$oblock)
{
    global $globals;
    global $vg;
    global $thinpool;
    echo "\n\nCreating Block Device Clone ... \n\n";
    if(file_exists($vg . "/WINTOOL")) {
        vexec("/sbin/kpartx -d " . $vg . "/WINTOOL");
        vexec($globals["com"]["lvremove"] . " -f " . $vg . "/WINTOOL");
    }
    exec("lvdisplay -C --nosuffix -o lv_size --units g \"" . $block . "\" 2>/dev/null", $lvsize);
    if(empty($lvsize[1])) {
        mydie("Could not determine BLOCK size");
    }
    $gb = trim($lvsize[1]);
    echo "Size of Block Device : " . $gb . " \n\n";
    if(!empty($thinpool)) {
        vexec($globals["com"]["lvcreate"] . " -V" . $gb . "G -n WINTOOL -T " . $thinpool);
    } else {
        vexec("lvcreate -L " . $gb . "G -n WINTOOL " . $vg);
    }
    passthru("dd if=\"" . $block . "\" of=" . $vg . "/WINTOOL bs=24M 2>&1");
    $oblock = $block;
    $block = $vg . "/WINTOOL";
}
function resize_ntfs($block)
{
    global $av;
    vexec("/sbin/kpartx -l " . $block, $kpart, $kparted);
    vexec("/sbin/kpartx -" . $av . " " . $block, $_kpart, $kparted);
    if($kparted != "0") {
        mydie("FIND SIZE : There was an error KPARTING the BLOCK Device");
    }
    $tmp = explode(" ", $kpart[0]);
    $mapper = $tmp[0];
    $rand = generateRandStr(8);
    mkdir("/tmp/" . $rand, 493);
    vexec((file_exists("/sbin/mount.ntfs") ? "/sbin/mount.ntfs" : "ntfsmount") . " /dev/mapper/" . $mapper . " /tmp/" . $rand, $out, $ret);
    vexec("stat -f -c %a /tmp/" . $rand, $_free, $ret);
    vexec("stat -f -c %b /tmp/" . $rand, $_total, $ret);
    vexec("umount /tmp/" . $rand, $out, $ret);
    rmdir("/tmp/" . $rand);
    $used = $_total[0] - $_free[0];
    $used = $used * 4096 / 1000 / 1000;
    echo "Used Size is : " . $used . " MB. Resizing ... \n\n";
    passthru("ntfsresize --force /dev/mapper/" . $mapper . " --size=" . ceil($used + 1024) . "M", $ret);
    if($ret != "0") {
        mydie("CLONE RESIZE : Error while resizing clone to minimum levels");
    }
    vexec("kpartx -d /dev/mapper/" . $mapper, $out, $ret);
    return $used;
}
function mydie($m, $loop_device = "")
{
    global $globals;
    global $vg;
    exec("/sbin/kpartx -d " . $GLOBALS["block"]);
    if(!empty($loop_device)) {
        exec("/sbin/kpartx -d " . $loop_device . "");
        exec("losetup -d " . $loop_device . "");
    }
    unlink($GLOBALS["createin"] . "/" . basename($GLOBALS["block"]) . ".img");
    unlink($GLOBALS["createin"] . "/" . $GLOBALS["name"]);
    vexec($globals["com"]["lvremove"] . " -f " . $vg . "/WINTOOL");
    exit($m);
}

?>