<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
class vzo
{
    public $loaded = 0;
    public $status = [];
    public $status_statewise = [];
    public $type = "vzo";
    public $user = [];
    public function __construct()
    {
        if(!empty($GLOBALS["globals"]["interface"])) {
            $this->bandwidth_device = $GLOBALS["globals"]["interface"];
        }
    }
    public function conf($vpsid, $conf_name)
    {
        if(in_array($conf_name, ["io_priority", "vnc_support", "vnc_store_pass", "cpu_pinning", "serverload", "openvz", "vps_ram_info", "tun_tap", "ppp", "recipe_live", "control_panel_live", "serial_console", "openvz_features", "inc_backup"])) {
            return true;
        }
        if($conf_name == "vncpasslen") {
            return 8;
        }
        if($conf_name == "storage_types") {
            return ["openvz"];
        }
        if(in_array($conf_name, ["migrate_pre_create_vps", "getos_pre_createvps"])) {
            return true;
        }
        if($conf_name == "possible_mig_virts") {
            return ["vzo"];
        }
        if($conf_name == "live_mig") {
            return ["vzo"];
        }
        return false;
    }
    public function new_vps_name($suggested_name = "")
    {
        vexec("/usr/bin/prlctl list --output name --all", $output, $return);
        unset($output[0]);
        $ret = empty($suggested_name) ? 101 : str_replace("v", "", $suggested_name);
        foreach ($output as $k => $v) {
            $v = trim($v);
            if(empty($v)) {
            } else {
                $names[$v] = $v;
            }
        }
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\tAND virt = 'vzo' \n\t\t\t\t\t\tORDER BY vps_name DESC");
        if(0 < vsql_num_rows($res)) {
            for ($x = 0; $x < vsql_num_rows($res); $x++) {
                $row = vsql_fetch_assoc($res);
                $row["vps_name"] = trim($row["vps_name"]);
                $names[$row["vps_name"]] = $row["vps_name"];
                $tmp_int = (int) $row["vps_name"];
                if($ret < $tmp_int && $tmp_int < 2000) {
                    $ret = $tmp_int + 1;
                }
            }
        }
        $x = 0;
        while ($x < 100000) {
            if(in_array($ret, $names)) {
                $ret = $ret + 1;
                $x++;
                break;
            }
        }
        return $ret;
    }
    public function getconf($vid)
    {
        $r = [];
        if(0 < substr_count($vid, "/")) {
            $path = $vid;
        } else {
            $vps_uuid = $this->getuuid($vid);
            $path = "/etc/vz/conf/" . $vps_uuid . ".conf";
        }
        $tmp = @file($path);
        foreach ($tmp as $k => $l) {
            $tmp[$k] = trim(preg_replace("/(\\#(.*))/is", "", trim($l)));
            if(empty($tmp[$k])) {
            } elseif(preg_match("/=/is", $tmp[$k])) {
                $t = explode("=", $tmp[$k]);
                $r[$t[0]] = $t[1];
            }
        }
        foreach ($r as $k => $v) {
            $r[$k] = trim($v, "\"");
        }
        if(is_numeric($vid)) {
            $this->conf[$vid] = $r;
        }
        return $r;
    }
    public function getname($vid)
    {
        global $user;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            return $user["vps"]["vps_name"];
        }
        if($vps = getvps($vid)) {
            return $vps["vps_name"];
        }
        return false;
    }
    public function stop($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("stop_vps", "", 0, $vid, $vps["uid"], 0, $l["stop_vps"]);
        task_start($actid);
        task_update($actid, $l["stop_vps"], 57);
        $vps_name = $this->getname($vid);
        oexec("/usr/bin/prlctl stop " . xss($vps_name), $output);
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --autostart off");
        writefile(logdir("stop") . $vid . ".log", $output, 1);
        task_update($actid, $l["stop_vps_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function poweroff($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("poweroff_vps", "", 0, $vid, $vps["uid"], 0, $l["power_off_vps"]);
        task_start($actid);
        task_update($actid, $l["power_off_vps"], 57);
        $status = $this->vps_status_statewise($vid);
        if($status == 2) {
            return false;
        }
        $vps_name = $this->getname($vid);
        oexec("/usr/bin/prlctl stop " . xss($vps_name) . " --fast", $output);
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --autostart off");
        writefile(logdir("poweroff") . $vid . ".log", $output, 1);
        task_update($actid, $l["power_off_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function start($vid)
    {
        global $l;
        global $globals;
        $vps = getvps($vid, 0);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        $actid = vps_task("start_vps", "", 0, $vid, $vps["uid"], 0, $l["attempting_start_vps"]);
        task_start($actid);
        task_update($actid, $l["attempting_start_vps"], 5);
        task_update($actid, $l["start_script"], 45);
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/openvz_features.php " . xss($vid) . " " . xss($actid) . " 2>&1 &", $o_features, $r_features);
        task_update($actid, $l["call_hook_before_startvps"], 48);
        apply_filters("before_startvps", $vps);
        task_update($actid, $l["beginning_start_vps"], 60);
        oexec("/usr/bin/prlctl start " . xss($vps["vps_name"]), $output);
        writefile(logdir("start") . $vid . ".log", $output, 1);
        if(!empty($vps["ppp"])) {
            vexec("/usr/sbin/vzctl set " . xss($vps["vps_name"]) . " --devices \"c:10:200:rw c:108:0:rw\" --save");
            vexec("/usr/sbin/vzctl exec " . xss($vps["vps_name"]) . " mknod /dev/ppp c 108 0");
            vexec("/usr/sbin/vzctl exec " . xss($vps["vps_name"]) . " chmod 600 /dev/ppp");
        } else {
            vexec("/usr/sbin/vzctl exec " . xss($vps["vps_name"]) . " rm -rf /dev/ppp");
        }
        if(!empty($vps["tuntap"])) {
            $this->enable_tuntap($vid);
        }
        if(!empty($vps["nw_suspended"])) {
            $this->suspend_vps_net($vps["vpsid"]);
        }
        task_update($actid, $l["change_hostname"], 75);
        vexec("/usr/bin/prlctl set " . xss($vps["vps_name"]) . " --hostname " . xss($vps["hostname"]), $hostoutput, $ret);
        vexec("/usr/sbin/vzctl exec " . xss($vps["vps_name"]) . " hostname " . xss($vps["hostname"]), $hostoutput, $ret);
        task_update($actid, $l["set_autostart"], 88);
        vexec("/usr/bin/prlctl set " . xss($vps["vps_name"]) . " --autostart on");
        task_update($actid, $l["call_hook"], 95);
        apply_filters("after_startvps", $vps);
        task_update($actid, $l["start_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function restart($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("restart_vps", "", 0, $vid, $vps["uid"], 0, $l["restart_vps"]);
        task_start($actid);
        task_update($actid, $l["restart_vps"], 57);
        $vps = getvps($vid);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        oexec("/usr/bin/prlctl restart " . xss($vps["vps_name"]), $output);
        if(!empty($vps["nw_suspended"])) {
            $this->suspend_vps_net($vps["vpsid"]);
        }
        vexec("/usr/bin/prlctl set " . xss($vps["vps_name"]) . " --hostname " . xss($vps["hostname"]), $resrtartoutput, $ret);
        vexec("/usr/sbin/vzctl exec " . xss($vps["vps_name"]) . " hostname " . xss($vps["hostname"]), $resrtartoutput, $ret);
        task_update($actid, $l["restart_vps_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function changehostname($vid, $host)
    {
        global $globals;
        global $user;
        global $l;
        $actid = vps_task("hostname", $host, 0, $vid, $user["uid"], 0, $l["task_started"]);
        task_start($actid);
        $vps_name = $this->getname($vid);
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --hostname " . xss($host), $output, $ret);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " hostname " . xss($host), $output, $ret);
        $status = $this->status($vid, 1);
        $vps_uuid = $this->getuuid($vid);
        $mount_point = "/vz/root/" . $vps_uuid;
        if($status == 0) {
            vexec("/usr/bin/prlctl mount " . xss($vps_name), $mount);
        }
        hostname_configure($mount_point, $host);
        if($status == 0) {
            vexec("/usr/bin/prlctl umount " . xss($vps_name), $mount);
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function tc_create($vid)
    {
        return vs_tc_create_vz($vid, 1);
    }
    public function tc_destroy($vid)
    {
        return vs_tc_destroy_vz($vid);
    }
    public function editvps($vid)
    {
        $this->tc_destroy($vid);
        $this->disable_tuntap($vid);
        return $this->createvps($vid, 0);
    }
    public function createvps($vid, $create = 1)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        global $error;
        global $l;
        $vps = getvps($vid);
        $action = "edit_vps";
        if(!empty($create)) {
            $action = "create_vps";
        }
        $actid = vps_task($action, "", 0, $vid, $vps["uid"], 0, $l["beginning_creation"]);
        task_start($actid);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        if(empty($oslist)) {
            oslist();
        }
        task_update($actid, $l["beginning_creation"], 5);
        if(!empty($create) && !defined("DONT_DD_OS_TEMPLATE") && !empty($vps["osid"])) {
            task_update($actid, $l["downloading_os"], 20);
            getos($ostemplates[$vps["osid"]]["filename"], "vzoos");
        }
        $all_ipr_ips = [];
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $_ips[$i] = vsql_fetch_assoc($res);
            $ips[$i] = $_ips[$i]["ip"];
            if(valid_ipv6($_ips[$i]["ip"])) {
                $ips[$i] = ipv6_expand($_ips[$i]["ip"]);
            }
            if(!empty($_ips[$i]["ipr_ips"])) {
                $ipr_ips = unserialize($_ips[$i]["ipr_ips"]);
                $all_ipr_ips = array_merge($all_ipr_ips, $ipr_ips);
            }
        }
        $all_vps_ips = array_merge($ips, $all_ipr_ips);
        if(!empty($create)) {
            if(function_exists("virt_resolve_deps")) {
                virt_resolve_deps("vzo");
            }
            $tmp_parts = preg_split("/-/", $ostemplates[$vps["osid"]]["name"]);
            if(!empty($ostemplates[$vps["osid"]]["name"])) {
                $converted_tmpl_fpath = "/vz/template/cache/" . $ostemplates[$vps["osid"]]["name"] . ".plain.ploopv2.tar.lz4";
                $os_tmpl_struct = "/vz/template/" . $tmp_parts[0] . "/" . $tmp_parts[1] . "/" . $tmp_parts[2] . (!empty($tmp_parts[3]) ? "/config/os/" . $tmp_parts[3] : "");
                if(is_custom_os($vps["osid"])) {
                    if(!empty($tmp_parts) && 2 < count($tmp_parts) && (!file_exists($converted_tmpl_fpath) || !is_dir($os_tmpl_struct))) {
                        unlink($converted_tmpl_fpath);
                        rmdir_recursive($os_tmpl_struct);
                        vexec("vzpkg clean " . xss($ostemplates[$vps["osid"]]["name"]));
                    }
                } else {
                    vexec("yum list installed | grep " . $ostemplates[$vps["osid"]]["name"] . "-ez", $o, $r);
                    if(empty($o)) {
                        if(!empty($tmp_parts) && 2 < count($tmp_parts)) {
                            $lz4_temp_size = @vfilesize($converted_tmpl_fpath);
                            if($lz4_temp_size < $ostemplates[$vps["osid"]]["size"] || !file_exists($converted_tmpl_fpath) || !is_dir($os_tmpl_struct)) {
                                unlink($converted_tmpl_fpath);
                                rmdir_recursive($os_tmpl_struct);
                            }
                        }
                    } else {
                        $lz4_temp_size = @vfilesize($converted_tmpl_fpath);
                        if($lz4_temp_size < $ostemplates[$vps["osid"]]["size"] || !file_exists($converted_tmpl_fpath) || !is_dir($os_tmpl_struct)) {
                            unlink($converted_tmpl_fpath);
                            rmdir_recursive($os_tmpl_struct);
                            vexec("yum remove " . $ostemplates[$vps["osid"]]["name"] . "-ez -y", $o, $r);
                        }
                    }
                }
            }
            task_update($actid, $l["preparing_config_file"], 24);
            $dist_path = "/vz/template/" . $tmp_parts[0] . "/" . $tmp_parts[1] . "/" . $tmp_parts[2] . "/config/os/" . (!empty($tmp_parts[3]) ? $tmp_parts[3] : "default") . "/distribution";
            vexec("echo " . distro_find($ostemplates[$vps["osid"]]["name"]) . " > " . $dist_path);
            task_update($actid, $l["virtuzo_create"], 26);
            $custom_config = !empty($globals["vzo_config_file_name"]) && file_exists("/etc/vz/conf/ve-" . $globals["vzo_config_file_name"] . ".conf-sample") ? " --config " . $globals["vzo_config_file_name"] : "";
            $ret = vexec("/usr/bin/prlctl create " . xss($vps_name) . " --vmtype ct --ostemplate " . xss($ostemplates[$vps["osid"]]["name"]) . $custom_config . " 2>&1", $o, $r);
            if($ret != 0) {
                $o_str = implode(" ", $o);
                $def_dist_pkg_mgr_path = dirname(dirname($dist_path)) . "/default/package_manager";
                if(preg_match("/Error\\:\\spackage_manager/i", $o_str) && file_exists($def_dist_pkg_mgr_path)) {
                    $pkgmgr = $this->get_ovz_pkg_mgr($ostemplates[$vps["osid"]]["name"]);
                    file_put_contents($def_dist_pkg_mgr_path, $pkgmgr);
                    $ret = vexec("/usr/bin/prlctl create " . xss($vps_name) . " --vmtype ct --ostemplate " . xss($ostemplates[$vps["osid"]]["name"]) . $custom_config . " 2>&1", $o, $r);
                }
                if($ret != 0) {
                    $error[] = $l["virtuzo_create_error"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    task_update($actid, $l["virtuzo_create_error"], -1);
                    return false;
                }
            }
            unset($o);
            unset($r);
        }
        $uuid = $this->getuuid($vid);
        vexec("sed -i 's/DISTRIBUTION=\"\"/DISTRIBUTION=\"" . distro_find($ostemplates[$vps["osid"]]["name"]) . "\"/g' /etc/vz/conf/" . $uuid . ".conf");
        apply_filters("after_config_write", $vps);
        task_update($actid, $l["set_disk_space"], 28);
        $diskspace = round($vps["space"] * 1024);
        $ret = $this->vps_info($vid);
        foreach ($ret["Hardware"] as $k => $v) {
            if(preg_match("/^hdd\\d+/i", $k)) {
                $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --device-set " . xss($k) . " --size " . $diskspace . "M");
                if($ret != 0) {
                    $error[] = $l["openvz_err_space"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    task_update($actid, $l["openvz_err_space"], -1);
                    return false;
                }
                task_update($actid, $l["set_hostname"], 36);
                $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --hostname " . xss($vps["hostname"]));
                if($ret != 0) {
                    $error[] = $l["openvz_err_hostname"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    return false;
                }
                task_update($actid, $l["set_ips"], 55);
                vexec("/usr/bin/prlctl list -n " . xss($vps_name) . " -o ip", $ipout, $ipret);
                $ipout = explode(" ", $ipout[1]);
                $tmp_ip6s_del = [];
                foreach ($ipout as $k => $ip) {
                    if(valid_ipv6($ip)) {
                        $ipout[$k] = ipv6_expand($ip);
                        $tmp_ip6s_del[$ipout[$k]] = $ip;
                    }
                }
                $ips_to_del = $ips_to_add = [];
                $ips_to_del = array_diff($ipout, $all_vps_ips);
                $ips_to_add = array_diff($all_vps_ips, $ipout);
                $ipr_ips_to_add = array_diff($all_ipr_ips, $ipout);
                if(!empty($ips_to_del)) {
                    foreach ($ips_to_del as $ip) {
                        $ip = !empty($tmp_ip6s_del[$ip]) ? $tmp_ip6s_del[$ip] : $ip;
                        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --ipdel " . xss($ip));
                    }
                }
                if(!empty($ips_to_add) || !empty($ipr_ips_to_add)) {
                    foreach ($_ips as $k => $v) {
                        if(!empty($_ips[$k]["ipr_ips"]) && !empty($ipr_ips_to_add)) {
                            $ipr_ips = unserialize($_ips[$k]["ipr_ips"]);
                            foreach ($ipr_ips as $ipr_ip) {
                                if(in_array($ipr_ip, $ipr_ips_to_add)) {
                                    $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --ipadd " . xss($ipr_ip));
                                    if($ret != 0) {
                                        $error[] = $l["openvz_err_ip"];
                                        $error["derr"] = array_end($GLOBALS["logr"]);
                                        task_update($actid, $l["openvz_err_ip"], -1);
                                        return false;
                                    }
                                }
                            }
                        }
                        if(valid_ipv6($_ips[$k]["ip"])) {
                            $_ips[$k]["ip"] = ipv6_expand($_ips[$k]["ip"]);
                        }
                        if(in_array($_ips[$k]["ip"], $ips_to_add) && !empty($ips_to_add)) {
                            $internal_cidr = "/" . $_ips[$k]["netmask"];
                            if(empty($_ips[$k]["ipv6"]) && !empty($_ips[$k]["internal"]) && !empty($_ips[$k]["netmask"])) {
                                $internal_cidr = "/" . mask2cidr($_ips[$k]["netmask"]);
                            }
                            $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --ipadd " . xss($_ips[$k]["ip"] . (!empty($_ips[$k]["ipr_netmask"]) ? "/" . $_ips[$k]["ipr_netmask"] : $internal_cidr)));
                            if(valid_ipv6($_ips[$k]["ip"]) && !empty($_ips[$k]["routing"])) {
                                $ret6 = vexec("ip -6 neigh add proxy " . xss($_ips[$k]["ip"]) . " dev " . xss(empty($globals["interface"]) ? "eth0" : $globals["interface"]) . "");
                            }
                            if($ret != 0) {
                                $error[] = $l["openvz_err_ip"];
                                $error["derr"] = array_end($GLOBALS["logr"]);
                                task_update($actid, $l["openvz_err_ip"], -1);
                                return false;
                            }
                        }
                    }
                }
                if(!empty($vps["vnc"])) {
                    task_update($actid, $l["enable_vnc"], 62);
                    $vncpass = empty($vps["vnc_passwd"]) ? generateRandStr(8) : $vps["vnc_passwd"];
                    vexec("/usr/bin/prlctl set " . xss($vps_name) . " --vnc-mode auto --vnc-passwd " . xss($vncpass) . " --vnc-address " . xss(server_vncip($vps["serid"])), $out, $ret);
                } else {
                    task_update($actid, $l["disable_vnc"], 62);
                    vexec("/usr/bin/prlctl set " . xss($vps_name) . " --vnc-mode off", $out, $ret);
                }
                $vncDetails = $this->vncDetails($vps["vpsid"]);
                to_master("vps", "vncport", $vps["vpsid"], "vpsid", $vncDetails["port"]);
                $vps["dns_nameserver"] = @_unserialize($vps["dns_nameserver"]);
                if(!empty($vps["dns_nameserver"])) {
                    task_update($actid, $l["set_dnsnameserver"], 67);
                    $ns = implode(" ", $vps["dns_nameserver"]);
                    $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --nameserver " . xss($ns));
                    if($ret != 0) {
                        $error[] = $l["openvz_err_dns"];
                        $error["derr"] = array_end($GLOBALS["logr"]);
                        task_update($actid, $l["openvz_err_dns"], -1);
                        return false;
                    }
                } else {
                    $res = makequery("SELECT ip.* FROM `ips` i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\tWHERE ip = :ip", [":ip" => $ips[0]]);
                    $tmp = vsql_fetch_assoc($res);
                    if(!empty($tmp["ns1"])) {
                        $ns = $tmp["ns1"] . " " . $tmp["ns2"];
                        task_update($actid, $l["set_dnsnameserver"], 67);
                        $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --nameserver " . xss($ns));
                        if($ret != 0) {
                            $error[] = $l["openvz_err_dns"];
                            $error["derr"] = array_end($GLOBALS["logr"]);
                            task_update($actid, $l["openvz_err_dns"], -1);
                            return false;
                        }
                    } else {
                        task_update($actid, $l["set_dnsnameserver"], 67);
                        $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --nameserver '4.2.2.1 4.2.2.2'");
                        if($ret != 0) {
                            $error[] = $l["openvz_err_dns"];
                            $error["derr"] = array_end($GLOBALS["logr"]);
                            task_update($actid, $l["openvz_err_dns"], -1);
                            return false;
                        }
                    }
                }
                task_update($actid, $l["setting_cpu"], 72);
                $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --cpuunits " . xss($vps["cpu"]));
                if($ret != 0) {
                    $error[] = $l["openvz_err_cpu"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    task_update($actid, $l["openvz_err_cpu"], -1);
                    return false;
                }
                if(!empty($vps["cpu_percent"])) {
                    task_update($actid, $l["setting_cpu_perc"], 76);
                    $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --cpulimit " . xss(round($vps["cpu_percent"])));
                    if($ret != 0) {
                        $error[] = $l["openvz_err_cpulim"];
                        $error["derr"] = array_end($GLOBALS["logr"]);
                        task_update($actid, $l["openvz_err_cpulim"], -1);
                        return false;
                    }
                }
                if(!empty($vps["cores"])) {
                    task_update($actid, $l["setting_cpu_cores"], 83);
                    $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --cpus " . xss($vps["cores"]));
                    if($ret != 0) {
                        $error[] = $l["openvz_err_cores"];
                        $error["derr"] = array_end($GLOBALS["logr"]);
                        task_update($actid, $l["openvz_err_cores"], -1);
                        return false;
                    }
                }
                if($vps["cpupin"] != -1) {
                    task_update($actid, $l["setting_cpu_pin"], 87);
                    $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --cpumask " . xss($vps["cpupin"]));
                    if($ret != 0) {
                        $error[] = $l["err_set_pinning"];
                        $error["derr"] = array_end($GLOBALS["logr"]);
                        task_update($actid, $l["err_set_pinning"], 20);
                        return false;
                    }
                }
                task_update($actid, $l["set_io_prio"], 90);
                $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --ioprio " . xss($vps["io"]));
                if($ret != 0) {
                    $error[] = $l["openvz_err_ioprio"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    task_update($actid, $l["openvz_err_ioprio"], -1);
                    return false;
                }
                task_update($actid, $l["set_ram"], 94);
                $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --memsize  " . $vps["ram"] . "M  --swap " . xss($vps["swap"]) . "M");
                if($ret != 0) {
                    $error[] = $l["err_set_ram"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    task_update($actid, $l["err_set_ram"], -1);
                    return false;
                }
                _task_update($actid, $l["tc_rule_create"], 96, "group");
                $this->tc_create($vid);
                _task_update($actid, $l["tc_rule_create"], 96, "group_end");
                if(!empty($vps["tuntap"])) {
                    $this->enable_tuntap($vid);
                }
                task_update($actid, $l["calling_after_createvps"], 98);
                apply_filters("after_createvps", $vps);
                $tmp_l = $action == "edit_vps" ? $l["edit_done"] : $l["create_done"];
                task_update($actid, $tmp_l, 100);
                return true;
            }
        }
    }
    public function destroyvps($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("deletevs", "", 0, $vid, $vps["uid"], 0, $l["del_vps"]);
        task_start($actid);
        $data = ["serid" => $vps["serid"]];
        task_update($actid, $l["start_del_vps"], 5, serialize($data));
        _task_update($actid, $l["tc_rule_delete"], 20, "group");
        $this->tc_destroy($vid);
        _task_update($actid, "", 20, "group_end");
        task_update($actid, $l["stop_vps"], 30);
        $this->stop($vid);
        $vps_name = $this->getname($vid);
        task_update($actid, $l["call_hook_before_delvps"], 40);
        apply_filters("before_deletevps", $vps);
        vexec("/usr/bin/prlctl umount " . xss($vps_name), $output, $ret);
        task_update($actid, $l["del_vps"], 55);
        vexec("/usr/bin/prlctl destroy " . xss($vps_name), $output, $ret);
        $vps_uuid = $this->getuuid($vid);
        if(file_exists("/etc/vz/names/" . $vps_name)) {
            @unlink("/etc/vz/names/" . $vps_name);
        }
        if(file_exists("/etc/vz/conf/" . $vps_uuid . ".conf")) {
            return false;
        }
        if(is_file("/vz/backup/" . $vps_name . "tar.gz")) {
            @unlink("/vz/backup/" . $vps_name . "tar.gz");
        }
        if(is_dir("/home/" . $vps["vps_name"])) {
            vexec("rm -rf /home/" . $vps["vps_name"]);
        }
        task_update($actid, $l["call_hook_after_delvps"], 88);
        apply_filters("after_deletevps", $vps);
        task_update($actid, $l["del_vps_done"], 100);
        return true;
    }
    public function osreinstall($vid, $format_primary = 0)
    {
        $vps_name = $this->getname($vid);
        $this->destroyvps($vid);
        if(!$this->createvps($vid)) {
            return false;
        }
        $this->start($vid);
        return true;
    }
    public function changepassword($vid, $newpassword)
    {
        global $globals;
        global $user;
        global $l;
        $actid = vps_task("changepassword", base64_encode($newpassword), 1, $vid, $user["uid"], 0, $l["task_started"]);
        task_start($actid);
        task_update($actid, $l["started"], 10, "XXXXXXXX");
        $vps_name = $this->getname($vid);
        $params = ["password" => xss($newpassword)];
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --userpasswd root:" . xss($newpassword), $output, $ret, $params);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function filelist($vid, $dir = "", $searchSubdirs = 1, $directoriesonly = 0, $maxlevel = "all", $level = 1)
    {
        $vps_name = $this->getname($vid);
        $path = rtrim("/vz/root/" . $vps_name, "/");
        $dir = $dir[0] == "/" ? $dir : "/" . $dir;
        $r = filelist($path . $dir, $searchSubdirs, $directoriesonly, $maxlevel, $level);
        if(empty($r)) {
            $r = [];
        }
        $listd = $listf = [];
        foreach ($r as $k => $v) {
            $k = substr($k, strlen($path));
            $v["fullpath"] = rtrim($v["path"], "/");
            $v["path"] = substr($v["path"], strlen($path));
            if(empty($v["dir"])) {
                $listf[$k] = $v;
            } else {
                $listd[$k] = $v;
            }
        }
        $list = array_merge($listd, $listf);
        return $list;
    }
    public function processes($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " ps ax -eo pid,user,pcpu,pmem,rss,tty,stat,time,command", $r, $ret);
        foreach ($r as $k => $v) {
            $v = trim($v);
            if(strtolower(substr($v, 0, 3)) == "pid") {
                $keys = preg_split("/\\s+/", trim($v));
                unset($r[$k]);
                $i = 0;
                $processes = [];
                foreach ($r as $k => $v) {
                    $v = preg_split("/\\s+/", trim($v));
                    $_v = $v;
                    reset($keys);
                    foreach ($_v as $kk => $vv) {
                        $tmp = $keys[$kk];
                        if(empty($tmp)) {
                            end($keys);
                            $processes[$i][current($keys)] .= " " . implode(" ", $v);
                            $i++;
                        } else {
                            $processes[$i][$tmp] = $vv;
                            unset($v[$kk]);
                        }
                    }
                }
                foreach ($processes as $i => $v) {
                    foreach ($processes[$i] as $kk => $vv) {
                        $processes[$i][$kk] = htmlizer($vv);
                    }
                }
                return $processes;
            } else {
                unset($r[$k]);
            }
        }
    }
    public function os($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $vps = getvps($vid);
        $osid = $vps["osid"];
        if(empty($ostemplates)) {
            oslist();
        }
        $osinfo = $ostemplates[$vps["osid"]];
        if(empty($osinfo)) {
            $osinfo["name"] = $vps["os_name"];
            $osinfo["distro"] = distro_find($vps["os_name"]);
        }
        return $osinfo;
    }
    public function hostname($vid)
    {
        if($this->status($vid) == 0) {
            $vps = getvps($vid);
            return $vps["hostname"];
        }
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " hostname", $output, $ret);
        return htmlizer(implode("", $output));
    }
    public function listips($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $ips = [];
        $res = makequery("SELECT * FROM `ips`\n\t\t\t\t\tWHERE vpsid = :vid\t\t\t\t\t\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(in_array($row["ip"], $ips)) {
            } else {
                $ips[] = $row["ip"];
            }
        }
        return $ips;
    }
    public function cpu($vid)
    {
        global $user;
        $ret = [];
        $ret["manu"] = "unknown";
        $ret["limit"] = 0;
        $ret["used"] = 0;
        oexec("cat /proc/cpuinfo", $tmp);
        if(preg_match("/intel/is", $tmp)) {
            $ret["manu"] = "intel";
        } elseif(preg_match("/amd/is", $tmp)) {
            $ret["manu"] = "amd";
        }
        virt_preg_replace("/cpu(\\s*?)MHz(\\s*?)\\:(\\s*?)(.*?)(\\s*?)\\n/is", $tmp, $mhz, 4);
        $vps = getvps($vid);
        if($this->status($vid) !== 0) {
            $ret["used"] = $this->_cpu_stats($vid);
        }
        $ret["percent"] = $ret["used"];
        $ret["percent_free"] = 100 - $ret["percent"];
        if(!empty($mhz)) {
            $ret["limit"] = $mhz;
            $ret["used"] = $ret["percent"] * $mhz / 100;
            $ret["free"] = $ret["limit"] - $ret["used"];
        } else {
            $ret["limit"] = 100;
            $ret["used"] = $ret["percent"];
            $ret["free"] = $ret["limit"] - $ret["used"];
        }
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function ram($vid)
    {
        global $user;
        $ret = [];
        $ret["used"] = 0;
        $ret["cached"] = 0;
        $ret["limit"] = 0;
        $ret["guaranteed"] = 0;
        $ret["swap"] = 0;
        $free = 0;
        if($this->status($vid) !== 0) {
            $vps_name = $this->getname($vid);
            vexec("prlctl statistics " . xss($vps_name) . " | grep ram", $output, $return);
            foreach ($output as $k => $v) {
                $tmp = explode(":", trim($v));
                if(trim($tmp[0]) == "guest.ram.cached") {
                    $ret["cached"] = (int) $tmp[1];
                }
                if(trim($tmp[0]) == "guest.ram.total") {
                    $ret["limit"] = (int) $tmp[1];
                }
                if(trim($tmp[0]) == "guest.ram.usage") {
                    $ret["usage"] = (int) $tmp[1];
                }
            }
        }
        if(!empty($user["vps"])) {
            $vps = $user["vps"];
        } else {
            $vps = getvps($vid);
        }
        if(!empty($vps)) {
            $ret["guaranteed"] = $vps["ram"];
            $ret["swap"] = $vps["swap"];
        }
        $ret["free"] = $ret["limit"] - $ret["usage"];
        $ret["used"] = $ret["limit"] - $ret["free"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function disk($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if($this->status($vid) !== 0) {
            oexec("/usr/sbin/vzlist -H -o diskspace " . xss($vps_name), $tmp);
            $tmp = trim($tmp);
            if(is_numeric($tmp)) {
                $ret["used"] = $tmp / 1024;
            }
            oexec("/usr/sbin/vzlist -H -o diskspace.h " . xss($vps_name), $tmp);
            $tmp = trim($tmp);
            if(is_numeric($tmp)) {
                $ret["act_limit"] = $tmp / 1024;
            }
        }
        if(!empty($user["vps"])) {
            $ret["limit"] = $user["vps"]["space"] * 1024;
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["space"] * 1024;
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["limit_gb"] = $ret["limit"] / 1024;
        $ret["used_gb"] = $ret["used"] / 1024;
        $ret["free_gb"] = $ret["limit_gb"] - $ret["used_gb"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function inodes($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if($this->status($vid) !== 0) {
            oexec("/usr/sbin/vzlist -H -o diskinodes " . xss($vps_name), $tmp);
            $tmp = trim($tmp);
            if(is_numeric($tmp)) {
                $ret["used"] = $tmp;
            }
            oexec("/usr/sbin/vzlist -H -o diskinodes.h " . xss($vps_name), $tmp);
            $tmp = trim($tmp);
            if(is_numeric($tmp)) {
                $ret["act_limit"] = $tmp;
            }
        }
        if(!empty($user["vps"])) {
            $ret["limit"] = empty($user["vps"]["inodes"]) ? $ret["act_limit"] : $user["vps"]["inodes"];
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = empty($vps["inodes"]) ? $ret["act_limit"] : $vps["inodes"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function network_speed($vid)
    {
        $vps = getvps($vid);
        $ret["speed"] = 0;
        $ret["upload"] = 0;
        $ret["download"] = 0;
        $value = $this->_network_usage($vid);
        if(empty($value["in"]) && empty($value["out"])) {
        } else {
            usleep(1000000);
            $value2 = $this->_network_usage($vid);
        }
        if($value2["in"] < $value["in"]) {
            $value2["in"] = $value["in"];
            $value2["out"] = $value["out"];
        }
        $ret["download"] = $value2["in"] - $value["in"];
        $ret["upload"] = $value2["out"] - $value["out"];
        $ret["speed"] = $ret["upload"] + $ret["download"];
        return $ret;
    }
    public function status($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        $vs_name_id = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $vs_name_id[$row["vps_name"]] = $row["vpsid"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            $output = [];
            vexec("/usr/sbin/vzlist -j -o name,ctid,status " . (count($vids) == 1 ? xss($vs[current($vids)]) : "-a"), $output, $cmdret);
            if(count($vids) == 1 && $cmdret != 0) {
                vexec("/usr/sbin/vzlist -j -o name,ctid,status -a", $output, $cmdret);
            }
            if($cmdret == 0) {
                $output = implode("\n", $output);
                $output = json_decode($output, 1);
                foreach ($output as $v) {
                    $name = isset($vs_name_id[$v["name"]]) ? $v["name"] : (isset($vs_name_id[$v["ctid"]]) ? $v["ctid"] : "");
                    $vid = intval($vs_name_id[$name]);
                    if(!isset($vs_name_id[$name])) {
                    } elseif(!empty($vid) && preg_match("/running/is", $v["status"])) {
                        $this->status[$vid] = 1;
                        $on[$vid] = 1;
                    }
                }
                unset($v);
            }
            unset($output);
            unset($cmdret);
        }
        unset($vs_name_id);
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = !empty($on[$k]) ? 1 : 0;
            } else {
                $ret[$k] = !empty($this->status[$k]) ? 1 : 0;
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function vps_status_statewise($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        $vs_name_id = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $vs_name_id[$row["vps_name"]] = $row["vpsid"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status_statewise[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            $output = [];
            vexec("/usr/sbin/vzlist -j -o name,ctid,status " . (count($vids) == 1 ? xss($vs[current($vids)]) : "-a"), $output, $cmdret);
            if(count($vids) == 1 && $cmdret != 0) {
                vexec("/usr/sbin/vzlist -j -o name,ctid,status -a", $output, $cmdret);
            }
            if($cmdret == 0) {
                $output = implode("\n", $output);
                $output = json_decode($output, 1);
            }
            unset($cmdret);
            if(!empty($output) && is_array($output)) {
                foreach ($output as $vmk => $vmv) {
                    $name = isset($vs_name_id[$vmv["name"]]) ? $vmv["name"] : (isset($vs_name_id[$vmv["ctid"]]) ? $vmv["ctid"] : "");
                    if(!isset($vs_name_id[$name])) {
                    } elseif(isset($vs_name_id[$name])) {
                        $vid = intval($vs_name_id[$name]);
                        strtolower($vmv["status"]);
                        switch (strtolower($vmv["status"])) {
                            case "running":
                                $this->status_statewise[$vid] = 1;
                                $on[$vid] = 1;
                                break;
                            case "suspended":
                                $this->status_statewise[$vid] = 2;
                                $on[$vid] = 2;
                                break;
                            default:
                                $this->status_statewise[$vid] = 0;
                                $on[$vid] = 0;
                                unset($vid);
                        }
                    }
                }
                unset($vmk);
                unset($vmv);
            }
            unset($output);
        }
        unset($vs_name_id);
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = $on[$k] == 1 ? 1 : ($on[$k] == 2 ? 2 : 0);
            } else {
                $ret[$k] = $this->status_statewise[$k] == 1 ? 1 : ($this->status_statewise[$k] == 2 ? 2 : 0);
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function uptime($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " uptime", $output, $ret);
        if(!empty($output[0])) {
            return htmlizer($output[0]);
        }
        return false;
    }
    public function services($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " which systemctl", $o, $r);
        if(empty($r)) {
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " systemctl list-units --type=service --state=running | awk '{\$1=\$1};1'", $tmp);
            foreach ($tmp as $serv) {
                $parts = preg_split("/\\s+/is", $serv);
                preg_match("/^(.+[^@])\\.service\$/is", $parts[0], $matches);
                if(empty($matches[1]) || in_array($matches[1], ["virtualizor", "virtnetwork"])) {
                } else {
                    $services[] = $matches[1];
                }
            }
            $services = array_unique($services);
        } else {
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " ps -Aeo comm", $list, $ret);
            unset($list[0]);
            foreach ($list as $k => $v) {
                $v = explode("-", trim($v));
                if($v[0] == "ps") {
                    unset($list[$k]);
                } else {
                    $list[$k] = htmlizer($v[0]);
                }
            }
            $services = array_unique($list);
        }
        return $services;
    }
    public function startservice($vid, $ser)
    {
        $vps_name = $this->getname($vid);
        if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $ser)) {
            return false;
        }
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " " . xss("/etc/init.d/" . $ser) . " start", $output, $ret);
        return true;
    }
    public function restartservice($vid, $ser)
    {
        $vps_name = $this->getname($vid);
        if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $ser)) {
            return false;
        }
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " " . xss("/etc/init.d/" . $ser) . " restart", $output, $ret);
        return true;
    }
    public function stopservice($vid, $ser)
    {
        $vps_name = $this->getname($vid);
        if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $ser)) {
            return false;
        }
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " " . xss("/etc/init.d/" . $ser) . " stop", $output, $ret);
        return true;
    }
    public function listautoservices($vid)
    {
        $services = [];
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " which systemctl", $o, $r);
        if(empty($r)) {
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " systemctl list-unit-files --type=service --state=enabled", $tmp);
            foreach ($tmp as $serv) {
                $parts = preg_split("/\\s+/is", $serv);
                preg_match("/^(.+[^@])\\.service\$/is", $parts[0], $matches);
                if(empty($matches[1])) {
                } else {
                    $services[] = $matches[1];
                }
            }
        } else {
            oexec("/usr/sbin/vzctl exec " . xss($vps_name) . " runlevel", $tmp);
            $tmp = preg_replace("/(N|\\s)/", "", $tmp);
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " chkconfig --list", $chk);
            if(is_array($chk)) {
                foreach ($chk as $v) {
                    if(!preg_match("/" . $tmp . "\\:on/is", $v)) {
                    } else {
                        $ser = preg_split("/\\s/is", $v);
                        $services[] = htmlizer($ser[0]);
                    }
                }
            }
        }
        return $services;
    }
    public function killprocess($vid, $pids)
    {
        $vps_name = $this->getname($vid);
        if(!is_array($pids)) {
            $pids = [$pids];
        }
        foreach ($pids as $pid) {
            if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $pid)) {
                return false;
            }
            $pid = (int) $pid;
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " kill -9 " . $pid, $output, $ret);
        }
        return true;
    }
    public function install_recipe($vid, $recipe, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $allowed_shells = $globals["shells"];
        if(array_key_exists("rid", $recipe)) {
            $recipe = [$recipe["rid"] => $recipe];
        }
        $status = no_log_status($vid, 1, $this);
        if(empty($actid)) {
            $actid = vps_task("install_recipe", serialize($recipe), 0, $vid, $user["uid"], 1, $l["change_onboot"]);
        }
        task_start($actid);
        $vps = getvps($vid);
        if($status != 1) {
            vexec("/usr/sbin/vzctl mount " . $vps["vps_name"], $mo, $mr);
            if($mr) {
                return false;
            }
        }
        $vps_uuid = $this->getuuid($vid);
        $mount_point = "/vz/root/" . $vps_uuid;
        $exec_recipe_path_rel = "/root/exec_recipe";
        $exec_recipe_path_abs = $mount_point . $exec_recipe_path_rel . ".sh";
        file_put_contents($exec_recipe_path_abs, "#!/bin/bash");
        chmod($exec_recipe_path_abs, 493);
        $recipe_file_rel_path_prefix = "/root/recipe_";
        foreach ($recipe as $k => $v) {
            $recipe_path_rel = $recipe_file_rel_path_prefix . $v["rid"];
            $recipe_path_abs = $mount_point . $recipe_path_rel;
            foreach ($allowed_shells as $sk => $sv) {
                if(substr($v["code"], 0, strlen($sv)) == $sv) {
                    $v["code"] = str_replace($sv, "", $v["code"]);
                }
            }
            $v["code"] = $v["shell"] . "\n" . $v["code"];
            $__code = lang_vars_name($v["code"], ["vps_hostname" => $vps["hostname"], "vps_name" => $vps["vps_name"], "vpsid" => $vid]) . "\n" . "rm -f " . $recipe_path_rel . ".sh;";
            writefile($recipe_path_abs . ".sh", $__code, 1);
            @chmod($recipe_path_abs . ".sh", 493);
            file_put_contents($exec_recipe_path_abs, "\necho `date`: Recipe ID: " . $v["rid"] . "; sh " . $recipe_path_rel . ".sh  > " . $recipe_path_rel . ".log 2>&1 ; echo `date`: RET: \$?", FILE_APPEND);
        }
        file_put_contents($exec_recipe_path_abs, "\nrm -f " . $exec_recipe_path_rel . ".sh", FILE_APPEND);
        if($status == 1) {
            vexec("/usr/sbin/vzctl exec " . xss($vps["vps_name"]) . " \"" . xss($exec_recipe_path_rel) . ".sh > " . $exec_recipe_path_rel . ".log 2>&1 &\"", $output, $ret);
        } else {
            if(file_exists($mount_point . "/etc/redhat-release") || file_exists($mount_point . "/etc/oracle-release")) {
                $rc_path = "/rc.d/rc.local";
            } elseif(file_exists($mount_point . "/etc/debian_version")) {
                $rc_path = "/rc.local";
            }
            $rc_file = $mount_point . "/etc" . $rc_path;
            if(!file_exists($rc_file)) {
                vexec("touch " . $rc_file);
                chmod($rc_file, 493);
            }
            if(!file_exists($mount_point . "/etc/rc.local.original")) {
                copy($rc_file, $mount_point . "/etc/rc.local.original");
            }
            if(is_safe_file($rc_file) && is_safe_file($mount_point . "/root") && is_safe_file($mount_point . "/etc/rc.local.original")) {
                file_put_contents($rc_file, "\necho `date` : Recipes: 2>&1 >" . $exec_recipe_path_rel . ".log;\nsh " . $exec_recipe_path_rel . ".sh 2>&1 >>" . $exec_recipe_path_rel . ".log;\necho `date` : RET : \$? 2>&1 >>" . $exec_recipe_path_rel . ".log;", FILE_APPEND);
                chmod($rc_file, 493);
            }
            $rc_data = file_get_contents($rc_file);
            $rc_data = preg_replace("/#remove_file.*?#remove_file_end/is", "", $rc_data);
            writefile($rc_file, $rc_data, 1);
            file_put_contents($rc_file, "\n#remove_file\nmv /etc/rc.local.original /etc" . $rc_path . "\n#remove_file_end", FILE_APPEND);
        }
        if($status != 1) {
            unset($mo);
            unset($mr);
            vexec("/usr/sbin/vzctl umount " . $vps["vps_name"], $mo, $mr);
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function install_cp($vid, $cp, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $actid = vps_task("install_cp", $cp, 0, $vid, $user["uid"], 0, $l["task_started"]);
        task_start($actid);
        $vps = getvps($vid);
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " wget -O " . xss("/root/ins_" . $cp . ".sh") . " " . xss("http://files.virtualizor.com/ins_" . $cp . ".sh"));
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " chmod 0755 " . xss("/root/ins_" . $cp . ".sh"));
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " " . xss("/root/ins_" . $cp . ".sh") . " > " . xss("/root/ins_" . $cp . ".log") . " 2>&1 &", $output, $ret);
        cp_mail($cp, $vps);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function serverloads($ids)
    {
        if(empty($ids)) {
            return false;
        }
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
            $usage[$row["vpsid"]][1] = 0;
            $usage[$row["vpsid"]][5] = 0;
            $usage[$row["vpsid"]][15] = 0;
            $stats = [];
            vexec("/usr/sbin/vzctl exec " . xss($row["vps_name"]) . " uptime", $stats, $ret);
            if(empty($stats[0])) {
            } else {
                $stats[0] = htmlizer($stats[0]);
                $tmp = substr($stats[0], strrpos($stats[0], ":") + 1);
                list($usage[$row["vpsid"]][1], $usage[$row["vpsid"]][5], $usage[$row["vpsid"]][15]) = explode(",", $tmp);
            }
        }
        return $usage;
    }
    public function vscpu($ids, $speed = 100000, $times = 2)
    {
        if(empty($ids)) {
            return false;
        }
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
            $vpses[$row["vpsid"]]["PREV_TOTAL"] = 0;
            $vpses[$row["vpsid"]]["DIFF_TOTAL"] = 0;
        }
        $PREV_TOTAL = 0;
        $DIFF_TOTAL = 0;
        for ($i = 1; $i <= $times; $i++) {
            $tmp = preg_grep("/^cpu /is", file("/proc/stat"));
            $tmp = preg_split("/[\\s]+/is", $tmp[0]);
            unset($tmp[0]);
            unset($tmp[4]);
            $total = array_sum($tmp);
            $DIFF_TOTAL = $total - $PREV_TOTAL;
            $PREV_TOTAL = $total;
            foreach ($vpses as $kv => $vps) {
                $stats = [];
                vexec("/usr/sbin/vzctl exec " . xss($vps["vps_name"]) . " cat /proc/stat", $stats, $ret);
                if(empty($stats[0])) {
                    $usage[$kv] = 0;
                } else {
                    $tmp = preg_grep("/^cpu /is", $stats);
                    $tmp = preg_split("/[\\s]+/is", $tmp[0]);
                    unset($tmp[0]);
                    unset($tmp[4]);
                    $total = array_sum($tmp);
                    $vpses[$kv]["DIFF_TOTAL"] = array_sum($tmp) - $vpses[$kv]["PREV_TOTAL"];
                    $usage[$kv] = round((1000 * $vpses[$kv]["DIFF_TOTAL"] / $DIFF_TOTAL + 1) / 10, 2);
                    $vpses[$kv]["PREV_TOTAL"] = $total;
                }
            }
            usleep($speed);
            clearstatcache();
        }
        return $usage;
    }
    public function vsram($ids)
    {
        $used_ram = 0;
        $ram[0]["used"] = 0;
        $ram[0]["ram"] = 0;
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $tmp = $this->ram($row["vpsid"]);
            $ram[$row["vpsid"]]["used"] = $tmp["used"];
            $ram[$row["vpsid"]]["label"] = "VPS : " . $row["vps_name"];
            $ram[$row["vpsid"]]["ram"] = $row["ram"];
        }
        $meminfo = get_meminfo();
        $free = $meminfo["Buffers"] + $meminfo["Cached"] + $meminfo["MemFree"];
        $used_ram = $meminfo["MemTotal"] - $free;
        $ram[0]["used"] = (int) $used_ram;
        $ram[0]["ram"] = $meminfo["MemTotal"];
        return $ram;
    }
    public function backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit)
    {
        global $globals;
        global $error;
        global $l;
        if(empty($disable_compress)) {
            $compression = get_compression_algo(0, 1);
            $file_ext = $compression["file_ext"];
            $compression_algo = $compression["compression_algo"];
        } else {
            $file_ext = ".tar";
            $compression_algo = "-pcf";
        }
        $final_backup = $vps["vpsid"] . "_" . parse_backup_hostname($vps["hostname"]) . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . $file_ext;
        $vps_name = $vps["vps_name"];
        $clone_name = $vps["vpsid"] . "-virt-backup";
        vexec("/usr/bin/prlctl clone " . xss($vps_name) . " --name " . xss($clone_name) . " " . ($globals["tmp_vzo_bkup_location"] ? "--dst " . xss($globals["tmp_vzo_bkup_location"]) : "") . " --template", $out, $ret);
        if($ret != "0") {
            return false;
        }
        vexec("/usr/bin/prlctl list -H -o uuid -t " . xss($clone_name), $out, $ret);
        if($ret != "0") {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        $template_uuid = trim(trim($out[0]), "{}");
        if(empty($template_uuid)) {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        $throttle_block_size = get_throttle_block_size();
        vexec("cd " . xss(($globals["tmp_vzo_bkup_location"] ? $globals["tmp_vzo_bkup_location"] : "/vz/private") . "/" . $template_uuid) . " && /bin/tar " . $compression_algo . " - * " . (empty($io_limit) ? "" : "| throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " > " . xss($temp_backup_dir . "/" . $final_backup), $out, $ret);
        if($ret != "0") {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
        if(@vfilesize($temp_backup_dir . "/" . $final_backup) < 1 || !store_backup_inf($vps, $temp_backup_dir)) {
            $error[] = $l["err_vzdump"];
            return false;
        }
        return $final_backup;
    }
    public function restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit, $storagename = "")
    {
        global $globals;
        global $error;
        global $l;
        $last_actid = $GLOBALS["current_taskid"];
        $this->poweroff($vps["vpsid"]);
        $GLOBALS["current_taskid"] = $last_actid;
        $vps_uuid = $this->getuuid($vps["vpsid"]);
        if(empty($vps_uuid)) {
            $error[] = $l["vps_uuid_empty"];
            return false;
        }
        $uncompression = get_decompression_algo($backup_filename, 1, 0);
        if(in_array($uncompression["file_ext"], ["lzo", "zst", "lz4"])) {
            vexec("cd " . xss("/vz/private/" . $vps_uuid) . " && " . $uncompression["compression_algo"] . " " . $uncompression["params"] . " " . xss($temp_restore_dir . "/" . $backup_filename) . " > root.tar && /bin/tar -xvf root.tar " . xss("root.hdd"), $out, $ret);
            vexec("cd " . xss("/vz/private/" . $vps_uuid) . " && rm -rf root.tar", $o, $r);
        } else {
            vexec("cd " . xss("/vz/private/" . $vps_uuid) . " && /bin/tar " . (preg_match("/\\.gz\$/is", $backup_filename) ? "-xvzf" : "-xvf") . " " . xss($temp_restore_dir . "/" . $backup_filename) . " " . xss("root.hdd"), $out, $ret);
        }
        return true;
    }
    public function suspendvps($vid)
    {
        global $globals;
        global $l;
        if($this->vps_status_statewise($vid, 1) == 2 || $this->vps_status_statewise($vid, 1) == 0) {
            return true;
        }
        $actid = vps_task("suspend_vps", "", 0, $vid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        if(!empty($globals["vz6_style_suspend"])) {
            return $GLOBALS["openvz_kernel"]->suspendvps($vid);
        }
        $vps_name = $this->getname($vid);
        if($this->vps_status_statewise($vid, 1) == 0) {
            $this->start($vid);
        }
        vexec("/usr/bin/prlctl suspend " . xss($vps_name), $output, $ret);
        if($ret == "0") {
            vexec("/usr/bin/prlctl set " . xss($vps_name) . " --autostart off", $_output, $_ret);
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["suspend_error"], -1);
        return false;
    }
    public function unsuspendvps($vid)
    {
        global $globals;
        global $l;
        if(!empty($globals["vz6_style_suspend"])) {
            return $GLOBALS["openvz_kernel"]->unsuspendvps($vid);
        }
        $vps_name = $this->getname($vid);
        file_put_contents(logdir("unsuspend") . $vid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        $actid = vps_task("unsuspend_vps", "", 0, $vid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        vexec("/usr/bin/prlctl resume " . xss($vps_name), $output, $ret);
        if($ret == "0") {
            vexec("prlctl set " . xss($vps_name) . " --autostart on", $output, $_ret);
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["unsuspend_error"], -1);
        return false;
    }
    public function suspend_vps_net($vid)
    {
        global $l;
        $vps_name = $this->getname($vid);
        vexec("prlctl set " . xss($vps_name) . " --ipdel all", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function unsuspend_vps_net($vid)
    {
        $vps_name = $this->getname($vid);
        file_put_contents(logdir("nw_unsuspend") . $vid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        $res = makequery("SELECT ip FROM ips WHERE vpsid = :vid ORDER BY `primary` DESC", [":vid" => $vid]);
        if(0 < vsql_num_rows($res)) {
            $ips = [];
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $ips[] = $row["ip"];
            }
            $ips_cmd = implode(" --ipadd ", $ips);
            vexec("prlctl set " . xss($vps_name) . " --ipadd " . $ips_cmd, $output, $ret);
        }
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function vps_net_status($vpsid)
    {
        $value = 0;
        if(empty($vpsid)) {
            return $value;
        }
        $vps_name = $this->getname($vpsid);
        vexec("vzctl exec " . xss($vps_name) . " ip a", $output, $ret);
        $output = implode("\n", $output);
        $value = preg_match("/venet0/is", $output) ? 1 : 0;
        return $value;
    }
    public function createtemplate($vid, $name)
    {
        global $globals;
        global $error;
        global $l;
        $vps_name = $this->getname($vid);
        $vps_uuid = $this->getuuid($vid);
        $path = $globals["vzoos"] . "/" . $name . ".tar.gz";
        if(file_exists($path)) {
            $error[] = $l["temp_exists"];
            return false;
        }
        $status = $this->status($vid);
        if($status == 0) {
            vexec("/usr/bin/prlctl mount " . xss($vps_name), $mount);
        }
        vexec("cd " . xss("/vz/root/" . $vps_uuid . "/") . "; /bin/tar -pzcf " . xss($path) . " * --exclude=\"virtbackup/*\"");
        if($status == 0) {
            vexec("/usr/bin/prlctl umount " . xss($vps_name), $mount);
        }
        if(@vfilesize($path) < 1) {
            return false;
        }
        return $name . ".tar.gz";
    }
    public function check_kernel()
    {
        global $l;
        global $globals;
        if(!empty($globals["is_master_only"])) {
            return true;
        }
        oexec("uname -r", $uname);
        if(@preg_match("/\\.vz7\\./is", $uname)) {
            return true;
        }
        return $l["wrong_kernel"] . "<b>" . $uname . "</b>." . $l["correct_kernel"];
    }
    public function resources()
    {
        global $globals;
        $ret["licnumvs"] = $globals["licnumvs"];
        $ret["ram"] = 0;
        $ret["space"] = 0;
        $ret["total_ram"] = 0;
        $ret["total_space"] = 0;
        $ret["check_kernel"] = $this->check_kernel();
        $ret["overcommit"] = $globals["overcommit"];
        $meminfo = get_meminfo();
        if(array_key_exists("MemAvailable", $meminfo)) {
            $free = $meminfo["MemAvailable"];
        } else {
            $free = $meminfo["Buffers"] + $meminfo["Cached"] + $meminfo["MemFree"];
        }
        $ret["ram"] = $free;
        $ret["total_ram"] = $meminfo["MemTotal"];
        vexec("/bin/df /vz", $disk);
        unset($disk[0]);
        $disk[1] = str_replace("\n", "", implode(" ", $disk));
        if(!empty($disk[1])) {
            $tmp = preg_split("/\\s+/", trim($disk[1]));
            $ret["space"] = @round((double) @trim($tmp[3]) / 1024 / 1024, 2);
            $ret["total_space"] = @round((double) @trim($tmp[1]) / 1024 / 1024, 2);
        }
        $ret["cpucores"] = get_cores();
        return $ret;
    }
    public function enable_tuntap($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl set " . xss($vps_name) . " --devnodes net/tun:rw --save");
        vexec("/usr/sbin/vzctl set " . xss($vps_name) . " --devices \"c:10:200:rw c:108:0:rw\" --save");
        vexec("/usr/sbin/vzctl set " . xss($vps_name) . " --capability net_admin:on --save", $output, $ret);
        if($this->status($vid) == 1 && empty($ret)) {
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " mkdir -p /dev/net");
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " mknod /dev/net/tun c 10 200");
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " chmod 600 /dev/net/tun");
            return true;
        }
        return false;
    }
    public function disable_tuntap($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " ls /dev/net/tun", $o, $ret);
        if(empty($ret)) {
            vexec("/usr/sbin/vzctl set " . xss($vps_name) . " --devnodes net/tun:r --save");
            if(empty($ret)) {
                vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " rm -f /dev/net/tun");
                return true;
            }
            return false;
        }
        return false;
    }
    public function enable_ppp($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl set " . xss($vps_name) . " --features ppp:on --save", $output, $ret);
        vexec("/usr/sbin/vzctl set " . xss($vps_name) . " --devices \"c:10:200:rw c:108:0:rw\" --save");
        if($this->status($vid) == 1 && empty($ret)) {
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " mknod /dev/ppp c 108 0");
            vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " chmod 600 /dev/ppp");
            return true;
        }
        return false;
    }
    public function disable_ppp($vid)
    {
        $vps_name = $this->getname($vid);
        vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " ls /dev/ppp", $o, $ret);
        if(empty($ret)) {
            vexec("/usr/sbin/vzctl set " . xss($vps_name) . " --features ppp:off --save", $output, $ret);
            if(empty($ret)) {
                vexec("/usr/sbin/vzctl exec " . xss($vps_name) . " rm -rf /dev/ppp");
                return true;
            }
            return false;
        }
        return false;
    }
    public function cron()
    {
        global $globals;
        global $l;
        global $kernel;
        $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_1";
        $vpses = get_bw_vps("vzo");
        $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_2";
        $status = $this->vps_status_statewise(array_keys($vpses));
        $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_3";
        $io_usage = $this->get_io_usage();
        foreach ($vpses as $k => $v) {
            if(!empty($globals["cb_bandwidth_overusage"]) && !empty($vpses[$k]["bandwidth"]) && $vpses[$k]["bandwidth"] < $vpses[$k]["used_bandwidth"]) {
                $callback["act"][] = "bandwidth_overusage";
                $callback["data"]["email"] = $vpses[$k]["email"];
                $callback["data"]["overused"] = $vpses[$k]["used_bandwidth"] - $vpses[$k]["bandwidth"];
                $service_period = get_vps_service_period($k);
                $before = $service_period["end"] - 480;
                $current = time();
                if($before < $current && $current <= $service_period["end"]) {
                    vps_task("bandwidth_overusage_callback", serialize($callback), 0, $k, $vpses[$k]["uid"], 0, $l["task_pending"]);
                }
            }
            $vpses[$k]["status"] = $status[$k];
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_4";
            $vpses[$k]["cpu"] = $this->_cpu_stats($k);
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_5";
            $disk = $this->disk($k);
            $disk["used"] = $disk["used"];
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_6";
            $inodes = $this->inodes($k);
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_7";
            $ram = $this->ram($k);
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_8";
            $vpses[$k]["net_speed"] = $this->network_speed($k);
            makequery("INSERT INTO status SET\n\t\t\t\t\t\t`vpsid` = :vpsid, \n\t\t\t\t\t\t`time` = :time,\n\t\t\t\t\t\t`status` = :status,\n\t\t\t\t\t\t`disk` = :disk,\n\t\t\t\t\t\t`inode` = :inode,\n\t\t\t\t\t\t`ram` = :ram,\n\t\t\t\t\t\t`cpu` = :cpu,\n\t\t\t\t\t\t`actual_cpu` = :actual_cpu,\n\t\t\t\t\t\t`net_in` = :net_in,\n\t\t\t\t\t\t`net_out` = :net_out,\n\t\t\t\t\t\t`io_read` = :io_read,\n\t\t\t\t\t\t`io_write` = :io_write", [":vpsid" => $v["vpsid"], ":time" => $globals["cron_timestamp"], ":status" => $vpses[$k]["status"], ":disk" => $disk["used"], ":inode" => $inodes["used"], ":ram" => $ram["used"], ":cpu" => $vpses[$k]["cpu"], ":actual_cpu" => $vpses[$k]["cpu"], ":net_in" => $vpses[$k]["net_speed"]["download"], ":net_out" => $vpses[$k]["net_speed"]["upload"], ":io_read" => $io_usage[$k]["read"], ":io_write" => $io_usage[$k]["write"]]);
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_9";
            $vpses[$k]["net_status"] = $this->vps_net_status($k);
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_10";
            $cpu = $this->cpu($k);
            $vpses[$k]["cpu_usage"] = $cpu["percent"];
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_11";
            $ram = $this->ram($k);
            $vpses[$k]["ram_usage"] = $ram["percent"];
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_12";
            $disk = $this->disk($k);
            $vpses[$k]["disk_usage"] = $disk["percent"];
            makequery("INSERT INTO system_alerts SET\n\t\t\t\t\t\t`vpsid` = :vpsid,\n\t\t\t\t\t\t`time` = :time,\n\t\t\t\t\t\t`cpu` = :cpu,\n\t\t\t\t\t\t`ram` = :ram,\n\t\t\t\t\t\t`disk` = :disk", [":vpsid" => $v["vpsid"], ":time" => time(), ":cpu" => $vpses[$k]["cpu_usage"], ":ram" => $vpses[$k]["ram_usage"], ":disk" => $vpses[$k]["disk_usage"]]);
            if(!empty($globals["openvz_suspend_load"])) {
                $vload = [];
                $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_13";
                oexec("vzctl exec " . xss($v["vps_name"]) . " uptime", $vload, $vret);
                $load = calc_load($vload);
                if($globals["openvz_suspend_load"] <= $load[1]) {
                    $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_14";
                    if($this->suspendvps($v["vpsid"])) {
                        $res = makequery("UPDATE vps \n\t\t\t\t\t\t\t\tSET suspended = '1',\n\t\t\t\t\t\t\t\tsuspend_reason = 'load'\n\t\t\t\t\t\t\t\tWHERE vpsid=:vpsid", [":vpsid" => $v["vpsid"]]);
                        logs_vps("load_suspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    }
                }
            }
            if(!empty($vpses[$k]["suspended"]) && $vpses[$k]["status"] != 2) {
                if(time() - filemtime(logdir("unsuspend") . $k . ".log") <= 60) {
                    echo "VPSID : " . $k . " was just unsuspended and we will wait for the next CRONM\n";
                } else {
                    echo "Suspending VPSID " . $k . " as it should have been suspended\n";
                    $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_15";
                    $this->suspendvps($v["vpsid"]);
                    logs_vps("suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                }
            }
            if(!empty($v["nw_suspended"])) {
                $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vpsid \n\t\t\t\t\t\tAND action = 'bandwidth_unsuspend'\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0", [":vpsid" => $v["vpsid"]]);
                $tmp_uvps = [];
                if(0 < vsql_num_rows($res)) {
                    $tmp_uvps = vsql_fetch_assoc($res);
                }
                $vs_nw_sus_dat = _unserialize($v["nw_suspended"]);
                if(!empty($tmp_uvps) && check_unsusp_vps_net($v["time"], $vs_nw_sus_dat["date"])) {
                    if($v["suspended"] == 1 && $v["suspend_reason"] == "bw") {
                        $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_16";
                        $this->unsuspendvps($v["vpsid"]);
                        $res = makequery("UPDATE vps SET \n\t\t\t\t\t\t\t\tsuspended = '0',\n\t\t\t\t\t\t\t\tsuspend_reason = ''\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        to_master("vps", "suspended", $v["vpsid"], "vpsid", "0");
                        to_master("vps", "suspend_reason", $v["vpsid"], "vpsid", "");
                    }
                    $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_17";
                    if($this->unsuspend_vps_net($v["vpsid"])) {
                        task_start($tmp_uvps["actid"]);
                        $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\tSET nw_suspended = NULL\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        logs_vps("bandwidth_unsuspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                        to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", NULL);
                        task_update($tmp_uvps["actid"], $l["completed"], 100);
                    }
                } elseif($vpses[$k]["net_status"]) {
                    if(time() - filemtime(logdir("nw_unsuspend") . $k . ".log") <= 60) {
                        echo "VPSID : " . $k . " NETWORK was just unsuspended and we will wait for the next CRONM\n";
                    } else {
                        echo "Suspending network of VPSID " . $k . " as its network should have been suspended\n";
                        $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_18";
                        $this->suspend_vps_net($v["vpsid"]);
                        logs_vps("bandwidth_suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    }
                }
            }
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_19";
            $bandwidth_val = $kernel->bandwidth($v["vpsid"]);
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_20";
            $service_period = get_vps_service_period($v["vpsid"]);
            $timestamp_threshold = @file_get_contents($globals["var"] . "/eubwthreshold/" . $v["vpsid"]);
            $used_percent_bandw = round(100 * $bandwidth_val["used_gb"] / $bandwidth_val["limit_gb"]);
            $user_threshold_bandw = $v["preferences"]["vps_bandwidth_threshold"];
            $set_threshold_bandw = !empty($user_threshold_bandw) ? $user_threshold_bandw : $globals["vps_bandwidth_threshold"];
            if($user_threshold_bandw < 0) {
                $set_threshold_bandw = 0;
            }
            if(!empty($bandwidth_val["limit_gb"]) && !empty($set_threshold_bandw) && $set_threshold_bandw < $used_percent_bandw && $timestamp_threshold < $service_period["start"]) {
                $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "vps_bandwidth_threshold" => $set_threshold_bandw, "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                if(!empty($v["email"])) {
                    send_emailtemp_mail("bandwidth_threshold", $v["email"], $email_vars, 1);
                    writefile($globals["var"] . "/eubwthreshold/" . $v["vpsid"], time(), 1);
                }
                $data["title"] = $l["bandwidth_threshold_mail_sub"];
                $data["data"] = lang_vars_name($l["bandwidth_threshold_notify"], $email_vars);
                save_notification("vps_band_thershold", $data);
            }
            if($bandwidth_val["limit_gb"] < $bandwidth_val["used_gb"] && !empty($bandwidth_val["limit_gb"]) && $v["band_suspend"] == 1 && empty($v["nw_suspended"]) && empty($globals["band_suspend"])) {
                $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_21";
                if($this->suspend_vps_net($v["vpsid"])) {
                    echo "Suspending network of VPSID " . $k . " as bandwidth has been overused. Used : " . $bandwidth_val["used_gb"] . " Allowed : " . $bandwidth_val["limit_gb"] . "\n";
                    $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                    if(!empty($v["email"]) && empty($globals["disable_suspend_email"])) {
                        send_emailtemp_mail("bandwidth", $v["email"], $email_vars, 1);
                    }
                    $data["title"] = $l["bandwidth_mail_sub"];
                    $data["data"] = lang_vars_name($l["bandwidth_mail_message_notify"], $email_vars);
                    save_notification("vps_band_suspended", $data);
                    $reason = serialize(["id" => "2", "reason" => "bw", "date" => time()]);
                    $res = makequery("UPDATE vps \n\t\t\t\t\t\t\tSET nw_suspended = :reason\n\t\t\t\t\t\t\tWHERE vpsid=:vpsid", [":vpsid" => $v["vpsid"], ":reason" => $reason]);
                    $v["nw_suspended"] = $reason;
                    vps_task("bandwidth_unsuspend", $v["vps_name"], 0, $v["vpsid"], $v["uid"], 1);
                    logs_vps("bandwidth_suspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", $reason);
                }
            }
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_22";
            handle_speed_cap($v, $this, $bandwidth_val);
            $GLOBALS["cronm_exit_ret"]["vzo"][] = "vzo_kernel_cronm_23";
        }
    }
    public function cronh()
    {
        return true;
    }
    public function create_internal_network($ippid, $bind_ip)
    {
        $interface = empty($GLOBALS["globals"]["interface"]) ? "eth0" : $GLOBALS["globals"]["interface"];
        vexec("/sbin/ifconfig " . xss($interface) . ":" . xss($ippid) . " " . xss($bind_ip) . " up");
    }
    public function destroy_internal_network($ippid)
    {
        $interface = empty($GLOBALS["globals"]["interface"]) ? "eth0" : $GLOBALS["globals"]["interface"];
        vexec("/sbin/ifconfig " . xss($interface) . ":" . xss($ippid) . " down");
    }
    public function console_session_create($vid, $duration)
    {
        $vps = getvps($vid);
        $desc = "Virtualizor VID " . $vps["vps_name"];
        $return = [];
        $tmp = @file("/etc/passwd");
        $passwd = [];
        foreach ($tmp as $uk => $uv) {
            $uv = explode(":", trim($uv));
            $passwd[$uv[0]] = $uv;
            if($desc == $uv[4]) {
                $username = trim($uv[0]);
            }
        }
        $arch = os_arch() == 64 ? "64" : "32";
        if(!is_link("/usr/local/virtualizor/bin/virtconsole")) {
            unlink("/usr/local/virtualizor/bin/virtconsole");
            vexec("/bin/ln -s /usr/local/virtualizor/bin/virtconsole_" . $arch . "  /usr/local/virtualizor/bin/virtconsole 2>/dev/null");
        }
        if(empty($username)) {
            $username = "virtcon-" . generateRandStr(8);
            vexec("useradd -s /usr/local/virtualizor/bin/virtconsole -c " . xss($desc) . " -m " . xss($username), $out, $ret);
            if($ret != 0) {
                $return["error"] = "There was an error creating system user";
                return $return;
            }
        }
        vexec("usermod -s /usr/local/virtualizor/bin/virtconsole " . xss($username), $out, $ret);
        $pass = generateRandStr(16);
        $params = ["password" => $pass];
        vexec("passwd " . $username . " << EOF" . "\n" . $pass . "\n" . $pass . "\n" . "EOF", $passout, $ret);
        if($ret != 0) {
            $return["error"] = "There was an error setting the password";
            return $return;
        }
        if(is_file("/etc/ssh/sshd_config")) {
            $file = file("/etc/ssh/sshd_config");
            foreach ($file as $k => $v) {
                if(preg_match("/\\bPort\\b(\\s*?)(.*?)/is", $v)) {
                    $sshport = str_replace("Port", "", $file[$k]);
                    $sshport = (int) trim($sshport);
                }
            }
        }
        @chmod("/usr/local/virtualizor/bin/virtconsole_" . $arch, 2413);
        $return["username"] = $username;
        $return["password"] = $pass;
        $return["start"] = time();
        $return["port"] = empty($sshport) ? 22 : $sshport;
        $return["duration"] = $duration;
        return $return;
    }
    public function console_session_destroy($vid)
    {
        $vps = getvps($vid);
        $desc = "Virtualizor VID " . $vps["vps_name"];
        $return = [];
        $tmp = @file("/etc/passwd");
        $passwd = [];
        foreach ($tmp as $uk => $uv) {
            $uv = explode(":", trim($uv));
            $passwd[$uv[0]] = $uv;
            if($desc == $uv[4]) {
                $username = trim($uv[0]);
            }
        }
        if(empty($username)) {
            $return["error"] = "No user found";
            return $return;
        }
        vexec("usermod -s /sbin/nologin " . xss($username), $out, $ret);
        if($ret != 0) {
            $return["error"] = "There was an error while deactivating the user";
            return $return;
        }
        $return["username"] = $username;
        return $return;
    }
    public function vm_location($vids, $live = false)
    {
        return $vids;
    }
    public function storage_check($data)
    {
        if(strtolower($data["type"]) != "openvz") {
            return "Invalid storage";
        }
        if(!file_exists($data["path"])) {
            return "The storage doesn't exist";
        }
        return "";
    }
    public function _network_usage($vid)
    {
        $vps = getvps($vid);
        oexec("/usr/sbin/vzctl exec " . xss($vps["vps_name"]) . " \"grep venet0 /proc/net/dev\"", $x);
        $value = preg_split("/[\\s]+/", str_replace(":", ": ", trim($x)));
        if(empty($value[1]) && empty($value[9])) {
            $value[1] = 0;
            $value[9] = 0;
        }
        list($c["in"], $c["out"]) = $value;
        return $c;
    }
    public function _cpu_stats($vid)
    {
        $vps_name = $this->getname($vid);
        oexec("prlctl statistics " . xss($vps_name) . " --filter guest.cpu.usage", $tmp_out);
        $ret = explode(":", $tmp_out);
        return trim($ret[1]);
    }
    public function vs_ntw_speed($vpsids)
    {
        $ret = [];
        $value1 = [];
        $value2 = [];
        foreach ($vpsids as $k => $v) {
            $value1[$v] = $this->_network_usage($v);
            $value1[$v]["time"] = time();
        }
        usleep(1000000);
        foreach ($vpsids as $k => $v) {
            $value2[$v] = $this->_network_usage($v);
            $value2[$v]["time"] = time();
        }
        foreach ($vpsids as $k => $v) {
            $diff = $value2[$v]["time"] - $value1[$v]["time"];
            if($value2[$v]["in"] < $value1[$v]["in"]) {
                $value2[$v]["in"] = $value1[$v]["in"];
                $value2[$v]["out"] = $value1[$v]["out"];
            }
            $ret[$v]["download"] = ($value2[$v]["in"] - $value1[$v]["in"]) / $diff;
            $ret[$v]["upload"] = ($value2[$v]["out"] - $value1[$v]["out"]) / $diff;
        }
        return $ret;
    }
    public function vs_disk_usage($vpsids)
    {
        $ret = [];
        foreach ($vpsids as $k => $v) {
            $tmp = [];
            $tmp["disk"] = $this->disk($v);
            $tmp["inode"] = $this->inodes($v);
            $ret[$v]["disk"]["used"] = empty($tmp["disk"]["used"]) ? 0 : $tmp["disk"]["used"] / 1024;
            $ret[$v]["disk"]["allocated"] = empty($tmp["disk"]["limit"]) ? 0 : $tmp["disk"]["limit"] / 1024;
            $ret[$v]["inode"]["used"] = empty($tmp["inode"]["used"]) ? 0 : $tmp["inode"]["used"];
            $ret[$v]["inode"]["allocated"] = empty($tmp["inode"]["limit"]) ? 0 : $tmp["inode"]["limit"];
        }
        return $ret;
    }
    public function migrate($vpsid, $data, $migrate_disk = 0)
    {
        global $globals;
        global $error;
        global $l;
        $speed = (int) (!empty($globals["default_mig_speed"]) ? $globals["default_mig_speed"] : 100);
        $uuid = $this->getuuid($vpsid);
        $new_vpsname = $data["new_vpsname"];
        $vps_name = $this->getname($vpsid);
        if(!empty($data["speed_limit"])) {
            $speed = $data["speed_limit"];
        }
        if(empty($data["live_mig"])) {
            $src_disk_path = $data["src_disk_path"];
            $dst_disk_path = $data["dst_disk_path"];
            if(empty($src_disk_path)) {
                $error[] = "Empty source VPS disk path";
            }
            if(empty($dst_disk_path)) {
                $error[] = "Empty destination VPS disk path";
            }
        }
        if(!empty($error)) {
            return false;
        }
        $sparse = 1;
        if(!empty($data["live_mig"])) {
            vexec("bash " . $globals["path"] . "/scripts/vzk_live_migrate.sh " . $vps_name . " " . $data["to_ip"] . " " . $data["to_ssh_port"] . " " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log > " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $r);
        } else {
            $throttle_block_size = get_throttle_block_size();
            vexec("bash " . $globals["path"] . "/scripts/migrate_dd.sh " . $src_disk_path . " " . $dst_disk_path . " " . $speed . " " . $data["to_ssh_port"] . " " . $data["to_ip"] . " " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log " . logdir($data["selected_act"]) . $data["vpsid"] . "-actual_transfer.log " . $data["disable_gzip"] . " " . $sparse . " " . xss($data["from_pgzip"]) . " " . xss($data["to_pgzip"]) . " " . xss($throttle_block_size) . " > " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $r);
        }
        if($r != 0) {
            $error[] = $l["mig_err_bg_exec"];
            return false;
        }
        return true;
    }
    public function get_vps_bridge($vpsid)
    {
        $ret = [];
        return $ret;
    }
    public function getuuid($vpsid)
    {
        global $globals;
        $vps_name = $this->getname($vpsid);
        vexec("/usr/bin/prlctl list " . xss($vps_name) . " -o uuid", $out, $ret);
        $uuid = substr($out[1], 1, -1);
        return $uuid;
    }
    public function vncDetails($vid)
    {
        global $globals;
        $vps = getvps($vid);
        $calling_file = basename($_SERVER["SCRIPT_FILENAME"]);
        if(in_array($calling_file, ["addvs.php", "rebuild.php"])) {
            sleep(2);
        }
        $vps_info = $this->vps_info($vid);
        $info["mode"] = $vps_info["Remote display"]["mode"];
        $info["port"] = $vps_info["Remote display"]["port"];
        $info["ip"] = $vps_info["Remote display"]["address"] == "0.0.0.0" ? server_vncip($vps["serid"]) : $vps_info["Remote display"]["address"];
        $info["password"] = $vps["vnc_passwd"];
        $info["state"] = $vps_info["Remote display state"];
        return $info;
    }
    public function changeVncPass($vid, $newpassword, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        if(empty($actid)) {
            $actid = vps_task("change_vncpass", base64_encode($newpassword), 0, $vid, $user["uid"], 1);
        }
        task_start($actid);
        task_update($actid, $l["started"], 10, "XXXXXXXX");
        $vps_name = $vps["vps_name"];
        $params = ["password" => xss($newpassword)];
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --vnc-passwd " . xss($newpassword), $out, $ret, $params);
        if($ret != 0) {
            task_update($actid, $l["err_vncpass"], -1);
            return false;
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vps_info($vid)
    {
        global $globals;
        global $error;
        $vps = getvps($vid);
        oexec("prlctl list " . xss($vps["vps_name"]) . " --info --json", $o);
        $ret = json_decode(json_encode(json_decode($o)), true);
        array_walk_recursive($ret, "trim");
        return $ret[0];
    }
    public function addsshkeys($vid, $ssh_keys)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("addsshkeys", "", 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
        task_start($actid);
        task_update($actid, $l["started"], 10);
        $uuid = $this->getuuid($vid);
        $rootdir = "/vz/root/";
        if(!empty($uuid) && is_dir($rootdir . $uuid)) {
            $rootdir = $rootdir . $uuid;
        } else {
            $rootdir = $rootdir . $vps["vps_name"];
        }
        if(!addsshkeys($rootdir, $ssh_keys)) {
            $error[] = $l["err_add_sshkeys"];
            task_update($actid, $l["err_add_sshkeys"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function removesshkeys($vid, $keys_to_remove)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("removesshkeys", "", 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
        task_start($actid);
        task_update($actid, $l["started"], 10);
        $uuid = $this->getuuid($vid);
        $rootdir = "/vz/root/";
        if(!empty($uuid) && is_dir($rootdir . $uuid)) {
            $rootdir = $rootdir . $uuid;
        } else {
            $rootdir = $rootdir . $vps["vps_name"];
        }
        if(!removesshkeys($rootdir, $keys_to_remove)) {
            $error[] = $l["err_remove_sshkeys"];
            task_update($actid, $l["err_remove_sshkeys"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function get_io_usage($vid = 0)
    {
        $delay = 3;
        $vpses = [];
        $io_usage = [];
        $token_vals = [];
        $query = "SELECT vpsid, vps_name FROM vps\n\t\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\t\tAND virt = 'vzo'";
        if(!empty($vid)) {
            $query .= " AND vpsid = :vid";
            $token_vals[":vid"] = $vid;
        }
        $res = makequery($query, $token_vals);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
            $io_usage[$row["vpsid"]] = ["read" => 0, "write" => 0];
        }
        foreach ($vpses as $vpsid => $vps) {
            vexec("prlctl list -o uuid -H " . $vps["vps_name"], $out, $ret);
            $uuid = trim($out[0], " {}");
            if(empty($uuid)) {
            } else {
                $ioacct = @file_get_contents("/proc/bc/" . $uuid . "/ioacct");
                $lines = explode("\n", trim($ioacct));
                foreach ($lines as $line) {
                    $parts = preg_split("/\\s+/is", trim($line));
                    if(count($parts) < 2) {
                    } elseif($parts[0] == "read") {
                        $io_usage[$vpsid]["read"] = (int) $parts[1];
                    } elseif($parts[0] == "write") {
                        $io_usage[$vpsid]["write"] = (int) $parts[1];
                    }
                }
            }
        }
        sleep($delay);
        foreach ($vpses as $vpsid => $vps) {
            vexec("prlctl list -o uuid -H " . $vps["vps_name"], $out, $ret);
            $uuid = trim($out[0], " {}");
            if(empty($uuid)) {
            } else {
                $ioacct = @file_get_contents("/proc/bc/" . $uuid . "/ioacct");
                $lines = explode("\n", trim($ioacct));
                foreach ($lines as $line) {
                    $parts = preg_split("/\\s+/is", trim($line));
                    if(count($parts) < 2) {
                    } elseif($parts[0] == "read") {
                        $read = (int) $parts[1];
                        $io_usage[$vpsid]["read"] = ($read - $io_usage[$vpsid]["read"]) / $delay;
                    } elseif($parts[0] == "write") {
                        $write = (int) $parts[1];
                        $io_usage[$vpsid]["write"] = ($write - $io_usage[$vpsid]["write"]) / $delay;
                    }
                }
            }
        }
        return $io_usage;
    }
    public function get_ovz_pkg_mgr($tmpl)
    {
        $ovz_distros = ["fedora" => ["fedora"], "redhat" => ["rhel", "redhat", "centos", "mandrake", "scientific", "almalinux"], "sles" => ["sles", "suse"], "opensuse" => ["opensuse"], "gentoo" => ["opensuse"], "slackware" => ["slackware"], "vzlinux" => ["vzlinux"], "debian" => ["debian", "ubuntu"]];
        $tmpla = preg_split("/\\-/i", $tmpl);
        $found = 0;
        foreach ($ovz_distros as $base => $vars) {
            foreach ($vars as $var) {
                if($tmpla[0] == $var) {
                    $distro = $base;
                    $found = 1;
                }
            }
            if($found) {
                if(empty($distro)) {
                    return false;
                }
                $ver = 0;
                $arch = "x86";
                if((int) $tmpla[1]) {
                    $ver = (int) $tmpla[1];
                    $arch = $tmpla[2];
                } elseif((int) $tmpla[2]) {
                    $ver = (int) $tmpla[2];
                    $arch = $tmpla[3];
                }
                $arch = in_array($arch, ["x86"]) ? 0 : 1;
                $pkg_mgrs = ["fedora" => ["def" => ["rpm49db5x86", "rpm49db5x64"], "17" => ["rpm49db5x86", "rpm49db5x64"], "16" => ["rpm49x86", "rpm49x64"], "15" => ["rpm49x86", "rpm49x64"]], "redhat" => ["def" => ["rpm47x86", "rpm47x64"], "8" => ["rpm414x86", "rpm414x64"], "7" => ["rpm410x86", "rpm410x64"], "6" => ["rpm47x86", "rpm47x64"], "5" => ["rpm44x86", "rpm44x64"], "4" => ["rpm43x86", "rpm43x64"], "3" => ["rpm43x86", "rpm43x64"]], "sles" => ["def" => ["rpmzypp44x86", "rpmzypp44x64"], "11" => ["rpmzypp44x86", "rpmzypp44x64"], "10" => ["rpm41x86", "rpm41x64"], "9" => ["rpm41s9x86", "rpm41s9x64"]], "opensuse" => ["def" => ["rpmzypp49x86", "rpmzypp49x64"], "12" => ["rpmzypp49x86", "rpmzypp49x64"]], "debian" => ["def" => ["dpkg", "dpkgx64"]]];
                if("debian" == $distro) {
                    $ver = "def";
                }
                $packager = "";
                foreach ($pkg_mgrs[$distro] as $verk => $pkgrs) {
                    if($ver == $verk) {
                        $packager = $pkgrs[$arch];
                    }
                }
                if(empty($packager)) {
                    $packager = $pkg_mgrs[$distro]["def"][$arch];
                }
                return $packager;
            }
        }
    }
    public function get_ct_path($vid)
    {
        global $globals;
        global $error;
        global $cluster;
        if(empty($vid)) {
            return false;
        }
        $vps = getvps($vid);
        if(empty($vps) || empty($vps["vps_name"])) {
            $error[] = "Found no VPS with ID " . $vid;
            return false;
        }
        vexec("prlctl list -i " . xss($vps["vps_name"]) . " --json 2>&1", $o, $r);
        if($r != 0) {
            $error[] = "Error fetching CT path for " . $vid . " (" . $vps["vps_name"] . ")";
            $error[] = print_r($o, 1);
        }
        $path = "";
        $path2 = "";
        $o = implode("", $o);
        $o = json_decode($o, 1);
        foreach ($o[0]["Hardware"] as $k => $v) {
            if(preg_match("/^hdd\\d+/i", $k)) {
                $path = $o[0]["Hardware"][$k]["image"];
                $path2 = $path . "/root.hds";
                if(!empty($path) && file_exists($path2)) {
                    return $path2;
                }
                $error[] = "Path not exists: " . $path2;
                return false;
            }
        }
    }
    public function can_take_inc_backup($vpsid, $type)
    {
        $last_action = get_last_action($vpsid, 0);
        if(in_array($last_action, ["restored", "deleted"])) {
            return false;
        }
        if(!empty($GLOBALS["take_full"])) {
            return false;
        }
        return true;
    }
    public function backuply_delete($time, $chain, $dir, $bid, $vps)
    {
        global $globals;
        global $servers;
        global $vps_cache;
        $vps_cache = $vps;
        $backup_server = [];
        if(0 < $bid) {
            $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
            if(vsql_num_rows($res) == 0) {
                return false;
            }
            $backup_server = vsql_fetch_assoc($res);
        }
        $class = load_backup_class($backup_server, "utils");
        if(empty($class)) {
            return false;
        }
        $json = get_disk_json($vps["vpsid"], 0);
        $bkp_dir = $dir . "/" . $vps["uuid"] . "/" . $chain . "/";
        if(!empty($json[$chain]["folder_format"])) {
            $bkp_dir = $dir . "/" . $json[$chain]["folder_format"] . "/" . $chain . "/";
        }
        $og_path = $json[$chain]["og_path"] . "/";
        if($json[$chain]["htime"] == $time) {
            vexec("prlctl backup-delete " . $vps["vps_name"] . " --backup-path " . xss($bkp_dir) . " -t " . $json[$chain]["bitmap"]);
            $inf_file = "root.hdd" . (!empty($json[$chain]["counter"]) ? "." . $json[$chain]["counter"] : "") . ".inf";
            $class->_unlink($bkp_dir . $og_path . $inf_file);
            if(!empty($json[$chain]["children"])) {
                ksort($json[$chain]["children"]);
                foreach ($json[$chain]["children"] as $t => $file) {
                    vexec("prlctl backup-delete " . $vps["vps_name"] . " --backup-path " . xss($bkp_dir) . " -t " . $file["bitmap"]);
                    $inf_file = "root.hdd" . (!empty($file["counter"]) ? "." . $file["counter"] : "") . ".inf";
                    $class->_unlink($bkp_dir . $og_path . $inf_file);
                    unset($json[$chain]["children"][$t]);
                }
            }
            unset($json[$chain]);
            $class->_rmdir($bkp_dir);
            update_last_action($vps["vpsid"], 0, "deleted");
            save_disk_json($vps["vpsid"], $json, 0);
            return true;
        } else {
            ksort($json[$chain]["children"]);
            foreach ($json[$chain]["children"] as $t => $file) {
                if($time == $file["htime"]) {
                    vexec("prlctl backup-delete " . $vps["vps_name"] . " --keep-chain --backup-path " . xss($bkp_dir) . " -t " . $file["bitmap"]);
                    $inf_file = "root.hdd" . (!empty($file["counter"]) ? "." . $file["counter"] : "") . ".inf";
                    $class->_unlink($bkp_dir . $og_path . $inf_file);
                    unset($json[$chain]["children"][$t]);
                    $delete_all_files = 1;
                }
                if($delete_all_files && $time != $file["htime"]) {
                    vexec("prlctl backup-delete " . $vps["vps_name"] . " --keep-chain --backup-path " . xss($bkp_dir) . " -t " . $file["bitmap"]);
                    $inf_file = "root.hdd" . (!empty($file["counter"]) ? "." . $file["counter"] : "") . ".inf";
                    $class->_unlink($bkp_dir . $og_path . $inf_file);
                    unset($json[$chain]["children"][$t]);
                }
            }
            update_last_action($vps["vpsid"], 0, "deleted");
            save_disk_json($vps["vpsid"], $json, 0);
            $delete_all_files = 0;
            return true;
        }
    }
    public function backuply_backup($vpsid, $bkp_dir, $disk_num, $pref_type)
    {
        global $error;
        global $backup_folder;
        global $kernel;
        $vps = getvps($vpsid);
        $filename = $vpsid . "_" . parse_backup_hostname($vps["hostname"]) . (!empty($disk_num) ? "_" . $disk_num : "") . "_" . $GLOBALS["backup_file_time"];
        if(empty($pref_type)) {
            $type = "full";
        }
        if($pref_type == "inc") {
            $type = "inc";
        } elseif($pref_type == "diff") {
            $type = "inc";
        } elseif($pref_type == "full") {
            $type = "full";
        }
        if(!$this->can_take_inc_backup($vpsid, $type)) {
            $type = "full";
        }
        $count = 0;
        $opt = "";
        if($type == "full") {
            $opt = " -f";
        } else {
            $file_contents = get_disk_json($vpsid, $disk_num);
            ksort($file_contents);
            $last_chain = array_end($file_contents);
            if(!empty($last_chain["children"])) {
                ksort($last_chain["children"]);
                $count = array_end($last_chain["children"])["file_count"] + 1;
            }
        }
        vexec("prlctl set " . $vps["vps_name"] . " --backup-path " . xss($bkp_dir));
        vexec("prlctl backup " . $vps["vps_name"] . $opt . " 2>&1", $o, $r);
        if($r != 0) {
            $error[] = print_r($o, 1);
            return false;
        }
        foreach ($o as $v) {
            if(!preg_match("/\\{(.*)\\}(\\.)(.*)/", $v, $m)) {
            } else {
                $bitmap = substr($m[0], 0, -1);
                $folder_uuid = "{" . $m[1] . "}";
                $counter = (int) $m[3];
            }
        }
        if(!empty($counter)) {
            $type = "inc";
        } else {
            $type = "full";
        }
        $og_file = "root.hdd" . (!empty($counter) ? "." . $counter : "") . ".qcow2";
        $uuid = $this->getuuid($vpsid);
        $filepath = $bkp_dir . "/{" . $uuid . "}/" . $folder_uuid . "/" . $og_file;
        $og_path = "{" . $uuid . "}/" . $folder_uuid . "/" . $og_file;
        $date = DateTime::createFromFormat("Y_m_d-H_i_s", $GLOBALS["backup_file_time"]);
        $disk_new_arr = ["filepath" => $filepath, "og_file" => $og_file, "og_path" => dirname($og_path), "counter" => !empty($counter) ? $counter : "", "htime" => $GLOBALS["backup_file_time"], "time" => $date->format("U"), "bitmap" => $bitmap, "is_vzo" => 1, "size" => vfilesize($filepath), "folder_format" => basename(dirname($backup_folder)), "file_count" => $count];
        $disk_json = get_disk_json($vpsid, $disk_num);
        $disk_arr = !empty($disk_json) ? $disk_json : [];
        $disk_new_arr["type"] = $pref_type;
        if(!empty($disk_arr)) {
            if(empty($counter)) {
                $disk_arr[basename($backup_folder)] = $disk_new_arr;
                $disk_arr[basename($backup_folder)]["hostname"] = $vps["hostname"];
                $disk_arr[basename($backup_folder)]["vps_uuid"] = $vps["uuid"];
                $disk_arr[basename($backup_folder)]["vpsid"] = $vps["vpsid"];
            } else {
                $disk_arr[basename($backup_folder)]["children"][time()] = $disk_new_arr;
            }
        } else {
            $disk_arr[basename($backup_folder)] = $disk_new_arr;
            $disk_arr[basename($backup_folder)]["hostname"] = $vps["hostname"];
            $disk_arr[basename($backup_folder)]["vps_uuid"] = $vps["uuid"];
            $disk_arr[basename($backup_folder)]["vpsid"] = $vps["vpsid"];
        }
        save_disk_json($vpsid, $disk_arr, $disk_num);
        update_last_action($vps["vpsid"], 0, "backuped");
        return array_merge(["filename" => $filename], $disk_new_arr);
    }
    public function backuply_restore($vpsid, $backing_file, $disk_num)
    {
        global $error;
        $vps = getvps($vpsid);
        $last_actid = $GLOBALS["current_taskid"];
        $this->poweroff($vpsid);
        $GLOBALS["current_taskid"] = $last_actid;
        vexec("prlctl restore " . $vps["vps_name"] . " --backup-path " . xss(dirname($backing_file)) . " -t " . basename($backing_file), $o, $r);
        if($r != 0) {
            $error[] = print_r($o, 1);
            return false;
        }
        update_last_action($vps["vpsid"], 0, "restored");
        return true;
    }
    public function is_live_mig_supported($vpsid, $src, $dest)
    {
        global $globals;
        global $cluster;
        global $servers;
        global $l;
        global $error;
        $cpu_src = $cluster->cpu($src);
        $cpu_dest = $cluster->cpu($dest);
        if(strtolower($cpu_src["manu"]) != strtolower($cpu_dest["manu"])) {
            $error[] = $l["err_live_mig_cpu_diff"];
            return false;
        }
        return true;
    }
}

?>