<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
class vzk
{
    public $loaded = 0;
    public $status = [];
    public $status_statewise = [];
    public $type = "vzk";
    public $user = [];
    public $bandwidth_device = "";
    public function __construct()
    {
        if(!empty($GLOBALS["globals"]["interface"])) {
            $this->bandwidth_device = $GLOBALS["globals"]["interface"];
        }
    }
    public function conf($vpsid, $conf_name)
    {
        if(in_array($conf_name, ["io_priority", "iso_support", "sec_iso_support", "win_support", "vnc_support", "vnc_store_pass", "cpu_pinning", "onboot_cp", "vps_ram_info", "hvm_support", "serverload", "perf_ops", "virtio", "nested_virt", "vnc_auto_port", "inc_backup", "enable_guest_agent"])) {
            return true;
        }
        if(in_array($conf_name, ["load_balancer"])) {
            if(check_licensepro()) {
                return true;
            }
            return false;
        }
        if(in_array($conf_name, ["get_vps_DISKS", "disks_support", "vpsdisk_destroy", "multiple_disk_support", "rescue_support", "migrate_pre_create_vps", "getos_pre_createvps", "use_dd_migrate", "vpsdisk_path_build"])) {
            return true;
        }
        if(in_array($conf_name, ["build_dhcp", "mac_support", "change_dns", "ebtables_support", "nw_config"])) {
            return true;
        }
        if($conf_name == "vncpasslen") {
            return 8;
        }
        if($conf_name == "allowed_distros") {
            $allowed_distros["centos"] = 1;
            $allowed_distros["ubuntu"] = 1;
            $allowed_distros["debian"] = 1;
            $allowed_distros["suse"] = 1;
            $allowed_distros["fedora-core"] = 1;
            $allowed_distros["linux"] = 1;
            $allowed_distros["win"] = 1;
            return array_keys($allowed_distros);
        }
        if($conf_name == "nic") {
            $nictypes["virtio"] = 1;
            $nictypes["default"] = 1;
            $nictypes["e1000"] = 1;
            return array_keys($nictypes);
        }
        if($conf_name == "storage_types") {
            return ["file"];
        }
        if($conf_name == "bios") {
            return ["seabios" => "seabios Default", "uefi" => "UEFI"];
        }
        return false;
    }
    public function new_vps_name($suggested_name = "")
    {
        vexec("/usr/bin/prlctl list --all --output name", $output, $return);
        unset($output[0]);
        $ret = empty($suggested_name) ? 1001 : str_replace("v", "", $suggested_name);
        foreach ($output as $k => $v) {
            $v = trim($v);
            if(empty($v)) {
            } else {
                $v = preg_split("/[\\s]+/", $v);
                $v[1] = trim($v[1]);
                $names[$v[1]] = $v[1];
            }
        }
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\tAND virt = 'vzk'\n\t\t\t\t\t\tORDER BY vps_name DESC");
        if(0 < vsql_num_rows($res)) {
            for ($x = 0; $x < vsql_num_rows($res); $x++) {
                $row = vsql_fetch_assoc($res);
                $row["vps_name"] = trim($row["vps_name"]);
                $names[$row["vps_name"]] = $row["vps_name"];
                $tmp_int = (int) $row["vps_name"];
                if($ret < $tmp_int && $tmp_int < 2000) {
                    $ret = $tmp_int + 1;
                }
            }
        }
        $x = 0;
        while ($x < 100000) {
            if(in_array("v" . $ret, $names) || in_array($ret, $names)) {
                $ret = $ret + 1;
                $x++;
                break;
            }
        }
        return "v" . $ret;
    }
    public function getconf($vid)
    {
        $r = [];
        if(0 < substr_count($vid, "/")) {
            $path = $vid;
        } else {
            $vps_uuid = $this->getuuid($vid);
            $path = "/etc/vz/conf/" . $vps_uuid . ".conf";
        }
        $tmp = @file($path);
        foreach ($tmp as $k => $l) {
            $tmp[$k] = trim(preg_replace("/(\\#(.*))/is", "", trim($l)));
            if(empty($tmp[$k])) {
            } elseif(preg_match("/=/is", $tmp[$k])) {
                $t = explode("=", $tmp[$k]);
                $r[$t[0]] = $t[1];
            }
        }
        foreach ($r as $k => $v) {
            $r[$k] = trim($v, "\"");
        }
        if(is_numeric($vid)) {
            $this->conf[$vid] = $r;
        }
        return $r;
    }
    public function getname($vid)
    {
        global $user;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            return $user["vps"]["vps_name"];
        }
        if($vps = getvps($vid)) {
            return $vps["vps_name"];
        }
        return false;
    }
    public function stop($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("stop_vps", "", 0, $vid, $vps["uid"], 0, $l["stop_vps"]);
        task_start($actid);
        task_update($actid, $l["stop_vps"], 57);
        $vps_name = $this->getname($vid);
        oexec("/usr/bin/prlctl stop " . xss($vps_name), $output);
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --autostart off");
        writefile(logdir("stop") . $vid . ".log", $output, 1);
        task_update($actid, $l["stop_vps_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function poweroff($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("poweroff_vps", "", 0, $vid, $vps["uid"], 0, $l["power_off_vps"]);
        task_start($actid);
        task_update($actid, $l["power_off_vps"], 57);
        $status = $this->vps_status_statewise($vid);
        if($status == 2) {
            return false;
        }
        $vps_name = $this->getname($vid);
        oexec("/usr/bin/prlctl stop " . xss($vps_name) . " --fast", $output);
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --autostart off");
        writefile(logdir("poweroff") . $vid . ".log", $output, 1);
        task_update($actid, $l["power_off_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function start($vid)
    {
        global $l;
        global $globals;
        $vps = getvps($vid, 0);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        if($this->status($vid, 1) == 1) {
            return false;
        }
        $actid = vps_task("start_vps", "", 0, $vid, $vps["uid"], 0, $l["attempting_start_vps"]);
        task_start($actid);
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vpsid\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0\n\t\t\t\t\t\tORDER BY actid ASC", [":vpsid" => $vid]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $tasks[$row["actid"]] = $row;
            }
        }
        task_update($actid, $l["beginning_start_vps"], 5);
        if(!empty($tasks)) {
            foreach ($tasks as $k => $v) {
                if($v["action"] == "editvzkvs") {
                    _task_update($actid, $l["edit_vps"], 20, $v["actid"]);
                    $this->editvps($vid, $v["actid"]);
                    logs_vps("editvzkvs", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "changepassword") {
                    _task_update($actid, $l["change_password"], 22, $v["actid"]);
                    $this->changepassword($vid, json_decode(base64_decode($v["data"])), $v["actid"]);
                    logs_vps("changepassword", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "remotedesktop") {
                    _task_update($actid, $l["remotedesktop"], 25, $v["actid"]);
                    $this->remotedesktop($vid, $v["data"], $v["actid"]);
                    logs_vps("remotedesktop", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "hostname") {
                    _task_update($actid, $l["change_hostname"], 27, $v["actid"]);
                    $this->changehostname($vid, $v["data"], $v["actid"]);
                    logs_vps("hostname", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_cp") {
                    _task_update($actid, $l["install_cp"], 30, $v["actid"]);
                    $this->install_cp($vid, $v["data"], $v["actid"]);
                    logs_vps("install_cp", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_ga") {
                    $this->install_ga($vid, [], $v["actid"]);
                    logs_vps("install_ga", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "resizevps") {
                    _task_update($actid, $l["resize_vps"], 35, $v["actid"]);
                    $this->resizevps($vid, $v["actid"]);
                    logs_vps("resizevps", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_recipe") {
                    _task_update($actid, $l["install_recipe"], 37, $v["actid"]);
                    $recipe = _unserialize($v["data"]);
                    $this->install_recipe($vid, $recipe, $v["actid"]);
                    logs_vps("install_recipe", !array_key_exists("rid", $recipe) ? implode(", ", array_keys($recipe)) : $recipe["rid"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "change_vncpass") {
                    _task_update($actid, $l["change_vncpass"], 40, $v["actid"]);
                    $this->changeVncPass($vid, base64_decode($v["data"]), $v["actid"]);
                    logs_vps("change_vncpass", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "installtools") {
                    _task_update($actid, $l["install_tools"], 42, $v["actid"]);
                    $this->installtools($vid, $v["actid"]);
                    logs_vps("installtools", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "delete_vpsdisks") {
                    _task_update($actid, $l["delete_vpsdisks"], 45, $v["actid"]);
                    $del_data = _unserialize($v["data"]);
                    $this->delete_vpsdisks($vid, $del_data, $v["actid"]);
                    logs_vps("delete_vpsdisks", $del_data, 1, $vid, $user["uid"]);
                }
                if($v["action"] == "addsshkeys") {
                    _task_update($actid, $l["add_sshkeys"], 47, $v["actid"]);
                    $ssh_keys = _unserialize($v["data"]);
                    $this->addsshkeys($vid, $ssh_keys, $v["actid"]);
                    logs_vps("addsshkeys", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "removesshkeys") {
                    _task_update($actid, $l["remove_sshkeys"], 48, $v["actid"]);
                    $ssh_keys = _unserialize($v["data"]);
                    $this->removesshkeys($vid, $ssh_keys, $v["actid"]);
                    logs_vps("removesshkeys", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "change_winips") {
                    $this->change_winips($vid, [], $v["actid"]);
                    logs_vps("change_winips", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "apply_lb_rule") {
                    $apply_lb_rule["actid"] = $v["actid"];
                    $apply_lb_rule["data"] = unserialize($v["data"]);
                }
            }
        }
        _task_update($actid, $l["performing_startup_process"], 43, "group");
        $this->onstartup($vid);
        _task_update($actid, "", 45, "group_end");
        sleep(2);
        task_update($actid, $l["call_hook_before_startvps"], 45);
        apply_filters("before_startvps", $vps);
        if(empty($globals["disable_virtsparsify"])) {
            vexec("virt-sparsify -V", $o, $r);
            $o = explode(" ", $o[0]);
            $version = trim(substr(trim($o[1]), 0, 4));
            if(version_compare($version, "1.26", ">=")) {
                foreach ($vps["disks"] as $k => $_disk_) {
                    if(preg_match("/file/is", $_disk_["type"]) && preg_match("/qcow2/is", $_disk_["format"])) {
                        vexec("virt-sparsify --in-place " . $_disk_["path"], $o, $r);
                    }
                }
            }
        }
        oexec("/usr/bin/prlctl start " . xss($vps["vps_name"]), $output);
        writefile(logdir("start") . $vid . ".log", $output, 1);
        if(!empty($vps["nw_suspended"])) {
            $this->suspend_vps_net($vps["vpsid"]);
        }
        _task_update($actid, $l["tc_rule_create"], 55, "group");
        $this->tc_create($vid);
        _task_update($actid, $l["tc_rule_create"], 55, "group_end");
        task_update($actid, $l["set_autostart"], 79);
        vexec("/usr/bin/prlctl set " . xss($vps["vps_name"]) . " --autostart on");
        if(!empty($apply_lb_rule)) {
            $this->lb_default_rule($vid, $apply_lb_rule["data"], $apply_lb_rule["actid"]);
            logs_vps("apply_lb_rule", "", 1, $vid, $user["uid"]);
        }
        task_update($actid, $l["call_hook_after_startvps"], 88);
        apply_filters("after_startvps", $vps);
        task_update($actid, $l["start_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function onstartup($vid)
    {
        global $globals;
        global $user;
        global $ostemplates;
        global $l;
        if($this->status($vid, 1) == 1) {
            return -1;
        }
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $this->ebtables_remove($vid);
        $vm_interface_name = $this->vifname($vid);
        $mac_addr = $this->getmac($vid);
        vs_ebtables_add($vid, $vm_interface_name, $mac_addr);
        $mount = mount($vid, "", 1);
        if(is_array($mount)) {
            vexec("df -P " . xss($mount["mount_point"]) . " 2>/dev/null", $tmp_out, $tmp_ret);
            $elements = preg_split("/\\s+/", $tmp_out[1]);
            $vps_disk_usage = ["Filesystem" => $elements[0], "1K-blocks" => $elements[1], "Used" => $elements[2], "Available" => $elements[3], "Use%" => $elements[4], "mounted_on" => $elements[5]];
            vexec("df -Pi " . xss($mount["mount_point"]) . " 2>/dev/null", $itmp_out, $itmp_ret);
            $elements = preg_split("/\\s+/", $itmp_out[1]);
            $vps_inode_usage = ["Filesystem" => $elements[0], "Inodes" => $elements[1], "IUsed" => $elements[2], "IFree" => $elements[3], "IUse%" => $elements[4], "mounted_on" => $elements[5]];
            if(!empty($vps_disk_usage) || !empty($vps_inode_usage)) {
                $tmp_data = ["disk" => $vps_disk_usage, "inode" => $vps_inode_usage];
                to_master("vps", "cached_disk", $vps["vpsid"], "vpsid", serialize($tmp_data));
            }
            if(file_exists($mount["mount_point"] . "/etc/shadow") && empty($globals["disable_nw_config"]) && empty($vps["disable_nw_config"])) {
                if(empty($ips[0])) {
                    $umount = umount($mount);
                    return false;
                }
                $routing = $ips[0]["routing"];
                $post = [];
                if(!empty($vps["dns_nameserver"])) {
                    $dns = unserialize($vps["dns_nameserver"]);
                    $post["dns"] = $dns;
                }
                network_configure($mount["mount_point"], $ips, $post, $routing);
            }
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["kvm_err_unmount"];
                return false;
            }
        }
        return true;
    }
    public function restart($vid)
    {
        global $l;
        $vps = getvps($vid);
        $data_decode = $vps["data"];
        $actid = vps_task("restart_vps", "", 0, $vid, $vps["uid"], 0, $l["restart_vps"]);
        task_start($actid);
        task_update($actid, $l["restart_vps"], 57);
        $vps = getvps($vid);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        if($this->status($vid) == 0) {
            task_update($actid, $l["restart_vps_done"], 100);
            return $this->start($vid);
        }
        $vps_name = $this->getname($vid);
        $this->stop($vid);
        for ($i = 1; $i <= 60; $i++) {
            $status = no_log_status($vid, 1, $this);
            if($status != 0 && $i != 60) {
                sleep(1);
            } elseif($status == 0) {
            } elseif($i == 60) {
                return false;
            }
        }
        task_update($actid, $l["restart_vps_done"], 100);
        $output = $this->start($vid);
        $out = [];
        $out["output"] = $output["output"];
        $out["taskid"] = $actid;
        return $out;
    }
    public function changehostname($vid, $host)
    {
        global $globals;
        global $user;
        global $l;
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("hostname", $host, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "hostname", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            hostname_configure($mount["mount_point"], $host);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        $vps_name = $this->getname($vid);
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --hostname " . xss($host), $output, $ret);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function tc_create($vid)
    {
        $interface = $this->vifname($vid);
        return vs_tc_create($vid, $interface);
    }
    public function tc_destroy($vid)
    {
        $interface = $this->vifname($vid);
        return vs_tc_destroy($interface);
    }
    public function editvps($vid, $actid = 0)
    {
        global $globals;
        global $l;
        global $user;
        $vps = getvps($vid);
        $this->tc_destroy($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("editvzkvs", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "editvzkvs", "vpsid" => $vid, "actid" => $actid]);
                $vm_interface_name = $this->vifname($vid);
                $mac_addr = $this->getmac($vid);
                vs_ebtables_add($vid, $vm_interface_name, $mac_addr);
                $this->tc_create($vid);
                return -1;
            }
        }
        task_start($actid);
        $ret = $this->createvps($vid, 0);
        task_update($actid, $l["completed"], 100);
        return $ret;
    }
    public function createvps($vid, $create = 1)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        global $error;
        global $l;
        global $storages;
        $vps = getvps($vid);
        $action = "edit_vps";
        if(!empty($create)) {
            $action = "create_vps";
        }
        $data_decode = $vps["data"];
        $actid = vps_task($action, "", 0, $vid, $vps["uid"], 0, $l["beginning_creation"]);
        task_start($actid);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        if(empty($oslist)) {
            oslist();
        }
        task_update($actid, $l["beginning_creation"], 5);
        $isopath = $sec_isopath = $isotype = $sec_isotype = "";
        if(!empty($vps["iso"])) {
            $isopath = iso_path($vps["uid"], $vps["iso"], $isotype);
            task_update($actid, $l["downloading_iso"], 10);
            getos($isopath, $isotype);
        }
        if(!empty($vps["sec_iso"])) {
            $sec_isopath = iso_path($vps["uid"], $vps["sec_iso"], $sec_isotype);
            task_update($actid, $l["downloading_iso2"], 15);
            getos($sec_isopath, $sec_isotype);
        }
        $uefi = 0;
        if(!empty($data_decode["bios"]) && preg_match("/uefi/is", $data_decode["bios"])) {
            $uefi = 1;
        }
        if(!empty($create) && !defined("DONT_DD_OS_TEMPLATE")) {
            if(!empty($vps["osid"])) {
                task_update($actid, $l["downloading_os"], 20);
                getos($ostemplates[$vps["osid"]]["filename"], "vzkos");
            }
            if(empty($ostemplates[$vps["osid"]]) || !file_exists($globals["vzkos"] . "/" . $ostemplates[$vps["osid"]]["filename"])) {
                $noos = true;
            }
            if(empty($vps["iso"]) || !file_exists($globals[$isotype] . "/" . $isopath)) {
                $noiso = true;
            }
            if(isset($noos) && isset($noiso)) {
                $error[] = $l["build_no_os_iso"];
                task_update($actid, $l["build_no_os_iso"], -1);
                return false;
            }
        }
        $all_ipr_ips = [];
        $bridge = [];
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $_ips[$i] = vsql_fetch_assoc($res);
            $ips[$i] = $_ips[$i]["ip"];
            if(!empty($_ips[$i]["ipr_ips"])) {
                $ipr_ips = unserialize($_ips[$i]["ipr_ips"]);
                $all_ipr_ips = array_merge($all_ipr_ips, $ipr_ips);
            }
            if(!empty($_ips[$i]["vlan"])) {
                $bridge[$_ips[$i]["ip"]] = $_ips[$i]["bridge"];
            }
        }
        $all_vps_ips = array_merge($ips, $all_ipr_ips);
        $routing = empty($_ips[0]["routing"]) ? 0 : 1;
        if(!empty($create)) {
            $vps_distro = $ostemplates[$vps["osid"]]["distro"];
            if($vps_distro == "fedora") {
                $vps_distro = "fedora-core";
            }
            $allowed_distros = $this->conf(0, "allowed_distros");
            if(!in_array($vps_distro, $allowed_distros)) {
                if(preg_match("/windows/is", $ostemplates[$vps["osid"]]["filename"])) {
                    $vps_distro = "win";
                } else {
                    $vps_distro = "linux";
                }
            }
            foreach ($storages as $k => $v) {
                if($v["st_uuid"] == $DISK["st_uuid"]) {
                    $vm_storage_path = $v["path"];
                    if(empty($vm_storage_path) || !is_dir($vm_storage_path)) {
                        $vm_storage_path = "/vz/vmprivate";
                    }
                    $ret = vexec("/usr/bin/prlctl create " . xss($vps_name) . " --distribution " . xss($vps_distro) . " --dst " . xss($vm_storage_path));
                    task_update($actid, $l["virtuzo_create"], 24);
                    if($ret != 0) {
                        $error[] = $l["virtuzo_create_error"];
                        $error["derr"] = array_end($GLOBALS["logr"]);
                        task_update($actid, $l["virtuzo_create_error"], -1);
                        return false;
                    }
                }
            }
        }
        $res = makequery("SELECT uid, inhouse_billing FROM users \n\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $vps["uid"]]);
        $_user = vsql_fetch_assoc($res);
        oexec("/usr/bin/uuidgen", $tuuid);
        $uuid = empty($uuid) ? trim($tuuid) : $uuid;
        $min_ram = $vps["ram"];
        $min_vcpu = $vps["cores"];
        $vertical_scailing = 0;
        if(!preg_match("/windows/is", $vps["os_name"]) && !empty($globals["inhouse_billing"]) && !empty($_user["inhouse_billing"])) {
            $vps_data = $vps["data"];
            $max_ram = $min_ram;
            if(!empty($globals["ver_max_ram"])) {
                $max_ram = $globals["ver_max_ram"];
            }
            if(!empty($vps_data["ver_max_ram"])) {
                $max_ram = $vps_data["ver_max_ram"];
            }
            if($max_ram < $min_ram) {
                $max_ram = $min_ram;
            }
            $max_vcpu = $min_vcpu;
            if(!empty($globals["ver_max_cpu"])) {
                $max_vcpu = $globals["ver_max_cpu"];
            }
            if(!empty($vps_data["ver_max_cpu"])) {
                $max_vcpu = $vps_data["ver_max_cpu"];
            }
            if($max_vcpu < $min_vcpu) {
                $max_vcpu = $min_vcpu;
            }
            $vertical_scailing = 1;
        } else {
            $max_ram = $min_ram;
            $max_vcpu = $min_vcpu;
        }
        task_update($actid, $l["set_hostname"], 26);
        $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --hostname " . xss($vps["hostname"]));
        if($ret != 0) {
            $error[] = $l["openvz_err_hostname"];
            $error["derr"] = array_end($GLOBALS["logr"]);
            task_update($actid, $l["openvz_err_hostname"], -1);
            return false;
        }
        task_update($actid, $l["setting_cpu"], 30);
        $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --cpuunits " . xss($vps["cpu"]));
        if($ret != 0) {
            $error[] = $l["openvz_err_cpu"];
            $error["derr"] = array_end($GLOBALS["logr"]);
            task_update($actid, $l["openvz_err_cpu"], -1);
            return false;
        }
        task_update($actid, $l["setting_bios"], 32);
        if(!empty($uefi)) {
            $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . "  --efi-boot on ");
            if($ret != 0) {
                $error[] = $l["openvz_err_uefi"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                task_update($actid, $l["openvz_err_uefi"], -1);
                return false;
            }
        } else {
            $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . "  --efi-boot off ");
            if($ret != 0) {
                $error[] = $l["openvz_err_bios"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                task_update($actid, $l["openvz_err_bios"], -1);
                return false;
            }
        }
        if(!empty($vps["cpu_percent"])) {
            task_update($actid, $l["setting_cpu_perc"], 34);
            $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --cpulimit " . xss(round($vps["cpu_percent"])));
            if($ret != 0) {
                $error[] = $l["openvz_err_cpulim"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                task_update($actid, $l["openvz_err_cpulim"], -1);
                return false;
            }
        }
        if(!empty($vps["cores"])) {
            task_update($actid, $l["setting_cpu_cores"], 38);
            $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --cpus " . xss($min_vcpu));
            if($ret != 0) {
                $error[] = $l["openvz_err_cores"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                task_update($actid, $l["openvz_err_cores"], -1);
                return false;
            }
        }
        if($vps["cpupin"] != -1) {
            task_update($actid, $l["setting_cpu_pin"], 42);
            $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --cpumask " . xss($vps["cpupin"]));
            if($ret != 0) {
                $error[] = $l["err_set_pinning"];
                $error["derr"] = array_end($GLOBALS["logr"]);
                task_update($actid, $l["err_set_pinning"], -1);
                return false;
            }
        }
        task_update($actid, $l["set_io_prio"], 46);
        $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --ioprio " . xss($vps["io"]));
        if($ret != 0) {
            $error[] = $l["openvz_err_ioprio"];
            $error["derr"] = array_end($GLOBALS["logr"]);
            task_update($actid, $l["openvz_err_ioprio"], -1);
            return false;
        }
        task_update($actid, $l["set_ram"], 50);
        $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --memsize  " . xss($min_ram) . "M" . (!empty($vps["swapram"]) ? " --swap " . xss($vps["swapram"]) . "M" : ""));
        if($ret != 0) {
            $error[] = $l["err_set_ram"];
            $error["derr"] = array_end($GLOBALS["logr"]);
            task_update($actid, $l["err_set_ram"], -1);
            return false;
        }
        $t_vpsmac = $this->getmac($vid);
        $t_strmaccmd = !empty($t_vpsmac) && valid_mac($t_vpsmac) ? " --mac " . $t_vpsmac : "";
        if(!empty($routing)) {
            $ret = vexec("prlctl set " . xss($vps_name) . " --device-set net0 --type routed" . $t_strmaccmd, $out);
        } else {
            $ret = vexec("prlctl set " . xss($vps_name) . " --device-del net0", $out);
            $ret = vexec("prlctl set " . xss($vps_name) . " --device-add net" . $t_strmaccmd, $out);
        }
        $vpsisos = [$globals[$isotype] . "/" . $isopath, $globals[$sec_isotype] . "/" . $sec_isopath];
        $vps_info = $this->vps_info($vid);
        foreach ($vpsisos as $k => $v) {
            if(!isset($vps_info["Hardware"]["cdrom" . $k])) {
                $ret = vexec("prlctl set " . xss($vps_name) . " --device-add cdrom --image=\"\" --iface ide");
            }
            if(!empty($vps[($k ? "sec_" : "") . "iso"]) && file_exists($v)) {
                $ret = vexec("prlctl set " . xss($vps_name) . " --device-set cdrom" . $k . " --image " . xss($v) . " --connect");
                task_update($actid, $l["set_iso"], 55);
                if($ret != 0) {
                    $error[] = $l["err_set_iso"];
                    $error["derr"] = array_end($GLOBALS["logr"]);
                    task_update($actid, $l["err_set_iso"], -1);
                    return false;
                }
            } else {
                $ret = vexec("prlctl set " . xss($vps_name) . " --device-set cdrom" . $k . " --image=\"\" --disconnect");
            }
        }
        task_update($actid, $l["set_boot_order"], 58);
        $ret = vexec("prlctl set " . xss($vps_name) . " --device-bootorder \"" . ($vps["boot"] == "dca" ? "cdrom0 hdd0 net0" : "hdd0 cdrom0 net0") . "\"", $out);
        if($ret != 0) {
            $error[] = $l["err_set_boot_order"];
            $error["derr"] = array_end($GLOBALS["logr"]);
            task_update($actid, $l["err_set_boot_order"], -1);
            return false;
        }
        vexec("/usr/bin/prlctl list -n " . xss($vps_name) . " -o ip", $ipout, $ipret);
        $ipout = explode(" ", $ipout[1]);
        $tmp_ip6s_del = [];
        foreach ($ipout as $k => $ip) {
            if(valid_ipv6($ip)) {
                $ipout[$k] = ipv6_expand($ip);
                $tmp_ip6s_del[$ipout[$k]] = $ip;
            }
        }
        $ips_to_del = $ips_to_add = [];
        $ips_to_del = array_diff($ipout, $all_vps_ips);
        $ips_to_add = array_diff($all_vps_ips, $ipout);
        $ipr_ips_to_add = array_diff($all_ipr_ips, $ipout);
        if(!empty($ips_to_del)) {
            foreach ($ips_to_del as $ip) {
                $ip = !empty($tmp_ip6s_del[$ip]) ? $tmp_ip6s_del[$ip] : $ip;
                vexec("/usr/bin/prlctl set " . xss($vps_name) . " --ipdel " . xss($ip));
            }
        }
        if(!empty($ips_to_add) || !empty($ipr_ips_to_add)) {
            foreach ($_ips as $k => $v) {
                if(!empty($_ips[$k]["ipr_ips"]) && !empty($ipr_ips_to_add)) {
                    $ipr_ips = unserialize($_ips[$k]["ipr_ips"]);
                    foreach ($ipr_ips as $ipr_ip) {
                        if(in_array($ipr_ip, $ipr_ips_to_add)) {
                            $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --ipadd " . xss($ipr_ip) . (!empty($_ips[$k]["gateway"]) && empty($_ips[$k]["routing"]) ? " --gw" . (valid_ipv6($_ips[$k]["ip"]) ? "6" : "") . " " . xss($_ips[$k]["gateway"]) : "") . (!empty($bridge[$ipr_ip]) ? " --network " . xss($bridge[$ipr_ip]) : ""));
                            if($ret != 0) {
                                $error[] = $l["openvz_err_ip"];
                                $error["derr"] = array_end($GLOBALS["logr"]);
                                return false;
                            }
                            if(valid_ipv6($_ips[$k]["ip"]) && !empty($_ips[$k]["routing"])) {
                                task_update($actid, $l["set_ips6"], 65);
                                $ret6 = vexec("ip -6 neigh add proxy " . xss($_ips[$k]["ip"]) . " dev " . xss(empty($globals["interface"]) ? "eth0" : $globals["interface"]) . "");
                                if($ret6 != 0) {
                                    $error[] = $l["openvz_err_ip"];
                                    $error["derr"] = array_end($GLOBALS["logr"]);
                                    task_update($actid, $l["openvz_err_ip"], -1);
                                    return false;
                                }
                            }
                        }
                    }
                }
                if(in_array($_ips[$k]["ip"], $ips_to_add) && !empty($ips_to_add)) {
                    task_update($actid, $l["set_ips"], 62);
                    $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --ipadd " . xss($_ips[$k]["ip"] . (!empty($_ips[$k]["netmask"]) ? "/" . $_ips[$k]["netmask"] : "")) . ($k == 0 && !empty($_ips[$k]["mac_addr"]) ? " --mac " . xss($_ips[$k]["mac_addr"]) : "") . (!empty($_ips[$k]["gateway"]) && empty($_ips[$k]["routing"]) ? " --gw" . (valid_ipv6($_ips[$k]["ip"]) ? "6" : "") . " " . xss($_ips[$k]["gateway"]) : "") . (!empty($bridge[$_ips[$k]["ip"]]) ? " --network " . xss($bridge[$_ips[$k]["ip"]]) : ""));
                    if($ret != 0) {
                        $error[] = $l["openvz_err_ip"];
                        $error["derr"] = array_end($GLOBALS["logr"]);
                        task_update($actid, $l["openvz_err_ip"], -1);
                        return false;
                    }
                }
            }
        }
        if(empty($vps["suspended"])) {
            $ret = vexec("/usr/bin/prlctl set " . xss($vps_name) . " --autostart on");
        }
        if(!empty($vps["vnc"])) {
            $vncpass = $vps["vnc_passwd"];
            task_update($actid, $l["enable_vnc"], 68);
            if(!empty($create)) {
                $vncport = 0;
                if(!empty($vps["vnc"])) {
                    $vncport = !empty($GLOBALS["use_vnc_port"]) ? $GLOBALS["use_vnc_port"] : $this->_newVncPort();
                }
            } else {
                $vncdetails = $this->vncDetails($vid);
                $vncpass = $vncdetails["password"];
                $vncport = 0;
                if(!empty($vps["vnc"])) {
                    $vncport = $vncdetails["port"];
                    $vncport = empty($vncport) ? $this->_newVncPort() : $vncport;
                }
            }
            if(!empty($data_decode["vnc_auto_port"])) {
                vexec("/usr/bin/prlctl set " . xss($vps_name) . " --vnc-mode auto --vnc-passwd " . xss($vncpass) . " --vnc-address " . xss(server_vncip($vps["serid"])), $out, $ret);
            } else {
                vexec("/usr/bin/prlctl set " . xss($vps_name) . " --vnc-mode manual --vnc-port " . xss($vncport) . " --vnc-passwd " . xss($vncpass) . " --vnc-address " . xss(server_vncip($vps["serid"])), $out, $ret);
            }
        } else {
            task_update($actid, $l["disable_vnc"], 68);
            vexec("/usr/bin/prlctl set " . xss($vps_name) . " --vnc-mode off", $out, $ret);
        }
        $vncDetails = $this->vncDetails($vps["vpsid"]);
        to_master("vps", "vncport", $vps["vpsid"], "vpsid", $vncDetails["port"]);
        $nic_type = empty($vps["nic_type"]) || $vps["nic_type"] == "default" ? "rtl" : $vps["nic_type"];
        task_update($actid, $l["set_nic"], 70);
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --device-set net0 --adapter-type " . xss($nic_type), $out, $ret);
        $mac = $this->getmac($vps["vpsid"]);
        if(!empty($mac)) {
            to_master("vps", "mac", $vps["vpsid"], "vpsid", $mac);
        }
        if(!empty($data_decode["nested_virt"])) {
            vexec("prlctl set " . xss($vps_name) . " --nested-virt on", $out, $ret);
        } else {
            vexec("prlctl set " . xss($vps_name) . " --nested-virt off", $out, $ret);
        }
        apply_filters("after_config_write", $vps);
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        $task_disk_num = 1;
        $task_disk_progress = 70;
        $device_bus = empty($vps["virtio"]) ? "ide" : ($vps["virtio"] == 1 ? "virtio" : ($vps["virtio"] == 2 ? "scsi" : "ide"));
        if(empty($create)) {
            if(preg_match("/windows/is", $vps["os_name"]) && ($ostemplates[$vps["osid"]]["perf_ops"] && $globals["use_win_script"])) {
                $this->change_winips($vid);
            }
            if(!preg_match("/windows/is", $vps["os_name"]) && !empty($vps["data"]["enable_guest_agent"])) {
                $this->install_ga($vid);
            }
            $resize_break = 0;
            $sync_disks = 0;
            foreach ($disks as $dk => $DISK) {
                $disk_size = vpsdisk_size($DISK);
                if(empty($disk_size) && 0 < $DISK["size"] && empty($DISK["primary"])) {
                    task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                    vexec("/usr/bin/prlctl set " . xss($vps_name) . " --device-add hdd --iface " . $device_bus . " --size " . xss($DISK["size"] * 1024), $out, $ret);
                    if($ret != 0) {
                        $error[] = $l["err_disk_create"];
                        task_update($actid, implode("<br>", $error), -1);
                        return false;
                    }
                    $tmp_disk = preg_split("/[\\s]+/", $out[0]);
                    $vps["disks"][$dk]["hdd_name"] = trim($tmp_disk[1]);
                    $vps["disks"][$dk]["extra"] = [];
                    $vps["disks"][$dk]["extra"]["hdd_name"] = trim($tmp_disk[1]);
                    $tmp_path = explode("=", $tmp_disk[4]);
                    $vps["disks"][$dk]["path"] = trim($tmp_path[1], "'");
                    to_master("disks", "path", $vps["disks"][$dk]["did"], "did", $vps["disks"][$dk]["path"]);
                    to_master("disks", "extra", $vps["disks"][$dk]["did"], "did", serialize($vps["disks"][$dk]["extra"]));
                }
                if(!empty($disk_size) && $disk_size < $DISK["size"] && empty($resize_break)) {
                    $this->resizevps($vid);
                    $resize_break = 1;
                }
                vexec("/usr/bin/prlctl set " . xss($vps_name) . " --device-set hdd" . $DISK["num"] . " --iface " . $device_bus . " --size " . xss($DISK["size"] * 1024), $out, $ret);
                $task_disk_num++;
                $task_disk_progress = $task_disk_progress + ceil(20 / count($disks));
            }
            task_update($actid, $l["edit_done"], 100);
            return true;
        } else {
            foreach ($disks as $dk => $DISK) {
                if(empty($DISK["primary"])) {
                    vexec("/usr/bin/prlctl set " . xss($vps_name) . " --device-add hdd --iface " . $device_bus . " --size " . xss($DISK["size"] * 1024), $out, $ret);
                    if($ret != 0) {
                        $error[] = $l["err_disk_create"];
                        return false;
                    }
                    $tmp_disk = preg_split("/[\\s]+/", $out[0]);
                    $vps["disks"][$dk]["extra"] = [];
                    $vps["disks"][$dk]["extra"]["hdd_name"] = trim($tmp_disk[1]);
                    $tmp_path = explode("=", $tmp_disk[4]);
                    $vps["disks"][$dk]["path"] = trim($tmp_path[1], "'");
                    to_master("disks", "path", $vps["disks"][$dk]["did"], "did", $vps["disks"][$dk]["path"]);
                    to_master("disks", "extra", $vps["disks"][$dk]["did"], "did", serialize($vps["disks"][$dk]["extra"]));
                } else {
                    $vps["disks"][$dk]["path"] = $DISK["path"];
                    $vps["disks"][$dk]["extra"] = [];
                    $vps["disks"][$dk]["extra"]["hdd_name"] = "hdd0";
                    $vps["disks"][$dk]["hdd_name"] = "hdd0";
                    to_master("disks", "path", $vps["disks"][$dk]["did"], "did", $vps["disks"][$dk]["path"]);
                    to_master("disks", "extra", $vps["disks"][$dk]["did"], "did", serialize($vps["disks"][$dk]["extra"]));
                    $os_template = "";
                    vexec("/usr/bin/prlctl set " . xss($vps_name) . " --device-set hdd0 --iface " . $device_bus . " --size " . xss($DISK["size"] * 1024), $out, $ret);
                    if(!empty($vps["osid"])) {
                        $os_template = $globals["vzkos"] . "/" . $ostemplates[$vps["osid"]]["filename"];
                        task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                        $dd_template = vpsdisk_create($DISK, $os_template);
                        if(!empty($dd_template)) {
                            $error = merge_error($error, $dd_template);
                            task_update($actid, print_r($error, 1), -1);
                            return false;
                        }
                        $task_disk_num++;
                        $task_disk_progress = $task_disk_progress + ceil(20 / count($disks));
                    }
                }
            }
            if(!empty($vps["osid"])) {
                task_update($actid, $l["resizing_disk"], 92);
                $resize = vpsdisk_resize($vid);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($actid, print_r($error, 1), -1);
                    return false;
                }
                task_update($actid, $l["resizing_disk_done"], 93);
                $disk = $resize["diskinfo"];
                $DISK = get_vps_disk($vid);
                $DISK["diskinfo"] = $resize["diskinfo"];
                if(empty($disk["parttype"])) {
                    $DISK["diskinfo"] = get_ostype_from_disk($DISK, $disk);
                    $disk = $DISK["diskinfo"];
                }
                if(empty($ostemplates[$vps["osid"]]["noresizefs"])) {
                    task_update($actid, $l["resizing_fs"], 94);
                    $fs_resize = vpsdisk_resize_filesystem($DISK);
                    if(!empty($fs_resize["error"])) {
                        $error = merge_error($error, $fs_resize["error"]);
                        task_update($actid, print_r($error, 1), -1);
                        return false;
                    }
                    task_update($actid, $l["resizing_fs_done"], 95);
                }
                if(!empty($disk["parttype"][0]["type"]) && preg_match("/" . $disk["parttype"][0]["type"] . "/is", "islinux")) {
                    if(!empty($ostemplates[$vps["osid"]]["perf_ops"])) {
                        task_update($actid, $l["mount"], 96);
                        $mount = mount($vid);
                        if(!is_array($mount)) {
                            $error[] = $l["kvm_err_mount"];
                            task_update($actid, $l["kvm_err_mount"], -1);
                            return false;
                        }
                        apply_filters("perform_operations", $mount);
                        $post = [];
                        if(!empty($vps["dns_nameserver"])) {
                            $dns = unserialize($vps["dns_nameserver"]);
                            $post["dns"] = $dns;
                        }
                        task_update($actid, $l["net_config"], 97);
                        network_configure($mount["mount_point"], $ips, $post, $routing);
                        task_update($actid, $l["hostname_config"], 98);
                        hostname_configure($mount["mount_point"], $vps["hostname"]);
                        task_update($actid, $l["sshkey_clean"], 99);
                        sshkey_clean($mount["mount_point"]);
                        if($vps["boot"] != "dca" || empty($vps["iso"])) {
                            $this->installtools($vid, $actid, $mount["mount_point"]);
                        }
                        task_update($actid, $l["umount"], 99);
                        $umount = umount($mount);
                        if(!empty($umount)) {
                            $error[] = $l["kvm_err_unmount"];
                            task_update($actid, $l["kvm_err_umount"], -1);
                            return false;
                        }
                    }
                } elseif(!empty($disk["parttype"][0]["type"]) && preg_match("/" . $disk["parttype"][0]["type"] . "/is", "iswindows")) {
                }
            }
            if(preg_match("/windows/is", $vps["os_name"]) && !empty($ostemplates[$vps["osid"]]["perf_ops"]) && $globals["use_win_script"]) {
                $this->change_winips($vid);
            }
            if(!preg_match("/windows/is", $vps["os_name"]) && !empty($vps["data"]["enable_guest_agent"])) {
                $this->install_ga($vid);
            }
            apply_filters("after_createvps", $vps);
            task_update($actid, $l["create_done"], 100);
            return true;
        }
    }
    public function destroyvps($vid)
    {
        global $l;
        $vps = getvps($vid);
        $actid = vps_task("deletevs", "", 0, $vid, $vps["uid"], 0, $l["del_vps"]);
        task_start($actid);
        $data = ["serid" => $vps["serid"]];
        task_update($actid, $l["start_del_vps"], 5, serialize($data));
        _task_update($actid, $l["tc_rule_delete"], 20, "group");
        $this->tc_destroy($vid);
        _task_update($actid, "", 20, "group_end");
        task_update($actid, $l["stop_vps"], 30);
        $this->stop($vid);
        $vps_name = $this->getname($vid);
        task_update($actid, $l["call_hook_before_delvps"], 35);
        apply_filters("before_deletevps", $vps);
        vexec("/usr/bin/prlctl umount " . xss($vps_name), $output, $ret);
        _task_update($actid, $l["del_ebtables"], 55, "group");
        $this->ebtables_remove($vid);
        ebtables_save();
        _task_update($actid, "", 55, "group_end");
        task_update($actid, $l["del_vps"], 75);
        vexec("/usr/bin/prlctl destroy " . xss($vps_name), $output, $ret);
        if(is_file("/vz/backup/" . $vps_name . "tar.gz")) {
            @unlink("/vz/backup/" . $vps_name . "tar.gz");
        }
        if(is_dir("/home/" . $vps["vps_name"])) {
            vexec("rm -rf /home/" . $vps["vps_name"]);
        }
        task_update($actid, $l["call_hook_after_delvps"], 88);
        apply_filters("after_deletevps", $vps);
        task_update($actid, $l["del_vps_done"], 100);
        return true;
    }
    public function osreinstall($vid, $format_primary = 0)
    {
        $vps_name = $this->getname($vid);
        $vnc = $this->vncDetails($vid);
        if(!empty($vnc["port"])) {
            $GLOBALS["use_vnc_port"] = $vnc["port"];
        }
        $this->destroyvps($vid);
        if(!$this->createvps($vid)) {
            return false;
        }
        return true;
    }
    public function changepassword($vid, $newpassword, $actid = 0, $vm_username = "")
    {
        global $globals;
        global $user;
        global $ostemplates;
        global $l;
        global $oslist;
        global $error;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("changepassword", base64_encode(json_encode([$newpassword, $vm_username])), 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1 && !empty($vps["data"]["enable_guest_agent"])) {
                $abort_task = function ($actid, $msg) {
                    task_update($actid, $msg, 0);
                    makequery("UPDATE tasks SET \n\t\t\t\t\t\t\t\tstarted = 0, \n\t\t\t\t\t\t\t\tupdated = 0,\n\t\t\t\t\t\t\t\tstatus = 0,\n\t\t\t\t\t\t\t\tprogress = 0\n\t\t\t\t\t\t\t\tWHERE actid = :actid", [":actid" => $actid]);
                };
                task_start($actid);
                $ga_pass_support = $this->guest_agent_support($vid, "guest-set-user-password", $not_installed);
                if(!empty($not_installed) || empty($ga_pass_support["done"])) {
                    $abort_task($actid, $ga_pass_support["error"] . " " . $l["kvm_pass_poweroff"]);
                    return -1;
                }
                task_update($actid, $l["kvm_live_pass_update"], 20);
                $encoded_password = base64_encode($newpassword);
                $params = ["password" => $encoded_password];
                $username = username_vps($vps["osid"], $vps["data"], $vm_username);
                vexec("virsh qemu-agent-command " . $vps["vps_name"] . " " . xss("{\"execute\":\"guest-set-user-password\", \"arguments\":{\"username\":\"" . $username . "\", \"password\":\"" . $encoded_password . "\", \"crypted\" : false }}") . " --pretty", $o, $ret, $params);
                unset($encoded_password);
                unset($username);
                unset($paramse);
                if(!empty($ret)) {
                    $abort_task($actid, $l["kvm_live_pass_err"]);
                    return -1;
                }
                task_update($actid, $l["kvm_live_pass"], 90);
                task_update($actid, $l["completed"], 100);
                return true;
            }
            save_notification("pending_task", ["action" => "changepassword", "vpsid" => $vid, "actid" => $actid]);
            return -1;
        }
        if(!empty($actid)) {
            return perform_vps_operation($vid, $actid, "change_password", $newpassword);
        }
    }
    public function filelist($vid, $dir = "", $searchSubdirs = 1, $directoriesonly = 0, $maxlevel = "all", $level = 1)
    {
        $vps_name = $this->getname($vid);
        $path = rtrim("/vz/root/" . $vps_name, "/");
        $dir = $dir[0] == "/" ? $dir : "/" . $dir;
        $r = filelist($path . $dir, $searchSubdirs, $directoriesonly, $maxlevel, $level);
        if(empty($r)) {
            $r = [];
        }
        $listd = $listf = [];
        foreach ($r as $k => $v) {
            $k = substr($k, strlen($path));
            $v["fullpath"] = rtrim($v["path"], "/");
            $v["path"] = substr($v["path"], strlen($path));
            if(empty($v["dir"])) {
                $listf[$k] = $v;
            } else {
                $listd[$k] = $v;
            }
        }
        $list = array_merge($listd, $listf);
        return $list;
    }
    public function processes($vid)
    {
        $processes = [];
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] != "installed" || $this->status($vid, 1) != 1) {
            return $processes;
        }
        $vps_name = $this->getname($vid);
        vexec("/usr/bin/prlctl exec " . xss($vps_name) . " ps ax -eo pid,user,pcpu,pmem,rss,tty,stat,time,command &", $r, $ret);
        foreach ($r as $k => $v) {
            $v = trim($v);
            if(strtolower(substr($v, 0, 3)) == "pid") {
                $keys = preg_split("/\\s+/", trim($v));
                unset($r[$k]);
                $i = 0;
                $processes = [];
                foreach ($r as $k => $v) {
                    $v = preg_split("/\\s+/", trim($v));
                    $_v = $v;
                    reset($keys);
                    foreach ($_v as $kk => $vv) {
                        $tmp = each($keys);
                        if(empty($tmp)) {
                            end($keys);
                            $processes[$i][current($keys)] .= " " . implode(" ", $v);
                            $i++;
                        } else {
                            $processes[$i][$tmp[1]] = $vv;
                            unset($v[$kk]);
                        }
                    }
                }
                foreach ($processes as $i => $v) {
                    foreach ($processes[$i] as $kk => $vv) {
                        $processes[$i][$kk] = htmlizer($vv);
                    }
                }
                return $processes;
            } else {
                unset($r[$k]);
            }
        }
    }
    public function os($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $vps = getvps($vid);
        $osid = $vps["osid"];
        if(empty($ostemplates)) {
            oslist();
        }
        $osinfo = $ostemplates[$vps["osid"]];
        if(empty($osinfo)) {
            $osinfo["name"] = $vps["os_name"];
            $osinfo["distro"] = distro_find($vps["os_name"]);
        }
        return $osinfo;
    }
    public function hostname($vid)
    {
        $vps = getvps($vid);
        return $vps["hostname"];
    }
    public function listips($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $ips = [];
        $res = makequery("SELECT * FROM `ips`\n\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(in_array($row["ip"], $ips)) {
            } else {
                $ips[] = $row["ip"];
            }
        }
        return $ips;
    }
    public function cpu($vid)
    {
        global $user;
        $ret = [];
        $ret["manu"] = "unknown";
        $ret["limit"] = 0;
        $ret["used"] = 0;
        oexec("cat /proc/cpuinfo", $tmp);
        if(preg_match("/intel/is", $tmp)) {
            $ret["manu"] = "intel";
        } elseif(preg_match("/amd/is", $tmp)) {
            $ret["manu"] = "amd";
        }
        virt_preg_replace("/cpu(\\s*?)MHz(\\s*?)\\:(\\s*?)(.*?)(\\s*?)\\n/is", $tmp, $mhz, 4);
        $vps = getvps($vid);
        if($this->status($vid) !== 0) {
            $ret["used"] = $this->_cpu_stats($vid);
        }
        $ret["percent"] = $ret["used"];
        $ret["percent_free"] = 100 - $ret["percent"];
        if(!empty($mhz)) {
            $ret["limit"] = $mhz;
            $ret["used"] = $ret["percent"] * $mhz / 100;
            $ret["free"] = $ret["limit"] - $ret["used"];
        } else {
            $ret["limit"] = 100;
            $ret["used"] = $ret["percent"];
            $ret["free"] = $ret["limit"] - $ret["used"];
        }
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function ram($vid)
    {
        global $user;
        $ret = [];
        $ret["used"] = 0;
        $ret["cached"] = 0;
        $ret["limit"] = 0;
        $ret["guaranteed"] = 0;
        $ret["swap"] = 0;
        $free = 0;
        if($this->status($vid) !== 0) {
            $vps_name = $this->getname($vid);
            vexec("prlctl statistics " . xss($vps_name) . " | grep ram", $output, $return);
            foreach ($output as $k => $v) {
                $tmp = explode(":", trim($v));
                if(trim($tmp[0]) == "guest.ram.cached") {
                    $ret["cached"] = (int) $tmp[1];
                }
                if(empty($ret["cached"]) && trim($tmp[0]) == "guest.ram.available") {
                    $ret["cached"] = (int) $tmp[1];
                }
                if(trim($tmp[0]) == "guest.ram.total") {
                    $ret["limit"] = (int) $tmp[1];
                }
            }
        }
        if(!empty($user["vps"])) {
            $vps = $user["vps"];
        } else {
            $vps = getvps($vid);
        }
        if(!empty($vps)) {
            $ret["guaranteed"] = $vps["ram"];
            $ret["swap"] = $vps["swap"];
        }
        $ret["used"] = $ret["limit"] - $ret["cached"];
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function disk($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            $vps = $user["vps"];
            $ret["limit"] = $user["vps"]["space"] * 1024;
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["space"] * 1024;
        }
        if(!empty($vps["cached_disk"]["disk"]["Used"])) {
            $ret["used"] = $vps["cached_disk"]["disk"]["Used"] / 1024;
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        if($this->status($vid) !== 0 && !empty($vps["data"]["enable_guest_agent"])) {
            $has_support = $this->guest_agent_support($vid);
            if(!empty($has_support["done"])) {
                $os_name = $vps["os_name"];
                $os_info = $this->ga_os_info($vid);
                if(!empty($os_info)) {
                    $os_name = strtolower($os_info["name"]);
                }
                if(preg_match("/windows/is", $os_name)) {
                    $out = $this->ga_exec($vid, "fsutil", ["volume", "diskfree", "c:"]);
                    $tmp = explode(":", $out[0]);
                    $tmp_free_disk = (int) preg_replace("/[,]/", "", $tmp[1]);
                    $ret["free"] = $tmp_free_disk / 1024 / 1024;
                    $ret["used"] = $ret["limit"] - $ret["free"];
                } else {
                    $out = $this->ga_exec($vid, "df", ["-m", "/"]);
                    unset($out[0]);
                    $tmp = cexplode(" ", $out[1], 0, 1);
                    $tmp = array_values($tmp);
                    list($ret["used"], $ret["free"]) = $tmp;
                }
            }
        }
        $ret["limit_gb"] = $ret["limit"] / 1024;
        $ret["used_gb"] = $ret["used"] / 1024;
        $ret["free_gb"] = $ret["limit_gb"] - $ret["used_gb"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function inodes($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            $vps = $user["vps"];
            $ret["limit"] = $user["vps"]["inodes"];
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["inodes"];
        }
        if(empty($ret["limit"])) {
            $ret["limit"] = $vps["cached_disk"]["inode"]["Inodes"];
        }
        if(!empty($vps["cached_disk"]["inode"]["IUsed"])) {
            $ret["used"] = $vps["cached_disk"]["inode"]["IUsed"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function network_speed($vid)
    {
        $vps = getvps($vid);
        $ret["speed"] = 0;
        $ret["upload"] = 0;
        $ret["download"] = 0;
        $value = $this->_network_usage($vid);
        if(empty($value["in"]) && empty($value["out"])) {
        } else {
            usleep(1000000);
            $value2 = $this->_network_usage($vid);
        }
        if($value2["in"] < $value["in"]) {
            $value2["in"] = $value["in"];
            $value2["out"] = $value["out"];
        }
        $ret["download"] = $value2["in"] - $value["in"];
        $ret["upload"] = $value2["out"] - $value["out"];
        $ret["speed"] = $ret["upload"] + $ret["download"];
        return $ret;
    }
    public function status($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            vexec("/usr/bin/prlctl list --all", $output);
            unset($output[0]);
            foreach ($output as $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                $vid = @array_search($v[4], $vs);
                if(!empty($vid) && preg_match("/running/is", $v[1])) {
                    $this->status[$vid] = 1;
                    $on[$vid] = 1;
                }
            }
        }
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = !empty($on[$k]) ? 1 : 0;
            } else {
                $ret[$k] = !empty($this->status[$k]) ? 1 : 0;
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function vps_status_statewise($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status_statewise[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            vexec("/usr/bin/prlctl list --all", $output);
            unset($output[0]);
            foreach ($output as $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                $vid = @array_search($v[4], $vs);
                if(!empty($vid)) {
                    if(preg_match("/(running)/is", $v[1])) {
                        $this->status_statewise[$vid] = 1;
                        $on[$vid] = 1;
                    }
                    if(preg_match("/(suspended)/is", $v[1])) {
                        $this->status_statewise[$vid] = 2;
                        $on[$vid] = 2;
                    }
                    if(!preg_match("/(running|suspended)/is", $v[1])) {
                        $this->status_statewise[$vid] = 0;
                        $on[$vid] = 0;
                    }
                }
            }
        }
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = $on[$k] == 1 ? 1 : ($on[$k] == 2 ? 2 : 0);
            } else {
                $ret[$k] = $this->status_statewise[$k] == 1 ? 1 : ($this->status_statewise[$k] == 2 ? 2 : 0);
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function uptime($vid)
    {
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] != "installed" || $this->status($vid, 1) != 1) {
            return true;
        }
        $vps_name = $this->getname($vid);
        vexec("/usr/bin/prlctl exec " . xss($vps_name) . " uptime &", $output, $ret);
        if(!empty($output[0])) {
            return htmlizer($output[0]);
        }
        return false;
    }
    public function services($vid)
    {
        $services = [];
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] != "installed" || $this->status($vid, 1) != 1) {
            return $services;
        }
        $vps_name = $this->getname($vid);
        vexec("/usr/bin/prlctl exec " . xss($vps_name) . " which systemctl", $o, $r);
        if(empty($r)) {
            vexec("/usr/bin/prlctl exec " . xss($vps_name) . " systemctl list-units --type=service --state=running | awk '{\$1=\$1};1'", $tmp);
            foreach ($tmp as $serv) {
                $parts = preg_split("/\\s+/is", $serv);
                preg_match("/^(.+[^@])\\.service\$/is", $parts[0], $matches);
                if(empty($matches[1]) || in_array($matches[1], ["virtualizor", "virtnetwork"])) {
                } else {
                    $services[] = $matches[1];
                }
            }
            $services = array_unique($services);
        } else {
            vexec("/usr/bin/prlctl exec " . xss($vps_name) . " ps -Aeo comm &", $list, $ret);
            unset($list[0]);
            foreach ($list as $k => $v) {
                $v = explode("-", trim($v));
                if($v[0] == "ps") {
                    unset($list[$k]);
                } else {
                    $list[$k] = htmlizer($v[0]);
                }
            }
            $services = array_unique($list);
        }
        return $services;
    }
    public function startservice($vid, $ser)
    {
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] != "installed" || $this->status($vid, 1) != 1) {
            return true;
        }
        $vps_name = $this->getname($vid);
        if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $ser)) {
            return false;
        }
        vexec("/usr/bin/prlctl exec " . xss($vps_name) . " " . xss("/etc/init.d/" . $ser) . " start &", $output, $ret);
        return true;
    }
    public function restartservice($vid, $ser)
    {
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] != "installed" || $this->status($vid, 1) != 1) {
            return true;
        }
        $vps_name = $this->getname($vid);
        if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $ser)) {
            return false;
        }
        vexec("/usr/bin/prlctl exec " . xss($vps_name) . " " . xss("/etc/init.d/" . $ser) . " restart &", $output, $ret);
        return true;
    }
    public function stopservice($vid, $ser)
    {
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] != "installed" || $this->status($vid, 1) != 1) {
            return true;
        }
        $vps_name = $this->getname($vid);
        if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $ser)) {
            return false;
        }
        vexec("/usr/bin/prlctl exec " . xss($vps_name) . " " . xss("/etc/init.d/" . $ser) . " stop &", $output, $ret);
        return true;
    }
    public function listautoservices($vid)
    {
        $services = [];
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] != "installed" || $this->status($vid, 1) != 1) {
            return $services;
        }
        $vps_name = $this->getname($vid);
        vexec("/usr/bin/prlctl exec " . xss($vps_name) . " which systemctl", $o, $r);
        if(empty($r)) {
            vexec("/usr/bin/prlctl exec " . xss($vps_name) . " systemctl list-unit-files --type=service --state=enabled", $tmp);
            foreach ($tmp as $serv) {
                $parts = preg_split("/\\s+/is", $serv);
                preg_match("/^(.+[^@])\\.service\$/is", $parts[0], $matches);
                if(empty($matches[1])) {
                } else {
                    $services[] = $matches[1];
                }
            }
        } else {
            oexec("/usr/bin/prlctl exec " . xss($vps_name) . " runlevel &", $tmp);
            $tmp = preg_replace("/(N|\\s)/", "", $tmp);
            vexec("/usr/bin/prlctl exec " . xss($vps_name) . " chkconfig --list &", $chk);
            if(is_array($chk)) {
                foreach ($chk as $v) {
                    if(!preg_match("/" . $tmp . "\\:on/is", $v)) {
                    } else {
                        $ser = preg_split("/\\s/is", $v);
                        $services[] = htmlizer($ser[0]);
                    }
                }
            }
        }
        return $services;
    }
    public function killprocess($vid, $pids)
    {
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] != "installed" || $this->status($vid, 1) != 1) {
            return true;
        }
        $vps_name = $this->getname($vid);
        if(!is_array($pids)) {
            $pids = [$pids];
        }
        foreach ($pids as $pid) {
            if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $pid)) {
                return false;
            }
            $pid = (int) $pid;
            vexec("/usr/bin/prlctl exec " . xss($vps_name) . " kill -9 &" . $pid, $output, $ret);
        }
        return true;
    }
    public function lb_save_config($lb_uuid, $config)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $conf = file_get_contents("/usr/local/virtualizor/conf/load_balancer.conf");
        $confs = lb_get_raw_config($lb_uuid, $config);
        $final_config = $conf . "\n" . implode("\n", $confs) . "\n\n";
        $this->ga_write_file($vpsid, "/etc/haproxy/haproxy.cfg", $final_config);
        $this->ga_exec($vpsid, "service", ["haproxy", "restart"]);
        return true;
    }
    public function lb_use_own_cert($lb_uuid, $keys, $file_name)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $this->ga_exec($vpsid, "mkdir", ["/usr/local/ssl"]);
        $this->ga_write_file($vpsid, "/usr/local/ssl/serve_" . $file_name . ".pem", implode("\n", [$keys["key"], $keys["cert"]]));
        return true;
    }
    public function lb_self_signed_cert($lb_uuid, $file_name)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $name = generateRandStr(6);
        vexec("openssl req -x509 -newkey rsa:4096 -nodes -out /var/virtualizor/" . $name . ".crt -keyout /var/virtualizor/" . $name . ".key -days 365 -subj \"/C=/O=/OU=/CN=\"");
        if(!file_exists("/var/virtualizor/" . $name . ".crt") || !file_exists("/var/virtualizor/" . $name . ".key")) {
            return false;
        }
        $keys[0] = file_get_contents("/var/virtualizor/" . $name . ".key");
        $keys[1] = file_get_contents("/var/virtualizor/" . $name . ".crt");
        $this->ga_exec($vpsid, "mkdir", ["/usr/local/ssl"]);
        $this->ga_write_file($vpsid, "/usr/local/ssl/serve_" . $file_name . ".pem", implode("\n", $keys));
        unlink("/var/virtualizor/" . $name . ".crt");
        unlink("/var/virtualizor/" . $name . ".key");
        return true;
    }
    public function lb_get_logs($lb_uuid)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $res = $this->ga_exec($vpsid, "journalctl", ["-u", "haproxy.service", "--since", "today", "--no-pager"]);
        return $res;
    }
    public function lb_get_status($lb_uuid)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $res = $this->ga_exec($vpsid, "systemctl", ["status", "haproxy"]);
        return !empty($res) ? true : false;
    }
    public function lb_get_stats($lb_uuid, $ip)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $file = $this->ga_read_file($vpsid, "/etc/haproxy/haproxy.cfg");
        $strfile = implode("\n", $file);
        preg_match("/stats\\s+auth\\s+(\\w+):(\\w+)/", $strfile, $mat);
        $rawres = $this->ga_exec($vpsid, "curl", ["--user", "haproxy:" . $mat[2], "http://" . $ip . "/stats"]);
        $res = implode(" ", $rawres);
        if(!preg_match("/\\<table(.*)\\<\\/table\\>/", $res, $mat)) {
            return $res;
        }
        preg_match("/\\<style type\\=\\\"text\\/css\\\"\\>(.*)\\<\\/style\\>/", $res, $mat);
        $style = $mat[1];
        $style = str_replace("body { font-family: arial, helvetica, sans-serif; font-size: 12px; font-weight: normal; color: black; background: white;} th,td { font-size: 10px;} h1 { font-size: x-large; margin-bottom: 0.5em;} h2 { font-family: helvetica, arial; font-size: x-large; font-weight: bold; font-style: italic; color: #6020a0; margin-top: 0em; margin-bottom: 0em;} h3 { font-family: helvetica, arial; font-size: 16px; font-weight: bold; color: #b00040; background: #e8e8d0; margin-top: 0em; margin-bottom: 0em;} li { margin-top: 0.25em; margin-right: 2em;}", "", $style);
        $style = str_replace("<!--", "", $style);
        $style = str_replace("-->", "", $style);
        $style = str_replace(";", " !important;", $style);
        $style = str_replace("border-bottom: 1px dotted black !important;", "border-bottom: 1px dotted black !important;position: relative !important;", $style);
        preg_match("/\\<table(.*)\\<\\/table\\>/", $res, $mat);
        $res = "<style>" . $style . "</style><table " . $mat[1] . "</table>";
        $res = str_replace("<td align=\"left\" valign=\"top\" nowrap width=\"1%\">", "<td align=\"left\" valign=\"top\" nowrap width=\"1%\" style=\"display:none\">", $res);
        $res = str_replace("class=\"tbl\"", "class=\"tbl table m-0\"", $res);
        return $res;
    }
    public function lb_default_rule($vid, $config, $actid = 0)
    {
        global $globals;
        global $l;
        if(!check_licensepro()) {
            return false;
        }
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status != 1 || empty($actid)) {
            $actid = vps_task("apply_lb_rule", serialize($config), 0, $vid, $vps["uid"], 1, $l["install_guest_agent"]);
            if($status != 1) {
                return -1;
            }
        }
        $i = 0;
        while ($i <= 20) {
            $res = $this->guest_agent_support($vid);
            if(isset($res["done"])) {
                foreach ($config as $filename => $v) {
                    if(in_array($v["source_protocol"], ["https", "http2", "http3"])) {
                        if(empty($v["ssl"])) {
                            $this->lb_self_signed_cert($vps["uuid"], $filename);
                        } else {
                            $this->lb_use_own_cert($vps["uuid"], $v["ssl"], $filename);
                        }
                    }
                }
                $this->lb_save_config($vps["uuid"], $config);
                task_update($actid, "VPS Started", 100);
                return NULL;
            } else {
                task_update($actid, "VPS Not Started", 10);
                sleep(10);
                $i++;
            }
        }
        task_update($actid, "Break....", 100);
    }
    public function install_ga($vid)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("install_ga", "", 0, $vid, $vps["uid"], 1, $l["install_guest_agent"]);
            if($status == 1) {
                return -1;
            }
        }
        if(!preg_match("/windows/", $vps["os_name"]) && !empty($vps["data"]["enable_guest_agent"])) {
            $data = [];
            $data[0] = ["rid" => rand(rand(-3, -10), rand(-500, -1000)), "code" => "\nif [ -f /etc/debian_version ]; then\n\tOS=Ubuntu\nelif [ -f /etc/redhat-release ]; then\n\tOS=redhat\nelif [-f /etc/oracle-release ]; then\n\tOS=redhat\nfi\n\nif [ \"\$OS\" = redhat  ] ; then\n\tsystemctl status qemu-guest-agent\n\tif [ \$? != 0 ] ; then\n\t\tyum  --skip-broken -y install qemu-guest-agent\n\tfi\n\t" . ($vps["load_balancer"] == -1 ? "\n\t\tsystemctl status haproxy\n\t\tif [ \$? != 0 ] ; then\n\t\t\tyum  --skip-broken -y install haproxy\n\t\tfi\n\t" : "") . "\n\t\nelif [ \"\$OS\" = Ubuntu  ] ; then\n\tsystemctl status qemu-guest-agent\n\tif [ \$? != 0 ] ; then\n\t\tapt-get clean -y 2>&1\n\t\tapt-get update -y 2>&1\n\t\tapt-get install -y qemu-guest-agent 2>&1\n\tfi\n\t" . ($vps["load_balancer"] == -1 ? "\n\t\tsystemctl status haproxy\n\t\tif [ \$? != 0 ] ; then\n\t\t\tapt-get clean -y 2>&1\n\t\t\tapt-get update -y 2>&1\n\t\t\tapt-get install -y haproxy 2>&1\n\t\tfi\n\t" : "") . "\nfi\nsystemctl enable qemu-guest-agent\n" . ($vps["load_balancer"] == -1 ? "systemctl enable haproxy" : "") . "\nif [ \"\$OS\" = redhat  ] ; then\n\tconfig=/etc/sysconfig/qemu-ga\n\tsed -c -i \"s/\\(BLACKLIST_RPC *= *\\).*/\\1guest\\-file\\-seek/\" \$config\nfi\n\nREL=\$(cat /etc/redhat-release)\nrhel9=\"\$(echo \$REL | egrep -i '(release 9)')\"\necho \$rhel9\nif [ \"\$?\" -eq \"0\" ]; then\n\tconfig=/etc/sysconfig/qemu-ga\n\tsed -c -i \"s/\\(BLOCK_RPCS *= *\\).*/\\1guest\\-file\\-seek/\" \$config\nfi\n\nsystemctl unmask qemu-guest-agent\n" . ($vps["load_balancer"] == -1 ? "systemctl unmask haproxy" : "") . "\nsystemctl restart qemu-guest-agent\n" . ($vps["load_balancer"] == -1 ? "systemctl restart haproxy" : "")];
            perform_vps_operation($vps["vpsid"], $actid, "install_recipe", $data);
        }
    }
    public function install_recipe($vid, $recipe, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $recipe_data = serialize($recipe);
            $actid = vps_task("install_recipe", $recipe_data, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "install_recipe", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "install_recipe", $recipe);
    }
    public function install_cp($vid, $cp, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("install_cp", $cp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "install_cp", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "install_cp", [$cp]);
    }
    public function serverloads($ids)
    {
        $usage = [];
        if(empty($ids)) {
            return false;
        }
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
            $usage[$row["vpsid"]][1] = 0;
            $usage[$row["vpsid"]][5] = 0;
            $usage[$row["vpsid"]][15] = 0;
            $vps_info = $this->vps_info($row["vpsid"]);
            if($vps_info["GuestTools"]["state"] != "installed" || $this->status($row["vpsid"], 1) != 1) {
            } else {
                $stats = [];
                vexec("/usr/bin/prlctl exec " . xss($row["vps_name"]) . " uptime &", $stats, $ret);
                if(empty($stats[0])) {
                } else {
                    $stats[0] = htmlizer($stats[0]);
                    $tmp = substr($stats[0], strrpos($stats[0], ":") + 1);
                    list($usage[$row["vpsid"]][1], $usage[$row["vpsid"]][5], $usage[$row["vpsid"]][15]) = explode(",", $tmp);
                }
            }
        }
        return $usage;
    }
    public function vscpu($ids, $speed = 100000, $times = 2)
    {
        $vs_status = $this->status($ids);
        $res = makequery("SELECT vpsid FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        $vpsnames = [];
        $usage = [];
        $_cpu_stats = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row["vpsid"];
            $usage[$row["vpsid"]] = 0;
        }
        foreach ($vpses as $k => $vpsid) {
            if($vs_status[$k] !== 0) {
                $usage[$k] = (int) $this->_cpu_stats($vpsid);
            } else {
                $usage[$k] = 0;
            }
        }
        return $usage;
    }
    public function vsram($ids)
    {
        $used_ram = 0;
        $ram[0]["used"] = 0;
        $ram[0]["ram"] = 0;
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $tmp = $this->ram($row["vpsid"]);
            $ram[$row["vpsid"]]["used"] = $tmp["used"];
            $ram[$row["vpsid"]]["label"] = "VPS : " . $row["vps_name"];
            $ram[$row["vpsid"]]["ram"] = $row["ram"];
        }
        $meminfo = get_meminfo();
        $free = $meminfo["Buffers"] + $meminfo["Cached"] + $meminfo["MemFree"];
        $used_ram = $meminfo["MemTotal"] - $free;
        $ram[0]["used"] = (int) $used_ram;
        $ram[0]["ram"] = $meminfo["MemTotal"];
        return $ram;
    }
    public function backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit)
    {
        global $globals;
        global $error;
        global $l;
        if(empty($disable_compress)) {
            $compression = get_compression_algo(0, 1, 1);
            $file_ext = $compression["file_ext"];
            $compression_algo = $compression["compression_algo"];
        } else {
            $file_ext = ".tar";
            $compression_algo = "-pcf";
        }
        $final_backup = $vps["vpsid"] . "_" . parse_backup_hostname($vps["hostname"]) . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . $file_ext;
        $vps_name = $vps["vps_name"];
        $clone_name = $vps["vpsid"] . "-virt-backup";
        vexec("/usr/bin/prlctl clone " . xss($vps_name) . " --name " . xss($clone_name) . " --template", $out, $ret);
        if($ret != "0") {
            return false;
        }
        vexec("/usr/bin/prlctl list -H -o uuid -t " . xss($clone_name), $out, $ret);
        if($ret != "0") {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        $template_uuid = trim(trim($out[0]), "{}");
        if(empty($template_uuid)) {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        $throttle_block_size = get_throttle_block_size();
        vexec("cd " . xss("/vz/vmprivate/" . $template_uuid) . " && /bin/tar " . $compression_algo . " - * " . (empty($io_limit) ? "" : "| throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " > " . xss($temp_backup_dir . "/" . $final_backup), $out, $ret);
        if($ret != "0") {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
        if(@vfilesize($temp_backup_dir . "/" . $final_backup) < 1 || !store_backup_inf($vps, $temp_backup_dir)) {
            $error[] = $l["err_vzdump"];
            return false;
        }
        return $final_backup;
    }
    public function restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit, $storagename = "")
    {
        global $globals;
        global $error;
        global $l;
        $last_actid = $GLOBALS["current_taskid"];
        $this->poweroff($vps["vpsid"]);
        $GLOBALS["current_taskid"] = $last_actid;
        $vps_uuid = $this->getuuid($vps["vpsid"]);
        if(empty($vps_uuid)) {
            $error[] = $l["vps_uuid_empty"];
            return false;
        }
        $uncompression = get_decompression_algo($backup_filename, 1, 0);
        if(in_array($uncompression["file_ext"], ["lzo", "zst", "lz4"])) {
            vexec("cd " . xss("/vz/vmprivate/" . $vps_uuid) . " && " . $uncompression["compression_algo"] . " " . $uncompression["params"] . " " . xss($temp_restore_dir . "/" . $backup_filename) . " > harddisk.tar && /bin/tar -xvf harddisk.tar " . xss("harddisk.hdd"), $out, $ret);
            vexec("cd " . xss("/vz/vmprivate/" . $vps_uuid) . " && rm -rf harddisk.tar", $o, $r);
        } else {
            vexec("cd " . xss("/vz/vmprivate/" . $vps_uuid) . " && /bin/tar " . (preg_match("/\\.gz\$/is", $backup_filename) ? "-xvzf" : "-xvf") . " " . xss($temp_restore_dir . "/" . $backup_filename) . " " . xss("harddisk.hdd"), $out, $ret);
        }
        return true;
    }
    public function suspendvps($vid)
    {
        global $l;
        if($this->vps_status_statewise($vid, 1) == 2 || $this->vps_status_statewise($vid, 1) == 0) {
            return true;
        }
        $actid = vps_task("suspend_vps", "", 0, $vid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        $vps_name = $this->getname($vid);
        if($this->vps_status_statewise($vid, 1) == 0) {
            $this->start($vid);
        }
        vexec("/usr/bin/prlctl suspend " . xss($vps_name), $output, $ret);
        if($ret == "0") {
            vexec("/usr/bin/prlctl set " . xss($vps_name) . " --autostart off", $_output, $_ret);
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["suspend_error"], -1);
        return false;
    }
    public function unsuspendvps($vid)
    {
        global $l;
        $vps_name = $this->getname($vid);
        file_put_contents(logdir("unsuspend") . $vid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        $actid = vps_task("unsuspend_vps", "", 0, $vid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        vexec("/usr/bin/prlctl resume " . xss($vps_name), $output, $ret);
        if($ret == "0") {
            vexec("prlctl set " . xss($vps_name) . " --autostart on", $output, $_ret);
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["unsuspend_error"], -1);
        return false;
    }
    public function suspend_vps_net($vid)
    {
        global $globals;
        $vm_interface_name = $this->vifname($vid);
        vexec("ifconfig  " . xss($vm_interface_name) . " down", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function unsuspend_vps_net($vid)
    {
        $vm_interface_name = $this->vifname($vid);
        file_put_contents(logdir("nw_unsuspend") . $vid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        vexec("ifconfig " . xss($vm_interface_name) . " up", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function vps_net_status($vpsid)
    {
        $vm_interface_name = $this->vifname($vpsid);
        $value = 0;
        if(!empty($vpsid)) {
            vexec("ifconfig", $output, $ret);
            $output = implode("\n", $output);
            $value = preg_match("/" . $vm_interface_name . "/is", $output) ? 1 : 0;
        }
        return $value;
    }
    public function createtemplate($vid, $name)
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vid);
        $vps_name = $this->getname($vid);
        $path = $globals["vzkos"] . "/" . $name . ".img";
        if(file_exists($path)) {
            $error[] = $l["temp_exists"];
            return false;
        }
        $clone_name = $vps["vpsid"] . "-virt-template";
        vexec("/usr/bin/prlctl clone " . xss($vps_name) . " --name " . xss($clone_name) . " --template", $out, $ret);
        if($ret != "0") {
            return false;
        }
        vexec("/usr/bin/prlctl list -H -o uuid -t " . xss($clone_name), $out, $ret);
        if($ret != "0") {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        $template_uuid = trim(trim($out[0]), "{}");
        if(empty($template_uuid)) {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        vexec("qemu-img convert -f qcow2 -O raw " . xss("/vz/vmprivate/" . $template_uuid . "/harddisk.hdd") . " " . xss($path), $out, $ret);
        if($ret != "0") {
            vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
            return false;
        }
        vexec("/usr/bin/prlctl delete " . xss($clone_name), $out, $ret);
        if(@vfilesize($path) < 1) {
            return false;
        }
        return $name . ".img";
    }
    public function check_kernel()
    {
        global $l;
        global $globals;
        if(!empty($globals["is_master_only"])) {
            return true;
        }
        oexec("uname -r", $uname);
        if(@preg_match("/\\.vz7\\./is", $uname)) {
            return NULL;
        }
        return $l["wrong_kernel"] . "<b>" . $uname . "</b>." . $l["correct_kernel"];
    }
    public function resources()
    {
        global $globals;
        $ret["licnumvs"] = $globals["licnumvs"];
        $ret["ram"] = 0;
        $ret["space"] = 0;
        $ret["total_ram"] = 0;
        $ret["total_space"] = 0;
        $ret["check_kernel"] = $this->check_kernel();
        $ret["overcommit"] = $globals["overcommit"];
        $meminfo = get_meminfo();
        if(array_key_exists("MemAvailable", $meminfo)) {
            $free = $meminfo["MemAvailable"];
        } else {
            $free = $meminfo["Buffers"] + $meminfo["Cached"] + $meminfo["MemFree"];
        }
        $ret["ram"] = $free;
        $ret["total_ram"] = $meminfo["MemTotal"];
        vexec("/bin/df /vz", $disk);
        unset($disk[0]);
        $disk[1] = str_replace("\n", "", implode(" ", $disk));
        if(!empty($disk[1])) {
            $tmp = preg_split("/\\s+/", trim($disk[1]));
            $ret["space"] = @round((double) @trim($tmp[3]) / 1024 / 1024, 2);
            $ret["total_space"] = @round((double) @trim($tmp[1]) / 1024 / 1024, 2);
        }
        $ret["cpucores"] = get_cores();
        return $ret;
    }
    public function cron()
    {
        global $globals;
        global $l;
        global $kernel;
        $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_1";
        $vpses = get_bw_vps("vzk");
        $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_2";
        $status = $this->vps_status_statewise(array_keys($vpses));
        $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_3";
        $io_usage = $this->get_io_usage();
        foreach ($vpses as $k => $v) {
            if(!empty($globals["cb_bandwidth_overusage"]) && !empty($vpses[$k]["bandwidth"]) && $vpses[$k]["bandwidth"] < $vpses[$k]["used_bandwidth"]) {
                $callback["act"][] = "bandwidth_overusage";
                $callback["data"]["email"] = $vpses[$k]["email"];
                $callback["data"]["overused"] = $vpses[$k]["used_bandwidth"] - $vpses[$k]["bandwidth"];
                $service_period = get_vps_service_period($k);
                $before = $service_period["end"] - 480;
                $current = time();
                if($before < $current && $current <= $service_period["end"]) {
                    vps_task("bandwidth_overusage_callback", serialize($callback), 0, $k, $vpses[$k]["uid"], 0, $l["task_pending"]);
                }
            }
            $vpses[$k]["status"] = $status[$k];
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_4";
            $vpses[$k]["cpu"] = $this->_cpu_stats($k);
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_5";
            $disk = $this->disk($k);
            $disk["used"] = $disk["used"];
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_6";
            $inodes = $this->inodes($k);
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_7";
            $ram = $this->ram($k);
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_8";
            $vpses[$k]["net_speed"] = $this->network_speed($k);
            makequery("INSERT INTO status SET\n\t\t\t\t\t`vpsid` = :vpsid, \n\t\t\t\t\t`time` = :time,\n\t\t\t\t\t`status` = :status,\n\t\t\t\t\t`disk` = :disk,\n\t\t\t\t\t`inode` = :inode,\n\t\t\t\t\t`ram` = :ram,\n\t\t\t\t\t`cpu` = :cpu,\n\t\t\t\t\t`actual_cpu` = :actual_cpu,\n\t\t\t\t\t`net_in` = :net_in,\n\t\t\t\t\t`net_out` = :net_out,\n\t\t\t\t\t`io_read` = :io_read,\n\t\t\t\t\t`io_write` = :io_write", [":vpsid" => $v["vpsid"], ":time" => $globals["cron_timestamp"], ":status" => $vpses[$k]["status"], ":disk" => $disk["used"], ":inode" => $inodes["used"], ":ram" => $ram["used"], ":cpu" => $vpses[$k]["cpu"], ":actual_cpu" => $vpses[$k]["cpu"], ":net_in" => $vpses[$k]["net_speed"]["download"], ":net_out" => $vpses[$k]["net_speed"]["upload"], ":io_read" => $io_usage[$k]["read"], ":io_write" => $io_usage[$k]["write"]]);
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_9";
            $vpses[$k]["net_status"] = $this->vps_net_status($k);
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_10";
            $cpu = $this->cpu($k);
            $vpses[$k]["cpu_usage"] = $cpu["percent"];
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_11";
            $ram = $this->ram($k);
            $vpses[$k]["ram_usage"] = $ram["percent"];
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_12";
            $disk = $this->disk($k);
            $vpses[$k]["disk_usage"] = $disk["percent"];
            makequery("INSERT INTO system_alerts SET\n\t\t\t\t\t\t`vpsid` = :vpsid,\n\t\t\t\t\t\t`time` = :time,\n\t\t\t\t\t\t`cpu` = :cpu,\n\t\t\t\t\t\t`ram` = :ram,\n\t\t\t\t\t\t`disk` = :disk", [":vpsid" => $v["vpsid"], ":time" => time(), ":cpu" => $vpses[$k]["cpu_usage"], ":ram" => $vpses[$k]["ram_usage"], ":disk" => $vpses[$k]["disk_usage"]]);
            if(!empty($vpses[$k]["suspended"]) && $vpses[$k]["status"] != 2) {
                if(time() - filemtime(logdir("unsuspend") . $k . ".log") <= 60) {
                    echo "VPSID : " . $k . " was just unsuspended and we will wait for the next CRONM\n";
                } else {
                    echo "Suspending VPSID " . $k . " as it should have been suspended\n";
                    $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_13";
                    $this->suspendvps($v["vpsid"]);
                    logs_vps("suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                }
            }
            if(!empty($v["nw_suspended"])) {
                $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vpsid \n\t\t\t\t\t\tAND action = 'bandwidth_unsuspend'\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0", [":vpsid" => $v["vpsid"]]);
                $tmp_uvps = [];
                if(0 < vsql_num_rows($res)) {
                    $tmp_uvps = vsql_fetch_assoc($res);
                }
                $vs_nw_sus_dat = _unserialize($v["nw_suspended"]);
                if(!empty($tmp_uvps) && check_unsusp_vps_net($v["time"], $vs_nw_sus_dat["date"])) {
                    if($v["suspended"] == 1 && $v["suspend_reason"] == "bw") {
                        $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_14";
                        $this->unsuspendvps($v["vpsid"]);
                        $res = makequery("UPDATE vps SET \n\t\t\t\t\t\t\t\tsuspended = '0',\n\t\t\t\t\t\t\t\tsuspend_reason = ''\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        to_master("vps", "suspended", $v["vpsid"], "vpsid", "0");
                        to_master("vps", "suspend_reason", $v["vpsid"], "vpsid", "");
                    }
                    $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_15";
                    if($this->unsuspend_vps_net($v["vpsid"])) {
                        task_start($tmp_uvps["actid"]);
                        $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\tSET nw_suspended = NULL\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        logs_vps("bandwidth_unsuspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                        to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", NULL);
                        task_update($tmp_uvps["actid"], $l["completed"], 100);
                    }
                } elseif($vpses[$k]["net_status"]) {
                    if(time() - filemtime(logdir("nw_unsuspend") . $k . ".log") <= 60) {
                        echo "VPSID : " . $k . " NETWORK was just unsuspended and we will wait for the next CRONM\n";
                    } else {
                        echo "Suspending network of VPSID " . $k . " as its network should have been suspended\n";
                        $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_16";
                        $this->suspend_vps_net($v["vpsid"]);
                        logs_vps("bandwidth_suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    }
                }
            }
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_17";
            $bandwidth_val = $kernel->bandwidth($v["vpsid"]);
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_18";
            $service_period = get_vps_service_period($v["vpsid"]);
            $timestamp_threshold = @file_get_contents($globals["var"] . "/eubwthreshold/" . $v["vpsid"]);
            $used_percent_bandw = round(100 * $bandwidth_val["used_gb"] / $bandwidth_val["limit_gb"]);
            $user_threshold_bandw = $v["preferences"]["vps_bandwidth_threshold"];
            $set_threshold_bandw = !empty($user_threshold_bandw) ? $user_threshold_bandw : $globals["vps_bandwidth_threshold"];
            if($user_threshold_bandw < 0) {
                $set_threshold_bandw = 0;
            }
            if(!empty($bandwidth_val["limit_gb"]) && !empty($set_threshold_bandw) && $set_threshold_bandw < $used_percent_bandw && $timestamp_threshold < $service_period["start"]) {
                $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "vps_bandwidth_threshold" => $set_threshold_bandw, "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                if(!empty($v["email"])) {
                    send_emailtemp_mail("bandwidth_threshold", $v["email"], $email_vars, 1);
                    writefile($globals["var"] . "/eubwthreshold/" . $v["vpsid"], time(), 1);
                }
                $data["title"] = $l["bandwidth_threshold_mail_sub"];
                $data["data"] = lang_vars_name($l["bandwidth_threshold_notify"], $email_vars);
                save_notification("vps_band_thershold", $data);
            }
            if($bandwidth_val["limit_gb"] < $bandwidth_val["used_gb"] && !empty($bandwidth_val["limit_gb"]) && $v["band_suspend"] == 1 && empty($v["nw_suspended"]) && empty($globals["band_suspend"])) {
                $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_19";
                if($this->suspend_vps_net($v["vpsid"])) {
                    echo "Suspending network of VPSID " . $k . " as bandwidth has been overused. Used : " . $bandwidth_val["used_gb"] . " Allowed : " . $bandwidth_val["limit_gb"] . "\n";
                    $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                    if(!empty($v["email"]) && empty($globals["disable_suspend_email"])) {
                        send_emailtemp_mail("bandwidth", $v["email"], $email_vars, 1);
                    }
                    $data["title"] = $l["bandwidth_mail_sub"];
                    $data["data"] = lang_vars_name($l["bandwidth_mail_message_notify"], $email_vars);
                    save_notification("vps_band_suspended", $data);
                    $reason = serialize(["id" => "2", "reason" => "bw", "date" => time()]);
                    $res = makequery("UPDATE vps \n\t\t\t\t\t\t\tSET nw_suspended = :reason\n\t\t\t\t\t\t\tWHERE vpsid=:vpsid", [":vpsid" => $v["vpsid"], ":reason" => $reason]);
                    $v["nw_suspended"] = $reason;
                    vps_task("bandwidth_unsuspend", $v["vps_name"], 0, $v["vpsid"], $v["uid"], 1);
                    logs_vps("bandwidth_suspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", $reason);
                }
            }
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_20";
            handle_speed_cap($v, $this, $bandwidth_val);
            $GLOBALS["cronm_exit_ret"]["vzk"][] = "vzk_kernel_cronm_21";
        }
    }
    public function cronh()
    {
        $vps_disk_usage = get_vps_disk_usage("vzk");
        foreach ($vps_disk_usage as $vpsid => $disk_usage) {
            to_master("vps", "cached_disk", $vpsid, "vpsid", serialize($disk_usage));
        }
    }
    public function create_internal_network($ippid, $bind_ip)
    {
        $interface = empty($GLOBALS["globals"]["interface"]) ? "eth0" : $GLOBALS["globals"]["interface"];
        vexec("/sbin/ifconfig " . xss($interface) . ":" . xss($ippid) . " " . xss($bind_ip) . " up");
    }
    public function destroy_internal_network($ippid)
    {
        $interface = empty($GLOBALS["globals"]["interface"]) ? "eth0" : $GLOBALS["globals"]["interface"];
        vexec("/sbin/ifconfig " . xss($interface) . ":" . xss($ippid) . " down");
    }
    public function vm_location($vids, $live = false)
    {
        return $vids;
    }
    public function storage_check($data)
    {
        if(preg_match("/ceph/is", $data["type"])) {
            exec("ceph osd lspools", $cephout, $cephret);
            foreach ($cephout as $k => $v) {
                if(preg_match("/" . basename($data["path"]) . "/is", $v)) {
                    return "";
                }
            }
            return "The Ceph Pool doesn't exist";
        } else {
            if(strtolower($data["type"]) != "file" && strtolower($data["format"]) != "qcow2") {
                return "Invalid storage";
            }
            if(!file_exists($data["path"])) {
                return "The storage doesn't exist";
            }
            return "";
        }
    }
    public function _newVncPort()
    {
        $files = filelist("/etc/libvirt/qemu/", 0);
        $vncport = 5900;
        foreach ($files as $k => $v) {
            if(!empty($v["dir"])) {
                unset($files[$k]);
            } elseif(substr($k, -3) != "xml") {
                unset($files[$k]);
            } else {
                $conf = file_get_contents($k);
                $porttmp = [];
                if(preg_match("/<graphics(\\s*?)(.*?)(\\s*?)port\\=('|\")(\\d*)('|\")/is", $conf, $porttmp)) {
                    $port = $porttmp[5];
                    if($vncport < $port) {
                        $vncport = $port;
                    }
                }
            }
        }
        for ($i = 1; $i < 1000; $i++) {
            $vncport = $vncport + 1;
            if(vexec("lsof -i:" . $vncport) != 0) {
                break;
            }
        }
        return $vncport;
    }
    public function _network_usage($vid, $dev = [])
    {
        $vps = getvps($vid);
        if(empty($dev)) {
            $dev = file("/proc/net/dev");
        }
        $devices = [];
        foreach ($dev as $k => $x) {
            $_dev = preg_split("/[\\s]+/", str_replace(":", ": ", trim($x)));
            $_dev[0] = trim($_dev[0], ":");
            foreach ($_dev as $kk => $vv) {
                $tmp[$kk] = trim($vv);
            }
            $devices[$tmp[0]] = $tmp;
        }
        $vm_interface_name = $this->vifname($vid);
        $value = $devices[$vm_interface_name];
        if(empty($value[1]) && empty($value[9])) {
            $value[1] = 0;
            $value[9] = 0;
        }
        list($c["out"], $c["in"]) = $value;
        return $c;
    }
    public function _cpu_stats($vid)
    {
        $vps_name = $this->getname($vid);
        oexec("prlctl statistics " . xss($vps_name) . " --filter guest.cpu.usage", $tmp_out);
        $ret = explode(":", $tmp_out);
        return trim($ret[1]);
    }
    public function vs_ntw_speed($vpsids)
    {
        $ret = [];
        $value1 = [];
        $value2 = [];
        foreach ($vpsids as $k => $v) {
            $value1[$v] = $this->_network_usage($v);
            $value1[$v]["time"] = time();
        }
        usleep(1000000);
        foreach ($vpsids as $k => $v) {
            $value2[$v] = $this->_network_usage($v);
            $value2[$v]["time"] = time();
        }
        foreach ($vpsids as $k => $v) {
            $diff = $value2[$v]["time"] - $value1[$v]["time"];
            if($value2[$v]["in"] < $value1[$v]["in"]) {
                $value2[$v]["in"] = $value1[$v]["in"];
                $value2[$v]["out"] = $value1[$v]["out"];
            }
            $ret[$v]["download"] = ($value2[$v]["in"] - $value1[$v]["in"]) / $diff;
            $ret[$v]["upload"] = ($value2[$v]["out"] - $value1[$v]["out"]) / $diff;
        }
        return $ret;
    }
    public function vs_disk_usage($vpsids)
    {
        $ret = [];
        foreach ($vpsids as $k => $v) {
            $tmp = [];
            $tmp["disk"] = $this->disk($v);
            $tmp["inode"] = $this->inodes($v);
            $ret[$v]["disk"]["used"] = empty($tmp["disk"]["used"]) ? 0 : $tmp["disk"]["used"] / 1024;
            $ret[$v]["disk"]["allocated"] = empty($tmp["disk"]["limit"]) ? 0 : $tmp["disk"]["limit"] / 1024;
            $ret[$v]["inode"]["used"] = empty($tmp["inode"]["used"]) ? 0 : $tmp["inode"]["used"];
            $ret[$v]["inode"]["allocated"] = empty($tmp["inode"]["limit"]) ? 0 : $tmp["inode"]["limit"];
        }
        return $ret;
    }
    public function migrate($vpsid, $data, $migrate_disk = 0)
    {
        global $globals;
        global $error;
        global $l;
        $speed = (int) (!empty($globals["default_mig_speed"]) ? $globals["default_mig_speed"] : 100);
        $sparse = 0;
        if(!empty($data["speed_limit"])) {
            $speed = $data["speed_limit"];
        }
        if($data["dest_disks"][$data["disk_num"]]["type"] == "file") {
            $sparse = 1;
        }
        $throttle_block_size = get_throttle_block_size();
        vexec("bash " . $globals["path"] . "/scripts/migrate_dd.sh " . $data["orig_disks"][$data["disk_num"]]["path"] . " " . $data["dest_disks"][$data["disk_num"]]["path"] . " " . $speed . " " . $data["to_ssh_port"] . " " . $data["to_ip"] . " " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log " . logdir($data["selected_act"]) . $data["vpsid"] . "-actual_transfer.log " . $data["disable_gzip"] . " " . $sparse . " " . xss($data["from_pgzip"]) . " " . xss($data["to_pgzip"]) . " " . xss($throttle_block_size) . " > " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $r);
        if($r != 0) {
            $error[] = $l["mig_err_bg_exec"];
            return false;
        }
        return true;
    }
    public function getuuid($vpsid)
    {
        global $globals;
        $vps_name = $this->getname($vpsid);
        vexec("/usr/bin/prlctl list " . xss($vps_name) . " -o uuid", $out, $ret);
        $uuid = substr($out[1], 1, -1);
        return $uuid;
    }
    public function get_vps_DISKS($vpsid, $disks)
    {
        global $globals;
        global $servers;
        global $kernel;
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return "";
        }
        if(!empty($vps["rescue"])) {
            $disks[-1]["primary"] = 1;
            $disks[-1]["rescue"] = 1;
            $disks[-1]["path"] = $GLOBALS["rescue_path"];
            $disks[-1]["st_uuid"] = $disks[0]["st_uuid"];
            $disks[-1]["type"] = $disks[0]["type"];
            $disks[-1]["format"] = $disks[0]["format"];
            $disks[-1]["size"] = (int) (!empty($globals["rescue_disk_size"]) ? $globals["rescue_disk_size"] : 2);
            $disks[-1]["vpsid"] = $vpsid;
            $disks[0]["primary"] = 0;
        }
        $vps_uuid = $this->getuuid($vpsid);
        $vps_info = $this->vps_info($vpsid);
        if(empty($disks)) {
            $disks = $vps["disks"];
        }
        foreach ($disks as $k => $v) {
            if($k == -1) {
            } else {
                $disks[$k]["vpsid"] = $vpsid;
                if(!empty($v["primary"])) {
                    $disks[$k]["path"] = $vps_info["Hardware"]["hdd0"]["image"];
                } elseif(!empty($v["hdd_name"])) {
                    $disks[$k]["path"] = $vps_info["Hardware"][$v["hdd_name"]]["image"];
                }
                if(preg_match("/file/is", $v["type"])) {
                    $disks[$k]["format"] = empty($v["format"]) ? "qcow2" : $v["format"];
                }
            }
        }
        return $disks;
    }
    public function vncDetails($vid)
    {
        global $globals;
        $vps = getvps($vid);
        $calling_file = basename($_SERVER["SCRIPT_FILENAME"]);
        if(in_array($calling_file, ["addvs.php", "rebuild.php"])) {
            sleep(2);
        }
        $vps_info = $this->vps_info($vid);
        $info["mode"] = $vps_info["Remote display"]["mode"];
        $info["port"] = $vps_info["Remote display"]["port"];
        $info["ip"] = $vps_info["Remote display"]["address"] == "0.0.0.0" ? server_vncip($vps["serid"]) : $vps_info["Remote display"]["address"];
        $info["password"] = $vps["vnc_passwd"];
        $info["state"] = $vps_info["Remote display state"];
        return $info;
    }
    public function changeVncPass($vid, $newpassword, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $vncdetails = $this->vncDetails($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("change_vncpass", base64_encode($newpassword), 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1 || empty($vncdetails["port"])) {
                save_notification("pending_task", ["action" => "change_vncpass", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10, "XXXXXXXX");
        $vps_name = $vps["vps_name"];
        $params = ["password" => xss($newpassword)];
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --vnc-passwd " . xss($newpassword), $out, $ret, $params);
        if($ret != 0) {
            task_update($actid, $l["err_vncpass"], -1);
            return false;
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function resizevps($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("resizevps", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "resizevps", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $disks = get_vps_DISKS($vid);
        foreach ($disks as $dk => $DISK) {
            $disk_size = vpsdisk_size($DISK);
            if(empty($disk_size) || $DISK["size"] <= $disk_size) {
            } else {
                $resize = vpsdisk_resize($vid, $DISK["path"]);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($actid, $l["vpsdisk_resize_err"], -1);
                    return false;
                }
                if(empty($resize["altered_partitions"])) {
                } elseif(!empty($DISK["primary"])) {
                    $DISK["diskinfo"] = $resize["diskinfo"];
                    $fs_resize = vpsdisk_resize_filesystem($DISK);
                    if(!empty($fs_resize["error"])) {
                        $error = merge_error($error, $fs_resize["error"]);
                        task_update($actid, $l["kvm_err_resizefs"], -1);
                        return false;
                    }
                }
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function remotedesktop($vid, $rdp, $actid = 0)
    {
        global $globals;
        global $l;
        global $user;
        global $oslist;
        global $ostemplates;
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("remotedesktop", $rdp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "remotedesktop", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "remote_desktop", [$rdp]);
    }
    public function vifname($vid, $bridge_num = 0)
    {
        global $globals;
        global $error;
        global $l;
        $vps_name = $this->getname($vid);
        $vps_info = $this->vps_info($vid);
        if(empty($vps_info)) {
            return false;
        }
        $dev = $vps_info["Hardware"]["net" . $bridge_num]["dev"];
        return $dev;
    }
    public function change_mac_address($vpsid, $mac_address)
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vpsid);
        $vm_interface_name = $this->vifname($vpsid);
        vexec("/usr/bin/prlctl set " . xss($vps["vps_name"]) . " --device-set " . xss($vm_interface_name) . " --mac " . xss($mac_address), $macout, $ret);
        return true;
    }
    public function vps_info($vid)
    {
        global $globals;
        global $error;
        $vps = getvps($vid);
        oexec("prlctl list " . xss($vps["vps_name"]) . " --info --json", $o);
        $ret = json_decode(json_encode(json_decode($o)), true);
        array_walk_recursive($ret, "trim");
        return $ret[0];
    }
    public function delete_vpsdisks($vpsid, $data, $actid = 0)
    {
        global $error;
        global $user;
        global $l;
        $status = no_log_status($vpsid, 1, $this);
        if(($status == 1 || empty($actid)) && $status == 1) {
            $disk_data = serialize($data);
            $actid = vps_task("delete_vpsdisks", $disk_data, 0, $vpsid, $user["uid"], 1, $l["change_onboot"]);
            save_notification("pending_task", ["action" => "delete_vpsdisks", "vpsid" => $vpsid, "actid" => $actid]);
            return -1;
        }
        task_start($actid);
        foreach ($data as $k => $DISK) {
            $DISK["vpsid"] = $vpsid;
            $disk_destroy = vpsdisk_destroy($DISK);
            if(!empty($disk_destroy)) {
                $error = merge_error($error, $disk_destroy);
                task_update($actid, $l["disk_destroy_err"], -1);
                return false;
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vpsdisk_destroy($vid, $DISK)
    {
        global $error;
        global $l;
        $vps = getvps($vid);
        if(empty($DISK["hdd_name"]) || $DISK["hdd_name"] == "hdd0") {
            return false;
        }
        vexec("/usr/bin/prlctl set " . xss($vps["vps_name"]) . " --device-del " . xss($DISK["hdd_name"]) . " --destroy-image", $resrtartoutput, $ret);
        if($ret != 0) {
            $error[] = $l["disk_destroy_err"];
            return $error;
        }
        return "";
    }
    public function ebtables_remove($vid)
    {
        global $globals;
        $vps = getvps($vid);
        $vm_interface_name = $this->vifname($vid);
        $vps_name = $vps["vps_name"];
        vs_ebtables_remove($vps_name, $vm_interface_name);
    }
    public function getmac($vpsid)
    {
        global $globals;
        $vps_name = $this->getname($vpsid);
        vexec("/usr/bin/prlctl list " . xss($vps_name) . " -o mac", $out, $ret);
        return trim($out[1]);
    }
    public function installtools($vid, $actid, $mount_point = "")
    {
        global $globals;
        global $error;
        global $l;
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("installtools", $rdp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            save_notification("pending_task", ["action" => "installtools", "vpsid" => $vid, "actid" => $actid]);
            if($status == 1) {
                return -1;
            }
        }
        $vps = getvps($vid);
        task_start($actid);
        $vps_info = $this->vps_info($vid);
        if($vps_info["GuestTools"]["state"] == "installed") {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        vexec("/usr/bin/prlctl installtools " . xss($vps["vps_name"]), $out, $ret);
        if($ret != 0) {
            task_update($actid, $l["err_install_tools"], 100);
            return true;
        }
        if(empty($mount_point)) {
            $mount = mount($vid, "", 1);
            if(!is_array($mount)) {
                if($mount == -1) {
                    task_update($actid, $l["mount_undetermined"], -1);
                    return true;
                }
                task_update($actid, $l["kvm_err_mount"], -1);
                return false;
            }
        } else {
            $mount["mount_point"] = $mount_point;
        }
        if(file_exists($mount["mount_point"] . "/etc/redhat-release") || file_exists($mount["mount_point"] . "/etc/oracle-release")) {
            $rc_path = "/rc.d/rc.local";
        } elseif(file_exists($mount["mount_point"] . "/etc/debian_version")) {
            $rc_path = "/rc.local";
        }
        if(is_safe_file($mount["mount_point"] . "/etc" . $rc_path) && is_safe_file($mount["mount_point"] . "/root") && is_safe_file($mount["mount_point"] . "/etc/rc.local.original") && is_safe_file($mount["mount_point"] . "/etc/selinux/config") && is_safe_file($mount["mount_point"] . "/etc/selinux/config.orignal") && file_exists($mount["mount_point"] . "/etc" . $rc_path)) {
            if(!file_exists($mount["mount_point"] . "/etc/rc.local.original")) {
                copy($mount["mount_point"] . "/etc" . $rc_path, $mount["mount_point"] . "/etc/rc.local.original");
            }
            $orig_rc = file_get_contents($mount["mount_point"] . "/etc" . $rc_path);
            $orig_rc = str_replace("mv /etc/rc.local.original /etc" . $rc_path, "", $orig_rc);
            $orig_rc = str_replace("exit 0", "#exit 0", $orig_rc);
            writefile($mount["mount_point"] . "/etc" . $rc_path, $orig_rc . "\nIN_TOOLS=\$(lsblk -o NAME,LABEL | grep \"vz-tools-lin\")\nIN_TOOLS_PATH=\$(echo \$IN_TOOLS | cut -c1-3)\nmkdir /mnt/cdrom\nmount -o ro /dev/\$IN_TOOLS_PATH /mnt/cdrom \nbash /mnt/cdrom/install &\nmv /etc/rc.local.original /etc" . $rc_path, 1);
            chmod($mount["mount_point"] . "/etc" . $rc_path, 493);
            copy($mount["mount_point"] . "/etc/selinux/config", $mount["mount_point"] . "/etc/selinux/config.orignal");
            vexec("/bin/echo \"SELINUX=disabled\" > " . xss($mount["mount_point"] . "/etc/selinux/config"));
        }
        if(empty($mount_point)) {
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["kvm_err_unmount"];
                task_update($actid, $l["kvm_err_unmount"], -1);
                return false;
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function change_winips($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("change_winips", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["change_onboot"], 57);
        perform_vps_operation($vid, 0, "config_network", ["config_network" => ["pub" => $this->getmac($vid), "int" => $this->getmac($vid)]]);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function create_rescue_disk($vid, $root_password)
    {
        global $globals;
        global $error;
        global $l;
        $GLOBALS["rescue_path"] = "";
        oslist();
        $GLOBALS["rescue"]["kvm"] = $GLOBALS["ostemplates_rescue"]["kvm"]["size"];
        $templ_name = $GLOBALS["ostemplates_rescue"]["kvm"]["file"];
        $lvsize = $GLOBALS["ostemplates_rescue"]["kvm"]["disk_size"];
        $untared_file = str_replace(".gz", "", $templ_name);
        $vps = getvps($vid, 0);
        $vps_info = $this->vps_info($vid);
        $actid = vps_task("enable_rescuevs", "", 0, $vid, $vps["uid"], 0, $l["enable_rescuevs"]);
        task_start($actid);
        task_update($actid, $l["enabling_rescue"], 5);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        if(empty($vps["rescue"])) {
            $error[] = $l["rescue_not_synced"];
            return false;
        }
        $vps_name = $vps["vps_name"];
        if(!file_exists($globals["vzkos"] . "/" . $templ_name) || filesize($globals["vzkos"] . "/" . $templ_name) != $GLOBALS["rescue"]["kvm"]) {
            task_update($actid, $l["download_rescue_temp"], 25);
            @unlink($globals["vzkos"] . "/" . $templ_name);
            $getfile = save_web_file("http://files.virtualizor.com/rescue.php?file=" . $templ_name, $globals["vzkos"] . "/" . $templ_name);
            if(empty($getfile) || filesize($globals["vzkos"] . "/" . $templ_name) != $GLOBALS["rescue"]["kvm"]) {
                $error[] = $l["err_downloading"];
                task_update($actid, $l["err_downloading"], -1);
                return false;
            }
            vexec("cd " . xss($globals["vzkos"]) . ";" . $globals["com"]["pgzip"] . " -d " . xss($globals["vzkos"] . "/" . $templ_name));
        }
        $isopath = $sec_isopath = $isotype = $sec_isotype = "";
        if(!empty($vps["iso"])) {
            $isopath = iso_path($vps["uid"], $vps["iso"], $isotype);
        }
        if(!empty($vps["sec_iso"])) {
            $sec_isopath = iso_path($vps["uid"], $vps["sec_iso"], $sec_isotype);
        }
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $this->poweroff($vps["vpsid"]);
        $routing = $ips[0]["routing"];
        $untar_path = "/var/virtualizor/vzk/" . $untared_file;
        vexec("/usr/bin/prlctl set " . xss($vps_name) . " --device-add hdd --iface virtio --size " . xss($disks[-1]["size"] * 1024), $out, $ret);
        $rescue_disk = [];
        $tmp_disk = preg_split("/[\\s]+/", $out[0]);
        $rescue_disk["hdd_name"] = trim($tmp_disk[1]);
        $rescue_disk["extra"]["hdd_name"] = trim($tmp_disk[1]);
        $tmp_path = explode("=", $tmp_disk[4]);
        $rescue_disk["path"] = trim($tmp_path[1], "'");
        $DISK["path"] = $rescue_disk["path"];
        $GLOBALS["rescue_path"] = $DISK["path"];
        task_update($actid, $l["creating_disk"], 35);
        vexec("qemu-img convert -f raw -O " . $DISK["format"] . " " . xss($globals["vzkos"] . "/" . $untared_file) . " " . xss($rescue_disk["path"]), $o, $ret);
        if($ret != "0") {
            $error[] = $l["kvm_err_rescue_dd"];
            $error["derr"] = array_end($GLOBALS["logr"]);
            vpsdisk_destroy($DISK);
            task_update($actid, $l["kvm_err_rescue_dd"], -1);
            return false;
        }
        task_update($actid, $l["resizing_disk"], 60);
        $resize = vpsdisk_resize($vid);
        if(!empty($resize["error"])) {
            $error = merge_error($error, $resize["error"]);
            task_update($actid, implode("<br>", $error), -1);
            return false;
        }
        $DISK["diskinfo"] = $resize["diskinfo"];
        task_update($actid, $l["resizing_fs"], 70);
        $fs_resize = vpsdisk_resize_filesystem($DISK);
        if(!empty($fs_resize["error"])) {
            $error = merge_error($error, $fs_resize["error"]);
            task_update($actid, implode("<br>", $error), -1);
            return false;
        }
        $new_boot_order = $rescue_disk["hdd_name"] . " " . $vps_info["Boot order"];
        vexec("prlctl set " . xss($vps_name) . " --device-bootorder " . xss($new_boot_order), $o, $ret);
        task_update($actid, $l["mount"], 65);
        $mount = mount($vid);
        if(!is_array($mount)) {
            $error[] = $l["kvm_err_mount"];
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        $post = [];
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            $shadow = file($mount["mount_point"] . "/etc/shadow");
            $tmp = explode(":", $shadow[0]);
            $tmp[1] = crypt($root_password);
            $shadow[0] = implode(":", $tmp);
            writefile($mount["mount_point"] . "/etc/shadow", implode("", $shadow), 1);
        }
        if(!empty($vps["dns_nameserver"])) {
            $dns = unserialize($vps["dns_nameserver"]);
            $post["dns"] = $dns;
        }
        task_update($actid, $l["net_config"], 70);
        network_configure($mount["mount_point"], $ips, $post, $routing);
        task_update($actid, $l["hostname_config"], 75);
        hostname_configure($mount["mount_point"], "rescue");
        task_update($actid, $l["sshkey_clean"], 80);
        sshkey_clean($mount["mount_point"]);
        task_update($actid, $l["umount"], 85);
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        if(!empty($vps["suspended"])) {
            return true;
        }
        unset($GLOBALS["rescue_path"]);
        $this->start($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "start_vps");
        _task_update($actid, $l["beginning_start_vps"], 95, $next_actid);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function list_bitmaps($vpsid)
    {
        $bitmaps = [];
        $status = $this->vps_status_statewise($vpsid, 1);
        if($status == 1) {
            $query_block = $this->get_query_block($vpsid);
            $DISKS = get_vps_DISKS($vpsid);
            foreach ($DISKS as $disk) {
                $temp_bitmaps = $query_block["return"][$disk["num"]]["dirty-bitmaps"];
                if(!empty($temp_bitmaps)) {
                    foreach ($temp_bitmaps as $v) {
                        $bitmaps[$disk["num"]][] = $v["name"];
                    }
                }
            }
        }
        return $bitmaps;
    }
    public function remove_bitmap($vpsid, $bitmap, $disk_num)
    {
        $vps = getvps($vpsid);
        $vps_name = $vps["vps_name"];
        $device = $this->get_device($vpsid, $disk_num);
        $arr = ["execute" => "block-dirty-bitmap-clear", "arguments" => ["node" => $device, "name" => $bitmap]];
        $cmd = "virsh qemu-monitor-command " . $vps_name . " " . xss(json_encode($arr)) . " 2>&1";
        oexec($cmd, $o);
        $arr = ["execute" => "block-dirty-bitmap-remove", "arguments" => ["node" => $device, "name" => $bitmap]];
        $cmd = "virsh qemu-monitor-command " . $vps_name . " " . xss(json_encode($arr)) . " 2>&1";
        oexec($cmd, $o);
    }
    public function get_query_block($vpsid)
    {
        $vps = getvps($vpsid);
        $vps_name = $vps["vps_name"];
        $qmp_command = ["execute" => "query-block"];
        oexec("/usr/bin/virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($qmp_command)), $out, $ret);
        $out = json_decode($out, true);
        return $out;
    }
    public function get_device($vpsid, $disk_num = 0)
    {
        if(empty($disk_num)) {
            $disk_num = 0;
        }
        $qemu_details = get_qemu_details();
        $is_new_libvirt = false;
        if((os_check("centos", ">=", 8) || os_check("ubuntu", ">=", 20) || os_check("almalinux", ">=", 8) || os_check("rocky", ">=", 8)) && version_compare($qemu_details["libvirt_ver"], "6.0.0", ">=")) {
            $is_new_libvirt = true;
        }
        $get_query_block = $this->get_query_block($vpsid);
        $device = $get_query_block["return"][$disk_num]["device"];
        if($is_new_libvirt) {
            $device = $get_query_block["return"][$disk_num]["inserted"]["node-name"];
        }
        return $device;
    }
    public function can_take_inc_backup($vpsid, $type)
    {
        $vps = getvps($vpsid);
        $bitmaps = $this->list_bitmaps($vpsid);
        $chains = [];
        if(empty($bitmaps)) {
            return false;
        }
        if(!empty($GLOBALS["take_full"])) {
            return false;
        }
        foreach ($vps["disks"] as $disk) {
            $file_contents = get_disk_json($vpsid, $disk["num"]);
            if(empty($file_contents)) {
                return false;
            }
            $chains[count($file_contents)] = 1;
        }
        if(1 < count($chains)) {
            return false;
        }
        return true;
    }
    public function get_last_bitmap($vpsid, $disk_num)
    {
        $bitmaps = $this->list_bitmaps($vpsid);
        $bitmaps = $bitmaps[$disk_num];
        foreach ($bitmaps as $bitmap) {
            $tmp = explode("_", $bitmap);
            $arr[] = (int) $tmp[1];
        }
        return "bitmap_" . (int) max($arr);
    }
    public function backuply_delete($time, $chain, $dir, $bid, $vps)
    {
        global $globals;
        global $servers;
        global $vps_cache;
        $vps_cache = $vps;
        $backup_server = [];
        if(0 < $bid) {
            $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
            if(vsql_num_rows($res) == 0) {
                return false;
            }
            $backup_server = vsql_fetch_assoc($res);
        }
        $class = load_backup_class($backup_server, "utils");
        if(empty($class)) {
            return false;
        }
        $qemu_details = get_qemu_details();
        $DISKS = $vps["disks"];
        foreach ($DISKS as $disk) {
            $json = get_disk_json($vps["vpsid"], $disk["num"]);
            $bkp_dir = $dir . "/" . $vps["uuid"] . "/" . $chain . "/";
            if(!empty($json[$chain]["folder_format"])) {
                $bkp_dir = $dir . "/" . $json[$chain]["folder_format"] . "/" . $chain . "/";
            }
            if($json[$chain]["htime"] == $time) {
                $class->_unlink($bkp_dir . basename($json[$chain]["filepath"]));
                $inf_file = get_inf_name($vps, $json[$chain]["htime"]);
                $class->_unlink($bkp_dir . $inf_file);
                if(empty($GLOBALS["dont_delete_bitmap"])) {
                    $this->remove_bitmap($vps["vpsid"], "bitmap_0", $disk["num"]);
                }
                if(!empty($json[$chain]["children"])) {
                    ksort($json[$chain]["children"]);
                    foreach ($json[$chain]["children"] as $t => $file) {
                        $filepath = $bkp_dir . basename($file["filepath"]);
                        if(empty($GLOBALS["dont_delete_bitmap"])) {
                            $this->remove_bitmap($vps["vpsid"], $file["bitmap"], $disk["num"]);
                        }
                        $class->_unlink($filepath);
                        $inf_file = get_inf_name($vps, $file["htime"]);
                        $class->_unlink($bkp_dir . $inf_file);
                        unset($json[$chain]["children"][$t]);
                    }
                }
                unset($json[$chain]);
                $class->_rmdir($bkp_dir);
                save_disk_json($vps["vpsid"], $json, $disk["num"]);
            } else {
                ksort($json[$chain]["children"]);
                $children_count = count($json[$chain]["children"]);
                if($children_count == 1) {
                    $dont_delete_bitmap = 1;
                }
                $to_unlink = [];
                foreach ($json[$chain]["children"] as $t => $file) {
                    $filepath = $bkp_dir . basename($file["filepath"]);
                    if(empty($backup_server)) {
                        if(!$get_next_file && $time != $file["htime"]) {
                            $prev_file = basename($file["filepath"]);
                        }
                        if($time == $file["htime"]) {
                            if(!$dont_delete_bitmap && empty($GLOBALS["dont_delete_bitmap"])) {
                                $this->remove_bitmap($vps["vpsid"], $file["bitmap"], $disk["num"]);
                            }
                            $to_unlink["file"] = $filepath;
                            $inf_file = get_inf_name($vps, $file["htime"]);
                            $to_unlink["inf"] = $bkp_dir . $inf_file;
                            unset($json[$chain]["children"][$t]);
                            $get_next_file = 1;
                        }
                        if($get_next_file && $time != $file["htime"]) {
                            $next_file = basename($file["filepath"]);
                            $get_next_file = 0;
                            if(!empty($next_file) && empty($prev_file)) {
                                $prev_file = basename($json[$chain]["filepath"]);
                            }
                            if(!empty($prev_file) && !empty($next_file)) {
                                if(version_compare($qemu_details["qemu_ver"], "6.1.0", ">=")) {
                                    $opt = " -F qcow2";
                                }
                                vexec("cd " . $bkp_dir . ";qemu-img rebase" . $opt . " -b " . $prev_file . " " . $next_file);
                                $class->_unlink($to_unlink["file"]);
                                $class->_unlink($to_unlink["inf"]);
                            }
                            if(!empty($to_unlink)) {
                                $class->_unlink($to_unlink["file"]);
                                $class->_unlink($to_unlink["inf"]);
                            }
                            save_disk_json($vps["vpsid"], $json, $disk["num"]);
                            $delete_all_files = $get_next_file = 0;
                            $prev_file = $next_file = "";
                        }
                    } else {
                        if($time == $file["htime"]) {
                            if(!$dont_delete_bitmap && empty($GLOBALS["dont_delete_bitmap"])) {
                                $this->remove_bitmap($vps["vpsid"], $file["bitmap"], $disk["num"]);
                            }
                            $class->_unlink($filepath);
                            $inf_file = get_inf_name($vps, $file["htime"]);
                            $class->_unlink($bkp_dir . $inf_file);
                            unset($json[$chain]["children"][$t]);
                            $delete_all_files = 1;
                        }
                        if($delete_all_files && $time != $file["htime"] && empty($GLOBALS["dont_delete_bitmap"])) {
                            $this->remove_bitmap($vps["vpsid"], $file["bitmap"], $disk["num"]);
                            $class->_unlink($filepath);
                            $inf_file = get_inf_name($vps, $file["htime"]);
                            $class->_unlink($bkp_dir . $inf_file);
                            unset($json[$chain]["children"][$t]);
                        }
                    }
                }
            }
        }
        return true;
    }
    public function clean_vps_cache($vpsid)
    {
        $vps = getvps($vpsid);
        $has_support = $this->guest_agent_support($vpsid, "guest-exec", $not_installed);
        if(!empty($has_support["done"])) {
            $os_info = $this->ga_os_info($vpsid);
            if(preg_match("/windows/is", $vps["os_name"])) {
                $drives = $this->ga_exec($vpsid, "wmic", ["logicaldisk", "get", "name"]);
                unset($drives[0]);
                foreach ($drives as $d) {
                    $d_letter = trim(substr($d, 0, 1));
                    $this->ga_exec($vpsid, "powershell", ["Write-VolumeCache", $d_letter]);
                }
            } else {
                $this->ga_exec($vpsid, "sync");
            }
            usleep(500000);
        }
    }
    public function backuply_backup($vpsid, $bkp_dir, $disk_num, $pref_type)
    {
        global $error;
        global $backup_folder;
        $vps = getvps($vpsid);
        $disk = get_vps_disk($vpsid, "", $disk_num);
        $filename = $vpsid . "_" . parse_backup_hostname($vps["hostname"]) . (!empty($disk_num) ? "_" . $disk_num : "") . "_" . $GLOBALS["backup_file_time"];
        if(empty($pref_type)) {
            $type = "full";
        }
        if($pref_type == "inc") {
            $type = "inc";
        } elseif($pref_type == "diff") {
            $type = "diff";
        } elseif($pref_type == "full") {
            $type = "full";
        }
        if(!$this->can_take_inc_backup($vpsid, $type)) {
            $type = "full";
        }
        $device = $this->get_device($vpsid, $disk_num);
        if($type == "full") {
            $bitmaps = $this->list_bitmaps($vpsid);
            if(!empty($bitmaps[$disk_num])) {
                foreach ($bitmaps[$disk_num] as $bitmap) {
                    $this->remove_bitmap($vps, $bitmap, $disk_num);
                }
            }
            $filename = $filename . ".full";
            $filepath = $bkp_dir . $filename;
            $status = $this->vps_status_statewise($vpsid, 1);
            if($status == 1) {
                $params = ["execute" => "transaction", "arguments" => ["actions" => [["type" => "block-dirty-bitmap-add", "data" => ["node" => $device, "name" => "bitmap_0"]]]]];
                vexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($params)) . " 2>&1", $o, $r);
                if($r != 0) {
                    $error[] = print_r($o, 1);
                    return false;
                }
                usleep(500000);
            }
            $GLOBALS["DONT_LOG"] = 1;
            $this->clean_vps_cache($vpsid);
            $GLOBALS["DONT_LOG"] = 0;
            if(preg_match("/ceph/is", $disk["type"])) {
                $cpath = preg_split("/" . preg_quote("/dev/rbd/", "/") . "/i", $disk["path"]);
                $cpath = $cpath[1];
                $disk_path = explode("/", $cpath);
                unset($o);
                unset($r);
                vexec("rbd ls " . xss($disk_path[0]) . " | grep -E " . xss($disk_path[1] . "\$"), $o, $r);
                if(!empty($r)) {
                    return false;
                }
                unset($r);
                unset($o);
                vexec("rbd showmapped | grep -E " . xss("(.*)" . $disk_path[1] . "(\\s)"), $o, $r);
                if(!empty($r)) {
                    vexec("rbd map " . xss($cpath) . " 2>&1");
                    sleep(1);
                }
            }
            vexec("qemu-img convert -U -O qcow2 " . $disk["path"] . " " . $bkp_dir . $filename . " 2>&1", $o, $r);
            if($r != 0) {
                $error[] = print_r($o, 1);
                unlink($bkp_dir . $filename);
                return false;
            }
        } elseif($type == "inc" || $type == "diff") {
            $file_contents = get_disk_json($vpsid, $disk_num);
            ksort($file_contents);
            $last_chain = array_end($file_contents);
            $prev_file = $last_chain["filepath"];
            $count = 0;
            if(!empty($last_chain["children"])) {
                ksort($last_chain["children"]);
                $prev_file = array_end($last_chain["children"])["filepath"];
                $count = array_end($last_chain["children"])["file_count"] + 1;
            }
            $filename = $filename . "." . $type . $count;
            $filepath = $bkp_dir . $filename;
            if(!file_exists($prev_file)) {
                echo "\n\n Creating new backing file \n\n";
                vexec("qemu-img create -f qcow2 " . $prev_file . " " . $disk["size"] . "G 2>&1", $o, $r);
                usleep(500000);
            }
            vexec("qemu-img create -f qcow2 " . $filepath . " " . $disk["size"] . "G -b " . basename($prev_file) . " -F qcow2 2>&1", $o, $r);
            if($r != 0) {
                $error[] = print_r($o, 1);
                unlink($bkp_dir . $filename);
                return false;
            }
            usleep(500000);
            $bitmap = "bitmap_0";
            if($type == "inc") {
                $bitmap = $this->get_last_bitmap($vpsid, $disk_num);
                echo "bitmap : " . $bitmap . "\n\n";
                $tmp_bitmap = cexplode("_", $bitmap, 1);
                $bit_count = $tmp_bitmap[1];
                $bit_count = $bit_count + 1;
                $params = ["execute" => "transaction", "arguments" => ["actions" => [["type" => "block-dirty-bitmap-add", "data" => ["node" => $device, "name" => "bitmap_" . $bit_count]]]]];
                vexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($params)) . " 2>&1", $o, $r);
                if($r != 0) {
                    $error[] = print_r($o, 1);
                    return false;
                }
            }
            $GLOBALS["DONT_LOG"] = 1;
            $this->clean_vps_cache($vpsid);
            $GLOBALS["DONT_LOG"] = 0;
            $params = ["execute" => "drive-backup", "arguments" => ["device" => $device, "bitmap" => $bitmap, "target" => $filepath, "format" => "qcow2", "sync" => "incremental", "mode" => "existing", "job-id" => "virt_snap0"]];
            vexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($params)) . " 2>&1", $o, $r);
            if($r != 0) {
                $error[] = print_r($o, 1);
                unlink($bkp_dir . $filename);
                return false;
            }
            $GLOBALS["DONT_LOG"] = 1;
            while (true) {
                oexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss("{\"execute\":\"query-block-jobs\"}"), $o, $r);
                $o = json_decode($o, 1);
                if(empty($o["return"])) {
                    break;
                }
                foreach ($o["return"] as $val) {
                    if($val["type"] == "backup" && $val["paused"]) {
                        $bitmaps = $this->list_bitmaps($vpsid);
                        if(!empty($bitmaps[$disk_num])) {
                            foreach ($bitmaps[$disk_num] as $bitmap) {
                                $this->remove_bitmap($vpsid, $bitmap, $disk_num);
                            }
                        }
                        @unlink($filepath);
                        oexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss("{\"execute\":\"block-job-cancel\", \"arguments\" : {\"device\" : \"" . $val["device"] . "\"}}"), $o, $r);
                        return false;
                    } elseif($val["type"] == "backup" && $val["status"] != "running") {
                    }
                }
            }
            $GLOBALS["DONT_LOG"] = 0;
        }
        $date = DateTime::createFromFormat("Y_m_d-H_i_s", $GLOBALS["backup_file_time"]);
        $disk_new_arr = ["filepath" => $filepath, "htime" => $GLOBALS["backup_file_time"], "time" => $date->format("U"), "bitmap" => $bitmap, "size" => vfilesize($filepath), "folder_format" => basename(dirname($backup_folder)), "file_count" => $count];
        $disk_json = get_disk_json($vpsid, $disk_num);
        $disk_arr = !empty($disk_json) ? $disk_json : [];
        $disk_new_arr["type"] = $pref_type;
        if(!empty($disk_arr)) {
            if($type == "full") {
                $disk_arr[basename($backup_folder)] = $disk_new_arr;
                $disk_arr[basename($backup_folder)]["hostname"] = $vps["hostname"];
                $disk_arr[basename($backup_folder)]["vps_uuid"] = $vps["uuid"];
                $disk_arr[basename($backup_folder)]["vpsid"] = $vps["vpsid"];
            } else {
                $disk_arr[basename($backup_folder)]["children"][time()] = $disk_new_arr;
            }
        } else {
            $disk_arr[basename($backup_folder)] = $disk_new_arr;
            $disk_arr[basename($backup_folder)]["hostname"] = $vps["hostname"];
            $disk_arr[basename($backup_folder)]["vps_uuid"] = $vps["uuid"];
            $disk_arr[basename($backup_folder)]["vpsid"] = $vps["vpsid"];
        }
        save_disk_json($vpsid, $disk_arr, $disk_num);
        return array_merge(["filename" => $filename], $disk_new_arr);
    }
    public function backuply_restore($vpsid, $backing_file, $disk_num)
    {
        global $error;
        $last_actid = $GLOBALS["current_taskid"];
        $this->poweroff($vpsid);
        $GLOBALS["current_taskid"] = $last_actid;
        $disk = get_vps_disk($vpsid, "", $disk_num);
        vexec("qemu-img convert -O " . $disk["format"] . " " . $backing_file . " " . $disk["path"] . " 2>&1", $o, $r);
        if($r != 0) {
            $error[] = print_r($o, 1);
            return false;
        }
        return true;
    }
    public function rebase_files($vpsid, $rebase_files)
    {
        $full_backup = $rebase_files[0];
        unset($rebase_files[0]);
        $count = count($rebase_files);
        $flag = 0;
        foreach ($rebase_files as $key => $file) {
            $flag = $flag + 1;
            vexec("qemu-img rebase -b " . $full_backup . " " . $file, $o, $r);
            if($r != 0) {
                return false;
            }
            if(0 < $count - $flag) {
                vexec("qemu-img commit " . $file, $o1, $r1);
                if($r1 != 0) {
                    return false;
                }
            }
        }
        return $full_backup;
    }
    public function delete_rescue_disk($vid, $root_password = "")
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vid, 0);
        $vps_info = $this->vps_info($vid);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            return false;
        }
        $vps_name = $vps["vps_name"];
        $this->poweroff($vps["vpsid"]);
        $DISK = get_vps_disk($vid);
        $disks_count = count(array_keys($disks)) - 1;
        $bootorder = explode(" ", $vps_info["Boot order"]);
        $DISK["hdd_name"] = $bootorder[0];
        if(!empty($DISK["rescue"])) {
            $storage_destroy = vpsdisk_destroy($DISK);
            if(!empty($storage_destroy)) {
                $error = merge_error($error, $storage_destroy);
                return false;
            }
        }
        if(!empty($vps["suspended"])) {
            return true;
        }
        $this->start($vps["vpsid"]);
        return true;
    }
    public function addsshkeys($vid, $ssh_keys, $actid = 0)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("addsshkeys", serialize($ssh_keys), 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "addsshkeys", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return false;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(!addsshkeys($mount["mount_point"], $ssh_keys)) {
            $error[] = $l["err_add_sshkeys"];
            task_update($actid, $l["err_add_sshkeys"], -1);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function removesshkeys($vid, $keys_to_remove, $actid = 0)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("removesshkeys", serialize($keys_to_remove), 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "removesshkeys", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return false;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(!removesshkeys($mount["mount_point"], $keys_to_remove)) {
            $error[] = $l["err_remove_sshkeys"];
            task_update($actid, $l["err_remove_sshkeys"], -1);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function get_io_usage($vid = 0)
    {
        $delay = 3;
        $vpses = [];
        $io_usage = [];
        $token_vals = [];
        $query = "SELECT vpsid, vps_name FROM vps\n\t\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\t\tAND virt = 'vzk'";
        if(!empty($vid)) {
            $query .= " AND vpsid = :vid";
            $token_vals[":vid"] = $vid;
        }
        $res = makequery($query, $token_vals);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
            $io_usage[$row["vpsid"]] = ["read" => 0, "write" => 0];
        }
        foreach ($vpses as $vpsid => $vps) {
            vexec("prlctl list -o uuid -H " . $vps["vps_name"], $out, $ret);
            $uuid = trim($out[0], " {}");
            if(empty($uuid)) {
            } else {
                vexec("prlctl statistics " . $uuid . " --filter devices.*", $out, $ret);
                if($ret != 0) {
                } else {
                    foreach ($out as $line) {
                        $parts = explode(":", trim($line));
                        if(count($parts) < 2) {
                        } else {
                            $key = trim($parts[0]);
                            $value = trim($parts[1]);
                            if(preg_match("/^devices\\..+?\\.read_total\$/is", $key)) {
                                $io_usage[$vpsid]["read"] += (int) $value;
                            } elseif(preg_match("/^devices\\..+?\\.write_total\$/is", $key)) {
                                $io_usage[$vpsid]["write"] += (int) $value;
                            }
                        }
                    }
                }
            }
        }
        sleep($delay);
        foreach ($vpses as $vpsid => $vps) {
            vexec("prlctl list -o uuid -H " . $vps["vps_name"], $out, $ret);
            $uuid = trim($out[0], " {}");
            if(empty($uuid)) {
            } else {
                vexec("prlctl statistics " . $uuid . " --filter devices.*", $out, $ret);
                if($ret != 0) {
                } else {
                    $read = 0;
                    $write = 0;
                    foreach ($out as $line) {
                        $parts = explode(":", trim($line));
                        if(count($parts) < 2) {
                        } else {
                            $key = trim($parts[0]);
                            $value = trim($parts[1]);
                            if(preg_match("/^devices\\..+?\\.read_total\$/is", $key)) {
                                $read += (int) $value;
                            } elseif(preg_match("/^devices\\..+?\\.write_total\$/is", $key)) {
                                $write += (int) $value;
                            }
                        }
                    }
                    $io_usage[$vpsid]["read"] = ($read - $io_usage[$vpsid]["read"]) / $delay;
                    $io_usage[$vpsid]["write"] = ($write - $io_usage[$vpsid]["write"]) / $delay;
                }
            }
        }
        return $io_usage;
    }
    public function guest_agent_support($vpsid, $command = "", &$not_installed = 0)
    {
        global $l;
        $res = [];
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name)) {
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-info\"}"), $info, $ret);
        if(!empty($ret)) {
            $res["error"] = $info;
            $not_installed = 1;
            return $res;
        }
        $info = @json_decode($info, 1);
        $res["info"] = $info;
        if(!empty($command)) {
            $ga_pass_support = false;
            foreach ($info["return"]["supported_commands"] as $ik => $com) {
                if(preg_match("/" . $command . "/", $com["name"]) && !empty($com["enabled"])) {
                    $ga_pass_support = true;
                    if(!$ga_pass_support) {
                        $res["error"] = lang_vars_name($l["kvm_guest_agent_err"], ["version" => $info["return"]["version"], "command" => $command]);
                        return $res;
                    }
                }
            }
        }
        $res["done"] = 1;
        return $res;
    }
    public function ga_read_file($vpsid, $file)
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name) || empty($file)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-file-open", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-open\", \"arguments\": {\"path\": \"" . $file . "\",\"mode\" : \"r\" }}"), $handle, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $handle = json_decode($handle, true);
        $handle = $handle["return"];
        if(empty($handle)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-file-read", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-read\", \"arguments\" : {\"handle\":" . (int) $handle . "}}"), $proc, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $proc = json_decode($proc, true);
        $final_output = base64_decode($proc["return"]["buf-b64"]);
        $final_output = cexplode("\n", $final_output, 0, 1);
        $final_output = array_values($final_output);
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-close\", \"arguments\" : {\"handle\":" . (int) $handle . "}}"), $proc, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        return $final_output;
    }
    public function ga_write_file($vpsid, $file, $data)
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name) || empty($file)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-file-open", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-open\", \"arguments\": {\"path\": \"" . $file . "\",\"mode\" : \"w+\" }}"), $handle, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $handle = json_decode($handle, true);
        $handle = $handle["return"];
        if(empty($handle)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-file-write", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        $data = base64_encode($data);
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-write\", \"arguments\" : {\"handle\":" . (int) $handle . ", \"buf-b64\" : \"" . $data . "\"}}"), $proc, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $final_output = json_decode($proc, true);
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-close\", \"arguments\" : {\"handle\":" . (int) $handle . "}}"), $o, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        return $final_output;
    }
    public function ga_exec($vpsid, $command, $args = [], $input_data = "")
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name) || empty($command)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-exec", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        $_args = "";
        if(!empty($args)) {
            $_args = "\"arg\" : " . json_encode($args) . ",";
        }
        $_input_data = "";
        if(!empty($input_data)) {
            $_input_data = "\"input-data\" : " . json_encode(base64_encode($input_data)) . ",";
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-exec\", \"arguments\": {\"path\": \"" . $command . "\"," . $_args . $_input_data . "\"capture-output\":true }}"), $pid, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $pid = json_decode($pid, true);
        $pid = $pid["return"]["pid"];
        if(empty($pid)) {
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-exec-status\", \"arguments\" : {\"pid\":" . (int) $pid . "}}"), $proc, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $proc = json_decode($proc, true);
        if(empty($proc["return"]["exited"])) {
            $flag = $count = 0;
            while ($count <= 60) {
                oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-exec-status\", \"arguments\" : {\"pid\":" . (int) $pid . "}}"), $proc, $ret);
                if(!empty($ret) && empty($flag)) {
                    $error[] = $exec_err;
                    return false;
                    break;
                }
                if(!empty($ret) && !empty($flag)) {
                } else {
                    $proc = json_decode($proc, true);
                    if(!empty($proc)) {
                        $flag = 1;
                    }
                    if(!empty($proc["return"]["exited"])) {
                    } else {
                        $count++;
                        sleep(1);
                    }
                }
            }
        }
        $key = "out-data";
        if(!empty($proc["return"]["exitcode"])) {
            $key = "err-data";
        }
        $final_output = [];
        $tmp_output = @base64_decode($proc["return"][$key]);
        $final_output = @cexplode("\n", $tmp_output, 0, 1);
        return $final_output;
    }
    public function ga_network_get_interfaces($vpsid)
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-network-get-interfaces", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-network-get-interfaces\"}"), $out, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $out = json_decode($out, true);
        return $out["return"];
    }
    public function ga_os_info($vpsid)
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-get-osinfo", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-get-osinfo\"}"), $info, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $info = json_decode($info, true);
        $info = $info["return"];
        if(empty($info)) {
            return false;
        }
        return $info;
    }
    public function perform_vertical_scaling()
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        if(empty($globals["inhouse_billing"])) {
            echo "Enable billing from billing settings for scaling to take effect\n";
            return false;
        }
        @logdir("scaling/ver_scaling");
        $res = makequery("SELECT uid, pid FROM users WHERE \n\t\t\t\t\t\t`type` = 2 AND \n\t\t\t\t\t\tinhouse_billing = 1\n\t\t\t\t\t\tORDER BY email");
        $users = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $users[$row["uid"]] = $row;
        }
        $res = makequery("SELECT uid, pid FROM users WHERE \n\t\t\t\t\t\t`pid` IN (" . implode(", ", array_keys($users)) . ")\n\t\t\t\t\t\tORDER BY email");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $users[$row["uid"]] = $row;
        }
        $res = makequery("SELECT v.vpsid, \n\t\t\t\t\t\t\t\tv.serid, \n\t\t\t\t\t\t\t\tv.vps_name, \n\t\t\t\t\t\t\t\tv.hostname, \n\t\t\t\t\t\t\t\tv.uuid, \n\t\t\t\t\t\t\t\tv.os_name, \n\t\t\t\t\t\t\t\tv.uid, \n\t\t\t\t\t\t\t\tv.cores, \n\t\t\t\t\t\t\t\tv.ram, \n\t\t\t\t\t\t\t\tv.data \n\t\t\t\t\t\t\t\tFROM vps v, users u \n\t\t\t\t\t\t\t\tWHERE u.uid = v.uid AND v.uid IN (" . implode(", ", array_keys($users)) . ")");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $vps = vsql_fetch_assoc($res);
            $vps["data"] = json_decode($vps["data"], 1);
            $owner = !empty($users[$vps["uid"]]["pid"]) ? $users[$vps["uid"]]["pid"] : $vps["uid"];
            if(!empty($globals["enable_ver_scaling"]) || !empty($vps["data"]["enable_ver_scaling"])) {
                echo "----------------------------------------\n";
                echo "Next VPSID:" . $vps["vpsid"] . "\n\n";
                if(preg_match("/windows/is", $vps["os_name"])) {
                    echo "Vps having Id " . $vps["vpsid"] . " skipped for scaling as it has windows OS" . "\n\n";
                } else {
                    $vps_status = $this->vps_status_statewise($vps["vpsid"], true);
                    if($vps_status != 1) {
                        echo "Vps having Id " . $vps["vpsid"] . " skipped for scaling as it is off/suspended" . "\n\n";
                    } else {
                        $final_resource = [];
                        if(is_master()) {
                            $resource_pricing = resource_rates();
                            foreach ($resource_pricing as $resource => $rate) {
                                if(!in_array($resource, ["cores", "ram"])) {
                                } else {
                                    $final_resource[$resource] = $rate;
                                }
                            }
                        }
                        $vps["ver_ram_inc_by"] = !empty($vps["data"]["ver_ram_inc_by"]) ? $vps["data"]["ver_ram_inc_by"] : $globals["ver_ram_inc_by"];
                        $vps["ver_cpu_inc_by"] = !empty($vps["data"]["ver_cpu_inc_by"]) ? $vps["data"]["ver_cpu_inc_by"] : $globals["ver_cpu_inc_by"];
                        $ver_data = get_vps_meta($vps["uuid"], ["ver_ram_inc_by", "ver_cpu_inc_by"]);
                        if(!empty($ver_data)) {
                            foreach ($ver_data as $vv) {
                                if(!empty($vv["meta_value"])) {
                                    $vps[$vv["meta_key"]] = $vv["meta_value"];
                                }
                            }
                        }
                        if(!empty($globals["ver_max_ram"]) || !empty($vps["data"]["ver_max_ram"])) {
                            $this->vertical_scale_ram($vps, $owner, $final_resource);
                        }
                        if(!empty($globals["ver_max_cpu"]) || !empty($vps["data"]["ver_max_cpu"])) {
                            $this->vertical_scale_cpu($vps, $owner, $final_resource);
                        }
                    }
                }
            }
        }
        if(is_slave()) {
            initiate_reverse_sync();
        }
        echo "\n";
    }
    public function vertical_scale_ram($vps, $owner, $resources)
    {
        global $globals;
        global $servers;
        global $l;
        if(!check_licensepro()) {
            return false;
        }
        $vps_name = $vps["vps_name"];
        $min_ram = $vps["ram"];
        $max_ram = !empty($vps["data"]["ver_max_ram"]) ? $vps["data"]["ver_max_ram"] : $globals["ver_max_ram"];
        $usr_threshold = !empty($vps["data"]["ver_ram_threshold"]) ? $vps["data"]["ver_ram_threshold"] : $globals["ver_ram_threshold"];
        $inc_by = $vps["ver_ram_inc_by"] * 1024;
        $ram_log_path = logdir("/scaling/ver_scaling/") . $vps["vpsid"] . "_ram";
        $fcont = @json_decode(@read_file($ram_log_path), 1);
        if(empty($max_ram) || empty($usr_threshold) || empty($inc_by)) {
            return false;
        }
        $get_ram_stats = function ($vps_name) {
            vexec("virsh dommemstat " . $vps_name . " --live", $o, $r);
            $free = $o[5];
            $free = explode(" ", $free);
            $free = round($free[1] / 1024, 2);
            $actual_balloon = $o[0];
            $actual_balloon = explode(" ", $actual_balloon);
            $actual_balloon = round($actual_balloon[1] / 1024, 2);
            $total = $o[0];
            $total = explode(" ", $total);
            $total = round($total[1] / 1024, 2);
            return ["free" => $free, "total" => $total, "actual_balloon" => $actual_balloon];
        };
        $apply_billing = function ($vps, $owner, $resources, $inc_by) {
            global $globals;
            global $servers;
            global $l;
            $vals = [];
            $vals["vps_uuid"] = $vps["uuid"];
            $vals["uid"] = $owner;
            $vals["updatetime"] = time();
            $vals["endtime"] = $vals["updatetime"];
            $vals["starttime"] = $vals["endtime"];
            $vals["resource"] = "vertical_ram";
            if(is_master()) {
                $h_used = $resources["ram"]["h_rate"][$servers[$vps["serid"]]["sgid"]];
                if(empty($h_used)) {
                    $h_used = $resources["ram"]["h_rate"][-1];
                }
                $vals["h_used"] = $h_used * $inc_by;
            }
            $vals["data"] = serialize(["hostname" => $vps["hostname"]]);
            $set = [];
            foreach ($vals as $k => $v) {
                $set[$k] = "`" . $k . "` = :" . $k;
            }
            if(is_slave()) {
                $post["usage"]["vals"] = $vals;
                $post["usage"]["set"] = $set;
                $post["inc_by"] = $inc_by;
                $post["serid"] = $globals["slave"];
                make_api_call_from_slave("index.php?rsync_to_master=1&billing_sync=1", [], $post);
            } else {
                insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
            }
        };
        vexec("virsh dommemstat " . $vps_name . " --period 2 --live", $o, $r);
        $num_of_iterations = 2;
        for ($i = 0; $i < $num_of_iterations; $i++) {
            usleep(500000);
            $ram_stats = $get_ram_stats($vps_name);
            $free = $ram_stats["free"];
            $total = $ram_stats["total"];
            $actual_balloon = $ram_stats["actual_balloon"];
            $used_ram = round($total - $free, 2);
            $perc_used[$i] = round($used_ram / $total * 100, 3);
            $perc_free[$i] = round($free / $total * 100, 3);
        }
        $sum_used = array_sum($perc_used);
        $threshold = $sum_used / $num_of_iterations;
        $rem_ram = $max_ram - $total;
        echo "--SCALING RAM--\n";
        echo "Free (IN VM) : " . $free . " MB\n";
        echo "Total (IN VM) : " . $total . " MB\n";
        echo "Actual Balloon Value : " . $actual_balloon . " MB\n";
        echo "Percentage used : " . $threshold . "\n";
        if($usr_threshold < $threshold && 0 < $rem_ram) {
            $arr = [];
            $new_ram = round($total + $inc_by);
            if($max_ram < $new_ram) {
                $new_ram = $max_ram;
                $arr["maxed_out"] = 1;
            }
            $arr["new_ram"] = $new_ram;
            echo "Increasing Ram to : " . $new_ram . "MB\n";
            vexec("grep MemFree /proc/meminfo", $server_free_memory);
            virt_preg_replace("/(MemFree:\\s+)(.*)/", $server_free_memory[0], $server_free_memory, 2);
            $server_free_memory = (int) $server_free_memory / 1024;
            if($server_free_memory < $new_ram) {
                echo "ERROR : Insufficient RAM on server hence cannot perform scaling.\n Free RAM : " . $server_free_memory . " MB\n Required RAM : " . $new_ram . " MB";
                return false;
            }
            vexec("virsh setmem " . $vps_name . " " . $new_ram . "M --live", $o, $ret);
            if($ret != 0) {
                echo "Error: There was an error while increasing ram!\n";
                return false;
            }
            $arr["time"] = time() + 3600;
            @writefile($ram_log_path, @json_encode($arr), 1);
            if(!empty($fcont["maxed_out"]) && !empty($fcont["time"]) && $fcont["time"] < time()) {
                $fcont["maxed_out"] = 0;
                $inc_by = round($max_ram - $min_ram);
            }
            if(empty($fcont["maxed_out"]) && !empty($fcont["time"]) && $fcont["time"] < time() && !empty($fcont["new_ram"])) {
                $fcont["maxed_out"] = 0;
                $inc_by = round($fcont["new_ram"] - $min_ram);
            }
            if(empty($fcont["maxed_out"])) {
                $inc_by = $inc_by / 1024;
                $apply_billing($vps, $owner, $resources, $inc_by);
            }
        } elseif($threshold < $usr_threshold) {
            $time = $fcont["time"];
            if(!empty($time) && $time <= time()) {
                if($used_ram < $min_ram) {
                    $tmp_usage = $used_ram / $min_ram * 100;
                    if($tmp_usage < $usr_threshold) {
                        echo "Setting RAM to Actual Min RAM: " . $min_ram . "M\n";
                        vexec("virsh setmem " . $vps_name . " " . $min_ram . "M --live", $o, $ret);
                        if($ret != 0) {
                            echo "Error: There was an error while decreasing ram!\n";
                            return false;
                        }
                        if($ret == 0) {
                            @unlink($ram_log_path);
                        }
                    } elseif(!empty($fcont["new_ram"])) {
                        $inc_by = round(($fcont["new_ram"] - $min_ram) / 1024);
                        $apply_billing($vps, $owner, $resources, $inc_by);
                    }
                } elseif($min_ram < $total) {
                    $new_ram = round($total - $inc_by);
                    if($new_ram < $min_ram) {
                        $new_ram = $min_ram;
                    }
                    if($used_ram < $new_ram) {
                        $old_ram = 0;
                        $i = $used_ram + $inc_by;
                        while ($i < $total) {
                            if($usr_threshold <= $i / $total * 100) {
                                $new_ram = $old_ram;
                                break;
                            }
                            $old_ram = $i;
                            $i = $i + $inc_by;
                        }
                        $tmp_usage = $used_ram / $new_ram * 100;
                        if($tmp_usage < $usr_threshold) {
                            echo "Decreasing RAM to : " . $new_ram . "M\n";
                            vexec("virsh setmem " . $vps_name . " " . $new_ram . "M --live", $o, $ret);
                            if($ret != 0) {
                                echo "Error: There was an error while decreasing ram!\n";
                                return false;
                            }
                            if($min_ram < $new_ram) {
                                $inc_by = round(($new_ram - $min_ram) / 1024);
                                $apply_billing($vps, $owner, $resources, $inc_by);
                            }
                            if($ret == 0) {
                                @unlink($ram_log_path);
                            }
                        } elseif(!empty($fcont["new_ram"])) {
                            $inc_by = round(($fcont["new_ram"] - $min_ram) / 1024);
                            $apply_billing($vps, $owner, $resources, $inc_by);
                        }
                    }
                }
            }
        }
    }
    public function vertical_scale_cpu($vps, $owner, $resources)
    {
        global $globals;
        global $servers;
        if(!check_licensepro()) {
            return false;
        }
        $vps_name = $vps["vps_name"];
        $min_cpu = $vps["cores"];
        $max_cpu = !empty($vps["data"]["ver_max_cpu"]) ? $vps["data"]["ver_max_cpu"] : $globals["ver_max_cpu"];
        $usr_threshold = !empty($vps["data"]["ver_cpu_threshold"]) ? $vps["data"]["ver_cpu_threshold"] : $globals["ver_cpu_threshold"];
        $inc_by = $vps["ver_cpu_inc_by"];
        $cpu_log_path = logdir("/scaling/ver_scaling/") . $vps["vpsid"] . "_cpu";
        $file_time = @read_file($cpu_log_path);
        if(empty($max_cpu) || empty($usr_threshold) || empty($inc_by)) {
            return false;
        }
        $get_vcpus = function ($vps_name) {
            $_vcpu = [];
            vexec("virsh vcpuinfo " . $vps_name, $_vcpu, $ret);
            $vcpu = 0;
            foreach ($_vcpu as $v) {
                if(preg_match("/VCPU/", $v)) {
                    $vcpu++;
                }
            }
            return $vcpu;
        };
        $num_of_iterations = 2;
        $time = $usage = $tot_usage = $_time = [];
        $time_interval = 1;
        $vcpu = $get_vcpus($vps_name);
        for ($i = 0; $i < $num_of_iterations; $i++) {
            for ($j = 0; $j < 2; $j++) {
                vexec("virsh cpu-stats " . $vps_name . " --total", $o, $r);
                $_time = array_values(array_filter(explode(" ", $o[1])));
                $time[$j] = $_time[1];
                if($j == 1) {
                } else {
                    sleep($time_interval);
                }
            }
            $tot_usage[$i] = 100 * ($time[1] - $time[0]) / $time_interval;
            $usage[$i] = $tot_usage[$i] / $vcpu;
        }
        $sum_used = array_sum($tot_usage);
        $tot_threshold = $sum_used / $num_of_iterations;
        $sum_used = array_sum($usage);
        $threshold = $sum_used / $num_of_iterations;
        $rem_vcpu = $max_cpu - $vcpu;
        echo "\n--SCALING CPU--\n";
        echo "Total usage (" . $vcpu . " VCPUs): " . round($tot_threshold, 3) . "%\n";
        echo "Avg CPU Usage per vCPU: " . round($threshold, 3) . "%\n";
        if($usr_threshold < $threshold && 0 < $rem_vcpu) {
            $new_cpu = $vcpu + $inc_by;
            if($max_cpu < $new_cpu) {
                $new_cpu = $max_cpu;
            }
            echo "Increasing CPU core to : " . $new_cpu . " core\n";
            vexec("virsh setvcpus " . $vps_name . " " . $new_cpu . " --live", $o, $ret);
            if($ret != 0) {
                echo "Error: There was an error while increasing cpu cores!\n";
                return false;
            }
            @writefile($cpu_log_path, @time() + 3600, 1);
            if($vcpu != $max_cpu) {
                $vals = [];
                $vals["vps_uuid"] = $vps["uuid"];
                $vals["uid"] = $owner;
                $vals["updatetime"] = time();
                $vals["endtime"] = $vals["updatetime"];
                $vals["starttime"] = $vals["endtime"];
                $vals["resource"] = "vertical_cores";
                if(is_master()) {
                    $h_used = $resources["cores"]["h_rate"][$servers[$vps["serid"]]["sgid"]];
                    if(empty($h_used)) {
                        $h_used = $resources["cores"]["h_rate"][-1];
                    }
                    $vals["h_used"] = $h_used * $inc_by;
                }
                $vals["data"] = serialize(["hostname" => $vps["hostname"]]);
                $set = [];
                foreach ($vals as $k => $v) {
                    $set[$k] = "`" . $k . "` = :" . $k;
                }
                if(is_slave()) {
                    $post["usage"]["vals"] = $vals;
                    $post["usage"]["set"] = $set;
                    $post["inc_by"] = $inc_by;
                    $post["serid"] = $vps["serid"];
                    make_api_call_from_slave("index.php?rsync_to_master=1&billing_sync=1", [], $post);
                } else {
                    insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                }
            }
        } elseif($threshold < $usr_threshold && !empty($file_time) && $file_time <= time()) {
            echo "Decreasing CPU core to : " . $min_cpu . " core\n";
            vexec("virsh setvcpus " . $vps_name . " " . $min_cpu . " --live", $o, $ret);
            if($ret != 0) {
                echo "Error: There was an error while decreasing cpu cores!\n";
                return false;
            }
            @unlink($cpu_log_path);
        }
    }
    public function vpsdisk_path_build($vpsid, $suffix = "", $storage = [], $vps = [])
    {
        global $globals;
        $uuid = $this->getuuid($vpsid);
        $disk_name = $uuid . "/harddisk" . $vps["current_disk_num"] . ".hdd";
        return $storage["path"] . "/" . $disk_name;
    }
    public function get_vps_bridge($vpsid)
    {
        $ret = [];
        if(empty($vpsid)) {
            return $ret;
        }
        $ips = [];
        $res = makequery("SELECT i.ippid, ip.ippid, ip.bridge, ip.ovs_bridge FROM `ips` \n\t\t\t\t\t\ti LEFT JOIN ippool ip ON (ip.ippid = i.ippid) WHERE i.vpsid = :vid \n\t\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vpsid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(!empty($row["bridge"])) {
                $ips[$row["bridge"]] = trim($row["bridge"]);
            }
        }
        if(!empty($ips)) {
            foreach ($ips as $k => $v) {
                oexec("virsh net-list | grep " . $v . " 2>&1", $out, $return);
                if($return != "0") {
                    $ret[$v] = $v;
                }
            }
        }
        return $ret;
    }
}

?>