<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function vpsrestore()
{
    global $theme;
    global $globals;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $kernel;
    global $delete_done;
    global $restore_done;
    global $backup_servers;
    global $directories;
    global $backup_list;
    global $servers_keypass;
    global $vpses;
    global $vps_backup_server;
    global $vps_backup_dir;
    global $restore_details;
    global $servers;
    global $storages;
    global $newstorage;
    global $oslist;
    global $isos;
    global $ajax_user;
    global $updated_ips;
    global $bus_driver;
    global $has_backuply;
    global $ostemplates;
    if(!load_lang("admin/vpsrestore")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["cant_restore"], $l["cant_restore_exp"], $l["cant_restore"]);
        return false;
    }
    $theme["init_theme"] = "admin/vpsrestore";
    $theme["init_theme_name"] = "Restore VPS Backups";
    $theme["init_theme_func"] = ["vpsrestore_theme"];
    $theme["call_theme_func"] = "vpsrestore_theme";
    if(!is_allowed("restorevpsbackup")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $res = makequery("SELECT v.vpsid, v.vps_name, v.hostname FROM vps v\n\t\t\t\t\t\tLEFT JOIN plans p ON p.plid = v.plid\n\t\t\t\t\t\tWHERE v.serid = :serid\n\t\t\t\t\t\tAND (v.bpid > 0 OR (v.bpid = -1 AND p.bpid > 0))", [":serid" => $globals["server"]]);
    $vpses = [];
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $vpses[$row["vpsid"]] = $row;
    }
    $backup_servers = [];
    $res = makequery("SELECT * FROM backup_servers");
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $backup_servers[$row["bid"]] = $row;
    }
    $op = optREQ("op");
    if($op == "get_vps") {
        $vpsid = (int) optREQ("vpsid");
        $res = makequery("SELECT bp.bid, bp.dir, bp.bs_servergroups FROM vps v\n\t\t\t\t\t\t\tLEFT JOIN plans p ON p.plid = v.plid\n\t\t\t\t\t\t\tINNER JOIN backup_plans bp ON (bp.bpid = v.bpid OR (v.bpid = -1 AND bp.bpid = p.bpid))\n\t\t\t\t\t\t\tLEFT JOIN backup_servers bs ON bs.bid = bp.bid\n\t\t\t\t\t\t\tWHERE v.vpsid = :vpsid", [":vpsid" => $vpsid]);
        if(vsql_num_rows($res) == 0) {
            $error[] = $l["err_no_bkup_settings"];
            return false;
        }
        $row = vsql_fetch_assoc($res);
        $vps_backup_server = $row["bid"];
        $vps_backup_dir = $row["dir"];
        $row["bs_servergroups"] = _unserialize($row["bs_servergroups"]);
        $sgid = $servers[$globals["server"]]["sgid"];
        if(!empty($row["bs_servergroups"]["bs_groups"][$sgid])) {
            $vps_backup_server = $row["bs_servergroups"]["bs_groups"][$sgid];
        }
        if(!empty($row["bs_servergroups"]["bs_servers"][$globals["server"]])) {
            $vps_backup_server = $row["bs_servergroups"]["bs_servers"][$globals["server"]];
        }
        if(!empty($row["bs_servergroups"]["dir_groups"][$sgid])) {
            $vps_backup_dir = $row["bs_servergroups"]["dir_groups"][$sgid];
        }
        if(!empty($row["bs_servergroups"]["dir_servers"][$globals["server"]])) {
            $vps_backup_dir = $row["bs_servergroups"]["dir_servers"][$globals["server"]];
        }
        $_REQUEST["bid"] = $vps_backup_server;
        $_REQUEST["dir"] = $vps_backup_dir;
    }
    if($op == "get_dirs" || $op == "get_vps") {
        $bid = (int) optREQ("bid");
        $res = makequery("SELECT bid, dir, bs_servergroups FROM backup_plans");
        $directories = [];
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if($row["bid"] == $bid) {
                $directories[] = $row["dir"];
            }
            $row["bs_servergroups"] = _unserialize($row["bs_servergroups"]);
            foreach ($row["bs_servergroups"]["bs_groups"] as $sgid => $_bid) {
                if($_bid == $bid) {
                    if(empty($row["bs_servergroups"]["dir_groups"][$sgid])) {
                        $directories[] = $row["dir"];
                    } else {
                        $directories[] = $row["bs_servergroups"]["dir_groups"][$sgid];
                    }
                }
            }
            foreach ($row["bs_servergroups"]["bs_servers"] as $serid => $_bid) {
                if($_bid == $bid) {
                    if(empty($row["bs_servergroups"]["dir_servers"][$serid])) {
                        $directories[] = $row["dir"];
                    } else {
                        $directories[] = $row["bs_servergroups"]["dir_servers"][$serid];
                    }
                }
            }
        }
        $directories = array_unique($directories);
        $directories = array_values($directories);
    }
    if($op == "get_backups" || $op == "get_vps") {
        $bid = (int) optREQ("bid");
        $dir = optREQ("dir");
        $selected_date = (int) optREQ("date");
        $vpsid = (int) optREQ("vpsid");
        $has_backuply = 0;
        if(!empty($_REQUEST["use_backuply"])) {
            $has_backuply = 1;
            if(!empty($vpsid)) {
                $backup_list = $cluster->get_disk_json($globals["server"], $vpsid);
            } else {
                $jsons = $cluster->get_disk_json($globals["server"], 0);
                foreach ($jsons as $vpsid => $vjsons) {
                    if(empty($vjsons)) {
                    } else {
                        foreach ($vjsons as $chain => $json) {
                            if(empty($json)) {
                            } else {
                                $backup_list[$chain] = $json;
                            }
                        }
                    }
                }
            }
        } else {
            if($bid <= 0) {
                $backup_list = $cluster->list_vps_backups2($globals["server"], $dir, $selected_date);
            } else {
                $backup_list = [];
                if(empty($backup_servers[$bid])) {
                    return false;
                }
                $bs = $backup_servers[$bid];
                if($bs["type"] == "SSH") {
                    $connection = connect_ssh($bs);
                    if(!$connection) {
                        $error[] = $l["error_ssh_connect"];
                        return false;
                    }
                    $backup_list = get_ssh_backup_list($connection, $dir, $selected_date);
                } elseif($bs["type"] == "FTP") {
                    $ftp_con = connect_ftp($bs);
                    if($ftp_con) {
                        $backup_list = get_backups_list($ftp_con, $dir, $selected_date);
                    }
                }
            }
            $extensions = [];
            foreach ($servers[$globals["server"]]["virts"] as $virt) {
                $extensions = array_merge($extensions, get_backup_extensions($virt));
            }
            $bkup_regex = get_backup_regex();
            foreach ($backup_list as $date => $backups) {
                foreach ($backups as $k => $bkup) {
                    $filename = basename($bkup["abs_path"]);
                    preg_match($bkup_regex[1], $filename, $matches);
                    preg_match($bkup_regex[2], $filename, $matches2);
                    if($matches2[1] == "vzdump") {
                        $matches3 = !empty($matches2[11]) ? $matches2[10] . "." . $matches2[11] : $matches2[10];
                        if(!in_array($matches3, $extensions)) {
                            unset($backup_list[$date][$k]);
                        }
                    } elseif(!empty($matches[4]) || !in_array($matches[7], $extensions)) {
                        unset($backup_list[$date][$k]);
                    }
                }
                $backup_list[$date] = array_values($backup_list[$date]);
            }
            if(!empty($vpsid)) {
                foreach ($backup_list as $date => $backups) {
                    foreach ($backups as $k => $bkup) {
                        $filename = basename($bkup["abs_path"]);
                        preg_match($bkup_regex[1], $filename, $matches1);
                        preg_match($bkup_regex[2], $filename, $matches2);
                        $preg_num = $matches1[1];
                        if($matches2[1] == "vzdump") {
                            $preg_num = $matches2[3];
                        }
                        if((int) $preg_num != $vpsid) {
                            unset($backup_list[$date][$k]);
                        }
                    }
                    $backup_list[$date] = array_values($backup_list[$date]);
                }
            }
        }
        return true;
    }
    if(!empty($_REQUEST["use_backuply"]) && !empty($_REQUEST["backuply_restore"])) {
        $backup_file = optREQ("backup_file");
        $backup_date = (int) optREQ("backup_date");
        $bid = (int) optREQ("bid");
        $dir = optREQ("dir");
        $vps = $cluster->backuply_get_inf_contents($globals["server"], $backup_file, $bid, $dir);
        if(empty($vps)) {
            $error[] = $l["err_backuply_no_vps"];
            return false;
        }
        $actid = $cluster->backuply_restore($globals["server"], $vps["vpsid"], $backup_date, $backup_file);
        if(empty($actid)) {
            $error[] = $l["err_restore"];
            return false;
        }
        $restore_done = true;
        return true;
    }
    if(!empty($_REQUEST["use_backuply"]) && !empty($_REQUEST["backuply_delete"])) {
        $time = optREQ("time");
        $chain = optREQ("chain");
        $bid = (int) optREQ("bid");
        $dir = optREQ("dir");
        $vps = $cluster->backuply_get_inf_contents($globals["server"], $time, $bid, $dir);
        $res = $cluster->backuply_delete_backup($globals["server"], $time, $chain, $dir, $bid, $vps);
        if(empty($res)) {
            $error[] = $l["err_deleting_backup"];
            return false;
        }
        $delete_done = true;
        return true;
    }
    $delete = optREQ("delete");
    if(!empty($delete)) {
        if(!is_allowed("deletevpsbackup")) {
            $error[] = $l["err_acl_no_allowed"];
            return false;
        }
        $bid = (int) optREQ("bid");
        $dir = optREQ("dir");
        $date = (int) optREQ("date");
        $backup_files = cexplode(",", $delete);
        $backup_server = [];
        if(0 < $bid) {
            $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
            if(vsql_num_rows($res) == 0) {
                $error[] = $l["err_bkup_server_notfound"];
                return false;
            }
            $backup_server = vsql_fetch_assoc($res);
        }
        foreach ($backup_files as $backup_file) {
            $_vid = get_backup_vpsid($backup_file);
            $_files[$backup_file] = $cluster->backup_disk_list($globals["server"], $_vid, $backup_file, $dir, $date, $backup_server);
        }
        $result = call_user_func_array("array_merge", $_files);
        $backup_files = array_values($result);
        unset($result);
        unset($_files);
        if(!$cluster->delete_vps_backups2($globals["server"], $bid, $dir, $date, $backup_files)) {
            $error[] = $l["err_deleting_backup"];
            return false;
        }
        $delete_done = true;
        return true;
    } else {
        $restore_details = optREQ("restore_details");
        if(!empty($restore_details)) {
            $vpsid = (int) $restore_details;
            $bid = (int) optREQ("bid");
            $dir = optREQ("dir");
            $date = (int) optREQ("date");
            $htime = optREQ("htime");
            if(!empty($error)) {
                return false;
            }
            if(0 < $bid) {
                $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
                if(vsql_num_rows($res) == 0) {
                    $error[] = $l["err_bkup_server_notfound"];
                    return false;
                }
                $backup_server = vsql_fetch_assoc($res);
            }
            $use_backuply = 0;
            if(!empty($_REQUEST["use_backuply"])) {
                $_post = $cluster->backuply_get_inf_contents($globals["server"], $htime, $bid, $dir, $vpsid);
                if(empty($_post)) {
                    $error[] = $l["err_inf"];
                    return false;
                }
                $use_backuply = 1;
            } else {
                $inf = get_inf_contents($vpsid, $dir, $date, $backup_server);
                if(empty($inf)) {
                    $error[] = $l["err_inf"];
                    return false;
                }
                $_post = _unserialize($inf);
            }
            $res = makequery("SELECT uid, email \n\t\t\t\t\t\tFROM users \n\t\t\t\t\t\tORDER BY email \n\t\t\t\t\t\tLIMIT 0, " . (empty($globals["load_user_limit"]) ? 250 : $globals["load_user_limit"]));
            $users = [];
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $users[$row["uid"]] = $row["email"];
            }
            if(empty($users[$_post["uid"]])) {
                $res = makequery("SELECT uid, email\n\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $_post["uid"]]);
                $row = vsql_fetch_assoc($res);
                $users[$row["uid"]] = $row["email"];
            }
            if(!empty($users[$_post["uid"]]["pid"]) && empty($users[$users[$_post["uid"]]["pid"]])) {
                $res = makequery("SELECT uid, email \n\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $users[$_post["uid"]]["pid"]]);
                $row = vsql_fetch_assoc($res);
                $users[$row["uid"]] = $row["email"];
            }
            $disks = [];
            foreach ($_post["disks"] as $disk) {
                if(preg_match("/" . $_post["vps_name"] . "(_?)swap/is", $disk["path"]) || $kernel->features("disk_hotplug", $_post["virt"]) && !empty($disk["user_uid"]) && empty($disk["primary"])) {
                } else {
                    $disks[] = ["disk_uuid" => $disk["disk_uuid"], "st_uuid" => $disk["st_uuid"], "format" => $disk["format"], "size" => $disk["size"], "bus_driver" => $disk["bus_driver"], "bus_driver_num" => $disk["bus_driver_num"]];
                }
            }
            $restore_details = ["hostname" => "Restored-" . (int) $_post["vpsid"], "uid" => (int) $_post["uid"], "users" => $users, "disks" => $disks, "vps_virt" => $_post["virt"], "use_backuply" => $use_backuply];
            $restore_details["iso"] = [];
            $restore_details["os"] = $restore_details["iso"];
            if(empty($_post["iso"]) && empty($_post["osid"])) {
                oslist();
                $restore_details["os"] = $oslist[$_post["virt"]];
                useriso($_post["uid"]);
                if(!empty($isos)) {
                    $restore_details["iso"] = $isos;
                }
            }
            oslist();
            $restore_details["ignore_os_check"] = "";
            if(!array_key_exists($_post["osid"], $ostemplates)) {
                $restore_details["ignore_os_check"] = $l["err_no_os_temp"];
            }
            $server_ips = $servers[$globals["server"]];
            $ips_data = get_free_ips($globals["server"]);
            $ip_arr = ["ips", "ips6", "ips6_subnet", "ips_int"];
            $ip_arr_list = ["ips", "ipv6", "ipv6_subnet", "ips_int"];
            $restore_details["ips_list"] = [];
            $restore_details["free_ips"] = [];
            for ($i = 0; $i < 4; $i++) {
                $restore_details["free_ips"][$ip_arr[$i]] = $server_ips[$ip_arr_list[$i]];
                if(!empty($ips_data)) {
                    $restore_details["ips_list"][$ip_arr[$i]] = $ips_data[$ip_arr[$i]];
                }
            }
            $no_ip_flag = 0;
            foreach ($ip_arr as $ip_key) {
                if(empty($_post["num_" . $ip_key])) {
                    $restore_details["vps_ips"][$ip_key] = 0;
                    $no_ip_flag++;
                } else {
                    $restore_details["vps_ips"][$ip_key] = $_post["num_" . $ip_key];
                }
            }
            if(count($ip_arr) == $no_ip_flag) {
                foreach ($ip_arr as $ip_key) {
                    if(1 < $restore_details["free_ips"][$ip_key]) {
                        $restore_details["vps_ips"][$ip_key] = 1;
                    }
                }
            }
            $restore_details["bus_driver"] = $kernel->features("bus_driver_list", $_post["virt"]);
            return true;
        } else {
            $load_ajax_user = optGET("load_ajax_user");
            if(!empty($load_ajax_user)) {
                $_email = optREQ("email");
                $ajax_user = [];
                $ajax_res = makequery("SELECT uid, email, pid \n\t\t\t\t\t\tFROM users \n\t\t\t\t\t\tWHERE email LIKE '%" . $_email . "%'\n\t\t\t\t\t\tORDER BY email \n\t\t\t\t\t\tLIMIT 0, " . (empty($globals["load_user_ajax_reslen"]) ? 250 : $globals["load_user_ajax_reslen"]));
                for ($i = 1; $i <= vsql_num_rows($ajax_res); $i++) {
                    $usr_row = vsql_fetch_assoc($ajax_res);
                    $parent = "";
                    if(!empty($usr_row["pid"])) {
                        if(!empty($users[$usr_row["pid"]])) {
                            $parent = $users[$usr_row["pid"]]["email"];
                        } else {
                            $parent_res = makequery("SELECT email \n\t\t\t\t\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $usr_row["pid"]]);
                            $parent = vsql_fetch_assoc($parent_res);
                            $users[$usr_row["pid"]] = $parent;
                            $parent = $parent["email"];
                        }
                    }
                    $ajax_user[$usr_row["uid"]]["email"] = $usr_row["email"];
                    $ajax_user[$usr_row["uid"]]["parent"] = $parent;
                }
                return true;
            }
            $update_ips = (int) optREQ("update_ips");
            if(isset($_REQUEST["update_ips"])) {
                $updated_ips = [];
                $server_ips = $servers[$update_ips];
                $ips_data = get_free_ips($update_ips);
                $ip_arr = ["ips", "ips6", "ips6_subnet", "ips_int"];
                $ip_arr_list = ["ips", "ipv6", "ipv6_subnet", "ips_int"];
                $updated_ips["ips_list"] = [];
                $updated_ips["free_ips"] = [];
                for ($i = 0; $i < 4; $i++) {
                    $updated_ips["free_ips"][$ip_arr[$i]] = $server_ips[$ip_arr_list[$i]];
                    if(!empty($ips_data)) {
                        $updated_ips["ips_list"][$ip_arr[$i]] = $ips_data[$ip_arr[$i]];
                    }
                }
                return true;
            }
            $update_storage = (int) optREQ("update_storage");
            if(isset($_REQUEST["update_storage"])) {
                $tmp_active_server = $globals["server"];
                set_active_server($update_storage);
                list_storages();
                $newstorage[] = $storages;
                set_active_server($tmp_active_server);
                return true;
            }
            $restore = optREQ("restore");
            if(!empty($restore)) {
                if(!is_allowed("restorevpsbackup")) {
                    $error[] = $l["err_acl_no_allowed"];
                    return false;
                }
                $vpsid = POST("vpsid", $l["no_vpsid"]);
                $file = optPOST("file");
                $bid = optPOST("bid");
                $dir = POST("dir", $l["no_dir"]);
                if(empty($_REQUEST["use_backuply"])) {
                    $date = POST("date", $l["no_date"]);
                }
                $newvps = optPOST("newvps");
                $uid = optREQ("uid");
                $newserid = optREQ("newserid");
                $osid = optREQ("osid");
                $iso = optREQ("iso");
                if(!empty($_REQUEST["use_backuply"])) {
                    $htime = POST("htime", $l["no_htime"]);
                    $time = POST("time", $l["no_time"]);
                }
                if(!empty($error)) {
                    return false;
                }
                $GLOBALS["backup_file"] = $file;
                if(!empty($newvps)) {
                    $row = [];
                    if(0 < $bid) {
                        $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
                        if(vsql_num_rows($res) == 0) {
                            $error[] = $l["err_bkup_server_notfound"];
                            return false;
                        }
                        $row = vsql_fetch_assoc($res);
                    }
                    $use_backuply = 0;
                    if(!empty($_REQUEST["use_backuply"])) {
                        $post = $cluster->backuply_get_inf_contents($globals["server"], $htime, $bid, $dir, $vpsid);
                        if(empty($post)) {
                            $error[] = $l["err_inf"];
                            return false;
                        }
                        $use_backuply = 1;
                        $post["old_vps"] = base64_encode(serialize(["vpsid" => $post["vpsid"], "uuid" => $post["uuid"]]));
                    } else {
                        $inf = get_inf_contents($vpsid, $dir, $date, $row);
                        if(empty($inf)) {
                            $error[] = $l["err_inf"];
                            return false;
                        }
                        $post = _unserialize($inf);
                    }
                    if(isset($newserid)) {
                        $post["newserid"] = $newserid;
                        set_active_server($newserid);
                        list_storages();
                    }
                    if(!empty($uid)) {
                        $post["uid"] = $uid;
                    }
                    if(server_virt($globals["server"], $post["virt"]) != $post["virt"]) {
                        $error[] = $l["err_vps_virt_inv"];
                        return false;
                    }
                    if(empty($post["osid"]) && empty($post["iso"])) {
                        if(empty($osid) && empty($iso)) {
                            $error[] = $l["err_no_os"];
                            return false;
                        }
                        $post["osid"] = $osid;
                        $post["iso"] = $iso;
                    }
                    if(!empty($post["dns_nameserver"])) {
                        $post["dns"] = _unserialize($post["dns_nameserver"]);
                    }
                    if(isset($post["io"])) {
                        $post["priority"] = $post["io"];
                    }
                    if(isset($post["swap"])) {
                        $post["swapram"] = $post["swap"];
                    }
                    if(!empty($post["vnc"])) {
                        $post["vncpass"] = generateRandStr($kernel->features("vncpasslen", $post["virt"]));
                    }
                    if(!empty($post["plid"])) {
                        if($post["bpid"] == -1) {
                            $_res = makequery("SELECT bpid FROM plans WHERE plid = :plid", [":plid" => $post["plid"]]);
                            if(vsql_num_rows($_res) < 1) {
                                $error[] = $l["err_no_plan"];
                                return false;
                            }
                            $row = vsql_fetch_assoc($_res);
                            $post["bpid"] = $row["bpid"];
                        }
                        unset($post["plid"]);
                    }
                    $hostname = optREQ("hostname");
                    $tmp_serid = $globals["server"];
                    $post["rootpass"] = generateRandStr(16) . "aA1!aA1!aA1!";
                    $post["addvps"] = 1;
                    $post["restore"] = 1;
                    $post["bid"] = $bid;
                    $post["dir"] = $dir;
                    $post["backup_date"] = $date;
                    $post["backup_vpsid"] = $vpsid;
                    $post["hostname"] = empty($hostname) ? "Restored-" . $post["hostname"] : $hostname;
                    $post["from_server"] = $tmp_serid;
                    $num_ip_arr = ["num_ips", "num_ips_int", "num_ips6", "num_ips6_subnet"];
                    $no_ip_flag = 0;
                    foreach ($num_ip_arr as $ip_key) {
                        $ip_req = optREQ($ip_key);
                        $_ip_key = explode("num_", $ip_key);
                        $_ip_req = $_POST[$_ip_key[1]];
                        if(empty($ip_req) && empty($_ip_req)) {
                            $post[$ip_key] = 0;
                            $no_ip_flag++;
                        } else {
                            $post[$_ip_key[1]] = !empty($_ip_req) ? $_ip_req : "";
                            $post[$ip_key] = !empty($_ip_req) ? 0 : $ip_req;
                        }
                    }
                    if(count($num_ip_arr) == $no_ip_flag) {
                        $post["num_ips"] = 1;
                    }
                    if(!empty($post["bpid"]) && $post["bpid"] != -1) {
                        $res = makequery("SELECT bpid FROM backup_plans WHERE bpid = :bpid", [":bpid" => $post["bpid"]]);
                        if(vsql_num_rows($res) == 0) {
                            $error[] = $l["err_no_backup_plan"];
                            return false;
                        }
                    }
                    $space = [];
                    $stid_primary = storage_get_primary($post["virt"]);
                    $st_uuid_primary = $storages[$stid_primary]["st_uuid"];
                    foreach ($post["disks"] as $k => $disk) {
                        if(preg_match("/" . $post["vps_name"] . "(_?)swap/is", $disk["path"]) || $kernel->features("disk_hotplug", $post["virt"]) && !empty($disk["user_uid"]) && empty($disk["primary"])) {
                        } else {
                            $_size = (int) optPOST("size_" . $k);
                            $space[$k] = ["size" => !empty($_size) ? $_size : $disk["size"], "st_uuid" => $st_uuid_primary, "num" => $disk["num"]];
                            if(!empty($disk["bus_driver"])) {
                                $space[$k]["bus_driver"] = $disk["bus_driver"];
                                $space[$k]["bus_driver_num"] = $disk["bus_driver_num"];
                            }
                            $new_st_uuid = optPOST("st_uuid_" . $k);
                            if(!empty($new_st_uuid)) {
                                $storage = NULL;
                                foreach ($storages as $str) {
                                    if($str["st_uuid"] == $new_st_uuid) {
                                        $storage = $str;
                                        if(empty($storage)) {
                                            $error[] = lang_vars_name($l["err_storage_not_found"], ["uuid" => $new_st_uuid]);
                                            return false;
                                        }
                                        if($storage["format"] != $disk["format"]) {
                                            $error[] = lang_vars_name($l["err_inv_storage"], ["disk_num" => $k + 1, "storage_format" => strtoupper($storage["format"]), "disk_format" => strtoupper($disk["format"])]);
                                            return false;
                                        }
                                        $space[$k]["st_uuid"] = $new_st_uuid;
                                    }
                                }
                            }
                        }
                    }
                    if(!empty($space)) {
                        $post["space"] = $space;
                    }
                    $post["DONT_DD_OS_TEMPLATE"] = 1;
                    $post["storage_name"] = $storage["name"];
                    $post["backup_file"] = $GLOBALS["backup_file"];
                    $post["backup_file_htime"] = $htime;
                    $post["backuply_time"] = $time;
                    $post["use_backuply"] = $use_backuply;
                    if(!empty($post["data"])) {
                        foreach ($post["data"] as $key => $value) {
                            $post[$key] = $value;
                        }
                    }
                    $result = make_api_call("127.0.0.1", $servers_keypass[0]["pass"], "index.php?act=addvs&changeserid=" . $newserid, 0, $post);
                    if(empty($result["done"])) {
                        log_output(implode("\n", $result["error"]));
                        $error = merge_error([$l["err_restore"]], $result["error"]);
                    } else {
                        $restore_done = true;
                    }
                    set_active_server($tmp_serid);
                } else {
                    $res = makequery("SELECT vpsid, serid FROM vps WHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
                    $row = vsql_fetch_assoc($res);
                    if(empty($row["vpsid"])) {
                        $error[] = $l["err_vps_not_found"];
                        return false;
                    }
                    $result = $cluster->restore_vps2($row["serid"], $vpsid, $bid, $dir, $date);
                    if(empty($result)) {
                        $error[] = $l["err_restore"];
                    } else {
                        logs_admin("startedrestorevps", $vpsid, 1, 0, $user["uid"]);
                        $restore_done = true;
                    }
                }
                return true;
            }
        }
    }
}
function API_vpsrestore()
{
    global $theme;
    global $globals;
    global $user;
    global $l;
    global $error;
    global $delete_done;
    global $restore_done;
    global $directories;
    global $backup_list;
    global $vps_backup_server;
    global $vps_backup_dir;
    global $restore_details;
    global $newstorage;
    global $ajax_user;
    global $updated_ips;
    global $bus_driver;
    global $has_backuply;
    global $done;
    if(isset($delete_done)) {
        $GLOBALS["_api"]["delete_done"] = $delete_done;
    }
    if(isset($restore_done)) {
        $GLOBALS["_api"]["restore_done"] = $restore_done;
    }
    if(isset($directories)) {
        $GLOBALS["_api"]["directories"] = $directories;
    }
    if(isset($backup_list)) {
        $GLOBALS["_api"]["backup_list"] = $backup_list;
    }
    if(isset($vps_backup_server)) {
        $GLOBALS["_api"]["vps_backup_server"] = $vps_backup_server;
    }
    if(isset($vps_backup_dir)) {
        $GLOBALS["_api"]["vps_backup_dir"] = $vps_backup_dir;
    }
    if(isset($restore_details)) {
        $GLOBALS["_api"]["restore_details"] = $restore_details;
    }
    if(isset($newstorage)) {
        $GLOBALS["_api"]["newstorage"] = $newstorage;
    }
    if(isset($ajax_user)) {
        $GLOBALS["_api"]["ajax_user"] = $ajax_user;
    }
    if(isset($updated_ips)) {
        $GLOBALS["_api"]["updated_ips"] = $updated_ips;
    }
    if(isset($bus_driver)) {
        $GLOBALS["_api"]["bus_driver"] = $bus_driver;
    }
    if(isset($has_backuply)) {
        $GLOBALS["_api"]["has_backuply"] = $has_backuply;
    }
}

?>