<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "inc.php";
global $error;
global $mail_error_log;
global $servers;
global $globals;
define("INITIATE_REVERSE_SYNC", 1);
if(empty($globals["backup_queue"])) {
    $globals["backup_queue"] = 1;
}
if(!load_lang("admin/backup_plans")) {
    exit("ERROR: Could not load languages\n");
}
$arguments = getopt("a:b:f");
if(count($arguments) == 0) {
    $err = "Missing mandatory arguments. Either <actid> or <backup-plan-id> is required\n\nUsage: /usr/local/emps/bin/php /usr/local/virtualizor/scripts/vpsbackups_plan.php -a<actid> -b<backup-plan-id> [options]\n\nOptions:\n\t-f\tForce backup even if backup plan is disabled\n";
    exit($err);
}
$actid = $arguments["a"];
$bpid = $arguments["b"];
$force = isset($arguments["f"]);
echo "ACTID: " . $actid . "\n";
echo "Backup Plan ID: " . $bpid . "\n";
if(empty($actid) && empty($bpid)) {
    exit($l["log_err_missing_args"] . "\n");
}
if(!empty($bpid)) {
    $php_bin = preg_quote($globals["com"]["php"]);
    $script_name = preg_quote(__FILE__);
    vexec("/bin/ps -e -o cmd | grep -E \"^" . $php_bin . "\\s+" . $script_name . ".+\\-b" . $bpid . "(\\s|\$)\"", $out);
    if(1 < count($out)) {
        exit($l["log_err_bkup_running"] . "\n");
    }
    if(empty($force)) {
        $res = makequery("SELECT disabled FROM backup_plans WHERE bpid = :bpid", [":bpid" => $bpid]);
        if(vsql_num_rows($res) == 0) {
            exit($l["log_err_bkup_plan"] . "\n");
        }
        $row = vsql_fetch_assoc($res);
        if(!empty($row["disabled"])) {
            exit($l["log_bkup_disabled"] . "\n");
        }
    }
    echo "Finding VPS for backup plan id: " . $bpid . "\n";
    $res = makequery("SELECT v.vpsid FROM vps v\n\t\t\t\t\t\tLEFT JOIN plans p ON p.plid = v.plid\n\t\t\t\t\t\tWHERE (v.bpid = :bpid OR (v.bpid = -1 AND p.bpid = :bpid))\n\t\t\t\t\t\tAND v.serid = 0", [":bpid" => $bpid]);
    echo "Found " . vsql_num_rows($res) . " VPS" . "\n";
    if(vsql_num_rows($res) == 0) {
        exit($l["log_err_no_vps_backup"] . "\n");
    }
    $tot_vps = vsql_num_rows($res);
    $bkup_actid = tasks_admin_process("vpsbackups_plan_email", ["total_vps" => $tot_vps, "done_vps" => [], "last_updated" => time(), "pid" => ["master" => getmypid()]], 0, 0, 0, 0, 0);
    task_start($bkup_actid);
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $vpsid = $row["vpsid"];
        if($globals["backup_queue"] != -1) {
            while (true) {
                $running = get_running_tasks(0, ["vpsbackups_plan"]);
                if($globals["backup_queue"] <= $running) {
                    echo lang_vars_name($l["log_sleeping"], ["duration" => "5 seconds"]) . "\n";
                    sleep(5);
                    break;
                }
                echo lang_vars_name($l["log_tasks_running"], ["num" => $running, "max" => $globals["backup_queue"]]) . "\n";
                echo $l["log_running"] . "\n";
            }
        }
        $actid = tasks_admin_process("vpsbackups_plan", ["bpid" => $bpid, "bkup_actid" => $bkup_actid], 0, $vpsid, 0, 0, 0);
        $vps = getvps($vpsid);
        $lock_vps = 0;
        if($vps["virt"] == "kvm" && !empty($vps["disks"])) {
            foreach ($vps["disks"] as $vpsdisk) {
                if(preg_match("/file/is", $vpsdisk["type"])) {
                    $lock_vps = 1;
                }
            }
        }
        if($lock_vps) {
            lockvps($vpsid, $l["vm_locked_backup"]);
            if(is_slave()) {
                to_master("vps", "locked", $vpsid, "vpsid", serialize(["time" => time(), "reason" => $l["vm_locked_backup"]]));
                initiate_reverse_sync();
            }
        }
        echo "Starting backup of VPS " . $vpsid . " with Actid " . $actid . "\n";
        vexec($globals["com"]["php"] . " /usr/local/virtualizor/scripts/vpsbackups_plan.php -a" . $actid . " " . (!empty($force) ? "-f " : "") . "> " . logdir("backup") . $vpsid . ".log 2>&1 &");
        sleep(1);
    }
    exit;
}
$res = makequery("SELECT * FROM tasks\n\t\t\t\t\tWHERE actid = :actid", [":actid" => $actid]);
if(vsql_num_rows($res) == 0) {
    exit($l["log_err_no_task"]);
}
$task = vsql_fetch_assoc($res);
$vpsid = $task["vpsid"];
$data = _unserialize($task["data"]);
$bkup_actid = $data["bkup_actid"];
if(!empty($bkup_actid)) {
    $bres = makequery("SELECT * FROM tasks WHERE actid = :actid", [":actid" => $bkup_actid]);
    $bkup_task = vsql_fetch_assoc($bres);
    $bkup_data = unserialize($bkup_task["data"]);
    if(!empty($bkup_data)) {
        $bkup_data["pid"][$vpsid] = getmypid();
        task_update($bkup_actid, "", 0, $bkup_data);
    }
}
$vps = getvps($vpsid);
if(empty($vps)) {
    task_update($actid, $l["log_err_no_vps_backup"], -1);
    send_error_mail($l["log_err_no_vps_backup"]);
    exit($l["log_err_no_vps_backup"] . "\n");
}
if(empty($vps["locked"])) {
    $lock_vps = 0;
    if($vps["virt"] == "kvm" && !empty($vps["disks"])) {
        foreach ($vps["disks"] as $vpsdisk) {
            if(preg_match("/file/is", $vpsdisk["type"])) {
                $lock_vps = 1;
            }
        }
    }
    if($lock_vps) {
        lockvps($vpsid, $l["vm_locked_backup"]);
        if(is_slave()) {
            to_master("vps", "locked", $vpsid, "vpsid", serialize(["time" => time(), "reason" => $l["vm_locked_backup"]]));
            initiate_reverse_sync();
        }
    }
}
$vps["num_ips6"] = 0;
$vps["num_ips6_subnet"] = $vps["num_ips6"];
$vps["num_ips_int"] = $vps["num_ips6_subnet"];
$vps["num_ips"] = $vps["num_ips_int"];
$res = makequery("SELECT i.*, ip.*, i.ipv6 FROM `ips` i\n\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vpsid]);
for ($i = 0; $i < vsql_num_rows($res); $i++) {
    $row = vsql_fetch_assoc($res);
    if(!empty($row["internal"])) {
        $vps["num_ips_int"]++;
    } elseif(empty($row["ipv6"])) {
        $vps["num_ips"]++;
    } elseif(!empty($row["ipv6"]) && !empty($row["ipr_netmask"])) {
        $vps["num_ips6_subnet"]++;
    } elseif(!empty($row["ipv6"])) {
        $vps["num_ips6"]++;
    }
}
$GLOBALS["lvname"] = "backup-" . $vps["vpsid"];
$data["lv"] = $GLOBALS["lvname"];
$data["pid"] = getmypid();
$data["virt"] = $vps["virt"];
task_update($actid, "", 0, $data);
if(!empty($task["uid"])) {
    $res = makequery("SELECT email FROM users WHERE uid = :uid", [":uid" => $task["uid"]]);
    $row = vsql_fetch_assoc($res);
    $task["email"] = $row["email"];
} else {
    $task["email"] = empty($globals["backup_email"]) ? $globals["soft_email"] : $globals["backup_email"];
}
$backup_plan = get_backup_plan($vpsid);
if(empty($backup_plan) || empty($force) && !empty($backup_plan["disabled"])) {
    $err_msg = empty($backup_plan) ? $l["log_err_bkup_plan"] : $l["log_bkup_disabled"];
    task_update($actid, $err_msg, -1);
    send_error_mail($err_msg);
    exit($err_msg . "\n");
}
$backup_plan["bs_servergroups"] = _unserialize($backup_plan["bs_servergroups"]);
$dir = $backup_plan["dir"];
$backup_server = [];
$sgid = $servers[0]["sgid"];
$bid = $backup_plan["bid"];
if(!empty($backup_plan["bs_servergroups"]["bs_groups"][$sgid])) {
    $bid = $backup_plan["bs_servergroups"]["bs_groups"][$sgid];
}
if(!empty($backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]])) {
    $bid = $backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]];
}
if($bid == -1) {
    $bid = 0;
}
$res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
if(0 < vsql_num_rows($res)) {
    $backup_server = vsql_fetch_assoc($res);
}
$arch = server_os_arch(0);
if(!empty($backup_server) && $arch == 32) {
    task_update($actid, $l["log_err_unsupported_arch"], -1);
    send_error_mail($l["log_err_unsupported_arch"]);
    exit($l["log_err_unsupported_arch"] . "\n");
}
if(!empty($backup_plan["enable_enduser_backup_servers"])) {
    $res = makequery("SELECT * FROM enduser_backup_servers WHERE bserid = :bserid", [":bserid" => $vps["bserid"]]);
    if(0 < vsql_num_rows($res)) {
        $row = vsql_fetch_assoc($res);
        $backup_server = array_replace($backup_server, $row);
        $dir = $backup_server["dir"];
    }
}
if(!empty($backup_plan["bs_servergroups"]["dir_groups"][$sgid])) {
    $dir = $backup_plan["bs_servergroups"]["dir_groups"][$sgid];
}
if(!empty($backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]])) {
    $dir = $backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]];
}
$tmp = trim(cleanpath($dir));
if(empty($tmp) || $tmp == "/") {
    task_update($actid, $l["log_err_backup_dir_empty"], -1);
    send_error_mail($l["log_err_backup_dir_empty"]);
    exit($l["log_err_backup_dir_empty"] . "\n");
}
proc_nice((int) $backup_plan["nice"]);
vexec("/usr/bin/ionice -c " . (int) $backup_plan["ionice_class"] . " -n " . (int) $backup_plan["ionice_prio"] . " -p " . getmypid());
$stid = storage_get_primary($vps["virt"]);
install_compression_algo();
if(empty($force)) {
    $backup_plan_data = $backup_plan["data"];
    if(!empty($backup_plan_data["disable_suspended_vm"])) {
        $vps_status = $kernel->vps_status_statewise($vpsid);
        if(!empty($vps["suspended"]) || $vps_status == 2) {
            task_update($actid, $l["log_err_vps_suspended"], 100);
            return false;
        }
    }
}
$result = bg_vpsbackups();
if(($type == "FTP" || $type == "SSH") && empty($globals["temporary_st_directory"]) && empty($do_not_create_tmp)) {
    echo $l["log_cleaning"] . "\n";
    $vps = getvps($task["vpsid"]);
    foreach ($vps["disks"] as $vk => $vv) {
        foreach ($storages as $sk => $sv) {
            if($vv["st_uuid"] == $sv["st_uuid"]) {
                if($vps["virt"] == "proxk" && 0 < $vv["num"] || $kernel->features("disk_hotplug", $vps["virt"]) && !empty($vv["user_uid"]) && empty($vv["primary"])) {
                } else {
                    cleanup_temp_storage($sv["stid"], $GLOBALS["lvname"] . "-" . $vv["num"], "backup", $vps["virt"], $vps["vpsid"], $vv["path"]);
                }
            }
        }
    }
}
if($result) {
    task_update($actid, "", 100);
    if($task["uid"] == $vps["uid"] || empty($globals["backup_disable_success_mail"])) {
        send_success_mail($task["email"]);
    } else {
        unlockvps($vps["vpsid"]);
        if(is_slave()) {
            to_master("vps", "locked", $vps["vpsid"], "vpsid", "");
            initiate_reverse_sync();
        }
    }
} else {
    echo $l["log_err_backup_end"] . "\n";
    $error_log = implode("\n", $mail_error_log);
    send_error_mail($error_log);
}
if(!empty($error)) {
    echo "Errors: \n";
    r_print($error);
}
if(defined("debug")) {
    r_print($GLOBALS["logr"]);
}
function bg_vpsbackups()
{
    global $globals;
    global $kernel;
    global $servers;
    global $l;
    global $error;
    global $mail_error_log;
    global $vps;
    global $backup_plan;
    global $backup_server;
    global $dir;
    global $actid;
    global $task;
    global $type;
    global $do_not_create_tmp;
    global $bid;
    global $cluster;
    global $disks;
    global $backup_folder;
    global $bkup_data;
    global $bkup_actid;
    echo $l["log_scanning"] . "\n";
    while (true) {
        task_update($actid, $l["log_checking_tasks"], 0);
        echo $l["log_checking_tasks"] . "\n";
        $running = get_running_tasks($actid, ["vpsbackups_plan", "restorevps_plan"], $vps["vpsid"], "cleanup_backup");
        if(0 < $running) {
            echo $l["log_vps_tasks_running"] . "\n";
            echo lang_vars_name($l["log_sleeping"], ["duration" => "5 seconds"]) . "\n";
            task_update($actid, $l["in_queue"], 0);
            sleep(5);
            break;
        }
        if($globals["backup_queue"] == -1) {
            task_update($actid, $l["log_running"], 0);
        } else {
            $running = get_running_tasks($actid, ["vpsbackups_plan"], 0, "cleanup_backup");
            if($globals["backup_queue"] <= $running) {
                task_update($actid, $l["in_queue"], 0);
                echo lang_vars_name($l["log_sleeping"], ["duration" => "5 seconds"]) . "\n";
                sleep(5);
            } else {
                task_update($actid, $l["log_running"], 0);
                echo lang_vars_name($l["log_tasks_running"], ["num" => $running, "max" => $globals["backup_queue"]]) . "\n";
                echo $l["log_running"] . "\n";
            }
        }
    }
    task_start($actid);
    $script_tstart = microtime(true);
    echo $l["log_start_backup"] . "\n";
    $virt = $vps["virt"];
    if($kernel->features("disks_support", $vps["virt"]) && $vps["virt"] != "proxk") {
        foreach ($vps["disks"] as $k => $v) {
            if($kernel->features("disk_hotplug", $vps["virt"]) && !empty($v["user_uid"]) && empty($v["primary"])) {
                unset($vps["disks"][$k]);
            }
        }
        $disks = $vps["disks"];
    } else {
        $disks = [["size" => $vps["space"], "num" => 0]];
    }
    if(!empty($temp_backup_dir)) {
        echo "Temp Dir : " . $temp_backup_dir . "\n";
    }
    $type = empty($backup_server) ? "LOCAL" : $backup_server["type"];
    echo $l["log_backup_type"] . $type . "\n";
    $disks = array_filter($disks, function ($disk) {
        global $vps;
        $is_swap = preg_match("/" . $vps["vps_name"] . "(_swap|swap)/is", $disk["path"]);
        return empty($is_swap);
    });
    $GLOBALS["backup_file_time"] = date("Y_m_d-H_i_s", time());
    $inf_file_name = get_inf_name($vps);
    if($type == "FTP") {
        echo $l["log_connect"] . "\n";
        task_update($actid, $l["log_connect"], 10);
        $ftp_con = connect_ftp($backup_server);
        if(!$ftp_con) {
            $err_msg = $l["log_err_ftp_connect"] . "\n" . print_r(error_get_last(), 1);
            echo $err_msg . "\n";
            $mail_error_log[] = $err_msg;
            task_update($actid, $err_msg, -1);
            return false;
        }
        echo $l["log_create_backup_folder"] . "\n";
        task_update($actid, $l["log_create_backup_folder"], 15);
        $backup_folder = create_backup_folders2($ftp_con, $dir, $vps["vpsid"]);
        if(empty($backup_folder)) {
            $err = $l["log_err_create_backup_folder"] . "(" . implode(" . ", $error) . ")";
            echo $err . "\n";
            $mail_error_log[] = $err;
            task_update($actid, $l["log_err_create_backup_folder"], -1);
            return false;
        }
        $prog_step = floor(70 / (count($disks) * 2));
        $prog = 20;
        foreach ($disks as $k => $disk) {
            if(!empty($backup_plan["data"]["backup_primary"]) && 0 < $disk["num"]) {
            } else {
                ftp_close($ftp_con);
                if(!empty($globals["temporary_st_directory"]) && is_dir($globals["temporary_st_directory"])) {
                    $temp_backup_dir = $globals["temporary_st_directory"];
                } else {
                    $temp_backup_dir = tmp_storage_as_per_disk($disk);
                }
                if(!empty($do_not_create_tmp)) {
                    $temp_backup_dir = dirname($disk["path"]);
                    echo "Temp Dir : " . $temp_backup_dir . "\n";
                }
                if(empty($temp_backup_dir)) {
                    task_update($actid, "", -1);
                    return false;
                }
                echo $l["log_create_backup"] . ($disk["num"] + 1) . " [Size: " . $disk["size"] . "GB]\n";
                task_update($actid, $l["log_create_backup"] . ($disk["num"] + 1) . " [Size: " . $disk["size"] . "GB]", $prog);
                if(empty($do_not_create_tmp)) {
                    $temp_bk_name = $kernel->backup($vps, $temp_backup_dir, $backup_plan["disable_compression"], $disk["num"], $backup_plan["io_limit"]);
                } else {
                    $append = empty($disk["num"]) ? "" : "_" . $disk["num"];
                    $append .= "_" . parse_backup_hostname($vps["hostname"]);
                    $DISK = get_vps_disk($vps["vpsid"], "", $disk["num"]);
                    $temp_bk_name = $vps["vpsid"] . $append . "." . ($DISK["format"] == "qcow2" ? "qcow2" : "img");
                }
                $prog += $prog_step;
                if(empty($temp_bk_name)) {
                    $err = $l["log_err_create_backup"] . " (" . implode(" . ", $error) . ")";
                    $mail_error_log[] = $err;
                    echo $err . "\n";
                    task_update($actid, $err, -1);
                    return false;
                }
                echo $l["log_vps_backup_done"] . "\n";
                task_update($actid, $l["log_vps_backup_done"], $prog);
                $ftp_con = connect_ftp($backup_server);
                if(!$ftp_con) {
                    $err_msg = $l["log_err_ftp_connect"] . "\n" . print_r(error_get_last(), 1);
                    $mail_error_log[] = $err_msg;
                    echo $err_msg . "\n";
                    task_update($actid, $err_msg, -1);
                    return false;
                }
                echo $l["log_upload"] . "\n";
                task_update($actid, $l["log_upload"], $prog);
                if(!empty($do_not_create_tmp)) {
                    $local_dir = $disk["path"];
                } else {
                    $local_dir = $temp_backup_dir . "/" . $temp_bk_name;
                }
                $remote_dir = $backup_folder . "/" . $temp_bk_name;
                if(!ftp_put($ftp_con, $remote_dir, $local_dir, FTP_BINARY)) {
                    ftp_close($ftp_con);
                    $ftp_con = connect_ftp($backup_server);
                    if(!$ftp_con) {
                        $err_msg = $l["log_err_ftp_connect"] . "\n" . print_r(error_get_last(), 1);
                        $mail_error_log[] = $err_msg;
                        echo $err_msg . "\n";
                        task_update($actid, $err_msg, -1);
                        return false;
                    }
                    if(!ftp_put($ftp_con, $remote_dir, $local_dir, FTP_BINARY)) {
                        $err = $l["log_err_upload"] . "\n" . print_r(error_get_last(), 1);
                        echo $err . "\n";
                        $mail_error_log[] = $err;
                        $date = basename($backup_folder);
                        @$cluster->delete_vps_backups2(0, $bid, $dir, $date, [$temp_bk_name]);
                        task_update($actid, $err, -1);
                        return false;
                    }
                }
                ftp_close($ftp_con);
                $ftp_con = connect_ftp($backup_server);
                if(!$ftp_con) {
                    $err_msg = $l["log_err_ftp_connect"] . "\n" . print_r(error_get_last(), 1);
                    $mail_error_log[] = $err_msg;
                    echo $err_msg . "\n";
                    task_update($actid, $err_msg, -1);
                    return false;
                }
                $local_size = vfilesize($local_dir);
                sleep(10);
                $remote_size = ftp_size($ftp_con, $backup_folder . "/" . $temp_bk_name);
                echo $l["log_local_file_size"] . $local_size . "\n";
                echo $l["log_remote_file_size"] . $remote_size . "\n";
                if(empty($globals["disable_integrity_check"]) && $remote_size != $local_size) {
                    echo $l["log_err_bkup_integrity"] . "\n";
                    $mail_error_log[] = $l["log_err_bkup_integrity"];
                    task_update($actid, $l["log_err_bkup_integrity"], -1);
                    $date = basename($backup_folder);
                    @$cluster->delete_vps_backups2(0, $bid, $dir, $date, [$temp_bk_name]);
                    return false;
                }
                $file_del = cleanpath($temp_backup_dir . "/" . $temp_bk_name);
                if(!empty($file_del) && $file_del != "/") {
                    unlink($file_del);
                }
                $prog += $prog_step;
                $local_inf = dirname($disk["path"]);
            }
        }
        if(!empty($do_not_create_tmp)) {
            $vps_data = serialize($vps);
            writefile($local_inf . "/" . $inf_file_name, $vps_data, 1);
            $local_inf = $local_inf . "/" . $inf_file_name;
        } else {
            $local_inf = $temp_backup_dir . "/" . $inf_file_name;
        }
        $remote_inf = $backup_folder . "/" . $inf_file_name;
        ftp_close($ftp_con);
        $ftp_con = connect_ftp($backup_server);
        if(!$ftp_con) {
            $err_msg = $l["log_err_ftp_connect"] . "\n" . print_r(error_get_last(), 1);
            $mail_error_log[] = $err_msg;
            echo $err_msg . "\n";
            task_update($actid, $err_msg, -1);
            return false;
        }
        if(!ftp_put($ftp_con, $remote_inf, $local_inf, FTP_BINARY)) {
            ftp_close($ftp_con);
            $ftp_con = connect_ftp($backup_server);
            if(!$ftp_con) {
                $err_msg = $l["log_err_ftp_connect"] . "\n" . print_r(error_get_last(), 1);
                $mail_error_log[] = $err_msg;
                echo $err_msg . "\n";
                task_update($actid, $err_msg, -1);
                return false;
            }
            if(!ftp_put($ftp_con, $remote_inf, $local_inf, FTP_BINARY)) {
                $err = $l["log_err_inf_upload"] . "\n" . print_r(error_get_last(), 1);
                echo $err . "\n";
                $mail_error_log[] = $err;
                task_update($actid, $err, -1);
                $date = basename($backup_folder);
                @$cluster->delete_vps_backups2(0, $bid, $dir, $date, [$temp_bk_name]);
                return false;
            }
        }
        if(!empty($backup_plan["rotation"])) {
            apply_rotation_ftp($ftp_con, $vps["vpsid"], $dir, $backup_plan["rotation"]);
        }
        ftp_close($ftp_con);
    } elseif($type == "SSH") {
        echo $l["log_connect"] . "\n";
        task_update($actid, $l["log_connect"], 10);
        $creds = ["server" => $backup_server["hostname"], "port" => $backup_server["port"], "user" => $backup_server["username"], "pass" => $backup_server["password"], "salt" => $backup_server["salt"]];
        $connection = connect_ssh($backup_server);
        if(!$connection) {
            $err_msg = $l["log_err_ssh_conn"] . "\n" . print_r(error_get_last(), 1);
            echo $err_msg . "\n";
            $mail_error_log[] = $err_msg;
            task_update($actid, $err_msg, -1);
            return false;
        }
        echo $l["log_create_backup_folder"] . "\n";
        task_update($actid, $l["log_create_backup_folder"], 15);
        $back_path = create_ssh_backup_folders2($connection, $dir, $vps["vpsid"]);
        if(empty($back_path)) {
            $err = $l["log_err_create_backup_folder"] . "(" . implode(" . ", $error) . ")";
            echo $err . "\n";
            $mail_error_log[] = $err;
            task_update($actid, $l["log_err_create_backup_folder"], -1);
            return false;
        }
        $prog_step = floor(70 / (count($disks) * 2));
        $prog = 20;
        foreach ($disks as $k => $disk) {
            if(!empty($backup_plan["data"]["backup_primary"]) && 0 < $disk["num"]) {
            } else {
                ssh2_exec($connection, "exit");
                unset($connection);
                if(!empty($globals["temporary_st_directory"]) && is_dir($globals["temporary_st_directory"])) {
                    $temp_backup_dir = $globals["temporary_st_directory"];
                } else {
                    $temp_backup_dir = tmp_storage_as_per_disk($disk);
                }
                if(!empty($do_not_create_tmp)) {
                    $temp_backup_dir = dirname($disk["path"]);
                    echo "Temp Dir : " . $temp_backup_dir . "\n";
                }
                if(empty($temp_backup_dir)) {
                    task_update($actid, "", -1);
                    return false;
                }
                echo $l["log_create_backup"] . ($disk["num"] + 1) . " [Size: " . $disk["size"] . "GB]\n";
                task_update($actid, $l["log_create_backup"] . ($disk["num"] + 1) . " [Size: " . $disk["size"] . "GB]", $prog);
                if(empty($do_not_create_tmp)) {
                    $temp_bk_name = $kernel->backup($vps, $temp_backup_dir, $backup_plan["disable_compression"], $disk["num"], $backup_plan["io_limit"]);
                } else {
                    $append = empty($disk["num"]) ? "" : "_" . $disk["num"];
                    $append .= "_" . parse_backup_hostname($vps["hostname"]);
                    $DISK = get_vps_disk($vps["vpsid"], "", $disk["num"]);
                    $temp_bk_name = $vps["vpsid"] . $append . "." . ($DISK["format"] == "qcow2" ? "qcow2" : "img");
                }
                if(empty($temp_bk_name)) {
                    $err = $l["log_err_create_backup"] . "(" . implode(" . ", $error) . ")";
                    echo $err . "\n";
                    $mail_error_log[] = $err;
                    task_update($actid, $l["log_err_create_backup"], -1);
                    return false;
                }
                $prog += $prog_step;
                echo $l["log_vps_backup_done"] . "\n";
                task_update($actid, $l["log_vps_backup_done"], $prog);
                unset($connection);
                $connection = connect_ssh($backup_server);
                if(!$connection) {
                    $err_msg = $l["log_err_ssh_conn"] . "\n" . print_r(error_get_last(), 1);
                    $mail_error_log[] = $err_msg;
                    echo $err_msg . "\n";
                    task_update($actid, $err_msg, -1);
                    return false;
                }
                echo $l["log_upload"] . "\n";
                task_update($actid, $l["log_upload"], $prog);
                if(!empty($do_not_create_tmp)) {
                    $local_dir = $disk["path"];
                } else {
                    $local_dir = $temp_backup_dir . "/" . $temp_bk_name;
                }
                $remote_dir = $back_path . "/" . $temp_bk_name;
                if(!ssh2_scp_send($connection, $local_dir, $remote_dir)) {
                    $error_scp = print_r(error_get_last(), 1);
                    $result = v_sftp_cmd($creds, "put", xss($local_dir) . " " . xss($remote_dir));
                    if(!empty($result["error"]) || empty($result)) {
                        $result["error"] = $error_scp . "\n" . $result["error"];
                        $err = $l["log_err_ssh_send"] . "\n" . $result["error"];
                        echo $err . "\n";
                        $mail_error_log[] = $err;
                        $date = basename($backup_folder);
                        @$cluster->delete_vps_backups2(0, $bid, $dir, $date, [$temp_bk_name]);
                        task_update($actid, $err, -1);
                        return false;
                    }
                }
                sleep(3);
                unset($connection);
                $connection = connect_ssh($backup_server);
                if(!$connection) {
                    $err_msg = $l["log_err_ssh_conn"] . "\n" . print_r(error_get_last(), 1);
                    $mail_error_log[] = $err_msg;
                    echo $err_msg . "\n";
                    task_update($actid, $err_msg, -1);
                    return false;
                }
                $sftp = ssh2_sftp($connection);
                $statinfo = ssh2_sftp_stat($sftp, $remote_dir);
                $remote_size = $statinfo["size"];
                $local_size = vfilesize($local_dir);
                echo $l["log_local_file_size"] . $local_size . "\n";
                echo $l["log_remote_file_size"] . $remote_size . "\n";
                if(empty($globals["disable_integrity_check"]) && $remote_size != $local_size) {
                    echo $l["log_err_bkup_integrity"] . "\n";
                    $mail_error_log[] = $l["log_err_bkup_integrity"];
                    task_update($actid, $l["log_err_bkup_integrity"], -1);
                    $date = basename($back_path);
                    @$cluster->delete_vps_backups2(0, $bid, $dir, $date, [$temp_bk_name]);
                    return false;
                }
                $file_del = cleanpath($temp_backup_dir . "/" . $temp_bk_name);
                if(!empty($file_del) && $file_del != "/") {
                    unlink($file_del);
                }
                $prog += $prog_step;
                $local_inf = dirname($disk["path"]);
            }
        }
        if(!empty($do_not_create_tmp)) {
            $vps_data = serialize($vps);
            writefile($local_inf . "/" . $inf_file_name, $vps_data, 1);
            $local_inf = $local_inf . "/" . $inf_file_name;
        } else {
            $local_inf = $temp_backup_dir . "/" . $inf_file_name;
        }
        $remote_inf = $back_path . "/" . $inf_file_name;
        unset($connection);
        $connection = connect_ssh($backup_server);
        if(!$connection) {
            $err_msg = $l["log_err_ssh_conn"] . "\n" . print_r(error_get_last(), 1);
            $mail_error_log[] = $err_msg;
            echo $err_msg . "\n";
            task_update($actid, $err_msg, -1);
            return false;
        }
        if(!ssh2_scp_send($connection, $local_inf, $remote_inf)) {
            $error_scp = print_r(error_get_last(), 1);
            $result = v_sftp_cmd($creds, "put", xss($local_inf) . " " . xss($remote_inf));
            if(!empty($result["error"]) || empty($result)) {
                $result["error"] = $error_scp . "\n" . $result["error"];
                $err = $l["log_err_inf_upload"] . "\n" . $result["error"];
                echo $err . "\n";
                $mail_error_log[] = $err;
                task_update($actid, $err, -1);
                $date = basename($back_path);
                @$cluster->delete_vps_backups2(0, $bid, $dir, $date, [$temp_bk_name]);
                return false;
            }
        }
        if(!empty($backup_plan["rotation"])) {
            apply_rotation_ssh($connection, $vps["vpsid"], $dir, $backup_plan["rotation"]);
        }
        ssh2_exec($connection, "exit");
        unset($connection);
    } elseif($type == "LOCAL") {
        echo $l["log_create_backup_folder"] . "\n";
        task_update($actid, $l["log_create_backup_folder"], 15);
        $backup_folder = create_local_backup_folders2($dir, $vps["vpsid"]);
        if(empty($backup_folder)) {
            $err = $l["log_err_create_backup_folder"] . " (" . implode(" . ", $error) . ")";
            echo $err . "\n";
            $mail_error_log[] = $err;
            task_update($actid, $l["log_err_create_backup_folder"], -1);
            return false;
        }
        $prog_step = floor(70 / count($disks));
        $prog = 20;
        foreach ($disks as $k => $disk) {
            if(!empty($backup_plan["data"]["backup_primary"]) && 0 < $disk["num"]) {
            } else {
                $temp_backup_dir = tmp_storage_as_per_disk($disk);
                if(empty($temp_backup_dir)) {
                    task_update($actid, "", -1);
                    return false;
                }
                echo $l["log_create_backup"] . ($disk["num"] + 1) . " [Size: " . $disk["size"] . "GB]\n";
                task_update($actid, $l["log_create_backup"] . ($disk["num"] + 1) . " [Size: " . $disk["size"] . "GB]", $prog);
                if(empty($do_not_create_tmp)) {
                    $temp_bk_name = $kernel->backup($vps, $temp_backup_dir, $backup_plan["disable_compression"], $disk["num"], $backup_plan["io_limit"]);
                } else {
                    $append = empty($disk["num"]) ? "" : "_" . $disk["num"];
                    $append .= "_" . parse_backup_hostname($vps["hostname"]);
                    $DISK = get_vps_disk($vps["vpsid"], "", $disk["num"]);
                    $temp_bk_name = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . "." . ($DISK["format"] == "qcow2" ? "qcow2" : "img");
                    $remote_dir = $backup_folder . "/" . $temp_bk_name;
                    $local_dir = $disk["path"];
                    if(empty($backup_plan["disable_compression"])) {
                        @vexec($globals["com"]["pgzip"] . " -c " . @xss($local_dir) . " > " . @xss($remote_dir . ".gz") . "  2>&1", $cpout, $cpret);
                    } else {
                        @vexec("cp " . $local_dir . " " . $remote_dir, $cpout, $cpret);
                    }
                    if($cpret) {
                        $error[] = print_r($cpout, 1) . "\nRET: " . $cpret;
                    }
                }
                if(empty($temp_bk_name)) {
                    $err = $l["log_err_create_backup"] . "(" . implode(" . ", $error) . ")";
                    echo $err . "\n";
                    $mail_error_log[] = $err;
                    task_update($actid, $l["log_err_create_backup"], -1);
                    return false;
                }
                $prog += $prog_step;
                echo $l["log_vps_backup_done"] . "\n";
                task_update($actid, $l["log_vps_backup_done"], $prog);
                $local_inf = dirname($disk["path"]);
            }
        }
        if(!empty($do_not_create_tmp)) {
            sleep(1);
            $vps_data = serialize($vps);
            writefile($backup_folder . "/" . $inf_file_name, $vps_data, 1);
        }
        $remote_inf = $backup_folder . "/" . $inf_file_name;
        if($vps["virt"] == "openvz") {
            @rename($temp_backup_dir . "/" . $temp_bk_name, $backup_folder . "/" . $temp_bk_name);
            $local_inf = $temp_backup_dir . "/" . $inf_file_name;
            @rename($local_inf, $remote_inf);
            if(file_exists($temp_backup_dir . "/" . $temp_bk_name)) {
                echo $l["log_err_local_move_backup"] . "\n";
                $mail_error_log[] = $l["log_err_local_move_backup"];
            }
        }
        if(in_array($vps["virt"], ["proxk", "proxl"])) {
            $log_files = glob($backup_folder . "/*.log");
            if(!empty($log_files)) {
                foreach ($log_files as $lfile) {
                    @unlink($lfile);
                }
            }
        }
        if(!empty($backup_plan["rotation"])) {
            apply_rotation_local($vps["vpsid"], $dir, $backup_plan["rotation"]);
        }
    }
    if(!empty($mail_error_log)) {
        task_update($actid, implode(", ", array_values($mail_error_log)), -1);
        return false;
    }
    if(file_exists($local_inf) && preg_match("/.inf\$/i", $local_inf) && $type != "LOCAL") {
        $inftype = shell_exec("file " . xss($local_inf));
        if(preg_match("/ASCII text/i", $inftype)) {
            unlink($local_inf);
        }
    }
    $script_tend = microtime(true);
    $script_elapsed = $script_tend - $script_tstart;
    echo $l["log_vps_backup_script_done"] . ": " . round($script_elapsed / 60, 1) . " minutes\n";
    task_update($actid, $l["log_vps_backup_script_done"] . ": " . round($script_elapsed / 60, 1) . " minutes", 90);
    return true;
}
function check_backup_mail(&$has_master_script)
{
    global $vps;
    global $task;
    global $bkup_actid;
    global $bkup_data;
    $data = _unserialize($task["data"]);
    $has_master_script = 1;
    if(empty($bkup_actid)) {
        $has_master_script = 0;
        return true;
    }
    $bkup_data["done_vps"][] = $vps["vpsid"];
    $bkup_data["done_vps"] = array_unique($bkup_data["done_vps"]);
    $bkup_data["last_updated"] = time();
    task_update($bkup_actid, "", 0, $bkup_data);
    if($bkup_data["total_vps"] == count($bkup_data["done_vps"])) {
        return true;
    }
    return false;
}
function send_backup_mail($key, $email, $_vars = [])
{
    global $l;
    global $globals;
    global $vps;
    global $task;
    global $bkup_actid;
    global $cluster;
    $task_data = _unserialize($task["data"]);
    $vars = ["sn" => $globals["sn"], "vpsid" => $vps["vpsid"], "hostname" => $vps["hostname"], "vps_name" => $vps["vps_name"], "server_ip" => server_publicip(0), "server_hostname" => $cluster->hostname(0)];
    if(!empty($_vars)) {
        $vars = array_merge($vars, $_vars);
    }
    $mail_map = [];
    $mail_map["success_mail"] = email_templates("vpsbackups_end");
    $mail_map["error_mail"] = email_templates("vpsbackups_err");
    $put_mail_data = $send_background_mail = false;
    $send_mail = check_backup_mail($has_master_script);
    if($send_mail) {
        if(empty($has_master_script)) {
            if(empty($mail_map[$key]["is_disable"])) {
                $mail[0]["to"] = $email;
                $mail[0]["subject"] = lang_vars_name($mail_map[$key]["title"], $vars);
                $mail[0]["message"] = lang_vars_name($mail_map[$key]["body"], $vars);
                $mail[0]["type"] = $mail_map[$key]["mail_type"];
                $arg = $mail;
                $send_background_mail = true;
            }
        } else {
            $put_mail_data = true;
            $send_background_mail = true;
            $arg = (int) $bkup_actid;
        }
    } else {
        $put_mail_data = true;
    }
    if($put_mail_data) {
        $data = array_merge(["email" => $email], $vars);
        put_mail_data($bkup_actid, $key, $data);
    }
    if($send_background_mail) {
        send_background_mail($arg);
    }
    unlockvps($vps["vpsid"]);
    if(is_slave()) {
        to_master("vps", "locked", $vps["vpsid"], "vpsid", "");
        initiate_reverse_sync();
    }
}
function send_success_mail($email)
{
    global $globals;
    global $l;
    global $vps;
    $site_domain = !empty($globals["site_domain"]) && $globals["site_domain"] != $globals["primary_ip"] ? $l["server_domain"] . $globals["site_domain"] : "";
    send_backup_mail("success_mail", $email, ["primary_ip" => $globals["primary_ip"], "server_domain" => $site_domain]);
}
function send_error_mail($error_log)
{
    global $globals;
    global $l;
    global $vps;
    $site_domain = !empty($globals["site_domain"]) && $globals["site_domain"] != $globals["primary_ip"] ? $l["server_domain"] . $globals["site_domain"] : "";
    $email = empty($globals["backup_email"]) ? $globals["soft_email"] : $globals["backup_email"];
    $site_domain = unhtmlentities($site_domain);
    $vars = ["error_log" => $error_log, "primary_ip" => $globals["primary_ip"], "server_domain" => $site_domain];
    send_backup_mail("error_mail", $email, $vars);
}
function cleanup_backup($task)
{
    global $l;
    global $storages;
    global $kernel;
    $data = _unserialize($task["data"]);
    if(!empty($data["cleaned_up"])) {
        return NULL;
    }
    $virt = $data["virt"];
    list_storages();
    echo $l["log_abortclean"] . " - " . $task["actid"] . "\n";
    $prev_lv = $data["lv"];
    $vps = getvps($task["vpsid"]);
    foreach ($vps["disks"] as $vk => $vv) {
        foreach ($storages as $sk => $sv) {
            if($vv["st_uuid"] == $sv["st_uuid"]) {
                if($vps["virt"] == "proxk" && 0 < $vv["num"] || $kernel->features("disk_hotplug", $vps["virt"]) && !empty($v["user_uid"]) && empty($v["primary"])) {
                } else {
                    cleanup_temp_storage($sv["stid"], $prev_lv . "-" . $vv["num"], "backup", $virt, $task["vpsid"], $vv["path"]);
                }
            }
        }
    }
    $data["cleaned_up"] = true;
    task_update($task["actid"], "", 0, $data);
}
function tmp_storage_as_per_disk($disk)
{
    global $globals;
    global $kernel;
    global $servers;
    global $l;
    global $error;
    global $mail_error_log;
    global $vps;
    global $backup_plan;
    global $backup_server;
    global $dir;
    global $actid;
    global $task;
    global $type;
    global $do_not_create_tmp;
    global $bid;
    global $cluster;
    global $disks;
    global $storages;
    global $backup_folder;
    list_storages();
    $virt = $vps["virt"];
    $is_file_base_backup = 0;
    if($kernel->features("file_backup_support", $vps["virt"])) {
        $qemu_details = get_qemu_details();
        if($disk["type"] == "file") {
            if(version_compare($qemu_details["qemu_ver"], "2.0.0", "<")) {
                echo $l["qemu_file_backup_issue"] . "\n";
                $mail_error_log[] = $l["qemu_file_backup_issue"];
                task_update($actid, $l["qemu_file_backup_issue"], -1);
                return false;
            }
            $is_file_base_backup = 1;
        }
    }
    $vps_status = $kernel->vps_status_statewise($vps["vpsid"]);
    $do_not_create_tmp = 0;
    if(empty($vps_status) && !empty($is_file_base_backup)) {
        $do_not_create_tmp = 1;
    }
    $temp_backup_dir = $backup_folder;
    if(!empty($backup_server)) {
        if($vps["virt"] != "proxk") {
            foreach ($storages as $sk => $sv) {
                if($sv["st_uuid"] == $disk["st_uuid"]) {
                    $stid = $sv["stid"];
                }
            }
        }
        if($vps["virt"] == "proxk") {
            $stid = $GLOBALS["stid"];
        }
        if(!in_array($virt, ["openvz", "vzo", "vzk"])) {
            echo $l["log_createtemp_loc"] . "\n";
            echo "Storage : " . $stid . " LV Name :" . $GLOBALS["lvname"] . "-" . $disk["num"] . "\n";
            if(empty($do_not_create_tmp)) {
                $temp_backup_dir = create_temp_storage($stid, $GLOBALS["lvname"] . "-" . $disk["num"], "backup", $vps["vpsid"], $backup_plan["disable_compression"]);
                if(empty($temp_backup_dir) || !empty($error)) {
                    $err = $l["log_err_createtemp_loc"] . "(" . implode(" . ", $error) . ")";
                    echo $err . "\n";
                    $mail_error_log[] = $err;
                    task_update($actid, $err, -1);
                    echo $l["log_err_cant_proceed"] . "\n";
                    return false;
                }
            }
        } else {
            $temp_backup_dir = "/vz/dump";
            if(!file_exists($temp_backup_dir)) {
                mkdir($temp_backup_dir);
            }
        }
    } elseif($virt == "openvz") {
        $temp_backup_dir = "/vz/dump";
    }
    return $temp_backup_dir;
}

?>