<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function vps_stats()
{
    global $theme;
    global $globals;
    global $kernel;
    global $cluster;
    global $l;
    global $error;
    global $month;
    global $pie_data;
    global $vps_stats;
    global $sort_column;
    global $sort_column_by;
    global $vps_data;
    global $notice;
    if(!load_lang("admin/vps_stats")) {
        return false;
    }
    $theme["init_theme"] = "admin/vps_stats";
    $theme["init_theme_name"] = "vps_stats";
    $theme["init_theme_func"] = ["vps_stats_theme"];
    $theme["call_theme_func"] = "vps_stats_theme";
    $vpsid = (int) optREQ("svs");
    if(!empty($vpsid)) {
        $show = (int) optREQ("show");
        if(!empty($show)) {
            $year_req = substr($show, 0, 4);
            $month_req = substr($show, 4);
        }
        $from = $year_req . $month_req . "010000";
        $lastDate = date("t", strtotime("01-" . $month_req . "-" . $year_req));
        $to = $year_req . $month_req . $lastDate . "2359";
        $validFrom = valid_datetime($from);
        $validTo = valid_datetime($to);
        if(!($validFrom || $validTo)) {
            $from = 0;
            $to = 0;
            $month = get_month();
        } else {
            $month = get_month(["year" => $year_req, "month" => $month_req]);
        }
        $vps_stats = $cluster->monthly_vps_stats($vpsid, $from, $to);
    } else {
        $vpsid = (int) optREQ("vpsid");
        $serid = $globals["server"];
        $show = (int) optREQ("show");
        $where = [];
        $where["serid"] = "serid = " . $serid;
        if(!empty($vpsid)) {
            $vps = getvps($vpsid);
            $where["vpsid"] = "vpsid = " . $vpsid;
            $where["serid"] = "serid = " . $vps["serid"];
            $serid = $vps["serid"];
        }
        $res = makequery("SELECT COUNT(vpsid) AS num FROM vps\n\t\t\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)));
        $globals["cur_page"] = get_page();
        $globals["reslen"] = (int) optREQ("reslen");
        $globals["reslen"] = $globals["reslen"] <= 0 ? 50 : $globals["reslen"];
        $tmp = vsql_fetch_assoc($res);
        $globals["num_res"] = $tmp["num"];
        $res = makequery("SELECT vpsid, vps_name, serid, hostname, virt, cores, speed_cap FROM vps WHERE " . implode(" AND ", $where) . " LIMIT " . $globals["cur_page"] . ", " . $globals["reslen"]);
        if(vsql_num_rows($res) < 1) {
            $notice["no_vps"] = 1;
            return false;
        }
        $_vps_data = [];
        $vs_serid = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs_serid[$row["vpsid"]] = $row["serid"];
            $_vps_data[$row["vpsid"]]["vpsid"] = $row["vpsid"];
            $_vps_data[$row["vpsid"]]["vps_name"] = $row["vps_name"];
            $_vps_data[$row["vpsid"]]["hostname"] = $row["hostname"];
            $_vps_data[$row["vpsid"]]["virt"] = $row["virt"];
            $_vps_data[$row["vpsid"]]["speed_cap"] = $row["speed_cap"];
            $_vps_data[$row["vpsid"]]["cores"] = $row["cores"];
        }
        $sort_column_arr = ["cpu" => "used_cpu", "disk" => "used_disk", "ram" => "used_ram", "inode" => "used_inode", "vpsid" => "vpsid", "net_in" => "net_in", "net_out" => "net_out", "bandwidth" => "used_bandwidth", "io_read" => "io_read", "io_write" => "io_write"];
        $sort_column_by_arr = ["asc" => 0, "desc" => 1];
        if(optREQ("sortcolumn") == "") {
            $sort_column = "vpsid";
            $sort_column_by = empty($globals["enable_idsort"]) ? 0 : 1;
        } else {
            $sort_column = strtolower(optREQ("sortcolumn"));
            $sort_column = !in_array($sort_column, array_keys($sort_column_arr)) ? "vpsid" : $sort_column_arr[$sort_column];
            $sort_column_by = strtolower(optREQ("sortby"));
            $sort_column_by = array_key_exists($sort_column_by, $sort_column_by_arr) ? $sort_column_by_arr[$sort_column_by] : 0;
        }
        if(!empty($vs_serid)) {
            $pie_data["server_bandwidth"] = $cluster->bandwidth($serid, $show);
            $pie_data["server_cpu"] = $cluster->cpu($serid);
            $vps_data = $cluster->get_vps_stats($vs_serid, 1, $show);
            foreach ($vps_data as $k => $v) {
                if($k <= 0) {
                    $pie_data["server_ram"][$k] = $v;
                    unset($vps_data[$k]);
                } else {
                    $vps_data[$k]["vpsid"] = $_vps_data[$k]["vpsid"];
                    $vps_data[$k]["vps_name"] = $_vps_data[$k]["vps_name"];
                    $vps_data[$k]["hostname"] = $_vps_data[$k]["hostname"];
                    $vps_data[$k]["vps_ram_info"] = $kernel->features("vps_ram_info", $_vps_data[$k]["virt"]);
                    $vps_data[$k]["speed_cap"] = implode(",", _unserialize($_vps_data[$k]["speed_cap"]));
                    $vps_data[$k]["cores"] = $_vps_data[$k]["cores"];
                }
            }
            $filters["sort_column"] = $sort_column;
            $filters["sort_column_by"] = $sort_column_by;
            uasort($vps_data, function ($a, $b) {
                if(!empty($filters["sort_column_by"])) {
                    $cmp1 = $a;
                    $cmp2 = $b;
                } else {
                    $cmp1 = $b;
                    $cmp2 = $a;
                }
                if($cmp1[$filters["sort_column"]] == $cmp2[$filters["sort_column"]]) {
                    return 0;
                }
                if($cmp2[$filters["sort_column"]] < $cmp1[$filters["sort_column"]]) {
                    return -1;
                }
                return 1;
            });
            foreach ($vps_data as $k => $v) {
                $tmp_vps_data["K_" . $k] = $v;
            }
            $vps_data = $tmp_vps_data;
            unset($tmp_vps_data);
        }
    }
}
function API_vps_stats()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $month;
    global $pie_data;
    global $vps_stats;
    global $vps_data;
    global $notice;
    $GLOBALS["_api"]["pie_data"] = $pie_data;
    $GLOBALS["_api"]["vps_stats"] = $vps_stats;
    $GLOBALS["_api"]["vps_data"] = $vps_data;
    $GLOBALS["_api"]["month"] = $month;
    $GLOBALS["_api"]["notice"] = $notice;
}
function get_month($data = [])
{
    $month = [];
    if(!empty($data)) {
        $current_month = date("Y-m", strtotime($data["year"] . "-" . $data["month"]));
        $month["current_month"] = str_replace("-", "", $current_month);
        $prev_month = date("Y-m", strtotime("-1 month", strtotime($data["year"] . "-" . $data["month"])));
        $month["prev_month"] = str_replace("-", "", $prev_month);
        $next_month = date("Y-m", strtotime("+1 month", strtotime($data["year"] . "-" . $data["month"])));
        $month["next_month"] = str_replace("-", "", $next_month);
    } else {
        $current_month = date("Y-m");
        $month["current_month"] = str_replace("-", "", $current_month);
        $prev_month = date("Y-m", strtotime("-1 month"));
        $month["prev_month"] = str_replace("-", "", $prev_month);
        $next_month = date("Y-m", strtotime("+1 month"));
        $month["next_month"] = str_replace("-", "", $next_month);
    }
    return $month;
}

?>