<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function volumes()
{
    global $theme;
    global $globals;
    global $cluster;
    global $kernel;
    global $l;
    global $error;
    global $storage_disk;
    global $storage_servers;
    global $servers;
    global $servergroups;
    global $done;
    global $vpses;
    global $storages;
    global $store_vps_data;
    global $users;
    global $storage_uuids;
    global $disk_data;
    global $format_type;
    if(!load_lang("admin/volumes")) {
        return false;
    }
    $theme["init_theme"] = "admin/volumes";
    $theme["init_theme_name"] = "volumes";
    $theme["init_theme_func"] = ["volumes_theme"];
    $theme["call_theme_func"] = "volumes_theme";
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    if(!is_allowed("volumes")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $servergroups = server_groups();
    $format_type = ["ext4", "xfs"];
    $res = makequery("SELECT uid, email, pid, inhouse_billing FROM users ORDER BY email");
    $users = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    $serid_val = (int) optREQ("serid_val");
    if(isset($_REQUEST["serid_val"])) {
        $store_vps_data = [];
        $vpses = [];
        $query = makequery("SELECT * FROM vps WHERE serid = :serid AND load_balancer != '-1'", [":serid" => $serid_val]);
        for ($j = 1; $j <= vsql_num_rows($query); $j++) {
            $row = vsql_fetch_assoc($query);
            if($kernel->features("disk_hotplug", $row["virt"]) && $kernel->features("multiple_disk_support", $row["virt"]) && !empty($row["virtio"])) {
                $vpses[$row["vpsid"]] = $row;
            }
        }
        if(empty($vpses)) {
            $error[] = $l["no_vps"];
        }
        $tmp_active_server = $globals["server"];
        set_active_server($serid_val);
        list_storages();
        $newstorage = $storages;
        set_active_server($tmp_active_server);
        $store_vps_data["vpses"] = $vpses;
        $store_vps_data["newstorage"] = $newstorage;
        if(!empty($error)) {
            return false;
        }
    }
    $update_storage = (int) optREQ("update_storage");
    if(isset($_REQUEST["update_storage"])) {
        $tmp_active_server = $globals["server"];
        set_active_server($update_storage);
        list_storages();
        $newstorage[] = $storages;
        set_active_server($tmp_active_server);
        return true;
    }
    $disk_did = (int) optREQ("disk_did");
    if(!empty($disk_did)) {
        $action = (int) optREQ("action");
        $action_arr = ["1", "2", "3"];
        if(!in_array($action, $action_arr)) {
            $error[] = $l["invalid_action"];
        }
        $disk_data = [];
        $res = makequery("SELECT disks.* , storage.stid, storage.st_uuid \n\t\t\t\t\t\t\tfrom disks LEFT join storage\n\t\t\t\t\t\t\tON storage.st_uuid = disks.st_uuid \n\t\t\t\t\t     \tWHERE disks.did = :did", [":did" => $disk_did]);
        $row = vsql_fetch_assoc($res);
        $disk_data["disk"] = $row;
        if(empty($disk_data["disk"]["user_uid"])) {
            $error[] = $l["no_user_found"];
        }
        $uids = [];
        foreach ($users as $k => $v) {
            if($v["uid"] == $disk_data["disk"]["user_uid"] || $v["pid"] == $disk_data["disk"]["user_uid"]) {
                $uids[] = $v["uid"];
            }
        }
        if($action == 1) {
            if(!preg_match("/" . $disk_data["disk"]["vps_uuid"] . "/is", "attachable")) {
                $error[] = $l["disk_already_attached"];
            }
            $resid = makequery("SELECT * FROM storage_servers\n\t\t\t\t\t\t\t\tWHERE stid = :stid", [":stid" => $disk_data["disk"]["stid"]]);
            $server_sel = [];
            for ($i = 0; $i < vsql_num_rows($resid); $i++) {
                $prow = vsql_fetch_assoc($resid);
                foreach ($servers as $x => $y) {
                    if($prow["serid"] == $y["serid"] || $prow["sgid"] == $y["sgid"]) {
                        $server_sel["serid"][$y["serid"]] = $y["serid"];
                        $server_sel["server"][$x] = $y;
                    }
                }
            }
            if(empty($server_sel["serid"])) {
                foreach ($servers as $x => $y) {
                    $server_sel["serid"][$y["serid"]] = $y["serid"];
                    $server_sel["server"][$x] = $y;
                }
            }
            $disk_data["servers"] = $server_sel["server"];
            $qres = makequery("SELECT *\n\t\t\t\t\t\t\t\tFROM vps \n\t\t\t\t\t\t\t\tWHERE serid IN ('" . implode("','", $server_sel["serid"]) . "') AND uid IN ('" . implode("', '", $uids) . "') AND load_balancer != '-1'");
            $vps = [];
            for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                $row = vsql_fetch_assoc($qres);
                if($kernel->features("disk_hotplug", $row["virt"]) && $kernel->features("multiple_disk_support", $row["virt"]) && !empty($row["virtio"])) {
                    $vps[$row["vpsid"]] = $row;
                }
            }
            $disk_data["vps"] = $vps;
            $disk_data["action"] = "1";
            if(empty($disk_data["vps"])) {
                $error[] = $l["no_vps"];
            }
        } elseif($action == 2) {
            if(preg_match("/" . $disk_data["disk"]["vps_uuid"] . "/is", "attachable")) {
                $error[] = $l["disk_not_attached"];
            }
            $qres = makequery("SELECT *\n\t\t\t\t\t\t\t\tFROM vps \n\t\t\t\t\t\t\t\tWHERE uuid = '" . $disk_data["disk"]["vps_uuid"] . "' AND uid IN ('" . implode("', '", $uids) . "') AND load_balancer != '-1'");
            $vps = [];
            for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                $row = vsql_fetch_assoc($qres);
                if($kernel->features("disk_hotplug", $row["virt"]) && $kernel->features("multiple_disk_support", $row["virt"]) && !empty($row["virtio"])) {
                    $vps[$row["vpsid"]] = $row;
                }
            }
            foreach ($servers as $x => $y) {
                if($row["serid"] == $y["serid"]) {
                    $server_sel["server"][$x] = $y;
                }
            }
            $disk_data["vps"] = $vps;
            $disk_data["servers"] = $server_sel["server"];
            $disk_data["action"] = "2";
            if(empty($disk_data["vps"])) {
                $error[] = $l["no_vps"];
            }
        } elseif($action == 3) {
            $resid = makequery("SELECT * FROM storage_servers\n\t\t\t\t\t\tWHERE stid = :stid", [":stid" => $disk_data["disk"]["stid"]]);
            $server_sel = [];
            for ($i = 0; $i < vsql_num_rows($resid); $i++) {
                $prow = vsql_fetch_assoc($resid);
                foreach ($servers as $x => $y) {
                    if($prow["serid"] == $y["serid"] || $prow["sgid"] == $y["sgid"]) {
                        $server_sel["serid"][$y["serid"]] = $y["serid"];
                        $server_sel["server"][$x] = $y;
                    }
                }
            }
            if(empty($server_sel["serid"])) {
                foreach ($servers as $x => $y) {
                    $server_sel["serid"][$y["serid"]] = $y["serid"];
                    $server_sel["server"][$x] = $y;
                }
            }
            $qres = makequery("SELECT *\n\t\t\t\t\t\t\t\tFROM vps \n\t\t\t\t\t\t\t\tWHERE serid IN ('" . implode("','", $server_sel["serid"]) . "') AND uid = " . $disk_data["disk"]["user_uid"] . " AND load_balancer != '-1' ");
            $vps = [];
            for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                $row = vsql_fetch_assoc($qres);
                if($kernel->features("disk_hotplug", $row["virt"]) && $kernel->features("multiple_disk_support", $row["virt"]) && !empty($row["virtio"])) {
                    $vps[$row["vpsid"]] = $row;
                }
            }
            $disk_data["vps"] = $vps;
            $disk_data["servers"] = $server_sel["server"];
            $disk_data["action"] = "3";
        }
        if(!empty($error)) {
            return false;
        }
        return true;
    } else {
        $e_todo = (int) optREQ("e_todo");
        if(!empty($e_todo)) {
            $disk_did_action = optREQ("disk_did_action");
            $e_serid = optREQ("e_serid");
            $e_vpsid = optREQ("e_vpsid");
            if(!$cluster->check_licensepro($e_serid)) {
                $error[] = $l["require_prolic"];
                return false;
            }
            if(isset($_POST["e_disk_size"])) {
                $e_disk_size = optREQ("e_disk_size");
            }
            $action_arr = ["1", "2", "3"];
            if(!in_array($e_todo, $action_arr)) {
                $error[] = $l["invalid_action"];
                return false;
            }
            if(empty($disk_did_action)) {
                $error[] = $l["no_disk_did"];
            }
            $vps = getvps($e_vpsid);
            if(empty($vps)) {
                $error[] = $l["no_vps"];
            }
            if(!$kernel->features("disk_hotplug", $vps["virt"])) {
                $error[] = $l["unsupported_virt"];
                return false;
            }
            $res = makequery("SELECT * from disks\n\t\t\t\t\t     \tWHERE did = :did", [":did" => $disk_did_action]);
            $DISK = vsql_fetch_assoc($res);
            if(empty($DISK["user_uid"])) {
                $error[] = $l["no_user_found"];
            }
            $owner = !empty($users[$DISK["user_uid"]]["pid"]) ? $users[$DISK["user_uid"]]["pid"] : $DISK["user_uid"];
            if($e_todo == 1) {
                if(!empty($vps["locked"])) {
                    $error[] = $l["vps_locked"];
                }
                if(!empty($vps["rescue"])) {
                    $error[] = $l["vps_rescue"];
                }
                if(!preg_match("/" . $DISK["vps_uuid"] . "/is", "attachable")) {
                    $error[] = $l["disk_already_attached"];
                }
                if(!$cluster->get_attachable_disk($e_serid, $DISK)) {
                    $error[] = $l["no_disk_did"];
                }
                $p_check = $cluster->persistent_check_vm($e_serid, $e_vpsid);
                if(!empty($p_check["error"])) {
                    $error[] = implode($p_check["error"]);
                }
                if(!empty($error)) {
                    return false;
                }
                $h_check = $cluster->hotplug_disk($e_serid, $e_vpsid, $DISK, $DISK["mnt_point"]);
                if(!empty($h_check["error"])) {
                    $error[] = implode($h_check["error"]);
                    return false;
                }
                $num = count($vps["disks"]) - 1 + 1;
                $res = makequery("UPDATE disks,vps\n\t\t\t\t\t\t\tSET disks.vps_uuid = :vps_uuid, \n\t\t\t\t\t\t\tdisks.num = :num,\n\t\t\t\t\t\t\tvps.space = :space\n\t\t\t\t\t\t\tWHERE disks.did = :did AND\n\t\t\t\t\t\t\tvps.vpsid = :vpsid", [":vps_uuid" => $vps["uuid"], ":num" => $num, ":did" => $disk_did_action, ":space" => $vps["space"] + $DISK["size"], ":vpsid" => $vps["vpsid"]]);
                if(!empty($users[$owner]["inhouse_billing"])) {
                    $usage_disk = get_usage(["vps_uuid" => "attachable_" . $disk_did_action, "resource" => "volumes", "resource_val" => $DISK["size"]], $disk_did_action);
                    $usage_vps = get_usage(["vps_uuid" => $vps["uuid"], "resource" => "volumes", "resource_val" => $DISK["size"]], $disk_did_action);
                    $final_usid = !empty($usage_disk) ? $usage_disk : $usage_vps;
                    if(!empty($final_usid)) {
                        makequery("UPDATE `usage`\n\t\t\t\t\t\t\tSET vps_uuid = :vps_uuid,\n\t\t\t\t\t\t\tresource = :resource\n\t\t\t\t\t\t\tWHERE usid = :usid\n\t\t\t\t\t\t\tAND endtime = 0", [":vps_uuid" => $vps["uuid"], ":resource" => "space", ":usid" => $final_usid]);
                    } else {
                        $vals = [];
                        $vals["vps_uuid"] = $vps["uuid"];
                        $vals["uid"] = $owner;
                        $vals["starttime"] = time();
                        $vals["resource"] = "space";
                        $vals["resource_val"] = $DISK["size"];
                        $vals["data"] = serialize(["hostname" => $vps["hostname"], "disk_did" => $disk_did_action]);
                        $set = [];
                        foreach ($vals as $k => $v) {
                            $set[$k] = "`" . $k . "` = :" . $k;
                        }
                        insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                    }
                }
                $done["action_done"] = 1;
                logs_admin("volumeattached", $DISK["disk_name"], 1, $vps["vpsid"], $DISK["user_uid"]);
            } elseif($e_todo == 2) {
                if(!empty($vps["locked"])) {
                    $error[] = $l["vps_locked"];
                }
                if(!empty($vps["rescue"])) {
                    $error[] = $l["vps_rescue"];
                }
                if(!preg_match("/" . $DISK["vps_uuid"] . "/is", $vps["uuid"])) {
                    $error[] = $l["disk_not_attached"];
                }
                if(!$cluster->get_attachable_disk($e_serid, $DISK)) {
                    $error[] = $l["no_disk_did"];
                }
                $p_check = $cluster->persistent_check_vm($e_serid, $e_vpsid);
                if(!empty($p_check["error"])) {
                    $error[] = implode($p_check["error"]);
                }
                if(!empty($error)) {
                    return false;
                }
                $h_check = $cluster->detach_disk($e_serid, $e_vpsid, $DISK["path"]);
                if(!empty($h_check["error"])) {
                    $error[] = implode($h_check["error"]);
                    return false;
                }
                $res = makequery("UPDATE disks, vps\n\t\t\t\t\t\t\tSET disks.vps_uuid = :vps_uuid, \n\t\t\t\t\t\t\tdisks.num = :num,\n\t\t\t\t\t\t\tvps.space = :space\n\t\t\t\t\t\t\tWHERE disks.did = :did AND\n\t\t\t\t\t\t\tvps.vpsid = :vpsid", [":vps_uuid" => "attachable", ":num" => -1, ":did" => $disk_did_action, "space" => $vps["space"] - $DISK["size"], "vpsid" => $vps["vpsid"]]);
                if(!empty($users[$owner]["inhouse_billing"])) {
                    $usage_disk = get_usage(["vps_uuid" => $vps["uuid"], "resource" => "space", "resource_val" => $DISK["size"]], $disk_did_action);
                    if(!empty($usage_disk)) {
                        makequery("UPDATE `usage`\n\t\t\t\t\t\t\tSET vps_uuid = :vps_uuid,\n\t\t\t\t\t\t\tresource = :resource\n\t\t\t\t\t\t\tWHERE usid = :usid\n\t\t\t\t\t\t\tAND endtime = 0", [":vps_uuid" => "attachable_" . $disk_did_action, ":resource" => "volumes", ":usid" => $usage_disk]);
                    } else {
                        $vals = [];
                        $vals["vps_uuid"] = "attachable_" . $disk_did_action;
                        $vals["uid"] = $owner;
                        $vals["starttime"] = time();
                        $vals["resource"] = "volumes";
                        $vals["resource_val"] = $DISK["size"];
                        $vals["data"] = serialize(["hostname" => $vps["hostname"], "disk_did" => $disk_did_action]);
                        $set = [];
                        foreach ($vals as $k => $v) {
                            $set[$k] = "`" . $k . "` = :" . $k;
                        }
                        insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                    }
                }
                $done["action_done"] = 1;
                logs_admin("volumedetached", $DISK["disk_name"], 1, $vps["vpsid"], $DISK["user_uid"]);
            } elseif($e_todo == 3) {
                if(!preg_match("/" . $DISK["vps_uuid"] . "/is", "attachable")) {
                    $error[] = $l["disk_attached_resize"];
                    return false;
                }
                if($e_disk_size <= $DISK["size"]) {
                    $error[] = $l["disk_size_zero"];
                    return false;
                }
                $resources = $cluster->resources($e_serid, "kvm");
                foreach ($resources["storages"] as $_stid => $v) {
                    $storage_uuids[$v["st_uuid"]] = $_stid;
                    if(!empty($v["oversell"])) {
                        $alloc_space = storage_allocated_space($_stid);
                        $storages[$_stid]["disk_space"] = $v["oversell"] - $alloc_space;
                    } else {
                        $storages[$_stid]["disk_space"] = $v["free"];
                    }
                }
                if(2000 <= $e_disk_size) {
                    $error[] = $l["err_max_size"];
                }
                if($e_disk_size < 1 || empty($DISK["st_uuid"])) {
                    $error[] = $l["inv_space"];
                }
                if(empty($storages[$storage_uuids[$DISK["st_uuid"]]])) {
                    $error[] = $l["inv_storage"];
                }
                if($storages[$storage_uuids[$DISK["st_uuid"]]]["disk_space"] < $e_disk_size) {
                    $error[] = $l["less_space"];
                }
                $DISK["size"] = $e_disk_size;
                if(!$cluster->resize_attachable_disk($e_serid, $DISK)) {
                    $error[] = $l["err_disk_resize"];
                    return false;
                }
                if(!empty($error)) {
                    return false;
                }
                $res = makequery("UPDATE disks\n\t\t\t\t\t\tSET size = :size\n\t\t\t\t\t\tWHERE did = :did", [":size" => $e_disk_size, ":did" => $disk_did_action]);
                $done["action_done"] = 1;
            }
            return true;
        }
        if(isset($_POST["addvolume"])) {
            $vpsid = (int) POST("vpsid", $l["no_id"]);
            $serid = (int) POST("newserid", $l["no_server"]);
            $size = POST("size", $l["no_size"]);
            $st_uuid = $_POST["st_uuid"];
            $attach = (int) $_POST["attach"];
            $disk_name = POST("disk_name", $l["no_disk_name"]);
            $disk_foramt = POST("format_type", $l["no_disk_format"]);
            $mnt_point = optPOST("mnt_point");
            $tmp_server = (int) $globals["server"];
            set_active_server($serid);
            if(!$cluster->check_licensepro($serid)) {
                $error[] = $l["require_prolic"];
                return false;
            }
            $vps = getvps($vpsid);
            if(empty($vps)) {
                $error[] = $l["vps_not_found"];
            }
            if(!empty($vps["locked"])) {
                $error[] = $l["vps_locked"];
            }
            if(!empty($vps["rescue"])) {
                $error[] = $l["vps_rescue"];
            }
            if(!$kernel->features("disk_hotplug", $vps["virt"])) {
                $error[] = $l["unsupported_virt"];
                return false;
            }
            if(!$kernel->features("multiple_disk_support", $vps["virt"]) && $kernel->features("disks_support", $vps["virt"])) {
                $error[] = $l["no_multidisk_support"];
                return false;
            }
            if(empty($vps["virtio"])) {
                $error[] = $l["ide_not_support"];
                return false;
            }
            if(!in_array($disk_foramt, $format_type)) {
                $error[] = $l["invalid_format"];
                return false;
            }
            $stid = (int) optREQ("stid");
            if(empty($stid)) {
                $stid = storage_get_primary($vps["virt"]);
            }
            if(empty($stid)) {
                $error[] = $l["no_storage"];
                return false;
            }
            if(empty($storages[$stid])) {
                $error[] = $l["inv_storage"];
            }
            if(!empty($attach) && count($vps["disks"]) < 1) {
                $error[] = $l["inv_vps_disk"];
            }
            if(preg_match("/qcow2/is", $storages[$stid]["format"]) && preg_match("/xfs/is", $disk_foramt)) {
                $error[] = $l["xfs_not_qcow2"];
                return false;
            }
            if(!empty($error)) {
                return false;
            }
            $resources = $cluster->resources($vps["serid"], $vps["virt"]);
            foreach ($resources["storages"] as $_stid => $v) {
                $storage_uuids[$v["st_uuid"]] = $_stid;
                if(!empty($v["oversell"])) {
                    $alloc_space = storage_allocated_space($_stid);
                    $storages[$_stid]["disk_space"] = $v["oversell"] - $alloc_space;
                } else {
                    $storages[$_stid]["disk_space"] = $v["free"];
                }
            }
            if(empty($st_uuid)) {
                $st_uuid = $storages[$stid]["st_uuid"];
            }
            if(2000 <= $size) {
                $error[] = $l["err_max_size"];
            }
            if($size < 1 || empty($st_uuid)) {
                $error[] = $l["inv_space"];
            }
            if(empty($storages[$storage_uuids[$st_uuid]])) {
                $error[] = $l["inv_storage"];
            }
            $res = makequery("SELECT `stid`, `serid`, `sgid` FROM `storage_servers` ORDER BY `stid`");
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $resources["storages"][$row["stid"]]["serids"][$row["serid"]] = $row["serid"];
                $resources["storages"][$row["stid"]]["sgids"][$row["sgid"]] = $row["sgid"];
            }
            if(!empty($vps["ha"]) && 0 <= key($resources["storages"][$stid]["serids"])) {
                $error[] = $l["inv_storage_ha"];
            }
            if(!$kernel->features("multiple_disk_support", $vps["virt"])) {
                $error[] = $l["mul_storage"];
            }
            if($storages[$storage_uuids[$st_uuid]]["disk_space"] < $size) {
                $error[] = $l["less_space"];
            }
            if(!empty($error)) {
                return false;
            }
            $disk_config = [];
            $_stid = $storage_uuids[$st_uuid];
            $disk_uuid = "d" . generateRandStr(15);
            $disk_config["disks"][0] = vps_disk_struct();
            $disk_config["disks"][0]["primary"] = 0;
            $disk_config["disks"][0]["path"] = vpsdisk_path_build("attach-" . $disk_uuid, $storages[$_stid], $vps);
            $disk_config["disks"][0]["type"] = $storages[$_stid]["type"];
            $disk_config["disks"][0]["format"] = $storages[$_stid]["format"];
            $disk_config["disks"][0]["size"] = $size;
            $disk_config["disks"][0]["vpsid"] = $vps["vpsid"];
            $disk_config["disks"][0]["st_uuid"] = $storages[$_stid]["st_uuid"];
            $disk_config["disks"][0]["disk_uuid"] = $disk_uuid;
            $disk_config["disks"][0]["num"] = !empty($attach) ? count($vps["disks"]) - 1 + 1 : -1;
            $disk_config["disks"][0]["bus_driver"] = "";
            $disk_config["disks"][0]["bus_driver_num"] = 0;
            $disk_config["disks"][0]["user_uid"] = $vps["uid"];
            $disk_config["disks"][0]["disk_name"] = $disk_name;
            $disk_config["disks"][0]["mnt_point"] = $mnt_point;
            $vps_uuid = empty($attach) ? "attachable" : $vps["uuid"];
            vpsdisk_add($vps_uuid, $disk_config["disks"][0]);
            set_active_server($tmp_server);
            $hot_plug = [];
            $hot_plug["disk_config"] = $disk_config;
            $hot_plug["vpsid"] = $vpsid;
            $hot_plug["attach"] = $attach;
            $hot_plug["format_type"] = $disk_foramt;
            $hot_plug["owner"] = $owner = !empty($users[$vps["uid"]]["pid"]) ? $users[$vps["uid"]]["pid"] : $vps["uid"];
            $hot_plug["inhouse_billing"] = !empty($users[$owner]["inhouse_billing"]) ? 1 : 0;
            $actid = tasks_admin_process("addvolume", serialize($hot_plug), 1, $vpsid, $vps["uid"], 0, 0);
            if(empty($actid)) {
                $error[] = $l["attaching_disk_error"];
                return false;
            }
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/volume_hotplug.php " . $actid . " 2>&1 &");
            $done["voladd_done"] = 1;
            return true;
        } else {
            $disk_did = optREQ("delete");
            if(!empty($disk_did)) {
                $disk_did = cexplode(",", $disk_did, 1);
                $res = makequery("SELECT disks.* , storage.stid, storage.st_uuid, storage_servers.* \n\t\t\t\t\t\tfrom  disks, storage, storage_servers WHERE \n\t\t\t\t\t\tstorage.st_uuid = disks.st_uuid AND storage.stid = storage_servers.stid AND \n\t\t\t\t\t\tdisks.did IN ('" . implode("','", $disk_did) . "')");
                if(vsql_num_rows($res) < 1) {
                    return false;
                }
                $disk_inuse = [];
                for ($i = 0; $i < vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    if(!preg_match("/" . $row["vps_uuid"] . "/is", "attachable")) {
                        $disk_inuse[] = $row["did"];
                    } else {
                        $_disk[$row["did"]] = $row;
                    }
                }
                foreach ($_disk as $sk => $deldisk) {
                    if($deldisk["serid"] == -1) {
                        $serid = array_keys($servers);
                    } else {
                        foreach ($servers as $k => $v) {
                            if($deldisk["serid"] == $v["serid"] || $deldisk["sgid"] == $v["sgid"]) {
                                $serid = $v["serid"];
                            }
                        }
                    }
                    $_disk[$sk]["serid"] = $serid;
                }
                foreach ($_disk as $sk => $deldisk) {
                    $del = 1;
                    if(!$cluster->check_licensepro($deldisk["serid"])) {
                        $error[] = $l["require_prolic"];
                        return false;
                    }
                    if(!$cluster->delete_attachable_disk($deldisk["serid"], $deldisk)) {
                        $error[] = $l["disk_not_del"] . $deldisk["did"];
                        $del = 0;
                    }
                    if($del) {
                        $res = makequery("DELETE FROM disks WHERE did = :did", [":did" => $deldisk["did"]]);
                        if(!$res) {
                            $error[] = $l["disk_not_del"] . $deldisk["did"];
                            return false;
                        }
                        if(empty($error)) {
                            $owner = !empty($users[$deldisk["user_uid"]]["pid"]) ? $users[$deldisk["user_uid"]]["pid"] : $deldisk["user_uid"];
                            if(!empty($users[$owner]["inhouse_billing"])) {
                                $usage_disk = get_usage(["vps_uuid" => "attachable_" . $deldisk["did"], "resource" => "volumes", "resource_val" => $deldisk["size"]], $deldisk["did"]);
                                if(!empty($usage_disk)) {
                                    $res = makequery("UPDATE `usage` \n\t\t\t\t\t\t\t\t\t\t\tSET endtime = :time,\n\t\t\t\t\t\t\t\t\t\t\tupdatetime = :time\n\t\t\t\t\t\t\t\t\t\t\tWHERE vps_uuid = :vps_uuid \n\t\t\t\t\t\t\t\t\t\t\tAND usid = :usid", [":time" => time(), ":vps_uuid" => "attachable_" . $deldisk["did"], "usid" => $usage_disk]);
                                }
                            }
                            logs_admin("delvolume", $deldisk["disk_name"], 1, $deldisk["st_uuid"], $deldisk["user_uid"]);
                        }
                    }
                }
                if(!empty($error)) {
                    return false;
                }
                if(0 < count($disk_inuse)) {
                    $error[] = $l["disk_in_use"] . "\n" . implode("\n", array_values($disk_inuse));
                    return false;
                }
                $done = $_disk;
                return true;
            } else {
                $name = optREQ("name");
                $tokens = [];
                if(!empty($name)) {
                    $where["name"] = "disk_name LIKE :name";
                    $tokens[":name"] = wildsearch($name);
                }
                $path = optREQ("path");
                if(!empty($path)) {
                    $where["path"] = "disks.path LIKE :path";
                    $tokens[":path"] = wildsearch($path);
                }
                $user_email = optREQ("user_email");
                if(!empty($user_email)) {
                    foreach ($users as $k => $v) {
                        if(preg_match("/" . $user_email . "/is", $v["email"])) {
                            $uid = $v["uid"];
                        }
                    }
                    if(empty($uid)) {
                        $uid = "-1";
                    }
                }
                $res = makequery("SELECT COUNT(did) AS num FROM `disks` WHERE user_uid " . (!empty($uid) ? "=" . $uid : "!= 0") . "\n\t\t\t\t\t" . (empty($where) ? "" : " AND " . implode(" AND ", $where)), $tokens);
                $globals["cur_page"] = get_page();
                $globals["reslen"] = (int) optREQ("reslen");
                $globals["reslen"] = $globals["reslen"] <= 0 ? 50 : $globals["reslen"];
                $tmp = vsql_fetch_assoc($res);
                $globals["num_res"] = $tmp["num"];
                $res = makequery("SELECT disks.* , storage.stid, storage.st_uuid from disks\n\t\t\t\t\tLEFT join storage ON storage.st_uuid = disks.st_uuid \n\t\t\t\t\tWHERE disks.user_uid " . (!empty($uid) ? "=" . $uid : "!= 0") . "\n\t\t\t\t\t" . (empty($where) ? "" : " AND " . implode(" AND ", $where)) . "\n\t\t\t\t\tORDER BY did\n\t\t\t\t\tLIMIT " . (int) $globals["cur_page"] . ", " . $globals["reslen"], $tokens);
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $storage_disk[$row["did"]] = $row;
                }
                if(!empty($storage_disk)) {
                    foreach ($storage_disk as $k => $v) {
                        if(!preg_match("/" . $v["vps_uuid"] . "/is", "attachable")) {
                            $res = makequery("SELECT vpsid, vps_name, serid FROM `vps` \n\t\t\t\t\t\t\t\t\tWHERE uuid = :uuid", [":uuid" => $v["vps_uuid"]]);
                            $row = vsql_fetch_assoc($res);
                            $storage_disk[$k]["vpsid"] = !empty($row["vpsid"]) ? $row["vpsid"] : "";
                            $storage_disk[$k]["vps_name"] = !empty($row["vps_name"]) ? $row["vps_name"] : "";
                            $storage_disk[$k]["serid"] = $row["serid"];
                        } else {
                            $resid = makequery("SELECT * FROM storage_servers\n\t\t\t\t\t\t\t\t\tWHERE stid IN (" . $v["stid"] . ")");
                            if(1 <= vsql_num_rows($resid)) {
                                for ($i = 0; $i < vsql_num_rows($resid); $i++) {
                                    $prow = vsql_fetch_assoc($resid);
                                    $storage_disk[$k]["serid"] = $prow["serid"];
                                    $storage_disk[$k]["sgid"] = $prow["sgid"];
                                }
                            }
                        }
                        $users_res = makequery("SELECT uid, email, pid \n\t\t\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $v["user_uid"]]);
                        $usr_row = vsql_fetch_assoc($users_res);
                        $parent = "";
                        if(!empty($usr_row["pid"])) {
                            $res = makequery("SELECT uid, email, pid \n\t\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $usr_row["pid"]]);
                            $row = vsql_fetch_assoc($res);
                            $parent = $row["email"];
                        }
                        $storage_disk[$k]["user_email"] = !empty($parent) ? $usr_row["email"] . "(" . $parent . ")" : $usr_row["email"];
                    }
                }
                if(!empty($error)) {
                    return false;
                }
            }
        }
    }
}
function API_volumes()
{
    global $theme;
    global $globals;
    global $l;
    global $error;
    global $storage_disk;
    global $storage_servers;
    global $done;
    global $vpses;
    global $storages;
    global $store_vps_data;
    global $users;
    global $voladd_done;
    global $disk_data;
    global $format_type;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($store_vps_data)) {
        $GLOBALS["_api"]["store_vps_data"] = $store_vps_data;
    }
    if(!empty($users)) {
        $GLOBALS["_api"]["users"] = $users;
    }
    if(!empty($voladd_done)) {
        $GLOBALS["_api"]["voladd_done"] = $voladd_done;
    }
    if(!empty($disk_data)) {
        $GLOBALS["_api"]["disk_data"] = $disk_data;
    }
    $GLOBALS["_api"]["storage_disk"] = $storage_disk;
    $GLOBALS["_api"]["storage_servers"] = $storage_servers;
    $GLOBALS["_api"]["format_type"] = $format_type;
}

?>