<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function volume()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $cluster;
    global $user;
    global $l;
    global $error;
    global $done;
    global $servers;
    global $A;
    global $kernel;
    global $vs;
    global $uids;
    global $tr_pagination_vol;
    global $action_edit_data;
    global $space_resource;
    $theme["init_theme"] = "volume";
    $theme["init_theme_name"] = "volume";
    $theme["init_theme_func"] = ["volume_theme"];
    $theme["call_theme_func"] = "volume_theme";
    if($user["type"] != 2 && empty($user["inhouse_billing"]) || !empty($globals["disable_volume_enduser"])) {
        reporterror("", $l["no_access"]);
    } else {
        $A = [];
        list_servers();
        $servergroups = server_groups();
        $user["sg"] = cexplode(",", $user["sg"], 1);
        foreach ($servergroups as $k => $v) {
            if(!in_array($k, $user["sg"])) {
            } else {
                $A["servergroups"][$k] = $v;
            }
        }
        foreach ($servers as $k => $v) {
            if(!in_array($v["sgid"], $user["sg"])) {
                unset($servers[$k]);
            } else {
                foreach ($v["virts"] as $kk => $vv) {
                    $A["servergroups"][$v["sgid"]]["virts"][$vv] = $vv;
                    if(!empty($v["hvm"]) && ($vv == "xen" || $vv == "xcp")) {
                        $A["servergroups"][$v["sgid"]]["virts"][$vv . "hvm"] = $vv . "hvm";
                    }
                }
            }
        }
        $space_resource = $user["space"];
        $resu = makequery("SELECT uid, pid from users \n\t\t\t\t\t\twhere pid = :uid OR uid = :uid", [":uid" => $user["uid"]]);
        for ($i = 1; $i <= vsql_num_rows($resu); $i++) {
            $row = vsql_fetch_assoc($resu);
            $uids[$row["uid"]] = $row["uid"];
        }
        $name = optREQ("s_vol_name");
        $tokens = [];
        if(!empty($name)) {
            $where["name"] = "disk_name LIKE :name";
            $tokens[":name"] = wildsearch($name);
        }
        $size = optREQ("s_disk_size");
        if(!empty($size)) {
            $where["size"] = "disks.size LIKE :size";
            $tokens[":size"] = wildsearch($size);
        }
        $res = makequery("SELECT COUNT(did) AS num FROM `disks` WHERE user_uid IN ('" . implode("', '", $uids) . "')\n\t\t\t\t\t" . (empty($where) ? "" : " AND " . implode(" AND ", $where)), $tokens);
        $tr_pagination_vol["start"] = get_page("trpagevol");
        $tr_pagination_vol["len"] = (int) optREQ("reslen");
        $tr_pagination_vol["len"] = $tr_pagination_vol["len"] <= 0 ? 50 : $tr_pagination_vol["len"];
        $tmp = vsql_fetch_assoc($res);
        $tr_pagination_vol["maxNum"] = $tmp["num"];
        $res = makequery("SELECT disks.* , storage.stid, storage.st_uuid from disks\n\t\t\t\t\t\tLEFT join storage ON storage.st_uuid = disks.st_uuid \n\t\t\t\t\t\tWHERE disks.user_uid IN ('" . implode("', '", $uids) . "')\n\t\t\t\t\t" . (empty($where) ? "" : " AND " . implode(" AND ", $where)) . "\n\t\t\t\t\tORDER BY did\n\t\t\t\t\tLIMIT " . (int) $tr_pagination_vol["start"] . ", " . (int) $tr_pagination_vol["len"], $tokens);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $storage_disk[$row["did"]] = $row;
        }
        foreach ($storage_disk as $k => $v) {
            if(!preg_match("/" . $v["vps_uuid"] . "/is", "attachable")) {
                $res = makequery("SELECT vpsid, vps_name, serid, space FROM `vps` \n\t\t\t\t\t\t\t\tWHERE uuid = :uuid AND load_balancer != '-1'", [":uuid" => $v["vps_uuid"]]);
                $row = vsql_fetch_assoc($res);
                $storage_disk[$k]["vpsid"] = !empty($row["vpsid"]) ? $row["vpsid"] : "";
                $storage_disk[$k]["vps_name"] = !empty($row["vps_name"]) ? $row["vps_name"] : "";
                $storage_disk[$k]["serid"] = $row["serid"];
            } else {
                $space_resource -= $v["size"];
                $resid = makequery("SELECT * FROM storage_servers\n\t\t\t\t\t\t\t\tWHERE stid IN (" . $v["stid"] . ")");
                if(1 <= vsql_num_rows($resid)) {
                    for ($i = 0; $i < vsql_num_rows($resid); $i++) {
                        $prow = vsql_fetch_assoc($resid);
                        $storage_disk[$k]["serid"] = $prow["serid"];
                        $storage_disk[$k]["sgid"] = $prow["sgid"];
                    }
                }
            }
            foreach ($servers as $x => $y) {
                if($storage_disk[$k]["serid"] == $y["serid"] || $storage_disk[$k]["sgid"] == $y["sgid"]) {
                    $storage_disk[$k]["sgid"] = $y["sgid"];
                }
            }
            $users_res = makequery("SELECT uid, email, pid \n\t\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $v["user_uid"]]);
            $usr_row = vsql_fetch_assoc($users_res);
            $parent = "";
            if(!empty($usr_row["pid"])) {
                $res = makequery("SELECT email FROM users WHERE uid = :uid", [":uid" => $usr_row["pid"]]);
                $row = vsql_fetch_assoc($res);
                $parent = $row["email"];
            }
            $storage_disk[$k]["user_email"] = !empty($parent) ? $usr_row["email"] . "(" . $parent . ")" : $usr_row["email"];
        }
        $A["storage_disk"] = $storage_disk;
        if(optREQ("perform_action") || optREQ("todo_did") || isset($_REQUEST["addvolume"])) {
            $list_vol = 1;
        }
        $getvps = optREQ("listvs");
        if(!empty($getvps) || !empty($list_vol)) {
            $vs = [];
            $res = makequery("SELECT v.*, u.email\n\t\t\t\t\t\tFROM vps v\n\t\t\t\t\t\tLEFT JOIN users u ON (v.uid = u.uid) \n\t\t\t\t\t\tLEFT JOIN servers s ON (s.serid = v.serid) \n\t\t\t\t\t\tWHERE v.uid = :uid OR u.pid = :uid ORDER BY v.vpsid", [":uid" => $user["uid"]]);
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $space_resource -= $row["space"];
                if($kernel->features("disk_hotplug", $row["virt"]) && $kernel->features("multiple_disk_support", $row["virt"]) && !empty($row["virtio"])) {
                    $vs[$row["vpsid"]] = $row;
                }
            }
            if(!empty($vs)) {
                $A["vs"] = $vs;
            }
        }
        $vol_per_vpsid = (int) optREQ("vol_per_vpsid");
        if(isset($_REQUEST["vol_per_vpsid"])) {
            $vps = getvps($vol_per_vpsid);
            if(empty($vps)) {
                return NULL;
            }
            if(empty($servers)) {
                list_servers();
            }
            $vol_pr_sgid = $servers[$vps["serid"]]["sgid"];
            $resource_pricing = resource_rates();
            foreach ($resource_pricing as $resource => $v) {
                $allowed_sgid = [];
                $allowed_sgid[-1] = -1;
                $allowed_sgid[$vol_pr_sgid] = $vol_pr_sgid;
                if(!empty($resource_pricing[$resource]["h_rate"][$vol_pr_sgid])) {
                    unset($allowed_sgid[-1]);
                }
                foreach ($v["h_rate"] as $sgid => $val) {
                    if(!in_array($sgid, $allowed_sgid)) {
                        unset($resource_pricing[$resource]["h_rate"][$sgid]);
                        unset($resource_pricing[$resource]["m_rate"][$sgid]);
                        unset($resource_pricing[$resource]["y_rate"][$sgid]);
                    }
                }
                if(empty($resource_pricing[$resource]["h_rate"])) {
                    unset($resource_pricing[$resource]);
                } else {
                    foreach ($resource_pricing[$resource] as $rate_type => $val) {
                        $resource_pricing[$resource][$rate_type] = current($val);
                    }
                }
            }
            $A["resource_pricing"] = $resource_pricing;
        }
        $todo_did = optREQ("todo_did");
        if(!empty($todo_did)) {
            $post = [];
            $todo_action = optREQ("todo_action");
            if(empty($todo_action)) {
                $error[] = $l["vol_action_not_found"];
                return false;
            }
            $post["disk_did"] = $todo_did;
            $post["action"] = $todo_action;
            $action_edit_data = make_api_call("127.0.0.1", $globals["pass"], "index.php?act=volumes&disk_did=" . $todo_did . "&action=" . $todo_action, []);
            if(!empty($action_edit_data["error"])) {
                foreach ($action_edit_data["error"] as $k => $v) {
                    $error[] = $v;
                }
            }
            if(!empty($error)) {
                return false;
            }
            $A["action_edit_data"] = $action_edit_data;
        }
        $perform_action = (int) optREQ("perform_action");
        if(!empty($perform_action)) {
            $vpsid_vol = (int) optREQ("vpsid_vol");
            $e_vol_did = (int) optREQ("e_vol_did");
            $vol_size = optREQ("vol_size");
            $vol_edit = [];
            if(empty($vpsid_vol)) {
                $error[] = $l["vol_no_vps"];
            }
            if(empty($e_vol_did) || empty($storage_disk[$e_vol_did])) {
                $error[] = $l["vol_did_not_found"];
            }
            $vps = getvps($vpsid_vol);
            if(empty($vps) || empty($vs[$vpsid_vol])) {
                $error[] = $l["vol_no_vps"];
                return false;
            }
            if(!$ckernel->check_licensepro($vpsid_vol)) {
                $error[] = $l["require_pro_lic"];
                return false;
            }
            $vol_edit["e_serid"] = $vps["serid"];
            $vol_edit["e_vpsid"] = $vpsid_vol;
            $vol_edit["e_todo"] = $perform_action;
            $vol_edit["disk_did_action"] = $e_vol_did;
            if(!empty($error)) {
                return false;
            }
            $vol_edit["e_disk_size"] = !empty($vol_size) ? $vol_size : "";
            if($perform_action == "3" && !empty($vol_edit["e_disk_size"])) {
                $res = makequery("SELECT disks.* , storage.stid, storage.st_uuid \n\t\t\t\t\t\t\tfrom disks LEFT join storage\n\t\t\t\t\t\t\tON storage.st_uuid = disks.st_uuid \n\t\t\t\t\t     \tWHERE disks.did = :did", [":did" => $e_vol_did]);
                $row = vsql_fetch_assoc($res);
                if(!empty($row["size"])) {
                    $og_size = (int) $row["size"];
                }
                $_size = round($vol_size, 2);
                $curr_size = $_size - $og_size;
                $space_resource -= $curr_size;
                if($space_resource <= 0) {
                    $error[] = $l["vol_low_disk"];
                    return false;
                }
            }
            $voledit_done = make_api_call("127.0.0.1", $globals["pass"], "index.php?act=volumes", [], $vol_edit);
            if(!empty($voledit_done["error"])) {
                $error[] = $voledit_done["error"];
                return false;
            }
            $actions = ["1" => "attached", "2" => "detached", "3" => "resize"];
            if(!empty($voledit_done["done"])) {
                $done["msg"] = $l["vol_" . $actions[$perform_action] . "_done"];
                $done["goto"] = "act=volume";
            }
        }
        $delvol = optREQ("delvol");
        if(!empty($delvol)) {
            $delvol = ["delete" => $delvol];
            $vol_del_did = cexplode(",", $delvol["delete"], 1);
            foreach ($vol_del_did as $k => $v) {
                if(empty($storage_disk[$v])) {
                    $error[] = $l["vol_did_not_found"];
                    return false;
                }
            }
            $voldel_done = make_api_call("127.0.0.1", $globals["pass"], "index.php?act=volumes", [], $delvol);
            if(!empty($voldel_done["error"])) {
                $error[] = $voldel_done["error"];
                return false;
            }
            if(!empty($voldel_done["done"])) {
                $done["msg"] = $l["vol_delete_done"];
                $done["goto"] = "act=volume";
            }
        }
        if(isset($_REQUEST["addvolume"])) {
            $vol_size = optPOST("vol_size");
            $vps_sel = (int) optPOST("vps_sel");
            $format = optPOST("format");
            $attach_vol = optPOST("attach_vol");
            $mntpoint = optPOST("mntpoint");
            $volname = optPOST("volname");
            if(empty($vol_size)) {
                $error[] = $l["vol_size_empty"];
            }
            if(empty($vps_sel)) {
                $error[] = $l["vol_no_vps"];
            }
            if(empty($volname)) {
                $error[] = $l["vol_name_placeholder"];
            }
            if(!empty($error)) {
                return false;
            }
            $_size = round($vol_size, 2);
            $space_resource -= $_size;
            if($space_resource <= 0) {
                $error[] = $l["vol_low_disk"];
            }
            if($_size < 1) {
                $error[] = $l["vol_size_less"];
            }
            $vps = getvps($vps_sel);
            if(empty($vps) || empty($vs[$vps_sel])) {
                $error[] = $l["vol_no_vps"];
                return false;
            }
            if(!$ckernel->check_licensepro($vps_sel)) {
                $error[] = $l["require_pro_lic"];
                return false;
            }
            $resource_pricing = resource_rates();
            foreach ($servers as $x => $y) {
                if($vps["serid"] == $y["serid"]) {
                    $p_sgid = $y["sgid"];
                }
            }
            $h_rate = (empty($resource_pricing["space"]["h_rate"][$p_sgid]) ? $resource_pricing["space"]["h_rate"][-1] : $resource_pricing["space"]["h_rate"][$p_sgid]) / 1024;
            $total_price = $h_rate * $vol_size;
            if((int) $user["cur_bal"] < $total_price) {
                $error[] = $l["vol_insufficient_balance"];
            }
            if(!empty($error)) {
                return false;
            }
            $vol = ["addvolume" => "1", "vpsid" => $vps_sel, "newserid" => $vps["serid"], "size" => $_size, "attach" => $attach_vol, "disk_name" => $volname, "format_type" => $format, "mnt_point" => $mntpoint, "st_uuid" => ""];
            $voladd_done = make_api_call("127.0.0.1", $globals["pass"], "index.php?act=volumes", [], $vol);
            if(!empty($voladd_done["error"])) {
                $error[] = $l["vol_attach_err"];
                return false;
            }
            if(!empty($voladd_done["done"])) {
                $A["done"] = $l["done"];
                $A["done_msg"] = $l["vol_add_done"];
                $done["done"] = $l["vol_add_done"];
                $done["msg"] = $l["vol_add_done"];
                $done["goto"] = "act=volume";
            }
        }
    }
}
function API_volume()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $cluster;
    global $user;
    global $l;
    global $error;
    global $done;
    global $A;
    global $tr_pagination_vol;
    global $action_edit_data;
    $GLOBALS["_api"] += $A;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["virts"] = $globals["virts"];
    if(!empty($action_edit_data)) {
        $GLOBALS["_api"]["action_edit_data"] = $action_edit_data;
    }
    $GLOBALS["_api"]["trpagevol"] = $tr_pagination_vol;
    $GLOBALS["_api"]["user"] = $user;
}

?>