<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(php_sapi_name() != "cli") {
    echo "You need to run this command from console.";
    exit(1);
}
$tcpdf_include_dirs = [realpath(dirname(__FILE__) . "/../tcpdf.php"), "/usr/share/php/tcpdf/tcpdf.php", "/usr/share/tcpdf/tcpdf.php", "/usr/share/php-tcpdf/tcpdf.php", "/var/www/tcpdf/tcpdf.php", "/var/www/html/tcpdf/tcpdf.php", "/usr/local/apache2/htdocs/tcpdf/tcpdf.php"];
foreach ($tcpdf_include_dirs as $tcpdf_include_path) {
    if(@file_exists($tcpdf_include_path)) {
        require_once $tcpdf_include_path;
        array_shift($argv);
        if(!is_array($argv)) {
            showhelp();
        }
        $options = ["type" => "", "enc" => "", "flags" => 32, "outpath" => K_PATH_FONTS, "platid" => 3, "encid" => 1, "addcbbox" => false, "link" => false];
        $sopt = "";
        $sopt .= "t:";
        $sopt .= "e:";
        $sopt .= "f:";
        $sopt .= "o:";
        $sopt .= "p:";
        $sopt .= "n:";
        $sopt .= "b";
        $sopt .= "l";
        $sopt .= "i:";
        $sopt .= "h";
        $lopt = [];
        $lopt[] = "type:";
        $lopt[] = "enc:";
        $lopt[] = "flags:";
        $lopt[] = "outpath:";
        $lopt[] = "platid:";
        $lopt[] = "encid:";
        $lopt[] = "addcbbox";
        $lopt[] = "link";
        $lopt[] = "fonts:";
        $lopt[] = "help";
        $inopt = getopt($sopt, $lopt);
        foreach ($inopt as $opt => $val) {
            switch ($opt) {
                case "t":
                case "type":
                    if(in_array($val, ["TrueTypeUnicode", "TrueType", "Type1", "CID0JP", "CID0KR", "CID0CS", "CID0CT"])) {
                        $options["type"] = $val;
                    }
                    break;
                case "e":
                case "enc":
                    $options["enc"] = $val;
                    break;
                case "f":
                case "flags":
                    $options["flags"] = intval($val);
                    break;
                case "o":
                case "outpath":
                    $options["outpath"] = realpath($val);
                    if(substr($options["outpath"], -1) != "/") {
                        $options["outpath"] .= "/";
                    }
                    break;
                case "p":
                case "platid":
                    $options["platid"] = min(max(1, intval($val)), 3);
                    break;
                case "n":
                case "encid":
                    $options["encid"] = min(max(0, intval($val)), 10);
                    break;
                case "b":
                case "addcbbox":
                    $options["addcbbox"] = true;
                    break;
                case "l":
                case "link":
                    $options["link"] = true;
                    break;
                case "i":
                case "fonts":
                    $options["fonts"] = explode(",", $val);
                    break;
                case "h":
                case "help":
                default:
                    showhelp();
            }
        }
        if(empty($options["fonts"])) {
            echo "ERROR: missing input fonts (try --help for usage)\n\n";
            exit(2);
        }
        if(!is_dir($options["outpath"]) || !is_writable($options["outpath"])) {
            echo "ERROR: Can't write to " . $options["outpath"] . "\n\n";
            exit(3);
        }
        echo "\n>>> Converting fonts for TCPDF:\n";
        echo "*** Output dir set to " . $options["outpath"] . "\n";
        $errors = false;
        foreach ($options["fonts"] as $font) {
            $fontfile = realpath($font);
            $fontname = TCPDF_FONTS::addTTFfont($fontfile, $options["type"], $options["enc"], $options["flags"], $options["outpath"], $options["platid"], $options["encid"], $options["addcbbox"], $options["link"]);
            if($fontname === false) {
                $errors = true;
                echo "--- ERROR: can't add " . $font . "\n";
            } else {
                echo "+++ OK   : " . $fontfile . " added as " . $fontname . "\n";
            }
        }
        if($errors) {
            echo "--- Process completed with ERRORS!\n\n";
            exit(4);
        }
        echo ">>> Process successfully completed!\n\n";
        exit(0);
    }
}
function showHelp()
{
    $help = "tcpdf_addfont - command line tool to convert fonts for the TCPDF library.\n\nUsage: tcpdf_addfont.php [ options ] -i fontfile[,fontfile]...\n\nOptions:\n\n\t-t\n\t--type      Font type. Leave empty for autodetect mode.\n\t            Valid values are:\n\t\t\t\t\tTrueTypeUnicode\n\t\t\t\t\tTrueType\n\t\t\t\t\tType1\n\t\t\t\t\tCID0JP = CID-0 Japanese\n\t\t\t\t\tCID0KR = CID-0 Korean\n\t\t\t\t\tCID0CS = CID-0 Chinese Simplified\n\t\t\t\t\tCID0CT = CID-0 Chinese Traditional\n\n\t-e\n\t--enc       Name of the encoding table to use. Leave empty for\n\t            default mode. Omit this parameter for TrueType Unicode\n\t            and symbolic fonts like Symbol or ZapfDingBats.\n\n\t-f\n\t--flags     Unsigned 32-bit integer containing flags specifying\n\t            various characteristics of the font (PDF32000:2008 -\n\t            9.8.2 Font Descriptor Flags): +1 for fixed font; +4 for\n\t            symbol or +32 for non-symbol; +64 for italic. Fixed and\n\t            Italic mode are generally autodetected so you have to\n\t            set it to 32 = non-symbolic font (default) or 4 =\n\t            symbolic font.\n\n\t-o\n\t--outpath   Output path for generated font files (must be writeable\n\t            by the web server). Leave empty for default font folder.\n\n\t-p\n\t--platid    Platform ID for CMAP table to extract (when building a\n\t            Unicode font for Windows this value should be 3, for\n\t            Macintosh should be 1).\n\n\t-n\n\t--encid     Encoding ID for CMAP table to extract (when building a\n\t            Unicode font for Windows this value should be 1, for\n\t            Macintosh should be 0). When Platform ID is 3, legal\n\t            values for Encoding ID are: 0=Symbol, 1=Unicode,\n\t            2=ShiftJIS, 3=PRC, 4=Big5, 5=Wansung, 6=Johab,\n\t            7=Reserved, 8=Reserved, 9=Reserved, 10=UCS-4.\n\n\t-b\n\t--addcbbox  Includes the character bounding box information on the\n\t            php font file.\n\n\t-l\n\t--link      Link to system font instead of copying the font data #\n\t            (not transportable) - Note: do not work with Type1 fonts.\n\n\t-i\n\t--fonts     Comma-separated list of input font files.\n\n\t-h\n\t--help      Display this help and exit.";
    echo $help . "\n\n";
    exit(0);
}

?>