<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
require_once dirname(__FILE__) . "/include/tcpdf_font_data.php";
require_once dirname(__FILE__) . "/include/tcpdf_fonts.php";
require_once dirname(__FILE__) . "/include/tcpdf_colors.php";
require_once dirname(__FILE__) . "/include/tcpdf_images.php";
require_once dirname(__FILE__) . "/include/tcpdf_static.php";
/**
 * @class TCPDF
 * PHP class for generating PDF documents without requiring external extensions.
 * TCPDF project (http://www.tcpdf.org) has been originally derived in 2002 from the Public Domain FPDF class by Olivier Plathey (http://www.fpdf.org), but now is almost entirely rewritten.<br>
 * @package com.tecnick.tcpdf
 * @brief PHP class for generating PDF documents without requiring external extensions.
 * @version 6.3.2
 * @author Nicola Asuni - info@tecnick.com
 * @IgnoreAnnotation("protected")
 * @IgnoreAnnotation("public")
 * @IgnoreAnnotation("pre")
 */
class TCPDF
{
    /**
     * Current page number.
     * @protected
     */
    protected $page;
    /**
     * Current object number.
     * @protected
     */
    protected $n;
    /**
     * Array of object offsets.
     * @protected
     */
    protected $offsets = [];
    /**
     * Array of object IDs for each page.
     * @protected
     */
    protected $pageobjects = [];
    /**
     * Buffer holding in-memory PDF.
     * @protected
     */
    protected $buffer;
    /**
     * Array containing pages.
     * @protected
     */
    protected $pages = [];
    /**
     * Current document state.
     * @protected
     */
    protected $state;
    /**
     * Compression flag.
     * @protected
     */
    protected $compress;
    /**
     * Current page orientation (P = Portrait, L = Landscape).
     * @protected
     */
    protected $CurOrientation;
    /**
     * Page dimensions.
     * @protected
     */
    protected $pagedim = [];
    /**
     * Scale factor (number of points in user unit).
     * @protected
     */
    protected $k;
    /**
     * Width of page format in points.
     * @protected
     */
    protected $fwPt;
    /**
     * Height of page format in points.
     * @protected
     */
    protected $fhPt;
    /**
     * Current width of page in points.
     * @protected
     */
    protected $wPt;
    /**
     * Current height of page in points.
     * @protected
     */
    protected $hPt;
    /**
     * Current width of page in user unit.
     * @protected
     */
    protected $w;
    /**
     * Current height of page in user unit.
     * @protected
     */
    protected $h;
    /**
     * Left margin.
     * @protected
     */
    protected $lMargin;
    /**
     * Right margin.
     * @protected
     */
    protected $rMargin;
    /**
     * Cell left margin (used by regions).
     * @protected
     */
    protected $clMargin;
    /**
     * Cell right margin (used by regions).
     * @protected
     */
    protected $crMargin;
    /**
     * Top margin.
     * @protected
     */
    protected $tMargin;
    /**
     * Page break margin.
     * @protected
     */
    protected $bMargin;
    /**
     * Array of cell internal paddings ('T' => top, 'R' => right, 'B' => bottom, 'L' => left).
     * @since 5.9.000 (2010-10-03)
     * @protected
     */
    protected $cell_padding = ["T" => 0, "R" => 0, "B" => 0, "L" => 0];
    /**
     * Array of cell margins ('T' => top, 'R' => right, 'B' => bottom, 'L' => left).
     * @since 5.9.000 (2010-10-04)
     * @protected
     */
    protected $cell_margin = ["T" => 0, "R" => 0, "B" => 0, "L" => 0];
    /**
     * Current horizontal position in user unit for cell positioning.
     * @protected
     */
    protected $x;
    /**
     * Current vertical position in user unit for cell positioning.
     * @protected
     */
    protected $y;
    /**
     * Height of last cell printed.
     * @protected
     */
    protected $lasth;
    /**
     * Line width in user unit.
     * @protected
     */
    protected $LineWidth;
    /**
     * Array of standard font names.
     * @protected
     */
    protected $CoreFonts;
    /**
     * Array of used fonts.
     * @protected
     */
    protected $fonts = [];
    /**
     * Array of font files.
     * @protected
     */
    protected $FontFiles = [];
    /**
     * Array of encoding differences.
     * @protected
     */
    protected $diffs = [];
    /**
     * Array of used images.
     * @protected
     */
    protected $images = [];
    /**
     * Depth of the svg tag, to keep track if the svg tag is a subtag or the root tag.
     * @protected
     */
    protected $svg_tag_depth = 0;
    /**
     * Array of Annotations in pages.
     * @protected
     */
    protected $PageAnnots = [];
    /**
     * Array of internal links.
     * @protected
     */
    protected $links = [];
    /**
     * Current font family.
     * @protected
     */
    protected $FontFamily;
    /**
     * Current font style.
     * @protected
     */
    protected $FontStyle;
    /**
     * Current font ascent (distance between font top and baseline).
     * @protected
     * @since 2.8.000 (2007-03-29)
     */
    protected $FontAscent;
    /**
     * Current font descent (distance between font bottom and baseline).
     * @protected
     * @since 2.8.000 (2007-03-29)
     */
    protected $FontDescent;
    /**
     * Underlining flag.
     * @protected
     */
    protected $underline;
    /**
     * Overlining flag.
     * @protected
     */
    protected $overline;
    /**
     * Current font info.
     * @protected
     */
    protected $CurrentFont;
    /**
     * Current font size in points.
     * @protected
     */
    protected $FontSizePt;
    /**
     * Current font size in user unit.
     * @protected
     */
    protected $FontSize;
    /**
     * Commands for drawing color.
     * @protected
     */
    protected $DrawColor;
    /**
     * Commands for filling color.
     * @protected
     */
    protected $FillColor;
    /**
     * Commands for text color.
     * @protected
     */
    protected $TextColor;
    /**
     * Indicates whether fill and text colors are different.
     * @protected
     */
    protected $ColorFlag;
    /**
     * Automatic page breaking.
     * @protected
     */
    protected $AutoPageBreak;
    /**
     * Threshold used to trigger page breaks.
     * @protected
     */
    protected $PageBreakTrigger;
    /**
     * Flag set when processing page header.
     * @protected
     */
    protected $InHeader = false;
    /**
     * Flag set when processing page footer.
     * @protected
     */
    protected $InFooter = false;
    /**
     * Zoom display mode.
     * @protected
     */
    protected $ZoomMode;
    /**
     * Layout display mode.
     * @protected
     */
    protected $LayoutMode;
    /**
     * If true set the document information dictionary in Unicode.
     * @protected
     */
    protected $docinfounicode = true;
    /**
     * Document title.
     * @protected
     */
    protected $title = "";
    /**
     * Document subject.
     * @protected
     */
    protected $subject = "";
    /**
     * Document author.
     * @protected
     */
    protected $author = "";
    /**
     * Document keywords.
     * @protected
     */
    protected $keywords = "";
    /**
     * Document creator.
     * @protected
     */
    protected $creator = "";
    /**
     * Starting page number.
     * @protected
     */
    protected $starting_page_number = 1;
    /**
     * The right-bottom (or left-bottom for RTL) corner X coordinate of last inserted image.
     * @since 2002-07-31
     * @author Nicola Asuni
     * @protected
     */
    protected $img_rb_x;
    /**
     * The right-bottom corner Y coordinate of last inserted image.
     * @since 2002-07-31
     * @author Nicola Asuni
     * @protected
     */
    protected $img_rb_y;
    /**
     * Adjusting factor to convert pixels to user units.
     * @since 2004-06-14
     * @author Nicola Asuni
     * @protected
     */
    protected $imgscale = 1;
    /**
     * Boolean flag set to true when the input text is unicode (require unicode fonts).
     * @since 2005-01-02
     * @author Nicola Asuni
     * @protected
     */
    protected $isunicode = false;
    /**
     * PDF version.
     * @since 1.5.3
     * @protected
     */
    protected $PDFVersion = "1.7";
    /**
     * ID of the stored default header template (-1 = not set).
     * @protected
     */
    protected $header_xobjid = false;
    /**
     * If true reset the Header Xobject template at each page
     * @protected
     */
    protected $header_xobj_autoreset = false;
    /**
     * Minimum distance between header and top page margin.
     * @protected
     */
    protected $header_margin;
    /**
     * Minimum distance between footer and bottom page margin.
     * @protected
     */
    protected $footer_margin;
    /**
     * Original left margin value.
     * @protected
     * @since 1.53.0.TC013
     */
    protected $original_lMargin;
    /**
     * Original right margin value.
     * @protected
     * @since 1.53.0.TC013
     */
    protected $original_rMargin;
    /**
     * Default font used on page header.
     * @protected
     * @var array<int,string|float|null>
     * @phpstan-var array{0: string, 1: string, 2: float|null}
     */
    protected $header_font;
    /**
     * Default font used on page footer.
     * @protected
     * @var array<int,string|float|null>
     * @phpstan-var array{0: string, 1: string, 2: float|null}
     */
    protected $footer_font;
    /**
     * Language templates.
     * @protected
     */
    protected $l;
    /**
     * Barcode to print on page footer (only if set).
     * @protected
     */
    protected $barcode = false;
    /**
     * Boolean flag to print/hide page header.
     * @protected
     */
    protected $print_header = true;
    /**
     * Boolean flag to print/hide page footer.
     * @protected
     */
    protected $print_footer = true;
    /**
     * Header image logo.
     * @protected
     */
    protected $header_logo = "";
    /**
     * Width of header image logo in user units.
     * @protected
     */
    protected $header_logo_width = 30;
    /**
     * Title to be printed on default page header.
     * @protected
     */
    protected $header_title = "";
    /**
     * String to print on page header after title.
     * @protected
     */
    protected $header_string = "";
    /**
     * Color for header text (RGB array).
     * @since 5.9.174 (2012-07-25)
     * @protected
     * @var int[]
     * @phpstan-var array{0: int, 1: int, 2: int}
     */
    protected $header_text_color = [0, 0, 0];
    /**
     * Color for header line (RGB array).
     * @since 5.9.174 (2012-07-25)
     * @protected
     * @var int[]
     * @phpstan-var array{0: int, 1: int, 2: int}
     */
    protected $header_line_color = [0, 0, 0];
    /**
     * Color for footer text (RGB array).
     * @since 5.9.174 (2012-07-25)
     * @protected
     * @var int[]
     * @phpstan-var array{0: int, 1: int, 2: int}
     */
    protected $footer_text_color = [0, 0, 0];
    /**
     * Color for footer line (RGB array).
     * @since 5.9.174 (2012-07-25)
     * @protected
     * @var int[]
     * @phpstan-var array{0: int, 1: int, 2: int}
     */
    protected $footer_line_color = [0, 0, 0];
    /**
     * Text shadow data array.
     * @since 5.9.174 (2012-07-25)
     * @protected
     */
    protected $txtshadow = ["enabled" => false, "depth_w" => 0, "depth_h" => 0, "color" => false, "opacity" => 1, "blend_mode" => "Normal"];
    /**
     * Default number of columns for html table.
     * @protected
     */
    protected $default_table_columns = 4;
    /**
     * HTML PARSER: array to store current link and rendering styles.
     * @protected
     */
    protected $HREF = [];
    /**
     * List of available fonts on filesystem.
     * @protected
     */
    protected $fontlist = [];
    /**
     * Current foreground color.
     * @protected
     */
    protected $fgcolor;
    /**
     * HTML PARSER: array of boolean values, true in case of ordered list (OL), false otherwise.
     * @protected
     */
    protected $listordered = [];
    /**
     * HTML PARSER: array count list items on nested lists.
     * @protected
     */
    protected $listcount = [];
    /**
     * HTML PARSER: current list nesting level.
     * @protected
     */
    protected $listnum = 0;
    /**
     * HTML PARSER: indent amount for lists.
     * @protected
     */
    protected $listindent = 0;
    /**
     * HTML PARSER: current list indententation level.
     * @protected
     */
    protected $listindentlevel = 0;
    /**
     * Current background color.
     * @protected
     */
    protected $bgcolor;
    /**
     * Temporary font size in points.
     * @protected
     */
    protected $tempfontsize = 10;
    /**
     * Spacer string for LI tags.
     * @protected
     */
    protected $lispacer = "";
    /**
     * Default encoding.
     * @protected
     * @since 1.53.0.TC010
     */
    protected $encoding = "UTF-8";
    /**
     * Boolean flag to indicate if the document language is Right-To-Left.
     * @protected
     * @since 2.0.000
     */
    protected $rtl = false;
    /**
     * Boolean flag used to force RTL or LTR string direction.
     * @protected
     * @since 2.0.000
     */
    protected $tmprtl = false;
    /**
     * IBoolean flag indicating whether document is protected.
     * @protected
     * @since 2.0.000 (2008-01-02)
     */
    protected $encrypted;
    /**
     * Array containing encryption settings.
     * @protected
     * @since 5.0.005 (2010-05-11)
     */
    protected $encryptdata = [];
    /**
     * Last RC4 key encrypted (cached for optimisation).
     * @protected
     * @since 2.0.000 (2008-01-02)
     */
    protected $last_enc_key;
    /**
     * Last RC4 computed key.
     * @protected
     * @since 2.0.000 (2008-01-02)
     */
    protected $last_enc_key_c;
    /**
     * File ID (used on document trailer).
     * @protected
     * @since 5.0.005 (2010-05-12)
     */
    protected $file_id;
    /**
     * Outlines for bookmark.
     * @protected
     * @since 2.1.002 (2008-02-12)
     */
    protected $outlines = [];
    /**
     * Outline root for bookmark.
     * @protected
     * @since 2.1.002 (2008-02-12)
     */
    protected $OutlineRoot;
    /**
     * Javascript code.
     * @protected
     * @since 2.1.002 (2008-02-12)
     */
    protected $javascript = "";
    /**
     * Javascript counter.
     * @protected
     * @since 2.1.002 (2008-02-12)
     */
    protected $n_js;
    /**
     * line through state
     * @protected
     * @since 2.8.000 (2008-03-19)
     */
    protected $linethrough;
    /**
     * Array with additional document-wide usage rights for the document.
     * @protected
     * @since 5.8.014 (2010-08-23)
     */
    protected $ur = [];
    /**
     * DPI (Dot Per Inch) Document Resolution (do not change).
     * @protected
     * @since 3.0.000 (2008-03-27)
     */
    protected $dpi = 72;
    /**
     * Array of page numbers were a new page group was started (the page numbers are the keys of the array).
     * @protected
     * @since 3.0.000 (2008-03-27)
     */
    protected $newpagegroup = [];
    /**
     * Array that contains the number of pages in each page group.
     * @protected
     * @since 3.0.000 (2008-03-27)
     */
    protected $pagegroups = [];
    /**
     * Current page group number.
     * @protected
     * @since 3.0.000 (2008-03-27)
     */
    protected $currpagegroup = 0;
    /**
     * Array of transparency objects and parameters.
     * @protected
     * @since 3.0.000 (2008-03-27)
     */
    protected $extgstates;
    /**
     * Set the default JPEG compression quality (1-100).
     * @protected
     * @since 3.0.000 (2008-03-27)
     */
    protected $jpeg_quality;
    /**
     * Default cell height ratio.
     * @protected
     * @since 3.0.014 (2008-05-23)
     * @var float
     */
    protected $cell_height_ratio = K_CELL_HEIGHT_RATIO;
    /**
     * PDF viewer preferences.
     * @protected
     * @since 3.1.000 (2008-06-09)
     */
    protected $viewer_preferences;
    /**
     * A name object specifying how the document should be displayed when opened.
     * @protected
     * @since 3.1.000 (2008-06-09)
     */
    protected $PageMode;
    /**
     * Array for storing gradient information.
     * @protected
     * @since 3.1.000 (2008-06-09)
     */
    protected $gradients = [];
    /**
     * Array used to store positions inside the pages buffer (keys are the page numbers).
     * @protected
     * @since 3.2.000 (2008-06-26)
     */
    protected $intmrk = [];
    /**
     * Array used to store positions inside the pages buffer (keys are the page numbers).
     * @protected
     * @since 5.7.000 (2010-08-03)
     */
    protected $bordermrk = [];
    /**
     * Array used to store page positions to track empty pages (keys are the page numbers).
     * @protected
     * @since 5.8.007 (2010-08-18)
     */
    protected $emptypagemrk = [];
    /**
     * Array used to store content positions inside the pages buffer (keys are the page numbers).
     * @protected
     * @since 4.6.021 (2009-07-20)
     */
    protected $cntmrk = [];
    /**
     * Array used to store footer positions of each page.
     * @protected
     * @since 3.2.000 (2008-07-01)
     */
    protected $footerpos = [];
    /**
     * Array used to store footer length of each page.
     * @protected
     * @since 4.0.014 (2008-07-29)
     */
    protected $footerlen = [];
    /**
     * Boolean flag to indicate if a new line is created.
     * @protected
     * @since 3.2.000 (2008-07-01)
     */
    protected $newline = true;
    /**
     * End position of the latest inserted line.
     * @protected
     * @since 3.2.000 (2008-07-01)
     */
    protected $endlinex = 0;
    /**
     * PDF string for width value of the last line.
     * @protected
     * @since 4.0.006 (2008-07-16)
     */
    protected $linestyleWidth = "";
    /**
     * PDF string for CAP value of the last line.
     * @protected
     * @since 4.0.006 (2008-07-16)
     */
    protected $linestyleCap = "0 J";
    /**
     * PDF string for join value of the last line.
     * @protected
     * @since 4.0.006 (2008-07-16)
     */
    protected $linestyleJoin = "0 j";
    /**
     * PDF string for dash value of the last line.
     * @protected
     * @since 4.0.006 (2008-07-16)
     */
    protected $linestyleDash = "[] 0 d";
    /**
     * Boolean flag to indicate if marked-content sequence is open.
     * @protected
     * @since 4.0.013 (2008-07-28)
     */
    protected $openMarkedContent = false;
    /**
     * Count the latest inserted vertical spaces on HTML.
     * @protected
     * @since 4.0.021 (2008-08-24)
     */
    protected $htmlvspace = 0;
    /**
     * Array of Spot colors.
     * @protected
     * @since 4.0.024 (2008-09-12)
     */
    protected $spot_colors = [];
    /**
     * Symbol used for HTML unordered list items.
     * @protected
     * @since 4.0.028 (2008-09-26)
     */
    protected $lisymbol = "";
    /**
     * String used to mark the beginning and end of EPS image blocks.
     * @protected
     * @since 4.1.000 (2008-10-18)
     */
    protected $epsmarker = "x#!#EPS#!#x";
    /**
     * Array of transformation matrix.
     * @protected
     * @since 4.2.000 (2008-10-29)
     */
    protected $transfmatrix = [];
    /**
     * Current key for transformation matrix.
     * @protected
     * @since 4.8.005 (2009-09-17)
     */
    protected $transfmatrix_key = 0;
    /**
     * Booklet mode for double-sided pages.
     * @protected
     * @since 4.2.000 (2008-10-29)
     */
    protected $booklet = false;
    /**
     * Epsilon value used for float calculations.
     * @protected
     * @since 4.2.000 (2008-10-29)
     */
    protected $feps = 0.005;
    /**
     * Array used for custom vertical spaces for HTML tags.
     * @protected
     * @since 4.2.001 (2008-10-30)
     */
    protected $tagvspaces = [];
    /**
     * HTML PARSER: custom indent amount for lists. Negative value means disabled.
     * @protected
     * @since 4.2.007 (2008-11-12)
     */
    protected $customlistindent = -1;
    /**
     * Boolean flag to indicate if the border of the cell sides that cross the page should be removed.
     * @protected
     * @since 4.2.010 (2008-11-14)
     */
    protected $opencell = true;
    /**
     * Array of files to embedd.
     * @protected
     * @since 4.4.000 (2008-12-07)
     */
    protected $embeddedfiles = [];
    /**
     * Boolean flag to indicate if we are inside a PRE tag.
     * @protected
     * @since 4.4.001 (2008-12-08)
     */
    protected $premode = false;
    /**
     * Array used to store positions of graphics transformation blocks inside the page buffer.
     * keys are the page numbers
     * @protected
     * @since 4.4.002 (2008-12-09)
     */
    protected $transfmrk = [];
    /**
     * Default color for html links.
     * @protected
     * @since 4.4.003 (2008-12-09)
     */
    protected $htmlLinkColorArray = [0, 0, 255];
    /**
     * Default font style to add to html links.
     * @protected
     * @since 4.4.003 (2008-12-09)
     */
    protected $htmlLinkFontStyle = "U";
    /**
     * Counts the number of pages.
     * @protected
     * @since 4.5.000 (2008-12-31)
     */
    protected $numpages = 0;
    /**
     * Array containing page lengths in bytes.
     * @protected
     * @since 4.5.000 (2008-12-31)
     */
    protected $pagelen = [];
    /**
     * Counts the number of pages.
     * @protected
     * @since 4.5.000 (2008-12-31)
     */
    protected $numimages = 0;
    /**
     * Store the image keys.
     * @protected
     * @since 4.5.000 (2008-12-31)
     */
    protected $imagekeys = [];
    /**
     * Length of the buffer in bytes.
     * @protected
     * @since 4.5.000 (2008-12-31)
     */
    protected $bufferlen = 0;
    /**
     * Counts the number of fonts.
     * @protected
     * @since 4.5.000 (2009-01-02)
     */
    protected $numfonts = 0;
    /**
     * Store the font keys.
     * @protected
     * @since 4.5.000 (2009-01-02)
     */
    protected $fontkeys = [];
    /**
     * Store the font object IDs.
     * @protected
     * @since 4.8.001 (2009-09-09)
     */
    protected $font_obj_ids = [];
    /**
     * Store the fage status (true when opened, false when closed).
     * @protected
     * @since 4.5.000 (2009-01-02)
     */
    protected $pageopen = [];
    /**
     * Default monospace font.
     * @protected
     * @since 4.5.025 (2009-03-10)
     */
    protected $default_monospaced_font = "courier";
    /**
     * Cloned copy of the current class object.
     * @protected
     * @since 4.5.029 (2009-03-19)
     */
    protected $objcopy;
    /**
     * Array used to store the lengths of cache files.
     * @protected
     * @since 4.5.029 (2009-03-19)
     */
    protected $cache_file_length = [];
    /**
     * Table header content to be repeated on each new page.
     * @protected
     * @since 4.5.030 (2009-03-20)
     */
    protected $thead = "";
    /**
     * Margins used for table header.
     * @protected
     * @since 4.5.030 (2009-03-20)
     */
    protected $theadMargins = [];
    /**
     * Boolean flag to enable document digital signature.
     * @protected
     * @since 4.6.005 (2009-04-24)
     */
    protected $sign = false;
    /**
     * Digital signature data.
     * @protected
     * @since 4.6.005 (2009-04-24)
     */
    protected $signature_data = [];
    /**
     * Digital signature max length.
     * @protected
     * @since 4.6.005 (2009-04-24)
     */
    protected $signature_max_length = 11742;
    /**
     * Data for digital signature appearance.
     * @protected
     * @since 5.3.011 (2010-06-16)
     */
    protected $signature_appearance = ["page" => 1, "rect" => "0 0 0 0"];
    /**
     * Array of empty digital signature appearances.
     * @protected
     * @since 5.9.101 (2011-07-06)
     */
    protected $empty_signature_appearance = [];
    /**
     * Boolean flag to enable document timestamping with TSA.
     * @protected
     * @since 6.0.085 (2014-06-19)
     */
    protected $tsa_timestamp = false;
    /**
     * Timestamping data.
     * @protected
     * @since 6.0.085 (2014-06-19)
     */
    protected $tsa_data = [];
    /**
     * Regular expression used to find blank characters (required for word-wrapping).
     * @protected
     * @since 4.6.006 (2009-04-28)
     */
    protected $re_spaces = "/[^\\S\\xa0]/";
    /**
     * Array of $re_spaces parts.
     * @protected
     * @since 5.5.011 (2010-07-09)
     */
    protected $re_space = ["p" => "[^\\S\\xa0]", "m" => ""];
    /**
     * Digital signature object ID.
     * @protected
     * @since 4.6.022 (2009-06-23)
     */
    protected $sig_obj_id = 0;
    /**
     * ID of page objects.
     * @protected
     * @since 4.7.000 (2009-08-29)
     */
    protected $page_obj_id = [];
    /**
     * List of form annotations IDs.
     * @protected
     * @since 4.8.000 (2009-09-07)
     */
    protected $form_obj_id = [];
    /**
     * Deafult Javascript field properties. Possible values are described on official Javascript for Acrobat API reference. Annotation options can be directly specified using the 'aopt' entry.
     * @protected
     * @since 4.8.000 (2009-09-07)
     */
    protected $default_form_prop = ["lineWidth" => 1, "borderStyle" => "solid", "fillColor" => [255, 255, 255], "strokeColor" => [128, 128, 128]];
    /**
     * Javascript objects array.
     * @protected
     * @since 4.8.000 (2009-09-07)
     */
    protected $js_objects = [];
    /**
     * Current form action (used during XHTML rendering).
     * @protected
     * @since 4.8.000 (2009-09-07)
     */
    protected $form_action = "";
    /**
     * Current form encryption type (used during XHTML rendering).
     * @protected
     * @since 4.8.000 (2009-09-07)
     */
    protected $form_enctype = "application/x-www-form-urlencoded";
    /**
     * Current method to submit forms.
     * @protected
     * @since 4.8.000 (2009-09-07)
     */
    protected $form_mode = "post";
    /**
     * List of fonts used on form fields (fontname => fontkey).
     * @protected
     * @since 4.8.001 (2009-09-09)
     */
    protected $annotation_fonts = [];
    /**
     * List of radio buttons parent objects.
     * @protected
     * @since 4.8.001 (2009-09-09)
     */
    protected $radiobutton_groups = [];
    /**
     * List of radio group objects IDs.
     * @protected
     * @since 4.8.001 (2009-09-09)
     */
    protected $radio_groups = [];
    /**
     * Text indentation value (used for text-indent CSS attribute).
     * @protected
     * @since 4.8.006 (2009-09-23)
     */
    protected $textindent = 0;
    /**
     * Store page number when startTransaction() is called.
     * @protected
     * @since 4.8.006 (2009-09-23)
     */
    protected $start_transaction_page = 0;
    /**
     * Store Y position when startTransaction() is called.
     * @protected
     * @since 4.9.001 (2010-03-28)
     */
    protected $start_transaction_y = 0;
    /**
     * True when we are printing the thead section on a new page.
     * @protected
     * @since 4.8.027 (2010-01-25)
     */
    protected $inthead = false;
    /**
     * Array of column measures (width, space, starting Y position).
     * @protected
     * @since 4.9.001 (2010-03-28)
     */
    protected $columns = [];
    /**
     * Number of colums.
     * @protected
     * @since 4.9.001 (2010-03-28)
     */
    protected $num_columns = 1;
    /**
     * Current column number.
     * @protected
     * @since 4.9.001 (2010-03-28)
     */
    protected $current_column = 0;
    /**
     * Starting page for columns.
     * @protected
     * @since 4.9.001 (2010-03-28)
     */
    protected $column_start_page = 0;
    /**
     * Maximum page and column selected.
     * @protected
     * @since 5.8.000 (2010-08-11)
     */
    protected $maxselcol = ["page" => 0, "column" => 0];
    /**
     * Array of: X difference between table cell x start and starting page margin, cellspacing, cellpadding.
     * @protected
     * @since 5.8.000 (2010-08-11)
     */
    protected $colxshift = ["x" => 0, "s" => ["H" => 0, "V" => 0], "p" => ["L" => 0, "T" => 0, "R" => 0, "B" => 0]];
    /**
     * Text rendering mode: 0 = Fill text; 1 = Stroke text; 2 = Fill, then stroke text; 3 = Neither fill nor stroke text (invisible); 4 = Fill text and add to path for clipping; 5 = Stroke text and add to path for clipping; 6 = Fill, then stroke text and add to path for clipping; 7 = Add text to path for clipping.
     * @protected
     * @since 4.9.008 (2010-04-03)
     */
    protected $textrendermode = 0;
    /**
     * Text stroke width in doc units.
     * @protected
     * @since 4.9.008 (2010-04-03)
     */
    protected $textstrokewidth = 0;
    /**
     * Current stroke color.
     * @protected
     * @since 4.9.008 (2010-04-03)
     */
    protected $strokecolor;
    /**
     * Default unit of measure for document.
     * @protected
     * @since 5.0.000 (2010-04-22)
     */
    protected $pdfunit = "mm";
    /**
     * Boolean flag true when we are on TOC (Table Of Content) page.
     * @protected
     */
    protected $tocpage = false;
    /**
     * Boolean flag: if true convert vector images (SVG, EPS) to raster image using GD or ImageMagick library.
     * @protected
     * @since 5.0.000 (2010-04-26)
     */
    protected $rasterize_vector_images = false;
    /**
     * Boolean flag: if true enables font subsetting by default.
     * @protected
     * @since 5.3.002 (2010-06-07)
     */
    protected $font_subsetting = true;
    /**
     * Array of default graphic settings.
     * @protected
     * @since 5.5.008 (2010-07-02)
     */
    protected $default_graphic_vars = [];
    /**
     * Array of XObjects.
     * @protected
     * @since 5.8.014 (2010-08-23)
     */
    protected $xobjects = [];
    /**
     * Boolean value true when we are inside an XObject.
     * @protected
     * @since 5.8.017 (2010-08-24)
     */
    protected $inxobj = false;
    /**
     * Current XObject ID.
     * @protected
     * @since 5.8.017 (2010-08-24)
     */
    protected $xobjid = "";
    /**
     * Percentage of character stretching.
     * @protected
     * @since 5.9.000 (2010-09-29)
     */
    protected $font_stretching = 100;
    /**
     * Increases or decreases the space between characters in a text by the specified amount (tracking).
     * @protected
     * @since 5.9.000 (2010-09-29)
     */
    protected $font_spacing = 0;
    /**
     * Array of no-write regions.
     * ('page' => page number or empy for current page, 'xt' => X top, 'yt' => Y top, 'xb' => X bottom, 'yb' => Y bottom, 'side' => page side 'L' = left or 'R' = right)
     * @protected
     * @since 5.9.003 (2010-10-14)
     */
    protected $page_regions = [];
    /**
     * Boolean value true when page region check is active.
     * @protected
     */
    protected $check_page_regions = true;
    /**
     * Array of PDF layers data.
     * @protected
     * @since 5.9.102 (2011-07-13)
     */
    protected $pdflayers = [];
    /**
     * A dictionary of names and corresponding destinations (Dests key on document Catalog).
     * @protected
     * @since 5.9.097 (2011-06-23)
     */
    protected $dests = [];
    /**
     * Object ID for Named Destinations
     * @protected
     * @since 5.9.097 (2011-06-23)
     */
    protected $n_dests;
    /**
     * Embedded Files Names
     * @protected
     * @since 5.9.204 (2013-01-23)
     */
    protected $efnames = [];
    /**
     * Directory used for the last SVG image.
     * @protected
     * @since 5.0.000 (2010-05-05)
     */
    protected $svgdir = "";
    /**
     *  Deafult unit of measure for SVG.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svgunit = "px";
    /**
     * Array of SVG gradients.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svggradients = [];
    /**
     * ID of last SVG gradient.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svggradientid = 0;
    /**
     * Boolean value true when in SVG defs group.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svgdefsmode = false;
    /**
     * Array of SVG defs.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svgdefs = [];
    /**
     * Boolean value true when in SVG clipPath tag.
     * @protected
     * @since 5.0.000 (2010-04-26)
     */
    protected $svgclipmode = false;
    /**
     * Array of SVG clipPath commands.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svgclippaths = [];
    /**
     * Array of SVG clipPath tranformation matrix.
     * @protected
     * @since 5.8.022 (2010-08-31)
     */
    protected $svgcliptm = [];
    /**
     * ID of last SVG clipPath.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svgclipid = 0;
    /**
     * SVG text.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svgtext = "";
    /**
     * SVG text properties.
     * @protected
     * @since 5.8.013 (2010-08-23)
     */
    protected $svgtextmode = [];
    /**
     * Array of SVG properties.
     * @protected
     * @since 5.0.000 (2010-05-02)
     */
    protected $svgstyles = [["alignment-baseline" => "auto", "baseline-shift" => "baseline", "clip" => "auto", "clip-path" => "none", "clip-rule" => "nonzero", "color" => "black", "color-interpolation" => "sRGB", "color-interpolation-filters" => "linearRGB", "color-profile" => "auto", "color-rendering" => "auto", "cursor" => "auto", "direction" => "ltr", "display" => "inline", "dominant-baseline" => "auto", "enable-background" => "accumulate", "fill" => "black", "fill-opacity" => 1, "fill-rule" => "nonzero", "filter" => "none", "flood-color" => "black", "flood-opacity" => 1, "font" => "", "font-family" => "helvetica", "font-size" => "medium", "font-size-adjust" => "none", "font-stretch" => "normal", "font-style" => "normal", "font-variant" => "normal", "font-weight" => "normal", "glyph-orientation-horizontal" => "0deg", "glyph-orientation-vertical" => "auto", "image-rendering" => "auto", "kerning" => "auto", "letter-spacing" => "normal", "lighting-color" => "white", "marker" => "", "marker-end" => "none", "marker-mid" => "none", "marker-start" => "none", "mask" => "none", "opacity" => 1, "overflow" => "auto", "pointer-events" => "visiblePainted", "shape-rendering" => "auto", "stop-color" => "black", "stop-opacity" => 1, "stroke" => "none", "stroke-dasharray" => "none", "stroke-dashoffset" => 0, "stroke-linecap" => "butt", "stroke-linejoin" => "miter", "stroke-miterlimit" => 4, "stroke-opacity" => 1, "stroke-width" => 1, "text-anchor" => "start", "text-decoration" => "none", "text-rendering" => "auto", "unicode-bidi" => "normal", "visibility" => "visible", "word-spacing" => "normal", "writing-mode" => "lr-tb", "text-color" => "black", "transfmatrix" => [1, 0, 0, 1, 0, 0]]];
    /**
     * If true force sRGB color profile for all document.
     * @protected
     * @since 5.9.121 (2011-09-28)
     */
    protected $force_srgb = false;
    /**
     * If true set the document to PDF/A mode.
     * @protected
     * @since 5.9.121 (2011-09-27)
     */
    protected $pdfa_mode = false;
    /**
     * version of PDF/A mode (1 - 3).
     * @protected
     * @since 6.2.26 (2019-03-12)
     */
    protected $pdfa_version = 1;
    /**
     * Document creation date-time
     * @protected
     * @since 5.9.152 (2012-03-22)
     */
    protected $doc_creation_timestamp;
    /**
     * Document modification date-time
     * @protected
     * @since 5.9.152 (2012-03-22)
     */
    protected $doc_modification_timestamp;
    /**
     * Custom XMP data.
     * @protected
     * @since 5.9.128 (2011-10-06)
     */
    protected $custom_xmp = "";
    /**
     * Custom XMP RDF data.
     * @protected
     * @since 6.3.0 (2019-09-19)
     */
    protected $custom_xmp_rdf = "";
    /**
     * Overprint mode array.
     * (Check the "Entries in a Graphics State Parameter Dictionary" on PDF 32000-1:2008).
     * @protected
     * @since 5.9.152 (2012-03-23)
     * @var array<string,bool|int>
     */
    protected $overprint = ["OP" => false, "op" => false, "OPM" => 0];
    /**
     * Alpha mode array.
     * (Check the "Entries in a Graphics State Parameter Dictionary" on PDF 32000-1:2008).
     * @protected
     * @since 5.9.152 (2012-03-23)
     */
    protected $alpha = ["CA" => 1, "ca" => 1, "BM" => "/Normal", "AIS" => false];
    /**
     * Define the page boundaries boxes to be set on document.
     * @protected
     * @since 5.9.152 (2012-03-23)
     */
    protected $page_boxes = ["MediaBox", "CropBox", "BleedBox", "TrimBox", "ArtBox"];
    /**
     * If true print TCPDF meta link.
     * @protected
     * @since 5.9.152 (2012-03-23)
     */
    protected $tcpdflink = true;
    /**
     * Cache array for computed GD gamma values.
     * @protected
     * @since 5.9.1632 (2012-06-05)
     */
    protected $gdgammacache = [];
    /**
     * Cache array for file content
     * @protected
     * @var array
     * @since 6.3.5 (2020-09-28)
     */
    protected $fileContentCache = [];
    /**
     * Whether to allow local file path in image html tags, when prefixed with file://
     *
     * @var bool
     * @protected
     * @since 6.4 (2020-07-23)
     */
    protected $allowLocalFiles = false;
    protected static $cleaned_ids = [];
    public function __construct($orientation = "P", $unit = "mm", $format = "A4", $unicode = true, $encoding = "UTF-8", $diskcache = false, $pdfa = false)
    {
        $serformat = is_array($format) ? json_encode($format) : $format;
        $this->file_id = md5(TCPDF_STATIC::getRandomSeed("TCPDF" . $orientation . $unit . $serformat . $encoding));
        $this->font_obj_ids = [];
        $this->page_obj_id = [];
        $this->form_obj_id = [];
        if($pdfa) {
            $this->pdfa_mode = true;
            $this->pdfa_version = $pdfa;
        } else {
            $this->pdfa_mode = false;
        }
        $this->force_srgb = false;
        $this->rtl = false;
        $this->tmprtl = false;
        $this->_dochecks();
        $this->isunicode = $unicode;
        $this->page = 0;
        $this->transfmrk[0] = [];
        $this->pagedim = [];
        $this->n = 2;
        $this->buffer = "";
        $this->pages = [];
        $this->state = 0;
        $this->fonts = [];
        $this->FontFiles = [];
        $this->diffs = [];
        $this->images = [];
        $this->links = [];
        $this->gradients = [];
        $this->InFooter = false;
        $this->lasth = 0;
        $this->FontFamily = defined("PDF_FONT_NAME_MAIN") ? PDF_FONT_NAME_MAIN : "helvetica";
        $this->FontStyle = "";
        $this->FontSizePt = 12;
        $this->underline = false;
        $this->overline = false;
        $this->linethrough = false;
        $this->DrawColor = "0 G";
        $this->FillColor = "0 g";
        $this->TextColor = "0 g";
        $this->ColorFlag = false;
        $this->pdflayers = [];
        $this->encrypted = false;
        $this->last_enc_key = "";
        $this->CoreFonts = ["courier" => "Courier", "courierB" => "Courier-Bold", "courierI" => "Courier-Oblique", "courierBI" => "Courier-BoldOblique", "helvetica" => "Helvetica", "helveticaB" => "Helvetica-Bold", "helveticaI" => "Helvetica-Oblique", "helveticaBI" => "Helvetica-BoldOblique", "times" => "Times-Roman", "timesB" => "Times-Bold", "timesI" => "Times-Italic", "timesBI" => "Times-BoldItalic", "symbol" => "Symbol", "zapfdingbats" => "ZapfDingbats"];
        $this->setPageUnit($unit);
        $this->setPageFormat($format, $orientation);
        $margin = 0 / $this->k;
        $this->setMargins($margin, $margin);
        $this->clMargin = $this->lMargin;
        $this->crMargin = $this->rMargin;
        $cpadding = $margin / 10;
        $this->setCellPaddings($cpadding, 0, $cpadding, 0);
        $this->setCellMargins(0, 0, 0, 0);
        $this->LineWidth = 0 / $this->k;
        $this->linestyleWidth = sprintf("%F w", $this->LineWidth * $this->k);
        $this->linestyleCap = "0 J";
        $this->linestyleJoin = "0 j";
        $this->linestyleDash = "[] 0 d";
        $this->setAutoPageBreak(true, 2 * $margin);
        $this->setDisplayMode("fullwidth");
        $this->setCompression();
        $this->setPDFVersion();
        $this->tcpdflink = true;
        $this->encoding = $encoding;
        $this->HREF = [];
        $this->getFontsList();
        $this->fgcolor = ["R" => 0, "G" => 0, "B" => 0];
        $this->strokecolor = ["R" => 0, "G" => 0, "B" => 0];
        $this->bgcolor = ["R" => 255, "G" => 255, "B" => 255];
        $this->extgstates = [];
        $this->setTextShadow();
        $this->sign = false;
        $this->tsa_timestamp = false;
        $this->tsa_data = [];
        $this->signature_appearance = ["page" => 1, "rect" => "0 0 0 0", "name" => "Signature"];
        $this->empty_signature_appearance = [];
        $this->ur["enabled"] = false;
        $this->ur["document"] = "/FullSave";
        $this->ur["annots"] = "/Create/Delete/Modify/Copy/Import/Export";
        $this->ur["form"] = "/Add/Delete/FillIn/Import/Export/SubmitStandalone/SpawnTemplate";
        $this->ur["signature"] = "/Modify";
        $this->ur["ef"] = "/Create/Delete/Modify/Import";
        $this->ur["formex"] = "";
        $this->jpeg_quality = 75;
        TCPDF_FONTS::utf8Bidi([], "", false, $this->isunicode, $this->CurrentFont);
        $this->setFont($this->FontFamily, $this->FontStyle, $this->FontSizePt);
        $this->setHeaderFont([$this->FontFamily, $this->FontStyle, $this->FontSizePt]);
        $this->setFooterFont([$this->FontFamily, $this->FontStyle, $this->FontSizePt]);
        if($this->isunicode && @preg_match("/\\pL/u", "a") == 1) {
            $this->setSpacesRE("/(?!\\xa0)[\\s\\p{Z}]/u");
        } else {
            $this->setSpacesRE("/[^\\S\\xa0]/");
        }
        $this->default_form_prop = ["lineWidth" => 1, "borderStyle" => "solid", "fillColor" => [255, 255, 255], "strokeColor" => [128, 128, 128]];
        $this->doc_creation_timestamp = time();
        $this->doc_modification_timestamp = $this->doc_creation_timestamp;
        $this->default_graphic_vars = $this->getGraphicVars();
        $this->header_xobj_autoreset = false;
        $this->custom_xmp = "";
        $this->custom_xmp_rdf = "";
        register_shutdown_function([$this, "_destroy"], true);
    }
    public function __destruct()
    {
        $this->_destroy(true);
    }
    public function setPageUnit($unit)
    {
        $unit = strtolower($unit);
        switch ($unit) {
            case "px":
            case "pt":
                $this->k = 1;
                break;
            case "mm":
                $this->k = $this->dpi / 0;
                break;
            case "cm":
                $this->k = $this->dpi / 0;
                break;
            case "in":
                $this->k = $this->dpi;
                break;
            default:
                $this->Error("Incorrect unit: " . $unit);
                $this->pdfunit = $unit;
                if(isset($this->CurOrientation)) {
                    $this->setPageOrientation($this->CurOrientation);
                }
        }
    }
    protected function setPageFormat($format, $orientation = "P")
    {
        if(!empty($format) && isset($this->pagedim[$this->page])) {
            unset($this->pagedim[$this->page]);
        }
        if(is_string($format)) {
            $pf = TCPDF_STATIC::getPageSizeFromFormat($format);
            list($this->fwPt, $this->fhPt) = $pf;
        } else {
            if(isset($format["MediaBox"])) {
                $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "MediaBox", $format["MediaBox"]["llx"], $format["MediaBox"]["lly"], $format["MediaBox"]["urx"], $format["MediaBox"]["ury"], false, $this->k, $this->pagedim);
                $this->fwPt = ($format["MediaBox"]["urx"] - $format["MediaBox"]["llx"]) * $this->k;
                $this->fhPt = ($format["MediaBox"]["ury"] - $format["MediaBox"]["lly"]) * $this->k;
            } else {
                if(isset($format[0]) && is_numeric($format[0]) && isset($format[1]) && is_numeric($format[1])) {
                    $pf = [$format[0] * $this->k, $format[1] * $this->k];
                } else {
                    if(!isset($format["format"])) {
                        $format["format"] = "A4";
                    }
                    $pf = TCPDF_STATIC::getPageSizeFromFormat($format["format"]);
                }
                list($this->fwPt, $this->fhPt) = $pf;
                $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "MediaBox", 0, 0, $this->fwPt, $this->fhPt, true, $this->k, $this->pagedim);
            }
            if(isset($format["CropBox"])) {
                $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "CropBox", $format["CropBox"]["llx"], $format["CropBox"]["lly"], $format["CropBox"]["urx"], $format["CropBox"]["ury"], false, $this->k, $this->pagedim);
            }
            if(isset($format["BleedBox"])) {
                $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "BleedBox", $format["BleedBox"]["llx"], $format["BleedBox"]["lly"], $format["BleedBox"]["urx"], $format["BleedBox"]["ury"], false, $this->k, $this->pagedim);
            }
            if(isset($format["TrimBox"])) {
                $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "TrimBox", $format["TrimBox"]["llx"], $format["TrimBox"]["lly"], $format["TrimBox"]["urx"], $format["TrimBox"]["ury"], false, $this->k, $this->pagedim);
            }
            if(isset($format["ArtBox"])) {
                $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "ArtBox", $format["ArtBox"]["llx"], $format["ArtBox"]["lly"], $format["ArtBox"]["urx"], $format["ArtBox"]["ury"], false, $this->k, $this->pagedim);
            }
            if(isset($format["BoxColorInfo"])) {
                $this->pagedim[$this->page]["BoxColorInfo"] = $format["BoxColorInfo"];
            }
            if(isset($format["Rotate"]) && $format["Rotate"] % 90 == 0) {
                $this->pagedim[$this->page]["Rotate"] = intval($format["Rotate"]);
            }
            if(isset($format["PZ"])) {
                $this->pagedim[$this->page]["PZ"] = floatval($format["PZ"]);
            }
            if(isset($format["trans"])) {
                if(isset($format["trans"]["Dur"])) {
                    $this->pagedim[$this->page]["trans"]["Dur"] = floatval($format["trans"]["Dur"]);
                }
                $stansition_styles = ["Split", "Blinds", "Box", "Wipe", "Dissolve", "Glitter", "R", "Fly", "Push", "Cover", "Uncover", "Fade"];
                if(isset($format["trans"]["S"]) && in_array($format["trans"]["S"], $stansition_styles)) {
                    $this->pagedim[$this->page]["trans"]["S"] = $format["trans"]["S"];
                    $valid_effect = ["Split", "Blinds"];
                    $valid_vals = ["H", "V"];
                    if(isset($format["trans"]["Dm"]) && in_array($format["trans"]["S"], $valid_effect) && in_array($format["trans"]["Dm"], $valid_vals)) {
                        $this->pagedim[$this->page]["trans"]["Dm"] = $format["trans"]["Dm"];
                    }
                    $valid_effect = ["Split", "Box", "Fly"];
                    $valid_vals = ["I", "O"];
                    if(isset($format["trans"]["M"]) && in_array($format["trans"]["S"], $valid_effect) && in_array($format["trans"]["M"], $valid_vals)) {
                        $this->pagedim[$this->page]["trans"]["M"] = $format["trans"]["M"];
                    }
                    $valid_effect = ["Wipe", "Glitter", "Fly", "Cover", "Uncover", "Push"];
                    if(isset($format["trans"]["Di"]) && in_array($format["trans"]["S"], $valid_effect) && (($format["trans"]["Di"] == 90 || $format["trans"]["Di"] == 180) && $format["trans"]["S"] == "Wipe" || $format["trans"]["Di"] == 315 && $format["trans"]["S"] == "Glitter" || $format["trans"]["Di"] == 0 || $format["trans"]["Di"] == 270)) {
                        $this->pagedim[$this->page]["trans"]["Di"] = intval($format["trans"]["Di"]);
                    }
                    if(isset($format["trans"]["SS"]) && $format["trans"]["S"] == "Fly") {
                        $this->pagedim[$this->page]["trans"]["SS"] = floatval($format["trans"]["SS"]);
                    }
                    if(isset($format["trans"]["B"]) && $format["trans"]["B"] === true && $format["trans"]["S"] == "Fly") {
                        $this->pagedim[$this->page]["trans"]["B"] = "true";
                    }
                } else {
                    $this->pagedim[$this->page]["trans"]["S"] = "R";
                }
                if(isset($format["trans"]["D"])) {
                    $this->pagedim[$this->page]["trans"]["D"] = floatval($format["trans"]["D"]);
                } else {
                    $this->pagedim[$this->page]["trans"]["D"] = 1;
                }
            }
        }
        $this->setPageOrientation($orientation);
    }
    public function setPageOrientation($orientation, $autopagebreak = NULL, $bottommargin = NULL)
    {
        if(!isset($this->pagedim[$this->page]["MediaBox"])) {
            $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "MediaBox", 0, 0, $this->fwPt, $this->fhPt, true, $this->k, $this->pagedim);
        }
        if(!isset($this->pagedim[$this->page]["CropBox"])) {
            $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "CropBox", $this->pagedim[$this->page]["MediaBox"]["llx"], $this->pagedim[$this->page]["MediaBox"]["lly"], $this->pagedim[$this->page]["MediaBox"]["urx"], $this->pagedim[$this->page]["MediaBox"]["ury"], true, $this->k, $this->pagedim);
        }
        if(!isset($this->pagedim[$this->page]["BleedBox"])) {
            $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "BleedBox", $this->pagedim[$this->page]["CropBox"]["llx"], $this->pagedim[$this->page]["CropBox"]["lly"], $this->pagedim[$this->page]["CropBox"]["urx"], $this->pagedim[$this->page]["CropBox"]["ury"], true, $this->k, $this->pagedim);
        }
        if(!isset($this->pagedim[$this->page]["TrimBox"])) {
            $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "TrimBox", $this->pagedim[$this->page]["CropBox"]["llx"], $this->pagedim[$this->page]["CropBox"]["lly"], $this->pagedim[$this->page]["CropBox"]["urx"], $this->pagedim[$this->page]["CropBox"]["ury"], true, $this->k, $this->pagedim);
        }
        if(!isset($this->pagedim[$this->page]["ArtBox"])) {
            $this->pagedim = TCPDF_STATIC::setPageBoxes($this->page, "ArtBox", $this->pagedim[$this->page]["CropBox"]["llx"], $this->pagedim[$this->page]["CropBox"]["lly"], $this->pagedim[$this->page]["CropBox"]["urx"], $this->pagedim[$this->page]["CropBox"]["ury"], true, $this->k, $this->pagedim);
        }
        if(!isset($this->pagedim[$this->page]["Rotate"])) {
            $this->pagedim[$this->page]["Rotate"] = 0;
        }
        if(!isset($this->pagedim[$this->page]["PZ"])) {
            $this->pagedim[$this->page]["PZ"] = 1;
        }
        if($this->fhPt < $this->fwPt) {
            $default_orientation = "L";
        } else {
            $default_orientation = "P";
        }
        $valid_orientations = ["P", "L"];
        if(empty($orientation)) {
            $orientation = $default_orientation;
        } else {
            $orientation = strtoupper($orientation[0]);
        }
        if(in_array($orientation, $valid_orientations) && $orientation != $default_orientation) {
            $this->CurOrientation = $orientation;
            $this->wPt = $this->fhPt;
            $this->hPt = $this->fwPt;
        } else {
            $this->CurOrientation = $default_orientation;
            $this->wPt = $this->fwPt;
            $this->hPt = $this->fhPt;
        }
        if(abs($this->pagedim[$this->page]["MediaBox"]["urx"] - $this->hPt) < $this->feps && abs($this->pagedim[$this->page]["MediaBox"]["ury"] - $this->wPt) < $this->feps) {
            $this->pagedim = TCPDF_STATIC::swapPageBoxCoordinates($this->page, $this->pagedim);
        }
        $this->w = $this->wPt / $this->k;
        $this->h = $this->hPt / $this->k;
        if(TCPDF_STATIC::empty_string($autopagebreak)) {
            if(isset($this->AutoPageBreak)) {
                $autopagebreak = $this->AutoPageBreak;
            } else {
                $autopagebreak = true;
            }
        }
        if(TCPDF_STATIC::empty_string($bottommargin)) {
            if(isset($this->bMargin)) {
                $bottommargin = $this->bMargin;
            } else {
                $bottommargin = 0 / $this->k;
            }
        }
        $this->setAutoPageBreak($autopagebreak, $bottommargin);
        $this->pagedim[$this->page]["w"] = $this->wPt;
        $this->pagedim[$this->page]["h"] = $this->hPt;
        $this->pagedim[$this->page]["wk"] = $this->w;
        $this->pagedim[$this->page]["hk"] = $this->h;
        $this->pagedim[$this->page]["tm"] = $this->tMargin;
        $this->pagedim[$this->page]["bm"] = $bottommargin;
        $this->pagedim[$this->page]["lm"] = $this->lMargin;
        $this->pagedim[$this->page]["rm"] = $this->rMargin;
        $this->pagedim[$this->page]["pb"] = $autopagebreak;
        $this->pagedim[$this->page]["or"] = $this->CurOrientation;
        $this->pagedim[$this->page]["olm"] = $this->original_lMargin;
        $this->pagedim[$this->page]["orm"] = $this->original_rMargin;
    }
    public function setSpacesRE($re = "/[^\\S\\xa0]/")
    {
        $this->re_spaces = $re;
        $re_parts = explode("/", $re);
        $this->re_space = [];
        if(isset($re_parts[1]) && !empty($re_parts[1])) {
            $this->re_space["p"] = $re_parts[1];
        } else {
            $this->re_space["p"] = "[\\s]";
        }
        if(isset($re_parts[2]) && !empty($re_parts[2])) {
            $this->re_space["m"] = $re_parts[2];
        } else {
            $this->re_space["m"] = "";
        }
    }
    public function setRTL($enable, $resetx = true)
    {
        $enable = $enable ? true : false;
        $resetx = $resetx && $enable != $this->rtl;
        $this->rtl = $enable;
        $this->tmprtl = false;
        if($resetx) {
            $this->Ln(0);
        }
    }
    public function getRTL()
    {
        return $this->rtl;
    }
    public function setTempRTL($mode)
    {
        $newmode = false;
        strtoupper($mode);
        switch (strtoupper($mode)) {
            case "LTR":
            case "L":
                if($this->rtl) {
                    $newmode = "L";
                }
                break;
            case "RTL":
            case "R":
                if(!$this->rtl) {
                    $newmode = "R";
                }
                break;
            case false:
            default:
                $newmode = false;
                $this->tmprtl = $newmode;
        }
    }
    public function isRTLTextDir()
    {
        return $this->rtl || $this->tmprtl == "R";
    }
    public function setLastH($h)
    {
        $this->lasth = $h;
    }
    public function getCellHeight($fontsize, $padding = true)
    {
        $height = $fontsize * $this->cell_height_ratio;
        if($padding) {
            $height += $this->cell_padding["T"] + $this->cell_padding["B"];
        }
        return round($height, 6);
    }
    public function resetLastH()
    {
        $this->lasth = $this->getCellHeight($this->FontSize);
    }
    public function getLastH()
    {
        return $this->lasth;
    }
    public function setImageScale($scale)
    {
        $this->imgscale = $scale;
    }
    public function getImageScale()
    {
        return $this->imgscale;
    }
    public function getPageDimensions($pagenum = NULL)
    {
        if(empty($pagenum)) {
            $pagenum = $this->page;
        }
        return $this->pagedim[$pagenum];
    }
    public function getPageWidth($pagenum = NULL)
    {
        if(empty($pagenum)) {
            return $this->w;
        }
        return $this->pagedim[$pagenum]["w"];
    }
    public function getPageHeight($pagenum = NULL)
    {
        if(empty($pagenum)) {
            return $this->h;
        }
        return $this->pagedim[$pagenum]["h"];
    }
    public function getBreakMargin($pagenum = NULL)
    {
        if(empty($pagenum)) {
            return $this->bMargin;
        }
        return $this->pagedim[$pagenum]["bm"];
    }
    public function getScaleFactor()
    {
        return $this->k;
    }
    public function setMargins($left, $top, $right = NULL, $keepmargins = false)
    {
        $this->lMargin = $left;
        $this->tMargin = $top;
        if($right == -1 || $right === NULL) {
            $right = $left;
        }
        $this->rMargin = $right;
        if($keepmargins) {
            $this->original_lMargin = $this->lMargin;
            $this->original_rMargin = $this->rMargin;
        }
    }
    public function setLeftMargin($margin)
    {
        $this->lMargin = $margin;
        if(0 < $this->page && $this->x < $margin) {
            $this->x = $margin;
        }
    }
    public function setTopMargin($margin)
    {
        $this->tMargin = $margin;
        if(0 < $this->page && $this->y < $margin) {
            $this->y = $margin;
        }
    }
    public function setRightMargin($margin)
    {
        $this->rMargin = $margin;
        if(0 < $this->page && $this->w - $margin < $this->x) {
            $this->x = $this->w - $margin;
        }
    }
    public function setCellPadding($pad)
    {
        if(0 <= $pad) {
            $this->cell_padding["L"] = $pad;
            $this->cell_padding["T"] = $pad;
            $this->cell_padding["R"] = $pad;
            $this->cell_padding["B"] = $pad;
        }
    }
    public function setCellPaddings($left = NULL, $top = NULL, $right = NULL, $bottom = NULL)
    {
        if(!TCPDF_STATIC::empty_string($left) && 0 <= $left) {
            $this->cell_padding["L"] = $left;
        }
        if(!TCPDF_STATIC::empty_string($top) && 0 <= $top) {
            $this->cell_padding["T"] = $top;
        }
        if(!TCPDF_STATIC::empty_string($right) && 0 <= $right) {
            $this->cell_padding["R"] = $right;
        }
        if(!TCPDF_STATIC::empty_string($bottom) && 0 <= $bottom) {
            $this->cell_padding["B"] = $bottom;
        }
    }
    public function getCellPaddings()
    {
        return $this->cell_padding;
    }
    public function setCellMargins($left = NULL, $top = NULL, $right = NULL, $bottom = NULL)
    {
        if(!TCPDF_STATIC::empty_string($left) && 0 <= $left) {
            $this->cell_margin["L"] = $left;
        }
        if(!TCPDF_STATIC::empty_string($top) && 0 <= $top) {
            $this->cell_margin["T"] = $top;
        }
        if(!TCPDF_STATIC::empty_string($right) && 0 <= $right) {
            $this->cell_margin["R"] = $right;
        }
        if(!TCPDF_STATIC::empty_string($bottom) && 0 <= $bottom) {
            $this->cell_margin["B"] = $bottom;
        }
    }
    public function getCellMargins()
    {
        return $this->cell_margin;
    }
    protected function adjustCellPadding($brd = 0)
    {
        if(empty($brd)) {
            return NULL;
        }
        if(is_string($brd)) {
            $slen = strlen($brd);
            $newbrd = [];
            for ($i = 0; $i < $slen; $i++) {
                $newbrd[$brd[$i]] = true;
            }
            $brd = $newbrd;
        } elseif($brd === 1 || $brd === true || is_numeric($brd) && 0 < (int) $brd) {
            $brd = ["LRTB" => true];
        }
        if(!is_array($brd)) {
            return NULL;
        }
        $cp = $this->cell_padding;
        if(isset($brd["mode"])) {
            $mode = $brd["mode"];
            unset($brd["mode"]);
        } else {
            $mode = "normal";
        }
        foreach ($brd as $border => $style) {
            $line_width = $this->LineWidth;
            if(is_array($style) && isset($style["width"])) {
                $line_width = $style["width"];
            }
            $adj = 0;
            switch ($mode) {
                case "ext":
                    $adj = 0;
                    break;
                case "int":
                    $adj = $line_width;
                    break;
                case "normal":
                default:
                    $adj = $line_width / 2;
                    if(is_numeric($this->cell_padding["T"]) && $this->cell_padding["T"] < $adj && strpos($border, "T") !== false) {
                        $this->cell_padding["T"] = $adj;
                    }
                    if(is_numeric($this->cell_padding["R"]) && $this->cell_padding["R"] < $adj && strpos($border, "R") !== false) {
                        $this->cell_padding["R"] = $adj;
                    }
                    if(is_numeric($this->cell_padding["B"]) && $this->cell_padding["B"] < $adj && strpos($border, "B") !== false) {
                        $this->cell_padding["B"] = $adj;
                    }
                    if(is_numeric($this->cell_padding["L"]) && $this->cell_padding["L"] < $adj && strpos($border, "L") !== false) {
                        $this->cell_padding["L"] = $adj;
                    }
            }
        }
        return ["T" => $this->cell_padding["T"] - $cp["T"], "R" => $this->cell_padding["R"] - $cp["R"], "B" => $this->cell_padding["B"] - $cp["B"], "L" => $this->cell_padding["L"] - $cp["L"]];
    }
    public function setAutoPageBreak($auto, $margin = 0)
    {
        $this->AutoPageBreak = $auto ? true : false;
        $this->bMargin = $margin;
        $this->PageBreakTrigger = $this->h - $margin;
    }
    public function getAutoPageBreak()
    {
        return $this->AutoPageBreak;
    }
    public function setDisplayMode($zoom, $layout = "SinglePage", $mode = "UseNone")
    {
        if($zoom == "fullpage" || $zoom == "fullwidth" || $zoom == "real" || $zoom == "default" || !is_string($zoom)) {
            $this->ZoomMode = $zoom;
        } else {
            $this->Error("Incorrect zoom display mode: " . $zoom);
        }
        $this->LayoutMode = TCPDF_STATIC::getPageLayoutMode($layout);
        $this->PageMode = TCPDF_STATIC::getPageMode($mode);
    }
    public function setCompression($compress = true)
    {
        $this->compress = false;
        if(function_exists("gzcompress") && $compress && !$this->pdfa_mode) {
            $this->compress = true;
        }
    }
    public function setSRGBmode($mode = false)
    {
        $this->force_srgb = $mode ? true : false;
    }
    public function setDocInfoUnicode($unicode = true)
    {
        $this->docinfounicode = $unicode ? true : false;
    }
    public function setTitle($title)
    {
        $this->title = $title;
    }
    public function setSubject($subject)
    {
        $this->subject = $subject;
    }
    public function setAuthor($author)
    {
        $this->author = $author;
    }
    public function setKeywords($keywords)
    {
        $this->keywords = $keywords;
    }
    public function setCreator($creator)
    {
        $this->creator = $creator;
    }
    public function setAllowLocalFiles($allowLocalFiles)
    {
        $this->allowLocalFiles = (bool) $allowLocalFiles;
    }
    public function Error($msg)
    {
        $this->_destroy(true);
        if(defined("K_TCPDF_THROW_EXCEPTION_ERROR") && !K_TCPDF_THROW_EXCEPTION_ERROR) {
            exit("<strong>TCPDF ERROR: </strong>" . $msg);
        }
        throw new Exception("TCPDF ERROR: " . $msg);
    }
    public function Open()
    {
        $this->state = 1;
    }
    public function Close()
    {
        if($this->state == 3) {
            return NULL;
        }
        if($this->page == 0) {
            $this->AddPage();
        }
        $this->endLayer();
        if($this->tcpdflink) {
            $gvars = $this->getGraphicVars();
            $this->setEqualColumns();
            $this->lastpage(true);
            $this->setAutoPageBreak(false);
            $this->x = 0;
            $this->y = $this->h - 1 / $this->k;
            $this->lMargin = 0;
            $this->_outSaveGraphicsState();
            $font = defined("PDF_FONT_NAME_MAIN") ? PDF_FONT_NAME_MAIN : "helvetica";
            $this->setFont($font, "", 1);
            $this->setTextRenderingMode(0, false, false);
            $msg = "Powered by TCPDF (www.tcpdf.org)";
            $lnk = "http://www.tcpdf.org";
            $this->Cell(0, 0, $msg, 0, 0, "L", 0, $lnk, 0, false, "D", "B");
            $this->_outRestoreGraphicsState();
            $this->setGraphicVars($gvars);
        }
        $this->endPage();
        $this->_enddoc();
        $this->_destroy(false);
    }
    public function setPage($pnum, $resetmargins = false)
    {
        if($pnum == $this->page && $this->state == 2) {
            return NULL;
        }
        if(0 < $pnum && $pnum <= $this->numpages) {
            $this->state = 2;
            $oldpage = $this->page;
            $this->page = $pnum;
            $this->wPt = $this->pagedim[$this->page]["w"];
            $this->hPt = $this->pagedim[$this->page]["h"];
            $this->w = $this->pagedim[$this->page]["wk"];
            $this->h = $this->pagedim[$this->page]["hk"];
            $this->tMargin = $this->pagedim[$this->page]["tm"];
            $this->bMargin = $this->pagedim[$this->page]["bm"];
            $this->original_lMargin = $this->pagedim[$this->page]["olm"];
            $this->original_rMargin = $this->pagedim[$this->page]["orm"];
            $this->AutoPageBreak = $this->pagedim[$this->page]["pb"];
            $this->CurOrientation = $this->pagedim[$this->page]["or"];
            $this->setAutoPageBreak($this->AutoPageBreak, $this->bMargin);
            if($resetmargins) {
                $this->lMargin = $this->pagedim[$this->page]["olm"];
                $this->rMargin = $this->pagedim[$this->page]["orm"];
                $this->setY($this->tMargin);
            } elseif($this->pagedim[$this->page]["olm"] != $this->pagedim[$oldpage]["olm"]) {
                $deltam = $this->pagedim[$this->page]["olm"] - $this->pagedim[$this->page]["orm"];
                $this->lMargin += $deltam;
                $this->rMargin -= $deltam;
            }
        } else {
            $this->Error("Wrong page number on setPage() function: " . $pnum);
        }
    }
    public function lastPage($resetmargins = false)
    {
        $this->setPage($this->getNumPages(), $resetmargins);
    }
    public function getPage()
    {
        return $this->page;
    }
    public function getNumPages()
    {
        return $this->numpages;
    }
    public function addTOCPage($orientation = "", $format = "", $keepmargins = false)
    {
        $this->AddPage($orientation, $format, $keepmargins, true);
    }
    public function endTOCPage()
    {
        $this->endPage(true);
    }
    public function AddPage($orientation = "", $format = "", $keepmargins = false, $tocpage = false)
    {
        if($this->inxobj) {
            return NULL;
        }
        if(!isset($this->original_lMargin) || $keepmargins) {
            $this->original_lMargin = $this->lMargin;
        }
        if(!isset($this->original_rMargin) || $keepmargins) {
            $this->original_rMargin = $this->rMargin;
        }
        $this->endPage();
        $this->startPage($orientation, $format, $tocpage);
    }
    public function endPage($tocpage = false)
    {
        if($this->page == 0 || $this->page < $this->numpages || !$this->pageopen[$this->page]) {
            return NULL;
        }
        $this->setFooter();
        $this->_endpage();
        $this->pageopen[$this->page] = false;
        if($tocpage) {
            $this->tocpage = false;
        }
    }
    public function startPage($orientation = "", $format = "", $tocpage = false)
    {
        if($tocpage) {
            $this->tocpage = true;
        }
        if($this->tocpage) {
            $tmpoutlines = $this->outlines;
            foreach ($tmpoutlines as $key => $outline) {
                if(!$outline["f"] && $this->numpages < $outline["p"]) {
                    $this->outlines[$key]["p"] = $outline["p"] + 1;
                }
            }
            $tmpdests = $this->dests;
            foreach ($tmpdests as $key => $dest) {
                if(!$dest["f"] && $this->numpages < $dest["p"]) {
                    $this->dests[$key]["p"] = $dest["p"] + 1;
                }
            }
            $tmplinks = $this->links;
            foreach ($tmplinks as $key => $link) {
                if(!$link["f"] && $this->numpages < $link["p"]) {
                    $this->links[$key]["p"] = $link["p"] + 1;
                }
            }
        }
        if($this->page < $this->numpages) {
            $this->setPage($this->page + 1);
            $this->setY($this->tMargin);
            return NULL;
        }
        if($this->state == 0) {
            $this->Open();
        }
        $this->numpages++;
        $this->swapMargins($this->booklet);
        $gvars = $this->getGraphicVars();
        $this->_beginpage($orientation, $format);
        $this->pageopen[$this->page] = true;
        $this->setGraphicVars($gvars);
        $this->setPageMark();
        $this->setHeader();
        $this->setGraphicVars($gvars);
        $this->setPageMark();
        $this->setTableHeader();
        $this->emptypagemrk[$this->page] = $this->pagelen[$this->page];
    }
    public function setPageMark()
    {
        $this->intmrk[$this->page] = $this->pagelen[$this->page];
        $this->bordermrk[$this->page] = $this->intmrk[$this->page];
        $this->setContentMark();
    }
    protected function setContentMark($page = 0)
    {
        if($page <= 0) {
            $page = $this->page;
        }
        if(isset($this->footerlen[$page])) {
            $this->cntmrk[$page] = $this->pagelen[$page] - $this->footerlen[$page];
        } else {
            $this->cntmrk[$page] = $this->pagelen[$page];
        }
    }
    public function setHeaderData($ln = "", $lw = 0, $ht = "", $hs = "", $tc = [0, 0, 0], $lc = [0, 0, 0])
    {
        $this->header_logo = $ln;
        $this->header_logo_width = $lw;
        $this->header_title = $ht;
        $this->header_string = $hs;
        $this->header_text_color = $tc;
        $this->header_line_color = $lc;
    }
    public function setFooterData($tc = [0, 0, 0], $lc = [0, 0, 0])
    {
        $this->footer_text_color = $tc;
        $this->footer_line_color = $lc;
    }
    public function getHeaderData()
    {
        $ret = [];
        $ret["logo"] = $this->header_logo;
        $ret["logo_width"] = $this->header_logo_width;
        $ret["title"] = $this->header_title;
        $ret["string"] = $this->header_string;
        $ret["text_color"] = $this->header_text_color;
        $ret["line_color"] = $this->header_line_color;
        return $ret;
    }
    public function setHeaderMargin($hm = 10)
    {
        $this->header_margin = $hm;
    }
    public function getHeaderMargin()
    {
        return $this->header_margin;
    }
    public function setFooterMargin($fm = 10)
    {
        $this->footer_margin = $fm;
    }
    public function getFooterMargin()
    {
        return $this->footer_margin;
    }
    public function setPrintHeader($val = true)
    {
        $this->print_header = $val ? true : false;
    }
    public function setPrintFooter($val = true)
    {
        $this->print_footer = $val ? true : false;
    }
    public function getImageRBX()
    {
        return $this->img_rb_x;
    }
    public function getImageRBY()
    {
        return $this->img_rb_y;
    }
    public function resetHeaderTemplate()
    {
        $this->header_xobjid = false;
    }
    public function setHeaderTemplateAutoreset($val = true)
    {
        $this->header_xobj_autoreset = $val ? true : false;
    }
    public function Header()
    {
        if($this->header_xobjid === false) {
            $this->header_xobjid = $this->startTemplate($this->w, $this->tMargin);
            $headerfont = $this->getHeaderFont();
            $headerdata = $this->getHeaderData();
            $this->y = $this->header_margin;
            if($this->rtl) {
                $this->x = $this->w - $this->original_rMargin;
            } else {
                $this->x = $this->original_lMargin;
            }
            if($headerdata["logo"] && $headerdata["logo"] != K_BLANK_IMAGE) {
                $imgtype = TCPDF_IMAGES::getImageFileType(K_PATH_IMAGES . $headerdata["logo"]);
                if($imgtype == "eps" || $imgtype == "ai") {
                    $this->ImageEps(K_PATH_IMAGES . $headerdata["logo"], "", "", $headerdata["logo_width"]);
                } elseif($imgtype == "svg") {
                    $this->ImageSVG(K_PATH_IMAGES . $headerdata["logo"], "", "", $headerdata["logo_width"]);
                } else {
                    $this->Image(K_PATH_IMAGES . $headerdata["logo"], "", "", $headerdata["logo_width"]);
                }
                $imgy = $this->getImageRBY();
            } else {
                $imgy = $this->y;
            }
            $cell_height = $this->getCellHeight($headerfont[2] / $this->k);
            if($this->getRTL()) {
                $header_x = $this->original_rMargin + $headerdata["logo_width"] * 0;
            } else {
                $header_x = $this->original_lMargin + $headerdata["logo_width"] * 0;
            }
            $cw = $this->w - $this->original_lMargin - $this->original_rMargin - $headerdata["logo_width"] * 0;
            $this->setTextColorArray($this->header_text_color);
            $this->setFont($headerfont[0], "B", $headerfont[2] + 1);
            $this->setX($header_x);
            $this->Cell($cw, $cell_height, $headerdata["title"], 0, 1, "", 0, "", 0);
            $this->setFont($headerfont[0], $headerfont[1], $headerfont[2]);
            $this->setX($header_x);
            $this->MultiCell($cw, $cell_height, $headerdata["string"], 0, "", 0, 1, "", "", true, 0, false, true, 0, "T", false);
            $this->setLineStyle(["width" => 0 / $this->k, "cap" => "butt", "join" => "miter", "dash" => 0, "color" => $headerdata["line_color"]]);
            $this->setY(0 / $this->k + max($imgy, $this->y));
            if($this->rtl) {
                $this->setX($this->original_rMargin);
            } else {
                $this->setX($this->original_lMargin);
            }
            $this->Cell($this->w - $this->original_lMargin - $this->original_rMargin, 0, "", "T", 0, "C");
            $this->endTemplate();
        }
        $x = 0;
        $dx = 0;
        if(!$this->header_xobj_autoreset && $this->booklet && $this->page % 2 == 0) {
            $dx = $this->original_lMargin - $this->original_rMargin;
        }
        if($this->rtl) {
            $x = $this->w + $dx;
        } else {
            $x = 0 + $dx;
        }
        $this->printTemplate($this->header_xobjid, $x, 0, 0, 0, "", "", false);
        if($this->header_xobj_autoreset) {
            $this->header_xobjid = false;
        }
    }
    public function Footer()
    {
        $cur_y = $this->y;
        $this->setTextColorArray($this->footer_text_color);
        $line_width = 0 / $this->k;
        $this->setLineStyle(["width" => $line_width, "cap" => "butt", "join" => "miter", "dash" => 0, "color" => $this->footer_line_color]);
        $barcode = $this->getBarcode();
        if(!empty($barcode)) {
            $this->Ln($line_width);
            $barcode_width = round(($this->w - $this->original_lMargin - $this->original_rMargin) / 3);
            $style = ["position" => $this->rtl ? "R" : "L", "align" => $this->rtl ? "R" : "L", "stretch" => false, "fitwidth" => true, "cellfitalign" => "", "border" => false, "padding" => 0, "fgcolor" => [0, 0, 0], "bgcolor" => false, "text" => false];
            $this->write1DBarcode($barcode, "C128", "", $cur_y + $line_width, "", $this->footer_margin / 3 - $line_width, 0, $style, "");
        }
        $w_page = isset($this->l["w_page"]) ? $this->l["w_page"] . " " : "";
        if(empty($this->pagegroups)) {
            $pagenumtxt = $w_page . $this->getAliasNumPage() . " / " . $this->getAliasNbPages();
        } else {
            $pagenumtxt = $w_page . $this->getPageNumGroupAlias() . " / " . $this->getPageGroupAlias();
        }
        $this->setY($cur_y);
        if($this->getRTL()) {
            $this->setX($this->original_rMargin);
            $this->Cell(0, 0, $pagenumtxt, "T", 0, "L");
        } else {
            $this->setX($this->original_lMargin);
            $this->Cell(0, 0, $this->getAliasRightShift() . $pagenumtxt, "T", 0, "R");
        }
    }
    protected function setHeader()
    {
        if(!$this->print_header || $this->state != 2) {
            return NULL;
        }
        $this->InHeader = true;
        $this->setGraphicVars($this->default_graphic_vars);
        $temp_thead = $this->thead;
        $temp_theadMargins = $this->theadMargins;
        $lasth = $this->lasth;
        $newline = $this->newline;
        $this->_outSaveGraphicsState();
        $this->rMargin = $this->original_rMargin;
        $this->lMargin = $this->original_lMargin;
        $this->setCellPadding(0);
        if($this->rtl) {
            $this->setXY($this->original_rMargin, $this->header_margin);
        } else {
            $this->setXY($this->original_lMargin, $this->header_margin);
        }
        $this->setFont($this->header_font[0], $this->header_font[1], $this->header_font[2]);
        $this->Header();
        if($this->rtl) {
            $this->setXY($this->original_rMargin, $this->tMargin);
        } else {
            $this->setXY($this->original_lMargin, $this->tMargin);
        }
        $this->_outRestoreGraphicsState();
        $this->lasth = $lasth;
        $this->thead = $temp_thead;
        $this->theadMargins = $temp_theadMargins;
        $this->newline = $newline;
        $this->InHeader = false;
    }
    protected function setFooter()
    {
        if($this->state != 2) {
            return NULL;
        }
        $this->InFooter = true;
        $gvars = $this->getGraphicVars();
        $this->footerpos[$this->page] = $this->pagelen[$this->page];
        $this->_out("\n");
        if($this->print_footer) {
            $this->setGraphicVars($this->default_graphic_vars);
            $this->current_column = 0;
            $this->num_columns = 1;
            $temp_thead = $this->thead;
            $temp_theadMargins = $this->theadMargins;
            $lasth = $this->lasth;
            $this->_outSaveGraphicsState();
            $this->rMargin = $this->original_rMargin;
            $this->lMargin = $this->original_lMargin;
            $this->setCellPadding(0);
            $footer_y = $this->h - $this->footer_margin;
            if($this->rtl) {
                $this->setXY($this->original_rMargin, $footer_y);
            } else {
                $this->setXY($this->original_lMargin, $footer_y);
            }
            $this->setFont($this->footer_font[0], $this->footer_font[1], $this->footer_font[2]);
            $this->Footer();
            if($this->rtl) {
                $this->setXY($this->original_rMargin, $this->tMargin);
            } else {
                $this->setXY($this->original_lMargin, $this->tMargin);
            }
            $this->_outRestoreGraphicsState();
            $this->lasth = $lasth;
            $this->thead = $temp_thead;
            $this->theadMargins = $temp_theadMargins;
        }
        $this->setGraphicVars($gvars);
        $this->current_column = $gvars["current_column"];
        $this->num_columns = $gvars["num_columns"];
        $this->footerlen[$this->page] = $this->pagelen[$this->page] - $this->footerpos[$this->page] + 1;
        $this->InFooter = false;
    }
    protected function inPageBody()
    {
        return $this->InHeader === false && $this->InFooter === false;
    }
    protected function setTableHeader()
    {
        if(1 < $this->num_columns) {
            return NULL;
        }
        if(isset($this->theadMargins["top"])) {
            $this->tMargin = $this->theadMargins["top"];
            $this->pagedim[$this->page]["tm"] = $this->tMargin;
            $this->y = $this->tMargin;
        }
        if(!TCPDF_STATIC::empty_string($this->thead) && !$this->inthead) {
            $prev_lMargin = $this->lMargin;
            $prev_rMargin = $this->rMargin;
            $prev_cell_padding = $this->cell_padding;
            $this->lMargin = $this->theadMargins["lmargin"] + $this->pagedim[$this->page]["olm"] - $this->pagedim[$this->theadMargins["page"]]["olm"];
            $this->rMargin = $this->theadMargins["rmargin"] + $this->pagedim[$this->page]["orm"] - $this->pagedim[$this->theadMargins["page"]]["orm"];
            $this->cell_padding = $this->theadMargins["cell_padding"];
            if($this->rtl) {
                $this->x = $this->w - $this->rMargin;
            } else {
                $this->x = $this->lMargin;
            }
            if($this->theadMargins["cell"]) {
                if($this->rtl) {
                    $this->x -= $this->cell_padding["R"];
                } else {
                    $this->x += $this->cell_padding["L"];
                }
            }
            $gvars = $this->getGraphicVars();
            if(!empty($this->theadMargins["gvars"])) {
                $this->setGraphicVars($this->theadMargins["gvars"]);
                $this->rMargin = $gvars["rMargin"];
                $this->lMargin = $gvars["lMargin"];
            }
            $this->writeHTML($this->thead, false, false, false, false, "");
            $this->setGraphicVars($gvars);
            if(!isset($this->theadMargins["top"])) {
                $this->theadMargins["top"] = $this->tMargin;
            }
            if(!isset($this->columns[0]["th"])) {
                $this->columns[0]["th"] = [];
            }
            $this->columns[0]["th"]["'" . $this->page . "'"] = $this->y;
            $this->tMargin = $this->y;
            $this->pagedim[$this->page]["tm"] = $this->tMargin;
            $this->lasth = 0;
            $this->lMargin = $prev_lMargin;
            $this->rMargin = $prev_rMargin;
            $this->cell_padding = $prev_cell_padding;
        }
    }
    public function PageNo()
    {
        return $this->page;
    }
    public function getAllSpotColors()
    {
        return $this->spot_colors;
    }
    public function AddSpotColor($name, $c, $m, $y, $k)
    {
        if(!isset($this->spot_colors[$name])) {
            $i = 1 + count($this->spot_colors);
            $this->spot_colors[$name] = ["C" => $c, "M" => $m, "Y" => $y, "K" => $k, "name" => $name, "i" => $i];
        }
    }
    public function setSpotColor($type, $name, $tint = 100)
    {
        $spotcolor = TCPDF_COLORS::getSpotColor($name, $this->spot_colors);
        if($spotcolor === false) {
            $this->Error("Undefined spot color: " . $name . ", you must add it using the AddSpotColor() method.");
        }
        $tint = max(0, min(100, $tint)) / 100;
        $pdfcolor = sprintf("/CS%d ", $this->spot_colors[$name]["i"]);
        switch ($type) {
            case "draw":
                $pdfcolor .= sprintf("CS %F SCN", $tint);
                $this->DrawColor = $pdfcolor;
                $this->strokecolor = $spotcolor;
                break;
            case "fill":
                $pdfcolor .= sprintf("cs %F scn", $tint);
                $this->FillColor = $pdfcolor;
                $this->bgcolor = $spotcolor;
                break;
            case "text":
                $pdfcolor .= sprintf("cs %F scn", $tint);
                $this->TextColor = $pdfcolor;
                $this->fgcolor = $spotcolor;
                break;
            default:
                $this->ColorFlag = $this->FillColor != $this->TextColor;
                if($this->state == 2) {
                    $this->_out($pdfcolor);
                }
                if($this->inxobj) {
                    $this->xobjects[$this->xobjid]["spot_colors"][$name] = $this->spot_colors[$name];
                }
                return $pdfcolor;
        }
    }
    public function setDrawSpotColor($name, $tint = 100)
    {
        $this->setSpotColor("draw", $name, $tint);
    }
    public function setFillSpotColor($name, $tint = 100)
    {
        $this->setSpotColor("fill", $name, $tint);
    }
    public function setTextSpotColor($name, $tint = 100)
    {
        $this->setSpotColor("text", $name, $tint);
    }
    public function setColorArray($type, $color, $ret = false)
    {
        if(is_array($color)) {
            $color = array_values($color);
            $c = isset($color[0]) ? $color[0] : -1;
            $m = isset($color[1]) ? $color[1] : -1;
            $y = isset($color[2]) ? $color[2] : -1;
            $k = isset($color[3]) ? $color[3] : -1;
            $name = isset($color[4]) ? $color[4] : "";
            if(0 <= $c) {
                return $this->setColor($type, $c, $m, $y, $k, $ret, $name);
            }
        }
        return "";
    }
    public function setDrawColorArray($color, $ret = false)
    {
        return $this->setColorArray("draw", $color, $ret);
    }
    public function setFillColorArray($color, $ret = false)
    {
        return $this->setColorArray("fill", $color, $ret);
    }
    public function setTextColorArray($color, $ret = false)
    {
        return $this->setColorArray("text", $color, $ret);
    }
    public function setColor($type, $col1 = 0, $col2 = -1, $col3 = -1, $col4 = -1, $ret = false, $name = "")
    {
        if(!is_numeric($col1)) {
            $col1 = 0;
        }
        if(!is_numeric($col2)) {
            $col2 = -1;
        }
        if(!is_numeric($col3)) {
            $col3 = -1;
        }
        if(!is_numeric($col4)) {
            $col4 = -1;
        }
        $suffix = "";
        if($col2 == -1 && $col3 == -1 && $col4 == -1) {
            $col1 = max(0, min(255, $col1));
            $intcolor = ["G" => $col1];
            $pdfcolor = sprintf("%F ", $col1 / 255);
            $suffix = "g";
        } elseif($col4 == -1) {
            $col1 = max(0, min(255, $col1));
            $col2 = max(0, min(255, $col2));
            $col3 = max(0, min(255, $col3));
            $intcolor = ["R" => $col1, "G" => $col2, "B" => $col3];
            $pdfcolor = sprintf("%F %F %F ", $col1 / 255, $col2 / 255, $col3 / 255);
            $suffix = "rg";
        } else {
            $col1 = max(0, min(100, $col1));
            $col2 = max(0, min(100, $col2));
            $col3 = max(0, min(100, $col3));
            $col4 = max(0, min(100, $col4));
            if(empty($name)) {
                $intcolor = ["C" => $col1, "M" => $col2, "Y" => $col3, "K" => $col4];
                $pdfcolor = sprintf("%F %F %F %F ", $col1 / 100, $col2 / 100, $col3 / 100, $col4 / 100);
                $suffix = "k";
            } else {
                $intcolor = ["C" => $col1, "M" => $col2, "Y" => $col3, "K" => $col4, "name" => $name];
                $this->AddSpotColor($name, $col1, $col2, $col3, $col4);
                $pdfcolor = $this->setSpotColor($type, $name, 100);
            }
        }
        switch ($type) {
            case "draw":
                $pdfcolor .= strtoupper($suffix);
                $this->DrawColor = $pdfcolor;
                $this->strokecolor = $intcolor;
                break;
            case "fill":
                $pdfcolor .= $suffix;
                $this->FillColor = $pdfcolor;
                $this->bgcolor = $intcolor;
                break;
            case "text":
                $pdfcolor .= $suffix;
                $this->TextColor = $pdfcolor;
                $this->fgcolor = $intcolor;
                break;
            default:
                $this->ColorFlag = $this->FillColor != $this->TextColor;
                if($type != "text" && $this->state == 2 && $type !== 0) {
                    if(!$ret) {
                        $this->_out($pdfcolor);
                    }
                    return $pdfcolor;
                }
                return "";
        }
    }
    public function setDrawColor($col1 = 0, $col2 = -1, $col3 = -1, $col4 = -1, $ret = false, $name = "")
    {
        return $this->setColor("draw", $col1, $col2, $col3, $col4, $ret, $name);
    }
    public function setFillColor($col1 = 0, $col2 = -1, $col3 = -1, $col4 = -1, $ret = false, $name = "")
    {
        return $this->setColor("fill", $col1, $col2, $col3, $col4, $ret, $name);
    }
    public function setTextColor($col1 = 0, $col2 = -1, $col3 = -1, $col4 = -1, $ret = false, $name = "")
    {
        return $this->setColor("text", $col1, $col2, $col3, $col4, $ret, $name);
    }
    public function GetStringWidth($s, $fontname = "", $fontstyle = "", $fontsize = 0, $getarray = false)
    {
        return $this->GetArrStringWidth(TCPDF_FONTS::utf8Bidi(TCPDF_FONTS::UTF8StringToArray($s, $this->isunicode, $this->CurrentFont), $s, $this->tmprtl, $this->isunicode, $this->CurrentFont), $fontname, $fontstyle, $fontsize, $getarray);
    }
    public function GetArrStringWidth($sa, $fontname = "", $fontstyle = "", $fontsize = 0, $getarray = false)
    {
        if(!TCPDF_STATIC::empty_string($fontname)) {
            $prev_FontFamily = $this->FontFamily;
            $prev_FontStyle = $this->FontStyle;
            $prev_FontSizePt = $this->FontSizePt;
            $this->setFont($fontname, $fontstyle, $fontsize, "", "default", false);
        }
        if($this->isunicode && !$this->isUnicodeFont()) {
            $sa = TCPDF_FONTS::UTF8ArrToLatin1Arr($sa);
        }
        $w = 0;
        $wa = [];
        foreach ($sa as $ck => $char) {
            $cw = $this->GetCharWidth($char, isset($sa[$ck + 1]));
            $wa[] = $cw;
            $w += $cw;
        }
        if(!TCPDF_STATIC::empty_string($fontname)) {
            $this->setFont($prev_FontFamily, $prev_FontStyle, $prev_FontSizePt, "", "default", false);
        }
        if($getarray) {
            return $wa;
        }
        return $w;
    }
    public function GetCharWidth($char, $notlast = true)
    {
        $chw = $this->getRawCharWidth($char);
        if($this->font_spacing < 0 || 0 < $this->font_spacing && $notlast) {
            $chw += $this->font_spacing;
        }
        if($this->font_stretching != 100) {
            $chw *= $this->font_stretching / 100;
        }
        return $chw;
    }
    public function getRawCharWidth($char)
    {
        if($char == 173) {
            return 0;
        }
        if(isset($this->CurrentFont["cw"][intval($char)])) {
            $w = $this->CurrentFont["cw"][intval($char)];
        } elseif(isset($this->CurrentFont["dw"])) {
            $w = $this->CurrentFont["dw"];
        } elseif(isset($this->CurrentFont["cw"][32])) {
            $w = $this->CurrentFont["cw"][32];
        } else {
            $w = 600;
        }
        return $this->getAbsFontMeasure($w);
    }
    public function GetNumChars($s)
    {
        if($this->isUnicodeFont()) {
            return count(TCPDF_FONTS::UTF8StringToArray($s, $this->isunicode, $this->CurrentFont));
        }
        return strlen($s);
    }
    protected function getFontsList()
    {
        if(($fontsdir = opendir(TCPDF_FONTS::_getfontpath())) !== false) {
            while (($file = readdir($fontsdir)) !== false) {
                if(substr($file, -4) == ".php") {
                    array_push($this->fontlist, strtolower(basename($file, ".php")));
                }
            }
            closedir($fontsdir);
        }
    }
    public function AddFont($family, $style = "", $fontfile = "", $subset = "default")
    {
        if($subset === "default") {
            $subset = $this->font_subsetting;
        }
        if($this->pdfa_mode) {
            $subset = false;
        }
        if(TCPDF_STATIC::empty_string($family)) {
            if(!TCPDF_STATIC::empty_string($this->FontFamily)) {
                $family = $this->FontFamily;
            } else {
                $this->Error("Empty font family");
            }
        }
        if(substr($family, -1) == "I") {
            $style .= "I";
            $family = substr($family, 0, -1);
        }
        if(substr($family, -1) == "B") {
            $style .= "B";
            $family = substr($family, 0, -1);
        }
        $family = strtolower($family);
        if(!$this->isunicode && $family == "arial") {
            $family = "helvetica";
        }
        if($family == "symbol" || $family == "zapfdingbats") {
            $style = "";
        }
        if($this->pdfa_mode && isset($this->CoreFonts[$family])) {
            $family = "pdfa" . $family;
        }
        $tempstyle = strtoupper($style);
        $style = "";
        if(strpos($tempstyle, "U") !== false) {
            $this->underline = true;
        } else {
            $this->underline = false;
        }
        if(strpos($tempstyle, "D") !== false) {
            $this->linethrough = true;
        } else {
            $this->linethrough = false;
        }
        if(strpos($tempstyle, "O") !== false) {
            $this->overline = true;
        } else {
            $this->overline = false;
        }
        if(strpos($tempstyle, "B") !== false) {
            $style .= "B";
        }
        if(strpos($tempstyle, "I") !== false) {
            $style .= "I";
        }
        $bistyle = $style;
        $fontkey = $family . $style;
        $font_style = $style . ($this->underline ? "U" : "") . ($this->linethrough ? "D" : "") . ($this->overline ? "O" : "");
        $fontdata = ["fontkey" => $fontkey, "family" => $family, "style" => $font_style];
        $fb = $this->getFontBuffer($fontkey);
        if($fb !== false) {
            if($this->inxobj) {
                $this->xobjects[$this->xobjid]["fonts"][$fontkey] = $fb["i"];
            }
            return $fontdata;
        }
        $fontdir = false;
        if(!TCPDF_STATIC::empty_string($fontfile)) {
            $fontdir = dirname($fontfile);
            if(TCPDF_STATIC::empty_string($fontdir) || $fontdir == ".") {
                $fontdir = "";
            } else {
                $fontdir .= "/";
            }
        }
        $missing_style = false;
        if(TCPDF_STATIC::empty_string($fontfile) || !@TCPDF_STATIC::file_exists($fontfile)) {
            $tmp_fontfile = str_replace(" ", "", $family) . strtolower($style) . ".php";
            $fontfile = TCPDF_FONTS::getFontFullPath($tmp_fontfile, $fontdir);
            if(TCPDF_STATIC::empty_string($fontfile)) {
                $missing_style = true;
                $tmp_fontfile = str_replace(" ", "", $family) . ".php";
                $fontfile = TCPDF_FONTS::getFontFullPath($tmp_fontfile, $fontdir);
            }
        }
        if(!TCPDF_STATIC::empty_string($fontfile) && @TCPDF_STATIC::file_exists($fontfile)) {
            include $fontfile;
        } else {
            $this->Error("Could not include font definition file: " . $family . "");
        }
        if(!isset($type) || !isset($cw)) {
            $this->Error("The font definition file has a bad format: " . $fontfile . "");
        }
        if(!isset($file) || TCPDF_STATIC::empty_string($file)) {
            $file = "";
        }
        if(!isset($enc) || TCPDF_STATIC::empty_string($enc)) {
            $enc = "";
        }
        if(!isset($cidinfo) || TCPDF_STATIC::empty_string($cidinfo)) {
            $cidinfo = ["Registry" => "Adobe", "Ordering" => "Identity", "Supplement" => 0];
            $cidinfo["uni2cid"] = [];
        }
        if(!isset($ctg) || TCPDF_STATIC::empty_string($ctg)) {
            $ctg = "";
        }
        if(!isset($desc) || TCPDF_STATIC::empty_string($desc)) {
            $desc = [];
        }
        if(!isset($up) || TCPDF_STATIC::empty_string($up)) {
            $up = -100;
        }
        if(!isset($ut) || TCPDF_STATIC::empty_string($ut)) {
            $ut = 50;
        }
        if(!isset($cw) || TCPDF_STATIC::empty_string($cw)) {
            $cw = [];
        }
        if(!isset($dw) || TCPDF_STATIC::empty_string($dw)) {
            if(isset($desc["MissingWidth"]) && 0 < $desc["MissingWidth"]) {
                $dw = $desc["MissingWidth"];
            } elseif(isset($cw[32])) {
                $dw = $cw[32];
            } else {
                $dw = 600;
            }
        }
        $this->numfonts++;
        if($type == "core") {
            $name = $this->CoreFonts[$fontkey];
            $subset = false;
        } elseif($type == "TrueType" || $type == "Type1") {
            $subset = false;
        } elseif($type == "TrueTypeUnicode") {
            $enc = "Identity-H";
        } elseif($type == "cidfont0") {
            if($this->pdfa_mode) {
                $this->Error("All fonts must be embedded in PDF/A mode!");
            }
        } else {
            $this->Error("Unknow font type: " . $type . "");
        }
        if(!isset($name) || empty($name)) {
            $name = $fontkey;
        }
        if($type != "core" && $missing_style) {
            $styles = ["" => "", "B" => ",Bold", "I" => ",Italic", "BI" => ",BoldItalic"];
            $name .= $styles[$bistyle];
            if(strpos($bistyle, "B") !== false) {
                if(isset($desc["StemV"])) {
                    $desc["StemV"] = round($desc["StemV"] * 0);
                } else {
                    $desc["StemV"] = 123;
                }
            }
            if(strpos($bistyle, "I") !== false) {
                if(isset($desc["ItalicAngle"])) {
                    $desc["ItalicAngle"] -= 11;
                } else {
                    $desc["ItalicAngle"] = -11;
                }
                if(isset($desc["Flags"])) {
                    $desc["Flags"] |= 64;
                } else {
                    $desc["Flags"] = 64;
                }
            }
        }
        if(!isset($cbbox)) {
            $cbbox = [];
        }
        $subsetchars = array_fill(0, 255, true);
        $this->setFontBuffer($fontkey, ["fontkey" => $fontkey, "i" => $this->numfonts, "type" => $type, "name" => $name, "desc" => $desc, "up" => $up, "ut" => $ut, "cw" => $cw, "cbbox" => $cbbox, "dw" => $dw, "enc" => $enc, "cidinfo" => $cidinfo, "file" => $file, "ctg" => $ctg, "subset" => $subset, "subsetchars" => $subsetchars]);
        if($this->inxobj) {
            $this->xobjects[$this->xobjid]["fonts"][$fontkey] = $this->numfonts;
        }
        if(isset($diff) && !empty($diff)) {
            $d = 0;
            $nb = count($this->diffs);
            for ($i = 1; $i <= $nb; $i++) {
                if($this->diffs[$i] == $diff) {
                    $d = $i;
                    break;
                }
            }
            if($d == 0) {
                $d = $nb + 1;
                $this->diffs[$d] = $diff;
            }
            $this->setFontSubBuffer($fontkey, "diff", $d);
        }
        if(!TCPDF_STATIC::empty_string($file)) {
            if(!isset($this->FontFiles[$file])) {
                if(strcasecmp($type, "TrueType") == 0 || strcasecmp($type, "TrueTypeUnicode") == 0) {
                    $this->FontFiles[$file] = ["length1" => $originalsize, "fontdir" => $fontdir, "subset" => $subset, "fontkeys" => [$fontkey]];
                } elseif($type != "core") {
                    $this->FontFiles[$file] = ["length1" => $size1, "length2" => $size2, "fontdir" => $fontdir, "subset" => $subset, "fontkeys" => [$fontkey]];
                }
            } else {
                $this->FontFiles[$file]["subset"] = $this->FontFiles[$file]["subset"] && $subset;
                if(!in_array($fontkey, $this->FontFiles[$file]["fontkeys"])) {
                    $this->FontFiles[$file]["fontkeys"][] = $fontkey;
                }
            }
        }
        return $fontdata;
    }
    public function setFont($family, $style = "", $size = NULL, $fontfile = "", $subset = "default", $out = true)
    {
        if($size === NULL) {
            $size = $this->FontSizePt;
        }
        if($size < 0) {
            $size = 0;
        }
        $fontdata = $this->AddFont($family, $style, $fontfile, $subset);
        $this->FontFamily = $fontdata["family"];
        $this->FontStyle = $fontdata["style"];
        if(isset($this->CurrentFont["fontkey"]) && isset($this->CurrentFont["subsetchars"])) {
            $this->setFontSubBuffer($this->CurrentFont["fontkey"], "subsetchars", $this->CurrentFont["subsetchars"]);
        }
        $this->CurrentFont = $this->getFontBuffer($fontdata["fontkey"]);
        $this->setFontSize($size, $out);
    }
    public function setFontSize($size, $out = true)
    {
        $size = (double) $size;
        $this->FontSizePt = $size;
        $this->FontSize = $size / $this->k;
        if(isset($this->CurrentFont["desc"]["FontBBox"])) {
            $bbox = explode(" ", substr($this->CurrentFont["desc"]["FontBBox"], 1, -1));
            $font_height = (intval($bbox[3]) - intval($bbox[1])) * $size / 1000;
        } else {
            $font_height = $size * 0;
        }
        if(isset($this->CurrentFont["desc"]["Ascent"]) && 0 < $this->CurrentFont["desc"]["Ascent"]) {
            $font_ascent = $this->CurrentFont["desc"]["Ascent"] * $size / 1000;
        }
        if(isset($this->CurrentFont["desc"]["Descent"]) && $this->CurrentFont["desc"]["Descent"] <= 0) {
            $font_descent = -1 * $this->CurrentFont["desc"]["Descent"] * $size / 1000;
        }
        if(!isset($font_ascent) && !isset($font_descent)) {
            $font_ascent = 0 * $font_height;
            $font_descent = $font_height - $font_ascent;
        } elseif(!isset($font_descent)) {
            $font_descent = $font_height - $font_ascent;
        } elseif(!isset($font_ascent)) {
            $font_ascent = $font_height - $font_descent;
        }
        $this->FontAscent = $font_ascent / $this->k;
        $this->FontDescent = $font_descent / $this->k;
        if($out && 0 < $this->page && isset($this->CurrentFont["i"]) && $this->state == 2) {
            $this->_out(sprintf("BT /F%d %F Tf ET", $this->CurrentFont["i"], $this->FontSizePt));
        }
    }
    public function getFontBBox()
    {
        $fbbox = [];
        if(isset($this->CurrentFont["desc"]["FontBBox"])) {
            $tmpbbox = explode(" ", substr($this->CurrentFont["desc"]["FontBBox"], 1, -1));
            $fbbox = array_map([$this, "getAbsFontMeasure"], $tmpbbox);
        } else {
            if(isset($this->CurrentFont["desc"]["MaxWidth"])) {
                $maxw = $this->getAbsFontMeasure(intval($this->CurrentFont["desc"]["MaxWidth"]));
            } else {
                $maxw = 0;
                if(isset($this->CurrentFont["desc"]["MissingWidth"])) {
                    $maxw = max($maxw, $this->CurrentFont["desc"]["MissingWidth"]);
                }
                if(isset($this->CurrentFont["desc"]["AvgWidth"])) {
                    $maxw = max($maxw, $this->CurrentFont["desc"]["AvgWidth"]);
                }
                if(isset($this->CurrentFont["dw"])) {
                    $maxw = max($maxw, $this->CurrentFont["dw"]);
                }
                foreach ($this->CurrentFont["cw"] as $char => $w) {
                    $maxw = max($maxw, $w);
                }
                if($maxw == 0) {
                    $maxw = 600;
                }
                $maxw = $this->getAbsFontMeasure($maxw);
            }
            $fbbox = [0, 0 - $this->FontDescent, $maxw, $this->FontAscent];
        }
        return $fbbox;
    }
    public function getAbsFontMeasure($s)
    {
        return $s * $this->FontSize / 1000;
    }
    public function getCharBBox($char)
    {
        $c = intval($char);
        if(isset($this->CurrentFont["cw"][$c])) {
            $result = [0, 0, 0, 0];
            if(isset($this->CurrentFont["cbbox"][$c])) {
                $result = $this->CurrentFont["cbbox"][$c];
            }
            return array_map([$this, "getAbsFontMeasure"], $result);
        }
        return false;
    }
    public function getFontDescent($font, $style = "", $size = 0)
    {
        $fontdata = $this->AddFont($font, $style);
        $fontinfo = $this->getFontBuffer($fontdata["fontkey"]);
        if(isset($fontinfo["desc"]["Descent"]) && $fontinfo["desc"]["Descent"] <= 0) {
            $descent = -1 * $fontinfo["desc"]["Descent"] * $size / 1000;
        } else {
            $descent = 0 * $size;
        }
        return $descent / $this->k;
    }
    public function getFontAscent($font, $style = "", $size = 0)
    {
        $fontdata = $this->AddFont($font, $style);
        $fontinfo = $this->getFontBuffer($fontdata["fontkey"]);
        if(isset($fontinfo["desc"]["Ascent"]) && 0 < $fontinfo["desc"]["Ascent"]) {
            $ascent = $fontinfo["desc"]["Ascent"] * $size / 1000;
        } else {
            $ascent = 0 * $size;
        }
        return $ascent / $this->k;
    }
    public function isCharDefined($char, $font = "", $style = "")
    {
        if(is_string($char)) {
            $char = TCPDF_FONTS::UTF8StringToArray($char, $this->isunicode, $this->CurrentFont);
            $char = $char[0];
        }
        if(TCPDF_STATIC::empty_string($font)) {
            if(TCPDF_STATIC::empty_string($style)) {
                return isset($this->CurrentFont["cw"][intval($char)]);
            }
            $font = $this->FontFamily;
        }
        $fontdata = $this->AddFont($font, $style);
        $fontinfo = $this->getFontBuffer($fontdata["fontkey"]);
        return isset($fontinfo["cw"][intval($char)]);
    }
    public function replaceMissingChars($text, $font = "", $style = "", $subs = [])
    {
        if(empty($subs)) {
            return $text;
        }
        if(TCPDF_STATIC::empty_string($font)) {
            $font = $this->FontFamily;
        }
        $fontdata = $this->AddFont($font, $style);
        $fontinfo = $this->getFontBuffer($fontdata["fontkey"]);
        $uniarr = TCPDF_FONTS::UTF8StringToArray($text, $this->isunicode, $this->CurrentFont);
        foreach ($uniarr as $k => $chr) {
            if(!isset($fontinfo["cw"][$chr]) && isset($subs[$chr])) {
                if(is_array($subs[$chr])) {
                    foreach ($subs[$chr] as $s) {
                        if(isset($fontinfo["cw"][$s])) {
                            $uniarr[$k] = $s;
                        }
                    }
                } elseif(isset($fontinfo["cw"][$subs[$chr]])) {
                    $uniarr[$k] = $subs[$chr];
                }
            }
        }
        return TCPDF_FONTS::UniArrSubString(TCPDF_FONTS::UTF8ArrayToUniArray($uniarr, $this->isunicode));
    }
    public function setDefaultMonospacedFont($font)
    {
        $this->default_monospaced_font = $font;
    }
    public function AddLink()
    {
        $n = count($this->links) + 1;
        $this->links[$n] = ["p" => 0, "y" => 0, "f" => false];
        return $n;
    }
    public function setLink($link, $y = 0, $page = -1)
    {
        $fixed = false;
        if(!empty($page) && substr($page, 0, 1) == "*") {
            $page = intval(substr($page, 1));
            $fixed = true;
        }
        if($page < 0) {
            $page = $this->page;
        }
        if($y == -1) {
            $y = $this->y;
        }
        $this->links[$link] = ["p" => $page, "y" => $y, "f" => $fixed];
    }
    public function Link($x, $y, $w, $h, $link, $spaces = 0)
    {
        $this->Annotation($x, $y, $w, $h, $link, ["Subtype" => "Link"], $spaces);
    }
    public function Annotation($x, $y, $w, $h, $text, $opt = ["Subtype" => "Text"], $spaces = 0)
    {
        if($this->inxobj) {
            $this->xobjects[$this->xobjid]["annotations"][] = ["x" => $x, "y" => $y, "w" => $w, "h" => $h, "text" => $text, "opt" => $opt, "spaces" => $spaces];
        } else {
            if($x === "") {
                $x = $this->x;
            }
            if($y === "") {
                $y = $this->y;
            }
            list($x, $y) = $this->checkPageRegions($h, $x, $y);
            if(isset($this->transfmatrix) && !empty($this->transfmatrix)) {
                $i = $this->transfmatrix_key;
                while (0 < $i) {
                    $maxid = count($this->transfmatrix[$i]) - 1;
                    $j = $maxid;
                    while (0 <= $j) {
                        $ctm = $this->transfmatrix[$i][$j];
                        if(isset($ctm["a"])) {
                            $x = $x * $this->k;
                            $y = ($this->h - $y) * $this->k;
                            $w = $w * $this->k;
                            $h = $h * $this->k;
                            $xt = $x;
                            $yt = $y;
                            $x1 = $ctm["a"] * $xt + $ctm["c"] * $yt + $ctm["e"];
                            $y1 = $ctm["b"] * $xt + $ctm["d"] * $yt + $ctm["f"];
                            $xt = $x + $w;
                            $yt = $y;
                            $x2 = $ctm["a"] * $xt + $ctm["c"] * $yt + $ctm["e"];
                            $y2 = $ctm["b"] * $xt + $ctm["d"] * $yt + $ctm["f"];
                            $xt = $x;
                            $yt = $y - $h;
                            $x3 = $ctm["a"] * $xt + $ctm["c"] * $yt + $ctm["e"];
                            $y3 = $ctm["b"] * $xt + $ctm["d"] * $yt + $ctm["f"];
                            $xt = $x + $w;
                            $yt = $y - $h;
                            $x4 = $ctm["a"] * $xt + $ctm["c"] * $yt + $ctm["e"];
                            $y4 = $ctm["b"] * $xt + $ctm["d"] * $yt + $ctm["f"];
                            $x = min($x1, $x2, $x3, $x4);
                            $y = max($y1, $y2, $y3, $y4);
                            $w = (max($x1, $x2, $x3, $x4) - $x) / $this->k;
                            $h = ($y - min($y1, $y2, $y3, $y4)) / $this->k;
                            $x = $x / $this->k;
                            $y = $this->h - $y / $this->k;
                        }
                        --$j;
                    }
                    --$i;
                }
            }
            if($this->page <= 0) {
                $page = 1;
            } else {
                $page = $this->page;
            }
            if(!isset($this->PageAnnots[$page])) {
                $this->PageAnnots[$page] = [];
            }
            $this->PageAnnots[$page][] = ["n" => ++$this->n, "x" => $x, "y" => $y, "w" => $w, "h" => $h, "txt" => $text, "opt" => $opt, "numspaces" => $spaces];
            if((!$this->pdfa_mode || $this->pdfa_mode && $this->pdfa_version == 3) && ($opt["Subtype"] == "FileAttachment" || $opt["Subtype"] == "Sound") && !TCPDF_STATIC::empty_string($opt["FS"]) && (@TCPDF_STATIC::file_exists($opt["FS"]) || TCPDF_STATIC::isValidURL($opt["FS"])) && !isset($this->embeddedfiles[basename($opt["FS"])])) {
                $this->embeddedfiles[basename($opt["FS"])] = ["f" => ++$this->n, "n" => ++$this->n, "file" => $opt["FS"]];
            }
            if(isset($opt["mk"]["i"]) && @TCPDF_STATIC::file_exists($opt["mk"]["i"])) {
                $this->Image($opt["mk"]["i"], "", "", 10, 10, "", "", "", false, 300, "", false, false, 0, false, true);
            }
            if(isset($opt["mk"]["ri"]) && @TCPDF_STATIC::file_exists($opt["mk"]["ri"])) {
                $this->Image($opt["mk"]["ri"], "", "", 0, 0, "", "", "", false, 300, "", false, false, 0, false, true);
            }
            if(isset($opt["mk"]["ix"]) && @TCPDF_STATIC::file_exists($opt["mk"]["ix"])) {
                $this->Image($opt["mk"]["ix"], "", "", 0, 0, "", "", "", false, 300, "", false, false, 0, false, true);
            }
        }
    }
    protected function _putEmbeddedFiles()
    {
        if($this->pdfa_mode && $this->pdfa_version != 3) {
            return NULL;
        }
        reset($this->embeddedfiles);
        foreach ($this->embeddedfiles as $filename => $filedata) {
            $data = $this->getCachedFileContents($filedata["file"]);
            if($data !== false) {
                $rawsize = strlen($data);
                if(0 < $rawsize) {
                    $this->efnames[$filename] = $filedata["f"] . " 0 R";
                    $out = $this->_getobj($filedata["f"]) . "\n";
                    $out .= "<</Type /Filespec /F " . $this->_datastring($filename, $filedata["f"]);
                    $out .= " /UF " . $this->_datastring($filename, $filedata["f"]);
                    $out .= " /AFRelationship /Source";
                    $out .= " /EF <</F " . $filedata["n"] . " 0 R>> >>";
                    $out .= "\nendobj";
                    $this->_out($out);
                    $filter = "";
                    if($this->compress) {
                        $data = gzcompress($data);
                        $filter = " /Filter /FlateDecode";
                    }
                    if($this->pdfa_version == 3) {
                        $filter = " /Subtype /text#2Fxml";
                    }
                    $stream = $this->_getrawstream($data, $filedata["n"]);
                    $out = $this->_getobj($filedata["n"]) . "\n";
                    $out .= "<< /Type /EmbeddedFile" . $filter . " /Length " . strlen($stream) . " /Params <</Size " . $rawsize . ">> >>";
                    $out .= " stream\n" . $stream . "\n" . "endstream";
                    $out .= "\nendobj";
                    $this->_out($out);
                }
            }
        }
    }
    public function Text($x, $y, $txt, $fstroke = 0, $fclip = false, $ffill = true, $border = 0, $ln = 0, $align = "", $fill = false, $link = "", $stretch = 0, $ignore_min_height = false, $calign = "T", $valign = "M", $rtloff = false)
    {
        $textrendermode = $this->textrendermode;
        $textstrokewidth = $this->textstrokewidth;
        $this->setTextRenderingMode($fstroke, $ffill, $fclip);
        $this->setXY($x, $y, $rtloff);
        $this->Cell(0, 0, $txt, $border, $ln, $align, $fill, $link, $stretch, $ignore_min_height, $calign, $valign);
        $this->textrendermode = $textrendermode;
        $this->textstrokewidth = $textstrokewidth;
    }
    public function AcceptPageBreak()
    {
        if(1 < $this->num_columns) {
            if($this->current_column < $this->num_columns - 1) {
                $this->selectColumn($this->current_column + 1);
            } elseif($this->AutoPageBreak) {
                $this->AddPage();
                $this->selectColumn(0);
            }
            return false;
        }
        return $this->AutoPageBreak;
    }
    protected function checkPageBreak($h = 0, $y = NULL, $addpage = true)
    {
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        $current_page = $this->page;
        if($this->PageBreakTrigger < $y + $h && $this->inPageBody() && $this->AcceptPageBreak()) {
            if($addpage) {
                $x = $this->x;
                $this->AddPage($this->CurOrientation);
                $this->y = $this->tMargin;
                $oldpage = $this->page - 1;
                if($this->rtl) {
                    if($this->pagedim[$this->page]["orm"] != $this->pagedim[$oldpage]["orm"]) {
                        $this->x = $x - ($this->pagedim[$this->page]["orm"] - $this->pagedim[$oldpage]["orm"]);
                    } else {
                        $this->x = $x;
                    }
                } elseif($this->pagedim[$this->page]["olm"] != $this->pagedim[$oldpage]["olm"]) {
                    $this->x = $x + $this->pagedim[$this->page]["olm"] - $this->pagedim[$oldpage]["olm"];
                } else {
                    $this->x = $x;
                }
            }
            return true;
        }
        if($current_page != $this->page) {
            return true;
        }
        return false;
    }
    public function Cell($w, $h = 0, $txt = "", $border = 0, $ln = 0, $align = "", $fill = false, $link = "", $stretch = 0, $ignore_min_height = false, $calign = "T", $valign = "M")
    {
        $prev_cell_margin = $this->cell_margin;
        $prev_cell_padding = $this->cell_padding;
        $this->adjustCellPadding($border);
        if(!$ignore_min_height) {
            $min_cell_height = $this->getCellHeight($this->FontSize);
            if($h < $min_cell_height) {
                $h = $min_cell_height;
            }
        }
        $this->checkPageBreak($h + $this->cell_margin["T"] + $this->cell_margin["B"]);
        if($this->txtshadow["enabled"]) {
            $x = $this->x;
            $y = $this->y;
            $bc = $this->bgcolor;
            $fc = $this->fgcolor;
            $sc = $this->strokecolor;
            $alpha = $this->alpha;
            $this->x += $this->txtshadow["depth_w"];
            $this->y += $this->txtshadow["depth_h"];
            $this->setFillColorArray($this->txtshadow["color"]);
            $this->setTextColorArray($this->txtshadow["color"]);
            $this->setDrawColorArray($this->txtshadow["color"]);
            if($this->txtshadow["opacity"] != $alpha["CA"]) {
                $this->setAlpha($this->txtshadow["opacity"], $this->txtshadow["blend_mode"]);
            }
            if($this->state == 2) {
                $this->_out($this->getCellCode($w, $h, $txt, $border, $ln, $align, $fill, $link, $stretch, true, $calign, $valign));
            }
            $this->x = $x;
            $this->y = $y;
            $this->setFillColorArray($bc);
            $this->setTextColorArray($fc);
            $this->setDrawColorArray($sc);
            if($this->txtshadow["opacity"] != $alpha["CA"]) {
                $this->setAlpha($alpha["CA"], $alpha["BM"], $alpha["ca"], $alpha["AIS"]);
            }
        }
        if($this->state == 2) {
            $this->_out($this->getCellCode($w, $h, $txt, $border, $ln, $align, $fill, $link, $stretch, true, $calign, $valign));
        }
        $this->cell_padding = $prev_cell_padding;
        $this->cell_margin = $prev_cell_margin;
    }
    protected function getCellCode($w, $h = 0, $txt = "", $border = 0, $ln = 0, $align = "", $fill = false, $link = "", $stretch = 0, $ignore_min_height = false, $calign = "T", $valign = "M")
    {
        $txt = is_null($txt) ? "" : $txt;
        $txt = str_replace(TCPDF_FONTS::unichr(160, $this->isunicode), " ", $txt);
        $prev_cell_margin = $this->cell_margin;
        $prev_cell_padding = $this->cell_padding;
        $txt = TCPDF_STATIC::removeSHY($txt, $this->isunicode);
        $rs = "";
        $this->adjustCellPadding($border);
        if(!$ignore_min_height) {
            $min_cell_height = $this->getCellHeight($this->FontSize);
            if($h < $min_cell_height) {
                $h = $min_cell_height;
            }
        }
        $k = $this->k;
        list($this->x, $this->y) = $this->checkPageRegions($h, $this->x, $this->y);
        if($this->rtl) {
            $x = $this->x - $this->cell_margin["R"];
        } else {
            $x = $this->x + $this->cell_margin["L"];
        }
        $y = $this->y + $this->cell_margin["T"];
        $prev_font_stretching = $this->font_stretching;
        $prev_font_spacing = $this->font_spacing;
        switch ($calign) {
            case "A":
                switch ($valign) {
                    case "T":
                        $y -= $this->cell_padding["T"];
                        break;
                    case "B":
                        $y -= $h - $this->cell_padding["B"] - $this->FontAscent - $this->FontDescent;
                        break;
                    case "C":
                    case "M":
                    default:
                        $y -= ($h - $this->FontAscent - $this->FontDescent) / 2;
                }
                break;
            case "L":
                switch ($valign) {
                    case "T":
                        $y -= $this->cell_padding["T"] + $this->FontAscent;
                        break;
                    case "B":
                        $y -= $h - $this->cell_padding["B"] - $this->FontDescent;
                        break;
                    case "C":
                    case "M":
                    default:
                        $y -= ($h + $this->FontAscent - $this->FontDescent) / 2;
                }
                break;
            case "D":
                switch ($valign) {
                    case "T":
                        $y -= $this->cell_padding["T"] + $this->FontAscent + $this->FontDescent;
                        break;
                    case "B":
                        $y -= $h - $this->cell_padding["B"];
                        break;
                    case "C":
                    case "M":
                    default:
                        $y -= ($h + $this->FontAscent + $this->FontDescent) / 2;
                }
                break;
            case "B":
                $y -= $h;
                break;
            case "C":
            case "M":
                $y -= $h / 2;
                break;
            case "T":
            default:
                switch ($valign) {
                    case "T":
                        $yt = $y + $this->cell_padding["T"];
                        break;
                    case "B":
                        $yt = $y + $h - $this->cell_padding["B"] - $this->FontAscent - $this->FontDescent;
                        break;
                    case "C":
                    case "M":
                    default:
                        $yt = $y + ($h - $this->FontAscent - $this->FontDescent) / 2;
                        $basefonty = $yt + $this->FontAscent;
                        if(TCPDF_STATIC::empty_string($w) || $w <= 0) {
                            if($this->rtl) {
                                $w = $x - $this->lMargin;
                            } else {
                                $w = $this->w - $this->rMargin - $x;
                            }
                        }
                        $s = "";
                        if(is_string($border) && strlen($border) == 4) {
                            $border = 1;
                        }
                        if($fill || $border == 1) {
                            if($fill) {
                                $op = $border == 1 ? "B" : "f";
                            } else {
                                $op = "S";
                            }
                            if($this->rtl) {
                                $xk = ($x - $w) * $k;
                            } else {
                                $xk = $x * $k;
                            }
                            $s .= sprintf("%F %F %F %F re %s ", $xk, ($this->h - $y) * $k, $w * $k, -1 * $h * $k, $op);
                        }
                        $s .= $this->getCellBorder($x, $y, $w, $h, $border);
                        if($txt != "") {
                            $txt2 = $txt;
                            if($this->isunicode) {
                                if($this->CurrentFont["type"] == "core" || $this->CurrentFont["type"] == "TrueType" || $this->CurrentFont["type"] == "Type1") {
                                    $txt2 = TCPDF_FONTS::UTF8ToLatin1($txt2, $this->isunicode, $this->CurrentFont);
                                } else {
                                    $unicode = TCPDF_FONTS::UTF8StringToArray($txt, $this->isunicode, $this->CurrentFont);
                                    $unicode = TCPDF_FONTS::utf8Bidi($unicode, "", $this->tmprtl, $this->isunicode, $this->CurrentFont);
                                    if(defined("K_THAI_TOPCHARS") && K_THAI_TOPCHARS) {
                                        $numchars = count($unicode);
                                        $longtail = [3611, 3613, 3615];
                                        $lowtail = [3598, 3599];
                                        $upvowel = [3633, 3636, 3637, 3638, 3639];
                                        $tonemark = [3656, 3657, 3658, 3659, 3660];
                                        $lowvowel = [3640, 3641, 3642];
                                        $output = [];
                                        for ($i = 0; $i < $numchars; $i++) {
                                            if(3584 <= $unicode[$i] && $unicode[$i] <= 3675) {
                                                $ch0 = $unicode[$i];
                                                $ch1 = 0 < $i ? $unicode[$i - 1] : 0;
                                                $ch2 = 1 < $i ? $unicode[$i - 2] : 0;
                                                $chn = $i < $numchars - 1 ? $unicode[$i + 1] : 0;
                                                if(in_array($ch0, $tonemark)) {
                                                    if($chn == 3635) {
                                                        if(in_array($ch1, $longtail)) {
                                                            $output[] = $this->replaceChar($ch0, 63251 + $ch0 - 3656);
                                                        } else {
                                                            $output[] = $ch0;
                                                        }
                                                    } elseif(in_array($ch1, $longtail) || in_array($ch2, $longtail) && in_array($ch1, $lowvowel)) {
                                                        $output[] = $this->replaceChar($ch0, 63237 + $ch0 - 3656);
                                                    } elseif(in_array($ch1, $upvowel)) {
                                                        if(in_array($ch2, $longtail)) {
                                                            $output[] = $this->replaceChar($ch0, 63251 + $ch0 - 3656);
                                                        } else {
                                                            $output[] = $ch0;
                                                        }
                                                    } else {
                                                        $output[] = $this->replaceChar($ch0, 63242 + $ch0 - 3656);
                                                    }
                                                } elseif($ch0 == 3635 && (in_array($ch1, $longtail) || in_array($ch2, $longtail) && in_array($ch1, $tonemark))) {
                                                    if($this->isCharDefined(63249) && $this->isCharDefined(3634)) {
                                                        $output[] = 63249;
                                                        $this->CurrentFont["subsetchars"][63249] = true;
                                                        $output[] = 3634;
                                                        $this->CurrentFont["subsetchars"][3634] = true;
                                                    } else {
                                                        $output[] = $ch0;
                                                    }
                                                } elseif(in_array($ch1, $longtail)) {
                                                    if($ch0 == 3633) {
                                                        $output[] = $this->replaceChar($ch0, 63248);
                                                    } elseif(in_array($ch0, $upvowel)) {
                                                        $output[] = $this->replaceChar($ch0, 63233 + $ch0 - 3636);
                                                    } elseif($ch0 == 3655) {
                                                        $output[] = $this->replaceChar($ch0, 63250);
                                                    } else {
                                                        $output[] = $ch0;
                                                    }
                                                } elseif(in_array($ch1, $lowtail) && in_array($ch0, $lowvowel)) {
                                                    $output[] = $this->replaceChar($ch0, 63256 + $ch0 - 3640);
                                                } elseif($ch0 == 3597 && in_array($chn, $lowvowel)) {
                                                    $output[] = $this->replaceChar($ch0, 63247);
                                                } elseif($ch0 == 3600 && in_array($chn, $lowvowel)) {
                                                    $output[] = $this->replaceChar($ch0, 63232);
                                                } else {
                                                    $output[] = $ch0;
                                                }
                                            } else {
                                                $output[] = $unicode[$i];
                                            }
                                        }
                                        $unicode = $output;
                                        $this->setFontSubBuffer($this->CurrentFont["fontkey"], "subsetchars", $this->CurrentFont["subsetchars"]);
                                    }
                                    $txt2 = TCPDF_FONTS::arrUTF8ToUTF16BE($unicode, false);
                                }
                            }
                            $txt2 = TCPDF_STATIC::_escape($txt2);
                            $txwidth = $this->GetStringWidth($txt);
                            $width = $txwidth;
                            if(0 < $stretch) {
                                if($width <= 0) {
                                    $ratio = 1;
                                } else {
                                    $ratio = ($w - $this->cell_padding["L"] - $this->cell_padding["R"]) / $width;
                                }
                                if($ratio < 1 || 1 < $ratio && $stretch % 2 == 0) {
                                    if(2 < $stretch) {
                                        $this->font_spacing += ($w - $this->cell_padding["L"] - $this->cell_padding["R"] - $width) / (max($this->GetNumChars($txt) - 1, 1) * $this->font_stretching / 100);
                                    } else {
                                        $this->font_stretching *= $ratio;
                                    }
                                    $width = $w - $this->cell_padding["L"] - $this->cell_padding["R"];
                                    $align = "";
                                }
                            }
                            if($this->font_stretching != 100) {
                                $rs .= sprintf("BT %F Tz ET ", $this->font_stretching);
                            }
                            if($this->font_spacing != 0) {
                                $rs .= sprintf("BT %F Tc ET ", $this->font_spacing * $this->k);
                            }
                            if($this->ColorFlag && $this->textrendermode < 4) {
                                $s .= "q " . $this->TextColor . " ";
                            }
                            $s .= sprintf("BT %d Tr %F w ET ", $this->textrendermode, $this->textstrokewidth * $this->k);
                            $ns = substr_count($txt, chr(32));
                            $spacewidth = 0;
                            if($align == "J" && 0 < $ns) {
                                if($this->isUnicodeFont()) {
                                    $width = $this->GetStringWidth(str_replace(" ", "", $txt));
                                    $spacewidth = -1000 * ($w - $width - $this->cell_padding["L"] - $this->cell_padding["R"]) / ($ns ? $ns : 1) / ($this->FontSize ? $this->FontSize : 1);
                                    if($this->font_stretching != 100) {
                                        $spacewidth /= $this->font_stretching / 100;
                                    }
                                    $txt2 = str_replace(chr(0) . chr(32), ") " . sprintf("%F", $spacewidth) . " (", $txt2);
                                    $unicode_justification = true;
                                } else {
                                    $width = $txwidth;
                                    $spacewidth = ($w - $width - $this->cell_padding["L"] - $this->cell_padding["R"]) / ($ns ? $ns : 1) * $this->k;
                                    if($this->font_stretching != 100) {
                                        $spacewidth /= $this->font_stretching / 100;
                                    }
                                    $rs .= sprintf("BT %F Tw ET ", $spacewidth);
                                }
                                $width = $w - $this->cell_padding["L"] - $this->cell_padding["R"];
                            }
                            $txt2 = str_replace("\r", " ", $txt2);
                            switch ($align) {
                                case "C":
                                    $dx = ($w - $width) / 2;
                                    break;
                                case "R":
                                    if($this->rtl) {
                                        $dx = $this->cell_padding["R"];
                                    } else {
                                        $dx = $w - $width - $this->cell_padding["R"];
                                    }
                                    break;
                                case "L":
                                    if($this->rtl) {
                                        $dx = $w - $width - $this->cell_padding["L"];
                                    } else {
                                        $dx = $this->cell_padding["L"];
                                    }
                                    break;
                                case "J":
                                default:
                                    if($this->rtl) {
                                        $dx = $this->cell_padding["R"];
                                    } else {
                                        $dx = $this->cell_padding["L"];
                                    }
                                    if($this->rtl) {
                                        $xdx = $x - $dx - $width;
                                    } else {
                                        $xdx = $x + $dx;
                                    }
                                    $xdk = $xdx * $k;
                                    $s .= sprintf("BT %F %F Td [(%s)] TJ ET", $xdk, ($this->h - $basefonty) * $k, $txt2);
                                    if(isset($uniblock)) {
                                        $xshift = 0;
                                        $ty = ($this->h - $basefonty + 0 * $this->FontSize) * $k;
                                        $spw = ($w - $txwidth - $this->cell_padding["L"] - $this->cell_padding["R"]) / ($ns ? $ns : 1);
                                        foreach ($uniblock as $uk => $uniarr) {
                                            if($uk % 2 == 0) {
                                                if($spacewidth != 0) {
                                                    $xshift += count(array_keys($uniarr, 32)) * $spw;
                                                }
                                                $xshift += $this->GetArrStringWidth($uniarr);
                                            } else {
                                                $topchr = TCPDF_FONTS::arrUTF8ToUTF16BE($uniarr, false);
                                                $topchr = TCPDF_STATIC::_escape($topchr);
                                                $s .= sprintf(" BT %F %F Td [(%s)] TJ ET", $xdk + $xshift * $k, $ty, $topchr);
                                            }
                                        }
                                    }
                                    if($this->underline) {
                                        $s .= " " . $this->_dounderlinew($xdx, $basefonty, $width);
                                    }
                                    if($this->linethrough) {
                                        $s .= " " . $this->_dolinethroughw($xdx, $basefonty, $width);
                                    }
                                    if($this->overline) {
                                        $s .= " " . $this->_dooverlinew($xdx, $basefonty, $width);
                                    }
                                    if($this->ColorFlag && $this->textrendermode < 4) {
                                        $s .= " Q";
                                    }
                                    if($link) {
                                        $this->Link($xdx, $yt, $width, $this->FontAscent + $this->FontDescent, $link, $ns);
                                    }
                            }
                        }
                        if($s) {
                            $rs .= $s;
                            if($this->font_spacing != 0) {
                                $rs .= " BT 0 Tc ET";
                            }
                            if($this->font_stretching != 100) {
                                $rs .= " BT 100 Tz ET";
                            }
                        }
                        if(!$this->isUnicodeFont() && $align == "J") {
                            $rs .= " BT 0 Tw ET";
                        }
                        $this->font_stretching = $prev_font_stretching;
                        $this->font_spacing = $prev_font_spacing;
                        $this->lasth = $h;
                        if(0 < $ln) {
                            $this->y = $y + $h + $this->cell_margin["B"];
                            if($ln == 1) {
                                if($this->rtl) {
                                    $this->x = $this->w - $this->rMargin;
                                } else {
                                    $this->x = $this->lMargin;
                                }
                            }
                        } elseif($this->rtl) {
                            $this->x = $x - $w - $this->cell_margin["L"];
                        } else {
                            $this->x = $x + $w + $this->cell_margin["R"];
                        }
                        $gstyles = "" . $this->linestyleWidth . " " . $this->linestyleCap . " " . $this->linestyleJoin . " " . $this->linestyleDash . " " . $this->DrawColor . " " . $this->FillColor . "\n";
                        $rs = $gstyles . $rs;
                        $this->cell_padding = $prev_cell_padding;
                        $this->cell_margin = $prev_cell_margin;
                        return $rs;
                }
        }
    }
    protected function replaceChar($oldchar, $newchar)
    {
        if($this->isCharDefined($newchar)) {
            $this->CurrentFont["subsetchars"][$newchar] = true;
            return $newchar;
        }
        return $oldchar;
    }
    protected function getCellBorder($x, $y, $w, $h, $brd)
    {
        $s = "";
        if(empty($brd)) {
            return $s;
        }
        if($brd == 1) {
            $brd = ["LRTB" => true];
        }
        $k = $this->k;
        if($this->rtl) {
            $xeL = ($x - $w) * $k;
            $xeR = $x * $k;
        } else {
            $xeL = $x * $k;
            $xeR = ($x + $w) * $k;
        }
        $yeL = ($this->h - ($y + $h)) * $k;
        $yeT = ($this->h - $y) * $k;
        $xeT = $xeL;
        $xeB = $xeR;
        $yeR = $yeT;
        $yeB = $yeL;
        if(is_string($brd)) {
            $slen = strlen($brd);
            $newbrd = [];
            for ($i = 0; $i < $slen; $i++) {
                $newbrd[$brd[$i]] = ["cap" => "square", "join" => "miter"];
            }
            $brd = $newbrd;
        }
        if(isset($brd["mode"])) {
            $mode = $brd["mode"];
            unset($brd["mode"]);
        } else {
            $mode = "normal";
        }
        foreach ($brd as $border => $style) {
            if(is_array($style) && !empty($style)) {
                $prev_style = $this->linestyleWidth . " " . $this->linestyleCap . " " . $this->linestyleJoin . " " . $this->linestyleDash . " " . $this->DrawColor . " ";
                $s .= $this->setLineStyle($style, true) . "\n";
            }
            switch ($mode) {
                case "ext":
                    $off = $this->LineWidth / 2 * $k;
                    $xL = $xeL - $off;
                    $xR = $xeR + $off;
                    $yT = $yeT + $off;
                    $yL = $yeL - $off;
                    $xT = $xL;
                    $xB = $xR;
                    $yR = $yT;
                    $yB = $yL;
                    $w += $this->LineWidth;
                    $h += $this->LineWidth;
                    break;
                case "int":
                    $off = $this->LineWidth / 2 * $k;
                    $xL = $xeL + $off;
                    $xR = $xeR - $off;
                    $yT = $yeT - $off;
                    $yL = $yeL + $off;
                    $xT = $xL;
                    $xB = $xR;
                    $yR = $yT;
                    $yB = $yL;
                    $w -= $this->LineWidth;
                    $h -= $this->LineWidth;
                    break;
                case "normal":
                default:
                    $xL = $xeL;
                    $xT = $xeT;
                    $xB = $xeB;
                    $xR = $xeR;
                    $yL = $yeL;
                    $yT = $yeT;
                    $yB = $yeB;
                    $yR = $yeR;
                    if(strlen($border) == 4) {
                        $s .= sprintf("%F %F %F %F re S ", $xT, $yT, $w * $k, -1 * $h * $k);
                    } elseif(strlen($border) == 3) {
                        if(strpos($border, "B") === false) {
                            $s .= sprintf("%F %F m ", $xL, $yL);
                            $s .= sprintf("%F %F l ", $xT, $yT);
                            $s .= sprintf("%F %F l ", $xR, $yR);
                            $s .= sprintf("%F %F l ", $xB, $yB);
                            $s .= "S ";
                        } elseif(strpos($border, "L") === false) {
                            $s .= sprintf("%F %F m ", $xT, $yT);
                            $s .= sprintf("%F %F l ", $xR, $yR);
                            $s .= sprintf("%F %F l ", $xB, $yB);
                            $s .= sprintf("%F %F l ", $xL, $yL);
                            $s .= "S ";
                        } elseif(strpos($border, "T") === false) {
                            $s .= sprintf("%F %F m ", $xR, $yR);
                            $s .= sprintf("%F %F l ", $xB, $yB);
                            $s .= sprintf("%F %F l ", $xL, $yL);
                            $s .= sprintf("%F %F l ", $xT, $yT);
                            $s .= "S ";
                        } elseif(strpos($border, "R") === false) {
                            $s .= sprintf("%F %F m ", $xB, $yB);
                            $s .= sprintf("%F %F l ", $xL, $yL);
                            $s .= sprintf("%F %F l ", $xT, $yT);
                            $s .= sprintf("%F %F l ", $xR, $yR);
                            $s .= "S ";
                        }
                    } elseif(strlen($border) == 2) {
                        if(strpos($border, "L") !== false && strpos($border, "T") !== false) {
                            $s .= sprintf("%F %F m ", $xL, $yL);
                            $s .= sprintf("%F %F l ", $xT, $yT);
                            $s .= sprintf("%F %F l ", $xR, $yR);
                            $s .= "S ";
                        } elseif(strpos($border, "T") !== false && strpos($border, "R") !== false) {
                            $s .= sprintf("%F %F m ", $xT, $yT);
                            $s .= sprintf("%F %F l ", $xR, $yR);
                            $s .= sprintf("%F %F l ", $xB, $yB);
                            $s .= "S ";
                        } elseif(strpos($border, "R") !== false && strpos($border, "B") !== false) {
                            $s .= sprintf("%F %F m ", $xR, $yR);
                            $s .= sprintf("%F %F l ", $xB, $yB);
                            $s .= sprintf("%F %F l ", $xL, $yL);
                            $s .= "S ";
                        } elseif(strpos($border, "B") !== false && strpos($border, "L") !== false) {
                            $s .= sprintf("%F %F m ", $xB, $yB);
                            $s .= sprintf("%F %F l ", $xL, $yL);
                            $s .= sprintf("%F %F l ", $xT, $yT);
                            $s .= "S ";
                        } elseif(strpos($border, "L") !== false && strpos($border, "R") !== false) {
                            $s .= sprintf("%F %F m ", $xL, $yL);
                            $s .= sprintf("%F %F l ", $xT, $yT);
                            $s .= "S ";
                            $s .= sprintf("%F %F m ", $xR, $yR);
                            $s .= sprintf("%F %F l ", $xB, $yB);
                            $s .= "S ";
                        } elseif(strpos($border, "T") !== false && strpos($border, "B") !== false) {
                            $s .= sprintf("%F %F m ", $xT, $yT);
                            $s .= sprintf("%F %F l ", $xR, $yR);
                            $s .= "S ";
                            $s .= sprintf("%F %F m ", $xB, $yB);
                            $s .= sprintf("%F %F l ", $xL, $yL);
                            $s .= "S ";
                        }
                    } elseif(strpos($border, "L") !== false) {
                        $s .= sprintf("%F %F m ", $xL, $yL);
                        $s .= sprintf("%F %F l ", $xT, $yT);
                        $s .= "S ";
                    } elseif(strpos($border, "T") !== false) {
                        $s .= sprintf("%F %F m ", $xT, $yT);
                        $s .= sprintf("%F %F l ", $xR, $yR);
                        $s .= "S ";
                    } elseif(strpos($border, "R") !== false) {
                        $s .= sprintf("%F %F m ", $xR, $yR);
                        $s .= sprintf("%F %F l ", $xB, $yB);
                        $s .= "S ";
                    } elseif(strpos($border, "B") !== false) {
                        $s .= sprintf("%F %F m ", $xB, $yB);
                        $s .= sprintf("%F %F l ", $xL, $yL);
                        $s .= "S ";
                    }
                    if(is_array($style) && !empty($style)) {
                        $s .= "\n" . $this->linestyleWidth . " " . $this->linestyleCap . " " . $this->linestyleJoin . " " . $this->linestyleDash . " " . $this->DrawColor . "\n";
                    }
            }
        }
        return $s;
    }
    public function MultiCell($w, $h, $txt, $border = 0, $align = "J", $fill = false, $ln = 1, $x = NULL, $y = NULL, $reseth = true, $stretch = 0, $ishtml = false, $autopadding = true, $maxh = 0, $valign = "T", $fitcell = false)
    {
        $prev_cell_margin = $this->cell_margin;
        $prev_cell_padding = $this->cell_padding;
        $this->adjustCellPadding($border);
        $mc_padding = $this->cell_padding;
        $mc_margin = $this->cell_margin;
        $this->cell_padding["T"] = 0;
        $this->cell_padding["B"] = 0;
        $this->setCellMargins(0, 0, 0, 0);
        if(TCPDF_STATIC::empty_string($this->lasth) || $reseth) {
            $this->resetLastH();
        }
        if(!TCPDF_STATIC::empty_string($y)) {
            $this->setY($y);
        }
        $y = $this->GetY();
        $resth = 0;
        if(0 < $h && $this->inPageBody() && $this->PageBreakTrigger < $y + $h + $mc_margin["T"] + $mc_margin["B"]) {
            $newh = $this->PageBreakTrigger - $y;
            $resth = $h - $newh;
            $h = $newh;
        }
        $startpage = $this->page;
        $startcolumn = $this->current_column;
        if(!TCPDF_STATIC::empty_string($x)) {
            $this->setX($x);
        } else {
            $x = $this->GetX();
        }
        list($x, $y) = $this->checkPageRegions(0, $x, $y);
        $oy = $y + $mc_margin["T"];
        if($this->rtl) {
            $ox = $this->w - $x - $mc_margin["R"];
        } else {
            $ox = $x + $mc_margin["L"];
        }
        $this->x = $ox;
        $this->y = $oy;
        if(TCPDF_STATIC::empty_string($w) || $w <= 0) {
            if($this->rtl) {
                $w = $this->x - $this->lMargin - $mc_margin["L"];
            } else {
                $w = $this->w - $this->x - $this->rMargin - $mc_margin["R"];
            }
        }
        $lMargin = $this->lMargin;
        $rMargin = $this->rMargin;
        if($this->rtl) {
            $this->rMargin = $this->w - $this->x;
            $this->lMargin = $this->x - $w;
        } else {
            $this->lMargin = $this->x;
            $this->rMargin = $this->w - $this->x - $w;
        }
        $this->clMargin = $this->lMargin;
        $this->crMargin = $this->rMargin;
        if($autopadding) {
            $this->y += $mc_padding["T"];
        }
        if($ishtml) {
            $this->writeHTML($txt, true, false, $reseth, true, $align);
            $nl = 1;
        } else {
            $prev_FontSizePt = $this->FontSizePt;
            if($fitcell) {
                $tobottom = $this->h - $this->y - $this->bMargin - $this->cell_padding["T"] - $this->cell_padding["B"];
                $h = $maxh = max(min($h, $tobottom), min($maxh, $tobottom));
            }
            if(0 < $maxh) {
                $text_height = $this->getStringHeight($w, $txt, $reseth, $autopadding, $mc_padding, $border);
                if($fitcell && $maxh < $text_height && 1 < $this->FontSizePt) {
                    $fmin = 1;
                    $fmax = $this->FontSizePt;
                    $diff_epsilon = 1 / $this->k;
                    $maxit = 2 * min(100, max(10, intval($fmax)));
                    while (0 <= $maxit) {
                        $fmid = ($fmax + $fmin) / 2;
                        $this->setFontSize($fmid, false);
                        $this->resetLastH();
                        $text_height = $this->getStringHeight($w, $txt, $reseth, $autopadding, $mc_padding, $border);
                        $diff = $maxh - $text_height;
                        if(0 <= $diff) {
                            if($diff <= $diff_epsilon) {
                            } else {
                                $fmin = $fmid;
                            }
                        } else {
                            $fmax = $fmid;
                        }
                        --$maxit;
                    }
                    if($maxit < 0) {
                        $this->setFontSize($fmin);
                        $this->resetLastH();
                        $text_height = $this->getStringHeight($w, $txt, $reseth, $autopadding, $mc_padding, $border);
                    } else {
                        $this->setFontSize($fmid);
                        $this->resetLastH();
                    }
                }
                if($text_height < $maxh) {
                    if($valign == "M") {
                        $this->y += ($maxh - $text_height) / 2;
                    } elseif($valign == "B") {
                        $this->y += $maxh - $text_height;
                    }
                }
            }
            $nl = $this->Write($this->lasth, $txt, "", 0, $align, true, $stretch, false, true, $maxh, 0, $mc_margin);
            if($fitcell) {
                $this->setFontSize($prev_FontSizePt);
            }
        }
        if($autopadding) {
            $this->y += $mc_padding["B"];
        }
        $currentY = $this->y;
        $endpage = $this->page;
        if(0 < $resth) {
            $skip = $endpage - $startpage;
            $tmpresth = $resth;
            while (0 < $tmpresth) {
                if($skip <= 0) {
                    $this->checkPageBreak($this->PageBreakTrigger + 1);
                }
                if(1 < $this->num_columns) {
                    $tmpresth -= $this->h - $this->y - $this->bMargin;
                } else {
                    $tmpresth -= $this->h - $this->tMargin - $this->bMargin;
                }
                --$skip;
            }
            $currentY = $this->y;
            $endpage = $this->page;
        }
        $endcolumn = $this->current_column;
        if($this->num_columns == 0) {
            $this->num_columns = 1;
        }
        $check_page_regions = $this->check_page_regions;
        $this->check_page_regions = false;
        $border_start = TCPDF_STATIC::getBorderMode($border, $position = "start", $this->opencell);
        $border_end = TCPDF_STATIC::getBorderMode($border, $position = "end", $this->opencell);
        $border_middle = TCPDF_STATIC::getBorderMode($border, $position = "middle", $this->opencell);
        for ($page = $startpage; $page <= $endpage; $page++) {
            $ccode = "";
            $this->setPage($page);
            if($this->num_columns < 2) {
                $this->setX($x);
                $this->y = $this->tMargin;
            }
            if($startpage < $page) {
                if($this->rtl && $this->pagedim[$page]["orm"] != $this->pagedim[$startpage]["orm"]) {
                    $this->x -= $this->pagedim[$page]["orm"] - $this->pagedim[$startpage]["orm"];
                } elseif(!$this->rtl && $this->pagedim[$page]["olm"] != $this->pagedim[$startpage]["olm"]) {
                    $this->x += $this->pagedim[$page]["olm"] - $this->pagedim[$startpage]["olm"];
                }
            }
            if($startpage == $endpage) {
                for ($column = $startcolumn; $column <= $endcolumn; $column++) {
                    if($column != $this->current_column) {
                        $this->selectColumn($column);
                    }
                    if($this->rtl) {
                        $this->x -= $mc_margin["R"];
                    } else {
                        $this->x += $mc_margin["L"];
                    }
                    if($startcolumn == $endcolumn) {
                        $cborder = $border;
                        $h = max($h, $currentY - $oy);
                        $this->y = $oy;
                    } elseif($column == $startcolumn) {
                        $cborder = $border_start;
                        $this->y = $oy;
                        $h = $this->h - $this->y - $this->bMargin;
                    } elseif($column == $endcolumn) {
                        $cborder = $border_end;
                        $h = $currentY - $this->y;
                        if($h < $resth) {
                            $h = $resth;
                        }
                    } else {
                        $cborder = $border_middle;
                        $h = $this->h - $this->y - $this->bMargin;
                        $resth -= $h;
                    }
                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                }
            } elseif($page == $startpage) {
                for ($column = $startcolumn; $column < $this->num_columns; $column++) {
                    if($column != $this->current_column) {
                        $this->selectColumn($column);
                    }
                    if($this->rtl) {
                        $this->x -= $mc_margin["R"];
                    } else {
                        $this->x += $mc_margin["L"];
                    }
                    if($column == $startcolumn) {
                        $cborder = $border_start;
                        $this->y = $oy;
                        $h = $this->h - $this->y - $this->bMargin;
                    } else {
                        $cborder = $border_middle;
                        $h = $this->h - $this->y - $this->bMargin;
                        $resth -= $h;
                    }
                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                }
            } elseif($page == $endpage) {
                for ($column = 0; $column <= $endcolumn; $column++) {
                    if($column != $this->current_column) {
                        $this->selectColumn($column);
                    }
                    if($this->rtl) {
                        $this->x -= $mc_margin["R"];
                    } else {
                        $this->x += $mc_margin["L"];
                    }
                    if($column == $endcolumn) {
                        $cborder = $border_end;
                        $h = $currentY - $this->y;
                        if($h < $resth) {
                            $h = $resth;
                        }
                    } else {
                        $cborder = $border_middle;
                        $h = $this->h - $this->y - $this->bMargin;
                        $resth -= $h;
                    }
                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                }
            } else {
                for ($column = 0; $column < $this->num_columns; $column++) {
                    $this->selectColumn($column);
                    if($this->rtl) {
                        $this->x -= $mc_margin["R"];
                    } else {
                        $this->x += $mc_margin["L"];
                    }
                    $cborder = $border_middle;
                    $h = $this->h - $this->y - $this->bMargin;
                    $resth -= $h;
                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                }
            }
            if($cborder || $fill) {
                $offsetlen = strlen($ccode);
                if($this->inxobj) {
                    if(end($this->xobjects[$this->xobjid]["transfmrk"]) !== false) {
                        $pagemarkkey = key($this->xobjects[$this->xobjid]["transfmrk"]);
                        $pagemark = $this->xobjects[$this->xobjid]["transfmrk"][$pagemarkkey];
                        $this->xobjects[$this->xobjid]["transfmrk"][$pagemarkkey] += $offsetlen;
                    } else {
                        $pagemark = $this->xobjects[$this->xobjid]["intmrk"];
                        $this->xobjects[$this->xobjid]["intmrk"] += $offsetlen;
                    }
                    $pagebuff = $this->xobjects[$this->xobjid]["outdata"];
                    $pstart = substr($pagebuff, 0, $pagemark);
                    $pend = substr($pagebuff, $pagemark);
                    $this->xobjects[$this->xobjid]["outdata"] = $pstart . $ccode . $pend;
                } else {
                    if(end($this->transfmrk[$this->page]) !== false) {
                        $pagemarkkey = key($this->transfmrk[$this->page]);
                        $pagemark = $this->transfmrk[$this->page][$pagemarkkey];
                        $this->transfmrk[$this->page][$pagemarkkey] += $offsetlen;
                    } elseif($this->InFooter) {
                        $pagemark = $this->footerpos[$this->page];
                        $this->footerpos[$this->page] += $offsetlen;
                    } else {
                        $pagemark = $this->intmrk[$this->page];
                        $this->intmrk[$this->page] += $offsetlen;
                    }
                    $pagebuff = $this->getPageBuffer($this->page);
                    $pstart = substr($pagebuff, 0, $pagemark);
                    $pend = substr($pagebuff, $pagemark);
                    $this->setPageBuffer($this->page, $pstart . $ccode . $pend);
                }
            }
        }
        $this->check_page_regions = $check_page_regions;
        $currentY = $this->GetY();
        if(1 < $this->num_columns) {
            $this->selectColumn();
        } else {
            $this->lMargin = $lMargin;
            $this->rMargin = $rMargin;
            if($startpage < $this->page) {
                $dl = $this->pagedim[$this->page]["olm"] - $this->pagedim[$startpage]["olm"];
                $dr = $this->pagedim[$this->page]["orm"] - $this->pagedim[$startpage]["orm"];
                if($dl != 0 || $dr != 0) {
                    $this->lMargin += $dl;
                    $this->rMargin += $dr;
                }
            }
        }
        if(0 < $ln) {
            $this->setY($currentY + $mc_margin["B"]);
            if($ln == 2) {
                $this->setX($x + $w + $mc_margin["L"] + $mc_margin["R"]);
            }
        } else {
            $this->setPage($startpage);
            $this->y = $y;
            $this->setX($x + $w + $mc_margin["L"] + $mc_margin["R"]);
        }
        $this->setContentMark();
        $this->cell_padding = $prev_cell_padding;
        $this->cell_margin = $prev_cell_margin;
        $this->clMargin = $this->lMargin;
        $this->crMargin = $this->rMargin;
        return $nl;
    }
    public function getNumLines($txt, $w = 0, $reseth = false, $autopadding = true, $cellpadding = NULL, $border = 0)
    {
        if($txt === NULL) {
            return 0;
        }
        if($txt === "") {
            return 1;
        }
        $prev_cell_padding = $this->cell_padding;
        $prev_lasth = $this->lasth;
        if(is_array($cellpadding)) {
            $this->cell_padding = $cellpadding;
        }
        $this->adjustCellPadding($border);
        if(TCPDF_STATIC::empty_string($w) || $w <= 0) {
            if($this->rtl) {
                $w = $this->x - $this->lMargin;
            } else {
                $w = $this->w - $this->rMargin - $this->x;
            }
        }
        $wmax = $w - $this->cell_padding["L"] - $this->cell_padding["R"];
        if($reseth) {
            $this->resetLastH();
        }
        $lines = 1;
        $sum = 0;
        $chars = TCPDF_FONTS::utf8Bidi(TCPDF_FONTS::UTF8StringToArray($txt, $this->isunicode, $this->CurrentFont), $txt, $this->tmprtl, $this->isunicode, $this->CurrentFont);
        $charsWidth = $this->GetArrStringWidth($chars, "", "", 0, true);
        $length = count($chars);
        $lastSeparator = -1;
        for ($i = 0; $i < $length; $i++) {
            $c = $chars[$i];
            $charWidth = $charsWidth[$i];
            if($c != 160 && ($c == 173 || preg_match($this->re_spaces, TCPDF_FONTS::unichr($c, $this->isunicode)) || $c == 45 && 0 < $i && $i < $length - 1 && @preg_match("/[\\p{L}]/" . $this->re_space["m"], @TCPDF_FONTS::unichr($chars[$i - 1], $this->isunicode)) && @preg_match("/[\\p{L}]/" . $this->re_space["m"], @TCPDF_FONTS::unichr($chars[$i + 1], $this->isunicode)))) {
                $lastSeparator = $i;
            }
            if($wmax < $sum + $charWidth || $c == 10) {
                $lines++;
                if($c == 10) {
                    $lastSeparator = -1;
                    $sum = 0;
                } elseif($lastSeparator != -1) {
                    $i = $lastSeparator;
                    $lastSeparator = -1;
                    $sum = 0;
                } else {
                    $sum = $charWidth;
                }
            } else {
                $sum += $charWidth;
            }
        }
        if($chars[$length - 1] == 10) {
            --$lines;
        }
        $this->cell_padding = $prev_cell_padding;
        $this->lasth = $prev_lasth;
        return $lines;
    }
    public function getStringHeight($w, $txt, $reseth = false, $autopadding = true, $cellpadding = NULL, $border = 0)
    {
        $prev_cell_padding = $this->cell_padding;
        $prev_lasth = $this->lasth;
        if(is_array($cellpadding)) {
            $this->cell_padding = $cellpadding;
        }
        $this->adjustCellPadding($border);
        $lines = $this->getNumLines($txt, $w, $reseth, $autopadding, $cellpadding, $border);
        $height = $this->getCellHeight($lines * $this->FontSize, $autopadding);
        $this->cell_padding = $prev_cell_padding;
        $this->lasth = $prev_lasth;
        return $height;
    }
    public function Write($h, $txt, $link = "", $fill = false, $align = "", $ln = false, $stretch = 0, $firstline = false, $firstblock = false, $maxh = 0, $wadj = 0, $margin = NULL)
    {
        list($this->x, $this->y) = $this->checkPageRegions($h, $this->x, $this->y);
        if(strlen($txt) == 0) {
            $txt = " ";
        }
        if(!is_array($margin)) {
            $margin = $this->cell_margin;
        }
        $s = str_replace("\r", "", $txt);
        if(preg_match(TCPDF_FONT_DATA::$uni_RE_PATTERN_ARABIC, $s)) {
            $arabic = true;
        } else {
            $arabic = false;
        }
        if($arabic || $this->tmprtl == "R" || preg_match(TCPDF_FONT_DATA::$uni_RE_PATTERN_RTL, $s)) {
            $rtlmode = true;
        } else {
            $rtlmode = false;
        }
        $chrwidth = $this->GetCharWidth(46);
        $chars = TCPDF_FONTS::UTF8StringToArray($s, $this->isunicode, $this->CurrentFont);
        $chrw = $this->GetArrStringWidth($chars, "", "", 0, true);
        array_walk($chrw, [$this, "getRawCharWidth"]);
        $maxchwidth = max($chrw);
        $uchars = TCPDF_FONTS::UTF8ArrayToUniArray($chars, $this->isunicode);
        $nb = count($chars);
        $shy_replacement = 45;
        $shy_replacement_char = TCPDF_FONTS::unichr($shy_replacement, $this->isunicode);
        $shy_replacement_width = $this->GetCharWidth($shy_replacement);
        $pw = $w = $this->w - $this->lMargin - $this->rMargin;
        if($this->rtl) {
            $w = $this->x - $this->lMargin;
        } else {
            $w = $this->w - $this->rMargin - $this->x;
        }
        $wmax = $w - $wadj;
        if(!$firstline) {
            $wmax -= $this->cell_padding["L"] + $this->cell_padding["R"];
        }
        if(!$firstline && ($wmax < $chrwidth || $wmax < $maxchwidth)) {
            return "";
        }
        $row_height = max($h, $this->getCellHeight($this->FontSize));
        $maxy = $this->y + $maxh - max($row_height, $h);
        $start_page = $this->page;
        $i = 0;
        $j = 0;
        $sep = -1;
        $prevsep = $sep;
        $shy = false;
        $prevshy = $shy;
        $l = 0;
        $nl = 0;
        $linebreak = false;
        for ($pc = 0; $i < $nb; $i++) {
            if(0 < $maxh && $maxy < $this->y) {
                break;
            }
            $c = $chars[$i];
            if($c == 10) {
                if($align == "J") {
                    if($this->rtl) {
                        $talign = "R";
                    } else {
                        $talign = "L";
                    }
                } else {
                    $talign = $align;
                }
                $tmpstr = TCPDF_FONTS::UniArrSubString($uchars, $j, $i);
                if($firstline) {
                    $startx = $this->x;
                    $tmparr = array_slice($chars, $j, $i - $j);
                    if($rtlmode) {
                        $tmparr = TCPDF_FONTS::utf8Bidi($tmparr, $tmpstr, $this->tmprtl, $this->isunicode, $this->CurrentFont);
                    }
                    $linew = $this->GetArrStringWidth($tmparr);
                    unset($tmparr);
                    if($this->rtl) {
                        $this->endlinex = $startx - $linew;
                    } else {
                        $this->endlinex = $startx + $linew;
                    }
                    $w = $linew;
                    $tmpcellpadding = $this->cell_padding;
                    if($maxh == 0) {
                        $this->setCellPadding(0);
                    }
                }
                if($firstblock && $this->isRTLTextDir()) {
                    $tmpstr = $this->stringRightTrim($tmpstr);
                }
                if(!empty($tmpstr) || $this->y < $this->PageBreakTrigger - $row_height) {
                    $this->Cell($w, $h, $tmpstr, 0, 1, $talign, $fill, $link, $stretch);
                }
                unset($tmpstr);
                if($firstline) {
                    $this->cell_padding = $tmpcellpadding;
                    return TCPDF_FONTS::UniArrSubString($uchars, $i);
                }
                $nl++;
                $j = $i + 1;
                $l = 0;
                $sep = -1;
                $prevsep = $sep;
                $shy = false;
                if($this->PageBreakTrigger < $this->y + $this->lasth && $this->inPageBody() && $this->AcceptPageBreak()) {
                    if($this->rtl) {
                        $this->x -= $margin["R"];
                    } else {
                        $this->x += $margin["L"];
                    }
                    $this->lMargin += $margin["L"];
                    $this->rMargin += $margin["R"];
                }
                $w = $this->getRemainingWidth();
                $wmax = $w - $this->cell_padding["L"] - $this->cell_padding["R"];
            } else {
                if($c != 160 && ($c == 173 || preg_match($this->re_spaces, TCPDF_FONTS::unichr($c, $this->isunicode)) || $c == 45 && $i < $nb - 1 && @preg_match("/[\\p{L}]/" . $this->re_space["m"], @TCPDF_FONTS::unichr($pc, $this->isunicode)) && @preg_match("/[\\p{L}]/" . $this->re_space["m"], @TCPDF_FONTS::unichr($chars[$i + 1], $this->isunicode)))) {
                    $prevsep = $sep;
                    $sep = $i;
                    if($c == 173 || $c == 45) {
                        $prevshy = $shy;
                        $shy = true;
                        if($pc == 45) {
                            $tmp_shy_replacement_width = 0;
                            $tmp_shy_replacement_char = "";
                        } else {
                            $tmp_shy_replacement_width = $shy_replacement_width;
                            $tmp_shy_replacement_char = $shy_replacement_char;
                        }
                    } else {
                        $shy = false;
                    }
                }
                if($this->isUnicodeFont() && $arabic) {
                    $l = $this->GetArrStringWidth(TCPDF_FONTS::utf8Bidi(array_slice($chars, $j, $i - $j), "", $this->tmprtl, $this->isunicode, $this->CurrentFont));
                } else {
                    $l += $this->GetCharWidth($c, $i + 1 < $nb);
                }
                if($wmax < $l || $c == 173 && $wmax <= $l + $tmp_shy_replacement_width) {
                    if($c == 173 && $wmax < $l + $tmp_shy_replacement_width) {
                        $sep = $prevsep;
                        $shy = $prevshy;
                    }
                    if($sep == -1) {
                        if($this->rtl && $this->x <= $this->w - $this->rMargin - $this->cell_padding["R"] - $margin["R"] - $chrwidth || !$this->rtl && $this->lMargin + $this->cell_padding["L"] + $margin["L"] + $chrwidth <= $this->x) {
                            $this->Cell($w, $h, "", 0, 1);
                            $linebreak = true;
                            if($firstline) {
                                return TCPDF_FONTS::UniArrSubString($uchars, $j);
                            }
                        } else {
                            $tmpstr = TCPDF_FONTS::UniArrSubString($uchars, $j, $i);
                            if($firstline) {
                                $startx = $this->x;
                                $tmparr = array_slice($chars, $j, $i - $j);
                                if($rtlmode) {
                                    $tmparr = TCPDF_FONTS::utf8Bidi($tmparr, $tmpstr, $this->tmprtl, $this->isunicode, $this->CurrentFont);
                                }
                                $linew = $this->GetArrStringWidth($tmparr);
                                unset($tmparr);
                                if($this->rtl) {
                                    $this->endlinex = $startx - $linew;
                                } else {
                                    $this->endlinex = $startx + $linew;
                                }
                                $w = $linew;
                                $tmpcellpadding = $this->cell_padding;
                                if($maxh == 0) {
                                    $this->setCellPadding(0);
                                }
                            }
                            if($firstblock && $this->isRTLTextDir()) {
                                $tmpstr = $this->stringRightTrim($tmpstr);
                            }
                            $this->Cell($w, $h, $tmpstr, 0, 1, $align, $fill, $link, $stretch);
                            unset($tmpstr);
                            if($firstline) {
                                $this->cell_padding = $tmpcellpadding;
                                return TCPDF_FONTS::UniArrSubString($uchars, $i);
                            }
                            $j = $i;
                            --$i;
                        }
                    } else {
                        if($this->rtl && !$firstblock && $sep < $i) {
                            $endspace = 1;
                        } else {
                            $endspace = 0;
                        }
                        $strrest = TCPDF_FONTS::UniArrSubString($uchars, $sep + $endspace);
                        $nextstr = TCPDF_STATIC::pregSplit("/" . $this->re_space["p"] . "/", $this->re_space["m"], $this->stringTrim($strrest));
                        if(isset($nextstr[0]) && $pw < $this->GetStringWidth($nextstr[0])) {
                            $tmpstr = TCPDF_FONTS::UniArrSubString($uchars, $j, $i);
                            if($firstline) {
                                $startx = $this->x;
                                $tmparr = array_slice($chars, $j, $i - $j);
                                if($rtlmode) {
                                    $tmparr = TCPDF_FONTS::utf8Bidi($tmparr, $tmpstr, $this->tmprtl, $this->isunicode, $this->CurrentFont);
                                }
                                $linew = $this->GetArrStringWidth($tmparr);
                                unset($tmparr);
                                if($this->rtl) {
                                    $this->endlinex = $startx - $linew;
                                } else {
                                    $this->endlinex = $startx + $linew;
                                }
                                $w = $linew;
                                $tmpcellpadding = $this->cell_padding;
                                if($maxh == 0) {
                                    $this->setCellPadding(0);
                                }
                            }
                            if($firstblock && $this->isRTLTextDir()) {
                                $tmpstr = $this->stringRightTrim($tmpstr);
                            }
                            $this->Cell($w, $h, $tmpstr, 0, 1, $align, $fill, $link, $stretch);
                            unset($tmpstr);
                            if($firstline) {
                                $this->cell_padding = $tmpcellpadding;
                                return TCPDF_FONTS::UniArrSubString($uchars, $i);
                            }
                            $j = $i;
                            --$i;
                        } else {
                            if($shy) {
                                $shy_width = $tmp_shy_replacement_width;
                                if($this->rtl) {
                                    $shy_char_left = $tmp_shy_replacement_char;
                                    $shy_char_right = "";
                                } else {
                                    $shy_char_left = "";
                                    $shy_char_right = $tmp_shy_replacement_char;
                                }
                            } else {
                                $shy_width = 0;
                                $shy_char_left = "";
                                $shy_char_right = "";
                            }
                            $tmpstr = TCPDF_FONTS::UniArrSubString($uchars, $j, $sep + $endspace);
                            if($firstline) {
                                $startx = $this->x;
                                $tmparr = array_slice($chars, $j, $sep + $endspace - $j);
                                if($rtlmode) {
                                    $tmparr = TCPDF_FONTS::utf8Bidi($tmparr, $tmpstr, $this->tmprtl, $this->isunicode, $this->CurrentFont);
                                }
                                $linew = $this->GetArrStringWidth($tmparr);
                                unset($tmparr);
                                if($this->rtl) {
                                    $this->endlinex = $startx - $linew - $shy_width;
                                } else {
                                    $this->endlinex = $startx + $linew + $shy_width;
                                }
                                $w = $linew;
                                $tmpcellpadding = $this->cell_padding;
                                if($maxh == 0) {
                                    $this->setCellPadding(0);
                                }
                            }
                            if($firstblock && $this->isRTLTextDir()) {
                                $tmpstr = $this->stringRightTrim($tmpstr);
                            }
                            $this->Cell($w, $h, $shy_char_left . $tmpstr . $shy_char_right, 0, 1, $align, $fill, $link, $stretch);
                            unset($tmpstr);
                            if($firstline) {
                                if($chars[$sep] == 45) {
                                    $endspace += 1;
                                }
                                $this->cell_padding = $tmpcellpadding;
                                return TCPDF_FONTS::UniArrSubString($uchars, $sep + $endspace);
                            }
                            $i = $sep;
                            $sep = -1;
                            $shy = false;
                            $j = $i + 1;
                        }
                    }
                    if($this->PageBreakTrigger < $this->y + $this->lasth && $this->inPageBody() && $this->AcceptPageBreak()) {
                        if($this->rtl) {
                            $this->x -= $margin["R"];
                        } else {
                            $this->x += $margin["L"];
                        }
                        $this->lMargin += $margin["L"];
                        $this->rMargin += $margin["R"];
                    }
                    $w = $this->getRemainingWidth();
                    $wmax = $w - $this->cell_padding["L"] - $this->cell_padding["R"];
                    if($linebreak) {
                        $linebreak = false;
                    } else {
                        $nl++;
                        $l = 0;
                    }
                }
            }
            $pc = $c;
        }
        if(0 < $l) {
            switch ($align) {
                case "J":
                case "C":
                case "L":
                    if(!$this->rtl) {
                        $w = $l;
                    }
                    break;
                case "R":
                    if($this->rtl) {
                        $w = $l;
                    }
                    break;
                default:
                    $w = $l;
                    $tmpstr = TCPDF_FONTS::UniArrSubString($uchars, $j, $nb);
                    if($firstline) {
                        $startx = $this->x;
                        $tmparr = array_slice($chars, $j, $nb - $j);
                        if($rtlmode) {
                            $tmparr = TCPDF_FONTS::utf8Bidi($tmparr, $tmpstr, $this->tmprtl, $this->isunicode, $this->CurrentFont);
                        }
                        $linew = $this->GetArrStringWidth($tmparr);
                        unset($tmparr);
                        if($this->rtl) {
                            $this->endlinex = $startx - $linew;
                        } else {
                            $this->endlinex = $startx + $linew;
                        }
                        $w = $linew;
                        $tmpcellpadding = $this->cell_padding;
                        if($maxh == 0) {
                            $this->setCellPadding(0);
                        }
                    }
                    if($firstblock && $this->isRTLTextDir()) {
                        $tmpstr = $this->stringRightTrim($tmpstr);
                    }
                    $this->Cell($w, $h, $tmpstr, 0, $ln, $align, $fill, $link, $stretch);
                    unset($tmpstr);
                    if($firstline) {
                        $this->cell_padding = $tmpcellpadding;
                        return TCPDF_FONTS::UniArrSubString($uchars, $nb);
                    }
                    $nl++;
            }
        }
        if($firstline) {
            return "";
        }
        return $nl;
    }
    protected function getRemainingWidth()
    {
        list($this->x, $this->y) = $this->checkPageRegions(0, $this->x, $this->y);
        if($this->rtl) {
            return $this->x - $this->lMargin;
        }
        return $this->w - $this->rMargin - $this->x;
    }
    protected function fitBlock($w, $h, $x, $y, $fitonpage = false)
    {
        if($w <= 0) {
            $w = $this->w - $this->lMargin - $this->rMargin;
        }
        if($w <= 0) {
            $w = 1;
        }
        if($h <= 0) {
            $h = $this->PageBreakTrigger - $this->tMargin;
        }
        if($h <= 0) {
            $h = 1;
        }
        if($fitonpage || $this->AutoPageBreak) {
            $ratio_wh = $w / $h;
            if($this->PageBreakTrigger - $this->tMargin < $h) {
                $h = $this->PageBreakTrigger - $this->tMargin;
                $w = $h * $ratio_wh;
            }
            if($fitonpage) {
                $maxw = $this->w - $this->lMargin - $this->rMargin;
                if($maxw < $w) {
                    $w = $maxw;
                    $h = $w / $ratio_wh;
                }
            }
        }
        $prev_x = $this->x;
        $prev_y = $this->y;
        if($this->checkPageBreak($h, $y) || $this->y < $prev_y) {
            $y = $this->y;
            if($this->rtl) {
                $x += $prev_x - $this->x;
            } else {
                $x += $this->x - $prev_x;
            }
            $this->newline = true;
        }
        if($fitonpage) {
            $ratio_wh = $w / $h;
            if($this->PageBreakTrigger < $y + $h) {
                $h = $this->PageBreakTrigger - $y;
                $w = $h * $ratio_wh;
            }
            if(!$this->rtl && $this->w - $this->rMargin < $x + $w) {
                $w = $this->w - $this->rMargin - $x;
                $h = $w / $ratio_wh;
            } elseif($this->rtl && $x - $w < $this->lMargin) {
                $w = $x - $this->lMargin;
                $h = $w / $ratio_wh;
            }
        }
        return [$w, $h, $x, $y];
    }
    public function Image($file, $x = NULL, $y = NULL, $w = 0, $h = 0, $type = "", $link = "", $align = "", $resize = false, $dpi = 300, $palign = "", $ismask = false, $imgmask = false, $border = 0, $fitbox = false, $hidden = false, $fitonpage = false, $alt = false, $altimgs = [])
    {
        if($this->state != 2) {
            return false;
        }
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        $exurl = "";
        $imsize = false;
        if(empty($file)) {
            return false;
        }
        if($file[0] === "@") {
            $imgdata = substr($file, 1);
        } else {
            if($file[0] === "*") {
                $file = substr($file, 1);
                $exurl = $file;
            }
            if(!@$this->fileExists($file)) {
                return false;
            }
            if(false !== ($info = $this->getImageBuffer($file))) {
                $imsize = [$info["w"], $info["h"]];
            } elseif(($imsize = @getimagesize($file)) === false && strpos($file, "__tcpdf_" . $this->file_id . "_img") === false) {
                $imgdata = $this->getCachedFileContents($file);
            }
        }
        if(!empty($imgdata)) {
            $original_file = $file;
            $file = TCPDF_STATIC::getObjFilename("img", $this->file_id);
            $fp = TCPDF_STATIC::fopenLocal($file, "w");
            if(!$fp) {
                $this->Error("Unable to write file: " . $file);
            }
            fwrite($fp, $imgdata);
            fclose($fp);
            unset($imgdata);
            $imsize = @getimagesize($file);
            if($imsize === false) {
                unlink($file);
                $file = $original_file;
            }
        }
        if($imsize === false) {
            if(0 < $w && 0 < $h) {
                $pw = $this->getHTMLUnitToUnits($w, 0, $this->pdfunit, true) * $this->imgscale * $this->k;
                $ph = $this->getHTMLUnitToUnits($h, 0, $this->pdfunit, true) * $this->imgscale * $this->k;
                $imsize = [$pw, $ph];
            } else {
                $this->Error("[Image] Unable to get the size of the image: " . $file);
            }
        }
        $filehash = md5($file);
        list($pixw, $pixh) = $imsize;
        if($w <= 0 && $h <= 0) {
            $w = $this->pixelsToUnits($pixw);
            $h = $this->pixelsToUnits($pixh);
        } elseif($w <= 0) {
            $w = $h * $pixw / $pixh;
        } elseif($h <= 0) {
            $h = $w * $pixh / $pixw;
        } elseif($fitbox !== false && 0 < $w && 0 < $h) {
            if(strlen($fitbox) !== 2) {
                $fitbox = "--";
            }
            if($w * $pixh / ($h * $pixw) < 1) {
                $oldh = $h;
                $h = $w * $pixh / $pixw;
                $hdiff = $oldh - $h;
                strtoupper($fitbox[1]);
                switch (strtoupper($fitbox[1])) {
                    case "T":
                    case "M":
                        $y += $hdiff / 2;
                        break;
                    case "B":
                        $y += $hdiff;
                        break;
                }
            } else {
                $oldw = $w;
                $w = $h * $pixw / $pixh;
                $wdiff = $oldw - $w;
                strtoupper($fitbox[0]);
                switch (strtoupper($fitbox[0])) {
                    case "L":
                        if($this->rtl) {
                            $x -= $wdiff;
                        }
                        break;
                    case "C":
                        if($this->rtl) {
                            $x -= $wdiff / 2;
                        } else {
                            $x += $wdiff / 2;
                        }
                        break;
                    case "R":
                        if(!$this->rtl) {
                            $x += $wdiff;
                        }
                        break;
                }
            }
        }
        list($w, $h, $x, $y) = $this->fitBlock($w, $h, $x, $y, $fitonpage);
        $neww = round($w * $this->k * $dpi / $this->dpi);
        $newh = round($h * $this->k * $dpi / $this->dpi);
        $newsize = $neww * $newh;
        $pixsize = $pixw * $pixh;
        if(intval($resize) == 2) {
            $resize = true;
        } elseif($pixsize <= $newsize) {
            $resize = false;
        }
        $newimage = true;
        if(in_array($file, $this->imagekeys)) {
            $newimage = false;
            $info = $this->getImageBuffer($file);
            if(strpos($file, "__tcpdf_" . $this->file_id . "_imgmask_") === false) {
                $oldsize = $info["w"] * $info["h"];
                if($oldsize < $newsize && $resize || $oldsize < $pixsize && !$resize) {
                    $newimage = true;
                }
            }
        } elseif($ismask === false && $imgmask === false && strpos($file, "__tcpdf_" . $this->file_id . "_imgmask_") === false) {
            $tempfile_plain = K_PATH_CACHE . "__tcpdf_" . $this->file_id . "_imgmask_plain_" . $filehash;
            $tempfile_alpha = K_PATH_CACHE . "__tcpdf_" . $this->file_id . "_imgmask_alpha_" . $filehash;
            if(in_array($tempfile_plain, $this->imagekeys)) {
                $info = $this->getImageBuffer($tempfile_plain);
                $oldsize = $info["w"] * $info["h"];
                if($oldsize < $newsize && $resize || $oldsize < $pixsize && !$resize) {
                    $newimage = true;
                } else {
                    $newimage = false;
                    $imgmask = $this->Image($tempfile_alpha, $x, $y, $w, $h, "PNG", "", "", $resize, $dpi, "", true, false);
                    return $this->Image($tempfile_plain, $x, $y, $w, $h, $type, $link, $align, $resize, $dpi, $palign, false, $imgmask);
                }
            }
        }
        if($newimage) {
            $type = strtolower($type);
            if($type == "") {
                $type = TCPDF_IMAGES::getImageFileType($file, $imsize);
            } elseif($type == "jpg") {
                $type = "jpeg";
            }
            $mqr = TCPDF_STATIC::get_mqr();
            TCPDF_STATIC::set_mqr(false);
            $mtd = "_parse" . $type;
            $gdfunction = "imagecreatefrom" . $type;
            $info = false;
            if(method_exists("TCPDF_IMAGES", $mtd) && !($resize && (function_exists($gdfunction) || extension_loaded("imagick")))) {
                $info = TCPDF_IMAGES::$mtd($file);
                if($ismask === false && $imgmask === false && strpos($file, "__tcpdf_" . $this->file_id . "_imgmask_") === false && ($info === "pngalpha" || isset($info["trns"]) && !empty($info["trns"]))) {
                    return $this->ImagePngAlpha($file, $x, $y, $pixw, $pixh, $w, $h, "PNG", $link, $align, $resize, $dpi, $palign, $filehash);
                }
            }
            if($info === false && function_exists($gdfunction)) {
                try {
                    $img = $gdfunction($file);
                    if($img !== false) {
                        if($resize) {
                            $imgr = imagecreatetruecolor($neww, $newh);
                            if($type == "gif" || $type == "png") {
                                $imgr = TCPDF_IMAGES::setGDImageTransparency($imgr, $img);
                            }
                            imagecopyresampled($imgr, $img, 0, 0, 0, 0, $neww, $newh, $pixw, $pixh);
                            $img = $imgr;
                        }
                        if($type == "gif" || $type == "png") {
                            $info = TCPDF_IMAGES::_toPNG($img, TCPDF_STATIC::getObjFilename("img", $this->file_id));
                        } else {
                            $info = TCPDF_IMAGES::_toJPEG($img, $this->jpeg_quality, TCPDF_STATIC::getObjFilename("img", $this->file_id));
                        }
                    }
                } catch (Exception $e) {
                    $info = false;
                }
            }
            if($info === false && extension_loaded("imagick")) {
                try {
                    $img = new Imagick();
                    if($type == "svg") {
                        if($file[0] === "@") {
                            $svgimg = substr($file, 1);
                        } else {
                            $svgimg = $this->getCachedFileContents($file);
                        }
                        if($svgimg !== false) {
                            $regs = [];
                            if(preg_match("/<svg([^\\>]*)>/si", $svgimg, $regs)) {
                                $svgtag = $regs[1];
                                $tmp = [];
                                if(preg_match("/[\\s]+width[\\s]*=[\\s]*\"([^\"]*)\"/si", $svgtag, $tmp)) {
                                    $ow = $this->getHTMLUnitToUnits($tmp[1], 1, $this->svgunit, false);
                                    $owu = sprintf("%F", $ow * $dpi / 72) . $this->pdfunit;
                                    $svgtag = preg_replace("/[\\s]+width[\\s]*=[\\s]*\"[^\"]*\"/si", " width=\"" . $owu . "\"", $svgtag, 1);
                                } else {
                                    $ow = $w;
                                }
                                $tmp = [];
                                if(preg_match("/[\\s]+height[\\s]*=[\\s]*\"([^\"]*)\"/si", $svgtag, $tmp)) {
                                    $oh = $this->getHTMLUnitToUnits($tmp[1], 1, $this->svgunit, false);
                                    $ohu = sprintf("%F", $oh * $dpi / 72) . $this->pdfunit;
                                    $svgtag = preg_replace("/[\\s]+height[\\s]*=[\\s]*\"[^\"]*\"/si", " height=\"" . $ohu . "\"", $svgtag, 1);
                                } else {
                                    $oh = $h;
                                }
                                $tmp = [];
                                if(!preg_match("/[\\s]+viewBox[\\s]*=[\\s]*\"[\\s]*([0-9\\.]+)[\\s]+([0-9\\.]+)[\\s]+([0-9\\.]+)[\\s]+([0-9\\.]+)[\\s]*\"/si", $svgtag, $tmp)) {
                                    $vbw = $ow * $this->imgscale * $this->k;
                                    $vbh = $oh * $this->imgscale * $this->k;
                                    $vbox = sprintf(" viewBox=\"0 0 %F %F\" ", $vbw, $vbh);
                                    $svgtag = $vbox . $svgtag;
                                }
                                $svgimg = preg_replace("/<svg([^\\>]*)>/si", "<svg" . $svgtag . ">", $svgimg, 1);
                            }
                            $img->readImageBlob($svgimg);
                        }
                    } else {
                        $img->readImage($file);
                    }
                    if($resize) {
                        $img->resizeImage($neww, $newh, 10, 1, false);
                    }
                    $img->setCompressionQuality($this->jpeg_quality);
                    $img->setImageFormat("jpeg");
                    $tempname = TCPDF_STATIC::getObjFilename("img", $this->file_id);
                    $img->writeImage($tempname);
                    $info = TCPDF_IMAGES::_parsejpeg($tempname);
                    unlink($tempname);
                    $img->destroy();
                } catch (Exception $e) {
                    $info = false;
                }
            }
            if($info === false) {
                return false;
            }
            TCPDF_STATIC::set_mqr($mqr);
            if($ismask) {
                $info["cs"] = "DeviceGray";
            }
            if($imgmask !== false) {
                $info["masked"] = $imgmask;
            }
            if(!empty($exurl)) {
                $info["exurl"] = $exurl;
            }
            $info["altimgs"] = $altimgs;
            $info["i"] = $this->setImageBuffer($file, $info);
        }
        $this->img_rb_x = $x + $w;
        $this->img_rb_y = $y + $h;
        if($palign == "L") {
            $ximg = $this->lMargin;
        } elseif($palign == "C") {
            $ximg = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
        } elseif($palign == "R") {
            $ximg = $this->w - $this->rMargin - $w;
        } else {
            $ximg = $x;
        }
        if($ismask || $hidden) {
            return $info["i"];
        }
        $xkimg = $ximg * $this->k;
        if(!$alt) {
            $this->_out(sprintf("q %F 0 0 %F %F %F cm /I%u Do Q", $w * $this->k, $h * $this->k, $xkimg, ($this->h - ($y + $h)) * $this->k, $info["i"]));
        }
        if(!empty($border)) {
            $bx = $this->x;
            $by = $this->y;
            $this->x = $ximg;
            if($this->rtl) {
                $this->x += $w;
            }
            $this->y = $y;
            $this->Cell($w, $h, "", $border, 0, "", 0, "", 0, true);
            $this->x = $bx;
            $this->y = $by;
        }
        if($link) {
            $this->Link($ximg, $y, $w, $h, $link, 0);
        }
        switch ($align) {
            case "T":
                $this->y = $y;
                $this->x = $this->img_rb_x;
                break;
            case "M":
                $this->y = $y + round($h / 2);
                $this->x = $this->img_rb_x;
                break;
            case "B":
                $this->y = $this->img_rb_y;
                $this->x = $this->img_rb_x;
                break;
            case "N":
                $this->setY($this->img_rb_y);
                break;
            default:
                $this->endlinex = $this->img_rb_x;
                if($this->inxobj) {
                    $this->xobjects[$this->xobjid]["images"][] = $info["i"];
                }
                return $info["i"];
        }
    }
    protected function ImagePngAlpha($file, $x, $y, $wpx, $hpx, $w, $h, $type, $link, $align, $resize, $dpi, $palign, $filehash = "")
    {
        if(empty($filehash)) {
            $filehash = md5($file);
        }
        $tempfile_plain = K_PATH_CACHE . "__tcpdf_" . $this->file_id . "_imgmask_plain_" . $filehash;
        $tempfile_alpha = K_PATH_CACHE . "__tcpdf_" . $this->file_id . "_imgmask_alpha_" . $filehash;
        $parsed = false;
        $parse_error = "";
        if($parsed === false && extension_loaded("imagick")) {
            try {
                $img = new Imagick();
                $img->readImage($file);
                $imga = TCPDF_STATIC::objclone($img);
                if(method_exists($img, "setImageAlphaChannel") && defined("Imagick::ALPHACHANNEL_EXTRACT")) {
                    $img->setImageAlphaChannel(Imagick::ALPHACHANNEL_EXTRACT);
                } else {
                    $img->separateImageChannel(8);
                    $img->negateImage(true);
                }
                $img->setImageFormat("png");
                $img->writeImage($tempfile_alpha);
                if(method_exists($imga, "setImageMatte")) {
                    $imga->setImageMatte(false);
                } else {
                    $imga->separateImageChannel(39);
                }
                $imga->setImageFormat("png");
                $imga->writeImage($tempfile_plain);
                $parsed = true;
            } catch (Exception $e) {
                $parse_error = "Imagick library error: " . $e->getMessage();
            }
        }
        if($parsed === false && function_exists("imagecreatefrompng")) {
            try {
                $img = imagecreatefrompng($file);
                $imgalpha = imagecreate($wpx, $hpx);
                for ($c = 0; $c < 256; $c++) {
                    ImageColorAllocate($imgalpha, $c, $c, $c);
                }
                for ($xpx = 0; $xpx < $wpx; $xpx++) {
                    for ($ypx = 0; $ypx < $hpx; $ypx++) {
                        $color = imagecolorat($img, $xpx, $ypx);
                        $alpha = $this->getGDgamma($img, $color);
                        imagesetpixel($imgalpha, (int) $xpx, (int) $ypx, (int) $alpha);
                    }
                }
                imagepng($imgalpha, $tempfile_alpha);
                imagedestroy($imgalpha);
                $imgplain = imagecreatetruecolor($wpx, $hpx);
                imagecopy($imgplain, $img, 0, 0, 0, 0, $wpx, $hpx);
                imagepng($imgplain, $tempfile_plain);
                imagedestroy($imgplain);
                $parsed = true;
            } catch (Exception $e) {
                $parse_error = "GD library error: " . $e->getMessage();
            }
        }
        if($parsed === false) {
            if(empty($parse_error)) {
                $this->Error("TCPDF requires the Imagick or GD extension to handle PNG images with alpha channel.");
            } else {
                $this->Error($parse_error);
            }
        }
        $imgmask = $this->Image($tempfile_alpha, $x, $y, $w, $h, "PNG", "", "", $resize, $dpi, "", true, false);
        $this->Image($tempfile_plain, $x, $y, $w, $h, $type, $link, $align, $resize, $dpi, $palign, false, $imgmask);
    }
    protected function getGDgamma($img, $c)
    {
        if(!isset($this->gdgammacache["#" . $c])) {
            $colors = imagecolorsforindex($img, $c);
            $this->gdgammacache["#" . $c] = (int) ((127 - $colors["alpha"]) / 127 * 255);
            $this->gdgammacache["#" . $c] = (int) (pow($this->gdgammacache["#" . $c] / 255, 0) * 255);
            if(8 < count($this->gdgammacache)) {
                array_shift($this->gdgammacache);
            }
        }
        return $this->gdgammacache["#" . $c];
    }
    public function Ln($h = NULL, $cell = false)
    {
        if(1 < $this->num_columns && $this->y == $this->columns[$this->current_column]["y"] && isset($this->columns[$this->current_column]["x"]) && $this->x == $this->columns[$this->current_column]["x"]) {
            return NULL;
        }
        if($cell) {
            if($this->rtl) {
                $cellpadding = $this->cell_padding["R"];
            } else {
                $cellpadding = $this->cell_padding["L"];
            }
        } else {
            $cellpadding = 0;
        }
        if($this->rtl) {
            $this->x = $this->w - $this->rMargin - $cellpadding;
        } else {
            $this->x = $this->lMargin + $cellpadding;
        }
        if(TCPDF_STATIC::empty_string($h)) {
            $h = $this->lasth;
        }
        $this->y += $h;
        $this->newline = true;
    }
    public function GetX()
    {
        if($this->rtl) {
            return $this->w - $this->x;
        }
        return $this->x;
    }
    public function GetAbsX()
    {
        return $this->x;
    }
    public function GetY()
    {
        return $this->y;
    }
    public function setX($x, $rtloff = false)
    {
        $x = floatval($x);
        if(!$rtloff && $this->rtl) {
            if(0 <= $x) {
                $this->x = $this->w - $x;
            } else {
                $this->x = abs($x);
            }
        } elseif(0 <= $x) {
            $this->x = $x;
        } else {
            $this->x = $this->w + $x;
        }
        if($this->x < 0) {
            $this->x = 0;
        }
        if($this->w < $this->x) {
            $this->x = $this->w;
        }
    }
    public function setY($y, $resetx = true, $rtloff = false)
    {
        $y = floatval($y);
        if($resetx) {
            if(!$rtloff && $this->rtl) {
                $this->x = $this->w - $this->rMargin;
            } else {
                $this->x = $this->lMargin;
            }
        }
        if(0 <= $y) {
            $this->y = $y;
        } else {
            $this->y = $this->h + $y;
        }
        if($this->y < 0) {
            $this->y = 0;
        }
        if($this->h < $this->y) {
            $this->y = $this->h;
        }
    }
    public function setXY($x, $y, $rtloff = false)
    {
        $this->setY($y, false, $rtloff);
        $this->setX($x, $rtloff);
    }
    public function setAbsX($x)
    {
        $this->x = floatval($x);
    }
    public function setAbsY($y)
    {
        $this->y = floatval($y);
    }
    public function setAbsXY($x, $y)
    {
        $this->setAbsX($x);
        $this->setAbsY($y);
    }
    public function Output($name = "doc.pdf", $dest = "I")
    {
        if($this->state < 3) {
            $this->Close();
        }
        if(is_bool($dest)) {
            $dest = $dest ? "D" : "F";
        }
        $dest = strtoupper($dest);
        if($dest[0] != "F" && $name !== NULL) {
            $name = preg_replace("/[\\s]+/", "_", $name);
            $name = preg_replace("/[^a-zA-Z0-9_\\.-]/", "", $name);
        }
        if($this->sign) {
            $pdfdoc = $this->getBuffer();
            $pdfdoc = substr($pdfdoc, 0, -1);
            $byterange_string_len = strlen(TCPDF_STATIC::$byterange_string);
            $byte_range = [];
            $byte_range[0] = 0;
            $byte_range[1] = strpos($pdfdoc, TCPDF_STATIC::$byterange_string) + $byterange_string_len + 10;
            $byte_range[2] = $byte_range[1] + $this->signature_max_length + 2;
            $byte_range[3] = strlen($pdfdoc) - $byte_range[2];
            $pdfdoc = substr($pdfdoc, 0, $byte_range[1]) . substr($pdfdoc, $byte_range[2]);
            $byterange = sprintf("/ByteRange[0 %u %u %u]", $byte_range[1], $byte_range[2], $byte_range[3]);
            $byterange .= str_repeat(" ", $byterange_string_len - strlen($byterange));
            $pdfdoc = str_replace(TCPDF_STATIC::$byterange_string, $byterange, $pdfdoc);
            $tempdoc = TCPDF_STATIC::getObjFilename("doc", $this->file_id);
            $f = TCPDF_STATIC::fopenLocal($tempdoc, "wb");
            if(!$f) {
                $this->Error("Unable to create temporary file: " . $tempdoc);
            }
            $pdfdoc_length = strlen($pdfdoc);
            fwrite($f, $pdfdoc, $pdfdoc_length);
            fclose($f);
            $tempsign = TCPDF_STATIC::getObjFilename("sig", $this->file_id);
            if(empty($this->signature_data["extracerts"])) {
                openssl_pkcs7_sign($tempdoc, $tempsign, $this->signature_data["signcert"], [$this->signature_data["privkey"], $this->signature_data["password"]], [], PKCS7_BINARY | PKCS7_DETACHED);
            } else {
                openssl_pkcs7_sign($tempdoc, $tempsign, $this->signature_data["signcert"], [$this->signature_data["privkey"], $this->signature_data["password"]], [], PKCS7_BINARY | PKCS7_DETACHED, $this->signature_data["extracerts"]);
            }
            $signature = file_get_contents($tempsign);
            $signature = substr($signature, $pdfdoc_length);
            $signature = substr($signature, strpos($signature, "%%EOF\n\n------") + 13);
            $tmparr = explode("\n\n", $signature);
            $signature = $tmparr[1];
            $signature = base64_decode(trim($signature));
            $signature = $this->applyTSA($signature);
            $signature = current(unpack("H*", $signature));
            $signature = str_pad($signature, $this->signature_max_length, "0");
            $this->buffer = substr($pdfdoc, 0, $byte_range[1]) . "<" . $signature . ">" . substr($pdfdoc, $byte_range[1]);
            $this->bufferlen = strlen($this->buffer);
        }
        switch ($dest) {
            case "I":
                if(ob_get_contents()) {
                    $this->Error("Some data has already been output, can't send PDF file");
                }
                if(php_sapi_name() != "cli") {
                    header("Content-Type: application/pdf");
                    if(headers_sent()) {
                        $this->Error("Some data has already been output to browser, can't send PDF file");
                    }
                    header("Cache-Control: private, must-revalidate, post-check=0, pre-check=0, max-age=1");
                    header("Pragma: public");
                    header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
                    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
                    header("Content-Disposition: inline; filename=\"" . basename($name) . "\"");
                    TCPDF_STATIC::sendOutputData($this->getBuffer(), $this->bufferlen);
                } else {
                    echo $this->getBuffer();
                }
                break;
            case "D":
                if(ob_get_contents()) {
                    $this->Error("Some data has already been output, can't send PDF file");
                }
                header("Content-Description: File Transfer");
                if(headers_sent()) {
                    $this->Error("Some data has already been output to browser, can't send PDF file");
                }
                header("Cache-Control: private, must-revalidate, post-check=0, pre-check=0, max-age=1");
                header("Pragma: public");
                header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
                header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
                if(strpos(php_sapi_name(), "cgi") === false) {
                    header("Content-Type: application/force-download");
                    header("Content-Type: application/octet-stream", false);
                    header("Content-Type: application/download", false);
                    header("Content-Type: application/pdf", false);
                } else {
                    header("Content-Type: application/pdf");
                }
                header("Content-Disposition: attachment; filename=\"" . basename($name) . "\"");
                header("Content-Transfer-Encoding: binary");
                TCPDF_STATIC::sendOutputData($this->getBuffer(), $this->bufferlen);
                break;
            case "F":
            case "FI":
            case "FD":
                $f = TCPDF_STATIC::fopenLocal($name, "wb");
                if(!$f) {
                    $this->Error("Unable to create output file: " . $name);
                }
                fwrite($f, $this->getBuffer(), $this->bufferlen);
                fclose($f);
                if($dest == "FI") {
                    header("Content-Type: application/pdf");
                    header("Cache-Control: private, must-revalidate, post-check=0, pre-check=0, max-age=1");
                    header("Pragma: public");
                    header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
                    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
                    header("Content-Disposition: inline; filename=\"" . basename($name) . "\"");
                    TCPDF_STATIC::sendOutputData(file_get_contents($name), filesize($name));
                } elseif($dest == "FD") {
                    if(ob_get_contents()) {
                        $this->Error("Some data has already been output, can't send PDF file");
                    }
                    header("Content-Description: File Transfer");
                    if(headers_sent()) {
                        $this->Error("Some data has already been output to browser, can't send PDF file");
                    }
                    header("Cache-Control: private, must-revalidate, post-check=0, pre-check=0, max-age=1");
                    header("Pragma: public");
                    header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
                    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
                    if(strpos(php_sapi_name(), "cgi") === false) {
                        header("Content-Type: application/force-download");
                        header("Content-Type: application/octet-stream", false);
                        header("Content-Type: application/download", false);
                        header("Content-Type: application/pdf", false);
                    } else {
                        header("Content-Type: application/pdf");
                    }
                    header("Content-Disposition: attachment; filename=\"" . basename($name) . "\"");
                    header("Content-Transfer-Encoding: binary");
                    TCPDF_STATIC::sendOutputData(file_get_contents($name), filesize($name));
                }
                break;
            case "E":
                $retval = "Content-Type: application/pdf;\r\n";
                $retval .= " name=\"" . $name . "\"" . "\r\n";
                $retval .= "Content-Transfer-Encoding: base64\r\n";
                $retval .= "Content-Disposition: attachment;\r\n";
                $retval .= " filename=\"" . $name . "\"" . "\r\n\r\n";
                $retval .= chunk_split(base64_encode($this->getBuffer()), 76, "\r\n");
                return $retval;
                break;
            case "S":
                return $this->getBuffer();
                break;
            default:
                $this->Error("Incorrect output destination: " . $dest);
                return "";
        }
    }
    public function _destroy($destroyall = false, $preserve_objcopy = false)
    {
        if(isset(self::$cleaned_ids[$this->file_id])) {
            $destroyall = false;
        }
        if($destroyall && !$preserve_objcopy && isset($this->file_id)) {
            self::$cleaned_ids[$this->file_id] = true;
            if($handle = @opendir(K_PATH_CACHE)) {
                while (false !== ($file_name = readdir($handle))) {
                    if(strpos($file_name, "__tcpdf_" . $this->file_id . "_") === 0) {
                        unlink(K_PATH_CACHE . $file_name);
                    }
                }
                closedir($handle);
            }
            if(isset($this->imagekeys)) {
                foreach ($this->imagekeys as $file) {
                    if(strpos($file, K_PATH_CACHE) === 0 && TCPDF_STATIC::file_exists($file)) {
                        @unlink($file);
                    }
                }
            }
        }
        $preserve = ["file_id", "state", "bufferlen", "buffer", "cached_files", "imagekeys", "sign", "signature_data", "signature_max_length", "byterange_string", "tsa_timestamp", "tsa_data"];
        foreach (array_keys(get_object_vars($this)) as $val) {
            if(($destroyall || !in_array($val, $preserve)) && (!$preserve_objcopy || $val != "objcopy") && $val != "file_id" && isset($this->{$val})) {
                unset($this->{$val});
            }
        }
    }
    protected function _dochecks()
    {
        if(false) {
            $this->Error("Don't alter the locale before including class file");
        }
        if(sprintf("%.1F", 0) != "1.0") {
            setlocale(LC_NUMERIC, "C");
        }
    }
    protected function getInternalPageNumberAliases($a = "")
    {
        $alias = [];
        $alias = ["u" => [], "a" => []];
        $u = "{" . $a . "}";
        $alias["u"][] = TCPDF_STATIC::_escape($u);
        if($this->isunicode) {
            $alias["u"][] = TCPDF_STATIC::_escape(TCPDF_FONTS::UTF8ToLatin1($u, $this->isunicode, $this->CurrentFont));
            $alias["u"][] = TCPDF_STATIC::_escape(TCPDF_FONTS::utf8StrRev($u, false, $this->tmprtl, $this->isunicode, $this->CurrentFont));
            $alias["a"][] = TCPDF_STATIC::_escape(TCPDF_FONTS::UTF8ToLatin1($a, $this->isunicode, $this->CurrentFont));
            $alias["a"][] = TCPDF_STATIC::_escape(TCPDF_FONTS::utf8StrRev($a, false, $this->tmprtl, $this->isunicode, $this->CurrentFont));
        }
        $alias["a"][] = TCPDF_STATIC::_escape($a);
        return $alias;
    }
    protected function getAllInternalPageNumberAliases()
    {
        $basic_alias = [TCPDF_STATIC::$alias_tot_pages, TCPDF_STATIC::$alias_num_page, TCPDF_STATIC::$alias_group_tot_pages, TCPDF_STATIC::$alias_group_num_page, TCPDF_STATIC::$alias_right_shift];
        $pnalias = [];
        foreach ($basic_alias as $k => $a) {
            $pnalias[$k] = $this->getInternalPageNumberAliases($a);
        }
        return $pnalias;
    }
    protected function replaceRightShiftPageNumAliases($page, $aliases, $diff)
    {
        foreach ($aliases as $type => $alias) {
            foreach ($alias as $a) {
                $startnum = strpos($a, ":") + 1;
                $a = substr($a, 0, $startnum);
                if(($pos = strpos($page, $a)) !== false) {
                    $endnum = strpos($page, "}", $pos);
                    $aa = substr($page, $pos, $endnum - $pos + 1);
                    $ratio = substr($page, $pos + $startnum, $endnum - $pos - $startnum);
                    $ratio = preg_replace("/[^0-9\\.]/", "", $ratio);
                    $ratio = floatval($ratio);
                    if($type == "u") {
                        $chrdiff = floor(($diff + 12) * $ratio);
                        $shift = str_repeat(" ", $chrdiff);
                        $shift = TCPDF_FONTS::UTF8ToUTF16BE($shift, false, $this->isunicode, $this->CurrentFont);
                    } else {
                        $chrdiff = floor(($diff + 11) * $ratio);
                        $shift = str_repeat(" ", $chrdiff);
                    }
                    $page = str_replace($aa, $shift, $page);
                }
            }
        }
        return $page;
    }
    protected function setPageBoxTypes($boxes)
    {
        $this->page_boxes = [];
        foreach ($boxes as $box) {
            if(in_array($box, TCPDF_STATIC::$pageboxes)) {
                $this->page_boxes[] = $box;
            }
        }
    }
    protected function _putpages()
    {
        $filter = $this->compress ? "/Filter /FlateDecode " : "";
        $pnalias = $this->getAllInternalPageNumberAliases();
        $num_pages = $this->numpages;
        $ptpa = TCPDF_STATIC::formatPageNumber($this->starting_page_number + $num_pages - 1);
        $ptpu = TCPDF_FONTS::UTF8ToUTF16BE($ptpa, false, $this->isunicode, $this->CurrentFont);
        $ptp_num_chars = $this->GetNumChars($ptpa);
        $pagegroupnum = 0;
        $groupnum = 0;
        $ptgu = 1;
        $ptga = 1;
        $ptg_num_chars = 1;
        for ($n = 1; $n <= $num_pages; $n++) {
            $temppage = $this->getPageBuffer($n);
            $pagelen = strlen($temppage);
            $pnpa = TCPDF_STATIC::formatPageNumber($this->starting_page_number + $n - 1);
            $pnpu = TCPDF_FONTS::UTF8ToUTF16BE($pnpa, false, $this->isunicode, $this->CurrentFont);
            $pnp_num_chars = $this->GetNumChars($pnpa);
            $pdiff = 0;
            $gdiff = 0;
            if(!empty($this->pagegroups)) {
                if(isset($this->newpagegroup[$n])) {
                    $pagegroupnum = 0;
                    $groupnum++;
                    $ptga = TCPDF_STATIC::formatPageNumber($this->pagegroups[$groupnum]);
                    $ptgu = TCPDF_FONTS::UTF8ToUTF16BE($ptga, false, $this->isunicode, $this->CurrentFont);
                    $ptg_num_chars = $this->GetNumChars($ptga);
                }
                $pagegroupnum++;
                $pnga = TCPDF_STATIC::formatPageNumber($pagegroupnum);
                $pngu = TCPDF_FONTS::UTF8ToUTF16BE($pnga, false, $this->isunicode, $this->CurrentFont);
                $png_num_chars = $this->GetNumChars($pnga);
                $replace = [];
                $replace[] = [$ptgu, $ptg_num_chars, 9, $pnalias[2]["u"]];
                $replace[] = [$ptga, $ptg_num_chars, 7, $pnalias[2]["a"]];
                $replace[] = [$pngu, $png_num_chars, 9, $pnalias[3]["u"]];
                $replace[] = [$pnga, $png_num_chars, 7, $pnalias[3]["a"]];
                list($temppage, $gdiff) = TCPDF_STATIC::replacePageNumAliases($temppage, $replace, $gdiff);
            }
            $replace = [];
            $replace[] = [$ptpu, $ptp_num_chars, 9, $pnalias[0]["u"]];
            $replace[] = [$ptpa, $ptp_num_chars, 7, $pnalias[0]["a"]];
            $replace[] = [$pnpu, $pnp_num_chars, 9, $pnalias[1]["u"]];
            $replace[] = [$pnpa, $pnp_num_chars, 7, $pnalias[1]["a"]];
            list($temppage, $pdiff) = TCPDF_STATIC::replacePageNumAliases($temppage, $replace, $pdiff);
            $temppage = $this->replaceRightShiftPageNumAliases($temppage, $pnalias[4], max($pdiff, $gdiff));
            $temppage = str_replace($this->epsmarker, "", $temppage);
            $this->page_obj_id[$n] = $this->_newobj();
            $out = "<<";
            $out .= " /Type /Page";
            $out .= " /Parent 1 0 R";
            if(empty($this->signature_data["approval"]) || $this->signature_data["approval"] != "A") {
                $out .= " /LastModified " . $this->_datestring(0, $this->doc_modification_timestamp);
            }
            $out .= " /Resources 2 0 R";
            foreach ($this->page_boxes as $box) {
                $out .= " /" . $box;
                $out .= sprintf(" [%F %F %F %F]", $this->pagedim[$n][$box]["llx"], $this->pagedim[$n][$box]["lly"], $this->pagedim[$n][$box]["urx"], $this->pagedim[$n][$box]["ury"]);
            }
            if(isset($this->pagedim[$n]["BoxColorInfo"]) && !empty($this->pagedim[$n]["BoxColorInfo"])) {
                $out .= " /BoxColorInfo <<";
                foreach ($this->page_boxes as $box) {
                    if(isset($this->pagedim[$n]["BoxColorInfo"][$box])) {
                        $out .= " /" . $box . " <<";
                        if(isset($this->pagedim[$n]["BoxColorInfo"][$box]["C"])) {
                            $color = $this->pagedim[$n]["BoxColorInfo"][$box]["C"];
                            $out .= " /C [";
                            $out .= sprintf(" %F %F %F", $color[0] / 255, $color[1] / 255, $color[2] / 255);
                            $out .= " ]";
                        }
                        if(isset($this->pagedim[$n]["BoxColorInfo"][$box]["W"])) {
                            $out .= " /W " . $this->pagedim[$n]["BoxColorInfo"][$box]["W"] * $this->k;
                        }
                        if(isset($this->pagedim[$n]["BoxColorInfo"][$box]["S"])) {
                            $out .= " /S /" . $this->pagedim[$n]["BoxColorInfo"][$box]["S"];
                        }
                        if(isset($this->pagedim[$n]["BoxColorInfo"][$box]["D"])) {
                            $dashes = $this->pagedim[$n]["BoxColorInfo"][$box]["D"];
                            $out .= " /D [";
                            foreach ($dashes as $dash) {
                                $out .= sprintf(" %F", $dash * $this->k);
                            }
                            $out .= " ]";
                        }
                        $out .= " >>";
                    }
                }
                $out .= " >>";
            }
            $out .= " /Contents " . ($this->n + 1) . " 0 R";
            $out .= " /Rotate " . $this->pagedim[$n]["Rotate"];
            if(!$this->pdfa_mode || 2 <= $this->pdfa_version) {
                $out .= " /Group << /Type /Group /S /Transparency /CS /DeviceRGB >>";
            }
            if(isset($this->pagedim[$n]["trans"]) && !empty($this->pagedim[$n]["trans"])) {
                if(isset($this->pagedim[$n]["trans"]["Dur"])) {
                    $out .= " /Dur " . $this->pagedim[$n]["trans"]["Dur"];
                }
                $out .= " /Trans <<";
                $out .= " /Type /Trans";
                if(isset($this->pagedim[$n]["trans"]["S"])) {
                    $out .= " /S /" . $this->pagedim[$n]["trans"]["S"];
                }
                if(isset($this->pagedim[$n]["trans"]["D"])) {
                    $out .= " /D " . $this->pagedim[$n]["trans"]["D"];
                }
                if(isset($this->pagedim[$n]["trans"]["Dm"])) {
                    $out .= " /Dm /" . $this->pagedim[$n]["trans"]["Dm"];
                }
                if(isset($this->pagedim[$n]["trans"]["M"])) {
                    $out .= " /M /" . $this->pagedim[$n]["trans"]["M"];
                }
                if(isset($this->pagedim[$n]["trans"]["Di"])) {
                    $out .= " /Di " . $this->pagedim[$n]["trans"]["Di"];
                }
                if(isset($this->pagedim[$n]["trans"]["SS"])) {
                    $out .= " /SS " . $this->pagedim[$n]["trans"]["SS"];
                }
                if(isset($this->pagedim[$n]["trans"]["B"])) {
                    $out .= " /B " . $this->pagedim[$n]["trans"]["B"];
                }
                $out .= " >>";
            }
            $out .= $this->_getannotsrefs($n);
            $out .= " /PZ " . $this->pagedim[$n]["PZ"];
            $out .= " >>";
            $out .= "\nendobj";
            $this->_out($out);
            $p = $this->compress ? gzcompress($temppage) : $temppage;
            $this->_newobj();
            $p = $this->_getrawstream($p);
            $this->_out("<<" . $filter . "/Length " . strlen($p) . ">> stream" . "\n" . $p . "\n" . "endstream" . "\n" . "endobj");
        }
        $out = $this->_getobj(1) . "\n";
        $out .= "<< /Type /Pages /Kids [";
        foreach ($this->page_obj_id as $page_obj) {
            $out .= " " . $page_obj . " 0 R";
        }
        $out .= " ] /Count " . $num_pages . " >>";
        $out .= "\nendobj";
        $this->_out($out);
    }
    protected function _getannotsrefs($n)
    {
        if(!(isset($this->PageAnnots[$n]) || $this->sign && isset($this->signature_data["cert_type"]))) {
            return "";
        }
        $out = " /Annots [";
        if(isset($this->PageAnnots[$n])) {
            foreach ($this->PageAnnots[$n] as $key => $val) {
                if(!in_array($val["n"], $this->radio_groups)) {
                    $out .= " " . $val["n"] . " 0 R";
                }
            }
            if(isset($this->radiobutton_groups[$n])) {
                foreach ($this->radiobutton_groups[$n] as $key => $data) {
                    if(isset($data["n"])) {
                        $out .= " " . $data["n"] . " 0 R";
                    }
                }
            }
        }
        if($this->sign && $n == $this->signature_appearance["page"] && isset($this->signature_data["cert_type"])) {
            $out .= " " . $this->sig_obj_id . " 0 R";
        }
        if(!empty($this->empty_signature_appearance)) {
            foreach ($this->empty_signature_appearance as $esa) {
                if($esa["page"] == $n) {
                    $out .= " " . $esa["objid"] . " 0 R";
                }
            }
        }
        $out .= " ]";
        return $out;
    }
    protected function _putannotsobjs()
    {
        for ($n = 1; $n <= $this->numpages; $n++) {
            if(isset($this->PageAnnots[$n])) {
                foreach ($this->PageAnnots[$n] as $key => $pl) {
                    $annot_obj_id = $this->PageAnnots[$n][$key]["n"];
                    if(isset($this->radiobutton_groups[$n][$pl["txt"]]) && is_array($this->radiobutton_groups[$n][$pl["txt"]])) {
                        $radio_button_obj_id = $this->radiobutton_groups[$n][$pl["txt"]]["n"];
                        $annots = "<<";
                        $annots .= " /Type /Annot";
                        $annots .= " /Subtype /Widget";
                        $annots .= " /Rect [0 0 0 0]";
                        if($this->radiobutton_groups[$n][$pl["txt"]]["#readonly#"]) {
                            $annots .= " /F 68";
                            $annots .= " /Ff 49153";
                        } else {
                            $annots .= " /F 4";
                            $annots .= " /Ff 49152";
                        }
                        $annots .= " /T " . $this->_datastring($pl["txt"], $radio_button_obj_id);
                        if(isset($pl["opt"]["tu"]) && is_string($pl["opt"]["tu"])) {
                            $annots .= " /TU " . $this->_datastring($pl["opt"]["tu"], $radio_button_obj_id);
                        }
                        $annots .= " /FT /Btn";
                        $annots .= " /Kids [";
                        $defval = "";
                        foreach ($this->radiobutton_groups[$n][$pl["txt"]] as $key => $data) {
                            if(isset($data["kid"])) {
                                $annots .= " " . $data["kid"] . " 0 R";
                                if($data["def"] !== "Off") {
                                    $defval = $data["def"];
                                }
                            }
                        }
                        $annots .= " ]";
                        if(!empty($defval)) {
                            $annots .= " /V /" . $defval;
                        }
                        $annots .= " >>";
                        $this->_out($this->_getobj($radio_button_obj_id) . "\n" . $annots . "\n" . "endobj");
                        $this->form_obj_id[] = $radio_button_obj_id;
                        $this->radiobutton_groups[$n][$pl["txt"]] = $radio_button_obj_id;
                    }
                    $formfield = false;
                    $pl["opt"] = array_change_key_case($pl["opt"], CASE_LOWER);
                    $a = $pl["x"] * $this->k;
                    $b = $this->pagedim[$n]["h"] - ($pl["y"] + $pl["h"]) * $this->k;
                    $c = $pl["w"] * $this->k;
                    $d = $pl["h"] * $this->k;
                    $rect = sprintf("%F %F %F %F", $a, $b, $a + $c, $b + $d);
                    $annots = "<</Type /Annot";
                    $annots .= " /Subtype /" . $pl["opt"]["subtype"];
                    $annots .= " /Rect [" . $rect . "]";
                    $ft = ["Btn", "Tx", "Ch", "Sig"];
                    if(isset($pl["opt"]["ft"]) && in_array($pl["opt"]["ft"], $ft)) {
                        $annots .= " /FT /" . $pl["opt"]["ft"];
                        $formfield = true;
                    }
                    if($pl["opt"]["subtype"] !== "Link") {
                        $annots .= " /Contents " . $this->_textstring($pl["txt"], $annot_obj_id);
                    }
                    $annots .= " /P " . $this->page_obj_id[$n] . " 0 R";
                    $annots .= " /NM " . $this->_datastring(sprintf("%04u-%04u", $n, $key), $annot_obj_id);
                    $annots .= " /M " . $this->_datestring($annot_obj_id, $this->doc_modification_timestamp);
                    if(isset($pl["opt"]["f"])) {
                        $fval = 0;
                        if(is_array($pl["opt"]["f"])) {
                            foreach ($pl["opt"]["f"] as $f) {
                                strtolower($f);
                                switch (strtolower($f)) {
                                    case "invisible":
                                        $fval += 1;
                                        break;
                                    case "hidden":
                                        $fval += 2;
                                        break;
                                    case "print":
                                        $fval += 4;
                                        break;
                                    case "nozoom":
                                        $fval += 8;
                                        break;
                                    case "norotate":
                                        $fval += 16;
                                        break;
                                    case "noview":
                                        $fval += 32;
                                        break;
                                    case "readonly":
                                        $fval += 64;
                                        break;
                                    case "locked":
                                        $fval += 256;
                                        break;
                                    case "togglenoview":
                                        $fval += 512;
                                        break;
                                    case "lockedcontents":
                                        $fval += 1024;
                                        break;
                                }
                            }
                        } else {
                            $fval = intval($pl["opt"]["f"]);
                        }
                    } else {
                        $fval = 4;
                    }
                    if($this->pdfa_mode) {
                        $fval |= 4;
                    }
                    $annots .= " /F " . intval($fval);
                    if(isset($pl["opt"]["as"]) && is_string($pl["opt"]["as"])) {
                        $annots .= " /AS /" . $pl["opt"]["as"];
                    }
                    if(isset($pl["opt"]["ap"])) {
                        $annots .= " /AP <<";
                        if(is_array($pl["opt"]["ap"])) {
                            foreach ($pl["opt"]["ap"] as $apmode => $apdef) {
                                $annots .= " /" . strtoupper($apmode);
                                if(is_array($apdef)) {
                                    $annots .= " <<";
                                    foreach ($apdef as $apstate => $stream) {
                                        $apsobjid = $this->_putAPXObject($c, $d, $stream);
                                        $annots .= " /" . $apstate . " " . $apsobjid . " 0 R";
                                    }
                                    $annots .= " >>";
                                } else {
                                    $apsobjid = $this->_putAPXObject($c, $d, $apdef);
                                    $annots .= " " . $apsobjid . " 0 R";
                                }
                            }
                        } else {
                            $annots .= $pl["opt"]["ap"];
                        }
                        $annots .= " >>";
                    }
                    if(isset($pl["opt"]["bs"]) && is_array($pl["opt"]["bs"])) {
                        $annots .= " /BS <<";
                        $annots .= " /Type /Border";
                        if(isset($pl["opt"]["bs"]["w"])) {
                            $annots .= " /W " . intval($pl["opt"]["bs"]["w"]);
                        }
                        $bstyles = ["S", "D", "B", "I", "U"];
                        if(isset($pl["opt"]["bs"]["s"]) && in_array($pl["opt"]["bs"]["s"], $bstyles)) {
                            $annots .= " /S /" . $pl["opt"]["bs"]["s"];
                        }
                        if(isset($pl["opt"]["bs"]["d"]) && is_array($pl["opt"]["bs"]["d"])) {
                            $annots .= " /D [";
                            foreach ($pl["opt"]["bs"]["d"] as $cord) {
                                $annots .= " " . intval($cord);
                            }
                            $annots .= "]";
                        }
                        $annots .= " >>";
                    } else {
                        $annots .= " /Border [";
                        if(isset($pl["opt"]["border"]) && 3 <= count($pl["opt"]["border"])) {
                            $annots .= intval($pl["opt"]["border"][0]) . " ";
                            $annots .= intval($pl["opt"]["border"][1]) . " ";
                            $annots .= intval($pl["opt"]["border"][2]);
                            if(isset($pl["opt"]["border"][3]) && is_array($pl["opt"]["border"][3])) {
                                $annots .= " [";
                                foreach ($pl["opt"]["border"][3] as $dash) {
                                    $annots .= intval($dash) . " ";
                                }
                                $annots .= "]";
                            }
                        } else {
                            $annots .= "0 0 0";
                        }
                        $annots .= "]";
                    }
                    if(isset($pl["opt"]["be"]) && is_array($pl["opt"]["be"])) {
                        $annots .= " /BE <<";
                        $bstyles = ["S", "C"];
                        if(isset($pl["opt"]["be"]["s"]) && in_array($pl["opt"]["be"]["s"], $bstyles)) {
                            $annots .= " /S /" . $pl["opt"]["bs"]["s"];
                        } else {
                            $annots .= " /S /S";
                        }
                        if(isset($pl["opt"]["be"]["i"]) && 0 <= $pl["opt"]["be"]["i"] && $pl["opt"]["be"]["i"] <= 2) {
                            $annots .= " /I " . sprintf(" %F", $pl["opt"]["be"]["i"]);
                        }
                        $annots .= ">>";
                    }
                    if(isset($pl["opt"]["c"]) && is_array($pl["opt"]["c"]) && !empty($pl["opt"]["c"])) {
                        $annots .= " /C " . TCPDF_COLORS::getColorStringFromArray($pl["opt"]["c"]);
                    }
                    $markups = ["text", "freetext", "line", "square", "circle", "polygon", "polyline", "highlight", "underline", "squiggly", "strikeout", "stamp", "caret", "ink", "fileattachment", "sound"];
                    if(in_array(strtolower($pl["opt"]["subtype"]), $markups)) {
                        if(isset($pl["opt"]["t"]) && is_string($pl["opt"]["t"])) {
                            $annots .= " /T " . $this->_textstring($pl["opt"]["t"], $annot_obj_id);
                        }
                        if(isset($pl["opt"]["ca"])) {
                            $annots .= " /CA " . sprintf("%F", floatval($pl["opt"]["ca"]));
                        }
                        if(isset($pl["opt"]["rc"])) {
                            $annots .= " /RC " . $this->_textstring($pl["opt"]["rc"], $annot_obj_id);
                        }
                        $annots .= " /CreationDate " . $this->_datestring($annot_obj_id, $this->doc_creation_timestamp);
                        if(isset($pl["opt"]["subj"])) {
                            $annots .= " /Subj " . $this->_textstring($pl["opt"]["subj"], $annot_obj_id);
                        }
                    }
                    $lineendings = ["Square", "Circle", "Diamond", "OpenArrow", "ClosedArrow", "None", "Butt", "ROpenArrow", "RClosedArrow", "Slash"];
                    strtolower($pl["opt"]["subtype"]);
                    switch (strtolower($pl["opt"]["subtype"])) {
                        case "text":
                            if(isset($pl["opt"]["open"])) {
                                $annots .= " /Open " . (strtolower($pl["opt"]["open"]) == "true" ? "true" : "false");
                            }
                            $iconsapp = ["Comment", "Help", "Insert", "Key", "NewParagraph", "Note", "Paragraph"];
                            if(isset($pl["opt"]["name"]) && in_array($pl["opt"]["name"], $iconsapp)) {
                                $annots .= " /Name /" . $pl["opt"]["name"];
                            } else {
                                $annots .= " /Name /Note";
                            }
                            $hasStateModel = isset($pl["opt"]["statemodel"]);
                            $hasState = isset($pl["opt"]["state"]);
                            $statemodels = ["Marked", "Review"];
                            if(!$hasStateModel && !$hasState) {
                            } else {
                                if($hasStateModel && in_array($pl["opt"]["statemodel"], $statemodels)) {
                                    $annots .= " /StateModel /" . $pl["opt"]["statemodel"];
                                } else {
                                    $pl["opt"]["statemodel"] = "Marked";
                                    $annots .= " /StateModel /" . $pl["opt"]["statemodel"];
                                }
                                if($pl["opt"]["statemodel"] == "Marked") {
                                    $states = ["Accepted", "Unmarked"];
                                } else {
                                    $states = ["Accepted", "Rejected", "Cancelled", "Completed", "None"];
                                }
                                if($hasState && in_array($pl["opt"]["state"], $states)) {
                                    $annots .= " /State /" . $pl["opt"]["state"];
                                } elseif($pl["opt"]["statemodel"] == "Marked") {
                                    $annots .= " /State /Unmarked";
                                } else {
                                    $annots .= " /State /None";
                                }
                            }
                            break;
                        case "link":
                            if(is_string($pl["txt"]) && !empty($pl["txt"])) {
                                if($pl["txt"][0] == "#") {
                                    $annots .= " /A <</S /GoTo /D /" . TCPDF_STATIC::encodeNameObject(substr($pl["txt"], 1)) . ">>";
                                } elseif($pl["txt"][0] == "%") {
                                    $filename = basename(substr($pl["txt"], 1));
                                    $annots .= " /A << /S /GoToE /D [0 /Fit] /NewWindow true /T << /R /C /P " . ($n - 1) . " /A " . $this->embeddedfiles[$filename]["a"] . " >> >>";
                                } elseif($pl["txt"][0] == "*") {
                                    $filename = basename(substr($pl["txt"], 1));
                                    $jsa = "var D=event.target.doc;var MyData=D.dataObjects;for (var i in MyData) if (MyData[i].path==\"" . $filename . "\") D.exportDataObject( { cName : MyData[i].name, nLaunch : 2});";
                                    $annots .= " /A << /S /JavaScript /JS " . $this->_textstring($jsa, $annot_obj_id) . ">>";
                                } else {
                                    $parsedUrl = parse_url($pl["txt"]);
                                    if(empty($parsedUrl["scheme"]) && !empty($parsedUrl["path"]) && strtolower(substr($parsedUrl["path"], -4)) == ".pdf") {
                                        $dest = "[0 /Fit]";
                                        if(!empty($parsedUrl["fragment"])) {
                                            $tmp = explode("=", $parsedUrl["fragment"]);
                                            $dest = "(" . (count($tmp) == 2 ? $tmp[1] : $tmp[0]) . ")";
                                        }
                                        $annots .= " /A <</S /GoToR /D " . $dest . " /F " . $this->_datastring($this->unhtmlentities($parsedUrl["path"]), $annot_obj_id) . " /NewWindow true>>";
                                    } else {
                                        $annots .= " /A <</S /URI /URI " . $this->_datastring($this->unhtmlentities($pl["txt"]), $annot_obj_id) . ">>";
                                    }
                                }
                            } elseif(isset($this->links[$pl["txt"]])) {
                                $l = $this->links[$pl["txt"]];
                                if(isset($this->page_obj_id[$l["p"]])) {
                                    $annots .= sprintf(" /Dest [%u 0 R /XYZ 0 %F null]", $this->page_obj_id[$l["p"]], $this->pagedim[$l["p"]]["h"] - $l["y"] * $this->k);
                                }
                            }
                            $hmodes = ["N", "I", "O", "P"];
                            if(isset($pl["opt"]["h"]) && in_array($pl["opt"]["h"], $hmodes)) {
                                $annots .= " /H /" . $pl["opt"]["h"];
                            } else {
                                $annots .= " /H /I";
                            }
                            break;
                        case "freetext":
                            if(isset($pl["opt"]["da"]) && !empty($pl["opt"]["da"])) {
                                $annots .= " /DA (" . $pl["opt"]["da"] . ")";
                            }
                            if(isset($pl["opt"]["q"]) && 0 <= $pl["opt"]["q"] && $pl["opt"]["q"] <= 2) {
                                $annots .= " /Q " . intval($pl["opt"]["q"]);
                            }
                            if(isset($pl["opt"]["rc"])) {
                                $annots .= " /RC " . $this->_textstring($pl["opt"]["rc"], $annot_obj_id);
                            }
                            if(isset($pl["opt"]["ds"])) {
                                $annots .= " /DS " . $this->_textstring($pl["opt"]["ds"], $annot_obj_id);
                            }
                            if(isset($pl["opt"]["cl"]) && is_array($pl["opt"]["cl"])) {
                                $annots .= " /CL [";
                                foreach ($pl["opt"]["cl"] as $cl) {
                                    $annots .= sprintf("%F ", $cl * $this->k);
                                }
                                $annots .= "]";
                            }
                            $tfit = ["FreeText", "FreeTextCallout", "FreeTextTypeWriter"];
                            if(isset($pl["opt"]["it"]) && in_array($pl["opt"]["it"], $tfit)) {
                                $annots .= " /IT /" . $pl["opt"]["it"];
                            }
                            if(isset($pl["opt"]["rd"]) && is_array($pl["opt"]["rd"])) {
                                $l = $pl["opt"]["rd"][0] * $this->k;
                                $r = $pl["opt"]["rd"][1] * $this->k;
                                $t = $pl["opt"]["rd"][2] * $this->k;
                                $b = $pl["opt"]["rd"][3] * $this->k;
                                $annots .= " /RD [" . sprintf("%F %F %F %F", $l, $r, $t, $b) . "]";
                            }
                            if(isset($pl["opt"]["le"]) && in_array($pl["opt"]["le"], $lineendings)) {
                                $annots .= " /LE /" . $pl["opt"]["le"];
                            }
                            break;
                        case "line":
                        case "square":
                        case "circle":
                        case "polygon":
                        case "polyline":
                        case "highlight":
                        case "underline":
                        case "squiggly":
                        case "strikeout":
                        case "stamp":
                        case "caret":
                        case "ink":
                        case "popup":
                        case "fileattachment":
                            if($this->pdfa_mode && $this->pdfa_version != 3) {
                            } elseif(!isset($pl["opt"]["fs"])) {
                            } else {
                                $filename = basename($pl["opt"]["fs"]);
                                if(isset($this->embeddedfiles[$filename]["f"])) {
                                    $annots .= " /FS " . $this->embeddedfiles[$filename]["f"] . " 0 R";
                                    $iconsapp = ["Graph", "Paperclip", "PushPin", "Tag"];
                                    if(isset($pl["opt"]["name"]) && in_array($pl["opt"]["name"], $iconsapp)) {
                                        $annots .= " /Name /" . $pl["opt"]["name"];
                                    } else {
                                        $annots .= " /Name /PushPin";
                                    }
                                    $this->embeddedfiles[$filename]["a"] = $key;
                                }
                            }
                            break;
                        case "sound":
                            if(!isset($pl["opt"]["fs"])) {
                            } else {
                                $filename = basename($pl["opt"]["fs"]);
                                if(isset($this->embeddedfiles[$filename]["f"])) {
                                    $annots .= " /Sound " . $this->embeddedfiles[$filename]["f"] . " 0 R";
                                    $iconsapp = ["Speaker", "Mic"];
                                    if(isset($pl["opt"]["name"]) && in_array($pl["opt"]["name"], $iconsapp)) {
                                        $annots .= " /Name /" . $pl["opt"]["name"];
                                    } else {
                                        $annots .= " /Name /Speaker";
                                    }
                                }
                            }
                            break;
                        case "movie":
                        case "widget":
                            $hmode = ["N", "I", "O", "P", "T"];
                            if(isset($pl["opt"]["h"]) && in_array($pl["opt"]["h"], $hmode)) {
                                $annots .= " /H /" . $pl["opt"]["h"];
                            }
                            if(isset($pl["opt"]["mk"]) && is_array($pl["opt"]["mk"]) && !empty($pl["opt"]["mk"])) {
                                $annots .= " /MK <<";
                                if(isset($pl["opt"]["mk"]["r"])) {
                                    $annots .= " /R " . $pl["opt"]["mk"]["r"];
                                }
                                if(isset($pl["opt"]["mk"]["bc"]) && is_array($pl["opt"]["mk"]["bc"])) {
                                    $annots .= " /BC " . TCPDF_COLORS::getColorStringFromArray($pl["opt"]["mk"]["bc"]);
                                }
                                if(isset($pl["opt"]["mk"]["bg"]) && is_array($pl["opt"]["mk"]["bg"])) {
                                    $annots .= " /BG " . TCPDF_COLORS::getColorStringFromArray($pl["opt"]["mk"]["bg"]);
                                }
                                if(isset($pl["opt"]["mk"]["ca"])) {
                                    $annots .= " /CA " . $pl["opt"]["mk"]["ca"];
                                }
                                if(isset($pl["opt"]["mk"]["rc"])) {
                                    $annots .= " /RC " . $pl["opt"]["mk"]["rc"];
                                }
                                if(isset($pl["opt"]["mk"]["ac"])) {
                                    $annots .= " /AC " . $pl["opt"]["mk"]["ac"];
                                }
                                if(isset($pl["opt"]["mk"]["i"])) {
                                    $info = $this->getImageBuffer($pl["opt"]["mk"]["i"]);
                                    if($info !== false) {
                                        $annots .= " /I " . $info["n"] . " 0 R";
                                    }
                                }
                                if(isset($pl["opt"]["mk"]["ri"])) {
                                    $info = $this->getImageBuffer($pl["opt"]["mk"]["ri"]);
                                    if($info !== false) {
                                        $annots .= " /RI " . $info["n"] . " 0 R";
                                    }
                                }
                                if(isset($pl["opt"]["mk"]["ix"])) {
                                    $info = $this->getImageBuffer($pl["opt"]["mk"]["ix"]);
                                    if($info !== false) {
                                        $annots .= " /IX " . $info["n"] . " 0 R";
                                    }
                                }
                                if(isset($pl["opt"]["mk"]["if"]) && is_array($pl["opt"]["mk"]["if"]) && !empty($pl["opt"]["mk"]["if"])) {
                                    $annots .= " /IF <<";
                                    $if_sw = ["A", "B", "S", "N"];
                                    if(isset($pl["opt"]["mk"]["if"]["sw"]) && in_array($pl["opt"]["mk"]["if"]["sw"], $if_sw)) {
                                        $annots .= " /SW /" . $pl["opt"]["mk"]["if"]["sw"];
                                    }
                                    $if_s = ["A", "P"];
                                    if(isset($pl["opt"]["mk"]["if"]["s"]) && in_array($pl["opt"]["mk"]["if"]["s"], $if_s)) {
                                        $annots .= " /S /" . $pl["opt"]["mk"]["if"]["s"];
                                    }
                                    if(isset($pl["opt"]["mk"]["if"]["a"]) && is_array($pl["opt"]["mk"]["if"]["a"]) && !empty($pl["opt"]["mk"]["if"]["a"])) {
                                        $annots .= sprintf(" /A [%F %F]", $pl["opt"]["mk"]["if"]["a"][0], $pl["opt"]["mk"]["if"]["a"][1]);
                                    }
                                    if(isset($pl["opt"]["mk"]["if"]["fb"]) && $pl["opt"]["mk"]["if"]["fb"]) {
                                        $annots .= " /FB true";
                                    }
                                    $annots .= ">>";
                                }
                                if(isset($pl["opt"]["mk"]["tp"]) && 0 <= $pl["opt"]["mk"]["tp"] && $pl["opt"]["mk"]["tp"] <= 6) {
                                    $annots .= " /TP " . intval($pl["opt"]["mk"]["tp"]);
                                }
                                $annots .= ">>";
                            }
                            if(isset($this->radiobutton_groups[$n][$pl["txt"]])) {
                                $annots .= " /Parent " . $this->radiobutton_groups[$n][$pl["txt"]] . " 0 R";
                            }
                            if(isset($pl["opt"]["t"]) && is_string($pl["opt"]["t"])) {
                                $annots .= " /T " . $this->_datastring($pl["opt"]["t"], $annot_obj_id);
                            }
                            if(isset($pl["opt"]["tu"]) && is_string($pl["opt"]["tu"])) {
                                $annots .= " /TU " . $this->_datastring($pl["opt"]["tu"], $annot_obj_id);
                            }
                            if(isset($pl["opt"]["tm"]) && is_string($pl["opt"]["tm"])) {
                                $annots .= " /TM " . $this->_datastring($pl["opt"]["tm"], $annot_obj_id);
                            }
                            if(isset($pl["opt"]["ff"])) {
                                if(is_array($pl["opt"]["ff"])) {
                                    $flag = 0;
                                    foreach ($pl["opt"]["ff"] as $val) {
                                        $flag += 1 << $val - 1;
                                    }
                                } else {
                                    $flag = intval($pl["opt"]["ff"]);
                                }
                                $annots .= " /Ff " . $flag;
                            }
                            if(isset($pl["opt"]["maxlen"])) {
                                $annots .= " /MaxLen " . intval($pl["opt"]["maxlen"]);
                            }
                            if(isset($pl["opt"]["v"])) {
                                $annots .= " /V";
                                if(is_array($pl["opt"]["v"])) {
                                    foreach ($pl["opt"]["v"] as $optval) {
                                        if(is_float($optval)) {
                                            $optval = sprintf("%F", $optval);
                                        }
                                        $annots .= " " . $optval;
                                    }
                                } else {
                                    $annots .= " " . $this->_textstring($pl["opt"]["v"], $annot_obj_id);
                                }
                            }
                            if(isset($pl["opt"]["dv"])) {
                                $annots .= " /DV";
                                if(is_array($pl["opt"]["dv"])) {
                                    foreach ($pl["opt"]["dv"] as $optval) {
                                        if(is_float($optval)) {
                                            $optval = sprintf("%F", $optval);
                                        }
                                        $annots .= " " . $optval;
                                    }
                                } else {
                                    $annots .= " " . $this->_textstring($pl["opt"]["dv"], $annot_obj_id);
                                }
                            }
                            if(isset($pl["opt"]["rv"])) {
                                $annots .= " /RV";
                                if(is_array($pl["opt"]["rv"])) {
                                    foreach ($pl["opt"]["rv"] as $optval) {
                                        if(is_float($optval)) {
                                            $optval = sprintf("%F", $optval);
                                        }
                                        $annots .= " " . $optval;
                                    }
                                } else {
                                    $annots .= " " . $this->_textstring($pl["opt"]["rv"], $annot_obj_id);
                                }
                            }
                            if(isset($pl["opt"]["a"]) && !empty($pl["opt"]["a"])) {
                                $annots .= " /A << " . $pl["opt"]["a"] . " >>";
                            }
                            if(isset($pl["opt"]["aa"]) && !empty($pl["opt"]["aa"])) {
                                $annots .= " /AA << " . $pl["opt"]["aa"] . " >>";
                            }
                            if(isset($pl["opt"]["da"]) && !empty($pl["opt"]["da"])) {
                                $annots .= " /DA (" . $pl["opt"]["da"] . ")";
                            }
                            if(isset($pl["opt"]["q"]) && 0 <= $pl["opt"]["q"] && $pl["opt"]["q"] <= 2) {
                                $annots .= " /Q " . intval($pl["opt"]["q"]);
                            }
                            if(isset($pl["opt"]["opt"]) && is_array($pl["opt"]["opt"]) && !empty($pl["opt"]["opt"])) {
                                $annots .= " /Opt [";
                                foreach ($pl["opt"]["opt"] as $copt) {
                                    if(is_array($copt)) {
                                        $annots .= " [" . $this->_textstring($copt[0], $annot_obj_id) . " " . $this->_textstring($copt[1], $annot_obj_id) . "]";
                                    } else {
                                        $annots .= " " . $this->_textstring($copt, $annot_obj_id);
                                    }
                                }
                                $annots .= "]";
                            }
                            if(isset($pl["opt"]["ti"])) {
                                $annots .= " /TI " . intval($pl["opt"]["ti"]);
                            }
                            if(isset($pl["opt"]["i"]) && is_array($pl["opt"]["i"]) && !empty($pl["opt"]["i"])) {
                                $annots .= " /I [";
                                foreach ($pl["opt"]["i"] as $copt) {
                                    $annots .= intval($copt) . " ";
                                }
                                $annots .= "]";
                            }
                            break;
                        case "screen":
                        case "printermark":
                        case "trapnet":
                        case "watermark":
                        case "3d":
                        default:
                            $annots .= ">>";
                            $this->_out($this->_getobj($annot_obj_id) . "\n" . $annots . "\n" . "endobj");
                            if($formfield && !isset($this->radiobutton_groups[$n][$pl["txt"]])) {
                                $this->form_obj_id[] = $annot_obj_id;
                            }
                    }
                }
            }
        }
    }
    protected function _putAPXObject($w = 0, $h = 0, $stream = "")
    {
        $stream = trim($stream);
        $out = $this->_getobj() . "\n";
        $this->xobjects["AX" . $this->n] = ["n" => $this->n];
        $out .= "<<";
        $out .= " /Type /XObject";
        $out .= " /Subtype /Form";
        $out .= " /FormType 1";
        if($this->compress) {
            $stream = gzcompress($stream);
            $out .= " /Filter /FlateDecode";
        }
        $rect = sprintf("%F %F", $w, $h);
        $out .= " /BBox [0 0 " . $rect . "]";
        $out .= " /Matrix [1 0 0 1 0 0]";
        $out .= " /Resources 2 0 R";
        $stream = $this->_getrawstream($stream);
        $out .= " /Length " . strlen($stream);
        $out .= " >>";
        $out .= " stream\n" . $stream . "\n" . "endstream";
        $out .= "\nendobj";
        $this->_out($out);
        return $this->n;
    }
    protected function _putfonts()
    {
        $nf = $this->n;
        foreach ($this->diffs as $diff) {
            $this->_newobj();
            $this->_out("<< /Type /Encoding /BaseEncoding /WinAnsiEncoding /Differences [" . $diff . "] >>" . "\n" . "endobj");
        }
        $mqr = TCPDF_STATIC::get_mqr();
        TCPDF_STATIC::set_mqr(false);
        foreach ($this->FontFiles as $file => $info) {
            $fontfile = TCPDF_FONTS::getFontFullPath($file, $info["fontdir"]);
            if(!TCPDF_STATIC::empty_string($fontfile)) {
                $font = file_get_contents($fontfile);
                $compressed = substr($file, -2) == ".z";
                if(!$compressed && isset($info["length2"])) {
                    $header = ord($font[0]) == 128;
                    if($header) {
                        $font = substr($font, 6);
                    }
                    if($header && ord($font[$info["length1"]]) == 128) {
                        $font = substr($font, 0, $info["length1"]) . substr($font, $info["length1"] + 6);
                    }
                } elseif($info["subset"] && (!$compressed || $compressed && function_exists("gzcompress"))) {
                    if($compressed) {
                        $font = gzuncompress($font);
                    }
                    $subsetchars = [];
                    foreach ($info["fontkeys"] as $fontkey) {
                        $fontinfo = $this->getFontBuffer($fontkey);
                        $subsetchars += $fontinfo["subsetchars"];
                    }
                    $font = TCPDF_FONTS::_getTrueTypeFontSubset($font, $subsetchars);
                    $info["length1"] = strlen($font);
                    if($compressed) {
                        $font = gzcompress($font);
                    }
                }
                $this->_newobj();
                $this->FontFiles[$file]["n"] = $this->n;
                $stream = $this->_getrawstream($font);
                $out = "<< /Length " . strlen($stream);
                if($compressed) {
                    $out .= " /Filter /FlateDecode";
                }
                $out .= " /Length1 " . $info["length1"];
                if(isset($info["length2"])) {
                    $out .= " /Length2 " . $info["length2"] . " /Length3 0";
                }
                $out .= " >>";
                $out .= " stream\n" . $stream . "\n" . "endstream";
                $out .= "\nendobj";
                $this->_out($out);
            }
        }
        TCPDF_STATIC::set_mqr($mqr);
        foreach ($this->fontkeys as $k) {
            $font = $this->getFontBuffer($k);
            $type = $font["type"];
            $name = $font["name"];
            if($type == "core") {
                $out = $this->_getobj($this->font_obj_ids[$k]) . "\n";
                $out .= "<</Type /Font";
                $out .= " /Subtype /Type1";
                $out .= " /BaseFont /" . $name;
                $out .= " /Name /F" . $font["i"];
                if(strtolower($name) != "symbol" && strtolower($name) != "zapfdingbats") {
                    $out .= " /Encoding /WinAnsiEncoding";
                }
                if($k == "helvetica") {
                    $this->annotation_fonts[$k] = $font["i"];
                }
                $out .= " >>";
                $out .= "\nendobj";
                $this->_out($out);
            } elseif($type == "Type1" || $type == "TrueType") {
                $out = $this->_getobj($this->font_obj_ids[$k]) . "\n";
                $out .= "<</Type /Font";
                $out .= " /Subtype /" . $type;
                $out .= " /BaseFont /" . $name;
                $out .= " /Name /F" . $font["i"];
                $out .= " /FirstChar 32 /LastChar 255";
                $out .= " /Widths " . ($this->n + 1) . " 0 R";
                $out .= " /FontDescriptor " . ($this->n + 2) . " 0 R";
                if($font["enc"]) {
                    if(isset($font["diff"])) {
                        $out .= " /Encoding " . ($nf + $font["diff"]) . " 0 R";
                    } else {
                        $out .= " /Encoding /WinAnsiEncoding";
                    }
                }
                $out .= " >>";
                $out .= "\nendobj";
                $this->_out($out);
                $this->_newobj();
                $s = "[";
                for ($i = 32; $i < 256; $i++) {
                    if(isset($font["cw"][$i])) {
                        $s .= $font["cw"][$i] . " ";
                    } else {
                        $s .= $font["dw"] . " ";
                    }
                }
                $s .= "]";
                $s .= "\nendobj";
                $this->_out($s);
                $this->_newobj();
                $s = "<</Type /FontDescriptor /FontName /" . $name;
                foreach ($font["desc"] as $fdk => $fdv) {
                    if(is_float($fdv)) {
                        $fdv = sprintf("%F", $fdv);
                    }
                    $s .= " /" . $fdk . " " . $fdv . "";
                }
                if(!TCPDF_STATIC::empty_string($font["file"])) {
                    $s .= " /FontFile" . ($type == "Type1" ? "" : "2") . " " . $this->FontFiles[$font["file"]]["n"] . " 0 R";
                }
                $s .= ">>";
                $s .= "\nendobj";
                $this->_out($s);
            } else {
                $mtd = "_put" . strtolower($type);
                if(!method_exists($this, $mtd)) {
                    $this->Error("Unsupported font type: " . $type);
                }
                $this->{$mtd}($font);
            }
        }
    }
    protected function _puttruetypeunicode($font)
    {
        $fontname = "";
        if($font["subset"]) {
            $subtag = sprintf("%06u", $font["i"]);
            $subtag = strtr($subtag, "0123456789", "ABCDEFGHIJ");
            $fontname .= $subtag . "+";
        }
        $fontname .= $font["name"];
        $out = $this->_getobj($this->font_obj_ids[$font["fontkey"]]) . "\n";
        $out .= "<< /Type /Font";
        $out .= " /Subtype /Type0";
        $out .= " /BaseFont /" . $fontname;
        $out .= " /Name /F" . $font["i"];
        $out .= " /Encoding /" . $font["enc"];
        $out .= " /ToUnicode " . ($this->n + 1) . " 0 R";
        $out .= " /DescendantFonts [" . ($this->n + 2) . " 0 R]";
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
        $stream = TCPDF_FONT_DATA::$uni_identity_h;
        $this->_newobj();
        $stream = $this->compress ? gzcompress($stream) : $stream;
        $filter = $this->compress ? "/Filter /FlateDecode " : "";
        $stream = $this->_getrawstream($stream);
        $this->_out("<<" . $filter . "/Length " . strlen($stream) . ">> stream" . "\n" . $stream . "\n" . "endstream" . "\n" . "endobj");
        $oid = $this->_newobj();
        $out = "<< /Type /Font";
        $out .= " /Subtype /CIDFontType2";
        $out .= " /BaseFont /" . $fontname;
        $cidinfo = "/Registry " . $this->_datastring($font["cidinfo"]["Registry"], $oid);
        $cidinfo .= " /Ordering " . $this->_datastring($font["cidinfo"]["Ordering"], $oid);
        $cidinfo .= " /Supplement " . $font["cidinfo"]["Supplement"];
        $out .= " /CIDSystemInfo << " . $cidinfo . " >>";
        $out .= " /FontDescriptor " . ($this->n + 1) . " 0 R";
        $out .= " /DW " . $font["dw"];
        $out .= "\n" . TCPDF_FONTS::_putfontwidths($font, 0);
        if(isset($font["ctg"]) && !TCPDF_STATIC::empty_string($font["ctg"])) {
            $out .= "\n/CIDToGIDMap " . ($this->n + 2) . " 0 R";
        }
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
        $this->_newobj();
        $out = "<< /Type /FontDescriptor";
        $out .= " /FontName /" . $fontname;
        foreach ($font["desc"] as $key => $value) {
            if(is_float($value)) {
                $value = sprintf("%F", $value);
            }
            $out .= " /" . $key . " " . $value;
        }
        $fontdir = false;
        if(!TCPDF_STATIC::empty_string($font["file"])) {
            $out .= " /FontFile2 " . $this->FontFiles[$font["file"]]["n"] . " 0 R";
            $fontdir = $this->FontFiles[$font["file"]]["fontdir"];
        }
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
        if(isset($font["ctg"]) && !TCPDF_STATIC::empty_string($font["ctg"])) {
            $this->_newobj();
            $ctgfile = strtolower($font["ctg"]);
            $fontfile = TCPDF_FONTS::getFontFullPath($ctgfile, $fontdir);
            if(TCPDF_STATIC::empty_string($fontfile)) {
                $this->Error("Font file not found: " . $ctgfile);
            }
            $stream = $this->_getrawstream(file_get_contents($fontfile));
            $out = "<< /Length " . strlen($stream) . "";
            if(substr($fontfile, -2) == ".z") {
                $out .= " /Filter /FlateDecode";
            }
            $out .= " >>";
            $out .= " stream\n" . $stream . "\n" . "endstream";
            $out .= "\nendobj";
            $this->_out($out);
        }
    }
    protected function _putcidfont0($font)
    {
        $cidoffset = 0;
        if(!isset($font["cw"][1])) {
            $cidoffset = 31;
        }
        if(isset($font["cidinfo"]["uni2cid"])) {
            $uni2cid = $font["cidinfo"]["uni2cid"];
            $cw = [];
            foreach ($font["cw"] as $uni => $width) {
                if(isset($uni2cid[$uni])) {
                    $cw[$uni2cid[$uni] + $cidoffset] = $width;
                } elseif($uni < 256) {
                    $cw[$uni] = $width;
                }
            }
            $font = array_merge($font, ["cw" => $cw]);
        }
        $name = $font["name"];
        $enc = $font["enc"];
        if($enc) {
            $longname = $name . "-" . $enc;
        } else {
            $longname = $name;
        }
        $out = $this->_getobj($this->font_obj_ids[$font["fontkey"]]) . "\n";
        $out .= "<</Type /Font";
        $out .= " /Subtype /Type0";
        $out .= " /BaseFont /" . $longname;
        $out .= " /Name /F" . $font["i"];
        if($enc) {
            $out .= " /Encoding /" . $enc;
        }
        $out .= " /DescendantFonts [" . ($this->n + 1) . " 0 R]";
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
        $oid = $this->_newobj();
        $out = "<</Type /Font";
        $out .= " /Subtype /CIDFontType0";
        $out .= " /BaseFont /" . $name;
        $cidinfo = "/Registry " . $this->_datastring($font["cidinfo"]["Registry"], $oid);
        $cidinfo .= " /Ordering " . $this->_datastring($font["cidinfo"]["Ordering"], $oid);
        $cidinfo .= " /Supplement " . $font["cidinfo"]["Supplement"];
        $out .= " /CIDSystemInfo <<" . $cidinfo . ">>";
        $out .= " /FontDescriptor " . ($this->n + 1) . " 0 R";
        $out .= " /DW " . $font["dw"];
        $out .= "\n" . TCPDF_FONTS::_putfontwidths($font, $cidoffset);
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
        $this->_newobj();
        $s = "<</Type /FontDescriptor /FontName /" . $name;
        foreach ($font["desc"] as $k => $v) {
            if($k != "Style") {
                if(is_float($v)) {
                    $v = sprintf("%F", $v);
                }
                $s .= " /" . $k . " " . $v . "";
            }
        }
        $s .= ">>";
        $s .= "\nendobj";
        $this->_out($s);
    }
    protected function _putimages()
    {
        $filter = $this->compress ? "/Filter /FlateDecode " : "";
        foreach ($this->imagekeys as $file) {
            $info = $this->getImageBuffer($file);
            if(!$this->pdfa_mode && isset($info["altimgs"]) && !empty($info["altimgs"])) {
                $altoid = $this->_newobj();
                $out = "[";
                foreach ($info["altimgs"] as $altimage) {
                    if(isset($this->xobjects["I" . $altimage[0]]["n"])) {
                        $out .= " << /Image " . $this->xobjects["I" . $altimage[0]]["n"] . " 0 R";
                        $out .= " /DefaultForPrinting";
                        if($altimage[1] === true) {
                            $out .= " true";
                        } else {
                            $out .= " false";
                        }
                        $out .= " >>";
                    }
                }
                $out .= " ]";
                $out .= "\nendobj";
                $this->_out($out);
            }
            $oid = $this->_newobj();
            $this->xobjects["I" . $info["i"]] = ["n" => $oid];
            $this->setImageSubBuffer($file, "n", $this->n);
            $out = "<</Type /XObject";
            $out .= " /Subtype /Image";
            $out .= " /Width " . $info["w"];
            $out .= " /Height " . $info["h"];
            if(array_key_exists("masked", $info)) {
                $out .= " /SMask " . ($this->n - 1) . " 0 R";
            }
            $icc = false;
            if(isset($info["icc"]) && $info["icc"] !== false) {
                $icc = true;
                $out .= " /ColorSpace [/ICCBased " . ($this->n + 1) . " 0 R]";
            } elseif($info["cs"] == "Indexed") {
                $out .= " /ColorSpace [/Indexed /DeviceRGB " . (strlen($info["pal"]) / 3 - 1) . " " . ($this->n + 1) . " 0 R]";
            } else {
                $out .= " /ColorSpace /" . $info["cs"];
            }
            if($info["cs"] == "DeviceCMYK") {
                $out .= " /Decode [1 0 1 0 1 0 1 0]";
            }
            $out .= " /BitsPerComponent " . $info["bpc"];
            if(isset($altoid) && 0 < $altoid) {
                $out .= " /Alternates " . $altoid . " 0 R";
            }
            if(isset($info["exurl"]) && !empty($info["exurl"])) {
                $out .= " /Length 0";
                $out .= " /F << /FS /URL /F " . $this->_datastring($info["exurl"], $oid) . " >>";
                if(isset($info["f"])) {
                    $out .= " /FFilter /" . $info["f"];
                }
                $out .= " >>";
                $out .= " stream\nendstream";
            } else {
                if(isset($info["f"])) {
                    $out .= " /Filter /" . $info["f"];
                }
                if(isset($info["parms"])) {
                    $out .= " " . $info["parms"];
                }
                if(isset($info["trns"]) && is_array($info["trns"])) {
                    $trns = "";
                    $count_info = count($info["trns"]);
                    if($info["cs"] == "Indexed") {
                        $maxval = pow(2, $info["bpc"]) - 1;
                        for ($i = 0; $i < $count_info; $i++) {
                            if($info["trns"][$i] != 0 && $info["trns"][$i] != $maxval) {
                                $trns = "";
                                break;
                            }
                            if(empty($trns) && $info["trns"][$i] == 0) {
                                $trns .= $i . " " . $i . " ";
                            }
                        }
                    } else {
                        for ($i = 0; $i < $count_info; $i++) {
                            if($info["trns"][$i] == 0) {
                                $trns .= $info["trns"][$i] . " " . $info["trns"][$i] . " ";
                            }
                        }
                    }
                    if(!empty($trns)) {
                        $out .= " /Mask [" . $trns . "]";
                    }
                }
                $stream = $this->_getrawstream($info["data"]);
                $out .= " /Length " . strlen($stream) . " >>";
                $out .= " stream\n" . $stream . "\n" . "endstream";
            }
            $out .= "\nendobj";
            $this->_out($out);
            if($icc) {
                $this->_newobj();
                $icc = $this->compress ? gzcompress($info["icc"]) : $info["icc"];
                $icc = $this->_getrawstream($icc);
                $this->_out("<</N " . $info["ch"] . " /Alternate /" . $info["cs"] . " " . $filter . "/Length " . strlen($icc) . ">> stream" . "\n" . $icc . "\n" . "endstream" . "\n" . "endobj");
            } elseif($info["cs"] == "Indexed") {
                $this->_newobj();
                $pal = $this->compress ? gzcompress($info["pal"]) : $info["pal"];
                $pal = $this->_getrawstream($pal);
                $this->_out("<<" . $filter . "/Length " . strlen($pal) . ">> stream" . "\n" . $pal . "\n" . "endstream" . "\n" . "endobj");
            }
        }
    }
    protected function _putxobjects()
    {
        foreach ($this->xobjects as $key => $data) {
            if(isset($data["outdata"])) {
                $stream = str_replace($this->epsmarker, "", trim($data["outdata"]));
                $out = $this->_getobj($data["n"]) . "\n";
                $out .= "<<";
                $out .= " /Type /XObject";
                $out .= " /Subtype /Form";
                $out .= " /FormType 1";
                if($this->compress) {
                    $stream = gzcompress($stream);
                    $out .= " /Filter /FlateDecode";
                }
                $out .= sprintf(" /BBox [%F %F %F %F]", $data["x"] * $this->k, -1 * $data["y"] * $this->k, ($data["w"] + $data["x"]) * $this->k, ($data["h"] - $data["y"]) * $this->k);
                $out .= " /Matrix [1 0 0 1 0 0]";
                $out .= " /Resources <<";
                $out .= " /ProcSet [/PDF /Text /ImageB /ImageC /ImageI]";
                if(!$this->pdfa_mode || 2 <= $this->pdfa_version) {
                    if(isset($data["extgstates"]) && !empty($data["extgstates"])) {
                        $out .= " /ExtGState <<";
                        foreach ($data["extgstates"] as $k => $extgstate) {
                            if(isset($this->extgstates[$k]["name"])) {
                                $out .= " /" . $this->extgstates[$k]["name"];
                            } else {
                                $out .= " /GS" . $k;
                            }
                            $out .= " " . $this->extgstates[$k]["n"] . " 0 R";
                        }
                        $out .= " >>";
                    }
                    if(isset($data["gradients"]) && !empty($data["gradients"])) {
                        $gp = "";
                        $gs = "";
                        foreach ($data["gradients"] as $id => $grad) {
                            $gp .= " /p" . $id . " " . $this->gradients[$id]["pattern"] . " 0 R";
                            $gs .= " /Sh" . $id . " " . $this->gradients[$id]["id"] . " 0 R";
                        }
                        $out .= " /Pattern <<" . $gp . " >>";
                        $out .= " /Shading <<" . $gs . " >>";
                    }
                }
                if(isset($data["spot_colors"]) && !empty($data["spot_colors"])) {
                    $out .= " /ColorSpace <<";
                    foreach ($data["spot_colors"] as $name => $color) {
                        $out .= " /CS" . $color["i"] . " " . $this->spot_colors[$name]["n"] . " 0 R";
                    }
                    $out .= " >>";
                }
                if(!empty($data["fonts"])) {
                    $out .= " /Font <<";
                    foreach ($data["fonts"] as $fontkey => $fontid) {
                        $out .= " /F" . $fontid . " " . $this->font_obj_ids[$fontkey] . " 0 R";
                    }
                    $out .= " >>";
                }
                if(!empty($data["images"]) || !empty($data["xobjects"])) {
                    $out .= " /XObject <<";
                    foreach ($data["images"] as $imgid) {
                        $out .= " /I" . $imgid . " " . $this->xobjects["I" . $imgid]["n"] . " 0 R";
                    }
                    foreach ($data["xobjects"] as $sub_id => $sub_objid) {
                        $out .= " /" . $sub_id . " " . $sub_objid["n"] . " 0 R";
                    }
                    $out .= " >>";
                }
                $out .= " >>";
                if(isset($data["group"]) && $data["group"] !== false) {
                    $out .= " /Group << /Type /Group /S /Transparency";
                    if(is_array($data["group"])) {
                        if(isset($data["group"]["CS"]) && !empty($data["group"]["CS"])) {
                            $out .= " /CS /" . $data["group"]["CS"];
                        }
                        if(isset($data["group"]["I"])) {
                            $out .= " /I /" . ($data["group"]["I"] === true ? "true" : "false");
                        }
                        if(isset($data["group"]["K"])) {
                            $out .= " /K /" . ($data["group"]["K"] === true ? "true" : "false");
                        }
                    }
                    $out .= " >>";
                }
                $stream = $this->_getrawstream($stream, $data["n"]);
                $out .= " /Length " . strlen($stream);
                $out .= " >>";
                $out .= " stream\n" . $stream . "\n" . "endstream";
                $out .= "\nendobj";
                $this->_out($out);
            }
        }
    }
    protected function _putspotcolors()
    {
        foreach ($this->spot_colors as $name => $color) {
            $this->_newobj();
            $this->spot_colors[$name]["n"] = $this->n;
            $out = "[/Separation /" . str_replace(" ", "#20", $name);
            $out .= " /DeviceCMYK <<";
            $out .= " /Range [0 1 0 1 0 1 0 1] /C0 [0 0 0 0]";
            $out .= " " . sprintf("/C1 [%F %F %F %F] ", $color["C"] / 100, $color["M"] / 100, $color["Y"] / 100, $color["K"] / 100);
            $out .= " /FunctionType 2 /Domain [0 1] /N 1>>]";
            $out .= "\nendobj";
            $this->_out($out);
        }
    }
    protected function _getxobjectdict()
    {
        $out = "";
        foreach ($this->xobjects as $id => $objid) {
            $out .= " /" . $id . " " . $objid["n"] . " 0 R";
        }
        return $out;
    }
    protected function _putresourcedict()
    {
        $out = $this->_getobj(2) . "\n";
        $out .= "<< /ProcSet [/PDF /Text /ImageB /ImageC /ImageI]";
        $out .= " /Font <<";
        foreach ($this->fontkeys as $fontkey) {
            $font = $this->getFontBuffer($fontkey);
            $out .= " /F" . $font["i"] . " " . $font["n"] . " 0 R";
        }
        $out .= " >>";
        $out .= " /XObject <<";
        $out .= $this->_getxobjectdict();
        $out .= " >>";
        if(!empty($this->pdflayers)) {
            $out .= " /Properties <<";
            foreach ($this->pdflayers as $layer) {
                $out .= " /" . $layer["layer"] . " " . $layer["objid"] . " 0 R";
            }
            $out .= " >>";
        }
        if(!$this->pdfa_mode || 2 <= $this->pdfa_version) {
            if(isset($this->extgstates) && !empty($this->extgstates)) {
                $out .= " /ExtGState <<";
                foreach ($this->extgstates as $k => $extgstate) {
                    if(isset($extgstate["name"])) {
                        $out .= " /" . $extgstate["name"];
                    } else {
                        $out .= " /GS" . $k;
                    }
                    $out .= " " . $extgstate["n"] . " 0 R";
                }
                $out .= " >>";
            }
            if(isset($this->gradients) && !empty($this->gradients)) {
                $gp = "";
                $gs = "";
                foreach ($this->gradients as $id => $grad) {
                    $gp .= " /p" . $id . " " . $grad["pattern"] . " 0 R";
                    $gs .= " /Sh" . $id . " " . $grad["id"] . " 0 R";
                }
                $out .= " /Pattern <<" . $gp . " >>";
                $out .= " /Shading <<" . $gs . " >>";
            }
        }
        if(isset($this->spot_colors) && !empty($this->spot_colors)) {
            $out .= " /ColorSpace <<";
            foreach ($this->spot_colors as $color) {
                $out .= " /CS" . $color["i"] . " " . $color["n"] . " 0 R";
            }
            $out .= " >>";
        }
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
    }
    protected function _putresources()
    {
        $this->_putextgstates();
        $this->_putocg();
        $this->_putfonts();
        $this->_putimages();
        $this->_putspotcolors();
        $this->_putshaders();
        $this->_putxobjects();
        $this->_putresourcedict();
        $this->_putdests();
        $this->_putEmbeddedFiles();
        $this->_putannotsobjs();
        $this->_putjavascript();
        $this->_putbookmarks();
        $this->_putencryption();
    }
    protected function _putinfo()
    {
        $oid = $this->_newobj();
        $out = "<<";
        $prev_isunicode = $this->isunicode;
        if($this->docinfounicode) {
            $this->isunicode = true;
        }
        if(!TCPDF_STATIC::empty_string($this->title)) {
            $out .= " /Title " . $this->_textstring($this->title, $oid);
        }
        if(!TCPDF_STATIC::empty_string($this->author)) {
            $out .= " /Author " . $this->_textstring($this->author, $oid);
        }
        if(!TCPDF_STATIC::empty_string($this->subject)) {
            $out .= " /Subject " . $this->_textstring($this->subject, $oid);
        }
        if(!TCPDF_STATIC::empty_string($this->keywords)) {
            $out .= " /Keywords " . $this->_textstring($this->keywords, $oid);
        }
        if(!TCPDF_STATIC::empty_string($this->creator)) {
            $out .= " /Creator " . $this->_textstring($this->creator, $oid);
        }
        $this->isunicode = $prev_isunicode;
        $out .= " /Producer " . $this->_textstring(TCPDF_STATIC::getTCPDFProducer(), $oid);
        $out .= " /CreationDate " . $this->_datestring(0, $this->doc_creation_timestamp);
        $out .= " /ModDate " . $this->_datestring(0, $this->doc_modification_timestamp);
        $out .= " /Trapped /False";
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
        return $oid;
    }
    public function setExtraXMP($xmp)
    {
        $this->custom_xmp = $xmp;
    }
    public function setExtraXMPRDF($xmp)
    {
        $this->custom_xmp_rdf = $xmp;
    }
    protected function _putXMP()
    {
        $oid = $this->_newobj();
        $prev_isunicode = $this->isunicode;
        $this->isunicode = true;
        $prev_encrypted = $this->encrypted;
        $this->encrypted = false;
        $xmp = "<?xpacket begin=\"" . TCPDF_FONTS::unichr(65279, $this->isunicode) . "\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>" . "\n";
        $xmp .= "<x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"Adobe XMP Core 4.2.1-c043 52.372728, 2009/01/18-15:08:04\">\n";
        $xmp .= "\t<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n";
        $xmp .= "\t\t<rdf:Description rdf:about=\"\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n";
        $xmp .= "\t\t\t<dc:format>application/pdf</dc:format>\n";
        $xmp .= "\t\t\t<dc:title>\n";
        $xmp .= "\t\t\t\t<rdf:Alt>\n";
        $xmp .= "\t\t\t\t\t<rdf:li xml:lang=\"x-default\">" . TCPDF_STATIC::_escapeXML($this->title) . "</rdf:li>" . "\n";
        $xmp .= "\t\t\t\t</rdf:Alt>\n";
        $xmp .= "\t\t\t</dc:title>\n";
        $xmp .= "\t\t\t<dc:creator>\n";
        $xmp .= "\t\t\t\t<rdf:Seq>\n";
        $xmp .= "\t\t\t\t\t<rdf:li>" . TCPDF_STATIC::_escapeXML($this->author) . "</rdf:li>" . "\n";
        $xmp .= "\t\t\t\t</rdf:Seq>\n";
        $xmp .= "\t\t\t</dc:creator>\n";
        $xmp .= "\t\t\t<dc:description>\n";
        $xmp .= "\t\t\t\t<rdf:Alt>\n";
        $xmp .= "\t\t\t\t\t<rdf:li xml:lang=\"x-default\">" . TCPDF_STATIC::_escapeXML($this->subject) . "</rdf:li>" . "\n";
        $xmp .= "\t\t\t\t</rdf:Alt>\n";
        $xmp .= "\t\t\t</dc:description>\n";
        $xmp .= "\t\t\t<dc:subject>\n";
        $xmp .= "\t\t\t\t<rdf:Bag>\n";
        $xmp .= "\t\t\t\t\t<rdf:li>" . TCPDF_STATIC::_escapeXML($this->keywords) . "</rdf:li>" . "\n";
        $xmp .= "\t\t\t\t</rdf:Bag>\n";
        $xmp .= "\t\t\t</dc:subject>\n";
        $xmp .= "\t\t</rdf:Description>\n";
        $dcdate = TCPDF_STATIC::getFormattedDate($this->doc_creation_timestamp);
        $doccreationdate = substr($dcdate, 0, 4) . "-" . substr($dcdate, 4, 2) . "-" . substr($dcdate, 6, 2);
        $doccreationdate .= "T" . substr($dcdate, 8, 2) . ":" . substr($dcdate, 10, 2) . ":" . substr($dcdate, 12, 2);
        $doccreationdate .= substr($dcdate, 14, 3) . ":" . substr($dcdate, 18, 2);
        $doccreationdate = TCPDF_STATIC::_escapeXML($doccreationdate);
        $dmdate = TCPDF_STATIC::getFormattedDate($this->doc_modification_timestamp);
        $docmoddate = substr($dmdate, 0, 4) . "-" . substr($dmdate, 4, 2) . "-" . substr($dmdate, 6, 2);
        $docmoddate .= "T" . substr($dmdate, 8, 2) . ":" . substr($dmdate, 10, 2) . ":" . substr($dmdate, 12, 2);
        $docmoddate .= substr($dmdate, 14, 3) . ":" . substr($dmdate, 18, 2);
        $docmoddate = TCPDF_STATIC::_escapeXML($docmoddate);
        $xmp .= "\t\t<rdf:Description rdf:about=\"\" xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n";
        $xmp .= "\t\t\t<xmp:CreateDate>" . $doccreationdate . "</xmp:CreateDate>" . "\n";
        $xmp .= "\t\t\t<xmp:CreatorTool>" . $this->creator . "</xmp:CreatorTool>" . "\n";
        $xmp .= "\t\t\t<xmp:ModifyDate>" . $docmoddate . "</xmp:ModifyDate>" . "\n";
        $xmp .= "\t\t\t<xmp:MetadataDate>" . $doccreationdate . "</xmp:MetadataDate>" . "\n";
        $xmp .= "\t\t</rdf:Description>\n";
        $xmp .= "\t\t<rdf:Description rdf:about=\"\" xmlns:pdf=\"http://ns.adobe.com/pdf/1.3/\">\n";
        $xmp .= "\t\t\t<pdf:Keywords>" . TCPDF_STATIC::_escapeXML($this->keywords) . "</pdf:Keywords>" . "\n";
        $xmp .= "\t\t\t<pdf:Producer>" . TCPDF_STATIC::_escapeXML(TCPDF_STATIC::getTCPDFProducer()) . "</pdf:Producer>" . "\n";
        $xmp .= "\t\t</rdf:Description>\n";
        $xmp .= "\t\t<rdf:Description rdf:about=\"\" xmlns:xmpMM=\"http://ns.adobe.com/xap/1.0/mm/\">\n";
        $uuid = "uuid:" . substr($this->file_id, 0, 8) . "-" . substr($this->file_id, 8, 4) . "-" . substr($this->file_id, 12, 4) . "-" . substr($this->file_id, 16, 4) . "-" . substr($this->file_id, 20, 12);
        $xmp .= "\t\t\t<xmpMM:DocumentID>" . $uuid . "</xmpMM:DocumentID>" . "\n";
        $xmp .= "\t\t\t<xmpMM:InstanceID>" . $uuid . "</xmpMM:InstanceID>" . "\n";
        $xmp .= "\t\t</rdf:Description>\n";
        if($this->pdfa_mode) {
            $xmp .= "\t\t<rdf:Description rdf:about=\"\" xmlns:pdfaid=\"http://www.aiim.org/pdfa/ns/id/\">\n";
            $xmp .= "\t\t\t<pdfaid:part>" . $this->pdfa_version . "</pdfaid:part>" . "\n";
            $xmp .= "\t\t\t<pdfaid:conformance>B</pdfaid:conformance>\n";
            $xmp .= "\t\t</rdf:Description>\n";
        }
        $xmp .= "\t\t<rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n";
        $xmp .= "\t\t\t<pdfaExtension:schemas>\n";
        $xmp .= "\t\t\t\t<rdf:Bag>\n";
        $xmp .= "\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:namespaceURI>http://ns.adobe.com/pdf/1.3/</pdfaSchema:namespaceURI>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:prefix>pdf</pdfaSchema:prefix>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:schema>Adobe PDF Schema</pdfaSchema:schema>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:property>\n";
        $xmp .= "\t\t\t\t\t\t\t<rdf:Seq>\n";
        $xmp .= "\t\t\t\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:category>internal</pdfaProperty:category>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:description>Adobe PDF Schema</pdfaProperty:description>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:name>InstanceID</pdfaProperty:name>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:valueType>URI</pdfaProperty:valueType>\n";
        $xmp .= "\t\t\t\t\t\t\t\t</rdf:li>\n";
        $xmp .= "\t\t\t\t\t\t\t</rdf:Seq>\n";
        $xmp .= "\t\t\t\t\t\t</pdfaSchema:property>\n";
        $xmp .= "\t\t\t\t\t</rdf:li>\n";
        $xmp .= "\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:namespaceURI>http://ns.adobe.com/xap/1.0/mm/</pdfaSchema:namespaceURI>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:prefix>xmpMM</pdfaSchema:prefix>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:schema>XMP Media Management Schema</pdfaSchema:schema>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:property>\n";
        $xmp .= "\t\t\t\t\t\t\t<rdf:Seq>\n";
        $xmp .= "\t\t\t\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:category>internal</pdfaProperty:category>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:description>UUID based identifier for specific incarnation of a document</pdfaProperty:description>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:name>InstanceID</pdfaProperty:name>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:valueType>URI</pdfaProperty:valueType>\n";
        $xmp .= "\t\t\t\t\t\t\t\t</rdf:li>\n";
        $xmp .= "\t\t\t\t\t\t\t</rdf:Seq>\n";
        $xmp .= "\t\t\t\t\t\t</pdfaSchema:property>\n";
        $xmp .= "\t\t\t\t\t</rdf:li>\n";
        $xmp .= "\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:namespaceURI>http://www.aiim.org/pdfa/ns/id/</pdfaSchema:namespaceURI>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:prefix>pdfaid</pdfaSchema:prefix>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:schema>PDF/A ID Schema</pdfaSchema:schema>\n";
        $xmp .= "\t\t\t\t\t\t<pdfaSchema:property>\n";
        $xmp .= "\t\t\t\t\t\t\t<rdf:Seq>\n";
        $xmp .= "\t\t\t\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:category>internal</pdfaProperty:category>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:description>Part of PDF/A standard</pdfaProperty:description>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:name>part</pdfaProperty:name>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:valueType>Integer</pdfaProperty:valueType>\n";
        $xmp .= "\t\t\t\t\t\t\t\t</rdf:li>\n";
        $xmp .= "\t\t\t\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:category>internal</pdfaProperty:category>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:description>Amendment of PDF/A standard</pdfaProperty:description>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:name>amd</pdfaProperty:name>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:valueType>Text</pdfaProperty:valueType>\n";
        $xmp .= "\t\t\t\t\t\t\t\t</rdf:li>\n";
        $xmp .= "\t\t\t\t\t\t\t\t<rdf:li rdf:parseType=\"Resource\">\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:category>internal</pdfaProperty:category>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:description>Conformance level of PDF/A standard</pdfaProperty:description>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:name>conformance</pdfaProperty:name>\n";
        $xmp .= "\t\t\t\t\t\t\t\t\t<pdfaProperty:valueType>Text</pdfaProperty:valueType>\n";
        $xmp .= "\t\t\t\t\t\t\t\t</rdf:li>\n";
        $xmp .= "\t\t\t\t\t\t\t</rdf:Seq>\n";
        $xmp .= "\t\t\t\t\t\t</pdfaSchema:property>\n";
        $xmp .= "\t\t\t\t\t</rdf:li>\n";
        $xmp .= "\t\t\t\t</rdf:Bag>\n";
        $xmp .= "\t\t\t</pdfaExtension:schemas>\n";
        $xmp .= "\t\t</rdf:Description>\n";
        $xmp .= $this->custom_xmp_rdf;
        $xmp .= "\t</rdf:RDF>\n";
        $xmp .= $this->custom_xmp;
        $xmp .= "</x:xmpmeta>\n";
        $xmp .= "<?xpacket end=\"w\"?>";
        $out = "<< /Type /Metadata /Subtype /XML /Length " . strlen($xmp) . " >> stream" . "\n" . $xmp . "\n" . "endstream" . "\n" . "endobj";
        $this->isunicode = $prev_isunicode;
        $this->encrypted = $prev_encrypted;
        $this->_out($out);
        return $oid;
    }
    protected function _putcatalog()
    {
        $xmpobj = $this->_putXMP();
        if($this->pdfa_mode || $this->force_srgb) {
            $iccobj = $this->_newobj();
            $icc = file_get_contents(dirname(__FILE__) . "/include/sRGB.icc");
            $filter = "";
            if($this->compress) {
                $filter = " /Filter /FlateDecode";
                $icc = gzcompress($icc);
            }
            $icc = $this->_getrawstream($icc);
            $this->_out("<</N 3 " . $filter . "/Length " . strlen($icc) . ">> stream" . "\n" . $icc . "\n" . "endstream" . "\n" . "endobj");
        }
        $oid = $this->_newobj();
        $out = "<< /Type /Catalog";
        $out .= " /Version /" . $this->PDFVersion;
        $out .= " /Pages 1 0 R";
        $out .= " /Names <<";
        if(!$this->pdfa_mode && !empty($this->n_js)) {
            $out .= " /JavaScript " . $this->n_js;
        }
        if(!empty($this->efnames)) {
            $out .= " /EmbeddedFiles <</Names [";
            foreach ($this->efnames as $fn => $fref) {
                $out .= " " . $this->_datastring($fn) . " " . $fref;
            }
            $out .= " ]>>";
        }
        $out .= " >>";
        if(!empty($this->dests)) {
            $out .= " /Dests " . $this->n_dests . " 0 R";
        }
        $out .= $this->_putviewerpreferences();
        if(isset($this->LayoutMode) && !TCPDF_STATIC::empty_string($this->LayoutMode)) {
            $out .= " /PageLayout /" . $this->LayoutMode;
        }
        if(isset($this->PageMode) && !TCPDF_STATIC::empty_string($this->PageMode)) {
            $out .= " /PageMode /" . $this->PageMode;
        }
        if(0 < count($this->outlines)) {
            $out .= " /Outlines " . $this->OutlineRoot . " 0 R";
            $out .= " /PageMode /UseOutlines";
        }
        if($this->ZoomMode == "fullpage") {
            $out .= " /OpenAction [" . $this->page_obj_id[1] . " 0 R /Fit]";
        } elseif($this->ZoomMode == "fullwidth") {
            $out .= " /OpenAction [" . $this->page_obj_id[1] . " 0 R /FitH null]";
        } elseif($this->ZoomMode == "real") {
            $out .= " /OpenAction [" . $this->page_obj_id[1] . " 0 R /XYZ null null 1]";
        } elseif(!is_string($this->ZoomMode)) {
            $out .= sprintf(" /OpenAction [" . $this->page_obj_id[1] . " 0 R /XYZ null null %F]", $this->ZoomMode / 100);
        }
        $out .= " /Metadata " . $xmpobj . " 0 R";
        if(isset($this->l["a_meta_language"])) {
            $out .= " /Lang " . $this->_textstring($this->l["a_meta_language"], $oid);
        }
        if($this->pdfa_mode || $this->force_srgb) {
            $out .= " /OutputIntents [<<";
            $out .= " /Type /OutputIntent";
            $out .= " /S /GTS_PDFA1";
            $out .= " /OutputCondition " . $this->_textstring("sRGB IEC61966-2.1", $oid);
            $out .= " /OutputConditionIdentifier " . $this->_textstring("sRGB IEC61966-2.1", $oid);
            $out .= " /RegistryName " . $this->_textstring("http://www.color.org", $oid);
            $out .= " /Info " . $this->_textstring("sRGB IEC61966-2.1", $oid);
            $out .= " /DestOutputProfile " . $iccobj . " 0 R";
            $out .= " >>]";
        }
        if(!empty($this->pdflayers)) {
            $lyrobjs = "";
            $lyrobjs_off = "";
            $lyrobjs_lock = "";
            foreach ($this->pdflayers as $layer) {
                $layer_obj_ref = " " . $layer["objid"] . " 0 R";
                $lyrobjs .= $layer_obj_ref;
                if($layer["view"] === false) {
                    $lyrobjs_off .= $layer_obj_ref;
                }
                if($layer["lock"]) {
                    $lyrobjs_lock .= $layer_obj_ref;
                }
            }
            $out .= " /OCProperties << /OCGs [" . $lyrobjs . "]";
            $out .= " /D <<";
            $out .= " /Name " . $this->_textstring("Layers", $oid);
            $out .= " /Creator " . $this->_textstring("TCPDF", $oid);
            $out .= " /BaseState /ON";
            $out .= " /OFF [" . $lyrobjs_off . "]";
            $out .= " /Locked [" . $lyrobjs_lock . "]";
            $out .= " /Intent /View";
            $out .= " /AS [";
            $out .= " << /Event /Print /OCGs [" . $lyrobjs . "] /Category [/Print] >>";
            $out .= " << /Event /View /OCGs [" . $lyrobjs . "] /Category [/View] >>";
            $out .= " ]";
            $out .= " /Order [" . $lyrobjs . "]";
            $out .= " /ListMode /AllPages";
            $out .= " >>";
            $out .= " >>";
        }
        if(!empty($this->form_obj_id) || $this->sign && isset($this->signature_data["cert_type"]) || !empty($this->empty_signature_appearance)) {
            $out .= " /AcroForm <<";
            $objrefs = "";
            if($this->sign && isset($this->signature_data["cert_type"])) {
                $objrefs .= $this->sig_obj_id . " 0 R";
            }
            if(!empty($this->empty_signature_appearance)) {
                foreach ($this->empty_signature_appearance as $esa) {
                    $objrefs .= " " . $esa["objid"] . " 0 R";
                }
            }
            if(!empty($this->form_obj_id)) {
                foreach ($this->form_obj_id as $objid) {
                    $objrefs .= " " . $objid . " 0 R";
                }
            }
            $out .= " /Fields [" . $objrefs . "]";
            if(empty($this->signature_data["approval"]) || $this->signature_data["approval"] != "A") {
                $out .= " /NeedAppearances false";
            }
            if($this->sign && isset($this->signature_data["cert_type"])) {
                if(0 < $this->signature_data["cert_type"]) {
                    $out .= " /SigFlags 3";
                } else {
                    $out .= " /SigFlags 1";
                }
            }
            if(isset($this->annotation_fonts) && !empty($this->annotation_fonts)) {
                $out .= " /DR <<";
                $out .= " /Font <<";
                foreach ($this->annotation_fonts as $fontkey => $fontid) {
                    $out .= " /F" . $fontid . " " . $this->font_obj_ids[$fontkey] . " 0 R";
                }
                $out .= " >> >>";
            }
            $font = $this->getFontBuffer("helvetica");
            $out .= " /DA (/F" . $font["i"] . " 0 Tf 0 g)";
            $out .= " /Q " . ($this->rtl ? "2" : "0");
            $out .= " >>";
            if($this->sign && isset($this->signature_data["cert_type"]) && (empty($this->signature_data["approval"]) || $this->signature_data["approval"] != "A")) {
                if(0 < $this->signature_data["cert_type"]) {
                    $out .= " /Perms << /DocMDP " . ($this->sig_obj_id + 1) . " 0 R >>";
                } else {
                    $out .= " /Perms << /UR3 " . ($this->sig_obj_id + 1) . " 0 R >>";
                }
            }
        }
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
        return $oid;
    }
    protected function _putviewerpreferences()
    {
        $vp = $this->viewer_preferences;
        $out = " /ViewerPreferences <<";
        if($this->rtl) {
            $out .= " /Direction /R2L";
        } else {
            $out .= " /Direction /L2R";
        }
        if(isset($vp["HideToolbar"]) && $vp["HideToolbar"]) {
            $out .= " /HideToolbar true";
        }
        if(isset($vp["HideMenubar"]) && $vp["HideMenubar"]) {
            $out .= " /HideMenubar true";
        }
        if(isset($vp["HideWindowUI"]) && $vp["HideWindowUI"]) {
            $out .= " /HideWindowUI true";
        }
        if(isset($vp["FitWindow"]) && $vp["FitWindow"]) {
            $out .= " /FitWindow true";
        }
        if(isset($vp["CenterWindow"]) && $vp["CenterWindow"]) {
            $out .= " /CenterWindow true";
        }
        if(isset($vp["DisplayDocTitle"]) && $vp["DisplayDocTitle"]) {
            $out .= " /DisplayDocTitle true";
        }
        if(isset($vp["NonFullScreenPageMode"])) {
            $out .= " /NonFullScreenPageMode /" . $vp["NonFullScreenPageMode"];
        }
        if(isset($vp["ViewArea"])) {
            $out .= " /ViewArea /" . $vp["ViewArea"];
        }
        if(isset($vp["ViewClip"])) {
            $out .= " /ViewClip /" . $vp["ViewClip"];
        }
        if(isset($vp["PrintArea"])) {
            $out .= " /PrintArea /" . $vp["PrintArea"];
        }
        if(isset($vp["PrintClip"])) {
            $out .= " /PrintClip /" . $vp["PrintClip"];
        }
        if(isset($vp["PrintScaling"])) {
            $out .= " /PrintScaling /" . $vp["PrintScaling"];
        }
        if(isset($vp["Duplex"]) && !TCPDF_STATIC::empty_string($vp["Duplex"])) {
            $out .= " /Duplex /" . $vp["Duplex"];
        }
        if(isset($vp["PickTrayByPDFSize"])) {
            if($vp["PickTrayByPDFSize"]) {
                $out .= " /PickTrayByPDFSize true";
            } else {
                $out .= " /PickTrayByPDFSize false";
            }
        }
        if(isset($vp["PrintPageRange"])) {
            $PrintPageRangeNum = "";
            foreach ($vp["PrintPageRange"] as $k => $v) {
                $PrintPageRangeNum .= " " . ($v - 1) . "";
            }
            $out .= " /PrintPageRange [" . substr($PrintPageRangeNum, 1) . "]";
        }
        if(isset($vp["NumCopies"])) {
            $out .= " /NumCopies " . intval($vp["NumCopies"]);
        }
        $out .= " >>";
        return $out;
    }
    protected function _putheader()
    {
        $this->_out("%PDF-" . $this->PDFVersion);
        $this->_out("%" . chr(226) . chr(227) . chr(207) . chr(211));
    }
    protected function _enddoc()
    {
        if(isset($this->CurrentFont["fontkey"]) && isset($this->CurrentFont["subsetchars"])) {
            $this->setFontSubBuffer($this->CurrentFont["fontkey"], "subsetchars", $this->CurrentFont["subsetchars"]);
        }
        $this->state = 1;
        $this->_putheader();
        $this->_putpages();
        $this->_putresources();
        if(!empty($this->empty_signature_appearance)) {
            foreach ($this->empty_signature_appearance as $key => $esa) {
                $out = $this->_getobj($esa["objid"]) . "\n";
                $out .= "<< /Type /Annot";
                $out .= " /Subtype /Widget";
                $out .= " /Rect [" . $esa["rect"] . "]";
                $out .= " /P " . $this->page_obj_id[$esa["page"]] . " 0 R";
                $out .= " /F 4";
                $out .= " /FT /Sig";
                $signame = $esa["name"] . sprintf(" [%03d]", $key + 1);
                $out .= " /T " . $this->_textstring($signame, $esa["objid"]);
                $out .= " /Ff 0";
                $out .= " >>";
                $out .= "\nendobj";
                $this->_out($out);
            }
        }
        if($this->sign && isset($this->signature_data["cert_type"])) {
            $out = $this->_getobj($this->sig_obj_id) . "\n";
            $out .= "<< /Type /Annot";
            $out .= " /Subtype /Widget";
            $out .= " /Rect [" . $this->signature_appearance["rect"] . "]";
            $out .= " /P " . $this->page_obj_id[$this->signature_appearance["page"]] . " 0 R";
            $out .= " /F 4";
            $out .= " /FT /Sig";
            $out .= " /T " . $this->_textstring($this->signature_appearance["name"], $this->sig_obj_id);
            $out .= " /Ff 0";
            $out .= " /V " . ($this->sig_obj_id + 1) . " 0 R";
            $out .= " >>";
            $out .= "\nendobj";
            $this->_out($out);
            $this->_putsignature();
        }
        $objid_info = $this->_putinfo();
        $objid_catalog = $this->_putcatalog();
        $o = $this->bufferlen;
        $this->_out("xref");
        $this->_out("0 " . ($this->n + 1));
        $this->_out("0000000000 65535 f ");
        $freegen = $this->n + 2;
        for ($i = 1; $i <= $this->n; $i++) {
            if(!isset($this->offsets[$i]) && 1 < $i) {
                $this->_out(sprintf("0000000000 %05d f ", $freegen));
                $freegen++;
            } else {
                $this->_out(sprintf("%010d 00000 n ", $this->offsets[$i]));
            }
        }
        $out = "trailer\n";
        $out .= "<<";
        $out .= " /Size " . ($this->n + 1);
        $out .= " /Root " . $objid_catalog . " 0 R";
        $out .= " /Info " . $objid_info . " 0 R";
        if($this->encrypted) {
            $out .= " /Encrypt " . $this->encryptdata["objid"] . " 0 R";
        }
        $out .= " /ID [ <" . $this->file_id . "> <" . $this->file_id . "> ]";
        $out .= " >>";
        $this->_out($out);
        $this->_out("startxref");
        $this->_out($o);
        $this->_out("%%EOF");
        $this->state = 3;
    }
    protected function _beginpage($orientation = "", $format = "")
    {
        $this->page++;
        $this->pageobjects[$this->page] = [];
        $this->setPageBuffer($this->page, "");
        $this->transfmrk[$this->page] = [];
        $this->state = 2;
        if(TCPDF_STATIC::empty_string($orientation)) {
            if(isset($this->CurOrientation)) {
                $orientation = $this->CurOrientation;
            } elseif($this->fhPt < $this->fwPt) {
                $orientation = "L";
            } else {
                $orientation = "P";
            }
        }
        if(TCPDF_STATIC::empty_string($format)) {
            $this->pagedim[$this->page] = $this->pagedim[$this->page - 1];
            $this->setPageOrientation($orientation);
        } else {
            $this->setPageFormat($format, $orientation);
        }
        if($this->rtl) {
            $this->x = $this->w - $this->rMargin;
        } else {
            $this->x = $this->lMargin;
        }
        $this->y = $this->tMargin;
        if(isset($this->newpagegroup[$this->page])) {
            $this->currpagegroup = $this->newpagegroup[$this->page];
            $this->pagegroups[$this->currpagegroup] = 1;
        } elseif(isset($this->currpagegroup) && 0 < $this->currpagegroup) {
            $this->pagegroups[$this->currpagegroup]++;
        }
    }
    protected function _endpage()
    {
        $this->setVisibility("all");
        $this->state = 1;
    }
    protected function _newobj()
    {
        $this->_out($this->_getobj());
        return $this->n;
    }
    protected function _getobj($objid = NULL)
    {
        if(TCPDF_STATIC::empty_string($objid)) {
            $this->n++;
            $objid = $this->n;
        }
        $this->offsets[$objid] = $this->bufferlen;
        $this->pageobjects[$this->page][] = $objid;
        return $objid . " 0 obj";
    }
    protected function _dounderline($x, $y, $txt)
    {
        $w = $this->GetStringWidth($txt);
        return $this->_dounderlinew($x, $y, $w);
    }
    protected function _dounderlinew($x, $y, $w)
    {
        $linew = -1 * $this->CurrentFont["ut"] / 1000 * $this->FontSizePt;
        return sprintf("%F %F %F %F re f", $x * $this->k, ($this->h - $y) * $this->k + $linew, $w * $this->k, $linew);
    }
    protected function _dolinethrough($x, $y, $txt)
    {
        $w = $this->GetStringWidth($txt);
        return $this->_dolinethroughw($x, $y, $w);
    }
    protected function _dolinethroughw($x, $y, $w)
    {
        $linew = -1 * $this->CurrentFont["ut"] / 1000 * $this->FontSizePt;
        return sprintf("%F %F %F %F re f", $x * $this->k, ($this->h - $y) * $this->k + $linew + $this->FontSizePt / 3, $w * $this->k, $linew);
    }
    protected function _dooverline($x, $y, $txt)
    {
        $w = $this->GetStringWidth($txt);
        return $this->_dooverlinew($x, $y, $w);
    }
    protected function _dooverlinew($x, $y, $w)
    {
        $linew = -1 * $this->CurrentFont["ut"] / 1000 * $this->FontSizePt;
        return sprintf("%F %F %F %F re f", $x * $this->k, ($this->h - $y + $this->FontAscent) * $this->k - $linew, $w * $this->k, $linew);
    }
    protected function _datastring($s, $n = 0)
    {
        if($n == 0) {
            $n = $this->n;
        }
        $s = $this->_encrypt_data($n, $s);
        return "(" . TCPDF_STATIC::_escape($s) . ")";
    }
    public function setDocCreationTimestamp($time)
    {
        if(is_string($time)) {
            $time = TCPDF_STATIC::getTimestamp($time);
        }
        $this->doc_creation_timestamp = intval($time);
    }
    public function setDocModificationTimestamp($time)
    {
        if(is_string($time)) {
            $time = TCPDF_STATIC::getTimestamp($time);
        }
        $this->doc_modification_timestamp = intval($time);
    }
    public function getDocCreationTimestamp()
    {
        return $this->doc_creation_timestamp;
    }
    public function getDocModificationTimestamp()
    {
        return $this->doc_modification_timestamp;
    }
    protected function _datestring($n = 0, $timestamp = 0)
    {
        if(empty($timestamp) || $timestamp < 0) {
            $timestamp = $this->doc_creation_timestamp;
        }
        return $this->_datastring("D:" . TCPDF_STATIC::getFormattedDate($timestamp), $n);
    }
    protected function _textstring($s, $n = 0)
    {
        if($this->isunicode) {
            $s = TCPDF_FONTS::UTF8ToUTF16BE($s, true, $this->isunicode, $this->CurrentFont);
        }
        return $this->_datastring($s, $n);
    }
    protected function _getrawstream($s, $n = 0)
    {
        if($n <= 0) {
            $n = $this->n;
        }
        return $this->_encrypt_data($n, $s);
    }
    protected function _out($s)
    {
        if($this->state == 2) {
            if($this->inxobj) {
                $this->xobjects[$this->xobjid]["outdata"] .= $s . "\n";
            } elseif(!$this->InFooter && isset($this->footerlen[$this->page]) && 0 < $this->footerlen[$this->page]) {
                $pagebuff = $this->getPageBuffer($this->page);
                $page = substr($pagebuff, 0, -1 * $this->footerlen[$this->page]);
                $footer = substr($pagebuff, -1 * $this->footerlen[$this->page]);
                $this->setPageBuffer($this->page, $page . $s . "\n" . $footer);
                $this->footerpos[$this->page] += strlen($s . "\n");
            } else {
                $this->setPageBuffer($this->page, $s . "\n", true);
            }
        } elseif(0 < $this->state) {
            $this->setBuffer($s . "\n");
        }
    }
    public function setHeaderFont($font)
    {
        $this->header_font = $font;
    }
    public function getHeaderFont()
    {
        return $this->header_font;
    }
    public function setFooterFont($font)
    {
        $this->footer_font = $font;
    }
    public function getFooterFont()
    {
        return $this->footer_font;
    }
    public function setLanguageArray($language)
    {
        $this->l = $language;
        if(isset($this->l["a_meta_dir"])) {
            $this->rtl = $this->l["a_meta_dir"] == "rtl" ? true : false;
        } else {
            $this->rtl = false;
        }
    }
    public function getPDFData()
    {
        if($this->state < 3) {
            $this->Close();
        }
        return $this->buffer;
    }
    public function addHtmlLink($url, $name, $fill = false, $firstline = false, $color = NULL, $style = -1, $firstblock = false)
    {
        if(isset($url[1]) && $url[0] == "#" && is_numeric($url[1])) {
            $lnkdata = explode(",", $url);
            if(isset($lnkdata[0])) {
                $page = substr($lnkdata[0], 1);
                if(isset($lnkdata[1]) && 0 < strlen($lnkdata[1])) {
                    $lnky = floatval($lnkdata[1]);
                } else {
                    $lnky = 0;
                }
                $url = $this->AddLink();
                $this->setLink($url, $lnky, $page);
            }
        }
        $prevcolor = $this->fgcolor;
        $prevstyle = $this->FontStyle;
        if(empty($color)) {
            $this->setTextColorArray($this->htmlLinkColorArray);
        } else {
            $this->setTextColorArray($color);
        }
        if($style == -1) {
            $this->setFont("", $this->FontStyle . $this->htmlLinkFontStyle);
        } else {
            $this->setFont("", $this->FontStyle . $style);
        }
        $ret = $this->Write($this->lasth, $name, $url, $fill, "", false, 0, $firstline, $firstblock, 0);
        $this->setFont("", $prevstyle);
        $this->setTextColorArray($prevcolor);
        return $ret;
    }
    public function pixelsToUnits($px)
    {
        return $px / ($this->imgscale * $this->k);
    }
    public function unhtmlentities($text_to_convert)
    {
        return @html_entity_decode($text_to_convert, ENT_QUOTES, $this->encoding);
    }
    protected function _objectkey($n)
    {
        $objkey = $this->encryptdata["key"] . pack("VXxx", $n);
        if($this->encryptdata["mode"] == 2) {
            $objkey .= "sAlT";
        }
        $objkey = substr(TCPDF_STATIC::_md5_16($objkey), 0, $this->encryptdata["Length"] / 8 + 5);
        $objkey = substr($objkey, 0, 16);
        return $objkey;
    }
    protected function _encrypt_data($n, $s)
    {
        if(!$this->encrypted) {
            return $s;
        }
        switch ($this->encryptdata["mode"]) {
            case 0:
            case 1:
                $s = TCPDF_STATIC::_RC4($this->_objectkey($n), $s, $this->last_enc_key, $this->last_enc_key_c);
                break;
            case 2:
                $s = TCPDF_STATIC::_AES($this->_objectkey($n), $s);
                break;
            case 3:
                $s = TCPDF_STATIC::_AES($this->encryptdata["key"], $s);
                break;
            default:
                return $s;
        }
    }
    protected function _putencryption()
    {
        if(!$this->encrypted) {
            return NULL;
        }
        $this->encryptdata["objid"] = $this->_newobj();
        $out = "<<";
        if(!isset($this->encryptdata["Filter"]) || empty($this->encryptdata["Filter"])) {
            $this->encryptdata["Filter"] = "Standard";
        }
        $out .= " /Filter /" . $this->encryptdata["Filter"];
        if(isset($this->encryptdata["SubFilter"]) && !empty($this->encryptdata["SubFilter"])) {
            $out .= " /SubFilter /" . $this->encryptdata["SubFilter"];
        }
        if(!isset($this->encryptdata["V"]) || empty($this->encryptdata["V"])) {
            $this->encryptdata["V"] = 1;
        }
        $out .= " /V " . $this->encryptdata["V"];
        if(isset($this->encryptdata["Length"]) && !empty($this->encryptdata["Length"])) {
            $out .= " /Length " . $this->encryptdata["Length"];
        } else {
            $out .= " /Length 40";
        }
        if(4 <= $this->encryptdata["V"]) {
            if(!isset($this->encryptdata["StmF"]) || empty($this->encryptdata["StmF"])) {
                $this->encryptdata["StmF"] = "Identity";
            }
            if(!isset($this->encryptdata["StrF"]) || empty($this->encryptdata["StrF"])) {
                $this->encryptdata["StrF"] = "Identity";
            }
            if(isset($this->encryptdata["CF"]) && !empty($this->encryptdata["CF"])) {
                $out .= " /CF <<";
                $out .= " /" . $this->encryptdata["StmF"] . " <<";
                $out .= " /Type /CryptFilter";
                if(isset($this->encryptdata["CF"]["CFM"]) && !empty($this->encryptdata["CF"]["CFM"])) {
                    $out .= " /CFM /" . $this->encryptdata["CF"]["CFM"];
                    if($this->encryptdata["pubkey"]) {
                        $out .= " /Recipients [";
                        foreach ($this->encryptdata["Recipients"] as $rec) {
                            $out .= " <" . $rec . ">";
                        }
                        $out .= " ]";
                        if(isset($this->encryptdata["CF"]["EncryptMetadata"]) && !$this->encryptdata["CF"]["EncryptMetadata"]) {
                            $out .= " /EncryptMetadata false";
                        } else {
                            $out .= " /EncryptMetadata true";
                        }
                    }
                } else {
                    $out .= " /CFM /None";
                }
                if(isset($this->encryptdata["CF"]["AuthEvent"]) && !empty($this->encryptdata["CF"]["AuthEvent"])) {
                    $out .= " /AuthEvent /" . $this->encryptdata["CF"]["AuthEvent"];
                } else {
                    $out .= " /AuthEvent /DocOpen";
                }
                if(isset($this->encryptdata["CF"]["Length"]) && !empty($this->encryptdata["CF"]["Length"])) {
                    $out .= " /Length " . $this->encryptdata["CF"]["Length"];
                }
                $out .= " >> >>";
            }
            $out .= " /StmF /" . $this->encryptdata["StmF"];
            $out .= " /StrF /" . $this->encryptdata["StrF"];
            if(isset($this->encryptdata["EFF"]) && !empty($this->encryptdata["EFF"])) {
                $out .= " /EFF /" . $this->encryptdata[""];
            }
        }
        if($this->encryptdata["pubkey"]) {
            if($this->encryptdata["V"] < 4 && isset($this->encryptdata["Recipients"]) && !empty($this->encryptdata["Recipients"])) {
                $out .= " /Recipients [";
                foreach ($this->encryptdata["Recipients"] as $rec) {
                    $out .= " <" . $rec . ">";
                }
                $out .= " ]";
            }
        } else {
            $out .= " /R";
            if($this->encryptdata["V"] == 5) {
                $out .= " 5";
                $out .= " /OE (" . TCPDF_STATIC::_escape($this->encryptdata["OE"]) . ")";
                $out .= " /UE (" . TCPDF_STATIC::_escape($this->encryptdata["UE"]) . ")";
                $out .= " /Perms (" . TCPDF_STATIC::_escape($this->encryptdata["perms"]) . ")";
            } elseif($this->encryptdata["V"] == 4) {
                $out .= " 4";
            } elseif($this->encryptdata["V"] < 2) {
                $out .= " 2";
            } else {
                $out .= " 3";
            }
            $out .= " /O (" . TCPDF_STATIC::_escape($this->encryptdata["O"]) . ")";
            $out .= " /U (" . TCPDF_STATIC::_escape($this->encryptdata["U"]) . ")";
            $out .= " /P " . $this->encryptdata["P"];
            if(isset($this->encryptdata["EncryptMetadata"]) && !$this->encryptdata["EncryptMetadata"]) {
                $out .= " /EncryptMetadata false";
            } else {
                $out .= " /EncryptMetadata true";
            }
        }
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
    }
    protected function _Uvalue()
    {
        if($this->encryptdata["mode"] == 0) {
            return TCPDF_STATIC::_RC4($this->encryptdata["key"], TCPDF_STATIC::$enc_padding, $this->last_enc_key, $this->last_enc_key_c);
        }
        if($this->encryptdata["mode"] < 3) {
            $tmp = TCPDF_STATIC::_md5_16(TCPDF_STATIC::$enc_padding . $this->encryptdata["fileid"]);
            $enc = TCPDF_STATIC::_RC4($this->encryptdata["key"], $tmp, $this->last_enc_key, $this->last_enc_key_c);
            $len = strlen($tmp);
            for ($i = 1; $i <= 19; $i++) {
                $ek = "";
                for ($j = 0; $j < $len; $j++) {
                    $ek .= chr(ord($this->encryptdata["key"][$j]) ^ $i);
                }
                $enc = TCPDF_STATIC::_RC4($ek, $enc, $this->last_enc_key, $this->last_enc_key_c);
            }
            $enc .= str_repeat("\0", 16);
            return substr($enc, 0, 32);
        }
        if($this->encryptdata["mode"] == 3) {
            $seed = TCPDF_STATIC::_md5_16(TCPDF_STATIC::getRandomSeed());
            $this->encryptdata["UVS"] = substr($seed, 0, 8);
            $this->encryptdata["UKS"] = substr($seed, 8, 16);
            return hash("sha256", $this->encryptdata["user_password"] . $this->encryptdata["UVS"], true) . $this->encryptdata["UVS"] . $this->encryptdata["UKS"];
        }
    }
    protected function _UEvalue()
    {
        $hashkey = hash("sha256", $this->encryptdata["user_password"] . $this->encryptdata["UKS"], true);
        return TCPDF_STATIC::_AESnopad($hashkey, $this->encryptdata["key"]);
    }
    protected function _Ovalue()
    {
        if($this->encryptdata["mode"] < 3) {
            $tmp = TCPDF_STATIC::_md5_16($this->encryptdata["owner_password"]);
            if(0 < $this->encryptdata["mode"]) {
                for ($i = 0; $i < 50; $i++) {
                    $tmp = TCPDF_STATIC::_md5_16($tmp);
                }
            }
            $owner_key = substr($tmp, 0, $this->encryptdata["Length"] / 8);
            $enc = TCPDF_STATIC::_RC4($owner_key, $this->encryptdata["user_password"], $this->last_enc_key, $this->last_enc_key_c);
            if(0 < $this->encryptdata["mode"]) {
                $len = strlen($owner_key);
                for ($i = 1; $i <= 19; $i++) {
                    $ek = "";
                    for ($j = 0; $j < $len; $j++) {
                        $ek .= chr(ord($owner_key[$j]) ^ $i);
                    }
                    $enc = TCPDF_STATIC::_RC4($ek, $enc, $this->last_enc_key, $this->last_enc_key_c);
                }
            }
            return $enc;
        }
        if($this->encryptdata["mode"] == 3) {
            $seed = TCPDF_STATIC::_md5_16(TCPDF_STATIC::getRandomSeed());
            $this->encryptdata["OVS"] = substr($seed, 0, 8);
            $this->encryptdata["OKS"] = substr($seed, 8, 16);
            return hash("sha256", $this->encryptdata["owner_password"] . $this->encryptdata["OVS"] . $this->encryptdata["U"], true) . $this->encryptdata["OVS"] . $this->encryptdata["OKS"];
        }
    }
    protected function _OEvalue()
    {
        $hashkey = hash("sha256", $this->encryptdata["owner_password"] . $this->encryptdata["OKS"] . $this->encryptdata["U"], true);
        return TCPDF_STATIC::_AESnopad($hashkey, $this->encryptdata["key"]);
    }
    protected function _fixAES256Password($password)
    {
        $psw = "";
        $psw_array = TCPDF_FONTS::utf8Bidi(TCPDF_FONTS::UTF8StringToArray($password, $this->isunicode, $this->CurrentFont), $password, $this->rtl, $this->isunicode, $this->CurrentFont);
        foreach ($psw_array as $c) {
            $psw .= TCPDF_FONTS::unichr($c, $this->isunicode);
        }
        return substr($psw, 0, 127);
    }
    protected function _generateencryptionkey()
    {
        $keybytelen = $this->encryptdata["Length"] / 8;
        if(!$this->encryptdata["pubkey"]) {
            if($this->encryptdata["mode"] == 3) {
                $this->encryptdata["key"] = substr(hash("sha256", TCPDF_STATIC::getRandomSeed(), true), 0, $keybytelen);
                $this->encryptdata["user_password"] = $this->_fixAES256Password($this->encryptdata["user_password"]);
                $this->encryptdata["owner_password"] = $this->_fixAES256Password($this->encryptdata["owner_password"]);
                $this->encryptdata["U"] = $this->_Uvalue();
                $this->encryptdata["UE"] = $this->_UEvalue();
                $this->encryptdata["O"] = $this->_Ovalue();
                $this->encryptdata["OE"] = $this->_OEvalue();
                $this->encryptdata["P"] = $this->encryptdata["protection"];
                $perms = TCPDF_STATIC::getEncPermissionsString($this->encryptdata["protection"]);
                $perms .= chr(255) . chr(255) . chr(255) . chr(255);
                if(isset($this->encryptdata["CF"]["EncryptMetadata"]) && !$this->encryptdata["CF"]["EncryptMetadata"]) {
                    $perms .= "F";
                } else {
                    $perms .= "T";
                }
                $perms .= "adb";
                $perms .= "nick";
                $this->encryptdata["perms"] = TCPDF_STATIC::_AESnopad($this->encryptdata["key"], $perms);
            } else {
                $this->encryptdata["user_password"] = substr($this->encryptdata["user_password"] . TCPDF_STATIC::$enc_padding, 0, 32);
                $this->encryptdata["owner_password"] = substr($this->encryptdata["owner_password"] . TCPDF_STATIC::$enc_padding, 0, 32);
                $this->encryptdata["O"] = $this->_Ovalue();
                $permissions = TCPDF_STATIC::getEncPermissionsString($this->encryptdata["protection"]);
                $tmp = TCPDF_STATIC::_md5_16($this->encryptdata["user_password"] . $this->encryptdata["O"] . $permissions . $this->encryptdata["fileid"]);
                if(0 < $this->encryptdata["mode"]) {
                    for ($i = 0; $i < 50; $i++) {
                        $tmp = TCPDF_STATIC::_md5_16(substr($tmp, 0, $keybytelen));
                    }
                }
                $this->encryptdata["key"] = substr($tmp, 0, $keybytelen);
                $this->encryptdata["U"] = $this->_Uvalue();
                $this->encryptdata["P"] = $this->encryptdata["protection"];
            }
        } else {
            $seed = sha1(TCPDF_STATIC::getRandomSeed(), true);
            $recipient_bytes = "";
            foreach ($this->encryptdata["pubkeys"] as $pubkey) {
                if(isset($pubkey["p"])) {
                    $pkprotection = TCPDF_STATIC::getUserPermissionCode($pubkey["p"], $this->encryptdata["mode"]);
                } else {
                    $pkprotection = $this->encryptdata["protection"];
                }
                $pkpermissions = TCPDF_STATIC::getEncPermissionsString($pkprotection);
                $envelope = $seed . $pkpermissions;
                $tempkeyfile = TCPDF_STATIC::getObjFilename("key", $this->file_id);
                $f = TCPDF_STATIC::fopenLocal($tempkeyfile, "wb");
                if(!$f) {
                    $this->Error("Unable to create temporary key file: " . $tempkeyfile);
                }
                $envelope_length = strlen($envelope);
                fwrite($f, $envelope, $envelope_length);
                fclose($f);
                $tempencfile = TCPDF_STATIC::getObjFilename("enc", $this->file_id);
                if(!openssl_pkcs7_encrypt($tempkeyfile, $tempencfile, $pubkey["c"], [], PKCS7_BINARY | PKCS7_DETACHED)) {
                    $this->Error("Unable to encrypt the file: " . $tempkeyfile);
                }
                $signature = file_get_contents($tempencfile, false, NULL, $envelope_length);
                $signature = substr($signature, strpos($signature, "Content-Disposition"));
                $tmparr = explode("\n\n", $signature);
                $signature = trim($tmparr[1]);
                unset($tmparr);
                $signature = base64_decode($signature);
                $hexsignature = current(unpack("H*", $signature));
                $this->encryptdata["Recipients"][] = $hexsignature;
                $recipient_bytes .= $signature;
            }
            if($this->encryptdata["mode"] == 3) {
                $this->encryptdata["key"] = substr(hash("sha256", $seed . $recipient_bytes, true), 0, $keybytelen);
            } else {
                $this->encryptdata["key"] = substr(sha1($seed . $recipient_bytes, true), 0, $keybytelen);
            }
        }
    }
    public function setProtection($permissions = ["print", "modify", "copy", "annot-forms", "fill-forms", "extract", "assemble", "print-high"], $user_pass = "", $owner_pass = NULL, $mode = 0, $pubkeys = NULL)
    {
        if($this->pdfa_mode) {
            return NULL;
        }
        $this->encryptdata["protection"] = TCPDF_STATIC::getUserPermissionCode($permissions, $mode);
        if($pubkeys !== NULL && is_array($pubkeys)) {
            $this->encryptdata["pubkeys"] = $pubkeys;
            if($mode == 0) {
                $mode = 1;
            }
            if(!function_exists("openssl_pkcs7_encrypt")) {
                $this->Error("Public-Key Security requires openssl library.");
            }
            $this->encryptdata["pubkey"] = true;
            $this->encryptdata["Filter"] = "Adobe.PubSec";
            $this->encryptdata["StmF"] = "DefaultCryptFilter";
            $this->encryptdata["StrF"] = "DefaultCryptFilter";
        } else {
            $this->encryptdata["pubkey"] = false;
            $this->encryptdata["Filter"] = "Standard";
            $this->encryptdata["StmF"] = "StdCF";
            $this->encryptdata["StrF"] = "StdCF";
        }
        if(1 < $mode) {
            if(!extension_loaded("openssl") && !extension_loaded("mcrypt")) {
                $this->Error("AES encryption requires openssl or mcrypt extension (http://www.php.net/manual/en/mcrypt.requirements.php).");
            }
            if(extension_loaded("openssl") && !in_array("aes-256-cbc", openssl_get_cipher_methods())) {
                $this->Error("AES encryption requires openssl/aes-256-cbc cypher.");
            }
            if(extension_loaded("mcrypt") && mcrypt_get_cipher_name(MCRYPT_RIJNDAEL_128) === false) {
                $this->Error("AES encryption requires MCRYPT_RIJNDAEL_128 cypher.");
            }
            if($mode == 3 && !function_exists("hash")) {
                $this->Error("AES 256 encryption requires HASH Message Digest Framework (http://www.php.net/manual/en/book.hash.php).");
            }
        }
        if($owner_pass === NULL) {
            $owner_pass = md5(TCPDF_STATIC::getRandomSeed());
        }
        $this->encryptdata["user_password"] = $user_pass;
        $this->encryptdata["owner_password"] = $owner_pass;
        $this->encryptdata["mode"] = $mode;
        switch ($mode) {
            case 0:
                $this->encryptdata["V"] = 1;
                $this->encryptdata["Length"] = 40;
                $this->encryptdata["CF"]["CFM"] = "V2";
                break;
            case 1:
                $this->encryptdata["V"] = 2;
                $this->encryptdata["Length"] = 128;
                $this->encryptdata["CF"]["CFM"] = "V2";
                if($this->encryptdata["pubkey"]) {
                    $this->encryptdata["SubFilter"] = "adbe.pkcs7.s4";
                    $this->encryptdata["Recipients"] = [];
                }
                break;
            case 2:
                $this->encryptdata["V"] = 4;
                $this->encryptdata["Length"] = 128;
                $this->encryptdata["CF"]["CFM"] = "AESV2";
                $this->encryptdata["CF"]["Length"] = 128;
                if($this->encryptdata["pubkey"]) {
                    $this->encryptdata["SubFilter"] = "adbe.pkcs7.s5";
                    $this->encryptdata["Recipients"] = [];
                }
                break;
            case 3:
                $this->encryptdata["V"] = 5;
                $this->encryptdata["Length"] = 256;
                $this->encryptdata["CF"]["CFM"] = "AESV3";
                $this->encryptdata["CF"]["Length"] = 256;
                if($this->encryptdata["pubkey"]) {
                    $this->encryptdata["SubFilter"] = "adbe.pkcs7.s5";
                    $this->encryptdata["Recipients"] = [];
                }
                break;
            default:
                $this->encrypted = true;
                $this->encryptdata["fileid"] = TCPDF_STATIC::convertHexStringToString($this->file_id);
                $this->_generateencryptionkey();
        }
    }
    public function StartTransform()
    {
        if($this->state != 2) {
            return NULL;
        }
        $this->_outSaveGraphicsState();
        if($this->inxobj) {
            $this->xobjects[$this->xobjid]["transfmrk"][] = strlen($this->xobjects[$this->xobjid]["outdata"]);
        } else {
            $this->transfmrk[$this->page][] = $this->pagelen[$this->page];
        }
        $this->transfmatrix_key++;
        $this->transfmatrix[$this->transfmatrix_key] = [];
    }
    public function StopTransform()
    {
        if($this->state != 2) {
            return NULL;
        }
        $this->_outRestoreGraphicsState();
        if(isset($this->transfmatrix[$this->transfmatrix_key])) {
            array_pop($this->transfmatrix[$this->transfmatrix_key]);
            --$this->transfmatrix_key;
        }
        if($this->inxobj) {
            array_pop($this->xobjects[$this->xobjid]["transfmrk"]);
        } else {
            array_pop($this->transfmrk[$this->page]);
        }
    }
    public function ScaleX($s_x, $x = "", $y = "")
    {
        $this->Scale($s_x, 100, $x, $y);
    }
    public function ScaleY($s_y, $x = "", $y = "")
    {
        $this->Scale(100, $s_y, $x, $y);
    }
    public function ScaleXY($s, $x = "", $y = "")
    {
        $this->Scale($s, $s, $x, $y);
    }
    public function Scale($s_x, $s_y, $x = NULL, $y = NULL)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        if($s_x == 0 || $s_y == 0) {
            $this->Error("Please do not use values equal to zero for scaling");
        }
        $y = ($this->h - $y) * $this->k;
        $x *= $this->k;
        $s_x /= 100;
        $s_y /= 100;
        $tm = [];
        $tm[0] = $s_x;
        $tm[1] = 0;
        $tm[2] = 0;
        $tm[3] = $s_y;
        $tm[4] = $x * (1 - $s_x);
        $tm[5] = $y * (1 - $s_y);
        $this->Transform($tm);
    }
    public function MirrorH($x = NULL)
    {
        $this->Scale(-100, 100, $x);
    }
    public function MirrorV($y = NULL)
    {
        $this->Scale(100, -100, NULL, $y);
    }
    public function MirrorP($x = NULL, $y = NULL)
    {
        $this->Scale(-100, -100, $x, $y);
    }
    public function MirrorL($angle = 0, $x = NULL, $y = NULL)
    {
        $this->Scale(-100, 100, $x, $y);
        $this->Rotate(-2 * ($angle - 90), $x, $y);
    }
    public function TranslateX($t_x)
    {
        $this->Translate($t_x, 0);
    }
    public function TranslateY($t_y)
    {
        $this->Translate(0, $t_y);
    }
    public function Translate($t_x, $t_y)
    {
        $tm = [];
        $tm[0] = 1;
        $tm[1] = 0;
        $tm[2] = 0;
        $tm[3] = 1;
        $tm[4] = $t_x * $this->k;
        $tm[5] = -1 * $t_y * $this->k;
        $this->Transform($tm);
    }
    public function Rotate($angle, $x = NULL, $y = NULL)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        $y = ($this->h - $y) * $this->k;
        $x *= $this->k;
        $tm = [];
        $tm[0] = cos(deg2rad($angle));
        $tm[1] = sin(deg2rad($angle));
        $tm[2] = -1 * $tm[1];
        $tm[3] = $tm[0];
        $tm[4] = $x + $tm[1] * $y - $tm[0] * $x;
        $tm[5] = $y - $tm[0] * $y - $tm[1] * $x;
        $this->Transform($tm);
    }
    public function SkewX($angle_x, $x = NULL, $y = NULL)
    {
        $this->Skew($angle_x, 0, $x, $y);
    }
    public function SkewY($angle_y, $x = NULL, $y = NULL)
    {
        $this->Skew(0, $angle_y, $x, $y);
    }
    public function Skew($angle_x, $angle_y, $x = NULL, $y = NULL)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        if($angle_x <= -90 || 90 <= $angle_x || $angle_y <= -90 || 90 <= $angle_y) {
            $this->Error("Please use values between -90 and +90 degrees for Skewing.");
        }
        $x *= $this->k;
        $y = ($this->h - $y) * $this->k;
        $tm = [];
        $tm[0] = 1;
        $tm[1] = tan(deg2rad($angle_y));
        $tm[2] = tan(deg2rad($angle_x));
        $tm[3] = 1;
        $tm[4] = -1 * $tm[2] * $y;
        $tm[5] = -1 * $tm[1] * $x;
        $this->Transform($tm);
    }
    protected function Transform($tm)
    {
        if($this->state != 2) {
            return NULL;
        }
        $this->_out(sprintf("%F %F %F %F %F %F cm", $tm[0], $tm[1], $tm[2], $tm[3], $tm[4], $tm[5]));
        $this->transfmatrix[$this->transfmatrix_key][] = ["a" => $tm[0], "b" => $tm[1], "c" => $tm[2], "d" => $tm[3], "e" => $tm[4], "f" => $tm[5]];
        if($this->inxobj) {
            if(end($this->xobjects[$this->xobjid]["transfmrk"]) !== false) {
                $key = key($this->xobjects[$this->xobjid]["transfmrk"]);
                $this->xobjects[$this->xobjid]["transfmrk"][$key] = strlen($this->xobjects[$this->xobjid]["outdata"]);
            }
        } elseif(end($this->transfmrk[$this->page]) !== false) {
            $key = key($this->transfmrk[$this->page]);
            $this->transfmrk[$this->page][$key] = $this->pagelen[$this->page];
        }
    }
    public function setLineWidth($width)
    {
        $this->LineWidth = $width;
        $this->linestyleWidth = sprintf("%F w", $width * $this->k);
        if($this->state == 2) {
            $this->_out($this->linestyleWidth);
        }
    }
    public function GetLineWidth()
    {
        return $this->LineWidth;
    }
    public function setLineStyle($style, $ret = false)
    {
        $s = "";
        if(!is_array($style)) {
            return $s;
        }
        if(isset($style["width"])) {
            $this->LineWidth = $style["width"];
            $this->linestyleWidth = sprintf("%F w", $style["width"] * $this->k);
            $s .= $this->linestyleWidth . " ";
        }
        if(isset($style["cap"])) {
            $ca = ["butt" => 0, "round" => 1, "square" => 2];
            if(isset($ca[$style["cap"]])) {
                $this->linestyleCap = $ca[$style["cap"]] . " J";
                $s .= $this->linestyleCap . " ";
            }
        }
        if(isset($style["join"])) {
            $ja = ["miter" => 0, "round" => 1, "bevel" => 2];
            if(isset($ja[$style["join"]])) {
                $this->linestyleJoin = $ja[$style["join"]] . " j";
                $s .= $this->linestyleJoin . " ";
            }
        }
        if(isset($style["dash"])) {
            $dash_string = "";
            if($style["dash"]) {
                if(0 < preg_match("/^.+,/", $style["dash"])) {
                    $tab = explode(",", $style["dash"]);
                } else {
                    $tab = [$style["dash"]];
                }
                $dash_string = "";
                foreach ($tab as $i => $v) {
                    if($i) {
                        $dash_string .= " ";
                    }
                    $dash_string .= sprintf("%F", $v);
                }
            }
            if(!isset($style["phase"]) || !$style["dash"]) {
                $style["phase"] = 0;
            }
            $this->linestyleDash = sprintf("[%s] %F d", $dash_string, $style["phase"]);
            $s .= $this->linestyleDash . " ";
        }
        if(isset($style["color"])) {
            $s .= $this->setDrawColorArray($style["color"], true) . " ";
        }
        if(!$ret && $this->state == 2) {
            $this->_out($s);
        }
        return $s;
    }
    protected function _outPoint($x, $y)
    {
        if($this->state == 2) {
            $this->_out(sprintf("%F %F m", $x * $this->k, ($this->h - $y) * $this->k));
        }
    }
    protected function _outLine($x, $y)
    {
        if($this->state == 2) {
            $this->_out(sprintf("%F %F l", $x * $this->k, ($this->h - $y) * $this->k));
        }
    }
    protected function _outRect($x, $y, $w, $h, $op)
    {
        if($this->state == 2) {
            $this->_out(sprintf("%F %F %F %F re %s", $x * $this->k, ($this->h - $y) * $this->k, $w * $this->k, -1 * $h * $this->k, $op));
        }
    }
    protected function _outCurve($x1, $y1, $x2, $y2, $x3, $y3)
    {
        if($this->state == 2) {
            $this->_out(sprintf("%F %F %F %F %F %F c", $x1 * $this->k, ($this->h - $y1) * $this->k, $x2 * $this->k, ($this->h - $y2) * $this->k, $x3 * $this->k, ($this->h - $y3) * $this->k));
        }
    }
    protected function _outCurveV($x2, $y2, $x3, $y3)
    {
        if($this->state == 2) {
            $this->_out(sprintf("%F %F %F %F v", $x2 * $this->k, ($this->h - $y2) * $this->k, $x3 * $this->k, ($this->h - $y3) * $this->k));
        }
    }
    protected function _outCurveY($x1, $y1, $x3, $y3)
    {
        if($this->state == 2) {
            $this->_out(sprintf("%F %F %F %F y", $x1 * $this->k, ($this->h - $y1) * $this->k, $x3 * $this->k, ($this->h - $y3) * $this->k));
        }
    }
    public function Line($x1, $y1, $x2, $y2, $style = [])
    {
        if($this->state != 2) {
            return NULL;
        }
        if(is_array($style)) {
            $this->setLineStyle($style);
        }
        $this->_outPoint($x1, $y1);
        $this->_outLine($x2, $y2);
        $this->_out("S");
    }
    public function Rect($x, $y, $w, $h, $style = "", $border_style = [], $fill_color = [])
    {
        if($this->state != 2) {
            return NULL;
        }
        if(empty($style)) {
            $style = "S";
        }
        if(strpos($style, "F") !== false && !empty($fill_color)) {
            $this->setFillColorArray($fill_color);
        }
        if(!empty($border_style)) {
            if(isset($border_style["all"]) && !empty($border_style["all"])) {
                $this->setLineStyle($border_style["all"]);
                $border_style = [];
            } else {
                $opnostroke = ["S" => "", "D" => "", "s" => "", "d" => "", "B" => "F", "FD" => "F", "DF" => "F", "B*" => "F*", "F*D" => "F*", "DF*" => "F*", "b" => "f", "fd" => "f", "df" => "f", "b*" => "f*", "f*d" => "f*", "df*" => "f*"];
                if(isset($opnostroke[$style])) {
                    $style = $opnostroke[$style];
                }
            }
        }
        if(!empty($style)) {
            $op = TCPDF_STATIC::getPathPaintOperator($style);
            $this->_outRect($x, $y, $w, $h, $op);
        }
        if(!empty($border_style)) {
            $border_style2 = [];
            foreach ($border_style as $line => $value) {
                $length = strlen($line);
                for ($i = 0; $i < $length; $i++) {
                    $border_style2[$line[$i]] = $value;
                }
            }
            $border_style = $border_style2;
            if(isset($border_style["L"]) && $border_style["L"]) {
                $this->Line($x, $y, $x, $y + $h, $border_style["L"]);
            }
            if(isset($border_style["T"]) && $border_style["T"]) {
                $this->Line($x, $y, $x + $w, $y, $border_style["T"]);
            }
            if(isset($border_style["R"]) && $border_style["R"]) {
                $this->Line($x + $w, $y, $x + $w, $y + $h, $border_style["R"]);
            }
            if(isset($border_style["B"]) && $border_style["B"]) {
                $this->Line($x, $y + $h, $x + $w, $y + $h, $border_style["B"]);
            }
        }
    }
    public function Curve($x0, $y0, $x1, $y1, $x2, $y2, $x3, $y3, $style = "", $line_style = [], $fill_color = [])
    {
        if($this->state != 2) {
            return NULL;
        }
        if(false !== strpos($style, "F") && isset($fill_color)) {
            $this->setFillColorArray($fill_color);
        }
        $op = TCPDF_STATIC::getPathPaintOperator($style);
        if($line_style) {
            $this->setLineStyle($line_style);
        }
        $this->_outPoint($x0, $y0);
        $this->_outCurve($x1, $y1, $x2, $y2, $x3, $y3);
        $this->_out($op);
    }
    public function Polycurve($x0, $y0, $segments, $style = "", $line_style = [], $fill_color = [])
    {
        if($this->state != 2) {
            return NULL;
        }
        if(false !== strpos($style, "F") && isset($fill_color)) {
            $this->setFillColorArray($fill_color);
        }
        $op = TCPDF_STATIC::getPathPaintOperator($style);
        if($op == "f") {
            $line_style = [];
        }
        if($line_style) {
            $this->setLineStyle($line_style);
        }
        $this->_outPoint($x0, $y0);
        foreach ($segments as $segment) {
            list($x1, $y1, $x2, $y2, $x3, $y3) = $segment;
            $this->_outCurve($x1, $y1, $x2, $y2, $x3, $y3);
        }
        $this->_out($op);
    }
    public function Ellipse($x0, $y0, $rx, $ry = 0, $angle = 0, $astart = 0, $afinish = 360, $style = "", $line_style = [], $fill_color = [], $nc = 2)
    {
        if($this->state != 2) {
            return NULL;
        }
        if(TCPDF_STATIC::empty_string($ry) || $ry == 0) {
            $ry = $rx;
        }
        if(false !== strpos($style, "F") && isset($fill_color)) {
            $this->setFillColorArray($fill_color);
        }
        $op = TCPDF_STATIC::getPathPaintOperator($style);
        if($op == "f") {
            $line_style = [];
        }
        if($line_style) {
            $this->setLineStyle($line_style);
        }
        $this->_outellipticalarc($x0, $y0, $rx, $ry, $angle, $astart, $afinish, false, $nc, true, true, false);
        $this->_out($op);
    }
    protected function _outellipticalarc($xc, $yc, $rx, $ry, $xang = 0, $angs = 0, $angf = 360, $pie = false, $nc = 2, $startpoint = true, $ccw = true, $svg = false)
    {
        if($rx <= 0 || $ry < 0) {
            return NULL;
        }
        $k = $this->k;
        if($nc < 2) {
            $nc = 2;
        }
        $xmin = -2147483649.0;
        $ymin = -2147483649.0;
        $xmax = 0;
        $ymax = 0;
        if($pie) {
            $this->_outPoint($xc, $yc);
        }
        $xang = deg2rad((double) $xang);
        $angs = deg2rad((double) $angs);
        $angf = deg2rad((double) $angf);
        if($svg) {
            $as = $angs;
            $af = $angf;
        } else {
            $as = atan2(sin($angs) / $ry, cos($angs) / $rx);
            $af = atan2(sin($angf) / $ry, cos($angf) / $rx);
        }
        if($as < 0) {
            $as += 2 * M_PI;
        }
        if($af < 0) {
            $af += 2 * M_PI;
        }
        if($ccw && $af < $as) {
            $as -= 2 * M_PI;
        } elseif(!$ccw && $as < $af) {
            $af -= 2 * M_PI;
        }
        $total_angle = $af - $as;
        if($nc < 2) {
            $nc = 2;
        }
        $nc *= 2 * abs($total_angle) / M_PI;
        $nc = round($nc) + 1;
        $arcang = $total_angle / $nc;
        $x0 = $xc;
        $y0 = $this->h - $yc;
        $ang = $as;
        $alpha = sin($arcang) * (sqrt(4 + 3 * pow(tan($arcang / 2), 2)) - 1) / 3;
        $cos_xang = cos($xang);
        $sin_xang = sin($xang);
        $cos_ang = cos($ang);
        $sin_ang = sin($ang);
        $px1 = $x0 + $rx * $cos_xang * $cos_ang - $ry * $sin_xang * $sin_ang;
        $py1 = $y0 + $rx * $sin_xang * $cos_ang + $ry * $cos_xang * $sin_ang;
        $qx1 = $alpha * (-1 * $rx * $cos_xang * $sin_ang - $ry * $sin_xang * $cos_ang);
        $qy1 = $alpha * (-1 * $rx * $sin_xang * $sin_ang + $ry * $cos_xang * $cos_ang);
        if($pie) {
            $this->_outLine($px1, $this->h - $py1);
        } elseif($startpoint) {
            $this->_outPoint($px1, $this->h - $py1);
        }
        for ($i = 1; $i <= $nc; $i++) {
            $ang = $as + $i * $arcang;
            if($i == $nc) {
                $ang = $af;
            }
            $cos_ang = cos($ang);
            $sin_ang = sin($ang);
            $px2 = $x0 + $rx * $cos_xang * $cos_ang - $ry * $sin_xang * $sin_ang;
            $py2 = $y0 + $rx * $sin_xang * $cos_ang + $ry * $cos_xang * $sin_ang;
            $qx2 = $alpha * (-1 * $rx * $cos_xang * $sin_ang - $ry * $sin_xang * $cos_ang);
            $qy2 = $alpha * (-1 * $rx * $sin_xang * $sin_ang + $ry * $cos_xang * $cos_ang);
            $cx1 = $px1 + $qx1;
            $cy1 = $this->h - ($py1 + $qy1);
            $cx2 = $px2 - $qx2;
            $cy2 = $this->h - ($py2 - $qy2);
            $cx3 = $px2;
            $cy3 = $this->h - $py2;
            $this->_outCurve($cx1, $cy1, $cx2, $cy2, $cx3, $cy3);
            $xmin = min($xmin, $cx1, $cx2, $cx3);
            $ymin = min($ymin, $cy1, $cy2, $cy3);
            $xmax = max($xmax, $cx1, $cx2, $cx3);
            $ymax = max($ymax, $cy1, $cy2, $cy3);
            $px1 = $px2;
            $py1 = $py2;
            $qx1 = $qx2;
            $qy1 = $qy2;
        }
        if($pie) {
            $this->_outLine($xc, $yc);
            $xmin = min($xmin, $xc);
            $ymin = min($ymin, $yc);
            $xmax = max($xmax, $xc);
            $ymax = max($ymax, $yc);
        }
        return [$xmin, $ymin, $xmax, $ymax];
    }
    public function Circle($x0, $y0, $r, $angstr = 0, $angend = 360, $style = "", $line_style = [], $fill_color = [], $nc = 2)
    {
        $this->Ellipse($x0, $y0, $r, $r, 0, $angstr, $angend, $style, $line_style, $fill_color, $nc);
    }
    public function PolyLine($p, $style = "", $line_style = [], $fill_color = [])
    {
        $this->Polygon($p, $style, $line_style, $fill_color, false);
    }
    public function Polygon($p, $style = "", $line_style = [], $fill_color = [], $closed = true)
    {
        if($this->state != 2) {
            return NULL;
        }
        $nc = count($p);
        $np = $nc / 2;
        if($closed) {
            for ($i = 0; $i < 4; $i++) {
                $p[$nc + $i] = $p[$i];
            }
            if(isset($line_style[0])) {
                $line_style[$np] = $line_style[0];
            }
            $nc += 4;
        }
        if(false !== strpos($style, "F") && isset($fill_color)) {
            $this->setFillColorArray($fill_color);
        }
        $op = TCPDF_STATIC::getPathPaintOperator($style);
        if($op == "f") {
            $line_style = [];
        }
        $draw = true;
        if($line_style) {
            if(isset($line_style["all"])) {
                $this->setLineStyle($line_style["all"]);
            } else {
                $draw = false;
                if($op == "B") {
                    $op = "f";
                    $this->_outPoint($p[0], $p[1]);
                    $i = 2;
                    while ($i < $nc) {
                        $this->_outLine($p[$i], $p[$i + 1]);
                        $i = $i + 2;
                    }
                    $this->_out($op);
                }
                $this->_outPoint($p[0], $p[1]);
                $i = 2;
                while ($i < $nc) {
                    $line_num = $i / 2 - 1;
                    if(isset($line_style[$line_num])) {
                        if($line_style[$line_num] != 0) {
                            if(is_array($line_style[$line_num])) {
                                $this->_out("S");
                                $this->setLineStyle($line_style[$line_num]);
                                $this->_outPoint($p[$i - 2], $p[$i - 1]);
                                $this->_outLine($p[$i], $p[$i + 1]);
                                $this->_out("S");
                                $this->_outPoint($p[$i], $p[$i + 1]);
                            } else {
                                $this->_outLine($p[$i], $p[$i + 1]);
                            }
                        }
                    } else {
                        $this->_outLine($p[$i], $p[$i + 1]);
                    }
                    $i = $i + 2;
                }
                $this->_out($op);
            }
        }
        if($draw) {
            $this->_outPoint($p[0], $p[1]);
            $i = 2;
            while ($i < $nc) {
                $this->_outLine($p[$i], $p[$i + 1]);
                $i = $i + 2;
            }
            $this->_out($op);
        }
    }
    public function RegularPolygon($x0, $y0, $r, $ns, $angle = 0, $draw_circle = false, $style = "", $line_style = [], $fill_color = [], $circle_style = "", $circle_outLine_style = [], $circle_fill_color = [])
    {
        if($ns < 3) {
            $ns = 3;
        }
        if($draw_circle) {
            $this->Circle($x0, $y0, $r, 0, 360, $circle_style, $circle_outLine_style, $circle_fill_color);
        }
        $p = [];
        for ($i = 0; $i < $ns; $i++) {
            $a = $angle + $i * 360 / $ns;
            $a_rad = deg2rad((double) $a);
            $p[] = $x0 + $r * sin($a_rad);
            $p[] = $y0 + $r * cos($a_rad);
        }
        $this->Polygon($p, $style, $line_style, $fill_color);
    }
    public function StarPolygon($x0, $y0, $r, $nv, $ng, $angle = 0, $draw_circle = false, $style = "", $line_style = [], $fill_color = [], $circle_style = "", $circle_outLine_style = [], $circle_fill_color = [])
    {
        if($nv < 2) {
            $nv = 2;
        }
        if($draw_circle) {
            $this->Circle($x0, $y0, $r, 0, 360, $circle_style, $circle_outLine_style, $circle_fill_color);
        }
        $p2 = [];
        $visited = [];
        for ($i = 0; $i < $nv; $i++) {
            $a = $angle + $i * 360 / $nv;
            $a_rad = deg2rad((double) $a);
            $p2[] = $x0 + $r * sin($a_rad);
            $p2[] = $y0 + $r * cos($a_rad);
            $visited[] = false;
        }
        $p = [];
        $i = 0;
        do {
            $p[] = $p2[$i * 2];
            $p[] = $p2[$i * 2 + 1];
            $visited[$i] = true;
            $i += $ng;
            $i %= $nv;
        } while ($visited[$i]);
        $this->Polygon($p, $style, $line_style, $fill_color);
    }
    public function RoundedRect($x, $y, $w, $h, $r, $round_corner = "1111", $style = "", $border_style = [], $fill_color = [])
    {
        $this->RoundedRectXY($x, $y, $w, $h, $r, $r, $round_corner, $style, $border_style, $fill_color);
    }
    public function RoundedRectXY($x, $y, $w, $h, $rx, $ry, $round_corner = "1111", $style = "", $border_style = [], $fill_color = [])
    {
        if($this->state != 2) {
            return NULL;
        }
        if($round_corner == "0000" || $rx == $ry && $rx == 0) {
            $this->Rect($x, $y, $w, $h, $style, $border_style, $fill_color);
        } else {
            if(false !== strpos($style, "F") && isset($fill_color)) {
                $this->setFillColorArray($fill_color);
            }
            $op = TCPDF_STATIC::getPathPaintOperator($style);
            if($op == "f") {
                $border_style = [];
            }
            if($border_style) {
                $this->setLineStyle($border_style);
            }
            $MyArc = 0 * (sqrt(2) - 1);
            $this->_outPoint($x + $rx, $y);
            $xc = $x + $w - $rx;
            $yc = $y + $ry;
            $this->_outLine($xc, $y);
            if($round_corner[0]) {
                $this->_outCurve($xc + $rx * $MyArc, $yc - $ry, $xc + $rx, $yc - $ry * $MyArc, $xc + $rx, $yc);
            } else {
                $this->_outLine($x + $w, $y);
            }
            $xc = $x + $w - $rx;
            $yc = $y + $h - $ry;
            $this->_outLine($x + $w, $yc);
            if($round_corner[1]) {
                $this->_outCurve($xc + $rx, $yc + $ry * $MyArc, $xc + $rx * $MyArc, $yc + $ry, $xc, $yc + $ry);
            } else {
                $this->_outLine($x + $w, $y + $h);
            }
            $xc = $x + $rx;
            $yc = $y + $h - $ry;
            $this->_outLine($xc, $y + $h);
            if($round_corner[2]) {
                $this->_outCurve($xc - $rx * $MyArc, $yc + $ry, $xc - $rx, $yc + $ry * $MyArc, $xc - $rx, $yc);
            } else {
                $this->_outLine($x, $y + $h);
            }
            $xc = $x + $rx;
            $yc = $y + $ry;
            $this->_outLine($x, $yc);
            if($round_corner[3]) {
                $this->_outCurve($xc - $rx, $yc - $ry * $MyArc, $xc - $rx * $MyArc, $yc - $ry, $xc, $yc - $ry);
            } else {
                $this->_outLine($x, $y);
                $this->_outLine($x + $rx, $y);
            }
            $this->_out($op);
        }
    }
    public function Arrow($x0, $y0, $x1, $y1, $head_style = 0, $arm_size = 5, $arm_angle = 15)
    {
        $dir_angle = atan2($y0 - $y1, $x0 - $x1);
        if($dir_angle < 0) {
            $dir_angle += 2 * M_PI;
        }
        $arm_angle = deg2rad($arm_angle);
        $sx1 = $x1;
        $sy1 = $y1;
        if(0 < $head_style) {
            $sx1 = $x1 + ($arm_size - $this->LineWidth) * cos($dir_angle);
            $sy1 = $y1 + ($arm_size - $this->LineWidth) * sin($dir_angle);
        }
        $this->Line($x0, $y0, $sx1, $sy1);
        $x2L = $x1 + $arm_size * cos($dir_angle + $arm_angle);
        $y2L = $y1 + $arm_size * sin($dir_angle + $arm_angle);
        $x2R = $x1 + $arm_size * cos($dir_angle - $arm_angle);
        $y2R = $y1 + $arm_size * sin($dir_angle - $arm_angle);
        $mode = "D";
        $style = [];
        switch ($head_style) {
            case 0:
                $mode = "D";
                $style = [1, 1, 0];
                break;
            case 1:
                $mode = "D";
                break;
            case 2:
                $mode = "DF";
                break;
            case 3:
                $mode = "F";
                break;
            default:
                $this->Polygon([$x2L, $y2L, $x1, $y1, $x2R, $y2R], $mode, $style, []);
        }
    }
    public function setDestination($name, $y = -1, $page = "", $x = -1)
    {
        $name = TCPDF_STATIC::encodeNameObject($name);
        if(TCPDF_STATIC::empty_string($name)) {
            return false;
        }
        if($y == -1) {
            $y = $this->GetY();
        } elseif($y < 0) {
            $y = 0;
        } elseif($this->h < $y) {
            $y = $this->h;
        }
        if($x == -1) {
            $x = $this->GetX();
        } elseif($x < 0) {
            $x = 0;
        } elseif($this->w < $x) {
            $x = $this->w;
        }
        $fixed = false;
        if(!empty($page) && substr($page, 0, 1) == "*") {
            $page = intval(substr($page, 1));
            $fixed = true;
        }
        if(empty($page)) {
            $page = $this->PageNo();
        }
        if(empty($page)) {
            return NULL;
        }
        $this->dests[$name] = ["x" => $x, "y" => $y, "p" => $page, "f" => $fixed];
        return $name;
    }
    public function getDestination()
    {
        return $this->dests;
    }
    protected function _putdests()
    {
        if(empty($this->dests)) {
            return NULL;
        }
        $this->n_dests = $this->_newobj();
        $out = " <<";
        foreach ($this->dests as $name => $o) {
            $out .= " /" . $name . " " . sprintf("[%u 0 R /XYZ %F %F null]", $this->page_obj_id[$o["p"]], $o["x"] * $this->k, $this->pagedim[$o["p"]]["h"] - $o["y"] * $this->k);
        }
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
    }
    public function setBookmark($txt, $level = 0, $y = -1, $page = "", $style = "", $color = [0, 0, 0], $x = -1, $link = "")
    {
        $this->Bookmark($txt, $level, $y, $page, $style, $color, $x, $link);
    }
    public function Bookmark($txt, $level = 0, $y = -1, $page = "", $style = "", $color = [0, 0, 0], $x = -1, $link = "")
    {
        if($level < 0) {
            $level = 0;
        }
        if(isset($this->outlines[0])) {
            $lastoutline = end($this->outlines);
            $maxlevel = $lastoutline["l"] + 1;
        } else {
            $maxlevel = 0;
        }
        if($maxlevel < $level) {
            $level = $maxlevel;
        }
        if($y == -1) {
            $y = $this->GetY();
        } elseif($y < 0) {
            $y = 0;
        } elseif($this->h < $y) {
            $y = $this->h;
        }
        if($x == -1) {
            $x = $this->GetX();
        } elseif($x < 0) {
            $x = 0;
        } elseif($this->w < $x) {
            $x = $this->w;
        }
        $fixed = false;
        $pageAsString = (string) $page;
        if($pageAsString && $pageAsString[0] == "*") {
            $page = intval(substr($page, 1));
            $fixed = true;
        }
        if(empty($page)) {
            $page = $this->PageNo();
        }
        if(empty($page)) {
            return NULL;
        }
        $this->outlines[] = ["t" => $txt, "l" => $level, "x" => $x, "y" => $y, "p" => $page, "f" => $fixed, "s" => strtoupper($style), "c" => $color, "u" => $link];
    }
    protected function sortBookmarks()
    {
        $outline_p = [];
        $outline_y = [];
        foreach ($this->outlines as $key => $row) {
            $outline_p[$key] = $row["p"];
            $outline_k[$key] = $key;
        }
        array_multisort($outline_p, SORT_NUMERIC, SORT_ASC, $outline_k, SORT_NUMERIC, SORT_ASC, $this->outlines);
    }
    protected function _putbookmarks()
    {
        $nb = count($this->outlines);
        if($nb == 0) {
            return NULL;
        }
        $this->sortBookmarks();
        $lru = [];
        $level = 0;
        foreach ($this->outlines as $i => $o) {
            if(0 < $o["l"]) {
                $parent = $lru[$o["l"] - 1];
                $this->outlines[$i]["parent"] = $parent;
                $this->outlines[$parent]["last"] = $i;
                if($level < $o["l"]) {
                    $this->outlines[$parent]["first"] = $i;
                }
            } else {
                $this->outlines[$i]["parent"] = $nb;
            }
            if($o["l"] <= $level && 0 < $i) {
                $prev = $lru[$o["l"]];
                $this->outlines[$prev]["next"] = $i;
                $this->outlines[$i]["prev"] = $prev;
            }
            $lru[$o["l"]] = $i;
            $level = $o["l"];
        }
        $n = $this->n + 1;
        $nltags = "/<br[\\s]?\\/>|<\\/(blockquote|dd|dl|div|dt|h1|h2|h3|h4|h5|h6|hr|li|ol|p|pre|ul|tcpdf|table|tr|td)>/si";
        foreach ($this->outlines as $i => $o) {
            $oid = $this->_newobj();
            $title = preg_replace($nltags, "\n", $o["t"]);
            $title = preg_replace("/[\r]+/si", "", $title);
            $title = preg_replace("/[\n]+/si", "\n", $title);
            $title = strip_tags($title);
            $title = $this->stringTrim($title);
            $out = "<</Title " . $this->_textstring($title, $oid);
            $out .= " /Parent " . ($n + $o["parent"]) . " 0 R";
            if(isset($o["prev"])) {
                $out .= " /Prev " . ($n + $o["prev"]) . " 0 R";
            }
            if(isset($o["next"])) {
                $out .= " /Next " . ($n + $o["next"]) . " 0 R";
            }
            if(isset($o["first"])) {
                $out .= " /First " . ($n + $o["first"]) . " 0 R";
            }
            if(isset($o["last"])) {
                $out .= " /Last " . ($n + $o["last"]) . " 0 R";
            }
            if(isset($o["u"]) && !empty($o["u"])) {
                if(is_string($o["u"])) {
                    if($o["u"][0] == "#") {
                        $out .= " /Dest /" . TCPDF_STATIC::encodeNameObject(substr($o["u"], 1));
                    } elseif($o["u"][0] == "%") {
                        $filename = basename(substr($o["u"], 1));
                        $out .= " /A <</S /GoToE /D [0 /Fit] /NewWindow true /T << /R /C /P " . ($o["p"] - 1) . " /A " . $this->embeddedfiles[$filename]["a"] . " >> >>";
                    } elseif($o["u"][0] == "*") {
                        $filename = basename(substr($o["u"], 1));
                        $jsa = "var D=event.target.doc;var MyData=D.dataObjects;for (var i in MyData) if (MyData[i].path==\"" . $filename . "\") D.exportDataObject( { cName : MyData[i].name, nLaunch : 2});";
                        $out .= " /A <</S /JavaScript /JS " . $this->_textstring($jsa, $oid) . ">>";
                    } else {
                        $out .= " /A <</S /URI /URI " . $this->_datastring($this->unhtmlentities($o["u"]), $oid) . ">>";
                    }
                } elseif(isset($this->links[$o["u"]])) {
                    $l = $this->links[$o["u"]];
                    if(isset($this->page_obj_id[$l["p"]])) {
                        $out .= sprintf(" /Dest [%u 0 R /XYZ 0 %F null]", $this->page_obj_id[$l["p"]], $this->pagedim[$l["p"]]["h"] - $l["y"] * $this->k);
                    }
                }
            } elseif(isset($this->page_obj_id[$o["p"]])) {
                $out .= " " . sprintf("/Dest [%u 0 R /XYZ %F %F null]", $this->page_obj_id[$o["p"]], $o["x"] * $this->k, $this->pagedim[$o["p"]]["h"] - $o["y"] * $this->k);
            }
            $style = 0;
            if(!empty($o["s"])) {
                if(strpos($o["s"], "B") !== false) {
                    $style |= 2;
                }
                if(strpos($o["s"], "I") !== false) {
                    $style |= 1;
                }
            }
            $out .= sprintf(" /F %d", $style);
            if(isset($o["c"]) && is_array($o["c"]) && count($o["c"]) == 3) {
                $color = array_values($o["c"]);
                $out .= sprintf(" /C [%F %F %F]", $color[0] / 255, $color[1] / 255, $color[2] / 255);
            } else {
                $out .= " /C [0.0 0.0 0.0]";
            }
            $out .= " /Count 0";
            $out .= " >>";
            $out .= "\nendobj";
            $this->_out($out);
        }
        $this->OutlineRoot = $this->_newobj();
        $this->_out("<< /Type /Outlines /First " . $n . " 0 R /Last " . ($n + $lru[0]) . " 0 R >>" . "\n" . "endobj");
    }
    public function IncludeJS($script)
    {
        $this->javascript .= $script;
    }
    public function addJavascriptObject($script, $onload = false)
    {
        if($this->pdfa_mode) {
            return false;
        }
        $this->n++;
        $this->js_objects[$this->n] = ["n" => $this->n, "js" => $script, "onload" => $onload];
        return $this->n;
    }
    protected function _putjavascript()
    {
        if($this->pdfa_mode || empty($this->javascript) && empty($this->js_objects)) {
            return NULL;
        }
        if(0 < strpos($this->javascript, "this.addField")) {
            if(!$this->ur["enabled"]) {
            }
            $jsa = sprintf("ftcpdfdocsaved=this.addField('%s','%s',%d,[%F,%F,%F,%F]);", "tcpdfdocsaved", "text", 0, 0, 1, 0, 1);
            $jsb = "getField('tcpdfdocsaved').value='saved';";
            $this->javascript = $jsa . "\n" . $this->javascript . "\n" . $jsb;
        }
        $this->n_js = "<< /Names [";
        if(!empty($this->javascript)) {
            $this->n_js .= " (EmbeddedJS) " . ($this->n + 1) . " 0 R";
        }
        if(!empty($this->js_objects)) {
            foreach ($this->js_objects as $key => $val) {
                if($val["onload"]) {
                    $this->n_js .= " (JS" . $key . ") " . $key . " 0 R";
                }
            }
        }
        $this->n_js .= " ] >>";
        if(!empty($this->javascript)) {
            $obj_id = $this->_newobj();
            $out = "<< /S /JavaScript";
            $out .= " /JS " . $this->_textstring($this->javascript, $obj_id);
            $out .= " >>";
            $out .= "\nendobj";
            $this->_out($out);
        }
        if(!empty($this->js_objects)) {
            foreach ($this->js_objects as $key => $val) {
                $out = $this->_getobj($key) . "\n" . " << /S /JavaScript /JS " . $this->_textstring($val["js"], $key) . " >>" . "\n" . "endobj";
                $this->_out($out);
            }
        }
    }
    protected function _addfield($type, $name, $x, $y, $w, $h, $prop)
    {
        if($this->rtl) {
            $x = $x - $w;
        }
        $this->javascript .= "if (getField('tcpdfdocsaved').value != 'saved') {";
        $k = $this->k;
        $this->javascript .= sprintf("f" . $name . "=this.addField('%s','%s',%u,[%F,%F,%F,%F]);", $name, $type, $this->PageNo() - 1, $x * $k, ($this->h - $y) * $k + 1, ($x + $w) * $k, ($this->h - $y - $h) * $k + 1) . "\n";
        $this->javascript .= "f" . $name . ".textSize=" . $this->FontSizePt . ";\n";
        foreach ($prop as $key => $val) {
            if(strcmp(substr($key, -5), "Color") == 0) {
                $val = TCPDF_COLORS::_JScolor($val);
            } else {
                $val = "'" . $val . "'";
            }
            $this->javascript .= "f" . $name . "." . $key . "=" . $val . ";\n";
        }
        if($this->rtl) {
            $this->x -= $w;
        } else {
            $this->x += $w;
        }
        $this->javascript .= "}";
    }
    public function setFormDefaultProp($prop = [])
    {
        $this->default_form_prop = $prop;
    }
    public function getFormDefaultProp()
    {
        return $this->default_form_prop;
    }
    public function TextField($name, $w, $h, $prop = [], $opt = [], $x = NULL, $y = NULL, $js = false)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        if($js) {
            $this->_addfield("text", $name, $x, $y, $w, $h, $prop);
        } else {
            $prop = array_merge($this->getFormDefaultProp(), $prop);
            $popt = TCPDF_STATIC::getAnnotOptFromJSProp($prop, $this->spot_colors, $this->rtl);
            $this->annotation_fonts[$this->CurrentFont["fontkey"]] = $this->CurrentFont["i"];
            $fontstyle = sprintf("/F%d %F Tf %s", $this->CurrentFont["i"], $this->FontSizePt, $this->TextColor);
            $popt["da"] = $fontstyle;
            $popt["ap"] = [];
            $popt["ap"]["n"] = "/Tx BMC q " . $fontstyle . " ";
            $text = "";
            if(isset($prop["value"]) && !empty($prop["value"])) {
                $text = $prop["value"];
            } elseif(isset($opt["v"]) && !empty($opt["v"])) {
                $text = $opt["v"];
            }
            $tmpid = $this->startTemplate($w, $h, false);
            $align = "";
            if(isset($popt["q"])) {
                switch ($popt["q"]) {
                    case 0:
                        $align = "L";
                        break;
                    case 1:
                        $align = "C";
                        break;
                    case 2:
                        $align = "R";
                        break;
                    default:
                        $align = "";
                }
            }
            $this->MultiCell($w, $h, $text, 0, $align, false, 0, 0, 0, true, 0, false, true, 0, "T", false);
            $this->endTemplate();
            --$this->n;
            $popt["ap"]["n"] .= $this->xobjects[$tmpid]["outdata"];
            unset($this->xobjects[$tmpid]);
            $popt["ap"]["n"] .= "Q EMC";
            $opt = array_merge($popt, $opt);
            unset($opt["bs"]);
            $opt["Subtype"] = "Widget";
            $opt["ft"] = "Tx";
            $opt["t"] = $name;
            unset($opt["mk"]["ca"]);
            unset($opt["mk"]["rc"]);
            unset($opt["mk"]["ac"]);
            unset($opt["mk"]["i"]);
            unset($opt["mk"]["ri"]);
            unset($opt["mk"]["ix"]);
            unset($opt["mk"]["if"]);
            unset($opt["mk"]["tp"]);
            $this->Annotation($x, $y, $w, $h, $name, $opt, 0);
            if($this->rtl) {
                $this->x -= $w;
            } else {
                $this->x += $w;
            }
        }
    }
    public function RadioButton($name, $w, $prop = [], $opt = [], $onvalue = "On", $checked = false, $x = NULL, $y = NULL, $js = false)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($w, $x, $y);
        if($js) {
            $this->_addfield("radiobutton", $name, $x, $y, $w, $w, $prop);
        } else {
            if(TCPDF_STATIC::empty_string($onvalue)) {
                $onvalue = "On";
            }
            if($checked) {
                $defval = $onvalue;
            } else {
                $defval = "Off";
            }
            $font = "zapfdingbats";
            if($this->pdfa_mode) {
                $font = "pdfa" . $font;
            }
            $this->AddFont($font);
            $tmpfont = $this->getFontBuffer($font);
            if(!isset($this->radiobutton_groups[$this->page])) {
                $this->radiobutton_groups[$this->page] = [];
            }
            if(!isset($this->radiobutton_groups[$this->page][$name])) {
                $this->radiobutton_groups[$this->page][$name] = [];
                $this->n++;
                $this->radiobutton_groups[$this->page][$name]["n"] = $this->n;
                $this->radio_groups[] = $this->n;
            }
            $kid = $this->n + 1;
            $this->radiobutton_groups[$this->page][$name][] = ["kid" => $kid, "def" => $defval];
            $prop = array_merge($this->getFormDefaultProp(), $prop);
            $prop["NoToggleToOff"] = "true";
            $prop["Radio"] = "true";
            $prop["borderStyle"] = "inset";
            $popt = TCPDF_STATIC::getAnnotOptFromJSProp($prop, $this->spot_colors, $this->rtl);
            $this->annotation_fonts[$tmpfont["fontkey"]] = $tmpfont["i"];
            $fontstyle = sprintf("/F%d %F Tf %s", $tmpfont["i"], $this->FontSizePt, $this->TextColor);
            $popt["da"] = $fontstyle;
            $popt["ap"] = [];
            $popt["ap"]["n"] = [];
            $fx = ($w - $this->getAbsFontMeasure($tmpfont["cw"][108])) / 2 * $this->k;
            $fy = ($w - ($tmpfont["desc"]["Ascent"] - $tmpfont["desc"]["Descent"]) * $this->FontSizePt / 1000 / $this->k) * $this->k;
            $popt["ap"]["n"][$onvalue] = sprintf("q %s BT /F%d %F Tf %F %F Td (" . chr(108) . ") Tj ET Q", $this->TextColor, $tmpfont["i"], $this->FontSizePt, $fx, $fy);
            $popt["ap"]["n"]["Off"] = sprintf("q %s BT /F%d %F Tf %F %F Td (" . chr(109) . ") Tj ET Q", $this->TextColor, $tmpfont["i"], $this->FontSizePt, $fx, $fy);
            if(!isset($popt["mk"])) {
                $popt["mk"] = [];
            }
            $popt["mk"]["ca"] = "(l)";
            $opt = array_merge($popt, $opt);
            $opt["Subtype"] = "Widget";
            $opt["ft"] = "Btn";
            if($checked) {
                $opt["v"] = ["/" . $onvalue];
                $opt["as"] = $onvalue;
            } else {
                $opt["as"] = "Off";
            }
            if(!isset($this->radiobutton_groups[$this->page][$name]["#readonly#"])) {
                $this->radiobutton_groups[$this->page][$name]["#readonly#"] = false;
            }
            $this->radiobutton_groups[$this->page][$name]["#readonly#"] |= $opt["f"] & 64;
            $this->Annotation($x, $y, $w, $w, $name, $opt, 0);
            if($this->rtl) {
                $this->x -= $w;
            } else {
                $this->x += $w;
            }
        }
    }
    public function ListBox($name, $w, $h, $values, $prop = [], $opt = [], $x = NULL, $y = NULL, $js = false)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        if($js) {
            $this->_addfield("listbox", $name, $x, $y, $w, $h, $prop);
            $s = "";
            foreach ($values as $value) {
                if(is_array($value)) {
                    $s .= ",['" . addslashes($value[1]) . "','" . addslashes($value[0]) . "']";
                } else {
                    $s .= ",['" . addslashes($value) . "','" . addslashes($value) . "']";
                }
            }
            $this->javascript .= "f" . $name . ".setItems(" . substr($s, 1) . ");" . "\n";
            return NULL;
        } else {
            $prop = array_merge($this->getFormDefaultProp(), $prop);
            $popt = TCPDF_STATIC::getAnnotOptFromJSProp($prop, $this->spot_colors, $this->rtl);
            $this->annotation_fonts[$this->CurrentFont["fontkey"]] = $this->CurrentFont["i"];
            $fontstyle = sprintf("/F%d %F Tf %s", $this->CurrentFont["i"], $this->FontSizePt, $this->TextColor);
            $popt["da"] = $fontstyle;
            $popt["ap"] = [];
            $popt["ap"]["n"] = "/Tx BMC q " . $fontstyle . " ";
            $text = "";
            foreach ($values as $item) {
                if(is_array($item)) {
                    $text .= $item[1] . "\n";
                } else {
                    $text .= $item . "\n";
                }
            }
            $tmpid = $this->startTemplate($w, $h, false);
            $this->MultiCell($w, $h, $text, 0, "", false, 0, 0, 0, true, 0, false, true, 0, "T", false);
            $this->endTemplate();
            --$this->n;
            $popt["ap"]["n"] .= $this->xobjects[$tmpid]["outdata"];
            unset($this->xobjects[$tmpid]);
            $popt["ap"]["n"] .= "Q EMC";
            $opt = array_merge($popt, $opt);
            $opt["Subtype"] = "Widget";
            $opt["ft"] = "Ch";
            $opt["t"] = $name;
            $opt["opt"] = $values;
            unset($opt["mk"]["ca"]);
            unset($opt["mk"]["rc"]);
            unset($opt["mk"]["ac"]);
            unset($opt["mk"]["i"]);
            unset($opt["mk"]["ri"]);
            unset($opt["mk"]["ix"]);
            unset($opt["mk"]["if"]);
            unset($opt["mk"]["tp"]);
            $this->Annotation($x, $y, $w, $h, $name, $opt, 0);
            if($this->rtl) {
                $this->x -= $w;
            } else {
                $this->x += $w;
            }
        }
    }
    public function ComboBox($name, $w, $h, $values, $prop = [], $opt = [], $x = NULL, $y = NULL, $js = false)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        if($js) {
            $this->_addfield("combobox", $name, $x, $y, $w, $h, $prop);
            $s = "";
            foreach ($values as $value) {
                if(is_array($value)) {
                    $s .= ",['" . addslashes($value[1]) . "','" . addslashes($value[0]) . "']";
                } else {
                    $s .= ",['" . addslashes($value) . "','" . addslashes($value) . "']";
                }
            }
            $this->javascript .= "f" . $name . ".setItems(" . substr($s, 1) . ");" . "\n";
            return NULL;
        } else {
            $prop = array_merge($this->getFormDefaultProp(), $prop);
            $prop["Combo"] = true;
            $popt = TCPDF_STATIC::getAnnotOptFromJSProp($prop, $this->spot_colors, $this->rtl);
            $this->annotation_fonts[$this->CurrentFont["fontkey"]] = $this->CurrentFont["i"];
            $fontstyle = sprintf("/F%d %F Tf %s", $this->CurrentFont["i"], $this->FontSizePt, $this->TextColor);
            $popt["da"] = $fontstyle;
            $popt["ap"] = [];
            $popt["ap"]["n"] = "/Tx BMC q " . $fontstyle . " ";
            $text = "";
            foreach ($values as $item) {
                if(is_array($item)) {
                    $text .= $item[1] . "\n";
                } else {
                    $text .= $item . "\n";
                }
            }
            $tmpid = $this->startTemplate($w, $h, false);
            $this->MultiCell($w, $h, $text, 0, "", false, 0, 0, 0, true, 0, false, true, 0, "T", false);
            $this->endTemplate();
            --$this->n;
            $popt["ap"]["n"] .= $this->xobjects[$tmpid]["outdata"];
            unset($this->xobjects[$tmpid]);
            $popt["ap"]["n"] .= "Q EMC";
            $opt = array_merge($popt, $opt);
            $opt["Subtype"] = "Widget";
            $opt["ft"] = "Ch";
            $opt["t"] = $name;
            $opt["opt"] = $values;
            unset($opt["mk"]["ca"]);
            unset($opt["mk"]["rc"]);
            unset($opt["mk"]["ac"]);
            unset($opt["mk"]["i"]);
            unset($opt["mk"]["ri"]);
            unset($opt["mk"]["ix"]);
            unset($opt["mk"]["if"]);
            unset($opt["mk"]["tp"]);
            $this->Annotation($x, $y, $w, $h, $name, $opt, 0);
            if($this->rtl) {
                $this->x -= $w;
            } else {
                $this->x += $w;
            }
        }
    }
    public function CheckBox($name, $w, $checked = false, $prop = [], $opt = [], $onvalue = "Yes", $x = NULL, $y = NULL, $js = false)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($w, $x, $y);
        if($js) {
            $this->_addfield("checkbox", $name, $x, $y, $w, $w, $prop);
        } else {
            if(!isset($prop["value"])) {
                $prop["value"] = ["Yes"];
            }
            $prop = array_merge($this->getFormDefaultProp(), $prop);
            $prop["borderStyle"] = "inset";
            $popt = TCPDF_STATIC::getAnnotOptFromJSProp($prop, $this->spot_colors, $this->rtl);
            $font = "zapfdingbats";
            if($this->pdfa_mode) {
                $font = "pdfa" . $font;
            }
            $this->AddFont($font);
            $tmpfont = $this->getFontBuffer($font);
            $this->annotation_fonts[$tmpfont["fontkey"]] = $tmpfont["i"];
            $fontstyle = sprintf("/F%d %F Tf %s", $tmpfont["i"], $this->FontSizePt, $this->TextColor);
            $popt["da"] = $fontstyle;
            $popt["ap"] = [];
            $popt["ap"]["n"] = [];
            $fx = ($w - $this->getAbsFontMeasure($tmpfont["cw"][110])) / 2 * $this->k;
            $fy = ($w - ($tmpfont["desc"]["Ascent"] - $tmpfont["desc"]["Descent"]) * $this->FontSizePt / 1000 / $this->k) * $this->k;
            $popt["ap"]["n"]["Yes"] = sprintf("q %s BT /F%d %F Tf %F %F Td (" . chr(110) . ") Tj ET Q", $this->TextColor, $tmpfont["i"], $this->FontSizePt, $fx, $fy);
            $popt["ap"]["n"]["Off"] = sprintf("q %s BT /F%d %F Tf %F %F Td (" . chr(111) . ") Tj ET Q", $this->TextColor, $tmpfont["i"], $this->FontSizePt, $fx, $fy);
            $opt = array_merge($popt, $opt);
            $opt["Subtype"] = "Widget";
            $opt["ft"] = "Btn";
            $opt["t"] = $name;
            if(TCPDF_STATIC::empty_string($onvalue)) {
                $onvalue = "Yes";
            }
            $opt["opt"] = [$onvalue];
            if($checked) {
                $opt["v"] = ["/Yes"];
                $opt["as"] = "Yes";
            } else {
                $opt["v"] = ["/Off"];
                $opt["as"] = "Off";
            }
            $this->Annotation($x, $y, $w, $w, $name, $opt, 0);
            if($this->rtl) {
                $this->x -= $w;
            } else {
                $this->x += $w;
            }
        }
    }
    public function Button($name, $w, $h, $caption, $action, $prop = [], $opt = [], $x = NULL, $y = NULL, $js = false)
    {
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        if($js) {
            $this->_addfield("button", $name, $this->x, $this->y, $w, $h, $prop);
            $this->javascript .= "f" . $name . ".buttonSetCaption('" . addslashes($caption) . "');\n";
            $this->javascript .= "f" . $name . ".setAction('MouseUp','" . addslashes($action) . "');\n";
            $this->javascript .= "f" . $name . ".highlight='push';\n";
            $this->javascript .= "f" . $name . ".print=false;\n";
        } else {
            $prop = array_merge($this->getFormDefaultProp(), $prop);
            $prop["Pushbutton"] = "true";
            $prop["highlight"] = "push";
            $prop["display"] = "display.noPrint";
            $popt = TCPDF_STATIC::getAnnotOptFromJSProp($prop, $this->spot_colors, $this->rtl);
            $this->annotation_fonts[$this->CurrentFont["fontkey"]] = $this->CurrentFont["i"];
            $fontstyle = sprintf("/F%d %F Tf %s", $this->CurrentFont["i"], $this->FontSizePt, $this->TextColor);
            $popt["da"] = $fontstyle;
            $popt["ap"] = [];
            $popt["ap"]["n"] = "/Tx BMC q " . $fontstyle . " ";
            $tmpid = $this->startTemplate($w, $h, false);
            $bw = 2 / $this->k;
            $border = ["L" => ["width" => $bw, "cap" => "square", "join" => "miter", "dash" => 0, "color" => [231]], "R" => ["width" => $bw, "cap" => "square", "join" => "miter", "dash" => 0, "color" => [51]], "T" => ["width" => $bw, "cap" => "square", "join" => "miter", "dash" => 0, "color" => [231]], "B" => ["width" => $bw, "cap" => "square", "join" => "miter", "dash" => 0, "color" => [51]]];
            $this->setFillColor(204);
            $this->Cell($w, $h, $caption, $border, 0, "C", true, "", 1, false, "T", "M");
            $this->endTemplate();
            --$this->n;
            $popt["ap"]["n"] .= $this->xobjects[$tmpid]["outdata"];
            unset($this->xobjects[$tmpid]);
            $popt["ap"]["n"] .= "Q EMC";
            if(!isset($popt["mk"])) {
                $popt["mk"] = [];
            }
            $ann_obj_id = $this->n + 1;
            if(!empty($action) && !is_array($action)) {
                $ann_obj_id = $this->n + 2;
            }
            $popt["mk"]["ca"] = $this->_textstring($caption, $ann_obj_id);
            $popt["mk"]["rc"] = $this->_textstring($caption, $ann_obj_id);
            $popt["mk"]["ac"] = $this->_textstring($caption, $ann_obj_id);
            $opt = array_merge($popt, $opt);
            $opt["Subtype"] = "Widget";
            $opt["ft"] = "Btn";
            $opt["t"] = $caption;
            $opt["v"] = $name;
            if(!empty($action)) {
                if(is_array($action)) {
                    $opt["aa"] = "/D <<";
                    $bmode = ["SubmitForm", "ResetForm", "ImportData"];
                    foreach ($action as $key => $val) {
                        if($key == "S" && in_array($val, $bmode)) {
                            $opt["aa"] .= " /S /" . $val;
                        } elseif($key == "F" && !empty($val)) {
                            $opt["aa"] .= " /F " . $this->_datastring($val, $ann_obj_id);
                        } elseif($key == "Fields" && is_array($val) && !empty($val)) {
                            $opt["aa"] .= " /Fields [";
                            foreach ($val as $field) {
                                $opt["aa"] .= " " . $this->_textstring($field, $ann_obj_id);
                            }
                            $opt["aa"] .= "]";
                        } elseif($key == "Flags") {
                            $ff = 0;
                            if(is_array($val)) {
                                foreach ($val as $flag) {
                                    switch ($flag) {
                                        case "Include/Exclude":
                                            $ff += 1;
                                            break;
                                        case "IncludeNoValueFields":
                                            $ff += 2;
                                            break;
                                        case "ExportFormat":
                                            $ff += 4;
                                            break;
                                        case "GetMethod":
                                            $ff += 8;
                                            break;
                                        case "SubmitCoordinates":
                                            $ff += 16;
                                            break;
                                        case "XFDF":
                                            $ff += 32;
                                            break;
                                        case "IncludeAppendSaves":
                                            $ff += 64;
                                            break;
                                        case "IncludeAnnotations":
                                            $ff += 128;
                                            break;
                                        case "SubmitPDF":
                                            $ff += 256;
                                            break;
                                        case "CanonicalFormat":
                                            $ff += 512;
                                            break;
                                        case "ExclNonUserAnnots":
                                            $ff += 1024;
                                            break;
                                        case "ExclFKey":
                                            $ff += 2048;
                                            break;
                                        case "EmbedForm":
                                            $ff += 8192;
                                            break;
                                    }
                                }
                            } else {
                                $ff = intval($val);
                            }
                            $opt["aa"] .= " /Flags " . $ff;
                        }
                    }
                    $opt["aa"] .= " >>";
                } else {
                    $js_obj_id = $this->addJavascriptObject($action);
                    $opt["aa"] = "/D " . $js_obj_id . " 0 R";
                }
            }
            $this->Annotation($x, $y, $w, $h, $name, $opt, 0);
            if($this->rtl) {
                $this->x -= $w;
            } else {
                $this->x += $w;
            }
        }
    }
    protected function _putsignature()
    {
        if(!$this->sign || !isset($this->signature_data["cert_type"])) {
            return NULL;
        }
        $sigobjid = $this->sig_obj_id + 1;
        $out = $this->_getobj($sigobjid) . "\n";
        $out .= "<< /Type /Sig";
        $out .= " /Filter /Adobe.PPKLite";
        $out .= " /SubFilter /adbe.pkcs7.detached";
        $out .= " " . TCPDF_STATIC::$byterange_string;
        $out .= " /Contents<" . str_repeat("0", $this->signature_max_length) . ">";
        if(empty($this->signature_data["approval"]) || $this->signature_data["approval"] != "A") {
            $out .= " /Reference [";
            $out .= " << /Type /SigRef";
            if(0 < $this->signature_data["cert_type"]) {
                $out .= " /TransformMethod /DocMDP";
                $out .= " /TransformParams <<";
                $out .= " /Type /TransformParams";
                $out .= " /P " . $this->signature_data["cert_type"];
                $out .= " /V /1.2";
            } else {
                $out .= " /TransformMethod /UR3";
                $out .= " /TransformParams <<";
                $out .= " /Type /TransformParams";
                $out .= " /V /2.2";
                if(!TCPDF_STATIC::empty_string($this->ur["document"])) {
                    $out .= " /Document[" . $this->ur["document"] . "]";
                }
                if(!TCPDF_STATIC::empty_string($this->ur["form"])) {
                    $out .= " /Form[" . $this->ur["form"] . "]";
                }
                if(!TCPDF_STATIC::empty_string($this->ur["signature"])) {
                    $out .= " /Signature[" . $this->ur["signature"] . "]";
                }
                if(!TCPDF_STATIC::empty_string($this->ur["annots"])) {
                    $out .= " /Annots[" . $this->ur["annots"] . "]";
                }
                if(!TCPDF_STATIC::empty_string($this->ur["ef"])) {
                    $out .= " /EF[" . $this->ur["ef"] . "]";
                }
                if(!TCPDF_STATIC::empty_string($this->ur["formex"])) {
                    $out .= " /FormEX[" . $this->ur["formex"] . "]";
                }
            }
            $out .= " >>";
            $out .= " >>";
            $out .= " ]";
        }
        if(isset($this->signature_data["info"]["Name"]) && !TCPDF_STATIC::empty_string($this->signature_data["info"]["Name"])) {
            $out .= " /Name " . $this->_textstring($this->signature_data["info"]["Name"], $sigobjid);
        }
        if(isset($this->signature_data["info"]["Location"]) && !TCPDF_STATIC::empty_string($this->signature_data["info"]["Location"])) {
            $out .= " /Location " . $this->_textstring($this->signature_data["info"]["Location"], $sigobjid);
        }
        if(isset($this->signature_data["info"]["Reason"]) && !TCPDF_STATIC::empty_string($this->signature_data["info"]["Reason"])) {
            $out .= " /Reason " . $this->_textstring($this->signature_data["info"]["Reason"], $sigobjid);
        }
        if(isset($this->signature_data["info"]["ContactInfo"]) && !TCPDF_STATIC::empty_string($this->signature_data["info"]["ContactInfo"])) {
            $out .= " /ContactInfo " . $this->_textstring($this->signature_data["info"]["ContactInfo"], $sigobjid);
        }
        $out .= " /M " . $this->_datestring($sigobjid, $this->doc_modification_timestamp);
        $out .= " >>";
        $out .= "\nendobj";
        $this->_out($out);
    }
    public function setUserRights($enable = true, $document = "/FullSave", $annots = "/Create/Delete/Modify/Copy/Import/Export", $form = "/Add/Delete/FillIn/Import/Export/SubmitStandalone/SpawnTemplate", $signature = "/Modify", $ef = "/Create/Delete/Modify/Import", $formex = "")
    {
        $this->ur["enabled"] = $enable;
        $this->ur["document"] = $document;
        $this->ur["annots"] = $annots;
        $this->ur["form"] = $form;
        $this->ur["signature"] = $signature;
        $this->ur["ef"] = $ef;
        $this->ur["formex"] = $formex;
        if(!$this->sign) {
            $this->setSignature("", "", "", "", 0, []);
        }
    }
    public function setSignature($signing_cert = "", $private_key = "", $private_key_password = "", $extracerts = "", $cert_type = 2, $info = [], $approval = "")
    {
        $this->sign = true;
        $this->n++;
        $this->sig_obj_id = $this->n;
        $this->n++;
        $this->signature_data = [];
        if(strlen($signing_cert) == 0) {
            $this->Error("Please provide a certificate file and password!");
        }
        if(strlen($private_key) == 0) {
            $private_key = $signing_cert;
        }
        $this->signature_data["signcert"] = $signing_cert;
        $this->signature_data["privkey"] = $private_key;
        $this->signature_data["password"] = $private_key_password;
        $this->signature_data["extracerts"] = $extracerts;
        $this->signature_data["cert_type"] = $cert_type;
        $this->signature_data["info"] = $info;
        $this->signature_data["approval"] = $approval;
    }
    public function setSignatureAppearance($x = 0, $y = 0, $w = 0, $h = 0, $page = -1, $name = "")
    {
        $this->signature_appearance = $this->getSignatureAppearanceArray($x, $y, $w, $h, $page, $name);
    }
    public function addEmptySignatureAppearance($x = 0, $y = 0, $w = 0, $h = 0, $page = -1, $name = "")
    {
        $this->n++;
        $this->empty_signature_appearance[] = ["objid" => $this->n] + $this->getSignatureAppearanceArray($x, $y, $w, $h, $page, $name);
    }
    protected function getSignatureAppearanceArray($x = 0, $y = 0, $w = 0, $h = 0, $page = -1, $name = "")
    {
        $sigapp = [];
        if($page < 1 || $this->numpages < $page) {
            $sigapp["page"] = $this->page;
        } else {
            $sigapp["page"] = intval($page);
        }
        if(empty($name)) {
            $sigapp["name"] = "Signature";
        } else {
            $sigapp["name"] = $name;
        }
        $a = $x * $this->k;
        $b = $this->pagedim[$sigapp["page"]]["h"] - ($y + $h) * $this->k;
        $c = $w * $this->k;
        $d = $h * $this->k;
        $sigapp["rect"] = sprintf("%F %F %F %F", $a, $b, $a + $c, $b + $d);
        return $sigapp;
    }
    public function setTimeStamp($tsa_host = "", $tsa_username = "", $tsa_password = "", $tsa_cert = "")
    {
        $this->tsa_data = [];
        if(!function_exists("curl_init")) {
            $this->Error("Please enable cURL PHP extension!");
        }
        if(strlen($tsa_host) == 0) {
            $this->Error("Please specify the host of Time Stamping Authority (TSA)!");
        }
        $this->tsa_data["tsa_host"] = $tsa_host;
        if(is_file($tsa_username)) {
            $this->tsa_data["tsa_auth"] = $tsa_username;
        } else {
            $this->tsa_data["tsa_username"] = $tsa_username;
        }
        $this->tsa_data["tsa_password"] = $tsa_password;
        $this->tsa_data["tsa_cert"] = $tsa_cert;
        $this->tsa_timestamp = true;
    }
    protected function applyTSA($signature)
    {
        if(!$this->tsa_timestamp) {
            return $signature;
        }
        return $signature;
    }
    public function startPageGroup($page = NULL)
    {
        if(empty($page)) {
            $page = $this->page + 1;
        }
        $this->newpagegroup[$page] = sizeof($this->newpagegroup) + 1;
    }
    public function setStartingPageNumber($num = 1)
    {
        $this->starting_page_number = max(0, intval($num));
    }
    public function getAliasRightShift()
    {
        $ref = "{" . TCPDF_STATIC::$alias_right_shift . "}{" . TCPDF_STATIC::$alias_tot_pages . "}{" . TCPDF_STATIC::$alias_num_page . "}";
        $rep = str_repeat(" ", $this->GetNumChars($ref));
        $wrep = $this->GetStringWidth($rep);
        if(0 < $wrep) {
            $wdiff = max(1, $this->GetStringWidth($ref) / $wrep);
        } else {
            $wdiff = 1;
        }
        $sdiff = sprintf("%F", $wdiff);
        $alias = TCPDF_STATIC::$alias_right_shift . $sdiff . "}";
        if($this->isUnicodeFont()) {
            $alias = "{" . $alias;
        }
        return $alias;
    }
    public function getAliasNbPages()
    {
        if($this->isUnicodeFont()) {
            return "{" . TCPDF_STATIC::$alias_tot_pages . "}";
        }
        return TCPDF_STATIC::$alias_tot_pages;
    }
    public function getAliasNumPage()
    {
        if($this->isUnicodeFont()) {
            return "{" . TCPDF_STATIC::$alias_num_page . "}";
        }
        return TCPDF_STATIC::$alias_num_page;
    }
    public function getPageGroupAlias()
    {
        if($this->isUnicodeFont()) {
            return "{" . TCPDF_STATIC::$alias_group_tot_pages . "}";
        }
        return TCPDF_STATIC::$alias_group_tot_pages;
    }
    public function getPageNumGroupAlias()
    {
        if($this->isUnicodeFont()) {
            return "{" . TCPDF_STATIC::$alias_group_num_page . "}";
        }
        return TCPDF_STATIC::$alias_group_num_page;
    }
    public function getGroupPageNo()
    {
        return $this->pagegroups[$this->currpagegroup];
    }
    public function getGroupPageNoFormatted()
    {
        return TCPDF_STATIC::formatPageNumber($this->getGroupPageNo());
    }
    public function PageNoFormatted()
    {
        return TCPDF_STATIC::formatPageNumber($this->PageNo());
    }
    protected function _putocg()
    {
        if(empty($this->pdflayers)) {
            return NULL;
        }
        foreach ($this->pdflayers as $key => $layer) {
            $this->pdflayers[$key]["objid"] = $this->_newobj();
            $out = "<< /Type /OCG";
            $out .= " /Name " . $this->_textstring($layer["name"], $this->pdflayers[$key]["objid"]);
            $out .= " /Usage <<";
            if(isset($layer["print"]) && $layer["print"] !== NULL) {
                $out .= " /Print <</PrintState /" . ($layer["print"] ? "ON" : "OFF") . ">>";
            }
            $out .= " /View <</ViewState /" . ($layer["view"] ? "ON" : "OFF") . ">>";
            $out .= " >> >>";
            $out .= "\nendobj";
            $this->_out($out);
        }
    }
    public function startLayer($name = "", $print = true, $view = true, $lock = true)
    {
        if($this->state != 2) {
            return NULL;
        }
        $layer = sprintf("LYR%03d", count($this->pdflayers) + 1);
        if(empty($name)) {
            $name = $layer;
        } else {
            $name = preg_replace("/[^a-zA-Z0-9_\\-]/", "", $name);
        }
        $this->pdflayers[] = ["layer" => $layer, "name" => $name, "print" => $print, "view" => $view, "lock" => $lock];
        $this->openMarkedContent = true;
        $this->_out("/OC /" . $layer . " BDC");
    }
    public function endLayer()
    {
        if($this->state != 2) {
            return NULL;
        }
        if($this->openMarkedContent) {
            $this->_out("EMC");
            $this->openMarkedContent = false;
        }
    }
    public function setVisibility($v)
    {
        if($this->state != 2) {
            return NULL;
        }
        $this->endLayer();
        switch ($v) {
            case "print":
                $this->startLayer("Print", true, false);
                break;
            case "view":
            case "screen":
                $this->startLayer("View", false, true);
                break;
            case "all":
                $this->_out("");
                break;
            default:
                $this->Error("Incorrect visibility: " . $v);
        }
    }
    protected function addExtGState($parms)
    {
        if($this->pdfa_mode || 2 <= $this->pdfa_version) {
            return NULL;
        }
        foreach ($this->extgstates as $i => $ext) {
            if($ext["parms"] == $parms) {
                if($this->inxobj) {
                    $this->xobjects[$this->xobjid]["extgstates"][$i] = $ext;
                }
                return $i;
            }
        }
        $n = count($this->extgstates) + 1;
        $this->extgstates[$n] = ["parms" => $parms];
        if($this->inxobj) {
            $this->xobjects[$this->xobjid]["extgstates"][$n] = $this->extgstates[$n];
        }
        return $n;
    }
    protected function setExtGState($gs)
    {
        if($this->pdfa_mode && $this->pdfa_version < 2 || $this->state != 2) {
            return NULL;
        }
        $this->_out(sprintf("/GS%d gs", $gs));
    }
    protected function _putextgstates()
    {
        foreach ($this->extgstates as $i => $ext) {
            $this->extgstates[$i]["n"] = $this->_newobj();
            $out = "<< /Type /ExtGState";
            foreach ($ext["parms"] as $k => $v) {
                if(is_float($v)) {
                    $v = sprintf("%F", $v);
                } elseif($v === true) {
                    $v = "true";
                } elseif($v === false) {
                    $v = "false";
                }
                $out .= " /" . $k . " " . $v;
            }
            $out .= " >>";
            $out .= "\nendobj";
            $this->_out($out);
        }
    }
    public function setOverprint($stroking = true, $nonstroking = NULL, $mode = 0)
    {
        if($this->state != 2) {
            return NULL;
        }
        $stroking = $stroking ? true : false;
        if(TCPDF_STATIC::empty_string($nonstroking)) {
            $nonstroking = $stroking;
        } else {
            $nonstroking = $nonstroking ? true : false;
        }
        if($mode != 0 && $mode != 1) {
            $mode = 0;
        }
        $this->overprint = ["OP" => $stroking, "op" => $nonstroking, "OPM" => $mode];
        $gs = $this->addExtGState($this->overprint);
        $this->setExtGState($gs);
    }
    public function getOverprint()
    {
        return $this->overprint;
    }
    public function setAlpha($stroking = 1, $bm = "Normal", $nonstroking = NULL, $ais = false)
    {
        if($this->pdfa_mode && $this->pdfa_version < 2) {
            return NULL;
        }
        $stroking = floatval($stroking);
        if(TCPDF_STATIC::empty_string($nonstroking)) {
            $nonstroking = $stroking;
        } else {
            $nonstroking = floatval($nonstroking);
        }
        if($bm[0] == "/") {
            $bm = substr($bm, 1);
        }
        if(!in_array($bm, ["Normal", "Multiply", "Screen", "Overlay", "Darken", "Lighten", "ColorDodge", "ColorBurn", "HardLight", "SoftLight", "Difference", "Exclusion", "Hue", "Saturation", "Color", "Luminosity"])) {
            $bm = "Normal";
        }
        $ais = $ais ? true : false;
        $this->alpha = ["CA" => $stroking, "ca" => $nonstroking, "BM" => "/" . $bm, "AIS" => $ais];
        $gs = $this->addExtGState($this->alpha);
        $this->setExtGState($gs);
    }
    public function getAlpha()
    {
        return $this->alpha;
    }
    public function setJPEGQuality($quality)
    {
        if($quality < 1 || 100 < $quality) {
            $quality = 75;
        }
        $this->jpeg_quality = intval($quality);
    }
    public function setDefaultTableColumns($cols = 4)
    {
        $this->default_table_columns = intval($cols);
    }
    public function setCellHeightRatio($h)
    {
        $this->cell_height_ratio = $h;
    }
    public function getCellHeightRatio()
    {
        return $this->cell_height_ratio;
    }
    public function setPDFVersion($version = "1.7")
    {
        if($this->pdfa_mode && $this->pdfa_version == 1) {
            $this->PDFVersion = "1.4";
        } elseif($this->pdfa_mode && 2 <= $this->pdfa_version) {
            $this->PDFVersion = "1.7";
        } else {
            $this->PDFVersion = $version;
        }
    }
    public function setViewerPreferences($preferences)
    {
        $this->viewer_preferences = $preferences;
    }
    public function colorRegistrationBar($x, $y, $w, $h, $transition = true, $vertical = false, $colors = "A,R,G,B,C,M,Y,K")
    {
        if(strpos($colors, "ALLSPOT") !== false) {
            $spot_colors = "";
            foreach ($this->spot_colors as $spot_color_name => $v) {
                $spot_colors .= "," . $spot_color_name;
            }
            if(!empty($spot_colors)) {
                $spot_colors = substr($spot_colors, 1);
                $colors = str_replace("ALLSPOT", $spot_colors, $colors);
            } else {
                $colors = str_replace("ALLSPOT", "NONE", $colors);
            }
        }
        $bars = explode(",", $colors);
        $numbars = count($bars);
        if($numbars <= 0) {
            return NULL;
        }
        if($vertical) {
            $coords = [0, 0, 0, 1];
            $wb = $w / $numbars;
            $hb = $h;
            $xd = $wb;
            $yd = 0;
        } else {
            $coords = [1, 0, 0, 0];
            $wb = $w;
            $hb = $h / $numbars;
            $xd = 0;
            $yd = $hb;
        }
        $xb = $x;
        $yb = $y;
        foreach ($bars as $col) {
            switch ($col) {
                case "A":
                    $col_a = [255];
                    $col_b = [0];
                    break;
                case "W":
                    $col_a = [0];
                    $col_b = [255];
                    break;
                case "R":
                    $col_a = [255, 255, 255];
                    $col_b = [255, 0, 0];
                    break;
                case "G":
                    $col_a = [255, 255, 255];
                    $col_b = [0, 255, 0];
                    break;
                case "B":
                    $col_a = [255, 255, 255];
                    $col_b = [0, 0, 255];
                    break;
                case "C":
                    $col_a = [0, 0, 0, 0];
                    $col_b = [100, 0, 0, 0];
                    break;
                case "M":
                    $col_a = [0, 0, 0, 0];
                    $col_b = [0, 100, 0, 0];
                    break;
                case "Y":
                    $col_a = [0, 0, 0, 0];
                    $col_b = [0, 0, 100, 0];
                    break;
                case "K":
                    $col_a = [0, 0, 0, 0];
                    $col_b = [0, 0, 0, 100];
                    break;
                case "RGB":
                    $col_a = [255, 255, 255];
                    $col_b = [0, 0, 0];
                    break;
                case "CMYK":
                    $col_a = [0, 0, 0, 0];
                    $col_b = [100, 100, 100, 100];
                    break;
                case "ALL":
                    $col_a = [0, 0, 0, 0, "None"];
                    $col_b = [100, 100, 100, 100, "All"];
                    break;
                case "NONE":
                    $col_a = [0, 0, 0, 0, "None"];
                    $col_b = [0, 0, 0, 0, "None"];
                    break;
                default:
                    $col_a = [0, 0, 0, 0, "None"];
                    $col_b = TCPDF_COLORS::getSpotColor($col, $this->spot_colors);
                    if($col_b === false) {
                        $col_b = [100, 100, 100, 100, "All"];
                    }
                    if($col != "NONE") {
                        if($transition) {
                            $this->LinearGradient($xb, $yb, $wb, $hb, $col_a, $col_b, $coords);
                        } else {
                            $this->setFillColorArray($col_b);
                            $this->Rect($xb, $yb, $wb, $hb, "F", []);
                        }
                        $xb += $xd;
                        $yb += $yd;
                    }
            }
        }
    }
    public function cropMark($x, $y, $w, $h, $type = "T,R,B,L", $color = [100, 100, 100, 100, "All"])
    {
        $this->setLineStyle(["width" => 0 / $this->k, "cap" => "butt", "join" => "miter", "dash" => 0, "color" => $color]);
        $type = strtoupper($type);
        $type = preg_replace("/[^A-Z\\-\\,]*/", "", $type);
        $type = str_replace("-", ",", $type);
        $type = str_replace("TL", "T,L", $type);
        $type = str_replace("TR", "T,R", $type);
        $type = str_replace("BL", "F,L", $type);
        $type = str_replace("BR", "F,R", $type);
        $type = str_replace("A", "T,L", $type);
        $type = str_replace("B", "T,R", $type);
        $type = str_replace("T,RO", "BO", $type);
        $type = str_replace("C", "F,L", $type);
        $type = str_replace("D", "F,R", $type);
        $crops = explode(",", strtoupper($type));
        $crops = array_unique($crops);
        $dw = $w / 4;
        $dh = $h / 4;
        foreach ($crops as $crop) {
            switch ($crop) {
                case "T":
                case "TOP":
                    $x1 = $x;
                    $y1 = $y - $h;
                    $x2 = $x;
                    $y2 = $y - $dh;
                    break;
                case "F":
                case "BOTTOM":
                    $x1 = $x;
                    $y1 = $y + $dh;
                    $x2 = $x;
                    $y2 = $y + $h;
                    break;
                case "L":
                case "LEFT":
                    $x1 = $x - $w;
                    $y1 = $y;
                    $x2 = $x - $dw;
                    $y2 = $y;
                    break;
                case "R":
                case "RIGHT":
                    $x1 = $x + $dw;
                    $y1 = $y;
                    $x2 = $x + $w;
                    $y2 = $y;
                    break;
                default:
                    $this->Line($x1, $y1, $x2, $y2);
            }
        }
    }
    public function registrationMark($x, $y, $r, $double = false, $cola = [100, 100, 100, 100, "All"], $colb = [0, 0, 0, 0, "None"])
    {
        $line_style = ["width" => max(0 / $this->k, $r / 30), "cap" => "butt", "join" => "miter", "dash" => 0, "color" => $cola];
        $this->setFillColorArray($cola);
        $this->PieSector($x, $y, $r, 90, 180, "F");
        $this->PieSector($x, $y, $r, 270, 360, "F");
        $this->Circle($x, $y, $r, 0, 360, "C", $line_style, [], 8);
        if($double) {
            $ri = $r * 0;
            $this->setFillColorArray($colb);
            $this->PieSector($x, $y, $ri, 90, 180, "F");
            $this->PieSector($x, $y, $ri, 270, 360, "F");
            $this->setFillColorArray($cola);
            $this->PieSector($x, $y, $ri, 0, 90, "F");
            $this->PieSector($x, $y, $ri, 180, 270, "F");
            $this->Circle($x, $y, $ri, 0, 360, "C", $line_style, [], 8);
        }
    }
    public function registrationMarkCMYK($x, $y, $r)
    {
        $lw = max(0 / $this->k, $r / 8);
        $ri = $r * 0;
        $re = $r * 0;
        $this->setFillColorArray([100, 0, 0, 0]);
        $this->PieSector($x, $y, $ri, 270, 360, "F");
        $this->setFillColorArray([0, 100, 0, 0]);
        $this->PieSector($x, $y, $ri, 0, 90, "F");
        $this->setFillColorArray([0, 0, 100, 0]);
        $this->PieSector($x, $y, $ri, 90, 180, "F");
        $this->setFillColorArray([0, 0, 0, 100]);
        $this->PieSector($x, $y, $ri, 180, 270, "F");
        $line_style = ["width" => $lw, "cap" => "butt", "join" => "miter", "dash" => 0, "color" => [100, 100, 100, 100, "All"]];
        $this->setFillColorArray([100, 100, 100, 100, "All"]);
        $this->Circle($x, $y, $r, 0, 360, "C", $line_style, [], 8);
        $this->Line($x, $y - $re, $x, $y - $ri);
        $this->Line($x, $y + $ri, $x, $y + $re);
        $this->Line($x - $re, $y, $x - $ri, $y);
        $this->Line($x + $ri, $y, $x + $re, $y);
    }
    public function LinearGradient($x, $y, $w, $h, $col1 = [], $col2 = [], $coords = [0, 0, 1, 0])
    {
        $this->Clip($x, $y, $w, $h);
        $this->Gradient(2, $coords, [["color" => $col1, "offset" => 0, "exponent" => 1], ["color" => $col2, "offset" => 1, "exponent" => 1]], [], false);
    }
    public function RadialGradient($x, $y, $w, $h, $col1 = [], $col2 = [], $coords = [0.5, 0.5, 0.5, 0.5, 1])
    {
        $this->Clip($x, $y, $w, $h);
        $this->Gradient(3, $coords, [["color" => $col1, "offset" => 0, "exponent" => 1], ["color" => $col2, "offset" => 1, "exponent" => 1]], [], false);
    }
    public function CoonsPatchMesh($x, $y, $w, $h, $col1 = [], $col2 = [], $col3 = [], $col4 = [], $coords = [0, 0, 0.33, 0, 0.67, 0, 1, 0, 1, 0.33, 1, 0.67, 1, 1, 0.67, 1, 0.33, 1, 0, 1, 0, 0.67, 0, 0.33], $coords_min = 0, $coords_max = 1, $antialias = false)
    {
        if($this->pdfa_mode && $this->pdfa_version < 2 || $this->state != 2) {
            return NULL;
        }
        $this->Clip($x, $y, $w, $h);
        $n = count($this->gradients) + 1;
        $this->gradients[$n] = [];
        $this->gradients[$n]["type"] = 6;
        $this->gradients[$n]["coords"] = [];
        $this->gradients[$n]["antialias"] = $antialias;
        $this->gradients[$n]["colors"] = [];
        $this->gradients[$n]["transparency"] = false;
        if(!isset($coords[0]["f"])) {
            if(!isset($col1[1])) {
                list($col1[2], $col1[1]) = $col1;
            }
            if(!isset($col2[1])) {
                list($col2[2], $col2[1]) = $col2;
            }
            if(!isset($col3[1])) {
                list($col3[2], $col3[1]) = $col3;
            }
            if(!isset($col4[1])) {
                list($col4[2], $col4[1]) = $col4;
            }
            $patch_array[0]["f"] = 0;
            $patch_array[0]["points"] = $coords;
            list($patch_array[0]["colors"][0]["r"], $patch_array[0]["colors"][0]["g"], $patch_array[0]["colors"][0]["b"]) = $col1;
            list($patch_array[0]["colors"][1]["r"], $patch_array[0]["colors"][1]["g"], $patch_array[0]["colors"][1]["b"]) = $col2;
            list($patch_array[0]["colors"][2]["r"], $patch_array[0]["colors"][2]["g"], $patch_array[0]["colors"][2]["b"]) = $col3;
            list($patch_array[0]["colors"][3]["r"], $patch_array[0]["colors"][3]["g"], $patch_array[0]["colors"][3]["b"]) = $col4;
        } else {
            $patch_array = $coords;
        }
        $bpcd = 65535;
        $this->gradients[$n]["stream"] = "";
        $count_patch = count($patch_array);
        for ($i = 0; $i < $count_patch; $i++) {
            $this->gradients[$n]["stream"] .= chr($patch_array[$i]["f"]);
            $count_points = count($patch_array[$i]["points"]);
            for ($j = 0; $j < $count_points; $j++) {
                $patch_array[$i]["points"][$j] = ($patch_array[$i]["points"][$j] - $coords_min) / ($coords_max - $coords_min) * $bpcd;
                if($patch_array[$i]["points"][$j] < 0) {
                    $patch_array[$i]["points"][$j] = 0;
                }
                if($bpcd < $patch_array[$i]["points"][$j]) {
                    $patch_array[$i]["points"][$j] = $bpcd;
                }
                $this->gradients[$n]["stream"] .= chr((int) floor($patch_array[$i]["points"][$j] / 256));
                $this->gradients[$n]["stream"] .= chr((int) floor(intval($patch_array[$i]["points"][$j]) % 256));
            }
            $count_cols = count($patch_array[$i]["colors"]);
            for ($j = 0; $j < $count_cols; $j++) {
                $this->gradients[$n]["stream"] .= chr($patch_array[$i]["colors"][$j]["r"]);
                $this->gradients[$n]["stream"] .= chr($patch_array[$i]["colors"][$j]["g"]);
                $this->gradients[$n]["stream"] .= chr($patch_array[$i]["colors"][$j]["b"]);
            }
        }
        $this->_out("/Sh" . $n . " sh");
        $this->_outRestoreGraphicsState();
        if($this->inxobj) {
            $this->xobjects[$this->xobjid]["gradients"][$n] = $this->gradients[$n];
        }
    }
    protected function Clip($x, $y, $w, $h)
    {
        if($this->state != 2) {
            return NULL;
        }
        if($this->rtl) {
            $x = $this->w - $x - $w;
        }
        $s = "q";
        $s .= sprintf(" %F %F %F %F re W n", $x * $this->k, ($this->h - $y) * $this->k, $w * $this->k, -1 * $h * $this->k);
        $s .= sprintf(" %F 0 0 %F %F %F cm", $w * $this->k, $h * $this->k, $x * $this->k, ($this->h - ($y + $h)) * $this->k);
        $this->_out($s);
    }
    public function Gradient($type, $coords, $stops, $background = [], $antialias = false)
    {
        if($this->pdfa_mode && $this->pdfa_version < 2 || $this->state != 2) {
            return NULL;
        }
        $n = count($this->gradients) + 1;
        $this->gradients[$n] = [];
        $this->gradients[$n]["type"] = $type;
        $this->gradients[$n]["coords"] = $coords;
        $this->gradients[$n]["antialias"] = $antialias;
        $this->gradients[$n]["colors"] = [];
        $this->gradients[$n]["transparency"] = false;
        $numcolspace = count($stops[0]["color"]);
        $bcolor = array_values($background);
        switch ($numcolspace) {
            case 5:
            case 4:
                $this->gradients[$n]["colspace"] = "DeviceCMYK";
                if(!empty($background)) {
                    $this->gradients[$n]["background"] = sprintf("%F %F %F %F", $bcolor[0] / 100, $bcolor[1] / 100, $bcolor[2] / 100, $bcolor[3] / 100);
                }
                break;
            case 3:
                $this->gradients[$n]["colspace"] = "DeviceRGB";
                if(!empty($background)) {
                    $this->gradients[$n]["background"] = sprintf("%F %F %F", $bcolor[0] / 255, $bcolor[1] / 255, $bcolor[2] / 255);
                }
                break;
            case 1:
                $this->gradients[$n]["colspace"] = "DeviceGray";
                if(!empty($background)) {
                    $this->gradients[$n]["background"] = sprintf("%F", $bcolor[0] / 255);
                }
                break;
            default:
                $num_stops = count($stops);
                $last_stop_id = $num_stops - 1;
                foreach ($stops as $key => $stop) {
                    $this->gradients[$n]["colors"][$key] = [];
                    if(isset($stop["offset"])) {
                        $this->gradients[$n]["colors"][$key]["offset"] = $stop["offset"];
                    } elseif($key == 0) {
                        $this->gradients[$n]["colors"][$key]["offset"] = 0;
                    } elseif($key == $last_stop_id) {
                        $this->gradients[$n]["colors"][$key]["offset"] = 1;
                    } else {
                        $offsetstep = (1 - $this->gradients[$n]["colors"][$key - 1]["offset"]) / ($num_stops - $key);
                        $this->gradients[$n]["colors"][$key]["offset"] = $this->gradients[$n]["colors"][$key - 1]["offset"] + $offsetstep;
                    }
                    if(isset($stop["opacity"])) {
                        $this->gradients[$n]["colors"][$key]["opacity"] = $stop["opacity"];
                        if(!($this->pdfa_mode && $this->pdfa_version < 2) && $stop["opacity"] < 1) {
                            $this->gradients[$n]["transparency"] = true;
                        }
                    } else {
                        $this->gradients[$n]["colors"][$key]["opacity"] = 1;
                    }
                    if(isset($stop["exponent"])) {
                        $this->gradients[$n]["colors"][$key]["exponent"] = $stop["exponent"];
                    } else {
                        $this->gradients[$n]["colors"][$key]["exponent"] = 1;
                    }
                    $color = array_values($stop["color"]);
                    switch ($numcolspace) {
                        case 5:
                        case 4:
                            $this->gradients[$n]["colors"][$key]["color"] = sprintf("%F %F %F %F", $color[0] / 100, $color[1] / 100, $color[2] / 100, $color[3] / 100);
                            break;
                        case 3:
                            $this->gradients[$n]["colors"][$key]["color"] = sprintf("%F %F %F", $color[0] / 255, $color[1] / 255, $color[2] / 255);
                            break;
                        case 1:
                            $this->gradients[$n]["colors"][$key]["color"] = sprintf("%F", $color[0] / 255);
                            break;
                    }
                }
                if($this->gradients[$n]["transparency"]) {
                    $this->_out("/TGS" . $n . " gs");
                }
                $this->_out("/Sh" . $n . " sh");
                $this->_outRestoreGraphicsState();
                if($this->inxobj) {
                    $this->xobjects[$this->xobjid]["gradients"][$n] = $this->gradients[$n];
                }
        }
    }
    public function _putshaders()
    {
        if($this->pdfa_mode && $this->pdfa_version < 2) {
            return NULL;
        }
        $idt = count($this->gradients);
        foreach ($this->gradients as $id => $grad) {
            if($grad["type"] == 2 || $grad["type"] == 3) {
                $fc = $this->_newobj();
                $out = "<<";
                $out .= " /FunctionType 3";
                $out .= " /Domain [0 1]";
                $functions = "";
                $bounds = "";
                $encode = "";
                $i = 1;
                $num_cols = count($grad["colors"]);
                $lastcols = $num_cols - 1;
                for ($i = 1; $i < $num_cols; $i++) {
                    $functions .= $fc + $i . " 0 R ";
                    if($i < $lastcols) {
                        $bounds .= sprintf("%F ", $grad["colors"][$i]["offset"]);
                    }
                    $encode .= "0 1 ";
                }
                $out .= " /Functions [" . trim($functions) . "]";
                $out .= " /Bounds [" . trim($bounds) . "]";
                $out .= " /Encode [" . trim($encode) . "]";
                $out .= " >>";
                $out .= "\nendobj";
                $this->_out($out);
                for ($i = 1; $i < $num_cols; $i++) {
                    $this->_newobj();
                    $out = "<<";
                    $out .= " /FunctionType 2";
                    $out .= " /Domain [0 1]";
                    $out .= " /C0 [" . $grad["colors"][$i - 1]["color"] . "]";
                    $out .= " /C1 [" . $grad["colors"][$i]["color"] . "]";
                    $out .= " /N " . $grad["colors"][$i]["exponent"];
                    $out .= " >>";
                    $out .= "\nendobj";
                    $this->_out($out);
                }
                if($grad["transparency"]) {
                    $ft = $this->_newobj();
                    $out = "<<";
                    $out .= " /FunctionType 3";
                    $out .= " /Domain [0 1]";
                    $functions = "";
                    $i = 1;
                    $num_cols = count($grad["colors"]);
                    for ($i = 1; $i < $num_cols; $i++) {
                        $functions .= $ft + $i . " 0 R ";
                    }
                    $out .= " /Functions [" . trim($functions) . "]";
                    $out .= " /Bounds [" . trim($bounds) . "]";
                    $out .= " /Encode [" . trim($encode) . "]";
                    $out .= " >>";
                    $out .= "\nendobj";
                    $this->_out($out);
                    for ($i = 1; $i < $num_cols; $i++) {
                        $this->_newobj();
                        $out = "<<";
                        $out .= " /FunctionType 2";
                        $out .= " /Domain [0 1]";
                        $out .= " /C0 [" . $grad["colors"][$i - 1]["opacity"] . "]";
                        $out .= " /C1 [" . $grad["colors"][$i]["opacity"] . "]";
                        $out .= " /N " . $grad["colors"][$i]["exponent"];
                        $out .= " >>";
                        $out .= "\nendobj";
                        $this->_out($out);
                    }
                }
            }
            $this->_newobj();
            $out = "<< /ShadingType " . $grad["type"];
            if(isset($grad["colspace"])) {
                $out .= " /ColorSpace /" . $grad["colspace"];
            } else {
                $out .= " /ColorSpace /DeviceRGB";
            }
            if(isset($grad["background"]) && !empty($grad["background"])) {
                $out .= " /Background [" . $grad["background"] . "]";
            }
            if(isset($grad["antialias"]) && $grad["antialias"] === true) {
                $out .= " /AntiAlias true";
            }
            if($grad["type"] == 2) {
                $out .= " " . sprintf("/Coords [%F %F %F %F]", $grad["coords"][0], $grad["coords"][1], $grad["coords"][2], $grad["coords"][3]);
                $out .= " /Domain [0 1]";
                $out .= " /Function " . $fc . " 0 R";
                $out .= " /Extend [true true]";
                $out .= " >>";
            } elseif($grad["type"] == 3) {
                $out .= " " . sprintf("/Coords [%F %F 0 %F %F %F]", $grad["coords"][0], $grad["coords"][1], $grad["coords"][2], $grad["coords"][3], $grad["coords"][4]);
                $out .= " /Domain [0 1]";
                $out .= " /Function " . $fc . " 0 R";
                $out .= " /Extend [true true]";
                $out .= " >>";
            } elseif($grad["type"] == 6) {
                $out .= " /BitsPerCoordinate 16";
                $out .= " /BitsPerComponent 8";
                $out .= " /Decode[0 1 0 1 0 1 0 1 0 1]";
                $out .= " /BitsPerFlag 8";
                $stream = $this->_getrawstream($grad["stream"]);
                $out .= " /Length " . strlen($stream);
                $out .= " >>";
                $out .= " stream\n" . $stream . "\n" . "endstream";
            }
            $out .= "\nendobj";
            $this->_out($out);
            if($grad["transparency"]) {
                $shading_transparency = preg_replace("/\\/ColorSpace \\/[^\\s]+/si", "/ColorSpace /DeviceGray", $out);
                $shading_transparency = preg_replace("/\\/Function [0-9]+ /si", "/Function " . $ft . " ", $shading_transparency);
            }
            $this->gradients[$id]["id"] = $this->n;
            $this->_newobj();
            $out = "<< /Type /Pattern /PatternType 2";
            $out .= " /Shading " . $this->gradients[$id]["id"] . " 0 R";
            $out .= " >>";
            $out .= "\nendobj";
            $this->_out($out);
            $this->gradients[$id]["pattern"] = $this->n;
            if($grad["transparency"]) {
                $idgs = $id + $idt;
                $this->_newobj();
                $this->_out($shading_transparency);
                $this->gradients[$idgs]["id"] = $this->n;
                $this->_newobj();
                $out = "<< /Type /Pattern /PatternType 2";
                $out .= " /Shading " . $this->gradients[$idgs]["id"] . " 0 R";
                $out .= " >>";
                $out .= "\nendobj";
                $this->_out($out);
                $this->gradients[$idgs]["pattern"] = $this->n;
                $oid = $this->_newobj();
                $this->xobjects["LX" . $oid] = ["n" => $oid];
                $filter = "";
                $stream = "q /a0 gs /Pattern cs /p" . $idgs . " scn 0 0 " . $this->wPt . " " . $this->hPt . " re f Q";
                if($this->compress) {
                    $filter = " /Filter /FlateDecode";
                    $stream = gzcompress($stream);
                }
                $stream = $this->_getrawstream($stream);
                $out = "<< /Type /XObject /Subtype /Form /FormType 1" . $filter;
                $out .= " /Length " . strlen($stream);
                $rect = sprintf("%F %F", $this->wPt, $this->hPt);
                $out .= " /BBox [0 0 " . $rect . "]";
                $out .= " /Group << /Type /Group /S /Transparency /CS /DeviceGray >>";
                $out .= " /Resources <<";
                $out .= " /ExtGState << /a0 << /ca 1 /CA 1 >> >>";
                $out .= " /Pattern << /p" . $idgs . " " . $this->gradients[$idgs]["pattern"] . " 0 R >>";
                $out .= " >>";
                $out .= " >> ";
                $out .= " stream\n" . $stream . "\n" . "endstream";
                $out .= "\nendobj";
                $this->_out($out);
                $this->_newobj();
                $out = "<< /Type /Mask /S /Luminosity /G " . ($this->n - 1) . " 0 R >>" . "\n" . "endobj";
                $this->_out($out);
                $this->_newobj();
                $out = "<< /Type /ExtGState /SMask " . ($this->n - 1) . " 0 R /AIS false >>" . "\n" . "endobj";
                $this->_out($out);
                $this->extgstates[] = ["n" => $this->n, "name" => "TGS" . $id];
            }
        }
    }
    public function PieSector($xc, $yc, $r, $a, $b, $style = "FD", $cw = true, $o = 90)
    {
        $this->PieSectorXY($xc, $yc, $r, $r, $a, $b, $style, $cw, $o);
    }
    public function PieSectorXY($xc, $yc, $rx, $ry, $a, $b, $style = "FD", $cw = false, $o = 0, $nc = 2)
    {
        if($this->state != 2) {
            return NULL;
        }
        if($this->rtl) {
            $xc = $this->w - $xc;
        }
        $op = TCPDF_STATIC::getPathPaintOperator($style);
        if($op == "f") {
            $line_style = [];
        }
        if($cw) {
            $d = $b;
            $b = 360 - $a + $o;
            $a = 360 - $d + $o;
        } else {
            $b += $o;
            $a += $o;
        }
        $this->_outellipticalarc($xc, $yc, $rx, $ry, 0, $a, $b, true, $nc);
        $this->_out($op);
    }
    public function ImageEps($file, $x = NULL, $y = NULL, $w = 0, $h = 0, $link = "", $useBoundingBox = true, $align = "", $palign = "", $border = 0, $fitonpage = false, $fixoutvals = false)
    {
        if($this->state != 2) {
            return NULL;
        }
        if($this->rasterize_vector_images && 0 < $w && 0 < $h) {
            return $this->Image($file, $x, $y, $w, $h, "EPS", $link, $align, true, 300, $palign, false, false, $border, false, false, $fitonpage);
        }
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        $k = $this->k;
        if($file[0] === "@") {
            $data = substr($file, 1);
        } else {
            $data = $this->getCachedFileContents($file);
        }
        if($data === false) {
            $this->Error("EPS file not found: " . $file);
        }
        $regs = [];
        preg_match("/%%Creator:([^\r\n]+)/", $data, $regs);
        if(1 < count($regs)) {
            $version_str = trim($regs[1]);
            if(strpos($version_str, "Adobe Illustrator") !== false) {
                $versexp = explode(" ", $version_str);
                $version = (double) array_pop($versexp);
                if(9 <= $version) {
                    $this->Error("This version of Adobe Illustrator file is not supported: " . $file);
                }
            }
        }
        $start = strpos($data, "%!PS-Adobe");
        if(0 < $start) {
            $data = substr($data, $start);
        }
        preg_match("/%%BoundingBox:([^\r\n]+)/", $data, $regs);
        if(1 < count($regs)) {
            list($x1, $y1, $x2, $y2) = explode(" ", trim($regs[1]));
        } else {
            $this->Error("No BoundingBox found in EPS/AI file: " . $file);
        }
        $start = strpos($data, "%%EndSetup");
        if($start === false) {
            $start = strpos($data, "%%EndProlog");
        }
        if($start === false) {
            $start = strpos($data, "%%BoundingBox");
        }
        $data = substr($data, $start);
        $end = strpos($data, "%%PageTrailer");
        if($end === false) {
            $end = strpos($data, "showpage");
        }
        if($end) {
            $data = substr($data, 0, $end);
        }
        if($w <= 0 && $h <= 0) {
            $w = ($x2 - $x1) / $k;
            $h = ($y2 - $y1) / $k;
        } elseif($w <= 0) {
            $w = ($x2 - $x1) / $k * $h / (($y2 - $y1) / $k);
        } elseif($h <= 0) {
            $h = ($y2 - $y1) / $k * $w / (($x2 - $x1) / $k);
        }
        list($w, $h, $x, $y) = $this->fitBlock($w, $h, $x, $y, $fitonpage);
        if($this->rasterize_vector_images) {
            return $this->Image($file, $x, $y, $w, $h, "EPS", $link, $align, true, 300, $palign, false, false, $border, false, false, $fitonpage);
        }
        $scale_x = $w / (($x2 - $x1) / $k);
        $scale_y = $h / (($y2 - $y1) / $k);
        $this->img_rb_y = $y + $h;
        if($this->rtl) {
            if($palign == "L") {
                $ximg = $this->lMargin;
            } elseif($palign == "C") {
                $ximg = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($palign == "R") {
                $ximg = $this->w - $this->rMargin - $w;
            } else {
                $ximg = $x - $w;
            }
            $this->img_rb_x = $ximg;
        } else {
            if($palign == "L") {
                $ximg = $this->lMargin;
            } elseif($palign == "C") {
                $ximg = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($palign == "R") {
                $ximg = $this->w - $this->rMargin - $w;
            } else {
                $ximg = $x;
            }
            $this->img_rb_x = $ximg + $w;
        }
        if($useBoundingBox) {
            $dx = $ximg * $k - $x1;
            $dy = $y * $k - $y1;
        } else {
            $dx = $ximg * $k;
            $dy = $y * $k;
        }
        $this->_out("q" . $this->epsmarker);
        $this->_out(sprintf("%F %F %F %F %F %F cm", 1, 0, 0, 1, $dx, $dy + $this->hPt - 2 * $y * $k - ($y2 - $y1)));
        if(isset($scale_x)) {
            $this->_out(sprintf("%F %F %F %F %F %F cm", $scale_x, 0, 0, $scale_y, $x1 * (1 - $scale_x), $y2 * (1 - $scale_y)));
        }
        $lines = preg_split("/[\\r\\n]+/si", $data, -1, PREG_SPLIT_NO_EMPTY);
        $u = 0;
        $cnt = count($lines);
        for ($i = 0; $i < $cnt; $i++) {
            $line = $lines[$i];
            if($line == "" || $line[0] == "%") {
            } else {
                $len = strlen($line);
                $color_name = "";
                if(strcasecmp("x", substr(trim($line), -1)) == 0 && 0 < preg_match("/\\([^\\)]*\\)/", $line, $matches)) {
                    $color_name = $matches[0];
                    $line = str_replace(" " . $color_name, "", $line);
                    $color_name = substr($color_name, 1, -1);
                }
                $chunks = explode(" ", $line);
                $cmd = trim(array_pop($chunks));
                if($cmd == "Xa" || $cmd == "XA") {
                    $b = array_pop($chunks);
                    $g = array_pop($chunks);
                    $r = array_pop($chunks);
                    $this->_out("" . $r . " " . $g . " " . $b . " " . ($cmd == "Xa" ? "rg" : "RG"));
                } else {
                    $skip = false;
                    if($fixoutvals) {
                        switch ($cmd) {
                            case "m":
                            case "l":
                            case "L":
                                foreach ($chunks as $key => $val) {
                                    if($key % 2 == 0 && ($val < $x1 || $x2 < $val)) {
                                        $skip = true;
                                    } elseif($key % 2 != 0 && ($val < $y1 || $y2 < $val)) {
                                        $skip = true;
                                    }
                                }
                                break;
                            case "m":
                            case "l":
                            case "v":
                            case "y":
                            case "c":
                            case "k":
                            case "K":
                            case "g":
                            case "G":
                            case "s":
                            case "S":
                            case "J":
                            case "j":
                            case "w":
                            case "M":
                            case "d":
                            case "n":
                                if($skip) {
                                } else {
                                    $this->_out($line);
                                }
                                break;
                            case "x":
                                if(empty($color_name)) {
                                    list($col_c, $col_m, $col_y, $col_k) = $chunks;
                                    $this->_out("" . $col_c . " " . $col_m . " " . $col_y . " " . $col_k . " k");
                                } else {
                                    list($col_c, $col_m, $col_y, $col_k, $col_t) = $chunks;
                                    $this->AddSpotColor($color_name, $col_c * 100, $col_m * 100, $col_y * 100, $col_k * 100);
                                    $color_cmd = sprintf("/CS%d cs %F scn", $this->spot_colors[$color_name]["i"], 1 - $col_t);
                                    $this->_out($color_cmd);
                                }
                                break;
                            case "X":
                                if(empty($color_name)) {
                                    list($col_c, $col_m, $col_y, $col_k) = $chunks;
                                    $this->_out("" . $col_c . " " . $col_m . " " . $col_y . " " . $col_k . " K");
                                } else {
                                    list($col_c, $col_m, $col_y, $col_k, $col_t) = $chunks;
                                    $this->AddSpotColor($color_name, $col_c * 100, $col_m * 100, $col_y * 100, $col_k * 100);
                                    $color_cmd = sprintf("/CS%d CS %F SCN", $this->spot_colors[$color_name]["i"], 1 - $col_t);
                                    $this->_out($color_cmd);
                                }
                                break;
                            case "Y":
                            case "N":
                            case "V":
                            case "L":
                            case "C":
                                if($skip) {
                                } else {
                                    $line[$len - 1] = strtolower($cmd);
                                    $this->_out($line);
                                }
                                break;
                            case "b":
                            case "B":
                                $this->_out($cmd . "*");
                                break;
                            case "f":
                            case "F":
                                if(0 < $u) {
                                    $isU = false;
                                    $max = min($i + 5, $cnt);
                                    for ($j = $i + 1; $j < $max; $j++) {
                                        $isU or $isU = $isU || $lines[$j] == "U" || $lines[$j] == "*U";
                                    }
                                    if($isU) {
                                        $this->_out("f*");
                                    }
                                } else {
                                    $this->_out("f*");
                                }
                                break;
                            case "*u":
                                $u++;
                                break;
                            case "*U":
                                --$u;
                                break;
                        }
                    }
                }
            }
        }
        $this->_out($this->epsmarker . "Q");
        if(!empty($border)) {
            $bx = $this->x;
            $by = $this->y;
            $this->x = $ximg;
            if($this->rtl) {
                $this->x += $w;
            }
            $this->y = $y;
            $this->Cell($w, $h, "", $border, 0, "", 0, "", 0, true);
            $this->x = $bx;
            $this->y = $by;
        }
        if($link) {
            $this->Link($ximg, $y, $w, $h, $link, 0);
        }
        switch ($align) {
            case "T":
                $this->y = $y;
                $this->x = $this->img_rb_x;
                break;
            case "M":
                $this->y = $y + round($h / 2);
                $this->x = $this->img_rb_x;
                break;
            case "B":
                $this->y = $this->img_rb_y;
                $this->x = $this->img_rb_x;
                break;
            case "N":
                $this->setY($this->img_rb_y);
                break;
            default:
                $this->endlinex = $this->img_rb_x;
        }
    }
    public function setBarcode($bc = "")
    {
        $this->barcode = $bc;
    }
    public function getBarcode()
    {
        return $this->barcode;
    }
    public function write1DBarcode($code, $type, $x = NULL, $y = NULL, $w = NULL, $h = NULL, $xres = NULL, $style = [], $align = "")
    {
        if(TCPDF_STATIC::empty_string(trim($code))) {
            return NULL;
        }
        require_once dirname(__FILE__) . "/tcpdf_barcodes_1d.php";
        $gvars = $this->getGraphicVars();
        $barcodeobj = new TCPDFBarcode($code, $type);
        $arrcode = $barcodeobj->getBarcodeArray();
        if(empty($arrcode) || $arrcode["maxw"] <= 0) {
            $this->Error("Error in 1D barcode string");
        }
        if($arrcode["maxh"] <= 0) {
            $arrcode["maxh"] = 1;
        }
        if(!isset($style["position"])) {
            $style["position"] = "";
        } elseif($style["position"] == "S") {
            $style["position"] = "";
            $style["stretch"] = true;
        }
        if(!isset($style["fitwidth"])) {
            if(!isset($style["stretch"])) {
                $style["fitwidth"] = true;
            } else {
                $style["fitwidth"] = false;
            }
        }
        if($style["fitwidth"]) {
            $style["stretch"] = false;
        }
        if(!isset($style["stretch"])) {
            if($w === "" || $w <= 0) {
                $style["stretch"] = false;
            } else {
                $style["stretch"] = true;
            }
        }
        if(!isset($style["fgcolor"])) {
            $style["fgcolor"] = [0, 0, 0];
        }
        if(!isset($style["bgcolor"])) {
            $style["bgcolor"] = false;
        }
        if(!isset($style["border"])) {
            $style["border"] = false;
        }
        $fontsize = 0;
        if(!isset($style["text"])) {
            $style["text"] = false;
        }
        if($style["text"] && isset($style["font"])) {
            if(isset($style["fontsize"])) {
                $fontsize = $style["fontsize"];
            }
            $this->setFont($style["font"], "", $fontsize);
        }
        if(!isset($style["stretchtext"])) {
            $style["stretchtext"] = 4;
        }
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        if(TCPDF_STATIC::empty_string($w) || $w <= 0) {
            if($this->rtl) {
                $w = $x - $this->lMargin;
            } else {
                $w = $this->w - $this->rMargin - $x;
            }
        }
        if(!isset($style["padding"])) {
            $padding = 0;
        } elseif($style["padding"] === "auto") {
            $padding = 10 * $w / ($arrcode["maxw"] + 20);
        } else {
            $padding = floatval($style["padding"]);
        }
        if(!isset($style["hpadding"])) {
            $hpadding = $padding;
        } elseif($style["hpadding"] === "auto") {
            $hpadding = 10 * $w / ($arrcode["maxw"] + 20);
        } else {
            $hpadding = floatval($style["hpadding"]);
        }
        if(!isset($style["vpadding"])) {
            $vpadding = $padding;
        } elseif($style["vpadding"] === "auto") {
            $vpadding = $hpadding / 2;
        } else {
            $vpadding = floatval($style["vpadding"]);
        }
        $max_xres = ($w - 2 * $hpadding) / $arrcode["maxw"];
        if($style["stretch"]) {
            $xres = $max_xres;
        } else {
            if(TCPDF_STATIC::empty_string($xres)) {
                $xres = 0 * $this->k;
            }
            if($max_xres < $xres) {
                $xres = $max_xres;
            }
            if(isset($style["padding"]) && $style["padding"] === "auto" || isset($style["hpadding"]) && $style["hpadding"] === "auto") {
                $hpadding = 10 * $xres;
                if(isset($style["vpadding"]) && $style["vpadding"] === "auto") {
                    $vpadding = $hpadding / 2;
                }
            }
        }
        if($style["fitwidth"]) {
            $wold = $w;
            $w = $arrcode["maxw"] * $xres + 2 * $hpadding;
            if(isset($style["cellfitalign"])) {
                switch ($style["cellfitalign"]) {
                    case "L":
                        if($this->rtl) {
                            $x -= $wold - $w;
                        }
                        break;
                    case "R":
                        if(!$this->rtl) {
                            $x += $wold - $w;
                        }
                        break;
                    case "C":
                        if($this->rtl) {
                            $x -= ($wold - $w) / 2;
                        } else {
                            $x += ($wold - $w) / 2;
                        }
                        break;
                }
            }
        }
        $text_height = $this->getCellHeight($fontsize / $this->k);
        if(TCPDF_STATIC::empty_string($h) || $h <= 0) {
            $h = $arrcode["maxw"] * $xres / 3 + 2 * $vpadding + $text_height;
        }
        $barh = $h - $text_height - 2 * $vpadding;
        if($barh <= 0) {
            if($h < $text_height) {
                $fontsize = $h * $this->k / (4 * $this->cell_height_ratio);
                $text_height = $this->getCellHeight($fontsize / $this->k);
                $this->setFont($style["font"], "", $fontsize);
            }
            if(0 < $vpadding) {
                $vpadding = ($h - $text_height) / 4;
            }
            $barh = $h - $text_height - 2 * $vpadding;
        }
        list($w, $h, $x, $y) = $this->fitBlock($w, $h, $x, $y, false);
        $this->img_rb_y = $y + $h;
        if($this->rtl) {
            if($style["position"] == "L") {
                $xpos = $this->lMargin;
            } elseif($style["position"] == "C") {
                $xpos = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($style["position"] == "R") {
                $xpos = $this->w - $this->rMargin - $w;
            } else {
                $xpos = $x - $w;
            }
            $this->img_rb_x = $xpos;
        } else {
            if($style["position"] == "L") {
                $xpos = $this->lMargin;
            } elseif($style["position"] == "C") {
                $xpos = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($style["position"] == "R") {
                $xpos = $this->w - $this->rMargin - $w;
            } else {
                $xpos = $x;
            }
            $this->img_rb_x = $xpos + $w;
        }
        $xpos_rect = $xpos;
        if(!isset($style["align"])) {
            $style["align"] = "C";
        }
        switch ($style["align"]) {
            case "L":
                $xpos = $xpos_rect + $hpadding;
                break;
            case "R":
                $xpos = $xpos_rect + $w - $arrcode["maxw"] * $xres - $hpadding;
                break;
            case "C":
            default:
                $xpos = $xpos_rect + ($w - $arrcode["maxw"] * $xres) / 2;
                $xpos_text = $xpos;
                $tempRTL = $this->rtl;
                $this->rtl = false;
                if($style["bgcolor"]) {
                    $this->Rect($xpos_rect, $y, $w, $h, $style["border"] ? "DF" : "F", "", $style["bgcolor"]);
                } elseif($style["border"]) {
                    $this->Rect($xpos_rect, $y, $w, $h, "D");
                }
                $this->setDrawColorArray($style["fgcolor"]);
                $this->setTextColorArray($style["fgcolor"]);
                foreach ($arrcode["bcode"] as $k => $v) {
                    $bw = $v["w"] * $xres;
                    if($v["t"]) {
                        $ypos = $y + $vpadding + $v["p"] * $barh / $arrcode["maxh"];
                        $this->Rect($xpos, $ypos, $bw, $v["h"] * $barh / $arrcode["maxh"], "F", [], $style["fgcolor"]);
                    }
                    $xpos += $bw;
                }
                if($style["text"]) {
                    if(isset($style["label"]) && !TCPDF_STATIC::empty_string($style["label"])) {
                        $label = $style["label"];
                    } else {
                        $label = $code;
                    }
                    $txtwidth = $arrcode["maxw"] * $xres;
                    if($txtwidth < $this->GetStringWidth($label)) {
                        $style["stretchtext"] = 2;
                    }
                    $this->x = $xpos_text;
                    $this->y = $y + $vpadding + $barh;
                    $cellpadding = $this->cell_padding;
                    $this->setCellPadding(0);
                    $this->Cell($txtwidth, 0, $label, 0, 0, "C", false, "", $style["stretchtext"], false, "T", "T");
                    $this->cell_padding = $cellpadding;
                }
                $this->rtl = $tempRTL;
                $this->setGraphicVars($gvars);
                switch ($align) {
                    case "T":
                        $this->y = $y;
                        $this->x = $this->img_rb_x;
                        break;
                    case "M":
                        $this->y = $y + round($h / 2);
                        $this->x = $this->img_rb_x;
                        break;
                    case "B":
                        $this->y = $this->img_rb_y;
                        $this->x = $this->img_rb_x;
                        break;
                    case "N":
                        $this->setY($this->img_rb_y);
                        break;
                    default:
                        $this->endlinex = $this->img_rb_x;
                }
        }
    }
    public function write2DBarcode($code, $type, $x = NULL, $y = NULL, $w = NULL, $h = NULL, $style = [], $align = "", $distort = false)
    {
        if(TCPDF_STATIC::empty_string(trim($code))) {
            return NULL;
        }
        require_once dirname(__FILE__) . "/tcpdf_barcodes_2d.php";
        $gvars = $this->getGraphicVars();
        $barcodeobj = new TCPDF2DBarcode($code, $type);
        $arrcode = $barcodeobj->getBarcodeArray();
        if(empty($arrcode) || !isset($arrcode["num_rows"]) || $arrcode["num_rows"] == 0 || !isset($arrcode["num_cols"]) || $arrcode["num_cols"] == 0) {
            $this->Error("Error in 2D barcode string");
        }
        if(!isset($style["position"])) {
            $style["position"] = "";
        }
        if(!isset($style["fgcolor"])) {
            $style["fgcolor"] = [0, 0, 0];
        }
        if(!isset($style["bgcolor"])) {
            $style["bgcolor"] = false;
        }
        if(!isset($style["border"])) {
            $style["border"] = false;
        }
        if(!isset($style["padding"])) {
            $style["padding"] = 0;
        } elseif($style["padding"] === "auto") {
            $style["padding"] = 4;
        }
        if(!isset($style["hpadding"])) {
            $style["hpadding"] = $style["padding"];
        } elseif($style["hpadding"] === "auto") {
            $style["hpadding"] = 4;
        }
        if(!isset($style["vpadding"])) {
            $style["vpadding"] = $style["padding"];
        } elseif($style["vpadding"] === "auto") {
            $style["vpadding"] = 4;
        }
        $hpad = 2 * $style["hpadding"];
        $vpad = 2 * $style["vpadding"];
        if(!isset($style["module_width"])) {
            $style["module_width"] = 1;
        }
        if(!isset($style["module_height"])) {
            $style["module_height"] = 1;
        }
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        $rows = $arrcode["num_rows"];
        $cols = $arrcode["num_cols"];
        if($rows <= 0 || $cols <= 0) {
            $this->Error("Error in 2D barcode string");
        }
        $mw = $style["module_width"];
        $mh = $style["module_height"];
        if($mw <= 0 || $mh <= 0) {
            $this->Error("Error in 2D barcode string");
        }
        if($this->rtl) {
            $maxw = $x - $this->lMargin;
        } else {
            $maxw = $this->w - $this->rMargin - $x;
        }
        $maxh = $this->h - $this->tMargin - $this->bMargin;
        $ratioHW = ($rows * $mh + $hpad) / ($cols * $mw + $vpad);
        $ratioWH = ($cols * $mw + $vpad) / ($rows * $mh + $hpad);
        if(!$distort) {
            if($maxh < $maxw * $ratioHW) {
                $maxw = $maxh * $ratioWH;
            }
            if($maxw < $maxh * $ratioWH) {
                $maxh = $maxw * $ratioHW;
            }
        }
        if($maxw < $w) {
            $w = $maxw;
        }
        if($maxh < $h) {
            $h = $maxh;
        }
        if((TCPDF_STATIC::empty_string($w) || $w <= 0) && (TCPDF_STATIC::empty_string($h) || $h <= 0)) {
            $w = ($cols + $hpad) * $mw / $this->k;
            $h = ($rows + $vpad) * $mh / $this->k;
        } elseif($w === "" || $w <= 0) {
            $w = $h * $ratioWH;
        } elseif($h === "" || $h <= 0) {
            $h = $w * $ratioHW;
        }
        $bw = $w * $cols / ($cols + $hpad);
        $bh = $h * $rows / ($rows + $vpad);
        $cw = $bw / $cols;
        $ch = $bh / $rows;
        if(!$distort) {
            if($mw / $mh < $cw / $ch) {
                $cw = $ch * $mw / $mh;
                $bw = $cw * $cols;
                $style["hpadding"] = ($w - $bw) / (2 * $cw);
            } else {
                $ch = $cw * $mh / $mw;
                $bh = $ch * $rows;
                $style["vpadding"] = ($h - $bh) / (2 * $ch);
            }
        }
        list($w, $h, $x, $y) = $this->fitBlock($w, $h, $x, $y, false);
        $this->img_rb_y = $y + $h;
        if($this->rtl) {
            if($style["position"] == "L") {
                $xpos = $this->lMargin;
            } elseif($style["position"] == "C") {
                $xpos = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($style["position"] == "R") {
                $xpos = $this->w - $this->rMargin - $w;
            } else {
                $xpos = $x - $w;
            }
            $this->img_rb_x = $xpos;
        } else {
            if($style["position"] == "L") {
                $xpos = $this->lMargin;
            } elseif($style["position"] == "C") {
                $xpos = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($style["position"] == "R") {
                $xpos = $this->w - $this->rMargin - $w;
            } else {
                $xpos = $x;
            }
            $this->img_rb_x = $xpos + $w;
        }
        $xstart = $xpos + $style["hpadding"] * $cw;
        $ystart = $y + $style["vpadding"] * $ch;
        $tempRTL = $this->rtl;
        $this->rtl = false;
        if($style["bgcolor"]) {
            $this->Rect($xpos, $y, $w, $h, $style["border"] ? "DF" : "F", "", $style["bgcolor"]);
        } elseif($style["border"]) {
            $this->Rect($xpos, $y, $w, $h, "D");
        }
        $this->setDrawColorArray($style["fgcolor"]);
        for ($r = 0; $r < $rows; $r++) {
            $xr = $xstart;
            for ($c = 0; $c < $cols; $c++) {
                if($arrcode["bcode"][$r][$c] == 1) {
                    $this->Rect($xr, $ystart, $cw, $ch, "F", [], $style["fgcolor"]);
                }
                $xr += $cw;
            }
            $ystart += $ch;
        }
        $this->rtl = $tempRTL;
        $this->setGraphicVars($gvars);
        switch ($align) {
            case "T":
                $this->y = $y;
                $this->x = $this->img_rb_x;
                break;
            case "M":
                $this->y = $y + round($h / 2);
                $this->x = $this->img_rb_x;
                break;
            case "B":
                $this->y = $this->img_rb_y;
                $this->x = $this->img_rb_x;
                break;
            case "N":
                $this->setY($this->img_rb_y);
                break;
            default:
                $this->endlinex = $this->img_rb_x;
        }
    }
    public function getMargins()
    {
        $ret = ["left" => $this->lMargin, "right" => $this->rMargin, "top" => $this->tMargin, "bottom" => $this->bMargin, "header" => $this->header_margin, "footer" => $this->footer_margin, "cell" => $this->cell_padding, "padding_left" => $this->cell_padding["L"], "padding_top" => $this->cell_padding["T"], "padding_right" => $this->cell_padding["R"], "padding_bottom" => $this->cell_padding["B"]];
        return $ret;
    }
    public function getOriginalMargins()
    {
        $ret = ["left" => $this->original_lMargin, "right" => $this->original_rMargin];
        return $ret;
    }
    public function getFontSize()
    {
        return $this->FontSize;
    }
    public function getFontSizePt()
    {
        return $this->FontSizePt;
    }
    public function getFontFamily()
    {
        return $this->FontFamily;
    }
    public function getFontStyle()
    {
        return $this->FontStyle;
    }
    public function fixHTMLCode($html, $default_css = "", $tagvs = NULL, $tidy_options = NULL)
    {
        return TCPDF_STATIC::fixHTMLCode($html, $default_css, $tagvs, $tidy_options, $this->tagvspaces);
    }
    protected function getCSSBorderWidth($width)
    {
        if($width == "thin") {
            $width = 2 / $this->k;
        } elseif($width == "medium") {
            $width = 4 / $this->k;
        } elseif($width == "thick") {
            $width = 6 / $this->k;
        } else {
            $width = $this->getHTMLUnitToUnits($width, 1, "px", false);
        }
        return $width;
    }
    protected function getCSSBorderDashStyle($style)
    {
        strtolower($style);
        switch (strtolower($style)) {
            case "none":
            case "hidden":
                $dash = -1;
                break;
            case "dotted":
                $dash = 1;
                break;
            case "dashed":
                $dash = 3;
                break;
            case "double":
            case "groove":
            case "ridge":
            case "inset":
            case "outset":
            case "solid":
            default:
                $dash = 0;
                return $dash;
        }
    }
    protected function getCSSBorderStyle($cssborder)
    {
        $bprop = preg_split("/[\\s]+/", trim($cssborder));
        $count = count($bprop);
        if(0 < $count && $bprop[$count - 1] === "!important") {
            unset($bprop[$count - 1]);
            --$count;
        }
        $border = [];
        switch ($count) {
            case 2:
                $width = "medium";
                list($style, $color) = $bprop;
                break;
            case 1:
                $width = "medium";
                $style = $bprop[0];
                $color = "black";
                break;
            case 0:
                $width = "medium";
                $style = "solid";
                $color = "black";
                break;
            default:
                list($width, $style, $color) = $bprop;
                if($style == "none") {
                    return [];
                }
                $border["cap"] = "square";
                $border["join"] = "miter";
                $border["dash"] = $this->getCSSBorderDashStyle($style);
                if($border["dash"] < 0) {
                    return [];
                }
                $border["width"] = $this->getCSSBorderWidth($width);
                $border["color"] = TCPDF_COLORS::convertHTMLColorToDec($color, $this->spot_colors);
                return $border;
        }
    }
    public function getCSSPadding($csspadding, $width = 0)
    {
        $padding = preg_split("/[\\s]+/", trim($csspadding));
        $cell_padding = [];
        count($padding);
        switch (count($padding)) {
            case 4:
                list($cell_padding["T"], $cell_padding["R"], $cell_padding["B"], $cell_padding["L"]) = $padding;
                break;
            case 3:
                $cell_padding["T"] = $padding[0];
                $cell_padding["R"] = $padding[1];
                $cell_padding["B"] = $padding[2];
                $cell_padding["L"] = $padding[1];
                break;
            case 2:
                $cell_padding["T"] = $padding[0];
                $cell_padding["R"] = $padding[1];
                $cell_padding["B"] = $padding[0];
                $cell_padding["L"] = $padding[1];
                break;
            case 1:
                $cell_padding["T"] = $padding[0];
                $cell_padding["R"] = $padding[0];
                $cell_padding["B"] = $padding[0];
                $cell_padding["L"] = $padding[0];
                if($width == 0) {
                    $width = $this->w - $this->lMargin - $this->rMargin;
                }
                $cell_padding["T"] = $this->getHTMLUnitToUnits($cell_padding["T"], $width, "px", false);
                $cell_padding["R"] = $this->getHTMLUnitToUnits($cell_padding["R"], $width, "px", false);
                $cell_padding["B"] = $this->getHTMLUnitToUnits($cell_padding["B"], $width, "px", false);
                $cell_padding["L"] = $this->getHTMLUnitToUnits($cell_padding["L"], $width, "px", false);
                return $cell_padding;
                break;
            default:
                return $this->cell_padding;
        }
    }
    public function getCSSMargin($cssmargin, $width = 0)
    {
        $margin = preg_split("/[\\s]+/", trim($cssmargin));
        $cell_margin = [];
        count($margin);
        switch (count($margin)) {
            case 4:
                list($cell_margin["T"], $cell_margin["R"], $cell_margin["B"], $cell_margin["L"]) = $margin;
                break;
            case 3:
                $cell_margin["T"] = $margin[0];
                $cell_margin["R"] = $margin[1];
                $cell_margin["B"] = $margin[2];
                $cell_margin["L"] = $margin[1];
                break;
            case 2:
                $cell_margin["T"] = $margin[0];
                $cell_margin["R"] = $margin[1];
                $cell_margin["B"] = $margin[0];
                $cell_margin["L"] = $margin[1];
                break;
            case 1:
                $cell_margin["T"] = $margin[0];
                $cell_margin["R"] = $margin[0];
                $cell_margin["B"] = $margin[0];
                $cell_margin["L"] = $margin[0];
                if($width == 0) {
                    $width = $this->w - $this->lMargin - $this->rMargin;
                }
                $cell_margin["T"] = $this->getHTMLUnitToUnits(str_replace("auto", "0", $cell_margin["T"]), $width, "px", false);
                $cell_margin["R"] = $this->getHTMLUnitToUnits(str_replace("auto", "0", $cell_margin["R"]), $width, "px", false);
                $cell_margin["B"] = $this->getHTMLUnitToUnits(str_replace("auto", "0", $cell_margin["B"]), $width, "px", false);
                $cell_margin["L"] = $this->getHTMLUnitToUnits(str_replace("auto", "0", $cell_margin["L"]), $width, "px", false);
                return $cell_margin;
                break;
            default:
                return $this->cell_margin;
        }
    }
    public function getCSSBorderMargin($cssbspace, $width = 0)
    {
        $space = preg_split("/[\\s]+/", trim($cssbspace));
        $border_spacing = [];
        count($space);
        switch (count($space)) {
            case 2:
                list($border_spacing["H"], $border_spacing["V"]) = $space;
                break;
            case 1:
                $border_spacing["H"] = $space[0];
                $border_spacing["V"] = $space[0];
                if($width == 0) {
                    $width = $this->w - $this->lMargin - $this->rMargin;
                }
                $border_spacing["H"] = $this->getHTMLUnitToUnits($border_spacing["H"], $width, "px", false);
                $border_spacing["V"] = $this->getHTMLUnitToUnits($border_spacing["V"], $width, "px", false);
                return $border_spacing;
                break;
            default:
                return ["H" => 0, "V" => 0];
        }
    }
    protected function getCSSFontSpacing($spacing, $parent = 0)
    {
        $val = 0;
        $spacing = trim($spacing);
        switch ($spacing) {
            case "normal":
                $val = 0;
                break;
            case "inherit":
                if($parent == "normal") {
                    $val = 0;
                } else {
                    $val = $parent;
                }
                break;
            default:
                $val = $this->getHTMLUnitToUnits($spacing, 0, "px", false);
                return $val;
        }
    }
    protected function getCSSFontStretching($stretch, $parent = 100)
    {
        $val = 100;
        $stretch = trim($stretch);
        switch ($stretch) {
            case "ultra-condensed":
                $val = 40;
                break;
            case "extra-condensed":
                $val = 55;
                break;
            case "condensed":
                $val = 70;
                break;
            case "semi-condensed":
                $val = 85;
                break;
            case "normal":
                $val = 100;
                break;
            case "semi-expanded":
                $val = 115;
                break;
            case "expanded":
                $val = 130;
                break;
            case "extra-expanded":
                $val = 145;
                break;
            case "ultra-expanded":
                $val = 160;
                break;
            case "wider":
                $val = $parent + 10;
                break;
            case "narrower":
                $val = $parent - 10;
                break;
            case "inherit":
                if($parent == "normal") {
                    $val = 100;
                } else {
                    $val = $parent;
                }
                break;
            default:
                $val = $this->getHTMLUnitToUnits($stretch, 100, "%", false);
                return $val;
        }
    }
    public function getHTMLFontUnits($val, $refsize = 12, $parent_size = 12, $defaultunit = "pt")
    {
        $refsize = TCPDF_FONTS::getFontRefSize($refsize);
        $parent_size = TCPDF_FONTS::getFontRefSize($parent_size, $refsize);
        switch ($val) {
            case "xx-small":
                $size = $refsize - 4;
                break;
            case "x-small":
                $size = $refsize - 3;
                break;
            case "small":
                $size = $refsize - 2;
                break;
            case "medium":
                $size = $refsize;
                break;
            case "large":
                $size = $refsize + 2;
                break;
            case "x-large":
                $size = $refsize + 4;
                break;
            case "xx-large":
                $size = $refsize + 6;
                break;
            case "smaller":
                $size = $parent_size - 3;
                break;
            case "larger":
                $size = $parent_size + 3;
                break;
            default:
                $size = $this->getHTMLUnitToUnits($val, $parent_size, $defaultunit, true);
                return $size;
        }
    }
    protected function getHtmlDomArray($html)
    {
        $css = [];
        $matches = [];
        if(0 < preg_match_all("/<cssarray>([^\\<]*?)<\\/cssarray>/is", $html, $matches)) {
            if(isset($matches[1][0])) {
                $css = array_merge($css, json_decode($this->unhtmlentities($matches[1][0]), true));
            }
            $html = preg_replace("/<cssarray>(.*?)<\\/cssarray>/is", "", $html);
        }
        $matches = [];
        if(0 < preg_match_all("/<link([^\\>]*?)>/is", $html, $matches)) {
            foreach ($matches[1] as $key => $link) {
                $type = [];
                if(preg_match("/type[\\s]*=[\\s]*\"text\\/css\"/", $link, $type)) {
                    $type = [];
                    preg_match("/media[\\s]*=[\\s]*\"([^\"]*)\"/", $link, $type);
                    if(empty($type) || isset($type[1]) && ($type[1] == "all" || $type[1] == "print")) {
                        $type = [];
                        if(0 < preg_match("/href[\\s]*=[\\s]*\"([^\"]*)\"/", $link, $type)) {
                            $cssdata = $this->getCachedFileContents(trim($type[1]));
                            if($cssdata !== false && 0 < strlen($cssdata)) {
                                $css = array_merge($css, TCPDF_STATIC::extractCSSproperties($cssdata));
                            }
                        }
                    }
                }
            }
        }
        $matches = [];
        if(0 < preg_match_all("/<style([^\\>]*?)>([^\\<]*?)<\\/style>/is", $html, $matches)) {
            foreach ($matches[1] as $key => $media) {
                $type = [];
                preg_match("/media[\\s]*=[\\s]*\"([^\"]*)\"/", $media, $type);
                if(empty($type) || isset($type[1]) && ($type[1] == "all" || $type[1] == "print")) {
                    $cssdata = $matches[2][$key];
                    $css = array_merge($css, TCPDF_STATIC::extractCSSproperties($cssdata));
                }
            }
        }
        $csstagarray = "<cssarray>" . htmlentities(json_encode($css)) . "</cssarray>";
        $html = preg_replace("/<head([^\\>]*?)>(.*?)<\\/head>/is", "", $html);
        $html = preg_replace("/<style([^\\>]*?)>([^\\<]*?)<\\/style>/is", "", $html);
        $blocktags = ["blockquote", "br", "dd", "dl", "div", "dt", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "li", "ol", "p", "pre", "ul", "tcpdf", "table", "tr", "td"];
        $selfclosingtags = ["area", "base", "basefont", "br", "hr", "input", "img", "link", "meta"];
        $html = strip_tags($html, "<marker/><a><b><blockquote><body><br><br/><dd><del><div><dl><dt><em><font><form><h1><h2><h3><h4><h5><h6><hr><hr/><i><img><input><label><li><ol><option><p><pre><s><select><small><span><strike><strong><sub><sup><table><tablehead><tcpdf><td><textarea><th><thead><tr><tt><u><ul>");
        $html = preg_replace("/<pre/", "<xre", $html);
        $html = preg_replace("/<(table|tr|td|th|tcpdf|blockquote|dd|div|dl|dt|form|h1|h2|h3|h4|h5|h6|br|hr|li|ol|ul|p)([^\\>]*)>[\\n\\r\\t]+/", "<\\1\\2>", $html);
        $html = preg_replace("@(\\r\\n|\\r)@", "\n", $html);
        $repTable = ["\t" => " ", "\0" => " ", "\v" => " ", "\\" => "\\\\"];
        $html = strtr($html, $repTable);
        $offset = 0;
        while ($offset < strlen($html) && ($pos = strpos($html, "</pre>", $offset)) !== false) {
            $html_a = substr($html, 0, $offset);
            $html_b = substr($html, $offset, $pos - $offset + 6);
            while (preg_match("'<xre([^\\>]*)>(.*?)\n(.*?)</pre>'si", $html_b)) {
                $html_b = preg_replace("'<xre([^\\>]*)>(.*?)\n(.*?)</pre>'si", "<xre\\1>\\2<br />\\3</pre>", $html_b);
            }
            while (preg_match("'<xre([^\\>]*)>(.*?)" . $this->re_space["p"] . "(.*?)</pre>'" . $this->re_space["m"], $html_b)) {
                $html_b = preg_replace("'<xre([^\\>]*)>(.*?)" . $this->re_space["p"] . "(.*?)</pre>'" . $this->re_space["m"], "<xre\\1>\\2&nbsp;\\3</pre>", $html_b);
            }
            $html = $html_a . $html_b . substr($html, $pos + 6);
            $offset = strlen($html_a . $html_b);
        }
        $offset = 0;
        while ($offset < strlen($html) && ($pos = strpos($html, "</textarea>", $offset)) !== false) {
            $html_a = substr($html, 0, $offset);
            $html_b = substr($html, $offset, $pos - $offset + 11);
            while (preg_match("'<textarea([^\\>]*)>(.*?)\n(.*?)</textarea>'si", $html_b)) {
                $html_b = preg_replace("'<textarea([^\\>]*)>(.*?)\n(.*?)</textarea>'si", "<textarea\\1>\\2<TBR>\\3</textarea>", $html_b);
                $html_b = preg_replace("'<textarea([^\\>]*)>(.*?)[\"](.*?)</textarea>'si", "<textarea\\1>\\2''\\3</textarea>", $html_b);
            }
            $html = $html_a . $html_b . substr($html, $pos + 11);
            $offset = strlen($html_a . $html_b);
        }
        $html = preg_replace("/([\\s]*)<option/si", "<option", $html);
        $html = preg_replace("/<\\/option>([\\s]*)/si", "</option>", $html);
        $offset = 0;
        while ($offset < strlen($html) && ($pos = strpos($html, "</option>", $offset)) !== false) {
            $html_a = substr($html, 0, $offset);
            $html_b = substr($html, $offset, $pos - $offset + 9);
            while (preg_match("'<option([^\\>]*)>(.*?)</option>'si", $html_b)) {
                $html_b = preg_replace("'<option([\\s]+)value=\"([^\"]*)\"([^\\>]*)>(.*?)</option>'si", "\\2#!TaB!#\\4#!NwL!#", $html_b);
                $html_b = preg_replace("'<option([^\\>]*)>(.*?)</option>'si", "\\2#!NwL!#", $html_b);
            }
            $html = $html_a . $html_b . substr($html, $pos + 9);
            $offset = strlen($html_a . $html_b);
        }
        if(preg_match("'</select'si", $html)) {
            $html = preg_replace("'<select([^\\>]*)>'si", "<select\\1 opt=\"", $html);
            $html = preg_replace("'#!NwL!#</select>'si", "\" />", $html);
        }
        $html = str_replace("\n", " ", $html);
        $html = str_replace("<TBR>", "\n", $html);
        $html = preg_replace("/[\\s]+<\\/(table|tr|ul|ol|dl)>/", "</\\1>", $html);
        $html = preg_replace("/" . $this->re_space["p"] . "+<\\/(td|th|li|dt|dd)>/" . $this->re_space["m"], "</\\1>", $html);
        $html = preg_replace("/[\\s]+<(tr|td|th|li|dt|dd)/", "<\\1", $html);
        $html = preg_replace("/" . $this->re_space["p"] . "+<(ul|ol|dl|br)/" . $this->re_space["m"], "<\\1", $html);
        $html = preg_replace("/<\\/(table|tr|td|th|blockquote|dd|dt|dl|div|dt|h1|h2|h3|h4|h5|h6|hr|li|ol|ul|p)>[\\s]+</", "</\\1><", $html);
        $html = preg_replace("/<\\/(td|th)>/", "<marker style=\"font-size:0\"/></\\1>", $html);
        $html = preg_replace("/<\\/table>([\\s]*)<marker style=\"font-size:0\"\\/>/", "</table>", $html);
        $html = preg_replace("/" . $this->re_space["p"] . "+<img/" . $this->re_space["m"], chr(32) . "<img", $html);
        $html = preg_replace("/<img([^\\>]*)>[\\s]+([^\\<])/xi", "<img\\1>&nbsp;\\2", $html);
        $html = preg_replace("/<img([^\\>]*)>/xi", "<img\\1><span><marker style=\"font-size:0\"/></span>", $html);
        $html = preg_replace("/<xre/", "<pre", $html);
        $html = preg_replace("/<textarea([^\\>]*)>([^\\<]*)<\\/textarea>/xi", "<textarea\\1 value=\"\\2\" />", $html);
        $html = preg_replace("/<li([^\\>]*)><\\/li>/", "<li\\1>&nbsp;</li>", $html);
        $html = preg_replace("/<li([^\\>]*)>" . $this->re_space["p"] . "*<img/" . $this->re_space["m"], "<li\\1><font size=\"1\">&nbsp;</font><img", $html);
        $html = preg_replace("/<([^\\>\\/]*)>[\\s]/", "<\\1>&nbsp;", $html);
        $html = preg_replace("/[\\s]<\\/([^\\>]*)>/", "&nbsp;</\\1>", $html);
        $html = preg_replace("/<su([bp])/", "<zws/><su\\1", $html);
        $html = preg_replace("/<\\/su([bp])>/", "</su\\1><zws/>", $html);
        $html = preg_replace("/" . $this->re_space["p"] . "+/" . $this->re_space["m"], chr(32), $html);
        $html = $this->stringTrim($html);
        $html = preg_replace("/<li><br([^\\>]*)>/", "<li> <br\\1>", $html);
        $html = preg_replace("/^<img/", "<span style=\"font-size:0\"><br /></span> <img", $html, 1);
        $tagpattern = "/(<[^>]+>)/";
        $a = preg_split($tagpattern, $html, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);
        $maxel = count($a);
        $elkey = 0;
        $key = 0;
        $dom = [];
        $dom[$key] = [];
        $dom[$key]["tag"] = false;
        $dom[$key]["block"] = false;
        $dom[$key]["value"] = "";
        $dom[$key]["parent"] = 0;
        $dom[$key]["hide"] = false;
        $dom[$key]["fontname"] = $this->FontFamily;
        $dom[$key]["fontstyle"] = $this->FontStyle;
        $dom[$key]["fontsize"] = $this->FontSizePt;
        $dom[$key]["font-stretch"] = $this->font_stretching;
        $dom[$key]["letter-spacing"] = $this->font_spacing;
        $dom[$key]["stroke"] = $this->textstrokewidth;
        $dom[$key]["fill"] = $this->textrendermode % 2 == 0;
        $dom[$key]["clip"] = 3 < $this->textrendermode;
        $dom[$key]["line-height"] = $this->cell_height_ratio;
        $dom[$key]["bgcolor"] = false;
        $dom[$key]["fgcolor"] = $this->fgcolor;
        $dom[$key]["strokecolor"] = $this->strokecolor;
        $dom[$key]["align"] = "";
        $dom[$key]["listtype"] = "";
        $dom[$key]["text-indent"] = 0;
        $dom[$key]["text-transform"] = "";
        $dom[$key]["border"] = [];
        $dom[$key]["dir"] = $this->rtl ? "rtl" : "ltr";
        $thead = false;
        $key++;
        $level = [];
        array_push($level, 0);
        while ($elkey < $maxel) {
            $dom[$key] = [];
            $element = $a[$elkey];
            $dom[$key]["elkey"] = $elkey;
            if(preg_match($tagpattern, $element)) {
                $element = substr($element, 1, -1);
                preg_match("/[\\/]?([a-zA-Z0-9]*)/", $element, $tag);
                $tagname = strtolower($tag[1]);
                if($tagname == "thead") {
                    if($element[0] == "/") {
                        $thead = false;
                    } else {
                        $thead = true;
                    }
                    $elkey++;
                } else {
                    $dom[$key]["tag"] = true;
                    $dom[$key]["value"] = $tagname;
                    if(in_array($dom[$key]["value"], $blocktags)) {
                        $dom[$key]["block"] = true;
                    } else {
                        $dom[$key]["block"] = false;
                    }
                    if($element[0] == "/") {
                        $dom[$key]["opening"] = false;
                        $dom[$key]["parent"] = end($level);
                        array_pop($level);
                        $dom[$key]["hide"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["hide"];
                        $dom[$key]["fontname"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fontname"];
                        $dom[$key]["fontstyle"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fontstyle"];
                        $dom[$key]["fontsize"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fontsize"];
                        $dom[$key]["font-stretch"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["font-stretch"];
                        $dom[$key]["letter-spacing"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["letter-spacing"];
                        $dom[$key]["stroke"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["stroke"];
                        $dom[$key]["fill"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fill"];
                        $dom[$key]["clip"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["clip"];
                        $dom[$key]["line-height"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["line-height"];
                        $dom[$key]["bgcolor"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["bgcolor"];
                        $dom[$key]["fgcolor"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["fgcolor"];
                        $dom[$key]["strokecolor"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["strokecolor"];
                        $dom[$key]["align"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["align"];
                        $dom[$key]["text-transform"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["text-transform"];
                        $dom[$key]["dir"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["dir"];
                        if(isset($dom[$dom[$dom[$key]["parent"]]["parent"]]["listtype"])) {
                            $dom[$key]["listtype"] = $dom[$dom[$dom[$key]["parent"]]["parent"]]["listtype"];
                        }
                        if($dom[$key]["value"] == "tr" && !isset($dom[$dom[$dom[$key]["parent"]]["parent"]]["cols"])) {
                            $dom[$dom[$dom[$key]["parent"]]["parent"]]["cols"] = $dom[$dom[$key]["parent"]]["cols"];
                        }
                        if($dom[$key]["value"] == "td" || $dom[$key]["value"] == "th") {
                            $dom[$dom[$key]["parent"]]["content"] = $csstagarray;
                            for ($i = $dom[$key]["parent"] + 1; $i < $key; $i++) {
                                $dom[$dom[$key]["parent"]]["content"] .= stripslashes($a[$dom[$i]["elkey"]]);
                            }
                            $key = $i;
                            $dom[$dom[$key]["parent"]]["content"] = str_replace("<table", "<table nested=\"true\"", $dom[$dom[$key]["parent"]]["content"]);
                            $dom[$dom[$key]["parent"]]["content"] = str_replace("<thead>", "", $dom[$dom[$key]["parent"]]["content"]);
                            $dom[$dom[$key]["parent"]]["content"] = str_replace("</thead>", "", $dom[$dom[$key]["parent"]]["content"]);
                        }
                        if($dom[$key]["value"] === "tr" && !empty($dom[$dom[$key]["parent"]]["thead"]) && $dom[$dom[$key]["parent"]]["thead"] === true) {
                            if(TCPDF_STATIC::empty_string($dom[$dom[$dom[$key]["parent"]]["parent"]]["thead"])) {
                                $dom[$dom[$dom[$key]["parent"]]["parent"]]["thead"] = $csstagarray . $a[$dom[$dom[$dom[$key]["parent"]]["parent"]]["elkey"]];
                            }
                            for ($i = $dom[$key]["parent"]; $i <= $key; $i++) {
                                $dom[$dom[$dom[$key]["parent"]]["parent"]]["thead"] .= $a[$dom[$i]["elkey"]];
                            }
                            if(!isset($dom[$dom[$key]["parent"]]["attribute"])) {
                                $dom[$dom[$key]["parent"]]["attribute"] = [];
                            }
                            $dom[$dom[$key]["parent"]]["attribute"]["nobr"] = "true";
                        }
                        if($dom[$key]["value"] == "table" && !TCPDF_STATIC::empty_string($dom[$dom[$key]["parent"]]["thead"])) {
                            $dom[$dom[$key]["parent"]]["thead"] = str_replace(" nobr=\"true\"", "", $dom[$dom[$key]["parent"]]["thead"]);
                            $dom[$dom[$key]["parent"]]["thead"] .= "</tablehead>";
                        }
                    } else {
                        $dom[$key]["opening"] = true;
                        $dom[$key]["parent"] = end($level);
                        if(substr($element, -1, 1) == "/" || in_array($dom[$key]["value"], $selfclosingtags)) {
                            $dom[$key]["self"] = true;
                        } else {
                            array_push($level, $key);
                            $dom[$key]["self"] = false;
                        }
                        $parentkey = 0;
                        if(0 < $key) {
                            $parentkey = $dom[$key]["parent"];
                            $dom[$key]["hide"] = $dom[$parentkey]["hide"];
                            $dom[$key]["fontname"] = $dom[$parentkey]["fontname"];
                            $dom[$key]["fontstyle"] = $dom[$parentkey]["fontstyle"];
                            $dom[$key]["fontsize"] = $dom[$parentkey]["fontsize"];
                            $dom[$key]["font-stretch"] = $dom[$parentkey]["font-stretch"];
                            $dom[$key]["letter-spacing"] = $dom[$parentkey]["letter-spacing"];
                            $dom[$key]["stroke"] = $dom[$parentkey]["stroke"];
                            $dom[$key]["fill"] = $dom[$parentkey]["fill"];
                            $dom[$key]["clip"] = $dom[$parentkey]["clip"];
                            $dom[$key]["line-height"] = $dom[$parentkey]["line-height"];
                            $dom[$key]["bgcolor"] = $dom[$parentkey]["bgcolor"];
                            $dom[$key]["fgcolor"] = $dom[$parentkey]["fgcolor"];
                            $dom[$key]["strokecolor"] = $dom[$parentkey]["strokecolor"];
                            $dom[$key]["align"] = $dom[$parentkey]["align"];
                            $dom[$key]["listtype"] = $dom[$parentkey]["listtype"];
                            $dom[$key]["text-indent"] = $dom[$parentkey]["text-indent"];
                            $dom[$key]["text-transform"] = $dom[$parentkey]["text-transform"];
                            $dom[$key]["border"] = [];
                            $dom[$key]["dir"] = $dom[$parentkey]["dir"];
                        }
                        preg_match_all("/([^=\\s]*)[\\s]*=[\\s]*\"([^\"]*)\"/", $element, $attr_array, PREG_PATTERN_ORDER);
                        $dom[$key]["attribute"] = [];
                        foreach ($attr_array[1] as $id => $name) {
                            $dom[$key]["attribute"][strtolower($name)] = $attr_array[2][$id];
                        }
                        if(!empty($css)) {
                            list($dom[$key]["csssel"], $dom[$key]["cssdata"]) = TCPDF_STATIC::getCSSdataArray($dom, $key, $css);
                            $dom[$key]["attribute"]["style"] = TCPDF_STATIC::getTagStyleFromCSSarray($dom[$key]["cssdata"]);
                        }
                        if(isset($dom[$key]["attribute"]["style"]) && !empty($dom[$key]["attribute"]["style"])) {
                            preg_match_all("/([^;:\\s]*):([^;]*)/", $dom[$key]["attribute"]["style"], $style_array, PREG_PATTERN_ORDER);
                            $dom[$key]["style"] = [];
                            foreach ($style_array[1] as $id => $name) {
                                $dom[$key]["style"][strtolower($name)] = trim($style_array[2][$id]);
                            }
                            if(isset($dom[$key]["style"]["direction"])) {
                                $dom[$key]["dir"] = $dom[$key]["style"]["direction"];
                            }
                            if(isset($dom[$key]["style"]["display"])) {
                                $dom[$key]["hide"] = trim(strtolower($dom[$key]["style"]["display"])) == "none";
                            }
                            if(isset($dom[$key]["style"]["font-family"])) {
                                $dom[$key]["fontname"] = $this->getFontFamilyName($dom[$key]["style"]["font-family"]);
                            }
                            if(isset($dom[$key]["style"]["list-style-type"])) {
                                $dom[$key]["listtype"] = trim(strtolower($dom[$key]["style"]["list-style-type"]));
                                if($dom[$key]["listtype"] == "inherit") {
                                    $dom[$key]["listtype"] = $dom[$parentkey]["listtype"];
                                }
                            }
                            if(isset($dom[$key]["style"]["text-indent"])) {
                                $dom[$key]["text-indent"] = $this->getHTMLUnitToUnits($dom[$key]["style"]["text-indent"]);
                                if($dom[$key]["text-indent"] == "inherit") {
                                    $dom[$key]["text-indent"] = $dom[$parentkey]["text-indent"];
                                }
                            }
                            if(isset($dom[$key]["style"]["text-transform"])) {
                                $dom[$key]["text-transform"] = $dom[$key]["style"]["text-transform"];
                            }
                            if(isset($dom[$key]["style"]["font-size"])) {
                                $fsize = trim($dom[$key]["style"]["font-size"]);
                                $dom[$key]["fontsize"] = $this->getHTMLFontUnits($fsize, $dom[0]["fontsize"], $dom[$parentkey]["fontsize"], "pt");
                            }
                            if(isset($dom[$key]["style"]["font-stretch"])) {
                                $dom[$key]["font-stretch"] = $this->getCSSFontStretching($dom[$key]["style"]["font-stretch"], $dom[$parentkey]["font-stretch"]);
                            }
                            if(isset($dom[$key]["style"]["letter-spacing"])) {
                                $dom[$key]["letter-spacing"] = $this->getCSSFontSpacing($dom[$key]["style"]["letter-spacing"], $dom[$parentkey]["letter-spacing"]);
                            }
                            if(isset($dom[$key]["style"]["line-height"])) {
                                $lineheight = trim($dom[$key]["style"]["line-height"]);
                                switch ($lineheight) {
                                    case "normal":
                                        $dom[$key]["line-height"] = $dom[0]["line-height"];
                                        break;
                                    case "inherit":
                                        $dom[$key]["line-height"] = $dom[$parentkey]["line-height"];
                                        break;
                                    default:
                                        if(is_numeric($lineheight)) {
                                            $lineheight = $lineheight * 100 . "%";
                                        }
                                        $dom[$key]["line-height"] = $this->getHTMLUnitToUnits($lineheight, 1, "%", true);
                                        if(substr($lineheight, -1) !== "%") {
                                            if($dom[$key]["fontsize"] <= 0) {
                                                $dom[$key]["line-height"] = 1;
                                            } else {
                                                $dom[$key]["line-height"] = ($dom[$key]["line-height"] - $this->cell_padding["T"] - $this->cell_padding["B"]) / $dom[$key]["fontsize"];
                                            }
                                        }
                                }
                            }
                            if(isset($dom[$key]["style"]["font-weight"])) {
                                if(strtolower($dom[$key]["style"]["font-weight"][0]) == "n") {
                                    if(strpos($dom[$key]["fontstyle"], "B") !== false) {
                                        $dom[$key]["fontstyle"] = str_replace("B", "", $dom[$key]["fontstyle"]);
                                    }
                                } elseif(strtolower($dom[$key]["style"]["font-weight"][0]) == "b") {
                                    $dom[$key]["fontstyle"] .= "B";
                                }
                            }
                            if(isset($dom[$key]["style"]["font-style"]) && strtolower($dom[$key]["style"]["font-style"][0]) == "i") {
                                $dom[$key]["fontstyle"] .= "I";
                            }
                            if(isset($dom[$key]["style"]["color"]) && !TCPDF_STATIC::empty_string($dom[$key]["style"]["color"])) {
                                $dom[$key]["fgcolor"] = TCPDF_COLORS::convertHTMLColorToDec($dom[$key]["style"]["color"], $this->spot_colors);
                            } elseif($dom[$key]["value"] == "a") {
                                $dom[$key]["fgcolor"] = $this->htmlLinkColorArray;
                            }
                            if(isset($dom[$key]["style"]["background-color"]) && !TCPDF_STATIC::empty_string($dom[$key]["style"]["background-color"])) {
                                $dom[$key]["bgcolor"] = TCPDF_COLORS::convertHTMLColorToDec($dom[$key]["style"]["background-color"], $this->spot_colors);
                            }
                            if(isset($dom[$key]["style"]["text-decoration"])) {
                                $decors = explode(" ", strtolower($dom[$key]["style"]["text-decoration"]));
                                foreach ($decors as $dec) {
                                    $dec = trim($dec);
                                    if(!TCPDF_STATIC::empty_string($dec)) {
                                        if($dec[0] == "u") {
                                            $dom[$key]["fontstyle"] .= "U";
                                        } elseif($dec[0] == "l") {
                                            $dom[$key]["fontstyle"] .= "D";
                                        } elseif($dec[0] == "o") {
                                            $dom[$key]["fontstyle"] .= "O";
                                        }
                                    }
                                }
                            } elseif($dom[$key]["value"] == "a") {
                                $dom[$key]["fontstyle"] = $this->htmlLinkFontStyle;
                            }
                            if(isset($dom[$key]["style"]["width"])) {
                                $dom[$key]["width"] = $dom[$key]["style"]["width"];
                            }
                            if(isset($dom[$key]["style"]["height"])) {
                                $dom[$key]["height"] = $dom[$key]["style"]["height"];
                            }
                            if(isset($dom[$key]["style"]["text-align"])) {
                                $dom[$key]["align"] = strtoupper($dom[$key]["style"]["text-align"][0]);
                            }
                            if(isset($dom[$key]["style"]["border"])) {
                                $borderstyle = $this->getCSSBorderStyle($dom[$key]["style"]["border"]);
                                if(!empty($borderstyle)) {
                                    $dom[$key]["border"]["LTRB"] = $borderstyle;
                                }
                            }
                            if(isset($dom[$key]["style"]["border-color"])) {
                                $brd_colors = preg_split("/[\\s]+/", trim($dom[$key]["style"]["border-color"]));
                                if(isset($brd_colors[3])) {
                                    $dom[$key]["border"]["L"]["color"] = TCPDF_COLORS::convertHTMLColorToDec($brd_colors[3], $this->spot_colors);
                                }
                                if(isset($brd_colors[1])) {
                                    $dom[$key]["border"]["R"]["color"] = TCPDF_COLORS::convertHTMLColorToDec($brd_colors[1], $this->spot_colors);
                                }
                                if(isset($brd_colors[0])) {
                                    $dom[$key]["border"]["T"]["color"] = TCPDF_COLORS::convertHTMLColorToDec($brd_colors[0], $this->spot_colors);
                                }
                                if(isset($brd_colors[2])) {
                                    $dom[$key]["border"]["B"]["color"] = TCPDF_COLORS::convertHTMLColorToDec($brd_colors[2], $this->spot_colors);
                                }
                            }
                            if(isset($dom[$key]["style"]["border-width"])) {
                                $brd_widths = preg_split("/[\\s]+/", trim($dom[$key]["style"]["border-width"]));
                                if(isset($brd_widths[3])) {
                                    $dom[$key]["border"]["L"]["width"] = $this->getCSSBorderWidth($brd_widths[3]);
                                }
                                if(isset($brd_widths[1])) {
                                    $dom[$key]["border"]["R"]["width"] = $this->getCSSBorderWidth($brd_widths[1]);
                                }
                                if(isset($brd_widths[0])) {
                                    $dom[$key]["border"]["T"]["width"] = $this->getCSSBorderWidth($brd_widths[0]);
                                }
                                if(isset($brd_widths[2])) {
                                    $dom[$key]["border"]["B"]["width"] = $this->getCSSBorderWidth($brd_widths[2]);
                                }
                            }
                            if(isset($dom[$key]["style"]["border-style"])) {
                                $brd_styles = preg_split("/[\\s]+/", trim($dom[$key]["style"]["border-style"]));
                                if(isset($brd_styles[3]) && $brd_styles[3] != "none") {
                                    $dom[$key]["border"]["L"]["cap"] = "square";
                                    $dom[$key]["border"]["L"]["join"] = "miter";
                                    $dom[$key]["border"]["L"]["dash"] = $this->getCSSBorderDashStyle($brd_styles[3]);
                                    if($dom[$key]["border"]["L"]["dash"] < 0) {
                                        $dom[$key]["border"]["L"] = [];
                                    }
                                }
                                if(isset($brd_styles[1])) {
                                    $dom[$key]["border"]["R"]["cap"] = "square";
                                    $dom[$key]["border"]["R"]["join"] = "miter";
                                    $dom[$key]["border"]["R"]["dash"] = $this->getCSSBorderDashStyle($brd_styles[1]);
                                    if($dom[$key]["border"]["R"]["dash"] < 0) {
                                        $dom[$key]["border"]["R"] = [];
                                    }
                                }
                                if(isset($brd_styles[0])) {
                                    $dom[$key]["border"]["T"]["cap"] = "square";
                                    $dom[$key]["border"]["T"]["join"] = "miter";
                                    $dom[$key]["border"]["T"]["dash"] = $this->getCSSBorderDashStyle($brd_styles[0]);
                                    if($dom[$key]["border"]["T"]["dash"] < 0) {
                                        $dom[$key]["border"]["T"] = [];
                                    }
                                }
                                if(isset($brd_styles[2])) {
                                    $dom[$key]["border"]["B"]["cap"] = "square";
                                    $dom[$key]["border"]["B"]["join"] = "miter";
                                    $dom[$key]["border"]["B"]["dash"] = $this->getCSSBorderDashStyle($brd_styles[2]);
                                    if($dom[$key]["border"]["B"]["dash"] < 0) {
                                        $dom[$key]["border"]["B"] = [];
                                    }
                                }
                            }
                            $cellside = ["L" => "left", "R" => "right", "T" => "top", "B" => "bottom"];
                            foreach ($cellside as $bsk => $bsv) {
                                if(isset($dom[$key]["style"]["border-" . $bsv])) {
                                    $borderstyle = $this->getCSSBorderStyle($dom[$key]["style"]["border-" . $bsv]);
                                    if(!empty($borderstyle)) {
                                        $dom[$key]["border"][$bsk] = $borderstyle;
                                    }
                                }
                                if(isset($dom[$key]["style"]["border-" . $bsv . "-color"])) {
                                    $dom[$key]["border"][$bsk]["color"] = TCPDF_COLORS::convertHTMLColorToDec($dom[$key]["style"]["border-" . $bsv . "-color"], $this->spot_colors);
                                }
                                if(isset($dom[$key]["style"]["border-" . $bsv . "-width"])) {
                                    $dom[$key]["border"][$bsk]["width"] = $this->getCSSBorderWidth($dom[$key]["style"]["border-" . $bsv . "-width"]);
                                }
                                if(isset($dom[$key]["style"]["border-" . $bsv . "-style"])) {
                                    $dom[$key]["border"][$bsk]["dash"] = $this->getCSSBorderDashStyle($dom[$key]["style"]["border-" . $bsv . "-style"]);
                                    if($dom[$key]["border"][$bsk]["dash"] < 0) {
                                        $dom[$key]["border"][$bsk] = [];
                                    }
                                }
                            }
                            if(isset($dom[$key]["style"]["padding"])) {
                                $dom[$key]["padding"] = $this->getCSSPadding($dom[$key]["style"]["padding"]);
                            } else {
                                $dom[$key]["padding"] = $this->cell_padding;
                            }
                            foreach ($cellside as $psk => $psv) {
                                if(isset($dom[$key]["style"]["padding-" . $psv])) {
                                    $dom[$key]["padding"][$psk] = $this->getHTMLUnitToUnits($dom[$key]["style"]["padding-" . $psv], 0, "px", false);
                                }
                            }
                            if(isset($dom[$key]["style"]["margin"])) {
                                $dom[$key]["margin"] = $this->getCSSMargin($dom[$key]["style"]["margin"]);
                            } else {
                                $dom[$key]["margin"] = $this->cell_margin;
                            }
                            foreach ($cellside as $psk => $psv) {
                                if(isset($dom[$key]["style"]["margin-" . $psv])) {
                                    $dom[$key]["margin"][$psk] = $this->getHTMLUnitToUnits(str_replace("auto", "0", $dom[$key]["style"]["margin-" . $psv]), 0, "px", false);
                                }
                            }
                            if(isset($dom[$key]["style"]["border-spacing"])) {
                                $dom[$key]["border-spacing"] = $this->getCSSBorderMargin($dom[$key]["style"]["border-spacing"]);
                            }
                            if(isset($dom[$key]["style"]["page-break-inside"]) && $dom[$key]["style"]["page-break-inside"] == "avoid") {
                                $dom[$key]["attribute"]["nobr"] = "true";
                            }
                            if(isset($dom[$key]["style"]["page-break-before"])) {
                                if($dom[$key]["style"]["page-break-before"] == "always") {
                                    $dom[$key]["attribute"]["pagebreak"] = "true";
                                } elseif($dom[$key]["style"]["page-break-before"] == "left") {
                                    $dom[$key]["attribute"]["pagebreak"] = "left";
                                } elseif($dom[$key]["style"]["page-break-before"] == "right") {
                                    $dom[$key]["attribute"]["pagebreak"] = "right";
                                }
                            }
                            if(isset($dom[$key]["style"]["page-break-after"])) {
                                if($dom[$key]["style"]["page-break-after"] == "always") {
                                    $dom[$key]["attribute"]["pagebreakafter"] = "true";
                                } elseif($dom[$key]["style"]["page-break-after"] == "left") {
                                    $dom[$key]["attribute"]["pagebreakafter"] = "left";
                                } elseif($dom[$key]["style"]["page-break-after"] == "right") {
                                    $dom[$key]["attribute"]["pagebreakafter"] = "right";
                                }
                            }
                        }
                        if(isset($dom[$key]["attribute"]["display"])) {
                            $dom[$key]["hide"] = trim(strtolower($dom[$key]["attribute"]["display"])) == "none";
                        }
                        if(isset($dom[$key]["attribute"]["border"]) && $dom[$key]["attribute"]["border"] != 0) {
                            $borderstyle = $this->getCSSBorderStyle($dom[$key]["attribute"]["border"] . " solid black");
                            if(!empty($borderstyle)) {
                                $dom[$key]["border"]["LTRB"] = $borderstyle;
                            }
                        }
                        if($dom[$key]["value"] == "font") {
                            if(isset($dom[$key]["attribute"]["face"])) {
                                $dom[$key]["fontname"] = $this->getFontFamilyName($dom[$key]["attribute"]["face"]);
                            }
                            if(isset($dom[$key]["attribute"]["size"])) {
                                if(0 < $key) {
                                    if($dom[$key]["attribute"]["size"][0] == "+") {
                                        $dom[$key]["fontsize"] = $dom[$dom[$key]["parent"]]["fontsize"] + intval(substr($dom[$key]["attribute"]["size"], 1));
                                    } elseif($dom[$key]["attribute"]["size"][0] == "-") {
                                        $dom[$key]["fontsize"] = $dom[$dom[$key]["parent"]]["fontsize"] - intval(substr($dom[$key]["attribute"]["size"], 1));
                                    } else {
                                        $dom[$key]["fontsize"] = intval($dom[$key]["attribute"]["size"]);
                                    }
                                } else {
                                    $dom[$key]["fontsize"] = intval($dom[$key]["attribute"]["size"]);
                                }
                            }
                        }
                        if(($dom[$key]["value"] == "ul" || $dom[$key]["value"] == "ol" || $dom[$key]["value"] == "dl") && (!isset($dom[$key]["align"]) || TCPDF_STATIC::empty_string($dom[$key]["align"]) || $dom[$key]["align"] != "J")) {
                            if($this->rtl) {
                                $dom[$key]["align"] = "R";
                            } else {
                                $dom[$key]["align"] = "L";
                            }
                        }
                        if(($dom[$key]["value"] == "small" || $dom[$key]["value"] == "sup" || $dom[$key]["value"] == "sub") && !isset($dom[$key]["attribute"]["size"]) && !isset($dom[$key]["style"]["font-size"])) {
                            $dom[$key]["fontsize"] = $dom[$key]["fontsize"] * K_SMALL_RATIO;
                        }
                        if($dom[$key]["value"] == "strong" || $dom[$key]["value"] == "b") {
                            $dom[$key]["fontstyle"] .= "B";
                        }
                        if($dom[$key]["value"] == "em" || $dom[$key]["value"] == "i") {
                            $dom[$key]["fontstyle"] .= "I";
                        }
                        if($dom[$key]["value"] == "u") {
                            $dom[$key]["fontstyle"] .= "U";
                        }
                        if($dom[$key]["value"] == "del" || $dom[$key]["value"] == "s" || $dom[$key]["value"] == "strike") {
                            $dom[$key]["fontstyle"] .= "D";
                        }
                        if(!isset($dom[$key]["style"]["text-decoration"]) && $dom[$key]["value"] == "a") {
                            $dom[$key]["fontstyle"] = $this->htmlLinkFontStyle;
                        }
                        if($dom[$key]["value"] == "pre" || $dom[$key]["value"] == "tt") {
                            $dom[$key]["fontname"] = $this->default_monospaced_font;
                        }
                        if(!empty($dom[$key]["value"]) && $dom[$key]["value"][0] == "h" && 0 < intval($dom[$key]["value"][1]) && intval($dom[$key]["value"][1]) < 7) {
                            if(!isset($dom[$key]["attribute"]["size"]) && !isset($dom[$key]["style"]["font-size"])) {
                                $headsize = (4 - intval($dom[$key]["value"][1])) * 2;
                                $dom[$key]["fontsize"] = $dom[0]["fontsize"] + $headsize;
                            }
                            if(!isset($dom[$key]["style"]["font-weight"])) {
                                $dom[$key]["fontstyle"] .= "B";
                            }
                        }
                        if($dom[$key]["value"] == "table") {
                            $dom[$key]["rows"] = 0;
                            $dom[$key]["trids"] = [];
                            $dom[$key]["thead"] = "";
                        }
                        if($dom[$key]["value"] == "tr") {
                            $dom[$key]["cols"] = 0;
                            if($thead) {
                                $dom[$key]["thead"] = true;
                            } else {
                                $dom[$key]["thead"] = false;
                                $parent = $dom[$key]["parent"];
                                if(!isset($dom[$parent]["rows"])) {
                                    $dom[$parent]["rows"] = 0;
                                }
                                $dom[$parent]["rows"]++;
                                if(!isset($dom[$parent]["trids"])) {
                                    $dom[$parent]["trids"] = [];
                                }
                                array_push($dom[$parent]["trids"], $key);
                            }
                        }
                        if($dom[$key]["value"] == "th" || $dom[$key]["value"] == "td") {
                            if(isset($dom[$key]["attribute"]["colspan"])) {
                                $colspan = intval($dom[$key]["attribute"]["colspan"]);
                            } else {
                                $colspan = 1;
                            }
                            $dom[$key]["attribute"]["colspan"] = $colspan;
                            $dom[$dom[$key]["parent"]]["cols"] += $colspan;
                        }
                        if(isset($dom[$key]["attribute"]["dir"])) {
                            $dom[$key]["dir"] = $dom[$key]["attribute"]["dir"];
                        }
                        if(isset($dom[$key]["attribute"]["color"]) && !TCPDF_STATIC::empty_string($dom[$key]["attribute"]["color"])) {
                            $dom[$key]["fgcolor"] = TCPDF_COLORS::convertHTMLColorToDec($dom[$key]["attribute"]["color"], $this->spot_colors);
                        } elseif(!isset($dom[$key]["style"]["color"]) && $dom[$key]["value"] == "a") {
                            $dom[$key]["fgcolor"] = $this->htmlLinkColorArray;
                        }
                        if(isset($dom[$key]["attribute"]["bgcolor"]) && !TCPDF_STATIC::empty_string($dom[$key]["attribute"]["bgcolor"])) {
                            $dom[$key]["bgcolor"] = TCPDF_COLORS::convertHTMLColorToDec($dom[$key]["attribute"]["bgcolor"], $this->spot_colors);
                        }
                        if(isset($dom[$key]["attribute"]["strokecolor"]) && !TCPDF_STATIC::empty_string($dom[$key]["attribute"]["strokecolor"])) {
                            $dom[$key]["strokecolor"] = TCPDF_COLORS::convertHTMLColorToDec($dom[$key]["attribute"]["strokecolor"], $this->spot_colors);
                        }
                        if(isset($dom[$key]["attribute"]["width"])) {
                            $dom[$key]["width"] = $dom[$key]["attribute"]["width"];
                        }
                        if(isset($dom[$key]["attribute"]["height"])) {
                            $dom[$key]["height"] = $dom[$key]["attribute"]["height"];
                        }
                        if(isset($dom[$key]["attribute"]["align"]) && !TCPDF_STATIC::empty_string($dom[$key]["attribute"]["align"]) && $dom[$key]["value"] !== "img") {
                            $dom[$key]["align"] = strtoupper($dom[$key]["attribute"]["align"][0]);
                        }
                        if(isset($dom[$key]["attribute"]["stroke"])) {
                            $dom[$key]["stroke"] = $this->getHTMLUnitToUnits($dom[$key]["attribute"]["stroke"], $dom[$key]["fontsize"], "pt", true);
                        }
                        if(isset($dom[$key]["attribute"]["fill"])) {
                            if($dom[$key]["attribute"]["fill"] == "true") {
                                $dom[$key]["fill"] = true;
                            } else {
                                $dom[$key]["fill"] = false;
                            }
                        }
                        if(isset($dom[$key]["attribute"]["clip"])) {
                            if($dom[$key]["attribute"]["clip"] == "true") {
                                $dom[$key]["clip"] = true;
                            } else {
                                $dom[$key]["clip"] = false;
                            }
                        }
                    }
                }
            } else {
                $dom[$key]["tag"] = false;
                $dom[$key]["block"] = false;
                $dom[$key]["parent"] = end($level);
                $dom[$key]["dir"] = $dom[$dom[$key]["parent"]]["dir"];
                if(!empty($dom[$dom[$key]["parent"]]["text-transform"])) {
                    if(function_exists("mb_convert_case")) {
                        $ttm = ["capitalize" => MB_CASE_TITLE, "uppercase" => MB_CASE_UPPER, "lowercase" => MB_CASE_LOWER];
                        if(isset($ttm[$dom[$dom[$key]["parent"]]["text-transform"]])) {
                            $element = mb_convert_case($element, $ttm[$dom[$dom[$key]["parent"]]["text-transform"]], $this->encoding);
                        }
                    } elseif(!$this->isunicode) {
                        switch ($dom[$dom[$key]["parent"]]["text-transform"]) {
                            case "capitalize":
                                $element = ucwords(strtolower($element));
                                break;
                            case "uppercase":
                                $element = strtoupper($element);
                                break;
                            case "lowercase":
                                $element = strtolower($element);
                                break;
                        }
                    }
                    $element = preg_replace("/&NBSP;/i", "&nbsp;", $element);
                }
                $dom[$key]["value"] = stripslashes($this->unhtmlentities($element));
            }
            $elkey++;
            $key++;
        }
        return $dom;
    }
    protected function getSpaceString()
    {
        $spacestr = chr(32);
        if($this->isUnicodeFont()) {
            $spacestr = chr(0) . chr(32);
        }
        return $spacestr;
    }
    protected function getHashForTCPDFtagParams($data)
    {
        return md5(strlen($data) . $this->file_id . $data);
    }
    public function serializeTCPDFtagParameters($data)
    {
        $encoded = urlencode(json_encode($data));
        return $this->getHashForTCPDFtagParams($encoded) . $encoded;
    }
    protected function unserializeTCPDFtagParameters($data)
    {
        $hash = substr($data, 0, 32);
        $encoded = substr($data, 32);
        if($hash != $this->getHashForTCPDFtagParams($encoded)) {
            $this->Error("Invalid parameters");
        }
        return json_decode(urldecode($encoded), true);
    }
    public function writeHTMLCell($w, $h, $x, $y, $html = "", $border = 0, $ln = 0, $fill = false, $reseth = true, $align = "", $autopadding = true)
    {
        return $this->MultiCell($w, $h, $html, $border, $align, $fill, $ln, $x, $y, $reseth, 0, true, $autopadding, 0, "T", false);
    }
    public function writeHTML($html, $ln = true, $fill = false, $reseth = false, $cell = false, $align = "")
    {
        $gvars = $this->getGraphicVars();
        $prev_cell_margin = $this->cell_margin;
        $prev_cell_padding = $this->cell_padding;
        $prevPage = $this->page;
        $prevlMargin = $this->lMargin;
        $prevrMargin = $this->rMargin;
        $curfontname = $this->FontFamily;
        $curfontstyle = $this->FontStyle;
        $curfontsize = $this->FontSizePt;
        $curfontascent = $this->getFontAscent($curfontname, $curfontstyle, $curfontsize);
        $curfontdescent = $this->getFontDescent($curfontname, $curfontstyle, $curfontsize);
        $curfontstretcing = $this->font_stretching;
        $curfonttracking = $this->font_spacing;
        $this->newline = true;
        $newline = true;
        $startlinepage = $this->page;
        $minstartliney = $this->y;
        $maxbottomliney = 0;
        $startlinex = $this->x;
        $startliney = $this->y;
        $yshift = 0;
        $loop = 0;
        $curpos = 0;
        $this_method_vars = [];
        $undo = false;
        $fontaligned = false;
        $reverse_dir = false;
        $this->premode = false;
        if($this->inxobj) {
            $pask = count($this->xobjects[$this->xobjid]["annotations"]);
        } elseif(isset($this->PageAnnots[$this->page])) {
            $pask = count($this->PageAnnots[$this->page]);
        } else {
            $pask = 0;
        }
        if($this->inxobj) {
            $startlinepos = strlen($this->xobjects[$this->xobjid]["outdata"]);
        } elseif(!$this->InFooter) {
            if(isset($this->footerlen[$this->page])) {
                $this->footerpos[$this->page] = $this->pagelen[$this->page] - $this->footerlen[$this->page];
            } else {
                $this->footerpos[$this->page] = $this->pagelen[$this->page];
            }
            $startlinepos = $this->footerpos[$this->page];
        } else {
            $startlinepos = $this->pagelen[$this->page];
        }
        $lalign = $align;
        $plalign = $align;
        if($this->rtl) {
            $w = $this->x - $this->lMargin;
        } else {
            $w = $this->w - $this->rMargin - $this->x;
        }
        $w -= $this->cell_padding["L"] + $this->cell_padding["R"];
        if($cell) {
            if($this->rtl) {
                $this->x -= $this->cell_padding["R"];
                $this->lMargin += $this->cell_padding["L"];
            } else {
                $this->x += $this->cell_padding["L"];
                $this->rMargin += $this->cell_padding["R"];
            }
        }
        if(0 <= $this->customlistindent) {
            $this->listindent = $this->customlistindent;
        } else {
            $this->listindent = $this->GetStringWidth("000000");
        }
        $this->listindentlevel = 0;
        $prev_cell_height_ratio = $this->cell_height_ratio;
        $prev_listnum = $this->listnum;
        $prev_listordered = $this->listordered;
        $prev_listcount = $this->listcount;
        $prev_lispacer = $this->lispacer;
        $this->listnum = 0;
        $this->listordered = [];
        $this->listcount = [];
        $this->lispacer = "";
        if(TCPDF_STATIC::empty_string($this->lasth) || $reseth) {
            $this->resetLastH();
        }
        $dom = $this->getHtmlDomArray($html);
        $maxel = count($dom);
        $key = 0;
        while ($key < $maxel) {
            if($dom[$key]["tag"] && $dom[$key]["opening"] && $dom[$key]["hide"]) {
                $hidden_node_key = $key;
                if($dom[$key]["self"]) {
                    $key++;
                } else {
                    while ($key < $maxel && (!$dom[$key]["tag"] || $dom[$key]["opening"] || $dom[$key]["parent"] != $hidden_node_key)) {
                        $key++;
                    }
                    $key++;
                }
            }
            if($key == $maxel) {
                break;
            }
            if($dom[$key]["tag"] && isset($dom[$key]["attribute"]["pagebreak"])) {
                if($dom[$key]["attribute"]["pagebreak"] == "true" || $dom[$key]["attribute"]["pagebreak"] == "left" || $dom[$key]["attribute"]["pagebreak"] == "right") {
                    $this->checkPageBreak($this->PageBreakTrigger + 1);
                    $this->htmlvspace = $this->PageBreakTrigger + 1;
                }
                if($dom[$key]["attribute"]["pagebreak"] == "left" && (!$this->rtl && $this->page % 2 == 0 || $this->rtl && $this->page % 2 != 0) || $dom[$key]["attribute"]["pagebreak"] == "right" && (!$this->rtl && $this->page % 2 != 0 || $this->rtl && $this->page % 2 == 0)) {
                    $this->checkPageBreak($this->PageBreakTrigger + 1);
                    $this->htmlvspace = $this->PageBreakTrigger + 1;
                }
            }
            if($dom[$key]["tag"] && $dom[$key]["opening"] && isset($dom[$key]["attribute"]["nobr"]) && $dom[$key]["attribute"]["nobr"] == "true") {
                if(isset($dom[$dom[$key]["parent"]]["attribute"]["nobr"]) && $dom[$dom[$key]["parent"]]["attribute"]["nobr"] == "true") {
                    $dom[$key]["attribute"]["nobr"] = false;
                } else {
                    $this->startTransaction();
                    $this_method_vars["html"] = $html;
                    $this_method_vars["ln"] = $ln;
                    $this_method_vars["fill"] = $fill;
                    $this_method_vars["reseth"] = $reseth;
                    $this_method_vars["cell"] = $cell;
                    $this_method_vars["align"] = $align;
                    $this_method_vars["gvars"] = $gvars;
                    $this_method_vars["prevPage"] = $prevPage;
                    $this_method_vars["prev_cell_margin"] = $prev_cell_margin;
                    $this_method_vars["prev_cell_padding"] = $prev_cell_padding;
                    $this_method_vars["prevlMargin"] = $prevlMargin;
                    $this_method_vars["prevrMargin"] = $prevrMargin;
                    $this_method_vars["curfontname"] = $curfontname;
                    $this_method_vars["curfontstyle"] = $curfontstyle;
                    $this_method_vars["curfontsize"] = $curfontsize;
                    $this_method_vars["curfontascent"] = $curfontascent;
                    $this_method_vars["curfontdescent"] = $curfontdescent;
                    $this_method_vars["curfontstretcing"] = $curfontstretcing;
                    $this_method_vars["curfonttracking"] = $curfonttracking;
                    $this_method_vars["minstartliney"] = $minstartliney;
                    $this_method_vars["maxbottomliney"] = $maxbottomliney;
                    $this_method_vars["yshift"] = $yshift;
                    $this_method_vars["startlinepage"] = $startlinepage;
                    $this_method_vars["startlinepos"] = $startlinepos;
                    $this_method_vars["startlinex"] = $startlinex;
                    $this_method_vars["startliney"] = $startliney;
                    $this_method_vars["newline"] = $newline;
                    $this_method_vars["loop"] = $loop;
                    $this_method_vars["curpos"] = $curpos;
                    $this_method_vars["pask"] = $pask;
                    $this_method_vars["lalign"] = $lalign;
                    $this_method_vars["plalign"] = $plalign;
                    $this_method_vars["w"] = $w;
                    $this_method_vars["prev_cell_height_ratio"] = $prev_cell_height_ratio;
                    $this_method_vars["prev_listnum"] = $prev_listnum;
                    $this_method_vars["prev_listordered"] = $prev_listordered;
                    $this_method_vars["prev_listcount"] = $prev_listcount;
                    $this_method_vars["prev_lispacer"] = $prev_lispacer;
                    $this_method_vars["fontaligned"] = $fontaligned;
                    $this_method_vars["key"] = $key;
                    $this_method_vars["dom"] = $dom;
                }
            }
            if($dom[$key]["value"] == "tr" && isset($dom[$key]["thead"]) && $dom[$key]["thead"]) {
                if(isset($dom[$key]["parent"]) && isset($dom[$dom[$key]["parent"]]["thead"]) && !TCPDF_STATIC::empty_string($dom[$dom[$key]["parent"]]["thead"])) {
                    $this->inthead = true;
                    $this->writeHTML($this->thead, false, false, false, false, "");
                    if($this->y < $this->start_transaction_y || $this->checkPageBreak($this->lasth, "", false)) {
                        $this->rollbackTransaction(true);
                        foreach ($this_method_vars as $vkey => $vval) {
                            ${$vkey} = $vval;
                        }
                        $tmp_thead = $this->thead;
                        $this->thead = "";
                        $pre_y = $this->y;
                        if(!$this->checkPageBreak($this->PageBreakTrigger + 1) && $this->y < $pre_y) {
                            $startliney = $this->y;
                        }
                        $this->start_transaction_page = $this->page;
                        $this->start_transaction_y = $this->y;
                        $this->thead = $tmp_thead;
                        if(isset($dom[$dom[$key]["parent"]]["attribute"]["cellspacing"])) {
                            $tmp_cellspacing = $this->getHTMLUnitToUnits($dom[$dom[$key]["parent"]]["attribute"]["cellspacing"], 1, "px");
                        } elseif(isset($dom[$dom[$key]["parent"]]["border-spacing"])) {
                            $tmp_cellspacing = $dom[$dom[$key]["parent"]]["border-spacing"]["V"];
                        } else {
                            $tmp_cellspacing = 0;
                        }
                        $dom[$dom[$key]["parent"]]["borderposition"]["page"] = $this->page;
                        $dom[$dom[$key]["parent"]]["borderposition"]["column"] = $this->current_column;
                        $dom[$dom[$key]["parent"]]["borderposition"]["y"] = $this->y + $tmp_cellspacing;
                        $xoffset = $this->x - $dom[$dom[$key]["parent"]]["borderposition"]["x"];
                        $dom[$dom[$key]["parent"]]["borderposition"]["x"] += $xoffset;
                        $dom[$dom[$key]["parent"]]["borderposition"]["xmax"] += $xoffset;
                        $this->writeHTML($this->thead, false, false, false, false, "");
                    }
                }
                while ($key < $maxel && !($dom[$key]["tag"] && $dom[$key]["opening"] && $dom[$key]["value"] == "tr" && (!isset($dom[$key]["thead"]) || !$dom[$key]["thead"]) || $dom[$key]["tag"] && !$dom[$key]["opening"] && $dom[$key]["value"] == "table")) {
                    $key++;
                }
            }
            if($dom[$key]["tag"] || $key == 0) {
                if(($dom[$key]["value"] == "table" || $dom[$key]["value"] == "tr") && isset($dom[$key]["align"])) {
                    $dom[$key]["align"] = $this->rtl ? "R" : "L";
                }
                if(!$this->newline && $dom[$key]["value"] == "img" && isset($dom[$key]["height"]) && 0 < $dom[$key]["height"]) {
                    $imgh = $this->getHTMLUnitToUnits($dom[$key]["height"], $dom[$key]["fontsize"] / $this->k, "px");
                    $autolinebreak = false;
                    if(!empty($dom[$key]["width"])) {
                        $imgw = $this->getHTMLUnitToUnits($dom[$key]["width"], $dom[$key]["fontsize"] / $this->k, "px", false);
                        if($imgw <= $this->w - $this->lMargin - $this->rMargin - $this->cell_padding["L"] - $this->cell_padding["R"] && ($this->rtl && $this->x - $imgw < $this->lMargin + $this->cell_padding["L"] || !$this->rtl && $this->w - $this->rMargin - $this->cell_padding["R"] < $this->x + $imgw)) {
                            $autolinebreak = true;
                            $this->Ln("", $cell);
                            if(!$dom[$key - 1]["tag"] && $dom[$key - 1]["value"] == " ") {
                                --$key;
                            }
                        }
                    }
                    if(!$autolinebreak) {
                        if($this->inPageBody()) {
                            $pre_y = $this->y;
                            if(!$this->checkPageBreak($imgh) && $this->y < $pre_y) {
                                $startliney = $this->y;
                            }
                        }
                        if($startlinepage < $this->page) {
                            if(isset($this->footerlen[$startlinepage])) {
                                $curpos = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                            }
                            $pagebuff = $this->getPageBuffer($startlinepage);
                            $linebeg = substr($pagebuff, $startlinepos, $curpos - $startlinepos);
                            $tstart = substr($pagebuff, 0, $startlinepos);
                            $tend = substr($this->getPageBuffer($startlinepage), $curpos);
                            $this->setPageBuffer($startlinepage, $tstart . "" . $tend);
                            $pagebuff = $this->getPageBuffer($this->page);
                            $tstart = substr($pagebuff, 0, $this->cntmrk[$this->page]);
                            $tend = substr($pagebuff, $this->cntmrk[$this->page]);
                            $yshift = $minstartliney - $this->y;
                            if($fontaligned) {
                                $yshift += $curfontsize / $this->k;
                            }
                            $try = sprintf("1 0 0 1 0 %F cm", $yshift * $this->k);
                            $this->setPageBuffer($this->page, $tstart . "\nq\n" . $try . "\n" . $linebeg . "\nQ\n" . $tend);
                            if(isset($this->PageAnnots[$this->page])) {
                                $next_pask = count($this->PageAnnots[$this->page]);
                            } else {
                                $next_pask = 0;
                            }
                            if(isset($this->PageAnnots[$startlinepage])) {
                                foreach ($this->PageAnnots[$startlinepage] as $pak => $pac) {
                                    if($pask <= $pak) {
                                        $this->PageAnnots[$this->page][] = $pac;
                                        unset($this->PageAnnots[$startlinepage][$pak]);
                                        $npak = count($this->PageAnnots[$this->page]) - 1;
                                        $this->PageAnnots[$this->page][$npak]["y"] -= $yshift;
                                    }
                                }
                            }
                            $pask = $next_pask;
                            $startlinepos = $this->cntmrk[$this->page];
                            $startlinepage = $this->page;
                            $startliney = $this->y;
                            $this->newline = false;
                        }
                        $this->y += $this->getCellHeight($curfontsize / $this->k) - $curfontdescent * $this->cell_height_ratio - $imgh;
                        $minstartliney = min($this->y, $minstartliney);
                        $maxbottomliney = $startliney + $this->getCellHeight($curfontsize / $this->k);
                    }
                } elseif(isset($dom[$key]["fontname"]) || isset($dom[$key]["fontstyle"]) || isset($dom[$key]["fontsize"]) || isset($dom[$key]["line-height"])) {
                    $pfontname = $curfontname;
                    $pfontstyle = $curfontstyle;
                    $pfontsize = $curfontsize;
                    $fontname = isset($dom[$key]["fontname"]) ? $dom[$key]["fontname"] : $curfontname;
                    $fontstyle = isset($dom[$key]["fontstyle"]) ? $dom[$key]["fontstyle"] : $curfontstyle;
                    $fontsize = isset($dom[$key]["fontsize"]) ? $dom[$key]["fontsize"] : $curfontsize;
                    $fontascent = $this->getFontAscent($fontname, $fontstyle, $fontsize);
                    $fontdescent = $this->getFontDescent($fontname, $fontstyle, $fontsize);
                    if($fontname != $curfontname || $fontstyle != $curfontstyle || $fontsize != $curfontsize || $this->cell_height_ratio != $dom[$key]["line-height"] || $dom[$key]["tag"] && $dom[$key]["opening"] && $dom[$key]["value"] == "li") {
                        if($key < $maxel - 1 && ($dom[$key]["tag"] && $dom[$key]["opening"] && $dom[$key]["value"] == "li" || $this->cell_height_ratio != $dom[$key]["line-height"] || !$this->newline && is_numeric($fontsize) && is_numeric($curfontsize) && 0 <= $fontsize && 0 <= $curfontsize && ($fontsize != $curfontsize || $fontstyle != $curfontstyle || $fontname != $curfontname))) {
                            if($startlinepage < $this->page) {
                                if(isset($this->footerlen[$startlinepage])) {
                                    $curpos = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                                }
                                $pagebuff = $this->getPageBuffer($startlinepage);
                                $linebeg = substr($pagebuff, $startlinepos, $curpos - $startlinepos);
                                $tstart = substr($pagebuff, 0, $startlinepos);
                                $tend = substr($this->getPageBuffer($startlinepage), $curpos);
                                $this->setPageBuffer($startlinepage, $tstart . "" . $tend);
                                $pagebuff = $this->getPageBuffer($this->page);
                                $tstart = substr($pagebuff, 0, $this->cntmrk[$this->page]);
                                $tend = substr($pagebuff, $this->cntmrk[$this->page]);
                                $yshift = $minstartliney - $this->y;
                                $try = sprintf("1 0 0 1 0 %F cm", $yshift * $this->k);
                                $this->setPageBuffer($this->page, $tstart . "\nq\n" . $try . "\n" . $linebeg . "\nQ\n" . $tend);
                                if(isset($this->PageAnnots[$this->page])) {
                                    $next_pask = count($this->PageAnnots[$this->page]);
                                } else {
                                    $next_pask = 0;
                                }
                                if(isset($this->PageAnnots[$startlinepage])) {
                                    foreach ($this->PageAnnots[$startlinepage] as $pak => $pac) {
                                        if($pask <= $pak) {
                                            $this->PageAnnots[$this->page][] = $pac;
                                            unset($this->PageAnnots[$startlinepage][$pak]);
                                            $npak = count($this->PageAnnots[$this->page]) - 1;
                                            $this->PageAnnots[$this->page][$npak]["y"] -= $yshift;
                                        }
                                    }
                                }
                                $pask = $next_pask;
                                $startlinepos = $this->cntmrk[$this->page];
                                $startlinepage = $this->page;
                                $startliney = $this->y;
                            }
                            if(!isset($dom[$key]["line-height"])) {
                                $dom[$key]["line-height"] = $this->cell_height_ratio;
                            }
                            if(!$dom[$key]["block"]) {
                                if(!(isset($dom[$key + 1]) && $dom[$key + 1]["tag"] && !$dom[$key + 1]["opening"] && $dom[$key + 1]["value"] != "li" && $dom[$key]["tag"]) || $dom[$key]["opening"]) {
                                    $this->y += (($curfontsize * $this->cell_height_ratio - $fontsize * $dom[$key]["line-height"]) / $this->k + $curfontascent - $fontascent - $curfontdescent + $fontdescent) / 2;
                                }
                                if($dom[$key]["value"] != "sup" && $dom[$key]["value"] != "sub") {
                                    $current_line_align_data = [$key, $minstartliney, $maxbottomliney];
                                    if(isset($line_align_data) && ($line_align_data[0] == $key - 1 || $line_align_data[0] == $key - 2 && isset($dom[$key - 1]) && 0 < preg_match("/^([\\s]+)\$/", $dom[$key - 1]["value"]))) {
                                        $minstartliney = min($this->y, $line_align_data[1]);
                                        $maxbottomliney = max($this->y + $this->getCellHeight($fontsize / $this->k), $line_align_data[2]);
                                    } else {
                                        $minstartliney = min($this->y, $minstartliney);
                                        $maxbottomliney = max($this->y + $this->getCellHeight($fontsize / $this->k), $maxbottomliney);
                                    }
                                    $line_align_data = $current_line_align_data;
                                }
                            }
                            $this->cell_height_ratio = $dom[$key]["line-height"];
                            $fontaligned = true;
                        }
                        $this->setFont($fontname, $fontstyle, $fontsize);
                        $this->resetLastH();
                        $curfontname = $fontname;
                        $curfontstyle = $fontstyle;
                        $curfontsize = $fontsize;
                        $curfontascent = $fontascent;
                        $curfontdescent = $fontdescent;
                    }
                }
                $textstroke = isset($dom[$key]["stroke"]) ? $dom[$key]["stroke"] : $this->textstrokewidth;
                $textfill = isset($dom[$key]["fill"]) ? $dom[$key]["fill"] : $this->textrendermode % 2 == 0;
                $textclip = isset($dom[$key]["clip"]) ? $dom[$key]["clip"] : 3 < $this->textrendermode;
                $this->setTextRenderingMode($textstroke, $textfill, $textclip);
                if(isset($dom[$key]["font-stretch"]) && $dom[$key]["font-stretch"] !== false) {
                    $this->setFontStretching($dom[$key]["font-stretch"]);
                }
                if(isset($dom[$key]["letter-spacing"]) && $dom[$key]["letter-spacing"] !== false) {
                    $this->setFontSpacing($dom[$key]["letter-spacing"]);
                }
                if($plalign == "J" && $dom[$key]["block"]) {
                    $plalign = "";
                }
                $curpos = $this->pagelen[$startlinepage];
                if(isset($dom[$key]["bgcolor"]) && $dom[$key]["bgcolor"] !== false) {
                    $this->setFillColorArray($dom[$key]["bgcolor"]);
                    $wfill = true;
                } else {
                    $wfill = $fill | false;
                }
                if(isset($dom[$key]["fgcolor"]) && $dom[$key]["fgcolor"] !== false) {
                    $this->setTextColorArray($dom[$key]["fgcolor"]);
                }
                if(isset($dom[$key]["strokecolor"]) && $dom[$key]["strokecolor"] !== false) {
                    $this->setDrawColorArray($dom[$key]["strokecolor"]);
                }
                if(isset($dom[$key]["align"])) {
                    $lalign = $dom[$key]["align"];
                }
                if(TCPDF_STATIC::empty_string($lalign)) {
                    $lalign = $align;
                }
            }
            if($this->newline && 0 < strlen($dom[$key]["value"]) && $dom[$key]["value"] != "td" && $dom[$key]["value"] != "th") {
                $newline = true;
                $fontaligned = false;
                if(isset($startlinex)) {
                    $yshift = $minstartliney - $startliney;
                    if(0 < $yshift || $startlinepage < $this->page) {
                        $yshift = 0;
                    }
                    $t_x = 0;
                    $linew = abs($this->endlinex - $startlinex);
                    if($this->inxobj) {
                        $pstart = substr($this->xobjects[$this->xobjid]["outdata"], 0, $startlinepos);
                        if(isset($opentagpos)) {
                            $midpos = $opentagpos;
                        } else {
                            $midpos = 0;
                        }
                        if(0 < $midpos) {
                            $pmid = substr($this->xobjects[$this->xobjid]["outdata"], $startlinepos, $midpos - $startlinepos);
                            $pend = substr($this->xobjects[$this->xobjid]["outdata"], $midpos);
                        } else {
                            $pmid = substr($this->xobjects[$this->xobjid]["outdata"], $startlinepos);
                            $pend = "";
                        }
                    } else {
                        $pstart = substr($this->getPageBuffer($startlinepage), 0, $startlinepos);
                        if(isset($opentagpos) && isset($this->footerlen[$startlinepage]) && !$this->InFooter) {
                            $this->footerpos[$startlinepage] = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                            $midpos = min($opentagpos, $this->footerpos[$startlinepage]);
                        } elseif(isset($opentagpos)) {
                            $midpos = $opentagpos;
                        } elseif(isset($this->footerlen[$startlinepage]) && !$this->InFooter) {
                            $this->footerpos[$startlinepage] = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                            $midpos = $this->footerpos[$startlinepage];
                        } else {
                            $midpos = 0;
                        }
                        if(0 < $midpos) {
                            $pmid = substr($this->getPageBuffer($startlinepage), $startlinepos, $midpos - $startlinepos);
                            $pend = substr($this->getPageBuffer($startlinepage), $midpos);
                        } else {
                            $pmid = substr($this->getPageBuffer($startlinepage), $startlinepos);
                            $pend = "";
                        }
                    }
                    if(isset($plalign) && ($plalign == "C" || $plalign == "J" || $plalign == "R" && !$this->rtl || $plalign == "L" && $this->rtl)) {
                        $tw = $w;
                        if($plalign == "J" && $this->isRTLTextDir() && 1 < $this->num_columns) {
                            $tw += $this->cell_padding["R"];
                        }
                        if($this->lMargin != $prevlMargin) {
                            $tw += $prevlMargin - $this->lMargin;
                        }
                        if($this->rMargin != $prevrMargin) {
                            $tw += $prevrMargin - $this->rMargin;
                        }
                        $one_space_width = $this->GetStringWidth(chr(32));
                        $no = 0;
                        if($this->isRTLTextDir()) {
                            $pos1 = TCPDF_STATIC::revstrpos($pmid, "[(");
                            if(0 < $pos1) {
                                $pos1 = intval($pos1);
                                if($this->isUnicodeFont()) {
                                    $pos2 = intval(TCPDF_STATIC::revstrpos($pmid, "[(" . chr(0) . chr(32)));
                                    $spacelen = 2;
                                } else {
                                    $pos2 = intval(TCPDF_STATIC::revstrpos($pmid, "[(" . chr(32)));
                                    $spacelen = 1;
                                }
                                if($pos1 == $pos2) {
                                    $pmid = substr($pmid, 0, $pos1 + 2) . substr($pmid, $pos1 + 2 + $spacelen);
                                    if(substr($pmid, $pos1, 4) == "[()]") {
                                        $linew -= $one_space_width;
                                    } elseif($pos1 == strpos($pmid, "[(")) {
                                        $no = 1;
                                    }
                                }
                            }
                        } else {
                            $pos1 = TCPDF_STATIC::revstrpos($pmid, ")]");
                            if(0 < $pos1) {
                                $pos1 = intval($pos1);
                                if($this->isUnicodeFont()) {
                                    $pos2 = intval(TCPDF_STATIC::revstrpos($pmid, chr(0) . chr(32) . ")]")) + 2;
                                    $spacelen = 2;
                                } else {
                                    $pos2 = intval(TCPDF_STATIC::revstrpos($pmid, chr(32) . ")]")) + 1;
                                    $spacelen = 1;
                                }
                                if($pos1 == $pos2) {
                                    $pmid = substr($pmid, 0, $pos1 - $spacelen) . substr($pmid, $pos1);
                                    $linew -= $one_space_width;
                                }
                            }
                        }
                        $mdiff = $tw - $linew;
                        if($plalign == "C") {
                            if($this->rtl) {
                                $t_x = -1 * $mdiff / 2;
                            } else {
                                $t_x = $mdiff / 2;
                            }
                        } elseif($plalign == "R") {
                            $t_x = $mdiff;
                        } elseif($plalign == "L") {
                            $t_x = -1 * $mdiff;
                        } elseif($plalign == "J" && $plalign == $lalign) {
                            if($this->isRTLTextDir()) {
                                $t_x = -1 * $mdiff;
                            }
                            $ns = 0;
                            $pmidtemp = $pmid;
                            $pmidtemp = preg_replace("/[\\\\][\\(]/x", "\\#!#OP#!#", $pmidtemp);
                            $pmidtemp = preg_replace("/[\\\\][\\)]/x", "\\#!#CP#!#", $pmidtemp);
                            if(preg_match_all("/\\[\\(([^\\)]*)\\)\\]/x", $pmidtemp, $lnstring, PREG_PATTERN_ORDER)) {
                                $spacestr = $this->getSpaceString();
                                $maxkk = count($lnstring[1]) - 1;
                                for ($kk = 0; $kk <= $maxkk; $kk++) {
                                    $lnstring[1][$kk] = str_replace("#!#OP#!#", "(", $lnstring[1][$kk]);
                                    $lnstring[1][$kk] = str_replace("#!#CP#!#", ")", $lnstring[1][$kk]);
                                    $lnstring[2][$kk] = substr_count($lnstring[1][$kk], $spacestr);
                                    $ns += $lnstring[2][$kk];
                                    $lnstring[3][$kk] = $ns;
                                }
                                if($ns == 0) {
                                    $ns = 1;
                                }
                                $spacewidth = $mdiff / ($ns - $no) * $this->k;
                                if($this->FontSize <= 0) {
                                    $this->FontSize = 1;
                                }
                                $spacewidthu = -1000 * ($mdiff + ($ns + $no) * $one_space_width) / $ns / $this->FontSize;
                                if($this->font_spacing != 0) {
                                    $osw = -1000 * $this->font_spacing / $this->FontSize;
                                    $spacewidthu += $osw;
                                }
                                $nsmax = $ns;
                                $ns = 0;
                                reset($lnstring);
                                $offset = 0;
                                $strcount = 0;
                                $prev_epsposbeg = 0;
                                $textpos = 0;
                                if($this->isRTLTextDir()) {
                                    $textpos = $this->wPt;
                                }
                                while (preg_match("/([0-9\\.\\+\\-]*)[\\s](Td|cm|m|l|c|re)[\\s]/x", $pmid, $strpiece, PREG_OFFSET_CAPTURE, $offset) == 1) {
                                    $stroffset = strpos($pmid, "[(", $offset);
                                    if($stroffset !== false && $stroffset <= $strpiece[2][1]) {
                                        $offset = strpos($pmid, ")]", $stroffset);
                                        while ($offset !== false && $pmid[$offset - 1] == "\\") {
                                            $offset = strpos($pmid, ")]", $offset + 1);
                                        }
                                        if($offset === false) {
                                            $this->Error("HTML Justification: malformed PDF code.");
                                        }
                                    } else {
                                        if($this->isRTLTextDir()) {
                                            $spacew = $spacewidth * ($nsmax - $ns);
                                        } else {
                                            $spacew = $spacewidth * $ns;
                                        }
                                        $offset = $strpiece[2][1] + strlen($strpiece[2][0]);
                                        $epsposend = strpos($pmid, $this->epsmarker . "Q", $offset);
                                        if($epsposend !== NULL) {
                                            $epsposend += strlen($this->epsmarker . "Q");
                                            $epsposbeg = strpos($pmid, "q" . $this->epsmarker, $offset);
                                            if($epsposbeg === NULL) {
                                                $epsposbeg = strpos($pmid, "q" . $this->epsmarker, $prev_epsposbeg - 6);
                                                $prev_epsposbeg = $epsposbeg;
                                            }
                                            if(0 < $epsposbeg && 0 < $epsposend && $epsposbeg < $offset && $offset < $epsposend) {
                                                $trx = sprintf("1 0 0 1 %F 0 cm", $spacew);
                                                $pmid_b = substr($pmid, 0, $epsposbeg);
                                                $pmid_m = substr($pmid, $epsposbeg, $epsposend - $epsposbeg);
                                                $pmid_e = substr($pmid, $epsposend);
                                                $pmid = $pmid_b . "\nq\n" . $trx . "\n" . $pmid_m . "\nQ\n" . $pmid_e;
                                                $offset = $epsposend;
                                            }
                                        }
                                        $currentxpos = 0;
                                        switch ($strpiece[2][0]) {
                                            case "Td":
                                            case "cm":
                                            case "m":
                                            case "l":
                                                preg_match("/([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](" . $strpiece[2][0] . ")([\\s]*)/x", $pmid, $xmatches);
                                                if(!isset($xmatches[1])) {
                                                } else {
                                                    $currentxpos = $xmatches[1];
                                                    $textpos = $currentxpos;
                                                    if($strcount <= $maxkk && $strpiece[2][0] == "Td") {
                                                        $ns = $lnstring[3][$strcount];
                                                        if($this->isRTLTextDir()) {
                                                            $spacew = $spacewidth * ($nsmax - $ns);
                                                        }
                                                        $strcount++;
                                                    }
                                                    if(preg_match("/([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](" . $strpiece[2][0] . ")([\\s]*)/x", $pmid, $pmatch) == 1) {
                                                        $newpmid = sprintf("%F", floatval($pmatch[1]) + $spacew) . " " . $pmatch[2] . " x*#!#*x" . $pmatch[3] . $pmatch[4];
                                                        $pmid = str_replace($pmatch[0], $newpmid, $pmid);
                                                        unset($pmatch);
                                                        unset($newpmid);
                                                    }
                                                }
                                                break;
                                            case "re":
                                                if(!TCPDF_STATIC::empty_string($this->lispacer)) {
                                                    $this->lispacer = "";
                                                } else {
                                                    preg_match("/([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](re)([\\s]*)/x", $pmid, $xmatches);
                                                    if(!isset($xmatches[1])) {
                                                    } else {
                                                        $currentxpos = $xmatches[1];
                                                        $x_diff = 0;
                                                        $w_diff = 0;
                                                        if($this->isRTLTextDir()) {
                                                            if($currentxpos < $textpos) {
                                                                $x_diff = $spacewidth * ($nsmax - $lnstring[3][$strcount]);
                                                                $w_diff = $spacewidth * $lnstring[2][$strcount];
                                                            } elseif(0 < $strcount) {
                                                                $x_diff = $spacewidth * ($nsmax - $lnstring[3][$strcount - 1]);
                                                                $w_diff = $spacewidth * $lnstring[2][$strcount - 1];
                                                            }
                                                        } elseif($textpos < $currentxpos) {
                                                            if(0 < $strcount) {
                                                                $x_diff = $spacewidth * $lnstring[3][$strcount - 1];
                                                            }
                                                            $w_diff = $spacewidth * $lnstring[2][$strcount];
                                                        } else {
                                                            if(1 < $strcount) {
                                                                $x_diff = $spacewidth * $lnstring[3][$strcount - 2];
                                                            }
                                                            if(0 < $strcount) {
                                                                $w_diff = $spacewidth * $lnstring[2][$strcount - 1];
                                                            }
                                                        }
                                                        if(preg_match("/(" . $xmatches[1] . ")[\\s](" . $xmatches[2] . ")[\\s](" . $xmatches[3] . ")[\\s](" . $strpiece[1][0] . ")[\\s](re)([\\s]*)/x", $pmid, $pmatch) == 1) {
                                                            $newx = sprintf("%F", floatval($pmatch[1]) + $x_diff);
                                                            $neww = sprintf("%F", floatval($pmatch[3]) + $w_diff);
                                                            $newpmid = $newx . " " . $pmatch[2] . " " . $neww . " " . $pmatch[4] . " x*#!#*x" . $pmatch[5] . $pmatch[6];
                                                            $pmid = str_replace($pmatch[0], $newpmid, $pmid);
                                                            unset($pmatch);
                                                            unset($newpmid);
                                                            unset($newx);
                                                            unset($neww);
                                                        }
                                                    }
                                                }
                                                break;
                                            case "c":
                                                preg_match("/([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s]([0-9\\.\\+\\-]*)[\\s](" . $strpiece[1][0] . ")[\\s](c)([\\s]*)/x", $pmid, $xmatches);
                                                if(!isset($xmatches[1])) {
                                                } else {
                                                    $currentxpos = $xmatches[1];
                                                    if(preg_match("/(" . $xmatches[1] . ")[\\s](" . $xmatches[2] . ")[\\s](" . $xmatches[3] . ")[\\s](" . $xmatches[4] . ")[\\s](" . $xmatches[5] . ")[\\s](" . $strpiece[1][0] . ")[\\s](c)([\\s]*)/x", $pmid, $pmatch) == 1) {
                                                        $newx1 = sprintf("%F", floatval($pmatch[1]) + $spacew);
                                                        $newx2 = sprintf("%F", floatval($pmatch[3]) + $spacew);
                                                        $newx3 = sprintf("%F", floatval($pmatch[5]) + $spacew);
                                                        $newpmid = $newx1 . " " . $pmatch[2] . " " . $newx2 . " " . $pmatch[4] . " " . $newx3 . " " . $pmatch[6] . " x*#!#*x" . $pmatch[7] . $pmatch[8];
                                                        $pmid = str_replace($pmatch[0], $newpmid, $pmid);
                                                        unset($pmatch);
                                                        unset($newpmid);
                                                        unset($newx1);
                                                        unset($newx2);
                                                        unset($newx3);
                                                    }
                                                }
                                                break;
                                            default:
                                                $cxpos = $currentxpos / $this->k;
                                                $lmpos = $this->lMargin + $this->cell_padding["L"] + $this->feps;
                                                if($this->inxobj) {
                                                    foreach ($this->xobjects[$this->xobjid]["annotations"] as $pak => $pac) {
                                                        if($minstartliney <= $pac["y"] && $currentxpos - $this->feps <= $pac["x"] * $this->k && $pac["x"] * $this->k <= $currentxpos + $this->feps) {
                                                            if($lmpos < $cxpos) {
                                                                $this->xobjects[$this->xobjid]["annotations"][$pak]["x"] += $spacew / $this->k;
                                                                $this->xobjects[$this->xobjid]["annotations"][$pak]["w"] += $spacewidth * $pac["numspaces"] / $this->k;
                                                            } else {
                                                                $this->xobjects[$this->xobjid]["annotations"][$pak]["w"] += $spacewidth * $pac["numspaces"] / $this->k;
                                                            }
                                                        }
                                                    }
                                                } elseif(isset($this->PageAnnots[$this->page])) {
                                                    foreach ($this->PageAnnots[$this->page] as $pak => $pac) {
                                                        if($minstartliney <= $pac["y"] && $currentxpos - $this->feps <= $pac["x"] * $this->k && $pac["x"] * $this->k <= $currentxpos + $this->feps) {
                                                            if($lmpos < $cxpos) {
                                                                $this->PageAnnots[$this->page][$pak]["x"] += $spacew / $this->k;
                                                                $this->PageAnnots[$this->page][$pak]["w"] += $spacewidth * $pac["numspaces"] / $this->k;
                                                            } else {
                                                                $this->PageAnnots[$this->page][$pak]["w"] += $spacewidth * $pac["numspaces"] / $this->k;
                                                            }
                                                        }
                                                    }
                                                }
                                        }
                                    }
                                }
                                $pmid = str_replace("x*#!#*x", "", $pmid);
                                if($this->isUnicodeFont()) {
                                    $spacew = $spacewidthu;
                                    if($this->font_stretching != 100) {
                                        $spacew /= $this->font_stretching / 100;
                                    }
                                    $pos = 0;
                                    $pmid = preg_replace("/[\\\\][\\(]/x", "\\#!#OP#!#", $pmid);
                                    $pmid = preg_replace("/[\\\\][\\)]/x", "\\#!#CP#!#", $pmid);
                                    if(0 < preg_match_all("/\\[\\(([^\\)]*)\\)\\]/x", $pmid, $pamatch)) {
                                        foreach ($pamatch[0] as $pk => $pmatch) {
                                            $replace = $pamatch[1][$pk];
                                            $replace = str_replace("#!#OP#!#", "(", $replace);
                                            $replace = str_replace("#!#CP#!#", ")", $replace);
                                            $newpmid = "[(" . str_replace(chr(0) . chr(32), ") " . sprintf("%F", $spacew) . " (", $replace) . ")]";
                                            $pos = strpos($pmid, $pmatch, $pos);
                                            if($pos !== false) {
                                                $pmid = substr_replace($pmid, $newpmid, $pos, strlen($pmatch));
                                            }
                                            $pos++;
                                        }
                                        unset($pamatch);
                                    }
                                    if($this->inxobj) {
                                        $this->xobjects[$this->xobjid]["outdata"] = $pstart . "\n" . $pmid . "\n" . $pend;
                                    } else {
                                        $this->setPageBuffer($startlinepage, $pstart . "\n" . $pmid . "\n" . $pend);
                                    }
                                    $endlinepos = strlen($pstart . "\n" . $pmid . "\n");
                                } else {
                                    if($this->font_stretching != 100) {
                                        $spacewidth /= $this->font_stretching / 100;
                                    }
                                    $rs = sprintf("%F Tw", $spacewidth);
                                    $pmid = preg_replace("/\\[\\(/x", $rs . " [(", $pmid);
                                    if($this->inxobj) {
                                        $this->xobjects[$this->xobjid]["outdata"] = $pstart . "\n" . $pmid . "\nBT 0 Tw ET\n" . $pend;
                                    } else {
                                        $this->setPageBuffer($startlinepage, $pstart . "\n" . $pmid . "\nBT 0 Tw ET\n" . $pend);
                                    }
                                    $endlinepos = strlen($pstart . "\n" . $pmid . "\nBT 0 Tw ET\n");
                                }
                            }
                        }
                    }
                    if($t_x != 0 || $yshift < 0) {
                        $trx = sprintf("1 0 0 1 %F %F cm", $t_x * $this->k, $yshift * $this->k);
                        $pstart .= "\nq\n" . $trx . "\n" . $pmid . "\nQ\n";
                        $endlinepos = strlen($pstart);
                        if($this->inxobj) {
                            $this->xobjects[$this->xobjid]["outdata"] = $pstart . $pend;
                            foreach ($this->xobjects[$this->xobjid]["annotations"] as $pak => $pac) {
                                if($pask <= $pak) {
                                    $this->xobjects[$this->xobjid]["annotations"][$pak]["x"] += $t_x;
                                    $this->xobjects[$this->xobjid]["annotations"][$pak]["y"] -= $yshift;
                                }
                            }
                        } else {
                            $this->setPageBuffer($startlinepage, $pstart . $pend);
                            if(isset($this->PageAnnots[$this->page])) {
                                foreach ($this->PageAnnots[$this->page] as $pak => $pac) {
                                    if($pask <= $pak) {
                                        $this->PageAnnots[$this->page][$pak]["x"] += $t_x;
                                        $this->PageAnnots[$this->page][$pak]["y"] -= $yshift;
                                    }
                                }
                            }
                        }
                        $this->y -= $yshift;
                    }
                }
                $pbrk = $this->checkPageBreak($this->lasth);
                $this->newline = false;
                $startlinex = $this->x;
                $startliney = $this->y;
                if($dom[$dom[$key]["parent"]]["value"] == "sup") {
                    $startliney -= 0 * $this->FontSizePt / $this->k;
                } elseif($dom[$dom[$key]["parent"]]["value"] == "sub") {
                    $startliney -= $this->FontSizePt / 0 / $this->k;
                } else {
                    $minstartliney = $startliney;
                    $maxbottomliney = $this->y + $this->getCellHeight($fontsize / $this->k);
                }
                $startlinepage = $this->page;
                if(isset($endlinepos) && !$pbrk) {
                    $startlinepos = $endlinepos;
                } elseif($this->inxobj) {
                    $startlinepos = strlen($this->xobjects[$this->xobjid]["outdata"]);
                } elseif(!$this->InFooter) {
                    if(isset($this->footerlen[$this->page])) {
                        $this->footerpos[$this->page] = $this->pagelen[$this->page] - $this->footerlen[$this->page];
                    } else {
                        $this->footerpos[$this->page] = $this->pagelen[$this->page];
                    }
                    $startlinepos = $this->footerpos[$this->page];
                } else {
                    $startlinepos = $this->pagelen[$this->page];
                }
                unset($endlinepos);
                $plalign = $lalign;
                if(isset($this->PageAnnots[$this->page])) {
                    $pask = count($this->PageAnnots[$this->page]);
                } else {
                    $pask = 0;
                }
                if(!($dom[$key]["tag"] && !$dom[$key]["opening"] && $dom[$key]["value"] == "table" && isset($this->emptypagemrk[$this->page]) && $this->emptypagemrk[$this->page] == $this->pagelen[$this->page])) {
                    $this->setFont($fontname, $fontstyle, $fontsize);
                    if($wfill) {
                        $this->setFillColorArray($this->bgcolor);
                    }
                }
            }
            if(isset($opentagpos)) {
                unset($opentagpos);
            }
            if($dom[$key]["tag"]) {
                if($dom[$key]["opening"]) {
                    if(isset($dom[$key]["text-indent"]) && $dom[$key]["block"]) {
                        $this->textindent = $dom[$key]["text-indent"];
                        $this->newline = true;
                    }
                    if($dom[$key]["value"] == "table" && isset($dom[$key]["cols"]) && 0 < $dom[$key]["cols"]) {
                        if($this->rtl) {
                            $wtmp = $this->x - $this->lMargin;
                        } else {
                            $wtmp = $this->w - $this->rMargin - $this->x;
                        }
                        if(isset($dom[$key]["attribute"]["cellspacing"])) {
                            $clsp = $this->getHTMLUnitToUnits($dom[$key]["attribute"]["cellspacing"], 1, "px");
                            $cellspacing = ["H" => $clsp, "V" => $clsp];
                        } elseif(isset($dom[$key]["border-spacing"])) {
                            $cellspacing = $dom[$key]["border-spacing"];
                        } else {
                            $cellspacing = ["H" => 0, "V" => 0];
                        }
                        if(isset($dom[$key]["width"])) {
                            $table_width = $this->getHTMLUnitToUnits($dom[$key]["width"], $wtmp, "px");
                        } else {
                            $table_width = $wtmp;
                        }
                        $table_width -= 2 * $cellspacing["H"];
                        if(!$this->inthead) {
                            $this->y += $cellspacing["V"];
                        }
                        if($this->rtl) {
                            $cellspacingx = -1 * $cellspacing["H"];
                        } else {
                            $cellspacingx = $cellspacing["H"];
                        }
                        $table_columns_width = $table_width - $cellspacing["H"] * ($dom[$key]["cols"] - 1);
                        $table_min_column_width = $table_columns_width / $dom[$key]["cols"];
                        $table_colwidths = array_fill(0, $dom[$key]["cols"], $table_min_column_width);
                    }
                    if($dom[$key]["value"] == "tr") {
                        $colid = 0;
                    }
                    if($dom[$key]["value"] == "td" || $dom[$key]["value"] == "th") {
                        $trid = $dom[$key]["parent"];
                        $table_el = $dom[$trid]["parent"];
                        if(!isset($dom[$table_el]["cols"])) {
                            $dom[$table_el]["cols"] = $dom[$trid]["cols"];
                        }
                        $tdborder = 0;
                        if(isset($dom[$key]["border"]) && !empty($dom[$key]["border"])) {
                            $tdborder = $dom[$key]["border"];
                        }
                        $colspan = intval($dom[$key]["attribute"]["colspan"]);
                        if($colspan <= 0) {
                            $colspan = 1;
                        }
                        $old_cell_padding = $this->cell_padding;
                        if(isset($dom[$dom[$trid]["parent"]]["attribute"]["cellpadding"])) {
                            $crclpd = $this->getHTMLUnitToUnits($dom[$dom[$trid]["parent"]]["attribute"]["cellpadding"], 1, "px");
                            $current_cell_padding = ["L" => $crclpd, "T" => $crclpd, "R" => $crclpd, "B" => $crclpd];
                        } elseif(isset($dom[$dom[$trid]["parent"]]["padding"])) {
                            $current_cell_padding = $dom[$dom[$trid]["parent"]]["padding"];
                        } else {
                            $current_cell_padding = ["L" => 0, "T" => 0, "R" => 0, "B" => 0];
                        }
                        $this->cell_padding = $current_cell_padding;
                        if(isset($dom[$key]["height"])) {
                            $cellh = $this->getHTMLUnitToUnits($dom[$key]["height"], 0, "px");
                        } else {
                            $cellh = 0;
                        }
                        if(isset($dom[$key]["content"])) {
                            $cell_content = $dom[$key]["content"];
                        } else {
                            $cell_content = "&nbsp;";
                        }
                        $tagtype = $dom[$key]["value"];
                        for ($parentid = $key; $key < $maxel && !($dom[$key]["tag"] && !$dom[$key]["opening"] && $dom[$key]["value"] == $tagtype && $dom[$key]["parent"] == $parentid); $key++) {
                        }
                        if(!isset($dom[$trid]["startpage"])) {
                            $dom[$trid]["startpage"] = $this->page;
                        } else {
                            $this->setPage($dom[$trid]["startpage"]);
                        }
                        if(!isset($dom[$trid]["startcolumn"])) {
                            $dom[$trid]["startcolumn"] = $this->current_column;
                        } elseif($this->current_column != $dom[$trid]["startcolumn"]) {
                            $tmpx = $this->x;
                            $this->selectColumn($dom[$trid]["startcolumn"]);
                            $this->x = $tmpx;
                        }
                        if(!isset($dom[$trid]["starty"])) {
                            $dom[$trid]["starty"] = $this->y;
                        } else {
                            $this->y = $dom[$trid]["starty"];
                        }
                        if(!isset($dom[$trid]["startx"])) {
                            $dom[$trid]["startx"] = $this->x;
                            $this->x += $cellspacingx;
                        } else {
                            $this->x += $cellspacingx / 2;
                        }
                        if(isset($dom[$parentid]["attribute"]["rowspan"])) {
                            $rowspan = intval($dom[$parentid]["attribute"]["rowspan"]);
                        } else {
                            $rowspan = 1;
                        }
                        if(isset($dom[$table_el]["rowspans"])) {
                            $rsk = 0;
                            $rskmax = count($dom[$table_el]["rowspans"]);
                            while ($rsk < $rskmax) {
                                $trwsp = $dom[$table_el]["rowspans"][$rsk];
                                $rsstartx = $trwsp["startx"];
                                $rsendx = $trwsp["endx"];
                                if($trwsp["startpage"] < $this->page) {
                                    if($this->rtl && $this->pagedim[$this->page]["orm"] != $this->pagedim[$trwsp["startpage"]]["orm"]) {
                                        $dl = $this->pagedim[$this->page]["orm"] - $this->pagedim[$trwsp["startpage"]]["orm"];
                                        $rsstartx -= $dl;
                                        $rsendx -= $dl;
                                    } elseif(!$this->rtl && $this->pagedim[$this->page]["olm"] != $this->pagedim[$trwsp["startpage"]]["olm"]) {
                                        $dl = $this->pagedim[$this->page]["olm"] - $this->pagedim[$trwsp["startpage"]]["olm"];
                                        $rsstartx += $dl;
                                        $rsendx += $dl;
                                    }
                                }
                                if(0 < $trwsp["rowspan"] && $this->x - $cellspacing["H"] - $current_cell_padding["L"] - $this->feps < $rsstartx && $rsstartx < $this->x + $cellspacing["H"] + $current_cell_padding["R"] + $this->feps && ($trwsp["starty"] < $this->y - $this->feps || $trwsp["startpage"] < $this->page || $trwsp["startcolumn"] < $this->current_column)) {
                                    $this->x = $rsendx + $cellspacingx;
                                    $colid += $trwsp["colspan"];
                                    if($trwsp["rowspan"] == 1 && isset($dom[$trid]["endy"]) && isset($dom[$trid]["endpage"]) && isset($dom[$trid]["endcolumn"]) && $trwsp["endpage"] == $dom[$trid]["endpage"] && $trwsp["endcolumn"] == $dom[$trid]["endcolumn"]) {
                                        $dom[$table_el]["rowspans"][$rsk]["endy"] = max($dom[$trid]["endy"], $trwsp["endy"]);
                                        $dom[$trid]["endy"] = $dom[$table_el]["rowspans"][$rsk]["endy"];
                                    }
                                    $rsk = 0;
                                } else {
                                    $rsk++;
                                }
                            }
                        }
                        if(isset($dom[$parentid]["width"])) {
                            $cellw = $this->getHTMLUnitToUnits($dom[$parentid]["width"], $table_columns_width, "px");
                            $tmpcw = $cellw / $colspan;
                            for ($i = 0; $i < $colspan; $i++) {
                                $table_colwidths[$colid + $i] = $tmpcw;
                            }
                        } else {
                            $cellw = 0;
                            for ($i = 0; $i < $colspan; $i++) {
                                $cellw += isset($table_colwidths[$colid + $i]) ? $table_colwidths[$colid + $i] : 0;
                            }
                        }
                        $cellw += ($colspan - 1) * $cellspacing["H"];
                        $colid += $colspan;
                        if(1 < $rowspan) {
                            $trsid = array_push($dom[$table_el]["rowspans"], ["trid" => $trid, "rowspan" => $rowspan, "mrowspan" => $rowspan, "colspan" => $colspan, "startpage" => $this->page, "startcolumn" => $this->current_column, "startx" => $this->x, "starty" => $this->y]);
                        }
                        $cellid = array_push($dom[$trid]["cellpos"], ["startx" => $this->x]);
                        if(1 < $rowspan) {
                            $dom[$trid]["cellpos"][$cellid - 1]["rowspanid"] = $trsid - 1;
                        }
                        if(isset($dom[$parentid]["bgcolor"]) && $dom[$parentid]["bgcolor"] !== false) {
                            $dom[$trid]["cellpos"][$cellid - 1]["bgcolor"] = $dom[$parentid]["bgcolor"];
                        }
                        if(isset($tdborder) && !empty($tdborder)) {
                            $dom[$trid]["cellpos"][$cellid - 1]["border"] = $tdborder;
                        }
                        $prevLastH = $this->lasth;
                        if($this->rtl) {
                            $this->colxshift["x"] = $this->w - $this->x - $this->rMargin;
                        } else {
                            $this->colxshift["x"] = $this->x - $this->lMargin;
                        }
                        $this->colxshift["s"] = $cellspacing;
                        $this->colxshift["p"] = $current_cell_padding;
                        $this->MultiCell($cellw, $cellh, $cell_content, false, $lalign, false, 2, "", "", true, 0, true, true, 0, "T", false);
                        $this->colxshift = ["x" => 0, "s" => ["H" => 0, "V" => 0], "p" => ["L" => 0, "T" => 0, "R" => 0, "B" => 0]];
                        $this->lasth = $prevLastH;
                        $this->cell_padding = $old_cell_padding;
                        $dom[$trid]["cellpos"][$cellid - 1]["endx"] = $this->x;
                        if($rowspan <= 1) {
                            if(isset($dom[$trid]["endy"])) {
                                if($this->page == $dom[$trid]["endpage"] && $this->current_column == $dom[$trid]["endcolumn"]) {
                                    $dom[$trid]["endy"] = max($this->y, $dom[$trid]["endy"]);
                                } elseif($dom[$trid]["endpage"] < $this->page || $dom[$trid]["endcolumn"] < $this->current_column) {
                                    $dom[$trid]["endy"] = $this->y;
                                }
                            } else {
                                $dom[$trid]["endy"] = $this->y;
                            }
                            if(isset($dom[$trid]["endpage"])) {
                                $dom[$trid]["endpage"] = max($this->page, $dom[$trid]["endpage"]);
                            } else {
                                $dom[$trid]["endpage"] = $this->page;
                            }
                            if(isset($dom[$trid]["endcolumn"])) {
                                $dom[$trid]["endcolumn"] = max($this->current_column, $dom[$trid]["endcolumn"]);
                            } else {
                                $dom[$trid]["endcolumn"] = $this->current_column;
                            }
                        } else {
                            $dom[$table_el]["rowspans"][$trsid - 1]["endx"] = $this->x;
                            $dom[$table_el]["rowspans"][$trsid - 1]["endy"] = $this->y;
                            $dom[$table_el]["rowspans"][$trsid - 1]["endpage"] = $this->page;
                            $dom[$table_el]["rowspans"][$trsid - 1]["endcolumn"] = $this->current_column;
                        }
                        if(isset($dom[$table_el]["rowspans"])) {
                            foreach ($dom[$table_el]["rowspans"] as $k => $trwsp) {
                                if(0 < $trwsp["rowspan"] && isset($dom[$trid]["endpage"])) {
                                    if($trwsp["endpage"] == $dom[$trid]["endpage"] && $trwsp["endcolumn"] == $dom[$trid]["endcolumn"]) {
                                        $dom[$table_el]["rowspans"][$k]["endy"] = max($dom[$trid]["endy"], $trwsp["endy"]);
                                    } elseif($trwsp["endpage"] < $dom[$trid]["endpage"] || $trwsp["endcolumn"] < $dom[$trid]["endcolumn"]) {
                                        $dom[$table_el]["rowspans"][$k]["endy"] = $dom[$trid]["endy"];
                                        $dom[$table_el]["rowspans"][$k]["endpage"] = $dom[$trid]["endpage"];
                                        $dom[$table_el]["rowspans"][$k]["endcolumn"] = $dom[$trid]["endcolumn"];
                                    } else {
                                        $dom[$trid]["endy"] = $this->pagedim[$dom[$trid]["endpage"]]["hk"] - $this->pagedim[$dom[$trid]["endpage"]]["bm"];
                                    }
                                }
                            }
                        }
                        $this->x += $cellspacingx / 2;
                    } else {
                        if(!isset($opentagpos)) {
                            if($this->inxobj) {
                                $opentagpos = strlen($this->xobjects[$this->xobjid]["outdata"]);
                            } elseif(!$this->InFooter) {
                                if(isset($this->footerlen[$this->page])) {
                                    $this->footerpos[$this->page] = $this->pagelen[$this->page] - $this->footerlen[$this->page];
                                } else {
                                    $this->footerpos[$this->page] = $this->pagelen[$this->page];
                                }
                                $opentagpos = $this->footerpos[$this->page];
                            }
                        }
                        $dom = $this->openHTMLTagHandler($dom, $key, $cell);
                    }
                } else {
                    $prev_numpages = $this->numpages;
                    $old_bordermrk = $this->bordermrk[$this->page];
                    $dom = $this->closeHTMLTagHandler($dom, $key, $cell, $maxbottomliney);
                    if($old_bordermrk < $this->bordermrk[$this->page]) {
                        $startlinepos += $this->bordermrk[$this->page] - $old_bordermrk;
                    }
                    if($this->numpages < $prev_numpages) {
                        $startlinepage = $this->page;
                    }
                }
            } elseif(0 < strlen($dom[$key]["value"])) {
                if(!TCPDF_STATIC::empty_string($this->lispacer) && $this->lispacer != "^") {
                    $this->setFont($pfontname, $pfontstyle, $pfontsize);
                    $this->resetLastH();
                    $minstartliney = $this->y;
                    $maxbottomliney = $startliney + $this->getCellHeight($this->FontSize);
                    if(is_numeric($pfontsize) && 0 < $pfontsize) {
                        $this->putHtmlListBullet($this->listnum, $this->lispacer, $pfontsize);
                    }
                    $this->setFont($curfontname, $curfontstyle, $curfontsize);
                    $this->resetLastH();
                    if(is_numeric($pfontsize) && 0 < $pfontsize && is_numeric($curfontsize) && 0 < $curfontsize && $pfontsize != $curfontsize) {
                        $pfontascent = $this->getFontAscent($pfontname, $pfontstyle, $pfontsize);
                        $pfontdescent = $this->getFontDescent($pfontname, $pfontstyle, $pfontsize);
                        $this->y += ($this->getCellHeight(($pfontsize - $curfontsize) / $this->k) + $pfontascent - $curfontascent - $pfontdescent + $curfontdescent) / 2;
                        $minstartliney = min($this->y, $minstartliney);
                        $maxbottomliney = max($this->y + $this->getCellHeight($pfontsize / $this->k), $maxbottomliney);
                    }
                }
                $this->htmlvspace = 0;
                preg_match(TCPDF_FONT_DATA::$uni_RE_PATTERN_RTL, $dom[$key]["value"]) or $isRTLString = preg_match(TCPDF_FONT_DATA::$uni_RE_PATTERN_RTL, $dom[$key]["value"]) || preg_match(TCPDF_FONT_DATA::$uni_RE_PATTERN_ARABIC, $dom[$key]["value"]);
                if(!$this->premode && $this->isRTLTextDir() && !$isRTLString) {
                    $lsp = "";
                    $rsp = "";
                    if(preg_match("/^(" . $this->re_space["p"] . "+)/" . $this->re_space["m"], $dom[$key]["value"], $matches)) {
                        $lsp = $matches[1];
                    }
                    if(preg_match("/(" . $this->re_space["p"] . "+)\$/" . $this->re_space["m"], $dom[$key]["value"], $matches)) {
                        $rsp = $matches[1];
                    }
                    $dom[$key]["value"] = $rsp . $this->stringTrim($dom[$key]["value"]) . $lsp;
                }
                if($newline) {
                    if(!$this->premode) {
                        $prelen = strlen($dom[$key]["value"]);
                        if($this->isRTLTextDir() && !$isRTLString) {
                            $dom[$key]["value"] = $this->stringRightTrim($dom[$key]["value"]);
                        } else {
                            $dom[$key]["value"] = $this->stringLeftTrim($dom[$key]["value"]);
                        }
                        $postlen = strlen($dom[$key]["value"]);
                        if($postlen == 0 && 0 < $prelen) {
                            $dom[$key]["trimmed_space"] = true;
                        }
                    }
                    $newline = false;
                    $firstblock = true;
                } else {
                    $firstblock = false;
                    $dom[$key]["value"] = preg_replace("/^" . $this->re_space["p"] . "+\$/" . $this->re_space["m"], chr(32), $dom[$key]["value"]);
                }
                $strrest = "";
                if($this->rtl) {
                    $this->x -= $this->textindent;
                } else {
                    $this->x += $this->textindent;
                }
                if(!isset($dom[$key]["trimmed_space"]) || !$dom[$key]["trimmed_space"]) {
                    $strlinelen = $this->GetStringWidth($dom[$key]["value"]);
                    if(!empty($this->HREF) && isset($this->HREF["url"])) {
                        $hrefcolor = "";
                        if(isset($dom[$dom[$key]["parent"]]["fgcolor"]) && $dom[$dom[$key]["parent"]]["fgcolor"] !== false) {
                            $hrefcolor = $dom[$dom[$key]["parent"]]["fgcolor"];
                        }
                        $hrefstyle = -1;
                        if(isset($dom[$dom[$key]["parent"]]["fontstyle"]) && $dom[$dom[$key]["parent"]]["fontstyle"] !== false) {
                            $hrefstyle = $dom[$dom[$key]["parent"]]["fontstyle"];
                        }
                        $strrest = $this->addHtmlLink($this->HREF["url"], $dom[$key]["value"], $wfill, true, $hrefcolor, $hrefstyle, true);
                    } else {
                        $wadj = 0;
                        if($this->rtl) {
                            $cwa = $this->x - $this->lMargin;
                        } else {
                            $cwa = $this->w - $this->rMargin - $this->x;
                        }
                        if($strlinelen < $cwa && isset($dom[$key + 1]) && $dom[$key + 1]["tag"] && !$dom[$key + 1]["block"]) {
                            $nkey = $key + 1;
                            $write_block = true;
                            $same_textdir = true;
                            $tmp_fontname = $this->FontFamily;
                            $tmp_fontstyle = $this->FontStyle;
                            for ($tmp_fontsize = $this->FontSizePt; $write_block && isset($dom[$nkey]); $nkey++) {
                                if($dom[$nkey]["tag"]) {
                                    if($dom[$nkey]["block"]) {
                                        $write_block = false;
                                    }
                                    $tmp_fontname = isset($dom[$nkey]["fontname"]) ? $dom[$nkey]["fontname"] : $this->FontFamily;
                                    $tmp_fontstyle = isset($dom[$nkey]["fontstyle"]) ? $dom[$nkey]["fontstyle"] : $this->FontStyle;
                                    $tmp_fontsize = isset($dom[$nkey]["fontsize"]) ? $dom[$nkey]["fontsize"] : $this->FontSizePt;
                                    $same_textdir = $dom[$nkey]["dir"] == $dom[$key]["dir"];
                                } else {
                                    $nextstr = TCPDF_STATIC::pregSplit("/" . $this->re_space["p"] . "+/", $this->re_space["m"], $dom[$nkey]["value"]);
                                    if(isset($nextstr[0]) && $same_textdir) {
                                        $wadj += $this->GetStringWidth($nextstr[0], $tmp_fontname, $tmp_fontstyle, $tmp_fontsize);
                                        if(isset($nextstr[1])) {
                                            $write_block = false;
                                        }
                                    }
                                }
                            }
                        }
                        if(0 < $wadj && $cwa <= $strlinelen + $wadj) {
                            $wadj = 0;
                            $nextstr = TCPDF_STATIC::pregSplit("/" . $this->re_space["p"] . "/", $this->re_space["m"], $dom[$key]["value"]);
                            $numblks = count($nextstr);
                            if(1 < $numblks) {
                                $wadj = $cwa - $strlinelen + $this->GetStringWidth($nextstr[$numblks - 1]);
                            } else {
                                $wadj = $this->GetStringWidth($nextstr[0]);
                            }
                        }
                        if(0 < $wadj && ($this->rtl && $this->tmprtl === "L" || !$this->rtl && $this->tmprtl === "R")) {
                            $reverse_dir = true;
                            $this->rtl = !$this->rtl;
                            $revshift = $strlinelen + $wadj + 0;
                            if($this->rtl) {
                                $this->x += $revshift;
                            } else {
                                $this->x -= $revshift;
                            }
                            $xws = $this->x;
                        }
                        $strrest = $this->Write($this->lasth, $dom[$key]["value"], "", $wfill, "", false, 0, true, $firstblock, 0, $wadj);
                        if($reverse_dir && $wadj == 0) {
                            $this->x = $xws;
                            $this->rtl = !$this->rtl;
                            $reverse_dir = false;
                        }
                    }
                }
                $this->textindent = 0;
                if(0 < strlen($strrest)) {
                    $this->newline = true;
                    if($strrest == $dom[$key]["value"]) {
                        $loop++;
                    } else {
                        $loop = 0;
                    }
                    $dom[$key]["value"] = $strrest;
                    if($cell) {
                        if($this->rtl) {
                            $this->x -= $this->cell_padding["R"];
                        } else {
                            $this->x += $this->cell_padding["L"];
                        }
                    }
                    if($loop < 3) {
                        --$key;
                    }
                } else {
                    $loop = 0;
                    if(0 < $this->font_spacing) {
                        if($this->rtl) {
                            $this->x -= $this->font_spacing;
                        } else {
                            $this->x += $this->font_spacing;
                        }
                    }
                }
            }
            $key++;
            if(isset($dom[$key]["tag"]) && $dom[$key]["tag"] && (!isset($dom[$key]["opening"]) || !$dom[$key]["opening"]) && isset($dom[$dom[$key]["parent"]]["attribute"]["nobr"]) && $dom[$dom[$key]["parent"]]["attribute"]["nobr"] == "true") {
                if(!$undo && ($this->y < $this->start_transaction_y || $dom[$key]["value"] == "tr" && $dom[$dom[$key]["parent"]]["endy"] < $this->start_transaction_y)) {
                    $this->rollbackTransaction(true);
                    foreach ($this_method_vars as $vkey => $vval) {
                        ${$vkey} = $vval;
                    }
                    if(!empty($dom[$key]["thead"])) {
                        $this->inthead = true;
                    }
                    $pre_y = $this->y;
                    if(!$this->checkPageBreak($this->PageBreakTrigger + 1) && $this->y < $pre_y) {
                        $startliney = $this->y;
                    }
                    $undo = true;
                } else {
                    $undo = false;
                }
            }
        }
        if(isset($startlinex)) {
            $yshift = $minstartliney - $startliney;
            if(0 < $yshift || $startlinepage < $this->page) {
                $yshift = 0;
            }
            $t_x = 0;
            $linew = abs($this->endlinex - $startlinex);
            if($this->inxobj) {
                $pstart = substr($this->xobjects[$this->xobjid]["outdata"], 0, $startlinepos);
                if(isset($opentagpos)) {
                    $midpos = $opentagpos;
                } else {
                    $midpos = 0;
                }
                if(0 < $midpos) {
                    $pmid = substr($this->xobjects[$this->xobjid]["outdata"], $startlinepos, $midpos - $startlinepos);
                    $pend = substr($this->xobjects[$this->xobjid]["outdata"], $midpos);
                } else {
                    $pmid = substr($this->xobjects[$this->xobjid]["outdata"], $startlinepos);
                    $pend = "";
                }
            } else {
                $pstart = substr($this->getPageBuffer($startlinepage), 0, $startlinepos);
                if(isset($opentagpos) && isset($this->footerlen[$startlinepage]) && !$this->InFooter) {
                    $this->footerpos[$startlinepage] = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                    $midpos = min($opentagpos, $this->footerpos[$startlinepage]);
                } elseif(isset($opentagpos)) {
                    $midpos = $opentagpos;
                } elseif(isset($this->footerlen[$startlinepage]) && !$this->InFooter) {
                    $this->footerpos[$startlinepage] = $this->pagelen[$startlinepage] - $this->footerlen[$startlinepage];
                    $midpos = $this->footerpos[$startlinepage];
                } else {
                    $midpos = 0;
                }
                if(0 < $midpos) {
                    $pmid = substr($this->getPageBuffer($startlinepage), $startlinepos, $midpos - $startlinepos);
                    $pend = substr($this->getPageBuffer($startlinepage), $midpos);
                } else {
                    $pmid = substr($this->getPageBuffer($startlinepage), $startlinepos);
                    $pend = "";
                }
            }
            if(isset($plalign) && ($plalign == "C" || $plalign == "R" && !$this->rtl || $plalign == "L" && $this->rtl)) {
                $tw = $w;
                if($this->lMargin != $prevlMargin) {
                    $tw += $prevlMargin - $this->lMargin;
                }
                if($this->rMargin != $prevrMargin) {
                    $tw += $prevrMargin - $this->rMargin;
                }
                $one_space_width = $this->GetStringWidth(chr(32));
                $no = 0;
                if($this->isRTLTextDir()) {
                    $pos1 = TCPDF_STATIC::revstrpos($pmid, "[(");
                    if(0 < $pos1) {
                        $pos1 = intval($pos1);
                        if($this->isUnicodeFont()) {
                            $pos2 = intval(TCPDF_STATIC::revstrpos($pmid, "[(" . chr(0) . chr(32)));
                            $spacelen = 2;
                        } else {
                            $pos2 = intval(TCPDF_STATIC::revstrpos($pmid, "[(" . chr(32)));
                            $spacelen = 1;
                        }
                        if($pos1 == $pos2) {
                            $pmid = substr($pmid, 0, $pos1 + 2) . substr($pmid, $pos1 + 2 + $spacelen);
                            if(substr($pmid, $pos1, 4) == "[()]") {
                                $linew -= $one_space_width;
                            } elseif($pos1 == strpos($pmid, "[(")) {
                                $no = 1;
                            }
                        }
                    }
                } else {
                    $pos1 = TCPDF_STATIC::revstrpos($pmid, ")]");
                    if(0 < $pos1) {
                        $pos1 = intval($pos1);
                        if($this->isUnicodeFont()) {
                            $pos2 = intval(TCPDF_STATIC::revstrpos($pmid, chr(0) . chr(32) . ")]")) + 2;
                            $spacelen = 2;
                        } else {
                            $pos2 = intval(TCPDF_STATIC::revstrpos($pmid, chr(32) . ")]")) + 1;
                            $spacelen = 1;
                        }
                        if($pos1 == $pos2) {
                            $pmid = substr($pmid, 0, $pos1 - $spacelen) . substr($pmid, $pos1);
                            $linew -= $one_space_width;
                        }
                    }
                }
                $mdiff = $tw - $linew;
                if($plalign == "C") {
                    if($this->rtl) {
                        $t_x = -1 * $mdiff / 2;
                    } else {
                        $t_x = $mdiff / 2;
                    }
                } elseif($plalign == "R") {
                    $t_x = $mdiff;
                } elseif($plalign == "L") {
                    $t_x = -1 * $mdiff;
                }
            }
            if($t_x != 0 || $yshift < 0) {
                $trx = sprintf("1 0 0 1 %F %F cm", $t_x * $this->k, $yshift * $this->k);
                $pstart .= "\nq\n" . $trx . "\n" . $pmid . "\nQ\n";
                $endlinepos = strlen($pstart);
                if($this->inxobj) {
                    $this->xobjects[$this->xobjid]["outdata"] = $pstart . $pend;
                    foreach ($this->xobjects[$this->xobjid]["annotations"] as $pak => $pac) {
                        if($pask <= $pak) {
                            $this->xobjects[$this->xobjid]["annotations"][$pak]["x"] += $t_x;
                            $this->xobjects[$this->xobjid]["annotations"][$pak]["y"] -= $yshift;
                        }
                    }
                } else {
                    $this->setPageBuffer($startlinepage, $pstart . $pend);
                    if(isset($this->PageAnnots[$this->page])) {
                        foreach ($this->PageAnnots[$this->page] as $pak => $pac) {
                            if($pask <= $pak) {
                                $this->PageAnnots[$this->page][$pak]["x"] += $t_x;
                                $this->PageAnnots[$this->page][$pak]["y"] -= $yshift;
                            }
                        }
                    }
                }
                $this->y -= $yshift;
                $yshift = 0;
            }
        }
        $this->setGraphicVars($gvars);
        if(1 < $this->num_columns) {
            $this->selectColumn();
        } elseif($prevPage < $this->page) {
            $this->lMargin = $this->pagedim[$this->page]["olm"];
            $this->rMargin = $this->pagedim[$this->page]["orm"];
        }
        $this->cell_height_ratio = $prev_cell_height_ratio;
        $this->listnum = $prev_listnum;
        $this->listordered = $prev_listordered;
        $this->listcount = $prev_listcount;
        $this->lispacer = $prev_lispacer;
        if($ln && !($cell && $dom[$key - 1]["value"] == "table")) {
            $this->Ln($this->lasth);
            if($this->y < $maxbottomliney && $startlinepage == $this->page) {
                $this->y = $maxbottomliney;
            }
        }
        unset($dom);
    }
    protected function openHTMLTagHandler($dom, $key, $cell)
    {
        $tag = $dom[$key];
        $parent = $dom[$dom[$key]["parent"]];
        $firsttag = $key == 1;
        if(isset($tag["dir"])) {
            $this->setTempRTL($tag["dir"]);
        } else {
            $this->tmprtl = false;
        }
        if($tag["block"]) {
            $hbz = 0;
            $hb = 0;
            if(isset($this->tagvspaces[$tag["value"]][0]["h"]) && !empty($this->tagvspaces[$tag["value"]][0]["h"]) && 0 <= $this->tagvspaces[$tag["value"]][0]["h"]) {
                $cur_h = $this->tagvspaces[$tag["value"]][0]["h"];
            } elseif(isset($tag["fontsize"])) {
                $cur_h = $this->getCellHeight($tag["fontsize"] / $this->k);
            } else {
                $cur_h = $this->getCellHeight($this->FontSize);
            }
            if(isset($this->tagvspaces[$tag["value"]][0]["n"])) {
                $on = $this->tagvspaces[$tag["value"]][0]["n"];
            } elseif(0 < preg_match("/[h][0-9]/", $tag["value"])) {
                $on = 0;
            } else {
                $on = 1;
            }
            if(!isset($this->tagvspaces[$tag["value"]]) && in_array($tag["value"], ["div", "dt", "dd", "li", "br", "hr"])) {
                $hb = 0;
            } else {
                $hb = $on * $cur_h;
            }
            if($this->htmlvspace <= 0 && 0 < $on) {
                if(isset($parent["fontsize"])) {
                    $hbz = $parent["fontsize"] / $this->k * $this->cell_height_ratio;
                } else {
                    $hbz = $this->getCellHeight($this->FontSize);
                }
            }
            if(isset($dom[$key - 1]) && $dom[$key - 1]["value"] == "table") {
                $hbz = 0;
            }
            $hbc = 0;
            if(isset($this->tagvspaces[$tag["value"]][1]["h"]) && !empty($this->tagvspaces[$tag["value"]][1]["h"]) && 0 <= $this->tagvspaces[$tag["value"]][1]["h"]) {
                $pre_h = $this->tagvspaces[$tag["value"]][1]["h"];
            } elseif(isset($parent["fontsize"])) {
                $pre_h = $this->getCellHeight($parent["fontsize"] / $this->k);
            } else {
                $pre_h = $this->getCellHeight($this->FontSize);
            }
            if(isset($this->tagvspaces[$tag["value"]][1]["n"])) {
                $cn = $this->tagvspaces[$tag["value"]][1]["n"];
            } elseif(0 < preg_match("/[h][0-9]/", $tag["value"])) {
                $cn = 0;
            } else {
                $cn = 1;
            }
            if(isset($this->tagvspaces[$tag["value"]][1])) {
                $hbc = $cn * $pre_h;
            }
        }
        switch ($tag["value"]) {
            case "table":
                $cp = 0;
                $cs = 0;
                $dom[$key]["rowspans"] = [];
                if(!isset($dom[$key]["attribute"]["nested"]) || $dom[$key]["attribute"]["nested"] != "true") {
                    $this->htmlvspace = 0;
                    if(!TCPDF_STATIC::empty_string($dom[$key]["thead"])) {
                        $this->thead = $dom[$key]["thead"];
                        if(!isset($this->theadMargins) || empty($this->theadMargins)) {
                            $this->theadMargins = [];
                            $this->theadMargins["cell_padding"] = $this->cell_padding;
                            $this->theadMargins["lmargin"] = $this->lMargin;
                            $this->theadMargins["rmargin"] = $this->rMargin;
                            $this->theadMargins["page"] = $this->page;
                            $this->theadMargins["cell"] = $cell;
                            $this->theadMargins["gvars"] = $this->getGraphicVars();
                        }
                    }
                }
                $dom[$key]["old_cell_padding"] = $this->cell_padding;
                if(isset($tag["attribute"]["cellpadding"])) {
                    $pad = $this->getHTMLUnitToUnits($tag["attribute"]["cellpadding"], 1, "px");
                    $this->setCellPadding($pad);
                } elseif(isset($tag["padding"])) {
                    $this->cell_padding = $tag["padding"];
                }
                if(isset($tag["attribute"]["cellspacing"])) {
                    $cs = $this->getHTMLUnitToUnits($tag["attribute"]["cellspacing"], 1, "px");
                } elseif(isset($tag["border-spacing"])) {
                    $cs = $tag["border-spacing"]["V"];
                }
                $prev_y = $this->y;
                if($this->checkPageBreak(2 * $cp + 2 * $cs + $this->lasth, "", false) || $this->y < $prev_y) {
                    $this->inthead = true;
                    $this->checkPageBreak($this->PageBreakTrigger + 1);
                }
                break;
            case "tr":
                $dom[$key]["cellpos"] = [];
                break;
            case "hr":
                if(isset($tag["height"]) && $tag["height"] != "") {
                    $hrHeight = $this->getHTMLUnitToUnits($tag["height"], 1, "px");
                } else {
                    $hrHeight = $this->GetLineWidth();
                }
                $this->addHTMLVertSpace($hbz, max($hb, $hrHeight / 2), $cell, $firsttag);
                $x = $this->GetX();
                $y = $this->GetY();
                $wtmp = $this->w - $this->lMargin - $this->rMargin;
                if($cell) {
                    $wtmp -= $this->cell_padding["L"] + $this->cell_padding["R"];
                }
                if(isset($tag["width"]) && $tag["width"] != "") {
                    $hrWidth = $this->getHTMLUnitToUnits($tag["width"], $wtmp, "px");
                } else {
                    $hrWidth = $wtmp;
                }
                $prevlinewidth = $this->GetLineWidth();
                $this->setLineWidth($hrHeight);
                $lineStyle = [];
                if(isset($tag["fgcolor"])) {
                    $lineStyle["color"] = $tag["fgcolor"];
                }
                if(isset($tag["fgcolor"])) {
                    $lineStyle["color"] = $tag["fgcolor"];
                }
                if(isset($tag["style"]["cap"])) {
                    $lineStyle["cap"] = $tag["style"]["cap"];
                }
                if(isset($tag["style"]["join"])) {
                    $lineStyle["join"] = $tag["style"]["join"];
                }
                if(isset($tag["style"]["dash"])) {
                    $lineStyle["dash"] = $tag["style"]["dash"];
                }
                if(isset($tag["style"]["phase"])) {
                    $lineStyle["phase"] = $tag["style"]["phase"];
                }
                $lineStyle = array_filter($lineStyle);
                $this->Line($x, $y, $x + $hrWidth, $y, $lineStyle);
                $this->setLineWidth($prevlinewidth);
                $this->addHTMLVertSpace(max($hbc, $hrHeight / 2), 0, $cell, !isset($dom[$key + 1]));
                break;
            case "a":
                if(array_key_exists("href", $tag["attribute"])) {
                    $this->HREF["url"] = $tag["attribute"]["href"];
                }
                break;
            case "img":
                if(empty($tag["attribute"]["src"])) {
                } else {
                    $imgsrc = $tag["attribute"]["src"];
                    if($imgsrc[0] === "@") {
                        $imgsrc = "@" . base64_decode(substr($imgsrc, 1));
                        $type = "";
                    } elseif($this->allowLocalFiles && substr($imgsrc, 0, 7) === "file://") {
                        $imgsrc = substr($imgsrc, 7);
                        $type = TCPDF_IMAGES::getImageFileType($imgsrc);
                    } else {
                        if($imgsrc[0] === "/" && !empty($_SERVER["DOCUMENT_ROOT"]) && $_SERVER["DOCUMENT_ROOT"] != "/") {
                            $findroot = strpos($imgsrc, $_SERVER["DOCUMENT_ROOT"]);
                            if($findroot === false || 1 < $findroot) {
                                if(substr($_SERVER["DOCUMENT_ROOT"], -1) == "/") {
                                    $imgsrc = substr($_SERVER["DOCUMENT_ROOT"], 0, -1) . $imgsrc;
                                } else {
                                    $imgsrc = $_SERVER["DOCUMENT_ROOT"] . $imgsrc;
                                }
                            }
                            $imgsrc = urldecode($imgsrc);
                            $testscrtype = @parse_url($imgsrc);
                            if(empty($testscrtype["query"])) {
                                $imgsrc = str_replace(K_PATH_URL, K_PATH_MAIN, $imgsrc);
                            } elseif(preg_match("|^https?://|", $imgsrc) !== 1) {
                                $imgsrc = str_replace(K_PATH_MAIN, K_PATH_URL, $imgsrc);
                            }
                        }
                        $type = TCPDF_IMAGES::getImageFileType($imgsrc);
                    }
                    if(!isset($tag["width"])) {
                        $tag["width"] = 0;
                    }
                    if(!isset($tag["height"])) {
                        $tag["height"] = 0;
                    }
                    $tag["attribute"]["align"] = "bottom";
                    switch ($tag["attribute"]["align"]) {
                        case "top":
                            $align = "T";
                            break;
                        case "middle":
                            $align = "M";
                            break;
                        case "bottom":
                            $align = "B";
                            break;
                        default:
                            $align = "B";
                            $prevy = $this->y;
                            $xpos = $this->x;
                            $imglink = "";
                            if(isset($this->HREF["url"]) && !TCPDF_STATIC::empty_string($this->HREF["url"])) {
                                $imglink = $this->HREF["url"];
                                if($imglink[0] == "#") {
                                    $lnkdata = explode(",", $imglink);
                                    if(isset($lnkdata[0])) {
                                        $page = intval(substr($lnkdata[0], 1));
                                        if(empty($page) || $page <= 0) {
                                            $page = $this->page;
                                        }
                                        if(isset($lnkdata[1]) && 0 < strlen($lnkdata[1])) {
                                            $lnky = floatval($lnkdata[1]);
                                        } else {
                                            $lnky = 0;
                                        }
                                        $imglink = $this->AddLink();
                                        $this->setLink($imglink, $lnky, $page);
                                    }
                                }
                            }
                            $border = 0;
                            if(isset($tag["border"]) && !empty($tag["border"])) {
                                $border = $tag["border"];
                            }
                            $iw = "";
                            if(isset($tag["width"])) {
                                $iw = $this->getHTMLUnitToUnits($tag["width"], $tag["fontsize"] / $this->k, "px", false);
                            }
                            $ih = "";
                            if(isset($tag["height"])) {
                                $ih = $this->getHTMLUnitToUnits($tag["height"], $tag["fontsize"] / $this->k, "px", false);
                            }
                            if($type == "eps" || $type == "ai") {
                                $this->ImageEps($imgsrc, $xpos, $this->y, $iw, $ih, $imglink, true, $align, "", $border, true);
                            } elseif($type == "svg") {
                                $this->ImageSVG($imgsrc, $xpos, $this->y, $iw, $ih, $imglink, $align, "", $border, true);
                            } else {
                                $this->Image($imgsrc, $xpos, $this->y, $iw, $ih, "", $imglink, $align, false, 300, "", false, false, $border, false, false, true);
                            }
                            switch ($align) {
                                case "T":
                                    $this->y = $prevy;
                                    break;
                                case "M":
                                    $this->y = ($this->img_rb_y + $prevy - $this->getCellHeight($tag["fontsize"] / $this->k)) / 2;
                                    break;
                                case "B":
                                    $this->y = $this->img_rb_y - ($this->getCellHeight($tag["fontsize"] / $this->k) - $this->getFontDescent($tag["fontname"], $tag["fontstyle"], $tag["fontsize"]) * $this->cell_height_ratio);
                                    break;
                            }
                    }
                }
                break;
            case "dl":
                $this->listnum++;
                if($this->listnum == 1) {
                    $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                } else {
                    $this->addHTMLVertSpace(0, 0, $cell, $firsttag);
                }
                break;
            case "dt":
                $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                break;
            case "dd":
                if($this->rtl) {
                    $this->rMargin += $this->listindent;
                } else {
                    $this->lMargin += $this->listindent;
                }
                $this->listindentlevel++;
                $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                break;
            case "ul":
            case "ol":
                $this->listnum++;
                if($tag["value"] == "ol") {
                    $this->listordered[$this->listnum] = true;
                } else {
                    $this->listordered[$this->listnum] = false;
                }
                if(isset($tag["attribute"]["start"])) {
                    $this->listcount[$this->listnum] = intval($tag["attribute"]["start"]) - 1;
                } else {
                    $this->listcount[$this->listnum] = 0;
                }
                if($this->rtl) {
                    $this->rMargin += $this->listindent;
                    $this->x -= $this->listindent;
                } else {
                    $this->lMargin += $this->listindent;
                    $this->x += $this->listindent;
                }
                $this->listindentlevel++;
                if($this->listnum == 1) {
                    if(1 < $key) {
                        $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                    }
                } else {
                    $this->addHTMLVertSpace(0, 0, $cell, $firsttag);
                }
                break;
            case "li":
                if(2 < $key) {
                    $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                }
                if($this->listordered[$this->listnum]) {
                    if(isset($parent["attribute"]["type"]) && !TCPDF_STATIC::empty_string($parent["attribute"]["type"])) {
                        $this->lispacer = $parent["attribute"]["type"];
                    } elseif(isset($parent["listtype"]) && !TCPDF_STATIC::empty_string($parent["listtype"])) {
                        $this->lispacer = $parent["listtype"];
                    } elseif(isset($this->lisymbol) && !TCPDF_STATIC::empty_string($this->lisymbol)) {
                        $this->lispacer = $this->lisymbol;
                    } else {
                        $this->lispacer = "#";
                    }
                    $this->listcount[$this->listnum]++;
                    if(isset($tag["attribute"]["value"])) {
                        $this->listcount[$this->listnum] = intval($tag["attribute"]["value"]);
                    }
                } elseif(isset($parent["attribute"]["type"]) && !TCPDF_STATIC::empty_string($parent["attribute"]["type"])) {
                    $this->lispacer = $parent["attribute"]["type"];
                } elseif(isset($parent["listtype"]) && !TCPDF_STATIC::empty_string($parent["listtype"])) {
                    $this->lispacer = $parent["listtype"];
                } elseif(isset($this->lisymbol) && !TCPDF_STATIC::empty_string($this->lisymbol)) {
                    $this->lispacer = $this->lisymbol;
                } else {
                    $this->lispacer = "!";
                }
                break;
            case "blockquote":
                if($this->rtl) {
                    $this->rMargin += $this->listindent;
                } else {
                    $this->lMargin += $this->listindent;
                }
                $this->listindentlevel++;
                $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                break;
            case "br":
                $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                break;
            case "div":
                $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                break;
            case "p":
                $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                break;
            case "pre":
                $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                $this->premode = true;
                break;
            case "sup":
                $this->setXY($this->GetX(), $this->GetY() - 0 * $this->FontSizePt / $this->k);
                break;
            case "sub":
                $this->setXY($this->GetX(), $this->GetY() + 0 * $this->FontSizePt / $this->k);
                break;
            case "h1":
            case "h2":
            case "h3":
            case "h4":
            case "h5":
            case "h6":
                $this->addHTMLVertSpace($hbz, $hb, $cell, $firsttag);
                break;
            case "form":
                if(isset($tag["attribute"]["action"])) {
                    $this->form_action = $tag["attribute"]["action"];
                } else {
                    $this->Error("Please explicitly set action attribute path!");
                }
                if(isset($tag["attribute"]["enctype"])) {
                    $this->form_enctype = $tag["attribute"]["enctype"];
                } else {
                    $this->form_enctype = "application/x-www-form-urlencoded";
                }
                if(isset($tag["attribute"]["method"])) {
                    $this->form_mode = $tag["attribute"]["method"];
                } else {
                    $this->form_mode = "post";
                }
                break;
            case "input":
                if(isset($tag["attribute"]["name"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["name"])) {
                    $name = $tag["attribute"]["name"];
                    $prop = [];
                    $opt = [];
                    if(isset($tag["attribute"]["readonly"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["readonly"])) {
                        $prop["readonly"] = true;
                    }
                    if(isset($tag["attribute"]["value"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["value"])) {
                        $value = $tag["attribute"]["value"];
                    }
                    if(isset($tag["attribute"]["maxlength"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["maxlength"])) {
                        $opt["maxlen"] = intval($tag["attribute"]["maxlength"]);
                    }
                    $h = $this->getCellHeight($this->FontSize);
                    if(isset($tag["attribute"]["size"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["size"])) {
                        $w = intval($tag["attribute"]["size"]) * $this->GetStringWidth(chr(32)) * 2;
                    } else {
                        $w = $h;
                    }
                    if(isset($tag["attribute"]["checked"]) && ($tag["attribute"]["checked"] == "checked" || $tag["attribute"]["checked"] == "true")) {
                        $checked = true;
                    } else {
                        $checked = false;
                    }
                    if(isset($tag["align"])) {
                        switch ($tag["align"]) {
                            case "C":
                                $opt["q"] = 1;
                                break;
                            case "R":
                                $opt["q"] = 2;
                                break;
                            case "L":
                        }
                    }
                    switch ($tag["attribute"]["type"]) {
                        case "text":
                            if(isset($value)) {
                                $opt["v"] = $value;
                            }
                            $this->TextField($name, $w, $h, $prop, $opt, "", "", false);
                            break;
                        case "password":
                            if(isset($value)) {
                                $opt["v"] = $value;
                            }
                            $prop["password"] = "true";
                            $this->TextField($name, $w, $h, $prop, $opt, "", "", false);
                            break;
                        case "checkbox":
                            if(!isset($value)) {
                            } else {
                                $this->CheckBox($name, $w, $checked, $prop, $opt, $value, "", "", false);
                            }
                            break;
                        case "radio":
                            if(!isset($value)) {
                            } else {
                                $this->RadioButton($name, $w, $prop, $opt, $value, $checked, "", "", false);
                            }
                            break;
                        case "submit":
                            if(!isset($value)) {
                                $value = "submit";
                            }
                            $w = $this->GetStringWidth($value) * 0;
                            $h *= 0;
                            $prop = ["lineWidth" => 1, "borderStyle" => "beveled", "fillColor" => [196, 196, 196], "strokeColor" => [255, 255, 255]];
                            $action = [];
                            $action["S"] = "SubmitForm";
                            $action["F"] = $this->form_action;
                            if($this->form_enctype != "FDF") {
                                $action["Flags"] = ["ExportFormat"];
                            }
                            if($this->form_mode == "get") {
                                $action["Flags"] = ["GetMethod"];
                            }
                            $this->Button($name, $w, $h, $value, $action, $prop, $opt, "", "", false);
                            break;
                        case "reset":
                            if(!isset($value)) {
                                $value = "reset";
                            }
                            $w = $this->GetStringWidth($value) * 0;
                            $h *= 0;
                            $prop = ["lineWidth" => 1, "borderStyle" => "beveled", "fillColor" => [196, 196, 196], "strokeColor" => [255, 255, 255]];
                            $this->Button($name, $w, $h, $value, ["S" => "ResetForm"], $prop, $opt, "", "", false);
                            break;
                        case "file":
                            $prop["fileSelect"] = "true";
                            $this->TextField($name, $w, $h, $prop, $opt, "", "", false);
                            if(!isset($value)) {
                                $value = "*";
                            }
                            $w = $this->GetStringWidth($value) * 2;
                            $h *= 0;
                            $prop = ["lineWidth" => 1, "borderStyle" => "beveled", "fillColor" => [196, 196, 196], "strokeColor" => [255, 255, 255]];
                            $jsaction = "var f=this.getField('" . $name . "'); f.browseForFileToSubmit();";
                            $this->Button("FB_" . $name, $w, $h, $value, $jsaction, $prop, $opt, "", "", false);
                            break;
                        case "hidden":
                            if(isset($value)) {
                                $opt["v"] = $value;
                            }
                            $opt["f"] = ["invisible", "hidden"];
                            $this->TextField($name, 0, 0, $prop, $opt, "", "", false);
                            break;
                        case "image":
                            if(isset($tag["attribute"]["src"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["src"])) {
                                $img = $tag["attribute"]["src"];
                                $value = "img";
                                if(isset($tag["attribute"]["onclick"]) && !empty($tag["attribute"]["onclick"])) {
                                    $jsaction = $tag["attribute"]["onclick"];
                                } else {
                                    $jsaction = "";
                                }
                                $this->Button($name, $w, $h, $value, $jsaction, $prop, $opt, "", "", false);
                            }
                            break;
                        case "button":
                            if(!isset($value)) {
                                $value = " ";
                            }
                            $w = $this->GetStringWidth($value) * 0;
                            $h *= 0;
                            $prop = ["lineWidth" => 1, "borderStyle" => "beveled", "fillColor" => [196, 196, 196], "strokeColor" => [255, 255, 255]];
                            if(isset($tag["attribute"]["onclick"]) && !empty($tag["attribute"]["onclick"])) {
                                $jsaction = $tag["attribute"]["onclick"];
                            } else {
                                $jsaction = "";
                            }
                            $this->Button($name, $w, $h, $value, $jsaction, $prop, $opt, "", "", false);
                            break;
                    }
                }
                break;
            case "textarea":
                $prop = [];
                $opt = [];
                if(isset($tag["attribute"]["readonly"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["readonly"])) {
                    $prop["readonly"] = true;
                }
                if(isset($tag["attribute"]["name"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["name"])) {
                    $name = $tag["attribute"]["name"];
                    if(isset($tag["attribute"]["value"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["value"])) {
                        $opt["v"] = $tag["attribute"]["value"];
                    }
                    if(isset($tag["attribute"]["cols"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["cols"])) {
                        $w = intval($tag["attribute"]["cols"]) * $this->GetStringWidth(chr(32)) * 2;
                    } else {
                        $w = 40;
                    }
                    if(isset($tag["attribute"]["rows"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["rows"])) {
                        $h = intval($tag["attribute"]["rows"]) * $this->getCellHeight($this->FontSize);
                    } else {
                        $h = 10;
                    }
                    $prop["multiline"] = "true";
                    $this->TextField($name, $w, $h, $prop, $opt, "", "", false);
                }
                break;
            case "select":
                $h = $this->getCellHeight($this->FontSize);
                if(isset($tag["attribute"]["size"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["size"])) {
                    $h *= $tag["attribute"]["size"] + 1;
                }
                $prop = [];
                $opt = [];
                if(isset($tag["attribute"]["name"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["name"])) {
                    $name = $tag["attribute"]["name"];
                    $w = 0;
                    if(isset($tag["attribute"]["opt"]) && !TCPDF_STATIC::empty_string($tag["attribute"]["opt"])) {
                        $options = explode("#!NwL!#", $tag["attribute"]["opt"]);
                        $values = [];
                        foreach ($options as $val) {
                            if(strpos($val, "#!TaB!#") !== false) {
                                $opts = explode("#!TaB!#", $val);
                                $values[] = $opts;
                                $w = max($w, $this->GetStringWidth($opts[1]));
                            } else {
                                $values[] = $val;
                                $w = max($w, $this->GetStringWidth($val));
                            }
                        }
                        $w *= 2;
                        $tag["attribute"]["multiple"] = "multiple";
                        if(isset($tag["attribute"]["multiple"]) && $tag["attribute"]["multiple"]) {
                            $prop["multipleSelection"] = "true";
                            $this->ListBox($name, $w, $h, $values, $prop, $opt, "", "", false);
                        } else {
                            $this->ComboBox($name, $w, $h, $values, $prop, $opt, "", "", false);
                        }
                    }
                }
                break;
            case "tcpdf":
                if(defined("K_TCPDF_CALLS_IN_HTML") && K_TCPDF_CALLS_IN_HTML === true && isset($tag["attribute"]["method"])) {
                    $tcpdf_method = $tag["attribute"]["method"];
                    if(method_exists($this, $tcpdf_method)) {
                        if(isset($tag["attribute"]["params"]) && !empty($tag["attribute"]["params"])) {
                            $params = $this->unserializeTCPDFtagParameters($tag["attribute"]["params"]);
                            call_user_func_array([$this, $tcpdf_method], $params);
                        } else {
                            $this->{$tcpdf_method}();
                        }
                        $this->newline = true;
                    }
                }
                break;
            default:
                $bordertags = ["blockquote", "br", "dd", "dl", "div", "dt", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "li", "ol", "p", "pre", "ul", "tcpdf", "table"];
                if(in_array($tag["value"], $bordertags)) {
                    $dom[$key]["borderposition"] = $this->getBorderStartPosition();
                }
                if($dom[$key]["self"] && isset($dom[$key]["attribute"]["pagebreakafter"])) {
                    $pba = $dom[$key]["attribute"]["pagebreakafter"];
                    if($pba == "true" || $pba == "left" || $pba == "right") {
                        $this->checkPageBreak($this->PageBreakTrigger + 1);
                    }
                    if($pba == "left" && (!$this->rtl && $this->page % 2 == 0 || $this->rtl && $this->page % 2 != 0) || $pba == "right" && (!$this->rtl && $this->page % 2 != 0 || $this->rtl && $this->page % 2 == 0)) {
                        $this->checkPageBreak($this->PageBreakTrigger + 1);
                    }
                }
                return $dom;
        }
    }
    protected function closeHTMLTagHandler($dom, $key, $cell, $maxbottomliney = 0)
    {
        $tag = $dom[$key];
        $parent = $dom[$dom[$key]["parent"]];
        !isset($dom[$key + 1]) or $lasttag = !isset($dom[$key + 1]) || !isset($dom[$key + 2]) && $dom[$key + 1]["value"] == "marker";
        $in_table_head = false;
        if($this->rtl) {
            $xmax = $this->w;
        } else {
            $xmax = 0;
        }
        if($tag["block"]) {
            $hbz = 0;
            $hb = 0;
            if(isset($this->tagvspaces[$tag["value"]][1]["h"]) && !empty($this->tagvspaces[$tag["value"]][1]["h"]) && 0 <= $this->tagvspaces[$tag["value"]][1]["h"]) {
                $pre_h = $this->tagvspaces[$tag["value"]][1]["h"];
            } elseif(isset($parent["fontsize"])) {
                $pre_h = $this->getCellHeight($parent["fontsize"] / $this->k);
            } else {
                $pre_h = $this->getCellHeight($this->FontSize);
            }
            if(isset($this->tagvspaces[$tag["value"]][1]["n"])) {
                $cn = $this->tagvspaces[$tag["value"]][1]["n"];
            } elseif(0 < preg_match("/[h][0-9]/", $tag["value"])) {
                $cn = 0;
            } else {
                $cn = 1;
            }
            if(!isset($this->tagvspaces[$tag["value"]]) && $tag["value"] == "div") {
                $hb = 0;
            } else {
                $hb = $cn * $pre_h;
            }
            if($this->PageBreakTrigger < $maxbottomliney) {
                $hbz = $this->getCellHeight($this->FontSize);
            } elseif($this->y < $maxbottomliney) {
                $hbz = $maxbottomliney - $this->y;
            }
        }
        switch ($tag["value"]) {
            case "tr":
                $table_el = $dom[$dom[$key]["parent"]]["parent"];
                if(!isset($parent["endy"])) {
                    $dom[$dom[$key]["parent"]]["endy"] = $this->y;
                    $parent["endy"] = $this->y;
                }
                if(!isset($parent["endpage"])) {
                    $dom[$dom[$key]["parent"]]["endpage"] = $this->page;
                    $parent["endpage"] = $this->page;
                }
                if(!isset($parent["endcolumn"])) {
                    $dom[$dom[$key]["parent"]]["endcolumn"] = $this->current_column;
                    $parent["endcolumn"] = $this->current_column;
                }
                if(isset($dom[$table_el]["rowspans"])) {
                    foreach ($dom[$table_el]["rowspans"] as $k => $trwsp) {
                        $dom[$table_el]["rowspans"][$k]["rowspan"] -= 1;
                        if($dom[$table_el]["rowspans"][$k]["rowspan"] == 0) {
                            if($dom[$table_el]["rowspans"][$k]["endpage"] == $parent["endpage"] && $dom[$table_el]["rowspans"][$k]["endcolumn"] == $parent["endcolumn"]) {
                                $dom[$dom[$key]["parent"]]["endy"] = max($dom[$table_el]["rowspans"][$k]["endy"], $parent["endy"]);
                            } elseif($parent["endpage"] < $dom[$table_el]["rowspans"][$k]["endpage"] || $parent["endcolumn"] < $dom[$table_el]["rowspans"][$k]["endcolumn"]) {
                                $dom[$dom[$key]["parent"]]["endy"] = $dom[$table_el]["rowspans"][$k]["endy"];
                                $dom[$dom[$key]["parent"]]["endpage"] = $dom[$table_el]["rowspans"][$k]["endpage"];
                                $dom[$dom[$key]["parent"]]["endcolumn"] = $dom[$table_el]["rowspans"][$k]["endcolumn"];
                            }
                        }
                    }
                    foreach ($dom[$table_el]["rowspans"] as $k => $trwsp) {
                        if($dom[$table_el]["rowspans"][$k]["rowspan"] == 0) {
                            $dom[$table_el]["rowspans"][$k]["endpage"] = max($dom[$table_el]["rowspans"][$k]["endpage"], $dom[$dom[$key]["parent"]]["endpage"]);
                            $dom[$dom[$key]["parent"]]["endpage"] = $dom[$table_el]["rowspans"][$k]["endpage"];
                            $dom[$table_el]["rowspans"][$k]["endcolumn"] = max($dom[$table_el]["rowspans"][$k]["endcolumn"], $dom[$dom[$key]["parent"]]["endcolumn"]);
                            $dom[$dom[$key]["parent"]]["endcolumn"] = $dom[$table_el]["rowspans"][$k]["endcolumn"];
                            $dom[$table_el]["rowspans"][$k]["endy"] = max($dom[$table_el]["rowspans"][$k]["endy"], $dom[$dom[$key]["parent"]]["endy"]);
                            $dom[$dom[$key]["parent"]]["endy"] = $dom[$table_el]["rowspans"][$k]["endy"];
                        }
                    }
                    foreach ($dom[$table_el]["rowspans"] as $k => $trwsp) {
                        if($dom[$table_el]["rowspans"][$k]["rowspan"] == 0) {
                            $dom[$table_el]["rowspans"][$k]["endpage"] = $dom[$dom[$key]["parent"]]["endpage"];
                            $dom[$table_el]["rowspans"][$k]["endcolumn"] = $dom[$dom[$key]["parent"]]["endcolumn"];
                            $dom[$table_el]["rowspans"][$k]["endy"] = $dom[$dom[$key]["parent"]]["endy"];
                        }
                    }
                }
                $prev_page = $this->page;
                $this->setPage($dom[$dom[$key]["parent"]]["endpage"]);
                if(1 < $this->num_columns) {
                    if($prev_page < $this->page && ($this->current_column == 0 && $dom[$dom[$key]["parent"]]["endcolumn"] == $this->num_columns - 1 || $this->current_column == $dom[$dom[$key]["parent"]]["endcolumn"])) {
                        $this->selectColumn(0);
                        $dom[$dom[$key]["parent"]]["endcolumn"] = 0;
                        $dom[$dom[$key]["parent"]]["endy"] = $this->y;
                    } else {
                        $this->selectColumn($dom[$dom[$key]["parent"]]["endcolumn"]);
                        $this->y = $dom[$dom[$key]["parent"]]["endy"];
                    }
                } else {
                    $this->y = $dom[$dom[$key]["parent"]]["endy"];
                }
                if(isset($dom[$table_el]["attribute"]["cellspacing"])) {
                    $this->y += $this->getHTMLUnitToUnits($dom[$table_el]["attribute"]["cellspacing"], 1, "px");
                } elseif(isset($dom[$table_el]["border-spacing"])) {
                    $this->y += $dom[$table_el]["border-spacing"]["V"];
                }
                $this->Ln(0, $cell);
                if($this->current_column == $parent["startcolumn"]) {
                    $this->x = $parent["startx"];
                }
                if($parent["startpage"] < $this->page) {
                    if($this->rtl && $this->pagedim[$this->page]["orm"] != $this->pagedim[$parent["startpage"]]["orm"]) {
                        $this->x -= $this->pagedim[$this->page]["orm"] - $this->pagedim[$parent["startpage"]]["orm"];
                    } elseif(!$this->rtl && $this->pagedim[$this->page]["olm"] != $this->pagedim[$parent["startpage"]]["olm"]) {
                        $this->x += $this->pagedim[$this->page]["olm"] - $this->pagedim[$parent["startpage"]]["olm"];
                    }
                }
                break;
            case "tablehead":
                $in_table_head = true;
                $this->inthead = false;
                break;
            case "table":
                $table_el = $parent;
                if(isset($table_el["attribute"]["border"]) && 0 < $table_el["attribute"]["border"]) {
                    $border = ["LTRB" => ["width" => $this->getCSSBorderWidth($table_el["attribute"]["border"]), "cap" => "square", "join" => "miter", "dash" => 0, "color" => [0, 0, 0]]];
                } else {
                    $border = 0;
                }
                $default_border = $border;
                foreach ($dom[$dom[$key]["parent"]]["trids"] as $j => $trkey) {
                    if(isset($dom[$dom[$key]["parent"]]["rowspans"])) {
                        foreach ($dom[$dom[$key]["parent"]]["rowspans"] as $k => $trwsp) {
                            if(isset($prevtrkey) && $trwsp["trid"] == $prevtrkey && 0 < $trwsp["mrowspan"]) {
                                $dom[$dom[$key]["parent"]]["rowspans"][$k]["trid"] = $trkey;
                            }
                            if($dom[$dom[$key]["parent"]]["rowspans"][$k]["trid"] == $trkey) {
                                $dom[$dom[$key]["parent"]]["rowspans"][$k]["mrowspan"] -= 1;
                            }
                        }
                    }
                    if(isset($prevtrkey) && $dom[$prevtrkey]["endpage"] < $dom[$trkey]["startpage"]) {
                        $pgendy = $this->pagedim[$dom[$prevtrkey]["endpage"]]["hk"] - $this->pagedim[$dom[$prevtrkey]["endpage"]]["bm"];
                        $dom[$prevtrkey]["endy"] = $pgendy;
                        if(isset($dom[$dom[$key]["parent"]]["rowspans"])) {
                            foreach ($dom[$dom[$key]["parent"]]["rowspans"] as $k => $trwsp) {
                                if($trwsp["trid"] == $prevtrkey && 0 <= $trwsp["mrowspan"] && $trwsp["endpage"] == $dom[$prevtrkey]["endpage"]) {
                                    $dom[$dom[$key]["parent"]]["rowspans"][$k]["endy"] = $pgendy;
                                    $dom[$dom[$key]["parent"]]["rowspans"][$k]["mrowspan"] = -1;
                                }
                            }
                        }
                    }
                    $prevtrkey = $trkey;
                    $table_el = $dom[$dom[$key]["parent"]];
                }
                if(0 < count($table_el["trids"])) {
                    unset($xmax);
                }
                foreach ($table_el["trids"] as $j => $trkey) {
                    $parent = $dom[$trkey];
                    if(!isset($xmax)) {
                        $xmax = $parent["cellpos"][count($parent["cellpos"]) - 1]["endx"];
                    }
                    foreach ($parent["cellpos"] as $k => $cellpos) {
                        if(isset($cellpos["rowspanid"]) && 0 <= $cellpos["rowspanid"]) {
                            $cellpos["startx"] = $table_el["rowspans"][$cellpos["rowspanid"]]["startx"];
                            $cellpos["endx"] = $table_el["rowspans"][$cellpos["rowspanid"]]["endx"];
                            $endy = $table_el["rowspans"][$cellpos["rowspanid"]]["endy"];
                            $startpage = $table_el["rowspans"][$cellpos["rowspanid"]]["startpage"];
                            $endpage = $table_el["rowspans"][$cellpos["rowspanid"]]["endpage"];
                            $startcolumn = $table_el["rowspans"][$cellpos["rowspanid"]]["startcolumn"];
                            $endcolumn = $table_el["rowspans"][$cellpos["rowspanid"]]["endcolumn"];
                        } else {
                            $endy = $parent["endy"];
                            $startpage = $parent["startpage"];
                            $endpage = $parent["endpage"];
                            $startcolumn = $parent["startcolumn"];
                            $endcolumn = $parent["endcolumn"];
                        }
                        if($this->num_columns == 0) {
                            $this->num_columns = 1;
                        }
                        if(isset($cellpos["border"])) {
                            $border = $cellpos["border"];
                        }
                        if(isset($cellpos["bgcolor"]) && $cellpos["bgcolor"] !== false) {
                            $this->setFillColorArray($cellpos["bgcolor"]);
                            $fill = true;
                        } else {
                            $fill = false;
                        }
                        $x = $cellpos["startx"];
                        $y = $parent["starty"];
                        $starty = $y;
                        $w = abs($cellpos["endx"] - $cellpos["startx"]);
                        $border_start = TCPDF_STATIC::getBorderMode($border, $position = "start", $this->opencell);
                        $border_end = TCPDF_STATIC::getBorderMode($border, $position = "end", $this->opencell);
                        $border_middle = TCPDF_STATIC::getBorderMode($border, $position = "middle", $this->opencell);
                        for ($page = $startpage; $page <= $endpage; $page++) {
                            $ccode = "";
                            $this->setPage($page);
                            if($this->num_columns < 2) {
                                $this->x = $x;
                                $this->y = $this->tMargin;
                            }
                            if($startpage < $page) {
                                if($this->rtl && $this->pagedim[$page]["orm"] != $this->pagedim[$startpage]["orm"]) {
                                    $this->x -= $this->pagedim[$page]["orm"] - $this->pagedim[$startpage]["orm"];
                                } elseif(!$this->rtl && $this->pagedim[$page]["olm"] != $this->pagedim[$startpage]["olm"]) {
                                    $this->x += $this->pagedim[$page]["olm"] - $this->pagedim[$startpage]["olm"];
                                }
                            }
                            if($startpage == $endpage) {
                                $deltacol = 0;
                                $deltath = 0;
                                for ($column = $startcolumn; $column <= $endcolumn; $column++) {
                                    $this->selectColumn($column);
                                    if($startcolumn == $endcolumn) {
                                        $cborder = $border;
                                        $h = $endy - $parent["starty"];
                                        $this->y = $y;
                                        $this->x = $x;
                                    } elseif($column == $startcolumn) {
                                        $cborder = $border_start;
                                        $this->y = $starty;
                                        $this->x = $x;
                                        $h = $this->h - $this->y - $this->bMargin;
                                        if($this->rtl) {
                                            $deltacol = $this->x + $this->rMargin - $this->w;
                                        } else {
                                            $deltacol = $this->x - $this->lMargin;
                                        }
                                    } elseif($column == $endcolumn) {
                                        $cborder = $border_end;
                                        if(isset($this->columns[$column]["th"]["'" . $page . "'"])) {
                                            $this->y = $this->columns[$column]["th"]["'" . $page . "'"];
                                        }
                                        $this->x += $deltacol;
                                        $h = $endy - $this->y;
                                    } else {
                                        $cborder = $border_middle;
                                        if(isset($this->columns[$column]["th"]["'" . $page . "'"])) {
                                            $this->y = $this->columns[$column]["th"]["'" . $page . "'"];
                                        }
                                        $this->x += $deltacol;
                                        $h = $this->h - $this->y - $this->bMargin;
                                    }
                                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                                }
                            } elseif($page == $startpage) {
                                $deltacol = 0;
                                $deltath = 0;
                                for ($column = $startcolumn; $column < $this->num_columns; $column++) {
                                    $this->selectColumn($column);
                                    if($column == $startcolumn) {
                                        $cborder = $border_start;
                                        $this->y = $starty;
                                        $this->x = $x;
                                        $h = $this->h - $this->y - $this->bMargin;
                                        if($this->rtl) {
                                            $deltacol = $this->x + $this->rMargin - $this->w;
                                        } else {
                                            $deltacol = $this->x - $this->lMargin;
                                        }
                                    } else {
                                        $cborder = $border_middle;
                                        if(isset($this->columns[$column]["th"]["'" . $page . "'"])) {
                                            $this->y = $this->columns[$column]["th"]["'" . $page . "'"];
                                        }
                                        $this->x += $deltacol;
                                        $h = $this->h - $this->y - $this->bMargin;
                                    }
                                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                                }
                            } elseif($page == $endpage) {
                                $deltacol = 0;
                                $deltath = 0;
                                for ($column = 0; $column <= $endcolumn; $column++) {
                                    $this->selectColumn($column);
                                    if($column == $endcolumn) {
                                        $cborder = $border_end;
                                        if(isset($this->columns[$column]["th"]["'" . $page . "'"])) {
                                            $this->y = $this->columns[$column]["th"]["'" . $page . "'"];
                                        }
                                        $this->x += $deltacol;
                                        $h = $endy - $this->y;
                                    } else {
                                        $cborder = $border_middle;
                                        if(isset($this->columns[$column]["th"]["'" . $page . "'"])) {
                                            $this->y = $this->columns[$column]["th"]["'" . $page . "'"];
                                        }
                                        $this->x += $deltacol;
                                        $h = $this->h - $this->y - $this->bMargin;
                                    }
                                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                                }
                            } else {
                                $deltacol = 0;
                                $deltath = 0;
                                for ($column = 0; $column < $this->num_columns; $column++) {
                                    $this->selectColumn($column);
                                    $cborder = $border_middle;
                                    if(isset($this->columns[$column]["th"]["'" . $page . "'"])) {
                                        $this->y = $this->columns[$column]["th"]["'" . $page . "'"];
                                    }
                                    $this->x += $deltacol;
                                    $h = $this->h - $this->y - $this->bMargin;
                                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                                }
                            }
                            if(!empty($cborder) || !empty($fill)) {
                                $offsetlen = strlen($ccode);
                                if($this->inxobj) {
                                    if(end($this->xobjects[$this->xobjid]["transfmrk"]) !== false) {
                                        $pagemarkkey = key($this->xobjects[$this->xobjid]["transfmrk"]);
                                        $pagemark = $this->xobjects[$this->xobjid]["transfmrk"][$pagemarkkey];
                                        $this->xobjects[$this->xobjid]["transfmrk"][$pagemarkkey] += $offsetlen;
                                    } else {
                                        $pagemark = $this->xobjects[$this->xobjid]["intmrk"];
                                        $this->xobjects[$this->xobjid]["intmrk"] += $offsetlen;
                                    }
                                    $pagebuff = $this->xobjects[$this->xobjid]["outdata"];
                                    $pstart = substr($pagebuff, 0, $pagemark);
                                    $pend = substr($pagebuff, $pagemark);
                                    $this->xobjects[$this->xobjid]["outdata"] = $pstart . $ccode . $pend;
                                } else {
                                    if(end($this->transfmrk[$this->page]) !== false) {
                                        $pagemarkkey = key($this->transfmrk[$this->page]);
                                        $pagemark = $this->transfmrk[$this->page][$pagemarkkey];
                                    } elseif($this->InFooter) {
                                        $pagemark = $this->footerpos[$this->page];
                                    } else {
                                        $pagemark = $this->intmrk[$this->page];
                                    }
                                    $pagebuff = $this->getPageBuffer($this->page);
                                    $pstart = substr($pagebuff, 0, $pagemark);
                                    $pend = substr($pagebuff, $pagemark);
                                    $this->setPageBuffer($this->page, $pstart . $ccode . $pend);
                                }
                            }
                        }
                        $border = $default_border;
                    }
                    if(isset($table_el["attribute"]["cellspacing"])) {
                        $this->y += $this->getHTMLUnitToUnits($table_el["attribute"]["cellspacing"], 1, "px");
                    } elseif(isset($table_el["border-spacing"])) {
                        $this->y += $table_el["border-spacing"]["V"];
                    }
                    $this->Ln(0, $cell);
                    $this->x = $parent["startx"];
                    if($startpage < $endpage) {
                        if($this->rtl && $this->pagedim[$endpage]["orm"] != $this->pagedim[$startpage]["orm"]) {
                            $this->x += $this->pagedim[$endpage]["orm"] - $this->pagedim[$startpage]["orm"];
                        } elseif(!$this->rtl && $this->pagedim[$endpage]["olm"] != $this->pagedim[$startpage]["olm"]) {
                            $this->x += $this->pagedim[$endpage]["olm"] - $this->pagedim[$startpage]["olm"];
                        }
                    }
                }
                if(!$in_table_head) {
                    $this->cell_padding = isset($table_el["old_cell_padding"]) ? $table_el["old_cell_padding"] : NULL;
                    $this->resetLastH();
                    if($this->page == $this->numpages - 1 && $this->pageopen[$this->numpages]) {
                        $plendiff = $this->pagelen[$this->numpages] - $this->emptypagemrk[$this->numpages];
                        if(0 < $plendiff && $plendiff < 60) {
                            $pagediff = substr($this->getPageBuffer($this->numpages), $this->emptypagemrk[$this->numpages], $plendiff);
                            if(substr($pagediff, 0, 5) == "BT /F") {
                                $plendiff = 0;
                            }
                        }
                        if($plendiff == 0) {
                            $this->deletePage($this->numpages);
                        }
                    }
                    if(isset($this->theadMargins["top"])) {
                        $this->tMargin = $this->theadMargins["top"];
                    }
                    if(!isset($table_el["attribute"]["nested"]) || $table_el["attribute"]["nested"] != "true") {
                        $this->thead = "";
                        $this->theadMargins = [];
                        $this->pagedim[$this->page]["tm"] = $this->tMargin;
                    }
                }
                $parent = $table_el;
                break;
            case "a":
                $this->HREF = [];
                break;
            case "sup":
                $this->setXY($this->GetX(), $this->GetY() + 0 * $parent["fontsize"] / $this->k);
                break;
            case "sub":
                $this->setXY($this->GetX(), $this->GetY() - 0 * $parent["fontsize"] / $this->k);
                break;
            case "div":
                $this->addHTMLVertSpace($hbz, $hb, $cell, false, $lasttag);
                break;
            case "blockquote":
                if($this->rtl) {
                    $this->rMargin -= $this->listindent;
                } else {
                    $this->lMargin -= $this->listindent;
                }
                --$this->listindentlevel;
                $this->addHTMLVertSpace($hbz, $hb, $cell, false, $lasttag);
                break;
            case "p":
                $this->addHTMLVertSpace($hbz, $hb, $cell, false, $lasttag);
                break;
            case "pre":
                $this->addHTMLVertSpace($hbz, $hb, $cell, false, $lasttag);
                $this->premode = false;
                break;
            case "dl":
                --$this->listnum;
                if($this->listnum <= 0) {
                    $this->listnum = 0;
                    $this->addHTMLVertSpace($hbz, $hb, $cell, false, $lasttag);
                } else {
                    $this->addHTMLVertSpace(0, 0, $cell, false, $lasttag);
                }
                $this->resetLastH();
                break;
            case "dt":
                $this->lispacer = "";
                $this->addHTMLVertSpace(0, 0, $cell, false, $lasttag);
                break;
            case "dd":
                $this->lispacer = "";
                if($this->rtl) {
                    $this->rMargin -= $this->listindent;
                } else {
                    $this->lMargin -= $this->listindent;
                }
                --$this->listindentlevel;
                $this->addHTMLVertSpace(0, 0, $cell, false, $lasttag);
                break;
            case "ul":
            case "ol":
                --$this->listnum;
                $this->lispacer = "";
                if($this->rtl) {
                    $this->rMargin -= $this->listindent;
                } else {
                    $this->lMargin -= $this->listindent;
                }
                --$this->listindentlevel;
                if($this->listnum <= 0) {
                    $this->listnum = 0;
                    $this->addHTMLVertSpace($hbz, $hb, $cell, false, $lasttag);
                } else {
                    $this->addHTMLVertSpace(0, 0, $cell, false, $lasttag);
                }
                $this->resetLastH();
                break;
            case "li":
                $this->lispacer = "";
                $this->addHTMLVertSpace(0, 0, $cell, false, $lasttag);
                break;
            case "h1":
            case "h2":
            case "h3":
            case "h4":
            case "h5":
            case "h6":
                $this->addHTMLVertSpace($hbz, $hb, $cell, false, $lasttag);
                break;
            case "form":
                $this->form_action = "";
                $this->form_enctype = "application/x-www-form-urlencoded";
                break;
            default:
                $this->drawHTMLTagBorder($parent, $xmax);
                if(isset($dom[$dom[$key]["parent"]]["attribute"]["pagebreakafter"])) {
                    $pba = $dom[$dom[$key]["parent"]]["attribute"]["pagebreakafter"];
                    if($pba == "true" || $pba == "left" || $pba == "right") {
                        $this->checkPageBreak($this->PageBreakTrigger + 1);
                    }
                    if($pba == "left" && (!$this->rtl && $this->page % 2 == 0 || $this->rtl && $this->page % 2 != 0) || $pba == "right" && (!$this->rtl && $this->page % 2 != 0 || $this->rtl && $this->page % 2 == 0)) {
                        $this->checkPageBreak($this->PageBreakTrigger + 1);
                    }
                }
                $this->tmprtl = false;
                return $dom;
        }
    }
    protected function addHTMLVertSpace($hbz = 0, $hb = 0, $cell = false, $firsttag = false, $lasttag = false)
    {
        if($firsttag) {
            $this->Ln(0, $cell);
            $this->htmlvspace = 0;
        } elseif($lasttag) {
            $this->Ln($hbz, $cell);
            $this->htmlvspace = 0;
        } else {
            if($hb < $this->htmlvspace) {
                $hd = 0;
            } else {
                $hd = $hb - $this->htmlvspace;
                $this->htmlvspace = $hb;
            }
            $this->Ln($hbz + $hd, $cell);
        }
    }
    protected function getBorderStartPosition()
    {
        if($this->rtl) {
            $xmax = $this->lMargin;
        } else {
            $xmax = $this->w - $this->rMargin;
        }
        return ["page" => $this->page, "column" => $this->current_column, "x" => $this->x, "y" => $this->y, "xmax" => $xmax];
    }
    protected function drawHTMLTagBorder($tag, $xmax)
    {
        if(!isset($tag["borderposition"])) {
            return NULL;
        }
        $prev_x = $this->x;
        $prev_y = $this->y;
        $prev_lasth = $this->lasth;
        $border = 0;
        $fill = false;
        $this->lasth = 0;
        if(isset($tag["border"]) && !empty($tag["border"])) {
            $border = $tag["border"];
            if(!TCPDF_STATIC::empty_string($this->thead) && !$this->inthead) {
                $border = TCPDF_STATIC::getBorderMode($border, $position = "middle", $this->opencell);
            }
        }
        if(isset($tag["bgcolor"]) && $tag["bgcolor"] !== false) {
            $old_bgcolor = $this->bgcolor;
            $this->setFillColorArray($tag["bgcolor"]);
            $fill = true;
        }
        if(!$border && !$fill) {
            return NULL;
        }
        if(isset($tag["attribute"]["cellspacing"])) {
            $clsp = $this->getHTMLUnitToUnits($tag["attribute"]["cellspacing"], 1, "px");
            $cellspacing = ["H" => $clsp, "V" => $clsp];
        } elseif(isset($tag["border-spacing"])) {
            $cellspacing = $tag["border-spacing"];
        } else {
            $cellspacing = ["H" => 0, "V" => 0];
        }
        if($tag["value"] != "table" && is_array($border) && !empty($border)) {
            $border["mode"] = "ext";
        }
        if($this->rtl) {
            if($tag["borderposition"]["x"] <= $xmax) {
                $xmax = $tag["borderposition"]["xmax"];
            }
            $w = $tag["borderposition"]["x"] - $xmax;
        } else {
            if($xmax <= $tag["borderposition"]["x"]) {
                $xmax = $tag["borderposition"]["xmax"];
            }
            $w = $xmax - $tag["borderposition"]["x"];
        }
        if($w <= 0) {
            return NULL;
        }
        $w += $cellspacing["H"];
        $startpage = $tag["borderposition"]["page"];
        $startcolumn = $tag["borderposition"]["column"];
        $x = $tag["borderposition"]["x"];
        $y = $tag["borderposition"]["y"];
        $endpage = $this->page;
        $starty = $tag["borderposition"]["y"] - $cellspacing["V"];
        $currentY = $this->y;
        $this->x = $x;
        $endcolumn = $this->current_column;
        if($this->num_columns == 0) {
            $this->num_columns = 1;
        }
        $border_start = TCPDF_STATIC::getBorderMode($border, $position = "start", $this->opencell);
        $border_end = TCPDF_STATIC::getBorderMode($border, $position = "end", $this->opencell);
        $border_middle = TCPDF_STATIC::getBorderMode($border, $position = "middle", $this->opencell);
        $temp_page_regions = $this->page_regions;
        $this->page_regions = [];
        for ($page = $startpage; $page <= $endpage; $page++) {
            $ccode = "";
            $this->setPage($page);
            if($this->num_columns < 2) {
                $this->x = $x;
                $this->y = $this->tMargin;
            }
            if($startpage < $page) {
                if($this->rtl && $this->pagedim[$page]["orm"] != $this->pagedim[$startpage]["orm"]) {
                    $this->x -= $this->pagedim[$page]["orm"] - $this->pagedim[$startpage]["orm"];
                } elseif(!$this->rtl && $this->pagedim[$page]["olm"] != $this->pagedim[$startpage]["olm"]) {
                    $this->x += $this->pagedim[$page]["olm"] - $this->pagedim[$startpage]["olm"];
                }
            }
            if($startpage == $endpage) {
                for ($column = $startcolumn; $column <= $endcolumn; $column++) {
                    $this->selectColumn($column);
                    if($startcolumn == $endcolumn) {
                        $cborder = $border;
                        $h = $currentY - $y + $cellspacing["V"];
                        $this->y = $starty;
                    } elseif($column == $startcolumn) {
                        $cborder = $border_start;
                        $this->y = $starty;
                        $h = $this->h - $this->y - $this->bMargin;
                    } elseif($column == $endcolumn) {
                        $cborder = $border_end;
                        $h = $currentY - $this->y;
                    } else {
                        $cborder = $border_middle;
                        $h = $this->h - $this->y - $this->bMargin;
                    }
                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                }
            } elseif($page == $startpage) {
                for ($column = $startcolumn; $column < $this->num_columns; $column++) {
                    $this->selectColumn($column);
                    if($column == $startcolumn) {
                        $cborder = $border_start;
                        $this->y = $starty;
                        $h = $this->h - $this->y - $this->bMargin;
                    } else {
                        $cborder = $border_middle;
                        $h = $this->h - $this->y - $this->bMargin;
                    }
                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                }
            } elseif($page == $endpage) {
                for ($column = 0; $column <= $endcolumn; $column++) {
                    $this->selectColumn($column);
                    if($column == $endcolumn) {
                        $cborder = $border_end;
                        $h = $currentY - $this->y;
                    } else {
                        $cborder = $border_middle;
                        $h = $this->h - $this->y - $this->bMargin;
                    }
                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                }
            } else {
                for ($column = 0; $column < $this->num_columns; $column++) {
                    $this->selectColumn($column);
                    $cborder = $border_middle;
                    $h = $this->h - $this->y - $this->bMargin;
                    $ccode .= $this->getCellCode($w, $h, "", $cborder, 1, "", $fill, "", 0, true) . "\n";
                }
            }
            if($cborder || $fill) {
                $offsetlen = strlen($ccode);
                if($this->inxobj) {
                    if(end($this->xobjects[$this->xobjid]["transfmrk"]) !== false) {
                        $pagemarkkey = key($this->xobjects[$this->xobjid]["transfmrk"]);
                        $pagemark = $this->xobjects[$this->xobjid]["transfmrk"][$pagemarkkey];
                        $this->xobjects[$this->xobjid]["transfmrk"][$pagemarkkey] += $offsetlen;
                    } else {
                        $pagemark = $this->xobjects[$this->xobjid]["intmrk"];
                        $this->xobjects[$this->xobjid]["intmrk"] += $offsetlen;
                    }
                    $pagebuff = $this->xobjects[$this->xobjid]["outdata"];
                    $pstart = substr($pagebuff, 0, $pagemark);
                    $pend = substr($pagebuff, $pagemark);
                    $this->xobjects[$this->xobjid]["outdata"] = $pstart . $ccode . $pend;
                } else {
                    if(end($this->transfmrk[$this->page]) !== false) {
                        $pagemarkkey = key($this->transfmrk[$this->page]);
                        $pagemark = $this->transfmrk[$this->page][$pagemarkkey];
                    } elseif($this->InFooter) {
                        $pagemark = $this->footerpos[$this->page];
                    } else {
                        $pagemark = $this->intmrk[$this->page];
                    }
                    $pagebuff = $this->getPageBuffer($this->page);
                    $pstart = substr($pagebuff, 0, $pagemark);
                    $pend = substr($pagebuff, $pagemark);
                    $this->setPageBuffer($this->page, $pstart . $ccode . $pend);
                    $this->bordermrk[$this->page] += $offsetlen;
                    $this->cntmrk[$this->page] += $offsetlen;
                }
            }
        }
        $this->page_regions = $temp_page_regions;
        if(isset($old_bgcolor)) {
            $this->setFillColorArray($old_bgcolor);
        }
        $this->x = $prev_x;
        $this->y = $prev_y;
        $this->lasth = $prev_lasth;
    }
    public function setLIsymbol($symbol = "!")
    {
        if(substr($symbol, 0, 4) == "img|") {
            $this->lisymbol = $symbol;
        } else {
            $symbol = strtolower($symbol);
            $valid_symbols = ["!", "#", "disc", "circle", "square", "1", "decimal", "decimal-leading-zero", "i", "lower-roman", "I", "upper-roman", "a", "lower-alpha", "lower-latin", "A", "upper-alpha", "upper-latin", "lower-greek"];
            if(in_array($symbol, $valid_symbols)) {
                $this->lisymbol = $symbol;
            } else {
                $this->lisymbol = "";
            }
        }
    }
    public function setBooklet($booklet = true, $inner = -1, $outer = -1)
    {
        $this->booklet = $booklet;
        if(0 <= $inner) {
            $this->lMargin = $inner;
        }
        if(0 <= $outer) {
            $this->rMargin = $outer;
        }
    }
    protected function swapMargins($reverse = true)
    {
        if($reverse) {
            $mtemp = $this->original_lMargin;
            $this->original_lMargin = $this->original_rMargin;
            $this->original_rMargin = $mtemp;
            $deltam = $this->original_lMargin - $this->original_rMargin;
            $this->lMargin += $deltam;
            $this->rMargin -= $deltam;
        }
    }
    public function setHtmlVSpace($tagvs)
    {
        $this->tagvspaces = $tagvs;
    }
    public function setListIndentWidth($width)
    {
        return $this->customlistindent = floatval($width);
    }
    public function setOpenCell($isopen)
    {
        $this->opencell = $isopen;
    }
    public function setHtmlLinksStyle($color = [0, 0, 255], $fontstyle = "U")
    {
        $this->htmlLinkColorArray = $color;
        $this->htmlLinkFontStyle = $fontstyle;
    }
    public function getHTMLUnitToUnits($htmlval, $refsize = 1, $defaultunit = "px", $points = false)
    {
        $supportedunits = ["%", "em", "ex", "px", "in", "cm", "mm", "pc", "pt"];
        $retval = 0;
        $value = 0;
        $unit = "px";
        if($points) {
            $k = 1;
        } else {
            $k = $this->k;
        }
        if(in_array($defaultunit, $supportedunits)) {
            $unit = $defaultunit;
        }
        if(is_numeric($htmlval)) {
            $value = floatval($htmlval);
        } elseif(preg_match("/([0-9\\.\\-\\+]+)/", $htmlval, $mnum)) {
            $value = floatval($mnum[1]);
            if(preg_match("/([a-z%]+)/", $htmlval, $munit) && in_array($munit[1], $supportedunits)) {
                $unit = $munit[1];
            }
        }
        switch ($unit) {
            case "%":
                $retval = $value * $refsize / 100;
                break;
            case "em":
                $retval = $value * $refsize;
                break;
            case "ex":
                $retval = $value * $refsize / 2;
                break;
            case "in":
                $retval = $value * $this->dpi / $k;
                break;
            case "cm":
                $retval = $value / 0 * $this->dpi / $k;
                break;
            case "mm":
                $retval = $value / 0 * $this->dpi / $k;
                break;
            case "pc":
                $retval = $value * 12 / $k;
                break;
            case "pt":
                $retval = $value / $k;
                break;
            case "px":
                $retval = $this->pixelsToUnits($value);
                if($points) {
                    $retval *= $this->k;
                }
                break;
            default:
                return $retval;
        }
    }
    protected function putHtmlListBullet($listdepth, $listtype = "", $size = 10)
    {
        if($this->state != 2) {
            return NULL;
        }
        $size /= $this->k;
        $fill = "";
        $bgcolor = $this->bgcolor;
        $color = $this->fgcolor;
        $strokecolor = $this->strokecolor;
        $width = 0;
        $textitem = "";
        $tmpx = $this->x;
        $lspace = $this->GetStringWidth("  ");
        if($listtype == "^") {
            $this->lispacer = "";
        } else {
            if($listtype == "!") {
                $deftypes = ["disc", "circle", "square"];
                $listtype = $deftypes[($listdepth - 1) % 3];
            } elseif($listtype == "#") {
                $listtype = "decimal";
            } elseif(substr($listtype, 0, 4) == "img|") {
                $img = explode("|", $listtype);
                $listtype = "img";
            }
            switch ($listtype) {
                case "none":
                case "disc":
                    $r = $size / 6;
                    $lspace += 2 * $r;
                    if($this->rtl) {
                        $this->x += $lspace;
                    } else {
                        $this->x -= $lspace;
                    }
                    $this->Circle($this->x + $r, $this->y + $this->lasth / 2, $r, 0, 360, "F", [], $color, 8);
                    break;
                case "circle":
                    $r = $size / 6;
                    $lspace += 2 * $r;
                    if($this->rtl) {
                        $this->x += $lspace;
                    } else {
                        $this->x -= $lspace;
                    }
                    $prev_line_style = $this->linestyleWidth . " " . $this->linestyleCap . " " . $this->linestyleJoin . " " . $this->linestyleDash . " " . $this->DrawColor;
                    $new_line_style = ["width" => $r / 3, "cap" => "butt", "join" => "miter", "dash" => 0, "phase" => 0, "color" => $color];
                    $this->Circle($this->x + $r, $this->y + $this->lasth / 2, $r * 0, 0, 360, "D", $new_line_style, [], 8);
                    $this->_out($prev_line_style);
                    break;
                case "square":
                    $l = $size / 3;
                    $lspace += $l;
                    if($this->rtl) {
                        $this->x += $lspace;
                    } else {
                        $this->x -= $lspace;
                    }
                    $this->Rect($this->x, $this->y + ($this->lasth - $l) / 2, $l, $l, "F", [], $color);
                    break;
                case "img":
                    $lspace += $img[2];
                    if($this->rtl) {
                        $this->x += $lspace;
                    } else {
                        $this->x -= $lspace;
                    }
                    $imgtype = strtolower($img[1]);
                    $prev_y = $this->y;
                    switch ($imgtype) {
                        case "svg":
                            $this->ImageSVG($img[4], $this->x, $this->y + ($this->lasth - $img[3]) / 2, $img[2], $img[3], "", "T", "", 0, false);
                            break;
                        case "ai":
                        case "eps":
                            $this->ImageEps($img[4], $this->x, $this->y + ($this->lasth - $img[3]) / 2, $img[2], $img[3], "", true, "T", "", 0, false);
                            break;
                        default:
                            $this->Image($img[4], $this->x, $this->y + ($this->lasth - $img[3]) / 2, $img[2], $img[3], $img[1], "", "T", false, 300, "", false, false, 0, false, false, false);
                            $this->y = $prev_y;
                    }
                    break;
                case "1":
                case "decimal":
                    $textitem = $this->listcount[$this->listnum];
                    break;
                case "decimal-leading-zero":
                    $textitem = sprintf("%02d", $this->listcount[$this->listnum]);
                    break;
                case "i":
                case "lower-roman":
                    $textitem = strtolower(TCPDF_STATIC::intToRoman($this->listcount[$this->listnum]));
                    break;
                case "I":
                case "upper-roman":
                    $textitem = TCPDF_STATIC::intToRoman($this->listcount[$this->listnum]);
                    break;
                case "a":
                case "lower-alpha":
                case "lower-latin":
                    $textitem = chr(97 + $this->listcount[$this->listnum] - 1);
                    break;
                case "A":
                case "upper-alpha":
                case "upper-latin":
                    $textitem = chr(65 + $this->listcount[$this->listnum] - 1);
                    break;
                case "lower-greek":
                    $textitem = TCPDF_FONTS::unichr(945 + $this->listcount[$this->listnum] - 1, $this->isunicode);
                    break;
                default:
                    $textitem = $this->listcount[$this->listnum];
                    if(!TCPDF_STATIC::empty_string($textitem)) {
                        $prev_y = $this->y;
                        $h = $this->getCellHeight($this->FontSize);
                        if($this->checkPageBreak($h) || $this->y < $prev_y) {
                            $tmpx = $this->x;
                        }
                        if($this->rtl) {
                            $textitem = "." . $textitem;
                        } else {
                            $textitem = $textitem . ".";
                        }
                        $lspace += $this->GetStringWidth($textitem);
                        if($this->rtl) {
                            $this->x += $lspace;
                        } else {
                            $this->x -= $lspace;
                        }
                        $this->Write($this->lasth, $textitem, "", false, "", false, 0, false);
                    }
                    $this->x = $tmpx;
                    $this->lispacer = "^";
                    $this->setFillColorArray($bgcolor);
                    $this->setDrawColorArray($strokecolor);
                    $this->settextColorArray($color);
            }
        }
    }
    protected function getGraphicVars()
    {
        $grapvars = ["FontFamily" => $this->FontFamily, "FontStyle" => $this->FontStyle, "FontSizePt" => $this->FontSizePt, "rMargin" => $this->rMargin, "lMargin" => $this->lMargin, "cell_padding" => $this->cell_padding, "cell_margin" => $this->cell_margin, "LineWidth" => $this->LineWidth, "linestyleWidth" => $this->linestyleWidth, "linestyleCap" => $this->linestyleCap, "linestyleJoin" => $this->linestyleJoin, "linestyleDash" => $this->linestyleDash, "textrendermode" => $this->textrendermode, "textstrokewidth" => $this->textstrokewidth, "DrawColor" => $this->DrawColor, "FillColor" => $this->FillColor, "TextColor" => $this->TextColor, "ColorFlag" => $this->ColorFlag, "bgcolor" => $this->bgcolor, "fgcolor" => $this->fgcolor, "htmlvspace" => $this->htmlvspace, "listindent" => $this->listindent, "listindentlevel" => $this->listindentlevel, "listnum" => $this->listnum, "listordered" => $this->listordered, "listcount" => $this->listcount, "lispacer" => $this->lispacer, "cell_height_ratio" => $this->cell_height_ratio, "font_stretching" => $this->font_stretching, "font_spacing" => $this->font_spacing, "alpha" => $this->alpha, "lasth" => $this->lasth, "tMargin" => $this->tMargin, "bMargin" => $this->bMargin, "AutoPageBreak" => $this->AutoPageBreak, "PageBreakTrigger" => $this->PageBreakTrigger, "x" => $this->x, "y" => $this->y, "w" => $this->w, "h" => $this->h, "wPt" => $this->wPt, "hPt" => $this->hPt, "fwPt" => $this->fwPt, "fhPt" => $this->fhPt, "page" => $this->page, "current_column" => $this->current_column, "num_columns" => $this->num_columns];
        return $grapvars;
    }
    protected function setGraphicVars($gvars, $extended = false)
    {
        if($this->state != 2) {
            return NULL;
        }
        $this->FontFamily = $gvars["FontFamily"];
        $this->FontStyle = $gvars["FontStyle"];
        $this->FontSizePt = $gvars["FontSizePt"];
        $this->rMargin = $gvars["rMargin"];
        $this->lMargin = $gvars["lMargin"];
        $this->cell_padding = $gvars["cell_padding"];
        $this->cell_margin = $gvars["cell_margin"];
        $this->LineWidth = $gvars["LineWidth"];
        $this->linestyleWidth = $gvars["linestyleWidth"];
        $this->linestyleCap = $gvars["linestyleCap"];
        $this->linestyleJoin = $gvars["linestyleJoin"];
        $this->linestyleDash = $gvars["linestyleDash"];
        $this->textrendermode = $gvars["textrendermode"];
        $this->textstrokewidth = $gvars["textstrokewidth"];
        $this->DrawColor = $gvars["DrawColor"];
        $this->FillColor = $gvars["FillColor"];
        $this->TextColor = $gvars["TextColor"];
        $this->ColorFlag = $gvars["ColorFlag"];
        $this->bgcolor = $gvars["bgcolor"];
        $this->fgcolor = $gvars["fgcolor"];
        $this->htmlvspace = $gvars["htmlvspace"];
        $this->listindent = $gvars["listindent"];
        $this->listindentlevel = $gvars["listindentlevel"];
        $this->listnum = $gvars["listnum"];
        $this->listordered = $gvars["listordered"];
        $this->listcount = $gvars["listcount"];
        $this->lispacer = $gvars["lispacer"];
        $this->cell_height_ratio = $gvars["cell_height_ratio"];
        $this->font_stretching = $gvars["font_stretching"];
        $this->font_spacing = $gvars["font_spacing"];
        $this->alpha = $gvars["alpha"];
        if($extended) {
            $this->lasth = $gvars["lasth"];
            $this->tMargin = $gvars["tMargin"];
            $this->bMargin = $gvars["bMargin"];
            $this->AutoPageBreak = $gvars["AutoPageBreak"];
            $this->PageBreakTrigger = $gvars["PageBreakTrigger"];
            $this->x = $gvars["x"];
            $this->y = $gvars["y"];
            $this->w = $gvars["w"];
            $this->h = $gvars["h"];
            $this->wPt = $gvars["wPt"];
            $this->hPt = $gvars["hPt"];
            $this->fwPt = $gvars["fwPt"];
            $this->fhPt = $gvars["fhPt"];
            $this->page = $gvars["page"];
            $this->current_column = $gvars["current_column"];
            $this->num_columns = $gvars["num_columns"];
        }
        $this->_out("" . $this->linestyleWidth . " " . $this->linestyleCap . " " . $this->linestyleJoin . " " . $this->linestyleDash . " " . $this->DrawColor . " " . $this->FillColor . "");
        if(!TCPDF_STATIC::empty_string($this->FontFamily)) {
            $this->setFont($this->FontFamily, $this->FontStyle, $this->FontSizePt);
        }
    }
    protected function _outSaveGraphicsState()
    {
        $this->_out("q");
    }
    protected function _outRestoreGraphicsState()
    {
        $this->_out("Q");
    }
    protected function setBuffer($data)
    {
        $this->bufferlen += strlen($data);
        $this->buffer .= $data;
    }
    protected function replaceBuffer($data)
    {
        $this->bufferlen = strlen($data);
        $this->buffer = $data;
    }
    protected function getBuffer()
    {
        return $this->buffer;
    }
    protected function setPageBuffer($page, $data, $append = false)
    {
        if($append) {
            $this->pages[$page] .= $data;
        } else {
            $this->pages[$page] = $data;
        }
        if($append && isset($this->pagelen[$page])) {
            $this->pagelen[$page] += strlen($data);
        } else {
            $this->pagelen[$page] = strlen($data);
        }
    }
    protected function getPageBuffer($page)
    {
        if(isset($this->pages[$page])) {
            return $this->pages[$page];
        }
        return false;
    }
    protected function setImageBuffer($image, $data)
    {
        $data["i"] = array_search($image, $this->imagekeys);
        if($data["i"] === false) {
            $this->imagekeys[$this->numimages] = $image;
            $data["i"] = $this->numimages;
            $this->numimages++;
        }
        $this->images[$image] = $data;
        return $data["i"];
    }
    protected function setImageSubBuffer($image, $key, $data)
    {
        if(!isset($this->images[$image])) {
            $this->setImageBuffer($image, []);
        }
        $this->images[$image][$key] = $data;
    }
    protected function getImageBuffer($image)
    {
        if(isset($this->images[$image])) {
            return $this->images[$image];
        }
        return false;
    }
    protected function setFontBuffer($font, $data)
    {
        $this->fonts[$font] = $data;
        if(!in_array($font, $this->fontkeys)) {
            $this->fontkeys[] = $font;
            $this->n++;
            $this->font_obj_ids[$font] = $this->n;
            $this->setFontSubBuffer($font, "n", $this->n);
        }
    }
    protected function setFontSubBuffer($font, $key, $data)
    {
        if(!isset($this->fonts[$font])) {
            $this->setFontBuffer($font, []);
        }
        $this->fonts[$font][$key] = $data;
    }
    protected function getFontBuffer($font)
    {
        if(isset($this->fonts[$font])) {
            return $this->fonts[$font];
        }
        return false;
    }
    public function movePage($frompage, $topage)
    {
        if($this->numpages < $frompage || $frompage <= $topage) {
            return false;
        }
        if($frompage == $this->page) {
            $this->endPage();
        }
        $tmppage = $this->getPageBuffer($frompage);
        $tmppagedim = $this->pagedim[$frompage];
        $tmppagelen = $this->pagelen[$frompage];
        $tmpintmrk = $this->intmrk[$frompage];
        $tmpbordermrk = $this->bordermrk[$frompage];
        $tmpcntmrk = $this->cntmrk[$frompage];
        $tmppageobjects = $this->pageobjects[$frompage];
        if(isset($this->footerpos[$frompage])) {
            $tmpfooterpos = $this->footerpos[$frompage];
        }
        if(isset($this->footerlen[$frompage])) {
            $tmpfooterlen = $this->footerlen[$frompage];
        }
        if(isset($this->transfmrk[$frompage])) {
            $tmptransfmrk = $this->transfmrk[$frompage];
        }
        if(isset($this->PageAnnots[$frompage])) {
            $tmpannots = $this->PageAnnots[$frompage];
        }
        if(isset($this->newpagegroup) && !empty($this->newpagegroup)) {
            $i = $frompage;
            while ($topage < $i) {
                if(isset($this->newpagegroup[$i]) && $frompage < $i + $this->pagegroups[$this->newpagegroup[$i]]) {
                    --$this->pagegroups[$this->newpagegroup[$i]];
                    break;
                }
                --$i;
            }
            $i = $topage;
            while (0 < $i) {
                if(isset($this->newpagegroup[$i]) && $topage < $i + $this->pagegroups[$this->newpagegroup[$i]]) {
                    $this->pagegroups[$this->newpagegroup[$i]]++;
                    break;
                }
                --$i;
            }
        }
        $i = $frompage;
        while ($topage < $i) {
            $j = $i - 1;
            $this->setPageBuffer($i, $this->getPageBuffer($j));
            $this->pagedim[$i] = $this->pagedim[$j];
            $this->pagelen[$i] = $this->pagelen[$j];
            $this->intmrk[$i] = $this->intmrk[$j];
            $this->bordermrk[$i] = $this->bordermrk[$j];
            $this->cntmrk[$i] = $this->cntmrk[$j];
            $this->pageobjects[$i] = $this->pageobjects[$j];
            if(isset($this->footerpos[$j])) {
                $this->footerpos[$i] = $this->footerpos[$j];
            } elseif(isset($this->footerpos[$i])) {
                unset($this->footerpos[$i]);
            }
            if(isset($this->footerlen[$j])) {
                $this->footerlen[$i] = $this->footerlen[$j];
            } elseif(isset($this->footerlen[$i])) {
                unset($this->footerlen[$i]);
            }
            if(isset($this->transfmrk[$j])) {
                $this->transfmrk[$i] = $this->transfmrk[$j];
            } elseif(isset($this->transfmrk[$i])) {
                unset($this->transfmrk[$i]);
            }
            if(isset($this->PageAnnots[$j])) {
                $this->PageAnnots[$i] = $this->PageAnnots[$j];
            } elseif(isset($this->PageAnnots[$i])) {
                unset($this->PageAnnots[$i]);
            }
            if(isset($this->newpagegroup[$j])) {
                $this->newpagegroup[$i] = $this->newpagegroup[$j];
                unset($this->newpagegroup[$j]);
            }
            if($this->currpagegroup == $j) {
                $this->currpagegroup = $i;
            }
            --$i;
        }
        $this->setPageBuffer($topage, $tmppage);
        $this->pagedim[$topage] = $tmppagedim;
        $this->pagelen[$topage] = $tmppagelen;
        $this->intmrk[$topage] = $tmpintmrk;
        $this->bordermrk[$topage] = $tmpbordermrk;
        $this->cntmrk[$topage] = $tmpcntmrk;
        $this->pageobjects[$topage] = $tmppageobjects;
        if(isset($tmpfooterpos)) {
            $this->footerpos[$topage] = $tmpfooterpos;
        } elseif(isset($this->footerpos[$topage])) {
            unset($this->footerpos[$topage]);
        }
        if(isset($tmpfooterlen)) {
            $this->footerlen[$topage] = $tmpfooterlen;
        } elseif(isset($this->footerlen[$topage])) {
            unset($this->footerlen[$topage]);
        }
        if(isset($tmptransfmrk)) {
            $this->transfmrk[$topage] = $tmptransfmrk;
        } elseif(isset($this->transfmrk[$topage])) {
            unset($this->transfmrk[$topage]);
        }
        if(isset($tmpannots)) {
            $this->PageAnnots[$topage] = $tmpannots;
        } elseif(isset($this->PageAnnots[$topage])) {
            unset($this->PageAnnots[$topage]);
        }
        $tmpoutlines = $this->outlines;
        foreach ($tmpoutlines as $key => $outline) {
            if(!$outline["f"]) {
                if($topage <= $outline["p"] && $outline["p"] < $frompage) {
                    $this->outlines[$key]["p"] = $outline["p"] + 1;
                } elseif($outline["p"] == $frompage) {
                    $this->outlines[$key]["p"] = $topage;
                }
            }
        }
        $tmpdests = $this->dests;
        foreach ($tmpdests as $key => $dest) {
            if(!$dest["f"]) {
                if($topage <= $dest["p"] && $dest["p"] < $frompage) {
                    $this->dests[$key]["p"] = $dest["p"] + 1;
                } elseif($dest["p"] == $frompage) {
                    $this->dests[$key]["p"] = $topage;
                }
            }
        }
        $tmplinks = $this->links;
        foreach ($tmplinks as $key => $link) {
            if(!$link["f"]) {
                if($topage <= $link["p"] && $link["p"] < $frompage) {
                    $this->links[$key]["p"] = $link["p"] + 1;
                } elseif($link["p"] == $frompage) {
                    $this->links[$key]["p"] = $topage;
                }
            }
        }
        $jfrompage = $frompage;
        $jtopage = $topage;
        if(0 < preg_match_all("/this\\.addField\\('([^']*)','([^']*)',([0-9]+)/", $this->javascript, $pamatch)) {
            foreach ($pamatch[0] as $pk => $pmatch) {
                $pagenum = intval($pamatch[3][$pk]) + 1;
                if($jtopage <= $pagenum && $pagenum < $jfrompage) {
                    $newpage = $pagenum + 1;
                } elseif($pagenum == $jfrompage) {
                    $newpage = $jtopage;
                } else {
                    $newpage = $pagenum;
                }
                --$newpage;
                $newjs = "this.addField(\\'" . $pamatch[1][$pk] . "\\',\\'" . $pamatch[2][$pk] . "\\'," . $newpage;
                $this->javascript = str_replace($pmatch, $newjs, $this->javascript);
            }
            unset($pamatch);
        }
        $this->lastPage(true);
        return true;
    }
    public function deletePage($page)
    {
        if($page < 1 || $this->numpages < $page) {
            return false;
        }
        unset($this->pages[$page]);
        unset($this->pagedim[$page]);
        unset($this->pagelen[$page]);
        unset($this->intmrk[$page]);
        unset($this->bordermrk[$page]);
        unset($this->cntmrk[$page]);
        foreach ($this->pageobjects[$page] as $oid) {
            if(isset($this->offsets[$oid])) {
                unset($this->offsets[$oid]);
            }
        }
        unset($this->pageobjects[$page]);
        if(isset($this->footerpos[$page])) {
            unset($this->footerpos[$page]);
        }
        if(isset($this->footerlen[$page])) {
            unset($this->footerlen[$page]);
        }
        if(isset($this->transfmrk[$page])) {
            unset($this->transfmrk[$page]);
        }
        if(isset($this->PageAnnots[$page])) {
            unset($this->PageAnnots[$page]);
        }
        if(isset($this->newpagegroup) && !empty($this->newpagegroup)) {
            $i = $page;
            while (0 < $i) {
                if(isset($this->newpagegroup[$i]) && $page < $i + $this->pagegroups[$this->newpagegroup[$i]]) {
                    --$this->pagegroups[$this->newpagegroup[$i]];
                    break;
                }
                --$i;
            }
        }
        if(isset($this->pageopen[$page])) {
            unset($this->pageopen[$page]);
        }
        if($page < $this->numpages) {
            for ($i = $page; $i < $this->numpages; $i++) {
                $j = $i + 1;
                $this->setPageBuffer($i, $this->getPageBuffer($j));
                $this->pagedim[$i] = $this->pagedim[$j];
                $this->pagelen[$i] = $this->pagelen[$j];
                $this->intmrk[$i] = $this->intmrk[$j];
                $this->bordermrk[$i] = $this->bordermrk[$j];
                $this->cntmrk[$i] = $this->cntmrk[$j];
                $this->pageobjects[$i] = $this->pageobjects[$j];
                if(isset($this->footerpos[$j])) {
                    $this->footerpos[$i] = $this->footerpos[$j];
                } elseif(isset($this->footerpos[$i])) {
                    unset($this->footerpos[$i]);
                }
                if(isset($this->footerlen[$j])) {
                    $this->footerlen[$i] = $this->footerlen[$j];
                } elseif(isset($this->footerlen[$i])) {
                    unset($this->footerlen[$i]);
                }
                if(isset($this->transfmrk[$j])) {
                    $this->transfmrk[$i] = $this->transfmrk[$j];
                } elseif(isset($this->transfmrk[$i])) {
                    unset($this->transfmrk[$i]);
                }
                if(isset($this->PageAnnots[$j])) {
                    $this->PageAnnots[$i] = $this->PageAnnots[$j];
                } elseif(isset($this->PageAnnots[$i])) {
                    unset($this->PageAnnots[$i]);
                }
                if(isset($this->newpagegroup[$j])) {
                    $this->newpagegroup[$i] = $this->newpagegroup[$j];
                    unset($this->newpagegroup[$j]);
                }
                if($this->currpagegroup == $j) {
                    $this->currpagegroup = $i;
                }
                if(isset($this->pageopen[$j])) {
                    $this->pageopen[$i] = $this->pageopen[$j];
                } elseif(isset($this->pageopen[$i])) {
                    unset($this->pageopen[$i]);
                }
            }
            unset($this->pages[$this->numpages]);
            unset($this->pagedim[$this->numpages]);
            unset($this->pagelen[$this->numpages]);
            unset($this->intmrk[$this->numpages]);
            unset($this->bordermrk[$this->numpages]);
            unset($this->cntmrk[$this->numpages]);
            foreach ($this->pageobjects[$this->numpages] as $oid) {
                if(isset($this->offsets[$oid])) {
                    unset($this->offsets[$oid]);
                }
            }
            unset($this->pageobjects[$this->numpages]);
            if(isset($this->footerpos[$this->numpages])) {
                unset($this->footerpos[$this->numpages]);
            }
            if(isset($this->footerlen[$this->numpages])) {
                unset($this->footerlen[$this->numpages]);
            }
            if(isset($this->transfmrk[$this->numpages])) {
                unset($this->transfmrk[$this->numpages]);
            }
            if(isset($this->PageAnnots[$this->numpages])) {
                unset($this->PageAnnots[$this->numpages]);
            }
            if(isset($this->newpagegroup[$this->numpages])) {
                unset($this->newpagegroup[$this->numpages]);
            }
            if($this->currpagegroup == $this->numpages) {
                $this->currpagegroup = $this->numpages - 1;
            }
            if(isset($this->pagegroups[$this->numpages])) {
                unset($this->pagegroups[$this->numpages]);
            }
            if(isset($this->pageopen[$this->numpages])) {
                unset($this->pageopen[$this->numpages]);
            }
        }
        --$this->numpages;
        $this->page = $this->numpages;
        $tmpoutlines = $this->outlines;
        foreach ($tmpoutlines as $key => $outline) {
            if(!$outline["f"]) {
                if($page < $outline["p"]) {
                    $this->outlines[$key]["p"] = $outline["p"] - 1;
                } elseif($outline["p"] == $page) {
                    unset($this->outlines[$key]);
                }
            }
        }
        $tmpdests = $this->dests;
        foreach ($tmpdests as $key => $dest) {
            if(!$dest["f"]) {
                if($page < $dest["p"]) {
                    $this->dests[$key]["p"] = $dest["p"] - 1;
                } elseif($dest["p"] == $page) {
                    unset($this->dests[$key]);
                }
            }
        }
        $tmplinks = $this->links;
        foreach ($tmplinks as $key => $link) {
            if(!$link["f"]) {
                if($page < $link["p"]) {
                    $this->links[$key]["p"] = $link["p"] - 1;
                } elseif($link["p"] == $page) {
                    unset($this->links[$key]);
                }
            }
        }
        $jpage = $page;
        if(0 < preg_match_all("/this\\.addField\\('([^']*)','([^']*)',([0-9]+)/", $this->javascript, $pamatch)) {
            foreach ($pamatch[0] as $pk => $pmatch) {
                $pagenum = intval($pamatch[3][$pk]) + 1;
                if($jpage <= $pagenum) {
                    $newpage = $pagenum - 1;
                } elseif($pagenum == $jpage) {
                    $newpage = 1;
                } else {
                    $newpage = $pagenum;
                }
                --$newpage;
                $newjs = "this.addField(\\'" . $pamatch[1][$pk] . "\\',\\'" . $pamatch[2][$pk] . "\\'," . $newpage;
                $this->javascript = str_replace($pmatch, $newjs, $this->javascript);
            }
            unset($pamatch);
        }
        if(0 < $this->numpages) {
            $this->lastPage(true);
        }
        return true;
    }
    public function copyPage($page = 0)
    {
        if($page == 0) {
            $page = $this->page;
        }
        if($page < 1 || $this->numpages < $page) {
            return false;
        }
        $this->endPage();
        $this->numpages++;
        $this->page = $this->numpages;
        $this->setPageBuffer($this->page, $this->getPageBuffer($page));
        $this->pagedim[$this->page] = $this->pagedim[$page];
        $this->pagelen[$this->page] = $this->pagelen[$page];
        $this->intmrk[$this->page] = $this->intmrk[$page];
        $this->bordermrk[$this->page] = $this->bordermrk[$page];
        $this->cntmrk[$this->page] = $this->cntmrk[$page];
        $this->pageobjects[$this->page] = $this->pageobjects[$page];
        $this->pageopen[$this->page] = false;
        if(isset($this->footerpos[$page])) {
            $this->footerpos[$this->page] = $this->footerpos[$page];
        }
        if(isset($this->footerlen[$page])) {
            $this->footerlen[$this->page] = $this->footerlen[$page];
        }
        if(isset($this->transfmrk[$page])) {
            $this->transfmrk[$this->page] = $this->transfmrk[$page];
        }
        if(isset($this->PageAnnots[$page])) {
            $this->PageAnnots[$this->page] = $this->PageAnnots[$page];
        }
        if(isset($this->newpagegroup[$page])) {
            $this->newpagegroup[$this->page] = sizeof($this->newpagegroup) + 1;
            $this->currpagegroup = $this->newpagegroup[$this->page];
            $this->pagegroups[$this->currpagegroup] = 1;
        } elseif(isset($this->currpagegroup) && 0 < $this->currpagegroup) {
            $this->pagegroups[$this->currpagegroup]++;
        }
        $tmpoutlines = $this->outlines;
        foreach ($tmpoutlines as $key => $outline) {
            if($outline["p"] == $page) {
                $this->outlines[] = ["t" => $outline["t"], "l" => $outline["l"], "x" => $outline["x"], "y" => $outline["y"], "p" => $this->page, "f" => $outline["f"], "s" => $outline["s"], "c" => $outline["c"]];
            }
        }
        $tmplinks = $this->links;
        foreach ($tmplinks as $key => $link) {
            if($link["p"] == $page) {
                $this->links[] = ["p" => $this->page, "y" => $link["y"], "f" => $link["f"]];
            }
        }
        $this->lastPage(true);
        return true;
    }
    public function addTOC($page = NULL, $numbersfont = "", $filler = ".", $toc_name = "TOC", $style = "", $color = [0, 0, 0])
    {
        $fontsize = $this->FontSizePt;
        $fontfamily = $this->FontFamily;
        $fontstyle = $this->FontStyle;
        $w = $this->w - $this->lMargin - $this->rMargin;
        $spacer = $this->GetStringWidth(chr(32)) * 4;
        $lmargin = $this->lMargin;
        $rmargin = $this->rMargin;
        $x_start = $this->GetX();
        $page_first = $this->page;
        $current_page = $this->page;
        $page_fill_start = false;
        $page_fill_end = false;
        $current_column = $this->current_column;
        if(TCPDF_STATIC::empty_string($numbersfont)) {
            $numbersfont = $this->default_monospaced_font;
        }
        if(TCPDF_STATIC::empty_string($filler)) {
            $filler = " ";
        }
        if(TCPDF_STATIC::empty_string($page)) {
            $gap = " ";
        } else {
            $gap = "";
            if($page < 1) {
                $page = 1;
            }
        }
        $this->setFont($numbersfont, $fontstyle, $fontsize);
        $numwidth = $this->GetStringWidth("00000");
        $maxpage = 0;
        foreach ($this->outlines as $key => $outline) {
            if($page_first < $this->page && $this->numpages <= $outline["p"]) {
                $outline["p"] += $this->page - $page_first;
            }
            if($this->rtl) {
                $aligntext = "R";
                $alignnum = "L";
            } else {
                $aligntext = "L";
                $alignnum = "R";
            }
            if($outline["l"] == 0) {
                $this->setFont($fontfamily, $outline["s"] . "B", $fontsize);
            } else {
                $this->setFont($fontfamily, $outline["s"], $fontsize - $outline["l"]);
            }
            $this->setTextColorArray($outline["c"]);
            $this->checkPageBreak(2 * $this->getCellHeight($this->FontSize));
            if($this->page == $current_page && $this->current_column == $current_column) {
                $this->lMargin = $lmargin;
                $this->rMargin = $rmargin;
            } else {
                if($this->current_column != $current_column) {
                    if($this->rtl) {
                        $x_start = $this->w - $this->columns[$this->current_column]["x"];
                    } else {
                        $x_start = $this->columns[$this->current_column]["x"];
                    }
                }
                $lmargin = $this->lMargin;
                $rmargin = $this->rMargin;
                $current_page = $this->page;
                $current_column = $this->current_column;
            }
            $this->setX($x_start);
            $indent = $spacer * $outline["l"];
            if($this->rtl) {
                $this->x -= $indent;
                $this->rMargin = $this->w - $this->x;
            } else {
                $this->x += $indent;
                $this->lMargin = $this->x;
            }
            $link = $this->AddLink();
            $this->setLink($link, $outline["y"], $outline["p"]);
            if($this->rtl) {
                $txt = " " . $outline["t"];
            } else {
                $txt = $outline["t"] . " ";
            }
            $this->Write(0, $txt, $link, false, $aligntext, false, 0, false, false, 0, $numwidth, "");
            if($this->rtl) {
                $tw = $this->x - $this->lMargin;
            } else {
                $tw = $this->w - $this->rMargin - $this->x;
            }
            $this->setFont($numbersfont, $fontstyle, $fontsize);
            if(TCPDF_STATIC::empty_string($page)) {
                $pagenum = $outline["p"];
            } else {
                $pagenum = "{#" . $outline["p"] . "}";
                if($this->isUnicodeFont()) {
                    $pagenum = "{" . $pagenum . "}";
                }
                $maxpage = max($maxpage, $outline["p"]);
            }
            $fw = $tw - $this->GetStringWidth($pagenum . $filler);
            $wfiller = $this->GetStringWidth($filler);
            if(0 < $wfiller) {
                $numfills = floor($fw / $wfiller);
            } else {
                $numfills = 0;
            }
            if(0 < $numfills) {
                $rowfill = str_repeat($filler, $numfills);
            } else {
                $rowfill = "";
            }
            if($this->rtl) {
                $pagenum = $pagenum . $gap . $rowfill;
            } else {
                $pagenum = $rowfill . $gap . $pagenum;
            }
            $this->Cell($tw, 0, $pagenum, 0, 1, $alignnum, 0, $link, 0);
        }
        $page_last = $this->getPage();
        $numpages = $page_last - $page_first + 1;
        if($this->booklet) {
            $page_fill_start = ($page_first % 2 == 0 xor $page % 2 == 0);
            $page_fill_end = !($numpages % 2 == 0 xor $page_fill_start);
            if($page_fill_start) {
                $this->addPage();
                $page_last++;
                $numpages++;
            }
            if($page_fill_end) {
                $this->addPage();
                $page_last++;
                $numpages++;
            }
        }
        $maxpage = max($maxpage, $page_last);
        if(!TCPDF_STATIC::empty_string($page)) {
            for ($p = $page_first; $p <= $page_last; $p++) {
                $temppage = $this->getPageBuffer($p);
                for ($n = 1; $n <= $maxpage; $n++) {
                    $a = "{#" . $n . "}";
                    $pnalias = $this->getInternalPageNumberAliases($a);
                    if($page <= $n && $n <= $this->numpages) {
                        $np = $n + $numpages;
                    } else {
                        $np = $n;
                    }
                    $na = TCPDF_STATIC::formatTOCPageNumber($this->starting_page_number + $np - 1);
                    $nu = TCPDF_FONTS::UTF8ToUTF16BE($na, false, $this->isunicode, $this->CurrentFont);
                    foreach ($pnalias["u"] as $u) {
                        $sfill = str_repeat($filler, max(0, strlen($u) - strlen($nu . " ")));
                        if($this->rtl) {
                            $nr = $nu . TCPDF_FONTS::UTF8ToUTF16BE(" " . $sfill, false, $this->isunicode, $this->CurrentFont);
                        } else {
                            $nr = TCPDF_FONTS::UTF8ToUTF16BE($sfill . " ", false, $this->isunicode, $this->CurrentFont) . $nu;
                        }
                        $temppage = str_replace($u, $nr, $temppage);
                    }
                    foreach ($pnalias["a"] as $a) {
                        $sfill = str_repeat($filler, max(0, strlen($a) - strlen($na . " ")));
                        if($this->rtl) {
                            $nr = $na . " " . $sfill;
                        } else {
                            $nr = $sfill . " " . $na;
                        }
                        $temppage = str_replace($a, $nr, $temppage);
                    }
                }
                $this->setPageBuffer($p, $temppage);
            }
            $this->Bookmark($toc_name, 0, 0, $page_first, $style, $color);
            if($page_fill_start) {
                $this->movePage($page_last, $page_first);
            }
            for ($i = 0; $i < $numpages; $i++) {
                $this->movePage($page_last, $page);
            }
        }
    }
    public function addHTMLTOC($page = NULL, $toc_name = "TOC", $templates = [], $correct_align = true, $style = "", $color = [0, 0, 0])
    {
        $filler = " ";
        $prev_htmlLinkColorArray = $this->htmlLinkColorArray;
        $prev_htmlLinkFontStyle = $this->htmlLinkFontStyle;
        $this->htmlLinkColorArray = [];
        $this->htmlLinkFontStyle = "";
        $page_first = $this->getPage();
        $page_fill_start = false;
        $page_fill_end = false;
        $current_font = $this->FontFamily;
        foreach ($templates as $level => $html) {
            $dom = $this->getHtmlDomArray($html);
            foreach ($dom as $key => $value) {
                if($value["value"] == "#TOC_PAGE_NUMBER#") {
                    $this->setFont($dom[$key - 1]["fontname"]);
                    $templates["F" . $level] = $this->isUnicodeFont();
                }
            }
        }
        $this->setFont($current_font);
        $maxpage = 0;
        foreach ($this->outlines as $key => $outline) {
            $row = $templates[$outline["l"]];
            if(TCPDF_STATIC::empty_string($page)) {
                $pagenum = $outline["p"];
            } else {
                $pagenum = "{#" . $outline["p"] . "}";
                if(isset($templates["F" . $outline["l"]]) && $templates["F" . $outline["l"]]) {
                    $pagenum = "{" . $pagenum . "}";
                }
                $maxpage = max($maxpage, $outline["p"]);
            }
            $row = str_replace("#TOC_DESCRIPTION#", $outline["t"], $row);
            $row = str_replace("#TOC_PAGE_NUMBER#", $pagenum, $row);
            $row = "<a href=\"#" . $outline["p"] . "," . $outline["y"] . "\">" . $row . "</a>";
            $this->writeHTML($row, false, false, true, false, "");
        }
        $this->htmlLinkColorArray = $prev_htmlLinkColorArray;
        $this->htmlLinkFontStyle = $prev_htmlLinkFontStyle;
        $page_last = $this->getPage();
        $numpages = $page_last - $page_first + 1;
        if($this->booklet) {
            $page_fill_start = ($page_first % 2 == 0 xor $page % 2 == 0);
            $page_fill_end = !($numpages % 2 == 0 xor $page_fill_start);
            if($page_fill_start) {
                $this->addPage();
                $page_last++;
                $numpages++;
            }
            if($page_fill_end) {
                $this->addPage();
                $page_last++;
                $numpages++;
            }
        }
        $maxpage = max($maxpage, $page_last);
        if(!TCPDF_STATIC::empty_string($page)) {
            for ($p = $page_first; $p <= $page_last; $p++) {
                $temppage = $this->getPageBuffer($p);
                for ($n = 1; $n <= $maxpage; $n++) {
                    $a = "{#" . $n . "}";
                    $pnalias = $this->getInternalPageNumberAliases($a);
                    if($page <= $n) {
                        $np = $n + $numpages;
                    } else {
                        $np = $n;
                    }
                    $na = TCPDF_STATIC::formatTOCPageNumber($this->starting_page_number + $np - 1);
                    $nu = TCPDF_FONTS::UTF8ToUTF16BE($na, false, $this->isunicode, $this->CurrentFont);
                    foreach ($pnalias["u"] as $u) {
                        if($correct_align) {
                            $sfill = str_repeat($filler, strlen($u) - strlen($nu . " "));
                            if($this->rtl) {
                                $nr = $nu . TCPDF_FONTS::UTF8ToUTF16BE(" " . $sfill, false, $this->isunicode, $this->CurrentFont);
                            } else {
                                $nr = TCPDF_FONTS::UTF8ToUTF16BE($sfill . " ", false, $this->isunicode, $this->CurrentFont) . $nu;
                            }
                        } else {
                            $nr = $nu;
                        }
                        $temppage = str_replace($u, $nr, $temppage);
                    }
                    foreach ($pnalias["a"] as $a) {
                        if($correct_align) {
                            $sfill = str_repeat($filler, strlen($a) - strlen($na . " "));
                            if($this->rtl) {
                                $nr = $na . " " . $sfill;
                            } else {
                                $nr = $sfill . " " . $na;
                            }
                        } else {
                            $nr = $na;
                        }
                        $temppage = str_replace($a, $nr, $temppage);
                    }
                }
                $this->setPageBuffer($p, $temppage);
            }
            $this->Bookmark($toc_name, 0, 0, $page_first, $style, $color);
            if($page_fill_start) {
                $this->movePage($page_last, $page_first);
            }
            for ($i = 0; $i < $numpages; $i++) {
                $this->movePage($page_last, $page);
            }
        }
    }
    public function startTransaction()
    {
        if(isset($this->objcopy)) {
            $this->commitTransaction();
        }
        $this->start_transaction_page = $this->page;
        $this->start_transaction_y = $this->y;
        $this->objcopy = TCPDF_STATIC::objclone($this);
    }
    public function commitTransaction()
    {
        if(isset($this->objcopy)) {
            $this->objcopy->_destroy(true, true);
            $this->objcopy->file_id = NULL;
            unset($this->objcopy);
        }
    }
    public function rollbackTransaction($self = false)
    {
        if(isset($this->objcopy)) {
            $objcopy = $this->objcopy;
            $this->_destroy(true, true);
            if($self) {
                $objvars = get_object_vars($objcopy);
                foreach ($objvars as $key => $value) {
                    $this->{$key} = $value;
                }
                $objcopy->_destroy(true, true);
                $objcopy->file_id = NULL;
                unset($objcopy);
                return $this;
            } else {
                $this->file_id = NULL;
                return $objcopy;
            }
        } else {
            return $this;
        }
    }
    public function setEqualColumns($numcols = 0, $width = 0, $y = NULL)
    {
        $this->columns = [];
        if($numcols < 2) {
            $numcols = 0;
            $this->columns = [];
        } else {
            $maxwidth = ($this->w - $this->original_lMargin - $this->original_rMargin) / $numcols;
            if($width == 0 || $maxwidth < $width) {
                $width = $maxwidth;
            }
            if(TCPDF_STATIC::empty_string($y)) {
                $y = $this->y;
            }
            $space = ($this->w - $this->original_lMargin - $this->original_rMargin - $numcols * $width) / ($numcols - 1);
            for ($i = 0; $i < $numcols; $i++) {
                $this->columns[$i] = ["w" => $width, "s" => $space, "y" => $y];
            }
        }
        $this->num_columns = $numcols;
        $this->current_column = 0;
        $this->column_start_page = $this->page;
        $this->selectColumn(0);
    }
    public function resetColumns()
    {
        $this->lMargin = $this->original_lMargin;
        $this->rMargin = $this->original_rMargin;
        $this->setEqualColumns();
    }
    public function setColumnsArray($columns)
    {
        $this->columns = $columns;
        $this->num_columns = count($columns);
        $this->current_column = 0;
        $this->column_start_page = $this->page;
        $this->selectColumn(0);
    }
    public function selectColumn($col = NULL)
    {
        if(TCPDF_STATIC::empty_string($col)) {
            $col = $this->current_column;
        } elseif($this->num_columns <= $col) {
            $col = 0;
        }
        $xshift = ["x" => 0, "s" => ["H" => 0, "V" => 0], "p" => ["L" => 0, "T" => 0, "R" => 0, "B" => 0]];
        $enable_thead = false;
        if(1 < $this->num_columns) {
            if($col != $this->current_column) {
                if($this->column_start_page == $this->page) {
                    $this->y = $this->columns[$col]["y"];
                } else {
                    $this->y = $this->tMargin;
                }
                if($this->maxselcol["page"] < $this->page || $this->page == $this->maxselcol["page"] && $this->maxselcol["column"] < $col) {
                    $enable_thead = true;
                    $this->maxselcol["page"] = $this->page;
                    $this->maxselcol["column"] = $col;
                }
            }
            $xshift = $this->colxshift;
            $listindent = $this->listindentlevel * $this->listindent;
            $colpos = 0;
            for ($i = 0; $i < $col; $i++) {
                $colpos += $this->columns[$i]["w"] + $this->columns[$i]["s"];
            }
            if($this->rtl) {
                $x = $this->w - $this->original_rMargin - $colpos;
                $this->rMargin = $this->w - $x + $listindent;
                $this->lMargin = $x - $this->columns[$col]["w"];
                $this->x = $x - $listindent;
            } else {
                $x = $this->original_lMargin + $colpos;
                $this->lMargin = $x + $listindent;
                $this->rMargin = $this->w - $x - $this->columns[$col]["w"];
                $this->x = $x + $listindent;
            }
            $this->columns[$col]["x"] = $x;
        }
        $this->current_column = $col;
        $this->newline = true;
        if(!TCPDF_STATIC::empty_string($this->thead) && !$this->inthead) {
            if($enable_thead) {
                $this->writeHTML($this->thead, false, false, false, false, "");
                $this->y += $xshift["s"]["V"];
                if(!isset($this->columns[$col]["th"])) {
                    $this->columns[$col]["th"] = [];
                }
                $this->columns[$col]["th"]["'" . $this->page . "'"] = $this->y;
                $this->lasth = 0;
            } elseif(isset($this->columns[$col]["th"]["'" . $this->page . "'"])) {
                $this->y = $this->columns[$col]["th"]["'" . $this->page . "'"];
            }
        }
        if($this->rtl) {
            $this->rMargin += $xshift["x"];
            $this->x -= $xshift["x"] + $xshift["p"]["R"];
        } else {
            $this->lMargin += $xshift["x"];
            $this->x += $xshift["x"] + $xshift["p"]["L"];
        }
    }
    public function getColumn()
    {
        return $this->current_column;
    }
    public function getNumberOfColumns()
    {
        return $this->num_columns;
    }
    public function setTextRenderingMode($stroke = 0, $fill = true, $clip = false)
    {
        if($stroke < 0) {
            $stroke = 0;
        }
        if($fill === true) {
            if(0 < $stroke) {
                if($clip === true) {
                    $textrendermode = 6;
                } else {
                    $textrendermode = 2;
                }
                $textstrokewidth = $stroke;
            } elseif($clip === true) {
                $textrendermode = 4;
            } else {
                $textrendermode = 0;
            }
        } elseif(0 < $stroke) {
            if($clip === true) {
                $textrendermode = 5;
            } else {
                $textrendermode = 1;
            }
            $textstrokewidth = $stroke;
        } elseif($clip === true) {
            $textrendermode = 7;
        } else {
            $textrendermode = 3;
        }
        $this->textrendermode = $textrendermode;
        $this->textstrokewidth = $stroke;
    }
    public function setTextShadow($params = ["enabled" => false, "depth_w" => 0, "depth_h" => 0, "color" => false, "opacity" => 1, "blend_mode" => "Normal"])
    {
        if(isset($params["enabled"])) {
            $this->txtshadow["enabled"] = $params["enabled"] ? true : false;
        } else {
            $this->txtshadow["enabled"] = false;
        }
        if(isset($params["depth_w"])) {
            $this->txtshadow["depth_w"] = floatval($params["depth_w"]);
        } else {
            $this->txtshadow["depth_w"] = 0;
        }
        if(isset($params["depth_h"])) {
            $this->txtshadow["depth_h"] = floatval($params["depth_h"]);
        } else {
            $this->txtshadow["depth_h"] = 0;
        }
        if(isset($params["color"]) && $params["color"] !== false && is_array($params["color"])) {
            $this->txtshadow["color"] = $params["color"];
        } else {
            $this->txtshadow["color"] = $this->strokecolor;
        }
        if(isset($params["opacity"])) {
            $this->txtshadow["opacity"] = min(1, max(0, floatval($params["opacity"])));
        } else {
            $this->txtshadow["opacity"] = 1;
        }
        if(isset($params["blend_mode"]) && in_array($params["blend_mode"], ["Normal", "Multiply", "Screen", "Overlay", "Darken", "Lighten", "ColorDodge", "ColorBurn", "HardLight", "SoftLight", "Difference", "Exclusion", "Hue", "Saturation", "Color", "Luminosity"])) {
            $this->txtshadow["blend_mode"] = $params["blend_mode"];
        } else {
            $this->txtshadow["blend_mode"] = "Normal";
        }
        if($this->txtshadow["depth_w"] == 0 && $this->txtshadow["depth_h"] == 0 || $this->txtshadow["opacity"] == 0) {
            $this->txtshadow["enabled"] = false;
        }
    }
    public function getTextShadow()
    {
        return $this->txtshadow;
    }
    protected function hyphenateWord($word, $patterns, $dictionary = [], $leftmin = 1, $rightmin = 2, $charmin = 1, $charmax = 8)
    {
        $hyphenword = [];
        $numchars = count($word);
        if($numchars <= $charmin) {
            return $word;
        }
        $word_string = TCPDF_FONTS::UTF8ArrSubString($word, "", "", $this->isunicode);
        $pattern = "/^([a-zA-Z0-9_\\.\\-]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)\$/";
        if(0 < preg_match($pattern, $word_string)) {
            return $word;
        }
        $pattern = "/(([a-zA-Z0-9\\-]+\\.)?)((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)\$/";
        if(0 < preg_match($pattern, $word_string)) {
            return $word;
        }
        if(isset($dictionary[$word_string])) {
            return TCPDF_FONTS::UTF8StringToArray($dictionary[$word_string], $this->isunicode, $this->CurrentFont);
        }
        $tmpword = array_merge([46], $word, [46]);
        $tmpnumchars = $numchars + 2;
        $maxpos = $tmpnumchars - 1;
        for ($pos = 0; $pos < $maxpos; $pos++) {
            $imax = min($tmpnumchars - $pos, $charmax);
            for ($i = 1; $i <= $imax; $i++) {
                $subword = strtolower(TCPDF_FONTS::UTF8ArrSubString($tmpword, $pos, $pos + $i, $this->isunicode));
                if(isset($patterns[$subword])) {
                    $pattern = TCPDF_FONTS::UTF8StringToArray($patterns[$subword], $this->isunicode, $this->CurrentFont);
                    $pattern_length = count($pattern);
                    $digits = 1;
                    for ($j = 0; $j < $pattern_length; $j++) {
                        if(48 <= $pattern[$j] && $pattern[$j] <= 57) {
                            if($j == 0) {
                                $zero = $pos - 1;
                            } else {
                                $zero = $pos + $j - $digits;
                            }
                            $level = $pattern[$j] - 48;
                            if(!isset($hyphenword[$zero]) || $hyphenword[$zero] < $level) {
                                $hyphenword[$zero] = $level;
                            }
                            $digits++;
                        }
                    }
                }
            }
        }
        $inserted = 0;
        $maxpos = $numchars - $rightmin;
        for ($i = $leftmin; $i <= $maxpos; $i++) {
            if(isset($hyphenword[$i]) && $hyphenword[$i] % 2 != 0) {
                array_splice($word, $i + $inserted, 0, 173);
                $inserted++;
            }
        }
        return $word;
    }
    public function hyphenateText($text, $patterns, $dictionary = [], $leftmin = 1, $rightmin = 2, $charmin = 1, $charmax = 8)
    {
        $text = $this->unhtmlentities($text);
        $word = [];
        $txtarr = [];
        $intag = false;
        $skip = false;
        if(!is_array($patterns)) {
            $patterns = TCPDF_STATIC::getHyphenPatternsFromTEX($patterns);
        }
        $unichars = TCPDF_FONTS::UTF8StringToArray($text, $this->isunicode, $this->CurrentFont);
        foreach ($unichars as $char) {
            if(!$intag && !$skip && TCPDF_FONT_DATA::$uni_type[$char] == "L") {
                $word[] = $char;
            } else {
                if(!TCPDF_STATIC::empty_string($word)) {
                    $txtarr = array_merge($txtarr, $this->hyphenateWord($word, $patterns, $dictionary, $leftmin, $rightmin, $charmin, $charmax));
                    $word = [];
                }
                $txtarr[] = $char;
                if(chr($char) == "<") {
                    $intag = true;
                } elseif($intag && chr($char) == ">") {
                    $intag = false;
                    $expected = [115, 116, 121, 108, 101];
                    $current = array_slice($txtarr, -6, 5);
                    $compare = array_diff($expected, $current);
                    if(empty($compare)) {
                        $expected = [47];
                        $current = array_slice($txtarr, -7, 1);
                        $compare = array_diff($expected, $current);
                        if(empty($compare)) {
                            $skip = false;
                        } else {
                            $skip = true;
                        }
                    }
                }
            }
        }
        if(!TCPDF_STATIC::empty_string($word)) {
            $txtarr = array_merge($txtarr, $this->hyphenateWord($word, $patterns, $dictionary, $leftmin, $rightmin, $charmin, $charmax));
        }
        return TCPDF_FONTS::UTF8ArrSubString($txtarr, "", "", $this->isunicode);
    }
    public function setRasterizeVectorImages($mode)
    {
        $this->rasterize_vector_images = $mode;
    }
    public function setFontSubsetting($enable = true)
    {
        if($this->pdfa_mode) {
            $this->font_subsetting = false;
        } else {
            $this->font_subsetting = $enable ? true : false;
        }
    }
    public function getFontSubsetting()
    {
        return $this->font_subsetting;
    }
    public function stringLeftTrim($str, $replace = "")
    {
        return preg_replace("/^" . $this->re_space["p"] . "+/" . $this->re_space["m"], $replace, $str);
    }
    public function stringRightTrim($str, $replace = "")
    {
        return preg_replace("/" . $this->re_space["p"] . "+\$/" . $this->re_space["m"], $replace, $str);
    }
    public function stringTrim($str, $replace = "")
    {
        $str = $this->stringLeftTrim($str, $replace);
        $str = $this->stringRightTrim($str, $replace);
        return $str;
    }
    public function isUnicodeFont()
    {
        return $this->CurrentFont["type"] == "TrueTypeUnicode" || $this->CurrentFont["type"] == "cidfont0";
    }
    public function getFontFamilyName($fontfamily)
    {
        $fontfamily = preg_replace("/[^a-z0-9_\\,]/", "", strtolower($fontfamily));
        $fontslist = preg_split("/[,]/", $fontfamily);
        foreach ($fontslist as $font) {
            $font = preg_replace("/regular\$/", "", $font);
            $font = preg_replace("/italic\$/", "I", $font);
            $font = preg_replace("/oblique\$/", "I", $font);
            $font = preg_replace("/bold([I]?)\$/", "B\\1", $font);
            $pattern = [];
            $replacement = [];
            $pattern[] = "/^serif|^cursive|^fantasy|^timesnewroman/";
            $replacement[] = "times";
            $pattern[] = "/^sansserif/";
            $replacement[] = "helvetica";
            $pattern[] = "/^monospace/";
            $replacement[] = "courier";
            $font = preg_replace($pattern, $replacement, $font);
            if(in_array(strtolower($font), $this->fontlist) || in_array($font, $this->fontkeys)) {
                return $font;
            }
        }
        return $this->CurrentFont["fontkey"];
    }
    public function startTemplate($w = 0, $h = 0, $group = false)
    {
        if($this->inxobj) {
            return false;
        }
        $this->inxobj = true;
        $this->n++;
        $this->xobjid = "XT" . $this->n;
        $this->xobjects[$this->xobjid] = ["n" => $this->n];
        $this->xobjects[$this->xobjid]["gvars"] = $this->getGraphicVars();
        $this->xobjects[$this->xobjid]["intmrk"] = 0;
        $this->xobjects[$this->xobjid]["transfmrk"] = [];
        $this->xobjects[$this->xobjid]["outdata"] = "";
        $this->xobjects[$this->xobjid]["xobjects"] = [];
        $this->xobjects[$this->xobjid]["images"] = [];
        $this->xobjects[$this->xobjid]["fonts"] = [];
        $this->xobjects[$this->xobjid]["annotations"] = [];
        $this->xobjects[$this->xobjid]["extgstates"] = [];
        $this->xobjects[$this->xobjid]["gradients"] = [];
        $this->xobjects[$this->xobjid]["spot_colors"] = [];
        $this->num_columns = 1;
        $this->current_column = 0;
        $this->setAutoPageBreak(false);
        if($w === "" || $w <= 0) {
            $w = $this->w - $this->lMargin - $this->rMargin;
        }
        if($h === "" || $h <= 0) {
            $h = $this->h - $this->tMargin - $this->bMargin;
        }
        $this->xobjects[$this->xobjid]["x"] = 0;
        $this->xobjects[$this->xobjid]["y"] = 0;
        $this->xobjects[$this->xobjid]["w"] = $w;
        $this->xobjects[$this->xobjid]["h"] = $h;
        $this->w = $w;
        $this->h = $h;
        $this->wPt = $this->w * $this->k;
        $this->hPt = $this->h * $this->k;
        $this->fwPt = $this->wPt;
        $this->fhPt = $this->hPt;
        $this->x = 0;
        $this->y = 0;
        $this->lMargin = 0;
        $this->rMargin = 0;
        $this->tMargin = 0;
        $this->bMargin = 0;
        $this->xobjects[$this->xobjid]["group"] = $group;
        return $this->xobjid;
    }
    public function endTemplate()
    {
        if(!$this->inxobj) {
            return false;
        }
        $this->inxobj = false;
        $this->setGraphicVars($this->xobjects[$this->xobjid]["gvars"], true);
        return $this->xobjid;
    }
    public function printTemplate($id, $x = NULL, $y = NULL, $w = 0, $h = 0, $align = "", $palign = "", $fitonpage = false)
    {
        if($this->state != 2) {
            return NULL;
        }
        if(!isset($this->xobjects[$id])) {
            $this->Error("The XObject Template '" . $id . "' doesn't exist!");
        }
        if($this->inxobj) {
            if($id == $this->xobjid) {
                $this->endTemplate();
            } else {
                $this->xobjects[$this->xobjid]["xobjects"][$id] = $this->xobjects[$id];
            }
        }
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        $ow = $this->xobjects[$id]["w"];
        if($ow <= 0) {
            $ow = 1;
        }
        $oh = $this->xobjects[$id]["h"];
        if($oh <= 0) {
            $oh = 1;
        }
        if($w <= 0 && $h <= 0) {
            $w = $ow;
            $h = $oh;
        } elseif($w <= 0) {
            $w = $h * $ow / $oh;
        } elseif($h <= 0) {
            $h = $w * $oh / $ow;
        }
        list($w, $h, $x, $y) = $this->fitBlock($w, $h, $x, $y, $fitonpage);
        $rb_y = $y + $h;
        if($this->rtl) {
            if($palign == "L") {
                $xt = $this->lMargin;
            } elseif($palign == "C") {
                $xt = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($palign == "R") {
                $xt = $this->w - $this->rMargin - $w;
            } else {
                $xt = $x - $w;
            }
            $rb_x = $xt;
        } else {
            if($palign == "L") {
                $xt = $this->lMargin;
            } elseif($palign == "C") {
                $xt = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($palign == "R") {
                $xt = $this->w - $this->rMargin - $w;
            } else {
                $xt = $x;
            }
            $rb_x = $xt + $w;
        }
        $this->StartTransform();
        $sx = $w / $ow;
        $sy = $h / $oh;
        $tm = [];
        $tm[0] = $sx;
        $tm[1] = 0;
        $tm[2] = 0;
        $tm[3] = $sy;
        $tm[4] = $xt * $this->k;
        $tm[5] = ($this->h - $h - $y) * $this->k;
        $this->Transform($tm);
        $this->_out("/" . $id . " Do");
        $this->StopTransform();
        if(!empty($this->xobjects[$id]["annotations"])) {
            foreach ($this->xobjects[$id]["annotations"] as $annot) {
                $coordlt = TCPDF_STATIC::getTransformationMatrixProduct($tm, [1, 0, 0, 1, $annot["x"] * $this->k, -1 * $annot["y"] * $this->k]);
                $ax = $coordlt[4] / $this->k;
                $ay = $this->h - $h - $coordlt[5] / $this->k;
                $coordrb = TCPDF_STATIC::getTransformationMatrixProduct($tm, [1, 0, 0, 1, ($annot["x"] + $annot["w"]) * $this->k, (-1 * $annot["y"] - $annot["h"]) * $this->k]);
                $aw = $coordrb[4] / $this->k - $ax;
                $ah = $this->h - $h - $coordrb[5] / $this->k - $ay;
                $this->Annotation($ax, $ay, $aw, $ah, $annot["text"], $annot["opt"], $annot["spaces"]);
            }
        }
        switch ($align) {
            case "T":
                $this->y = $y;
                $this->x = $rb_x;
                break;
            case "M":
                $this->y = $y + round($h / 2);
                $this->x = $rb_x;
                break;
            case "B":
                $this->y = $rb_y;
                $this->x = $rb_x;
                break;
            case "N":
                $this->setY($rb_y);
                break;
        }
    }
    public function setFontStretching($perc = 100)
    {
        $this->font_stretching = $perc;
    }
    public function getFontStretching()
    {
        return $this->font_stretching;
    }
    public function setFontSpacing($spacing = 0)
    {
        $this->font_spacing = $spacing;
    }
    public function getFontSpacing()
    {
        return $this->font_spacing;
    }
    public function getPageRegions()
    {
        return $this->page_regions;
    }
    public function setPageRegions($regions = [])
    {
        $this->page_regions = [];
        foreach ($regions as $data) {
            $this->addPageRegion($data);
        }
    }
    public function addPageRegion($region)
    {
        if(!isset($region["page"]) || empty($region["page"])) {
            $region["page"] = $this->page;
        }
        if(isset($region["xt"]) && isset($region["xb"]) && 0 < $region["xt"] && 0 < $region["xb"] && isset($region["yt"]) && isset($region["yb"]) && 0 <= $region["yt"] && $region["yt"] < $region["yb"] && isset($region["side"]) && ($region["side"] == "L" || $region["side"] == "R")) {
            $this->page_regions[] = $region;
        }
    }
    public function removePageRegion($key)
    {
        if(isset($this->page_regions[$key])) {
            unset($this->page_regions[$key]);
        }
    }
    protected function checkPageRegions($h, $x, $y)
    {
        if($x === "") {
            $x = $this->x;
        }
        if($y === "") {
            $y = $this->y;
        }
        if(!$this->check_page_regions || empty($this->page_regions)) {
            return [$x, $y];
        }
        if(empty($h)) {
            $h = $this->getCellHeight($this->FontSize);
        }
        if($this->checkPageBreak($h, $y)) {
            $x = $this->x;
            $y = $this->y;
        }
        if(1 < $this->num_columns) {
            if($this->rtl) {
                $this->lMargin = $this->columns[$this->current_column]["x"] - $this->columns[$this->current_column]["w"];
            } else {
                $this->rMargin = $this->w - $this->columns[$this->current_column]["x"] - $this->columns[$this->current_column]["w"];
            }
        } elseif($this->rtl) {
            $this->lMargin = max($this->clMargin, $this->original_lMargin);
        } else {
            $this->rMargin = max($this->crMargin, $this->original_rMargin);
        }
        foreach ($this->page_regions as $regid => $regdata) {
            if($regdata["page"] == $this->page && $regdata["yt"] - $h < $y && $y <= $regdata["yb"]) {
                $minv = ($regdata["xb"] - $regdata["xt"]) / ($regdata["yb"] - $regdata["yt"]);
                $yt = max($y, $regdata["yt"]);
                $yb = min($yt + $h, $regdata["yb"]);
                $xt = ($yt - $regdata["yt"]) * $minv + $regdata["xt"];
                $xb = ($yb - $regdata["yt"]) * $minv + $regdata["xt"];
                if($regdata["side"] == "L") {
                    $new_margin = max($xt, $xb);
                    if($this->lMargin < $new_margin) {
                        if($this->rtl) {
                            $this->lMargin = max(0, $new_margin);
                        }
                        if($x < $new_margin) {
                            $x = $new_margin;
                            if($this->w - $this->rMargin < $new_margin) {
                                $y = $regdata["yb"] - $h;
                            }
                        }
                    }
                } elseif($regdata["side"] == "R") {
                    $new_margin = min($xt, $xb);
                    if($new_margin < $this->w - $this->rMargin) {
                        if(!$this->rtl) {
                            $this->rMargin = max(0, $this->w - $new_margin);
                        }
                        if($new_margin < $x) {
                            $x = $new_margin;
                            if($this->lMargin < $new_margin) {
                                $y = $regdata["yb"] - $h;
                            }
                        }
                    }
                }
            }
        }
        return [$x, $y];
    }
    public function ImageSVG($file, $x = NULL, $y = NULL, $w = 0, $h = 0, $link = "", $align = "", $palign = "", $border = 0, $fitonpage = false)
    {
        if($this->state != 2) {
            return NULL;
        }
        $this->svggradients = [];
        $this->svggradientid = 0;
        $this->svgdefsmode = false;
        $this->svgdefs = [];
        $this->svgclipmode = false;
        $this->svgclippaths = [];
        $this->svgcliptm = [];
        $this->svgclipid = 0;
        $this->svgtext = "";
        $this->svgtextmode = [];
        if($this->rasterize_vector_images && 0 < $w && 0 < $h) {
            return $this->Image($file, $x, $y, $w, $h, "SVG", $link, $align, true, 300, $palign, false, false, $border, false, false, false);
        }
        if($file[0] === "@") {
            $this->svgdir = "";
            $svgdata = substr($file, 1);
        } else {
            $this->svgdir = dirname($file);
            $svgdata = $this->getCachedFileContents($file);
        }
        if($svgdata === false) {
            $this->Error("SVG file not found: " . $file);
        }
        if(TCPDF_STATIC::empty_string($x)) {
            $x = $this->x;
        }
        if(TCPDF_STATIC::empty_string($y)) {
            $y = $this->y;
        }
        list($x, $y) = $this->checkPageRegions($h, $x, $y);
        $k = $this->k;
        $ox = 0;
        $oy = 0;
        $ow = $w;
        $oh = $h;
        $aspect_ratio_align = "xMidYMid";
        $aspect_ratio_ms = "meet";
        $regs = [];
        preg_match("/<svg([^\\>]*)>/si", $svgdata, $regs);
        if(isset($regs[1]) && !empty($regs[1])) {
            $tmp = [];
            if(preg_match("/[\\s]+x[\\s]*=[\\s]*\"([^\"]*)\"/si", $regs[1], $tmp)) {
                $ox = $this->getHTMLUnitToUnits($tmp[1], 0, $this->svgunit, false);
            }
            $tmp = [];
            if(preg_match("/[\\s]+y[\\s]*=[\\s]*\"([^\"]*)\"/si", $regs[1], $tmp)) {
                $oy = $this->getHTMLUnitToUnits($tmp[1], 0, $this->svgunit, false);
            }
            $tmp = [];
            if(preg_match("/[\\s]+width[\\s]*=[\\s]*\"([^\"]*)\"/si", $regs[1], $tmp)) {
                $ow = $this->getHTMLUnitToUnits($tmp[1], 1, $this->svgunit, false);
            }
            $tmp = [];
            if(preg_match("/[\\s]+height[\\s]*=[\\s]*\"([^\"]*)\"/si", $regs[1], $tmp)) {
                $oh = $this->getHTMLUnitToUnits($tmp[1], 1, $this->svgunit, false);
            }
            $tmp = [];
            $view_box = [];
            if(preg_match("/[\\s]+viewBox[\\s]*=[\\s]*\"[\\s]*([0-9\\.\\-]+)[\\s]+([0-9\\.\\-]+)[\\s]+([0-9\\.]+)[\\s]+([0-9\\.]+)[\\s]*\"/si", $regs[1], $tmp)) {
                if(count($tmp) == 5) {
                    array_shift($tmp);
                    foreach ($tmp as $key => $val) {
                        $view_box[$key] = $this->getHTMLUnitToUnits($val, 0, $this->svgunit, false);
                    }
                    list($ox, $oy) = $view_box;
                }
                $tmp = [];
                if(preg_match("/[\\s]+preserveAspectRatio[\\s]*=[\\s]*\"([^\"]*)\"/si", $regs[1], $tmp)) {
                    $aspect_ratio = preg_split("/[\\s]+/si", $tmp[1]);
                    count($aspect_ratio);
                    switch (count($aspect_ratio)) {
                        case 3:
                            list($aspect_ratio_align, $aspect_ratio_ms) = $aspect_ratio;
                            break;
                        case 2:
                            list($aspect_ratio_align, $aspect_ratio_ms) = $aspect_ratio;
                            break;
                        case 1:
                            $aspect_ratio_align = $aspect_ratio[0];
                            $aspect_ratio_ms = "meet";
                            break;
                    }
                }
            }
        }
        if($ow <= 0) {
            $ow = 1;
        }
        if($oh <= 0) {
            $oh = 1;
        }
        if($w <= 0 && $h <= 0) {
            $w = $ow;
            $h = $oh;
        } elseif($w <= 0) {
            $w = $h * $ow / $oh;
        } elseif($h <= 0) {
            $h = $w * $oh / $ow;
        }
        list($w, $h, $x, $y) = $this->fitBlock($w, $h, $x, $y, $fitonpage);
        if($this->rasterize_vector_images) {
            return $this->Image($file, $x, $y, $w, $h, "SVG", $link, $align, true, 300, $palign, false, false, $border, false, false, false);
        }
        $this->img_rb_y = $y + $h;
        if($this->rtl) {
            if($palign == "L") {
                $ximg = $this->lMargin;
            } elseif($palign == "C") {
                $ximg = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($palign == "R") {
                $ximg = $this->w - $this->rMargin - $w;
            } else {
                $ximg = $x - $w;
            }
            $this->img_rb_x = $ximg;
        } else {
            if($palign == "L") {
                $ximg = $this->lMargin;
            } elseif($palign == "C") {
                $ximg = ($this->w + $this->lMargin - $this->rMargin - $w) / 2;
            } elseif($palign == "R") {
                $ximg = $this->w - $this->rMargin - $w;
            } else {
                $ximg = $x;
            }
            $this->img_rb_x = $ximg + $w;
        }
        $gvars = $this->getGraphicVars();
        $svgoffset_x = ($ximg - $ox) * $this->k;
        $svgoffset_y = -1 * ($y - $oy) * $this->k;
        if(isset($view_box[2]) && 0 < $view_box[2] && 0 < $view_box[3]) {
            list($ow, $oh) = $view_box;
        } else {
            if($ow <= 0) {
                $ow = $w;
            }
            if($oh <= 0) {
                $oh = $h;
            }
        }
        $svgscale_x = $w / $ow;
        $svgscale_y = $h / $oh;
        if($aspect_ratio_align != "none") {
            $svgscale_old_x = $svgscale_x;
            $svgscale_old_y = $svgscale_y;
            if($aspect_ratio_ms == "slice") {
                if($svgscale_y < $svgscale_x) {
                    $svgscale_y = $svgscale_x;
                } elseif($svgscale_x < $svgscale_y) {
                    $svgscale_x = $svgscale_y;
                }
            } elseif($svgscale_x < $svgscale_y) {
                $svgscale_y = $svgscale_x;
            } elseif($svgscale_y < $svgscale_x) {
                $svgscale_x = $svgscale_y;
            }
            substr($aspect_ratio_align, 1, 3);
            switch (substr($aspect_ratio_align, 1, 3)) {
                case "Min":
                case "Max":
                    $svgoffset_x += $w * $this->k - $ow * $this->k * $svgscale_x;
                    break;
                case "Mid":
                default:
                    $svgoffset_x += ($w * $this->k - $ow * $this->k * $svgscale_x) / 2;
                    substr($aspect_ratio_align, 5);
                    switch (substr($aspect_ratio_align, 5)) {
                        case "Min":
                        case "Max":
                            $svgoffset_y -= $h * $this->k - $oh * $this->k * $svgscale_y;
                            break;
                        case "Mid":
                        default:
                            $svgoffset_y -= ($h * $this->k - $oh * $this->k * $svgscale_y) / 2;
                    }
            }
        }
        $page_break_mode = $this->AutoPageBreak;
        $page_break_margin = $this->getBreakMargin();
        $cell_padding = $this->cell_padding;
        $this->setCellPadding(0);
        $this->setAutoPageBreak(false);
        $this->_out("q" . $this->epsmarker);
        $this->Rect($ximg, $y, $w, $h, "CNZ", [], []);
        $e = $ox * $this->k * (1 - $svgscale_x);
        $f = ($this->h - $oy) * $this->k * (1 - $svgscale_y);
        $this->_out(sprintf("%F %F %F %F %F %F cm", $svgscale_x, 0, 0, $svgscale_y, $e + $svgoffset_x, $f + $svgoffset_y));
        $parser = xml_parser_create("UTF-8");
        xml_set_object($parser, $this);
        xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
        xml_set_element_handler($parser, "startSVGElementHandler", "endSVGElementHandler");
        xml_set_character_data_handler($parser, "segSVGContentHandler");
        if(!xml_parse($parser, $svgdata)) {
            $error_message = sprintf("SVG Error: %s at line %d", xml_error_string(xml_get_error_code($parser)), xml_get_current_line_number($parser));
            $this->Error($error_message);
        }
        xml_parser_free($parser);
        unset($parser);
        $this->_out($this->epsmarker . "Q");
        $this->setGraphicVars($gvars);
        $this->lasth = $gvars["lasth"];
        if(!empty($border)) {
            $bx = $this->x;
            $by = $this->y;
            $this->x = $ximg;
            if($this->rtl) {
                $this->x += $w;
            }
            $this->y = $y;
            $this->Cell($w, $h, "", $border, 0, "", 0, "", 0, true);
            $this->x = $bx;
            $this->y = $by;
        }
        if($link) {
            $this->Link($ximg, $y, $w, $h, $link, 0);
        }
        switch ($align) {
            case "T":
                $this->y = $y;
                $this->x = $this->img_rb_x;
                break;
            case "M":
                $this->y = $y + round($h / 2);
                $this->x = $this->img_rb_x;
                break;
            case "B":
                $this->y = $this->img_rb_y;
                $this->x = $this->img_rb_x;
                break;
            case "N":
                $this->setY($this->img_rb_y);
                break;
            default:
                $this->x = $gvars["x"];
                $this->y = $gvars["y"];
                $this->page = $gvars["page"];
                $this->current_column = $gvars["current_column"];
                $this->tMargin = $gvars["tMargin"];
                $this->bMargin = $gvars["bMargin"];
                $this->w = $gvars["w"];
                $this->h = $gvars["h"];
                $this->wPt = $gvars["wPt"];
                $this->hPt = $gvars["hPt"];
                $this->fwPt = $gvars["fwPt"];
                $this->fhPt = $gvars["fhPt"];
                $this->endlinex = $this->img_rb_x;
                $this->setAutoPageBreak($page_break_mode, $page_break_margin);
                $this->cell_padding = $cell_padding;
        }
    }
    protected function convertSVGtMatrix($tm)
    {
        $a = $tm[0];
        $b = -1 * $tm[1];
        $c = -1 * $tm[2];
        $d = $tm[3];
        $e = $this->getHTMLUnitToUnits($tm[4], 1, $this->svgunit, false) * $this->k;
        $f = -1 * $this->getHTMLUnitToUnits($tm[5], 1, $this->svgunit, false) * $this->k;
        $x = 0;
        $y = $this->h * $this->k;
        $e = $x * (1 - $a) - $y * $c + $e;
        $f = $y * (1 - $d) - $x * $b + $f;
        return [$a, $b, $c, $d, $e, $f];
    }
    protected function SVGTransform($tm)
    {
        $this->Transform($this->convertSVGtMatrix($tm));
    }
    protected function setSVGStyles($svgstyle, $prevsvgstyle, $x = 0, $y = 0, $w = 1, $h = 1, $clip_function = "", $clip_params = [])
    {
        if($this->state != 2) {
            return NULL;
        }
        $objstyle = "";
        $minlen = 0 / $this->k;
        if(!isset($svgstyle["opacity"])) {
            return $objstyle;
        }
        $regs = [];
        if(preg_match("/url\\([\\s]*\\#([^\\)]*)\\)/si", $svgstyle["clip-path"], $regs)) {
            $clip_path = $this->svgclippaths[$regs[1]];
            foreach ($clip_path as $cp) {
                $this->startSVGElementHandler("clip-path", $cp["name"], $cp["attribs"], $cp["tm"]);
            }
        }
        if($svgstyle["opacity"] != 1) {
            $this->setAlpha($svgstyle["opacity"], "Normal", $svgstyle["opacity"], false);
        }
        $fill_color = TCPDF_COLORS::convertHTMLColorToDec($svgstyle["color"], $this->spot_colors);
        $this->setFillColorArray($fill_color);
        $text_color = TCPDF_COLORS::convertHTMLColorToDec($svgstyle["text-color"], $this->spot_colors);
        $this->setTextColorArray($text_color);
        if(preg_match("/rect\\(([a-z0-9\\-\\.]*)[\\s]*([a-z0-9\\-\\.]*)[\\s]*([a-z0-9\\-\\.]*)[\\s]*([a-z0-9\\-\\.]*)\\)/si", $svgstyle["clip"], $regs)) {
            $top = isset($regs[1]) ? $this->getHTMLUnitToUnits($regs[1], 0, $this->svgunit, false) : 0;
            $right = isset($regs[2]) ? $this->getHTMLUnitToUnits($regs[2], 0, $this->svgunit, false) : 0;
            $bottom = isset($regs[3]) ? $this->getHTMLUnitToUnits($regs[3], 0, $this->svgunit, false) : 0;
            $left = isset($regs[4]) ? $this->getHTMLUnitToUnits($regs[4], 0, $this->svgunit, false) : 0;
            $cx = $x + $left;
            $cy = $y + $top;
            $cw = $w - $left - $right;
            $ch = $h - $top - $bottom;
            if($svgstyle["clip-rule"] == "evenodd") {
                $clip_rule = "CNZ";
            } else {
                $clip_rule = "CEO";
            }
            $this->Rect($cx, $cy, $cw, $ch, $clip_rule, [], []);
        }
        $regs = [];
        if(preg_match("/url\\([\\s]*\\#([^\\)]*)\\)/si", $svgstyle["fill"], $regs)) {
            $gradient = $this->svggradients[$regs[1]];
            if(isset($gradient["xref"])) {
                $newgradient = $this->svggradients[$gradient["xref"]];
                $newgradient["coords"] = $gradient["coords"];
                $newgradient["mode"] = $gradient["mode"];
                $newgradient["type"] = $gradient["type"];
                $newgradient["gradientUnits"] = $gradient["gradientUnits"];
                if(isset($gradient["gradientTransform"])) {
                    $newgradient["gradientTransform"] = $gradient["gradientTransform"];
                }
                $gradient = $newgradient;
            }
            $this->_outSaveGraphicsState();
            if(!empty($clip_function) && method_exists($this, $clip_function)) {
                $bbox = call_user_func_array([$this, $clip_function], $clip_params);
                if((!isset($gradient["type"]) || $gradient["type"] != 3) && is_array($bbox) && count($bbox) == 4) {
                    list($x, $y, $w, $h) = $bbox;
                }
            }
            if($gradient["mode"] == "measure") {
                if(!isset($gradient["coords"][4])) {
                    $gradient["coords"][4] = 0;
                }
                if(isset($gradient["gradientTransform"]) && !empty($gradient["gradientTransform"])) {
                    $gtm = $gradient["gradientTransform"];
                    $xa = $gtm[0] * $gradient["coords"][0] + $gtm[2] * $gradient["coords"][1] + $gtm[4];
                    $ya = $gtm[1] * $gradient["coords"][0] + $gtm[3] * $gradient["coords"][1] + $gtm[5];
                    $xb = $gtm[0] * $gradient["coords"][2] + $gtm[2] * $gradient["coords"][3] + $gtm[4];
                    $yb = $gtm[1] * $gradient["coords"][2] + $gtm[3] * $gradient["coords"][3] + $gtm[5];
                    $r = sqrt(pow($gtm[0] * $gradient["coords"][4], 2) + pow($gtm[1] * $gradient["coords"][4], 2));
                    $gradient["coords"][0] = $xa;
                    $gradient["coords"][1] = $ya;
                    $gradient["coords"][2] = $xb;
                    $gradient["coords"][3] = $yb;
                    $gradient["coords"][4] = $r;
                }
                $gradient["coords"][0] = $this->getHTMLUnitToUnits($gradient["coords"][0], 0, $this->svgunit, false);
                $gradient["coords"][1] = $this->getHTMLUnitToUnits($gradient["coords"][1], 0, $this->svgunit, false);
                $gradient["coords"][2] = $this->getHTMLUnitToUnits($gradient["coords"][2], 0, $this->svgunit, false);
                $gradient["coords"][3] = $this->getHTMLUnitToUnits($gradient["coords"][3], 0, $this->svgunit, false);
                $gradient["coords"][4] = $this->getHTMLUnitToUnits($gradient["coords"][4], 0, $this->svgunit, false);
                if($w <= $minlen) {
                    $w = $minlen;
                }
                if($h <= $minlen) {
                    $h = $minlen;
                }
                if($gradient["gradientUnits"] == "objectBoundingBox") {
                    $gradient["coords"][0] += $x;
                    $gradient["coords"][1] += $y;
                    $gradient["coords"][2] += $x;
                    $gradient["coords"][3] += $y;
                }
                $gradient["coords"][0] = ($gradient["coords"][0] - $x) / $w;
                $gradient["coords"][1] = ($gradient["coords"][1] - $y) / $h;
                $gradient["coords"][2] = ($gradient["coords"][2] - $x) / $w;
                $gradient["coords"][3] = ($gradient["coords"][3] - $y) / $h;
                $gradient["coords"][4] /= $w;
            } elseif($gradient["mode"] == "percentage") {
                foreach ($gradient["coords"] as $key => $val) {
                    $gradient["coords"][$key] = intval($val) / 100;
                    if($val < 0) {
                        $gradient["coords"][$key] = 0;
                    } elseif(1 < $val) {
                        $gradient["coords"][$key] = 1;
                    }
                }
            }
            if($gradient["type"] == 2 && $gradient["coords"][0] == $gradient["coords"][2] && $gradient["coords"][1] == $gradient["coords"][3]) {
                $gradient["coords"][0] = 1;
                $gradient["coords"][1] = 0;
                $gradient["coords"][2] = 0;
                $gradient["coords"][3] = 0;
            }
            $tmp = $gradient["coords"][1];
            $gradient["coords"][1] = $gradient["coords"][3];
            $gradient["coords"][3] = $tmp;
            $cy = $this->h - $y;
            if($gradient["type"] == 3) {
                $cy -= $gradient["coords"][1] * ($w + $h);
                $h = $w = max($w, $h);
            } else {
                $cy -= $h;
            }
            $this->_out(sprintf("%F 0 0 %F %F %F cm", $w * $this->k, $h * $this->k, $x * $this->k, $cy * $this->k));
            if(1 < count($gradient["stops"])) {
                $this->Gradient($gradient["type"], $gradient["coords"], $gradient["stops"], [], false);
            }
        } elseif($svgstyle["fill"] != "none") {
            $fill_color = TCPDF_COLORS::convertHTMLColorToDec($svgstyle["fill"], $this->spot_colors);
            if($svgstyle["fill-opacity"] != 1) {
                $this->setAlpha($this->alpha["CA"], "Normal", $svgstyle["fill-opacity"], false);
            }
            $this->setFillColorArray($fill_color);
            if($svgstyle["fill-rule"] == "evenodd") {
                $objstyle .= "F*";
            } else {
                $objstyle .= "F";
            }
        }
        if($svgstyle["stroke"] != "none") {
            if($svgstyle["stroke-opacity"] != 1) {
                $this->setAlpha($svgstyle["stroke-opacity"], "Normal", $this->alpha["ca"], false);
            } elseif(preg_match("/rgba\\(\\d+%?,\\s*\\d+%?,\\s*\\d+%?,\\s*(\\d+(?:\\.\\d+)?)\\)/i", $svgstyle["stroke"], $rgba_matches)) {
                $this->setAlpha($rgba_matches[1], "Normal", $this->alpha["ca"], false);
            }
            $stroke_style = ["color" => TCPDF_COLORS::convertHTMLColorToDec($svgstyle["stroke"], $this->spot_colors), "width" => $this->getHTMLUnitToUnits($svgstyle["stroke-width"], 0, $this->svgunit, false), "cap" => $svgstyle["stroke-linecap"], "join" => $svgstyle["stroke-linejoin"]];
            if(isset($svgstyle["stroke-dasharray"]) && !empty($svgstyle["stroke-dasharray"]) && $svgstyle["stroke-dasharray"] != "none") {
                $stroke_style["dash"] = $svgstyle["stroke-dasharray"];
            }
            $this->setLineStyle($stroke_style);
            $objstyle .= "D";
        }
        $regs = [];
        if(!empty($svgstyle["font"])) {
            if(preg_match("/font-family[\\s]*:[\\s]*([^\\;\\\"]*)/si", $svgstyle["font"], $regs)) {
                $font_family = $this->getFontFamilyName($regs[1]);
            } else {
                $font_family = $svgstyle["font-family"];
            }
            if(preg_match("/font-size[\\s]*:[\\s]*([^\\s\\;\\\"]*)/si", $svgstyle["font"], $regs)) {
                $font_size = trim($regs[1]);
            } else {
                $font_size = $svgstyle["font-size"];
            }
            if(preg_match("/font-style[\\s]*:[\\s]*([^\\s\\;\\\"]*)/si", $svgstyle["font"], $regs)) {
                $font_style = trim($regs[1]);
            } else {
                $font_style = $svgstyle["font-style"];
            }
            if(preg_match("/font-weight[\\s]*:[\\s]*([^\\s\\;\\\"]*)/si", $svgstyle["font"], $regs)) {
                $font_weight = trim($regs[1]);
            } else {
                $font_weight = $svgstyle["font-weight"];
            }
            if(preg_match("/font-stretch[\\s]*:[\\s]*([^\\s\\;\\\"]*)/si", $svgstyle["font"], $regs)) {
                $font_stretch = trim($regs[1]);
            } else {
                $font_stretch = $svgstyle["font-stretch"];
            }
            if(preg_match("/letter-spacing[\\s]*:[\\s]*([^\\s\\;\\\"]*)/si", $svgstyle["font"], $regs)) {
                $font_spacing = trim($regs[1]);
            } else {
                $font_spacing = $svgstyle["letter-spacing"];
            }
        } else {
            $font_family = $this->getFontFamilyName($svgstyle["font-family"]);
            $font_size = $svgstyle["font-size"];
            $font_style = $svgstyle["font-style"];
            $font_weight = $svgstyle["font-weight"];
            $font_stretch = $svgstyle["font-stretch"];
            $font_spacing = $svgstyle["letter-spacing"];
        }
        $font_size = $this->getHTMLFontUnits($font_size, $this->svgstyles[0]["font-size"], $prevsvgstyle["font-size"], $this->svgunit);
        $font_stretch = $this->getCSSFontStretching($font_stretch, $svgstyle["font-stretch"]);
        $font_spacing = $this->getCSSFontSpacing($font_spacing, $svgstyle["letter-spacing"]);
        switch ($font_style) {
            case "italic":
                $font_style = "I";
                break;
            case "oblique":
                $font_style = "I";
                break;
            case "normal":
            default:
                $font_style = "";
                switch ($font_weight) {
                    case "bold":
                    case "bolder":
                        $font_style .= "B";
                        break;
                    case "normal":
                        if(substr($font_family, -1) == "I" && substr($font_family, -2, 1) == "B") {
                            $font_family = substr($font_family, 0, -2) . "I";
                        } elseif(substr($font_family, -1) == "B") {
                            $font_family = substr($font_family, 0, -1);
                        }
                        break;
                    default:
                        switch ($svgstyle["text-decoration"]) {
                            case "underline":
                                $font_style .= "U";
                                break;
                            case "overline":
                                $font_style .= "O";
                                break;
                            case "line-through":
                                $font_style .= "D";
                                break;
                            case "none":
                            default:
                                $this->setFont($font_family, $font_style, $font_size);
                                $this->setFontStretching($font_stretch);
                                $this->setFontSpacing($font_spacing);
                                return $objstyle;
                        }
                }
        }
    }
    protected function SVGPath($d, $style = "")
    {
        if($this->state != 2) {
            return NULL;
        }
        $op = TCPDF_STATIC::getPathPaintOperator($style, "");
        if(empty($op)) {
            return NULL;
        }
        $paths = [];
        $d = preg_replace("/([0-9ACHLMQSTVZ])([\\-\\+])/si", "\\1 \\2", $d);
        $d = preg_replace("/(\\.[0-9]+)(\\.)/s", "\\1 \\2", $d);
        preg_match_all("/([ACHLMQSTVZ])[\\s]*([^ACHLMQSTVZ\\\"]*)/si", $d, $paths, PREG_SET_ORDER);
        $x = 0;
        $y = 0;
        $x1 = 0;
        $y1 = 0;
        $x2 = 0;
        $y2 = 0;
        $xmin = -2147483649.0;
        $xmax = 0;
        $ymin = -2147483649.0;
        $ymax = 0;
        $xinitial = 0;
        $yinitial = 0;
        $relcoord = false;
        $minlen = 0 / $this->k;
        $firstcmd = true;
        foreach ($paths as $key => $val) {
            $cmd = trim($val[1]);
            if(strtolower($cmd) == $cmd) {
                $relcoord = true;
                $xoffset = $x;
                $yoffset = $y;
            } else {
                $relcoord = false;
                $xoffset = 0;
                $yoffset = 0;
            }
            $params = [];
            if(isset($val[2])) {
                $rawparams = preg_split("/([\\,\\s]+)/si", trim($val[2]));
                $params = [];
                foreach ($rawparams as $ck => $cp) {
                    $params[$ck] = $this->getHTMLUnitToUnits($cp, 0, $this->svgunit, false);
                    if(abs($params[$ck]) < $minlen) {
                        $params[$ck] = 0;
                    }
                }
            }
            $x0 = $x;
            $y0 = $y;
            strtoupper($cmd);
            switch (strtoupper($cmd)) {
                case "M":
                    foreach ($params as $ck => $cp) {
                        if($ck % 2 == 0) {
                            $x = $cp + $xoffset;
                        } else {
                            $y = $cp + $yoffset;
                            if($firstcmd || $minlen <= abs($x0 - $x) || $minlen <= abs($y0 - $y)) {
                                if($ck == 1) {
                                    $this->_outPoint($x, $y);
                                    $firstcmd = false;
                                    $xinitial = $x;
                                    $yinitial = $y;
                                } else {
                                    $this->_outLine($x, $y);
                                }
                                $x0 = $x;
                                $y0 = $y;
                            }
                            $xmin = min($xmin, $x);
                            $ymin = min($ymin, $y);
                            $xmax = max($xmax, $x);
                            $ymax = max($ymax, $y);
                            if($relcoord) {
                                $xoffset = $x;
                                $yoffset = $y;
                            }
                        }
                    }
                    break;
                case "L":
                    foreach ($params as $ck => $cp) {
                        if($ck % 2 == 0) {
                            $x = $cp + $xoffset;
                        } else {
                            $y = $cp + $yoffset;
                            if($minlen <= abs($x0 - $x) || $minlen <= abs($y0 - $y)) {
                                $this->_outLine($x, $y);
                                $x0 = $x;
                                $y0 = $y;
                            }
                            $xmin = min($xmin, $x);
                            $ymin = min($ymin, $y);
                            $xmax = max($xmax, $x);
                            $ymax = max($ymax, $y);
                            if($relcoord) {
                                $xoffset = $x;
                                $yoffset = $y;
                            }
                        }
                    }
                    break;
                case "H":
                    foreach ($params as $ck => $cp) {
                        $x = $cp + $xoffset;
                        if($minlen <= abs($x0 - $x) || $minlen <= abs($y0 - $y)) {
                            $this->_outLine($x, $y);
                            $x0 = $x;
                            $y0 = $y;
                        }
                        $xmin = min($xmin, $x);
                        $xmax = max($xmax, $x);
                        if($relcoord) {
                            $xoffset = $x;
                        }
                    }
                    break;
                case "V":
                    foreach ($params as $ck => $cp) {
                        $y = $cp + $yoffset;
                        if($minlen <= abs($x0 - $x) || $minlen <= abs($y0 - $y)) {
                            $this->_outLine($x, $y);
                            $x0 = $x;
                            $y0 = $y;
                        }
                        $ymin = min($ymin, $y);
                        $ymax = max($ymax, $y);
                        if($relcoord) {
                            $yoffset = $y;
                        }
                    }
                    break;
                case "C":
                    foreach ($params as $ck => $cp) {
                        $params[$ck] = $cp;
                        if(($ck + 1) % 6 == 0) {
                            $x1 = $params[$ck - 5] + $xoffset;
                            $y1 = $params[$ck - 4] + $yoffset;
                            $x2 = $params[$ck - 3] + $xoffset;
                            $y2 = $params[$ck - 2] + $yoffset;
                            $x = $params[$ck - 1] + $xoffset;
                            $y = $params[$ck] + $yoffset;
                            $this->_outCurve($x1, $y1, $x2, $y2, $x, $y);
                            $xmin = min($xmin, $x, $x1, $x2);
                            $ymin = min($ymin, $y, $y1, $y2);
                            $xmax = max($xmax, $x, $x1, $x2);
                            $ymax = max($ymax, $y, $y1, $y2);
                            if($relcoord) {
                                $xoffset = $x;
                                $yoffset = $y;
                            }
                        }
                    }
                    break;
                case "S":
                    foreach ($params as $ck => $cp) {
                        $params[$ck] = $cp;
                        if(($ck + 1) % 4 == 0) {
                            if(0 < $key && (strtoupper($paths[$key - 1][1]) == "C" || strtoupper($paths[$key - 1][1]) == "S")) {
                                $x1 = 2 * $x - $x2;
                                $y1 = 2 * $y - $y2;
                            } else {
                                $x1 = $x;
                                $y1 = $y;
                            }
                            $x2 = $params[$ck - 3] + $xoffset;
                            $y2 = $params[$ck - 2] + $yoffset;
                            $x = $params[$ck - 1] + $xoffset;
                            $y = $params[$ck] + $yoffset;
                            $this->_outCurve($x1, $y1, $x2, $y2, $x, $y);
                            $xmin = min($xmin, $x, $x1, $x2);
                            $ymin = min($ymin, $y, $y1, $y2);
                            $xmax = max($xmax, $x, $x1, $x2);
                            $ymax = max($ymax, $y, $y1, $y2);
                            if($relcoord) {
                                $xoffset = $x;
                                $yoffset = $y;
                            }
                        }
                    }
                    break;
                case "Q":
                    foreach ($params as $ck => $cp) {
                        $params[$ck] = $cp;
                        if(($ck + 1) % 4 == 0) {
                            $x1 = $params[$ck - 3] + $xoffset;
                            $y1 = $params[$ck - 2] + $yoffset;
                            $xa = ($x + 2 * $x1) / 3;
                            $ya = ($y + 2 * $y1) / 3;
                            $x = $params[$ck - 1] + $xoffset;
                            $y = $params[$ck] + $yoffset;
                            $xb = ($x + 2 * $x1) / 3;
                            $yb = ($y + 2 * $y1) / 3;
                            $this->_outCurve($xa, $ya, $xb, $yb, $x, $y);
                            $xmin = min($xmin, $x, $xa, $xb);
                            $ymin = min($ymin, $y, $ya, $yb);
                            $xmax = max($xmax, $x, $xa, $xb);
                            $ymax = max($ymax, $y, $ya, $yb);
                            if($relcoord) {
                                $xoffset = $x;
                                $yoffset = $y;
                            }
                        }
                    }
                    break;
                case "T":
                    foreach ($params as $ck => $cp) {
                        $params[$ck] = $cp;
                        if($ck % 2 != 0) {
                            if(0 < $key && (strtoupper($paths[$key - 1][1]) == "Q" || strtoupper($paths[$key - 1][1]) == "T")) {
                                $x1 = 2 * $x - $x1;
                                $y1 = 2 * $y - $y1;
                            } else {
                                $x1 = $x;
                                $y1 = $y;
                            }
                            $xa = ($x + 2 * $x1) / 3;
                            $ya = ($y + 2 * $y1) / 3;
                            $x = $params[$ck - 1] + $xoffset;
                            $y = $params[$ck] + $yoffset;
                            $xb = ($x + 2 * $x1) / 3;
                            $yb = ($y + 2 * $y1) / 3;
                            $this->_outCurve($xa, $ya, $xb, $yb, $x, $y);
                            $xmin = min($xmin, $x, $xa, $xb);
                            $ymin = min($ymin, $y, $ya, $yb);
                            $xmax = max($xmax, $x, $xa, $xb);
                            $ymax = max($ymax, $y, $ya, $yb);
                            if($relcoord) {
                                $xoffset = $x;
                                $yoffset = $y;
                            }
                        }
                    }
                    break;
                case "A":
                    foreach ($params as $ck => $cp) {
                        $params[$ck] = $cp;
                        if(($ck + 1) % 7 == 0) {
                            $x0 = $x;
                            $y0 = $y;
                            $rx = max(abs($params[$ck - 6]), 0);
                            $ry = max(abs($params[$ck - 5]), 0);
                            $ang = -1 * $rawparams[$ck - 4];
                            $angle = deg2rad($ang);
                            $fa = $rawparams[$ck - 3];
                            $fs = $rawparams[$ck - 2];
                            $x = $params[$ck - 1] + $xoffset;
                            $y = $params[$ck] + $yoffset;
                            if(abs($x0 - $x) < $minlen && abs($y0 - $y) < $minlen) {
                                $xmin = min($xmin, $x);
                                $ymin = min($ymin, $y);
                                $xmax = max($xmax, $x);
                                $ymax = max($ymax, $y);
                            } else {
                                $cos_ang = cos($angle);
                                $sin_ang = sin($angle);
                                $a = ($x0 - $x) / 2;
                                $b = ($y0 - $y) / 2;
                                $xa = $a * $cos_ang - $b * $sin_ang;
                                $ya = $a * $sin_ang + $b * $cos_ang;
                                $rx2 = $rx * $rx;
                                $ry2 = $ry * $ry;
                                $xa2 = $xa * $xa;
                                $ya2 = $ya * $ya;
                                $delta = $xa2 / $rx2 + $ya2 / $ry2;
                                if(1 < $delta) {
                                    $rx *= sqrt($delta);
                                    $ry *= sqrt($delta);
                                    $rx2 = $rx * $rx;
                                    $ry2 = $ry * $ry;
                                }
                                $numerator = $rx2 * $ry2 - $rx2 * $ya2 - $ry2 * $xa2;
                                if($numerator < 0) {
                                    $root = 0;
                                } else {
                                    $root = sqrt($numerator / ($rx2 * $ya2 + $ry2 * $xa2));
                                }
                                if($fa == $fs) {
                                    $root *= -1;
                                }
                                $cax = $root * ($rx * $ya) / $ry;
                                $cay = -1 * $root * ($ry * $xa) / $rx;
                                $cx = $cax * $cos_ang - $cay * $sin_ang + ($x0 + $x) / 2;
                                $cy = $cax * $sin_ang + $cay * $cos_ang + ($y0 + $y) / 2;
                                $angs = TCPDF_STATIC::getVectorsAngle(1, 0, ($xa - $cax) / $rx, ($cay - $ya) / $ry);
                                $dang = TCPDF_STATIC::getVectorsAngle(($xa - $cax) / $rx, ($ya - $cay) / $ry, (-1 * $xa - $cax) / $rx, (-1 * $ya - $cay) / $ry);
                                if($fs == 0 && 0 < $dang) {
                                    $dang -= 2 * M_PI;
                                } elseif($fs == 1 && $dang < 0) {
                                    $dang += 2 * M_PI;
                                }
                                $angf = $angs - $dang;
                                if($fs == 0 && $angf < $angs || $fs == 1 && $angs < $angf) {
                                    $tmp = $angs;
                                    $angs = $angf;
                                    $angf = $tmp;
                                }
                                $angs = round(rad2deg($angs), 6);
                                $angf = round(rad2deg($angf), 6);
                                if($angs < 0 && $angf < 0) {
                                    $angs += 360;
                                    $angf += 360;
                                }
                                $pie = false;
                                if($key == 0 && isset($paths[$key + 1][1]) && trim($paths[$key + 1][1]) == "z") {
                                    $pie = true;
                                }
                                list($axmin, $aymin, $axmax, $aymax) = $this->_outellipticalarc($cx, $cy, $rx, $ry, $ang, $angs, $angf, $pie, 2, false, $fs == 0, true);
                                $xmin = min($xmin, $x, $axmin);
                                $ymin = min($ymin, $y, $aymin);
                                $xmax = max($xmax, $x, $axmax);
                                $ymax = max($ymax, $y, $aymax);
                            }
                            if($relcoord) {
                                $xoffset = $x;
                                $yoffset = $y;
                            }
                        }
                    }
                    break;
                case "Z":
                    $this->_out("h");
                    $x = $x0 = $xinitial;
                    $y = $y0 = $yinitial;
                    break;
                default:
                    $firstcmd = false;
            }
        }
        if(!empty($op)) {
            $this->_out($op);
        }
        return [$xmin, $ymin, $xmax - $xmin, $ymax - $ymin];
    }
    protected function removeTagNamespace($name)
    {
        if(strpos($name, ":") !== false) {
            $parts = explode(":", $name);
            return $parts[sizeof($parts) - 1];
        }
        return $name;
    }
    protected function startSVGElementHandler($parser, $name, $attribs, $ctm = [])
    {
        $name = $this->removeTagNamespace($name);
        if($this->svgclipmode) {
            $this->svgclippaths[$this->svgclipid][] = ["name" => $name, "attribs" => $attribs, "tm" => $this->svgcliptm[$this->svgclipid]];
        } elseif($this->svgdefsmode && !in_array($name, ["clipPath", "linearGradient", "radialGradient", "stop"])) {
            if(isset($attribs["id"])) {
                $attribs["child_elements"] = [];
                $this->svgdefs[$attribs["id"]] = ["name" => $name, "attribs" => $attribs];
            } elseif(end($this->svgdefs) !== false) {
                $last_svgdefs_id = key($this->svgdefs);
                if(isset($this->svgdefs[$last_svgdefs_id]["attribs"]["child_elements"])) {
                    $attribs["id"] = "DF_" . (count($this->svgdefs[$last_svgdefs_id]["attribs"]["child_elements"]) + 1);
                    $this->svgdefs[$last_svgdefs_id]["attribs"]["child_elements"][$attribs["id"]] = ["name" => $name, "attribs" => $attribs];
                }
            }
        } else {
            $clipping = false;
            if($parser == "clip-path") {
                $clipping = true;
            }
            $prev_svgstyle = $this->svgstyles[max(0, count($this->svgstyles) - 1)];
            $svgstyle = $this->svgstyles[0];
            if($clipping && !isset($attribs["fill"]) && (!isset($attribs["style"]) || !preg_match("/[;\\\"\\s]{1}fill[\\s]*:[\\s]*([^;\\\"]*)/si", $attribs["style"], $attrval))) {
                $attribs["fill"] = "none";
            }
            if(isset($attribs["style"]) && !TCPDF_STATIC::empty_string($attribs["style"]) && $attribs["style"][0] != ";") {
                $attribs["style"] = ";" . $attribs["style"];
            }
            foreach ($prev_svgstyle as $key => $val) {
                if(in_array($key, TCPDF_IMAGES::$svginheritprop)) {
                    $svgstyle[$key] = $val;
                }
                if(isset($attribs[$key]) && !TCPDF_STATIC::empty_string($attribs[$key])) {
                    if($attribs[$key] == "inherit") {
                        $svgstyle[$key] = $val;
                    } else {
                        $svgstyle[$key] = $attribs[$key];
                    }
                } elseif(isset($attribs["style"]) && !TCPDF_STATIC::empty_string($attribs["style"])) {
                    $attrval = [];
                    if(preg_match("/[;\\\"\\s]{1}" . $key . "[\\s]*:[\\s]*([^;\\\"]*)/si", $attribs["style"], $attrval) && isset($attrval[1])) {
                        if($attrval[1] == "inherit") {
                            $svgstyle[$key] = $val;
                        } else {
                            $svgstyle[$key] = $attrval[1];
                        }
                    }
                }
            }
            if(!empty($ctm)) {
                $tm = $ctm;
            } else {
                $tm = [1, 0, 0, 1, 0, 0];
            }
            if(isset($attribs["transform"]) && !empty($attribs["transform"])) {
                $tm = TCPDF_STATIC::getTransformationMatrixProduct($tm, TCPDF_STATIC::getSVGTransformMatrix($attribs["transform"]));
            }
            $svgstyle["transfmatrix"] = $tm;
            $invisible = false;
            if($svgstyle["visibility"] == "hidden" || $svgstyle["visibility"] == "collapse" || $svgstyle["display"] == "none") {
                $invisible = true;
            }
            switch ($name) {
                case "defs":
                    $this->svgdefsmode = true;
                    break;
                case "clipPath":
                    if($invisible) {
                    } else {
                        $this->svgclipmode = true;
                        if(!isset($attribs["id"])) {
                            $attribs["id"] = "CP_" . (count($this->svgcliptm) + 1);
                        }
                        $this->svgclipid = $attribs["id"];
                        $this->svgclippaths[$this->svgclipid] = [];
                        $this->svgcliptm[$this->svgclipid] = $tm;
                    }
                    break;
                case "svg":
                    if(++$this->svg_tag_depth <= 1) {
                    } else {
                        array_push($this->svgstyles, $svgstyle);
                        $this->StartTransform();
                        $svgX = isset($attribs["x"]) ? $attribs["x"] : 0;
                        $svgY = isset($attribs["y"]) ? $attribs["y"] : 0;
                        $svgW = isset($attribs["width"]) ? $attribs["width"] : 0;
                        $svgH = isset($attribs["height"]) ? $attribs["height"] : 0;
                        $tm = TCPDF_STATIC::getTransformationMatrixProduct($tm, [1, 0, 0, 1, $svgX, $svgY]);
                        $this->SVGTransform($tm);
                        $x = 0;
                        $y = 0;
                        $w = isset($attribs["width"]) ? $this->getHTMLUnitToUnits($attribs["width"], 0, $this->svgunit, false) : $this->w;
                        $h = isset($attribs["height"]) ? $this->getHTMLUnitToUnits($attribs["height"], 0, $this->svgunit, false) : $this->h;
                        $this->Rect($x, $y, $w, $h, "CNZ", [], []);
                        if(isset($attribs["viewBox"])) {
                            $tmp = [];
                            preg_match_all("/[0-9]+/", $attribs["viewBox"], $tmp);
                            $tmp = $tmp[0];
                            if(sizeof($tmp) == 4) {
                                list($vx, $vy, $vw, $vh) = $tmp;
                                $tmp = [];
                                $aspectX = "xMid";
                                $aspectY = "YMid";
                                $fit = "meet";
                                if(isset($attribs["preserveAspectRatio"])) {
                                    if($attribs["preserveAspectRatio"] == "none") {
                                        $fit = "none";
                                    } else {
                                        preg_match_all("/[a-zA-Z]+/", $attribs["preserveAspectRatio"], $tmp);
                                        $tmp = $tmp[0];
                                        if(sizeof($tmp) == 2 && strlen($tmp[0]) == 8 && in_array($tmp[1], ["meet", "slice", "none"])) {
                                            $aspectX = substr($tmp[0], 0, 4);
                                            $aspectY = substr($tmp[0], 4, 4);
                                            $fit = $tmp[1];
                                        }
                                    }
                                }
                                $wr = $svgW / $vw;
                                $hr = $svgH / $vh;
                                $ax = $ay = 0;
                                if($fit == "meet" && $hr < $wr || $fit == "slice" && $wr < $hr) {
                                    if($aspectX == "xMax") {
                                        $ax = $vw * $wr / $hr - $vw;
                                    }
                                    if($aspectX == "xMid") {
                                        $ax = ($vw * $wr / $hr - $vw) / 2;
                                    }
                                    $wr = $hr;
                                } elseif($fit == "meet" && $wr < $hr || $fit == "slice" && $hr < $wr) {
                                    if($aspectY == "YMax") {
                                        $ay = $vh * $hr / $wr - $vh;
                                    }
                                    if($aspectY == "YMid") {
                                        $ay = ($vh * $hr / $wr - $vh) / 2;
                                    }
                                    $hr = $wr;
                                }
                                $newtm = [$wr, 0, 0, $hr, $wr * ($ax - $vx) - $svgX, $hr * ($ay - $vy) - $svgY];
                                $tm = TCPDF_STATIC::getTransformationMatrixProduct($tm, $newtm);
                                $this->SVGTransform($tm);
                            }
                        }
                        $this->setSVGStyles($svgstyle, $prev_svgstyle);
                    }
                    break;
                case "g":
                    array_push($this->svgstyles, $svgstyle);
                    $this->StartTransform();
                    $x = isset($attribs["x"]) ? $attribs["x"] : 0;
                    $y = isset($attribs["y"]) ? $attribs["y"] : 0;
                    $w = 1;
                    $h = 1;
                    $tm = TCPDF_STATIC::getTransformationMatrixProduct($tm, [$w, 0, 0, $h, $x, $y]);
                    $this->SVGTransform($tm);
                    $this->setSVGStyles($svgstyle, $prev_svgstyle);
                    break;
                case "linearGradient":
                    if($this->pdfa_mode && $this->pdfa_version < 2) {
                    } else {
                        if(!isset($attribs["id"])) {
                            $attribs["id"] = "GR_" . (count($this->svggradients) + 1);
                        }
                        $this->svggradientid = $attribs["id"];
                        $this->svggradients[$this->svggradientid] = [];
                        $this->svggradients[$this->svggradientid]["type"] = 2;
                        $this->svggradients[$this->svggradientid]["stops"] = [];
                        if(isset($attribs["gradientUnits"])) {
                            $this->svggradients[$this->svggradientid]["gradientUnits"] = $attribs["gradientUnits"];
                        } else {
                            $this->svggradients[$this->svggradientid]["gradientUnits"] = "objectBoundingBox";
                        }
                        if(!isset($attribs["x1"]) && !isset($attribs["y1"]) && !isset($attribs["x2"]) && !isset($attribs["y2"]) || isset($attribs["x1"]) && substr($attribs["x1"], -1) == "%" || isset($attribs["y1"]) && substr($attribs["y1"], -1) == "%" || isset($attribs["x2"]) && substr($attribs["x2"], -1) == "%" || isset($attribs["y2"]) && substr($attribs["y2"], -1) == "%") {
                            $this->svggradients[$this->svggradientid]["mode"] = "percentage";
                        } else {
                            $this->svggradients[$this->svggradientid]["mode"] = "measure";
                        }
                        $x1 = isset($attribs["x1"]) ? $attribs["x1"] : "0";
                        $y1 = isset($attribs["y1"]) ? $attribs["y1"] : "0";
                        $x2 = isset($attribs["x2"]) ? $attribs["x2"] : "100";
                        $y2 = isset($attribs["y2"]) ? $attribs["y2"] : "0";
                        if(isset($attribs["gradientTransform"])) {
                            $this->svggradients[$this->svggradientid]["gradientTransform"] = TCPDF_STATIC::getSVGTransformMatrix($attribs["gradientTransform"]);
                        }
                        $this->svggradients[$this->svggradientid]["coords"] = [$x1, $y1, $x2, $y2];
                        if(isset($attribs["xlink:href"]) && !empty($attribs["xlink:href"])) {
                            $this->svggradients[$this->svggradientid]["xref"] = substr($attribs["xlink:href"], 1);
                        }
                    }
                    break;
                case "radialGradient":
                    if($this->pdfa_mode && $this->pdfa_version < 2) {
                    } else {
                        if(!isset($attribs["id"])) {
                            $attribs["id"] = "GR_" . (count($this->svggradients) + 1);
                        }
                        $this->svggradientid = $attribs["id"];
                        $this->svggradients[$this->svggradientid] = [];
                        $this->svggradients[$this->svggradientid]["type"] = 3;
                        $this->svggradients[$this->svggradientid]["stops"] = [];
                        if(isset($attribs["gradientUnits"])) {
                            $this->svggradients[$this->svggradientid]["gradientUnits"] = $attribs["gradientUnits"];
                        } else {
                            $this->svggradients[$this->svggradientid]["gradientUnits"] = "objectBoundingBox";
                        }
                        if(!isset($attribs["cx"]) && !isset($attribs["cy"]) || isset($attribs["cx"]) && substr($attribs["cx"], -1) == "%" || isset($attribs["cy"]) && substr($attribs["cy"], -1) == "%") {
                            $this->svggradients[$this->svggradientid]["mode"] = "percentage";
                        } elseif(isset($attribs["r"]) && is_numeric($attribs["r"]) && $attribs["r"] <= 1) {
                            $this->svggradients[$this->svggradientid]["mode"] = "ratio";
                        } else {
                            $this->svggradients[$this->svggradientid]["mode"] = "measure";
                        }
                        $cx = isset($attribs["cx"]) ? $attribs["cx"] : 0;
                        $cy = isset($attribs["cy"]) ? $attribs["cy"] : 0;
                        $fx = isset($attribs["fx"]) ? $attribs["fx"] : $cx;
                        $fy = isset($attribs["fy"]) ? $attribs["fy"] : $cy;
                        $r = isset($attribs["r"]) ? $attribs["r"] : 0;
                        if(isset($attribs["gradientTransform"])) {
                            $this->svggradients[$this->svggradientid]["gradientTransform"] = TCPDF_STATIC::getSVGTransformMatrix($attribs["gradientTransform"]);
                        }
                        $this->svggradients[$this->svggradientid]["coords"] = [$cx, $cy, $fx, $fy, $r];
                        if(isset($attribs["xlink:href"]) && !empty($attribs["xlink:href"])) {
                            $this->svggradients[$this->svggradientid]["xref"] = substr($attribs["xlink:href"], 1);
                        }
                    }
                    break;
                case "stop":
                    if(substr($attribs["offset"], -1) == "%") {
                        $offset = floatval(substr($attribs["offset"], 0, -1)) / 100;
                    } else {
                        $offset = floatval($attribs["offset"]);
                        if(1 < $offset) {
                            $offset /= 100;
                        }
                    }
                    $stop_color = isset($svgstyle["stop-color"]) ? TCPDF_COLORS::convertHTMLColorToDec($svgstyle["stop-color"], $this->spot_colors) : "black";
                    $opacity = isset($svgstyle["stop-opacity"]) ? $svgstyle["stop-opacity"] : 1;
                    $this->svggradients[$this->svggradientid]["stops"][] = ["offset" => $offset, "color" => $stop_color, "opacity" => $opacity];
                    break;
                case "path":
                    if($invisible) {
                    } elseif(isset($attribs["d"])) {
                        $d = trim($attribs["d"]);
                        if(!empty($d)) {
                            $x = isset($attribs["x"]) ? $attribs["x"] : 0;
                            $y = isset($attribs["y"]) ? $attribs["y"] : 0;
                            $w = isset($attribs["width"]) ? $attribs["width"] : 1;
                            $h = isset($attribs["height"]) ? $attribs["height"] : 1;
                            $tm = TCPDF_STATIC::getTransformationMatrixProduct($tm, [$w, 0, 0, $h, $x, $y]);
                            if($clipping) {
                                $this->SVGTransform($tm);
                                $this->SVGPath($d, "CNZ");
                            } else {
                                $this->StartTransform();
                                $this->SVGTransform($tm);
                                $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, $w, $h, "SVGPath", [$d, "CNZ"]);
                                if(!empty($obstyle)) {
                                    $this->SVGPath($d, $obstyle);
                                }
                                $this->StopTransform();
                            }
                        }
                    }
                    break;
                case "rect":
                    if($invisible) {
                    } else {
                        $x = isset($attribs["x"]) ? $this->getHTMLUnitToUnits($attribs["x"], 0, $this->svgunit, false) : 0;
                        $y = isset($attribs["y"]) ? $this->getHTMLUnitToUnits($attribs["y"], 0, $this->svgunit, false) : 0;
                        $w = isset($attribs["width"]) ? $this->getHTMLUnitToUnits($attribs["width"], 0, $this->svgunit, false) : 0;
                        $h = isset($attribs["height"]) ? $this->getHTMLUnitToUnits($attribs["height"], 0, $this->svgunit, false) : 0;
                        $rx = isset($attribs["rx"]) ? $this->getHTMLUnitToUnits($attribs["rx"], 0, $this->svgunit, false) : 0;
                        $ry = isset($attribs["ry"]) ? $this->getHTMLUnitToUnits($attribs["ry"], 0, $this->svgunit, false) : $rx;
                        if($clipping) {
                            $this->SVGTransform($tm);
                            $this->RoundedRectXY($x, $y, $w, $h, $rx, $ry, "1111", "CNZ", [], []);
                        } else {
                            $this->StartTransform();
                            $this->SVGTransform($tm);
                            $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, $w, $h, "RoundedRectXY", [$x, $y, $w, $h, $rx, $ry, "1111", "CNZ"]);
                            if(!empty($obstyle)) {
                                $this->RoundedRectXY($x, $y, $w, $h, $rx, $ry, "1111", $obstyle, [], []);
                            }
                            $this->StopTransform();
                        }
                    }
                    break;
                case "circle":
                    if($invisible) {
                    } else {
                        $r = isset($attribs["r"]) ? $this->getHTMLUnitToUnits($attribs["r"], 0, $this->svgunit, false) : 0;
                        $cx = isset($attribs["cx"]) ? $this->getHTMLUnitToUnits($attribs["cx"], 0, $this->svgunit, false) : (isset($attribs["x"]) ? $this->getHTMLUnitToUnits($attribs["x"], 0, $this->svgunit, false) : 0);
                        $cy = isset($attribs["cy"]) ? $this->getHTMLUnitToUnits($attribs["cy"], 0, $this->svgunit, false) : (isset($attribs["y"]) ? $this->getHTMLUnitToUnits($attribs["y"], 0, $this->svgunit, false) : 0);
                        $x = $cx - $r;
                        $y = $cy - $r;
                        $w = 2 * $r;
                        $h = $w;
                        if($clipping) {
                            $this->SVGTransform($tm);
                            $this->Circle($cx, $cy, $r, 0, 360, "CNZ", [], [], 8);
                        } else {
                            $this->StartTransform();
                            $this->SVGTransform($tm);
                            $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, $w, $h, "Circle", [$cx, $cy, $r, 0, 360, "CNZ"]);
                            if(!empty($obstyle)) {
                                $this->Circle($cx, $cy, $r, 0, 360, $obstyle, [], [], 8);
                            }
                            $this->StopTransform();
                        }
                    }
                    break;
                case "ellipse":
                    if($invisible) {
                    } else {
                        $rx = isset($attribs["rx"]) ? $this->getHTMLUnitToUnits($attribs["rx"], 0, $this->svgunit, false) : 0;
                        $ry = isset($attribs["ry"]) ? $this->getHTMLUnitToUnits($attribs["ry"], 0, $this->svgunit, false) : 0;
                        $cx = isset($attribs["cx"]) ? $this->getHTMLUnitToUnits($attribs["cx"], 0, $this->svgunit, false) : (isset($attribs["x"]) ? $this->getHTMLUnitToUnits($attribs["x"], 0, $this->svgunit, false) : 0);
                        $cy = isset($attribs["cy"]) ? $this->getHTMLUnitToUnits($attribs["cy"], 0, $this->svgunit, false) : (isset($attribs["y"]) ? $this->getHTMLUnitToUnits($attribs["y"], 0, $this->svgunit, false) : 0);
                        $x = $cx - $rx;
                        $y = $cy - $ry;
                        $w = 2 * $rx;
                        $h = 2 * $ry;
                        if($clipping) {
                            $this->SVGTransform($tm);
                            $this->Ellipse($cx, $cy, $rx, $ry, 0, 0, 360, "CNZ", [], [], 8);
                        } else {
                            $this->StartTransform();
                            $this->SVGTransform($tm);
                            $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, $w, $h, "Ellipse", [$cx, $cy, $rx, $ry, 0, 0, 360, "CNZ"]);
                            if(!empty($obstyle)) {
                                $this->Ellipse($cx, $cy, $rx, $ry, 0, 0, 360, $obstyle, [], [], 8);
                            }
                            $this->StopTransform();
                        }
                    }
                    break;
                case "line":
                    if($invisible) {
                    } else {
                        $x1 = isset($attribs["x1"]) ? $this->getHTMLUnitToUnits($attribs["x1"], 0, $this->svgunit, false) : 0;
                        $y1 = isset($attribs["y1"]) ? $this->getHTMLUnitToUnits($attribs["y1"], 0, $this->svgunit, false) : 0;
                        $x2 = isset($attribs["x2"]) ? $this->getHTMLUnitToUnits($attribs["x2"], 0, $this->svgunit, false) : 0;
                        $y2 = isset($attribs["y2"]) ? $this->getHTMLUnitToUnits($attribs["y2"], 0, $this->svgunit, false) : 0;
                        $x = $x1;
                        $y = $y1;
                        $w = abs($x2 - $x1);
                        $h = abs($y2 - $y1);
                        if(!$clipping) {
                            $this->StartTransform();
                            $this->SVGTransform($tm);
                            $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, $w, $h, "Line", [$x1, $y1, $x2, $y2]);
                            $this->Line($x1, $y1, $x2, $y2);
                            $this->StopTransform();
                        }
                    }
                    break;
                case "polyline":
                case "polygon":
                    if($invisible) {
                    } else {
                        $points = isset($attribs["points"]) ? $attribs["points"] : "0 0";
                        $points = trim($points);
                        $points = preg_split("/[\\,\\s]+/si", $points);
                        if(count($points) < 4) {
                        } else {
                            $p = [];
                            $xmin = -2147483649.0;
                            $xmax = 0;
                            $ymin = -2147483649.0;
                            $ymax = 0;
                            foreach ($points as $key => $val) {
                                $p[$key] = $this->getHTMLUnitToUnits($val, 0, $this->svgunit, false);
                                if($key % 2 == 0) {
                                    $xmin = min($xmin, $p[$key]);
                                    $xmax = max($xmax, $p[$key]);
                                } else {
                                    $ymin = min($ymin, $p[$key]);
                                    $ymax = max($ymax, $p[$key]);
                                }
                            }
                            $x = $xmin;
                            $y = $ymin;
                            $w = $xmax - $xmin;
                            $h = $ymax - $ymin;
                            if($name == "polyline") {
                                $this->StartTransform();
                                $this->SVGTransform($tm);
                                $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, $w, $h, "PolyLine", [$p, "CNZ"]);
                                if(!empty($obstyle)) {
                                    $this->PolyLine($p, $obstyle, [], []);
                                }
                                $this->StopTransform();
                            } elseif($clipping) {
                                $this->SVGTransform($tm);
                                $this->Polygon($p, "CNZ", [], [], true);
                            } else {
                                $this->StartTransform();
                                $this->SVGTransform($tm);
                                $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, $w, $h, "Polygon", [$p, "CNZ"]);
                                if(!empty($obstyle)) {
                                    $this->Polygon($p, $obstyle, [], [], true);
                                }
                                $this->StopTransform();
                            }
                        }
                    }
                    break;
                case "image":
                    if($invisible) {
                    } elseif(!isset($attribs["xlink:href"]) || empty($attribs["xlink:href"])) {
                    } else {
                        $x = isset($attribs["x"]) ? $this->getHTMLUnitToUnits($attribs["x"], 0, $this->svgunit, false) : 0;
                        $y = isset($attribs["y"]) ? $this->getHTMLUnitToUnits($attribs["y"], 0, $this->svgunit, false) : 0;
                        $w = isset($attribs["width"]) ? $this->getHTMLUnitToUnits($attribs["width"], 0, $this->svgunit, false) : 0;
                        $h = isset($attribs["height"]) ? $this->getHTMLUnitToUnits($attribs["height"], 0, $this->svgunit, false) : 0;
                        $img = $attribs["xlink:href"];
                        if(!$clipping) {
                            $this->StartTransform();
                            $this->SVGTransform($tm);
                            $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, $w, $h);
                            if(0 < preg_match("/^data:image\\/[^;]+;base64,/", $img, $m)) {
                                $img = "@" . base64_decode(substr($img, strlen($m[0])));
                            } else {
                                if(!TCPDF_STATIC::empty_string($this->svgdir) && ($img[0] == "." || basename($img) == $img)) {
                                    $img = $this->svgdir . "/" . $img;
                                }
                                if($img[0] == "/" && !empty($_SERVER["DOCUMENT_ROOT"]) && $_SERVER["DOCUMENT_ROOT"] != "/") {
                                    $findroot = strpos($img, $_SERVER["DOCUMENT_ROOT"]);
                                    if($findroot === false || 1 < $findroot) {
                                        if(substr($_SERVER["DOCUMENT_ROOT"], -1) == "/") {
                                            $img = substr($_SERVER["DOCUMENT_ROOT"], 0, -1) . $img;
                                        } else {
                                            $img = $_SERVER["DOCUMENT_ROOT"] . $img;
                                        }
                                    }
                                }
                                $img = urldecode($img);
                                $testscrtype = @parse_url($img);
                                if(empty($testscrtype["query"])) {
                                    $img = str_replace(K_PATH_URL, K_PATH_MAIN, $img);
                                } elseif(preg_match("|^https?://|", $img) !== 1) {
                                    $img = str_replace(K_PATH_MAIN, K_PATH_URL, $img);
                                }
                            }
                            $imgtype = TCPDF_IMAGES::getImageFileType($img);
                            if($imgtype == "eps" || $imgtype == "ai") {
                                $this->ImageEps($img, $x, $y, $w, $h);
                            } elseif($imgtype == "svg") {
                                $svggradients = $this->svggradients;
                                $svggradientid = $this->svggradientid;
                                $svgdefsmode = $this->svgdefsmode;
                                $svgdefs = $this->svgdefs;
                                $svgclipmode = $this->svgclipmode;
                                $svgclippaths = $this->svgclippaths;
                                $svgcliptm = $this->svgcliptm;
                                $svgclipid = $this->svgclipid;
                                $svgtext = $this->svgtext;
                                $svgtextmode = $this->svgtextmode;
                                $this->ImageSVG($img, $x, $y, $w, $h);
                                $this->svggradients = $svggradients;
                                $this->svggradientid = $svggradientid;
                                $this->svgdefsmode = $svgdefsmode;
                                $this->svgdefs = $svgdefs;
                                $this->svgclipmode = $svgclipmode;
                                $this->svgclippaths = $svgclippaths;
                                $this->svgcliptm = $svgcliptm;
                                $this->svgclipid = $svgclipid;
                                $this->svgtext = $svgtext;
                                $this->svgtextmode = $svgtextmode;
                            } else {
                                $this->Image($img, $x, $y, $w, $h);
                            }
                            $this->StopTransform();
                        }
                    }
                    break;
                case "text":
                case "tspan":
                    if(isset($this->svgtextmode["text-anchor"]) && !empty($this->svgtext)) {
                    }
                    $this->svgtextmode["invisible"] = $invisible;
                    if($invisible) {
                    } else {
                        array_push($this->svgstyles, $svgstyle);
                        if(isset($attribs["x"])) {
                            $x = $this->getHTMLUnitToUnits($attribs["x"], 0, $this->svgunit, false);
                        } elseif($name == "tspan") {
                            $x = $this->x;
                        } else {
                            $x = 0;
                        }
                        if(isset($attribs["dx"])) {
                            $x += $this->getHTMLUnitToUnits($attribs["dx"], 0, $this->svgunit, false);
                        }
                        if(isset($attribs["y"])) {
                            $y = $this->getHTMLUnitToUnits($attribs["y"], 0, $this->svgunit, false);
                        } elseif($name == "tspan") {
                            $y = $this->y;
                        } else {
                            $y = 0;
                        }
                        if(isset($attribs["dy"])) {
                            $y += $this->getHTMLUnitToUnits($attribs["dy"], 0, $this->svgunit, false);
                        }
                        $svgstyle["text-color"] = $svgstyle["fill"];
                        $this->svgtext = "";
                        if(isset($svgstyle["text-anchor"])) {
                            $this->svgtextmode["text-anchor"] = $svgstyle["text-anchor"];
                        } else {
                            $this->svgtextmode["text-anchor"] = "start";
                        }
                        if(isset($svgstyle["direction"])) {
                            if($svgstyle["direction"] == "rtl") {
                                $this->svgtextmode["rtl"] = true;
                            } else {
                                $this->svgtextmode["rtl"] = false;
                            }
                        } else {
                            $this->svgtextmode["rtl"] = false;
                        }
                        if(isset($svgstyle["stroke"]) && $svgstyle["stroke"] != "none" && isset($svgstyle["stroke-width"]) && 0 < $svgstyle["stroke-width"]) {
                            $this->svgtextmode["stroke"] = $this->getHTMLUnitToUnits($svgstyle["stroke-width"], 0, $this->svgunit, false);
                        } else {
                            $this->svgtextmode["stroke"] = false;
                        }
                        $this->StartTransform();
                        $this->SVGTransform($tm);
                        $obstyle = $this->setSVGStyles($svgstyle, $prev_svgstyle, $x, $y, 1, 1);
                        $this->x = $x;
                        $this->y = $y;
                    }
                    break;
                case "use":
                    if(isset($attribs["xlink:href"]) && !empty($attribs["xlink:href"])) {
                        $svgdefid = substr($attribs["xlink:href"], 1);
                        if(isset($this->svgdefs[$svgdefid])) {
                            $use = $this->svgdefs[$svgdefid];
                            if(isset($attribs["xlink:href"])) {
                                unset($attribs["xlink:href"]);
                            }
                            if(isset($attribs["id"])) {
                                unset($attribs["id"]);
                            }
                            if(isset($use["attribs"]["x"]) && isset($attribs["x"])) {
                                $attribs["x"] += $use["attribs"]["x"];
                            }
                            if(isset($use["attribs"]["y"]) && isset($attribs["y"])) {
                                $attribs["y"] += $use["attribs"]["y"];
                            }
                            if(empty($attribs["style"])) {
                                $attribs["style"] = "";
                            }
                            if(!empty($use["attribs"]["style"])) {
                                $attribs["style"] = str_replace(";;", ";", ";" . $use["attribs"]["style"] . $attribs["style"]);
                            }
                            $attribs = array_merge($use["attribs"], $attribs);
                            $this->startSVGElementHandler($parser, $use["name"], $attribs);
                            return NULL;
                        }
                    }
                    break;
                default:
                    if(!empty($attribs["child_elements"])) {
                        $child_elements = $attribs["child_elements"];
                        unset($attribs["child_elements"]);
                        foreach ($child_elements as $child_element) {
                            if(empty($child_element["attribs"]["closing_tag"])) {
                                $this->startSVGElementHandler("child-tag", $child_element["name"], $child_element["attribs"]);
                            } else {
                                if(isset($child_element["attribs"]["content"])) {
                                    $this->svgtext = $child_element["attribs"]["content"];
                                }
                                $this->endSVGElementHandler("child-tag", $child_element["name"]);
                            }
                        }
                    }
            }
        }
    }
    protected function endSVGElementHandler($parser, $name)
    {
        $name = $this->removeTagNamespace($name);
        if($this->svgdefsmode && !in_array($name, ["defs", "clipPath", "linearGradient", "radialGradient", "stop"])) {
            if(end($this->svgdefs) !== false) {
                $last_svgdefs_id = key($this->svgdefs);
                if(isset($this->svgdefs[$last_svgdefs_id]["attribs"]["child_elements"])) {
                    foreach ($this->svgdefs[$last_svgdefs_id]["attribs"]["child_elements"] as $child_element) {
                        if(isset($child_element["attribs"]["id"]) && $child_element["name"] == $name) {
                            $this->svgdefs[$last_svgdefs_id]["attribs"]["child_elements"][$child_element["attribs"]["id"] . "_CLOSE"] = ["name" => $name, "attribs" => ["closing_tag" => true, "content" => $this->svgtext]];
                            return NULL;
                        }
                    }
                    if($this->svgdefs[$last_svgdefs_id]["name"] == $name) {
                        $this->svgdefs[$last_svgdefs_id]["attribs"]["child_elements"][$last_svgdefs_id . "_CLOSE"] = ["name" => $name, "attribs" => ["closing_tag" => true, "content" => $this->svgtext]];
                        return NULL;
                    }
                }
            }
        } else {
            switch ($name) {
                case "defs":
                    $this->svgdefsmode = false;
                    break;
                case "clipPath":
                    $this->svgclipmode = false;
                    break;
                case "svg":
                    if(--$this->svg_tag_depth <= 0) {
                    }
                    break;
                case "g":
                    array_pop($this->svgstyles);
                    $this->StopTransform();
                    break;
                case "text":
                case "tspan":
                    if($this->svgtextmode["invisible"]) {
                    } else {
                        $text = $this->svgtext;
                        $textlen = $this->GetStringWidth($text);
                        if($this->svgtextmode["text-anchor"] != "start") {
                            if($this->svgtextmode["text-anchor"] == "end") {
                                if($this->svgtextmode["rtl"]) {
                                    $this->x += $textlen;
                                } else {
                                    $this->x -= $textlen;
                                }
                            } elseif($this->svgtextmode["text-anchor"] == "middle") {
                                if($this->svgtextmode["rtl"]) {
                                    $this->x += $textlen / 2;
                                } else {
                                    $this->x -= $textlen / 2;
                                }
                            }
                        }
                        $textrendermode = $this->textrendermode;
                        $textstrokewidth = $this->textstrokewidth;
                        $this->setTextRenderingMode($this->svgtextmode["stroke"], true, false);
                        if($name == "text") {
                            $tmpx = $this->x;
                            $tmpy = $this->y;
                        }
                        $this->Cell($textlen, 0, $text, 0, 0, "", false, "", 0, false, "L", "T");
                        if($name == "text") {
                            $this->x = $tmpx;
                            $this->y = $tmpy;
                        }
                        $this->textrendermode = $textrendermode;
                        $this->textstrokewidth = $textstrokewidth;
                        $this->svgtext = "";
                        $this->StopTransform();
                        if(!$this->svgdefsmode) {
                            array_pop($this->svgstyles);
                        }
                    }
                    break;
            }
        }
    }
    protected function segSVGContentHandler($parser, $data)
    {
        $this->svgtext .= $data;
    }
    protected function getCachedFileContents($file)
    {
        if(!isset($this->fileContentCache[$file])) {
            $this->fileContentCache[$file] = TCPDF_STATIC::fileGetContents($file);
        }
        return $this->fileContentCache[$file];
    }
    protected function fileExists($file)
    {
        if(isset($this->fileContentCache[$file]) || false !== $this->getImageBuffer($file)) {
            return true;
        }
        return TCPDF_STATIC::file_exists($file);
    }
}

?>