<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function tasks()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $cluster;
    global $error;
    global $servers;
    global $servers_keypass;
    global $saved;
    global $servergroups;
    global $list;
    global $done;
    global $migrate_status;
    global $cpu;
    global $progress;
    global $migrate_done;
    global $migrate_run;
    global $mprog;
    global $ostemplates;
    global $tasks;
    global $logs_data;
    global $sort_column;
    global $sort_column_by;
    if(!load_lang("admin/tasks")) {
        return false;
    }
    $theme["init_theme"] = "admin/tasks";
    $theme["init_theme_name"] = "Tasks List";
    $theme["init_theme_func"] = ["tasks_theme"];
    $theme["call_theme_func"] = "tasks_theme";
    $servergroups = server_groups();
    oslist();
    $no_logs = ["editxcpvs", "bandwidth_unsuspend", "suspend_callback", "unsuspend_callback", "editvps_callback", "terminate_callback", "exportascsv"];
    $show_logs = (int) optREQ("show_logs");
    if(!empty($show_logs)) {
        $res = makequery("SELECT * FROM tasks WHERE actid = :actid", [":actid" => $show_logs]);
        $logs_data = [];
        if(vsql_num_rows($res) < 1) {
            $logs_data["logs"] = $l["no_logs"];
            return false;
        }
        $task = vsql_fetch_assoc($res);
        $task_data = _unserialize($task["data"]);
        $master_logs = ["addvs", "addvs_restore", "rebuildvs", "multimigrateprog", "multicloneprog", "deletevs", "getos", "addiso", "enable_rescuevs", "disable_rescuevs", "install_script", "sync_media", "multi_deletevs", "start_vps"];
        $slave_logs = ["vpsbackups", "restorevps", "migrate2", "clone2", "createtemplate", "multivirt", "multivirt_install", "get_crt", "renew_crt", "cron_crt", "start_vps", "stop_vps", "poweroff_vps", "haproxy_cron", "vpsbackups_plan", "restorevps_plan", "backuply_vpsbackups_plan", "backuply_restorevps_plan", "dbbackups", "install_script", "migrate_disk2", "installha"];
        if(!empty($task["logs"])) {
            $logs_data["logs"] = $task["logs"];
            return true;
        }
        if(empty($task["action"]) || in_array($task["action"], $no_logs)) {
            $logs_data["logs"] = $l["no_logs"];
            return false;
        }
        if(in_array($task["action"], $master_logs) && !is_slave() && empty($task["logs"])) {
            if($task["action"] == "addvs") {
                $paths["Addvs"] = logdir("addvs") . $task["vpsid"] . ".log";
            } elseif($task["action"] == "addvs_restore") {
                $paths["Addvs_Restore"] = logdir("addvs") . $task["vpsid"] . ".log";
            } elseif($task["action"] == "rebuildvs") {
                $paths["Rebuild"] = logdir("rebuild") . $task["vpsid"] . ".log";
            } elseif($task["action"] == "multimigrateprog") {
                $paths["Multimigrate"] = logdir("migrate") . $task["actid"] . "-multi_migrate.log";
            } elseif($task["action"] == "multicloneprog") {
                $paths["Multiclone"] = logdir("clone") . $task["actid"] . "-multi_clone.log";
            } elseif($task["action"] == "getos") {
                $paths["Download_OS"] = logdir() . "os.log";
            } elseif($task["action"] == "addiso") {
                $paths["Download_ISO"] = logdir() . "download_iso.log";
            } elseif($task["action"] == "deletevs") {
                $paths["Deletevs"] = logdir("deletevs") . $task["vpsid"] . ".log";
            } elseif($task["action"] == "enable_rescuevs") {
                $paths["Enable_Rescue"] = logdir("enable_rescuevs") . $task["vpsid"] . ".log";
            } elseif($task["action"] == "disable_rescuevs") {
                $paths["Disable_Rescue"] = logdir("disable_rescuevs") . $task["vpsid"] . ".log";
            } elseif($task["action"] == "install_script") {
                $paths["Install_script"] = logdir("install_script") . $task["vpsid"] . ".log";
            } elseif($task["action"] == "sync_media") {
                $paths["sync_media"] = logdir() . "sync_media.log";
            } elseif($task["action"] == "multi_deletevs") {
                $paths["multi_deletevs"] = logdir() . "multi_deletevs.log";
            }
            $logs = $cluster->get_logs(0, $paths);
            if(empty($logs)) {
                $logs_data["logs"] = $l["no_logs"];
            } else {
                $logs_data["logs"] = $logs;
            }
            return true;
        }
        if($task["action"] == "migrate2" || $task["action"] == "clone2" || $task["action"] == "migrate_disk2") {
            $my_act = substr($task["action"], 0, -1);
            if(!is_slave()) {
                $mpaths["Master"] = logdir($my_act) . $task_data["orig_vpsid"] . "-master.log";
                $mlogs = $cluster->get_logs(0, $mpaths);
                if(!is_array($mlogs)) {
                    $mlogs = [];
                }
            }
            $paths["Source"] = logdir($my_act) . $task_data["vpsid"] . "-source.log";
            $paths["Transfer_logs"] = logdir($my_act) . $task_data["vpsid"] . "-transfer.log";
            $slogs = $cluster->get_logs($task_data["from_server"], $paths);
            if(!is_array($slogs)) {
                $slogs = [];
            }
            $logs = array_merge($mlogs, $slogs);
            if(empty($logs)) {
                $logs_data["logs"] = $l["no_logs"];
            } else {
                $logs_data["logs"] = $logs;
            }
            return true;
        }
        if($task["action"] == "installha") {
            if(!is_slave()) {
                $mpaths["Master"] = logdir() . $task["action"] . "_master.log";
                $mlogs = $cluster->get_logs(0, $mpaths);
                if(!is_array($mlogs)) {
                    $mlogs = [];
                }
            }
            $paths["Slave"] = logdir() . $task["action"] . ".log";
            $slogs = $cluster->get_logs($task["serid"], $paths);
            if(!is_array($slogs)) {
                $slogs = [];
            }
            $logs = array_merge($mlogs, $slogs);
            if(empty($logs)) {
                $logs_data["logs"] = $l["no_logs"];
            } else {
                $logs_data["logs"] = $logs;
            }
            return true;
        }
        if(in_array($task["action"], $slave_logs)) {
            if($task["action"] == "vpsbackups") {
                $paths["Backup_logs"] = logdir() . "virtualizor-backups.log";
                $paths["Debug_logs"] = logdir() . "vpsbackups.log";
            }
            if($task["action"] == "restorevps") {
                $paths["Restore_logs"] = logdir() . "virtualizor-backups.log";
            }
            if($task["action"] == "createtemplate") {
                $paths["Createtemplate"] = logdir() . "createtemplate.log";
            }
            if($task["action"] == "multivirt") {
                $paths["Multivirt"] = logdir() . "multivirt";
                $paths["Multivirt_install_logs"] = logdir() . "multivirt_install";
            }
            if(preg_match("/crt/", $task["action"])) {
                $paths["Letsenrypt_logs"] = logdir() . "letsencrypt.log";
            }
            if($task["action"] == "haproxy_cron") {
                $paths["Haproxy_logs"] = logdir("haproxy") . "haproxy.log";
            }
            if($task["action"] == "start_vps" || $task["action"] == "stop_vps" || $task["action"] == "poweroff_vps") {
                $logaction = explode("_", $task["action"]);
                $paths[$logaction[0] . "_logs"] = logdir($logaction[0]) . $task["vpsid"] . ".log";
                $vps = getvps($task["vpsid"]);
                $task["serid"] = $vps["serid"];
            }
            if($task["action"] == "vpsbackups_plan") {
                $paths["Backup_logs"] = logdir("backup") . $task["vpsid"] . ".log";
            }
            if($task["action"] == "restorevps_plan") {
                $paths["Restore_logs"] = logdir("restore") . $task["vpsid"] . ".log";
            }
            if($task["action"] == "dbbackups") {
                $paths["DBBackup_logs"] = logdir() . "virtualizor-dbbackup.log";
            }
            if($task["action"] == "install_script") {
                $paths["Install_Script"] = logdir("install_script") . $task["vpsid"] . ".log";
            }
            if($task["action"] == "installha") {
                $paths["InstallHA_logs"] = logdir() . "installha";
            }
            $logs = $cluster->get_logs($task["serid"], $paths);
            if(empty($logs)) {
                $logs_data["logs"] = $l["no_logs"];
            } else {
                $logs_data["logs"] = $logs;
            }
            $logs_data["common_logs"] = $l["common_logs"];
            return true;
        }
        if(empty($logs_data)) {
            $logs_data["logs"] = $l["no_logs"];
        }
        return true;
    }
    $actids = optREQ("actid");
    $tokens = [];
    if(!empty($actids)) {
        $actids = cexplode(",", $actids, 1);
        $where["actid"] = "t.actid IN ('" . implode("','", $actids) . "')";
    }
    $action = optREQ("action");
    if(!empty($action)) {
        $action = cexplode(",", $action);
        $ptoks = vsql_in_tokens($action, "a");
        $tokens = array_merge($tokens, $ptoks["tokens"]);
        $where["action"] = "t.action IN ('-1', " . $ptoks["query"] . ")";
    }
    $status = (int) optREQ("status");
    if(!empty($status)) {
        if($status == 1) {
            $where["status"] = "status = 1 AND (t.updated > \n\t\t\t" . (time() - $globals["notupdated_task"]) . " \n\t\t\tOR t.started > " . (time() - $globals["notupdated_task"]) . ") AND t.ended <= 0";
        }
        if($status == 2) {
            $where["status"] = "t.progress = 100 AND ended > 0";
        }
        if($status == 3) {
            $where["status"] = "t.updated < " . (time() - $globals["notupdated_task"]) . " AND t.started < " . (time() - $globals["notupdated_task"]) . " AND ended = 0";
        }
        if($status == -1) {
            $where["status"] = "t.status = " . $status;
        }
    }
    $vpsid = optREQ("vpsid");
    if(!empty($vpsid)) {
        $vpsid = cexplode(",", $vpsid, 1, 1);
        $where["vpsid"] = "t.vpsid IN ('-1', '" . implode("', '", $vpsid) . "')";
    }
    $username = optREQ("username");
    if(!empty($username)) {
        if($username == "root") {
            $uids[] = 0;
        } else {
            $res = makequery("SELECT uid FROM users WHERE email LIKE :email", [":email" => wildsearch($username)]);
            if(0 < vsql_num_rows($res)) {
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $uids[] = $row["uid"];
                }
            } else {
                $uids[] = -1;
            }
        }
        $where["uids"] = "t.uid in (" . implode(",", $uids) . ")";
    }
    $server = $_GET["server"];
    if(isset($server) && -1 < $server) {
        $where["serid"] = "t.serid = " . (int) $server;
    }
    $show_top_ten = optREQ("show_top_ten");
    if(!empty($show_top_ten)) {
        $where[] = "started > 0 AND\n\t\t\t\tended = 0 AND \n\t\t\t\tprogress < 100 AND \n\t\t\t\tstatus_txt IS NOT NULL";
    }
    $where[] = " action NOT IN ('vpsbackups_plan_email', 'send_background_mail', 'backuply_vpsbackups_plan_email')";
    $res = makequery("SELECT COUNT(t.actid) AS num FROM `tasks` t\n\t\t\t\t\t " . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)), $tokens);
    $tmp = vsql_fetch_assoc($res);
    $sort_column_arr = ["actid" => "actid", "vpsid" => "vpsid", "started" => "started", "updated" => "updated", "ended" => "ended", "server" => "serid", "status" => "status"];
    $sort_column_by_arr = ["asc" => "ASC", "desc" => "DESC"];
    if(optREQ("sortcolumn") == "") {
        $sort_column = "actid";
        $sort_column_by = "desc";
    } else {
        $sort_column = strtolower(optREQ("sortcolumn"));
        $sort_column_by = strtolower(optREQ("sortby"));
        $sort_column_by = array_key_exists($sort_column_by, $sort_column_by_arr) ? $sort_column_by : "asc";
    }
    $globals["cur_page"] = get_page();
    $globals["reslen"] = (int) optREQ("reslen");
    $globals["reslen"] = $globals["reslen"] <= 0 ? 50 : $globals["reslen"];
    $globals["num_res"] = $tmp["num"];
    if(!empty($show_top_ten)) {
        $globals["cur_page"] = 0;
        $globals["reslen"] = 10;
    }
    $res = makequery("SELECT t.*, u.email FROM tasks t\n\t\t\t\t\tLEFT JOIN users u on (u.uid = t.uid)\n\t\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)) . "\n\t\t\t\t\tORDER BY " . (empty($sort_column_arr[$sort_column]) ? "t.actid" : "t." . $sort_column_arr[$sort_column] . " " . $sort_column_by_arr[$sort_column_by]) . "\n\t\t\t\t\tLIMIT " . $globals["cur_page"] . ", " . $globals["reslen"], $tokens);
    if(0 < vsql_num_rows($res)) {
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $serverid = -1;
            $row = vsql_fetch_assoc($res);
            $tasks[$row["actid"]] = $row;
            $data = _unserialize($tasks[$row["actid"]]["data"]);
            if(empty($globals["slave"]) && $tasks[$row["actid"]]["action"] == "migratedest") {
                unset($tasks[$row["actid"]]);
            } else {
                if(empty($tasks[$row["actid"]]["email"])) {
                    $tasks[$row["actid"]]["email"] = "root";
                }
                if($tasks[$row["actid"]]["action"] == "changepassword") {
                    unset($tasks[$row["actid"]]["data"]);
                }
                if($tasks[$row["actid"]]["action"] == "getos") {
                    $tasks[$row["actid"]]["os"] = $data["os"];
                    foreach ($tasks[$row["actid"]]["os"] as $k => $v) {
                        if(!empty($tasks[$row["actid"]]["os"][$k]["inprogress"])) {
                            $virt = $ostemplates[$v["osid"]]["type"];
                            $size = (double) @vfilesize($globals[$virt . "os"] . "/" . $ostemplates[$v["osid"]]["filename"]);
                            $fsize = $ostemplates[$v["osid"]]["size"];
                            $progress = @round($size / $fsize * 100);
                            $tasks[$row["actid"]]["os"][$k]["progress"] = $progress;
                        }
                    }
                }
                if($tasks[$row["actid"]]["action"] == "migrateprog" || $tasks[$row["actid"]]["action"] == "migratedest") {
                    $tasks[$row["actid"]]["status_txt"] = $l["migrate_speed"] . $data["speed"] . " MB/s";
                    $tasks[$row["actid"]]["progress"] = $data["percent"];
                    $serverid = $data["from_server"];
                    unset($data["from_pass"]);
                }
                $tmp_status_txt = [];
                if($tasks[$row["actid"]]["action"] == "migrate2" || $tasks[$row["actid"]]["action"] == "multimigrateprog" || $tasks[$row["actid"]]["action"] == "clone2" || $tasks[$row["actid"]]["action"] == "multicloneprog" || $tasks[$row["actid"]]["action"] == "migrate_disk2") {
                    if(!isset($data["speed"]) || !preg_match("/m\\/s/is", $data["speed"])) {
                        $tmp_status_txt[$l["speed"]] = $l["preparing"];
                    } else {
                        $tmp_status_txt[$l["speed"]] = $data["speed"];
                    }
                    if($tasks[$row["actid"]]["action"] == "migrate2" || $tasks[$row["actid"]]["action"] == "clone2" || $tasks[$row["actid"]]["action"] == "migrate_disk2") {
                        $tmp_status_txt[$l["transferred"]] = (empty($data["data_transferred"]) ? "--|--" : $data["data_transferred"]) . " MB";
                        $tmp_status_txt[$l["eta"]] = empty($data["eta"]) ? "--:--" : $data["eta"];
                    }
                    $tmp_status_txt[$l["progress"]] = (empty($data["percent"]) ? $tasks[$row["actid"]]["progress"] : $data["percent"]) . " %";
                    if(isset($tasks[$row["actid"]]["status"]) && isset($data["percent"]) && ($tasks[$row["actid"]]["status"] == -1 || 90 <= $data["percent"])) {
                        $tmp_status_txt = $tasks[$row["actid"]]["status_txt"];
                    } else {
                        $tmp_status_txt = json_encode($tmp_status_txt);
                    }
                    $tasks[$row["actid"]]["status_txt"] = $tmp_status_txt;
                    unset($data["from_pass"]);
                }
                if($tasks[$row["actid"]]["action"] == "addvs" || $tasks[$row["actid"]]["action"] == "addvs_restore") {
                    $serverid = $data["serid"];
                    unset($data["newvs"]["pass"]);
                    unset($data["newvs"]["vncpass"]);
                }
                if($tasks[$row["actid"]]["action"] == "rebuildvs") {
                    $serverid = $data["vps"]["serid"];
                }
                if($tasks[$row["actid"]]["action"] == "deletevs") {
                    $serverid = $data["serid"];
                }
                $tasks[$row["actid"]]["data"] = @serialize($data);
                $serverid = $serverid < 0 ? $tasks[$row["actid"]]["serid"] : $serverid;
                $_task_server = $servers[$serverid];
                $tasks[$row["actid"]]["server_name"] = $_task_server["server_name"];
                $tasks[$row["actid"]]["serid"] = $_task_server["serid"];
                $tasks[$row["actid"]]["not_updated"] = 0;
                if($tasks[$row["actid"]]["ended"] == 0 && $tasks[$row["actid"]]["started"] != 0 && $tasks[$row["actid"]]["started"] < time() - $globals["notupdated_task"] && $tasks[$row["actid"]]["updated"] < time() - $globals["notupdated_task"]) {
                    $tasks[$row["actid"]]["status_txt"] = $l["task_notupdated_status"];
                    $tasks[$row["actid"]]["progress"] = $l["task_notupdated"];
                    $tasks[$row["actid"]]["not_updated"] = 1;
                }
                $tasks[$row["actid"]]["started"] = empty($tasks[$row["actid"]]["started"]) ? $l["not_started"] : datify($tasks[$row["actid"]]["started"]);
                $tasks[$row["actid"]]["updated"] = empty($tasks[$row["actid"]]["updated"]) ? $l["not_updated"] : datify($tasks[$row["actid"]]["updated"]);
                $tasks[$row["actid"]]["ended"] = empty($tasks[$row["actid"]]["ended"]) ? $l["not_ended"] : datify($tasks[$row["actid"]]["ended"]);
                $tasks[$row["actid"]]["action_txt"] = $l[$row["action"]];
                if(!empty($show_top_ten) && !empty($tasks[$row["actid"]]["not_updated"])) {
                    unset($tasks[$row["actid"]]);
                }
            }
        }
        $show_task_count = optREQ("show_task_count");
        if(!empty($show_task_count) && isset($row) && empty($tasks[$row["actid"]]["not_updated"])) {
            $tasks_count = count($tasks);
            $tasks = [];
            $tasks["count"] = $tasks_count;
        }
    }
    return true;
}
function API_tasks()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $tasks;
    global $logs_data;
    $GLOBALS["_api"]["tasks"] = $tasks;
    $GLOBALS["_api"]["logs_data"] = $logs_data;
    $GLOBALS["_api"]["l_common_logs"] = $l["common_logs"];
}

?>