<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function server_stats_theme()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $server_stats;
    global $month;
    global $servers;
    softheader($l["<title>"]);
    $monthly_data = json_encode($server_stats);
    $month = json_encode($month);
    echo "<style>\n.tickLabel{\nwidth:30px !important;\n}\n</style>\n<script language=\"javascript\" type=\"text/javascript\"><!-- // --><![CDATA[\n\nfunction graph_display(id){\n\n\tvar res= id.split(\"_\");\n\n\tif(\$('#'+res[1]+'_body').is(':visible')){\n\n\t\t\$('#'+res[1]+'_sign').html('+');\n\t\t\$('#'+res[1]+'_body').slideUp(\"fast\");\n\n\t}else{\n\n\t\t\$('#'+res[1]+'_sign').html('-');\n\t\t\$('#'+res[1]+'_body').slideDown(\"fast\");\n\n\t}\n}\n\n//Show monthly graph\nfunction show_monthly_graph(monthly_data, month){\n\n\t\$(\"#note_box\").css(\"display\", \"none\");\n\n\tif(!empty(monthly_data)){\n\n\t\tvar cpu_data = new Array();\n\t\tvar inode_data = new Array();\n\t\tvar ram_data = new Array();\n\t\tvar disk_data = new Array();\n\t\tvar ntw_in_data = new Array();\n\t\tvar ntw_out_data = new Array();\n\t\tvar ntw_total_data = new Array();\n\t\tvar avg_download = 0;\n\t\tvar avg_upload = 0;\n\t\tvar count = 0;\n\n\t\t\$.each(monthly_data,function(key,val){\n\n\t\t\t//Array is in format [vpsid, time, status, disk, inode, ram, cpu, actual_cpu, net_in, net_out]\n\t\t\tcpu_data.push([val[1], val[6]]);\n\n\t\t\tinode_data.push([val[1], val[4]]);\n\n\t\t\tram_data.push([val[1], val[5]]);\n\n\t\t\tdisk_data.push([val[1], (val[3]/1024)]);\n\n\t\t\tntw_in_data.push([val[1], val[8]]);\n\n\t\t\tntw_out_data.push([val[1], val[9]]);\n\n\t\t\tntw_total_data.push([val[1], parseInt(val[8]) + parseInt(val[9])]);\n\n\t\t\tavg_download += parseInt(val.net_in);\n\t\t\tavg_upload += parseInt(val.net_out);\n\t\t\tcount++;\n\t\t});\n\n\t\t//cpu_data.sort(function(a,b){return a-b});\n\t\tcpu_data.sort(function(a, b){\n\t\t\treturn a[0]-b[0];\n\t\t});\n\n\t\tvar cpu_graph = [\n\t\t\t\t\t{ label: \"" . $l["cpu_graph_title"] . "\",  data: cpu_data}\n\t\t\t\t];\n\n\t\tvar inode_graph = [\n\t\t\t\t{ label: \"" . $l["inode_graph_title"] . "\",  data: inode_data, color: \"#80b3ff\"}\n\t\t\t];\n\n\t\tvar ram_graph = [\n\t\t\t\t{ label: \"" . $l["ram_graph_title"] . "\",  data: ram_data, color: \"#ccff33\"}\n\t\t\t];\n\n\t\tvar disk_graph = [\n\t\t\t\t{ label: \"" . $l["disk_graph_title"] . "\",  data: disk_data, color: \"#ff6600\"}\n\t\t\t];\n\n\t\tvar ntw_graph = [\n\t\t\t\t{ label: \"" . $l["download_graph_title"] . "\",  data: ntw_in_data, color: \"#0077FF\"},\n\t\t\t\t{ label: \"" . $l["upload_graph_title"] . "\",  data: ntw_out_data, color: \"#7D0096\"},\n\t\t\t\t{ label: \"" . $l["total_graph_title"] . "\",  data: ntw_total_data}\n\t\t\t];\n\n\t\tselection_zooming(\"cpu\", cpu_graph);\n\t\tlive_resource_graph(\"cpu\", cpu_graph, flot_options(\"cpu\"), \"% at\",true);\n\t\t\n\t\tselection_zooming(\"ram\", ram_graph);\n\t\tlive_resource_graph(\"ram\", ram_graph, flot_options(\"ram\"), \"MB at\",true);\n\t\t\n\t\tselection_zooming(\"disk\", disk_graph);\n\t\tlive_resource_graph(\"disk\", disk_graph, flot_options(\"disk\"), \"GB at\",true);\n\n\t\tselection_zooming(\"inodes\", inode_graph);\n\t\tlive_resource_graph(\"inodes\", inode_graph, flot_options(\"inodes\"), \" at\", true);\n\n\t\tselection_zooming(\"ntw\", ntw_graph);\n\t\tlive_resource_graph(\"ntw\", ntw_graph, flot_options(\"ntw\"), \"\", true);\n\n\t\t\$(\"#data_div\").css(\"display\", \"block\");\n\n\t}else{\n\t\t\$(\"#note_box\").css(\"display\", \"block\");\n\t\tshowalert(\"<b>" . $l["note"] . " : </b>&nbsp; " . $l["no_data"] . "\",\"2\");\n\t}\n\n\tvar current_year = month.current_month.substring(0,4);\n\tvar current_month = parseInt(month.current_month.substring(4));\n\tvar monthNames = [\"" . $l["jan"] . "\", \"" . $l["feb"] . "\", \"" . $l["mar"] . "\", \"" . $l["apr"] . "\", \"" . $l["may"] . "\", \"" . $l["jun"] . "\", \"" . $l["jul"] . "\", \"" . $l["aug"] . "\", \"" . $l["sep"] . "\", \"" . $l["oct"] . "\", \"" . $l["nov"] . "\", \"" . $l["dec"] . "\" ];\n\t\n\tvar d = new Date();\n\tcur_month = d.getMonth(); //get current month\n\n\tvar _month = parseInt(month.current_month.substring(5))-1; //get month from virtualizor\n\tif(cur_month == _month){\n\t\t\$(\"#next_month\").css(\"display\",\"none\");\n\t}\n\t\n\t\$(\"#month_holder2\").html(monthNames[current_month - 1] +\" \"+ current_year);\n\t\$(\"#next_month\").html('<a id=\"next_stats\" class=\"btn btn-primary\" href=\"" . $globals["index"] . "act=server_stats&show='+ month.next_month +'\">" . $l["next_month"] . "</a>');\n\t\$(\"#prev_month\").html('<a id=\"prev_stats\" class=\"btn btn-primary\" href=\"" . $globals["index"] . "act=server_stats&show='+ month.prev_month +'\">" . $l["prev_month"] . "</a>');\n\n}\n\n//lets check for selection and zooming\nfunction selection_zooming (id, data){\n\t\n\t\$(\"#\"+id).bind(\"plotselected\", function (event, ranges) {\n\t\tif (ranges.xaxis.to - ranges.xaxis.from < 0.00001) {ranges.xaxis.to = ranges.xaxis.from + 0.00001;}\n\t\tif (ranges.yaxis.to - ranges.yaxis.from < 0.00001) {ranges.yaxis.to = ranges.yaxis.from + 0.00001;}\n\t\toptions = flot_options(id);\n\t\tplot = \$.plot(\"#\"+id, data,\n\t\t\t\$.extend(true, {}, options, {\n\t\t\t\txaxis: { min: ranges.xaxis.from, max: ranges.xaxis.to },\n\t\t\t\tyaxis: { min: ranges.yaxis.from, max: ranges.yaxis.to }\n\t\t\t})\n\t\t);\n\t\t\n\t\t// if the button is there remove and append \n\t\tif(\$(\"#zoomOut_\"+id) != undefined){\n\t\t\t\$(\"#zoomOut_\"+id).fadeOut().remove();\n\t\t}\n\t\t\n\t\t\$(\"<input type='button' style='position:absolute;right:15px;top:15px;opacity:0.9;' class='btn' id='zoomOut_'\"+ id +\" value='Zoom Out'>\").appendTo(\$(\"#\"+id)).click(function(e){\n\t\t\te.preventDefault();\n\t\t\toptions = flot_options(id);\n\t\t\t\$.plot(\"#\"+id, data, options);\n\t\t\t\$(\"#zoomOut_\"+id).fadeOut().remove();\n\t\t});\n\t});\n};\n\nfunction flot_options(optionOf){\n\tvar options = {\n\t\t\tgrid: {\n\t\t\t\tborderWidth:0,\n\t\t\t\tlabelMargin:0,\n\t\t\t\taxisMargin:0,\n\t\t\t\tminBorderMargin:0\n\t\t\t},\n\t\t\tlegend: {\n\t\t\t\tshow: true,\n\t\t\t\tnoColumns: 3,\n\t\t\t},\n\t\t\tseries: {\n\t\t\t\tlines: {\n\t\t\t\t\tshow: true,\n\t\t\t\t\tlineWidth: 0.07,\n\t\t\t\t\tfill: true\n\t\t\t\t}\n\t\t\t},\n\t\t\txaxis: {\n\t\t\t\tshow:true,\n\t\t\t\tmode: \"time\",\n\t\t\t\ttickFormatter: function (v, axis) {\n\t\t\t\t\treturn nDate(v,\"m/d\");\n\t\t\t\t},\n\t\t\t\taxisLabelUseCanvas: true,\n\t\t\t\taxisLabelFontSizePixels: 12,\n\t\t\t\taxisLabelFontFamily: 'Verdana, Arial',\n\t\t\t\taxisLabelPadding: 10,\n\t\t\t},\n\t\t\tyaxis: {\n\t\t\t\tshow:true,\n\t\t\t\tmin: 0,\n\t\t\t\tmax: null,\n\t\t\t\taxisLabelUseCanvas: true,\n\t\t\t\taxisLabelFontSizePixels: 12,\n\t\t\t\taxisLabelFontFamily: 'Verdana, Arial',\n\t\t\t},\n\t\t\tselection: {\n\t\t\t\tmode: \"x\"\n\t\t\t},\t\n\t\t\tgrid: {\n\t\t\t\tborderWidth: 1,\n\t\t\t\tborderColor: '#FFF',\n\t\t\t\thoverable: true,\n\t\t\t}\n\t\t};\n\t\t\n\t\tif(optionOf == \"cpu\"){\n\t\t\n\t\t\t//Appending options for cpu\n\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\tif(v <= 1024)\n\t\t\t\t\treturn Math.round(v) + \" %\";\n\t\t\t};\n\t\t\toptions.legend.container = \$(\"#legend_cpu\");\n\t\t\n\t\t}else if(optionOf == \"ram\"){\n\t\t\t\n\t\t\t//Appending options for ram\n\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\tif(v <= 1024)\n\t\t\t\t\treturn Math.round(v) + \" MB\";\n\t\t\t\tif(v > 1024 && v < (1024*1024))\n\t\t\t\t\treturn Math.round(v /1024) + \" GB\";\n\t\t\t\tif(v > (1024*1024))\n\t\t\t\t\treturn Math.round(v / (1024*1024)) + \" TB\"\n\t\t\t};\n\t\t\toptions.legend.container = \$(\"#legend_ram\");\n\t\t\t\n\t\t}else if(optionOf == \"disk\"){\n\t\t\n\t\t\t//Appending options for Disk\n\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\tif(v <= 1024)\n\t\t\t\t\treturn Math.round(v) + \" GB\";\n\t\t\t\tif(v > 1024 && v < (1024*1024))\n\t\t\t\t\treturn Math.round(v /1024) + \" TB\";\n\t\t\t};\n\t\t\toptions.legend.container = \$(\"#legend_disk\");\n\t\t\n\t\t}else if(optionOf == \"inodes\"){\n\t\t\n\t\t\t//Appending option for INodes\n\t\t\toptions.yaxis.tickFormatter = \"\";\n\t\t\toptions.legend.container = \$(\"#legend_inodes\");\n\t\t\n\t\t}else if(optionOf == \"ntw\"){\n\t\t\n\t\t\t//Appending  option for Network\n\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\tif(v <= 1024)\n\t\t\t\t\treturn Math.round(v) + \" B/s\";\n\t\t\t\tif(v > 1024 && v <= (1024*1024))\n\t\t\t\t\treturn Math.round(v / 1024) + \" KB/s\";\n\t\t\t\tif(v > (1024*1024) && v <= (1024*1024*1024))\n\t\t\t\t\treturn Math.round(v / (1024*1024)) + \" MB/s\";\n\t\t\t\tif(v > (1024*1024*1024))\n\t\t\t\t\treturn Math.round(v / (1024*1024*1024)) + \" GB/s\";\n\t\t\t};\n\t\t\toptions.legend.container = \$(\"#legend_ntw\");\n\t\t\t\n\t\t}\n\t\t\n\t\treturn options;\n};\n\nfunction search_result(mon){\n\n\t//Display loading image\n\t\$(\"#img_loading\").html(\"<img class='form-label' src=" . $theme["images"] . "loading_35.gif />\");\n\t\$(\"#note_box\").css(\"display\", \"none\");\n\n\t\$.post(\"" . $globals["index"] . "act=server_stats&jsnohf=1&api=json&svs=" . $globals["server"] . "&show=\" + mon +\"\", function(data){\n\t\tdata = JSON.parse(data);\n\t\tif(data.server_stats){\n\t\t\tshow_monthly_graph(data.server_stats, data.month);\n\t\t\t\$(\"#data_div\").css(\"display\", \"block\");\n\t\t}else{\n\t\t\t\$(\"#note_box\").css(\"display\", \"block\");\n\t\t\tshowalert(\"<b>" . $l["note"] . " : </b>&nbsp; " . $l["no_data"] . "\",\"2\");\n\t\t}\n\t\t\$(\"#img_loading\").html(\"\");\n\t});\n\n};\n\n\$(document).ready(function() {\n\t\$(\".legend_container\").next(\"div\").css(\"width\", \$( window ).width() - 250);\n\tshow_monthly_graph(" . $monthly_data . ", " . $month . ");\n});\n\n</script>\n\n<div class=\"bg\">\n\t<div class=\"row mx-auto my-3\">\n\t\t<div class=\"col-10\">\n\t\t\t<h4 class=\"text-dark\"><i class=\"fas fa-chart-bar\"></i> " . $l["page_head"] . "</h4>\n\t\t</div>\n\t</div>\n\t<div class=\"card m-2 p-3\">\n\t";
    server_select();
    echo "<div class=\"row w-100 mx-auto my-3\" id=\"note_box\">\n\t\t<div class=\"col-sm-12\">\n\t\t\t<div class=\"notice\" style=\"display:none;\"><b>NOTE : </b>&nbsp; " . $l["no_data"] . "</div>\n\t\t</div>\n\t</div>\n\n\t<div class=\"form-group row w-100 mx-auto my-3\" id=\"per_month_display\">\n\t\t<div id=\"prev_month\" class=\"col-4 text-right\"></div>\n\t\t<div id=\"month_holder2\" class=\"col-4 text-center h4 p-0 m-0\"></div>\n\t\t<div id=\"next_month\" class=\"col-4 text-left\"></div>\n\t</div> </div><br />\n\n\t<div id=\"data_div\" style=\"display:none;\">\n\t\t<div class=\"row w-100 mx-auto\">\n\t\t\t<div class=\"col-sm-12 p-0\">\n\n\t\t\t\t<div id=\"flip_cpu\" class=\"roundheader cursor-pointer\" onclick=\"graph_display(this.id)\">\n\t\t\t\t\t<label id=\"cpu_sign\">-</label>\n\t\t\t\t\t<label>" . $l["cpu_label"] . "</label>\n\t\t\t\t</div>\n\t\t\t\t<br />\n\t\t\t\t<center>\n\t\t\t\t\t<div id=\"cpu_body\" class=\"box_shadow row w-100 p-2 bgaddv\">\n\t\t\t\t\t\t<div class=\"legend_container mb-3 row mx-auto w-100\" id=\"legend_cpu\"></div>\n\t\t\t\t\t\t<div id=\"cpu\" class=\"w-75\" style=\"margin:auto; height:300px; padding:6px;\"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</center><br />\n\n\t\t\t\t<div id=\"flip_ram\" class=\"roundheader cursor-pointer\"  onclick=\"graph_display(this.id)\">\n\t\t\t\t\t<label id=\"ram_sign\">-</label>\n\t\t\t\t\t<label>" . $l["ram_label"] . "</label>\n\t\t\t\t</div>\n\t\t\t\t<br />\n\t\t\t\t<center>\n\t\t\t\t\t\n\t\t\t\t\t<div id=\"ram_body\" class=\"box_shadow row w-100 p-2 bgaddv\">\n\t\t\t\t\t\t<div class=\"legend_container mb-3 row mx-auto w-100\" id=\"legend_ram\"></div>\n\t\t\t\t\t\t<div id=\"ram\" class=\"w-75\"  style=\"margin:auto; height:300px; padding:6px;\"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</center><br />\n\n\t\t\t\t<div id=\"flip_disk\" class=\"roundheader cursor-pointer\"  onclick=\"graph_display(this.id)\">\n\t\t\t\t\t<label id=\"disk_sign\">-</label>\n\t\t\t\t\t<label>" . $l["disk_label"] . "</label>\n\t\t\t\t</div><br />\n\n\t\t\t\t<center>\t\t\t\t\t\n\t\t\t\t\t<div id=\"disk_body\" class=\"box_shadow row w-100 p-2 bgaddv\">\n\t\t\t\t\t\t<div class=\"row mx-auto w-100\">\n\t\t\t\t\t\t\t<div class=\"legend_container mb-3 row mx-auto w-100\" id=\"legend_disk\"></div>\n\t\t\t\t\t\t\t<div id=\"disk\" class=\"w-75\"  style=\"margin:auto; height:300px; padding:6px;\"></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"row mx-auto w-100\">\n\t\t\t\t\t\t\t<div class=\"legend_container mb-3 row mx-auto w-100\" id=\"legend_inodes\"></div>\n\t\t\t\t\t\t\t<div id=\"inodes\" class=\"w-75\" style=\"margin:auto; height:300px; padding:6px;\"></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</center><br />\n\n\n\t\t\t\t<div id=\"flip_ntw\" class=\"roundheader\" cursor-pointer  onclick=\"graph_display(this.id)\">\n\t\t\t\t\t<label id=\"ntw_sign\">-</label>\n\t\t\t\t\t<label >" . $l["ntw_label"] . "</label>\n\t\t\t\t</div><br />\n\t\t\t\t<center>\n\t\t\t\t\t\n\t\t\t\t\t<div id=\"ntw_body\" class=\"box_shadow row w-100 p-2 bgaddv\">\n\t\t\t\t\t\t<div class=\"legend_container mb-3 row mx-auto w-100\" id=\"legend_ntw\"></div>\n\t\t\t\t\t\t<div id=\"ntw\" class=\"w-75\"  style=\"margin:auto; height:300px; padding:6px;\"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</center>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div><br><br>";
    softfooter();
}

?>