<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function self_shutdown()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $error;
    global $var;
    global $done;
    $theme["init_theme"] = "self_shutdown";
    $theme["init_theme_name"] = "self_shutdown";
    $theme["init_theme_func"] = ["self_shutdown_theme"];
    $theme["call_theme_func"] = "self_shutdown_theme";
    $data = [];
    if(isset($_POST["selfshutdown"])) {
        if(!empty($user["vps"]["admin_managed"])) {
            $error[] = $l["is_managed"];
            return false;
        }
        if(!empty($globals["disable_self_shutdown"])) {
            $error[] = $l["sd_not_allowed"];
            return false;
        }
        $data["vpsid"] = $globals["vpsid"];
        $data["shutdown_action"] = (int) optREQ("shutdown_action");
        if(3 < $data["shutdown_action"]) {
            $error[] = $l["sd_invalid_action"];
        }
        $del_id = (int) optREQ("delete_timer");
        if(!empty($del_id)) {
            $data["delete_timer"] = $del_id;
        }
        $edit_id = (int) optREQ("edit_timer");
        if(!empty($edit_id)) {
            $data["edit_timer"] = $edit_id;
        }
        $date_split = explode("/", optREQ("shutdown_date"));
        if(preg_match("/[a-zA-Z]/", implode("", $date_split)) && empty($del_id)) {
            $error[] = $l["sd_date_alert"];
            return false;
        }
        $mkTime["hours"] = sprintf("%02d", optREQ("shutdown_hrs"));
        $mkTime["minutes"] = sprintf("%02d", optREQ("shutdown_min"));
        $mkTime["day"] = sprintf("%02d", $date_split[1]);
        $mkTime["month"] = sprintf("%02d", $date_split[0]);
        $mkTime["year"] = sprintf("%04d", $date_split[2]);
        $mkTime["time"] = $mkTime["year"] . $mkTime["month"] . $mkTime["day"] . $mkTime["hours"] . $mkTime["minutes"];
        if(!valid_datetime($mkTime["time"]) && empty($del_id)) {
            $error[] = $l["sd_date_alert"];
            return false;
        }
        $data["time"] = datetime_to_time($mkTime["time"]);
        if($data["time"] < time() && empty($del_id)) {
            $error[] = $l["sd_date_current"];
            return false;
        }
        $resp = vps_self_shutdown($globals["vpsid"], $data);
        if(!empty($resp["updated"])) {
            $done["msg"] = $l["time_updated"];
        }
        if(!empty($resp["added"])) {
            $done["msg"] = $l["time_added"];
        }
        if(!empty($resp["deleted"])) {
            $done["msg"] = $l["time_deleted"];
        }
        $done["done"] = true;
    }
    $globals["cur_page"] = get_page();
    $globals["reslen"] = (int) optREQ("reslen");
    $globals["reslen"] = (int) ($globals["reslen"] <= 0 ? 50 : $globals["reslen"]);
    $data_show["reslen"] = $globals["reslen"];
    $data_show["cur_page"] = $globals["cur_page"];
    $data_show["vpsid"] = (int) $globals["vpsid"];
    $var = get_shutdown_date($globals["vpsid"], $data_show);
}
function API_self_shutdown()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $error;
    global $var;
    global $done;
    $GLOBALS["_api"]["self_shutdown"] = $var;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
}
function vps_self_shutdown($vpsid, $data)
{
    global $globals;
    if(empty($vpsid)) {
        return false;
    }
    $temp = [];
    if(!empty($data["delete_timer"])) {
        makequery("DELETE FROM `self_shutdown` WHERE \n\t\t\t\t`id` = :id AND \n\t\t\t\t`status` IS NULL", [":id" => $data["delete_timer"]]);
        $temp["deleted"] = 1;
    } elseif(!empty($data["edit_timer"])) {
        update_query("UPDATE `self_shutdown` SET \n\t\t\t\t`time` = :time,\n\t\t\t\t`action` = :action\n\t\t\t\t WHERE `id` = :id AND \n\t\t\t\t `status` IS NULL", [":time" => $data["time"], ":action" => $data["shutdown_action"], ":id" => $data["edit_timer"]]);
        $temp["updated"] = 1;
    } else {
        makequery("INSERT INTO `self_shutdown` SET\n\t\t\t\t`vpsid` = :vpsid,\n\t\t\t\t`time` = :time,\n\t\t\t\t`action` = :action", [":vpsid" => $data["vpsid"], ":time" => $data["time"], ":action" => $data["shutdown_action"]]);
        $temp["added"] = 1;
    }
    return $temp;
}
function get_shutdown_date($vpsid, $data)
{
    $var = [];
    $vpsid = (int) $vpsid;
    $res_num = makequery("SELECT COUNT(`id`) AS num FROM `self_shutdown` WHERE `vpsid` = :vpsid", [":vpsid" => $vpsid]);
    $tmp = vsql_fetch_assoc($res_num);
    $data["num_res"] = $tmp["num"];
    $pagination["start"] = $data["cur_page"];
    $pagination["len"] = $data["reslen"];
    $pagination["maxNum"] = $data["num_res"];
    $var["page"] = $pagination;
    $res = makequery("SELECT * FROM `self_shutdown` \n\t\t\t\t\tWHERE `vpsid` = :vpsid ORDER BY `status` \n\t\t\t\t\tLIMIT " . $data["cur_page"] . ", " . $data["reslen"] . "", [":vpsid" => $vpsid]);
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $row["time"] = datify($row["time"], "", false, "m/d/Y H:i");
        $temp = explode(" ", $row["time"]);
        $row["date"] = $temp[0];
        $hrMin = explode(":", $temp[1]);
        list($row["hours"], $row["minutes"]) = $hrMin;
        $var["self_shutdown"][$row["id"]] = $row;
    }
    return $var;
}

?>