<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function letsencrypt()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $info;
    global $cluster;
    global $keyconf;
    global $crt_details;
    global $site_domain;
    global $crt_buts;
    global $crt_config_options;
    global $crt_select_opts;
    global $done;
    global $error;
    global $actid;
    global $flag_task;
    global $logs;
    global $user_id;
    global $servers;
    global $servername;
    global $slaveactid;
    if(!load_lang("admin/letsencrypt")) {
        return false;
    }
    $theme["init_theme"] = "admin/letsencrypt";
    $theme["init_theme_name"] = "letsencrypt";
    $theme["init_theme_func"] = ["letsencrypt_theme"];
    $theme["call_theme_func"] = "letsencrypt_theme";
    if(!is_allowed("ssl")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $user_id = optREQ("uid");
    $crt_buts = ["get_crt" => "get_certificate", "renew_crt" => "renew_certificate", "show_logs" => "show_logs"];
    $servername = $servers[$globals["server"]]["server_name"];
    get_cert_details();
    get_form_data();
    if(optREQ("error")) {
        $actid = (int) optGET("actid");
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\t  WHERE actid = :actid", [":actid" => $actid]);
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        $tasks = vsql_fetch_assoc($res);
        if($tasks["status"] == -1) {
            $error[] = $tasks["status_txt"];
        }
        return true;
    }
    $opt = optPOST("opt");
    $res = [];
    if(!empty($opt)) {
        switch ($opt) {
            case "get_crt":
            case "renew_crt":
                $slaveactid = $cluster->le_manage($globals["server"], $opt, [], $user_id);
                $actid = 0;
                if(!empty($slaveactid)) {
                    if(is_master() && $globals["server"] != 0) {
                        for ($i = 0; $i < 3; $i++) {
                            $cluster->reverse_sync($globals["server"]);
                            $res1 = makequery("SELECT * FROM tasks WHERE\n\t\t\t\t\t\t\t\t\t\t\t\tserid = :serid\n\t\t\t\t\t\t\t\t\t\t\t\tAND slaveactid = :slaveactid", [":serid" => $globals["server"], ":slaveactid" => $slaveactid]);
                            $row = vsql_fetch_assoc($res1);
                            $actid = (int) $row["actid"];
                            if(!empty($actid)) {
                                break;
                            }
                            sleep(1);
                        }
                        if(empty($actid)) {
                            $res["done"] = false;
                            $res["err_msg"] = $l["no_task"];
                        } else {
                            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/virt_acme_master.php " . $actid . " " . $globals["server"] . " > " . logdir() . "le_master.log 2>&1 &", $o, $r);
                        }
                    } else {
                        $actid = $slaveactid;
                    }
                    $flag_task = 1;
                    $res["done"] = true;
                    $res["done_msg"] = $actid;
                } else {
                    $res["done"] = false;
                    $res["err_msg"] = $l["no_task"];
                }
                break;
            case "save_cfg":
                $save_data = [];
                $user_id = optPOST("uid");
                $primary_domain = array_values(array_filter(array_map("trim", preg_split("/\\s*,\\s*/", optPOST("primary_domain")))));
                $contact_email = optPOST("contact_email");
                $key_size = optPOST("key_size");
                $renew_days = (int) optPOST("renew_days");
                $ssl_type = optPOST("ssl_type");
                $save_data["staging"] = optPOST("staging") ? 1 : 0;
                $save_data["enable_force"] = optPOST("enable_force") ? 1 : 0;
                if(empty($primary_domain)) {
                    $res["done"] = false;
                    $res["err_msg"] = $l["err_inv_domain"];
                } elseif(!emailvalidation($contact_email)) {
                    $res["done"] = false;
                    $res["err_msg"] = $l["err_inv_contact_email"];
                } elseif(!in_array($key_size, $crt_select_opts["key_size"])) {
                    $res["done"] = false;
                    $res["err_msg"] = $l["err_inv_key_size"];
                } elseif(!is_numeric($renew_days) || $renew_days < 0) {
                    $res["done"] = false;
                    $res["err_msg"] = $l["err_inv_renew_days"];
                } elseif(!in_array($ssl_type, $crt_select_opts["ssl_type"])) {
                    $res["done"] = false;
                    $res["err_msg"] = $l["err_inv_ssl_type"];
                } else {
                    $save_data["primary_domain"] = $primary_domain;
                    $save_data["contact_email"] = $contact_email;
                    $save_data["key_size"] = $key_size;
                    $save_data["renew_days"] = $renew_days;
                    $save_data["ssl_type"] = $ssl_type;
                    $res = $cluster->le_manage($globals["server"], $opt, $save_data, $user_id);
                    if($res["done"]) {
                        $res["done_msg"] = $l["done_save_cfg"];
                        get_form_data();
                    }
                }
                break;
            case "show_logs":
                $logs = "";
                $logs = $cluster->le_manage($globals["server"], "show_logs", [], $user_id);
                if(empty($logs)) {
                    $logs = $l["no_logs"];
                }
                $res["done"] = true;
                break;
            default:
                $error[] = $l["err_unknown_req"];
                if(!$res["done"]) {
                    $error[] = !empty($res["err_msg"]) ? $res["err_msg"] : $l["err_save_cfg"];
                } else {
                    $done = !empty($res["done_msg"]) ? $res["done_msg"] : $res["done"];
                }
                get_cert_details();
        }
    }
}
function get_form_data()
{
    global $globals;
    global $cluster;
    global $crt_config_options;
    global $crt_select_opts;
    global $user_id;
    $confs = [];
    $form_data = $cluster->le_manage($globals["server"], "get_cfg", [], $user_id);
    $crt_config_options = ["crt_save_cfg_frm" => ["inputs" => ["ssl_type" => ["type" => "select", "value" => $form_data["conf"]["ssl_type"]], "primary_domain" => ["type" => "text", "value" => $form_data["conf"]["primary_domain"]], "contact_email" => ["type" => "text", "value" => $form_data["conf"]["contact_email"]], "key_size" => ["type" => "select", "value" => $form_data["conf"]["key_size"]], "renew_days" => ["type" => "text", "value" => $form_data["conf"]["renew_days"]], "staging" => ["type" => "checkbox", "value" => $form_data["conf"]["staging"]], "enable_force" => ["type" => "checkbox", "value" => $form_data["conf"]["enable_force"]]]]];
    $crt_select_opts = ["key_size" => $form_data["conf"]["sel_opts"]["key_size"], "ssl_type" => $form_data["conf"]["sel_opts"]["ssl_type"]];
    return true;
}
function get_cert_details()
{
    global $globals;
    global $l;
    global $crt_details;
    global $cluster;
    global $site_domain;
    global $error;
    global $user_id;
    $crt_details = [];
    $crt_details_tmp = $cluster->le_manage($globals["server"], "get_crt_details", [], $user_id);
    $site_domain = cexplode(",", $crt_details_tmp["site_domain"], 0, 1);
    $crt_details["crt_domain"] = !empty($crt_details_tmp["cert_info"]["subject"]["CN"]) ? $crt_details_tmp["cert_info"]["subject"]["CN"] : "";
    $sans = "";
    $tmp_sans = !empty($crt_details_tmp["cert_info"]["extensions"]["subjectAltName"]) ? preg_split("/,\\s/i", $crt_details_tmp["cert_info"]["extensions"]["subjectAltName"]) : "";
    if(!empty($tmp_sans)) {
        foreach ($tmp_sans as $v) {
            if($v != "") {
                $sans .= $v . "<br>";
            }
        }
    }
    $crt_details["crt_san"] = $sans;
    $crt_details["crt_issuer"] = !empty($crt_details_tmp["cert_info"]["issuer"]["CN"]) ? $crt_details_tmp["cert_info"]["issuer"]["CN"] : "";
    $crt_details["crt_serialno"] = !empty($crt_details_tmp["cert_info"]["serialNumber"]) ? $crt_details_tmp["cert_info"]["serialNumber"] : "";
    $crt_details["crt_valid_from_time"] = !empty($crt_details_tmp["cert_info"]["validFrom_time_t"]) ? gmdate("D, d M Y H:i:s T", $crt_details_tmp["cert_info"]["validFrom_time_t"]) : "";
    $crt_details["crt_valid_to_time"] = !empty($crt_details_tmp["cert_info"]["validTo_time_t"]) ? gmdate("D, d M Y H:i:s T", $crt_details_tmp["cert_info"]["validTo_time_t"]) : "";
    $crt_details["next_renew"] = !empty($crt_details_tmp["next_renew"]) ? gmdate("D, d M Y H:i:s T", $crt_details_tmp["next_renew"]) : "";
    $crt_details["crt_installed"] = $crt_details_tmp["crt_installed"] ? "<span style=\"color: green;\">" . $l["installed"] . "</span>" : "<span style=\"color: red;\">" . $l["not_installed"] . "</span>";
    return true;
}
function API_letsencrypt()
{
    global $theme;
    global $globals;
    global $crt_details;
    global $crt_config_options;
    global $crt_select_opts;
    global $done;
    global $actid;
    global $flag_task;
    global $logs;
    global $site_domain;
    global $servername;
    global $slaveactid;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["crt_config_options"] = $crt_config_options;
    $GLOBALS["_api"]["crt_details"] = $crt_details;
    $GLOBALS["_api"]["actid"] = $actid;
    $GLOBALS["_api"]["logs"] = $logs;
    $GLOBALS["_api"]["crt_select_opts"] = $crt_select_opts;
    $GLOBALS["_api"]["site_domain"] = $site_domain;
    $GLOBALS["_api"]["servername"] = $servername;
    $GLOBALS["_api"]["slaveactid"] = $slaveactid;
}

?>