<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
class cluster
{
    public $calls = [];
    public function __construct()
    {
    }
    public function virt($vz = 0, $xen = 0, $xenhvm = 0, $kvm = 0, $xcp = 0, $lxc = 0, $vmware = 0, $proxmox = 0, $virtuozzo = 0)
    {
        global $globals;
        global $servers;
        $virt = $servers[$globals["server"]]["virt"];
        if(preg_match("/openvz/is", $virt)) {
            return $vz;
        }
        if(preg_match("/xen/is", $virt) && !empty($servers[$globals["server"]]["hvm"])) {
            return $xenhvm;
        }
        if(preg_match("/xen/is", $virt)) {
            return $xen;
        }
        if(preg_match("/kvm/is", $virt)) {
            return $kvm;
        }
        if(preg_match("/vmware/is", $virt)) {
            return $vmware;
        }
        if(preg_match("/xcp/is", $virt)) {
            return $xcp;
        }
        if(preg_match("/lxc/is", $virt)) {
            return $lxc;
        }
        if(preg_match("/proxk/is", $virt)) {
            return $proxmox;
        }
        if(preg_match("/proxo/is", $virt)) {
            return $proxmox;
        }
        if(preg_match("/proxl/is", $virt)) {
            return $proxmox;
        }
        if(preg_match("/vzo/is", $virt)) {
            return $virtuozzo;
        }
        if(preg_match("/vzk/is", $virt)) {
            return $virtuozzo;
        }
    }
    public function filelist($serid, $dir = "", $searchSubdirs = 1, $directoriesonly = 0, $maxlevel = "all", $level = 1)
    {
        if(empty($serid)) {
            $path = file_exists("E:\\Program Files") ? "E:\\Program Files\\EasyPHP 3.0\\www\\virtualizor" : "";
            $dir = $dir[0] == "/" ? $dir : "/" . $dir;
            $r = filelist($path . $dir, $searchSubdirs, $directoriesonly, $maxlevel, $level);
            if(empty($r)) {
                $r = [];
            }
            $listd = $listf = [];
            foreach ($r as $k => $v) {
                $k = substr($k, strlen($path));
                $v["fullpath"] = rtrim($v["path"], "/");
                $v["path"] = substr($v["path"], strlen($path));
                if(empty($v["dir"])) {
                    $listf[$k] = $v;
                } else {
                    $listd[$k] = $v;
                }
            }
            $list = array_merge($listd, $listf);
        } else {
            $details = $this->call($serid, "index.php?act=filemanager&path=" . $dir);
            if(!empty($details)) {
                $list = $details["files"];
            } else {
                return -1;
            }
        }
        return $list;
    }
    public function cpu($serid, $limited = 0)
    {
        $ret = [];
        $ret["manu"] = "unknown";
        $ret["cpumodel"] = "unknown";
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(empty($serid)) {
            if(empty($limited)) {
                oexec("cat /proc/cpuinfo", $tmp);
                if(preg_match("/intel/is", $tmp)) {
                    $ret["manu"] = "intel";
                } elseif(preg_match("/amd/is", $tmp)) {
                    $ret["manu"] = "amd";
                }
                oexec("cat /proc/cpuinfo | grep \"model name\" | uniq", $model);
                $model = array_filter(explode(":", $model));
                unset($model[0]);
                $ret["cpumodel"] = implode("", $model);
            }
            virt_preg_replace("/cpu(\\s*?)MHz(\\s*?)\\:(\\s*?)(.*?)(\\s*?)\\n/is", $tmp, $tmp, 4);
            $ret["limit"] = round((double) (empty($tmp) ? 100 : $tmp));
            $tmp = @cpuused("cat /proc/stat");
            $ret["used"] = round((empty($tmp) ? 0 : $tmp) / 100 * $ret["limit"]);
        } else {
            $post["limited"] = $limited;
            $details = $this->call($serid, "index.php?act=apidoings&do=cpu", 1, [], $post);
            if(!empty($details)) {
                if(empty($limited)) {
                    $ret["cpumodel"] = $details["usage"]["cpu"]["cpumodel"];
                    $ret["manu"] = $details["usage"]["cpu"]["manu"];
                }
                $ret["limit"] = $details["usage"]["cpu"]["limit"];
                $ret["used"] = $details["usage"]["cpu"]["used"];
            } else {
                return -1;
            }
        }
        $ret["free"] = round($ret["limit"] - $ret["used"]);
        $ret["percent"] = round($ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100);
        $ret["percent_free"] = round(100 - $ret["percent"]);
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        if(!empty($limited)) {
            $final["percent"] = $ret["percent"];
            $final["percent_free"] = $ret["percent_free"];
            $ret = $final;
        }
        return $ret;
    }
    public function serverloads($serid, $ids)
    {
        global $kernel;
        $cpu = [];
        if(empty($serid)) {
            $cpu = $kernel->serverloads($ids);
        } else {
            $details = $this->call($serid, "index.php?act=serverloads");
            if(!empty($details)) {
                $cpu = $details["vpsusage"];
            } else {
                return -1;
            }
        }
        return $cpu;
    }
    public function vscpu($serid, $ids)
    {
        global $kernel;
        $cpu = [];
        if(empty($serid)) {
            $cpu = $kernel->vscpu($ids);
        } else {
            $details = $this->call($serid, "index.php?act=vscpu");
            if(!empty($details)) {
                $cpu = $details["vpsusage"];
            } else {
                return -1;
            }
        }
        return $cpu;
    }
    public function noderam($serid)
    {
        global $globals;
        if(empty($serid) && $globals["kernel"] == "xen") {
            $ret = [];
            $ret["used"] = 0;
            $ret["limit"] = 0;
            $ret["swap"] = 0;
            $ret["swap_used"] = 0;
            oexec(VXM . " info | grep _memory", $output);
            virt_preg_replace("/total_memory(\\s*?)\\:(\\s*?)(\\d*)\\n/is", $output, $ret["limit"], 3);
            virt_preg_replace("/free_memory(\\s*?)\\:(\\s*?)(.*)/is", $output, $free, 3);
            $free = (int) $free;
            $ret["used"] = $ret["limit"] - $free;
            $ret["free"] = $ret["limit"] - $ret["used"];
            $ret["swap_free"] = $ret["swap"] - $ret["swap_used"];
            $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
            $ret["percent_free"] = 100 - $ret["percent"];
            foreach ($ret as $k => $v) {
                $ret[$k] = round($v, 2);
            }
            return $ret;
        } else {
            return $this->ram($serid);
        }
    }
    public function ram($serid, $limited = 0)
    {
        global $globals;
        $ret = [];
        $ret["used"] = 0;
        $ret["limit"] = 0;
        $ret["swap"] = 0;
        $ret["swap_used"] = 0;
        if(empty($serid)) {
            $meminfo = get_meminfo();
            $free = $meminfo["Buffers"] + $meminfo["Cached"] + $meminfo["MemFree"];
            $ret["used"] = $meminfo["MemTotal"] - $free;
            $ret["limit"] = $meminfo["MemTotal"];
            $ret["swap"] = $meminfo["SwapTotal"];
            $ret["swap_used"] = $meminfo["SwapTotal"] - $meminfo["SwapFree"];
        } else {
            $post["limited"] = $limited;
            $details = $this->call($serid, "index.php?act=apidoings&do=ram", 1, [], $post);
            if(!empty($details)) {
                $ret["limit"] = $details["usage"]["ram"]["limit"];
                $ret["used"] = $details["usage"]["ram"]["used"];
                $ret["swap"] = $details["usage"]["ram"]["swap"];
                $ret["swap_used"] = $details["usage"]["ram"]["swap_used"];
            } else {
                return -1;
            }
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["swap_free"] = $ret["swap"] - $ret["swap_used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        $final["percent"] = round($ret["percent"]);
        $final["percent_free"] = round($ret["percent_free"]);
        if(!empty($limited)) {
            $ret = $final;
        }
        return $ret;
    }
    public function vsram($serid, $ids)
    {
        global $kernel;
        global $servers;
        $ram = [];
        if(empty($serid)) {
            $ram = $kernel->vsram($ids);
        } else {
            $details = $this->call($serid, "index.php?act=vsram");
            if(!empty($details)) {
                $ram = $details["vpsusage"];
            } else {
                return -1;
            }
        }
        return $ram;
    }
    public function disk($serid)
    {
        $ret = [];
        $ret["/"]["limit"] = 0;
        $ret["/"]["used"] = 0;
        if(empty($serid)) {
            $return = vexec("/bin/df -P", $output);
            unset($output[0]);
            foreach ($output as $k => $v) {
                $tmp = preg_split("/[\\s]+/", $v);
                if($tmp[0] == "tmpfs") {
                } else {
                    $ret[$tmp[5]]["limit"] = $tmp[1] / 1024;
                    $ret[$tmp[5]]["used"] = $tmp[2] / 1024;
                    $ret[$tmp[5]]["available"] = $tmp[3] / 1024;
                }
            }
            foreach ($ret as $k => $v) {
                $ret[$k]["free"] = $ret[$k]["limit"] - $ret[$k]["used"];
                $ret[$k]["limit_gb"] = $ret[$k]["limit"] / 1024;
                $ret[$k]["used_gb"] = $ret[$k]["used"] / 1024;
                $ret[$k]["actual_gb"] = ($ret[$k]["limit"] - $ret[$k]["available"]) / 1024;
                $ret[$k]["free_gb"] = $ret[$k]["limit_gb"] - $ret[$k]["used_gb"];
                $ret[$k]["percent"] = $ret[$k]["used"] / ($ret[$k]["limit"] ? $ret[$k]["limit"] : 1) * 100;
                $ret[$k]["percent_free"] = 100 - $ret[$k]["percent"];
                foreach ($ret[$k] as $kk => $vv) {
                    $ret[$k][$kk] = round($vv, 2);
                }
            }
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=disk");
            if(!empty($details)) {
                $ret = $details["usage"]["disk"];
            } else {
                return -1;
            }
        }
        return $ret;
    }
    public function inodes($serid)
    {
        $ret = [];
        $ret["/"]["limit"] = 0;
        $ret["/"]["used"] = 0;
        if(empty($serid)) {
            $return = vexec("/bin/df -i", $output);
            unset($output[0]);
            foreach ($output as $k => $v) {
                $tmp = preg_split("/[\\s]+/", $v);
                if($tmp[0] == "tmpfs") {
                } else {
                    list($ret[$tmp[5]]["limit"], $ret[$tmp[5]]["used"]) = $tmp;
                }
            }
            foreach ($ret as $k => $v) {
                $ret[$k]["free"] = $ret[$k]["limit"] - $ret[$k]["used"];
                $ret[$k]["percent"] = $ret[$k]["used"] / ($ret[$k]["limit"] ? $ret[$k]["limit"] : 1) * 100;
                $ret[$k]["percent_free"] = 100 - $ret[$k]["percent"];
                foreach ($ret[$k] as $kk => $vv) {
                    $ret[$k][$kk] = round($vv, 2);
                }
            }
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=inodes");
            if(!empty($details)) {
                $ret = $details["usage"]["inodes"];
            } else {
                return -1;
            }
        }
        return $ret;
    }
    public function bandwidth($serid, $show = 0)
    {
        global $user;
        $ret = [];
        $ret["limit"] = (empty($GLOBALS["globals"]["node_bandwidth"]) ? 0 : $GLOBALS["globals"]["node_bandwidth"]) * 1024;
        $ret["used"] = 0;
        $ret["usage"] = [];
        $ret["in"] = [];
        $ret["out"] = [];
        if(empty($serid)) {
            $month["yr"] = datify(time(), 0, 1, "Y");
            $month["month"] = datify(time(), 0, 1, "m");
            if(!empty($show)) {
                $month["yr"] = (int) substr($show, 0, 4);
                $month["month"] = substr($show, 4);
            }
            $tmp = mktime(1, 1, 1, $month["month"], 1, $month["yr"]);
            $month["days"] = date("t", $tmp);
            $start = $month["yr"] . $month["month"] . "01";
            $end = $month["yr"] . $month["month"] . $month["days"];
            $ret["usage"] = [];
            for ($i = 1; $i <= $month["days"]; $i++) {
                $ret["usage"][$i] = 0;
                $ret["in"]["usage"][$i] = 0;
                $ret["out"]["usage"][$i] = 0;
            }
            $res = makequery("SELECT * FROM bandwidth\n\t\t\t\t\t\t\tWHERE vpsid = 0\n\t\t\t\t\t\t\tAND date >= :start\n\t\t\t\t\t\t\tAND date <= :end\n\t\t\t\t\t\t\tAND `time` = 0", [":start" => $start, ":end" => $end]);
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $dt = (int) substr($row["date"], 6);
                $ret["usage"][$dt] = round(($row["in"] + $row["out"]) / 1024 / 1024, 2);
                $ret["in"]["usage"][$dt] = round($row["in"] / 1024 / 1024, 2);
                $ret["out"]["usage"][$dt] = round($row["out"] / 1024 / 1024, 2);
            }
            $ret["mdays"] = array_keys($ret["usage"]);
            $ret["used"] = array_sum($ret["usage"]);
            $ret["limit_gb"] = empty($ret["limit"]) ? 0 : $ret["limit"] / 1024;
            $ret["free"] = empty($ret["limit"]) ? 0 : $ret["limit"] - $ret["used"];
            $ret["free_gb"] = empty($ret["limit"]) ? 0 : $ret["limit_gb"] - $ret["used_gb"];
            $ret["used_gb"] = $ret["used"] / 1024;
            $ret["percent"] = empty($ret["limit"]) ? 0 : $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
            $ret["percent_free"] = 100 - $ret["percent"];
            $ret["in"]["used"] = array_sum($ret["in"]["usage"]);
            $ret["in"]["limit"] = $ret["in"]["used"] + 1;
            $ret["in"]["free"] = $ret["in"]["limit"] - $ret["in"]["used"];
            $ret["in"]["limit_gb"] = $ret["in"]["limit"] / 1024;
            $ret["in"]["used_gb"] = $ret["in"]["used"] / 1024;
            $ret["in"]["free_gb"] = $ret["in"]["limit_gb"] - $ret["in"]["used_gb"];
            $ret["in"]["percent"] = $ret["in"]["used"] / ($ret["in"]["limit"] ? $ret["in"]["limit"] : 1) * 100;
            $ret["in"]["percent_free"] = 100 - $ret["in"]["percent"];
            $ret["out"]["used"] = array_sum($ret["out"]["usage"]);
            $ret["out"]["limit"] = $ret["out"]["used"] + 1;
            $ret["out"]["free"] = $ret["out"]["limit"] - $ret["out"]["used"];
            $ret["out"]["limit_gb"] = $ret["out"]["limit"] / 1024;
            $ret["out"]["used_gb"] = $ret["out"]["used"] / 1024;
            $ret["out"]["free_gb"] = $ret["out"]["limit_gb"] - $ret["out"]["used_gb"];
            $ret["out"]["percent"] = $ret["out"]["used"] / ($ret["out"]["limit"] ? $ret["out"]["limit"] : 1) * 100;
            $ret["out"]["percent_free"] = 100 - $ret["out"]["percent"];
            foreach ($ret as $k => $v) {
                if(is_numeric($ret[$k])) {
                    $ret[$k] = round($v, 2);
                }
            }
            $ret["in"]["used_gb"] = round($ret["in"]["used_gb"], 2);
            $ret["out"]["used_gb"] = round($ret["out"]["used_gb"], 2);
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=bandwidth&show=" . $show);
            if(!empty($details)) {
                $ret = $details["usage"]["bandwidth"];
            } else {
                return -1;
            }
        }
        return $ret;
    }
    public function vsbandwidth($serid, $ids, $show = "")
    {
        global $kernel;
        $band = [];
        if(empty($serid)) {
            foreach ($ids as $id) {
                $band[$id] = $kernel->bandwidth($id, $show);
            }
        } else {
            $details = $this->call($serid, "index.php?act=vsbandwidth");
            if(!empty($details)) {
                $band = $details["vpsusage"];
            } else {
                return -1;
            }
        }
        return $band;
    }
    public function resources($serid, $virt = "")
    {
        global $kernel;
        global $storages;
        global $globals;
        global $servers;
        if(empty($serid)) {
            if($serid != $globals["server"]) {
                $tmp_active_server = $globals["server"];
                set_active_server($serid);
            }
            list_storages();
            $ret = $kernel->resources($virt);
            if(!is_slave() || is_api_call(1)) {
                $ret["to_master_data"] = give_to_master_data();
            }
            foreach ($storages as $k => $v) {
                $tmp = storage_size($v["path"], $v["type"]);
                $ret["storages"][$k] = $v;
                $ret["storages"][$k]["size"] = $tmp["size"];
                $ret["storages"][$k]["free"] = $tmp["free"];
            }
            $ret["os_name"] = distro_name();
            $ret["licexpires_txt"] = $globals["licexpires_txt"];
            $ret["version"] = $globals["version"];
            $ret["patch"] = $globals["patch"];
            $ret["vs_bandwidth"] = [];
            $ret["virt"] = $globals["kernel"];
            $ret["os"] = $this->os($serid);
            $ret["server_time"] = time();
            vexec("swtpm --version", $o, $return);
            if($return == "0") {
                $ret["is_swtpm_installed"] = "1";
            }
            $ret["sys_load"] = system_load();
            $ret["vs_bandwidth"] = vps_used_bandwidth();
            $resid = makequery("SELECT ippid FROM ippool_servers\n\t\t\t\t\t\tWHERE sgid = :sgid\n\t\t\t\t\t\tOR serid IN ('-1', '0')", [":sgid" => $servers[0]["sgid"]]);
            $ippid = [];
            for ($i = 0; $i < vsql_num_rows($resid); $i++) {
                $row = vsql_fetch_assoc($resid);
                $ippid[] = $row["ippid"];
            }
            if(!empty($ippid)) {
                $ippid_token = vsql_in_tokens($ippid);
                $res = makequery("SELECT \n\t\t\t\t\t(SELECT COUNT(ips.ip) FROM ips, ippool WHERE ips.ippid = ippool.ippid AND ippool.internal = 0 AND ips.ipv6 = 0 AND ips.vpsid = 0 AND ips.locked = 0 AND ips.ippid in (" . $ippid_token["query"] . ")) AS ips, \n\t\t\t\t\t(SELECT COUNT(ip) FROM ips WHERE ipv6 = 1 AND vpsid = 0 AND ipr_netmask = '' AND locked = 0 AND ippid in (" . $ippid_token["query"] . ")) AS ipv6, \n\t\t\t\t\t(SELECT COUNT(ip) FROM ips WHERE ipr_netmask != '' AND vpsid = 0 AND locked = 0 AND ippid in (" . $ippid_token["query"] . ")) AS ipv6_subnet, \n\t\t\t\t\t(SELECT COUNT(ips.ip) FROM ips, ippool WHERE ips.ippid = ippool.ippid AND ippool.internal != 0 AND ips.vpsid = 0 AND ips.locked = 0 AND ips.ippid in (" . $ippid_token["query"] . ")) AS ips_int", $ippid_token["tokens"]);
                $row = vsql_fetch_assoc($res);
                $ret["ips"] = $row["ips"];
                $ret["ipv6"] = $row["ipv6"];
                $ret["ipv6_subnet"] = $row["ipv6_subnet"];
                $ret["ips_int"] = $row["ips_int"];
            }
            if(isset($tmp_active_server)) {
                set_active_server($tmp_active_server);
            }
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=resources" . (!empty($virt) ? "&virt=" . $virt : ""));
            if(!empty($details)) {
                $ret = $details["info"]["resources"];
                if(!empty($details["license_expired"])) {
                    $ret["license_expired"] = $details["license_expired"];
                }
            } else {
                $res = makequery("UPDATE servers\n\t\t\t\t\t\t\t\tSET status = :status\n\t\t\t\t\t\t\t\tWHERE serid = :serid", [":status" => 0, ":serid" => $serid]);
                return -1;
            }
        }
        $res = makequery("SELECT SUM(cores) as used_cores FROM vps WHERE serid = :serid", [":serid" => $serid]);
        $row = vsql_fetch_assoc($res);
        $ret["vcores"] = $row["used_cores"];
        if(!empty($ret["storages"][0]) && empty($globals["slave"])) {
            $st = $ret["storages"][0];
            $newstid = insert_and_id("INSERT INTO storage\n\t\t\t\t\t\tSET name = :name,\n\t\t\t\t\t\t`st_uuid` = :st_uuid,\n\t\t\t\t\t\tpath = :path,\n\t\t\t\t\t\t`type` = :type,\n\t\t\t\t\t\tformat = :format,\n\t\t\t\t\t\tsize = :size,\n\t\t\t\t\t\tfree = :free,\n\t\t\t\t\t\tprimary_storage = :primary_storage", [":name" => $st["name"], ":st_uuid" => generateRandStr(16), ":path" => $st["path"], ":type" => $st["type"], ":format" => $st["format"], ":size" => (int) $st["size"], ":free" => (int) $st["free"], ":primary_storage" => $st["primary_storage"]]);
            $res = insert_and_id("INSERT INTO storage_servers\n\t\t\t\t\t\tSET stid = :newstid,\n\t\t\t\t\t\tserid = :serid,\n\t\t\t\t\t\tsgid = '-2'", [":newstid" => $newstid, ":serid" => $serid]);
            update_vps_disks($serid, $newstid, $ret);
            $this->sync($serid);
        } else {
            foreach ($ret["storages"] as $k => $v) {
                $res = makequery("UPDATE storage\n\t\t\t\t\t\t\t\tSET size = :size,\n\t\t\t\t\t\t\t\tfree = :free\n\t\t\t\t\t\t\t\tWHERE stid = :stid", [":size" => (double) $v["size"], ":free" => (double) $v["free"], ":stid" => $k]);
            }
            if(!empty($ret["vs_bandwidth"])) {
                foreach ($ret["vs_bandwidth"] as $vid => $used_bandwidth) {
                    $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\tSET used_bandwidth = :used_bandwidth\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":used_bandwidth" => (double) $used_bandwidth, ":vpsid" => $vid]);
                }
            }
        }
        $total_space = 0;
        $free_space = 0;
        foreach ($ret["storages"] as $k => $v) {
            $total_space += $v["size"];
            $free_space += $v["free"];
        }
        $ret["total_space"] = round((double) $total_space, 2);
        $ret["space"] = round((double) $free_space, 2);
        $se_arr = [":total_ram" => empty($ret["total_ram"]) ? 0 : $ret["total_ram"], ":ram" => $ret["ram"], ":space" => $free_space, ":total_space" => $total_space, ":hvm" => empty($ret["hvm"]) ? 0 : 1, ":licnumvs" => $ret["licnumvs"], ":overcommit" => $ret["overcommit"], ":unique_txt" => empty($ret["unique_txt"]) ? "" : $ret["unique_txt"], ":checked" => time(), ":os" => $ret["os_name"], ":os_arch" => $ret["os"]["os_arch"], ":uname" => $ret["os"]["uname"], ":lic_expires" => $ret["licexpires_txt"], ":version" => $ret["version"], ":patch" => $ret["patch"], ":vcores" => $ret["vcores"], ":ips" => $ret["ips"], ":ipv6" => $ret["ipv6"], ":ipv6_subnet" => $ret["ipv6_subnet"], ":ips_int" => $ret["ips_int"], ":status" => empty($ret["license_expired"]) ? 1 : 2, ":sys_load" => $ret["sys_load"], ":serid" => $serid];
        if(!empty($ret["virt"])) {
            $se_arr[":virt"] = $ret["virt"];
        }
        $res = makequery("UPDATE servers\n\t\t\t\t\t\tSET total_ram = :total_ram,\n\t\t\t\t\t\tram = :ram,\n\t\t\t\t\t\tspace = :space,\n\t\t\t\t\t\ttotal_space = :total_space,\n\t\t\t\t\t\thvm = :hvm,\n\t\t\t\t\t\t" . (empty($ret["virt"]) ? "" : "virt = :virt,") . "\n\t\t\t\t\t\tlicnumvs = :licnumvs,\n\t\t\t\t\t\tovercommit = :overcommit,\n\t\t\t\t\t\tunique_txt = :unique_txt,\n\t\t\t\t\t\tchecked = :checked,\n\t\t\t\t\t\tos = :os,\n\t\t\t\t\t\tos_arch = :os_arch,\n\t\t\t\t\t\tuname = :uname,\n\t\t\t\t\t\tlic_expires = :lic_expires,\n\t\t\t\t\t\tversion = :version,\n\t\t\t\t\t\tpatch = :patch,\n\t\t\t\t\t\tvcores = :vcores,\n\t\t\t\t\t\tips = :ips,\n\t\t\t\t\t\tipv6 = :ipv6,\n\t\t\t\t\t\tipv6_subnet = :ipv6_subnet,\n\t\t\t\t\t\tips_int = :ips_int,\n\t\t\t\t\t\tsys_load = :sys_load,\n\t\t\t\t\t\tstatus = :status\n\t\t\t\t\t\tWHERE serid = :serid", $se_arr);
        if(!empty($ret["to_master_data"])) {
            save_to_master_data($ret["to_master_data"], $serid);
        }
        return $ret;
    }
    public function processes($serid)
    {
        $processes = [];
        if($serid == 0) {
            $ret = vexec("ps ax -eo pid,user,pcpu,pmem,rss,tty,stat,time,command", $r);
            foreach ($r as $k => $v) {
                $v = trim($v);
                if(strtolower(substr($v, 0, 3)) == "pid") {
                    $keys = preg_split("/\\s+/", trim($v));
                    unset($r[$k]);
                    $i = 0;
                    foreach ($r as $k => $v) {
                        $v = preg_split("/\\s+/", trim($v));
                        $_v = $v;
                        foreach ($_v as $kk => $vv) {
                            $tmp = $keys[$kk];
                            if(empty($tmp)) {
                                end($keys);
                                $processes[$i][current($keys)] .= " " . implode(" ", $v);
                                $i++;
                            } else {
                                $processes[$i][$tmp] = $vv;
                                unset($v[$kk]);
                            }
                        }
                    }
                } else {
                    unset($r[$k]);
                }
            }
        } else {
            $details = $this->call($serid, "index.php?act=processes");
            if(!empty($details)) {
                $processes = $details["processes"];
            } else {
                return -1;
            }
        }
        return $processes;
    }
    public function killprocess($serid, $pids)
    {
        if(!is_array($pids)) {
            $pids = [$pids];
        }
        if($serid == 0) {
            foreach ($pids as $k => $pid) {
                if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $pid)) {
                } else {
                    $ret = vexec("kill -9 " . $pid, $output);
                }
            }
        } else {
            $post = [];
            $post["stop_x"] = 1;
            $post["sel_proc"] = $pids;
            $details = $this->call($serid, "index.php?act=processes", 1, [], $post);
        }
        return true;
    }
    public function services($serid)
    {
        $services = [];
        if($serid == 0) {
            vexec("which systemctl", $out, $ret);
            if(empty($ret)) {
                vexec("systemctl list-units --type=service --state=running | awk '{\$1=\$1};1'", $tmp);
                foreach ($tmp as $serv) {
                    $parts = preg_split("/\\s+/is", $serv);
                    preg_match("/^(.+[^@])\\.service\$/is", $parts[0], $matches);
                    if(empty($matches[1]) || in_array($matches[1], ["virtualizor", "virtnetwork"])) {
                    } else {
                        $services[] = $matches[1];
                    }
                }
            } else {
                oexec("/sbin/runlevel", $tmp);
                $tmp = preg_replace("/(N|\\s)/", "", $tmp);
                vexec("/sbin/chkconfig --list", $chk);
                if(is_array($chk)) {
                    foreach ($chk as $v) {
                        if(!preg_match("/" . $tmp . "\\:(on|off)/is", $v)) {
                        } else {
                            $ser = preg_split("/\\s/is", $v);
                            oexec("/sbin/service " . $ser[0] . " status", $stat);
                            $stat = trim($stat);
                            if(preg_match("/stop/is", $stat) || empty($stat)) {
                            } else {
                                $services[] = $ser[0];
                            }
                        }
                    }
                }
            }
        } else {
            $details = $this->call($serid, "index.php?act=services");
            if(!empty($details)) {
                $services = $details["running"];
            }
        }
        return $services;
    }
    public function listautoservices($serid)
    {
        $services = [];
        if($serid == 0) {
            vexec("which systemctl", $out, $ret);
            if(empty($ret)) {
                vexec("systemctl list-unit-files --type=service --state=enabled", $tmp);
                foreach ($tmp as $serv) {
                    $parts = preg_split("/\\s+/is", $serv);
                    preg_match("/^(.+[^@])\\.service\$/is", $parts[0], $matches);
                    if(empty($matches[1]) || in_array($matches[1], ["virtualizor", "virtnetwork"])) {
                    } else {
                        $services[] = $matches[1];
                    }
                }
            } else {
                oexec("/sbin/runlevel", $tmp);
                $tmp = preg_replace("/(N|\\s)/", "", $tmp);
                vexec("/sbin/chkconfig --list", $chk);
                if(is_array($chk)) {
                    foreach ($chk as $v) {
                        if(!preg_match("/" . $tmp . "\\:on/is", $v)) {
                        } else {
                            $ser = preg_split("/\\s/is", $v);
                            $services[] = $ser[0];
                        }
                    }
                }
            }
        } else {
            $details = $this->call($serid, "index.php?act=services");
            if(!empty($details)) {
                $services = $details["autostart"];
            }
        }
        return $services;
    }
    public function dotoservice($serid, $sers, $do)
    {
        global $kernel;
        global $servers;
        ignore_user_abort(true);
        if(!is_array($sers)) {
            $sers = [$sers];
        }
        if($serid == 0) {
            foreach ($sers as $k => $ser) {
                if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $ser)) {
                } elseif($ser == "httpd" || $ser == "nginx" || $ser == "webserver") {
                    $ret = vexec("/usr/local/emps/bin/nginxctl " . $do, $output);
                } elseif($ser == "mysqld") {
                    $ret = vexec("/usr/local/emps/bin/mysqlctl " . $do, $output);
                } else {
                    if($ser == "network" && server_virt(0, "kvm") == "kvm") {
                        $ser = "virtnetwork";
                    }
                    vexec("which systemctl", $out, $ret);
                    if(empty($ret)) {
                        $ret = vexec("systemctl " . $do . " " . $ser . ".service", $output);
                    } else {
                        $ret = vexec("/etc/init.d/" . $ser . " " . $do, $output);
                    }
                }
            }
        } else {
            $post = [];
            $post["action"] = $do;
            $post["sel_serv"] = $sers;
            $details = $this->call($serid, "index.php?act=services", 1, [], $post);
        }
        return true;
    }
    public function listips($serid)
    {
        global $servers;
        global $globals;
        if($serid == 0) {
            $tmp = explode(":", $globals["primary_ip"]);
            $ips[0] = $tmp[0];
        } else {
            $ips[0] = $servers[$serid]["ip"];
        }
        return $ips;
    }
    public function os($serid)
    {
        global $globals;
        $ret = [];
        if($serid == 0) {
            oexec("uname -a", $tmparch);
            $arch = preg_match("/(amd64|x86_64)/is", $tmparch) ? "x86_64" : "x86";
            $ret["os_arch"] = $arch;
            $ret["uname"] = trim($tmparch);
            if(empty($globals["distro"])) {
                $file = "/etc/redhat-release";
                oexec("cat " . $file, $tmp);
                preg_match("/(\\w+)(.*?)(\\d\\.(\\d+))/is", $tmp, $matches);
                if(empty($matches)) {
                    preg_match("/(\\w+)(.*?)(\\d+)/is", $tmp, $matches);
                }
                $ver = $matches[3];
                $distro = strtolower($matches[1]);
                $ret["distro"] = $distro;
                $ret["name"] = $distro . "-" . (empty($ver) ? "x.x" : $ver) . "-" . $arch;
            } elseif(preg_match("/proxmox/is", $globals["distro"])) {
                oexec("pveversion", $tmp);
                $ret["distro"] = "proxmox";
                $ret["name"] = trim($tmp);
            } else {
                oexec("lsb_release -r", $ver);
                preg_match("/^Release:(.*?)\$/is", $ver, $out);
                oexec("lsb_release -d | awk '{print \$2}'", $dist);
                $ret["distro"] = strtolower($dist);
                $ret["name"] = $ret["distro"] . "-" . (empty($out) ? "x.x" : trim($out[1])) . "-" . $arch;
            }
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=os");
            if(!empty($details)) {
                $ret = $details["info"]["os"];
            } else {
                return -1;
            }
        }
        return $ret;
    }
    public function hostname($serid)
    {
        if($serid == 0) {
            oexec("hostname", $hostname);
            return $hostname;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=hostname");
        if(!empty($details)) {
            return $details["info"]["hostname"];
        }
        return -1;
    }
    public function status($serid)
    {
        if($serid == 0) {
            return 1;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=status");
        if(empty($details)) {
            return 0;
        }
        return 1;
    }
    public function statewise($serid)
    {
        if($serid == 0) {
            return 1;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=statewise");
        if(!empty($details["license_expired"])) {
            return 2;
        }
        if(empty($details)) {
            return 0;
        }
        return 1;
    }
    public function uptime($serid)
    {
        if($serid == 0) {
            oexec("/usr/bin/uptime", $uptime);
            return $uptime;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=uptime");
        if(!empty($details)) {
            return $details["info"]["uptime"];
        }
        return -1;
    }
    public function servers()
    {
        return list_servers();
    }
    public function vm_location($serid, $array)
    {
        global $kernel;
        global $globals;
        if($serid == 0) {
            return $kernel->vm_location($array);
        }
        $tmp = $this->call($serid, "index.php?act=apidoings&do=vm_location", 1, [], ["array" => $array]);
        return $tmp["vm_location"];
    }
    public function vps_status($array, $live = 1)
    {
        global $kernel;
        global $globals;
        if(!empty($globals["is_cloud"])) {
            $array = $kernel->vm_location($array);
        }
        $serverwise = [];
        foreach ($array as $k => $v) {
            $serverwise[$v][] = $k;
        }
        foreach ($serverwise as $ser => $v) {
            $_v = [];
            if($ser == 0) {
                $serverwise[$ser] = $kernel->status($v, $live);
            } else {
                foreach ($v as $kk => $vv) {
                    $_v[$vv] = 0;
                }
                $tmp = $this->call($ser, "index.php?act=apidoings&do=vps_status", 1, $_v);
                $serverwise[$ser] = [];
                if(empty($tmp["vps_status"])) {
                    $serverwise[$ser] = $_v;
                } else {
                    $serverwise[$ser] = $tmp["vps_status"];
                }
            }
        }
        $ret = [];
        foreach ($serverwise as $ser => $v) {
            foreach ($v as $kk => $vv) {
                $ret[$kk] = $vv;
            }
        }
        return $ret;
    }
    public function vps_status_statewise($array, $live = 1)
    {
        global $kernel;
        global $globals;
        if(!empty($globals["is_cloud"])) {
            $array = $kernel->vm_location($array);
        }
        $serverwise = [];
        foreach ($array as $k => $v) {
            $serverwise[$v][] = $k;
        }
        foreach ($serverwise as $ser => $v) {
            $_v = [];
            if($ser == 0) {
                $serverwise[$ser] = $kernel->vps_status_statewise($v, $live);
            } else {
                foreach ($v as $kk => $vv) {
                    $_v[$vv] = 0;
                }
                $tmp = $this->call($ser, "index.php?act=apidoings&do=vps_status_statewise", 1, $_v);
                $serverwise[$ser] = [];
                if(empty($tmp["vps_status_statewise"])) {
                    $serverwise[$ser] = $_v;
                } else {
                    $serverwise[$ser] = $tmp["vps_status_statewise"];
                }
            }
        }
        $ret = [];
        foreach ($serverwise as $ser => $v) {
            foreach ($v as $kk => $vv) {
                $ret[$kk] = $vv;
            }
        }
        return $ret;
    }
    public function destroyvps($vpsid)
    {
        global $kernel;
        global $globals;
        global $l;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            $res = makequery("DELETE FROM bandwidth WHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
            $res = makequery("DELETE FROM `status` WHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
            $res = makequery("DELETE FROM `system_alerts` WHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
            if(!empty($globals["enable_backup_delete"]) && !empty($vps["bpid"])) {
                if(empty($globals["enable_backup_delete_cron"])) {
                    del_vps_backup($vps);
                } else {
                    $del_time = time() + (int) $globals["enable_backup_delete_cron"] * 86400;
                    $data = ["vps" => $vps, "del_time" => $del_time];
                    $actid_ = vps_task("delete_backup_cron", serialize($data), 0, $vpsid, $vps["uid"], 0, $l["enable_backup_delete_update_task"] . datify($del_time));
                }
            }
            if(!empty($vps["fwid"]) || !empty($vps["admin_fwid"])) {
                $firewall_ids = [$vps["fwid"], $vps["admin_fwid"]];
                $res = makequery("SELECT rules, default_policy FROM firewall_plans WHERE fwid IN('" . implode("','", $firewall_ids) . "')");
                if(0 < vsql_num_rows($res)) {
                    for ($i = 0; $i < vsql_num_rows($res); $i++) {
                        $row = vsql_fetch_assoc($res);
                        $firewall_data["rules"] = $row["rules"];
                        $firewall_data["policy"] = [$row["default_policy"]];
                        $this->delete_vpsfirewall_rule(0, [$vps["vpsid"]], $firewall_data);
                    }
                }
            }
            return $kernel->destroyvps($vpsid);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=destroyvps&vpsid=" . $vpsid . (defined("DONT_DESTROY_LIVE_MIG_VM") ? "&DONT_DESTROY_LIVE_MIG_VM=1" : ""), 1);
        if(empty($details["destroyvps"])) {
            return false;
        }
        $this->reverse_sync($vps["serid"]);
        return $details["destroyvps"];
    }
    public function bandwidth_reset($vpsid)
    {
        global $kernel;
        global $globals;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            $month["yr"] = datify(time(), 0, 1, "Y");
            $month["month"] = datify(time(), 0, 1, "m");
            $month["day"] = datify(time(), 0, 1, "d");
            $last_yr_month = date("Ym", strtotime("-1 month"));
            $end_date = $month["yr"] . $month["month"] . $month["day"];
            if(!empty($globals["band_calc_creation"])) {
                $creation_day = datify($vps["time"], 0, 1, "d");
                if($month["day"] < $creation_day) {
                    $start_date = (int) $last_yr_month . $creation_day;
                } else {
                    $start_date = (int) $month["yr"] . $month["month"] . $creation_day;
                }
            } else {
                $start_date = $month["yr"] . $month["month"] . "01";
            }
            makequery("UPDATE bandwidth SET\n\t\t\t\t\t\t`in` = :in,\n\t\t\t\t\t\t`out` = :out\n\t\t\t\t\t\tWHERE vpsid = :vpsid \n\t\t\t\t\t\tAND date >= :start_date\n\t\t\t\t\t\tAND date <= :end_date", [":in" => 0, ":out" => 0, ":vpsid" => $vpsid, ":start_date" => $start_date, ":end_date" => $end_date]);
            $bandwidth_val = $kernel->bandwidth($vpsid);
            $GLOBAL["DONT_ECHO"] = 1;
            handle_speed_cap($vps, $kernel, $bandwidth_val);
            unset($GLOBAL["DONT_ECHO"]);
            if(file_exists($globals["var"] . "/eubwthreshold/" . $vpsid) && is_safe_file($globals["var"] . "/eubwthreshold/" . $vpsid)) {
                @unlink($globals["var"] . "/eubwthreshold/" . $vpsid);
            }
        } else {
            $details = $this->call($vps["serid"], "index.php?act=apidoings&do=bandwidth_reset&vpsid=" . $vpsid, 1);
            if(empty($details)) {
                return false;
            }
        }
        if(!empty($vpsid)) {
            if(!empty($vps["speed_cap"])) {
                $vps["speed_cap"] = serialize(["up" => $vps["speed_cap"]["up"], "down" => $vps["speed_cap"]["down"]]);
            }
            $res = makequery("UPDATE vps\n\t\t\t\t\t\t\tSET used_bandwidth = 0, speed_cap = :speed_cap\n\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $vpsid, ":speed_cap" => $vps["speed_cap"]]);
        }
    }
    public function new_vps_name($serid, $VIRT, $vps_name = "")
    {
        global $error;
        global $kernel;
        global $l;
        if($serid == 0) {
            return $kernel->new_vps_name($VIRT, $vps_name);
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=new_vps_name&virt=" . $VIRT . "&vps_name=" . $vps_name, 1);
        if(empty($details)) {
            $error[] = "API call for new_vps_name failed";
            return false;
        }
        return $details["new_vps_name"];
    }
    public function check_vps_data($serid, $data, $edit = false)
    {
        global $error;
        global $kernel;
        global $l;
        if($serid == 0) {
            return $kernel->new_vps_name($data["virt"], $data["vps_name"]);
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=check_vps_data", 1, $data);
        if(empty($details)) {
            $error[] = $l["cvd_off"];
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["check_vps_data"];
    }
    public function startvps($serid, $vpsid)
    {
        global $kernel;
        global $user;
        global $l;
        $creater_uid = empty($GLOBALS["creater_uid"]) ? $user["uid"] : $GLOBALS["creater_uid"];
        if($serid == 0) {
            $ret = $kernel->start($vpsid, $ret_code);
            vexec("iptables -t filter -D FORWARD -j VM_TRAFFIC_FORWARD ;\n\t\t\tiptables -t filter -I FORWARD -j VM_TRAFFIC_FORWARD ;\n\t\t\tiptables -t filter -P FORWARD ACCEPT;", $o, $r);
            $GLOBALS["start_ret_code"] = $ret_code;
        } else {
            $actid = vps_task("start_vps", "", 0, $vpsid, $creater_uid, 0, $l["task_started"]);
            task_start($actid);
            _task_update($actid, $l["start_vps_slave"], 57, "group");
            task_update($actid, "", 57, "", "start_vps");
            $details = $this->call($serid, "index.php?act=apidoings&do=startvps&vpsid=" . $vpsid, 1);
            $ret = $details["startvps"];
            $ret["taskid"] = $actid;
            $ret_code = $details["startvps_ret"];
            $this->reverse_sync($serid);
            $_log = empty($ret["output"]) ? "Return code : " . $ret_code : $ret;
            $status = 100;
            if($ret_code != 0) {
                $status = -1;
            }
            _task_update($actid, print_r($_log, 1), $status);
            _task_update($actid, "", $status, "group_end");
        }
        return $ret;
    }
    public function stopvps($serid, $vpsid)
    {
        global $kernel;
        global $user;
        global $l;
        global $globals;
        global $creater_uid;
        if(!empty($globals["is_cloud"])) {
            $array = $kernel->vm_location([$vpsid => $serid]);
        }
        if($serid == 0) {
            $ret = $kernel->stop($vpsid);
        } else {
            $actid = vps_task("stop_vps", "", 0, $vpsid, $creater_uid, 0, $l["task_started"]);
            task_start($actid);
            _task_update($actid, $l["stop_vps_slave"], 57, "group");
            task_update($actid, "", 57, "", "stop_vps");
            $details = $this->call($serid, "index.php?act=apidoings&do=stopvps&vpsid=" . $vpsid, 1);
            $ret = $details["stopvps"];
            $ret["taskid"] = $actid;
            $this->reverse_sync($serid);
            if(empty($ret["output"])) {
                _task_update($actid, $l["completed"], 100, "group_end");
                return false;
            }
            _task_update($actid, $l["completed"], 100, "group_end");
        }
        return $ret;
    }
    public function restartvps($serid, $vpsid)
    {
        global $kernel;
        global $user;
        global $l;
        global $creater_uid;
        if($serid == 0) {
            $ret = $kernel->restart($vpsid);
        } else {
            $actid = vps_task("restart_vps", "", 0, $vpsid, $creater_uid, 0, $l["task_started"]);
            task_start($actid);
            _task_update($actid, $l["restart_vps_slave"], 57, "group");
            task_update($actid, "", 57, "", "restart_vps");
            $details = $this->call($serid, "index.php?act=apidoings&do=restartvps&vpsid=" . $vpsid, 1);
            $ret = $details["restartvps"];
            $ret["taskid"] = $actid;
            $this->reverse_sync($serid);
            if(empty($ret["output"])) {
                _task_update($actid, $l["completed"], 100, "group_end");
                return false;
            }
            _task_update($actid, $l["completed"], 100, "group_end");
        }
        return $ret;
    }
    public function poweroffvps($serid, $vpsid)
    {
        global $kernel;
        global $user;
        global $l;
        global $creater_uid;
        if($serid == 0) {
            $ret = $kernel->poweroff($vpsid);
        } else {
            $actid = vps_task("poweroff_vps", "", 0, $vpsid, $creater_uid, 0, $l["task_started"]);
            task_start($actid);
            _task_update($actid, $l["poweroff_vps_slave"], 57, "group");
            task_update($actid, "", 57, "", "poweroff_vps");
            $details = $this->call($serid, "index.php?act=apidoings&do=poweroffvps&vpsid=" . $vpsid, 1);
            $ret = $details["poweroffvps"];
            $ret["taskid"] = $actid;
            $this->reverse_sync($serid);
            if(empty($ret["output"])) {
                _task_update($actid, $l["completed"], 100, "group_end");
                return false;
            }
            task_update($actid, $l["completed"], 100, "group_end");
        }
        return $ret;
    }
    public function createvps($vpsid)
    {
        global $kernel;
        global $error;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->createvps($vpsid);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=createvps&vpsid=" . $vpsid . (defined("CREATE_DISK_MIGRATE") ? "&CREATE_DISK_MIGRATE=1" : "") . (defined("DONT_DD_OS_TEMPLATE") ? "&DONT_DD_OS_TEMPLATE=1" : ""), 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["createvps"])) {
            return false;
        }
        return $details["createvps"];
    }
    public function osreinstall($vpsid, $format_primary = 0)
    {
        global $kernel;
        global $error;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->osreinstall($vpsid, $format_primary);
        }
        $post = [];
        $post["format_primary"] = $format_primary;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=osreinstall&vpsid=" . $vpsid, 1, [], $post);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["osreinstall"])) {
            return false;
        }
        $this->reverse_sync($vps["serid"]);
        return $details["osreinstall"];
    }
    public function editvps($vpsid)
    {
        global $kernel;
        $vps = getvps($vpsid, 0);
        if($vps["serid"] == 0) {
            return $kernel->editvps($vpsid);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=editvps&vpsid=" . $vpsid, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["editvps"])) {
            return false;
        }
        return $details["editvps"];
    }
    public function remote_desktop($vpsid, $rdp)
    {
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->remotedesktop($vpsid, $rdp);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=remote_desktop&vpsid=" . $vpsid . "&rdp=" . $rdp, 1);
        if(empty($details["remote_desktop"])) {
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["remote_desktop"];
    }
    public function change_vps_pass($vpsid, $pass, $vm_username = "")
    {
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->changepassword($vpsid, $pass, 0, $vm_username);
        }
        $post["vpspass"] = $pass;
        $post["vm_username"] = $vm_username;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=change_vps_pass&vpsid=" . $vpsid, 1, [], $post);
        if(empty($details["change_vps_pass"])) {
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["change_vps_pass"];
    }
    public function change_vnc_pass($vpsid, $pass)
    {
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->changeVncPass($vpsid, $pass);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=change_vnc_pass&vpsid=" . $vpsid . "&vncpass=" . rawurlencode($pass), 1);
        if(empty($details["change_vnc_pass"])) {
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["change_vnc_pass"];
    }
    public function change_vps_hostname($vpsid, $hostname)
    {
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->changehostname($vpsid, $hostname);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=change_vps_hostname&vpsid=" . $vpsid . "&hostname=" . rawurlencode($hostname), 1);
        if(empty($details["change_vps_hostname"])) {
            return false;
        }
        return $details["change_vps_hostname"];
    }
    public function install_xentools($vpsid)
    {
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->install_xentools($vpsid);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=install_xentools&vpsid=" . $vpsid, 1);
        if(empty($details["install_xentools"])) {
            return false;
        }
        return $details["install_xentools"];
    }
    public function vpsconf($vpsid)
    {
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->getconf($vpsid);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=vpsconf&vpsid=" . $vpsid, 1);
        if(empty($details["vpsconf"])) {
            return false;
        }
        return $details["vpsconf"];
    }
    public function reboot($serid)
    {
        global $kernel;
        if($serid == 0) {
            vexec("reboot", $out, $ret);
            if($ret != "0") {
                return false;
            }
            return true;
        }
        $details = $this->call($serid, "index.php?act=manageserver&reboot=1", 1);
        if(empty($details["rebooted"])) {
            return false;
        }
        return true;
    }
    public function serverdetails($ip, $pass)
    {
        if(!valid_ip($ip) || empty($pass)) {
            return false;
        }
        return make_api_call($ip, $pass, "index.php?act=makeslave");
    }
    public function check_duplicate_entries($ip, $pass, $id, $ret, $keys = [])
    {
        global $globals;
        if(empty($ret)) {
            return false;
        }
        $data = [];
        $data["setslave"] = $id;
        $data["masterkey"] = $globals["key"];
        $data["keys"] = $keys;
        $post = [];
        $post["ret"] = $ret;
        return make_api_call($ip, $pass, "index.php?act=makeslave&check_duplicate_entries=1&" . generateRandStr(8), $data, $post);
    }
    public function setslave($ip, $pass, $id, $keys = [])
    {
        global $globals;
        clearstatcache();
        $data = [];
        $data["setslave"] = $id;
        $data["masterkey"] = $globals["key"];
        $data["keys"] = $keys;
        return make_api_call($ip, $pass, "index.php?act=makeslave&do=1&" . generateRandStr(8), $data);
    }
    public function unslave($delete, $force = "")
    {
        global $globals;
        global $servers;
        $data = [];
        $data["salveid"] = $delete;
        $data["masterkey"] = $globals["key"];
        if(empty($force)) {
            $sres = $this->sync($delete);
            if(empty($sres)) {
                return false;
            }
            $details = $this->call($delete, "index.php?act=makeslave&do=3", 1, $data);
            if(empty($details["unslaved"])) {
                if(!empty($details["error"])) {
                    $this->adderror($details["error"]);
                }
                return false;
            }
        } else {
            $sres = $this->sync($delete);
            $details = $this->call($delete, "index.php?act=makeslave&do=3", 1, $data);
        }
        $res = makequery("SELECT * FROM vps WHERE serid = :serid", [":serid" => $delete]);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vps[$row["vpsid"]] = $row;
            $vps_uuids[$row["uuid"]] = $row["uuid"];
        }
        $vpsids_tokens["tokens"] = [];
        if(!empty($vps)) {
            $vpsids_tokens = vsql_in_tokens(array_keys($vps));
        }
        $vpsids = empty($vps) ? -1 : $vpsids_tokens["query"];
        $res = makequery("DELETE FROM vps WHERE serid = :serid", [":serid" => $delete]);
        $vps_uuids_tokens["tokens"] = [];
        if(!empty($vps_uuids)) {
            $vps_uuids_tokens = vsql_in_tokens(array_keys($vps_uuids));
        }
        $res = makequery("DELETE FROM disks WHERE vps_uuid IN ('-1' " . (!empty($vps_uuids) ? $vps_uuids_tokens["query"] : "") . ")", $vps_uuids_tokens["tokens"]);
        $res = makequery("DELETE FROM servers WHERE serid = :serid", [":serid" => $delete]);
        $res = makequery("SELECT * FROM ippool_servers WHERE serid = :serid", [":serid" => $delete]);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $ippools[$row["ippid"]] = $row;
        }
        $ippids_tokens["tokens"] = [];
        if(!empty($ippools)) {
            $ippids_tokens = vsql_in_tokens(array_keys($ippools));
        }
        $ippids = empty($ippools) ? -1 : $ippids_tokens["query"];
        $res = makequery("SELECT * FROM ippool_servers WHERE serid != '" . $delete . "' AND ippid IN (" . $ippids . ")", $ippids_tokens["tokens"]);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            unset($ippools[$row["ippid"]]);
        }
        $ippids_tokens["tokens"] = [];
        if(!empty($ippools)) {
            $ippids_tokens = vsql_in_tokens(array_keys($ippools));
        }
        $ippids = empty($ippools) ? -1 : $ippids_tokens["query"];
        $res = makequery("DELETE FROM ippool WHERE ippid IN (" . $ippids . ")", $ippids_tokens["tokens"]);
        $res = makequery("DELETE FROM ips WHERE ippid IN (" . $ippids . ")", $ippids_tokens["tokens"]);
        $res = makequery("DELETE FROM ippool_servers WHERE serid = :serid", [":serid" => $delete]);
        $res = makequery("UPDATE ips SET vpsid = 0 WHERE vpsid IN (" . $vpsids . ")", $vpsids_tokens["tokens"]);
        $res = makequery("DELETE FROM vpsbackup_settings WHERE serid = :serid", [":serid" => $delete]);
        $res = makequery("DELETE FROM `passthrough` WHERE serid = :serid", [":serid" => $delete]);
        $res = makequery("SELECT * FROM storage_servers WHERE serid = :serid", [":serid" => $delete]);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $_storages[$row["stid"]] = $row;
        }
        $stids_tokens["tokens"] = [];
        if(!empty($_storages)) {
            $stids_tokens = vsql_in_tokens(array_keys($_storages));
        }
        $stids = empty($_storages) ? -1 : $stids_tokens["query"];
        $res = makequery("SELECT * FROM storage_servers WHERE serid != '" . $delete . "' AND stid IN (" . $stids . ")", $stids_tokens["tokens"]);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            unset($_storages[$row["stid"]]);
        }
        $stids_tokens["tokens"] = [];
        if(!empty($_storages)) {
            $stids_tokens = vsql_in_tokens(array_keys($_storages));
        }
        $stids = empty($_storages) ? -1 : $stids_tokens["query"];
        $res = makequery("DELETE FROM storage WHERE stid IN (" . $stids . ")", $stids_tokens["tokens"]);
        $res = makequery("DELETE FROM storage_servers WHERE serid = :serid", [":serid" => $delete]);
        $res = makequery("DELETE FROM haproxy WHERE serid = :serid", [":serid" => $delete]);
        return true;
    }
    public function sync($serid, $tables = [])
    {
        if($serid == 0) {
            return true;
        }
        $post["data"] = sync($serid, $tables);
        $details = $this->call($serid, "index.php?act=apidoings&do=sync", 1, [], $post);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["sync"])) {
            return false;
        }
        return true;
    }
    public function call($serid, $path, $live = false, $data = [], $post = [])
    {
        global $servers;
        global $servers_keypass;
        if(empty($servers[$serid])) {
            return false;
        }
        if(!empty($this->calls[$serid][$path]) && empty($live)) {
            return $this->calls[$serid][$path];
        }
        $this->calls[$serid][$path] = make_api_call($servers[$serid]["ip"], $servers_keypass[$serid]["pass"], $path, $data, $post);
        return $this->calls[$serid][$path];
    }
    public function serverglobals($serid)
    {
        global $globals;
        if($serid == 0) {
            return $globals;
        }
        $details = $this->call($serid, "index.php?act=makeslave");
        if(!empty($details["globals"])) {
            return $details["globals"];
        }
        return false;
    }
    public function whmcsstatus($serid)
    {
        global $globals;
        if($serid == 0) {
            $load = file_get_contents("/proc/loadavg");
            $load = explode(" ", $load);
            $load = $load[0];
            if(!$load && function_exists("exec")) {
                $reguptime = trim(exec("uptime"));
                if($reguptime && preg_match("/, *(\\d) (users?), .*: (.*), (.*), (.*)/", $reguptime, $uptime)) {
                    $load = $uptime[3];
                }
            }
            $uptime_text = file_get_contents("/proc/uptime");
            $uptime = substr($uptime_text, 0, strpos($uptime_text, " "));
            if(!$uptime && function_exists("shell_exec")) {
                $uptime = shell_exec("cut -d. -f1 /proc/uptime");
            }
            $days = floor($uptime / 60 / 60 / 24);
            $hours = str_pad($uptime / 60 / 60 % 24, 2, "0", STR_PAD_LEFT);
            $mins = str_pad($uptime / 60 % 60, 2, "0", STR_PAD_LEFT);
            $secs = str_pad($uptime % 60, 2, "0", STR_PAD_LEFT);
            $phpver = phpversion();
            $mysqlver = vsql_get_client_info();
            $zendver = function_exists("zend_version") ? zend_version() : "-";
            $data = "<load>" . $load . "</load>\n<uptime>" . $days . " Days " . $hours . ":" . $mins . ":" . $secs . "</uptime>\n<phpver>" . $phpver . "</phpver>\n<mysqlver>" . $mysqlver . "</mysqlver>\n<zendver>" . $zendver . "</zendver>\n";
            return $data;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=whmcsstatus", 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["whmcsstatus"])) {
            return false;
        }
        return $details["whmcsstatus"];
    }
    public function change_hostname($serid, $host)
    {
        global $globals;
        global $servers;
        if($serid == 0) {
            $virt = $servers[$serid]["virt"];
            if(preg_match("/xcp/is", $virt)) {
                oexec("source /etc/xensource-inventory; echo \$INSTALLATION_UUID", $output);
                if(!$output) {
                    return false;
                }
                vexec("xe host-set-hostname-live host-name=" . $host . " host-uuid=" . $output . " host-name=" . $host, $out, $ret);
                if($ret != "0") {
                    return false;
                }
                vexec("xe host-param-set name-label=" . $host . " uuid=" . $output, $out, $ret);
                if($ret != "0") {
                    return false;
                }
                return true;
            }
            vexec("hostname " . $host);
            if(is_file("/etc/hostname")) {
                writefile("/etc/hostname", $host . "\n", 1);
                return true;
            }
            $file = file("/etc/sysconfig/network");
            foreach ($file as $k => $v) {
                if(preg_match("/hostname(\\s*?)=(\\s*?)(.*?)/is", $v)) {
                    $found = 1;
                    $file[$k] = "HOSTNAME=" . $host . "\n";
                }
            }
            if(empty($found)) {
                $file[] = "HOSTNAME=" . $host . "\n";
            }
            writefile("/etc/sysconfig/network", implode("", $file), 1);
            return true;
        } else {
            $post = [];
            $post["newhost"] = $host;
            $post["changehost"] = "Change Hostname";
            $details = $this->call($serid, "index.php?act=hostname", 1, [], $post);
            if(!empty($details["done"])) {
                return true;
            }
            return false;
        }
    }
    public function ssl_get($serid)
    {
        global $kernel;
        global $globals;
        if($serid == 0) {
            global $globals;
            $ret = [];
            $ret["keyconf"] = @implode("", @file($globals["path"] . "/conf/virtualizor.key"));
            $ret["crtconf"] = @implode("", @file($globals["path"] . "/conf/virtualizor.crt"));
            $ret["csrconf"] = @implode("", @file($globals["path"] . "/conf/virtualizor.csr"));
            $ret["cert_bundle"] = @implode("", @file($globals["path"] . "/conf/virtualizor-bundle.crt"));
            $ret["cert_bundle"] = "";
            return $ret;
        }
        $details = $this->call($serid, "index.php?act=ssl", 1);
        if(empty($details)) {
            return false;
        }
        return $details;
    }
    public function ssl_save($serid, $crtinfo, $keyinfo, $bundle = "")
    {
        global $globals;
        global $kernel;
        global $error;
        if($serid == 0) {
            ignore_user_abort(true);
            writefile("/tmp/virtualizor.key", $keyinfo, 1);
            writefile("/tmp/virtualizor.crt", $crtinfo, 1);
            $ret = vexec("/usr/local/emps/bin/openssl verify /tmp/virtualizor.crt", $check_crt);
            vexec("/bin/rm -rf /tmp/virtualizor.crt");
            if(empty($check_crt)) {
                $error["inv_crt"] = 1;
            }
            $ret = vexec("/usr/local/emps/bin/openssl rsa -in /tmp/virtualizor.key -check", $check_key);
            vexec("/bin/rm -rf /tmp/virtualizor.key");
            if(empty($check_key)) {
                $error["inv_key"] = 1;
            }
            if(!empty($error["inv_key"]) || !empty($error["inv_crt"])) {
                return false;
            }
            writefile($globals["path"] . "/conf/virtualizor.key", $keyinfo, 1);
            writefile($globals["path"] . "/conf/virtualizor.crt", $crtinfo . "\n\n" . $bundle, 1);
            writefile($globals["path"] . "/conf/virtualizor-bundle.crt", $bundle, 1);
            return true;
        }
        $post["savessl"] = "Yes";
        $post["cert_key"] = $keyinfo;
        $post["cert_crt"] = $crtinfo;
        $post["cert_bundle"] = $bundle;
        $details = $this->call($serid, "index.php?act=ssl", 1, [], $post);
        if(!empty($details["error"]["inv_key"])) {
            $error["inv_key"] = 1;
        }
        if(!empty($details["error"]["inv_crt"])) {
            $error["inv_crt"] = 1;
        }
        if(empty($details["done"])) {
            return false;
        }
        return true;
    }
    public function createssl($serid, $country, $state, $locality, $organisation, $org_unit, $comname, $email, $key_size)
    {
        global $globals;
        global $kernel;
        if($serid == 0) {
            ignore_user_abort(true);
            vexec("/usr/local/emps/bin/openssl genrsa -out " . $globals["path"] . "/conf/virtualizor.key " . $key_size, $s1);
            $s1 = implode("", $s1);
            vexec("/usr/local/emps/bin/openssl req -subj /C='" . $country . "'/ST='" . $state . "'/L='" . $locality . "'/O='" . $organisation . "'" . (!empty($org_unit) ? "/OU='" . $org_unit . "'" : "") . "/CN='" . $comname . "'/emailAddress='" . $email . "' -new -key " . $globals["path"] . "/conf/virtualizor.key -out " . $globals["path"] . "/conf/virtualizor.csr", $s2);
            $s2 = implode("", $s2);
            vexec("/usr/local/emps/bin/openssl x509 -req -days 365 -in " . $globals["path"] . "/conf/virtualizor.csr -signkey " . $globals["path"] . "/conf/virtualizor.key -out " . $globals["path"] . "/conf/virtualizor.crt", $s3);
            $s3 = implode("", $s3);
            $s4 = implode("", $s4);
            return true;
        }
        $post = [];
        $post["country"] = $country;
        $post["state"] = $state;
        $post["locality"] = $locality;
        $post["organisation"] = $organisation;
        $post["orgunit"] = $org_unit;
        $post["comname"] = $comname;
        $post["email"] = $email;
        $post["keysize"] = $key_size;
        $post["create"] = "Create SSL";
        $details = $this->call($serid, "index.php?act=createssl", 1, [], $post);
        if(!empty($details["done"])) {
            return true;
        }
        return false;
    }
    public function kernel_conf_file($serid)
    {
        global $servers;
        $virt = $servers[$serid]["virt"];
        if(empty($virt)) {
            return false;
        }
        if(preg_match("/openvz/is", $virt)) {
            $conf_file = "/etc/vz/vz.conf";
        } elseif(preg_match("/xen/is", $virt)) {
            $conf_file = "/etc/xen/xend-config.sxp";
        } elseif(preg_match("/kvm/is", $virt)) {
            $conf_file = "/etc/libvirt/qemu.conf";
        } elseif(preg_match("/xcp/is", $virt)) {
            $conf_file = "/etc/xen/oxenstored.conf";
        }
        return $conf_file;
    }
    public function kernelconf($serid)
    {
        global $globals;
        global $kernel;
        if($serid == 0) {
            $conf_file = $this->kernel_conf_file($serid);
            $kernelconf = implode("", file($conf_file));
            return $kernelconf;
        }
        $details = $this->call($serid, "index.php?act=kernelconf");
        if(!empty($details)) {
            return $details["kernelconf"];
        }
        return false;
    }
    public function kernelconf_save($serid, $confinfo)
    {
        global $kernel;
        if($serid == 0) {
            $conf_file = $this->kernel_conf_file($serid);
            writefile($conf_file, $confinfo, 1);
            return true;
        }
        $post["saveconf"] = "Yes";
        $post["confinfo"] = $confinfo;
        $details = $this->call($serid, "index.php?act=kernelconf", 1, [], $post);
        if(!empty($details["done"])) {
            return true;
        }
        return false;
    }
    public function license_info($serid)
    {
        global $globals;
        if($serid == 0) {
            $info = $globals;
            $info["SERVER_ADDR"] = $_SERVER["SERVER_ADDR"];
            return $info;
        }
        $details = $this->call($serid, "index.php?act=license");
        if(!empty($details["info"])) {
            return $details["info"];
        }
        return false;
    }
    public function license_update($serid, $lickey)
    {
        global $globals;
        global $l;
        global $error;
        if($serid == 0) {
            $details = [];
            $license_contents_ser = get_web_file(LIC_URL . "license=" . $lickey);
            if(empty($license_contents_ser)) {
                $details["error"] = $l["lic_error"];
                return $details;
            }
            $license_contents = sm_decode($license_contents_ser);
            $license_contents = json_decode($license_contents, true);
            if($license_contents["license"] == $lickey) {
                writefile($globals["path"] . "/license2.php", $license_contents_ser, 1);
                loadlicense();
                return true;
            }
            $details["error"] = $l["inv_lic"];
            return $details;
        }
        $post = [];
        $post["licform"] = 1;
        $post["lickey"] = $lickey;
        $details = $this->call($serid, "index.php?act=license", 1, [], $post);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return true;
    }
    public function refreshlicense($serid)
    {
        global $globals;
        if($serid == 0) {
            loadlicense();
            loadlicense(true);
        } else {
            $details = $this->call($serid, "index.php?act=license&refreshlicense=1");
            return true;
        }
    }
    public function emailconfig($serid, $data)
    {
        global $kernel;
        if($serid == 0) {
            return saveglobals($data, true);
        }
        $data["editemailconfigsettings"] = "Yes";
        $details = $this->call($serid, "index.php?act=emailconfig", 1, [], $data);
        if(!empty($details["done"])) {
            return true;
        }
        return false;
    }
    public function maintenance_save($serid, $data)
    {
        if($serid == 0) {
            return saveglobals($data, true);
        }
        $data["maintenance"] = "Edit Settings";
        if(empty($data["off"])) {
            unset($data["off"]);
        }
        $details = $this->call($serid, "index.php?act=maintenance", 1, [], $data);
        if(!empty($details["done"])) {
            return true;
        }
        return false;
    }
    public function config_get($serid)
    {
        global $kernel;
        global $globals;
        if($serid == 0) {
            $info = [];
            $langs = [];
            $folders = filelist($globals["path"] . "/languages/", 0, 1);
            foreach ($folders as $k => $v) {
                $langs[$v["name"]] = $v["name"];
            }
            $skins = [];
            $folders = filelist($globals["path"] . "/enduser/themes/", 0, 1);
            foreach ($folders as $k => $v) {
                if(strtolower($v["name"]) == "api") {
                } else {
                    $skins[$v["name"]] = $v["name"];
                }
            }
            if($this->virt(1) && distro_check(0, 1, 1)) {
                $globals["vswap"] = 1;
            }
            $info["globals"] = $globals;
            $info["skins"] = $skins;
            $info["langs"] = $langs;
            return $info;
        } else {
            $details = $this->call($serid, "index.php?act=config");
            if(!empty($details["globals"])) {
                return $details;
            }
            return false;
        }
    }
    public function ssh_settings($data)
    {
        global $globals;
        $maxcheck = 0;
        if(is_file("/etc/ssh/sshd_config")) {
            $file = file("/etc/ssh/sshd_config");
            foreach ($file as $k => $v) {
                if(!empty($data["change_ssh_port"]) && preg_match("/\\bPort\\b(\\s*?)(.*?)/is", $v)) {
                    $file[$k] = "Port " . $data["change_ssh_port"] . "\n";
                }
                if(preg_match("/\\bMaxAuthTries\\b(\\s*?)(.*?)/is", $v)) {
                    $file[$k] = "MaxAuthTries " . (!empty($data["max_ssh_login"]) ? $data["max_ssh_login"] : 6) . "\n";
                }
            }
            writefile("/etc/ssh/sshd_config", implode("", $file), 1);
            $this->dotoservice(0, empty($globals["distro"]) ? "sshd" : "ssh", "restart");
            return true;
        }
    }
    public function config_save($serid, $data)
    {
        global $kernel;
        global $globals;
        if($serid == 0) {
            if(!saveglobals($data, true)) {
                return false;
            }
            if(empty($data["is_config_master"])) {
                $this->ssh_settings($data);
            }
            if(!empty($data["cron_time"])) {
                del_cron();
                add_cron($data["cron_time"]);
            }
            return true;
        }
        $data["editsettings"] = "Save Configuration";
        $details = $this->call($serid, "index.php?act=config_slave", 1, [], $data);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["done"])) {
            return false;
        }
        return true;
    }
    public function saveglobals($serid, $data)
    {
        global $kernel;
        global $globals;
        if($serid == 0) {
            if(!saveglobals($data, 1)) {
                return false;
            }
            return true;
        }
        $post = [];
        foreach ($data as $key => $val) {
            $post[$key] = $val;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=saveglobals", 1, [], $post);
        if(empty($details["saveglobals"])) {
            return false;
        }
        return true;
    }
    public function defaultvsconf($serid)
    {
        global $kernel;
        global $globals;
        if($serid == 0) {
            if($this->virt(1) && distro_check(0, 1, 1)) {
                $globals["vswap"] = 1;
            }
            if(empty($globals["vswap"])) {
                $tmppath = file_exists($globals["path"] . "/conf/openvz_vps.conf") ? $globals["path"] . "/conf/openvz_vps.conf" : $globals["path"] . "/conf/_openvz_vps.conf";
            } else {
                $tmppath = file_exists($globals["path"] . "/conf/openvz_vps_vswap.conf") ? $globals["path"] . "/conf/openvz_vps_vswap.conf" : $globals["path"] . "/conf/_openvz_vps_vswap.conf";
            }
            $defaultvsconf = implode("", file($tmppath));
            return $defaultvsconf;
        }
        $details = $this->call($serid, "index.php?act=defaultvsconf");
        if(!empty($details["defaultvsconf"])) {
            return $details["defaultvsconf"];
        }
        return false;
    }
    public function defaultvsconf_save($serid, $confinfo)
    {
        global $kernel;
        global $globals;
        if($serid == 0) {
            if($this->virt(1) && distro_check(0, 1, 1)) {
                $globals["vswap"] = 1;
            }
            if(empty($globals["vswap"])) {
                writefile($globals["path"] . "/conf/openvz_vps.conf", $confinfo, 1);
            } else {
                writefile($globals["path"] . "/conf/openvz_vps_vswap.conf", $confinfo, 1);
            }
            return true;
        }
        $post = [];
        $post["confinfo"] = $confinfo;
        $post["saveconf"] = "Save VPS Configuration";
        $details = $this->call($serid, "index.php?act=defaultvsconf", 1, [], $post);
        if(!empty($details["done"])) {
            return true;
        }
        return false;
    }
    public function suspendvps($vpsid)
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        $vps = getvps($vpsid);
        if(!empty($globals["is_cloud"])) {
            $array = $kernel->vm_location([$vpsid => $vps["serid"]]);
        }
        if($vps["serid"] == 0) {
            $suspend = true;
            if($kernel->vps_status_statewise($vpsid, 1) == 1) {
                $suspend = $kernel->suspendvps($vpsid);
                if(!$suspend) {
                    $suspend = $kernel->poweroff($vpsid);
                }
            }
            if(empty($globals["disable_suspend_email"]) && !empty($suspend)) {
                $res_email = makequery("SELECT `email` FROM `users` WHERE `uid`= :uid", [":uid" => $vps["uid"]]);
                $sus_reason = makequery("SELECT `suspend_reason` FROM `vps` WHERE `vpsid`= :vpsid", [":vpsid" => $vps["vpsid"]]);
                if(0 < vsql_num_rows($res_email)) {
                    $tmp = vsql_fetch_assoc($res_email);
                    $tmp_reason = vsql_fetch_assoc($sus_reason);
                    send_emailtemp_mail("suspend_vps", $tmp["email"], ["hostname" => $vps["hostname"], "vps_name" => $vps["vps_name"], "sn" => $globals["sn"], "suspend_reason" => !empty($tmp_reason["suspend_reason"]) ? $l["suspend_reason"] . $tmp_reason["suspend_reason"] : "", "vpsid" => $vpsid], 1);
                }
            }
            return $suspend;
        }
        $skip_callback = optREQ("skip_callback");
        $details = $this->call($vps["serid"], "index.php?act=vs&suspend=" . $vpsid . "&skip_callback=" . $skip_callback, 1);
        if(empty($details["done"])) {
            return false;
        }
        return true;
    }
    public function unsuspendvps($vpsid)
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        $vps = getvps($vpsid);
        if(!empty($globals["is_cloud"])) {
            $array = $kernel->vm_location([$vpsid => $vps["serid"]]);
        }
        if($vps["serid"] == 0) {
            $unsuspend = $kernel->unsuspendvps($vpsid);
            if(empty($globals["disable_suspend_email"]) && !empty($unsuspend)) {
                $res_email = makequery("SELECT `email` FROM `users` WHERE `uid` = :uid", [":uid" => $vps["uid"]]);
                if(0 < vsql_num_rows($res_email)) {
                    $tmp = vsql_fetch_assoc($res_email);
                    send_emailtemp_mail("unsuspend_vps", $tmp["email"], ["hostname" => $vps["hostname"], "vps_name" => $vps["vps_name"], "sn" => $globals["sn"], "vpsid" => $vpsid], 1);
                }
            }
            return $unsuspend;
        }
        $skip_callback = optREQ("skip_callback");
        $details = $this->call($vps["serid"], "index.php?act=vs&unsuspend=" . $vpsid . "&skip_callback=" . $skip_callback, 1);
        if(empty($details["done"])) {
            return false;
        }
        return true;
    }
    public function suspend_vps_net($vpsid)
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            $suspend_net = $kernel->suspend_vps_net($vpsid);
            if(empty($globals["disable_suspend_email"]) && !empty($suspend_net)) {
                $res_email = makequery("SELECT `email` FROM `users` WHERE `uid` = :uid", [":uid" => $vps["uid"]]);
                if(0 < vsql_num_rows($res_email)) {
                    $tmp = vsql_fetch_assoc($res_email);
                    send_emailtemp_mail("suspend_vps_net", $tmp["email"], ["hostname" => $vps["hostname"], "vps_name" => $vps["vps_name"], "sn" => $globals["sn"], "vpsid" => $vpsid]);
                }
            }
            return $suspend_net;
        }
        $details = $this->call($vps["serid"], "index.php?act=vs&suspend_net=" . $vpsid, 1);
        if(empty($details["done"])) {
            return false;
        }
        return true;
    }
    public function unsuspend_vps_net($vpsid)
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            $unsuspend_net = $kernel->unsuspend_vps_net($vpsid);
            if(empty($globals["disable_suspend_email"]) && !empty($unsuspend_net)) {
                $res_email = makequery("SELECT `email` FROM `users` WHERE `uid` = :uid", [":uid" => $vps["uid"]]);
                if(0 < vsql_num_rows($res_email)) {
                    $tmp = vsql_fetch_assoc($res_email);
                    send_emailtemp_mail("unsuspend_vps_net", $tmp["email"], ["hostname" => $vps["hostname"], "vps_name" => $vps["vps_name"], "sn" => $globals["sn"], "vpsid" => $vpsid]);
                }
            }
            return $unsuspend_net;
        }
        $details = $this->call($vps["serid"], "index.php?act=vs&unsuspend_net=" . $vpsid, 1);
        if(empty($details["done"])) {
            return false;
        }
        return true;
    }
    public function createtemplate($vpsid, $name)
    {
        global $kernel;
        global $error;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->createtemplate($vpsid, $name);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=createtemplate&vpsid=" . $vpsid . "&name=" . $name, 1);
        if(!empty($details["error"])) {
            return $details;
        }
        if(empty($details["createtemplate"])) {
            return false;
        }
        return $details["createtemplate"];
    }
    public function check_kernel($serid)
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->check_kernel();
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=check_kernel");
        if(!empty($details)) {
            return $details["info"]["check_kernel"];
        }
        return -1;
    }
    public function openvz_orphan($serid)
    {
        global $kernel;
        if($serid == 0) {
            $confs = filelist("/etc/vz/conf/", 0);
            $confs = !is_array($confs) ? [] : $confs;
            $orphan = [];
            foreach ($confs as $k => $v) {
                if(substr($v["name"], -4) != "conf") {
                } else {
                    $name = (int) str_replace(".conf", "", $v["name"]);
                    if(100 < $name && $name < 10000000) {
                        $qres = makequery("SELECT * FROM vps\n\t\t\t\t\t\t\t\t\tWHERE vps_name = :name\n\t\t\t\t\t\t\t\t\tAND serid = :serid", [":name" => $name, ":serid" => $serid]);
                        if(vsql_num_rows($qres) < 1) {
                            $orphan[$name] = $name;
                        }
                    }
                }
            }
            if(file_exists("/etc/virtuozzo-release")) {
                $orphan["is_openvz7"] = true;
            }
            return $orphan;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=openvz_orphan", 1);
            if(empty($details["openvz_orphan"])) {
                return false;
            }
            return $details["openvz_orphan"];
        }
    }
    public function openvz7_orphan($serid)
    {
        global $kernel;
        if($serid == 0) {
            vexec("prlctl list --all -o name -H", $out, $ret);
            $orphan = [];
            foreach ($out as $name) {
                $qres = makequery("SELECT * FROM vps\n\t\t\t\t\t\t\t\t\tWHERE vps_name = :name\n\t\t\t\t\t\t\t\t\tAND serid = :serid", [":name" => $name, ":serid" => $serid]);
                if(vsql_num_rows($qres) < 1) {
                    $orphan[$name] = $name;
                }
            }
            return $orphan;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=openvz7_orphan", 1);
            if(empty($details["openvz7_orphan"])) {
                return false;
            }
            return $details["openvz7_orphan"];
        }
    }
    public function kvm_orphan($serid)
    {
        global $kernel;
        if($serid == 0) {
            $confs = filelist("/etc/libvirt/qemu/", 0);
            $confs = !is_array($confs) ? [] : $confs;
            $orphan = [];
            foreach ($confs as $k => $v) {
                if(substr($v["name"], -3) != "xml") {
                } else {
                    $name = str_replace(".xml", "", $v["name"]);
                    $qres = makequery("SELECT * FROM vps\n\t\t\t\t\t\t\t\tWHERE vps_name = :name\n\t\t\t\t\t\t\t\tAND serid = :serid", [":name" => $name, ":serid" => $serid]);
                    if(vsql_num_rows($qres) < 1) {
                        $orphan[$name] = $name;
                    }
                }
            }
            return $orphan;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=kvm_orphan", 1);
            if(empty($details["kvm_orphan"])) {
                return false;
            }
            return $details["kvm_orphan"];
        }
    }
    public function xen_orphan($serid)
    {
        global $kernel;
        if($serid == 0) {
            $confs = filelist("/etc/xen/auto/", 0);
            $confs = !is_array($confs) ? [] : $confs;
            $orphan = [];
            foreach ($confs as $k => $v) {
                if(substr($v["name"], -3) != "cfg") {
                } else {
                    $name = str_replace(".cfg", "", $v["name"]);
                    $qres = makequery("SELECT * FROM vps\n\t\t\t\t\t\t\t\tWHERE vps_name = :name\n\t\t\t\t\t\t\t\tAND serid = :serid", [":name" => $name, ":serid" => $serid]);
                    if(vsql_num_rows($qres) < 1) {
                        $orphan[$name] = $name;
                    }
                }
            }
            return $orphan;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=xen_orphan", 1);
            if(empty($details["xen_orphan"])) {
                return false;
            }
            return $details["xen_orphan"];
        }
    }
    public function xcp_orphan($serid)
    {
        global $kernel;
        if($serid == 0) {
            $orphan = [];
            oexec("/usr/bin/xe vm-list params=uuid,name-label,is-control-domain,is-a-snapshot", $outputs, $ret);
            if($ret != 0) {
                return false;
            }
            $vpses = xcp_data_parser($outputs);
            foreach ($vpses as $k => $v) {
                if($v["is-control-domain"] == "1" || $v["is-control-domain"] == "true" || $v["is-a-snapshot"] == "true" || $v["is-a-snapshot"] == "1") {
                } else {
                    $qres = makequery("SELECT * FROM vps\n\t\t\t\t\t\t\t\tWHERE vps_name = :name\n\t\t\t\t\t\t\t\tAND serid = :serid", [":name" => $v["name-label"], ":serid" => $serid]);
                    if(0 < vsql_num_rows($qres)) {
                    } else {
                        $orphan[$v["name-label"]] = $v["name-label"];
                    }
                }
            }
            return $orphan;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=xcp_orphan", 1);
            if(empty($details["xcp_orphan"])) {
                return false;
            }
            return $details["xcp_orphan"];
        }
    }
    public function openvz_import($serid, $vps_names = [])
    {
        global $kernel;
        global $ostemplates;
        $ret = [];
        foreach ($vps_names as $k => $v) {
            $ret[$v] = [];
        }
        if($serid == 0) {
            foreach ($ret as $rk => $rv) {
                $r = [];
                $path = "/etc/vz/conf/" . $rk . ".conf";
                if(!file_exists($path)) {
                } else {
                    $tmp = @file($path);
                    $vz_conf = implode("", $tmp);
                    foreach ($tmp as $k => $l) {
                        $tmp[$k] = trim(preg_replace("/(\\#(.*))/is", "", trim($l)));
                        if(empty($tmp[$k])) {
                        } elseif(preg_match("/=/is", $tmp[$k])) {
                            $t = explode("=", $tmp[$k]);
                            $r[$t[0]] = $t[1];
                        }
                    }
                    foreach ($r as $k => $v) {
                        $r[$k] = trim($v, "\"");
                    }
                    $vconf = $r;
                    $vps = [];
                    $vps["virt"] = "openvz";
                    $space = !empty($vconf["DISKSPACE"]) ? explode(":", $vconf["DISKSPACE"]) : [0, 0];
                    $vps["space"] = $space[1] / 1024 / 1024;
                    $inodes = !empty($vconf["DISKINODES"]) ? explode(":", $vconf["DISKINODES"]) : [0, 0];
                    $vps["inodes"] = $inodes[1];
                    $vps["osid"] = 0;
                    foreach ($ostemplates as $k => $v) {
                        if(strtolower(trim($vconf["OSTEMPLATE"], ".")) == strtolower($v["name"])) {
                            $vps["osid"] = $k;
                        }
                    }
                    $vps["ips"] = [];
                    if(!empty($vconf["IP_ADDRESS"])) {
                        $tmp = $vconf["IP_ADDRESS"];
                        $vps["ips"] = explode(" ", $tmp);
                        foreach ($vps["ips"] as $k => $v) {
                            if(empty($v)) {
                                unset($vps["ips"][$k]);
                            }
                        }
                        $vps["ips"] = array_values($vps["ips"]);
                    }
                    $vps["hostname"] = !empty($vconf["HOSTNAME"]) ? $vconf["HOSTNAME"] : $rk;
                    $vps["io"] = !empty($vconf["IOPRIO"]) ? $vconf["IOPRIO"] : 3;
                    $vps["cpu"] = !empty($vconf["CPUUNITS"]) ? $vconf["CPUUNITS"] : 1000;
                    $vps["cpu_percent"] = !empty($vconf["CPULIMIT"]) ? $vconf["CPULIMIT"] : 10;
                    $vps["cores"] = !empty($vconf["CPUS"]) ? $vconf["CPUS"] : 1;
                    $ram = explode(":", $vconf["SHMPAGES"]);
                    $vps["ram"] = round($ram[1] * 4 / 1024);
                    if(empty($vps["ram"])) {
                        $ram = $vconf["SHMPAGES"];
                        $vps["ram"] = round($ram * 4 / 1024);
                    }
                    if(empty($vps["ram"])) {
                        $ram = explode(":", $vconf["PHYSPAGES"]);
                        $vps["ram"] = round($ram[1] * 4 / 1024);
                    }
                    if(!empty($vconf["PRIVVMPAGES"])) {
                        $bram = explode(":", $vconf["PRIVVMPAGES"]);
                        $vps["burst"] = round($bram[1] * 4 / 1024);
                        if(empty($vps["burst"])) {
                            $bram = $vconf["PRIVVMPAGES"];
                            $vps["burst"] = round($bram * 4 / 1024);
                        }
                    } else {
                        $vps["burst"] = $tram;
                    }
                    if(!empty($vconf["SWAPPAGES"])) {
                        $swap = explode(":", $vconf["SWAPPAGES"]);
                        $vps["burst"] = round($swap[1] * 4 / 1024);
                    }
                    if(file_exists("/vz/private/" . $rk . "/root.hdd")) {
                        $vps["ploop"] = 1;
                    }
                    if(!empty($vconf["DEVICES"]) && !empty($vconf["DEVNODES"]) && !empty($vconf["CAPABILITY"])) {
                        $vps["tuntap"] = 1;
                    }
                    if(preg_match("/ppp\\:on/is", $vz_conf)) {
                        $vps["ppp"] = 1;
                    }
                    $_ubc = ["kmemsize", "lockedpages", "numproc", "physpages", "numtcpsock", "numflock", "numpty", "numsiginfo", "tcpsndbuf", "tcprcvbuf", "othersockbuf", "dgramrcvbuf", "numothersock", "dcachesize", "numfile", "numiptent", "swappages"];
                    $ubc = [];
                    foreach ($_ubc as $k => $v) {
                        if(!empty($vconf[strtoupper($v)])) {
                            $__tmp = explode(":", $vconf[strtoupper($v)]);
                            if(strtolower($__tmp[0]) == "unlimited") {
                                $__tmp[0] = "unlimited";
                                $__tmp[1] = "unlimited";
                            }
                            if(!isset($__tmp[1])) {
                                $__tmp[1] = $__tmp[0];
                            }
                            $ubc[strtoupper($v)] = $__tmp;
                        }
                    }
                    $vps["ubc"] = !empty($ubc) ? serialize($ubc) : "";
                    $ret[$rk] = $vps;
                }
            }
            return $ret;
        } else {
            $post["vps_names"] = $vps_names;
            $details = $this->call($serid, "index.php?act=apidoings&do=openvz_import&", 1, [], $post);
            if(empty($details["openvz_import"])) {
                return false;
            }
            return $details["openvz_import"];
        }
    }
    public function openvz7_import($serid, $vps_names = [])
    {
        global $kernel;
        global $ostemplates;
        $ret = [];
        foreach ($vps_names as $k => $v) {
            $ret[$v] = [];
        }
        if($serid == 0) {
            foreach ($ret as $rk => $rv) {
                oexec("/usr/bin/prlctl list --info --json " . $rk, $out);
                $info = json_decode($out, true);
                if($info[0]["Type"] == "CT") {
                    $r = [];
                    $vps = [];
                    $vps["virt"] = "vzo";
                    $path = $info[0]["Home"] . "/ve.conf";
                    if(!file_exists($path)) {
                    } else {
                        $tmp = @file($path);
                        $vz_conf = implode("", $tmp);
                        foreach ($tmp as $k => $l) {
                            $tmp[$k] = trim(preg_replace("/(\\#(.*))/is", "", trim($l)));
                            if(empty($tmp[$k])) {
                            } elseif(preg_match("/=/is", $tmp[$k])) {
                                $t = explode("=", $tmp[$k]);
                                $r[$t[0]] = $t[1];
                            }
                        }
                        foreach ($r as $k => $v) {
                            $r[$k] = trim($v, "\"");
                        }
                        $vconf = $r;
                        $space = !empty($vconf["DISKSPACE"]) ? explode(":", $vconf["DISKSPACE"]) : [0, 0];
                        $tmp_unit = substr($space[1], -1);
                        if(!is_numeric($tmp_unit)) {
                            $tmp_unit = strtolower($tmp_unit);
                            $space[1] = (double) $space[1];
                            if($tmp_unit == "t") {
                                $space[1] = $space[1] * 1024 * 1024 * 1024;
                            } elseif($tmp_unit == "g") {
                                $space[1] = $space[1] * 1024 * 1024;
                            } elseif($tmp_unit == "m") {
                                $space[1] = $space[1] * 1024;
                            }
                        }
                        $vps["space"] = $space[1] / 1024 / 1024;
                        $inodes = !empty($vconf["DISKINODES"]) ? explode(":", $vconf["DISKINODES"]) : [0, 0];
                        $vps["inodes"] = $inodes[1];
                        $vps["osid"] = 0;
                        foreach ($ostemplates as $k => $v) {
                            if(strtolower(trim($vconf["OSTEMPLATE"], ".")) == strtolower($v["name"])) {
                                $vps["osid"] = $k;
                            }
                        }
                        $vps["ips"] = [];
                        if(!empty($vconf["IP_ADDRESS"])) {
                            $tmp = $vconf["IP_ADDRESS"];
                            $vps["ips"] = explode(" ", $tmp);
                            foreach ($vps["ips"] as $k => $v) {
                                if(strpos($v, "/") !== false) {
                                    $tmp = explode("/", $v);
                                    $v = $tmp[0];
                                }
                                if(empty($v)) {
                                    unset($vps["ips"][$k]);
                                } else {
                                    $vps["ips"][$k] = $v;
                                }
                            }
                            $vps["ips"] = array_values($vps["ips"]);
                        }
                        $vps["hostname"] = !empty($vconf["HOSTNAME"]) ? $vconf["HOSTNAME"] : $rk;
                        $vps["io"] = !empty($vconf["IOPRIO"]) ? $vconf["IOPRIO"] : 3;
                        $vps["cpu"] = !empty($vconf["CPUUNITS"]) ? $vconf["CPUUNITS"] : 1000;
                        $vps["cpu_percent"] = !empty($vconf["CPULIMIT"]) ? $vconf["CPULIMIT"] : 10;
                        $vps["cores"] = !empty($vconf["CPUS"]) ? $vconf["CPUS"] : 1;
                        $ram = explode(":", $vconf["SHMPAGES"]);
                        $vps["ram"] = round($ram[1] * 4 / 1024);
                        if(empty($vps["ram"])) {
                            $ram = $vconf["SHMPAGES"];
                            $vps["ram"] = round($ram * 4 / 1024);
                        }
                        if(empty($vps["ram"])) {
                            $ram = explode(":", $vconf["PHYSPAGES"]);
                            $vps["ram"] = round($ram[1] * 4 / 1024);
                        }
                        if(!empty($vconf["PRIVVMPAGES"])) {
                            $bram = explode(":", $vconf["PRIVVMPAGES"]);
                            $vps["burst"] = round($bram[1] * 4 / 1024);
                            if(empty($vps["burst"])) {
                                $bram = $vconf["PRIVVMPAGES"];
                                $vps["burst"] = round($bram * 4 / 1024);
                            }
                        } else {
                            $vps["burst"] = $tram;
                        }
                        if(!empty($vconf["SWAPPAGES"])) {
                            $swap = explode(":", $vconf["SWAPPAGES"]);
                            $vps["burst"] = round($swap[1] * 4 / 1024);
                        }
                        if(file_exists("/vz/private/" . $rk . "/root.hdd")) {
                            $vps["ploop"] = 1;
                        }
                        if(!empty($vconf["DEVICES"]) && !empty($vconf["DEVNODES"]) && !empty($vconf["CAPABILITY"])) {
                            $vps["tuntap"] = 1;
                        }
                        if(preg_match("/ppp\\:on/is", $vz_conf)) {
                            $vps["ppp"] = 1;
                        }
                        $_ubc = ["kmemsize", "lockedpages", "numproc", "physpages", "numtcpsock", "numflock", "numpty", "numsiginfo", "tcpsndbuf", "tcprcvbuf", "othersockbuf", "dgramrcvbuf", "numothersock", "dcachesize", "numfile", "numiptent", "swappages"];
                        $ubc = [];
                        foreach ($_ubc as $k => $v) {
                            if(!empty($vconf[strtoupper($v)])) {
                                $__tmp = explode(":", $vconf[strtoupper($v)]);
                                if(strtolower($__tmp[0]) == "unlimited") {
                                    $__tmp[0] = "unlimited";
                                    $__tmp[1] = "unlimited";
                                }
                                if(!isset($__tmp[1])) {
                                    $__tmp[1] = $__tmp[0];
                                }
                                $ubc[strtoupper($v)] = $__tmp;
                            }
                        }
                        $vps["ubc"] = !empty($ubc) ? serialize($ubc) : "";
                        $ret[$rk] = $vps;
                    }
                } else {
                    $path = $info[0]["Home"] . "/config.pvs";
                    if(!file_exists($path)) {
                    } else {
                        $vps = [];
                        $vps["virt"] = "vzk";
                        $config_xml = xmlstring2array(file_get_contents($path));
                        $vps["hostname"] = !empty($config_xml["Settings"]["GlobalNetwork"]["HostName"]) ? $config_xml["Settings"]["GlobalNetwork"]["HostName"] : $rk;
                        $vps["cpu"] = (int) $config_xml["Hardware"]["Cpu"]["CpuUnits"];
                        $vps["cpu_percent"] = (int) $config_xml["Hardware"]["Cpu"]["CpuLimit"];
                        $vps["cores"] = (int) $config_xml["Hardware"]["Cpu"]["Number"];
                        if(!empty($config_xml["Hardware"]["Cpu"]["CpuMask"])) {
                            $vps["cpupin"] = $config_xml["Hardware"]["Cpu"]["CpuMask"];
                        }
                        $vps["io"] = (int) $config_xml["Settings"]["Runtime"]["IoPriority"];
                        $vps["ram"] = (int) $config_xml["Hardware"]["Memory"]["RAM"];
                        $vps["ips"] = $config_xml["Hardware"]["NetworkAdapter"]["NetAddress"];
                        if(!is_array($vps["ips"])) {
                            $vps["ips"] = [$vps["ips"]];
                        }
                        foreach ($vps["ips"] as $k => $v) {
                            if(strpos($v, "/") !== false) {
                                $tmp = explode("/", $v);
                                $v = $tmp[0];
                                $vps["ips"][$k] = $v;
                            }
                        }
                        if(!empty($config_xml["Hardware"]["NetworkAdapter"]["MAC"])) {
                            $vps["mac"] = $config_xml["Hardware"]["NetworkAdapter"]["MAC"];
                            $vps["mac"] = wordwrap($vps["mac"], 2, ":", true);
                        }
                        $disk = $config_xml["Hardware"]["Hdd"];
                        if(empty($disk["Size"])) {
                            $disk = $disk[0];
                        }
                        $vps["disks"] = [];
                        $vps["disks"][0] = vps_disk_struct();
                        $vps["disks"][0]["primary"] = 1;
                        $vps["disks"][0]["path"] = $info[0]["Home"] . "/" . $disk["SystemName"];
                        $vps["disks"][0]["type"] = "file";
                        $vps["disks"][0]["format"] = "qcow2";
                        $vps["disks"][0]["size"] = $disk["Size"] / 1024;
                        $vps["space"] = $disk["Size"] / 1024;
                        if(!empty($config_xml["Settings"]["RemoteDisplay"]["Mode"])) {
                            $vps["vnc"] = 1;
                            $vps["vncport"] = (int) $config_xml["Settings"]["RemoteDisplay"]["PortNumber"];
                            $vps["vnc_passwd"] = $config_xml["Settings"]["RemoteDisplay"]["Password"];
                        }
                        $adapter_type = $config_xml["Hardware"]["NetworkAdapter"]["AdapterType"];
                        if($adapter_type == 2) {
                            $vps["nic_type"] = "e1000";
                        } elseif($adapter_type == 3) {
                            $vps["nic_type"] = "virtio";
                        }
                        $ret[$rk] = $vps;
                    }
                }
            }
            return $ret;
        } else {
            $post["vps_names"] = $vps_names;
            $details = $this->call($serid, "index.php?act=apidoings&do=openvz7_import", 1, [], $post);
            if(empty($details["openvz7_import"])) {
                return false;
            }
            return $details["openvz7_import"];
        }
    }
    public function kvm_import($serid, $vps_names = [], $execute = [])
    {
        global $globals;
        global $kernel;
        global $ostemplates;
        $ret = [];
        foreach ($vps_names as $k => $v) {
            $ret[$v] = [];
        }
        if($serid == 0) {
            if(!empty($execute) && is_array($execute) && !empty($execute["ln"])) {
                foreach ($execute["ln"] as $fk => $fv) {
                    exec("ln -s " . $fv["src"] . " " . $fv["dest"]);
                }
            }
            if(!is_dir($globals["var"] . "/kvm-conf")) {
                @mkdir($globals["var"] . "/kvm-conf");
            }
            foreach ($ret as $rk => $rv) {
                $source_kvm = "/home/kvm/" . $rk . "/" . $rk . ".xml";
                $target_kvm = "/etc/libvirt/qemu/" . $rk . ".xml";
                copy($source_kvm, $target_kvm);
                @chmod($target_kvm, 384);
                $virt_target_kvm = $globals["var"] . "/kvm-conf/" . $rk . ".xml";
                copy($source_kvm, $virt_target_kvm);
                @chmod($virt_target_kvm, 384);
                $r = [];
                $path = "/etc/libvirt/qemu/" . $rk . ".xml";
                if(!file_exists($path)) {
                } else {
                    $vps = [];
                    $config_xml = xmlstring2array(file_get_contents($path));
                    $vps["hostname"] = $rk;
                    $i = 0;
                    $disks = $config_xml["devices"]["disk"];
                    if(empty($disks[0]) && !empty($disks["@attributes"])) {
                        $disks = [];
                        $disks[0] = $config_xml["devices"]["disk"];
                    }
                    foreach ($disks as $k => $v) {
                        if($v["@attributes"]["device"] == "disk") {
                            $vps["boot"] = "cda";
                            $vps["kvm_cache"] = $v["driver"]["@attributes"]["cache"];
                            $vps["io_mode"] = $v["driver"]["@attributes"]["io"];
                            $vps["virtio"] = $v["target"]["@attributes"]["bus"] == "virtio" ? 1 : 0;
                            $vps["disks"][$i] = vps_disk_struct();
                            $vps["disks"][$i]["primary"] = $i == 0 ? 1 : 0;
                            $vps["disks"][$i]["path"] = empty($v["source"]["@attributes"]["file"]) ? $v["source"]["@attributes"]["dev"] : $v["source"]["@attributes"]["file"];
                            if($v["@attributes"]["type"] == "file") {
                                $size = qemu_size($vps["disks"][$i]["path"]);
                                $type = "file";
                            } else {
                                $size = lvsize($vps["disks"][$i]["path"]);
                                $type = "block";
                            }
                            $vps["disks"][$i]["type"] = $type;
                            $vps["disks"][$i]["size"] = $size;
                            $vps["disks"][$i]["extra"]["target_name"] = $v["target"]["@attributes"]["dev"];
                            $i++;
                        } elseif($v["@attributes"]["device"] == "cdrom" && $v["@attributes"]["type"] == "file") {
                            $temp = explode("/", $v["source"]["@attributes"]["file"]);
                            $vps["iso"] = $temp[count($temp) - 1];
                        }
                    }
                    if($vps["disks"][0]["type"] == "file") {
                        $vps["space"] = qemu_size($vps["disks"][0]["path"]);
                    } else {
                        $vps["space"] = lvsize($vps["disks"][0]["path"]);
                    }
                    $cores = $config_xml["vcpu"];
                    $vps["cores"] = !empty($cores) ? $cores : 1;
                    $vps["ram"] = round($config_xml["memory"] / 1024);
                    $vps["acpi"] = isset($config_xml["features"]["acpi"]) ? 1 : 0;
                    $vps["apic"] = isset($config_xml["features"]["apic"]) ? 1 : 0;
                    $vps["pae"] = isset($config_xml["features"]["pae"]) ? 1 : 0;
                    $vps["vnc"] = !empty($config_xml["devices"]["graphics"]) ? 1 : 0;
                    if(!empty($vps["vnc"])) {
                        $vps["vncport"] = $config_xml["devices"]["graphics"]["@attributes"]["port"];
                    }
                    $interfaces = $config_xml["devices"]["interface"];
                    if(empty($interfaces[0])) {
                        $interfaces = [$interfaces];
                    }
                    foreach ($interfaces as $k => $v) {
                        if($v["model"]["@attributes"]["type"] == "e1000") {
                            $vps["nic_type"] = "e1000";
                        } elseif($v["model"]["@attributes"]["type"] == "virtio") {
                            $vps["nic_type"] = "virtio";
                        } else {
                            $vps["nic_type"] = "default";
                        }
                    }
                    $ret_vps[$rk] = $vps;
                }
            }
            return $ret_vps;
        } else {
            $post["vps_names"] = $vps_names;
            $post["execute"] = $execute;
            $details = $this->call($serid, "index.php?act=apidoings&do=kvm_import&", 1, [], $post);
            if(empty($details["kvm_import"])) {
                return false;
            }
            return $details["kvm_import"];
        }
    }
    public function proxk_import($serid, $vps_names = [])
    {
        global $globals;
        global $kernel;
        global $ostemplates;
        $ret_vps = [];
        $ret = [];
        foreach ($vps_names as $k => $v) {
            $ret[$v] = [];
        }
        if($serid == 0) {
            foreach ($ret as $rk => $rv) {
                $r = [];
                $vps = [];
                $disk_config = $interface_config = [];
                $config = proxmox_get_call("/nodes/", "/qemu/" . $rk . "/config");
                $vps["hostname"] = $config["name"];
                $i = 0;
                foreach ($config as $k => $v) {
                    if(preg_match("/^sata[\\d]|scsi[\\d]|virtio[\\d]|ide[\\d]/", $k)) {
                        $disk_config[$k] = $v;
                    }
                    if(preg_match("/^net[0-9]+\$/", $k)) {
                        $interface_config[$k] = $v;
                    }
                }
                $tmpdsk = [];
                foreach ($disk_config as $k => $v) {
                    if(preg_match("/cdrom/", $v)) {
                    } else {
                        unset($disk_config[$k]);
                        $v1 = preg_split("/\\//", $v);
                        $v1 = preg_split("/\\./", $v1[count($v1) - 1]);
                        $num = preg_split("/\\-/", $v1[0]);
                        $tmpdsk[$num[count($num) - 1]] = [$k, $v];
                    }
                }
                ksort($tmpdsk);
                foreach ($tmpdsk as $k => $v) {
                    $disk_config[$v[0]] = $v[1];
                }
                unset($tmpdsk);
                $vps["space"] = 0;
                foreach ($disk_config as $k => $v) {
                    $vps["boot"] = "cda";
                    $disk_conf = explode(":", $v);
                    $bus_driver_num = preg_split("/^sata|scsi|virtio|ide/", $k);
                    $bus_driver = preg_split("/[\\d]/", $k);
                    $storage_name = trim($disk_conf[0]);
                    if(preg_match("/cdrom/", $storage_name)) {
                    } else {
                        $tmp_disk_name = explode(",", trim($disk_conf[1]));
                        $disk_name = $tmp_disk_name[0];
                        $res = makequery("SELECT * FROM  storage\n\t\t\t\t\t\t\tWHERE name = :storage_name", [":storage_name" => $storage_name]);
                        $_storage = vsql_fetch_assoc($res);
                        if(preg_match("/\\.iso\$/is", $disk_name)) {
                        } else {
                            if(preg_match("/file/is", $_storage["type"])) {
                                $vps["disks"][$i] = vps_disk_struct();
                                $vps["disks"][$i]["primary"] = $i == 0 ? 1 : 0;
                                $vps["disks"][$i]["path"] = $_storage["path"] . "/images/" . $disk_name;
                                $vps["disks"][$i]["type"] = "file";
                                $vps["disks"][$i]["size"] = qemu_size($vps["disks"][$i]["path"]);
                                $vps["disks"][$i]["st_uuid"] = $_storage["st_uuid"];
                                $vps["disks"][$i]["bus_driver"] = $bus_driver[0];
                                $vps["disks"][$i]["bus_driver_num"] = $bus_driver_num[1];
                            } elseif(preg_match("/zfs/is", $_storage["type"])) {
                                $vps["disks"][$i] = vps_disk_struct();
                                $vps["disks"][$i]["primary"] = $i == 0 ? 1 : 0;
                                $vps["disks"][$i]["path"] = $_storage["path"] . "/" . $disk_name;
                                $vps["disks"][$i]["type"] = "zfs block";
                                $vps["disks"][$i]["size"] = zfs_size($vps["disks"][$i]["path"]);
                                $vps["disks"][$i]["st_uuid"] = $_storage["st_uuid"];
                                $vps["disks"][$i]["bus_driver"] = $bus_driver[0];
                                $vps["disks"][$i]["bus_driver_num"] = $bus_driver_num[1];
                            } elseif(preg_match("/block/is", $_storage["type"])) {
                                $vps["disks"][$i] = vps_disk_struct();
                                $vps["disks"][$i]["primary"] = $i == 0 ? 1 : 0;
                                $vps["disks"][$i]["st_uuid"] = $_storage["st_uuid"];
                                $vps["disks"][$i]["bus_driver"] = $bus_driver[0];
                                $vps["disks"][$i]["bus_driver_num"] = $bus_driver_num[1];
                                if(preg_match("/ceph/is", $_storage["type"])) {
                                    $vps["disks"][$i]["type"] = "ceph block";
                                    $vps["disks"][$i]["path"] = "/dev/rbd/" . $_storage["name"] . "/" . $disk_name;
                                    $vps["disks"][$i]["size"] = ceph_size($vps["disks"][$i]["path"]);
                                } elseif(preg_match("/linbit/is", $_storage["type"])) {
                                    $vps["disks"][$i]["type"] = "linbit drbd block";
                                    $vps["disks"][$i]["path"] = "/dev/drbd/by-res/" . $disk_name;
                                    foreach ($tmp_disk_name as $tk => $tv) {
                                        if(preg_match("/size=/is", $tv)) {
                                            $tmp_tv = explode("=", $tv);
                                            $tmp_unit = substr($tmp_tv[1], -1);
                                            $tmp_size = (int) substr($tmp_tv[1], 0, -1);
                                            if($tmp_unit === "G") {
                                                $vps["disks"][$i]["size"] = $tmp_size;
                                            } elseif($tmp_unit === "K") {
                                                $vps["disks"][$i]["size"] = !empty($tmp_size) ? round($tmp_size / 1024 / 1024, 3) : 0;
                                            }
                                        }
                                    }
                                } else {
                                    $vps["disks"][$i]["type"] = "block";
                                    $vps["disks"][$i]["path"] = $_storage["path"] . "/" . $disk_name;
                                    if(preg_match("/thin/is", $_storage["type"])) {
                                        $vps["disks"][$i]["path"] = dirname($_storage["path"]) . "/" . $disk_name;
                                        $vps["disks"][$i]["type"] = "thin block";
                                    }
                                    $vps["disks"][$i]["size"] = lvsize($vps["disks"][$i]["path"]);
                                }
                            }
                            $vps["space"] += $vps["disks"][$i]["size"];
                            $i++;
                        }
                    }
                }
                $cores = $config["cores"] * $config["sockets"];
                $vps["cores"] = !empty($cores) ? $cores : 1;
                $vps["topology_sockets"] = $config["sockets"];
                $vps["topology_cores"] = $config["cores"];
                $vps["ram"] = round($config["memory"]);
                $vps["swap"] = round($config["swap"]);
                if(!empty($config["cpuunits"])) {
                    $vps["cpu"] = $config["cpuunits"];
                } else {
                    $vps["cpu"] = 1024;
                }
                if(!empty($config["cpulimit"])) {
                    $vps["cpu_percent"] = $config["cpulimit"] * 100;
                } else {
                    $vps["cpu_percent"] = $vps["cores"] * 100;
                }
                $vps["numa"] = $config["numa"];
                foreach ($interface_config as $k => $v) {
                    if(preg_match("/e1000/", $v)) {
                        $vps["nic_type"] = "e1000";
                    } elseif(preg_match("/virtio/", $v)) {
                        $vps["nic_type"] = "virtio";
                    } else {
                        $vps["nic_type"] = "default";
                    }
                }
                $ret_vps[$rk] = $vps;
            }
            return $ret_vps;
        } else {
            $post["vps_names"] = $vps_names;
            $details = $this->call($serid, "index.php?act=apidoings&do=proxk_import&", 1, [], $post);
            if(empty($details["proxk_import"])) {
                return false;
            }
            return $details["proxk_import"];
        }
    }
    public function proxl_import($serid, $vps_names = [])
    {
        global $globals;
        global $kernel;
        global $ostemplates;
        $ret = [];
        foreach ($vps_names as $k => $v) {
            $ret[$v] = [];
        }
        if($serid == 0) {
            foreach ($ret as $rk => $rv) {
                $r = [];
                $vps = [];
                $disk_config = $interface_config = [];
                $config = proxmox_get_call("/nodes/", "/lxc/" . $rk . "/config");
                $vps["hostname"] = $config["hostname"];
                $i = 0;
                foreach ($config as $k => $v) {
                    if(preg_match("/rootfs/", $k)) {
                        $disk_config[$k] = $v;
                    }
                    if(preg_match("/^net[0-9]+\$/", $k)) {
                        $interface_config[$k] = $v;
                    }
                }
                $vps["space"] = 0;
                foreach ($disk_config as $k => $v) {
                    $disk_conf = explode(":", $v);
                    $storage_name = trim($disk_conf[0]);
                    $tmp_disk_name = explode(",", trim($disk_conf[1]));
                    $disk_name = $tmp_disk_name[0];
                    $res = makequery("SELECT * FROM  storage\n\t\t\t\t\t\t\tWHERE name = :storage_name", [":storage_name" => $storage_name]);
                    $_storage = vsql_fetch_assoc($res);
                    if(preg_match("/\\.iso\$/is", $disk_name)) {
                    } else {
                        if(preg_match("/file/is", $_storage["type"])) {
                            $vps["disks"][$i] = vps_disk_struct();
                            $vps["disks"][$i]["primary"] = $i == 0 ? 1 : 0;
                            $vps["disks"][$i]["path"] = $_storage["path"] . "/images/" . $disk_name;
                            $vps["disks"][$i]["type"] = "file";
                            $vps["disks"][$i]["size"] = qemu_size($vps["disks"][$i]["path"]);
                            $vps["disks"][$i]["st_uuid"] = $_storage["st_uuid"];
                        } elseif(preg_match("/zfs/is", $_storage["type"])) {
                            $vps["disks"][$i] = vps_disk_struct();
                            $vps["disks"][$i]["primary"] = $i == 0 ? 1 : 0;
                            $vps["disks"][$i]["path"] = $_storage["path"] . "/" . $disk_name;
                            $vps["disks"][$i]["type"] = "zfs block";
                            $vps["disks"][$i]["size"] = zfs_size($vps["disks"][$i]["path"]);
                            $vps["disks"][$i]["st_uuid"] = $_storage["st_uuid"];
                        } elseif(preg_match("/block/is", $_storage["type"])) {
                            $vps["disks"][$i] = vps_disk_struct();
                            $vps["disks"][$i]["primary"] = $i == 0 ? 1 : 0;
                            $vps["disks"][$i]["bus_driver"] = $bus_driver[0];
                            $vps["disks"][$i]["bus_driver_num"] = $bus_driver_num[1];
                            $vps["disks"][$i]["st_uuid"] = $_storage["st_uuid"];
                            if(preg_match("/ceph/is", $_storage["type"])) {
                                $vps["disks"][$i]["path"] = "/dev/rbd/" . $_storage["name"] . "/" . $disk_name;
                                $vps["disks"][$i]["type"] = "ceph block";
                                $vps["disks"][$i]["size"] = ceph_size($vps["disks"][$i]["path"]);
                            } else {
                                $vps["disks"][$i]["type"] = "block";
                                $vps["disks"][$i]["path"] = $_storage["path"] . "/" . $disk_name;
                                if(preg_match("/thin/is", $_storage["type"])) {
                                    $vps["disks"][$i]["path"] = dirname($_storage["path"]) . "/" . $disk_name;
                                    $vps["disks"][$i]["type"] = "thin block";
                                }
                                $vps["disks"][$i]["size"] = lvsize($vps["disks"][$i]["path"]);
                            }
                        }
                        $vps["space"] += $vps["disks"][$i]["size"];
                        $i++;
                    }
                }
                $cores = $config["cores"];
                $vps["cores"] = !empty($cores) ? $cores : 1;
                $vps["ram"] = round($config["memory"]);
                $vps["swap"] = round($config["swap"]);
                if(!empty($config["cpuunits"])) {
                    $vps["cpu"] = $config["cpuunits"];
                } else {
                    $vps["cpu"] = 1024;
                }
                if(!empty($config["cpulimit"])) {
                    $vps["cpu_percent"] = $config["cpulimit"] * 100;
                } else {
                    $vps["cpu_percent"] = $vps["cores"] * 100;
                }
                $ret_vps[$rk] = $vps;
            }
            return $ret_vps;
        } else {
            $post["vps_names"] = $vps_names;
            $details = $this->call($serid, "index.php?act=apidoings&do=proxl_import&", 1, [], $post);
            if(empty($details["proxl_import"])) {
                return false;
            }
            return $details["proxl_import"];
        }
    }
    public function xen_import($serid, $vps_names = [], $execute = [])
    {
        global $globals;
        global $kernel;
        global $ostemplates;
        $ret = [];
        foreach ($vps_names as $k => $v) {
            $ret[$v] = [];
        }
        if($serid == 0) {
            if(!empty($execute) && is_array($execute) && !empty($execute["ln"])) {
                foreach ($execute["ln"] as $fk => $fv) {
                    exec("ln -s " . $fv["src"] . " " . $fv["dest"]);
                }
            }
            $ret_vps = [];
            foreach ($ret as $rk => $rv) {
                $r = [];
                $path = "/etc/xen/auto/" . $rk . ".cfg";
                if(!file_exists($path)) {
                    if(file_exists("/home/xen/" . $rk . "/" . $rk . ".cfg")) {
                        exec("ln -s " . xss("/home/xen/" . $rk . "/" . $rk . ".cfg") . " " . xss($path));
                    }
                    if(!file_exists($path)) {
                    }
                }
                $vps = [];
                $tmp = @file($path);
                foreach ($tmp as $k => $l) {
                    $tmp[$k] = trim(preg_replace("/(\\#(.*))/is", "", trim($l)));
                    if(empty($tmp[$k])) {
                    } elseif(preg_match("/=/is", $tmp[$k])) {
                        $kv = preg_split("/\\s*=\\s*/i", $tmp[$k], 2);
                        $kk = trim($kv[0]);
                        $vv = trim($kv[1]);
                        $vv = trim($vv, "\"'");
                        if($vv[0] == "[") {
                            $vv = trim($vv, "[]");
                            $vv = preg_split("/((?<=\")\\s*,\\s*(?=\".+\"))|((?<=')\\s*,\\s*(?='.+'))/i", $vv);
                            foreach ($vv as $key => $val) {
                                $vv[$key] = trim($vv[$key]);
                                $vv[$key] = trim($vv[$key], "\"'");
                                if($kk == "disk") {
                                    $xen_disk_count = substr_count($vv[$key], "phy:");
                                    $dtmp = explode("phy:", $vv[$key]);
                                    $vv[$key] = [];
                                    for ($x = 0; $x < $xen_disk_count; $x++) {
                                        $dt = explode(",", $dtmp[$x + 1]);
                                        $vv[$key][$x]["path"] = trim($dt[0]);
                                        $vv[$key][$x]["name"] = trim($dt[1]);
                                        $vv[$key][$x]["swap"] = preg_match("/(swap-)|(swap\$)/i", $vv[$key][$x]["path"]);
                                    }
                                }
                                if($kk == "vif") {
                                    $abc = [];
                                    $dt = explode(",", $vv[$key]);
                                    foreach ($dt as $dk => $dv) {
                                        $dv = explode("=", $dv);
                                        $abc[trim($dv[0])] = trim($dv[1]);
                                    }
                                    $vv[$key] = $abc;
                                }
                            }
                        }
                        $r[$kk] = $vv;
                    }
                }
                $vps["hvm"] = !empty($r["builder"]) ? 1 : 0;
                $vps["pv_on_hvm"] = !empty($r["xen_platform_pci"]) ? 1 : 0;
                $vps["hostname"] = $r["hostname"];
                $vps["cores"] = !empty($r["vcpus"]) ? $r["vcpus"] : 1;
                $vps["cpu"] = !empty($r["cpu_weight"]) ? $r["cpu_weight"] : 256;
                $vps["cpu_percent"] = !empty($r["cpu_cap"]) ? $r["cpu_cap"] : 0;
                $vps["ram"] = $r["memory"];
                $i = 0;
                $vps["space"] = 0;
                foreach ($r["disk"] as $k => $v) {
                    $vps["disks"][$i] = vps_disk_struct();
                    $vps["disks"][$i]["primary"] = empty($k) ? 1 : 0;
                    $vps["disks"][$i]["path"] = $v[0]["path"];
                    $vps["disks"][$i]["type"] = "block";
                    $vps["disks"][$i]["size"] = lvsize($v[0]["path"], $v[0]["swap"] ? "M" : "G");
                    $vps["disks"][$i]["size_unit"] = $v[0]["swap"] ? "M" : "";
                    if(!preg_match("/swap/is", $v[0]["path"])) {
                        $vps["space"] += $vps["disks"][$i]["size"];
                    }
                    $i++;
                }
                if(!empty($vps["disks"][1]) && empty($vps["hvm"])) {
                    $vps["swap"] = $vps["disks"][1]["size"];
                }
                $vps["iso"] = "";
                foreach ($r["disk"] as $k => $v) {
                    if(!empty($v["file"])) {
                        $parts = explode("/", $v["file"]);
                        $vps["iso"] = $parts[count($parts) - 1];
                    }
                }
                $vps["boot"] = !empty($r["boot"]) ? $r["boot"] : "cda";
                $vps["acpi"] = !empty($r["acpi"]) ? 1 : 0;
                $vps["apic"] = !empty($r["apic"]) ? 1 : 0;
                $vps["pae"] = !empty($r["pae"]) ? 1 : 0;
                $vps["shadow"] = !empty($r["shadow_memory"]) ? $r["shadow_memory"] : 0;
                if(!empty($r["vfb"]) || !empty($r["vnc"])) {
                    $vps["vnc"] = 1;
                } else {
                    $vps["vnc"] = 0;
                }
                if($vps["vnc"]) {
                    $vps["vncport"] = (int) $r["vnc"];
                    $vps["vncport"] += 5900;
                    if($r["keymap"]) {
                        $vps["vnc_keymap"] = $r["keymap"];
                    }
                }
                $vps["nic_type"] = !empty($r["vif"][0]["model"]) ? $r["vif"][0]["model"] : "default";
                $vps["vif_type"] = !empty($r["vif"][0]["type"]) ? $r["vif"][0]["type"] : "netfront";
                $temp_ips = explode(" ", $r["vif"][0]["ip"]);
                foreach ($temp_ips as $k => $temp_ip) {
                    $vps["ips"][] = $temp_ip;
                }
                $ret_vps[$rk] = $vps;
            }
            return $ret_vps;
        } else {
            $post["vps_names"] = $vps_names;
            $post["execute"] = $execute;
            $details = $this->call($serid, "index.php?act=apidoings&do=xen_import&", 1, [], $post);
            if(empty($details["xen_import"])) {
                return false;
            }
            return $details["xen_import"];
        }
    }
    public function xcp_import($serid, $vps_names)
    {
        $ret_vps = [];
        if($serid == 0) {
            oexec("/usr/bin/xe vm-list params=all", $outputs, $return);
            if($return != 0) {
                return false;
            }
            $vms = xcp_data_parser($outputs, "name-label");
            foreach ($vms as $vk => $vps_data) {
                $vps = [];
                $vps["vps_name"] = $vps_data["name-label"];
                if(!empty($vps["vps_name"]) && in_array($vps["vps_name"], $vps_names) && (!$vps_data["is-a-snapshot"] || $vps_data["is-a-snapshot"] != 1)) {
                    $vps["hostname"] = $vps_data["name-label"];
                    $vps["virt"] = "xcp";
                    $uuid = $vps_data["uuid"];
                    $outs = [];
                    oexec("xe vbd-list params=uuid,vdi-uuid,empty,type,device,bootable vm-uuid=" . $uuid, $outs, $rets);
                    $vps["space"] = 0;
                    if(!empty($outs) && $rets == 0) {
                        $vbds = xcp_data_parser($outs);
                        $sorted_vdbs = array_column($vbds, "device");
                        array_multisort($sorted_vdbs, SORT_ASC, $vbds);
                        $key = 0;
                        $space = 0;
                        foreach ($vbds as $k => $v) {
                            if($v["empty"] == "1" || $v["empty"] == "true") {
                            } elseif(strtolower($v["type"]) != "disk") {
                            } else {
                                $outs1 = [];
                                oexec("xe vdi-list params=uuid,virtual-size,sr-uuid uuid=" . $v["vdi-uuid"], $outs1, $rets1);
                                if(!empty($outs1) && $rets1 == 0) {
                                    $vdi = xcp_data_exploder($outs1);
                                    if(!empty($vdi)) {
                                        $vps["disks"][$key] = vps_disk_struct();
                                        $vps["disks"][$key]["primary"] = $v["userdevice"] == 0 ? 1 : 0;
                                        $vps["disks"][$key]["path"] = "/dev/VG_XenStorage-" . $vdi["sr-uuid"] . "/LV-" . $vdi["uuid"];
                                        $vps["disks"][$key]["format"] = "raw";
                                        if(!file_exists($vps["disks"][$key]["path"])) {
                                            $vps["disks"][$key]["path"] = "/dev/VG_XenStorage-" . $vdi["sr-uuid"] . "/VHD-" . $vdi["uuid"];
                                            $vps["disks"][$key]["format"] = "lv-vhd";
                                        }
                                        $vps["disks"][$key]["type"] = "block";
                                        if(!file_exists($vps["disks"][$key]["path"])) {
                                            $vps["disks"][$key]["path"] = "/run/sr-mount/" . $vdi["sr-uuid"] . "/" . $vdi["uuid"] . ".vhd";
                                            $vps["disks"][$key]["type"] = "file";
                                            $vps["disks"][$key]["format"] = "vhd";
                                        }
                                        if(!file_exists($vps["disks"][$key]["path"])) {
                                        } else {
                                            if($vps["disks"][$key]["type"] == "block") {
                                                $vps["disks"][$key]["size"] = lvsize($vps["disks"][$key]["path"]);
                                            } else {
                                                $vps["disks"][$key]["size"] = round($vdi["virtual-size"] / 1024 / 1024 / 1024, 1);
                                            }
                                            $key += 1;
                                            $space += $vdi["virtual-size"];
                                        }
                                    }
                                }
                            }
                        }
                        $vps["space"] = round($space / 1024 / 1024 / 1024, 1);
                    }
                    $vps["ram"] = ceil($vps_data["memory-actual"] / 1024 / 1024);
                    $cpu_units = $vps_data["VCPUs-params"];
                    $cpu_units = explode(":", $cpu_units);
                    $vps["cpu"] = (int) $cpu_units[1];
                    $vps["cpu"] = empty($vps["cpu"]) ? 1024 : $vps["cpu"];
                    if(preg_match("/pygrub/is", $vps_data["PV-bootloader"])) {
                        $vps["hvm"] = 0;
                    } else {
                        $vps["hvm"] = 1;
                    }
                    $vps["cores"] = $vps_data["VCPUs-number"];
                    $vps_data["platform"] = xcp_data_exploder($vps_data["platform"], ";", 0);
                    $vps["acpi"] = empty($vps_data["platform"]["acpi"]) || $vps_data["platform"]["acpi"] == "false" ? 0 : 1;
                    $vps["apic"] = empty($vps_data["platform"]["apic"]) || $vps_data["platform"]["apic"] == "false" ? 0 : 1;
                    $vps["pae"] = empty($vps_data["platform"]["pae"]) || $vps_data["platform"]["pae"] == "false" ? 0 : 1;
                    $vps["vnc"] = 1;
                    if(!empty($vps_data["networks"])) {
                        $ips = xcp_data_exploder($vps_data["networks"], ";", 0);
                        foreach ($ips as $k => $ip) {
                            if(valid_ip($ip) || valid_ipv6($ip)) {
                                $vps["ips"][] = $ip;
                            }
                        }
                    }
                    $ret_vps[$vps["vps_name"]] = $vps;
                }
            }
            return $ret_vps;
        } else {
            $post["vps_names"] = $vps_names;
            $details = $this->call($serid, "index.php?act=apidoings&do=xcp_import&", 1, [], $post);
            if(empty($details["xcp_import"])) {
                return false;
            }
            return $details["xcp_import"];
        }
    }
    public function vncDetails($vid)
    {
        global $globals;
        global $kernel;
        $vps = getvps($vid);
        if($vps["serid"] == 0) {
            vexec("lsof -h ", $o, $r);
            if($r != 0) {
                package_install("lsof", V_LOG_DIR . "/lsof_install.log");
            }
            return $kernel->vncDetails($vid);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=vncDetails&vpsid=" . $vid);
        if(empty($details["vncDetails"])) {
            return false;
        }
        return $details["vncDetails"];
    }
    public function get_free_vncport($serid, $virt)
    {
        global $globals;
        global $kernel;
        if($serid == 0) {
            return $kernel->get_free_vncport($virt);
        }
        $vnc_port = $this->call($serid, "index.php?act=apidoings&do=get_free_vncport&serid=" . $serid . "&virt=" . $virt);
        if(empty($vnc_port["get_free_vncport"])) {
            return false;
        }
        return $vnc_port["get_free_vncport"];
    }
    public function getmacaddr($vpsid)
    {
        global $globals;
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->getmac($vpsid);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=getmacaddr&vpsid=" . $vpsid);
        if(empty($details["macaddr"])) {
            return false;
        }
        return $details["macaddr"];
    }
    public function changemac_address($macaddr, $vpsid)
    {
        global $globals;
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            return $kernel->change_mac_address($vpsid, $macaddr);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=changemacaddr&mac=" . $macaddr . "&vpsid=" . $vpsid);
        if(empty($details["changemacaddr"])) {
            return false;
        }
        return $details["changemacaddr"];
    }
    public function vpsbackup($backup)
    {
        global $globals;
        global $kernel;
        $vps = getvps($backup["vpsid"]);
        if($vps["serid"] == 0) {
            return $kernel->vpsbackup($backup);
        }
        $post = [];
        foreach ($backup as $k => $v) {
            $post[$k] = $v;
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=vpsbackup", 1, [], $post);
        if(empty($details["vpsbackup"])) {
            return false;
        }
        return $details["vpsbackup"];
    }
    public function get_vpsbackup_details($serid)
    {
        global $globals;
        global $kernel;
        global $error;
        if(empty($serid)) {
            return $kernel->get_vpsbackup_details();
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=vpsbackupdetail&serid=" . $serid);
        if(empty($details["vpsbackupdetail"])) {
            return false;
        }
        return $details["vpsbackupdetail"];
    }
    public function del_vpsbackup($serid, $del)
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->del_vpsbackup($del);
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=del_vpsbackup&del=" . $del);
        if(empty($details["del_vpsbackup"])) {
            return false;
        }
        return $details["del_vpsbackup"];
    }
    public function onfirewall($serid)
    {
        global $globals;
        if(empty($serid)) {
            vexec("which systemctl", $out, $ret);
            if(empty($ret) && file_exists("/etc/init.d/virtfirewall")) {
                @unlink("/etc/init.d/virtfirewall");
            }
            if(empty($ret) || file_exists("/etc/init.d/virtfirewall")) {
                $return = vexec("service virtfirewall start", $output2);
            } else {
                $return = vexec($globals["com"]["php"] . " " . $globals["path"] . "/firewall.php start", $output2);
            }
            if(!empty($return)) {
                return false;
            }
            return true;
        }
        $details = $this->call($serid, "index.php?act=firewall&start=true");
        if(empty($details["action_ret"])) {
            return false;
        }
        return $details["action_ret"];
    }
    public function stopfirewall($serid)
    {
        global $globals;
        if(empty($serid)) {
            if(file_exists("/etc/systemd/system/virtfirewall.service ") || file_exists("/etc/init.d/virtfirewall")) {
                $return = vexec("service virtfirewall stop", $output2);
            } else {
                $return = vexec($globals["com"]["php"] . " " . $globals["path"] . "/firewall.php stop", $output2);
            }
            $return = vexec("service virtfirewall stop", $output2);
            if(!empty($return)) {
                return false;
            }
            return true;
        }
        $details = $this->call($serid, "index.php?act=firewall&stop=true");
        if(empty($details["action_ret"])) {
            return false;
        }
        return $details["action_ret"];
    }
    public function statusfirewall($serid)
    {
        global $globals;
        if(empty($serid)) {
            $return = vexec("service virtfirewall status 2>&1", $output);
            return empty($output) ? [] : $output;
        }
        $details = $this->call($serid, "index.php?act=firewall&status=true");
        if(empty($details["output"])) {
            return [];
        }
        return $details["output"];
    }
    public function restartfirewall($serid)
    {
        global $globals;
        if(empty($serid)) {
            $return = vexec("service virtfirewall restart", $output2);
            if(!empty($return)) {
                return false;
            }
            return true;
        }
        $details = $this->call($serid, "index.php?act=firewall&restart=true");
        if(empty($details["action_ret"])) {
            return false;
        }
        return $details["action_ret"];
    }
    public function versionfirewall($serid)
    {
        if(empty($serid)) {
            $return = vexec("/sbin/iptables -V", $output);
            return empty($output) ? [] : $output;
        }
        $details = $this->call($serid, "index.php?act=firewall&version=true");
        if(empty($details["output"])) {
            return [];
        }
        return $details["output"];
    }
    public function setFirewallpolicy($serid)
    {
        global $globals;
        if(empty($serid)) {
            delete_virt_chains();
            vexec("/sbin/iptables -F");
            apply_default_rules();
            vexec("/sbin/iptables -D VIRT_INPUT -p tcp -m multiport --dport 22 -j ACCEPT", $output1);
            vexec("/sbin/iptables -I VIRT_INPUT -p tcp -m multiport --dport 22 -j ACCEPT", $output1);
            $return = vexec("/usr/sbin/iptables-save", $output);
            $return1 = vexec("/sbin/iptables -L -v ", $output2);
            return array_merge($output1, $output2);
        }
        $details = $this->call($serid, "index.php?act=firewall&setpolicy=true");
        if(empty($details["output"])) {
            return false;
        }
        return $details["output"];
    }
    public function delete_firewall_rule($serid, $id)
    {
        if(empty($serid)) {
            $return = vexec("/sbin/iptables -D VIRT_INPUT " . $id, $output);
            apply_default_rules();
            return $output;
        }
        $details = $this->call($serid, "index.php?act=firewall&delete_rule=" . $id);
        if(empty($details["output"])) {
            return false;
        }
        return $details["output"];
    }
    public function viewfirewall($serid)
    {
        if(empty($serid)) {
            $return = vexec("/sbin/iptables -S", $output);
            return $output;
        }
        $details = $this->call($serid, "index.php?act=firewall&view=1");
        if(empty($details["output"])) {
            return false;
        }
        return $details["output"];
    }
    public function get_iptables_ports($serid)
    {
        global $error;
        global $globals;
        if(empty($serid)) {
            $firewall_conf = get_firewall_config();
            $refined_ports["ACCEPT"] = array_unique($firewall_conf["allowports"]);
            $refined_ports["DROP"] = array_unique($firewall_conf["blockports"]);
            return $refined_ports;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_iptables_ports");
        if(empty($details["get_iptables_ports"])) {
            return false;
        }
        return $details["get_iptables_ports"];
    }
    public function get_iptables_ips($serid)
    {
        if(empty($serid)) {
            $firewall_conf = get_firewall_config();
            foreach ($firewall_conf["allowips"] as $ip => $v) {
                if(empty($v["temp"])) {
                } else {
                    unset($firewall_conf["allowips"][$ip]);
                }
            }
            foreach ($firewall_conf["blockips"] as $ip => $v) {
                if(empty($v["temp"])) {
                } else {
                    unset($firewall_conf["blockips"][$ip]);
                }
            }
            $refined_ips["ACCEPT"] = array_unique(array_keys($firewall_conf["allowips"]));
            $refined_ips["DROP"] = array_unique(array_keys($firewall_conf["blockips"]));
            return $refined_ips;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_iptables_ips");
            if(empty($details["get_iptables_ips"])) {
                return false;
            }
            return $details["get_iptables_ips"];
        }
    }
    public function get_firewall_info($serid)
    {
        if(empty($serid)) {
            return get_firewall_config();
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_firewall_info");
        if(empty($details["get_firewall_info"])) {
            return false;
        }
        return $details["get_firewall_info"];
    }
    public function configure_firewall($serid, $apply_rule = 0)
    {
        global $globals;
        if(empty($serid)) {
            $firewall_config = get_firewall_config();
            $ret = [];
            if(!empty($firewall_config)) {
                if(!empty($apply_rule)) {
                    apply_default_rules();
                }
                return $ret;
            }
            $firewall_conf = [];
            $firewall_conf["test_mode"] = 0;
            $firewall_conf["firewall_enable"] = 0;
            $firewall_conf["test_option"] = "enable";
            $firewall_conf["mins"] = 5;
            $firewall_conf["allowports"] = ["4081:4085", "5900:7000", "25", "80", "443", "587", "8443", "2087", "2086", "10000"];
            $firewall_conf["blockports"] = [];
            $firewall_conf["allowips"] = [];
            $firewall_conf["blockips"] = [];
            save_firewall_config($firewall_conf);
            if(!empty($apply_rule)) {
                apply_default_rules();
            }
            return $ret;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=configure_firewall&apply_rule=" . $apply_rule);
        if(empty($details["configure_firewall"])) {
            return false;
        }
        return $details["configure_firewall"];
    }
    public function enable_disable_firewall_testing($serid, $option, $mins = 0)
    {
        global $globals;
        if(empty($serid)) {
            $this->configure_firewall(0);
            $firewall_testing = get_firewall_config();
            if(!empty($mins)) {
                $firewall_testing["mins"] = $mins;
            }
            if($option == "enable") {
                $firewall_testing["test_option"] = "enable";
            } elseif($option == "disable") {
                $firewall_testing["test_mode"] = 0;
                $firewall_testing["test_option"] = "disable";
            }
            if(!empty($firewall_testing["mins"])) {
                $cron_file = "/etc/cron.d/virtualizor-firewalltest";
                unlink($cron_file);
                $cron = "*/" . $firewall_testing["mins"] . " * * * * root " . $globals["com"]["php"] . " " . $globals["scriptfiles"] . "/firewalltest.php > " . logdir() . "firewalltest.log 2>&1\n\n";
                if(is_safe_file($cron_file)) {
                    writefile($cron_file, $cron, 1);
                }
            }
            save_firewall_config($firewall_testing);
            return true;
        }
        $details = $this->call($serid, "index.php?act=firewall&firewall_testing=" . $option . "&testing_interval=" . $mins);
        if(empty($details["output"])) {
            return false;
        }
        return $details["output"];
    }
    public function ip_allow_block_firewall($serid, $ip, $option, $ip_protocol = "", $ip_port = "", $is_temp = 0)
    {
        global $globals;
        if(empty($serid)) {
            $ret = [];
            $firewall_config = get_firewall_config();
            if(empty($firewall_config["firewall_enable"])) {
                $ret["firewall_disabled"] = 1;
                return $ret;
            }
            apply_default_rules();
            $ip_port = str_replace("-", ":", $ip_port);
            $tmp_ips = cexplode(",", $ip, 0, 1);
            if($option == "allow") {
                $preg_option = "DROP";
                $exec_option = "ACCEPT";
            } else {
                $preg_option = "ACCEPT";
                $exec_option = "DROP";
            }
            if(!empty($firewall_config[$option . "ips"]) && empty($is_temp)) {
                $save_it = 0;
                foreach ($firewall_config[$option . "ips"] as $ip => $v) {
                    if(!in_array($ip, $tmp_ips)) {
                        if(!empty($v["protocol"])) {
                            foreach ($v["protocol"] as $p) {
                                vexec("/sbin/iptables -D VIRT_INPUT -p " . $p . " -s " . $ip . " " . (!empty($v["port"]) ? " -m multiport --dport " . $v["port"] : "") . " -j ACCEPT");
                                vexec("/sbin/iptables -D VIRT_INPUT -p " . $p . " -s " . $ip . " " . (!empty($v["port"]) ? " -m multiport --dport " . $v["port"] : "") . " -j DROP");
                            }
                        } else {
                            vexec("/sbin/iptables -D VIRT_INPUT -p tcp -s " . $ip . " " . (!empty($v["port"]) ? " -m multiport --dport " . $v["port"] : "") . " -j ACCEPT");
                            vexec("/sbin/iptables -D VIRT_INPUT -p tcp -s " . $ip . " " . (!empty($v["port"]) ? " -m multiport --dport " . $v["port"] : "") . " -j DROP");
                        }
                        unset($firewall_config[$option . "ips"][$ip]);
                        $save_it = 1;
                    }
                }
                if($save_it) {
                    $return = vexec("/usr/sbin/iptables-save", $output);
                }
            }
            $umap = ["allow" => "block", "block" => "allow"];
            if(!empty($firewall_config[$umap[$option] . "ips"])) {
                foreach ($firewall_config[$umap[$option] . "ips"] as $pk => $p) {
                    if(in_array($pk, $tmp_ips)) {
                        unset($firewall_config[$umap[$option] . "ips"][$pk]);
                    }
                }
            }
            $tmp_ports = explode(",", $ip_port);
            foreach ($tmp_ports as $p) {
                if(in_array((int) trim($p), [4085, 4084, 4083, 4082, 4081])) {
                    $output["error"] = "port_default";
                    return $output;
                }
            }
            if(!empty($tmp_ips)) {
                foreach ($tmp_ips as $ip) {
                    $ip = trim($ip);
                    $return = vexec("iptables -S VIRT_INPUT", $search_output);
                    unset($search_output[0]);
                    $has_rule = 0;
                    $ipval = str_replace(".", "\\.", $ip);
                    if(!empty($search_output)) {
                        foreach ($search_output as $kl => $v) {
                            if((preg_match("/" . $exec_option . "\\b/i", $v) || preg_match("/" . $preg_option . "\\b/i", $v)) && preg_match("/" . $ipval . "\\b/i", $v) && preg_match("/" . $ip_protocol . "\\b/i", $v)) {
                                $has_rule = 1;
                                $return = vexec("/sbin/iptables -D VIRT_INPUT " . $kl, $output1);
                                $return = vexec("/sbin/iptables -I VIRT_INPUT " . (!empty($ip_protocol) ? " -p " . $ip_protocol : (!empty($ip_port) ? " -p tcp" : "")) . " -s " . $ip . " " . (!empty($ip_port) ? " -m multiport --dport " . $ip_port : "") . " -j " . $exec_option, $output1);
                                if($return == "0") {
                                    $return = vexec("/usr/sbin/iptables-save", $output);
                                    $firewall_config[$option . "ips"][$ip]["ip"] = $ip;
                                    $firewall_config[$option . "ips"][$ip]["port"] = $ip_port;
                                    $firewall_config[$option . "ips"][$ip]["temp"] = 0;
                                    if(!empty($is_temp)) {
                                        $firewall_config[$option . "ips"][$ip]["temp"] = 1;
                                    }
                                    $firewall_config[$option . "ips"][$ip]["protocol"][$ip_protocol] = $ip_protocol;
                                } else {
                                    $ret["err_ips"][] = $ip;
                                }
                            }
                        }
                    }
                    if(empty($has_rule)) {
                        $return = "1";
                        if($return == "1") {
                            $return = vexec("/sbin/iptables -I VIRT_INPUT " . (!empty($ip_protocol) ? " -p " . $ip_protocol : (!empty($ip_port) ? " -p tcp" : "")) . " -s " . $ip . " " . (!empty($ip_port) ? " -m multiport --dport " . $ip_port : "") . " -j " . $exec_option, $output1);
                            if($return == "0") {
                                $return = vexec("/usr/sbin/iptables-save", $output);
                            } else {
                                $ret["err_ips"][] = $ip;
                            }
                        }
                        $firewall_config[$option . "ips"][$ip]["ip"] = $ip;
                        $firewall_config[$option . "ips"][$ip]["port"] = $ip_port;
                        $firewall_config[$option . "ips"][$ip]["temp"] = 0;
                        if(!empty($is_temp)) {
                            $firewall_config[$option . "ips"][$ip]["temp"] = 1;
                        }
                        $firewall_config[$option . "ips"][$ip]["protocol"][$ip_protocol] = $ip_protocol;
                    }
                }
            }
            save_firewall_config($firewall_config);
            return $ret;
        } else {
            $details = $this->call($serid, "index.php?act=firewall&ip_" . $option . "=true&ip=" . $ip . "&option=" . $option . "&ip_protocol=" . $ip_protocol . "&ip_port=" . $ip_port . "&is_temp=" . $is_temp);
            return $details["action_ret"];
        }
    }
    public function allow_block_portfirewall($serid, $port, $option)
    {
        global $error;
        global $globals;
        if(empty($serid)) {
            $ret = [];
            $firewall_config = get_firewall_config();
            if(empty($firewall_config["firewall_enable"])) {
                $ret["firewall_disabled"] = 1;
                return $ret;
            }
            apply_default_rules();
            $port = str_replace("-", ":", $port);
            $tmp_ports = explode(",", $port);
            if($option == "allow") {
                $preg_option = "DROP";
                $exec_option = "ACCEPT";
            } else {
                $preg_option = "ACCEPT";
                $exec_option = "DROP";
            }
            if(!empty($firewall_config[$option . "ports"])) {
                $save_it = 0;
                foreach ($firewall_config[$option . "ports"] as $p) {
                    if(!in_array($p, $tmp_ports) && !in_array($p, [4085, 4084, 4083, 4082, 4081])) {
                        vexec("/sbin/iptables -D VIRT_INPUT -p tcp --dport  " . $p . " -j " . $exec_option, $output1);
                        vexec("/sbin/iptables -D VIRT_INPUT -p tcp --dport  " . $p . " -j " . $preg_option, $output1);
                        unset($firewall_config[$option . "ports"][$p]);
                        $save_it = 1;
                    }
                }
                if($save_it) {
                    $return = vexec("/usr/sbin/iptables-save", $output);
                }
            }
            $umap = ["allow" => "block", "block" => "allow"];
            if(!empty($firewall_config[$umap[$option] . "ports"])) {
                foreach ($firewall_config[$umap[$option] . "ports"] as $pk => $p) {
                    if(in_array($p, $tmp_ports)) {
                        unset($firewall_config[$umap[$option] . "ports"][$pk]);
                    }
                }
            }
            if(!empty($tmp_ports[0])) {
                foreach ($tmp_ports as $port) {
                    $port = trim($port);
                    if(in_array($port, [4085, 4084, 4083, 4082, 4081])) {
                        $output["error"] = "port_default";
                        $o[] = $output;
                    } else {
                        $return = vexec("iptables -S VIRT_INPUT", $search_output);
                        unset($search_output[0]);
                        $has_rule = 0;
                        if(!empty($search_output)) {
                            foreach ($search_output as $kl => $v) {
                                if((preg_match("/" . $exec_option . "\\b/i", $v) || preg_match("/" . $preg_option . "\\b/i", $v)) && preg_match("/\\b" . $port . "\\b/is", $v)) {
                                    $has_rule = 1;
                                    $return = vexec("/sbin/iptables -D VIRT_INPUT " . $kl, $output1);
                                    $return = vexec("/sbin/iptables -I VIRT_INPUT -p tcp --dport  " . $port . " -j " . $exec_option, $output1);
                                    if($return == "0") {
                                        $return = vexec("/usr/sbin/iptables-save", $output);
                                        $o[] = $output;
                                    } else {
                                        $ret["err_ports"][] = $port;
                                    }
                                }
                            }
                        }
                        if(empty($has_rule)) {
                            $return = "1";
                            if($return == "1") {
                                $return = vexec("/sbin/iptables -I VIRT_INPUT -p tcp --dport  " . $port . " -j " . $exec_option, $output1);
                                if($return == "0") {
                                    $return = vexec("/usr/sbin/iptables-save", $output);
                                } else {
                                    $ret["err_ports"][] = $port;
                                }
                            }
                        }
                    }
                }
            }
            $firewall_config[$option . "ports"] = empty($tmp_ports[0]) ? [] : $tmp_ports;
            if($option == "allow" && empty($tmp_ports[0])) {
                apply_default_rules();
                $firewall_config["allowports"] = ["4081:4085", "5900:7000", "25", "80", "443", "587", "8443", "2087", "2086", "10000"];
            }
            save_firewall_config($firewall_config);
            return $ret;
        } else {
            $details = $this->call($serid, "index.php?act=firewall&" . $option . "=true&port=" . $port . "&option=" . $option);
            return $details["action_ret"];
        }
    }
    public function searchip($serid, $ip)
    {
        global $globals;
        if(empty($serid)) {
            $return = vexec("/sbin/iptables -S | grep \"" . $ip . "\"", $output);
            if($return == "0") {
                return $output;
            }
            return false;
        }
        $details = $this->call($serid, "index.php?act=firewall&search=true&ip=" . $ip);
        if(empty($details["output"])) {
            return false;
        }
        return $details["output"];
    }
    public function get_kernel_version($serid)
    {
        global $kernel;
        if($serid == 0) {
            oexec("/bin/uname -r", $uname);
            return $uname;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_kernel_version");
        if(empty($details["info"]["kernel_name"])) {
            return false;
        }
        return $details["info"]["kernel_name"];
    }
    public function adderror($newerror)
    {
        global $error;
        foreach ($newerror as $k => $v) {
            if(is_numeric($k)) {
                $error[] = $v;
            } else {
                $error[$k] = $v;
            }
        }
    }
    public function createnat($serid, $data = [])
    {
        global $error;
        global $globals;
        if($serid == 0) {
            $name = $data["nat_name"];
            $conf = "<network>\n<name>" . $name . "</name>\n<forward mode='route'/>\n<bridge name='" . $name . "' dev='" . (empty($globals["interface"]) ? "eth0" : $globals["interface"]) . "' />\n<ip address='" . $data["gateway"] . "' netmask='" . $data["netmask"] . "'>\n</ip>\n</network>";
            writefile("/usr/share/libvirt/networks/" . $name . ".xml", $conf, 1);
            @chmod("/usr/share/libvirt/networks/" . $name . ".xml", 384);
            vexec("/usr/bin/virsh net-define /usr/share/libvirt/networks/" . $name . ".xml");
            vexec("/usr/bin/virsh net-autostart " . $name);
            vexec("/usr/bin/virsh net-start " . $name);
            return true;
        }
        $post["data"] = $data;
        $details = $this->call($serid, "index.php?act=apidoings&do=createnat", 1, [], $post);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["createnat"])) {
            return false;
        }
        return $details["createnat"];
    }
    public function destroynat($serid, $nat_name)
    {
        global $error;
        if($serid == 0) {
            vexec("/usr/bin/virsh net-destroy " . $nat_name);
            vexec("/usr/bin/virsh net-undefine " . $nat_name);
            return true;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=destroynat&nat_name=" . $nat_name, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["destroynat"])) {
            return false;
        }
        return $details["destroynat"];
    }
    public function set_vpsbackup_cron($serid, $data)
    {
        global $globals;
        if($serid == 0) {
            if($data["frequency"] == "daily") {
                $cron = $data["min"] . " " . $data["hrs"] . " * * * root " . $globals["com"]["php"] . " /usr/local/virtualizor/scripts/vpsbackups.php >> /dev/null 2>&1\n";
            } elseif($data["frequency"] == "weekly") {
                $cron = $data["min"] . " " . $data["hrs"] . " * * " . $data["day"] . " root " . $globals["com"]["php"] . " /usr/local/virtualizor/scripts/vpsbackups.php >> /dev/null 2>&1\n";
            } elseif($data["frequency"] == "monthly") {
                $cron = $data["min"] . " " . $data["hrs"] . " " . $data["date"] . " * * root " . $globals["com"]["php"] . " /usr/local/virtualizor/scripts/vpsbackups.php >> /dev/null 2>&1\n";
            } elseif($data["frequency"] == "hourly") {
                $cron = "0 */" . $data["hourly_freq"] . " * * * root " . $globals["com"]["php"] . " /usr/local/virtualizor/scripts/vpsbackups.php >> /dev/null 2>&1\n";
            }
            if(!writefile("/etc/cron.d/virtualizor-backups", $cron, 1)) {
                return false;
            }
            return true;
        }
        $post["data"] = $data;
        $details = $this->call($serid, "index.php?act=apidoings&do=setvpsbackupcron", 1, [], $post);
        if(!empty($details["setvpsbackupcron"])) {
            return true;
        }
        return false;
    }
    public function set_backup_plan_crons($serid)
    {
        global $globals;
        if($serid == 0) {
            $backup_crons = glob("/etc/cron.d/virtualizor-backups-b*");
            foreach ($backup_crons as $bcron) {
                if(is_safe_file($bcron)) {
                    @unlink($bcron);
                }
            }
            $res = makequery("SELECT * FROM backup_plans WHERE frequency NOT IN ('manual') AND `disabled` = 0 ");
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                set_backup_cron($row);
            }
            return true;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=setbackupplancrons", 1);
            if(!empty($details["setbackupplancrons"])) {
                return true;
            }
            return false;
        }
    }
    public function set_databasebackup_cron($serid, $data)
    {
        global $globals;
        if($serid == 0) {
            $cron = $data . " root " . $globals["com"]["php"] . " /usr/local/virtualizor/scripts/databasebackups.php -r >> " . logdir() . "virtualizor-dbbackup.log\n";
            if(!writefile("/etc/cron.d/virtualizor-databasebackups", $cron, 1)) {
                return false;
            }
            return true;
        }
    }
    public function restore_vps($serid, $vpsid, $backup_date, $backup_vpsid = 0)
    {
        global $globals;
        global $error;
        global $l;
        if($serid == 0) {
            $res = makequery("SELECT * FROM `tasks` WHERE action = \"restorevps\"\n\t\t\t\t\t\t\tAND started > 0\n\t\t\t\t\t\t\tAND ended = 0\n\t\t\t\t\t\t\tAND updated >= :updated", [":updated" => time() - $globals["notupdated_task"]]);
            if(0 < vsql_num_rows($res)) {
                $row = vsql_fetch_assoc($res);
                $prev_process = unserialize($row["data"]);
                vexec("/bin/ps " . $prev_process["pid"], $output);
                if(1 < count($output)) {
                    $error[] = $l["err_restore_process_running"];
                    return false;
                }
            }
            $res = makequery("SELECT * FROM `vps` WHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
            if(vsql_num_rows($res) == 0) {
                $error[] = $l["err_nonexistant_vps"];
                return false;
            }
            $barg = empty($backup_vpsid) ? "" : "-b" . $backup_vpsid;
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/restorevps.php -v" . $vpsid . " -d" . $backup_date . " " . $barg . " >> /dev/null 2>&1 &");
            return true;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=vpsrestore&vpsid=" . $vpsid . "&backupdate=" . $backup_date . "&backupvpsid=" . $backup_vpsid, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["vpsrestore"])) {
            return false;
        }
        return $details["vpsrestore"];
    }
    public function list_vps_backups($serid, $selected_date)
    {
        global $l;
        if($serid == 0) {
            $backup_settings = [];
            $res = makequery("SELECT * FROM vpsbackup_settings WHERE serid=:serid", [":serid" => $serid]);
            $row = vsql_fetch_assoc($res);
            $backup_settings = $row;
            if(vsql_num_rows($res) < 1) {
                return false;
            }
            if(!empty($backup_settings["bid"])) {
                $backup_server = [];
                $res = makequery("SELECT * FROM backup_servers WHERE bid=:bid", [":bid" => $backup_settings["bid"]]);
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $backup_server = $row;
                }
                if($backup_server["type"] == "SSH") {
                    $connection = connect_ssh($backup_server);
                    if(!$connection) {
                        log_output($l["log_err_ssh_conn"]);
                        $mail_error_log[] = $l["log_err_ssh_conn"];
                        return false;
                    }
                    return get_ssh_backup_list($connection, $backup_settings["dir"], $selected_date);
                }
                $ftp_con = connect_ftp($backup_server);
                if(!$ftp_con) {
                    $error[] = $l["err_ftp_connect"];
                    return false;
                }
                return get_backups_list($ftp_con, $backup_settings["dir"], $selected_date);
            }
            return get_backups_list(0, $backup_settings["dir"], $selected_date);
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=list_vps_backups&selected_date=" . $selected_date, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["list_vps_backups"])) {
            return false;
        }
        return $details["list_vps_backups"];
    }
    public function delete_vps_backup($serid, $vpsid, $backup_date)
    {
        global $globals;
        global $error;
        global $l;
        if($serid == 0) {
            $backup_settings = [];
            $res = makequery("SELECT * FROM vpsbackup_settings WHERE serid=:serid", [":serid" => $serid]);
            $row = vsql_fetch_assoc($res);
            $backup_settings = $row;
            if(!empty($backup_settings["bid"])) {
                $backup_server = [];
                $res = makequery("SELECT * FROM backup_servers WHERE bid=:bid", [":bid" => $backup_settings["bid"]]);
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $backup_server = $row;
                }
                if($backup_server["type"] == "SSH") {
                    $connection = connect_ssh($backup_server);
                    if(!$connection) {
                        log_output($l["log_err_ssh_conn"]);
                        $mail_error_log[] = $l["log_err_ssh_conn"];
                        return false;
                    }
                    if(!ssh2_exec($connection, "rm -f " . $backup_settings["dir"] . "/" . $backup_date . "/" . $vpsid . ".*")) {
                        return false;
                    }
                } else {
                    $ftp_con = connect_ftp($backup_server);
                    if(!$ftp_con) {
                        $error[] = $l["err_ftp_connect"];
                        return false;
                    }
                    $tar_res = ftp_delete($ftp_con, $backup_settings["dir"] . "/" . $backup_date . "/" . $vpsid . ".tar.gz");
                    $img_res = ftp_delete($ftp_con, $backup_settings["dir"] . "/" . $backup_date . "/" . $vpsid . ".img");
                    $img_res = ftp_delete($ftp_con, $backup_settings["dir"] . "/" . $backup_date . "/" . $vpsid . ".img.gz");
                    if(!$tar_res && !$img_res) {
                        return false;
                    }
                    $res = ftp_delete($ftp_con, $backup_settings["dir"] . "/" . $backup_date . "/" . $vpsid . ".inf");
                }
            } else {
                $backup_to_delete = $backup_settings["dir"] . "/" . $backup_date . "/" . $vpsid;
                if(!@unlink($backup_to_delete . ".tar.gz") && !@unlink($backup_to_delete . ".img") && !@unlink($backup_to_delete . ".img.gz")) {
                    return false;
                }
                @unlink($backup_settings["dir"] . "/" . $backup_date . "/" . $vpsid . ".inf");
            }
            return true;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=delete_vps_backup&vpsid=" . $vpsid . "&backup_date=" . $backup_date, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["delete_vps_backup"])) {
            return false;
        }
        return $details["delete_vps_backup"];
    }
    public function create_internal_network($serid, $data = [])
    {
        global $error;
        global $globals;
        global $kernel;
        if($serid == 0) {
            $kernel->create_internal_network($data["ippid"], $data["bind_ip"]);
            return true;
        }
        $post["data"] = $data;
        $details = $this->call($serid, "index.php?act=apidoings&do=create_internal_network", 1, [], $post);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["create_internal_network"])) {
            return false;
        }
        return $details["create_internal_network"];
    }
    public function destroy_internal_network($serid, $ippid)
    {
        global $error;
        global $globals;
        global $kernel;
        if($serid == 0) {
            $kernel->destroy_internal_network($ippid);
            return true;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=destroy_internal_network&ippid=" . $ippid, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["destroy_internal_network"])) {
            return false;
        }
        return $details["destroy_internal_network"];
    }
    public function getvpsdata($serid, $vpsid)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if($serid == 0) {
            $vps_name = $kernel->getname($vpsid);
            $_vps = getvps($vpsid);
            $virt = $_vps["virt"];
            if($virt != "openvz") {
                $vpsdata["conf"] = $kernel->get_raw_conf($vpsid);
            }
            $res = makequery("SELECT * FROM `vps` \n\t\t\t\t\t\t WHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
            $vps_db = [];
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $vpsdata["vps_db"] = $row;
            }
            return $vpsdata;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=getvpsdata&vpsid=" . $vpsid, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["getvpsdata"])) {
            return false;
        }
        return $details["getvpsdata"];
    }
    public function migrate($serid, $migrate, $vpsid, $uid)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if($serid == 0) {
            vexec("echo \"1 - Starting migration on destination\" >> " . logdir("migrate") . $vpsid . "-dest.log");
            $actid = tasks_admin_process("migratedest", serialize($migrate), 1, $vpsid, $uid, 0, 0);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/migrate.php " . $actid . " >> " . logdir("migrate") . $vpsid . "-dest.log 2>&1 &");
            vexec("echo \"1.1 - Exit from cluster - Control Given to background Migrate script\" >> " . logdir("migrate") . $vpsid . "-dest.log");
            return true;
        }
        $post = [];
        $post["migrate"] = $migrate;
        $post["vpsid"] = $vpsid;
        $post["uid"] = $uid;
        $details = $this->call($serid, "index.php?act=apidoings&do=migrate", 1, [], $post);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["migrate"])) {
            return false;
        }
        return $details["migrate"];
    }
    public function migrate2($serid, $migrate, $vpsid, $uid)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if(!in_array($migrate["selected_act"], ["migrate", "clone"])) {
            return false;
        }
        if($serid == 0) {
            vexec("echo \"1 - Starting migration from source\" >> " . logdir($migrate["selected_act"]) . $vpsid . "-source.log");
            $actid = tasks_admin_process($migrate["selected_act"] . "2", serialize($migrate), 1, $vpsid, $uid, 0, 0);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/migrate2.php " . $actid . " >> " . logdir($migrate["selected_act"]) . $vpsid . "-source.log 2>&1 &");
            vexec("echo \"1.1 - Exit from cluster - Control Given to background Migrate script\" >> " . logdir($migrate["selected_act"]) . $vpsid . "-source.log");
            return $actid;
        }
        $post = [];
        $post["migrate"] = $migrate;
        $post["vpsid"] = $vpsid;
        $post["uid"] = $uid;
        $post["selected_act"] = $migrate["selected_act"];
        $details = $this->call($serid, "index.php?act=apidoings&do=migrate2", 1, [], $post);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["migrate2"])) {
            return false;
        }
        return $details["migrate2"];
    }
    public function post_migrate2($serid, $vpsid, $success = false, $live_mig = false, $is_src = false)
    {
        global $globals;
        global $error;
        global $kernel;
        if($serid == 0) {
            if(!$kernel->post_migrate($vpsid, $success, $live_mig, $is_src)) {
                return false;
            }
        } else {
            $post["vpsid"] = $vpsid;
            $post["success"] = $success;
            $post["live_mig"] = $live_mig;
            $post["is_src"] = $is_src;
            $details = $this->call($serid, "index.php?act=apidoings&do=post_migrate2", 1, [], $post);
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
                return false;
            }
            if(empty($details["post_migrate2"])) {
                return false;
            }
        }
        return true;
    }
    public function ovzdump_del($vpsid)
    {
        global $theme;
        global $globals;
        global $cluster;
        global $user;
        global $l;
        global $done;
        global $error;
        global $kernel;
        global $file;
        $filepath = "/var/virtualizor/migratedump";
        if(!@unlink($filepath . "/" . $vpsid . ".tar.gz")) {
            $file["error"] = "Unable to delete the dump";
            return $file;
        }
        return true;
    }
    public function ovzdump($vpsname)
    {
        global $theme;
        global $globals;
        global $cluster;
        global $user;
        global $l;
        global $done;
        global $error;
        global $kernel;
        global $file;
        set_time_limit(0);
        $res = makequery("SELECT * FROM `vps`\n\t\t\t\t\t\tWHERE vps_name = :vps_name", [":vps_name" => $vpsname]);
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        $vps = vsql_fetch_assoc($res);
        $vpsid = $vps["vpsid"];
        $filepath = "/var/virtualizor/migratedump";
        vexec("echo \"[ovzdump] Backing Up\" >> " . logdir("migrate") . $vpsid . "-src.log");
        $filename = $kernel->backup($vps, $filepath, 0);
        if(empty($filename)) {
            $error["derr"] = array_end($GLOBALS["logr"]);
            $logpath = logdir("migrate") . $vpsid . "-src.log";
            $log = file_get_contents($logpath);
            writefile($logpath, $log . "[ovzdump] Error Backing Up\n" . var_export($error, 1), 1);
            $file["error"] = "Error creating the dump" . var_export($error, 1);
            return $file;
        }
        vexec("echo \"[ovzdump] Backup Done\" >> " . logdir("migrate") . $vpsid . "-src.log");
        $filesize = @vfilesize($filepath . "/" . $filename);
        if($filesize < 1) {
            $file["error"] = "File size not appropriate";
            return $file;
        }
        $file["name"] = $filename;
        $file["id"] = $vps["vpsid"];
        $file["size"] = $filesize;
        return $file;
    }
    public function getmprog($serid, $vpsid)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if($serid == 0) {
            $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\t\t  WHERE vpsid = :vpsid AND action = 'migratedest'", [":vpsid" => $vpsid]);
            if(0 < vsql_num_rows($res)) {
                for ($i = 0; $i < vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $tasks[$row["actid"]] = $row;
                }
            }
            return $tasks;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=getmprog&vpsid=" . $vpsid, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["getmprog"])) {
            return false;
        }
        return $details["getmprog"];
    }
    public function get_vpsbackups_log($serid, $log_len = 50)
    {
        global $error;
        global $globals;
        if(empty($log_len)) {
            $log_len = 50;
        }
        if($serid == 0) {
            vexec("/usr/bin/tail -" . $log_len . " " . logdir() . "virtualizor-backups.log", $log_output);
            return implode("\n", $log_output);
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_vpsbackups_log&log_len=" . $log_len, 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["get_vpsbackups_log"])) {
            return false;
        }
        return $details["get_vpsbackups_log"];
    }
    public function clear_vpsbackups_log($serid)
    {
        global $error;
        global $globals;
        if($serid == 0) {
            $h = fopen(logdir() . "virtualizor-backups.log", "w");
            return fclose($h);
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=clear_vpsbackups_log", 1);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["clear_vpsbackups_log"])) {
            return false;
        }
        return $details["clear_vpsbackups_log"];
    }
    public function backupnow($serid)
    {
        global $error;
        global $globals;
        if($serid == 0) {
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/vpsbackups.php >> " . logdir() . "vpsbackups.log 2>&1 &");
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=backupnow", 1);
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
                return false;
            }
            if(empty($details["backupnow"])) {
                return false;
            }
            return $details["backupnow"];
        }
    }
    public function build_dhcp($serid = 0)
    {
        global $error;
        global $globals;
        global $servers;
        global $oslist;
        if($serid == 0) {
            $vpsres = makequery("SELECT * FROM vps\n\t\t\t\t\t\t\t\tWHERE serid = 0");
            for ($i = 1; $i <= vsql_num_rows($vpsres); $i++) {
                $row = vsql_fetch_assoc($vpsres);
                $vs[$row["vpsid"]] = $row;
            }
            if(!empty($vs)) {
                $vs_tokens = vsql_in_tokens(array_keys($vs));
                $res = makequery("SELECT * FROM ips\n\t\t\t\t\t\t\tWHERE vpsid in (" . $vs_tokens["query"] . ")\n\t\t\t\t\t\t\tORDER BY vpsid ASC, `primary` DESC", $vs_tokens["tokens"]);
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $vs[$row["vpsid"]]["ips"][$row["ipid"]] = $row["ip"];
                }
            }
            oslist();
            foreach ($vs as $xc => $yc) {
                $vps_data[$yc["vpsid"]]["vps_name"] = $yc["vps_name"];
                $vps_data[$yc["vpsid"]]["ip"] = current($yc["ips"]);
                $vps_data[$yc["vpsid"]]["mac"] = $this->getmacaddr($yc["vpsid"]);
                $res = makequery("SELECT * FROM ips\n\t\t\t\t\t\t\t\tWHERE ip = :ip", [":ip" => $vps_data[$yc["vpsid"]]["ip"]]);
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $ipids[$row["ippid"]] = $row["ippid"];
                    $vps_data[$yc["vpsid"]]["ippid"] = $row["ippid"];
                }
            }
            if(!empty($ipids)) {
                $ipids_tokens = vsql_in_tokens(array_keys($ipids));
                $res = makequery("SELECT * FROM ippool\n\t\t\t\t\t\t\tWHERE ippid IN (" . $ipids_tokens["query"] . ")", $ipids_tokens["tokens"]);
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $ippools[$row["ippid"]] = $row;
                }
            }
            if(!distro_check(0, 0, 1, 0)) {
                $ifpath = "/etc/sysconfig/dhcpd";
            } else {
                $ifpath = "/etc/default/isc-dhcp-server";
            }
            $file = file($ifpath);
            foreach ($file as $k => $v) {
                if(preg_match("/\\DHCPDARGS\\b\\=/is", $v)) {
                    $file[$k] = (distro_check(0, 0, 1, 1) ? "INTERFACES" : "DHCPDARGS") . "=\"" . $globals["dhcp_interface"] . "\"";
                }
            }
            writefile($ifpath, implode("", $file), 1);
            $final_conf = [];
            foreach ($vps_data as $d => $k) {
                $final_conf[$d]["vps_name"] = $k["vps_name"];
                $final_conf[$d]["ip"] = $k["ip"];
                $final_conf[$d]["mac"] = $k["mac"];
                foreach ($ippools as $key => $val) {
                    if($k["ippid"] == $key) {
                        $final_conf[$d]["gateway"] = $val["gateway"];
                        $final_conf[$d]["netmask"] = $val["netmask"];
                        $final_conf[$d]["ns1"] = $val["ns1"];
                        $final_conf[$d]["ns2"] = $val["ns2"];
                    }
                }
            }
            $conf_data = "\n### Virtualizor DHCP Configuration\n\n\t\t\t\nsubnet 0.0.0.0 netmask 0.0.0.0 {\n\tdeny-unknown-clients;\n\tauthoritative;\n\tdefault-lease-time 21600000;\n\tmax-lease-time 432000000;\n}\n\n" . (!distro_check(0, 0, 1, 0, 1, 1, 1) ? "ddns-update-style ad-hoc;" : "");
            foreach ($final_conf as $key => $val) {
                if(!valid_ip($val["ip"])) {
                } else {
                    $addhash = "";
                    if(empty($val["gateway"])) {
                        $addhash = "#";
                    }
                    if(!empty($addhash)) {
                        $conf_data .= "\n# THIS IS COMMENTED BECAUSE THIS IP DOES NOT HAVE GATEWAY";
                    }
                    $conf_data .= "\n\n" . $addhash . "host vm" . $val["vps_name"] . " {\n" . $addhash . "\thardware ethernet " . trim($val["mac"]) . ";\n" . $addhash . "\t" . (!empty($val["gateway"]) ? "option routers " . $val["gateway"] . ";" : "") . "\n" . $addhash . "\toption subnet-mask " . (empty($val["netmask"]) ? "255.255.255.0" : $val["netmask"]) . ";\n" . $addhash . "\tfixed-address " . $val["ip"] . ";\n" . $addhash . "\toption domain-name-servers " . (empty($val["ns1"]) ? "4.2.2.1,4.2.2.2" : $val["ns1"] . "," . $val["ns2"]) . ";\n" . $addhash . "}";
                }
            }
            if(distro_check(0, 1, 1, 0, 1, 1, 1)) {
                $conf_path = "/etc/dhcp/dhcpd.conf";
            } else {
                $conf_path = "/etc/dhcpd.conf";
            }
            writefile($conf_path, $conf_data, 1);
            if(distro_check(0, 0, 1, 0)) {
                vexec("service isc-dhcp-server restart");
            } else {
                vexec("service dhcpd restart");
            }
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=build_dhcp", 1);
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
                return false;
            }
            if(empty($details["build_dhcp"])) {
                return false;
            }
            return $details["build_dhcp"];
        }
    }
    public function novnc_start($serid)
    {
        global $error;
        global $globals;
        global $servers;
        $use_serid = $serid;
        if(!empty($globals["novnc_master_only"])) {
            $use_serid = -1;
            $serid = 0;
        }
        if(posix_getuid() != 0) {
            $not_root = 1;
        }
        if($serid == 0 && empty($not_root)) {
            $vpsres = makequery("SELECT * FROM vps\n\t\t\t\t\t\t\t\tWHERE vnc > 0\n\t\t\t\t\t\t\t\tAND vncport > 0\n\t\t\t\t\t\t\t\t" . ($use_serid < 0 ? "" : "AND serid = 0") . "\n\t\t\t\t\t\t\t\tORDER BY serid, vpsid");
            for ($i = 1; $i <= vsql_num_rows($vpsres); $i++) {
                $row = vsql_fetch_assoc($vpsres);
                $vs[$row["vpsid"]] = $row;
            }
            $vps_data = "";
            foreach ($vs as $k => $v) {
                if($v["virt"] == "xcp") {
                    $vnc_ip = "127.0.0.1";
                    $vnc_token = $v["vpsid"] . "-" . $v["vnc_passwd"];
                } else {
                    $vnc_ip = server_vncip($v["serid"]);
                    $vnc_token = $v["vpsid"];
                }
                $vps_name = str_replace("v", "", $v["vps_name"]);
                $vps_data .= $vnc_token . ": " . $vnc_ip . ":" . vncPort($v) . "" . "\n";
            }
            $target_config = $globals["path"] . "/conf/novnc.vnc";
            writefile($target_config, $vps_data, 1);
            if(fileperms($globals["themes"] . "/default/novnc/utils/websockify") != 448) {
                chmod($globals["themes"] . "/default/novnc/utils/websockify", 448);
                chmod($globals["themes"] . "/default/novnc/utils/nova-novncproxy", 448);
                chmod($globals["themes"] . "/default/novnc/utils/rebind", 448);
                chmod($globals["themes"] . "/default/novnc/utils/u2x11", 448);
            }
            $ubuntu_major_version = 0;
            $os_info = os_details();
            if($os_info["distro"] == "ubuntu") {
                $ubuntu_version = explode(".", $os_info["version"]);
                $ubuntu_major_version = (int) $ubuntu_version[0];
            }
            if(distro_check(0, 0, 0, 0, 0, 0, 1) || get_pveversion() == 8 || 22 <= $ubuntu_major_version) {
                vexec("which python3", $tmp_o, $tmp_r);
                if($tmp_r != 0) {
                    package_install("python3");
                }
                vexec("websockify --help", $tmp_o, $tmp_r);
                if($tmp_r != 0) {
                    package_install("python-websockify");
                    exec("websockify --help", $websockify_out, $websocikfy_ret);
                    if($websocikfy_ret == "0") {
                        exec("find /usr/lib -name websocketproxy.py", $find_out, $find_ret);
                        if($find_ret == "0") {
                            shell_exec("sed -i \"s/'token'/'virttoken'/g\" " . $find_out[0]);
                        }
                    }
                }
                vexec("websockify -D :4081 --target-config=" . $target_config . " --web " . $globals["themes"] . "/default/novnc/ --cert=" . $globals["path"] . "/conf/virtualizor.crt --key=" . $globals["path"] . "/conf/virtualizor.key >> " . logdir() . "novnc");
            } else {
                if(!is_link("/usr/bin/python")) {
                    vexec("which python2", $_o, $_r);
                    if($_r != 0) {
                        package_install("python2");
                    }
                    vexec("which python2", $_o, $_r);
                    if($_r != 0) {
                        return false;
                    }
                    vexec("ln -s " . $_o[0] . " /usr/bin/python");
                }
                vexec($globals["themes"] . "/default/novnc/utils/websockify -D :4081 --target-config=" . $target_config . " --web " . $globals["themes"] . "/default/novnc/ --cert=" . $globals["path"] . "/conf/virtualizor.crt --key=" . $globals["path"] . "/conf/virtualizor.key >> " . logdir() . "novnc");
            }
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=novnc_start", 1);
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
                return false;
            }
            if(empty($details["novnc_start"])) {
                return false;
            }
            return $details["novnc_start"];
        }
    }
    public function novnc_stop($serid)
    {
        global $error;
        global $globals;
        global $servers;
        if($serid == 0) {
            vexec("kill -9 `lsof -t -i:4081`");
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=novnc_stop", 1);
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
                return false;
            }
            if(empty($details["novnc_stop"])) {
                return false;
            }
            return $details["novnc_stop"];
        }
    }
    public function storage_check($serid, $data)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if($serid == 0) {
            return $kernel->storage_check($data);
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=storage_check", 1, $data);
        if(empty($details)) {
            $this->adderror(["[storage_check] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["storage_check"];
    }
    public function multivirt($serid, $data = "")
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if($serid == 0) {
            $actid = tasks_admin_process("multivirt", $data);
            vexec("/usr/local/emps/bin/php /usr/local/virtualizor/scripts/multivirt.php " . $actid . " > " . logdir() . "multivirt 2>&1 &");
            return $actid;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=multivirt&start=1", 1, $data);
        if(empty($details)) {
            $this->adderror(["[multivirt] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["multivirt"];
    }
    public function installha($serid, $data = "")
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if($serid == 0) {
            $actid = tasks_admin_process("installha", $data);
            vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/installha.php " . $actid . " > " . logdir() . "installha.log 2>&1 &");
            return $actid;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=installha", 1, $data);
        if(empty($details)) {
            $this->adderror(["[installha] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["installha"];
    }
    public function os_distro_check($serid, $distro = "", $value = true)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $os_name = $servers[$serid]["os"];
        $distro = strtolower($distro);
        if(in_array($distro, ["centos", "sl", "almalinux", "rocky", "oracle"])) {
            $distro = "rhel";
        }
        if($distro == "debian") {
            $distro = "ubuntu";
        }
        if($distro == "rhel") {
            if(preg_match("/centos|Red Hat|Scientific|AlmaLinux|Rocky/is", $os_name)) {
                return $value;
            }
            return false;
        }
        if($distro == "xcp") {
            if(preg_match("/XenServer|XCP-ng|Citrix Hypervisor/is", $os_name)) {
                return $value;
            }
            return false;
        }
        if($distro == "ubuntu") {
            if(preg_match("/ubuntu|debian/is", $os_name)) {
                return $value;
            }
            return false;
        }
        return false;
    }
    public function os_check($serid, $distro = "", $operator = "", $version = "", $value = true)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $os_name = $servers[$serid]["os"];
        $distro = strtolower($distro);
        if(in_array($distro, ["centos", "sl", "almalinux", "rocky", "oracle"])) {
            $distro = "rhel";
        }
        if($distro == "debian") {
            $distro = "ubuntu";
        }
        $matched = $this->os_distro_check($serid, $distro);
        if(!$matched) {
            return false;
        }
        if(empty($operator)) {
            return $value;
        }
        if($distro == "rhel" || $distro == "xcp") {
            $tmp = preg_split("/release/is", $os_name);
            $os_version = trim(substr(trim($tmp[1]), 0, 5));
            if(version_compare($os_version, $version, $operator)) {
                return $value;
            }
            return false;
        }
        if($distro == "ubuntu") {
            $tmp = explode(" ", $os_name);
            $os_version = trim($tmp[1]);
            if(preg_match("/debian/is", $os_name)) {
                $os_version = trim($tmp[2]);
            }
            if(version_compare($os_version, $version, $operator)) {
                return $value;
            }
            return false;
        }
        return false;
    }
    public function backup_disk_list($serid, $vps, $file, $dir, $date, $backup_server, $set_inf = 0)
    {
        global $globals;
        if(empty($serid)) {
            return backup_disk_list($vps, $file, $dir, $date, $backup_server, $set_inf);
        }
        $post["vps"] = $vps;
        $post["file"] = $file;
        $post["dir"] = $dir;
        $post["date"] = $date;
        $post["backup_server"] = $backup_server;
        $post["set_inf"] = $set_inf;
        $details = $this->call($serid, "index.php?act=apidoings&do=backup_disk_list", 1, [], $post);
        if(!empty($details["backup_disk_list"])) {
            return $details["backup_disk_list"];
        }
    }
    public function reverse_sync($serid, $virt = "")
    {
        global $kernel;
        global $storages;
        global $globals;
        $ret = [];
        if(empty($serid)) {
            if(!is_slave() || is_api_call(1)) {
                $ret["to_master_data"] = give_to_master_data();
            }
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=reverse_sync", 1);
            if(!empty($details["reverse_sync"])) {
                $ret = $details["reverse_sync"];
            } else {
                return -1;
            }
        }
        save_to_master_data($ret["to_master_data"], $serid);
        return $ret;
    }
    public function delete_vpsdisks($vpsid, $data)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $vps = getvps($vpsid);
        $data_tokens = vsql_in_tokens(array_keys($data));
        $res = makequery("DELETE FROM disks \n\t\t\t\t\t\tWHERE disk_uuid IN (" . $data_tokens["query"] . ")", $data_tokens["tokens"]);
        if(empty($vps["serid"])) {
            return $kernel->delete_vpsdisks($vpsid, $data);
        }
        $post["data"] = $data;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=delete_vpsdisks&vpsid=" . $vpsid, 1, [], $post);
        if(empty($details)) {
            $this->adderror(["[delete_vpsdisks] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["delete_vpsdisks"];
    }
    public function vps_disks_real_size($vpsid)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            foreach ($vps["disks"] as $k => $DISK) {
                $ret[$k] = vpsdisk_real_size($DISK);
            }
            return $ret;
        } else {
            $details = $this->call($vps["serid"], "index.php?act=apidoings&do=vps_disks_real_size&vpsid=" . $vpsid, 1, [], $post);
            if(empty($details)) {
                $this->adderror(["[vps_disks_real_size] API call failed"]);
                return false;
            }
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
                return false;
            }
            return $details["vps_disks_real_size"];
        }
    }
    public function server_stats($serid, $from = 0, $to = 0)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if(empty($serid)) {
            $details["result"] = $kernel->monthly_vps_statistics(0, $from, $to);
            if(empty($details["result"])) {
                return false;
            }
            return $details["result"];
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=server_stats&from=" . $from . "&to=" . $to, 1);
        if(empty($details["result"])) {
            return false;
        }
        return $details["result"];
    }
    public function install_ssh_keys($local, $remote)
    {
        global $globals;
        global $servers;
        $res = makequery("SELECT * FROM server_sshkeys\n\t\t\t\t\t\t\tWHERE serid = :local", [":local" => $local]);
        if(vsql_num_rows($res) < 1) {
            $key_path = $globals["var"] . "/ssh-keys/" . $local;
            @mkdir_recursive($key_path, 493);
            vexec("cd " . $key_path . "; ssh-keygen -f id_rsa -t rsa -N \"\"");
            $public_key = file_get_contents($key_path . "/id_rsa.pub");
            $private_key = file_get_contents($key_path . "/id_rsa");
            if(preg_match("/OPENSSH PRIVATE KEY/i", $private_key)) {
                if(file_exists($key_path . "/id_rsa.pub") && is_safe_file($key_path . "/id_rsa.pub")) {
                    unlink($key_path . "/id_rsa.pub");
                }
                if(file_exists($key_path . "/id_rsa") && is_safe_file($key_path . "/id_rsa")) {
                    unlink($key_path . "/id_rsa");
                }
                vexec("cd " . $key_path . "; ssh-keygen -m PEM -f id_rsa -t rsa -N \"\"");
                $public_key = file_get_contents($key_path . "/id_rsa.pub");
                $private_key = file_get_contents($key_path . "/id_rsa");
            }
            @unlink($key_path . "/id_rsa.pub");
            @unlink($key_path . "/id_rsa");
            $res = makequery("REPLACE INTO server_sshkeys\n\t\t\t\t\t\t\t\tSET serid = :serid,\n\t\t\t\t\t\t\t\t`type` = :type,\n\t\t\t\t\t\t\t\t`time` = :time,\n\t\t\t\t\t\t\t\t`public_key` = :public_key,\n\t\t\t\t\t\t\t\t`private_key` = :private_key", [":serid" => $local, ":type" => "rsa", ":time" => time(), ":public_key" => $public_key, ":private_key" => $private_key]);
        } else {
            $row = vsql_fetch_assoc($res);
            $public_key = $row["public_key"];
            $private_key = $row["private_key"];
        }
        if(!$this->install_public_key($remote, $public_key)) {
            return false;
        }
        if(!$this->install_private_key($local, $private_key)) {
            return false;
        }
        return true;
    }
    public function install_public_key($serid, $public_key)
    {
        global $globals;
        global $kernel;
        global $error;
        if(empty($serid)) {
            @mkdir("/root/.ssh", 448);
            $authorized_keys = @file_get_contents("/root/.ssh/authorized_keys");
            if(0 < substr_count($authorized_keys, $public_key)) {
            } else {
                $authorized_keys = $authorized_keys . $public_key . "\n";
                writefile("/root/.ssh/authorized_keys", $authorized_keys, 1);
            }
            @chmod("/root/.ssh", 448);
            @chmod("/root/.ssh/authorized_keys", 384);
            return true;
        }
        $data["public_key"] = $public_key;
        $details = $this->call($serid, "index.php?act=apidoings&do=install_public_key", 1, $data);
        if(empty($details["install_public_key"])) {
            return false;
        }
        return $details["install_public_key"];
    }
    public function remove_public_key($serid, $sg_public_key)
    {
        global $globals;
        global $kernel;
        global $error;
        if(empty($serid)) {
            if(!is_dir("/root/.ssh")) {
                @mkdir("/root/.ssh", 448);
            }
            $authorized_keys = @file("/root/.ssh/authorized_keys");
            foreach ($authorized_keys as $ak => $av) {
                $av = trim($av);
                if(empty($av)) {
                    unset($authorized_keys[$ak]);
                }
            }
            $found_key = array_search($sg_public_key, $authorized_keys);
            if(!empty($authorized_keys[$found_key])) {
                unset($authorized_keys[$found_key]);
                $final_keys = implode("\n\n", $authorized_keys);
                writefile("/root/.ssh/authorized_keys", $final_keys, 1);
            }
            @chmod("/root/.ssh", 448);
            @chmod("/root/.ssh/authorized_keys", 384);
            return true;
        } else {
            $data["sg_public_key"] = $sg_public_key;
            $details = $this->call($serid, "index.php?act=apidoings&do=remove_public_key", 1, $data);
            if(empty($details["remove_public_key"])) {
                return false;
            }
            return $details["remove_public_key"];
        }
    }
    public function install_private_key($serid, $private_key)
    {
        global $globals;
        global $kernel;
        global $error;
        if(empty($serid)) {
            @mkdir($globals["var"] . "/ssh-keys", 448);
            writefile($globals["var"] . "/ssh-keys/id_rsa", $private_key, 1);
            @chmod($globals["var"] . "/ssh-keys/", 448);
            @chmod($globals["var"] . "/ssh-keys/id_rsa", 384);
            return true;
        }
        $data["private_key"] = $private_key;
        $details = $this->call($serid, "index.php?act=apidoings&do=install_private_key", 1, $data);
        if(empty($details["install_private_key"])) {
            return false;
        }
        return $details["install_private_key"];
    }
    public function check_ssh_connection($src_serid, $dest_ser_detail)
    {
        global $globals;
        global $servers;
        if(empty($src_serid)) {
            vexec("ssh -oStrictHostKeyChecking=no -i " . $globals["var"] . "/ssh-keys/id_rsa -q -p " . (empty($dest_ser_detail["to_ssh_port"]) ? "22" : $dest_ser_detail["to_ssh_port"]) . " root@" . $dest_ser_detail["to_ip"] . " exit", $out, $ret);
            if($ret != 0) {
                return false;
            }
            return true;
        }
        $data["dest_ser_detail"] = $dest_ser_detail;
        $details = $this->call($src_serid, "index.php?act=apidoings&do=check_ssh_connection", 1, $data);
        if(empty($details["check_ssh_connection"])) {
            return false;
        }
        return true;
    }
    public function monthly_vps_stats($vpsid, $from = 0, $to = 0)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            $details["result"] = $kernel->monthly_vps_statistics($vpsid, $from, $to);
        } else {
            $details = $this->call($vps["serid"], "index.php?act=apidoings&do=monthly_vps_stats&vpsid=" . $vpsid . "&from=" . $from . "&to=" . $to, 1);
        }
        if(empty($details["result"])) {
            return false;
        }
        return $details["result"];
    }
    public function get_vps_stats($array, $live = 0, $show = "")
    {
        global $kernel;
        global $globals;
        if(!empty($globals["is_cloud"])) {
            $array = $kernel->vm_location($array);
        }
        $serverwise = [];
        foreach ($array as $k => $v) {
            $serverwise[$v][] = $k;
        }
        foreach ($serverwise as $ser => $v) {
            if($ser == 0) {
                $serverwise[$ser] = $kernel->get_vps_stats($v, $live, $show);
            } else {
                $slave_calls[$ser]["path"] = "index.php?act=apidoings&do=get_vps_stats";
                foreach ($v as $kk => $vv) {
                    $slave_calls[$ser]["data"]["vs_serid"][$vv] = 0;
                }
                $slave_calls[$ser]["data"]["live"] = $live;
                $slave_calls[$ser]["data"]["show"] = $show;
            }
        }
        if(!empty($slave_calls)) {
            if(!empty($globals["hidden_enable_multi_curl"])) {
                $res = $this->multi_call($slave_calls);
                foreach ($res as $s => $r) {
                    if(empty($r["get_vps_stats"])) {
                        $serverwise[$s] = $slave_calls[$s]["data"]["vs_serid"];
                    } else {
                        $serverwise[$s] = $r["get_vps_stats"];
                    }
                }
            } else {
                foreach ($slave_calls as $s => $r) {
                    $tmp = $this->call($s, $r["path"], 1, $r["data"]);
                    $serverwise[$s] = [];
                    if(empty($tmp["get_vps_stats"])) {
                        $serverwise[$s] = $r["data"]["vs_serid"];
                    } else {
                        $serverwise[$s] = $tmp["get_vps_stats"];
                    }
                }
            }
        }
        $ret = [];
        foreach ($serverwise as $ser => $v) {
            foreach ($v as $kk => $vv) {
                $ret[$kk] = $vv;
            }
        }
        return $ret;
    }
    public function multi_call($params)
    {
        global $servers;
        global $servers_keypass;
        foreach ($params as $serid => $v) {
            if(empty($servers[$serid])) {
            } else {
                $params[$serid]["ip"] = $servers[$serid]["ip"];
                $params[$serid]["pass"] = $servers_keypass[$serid]["pass"];
            }
        }
        $res = make_multi_api_call($params);
        return $res;
    }
    public function suspend_users($uids, $reason = 0, $user_vars = [])
    {
        global $error;
        global $l;
        global $globals;
        if(empty($uids)) {
            return false;
        }
        if(!is_array($uids)) {
            $uids = [$uids];
        }
        $uids_tokens = vsql_in_tokens($uids);
        $res = makequery("SELECT uid, email FROM users\n\t\t\t\tWHERE uid IN (" . $uids_tokens["query"] . ") OR pid IN (" . $uids_tokens["query"] . ")", $uids_tokens["tokens"]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $_users[$row["uid"]] = $row;
            }
            $_users_tokens = vsql_in_tokens(array_keys($_users));
            $res = makequery("SELECT * FROM vps\n\t\t\t\t\tWHERE uid IN (" . $_users_tokens["query"] . ")", $_users_tokens["tokens"]);
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $vpses[$row["vpsid"]] = $row;
            }
            $sus_error = [];
            foreach ($vpses as $k => $v) {
                if(!empty($v["suspended"])) {
                } else {
                    $susret = $this->suspendvps($k);
                    if(!$susret) {
                        $sus_error["vpsids"][] = $v["vpsid"];
                    } else {
                        $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\t\tSET suspended = 1\n\t\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $k]);
                        logs_admin("suspend", $v["vps_name"], 1, $k, $v["uid"]);
                        $serids[$v["serid"]] = $v["serid"];
                    }
                }
            }
            foreach ($_users as $uk => $uv) {
                $reason_str = $l["user_suspended_" . $reason];
                if(!empty($user_vars)) {
                    $reason_str = lang_vars_name($reason_str, $user_vars[$uk]);
                }
                $user_susreason = serialize(["id" => $reason, "reason" => $reason_str, "time" => time(), "email_attempts" => 0, "email_time" => time()]);
                if(!in_array($uk, $uids)) {
                } else {
                    $res = makequery("UPDATE users \n\t\t\t\t\t\t\t\tSET suspended = :suspend_reason\n\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $uk, ":suspend_reason" => $user_susreason]);
                    logs_admin("suspenduser", $uv["email"], 1, $uk, $uk);
                    send_emailtemp_mail("suspend_users", $_users[$uk]["email"], ["sus_reason" => $reason_str, "sn" => $globals["sn"]]);
                }
            }
            if(!empty($serids)) {
                oexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/sync_config.php serids=" . implode(",", array_keys($serids)) . " > " . logdir() . "sync_config.log 2>&1 &");
            }
            if(!empty($sus_error)) {
                return $sus_error;
            }
            return true;
        } else {
            return false;
        }
    }
    public function unsuspend_users($uids, $additional_note = "")
    {
        global $error;
        global $globals;
        if(empty($uids)) {
            return false;
        }
        if(!is_array($uids)) {
            $uids = [$uids];
        }
        $uids_tokens = vsql_in_tokens($uids);
        $res = makequery("SELECT uid, email, pid FROM users\n\t\t\t\tWHERE uid IN (" . $uids_tokens["query"] . ") OR pid IN (" . $uids_tokens["query"] . ")", $uids_tokens["tokens"]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $_users[$row["uid"]] = $row;
            }
            $_users_tokens = vsql_in_tokens(array_keys($_users));
            $res = makequery("SELECT * FROM vps\n\t\t\t\t\tWHERE uid IN (" . $_users_tokens["query"] . ")", $_users_tokens["tokens"]);
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $vpses[$row["vpsid"]] = $row;
                $vps_serids[$row["vpsid"]] = $row["serid"];
            }
            $vs_status = $this->vps_status_statewise($vps_serids);
            $unsus_error = [];
            foreach ($vpses as $k => $v) {
                if(defined("VIRTUALIZOR_SCRIPTS") && !is_api_call()) {
                    echo "\nUnsuspending VPS : " . $k . " ...";
                }
                if(empty($v["suspended"]) || $vs_status[$v["vpsid"]] == 0) {
                } else {
                    $unsusret = $this->unsuspendvps($k);
                    if(empty($unsusret)) {
                        if(!is_api_call()) {
                            echo "Error occured !";
                        }
                        $unsus_error["vpsids"][] = $v["vpsid"];
                    } else {
                        if(!is_api_call()) {
                            echo "Success !";
                        }
                        $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\t\tSET `suspended` = 0\n\t\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $k]);
                        logs_admin("unsuspend", $v["vps_name"], 1, $k, $v["uid"]);
                        $serids[$v["serid"]] = $v["serid"];
                    }
                }
            }
            foreach ($_users as $uk => $uv) {
                if(!in_array($uk, $uids)) {
                } else {
                    $res = makequery("UPDATE users \n\t\t\t\t\t\t\t\tSET suspended = NULL\n\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $uk]);
                    logs_admin("unsuspenduser", $uv["email"], 1, $uk, $uk);
                    send_emailtemp_mail("unsuspend_users", $_users[$uk]["email"], ["sn" => $globals["sn"], "additional_note" => $additional_note]);
                }
            }
            if(!empty($serids)) {
                oexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/sync_config.php serids=" . implode(",", $serids) . " > " . logdir() . "sync_config.log 2>&1 &");
            }
            if(!empty($unsus_error)) {
                return $unsus_error;
            }
            return true;
        } else {
            return false;
        }
    }
    public function enable_rescue($vpsid, $password)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            return $kernel->create_rescue_disk($vpsid, $password);
        }
        $post["password"] = $password;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=enable_rescue&vpsid=" . $vpsid, 1, [], $post);
        if(empty($details)) {
            $this->adderror(["[enable_rescue] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        $this->reverse_sync($vps["serid"]);
        return $details["enable_rescue"];
    }
    public function disable_rescue($vpsid)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            return $kernel->delete_rescue_disk($vpsid);
        }
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=disable_rescue&vpsid=" . $vpsid, 1);
        if(empty($details)) {
            $this->adderror(["[disable_rescue] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        $this->reverse_sync($vps["serid"]);
        return $details["disable_rescue"];
    }
    public function ping_webuzo_vps($vpsid, $ip, $root_pass)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            return ping_webuzo_vps($ip, $root_pass);
        }
        $post["ip"] = $ip;
        $post["root_pass"] = $root_pass;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=ping_webuzo_vps&vpsid=" . $vpsid, 1, [], $post);
        if(empty($details)) {
            $this->adderror(["[ping_webuzo_vps] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["result"];
    }
    public function prepare_webuzoapps($vpsid, $data = [])
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            return prepare_webuzoapps($data);
        }
        $post["webuzodata"] = $data;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=prepare_webuzoapps&vpsid=" . $vpsid, 1, [], $post);
        if(empty($details)) {
            $this->adderror(["[prepare_webuzoapps] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return true;
    }
    public function getall_bw_info($serid, $start, $end)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if(empty($serid)) {
            $ret = getall_bw_info($start, $end);
            return $ret;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=getall_bw_info&start=" . $start . "&end=" . $end, 1);
        if(empty($details)) {
            $this->adderror(["[getall_bw_info] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["getall_bw_info"];
    }
    public function vps_disk_create($serid, $vps)
    {
        global $globals;
        global $kernel;
        global $error;
        if(empty($serid)) {
            $tmp_active_server = $globals["server"];
            set_active_server(0);
            foreach ($vps["disks"] as $dk => $DISK) {
                $storage_create = vpsdisk_create($DISK);
                if(!empty($storage_create)) {
                    return false;
                }
            }
            if($vps["virt"] == "xen" && empty($vps["hvm"]) && !empty($vps["disks"][1])) {
                $SWAPDISK = $vps["disks"][1];
                $ret = vexec("/sbin/mkswap -f " . $SWAPDISK["path"]);
                if($ret != "0") {
                    return false;
                }
            }
            set_active_server($tmp_active_server);
            return true;
        } else {
            $post["vps"] = base64_encode(serialize($vps));
            $details = $this->call($serid, "index.php?act=apidoings&do=vps_disk_create" . (defined("EDIT_DISK_MIGRATE") ? "&EDIT_DISK_MIGRATE=1" : ""), 1, [], $post);
            if(empty($details["vps_disk_create"])) {
                return false;
            }
            return $details["vps_disk_create"];
        }
    }
    public function le_manage($serid, $action, $data = [], $user_id = "")
    {
        global $kernel;
        global $globals;
        if($serid == 0) {
            if(empty($action)) {
                return false;
            }
            $params = "";
            if(!empty($user_id)) {
                $logfile = logdir("letsencrypt") . $user_id . ".log";
            } else {
                $logfile = logdir() . "letsencrypt.log";
            }
            if($action == "renew_crt" || $action == "get_crt") {
                if($action == "renew_crt") {
                    $params = " --renew";
                } elseif($action == "get_crt") {
                    $params = " --install";
                }
                if(!empty($globals["le_staging"])) {
                    $params .= " --staging";
                }
                if(!empty($globals["le_enable_force"])) {
                    $params .= " --force";
                }
                if(!empty($user_id)) {
                    $params .= " --user " . $user_id;
                }
                vexec("/usr/local/emps/bin/php " . $globals["path"] . "/scripts/virt_acme.php " . $params . " --frompanel > " . $logfile . " 2>&1 &", $o, $r);
                sleep(1);
                if(file_exists($logfile) && is_safe_file($logfile)) {
                    $tmp_taskid = file($logfile);
                    $taskid = (int) trim($tmp_taskid[0]);
                }
                if(empty($taskid)) {
                    return false;
                }
                return $taskid;
            }
            if($action == "show_logs") {
                $str = "";
                if(file_exists($logfile) && is_safe_file($logfile)) {
                    $str = file_get_contents($logfile);
                }
                return $str;
            }
            if($action == "get_cfg") {
                $params .= " --getcfg";
            } elseif($action == "get_crt_details") {
                $params .= " --getcrtdetails";
            } elseif($action == "save_cfg") {
                $params .= " --savecfg";
                if(empty($data)) {
                    return false;
                }
                foreach ($data as $k => $v) {
                    if($k == "primary_domain") {
                        foreach ($v as $dv) {
                            $params .= " -d " . xss($dv);
                        }
                    } else {
                        $k = str_replace("_", "", $k);
                        if(in_array($k, ["staging", "enableforce"])) {
                            if(empty($v)) {
                            } else {
                                $params .= " --" . ($k == "enableforce" ? "force" : $k);
                            }
                        } else {
                            $params .= " --" . $k . " " . xss($v);
                        }
                    }
                }
            }
            if(!empty($user_id)) {
                $params .= " --user " . $user_id;
            }
            if(empty($params)) {
                return false;
            }
            $cmd = "/usr/local/emps/bin/php " . $globals["path"] . "/scripts/virt_acme.php " . $params . " --frompanel";
            vexec($cmd, $o, $r);
            return unserialize(implode("\n", $o));
        }
        $do_data["action"] = $action;
        $do_data["data"] = $data;
        $details = $this->call($serid, "index.php?act=apidoings&do=le_manage", 1, $do_data);
        return $details["data"];
    }
    public function get_logs($serid, $paths)
    {
        global $globals;
        global $error;
        if(empty($serid)) {
            if(empty($paths)) {
                return false;
            }
            if(!is_array($paths)) {
                $paths = [$paths];
            }
            $logs = [];
            foreach ($paths as $name => $path) {
                if(is_file($path) && is_safe_file($path) && preg_match("/^\\/var\\/virtualizor\\/log/is", $path)) {
                    oexec("tail -n 1000 " . xss($path), $out, $ret);
                    $logs[$name] = $out;
                }
            }
            return $logs;
        } else {
            $data["paths"] = $paths;
            $details = $this->call($serid, "index.php?act=apidoings&do=get_logs", 1, $data);
            if(empty($details["get_logs"])) {
                return false;
            }
            return $details["get_logs"];
        }
    }
    public function cexec($serid, $command_id, &$out = "", &$ret = NULL)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if(empty($serid)) {
            $ret = false;
            $allowed_commands = [];
            $allowed_commands[1] = "rpm -qa libguestfs";
            $allowed_commands[2] = "service haproxy status";
            if(in_array($command_id, array_keys($allowed_commands))) {
                $ret = vexec($allowed_commands[$command_id], $out, $ret);
            }
            return $ret;
        }
        $data["command_id"] = $command_id;
        $details = $this->call($serid, "index.php?act=apidoings&do=cexec", 1, $data);
        if(empty($details)) {
            $this->adderror(["[cexec] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        $out = $details["cexec"]["out"];
        $ret = $details["cexec"]["ret"];
        return $ret;
    }
    public function storage_delete($serid, $storage_name, &$err = "")
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if(empty($serid)) {
            $ret = del_proxmox_storage($storage_name);
            return true;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=storage_delete&storage_name=" . $storage_name);
        if(empty($details)) {
            $err = "Storage Delete API call failed for Server ID ";
            return false;
        }
        return $details["storage_delete"];
    }
    public function save_haproxy($serid)
    {
        if(empty($serid)) {
            return save_haproxy();
        }
        $this->sync($serid);
        $details = $this->call($serid, "index.php?act=apidoings&do=save_haproxy", 1);
        $this->reverse_sync($serid);
        return $details["save_haproxy"];
    }
    public function get_inf_contents($serid, $vpsid, $backup_date)
    {
        if(empty($serid)) {
            $res = makequery("SELECT bid, dir FROM vpsbackup_settings WHERE serid = '0'");
            if(vsql_num_rows($res) == 0) {
                return false;
            }
            $backup_settings = vsql_fetch_assoc($res);
            if(!empty($backup_settings["bid"])) {
                return false;
            }
            $inf_file = $backup_settings["dir"] . "/" . $backup_date . "/" . $vpsid . ".inf";
            if(!file_exists($inf_file)) {
                return false;
            }
            $inf_contents = file_get_contents($inf_file);
            return $inf_contents;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_inf_contents&vpsid=" . $vpsid . "&backupdate=" . $backup_date, 1);
        if(empty($details["get_inf_contents"])) {
            return false;
        }
        return $details["get_inf_contents"];
    }
    public function get_orphaned_disks($serid)
    {
        global $storages;
        global $globals;
        if(empty($serid)) {
            $vps_disks = [];
            $res = makequery("SELECT uuid FROM `vps` WHERE serid = 0");
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $vps_uuids[] = $row["uuid"];
            }
            $vps_uuids_tokens = vsql_in_tokens($vps_uuids);
            $res = makequery("SELECT path FROM `disks` WHERE vps_uuid IN (" . $vps_uuids_tokens["query"] . ")", $vps_uuids_tokens["tokens"]);
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $vps_disks[] = $row["path"];
            }
            $orphaned = [];
            foreach ($storages as $st_id => $st) {
                if(preg_match("/zfs/is", $st["type"])) {
                    $pool = preg_replace("/^\\/dev\\/zvol\\//", "", $st["path"]);
                    vexec("zfs list -o name,used -t volume -Hpr " . xss($pool), $volumes, $ret);
                    foreach ($volumes as $volume) {
                        $parts = preg_split("/\\s+/", $volume, NULL, PREG_SPLIT_NO_EMPTY);
                        $v_name = basename($parts[0]);
                        if(strpos(trim($v_name), "backup-") === 0) {
                        } else {
                            $v_size = (int) $parts[1];
                            $v_path = $st["path"] . "/" . $v_name;
                            if(!in_array($v_path, $vps_disks)) {
                                $orphaned[$v_path] = ["path" => $v_path, "size" => $v_size, "st_id" => $st_id];
                            }
                        }
                    }
                } elseif(preg_match("/block/is", $st["type"])) {
                    $thin_pool = preg_match("/thin/is", $st["type"]);
                    $st_path = $thin_pool ? dirname($st["path"]) : $st["path"];
                    vexec($globals["com"]["lvdisplay"] . " -C -o lv_name,lv_size,lv_attr,pool_lv --unit b --nosuffix --noheadings --separator , " . xss($st_path), $lvs, $ret);
                    foreach ($lvs as $lv) {
                        if(strpos(trim($lv), "backup-") === 0) {
                        } else {
                            $parts = explode(",", trim($lv));
                            $lv_name = $parts[0];
                            $lv_size = (int) $parts[1];
                            $lv_attr = $parts[2];
                            $lv_path = $st_path . "/" . $lv_name;
                            if($thin_pool) {
                                $pool_lv = $parts[3];
                                if(substr($lv_attr, 0, 1) != "V") {
                                } elseif(basename($st["path"]) != $pool_lv) {
                                }
                            } else {
                                $lv_type = substr($lv_attr, 0, 1);
                                if(in_array($lv_type, ["t", "T", "V"])) {
                                }
                            }
                            if(!in_array($lv_path, $vps_disks)) {
                                $orphaned[$lv_path] = ["path" => $lv_path, "size" => $lv_size, "st_id" => $st_id];
                            }
                        }
                    }
                } elseif(preg_match("/file/is", $st["type"])) {
                    $files = @scandir($st["path"]);
                    foreach ($files as $file) {
                        if($file == "." || $file == "..") {
                        } elseif(strpos(trim($file), "backup-") === 0) {
                        } else {
                            $file_path = $st["path"] . "/" . $file;
                            if(is_dir($file_path)) {
                            } elseif(!in_array($file_path, $vps_disks)) {
                                $file_size = filesize($file_path);
                                $orphaned[$file_path] = ["path" => $file_path, "size" => $file_size, "st_id" => $st_id];
                            }
                        }
                    }
                    if(is_dir($st["path"] . "/images")) {
                        $folders = @scandir($st["path"] . "/images");
                        foreach ($folders as $folder) {
                            if($folder == "." || $folder == "..") {
                            } else {
                                $folder_path = $st["path"] . "/images/" . $folder;
                                if(!is_dir($folder_path)) {
                                } else {
                                    $files = @scandir($folder_path);
                                    foreach ($files as $file) {
                                        if($file == "." || $file == "..") {
                                        } elseif(strpos(trim($file), "backup-") === 0) {
                                        } else {
                                            $file_path = $folder_path . "/" . $file;
                                            if(is_dir($file_path)) {
                                            } elseif(!in_array($file_path, $vps_disks)) {
                                                $file_size = filesize($file_path);
                                                $orphaned[$file_path] = ["path" => $file_path, "size" => $file_size, "st_id" => $st_id];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return $orphaned;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_orphaned_disks", 1);
            if(empty($details["get_orphaned_disks"])) {
                return false;
            }
            return $details["get_orphaned_disks"];
        }
    }
    public function delete_orphaned_disks($serid, $disk_paths)
    {
        global $storages;
        global $globals;
        if(empty($serid)) {
            $orphaned = $this->get_orphaned_disks(0);
            foreach ($disk_paths as $path) {
                if(empty($orphaned[$path])) {
                    return false;
                }
                $disk = $orphaned[$path];
                $st_type = $storages[$disk["st_id"]]["type"];
                if(preg_match("/zfs/is", $st_type)) {
                    $path = preg_replace("/^\\/dev\\/zvol\\//", "", $path);
                    vexec("zfs destroy -R " . xss($path), $out, $ret);
                    if($ret != 0) {
                        return false;
                    }
                } elseif(preg_match("/block/is", $st_type)) {
                    vexec($globals["com"]["lvremove"] . " -f " . xss($path), $out, $ret);
                    if($ret != 0) {
                        return false;
                    }
                } elseif(preg_match("/file/is", $st_type) && !@unlink($path)) {
                    return false;
                }
            }
            return true;
        } else {
            $data["disk_paths"] = $disk_paths;
            $details = $this->call($serid, "index.php?act=apidoings&do=delete_orphaned_disks", 1, $data);
            if(empty($details["delete_orphaned_disks"])) {
                return false;
            }
            return $details["delete_orphaned_disks"];
        }
    }
    public function get_prox_vps_data($serid)
    {
        global $globals;
        global $kernel;
        global $proxmox_vps;
        global $v_vps_matches;
        $ret = [];
        if($serid == 0) {
            if(server_virt($serid, "proxo")) {
                $contianers = proxmox_get_call("nodes", "/openvz/");
                foreach ($contianers as $k => $v) {
                    $v["type"] = "openvz";
                    $v_vps_matches[$v["vmid"]] = 0;
                    $proxmox_vps[$v["vmid"]] = $v;
                }
            } else {
                $contianers = proxmox_get_call("nodes", "/lxc/");
                foreach ($contianers as $k => $v) {
                    $v["type"] = "proxl";
                    $v_vps_matches[$v["vmid"]] = 0;
                    $proxmox_vps[$v["vmid"]] = $v;
                }
            }
            $qemuGuests = proxmox_get_call("nodes", "/qemu/");
            foreach ($qemuGuests as $k => $v) {
                $v["type"] = "proxk";
                $v_vps_matches[$v["vmid"]] = 0;
                $proxmox_vps[$v["vmid"]] = $v;
            }
            return $proxmox_vps;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_prox_vps_data", 1);
            if(empty($details["get_prox_vps_data"])) {
                return false;
            }
            return $details["get_prox_vps_data"];
        }
    }
    public function get_prox_storage_data($serid)
    {
        global $globals;
        global $kernel;
        global $proxmox_storages;
        global $pve2;
        $ret = [];
        if($serid == 0) {
            proxmox_api_call();
            $list_proxmox_storages = $pve2->get("/storage");
            foreach ($list_proxmox_storages as $k => $v) {
                $proxmox_storages[$v["storage"]] = $v;
            }
            return $proxmox_storages;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_prox_storage_data", 1);
            if(empty($details["get_prox_storage_data"])) {
                return false;
            }
            return $details["get_prox_storage_data"];
        }
    }
    public function get_prox_user_data($serid)
    {
        global $globals;
        global $kernel;
        global $proxmox_users;
        global $pve2;
        $ret = [];
        if($serid == 0) {
            proxmox_api_call();
            $list_proxmox_users = $pve2->get("/access/users");
            foreach ($list_proxmox_users as $k => $v) {
                $proxmox_users[$v["userid"]] = $v;
            }
            return $proxmox_users;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_prox_user_data", 1);
            if(empty($details["get_prox_user_data"])) {
                return false;
            }
            return $details["get_prox_user_data"];
        }
    }
    public function get_prox_node_data($serid)
    {
        global $globals;
        global $kernel;
        global $proxmox_nodes;
        global $pve2;
        global $proxmox_nodes_ipwise;
        $ret = [];
        if($serid == 0) {
            proxmox_api_call();
            $proxmox_list_server = $pve2->get("/nodes");
            foreach ($proxmox_list_server as $k => $v) {
                $proxmox_nodes[$v["id"]] = $v;
                $proxmox_nodes_ipwise[$v["node"]] = $v["id"];
            }
            return [$proxmox_nodes, $proxmox_nodes_ipwise];
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_prox_node_data", 1);
            if(empty($details["get_prox_node_data"])) {
                return false;
            }
            return $details["get_prox_node_data"];
        }
    }
    public function get_prox_node_name($serid)
    {
        global $globals;
        global $kernel;
        $ret = [];
        if($serid == 0) {
            return $globals["proxmox_server_name"];
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_prox_node_name", 1);
        if(empty($details["get_prox_node_name"])) {
            return false;
        }
        return $details["get_prox_node_name"];
    }
    public function vs_net_restrict($serid, $vpsid)
    {
        global $globals;
        global $error;
        global $kernel;
        if(empty($serid)) {
            $vps = getvps($vpsid);
            $vifname = "";
            $status = $kernel->status($vpsid);
            if(empty($status)) {
                return false;
            }
            $virt = $vps["virt"] . (!empty($vps["hvm"]) ? "hvm" : "");
            $ebtables_support = $kernel->features("ebtables_support", $virt);
            if(!empty($ebtables_support)) {
                $vps_name = $vps["vps_name"];
                $vif_name = $kernel->vifname($vpsid);
                $mac_addr = $kernel->getmac($vpsid);
                $vinf_name = $int_mac_addr = 0;
                if(preg_match("/kvm/i", $vps["virt"])) {
                    $vinf_name = $kernel->vifname($vpsid, 1);
                    $int_mac_addr = $kernel->getmac($vpsid, 1);
                }
                vs_ebtables_remove($vps_name, $vif_name);
                vs_ebtables_add($vpsid, $vif_name, $mac_addr, $vinf_name, $int_mac_addr);
                $o = vs_tc_destroy($vif_name);
                $o = vs_tc_create($vpsid, $vif_name);
            } else {
                $o = vs_tc_destroy_vz($vpsid);
                $o = vs_tc_create_vz($vpsid);
            }
            return $o;
        }
        $post["vpsid"] = $vpsid;
        $details = $this->call($serid, "index.php?act=apidoings&do=vs_net_restrict", 1, [], $post);
        if(empty($details["vs_net_restrict"])) {
            return false;
        }
        return true;
    }
    public function list_vps_backups2($serid, $directory, $selected_date)
    {
        if($serid == 0) {
            return get_backups_list(0, $directory, $selected_date);
        }
        $post["directory"] = $directory;
        $post["selected_date"] = $selected_date;
        $details = $this->call($serid, "index.php?act=apidoings&do=list_vps_backups2", 1, [], $post);
        if(empty($details["list_vps_backups2"])) {
            return false;
        }
        return $details["list_vps_backups2"];
    }
    public function delete_vps_backups2($serid, $bid, $dir, $date, $backup_files)
    {
        global $user;
        if($serid == 0 || $bid != 0) {
            $extensions = get_backup_extensions();
            $ext_names = [];
            foreach ($extensions as $exts) {
                foreach ($exts as $ext) {
                    $ext_names[$ext] = true;
                }
            }
            if(!is_valid_backup_folder($date)) {
                return false;
            }
            foreach ($backup_files as $backup_file) {
                $vpsid = get_backup_vpsid($backup_file);
                if(empty($vpsid)) {
                    return false;
                }
                if(empty($ext_names[$ext])) {
                    return false;
                }
            }
            if($bid <= 0) {
                foreach ($backup_files as $backup_file) {
                    if(!is_safe_file($dir . "/" . $date . "/" . $backup_file)) {
                        return false;
                    }
                    if(file_exists($dir . "/" . $date . "/" . $backup_file) && !@unlink($dir . "/" . $date . "/" . $backup_file)) {
                        return false;
                    }
                    $parts = explode(".", $backup_file, 3);
                    if(preg_match("/vzdump/", $parts[0])) {
                        $regex = get_backup_regex();
                        preg_match($regex[2], $backup_file, $matches);
                        $timestamp = implode("_", [$matches[4], $matches[5], $matches[6]]) . "-" . implode("_", [$matches[7], $matches[8], $matches[9]]);
                        $file_list = filelist($dir . "/" . $date, 0);
                        foreach ($file_list as $_file) {
                            if(preg_match("/" . $matches[3] . "\\_(.*)\\_" . $timestamp . "\\.inf\$/", $_file["name"])) {
                                @unlink($dir . "/" . $date . "/" . $_file["name"]);
                            }
                        }
                        logs_admin("delbackup", $date, 1, $vpsid, $user["uid"]);
                        return true;
                    } else {
                        @unlink($dir . "/" . $date . "/" . $parts[0] . ".inf");
                        logs_admin("delbackup", $date, 1, $vpsid, $user["uid"]);
                    }
                }
                return true;
            } else {
                $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
                if(vsql_num_rows($res) == 0) {
                    return false;
                }
                $bs = vsql_fetch_assoc($res);
                $tmp_bs = $bs;
                $tmp_bs["password"] = pass_decrypt($tmp_bs["password"], $tmp_bs["salt"]);
                if($bs["type"] == "SSH") {
                    $connection = connect_ssh($bs);
                    if(!$connection) {
                        return false;
                    }
                    $sftp = ssh2_sftp($connection);
                    foreach ($backup_files as $backup_file) {
                        $statinfo = ssh2_sftp_stat($sftp, $dir . "/" . $date . "/" . $backup_file);
                        if(!empty($statinfo["size"]) && !@ssh2_sftp_unlink($sftp, $dir . "/" . $date . "/" . $backup_file)) {
                            return false;
                        }
                        $parts = explode(".", $backup_file, 3);
                        if(preg_match("/vzdump/", $parts[0])) {
                            $regex = get_backup_regex();
                            preg_match($regex[2], $backup_file, $matches);
                            $timestamp = implode("_", [$matches[4], $matches[5], $matches[6]]) . "-" . implode("_", [$matches[7], $matches[8], $matches[9]]);
                            $file_list = ssh_list_file($tmp_bs, $dir . "/" . $date, 0);
                            foreach ($file_list as $_file) {
                                if(preg_match("/" . $matches[3] . "\\_(.*)\\_" . $timestamp . "\\.inf\$/", $_file["name"])) {
                                    @ssh2_sftp_unlink($sftp, $dir . "/" . $date . "/" . $_file["name"]);
                                }
                            }
                            logs_admin("delbackup", $date, 1, $vpsid, $user["uid"]);
                            return true;
                        } else {
                            @ssh2_sftp_unlink($sftp, $dir . "/" . $date . "/" . $parts[0] . ".inf");
                            logs_admin("delbackup", $date, 1, $vpsid, $user["uid"]);
                        }
                    }
                    @ssh2_exec($connection, "exit");
                    unset($connection);
                    unset($sftp);
                } elseif($bs["type"] == "FTP") {
                    $ftp_con = connect_ftp($bs);
                    if(!$ftp_con) {
                        return false;
                    }
                    foreach ($backup_files as $backup_file) {
                        $ftp_size = ftp_size($ftp_con, $dir . "/" . $date . "/" . $backup_file);
                        if(0 < $ftp_size && !@ftp_delete($ftp_con, $dir . "/" . $date . "/" . $backup_file)) {
                            return false;
                        }
                        $parts = explode(".", $backup_file, 3);
                        if(preg_match("/vzdump/", $parts[0])) {
                            $regex = get_backup_regex();
                            preg_match($regex[2], $backup_file, $matches);
                            $timestamp = implode("_", [$matches[4], $matches[5], $matches[6]]) . "-" . implode("_", [$matches[7], $matches[8], $matches[9]]);
                            $file_list = ftp_list_file($tmp_bs, $dir . "/" . $date, 0);
                            foreach ($file_list as $_file) {
                                if(preg_match("/" . $matches[3] . "\\_(.*)\\_" . $timestamp . "\\.inf\$/", $_file["name"])) {
                                    @ftp_delete($ftp_con, $dir . "/" . $date . "/" . $_file["name"]);
                                }
                            }
                            logs_admin("delbackup", $date, 1, $vpsid, $user["uid"]);
                            return true;
                        } else {
                            ftp_delete($ftp_con, $dir . "/" . $date . "/" . $parts[0] . ".inf");
                            logs_admin("delbackup", $date, 1, $vpsid, $user["uid"]);
                        }
                    }
                    ftp_close($ftp_con);
                }
                return true;
            }
        } else {
            $data["bid"] = $bid;
            $data["dir"] = $dir;
            $data["date"] = $date;
            $data["backup_files"] = $backup_files;
            $details = $this->call($serid, "index.php?act=apidoings&do=delete_vps_backups2", 1, $data);
            if(empty($details["delete_vps_backups2"])) {
                return false;
            }
            return $details["delete_vps_backups2"];
        }
    }
    public function restore_vps2($serid, $vpsid, $bid, $dir, $backup_date, $backup_vpsid = 0, $storagename = "", $del_temp_local_backup = [])
    {
        global $globals;
        global $user;
        if($serid == 0) {
            if(empty($backup_vpsid)) {
                $backup_vpsid = $vpsid;
            }
            if(!empty($bid) && !testconnection($bid)) {
                return false;
            }
            $data = ["bid" => $bid, "dir" => $dir, "backup_file" => $GLOBALS["backup_file"], "backup_date" => $backup_date, "backup_vpsid" => $backup_vpsid, "storage_name" => $storagename, "del_temp_local_backup" => $del_temp_local_backup];
            $actid = tasks_admin_process("restorevps_plan", $data, 0, $vpsid, $user["uid"], 0, 0);
            vexec($globals["com"]["php"] . " /usr/local/virtualizor/scripts/restorevps_plan.php -a" . $actid . " > " . logdir("restore") . $vpsid . ".log 2>&1 &");
            return $actid;
        }
        $post["vpsid"] = $vpsid;
        $post["bid"] = $bid;
        $post["dir"] = $dir;
        $post["backup_file"] = $GLOBALS["backup_file"];
        $post["backup_date"] = $backup_date;
        $post["backup_vpsid"] = $backup_vpsid;
        $post["storage_name"] = $storagename;
        $post["del_temp_local_backup"] = $del_temp_local_backup;
        $details = $this->call($serid, "index.php?act=apidoings&do=restore_vps2", 1, [], $post);
        if(empty($details["restore_vps2"])) {
            return false;
        }
        return $details["restore_vps2"];
    }
    public function get_inf_contents2($serid, $vpsid, $dir, $backup_date)
    {
        if(empty($serid)) {
            $time = "";
            if(!empty($GLOBALS["backup_file"])) {
                $regex = get_backup_regex($vpsid);
                if(!preg_match($regex[2], $GLOBALS["backup_file"])) {
                    $tmp_inf_file = explode(".", $GLOBALS["backup_file"], 2);
                    $inf_file = $tmp_inf_file[0] . ".inf";
                    unset($tmp_inf_file);
                    $inf_contents = file_get_contents($dir . "/" . $backup_date . "/" . $inf_file);
                    return $inf_contents;
                }
                preg_match($regex[2], $GLOBALS["backup_file"], $m);
                $time = $m[4] . "_" . $m[5] . "_" . $m[6] . "-" . $m[7] . "_" . $m[8] . "_" . $m[9];
            }
            $filelist = scandir($dir . "/" . $backup_date);
            foreach ($filelist as $file) {
                if(preg_match("/" . $vpsid . "" . (!empty($time) ? "(.*)(" . $time . ")" : "") . "(_.+)?\\.inf\$/is", trim($file))) {
                    $inf_contents = file_get_contents($dir . "/" . $backup_date . "/" . $file);
                    return $inf_contents;
                }
            }
            return false;
        } else {
            $post["vpsid"] = $vpsid;
            $post["dir"] = $dir;
            $post["backup_date"] = $backup_date;
            $post["backup_file"] = $GLOBALS["backup_file"];
            $details = $this->call($serid, "index.php?act=apidoings&do=get_inf_contents2", 1, [], $post);
            if(empty($details["get_inf_contents2"])) {
                return false;
            }
            return $details["get_inf_contents2"];
        }
    }
    public function backuply_get_inf_contents($serid, $time, $bid, $dir, $vpsid = 0)
    {
        global $globals;
        global $cluster;
        if($serid == 0) {
            $backup_server = [];
            if(!has_plugin_license("backuply")) {
                return [];
            }
            if(0 < $bid) {
                $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
                if(vsql_num_rows($res) == 0) {
                    return false;
                }
                $backup_server = vsql_fetch_assoc($res);
            }
            $class = load_backup_class($backup_server, "utils");
            if(empty($class)) {
                return [];
            }
            $jsons = $cluster->get_disk_json($globals["server"], 0);
            foreach ($jsons as $vid => $vjsons) {
                if(empty($vjsons) || !empty($vpsid) && $vid != $vpsid) {
                } else {
                    foreach ($vjsons as $chain => $json) {
                        if(empty($json)) {
                        } else {
                            $_dir = $dir . "/" . $json["vps_uuid"];
                            if(!empty($json["folder_format"])) {
                                $_dir = $dir . "/" . $json["folder_format"];
                            }
                            $base_path = $_dir . "/" . $chain . (!empty($json["og_path"]) ? "/" . $json["og_path"] : "") . "/";
                            $inf_file = $globals["var"] . "/backuply_" . generateRandStr(5);
                            if(preg_match("/" . $time . "/", $json["htime"])) {
                                $path = $base_path . basename($json["filepath"]);
                                $basename = pathinfo($path)["filename"];
                                $inf_path = $base_path . $basename . ".inf";
                            } elseif(!empty($json["children"])) {
                                foreach ($json["children"] as $c => $cjson) {
                                    if(preg_match("/" . $time . "/", $cjson["htime"])) {
                                        $path = $base_path . basename($cjson["filepath"]);
                                        $basename = pathinfo($path)["filename"];
                                        $inf_path = $base_path . $basename . ".inf";
                                    }
                                }
                            }
                            if(!empty($inf_path)) {
                                if(0 < $bid) {
                                    $class->download($inf_path, $inf_file);
                                } else {
                                    copy($inf_path, $inf_file);
                                }
                                $vps = _unserialize(file_get_contents($inf_file));
                                @unlink($inf_file);
                            }
                            return $vps;
                        }
                    }
                }
            }
        } else {
            $post["time"] = $time;
            $post["bid"] = $bid;
            $post["dir"] = $dir;
            $post["vpsid"] = $vpsid;
            $details = $this->call($serid, "index.php?act=apidoings&do=backuply_get_inf_contents", 1, [], $post);
            if(empty($details["result"])) {
                return false;
            }
            return $details["result"];
        }
    }
    public function backuply_delete_backup($serid, $time, $chain, $dir, $bid, $vps)
    {
        global $globals;
        global $kernel;
        if($serid == 0) {
            if(!has_plugin_license("backuply")) {
                return false;
            }
            return $kernel->backuply_delete_backup($time, $chain, $dir, $bid, $vps);
        }
        $post["time"] = $time;
        $post["chain"] = $chain;
        $post["dir"] = $dir;
        $post["bid"] = $bid;
        $post["vps"] = $vps;
        $details = $this->call($serid, "index.php?act=apidoings&do=backuply_delete_backup", 1, [], $post);
        if(empty($details["result"])) {
            return false;
        }
        return $details["result"];
    }
    public function get_disk_json($serid, $vpsid, $disk_num = 0)
    {
        global $globals;
        if(!is_array($vpsid)) {
            $vps = getvps($vpsid);
        } else {
            $vps = $vpsid;
        }
        if($serid == 0) {
            return get_disk_json($vps["vpsid"], $disk_num);
        }
        $post["vpsid"] = $vpsid;
        $post["disk_num"] = $disk_num;
        $details = $this->call($serid, "index.php?act=apidoings&do=get_disk_json", 1, [], $post);
        if(empty($details["result"])) {
            return false;
        }
        return $details["result"];
    }
    public function save_disk_json($vpsid, $json, $disk_num)
    {
        global $globals;
        if(!is_array($vpsid)) {
            $vps = getvps($vpsid);
        } else {
            $vps = $vpsid;
        }
        if($vps["serid"] == 0) {
            return save_disk_json($vps["vpsid"], $json, $disk_num);
        }
        $post["vpsid"] = $vpsid;
        $post["json"] = $json;
        $post["disk_num"] = $disk_num;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=save_disk_json", 1, [], $post);
        if(empty($details["result"])) {
            return false;
        }
        return $details["result"];
    }
    public function backuply_restore($serid, $vpsid, $backup_date, $backup_file, $old_vps = [])
    {
        global $globals;
        global $user;
        global $kernel;
        if($serid == 0) {
            if(!has_plugin_license("backuply")) {
                return false;
            }
            return $kernel->backuply_eu_restore($vpsid, $backup_file, $backup_date, $old_vps);
        }
        $post["svs"] = $vpsid;
        $post["backup_date"] = $backup_date;
        $post["backup_file"] = $backup_file;
        $post["old_vps"] = $old_vps;
        $details = $this->call($serid, "index.php?act=apidoings&do=e_backuply_restore_backup", 1, [], $post);
        if(empty($details["result"])) {
            return false;
        }
        return $details["result"];
    }
    public function backuply_single_backup($vpsid, $type)
    {
        global $globals;
        global $kernel;
        $vps = getvps($vpsid);
        if($vps["serid"] == 0) {
            if(!has_plugin_license("backuply")) {
                return false;
            }
            return $kernel->backuply_single_backup($vpsid, $type);
        }
        $post["vpsid"] = $vpsid;
        $post["type"] = $type;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=backuply_single_backup", 1, [], $post);
        if(empty($details["backuply_single_backup"])) {
            return false;
        }
        return $details["backuply_single_backup"];
    }
    public function backuply_backup($serid, $bpid, $type)
    {
        global $globals;
        global $user;
        if($serid == 0) {
            if(!has_plugin_license("backuply")) {
                return false;
            }
            vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/backuply_vpsbackups_plan.php -b" . $bpid . " -t" . $type . " -f > " . logdir("vpsbackups_inc_plan") . $bpid . ".log 2>&1 &");
            return true;
        }
        $post = [];
        $post["bpid"] = $bpid;
        $post["type"] = $type;
        $details = $this->call($serid, "index.php?act=apidoings&do=backuply_backup", 1, [], $post);
        if(empty($details["backuply_backup"])) {
            return false;
        }
        return $details["backuply_backup"];
    }
    public function backupnow2($serid, $bpid)
    {
        global $globals;
        global $user;
        if($serid == 0) {
            vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/vpsbackups_plan.php -b" . $bpid . " -f > " . logdir("vpsbackups_plan") . $bpid . ".log 2>&1 &");
            return true;
        }
        $post["bpid"] = $bpid;
        $details = $this->call($serid, "index.php?act=apidoings&do=backupnow2", 1, [], $post);
        if(empty($details["backupnow2"])) {
            return false;
        }
        return $details["backupnow2"];
    }
    public function sync_media($serid, $name, $type, $force = 0)
    {
        global $globals;
        global $ostemplates;
        if($serid == 0) {
            oslist();
            if(empty($name) || empty($globals[$type])) {
                return false;
            }
            if(!empty($force) && is_safe_file($globals[$type] . "/" . $name)) {
                unlink($globals[$type] . "/" . $name);
            }
            $result = getos($name, $type);
            return $result;
        }
        $post["name"] = $name;
        $post["type"] = $type;
        $post["force"] = $force;
        $details = $this->call($serid, "index.php?act=apidoings&do=sync_media", 1, [], $post);
        if(empty($details["sync_media"])) {
            return false;
        }
        return $details["sync_media"];
    }
    public function ha_cluster($serid)
    {
        global $globals;
        if($serid == 0) {
            $ha_cluster_stats = [];
            vexec("/usr/sbin/pcs status 2>&1", $output, $return);
            if($return != 0) {
                return false;
            }
            $output = explode(":", $output[0]);
            $ha_cluster_stats["cluster_name"] = $output[1];
            vexec("/usr/sbin/pcs status nodes corosync 2>&1", $output, $return);
            if($return != 0) {
                return false;
            }
            $ha_nodes = [];
            if(preg_match("/Online/is", $output[1])) {
                $ha_nodes_raw = preg_split("/[\\s]+/", trim($output[1]));
                unset($ha_nodes_raw[0]);
                foreach ($ha_nodes_raw as $k => $v) {
                    $ha_nodes[$v] = 1;
                }
            }
            if(preg_match("/Offline/is", $output[2])) {
                $ha_nodes_raw = preg_split("/[\\s]+/", trim($output[2]));
                unset($ha_nodes_raw[0]);
                foreach ($ha_nodes_raw as $k => $v) {
                    $ha_nodes[$v] = 0;
                }
            }
            $ha_cluster_stats["node_status"] = $ha_nodes;
            vexec("/usr/sbin/pcs status resources 2>&1", $output, $return);
            if($return != 0) {
                return false;
            }
            $ha_resources = [];
            if($output[0] != "NO resources configured") {
                foreach ($output as $k => $v) {
                    $v = preg_split("/[\\s]+/", trim($v));
                    if($v[0] == "*") {
                        array_shift($v);
                    }
                    list($ha_resources[$v[0]]["status"], $ha_resources[$v[0]]["node"]) = $v;
                    $tmp_vps_name = explode("_", $v[0]);
                    $ha_resources[$v[0]]["vps_name"] = $tmp_vps_name[1];
                }
            }
            $ha_cluster_stats["ha_resources"] = $ha_resources;
            return $ha_cluster_stats;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=ha_cluster", 1, [], $post);
            if(empty($details["ha_cluster"])) {
                return false;
            }
            return $details["ha_cluster"];
        }
    }
    public function create_ha_cluster($serid, $servergroup_name, $sg_password, $sg_salt)
    {
        global $globals;
        if($serid == 0) {
            $ret["error"] = [];
            $ret["done"] = false;
            $ha_hostname = $this->hostname($serid);
            vexec("pcs --version 2>&1", $pcs_output, $pcs_return);
            if($pcs_return != 0) {
                $ret["error"][] = $pcs_output[0];
                return $ret;
            }
            $pcs_version = explode(".", $pcs_output[0]);
            $pcs_host = "cluster";
            $requires_name = "--name ";
            if(9 < $pcs_version[1]) {
                $pcs_host = "host";
                $requires_name = "";
            }
            vexec("/usr/sbin/pcs " . $pcs_host . " auth " . xss($ha_hostname) . " -u hacluster -p " . pass_decrypt($sg_password, $sg_salt) . " 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            vexec("/usr/sbin/pcs cluster setup " . $requires_name . xss($servergroup_name) . " " . xss($ha_hostname) . " --enable 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            vexec("/usr/sbin/pcs cluster start 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            vexec("/usr/sbin/pcs cluster enable 2>&1", $output, $return);
            unset($output);
            unset($return);
            vexec("/usr/sbin/pcs property set stonith-enabled=false 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            $ret["done"] = true;
            return $ret;
        }
        $post["servergroup_name"] = $servergroup_name;
        $post["sg_password"] = $sg_password;
        $post["sg_salt"] = $sg_salt;
        $details = $this->call($serid, "index.php?act=apidoings&do=create_ha_cluster", 1, [], $post);
        return $details["create_ha_cluster"];
    }
    public function add_ha_cluster($serid, $ha_hostname, $sg_password, $sg_salt)
    {
        global $globals;
        global $servers;
        global $servergroups;
        if($serid == 0) {
            $ret["error"] = [];
            $ret["done"] = false;
            vexec("pcs --version 2>&1", $pcs_output, $pcs_return);
            if($pcs_return != 0) {
                $ret["error"][] = $pcs_output[0];
                return $ret;
            }
            $pcs_version = explode(".", $pcs_output[0]);
            $pcs_host = "cluster";
            if(9 < $pcs_version[1]) {
                $pcs_host = "host";
            }
            vexec("/usr/sbin/pcs " . $pcs_host . " auth " . xss($ha_hostname) . " -u hacluster -p " . pass_decrypt($sg_password, $sg_salt) . " 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            vexec("/usr/sbin/pcs cluster node add " . xss($ha_hostname) . " --start --enable 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            vexec("/usr/sbin/pcs cluster enable --all 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            $ret["done"] = true;
            return $ret;
        }
        $post["sg_password"] = $sg_password;
        $post["sg_salt"] = $sg_salt;
        $post["ha_hostname"] = $ha_hostname;
        $details = $this->call($serid, "index.php?act=apidoings&do=add_ha_cluster", 1, [], $post);
        return $details["add_ha_cluster"];
    }
    public function remove_ha_cluster($serid, $del_data = [])
    {
        global $globals;
        global $servers;
        global $servergroups;
        if($serid == 0) {
            $ret["error"] = [];
            $ret["done"] = false;
            if($globals["slave"] == $del_data["node_remove_id"]) {
                vexec("/usr/sbin/pcs cluster destroy 2>&1", $output, $return);
                if($return != 0) {
                    $ret["error"][] = $output[0];
                    return $ret;
                }
                $ret["done"] = true;
                return $ret;
            }
            vexec("/usr/sbin/pcs cluster node remove " . xss($del_data["ha_node_hostname"]) . " --force 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            vexec("/usr/sbin/crm_node -R " . xss($del_data["ha_node_hostname"]) . " --force 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"][] = $output[0];
                return $ret;
            }
            $ret["done"] = true;
            return $ret;
        }
        $data["del_data"] = $del_data;
        $details = $this->call($serid, "index.php?act=apidoings&do=remove_ha_cluster", 1, $data);
        return $details["remove_ha_cluster"];
    }
    public function write_to_hosts($serid, $host_data = [])
    {
        global $globals;
        if($serid == 0) {
            write_to_hosts_file($host_data);
        } else {
            $data["host_data"] = $host_data;
            $details = $this->call($serid, "index.php?act=apidoings&do=write_to_hosts", 1, $data);
            if(empty($details["write_to_hosts"])) {
                return false;
            }
            return $details["write_to_hosts"];
        }
    }
    public function plan_backupvps($serid, $vpsid, $userid, $force = 0)
    {
        global $kernel;
        if($serid == 0) {
            $actid = $kernel->plan_backupvps($vpsid, $userid, $force);
            return $actid;
        }
        $post["userid"] = $userid;
        $post["vpsid"] = $vpsid;
        $post["force"] = $force;
        $details = $this->call($serid, "index.php?act=apidoings&do=plan_backupvps", 1, [], $post);
        if(empty($details["result"])) {
            return false;
        }
        return $details["result"];
    }
    public function local_backup_to_new_server($fromserver, $data)
    {
        global $servers;
        global $globals;
        if(empty($fromserver)) {
            if(!empty($data["bid"]) && !testconnection($data["bid"])) {
                return false;
            }
            vexec($data["command"] . " \"ls " . xss($data["dir"] . "/" . $data["backup_date"]) . "\"", $o, $r);
            if($r != 0) {
                vexec($data["command"] . " \"mkdir -p " . xss($data["dir"] . "/" . $data["backup_date"]) . "\"", $o, $r);
            }
            $backup_list = $this->list_vps_backups2($fromserver, $data["dir"], $data["backup_date"]);
            foreach ($backup_list as $date => $backups) {
                if($date == $data["backup_date"]) {
                    foreach ($backups as $k => $bkup) {
                        $filename = basename($bkup["abs_path"]);
                        $parts = explode(".", $filename, 2);
                        $_vid_ = (int) $parts[0];
                        if(empty($_vid_)) {
                            $parts1 = explode("-", $filename, 4);
                            $_vid_ = (int) $parts1[2];
                        }
                        if($_vid_ == $data["backup_vpsid"]) {
                            $ret = vexec("dd if=" . xss($data["dir"] . "/" . $data["backup_date"] . "/" . $filename) . " bs=24M | " . $data["command"] . " \"dd of=" . xss($data["dir"] . "/" . $data["backup_date"] . "/" . $filename) . " bs=24M\" 2>&1");
                            $files_to_delete[] = $data["dir"] . "/" . $data["backup_date"] . "/" . $filename;
                        }
                    }
                }
            }
            $res["command"] = $data["command"];
            $res["files_to_delete"] = $files_to_delete;
            return $res;
        } else {
            $post["backup_to_new_data"] = $data;
            $details = $this->call($fromserver, "index.php?act=apidoings&do=local_backup_to_new_server", 1, [], $post);
            return $details["res"];
        }
    }
    public function del_local_backup_from_new_server($serid, $backup_data)
    {
        if(empty($serid)) {
            foreach ($backup_data["files_to_delete"] as $bdk => $bdv) {
                $backup_data["files_to_delete"][$bdk] = xss($bdv);
            }
            vexec($backup_data["command"] . " \"rm -f " . implode(" ", $backup_data["files_to_delete"]) . "\" 2>&1", $out, $r);
            return true;
        } else {
            $post["backup_data"] = $backup_data;
            $details = $this->call($serid, "index.php?act=apidoings&do=del_local_backup_from_new_server", 1, [], $post);
            return true;
        }
    }
    public function get_ct_path($serid, $vpsid)
    {
        global $error;
        global $kernel;
        if(empty($serid)) {
            $ret = $kernel->get_ct_path($vpsid);
            if(empty($ret)) {
                $error[] = "Path returned was empty for CT with VID: " . $vpsid;
            }
        } else {
            $post["vpsid"] = $vpsid;
            $details = $this->call($serid, "index.php?act=apidoings&do=get_ct_path", 1, [], $post);
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
            } else {
                $ret = $details["result"];
            }
        }
        if(!empty($error)) {
            return false;
        }
        return $ret;
    }
    public function addsshkeys($serid, $vpsid, $ssh_keys)
    {
        global $kernel;
        if(empty($serid)) {
            $ret = $kernel->addsshkeys($vpsid, $ssh_keys);
        } else {
            $post["vpsid"] = $vpsid;
            $post["ssh_keys"] = $ssh_keys;
            $details = $this->call($serid, "index.php?act=apidoings&do=addsshkeys", 1, [], $post);
            $ret = $details["result"];
        }
        return $ret;
    }
    public function check_loop_device($serid)
    {
        global $error;
        global $kernel;
        global $l;
        if($serid == 0) {
            vexec("losetup -f", $o, $r);
            $ret = $o;
        } else {
            $loop_device = $this->call($serid, "index.php?act=apidoings&do=check_loop_device", 1);
            $ret = $loop_device["result"];
        }
        return $ret;
    }
    public function get_vps_used_bw($serid)
    {
        if(empty($serid)) {
            $ret = vps_used_bandwidth();
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_vps_used_bw", 1);
            $ret = $details["result"];
        }
        return $ret;
    }
    public function get_raw_conf($serid, $vpsid)
    {
        global $globals;
        global $kernel;
        global $error;
        if(empty($serid)) {
            $ret = $kernel->get_raw_conf($vpsid);
        } else {
            $post["vpsid"] = $vpsid;
            $details = $this->call($serid, "index.php?act=apidoings&do=get_raw_conf", 1, [], $post);
            $ret = $details["result"];
        }
        return $ret;
    }
    public function pci_manager($serid, $data, $action)
    {
        global $kernel;
        global $globals;
        $return = [];
        if(empty($serid)) {
            switch ($action) {
                case "node_pcis":
                    $return = $kernel->node_pci_devices();
                    break;
                case "assign":
                    if(!empty($data["vps"]) && !empty($data["pci"])) {
                        $return = $kernel->pci_assign($data["vps"]["vpsid"], $data);
                    }
                    break;
                case "remove":
                    if(!empty($data["vps"]) && !empty($data["pci"])) {
                        $return = $kernel->pci_remove($data["vps"]["vpsid"], $data);
                    }
                    break;
                case "reattach":
                    if(!empty($data["pci"])) {
                        $return = $kernel->reattachPCIdevice($data["vps"]["vpsid"], $data);
                    }
                    break;
                case "detach":
                    if(!empty($data["pci"]) && $globals["pci_manage"] == 1) {
                        $return = $kernel->detach_pci_device($data["vps"]["vpsid"], $data);
                    }
                    break;
                case "iommu_support":
                    $return = $kernel->check_iommu_support();
                    break;
                case "interrupt_remapping":
                    if(!empty($data)) {
                        $return = $kernel->check_interruptremapping_support($data);
                    }
                    break;
                case "iommu_group":
                    if(!empty($data["pci"])) {
                        $return = $kernel->get_iommugroup_members($data);
                    }
                    break;
                case "node_gpuroms":
                    $return = $kernel->node_gpuroms();
                    break;
            }
        } else {
            $post["data"] = $data;
            $post["action"] = $action;
            $return = $this->call($serid, "index.php?act=apidoings&do=pci_manager", 1, [], $post);
            $return = $return["result"];
        }
        return $return;
    }
    public function usb_manager($serid, $data, $action)
    {
        global $kernel;
        $return = [];
        if(empty($serid)) {
            switch ($action) {
                case "node_usbs":
                    $return = $kernel->node_usb_devices();
                    break;
                case "assign":
                    if(!empty($data["usb"]) && !empty($data["vps"])) {
                        $return = $kernel->usb_assign($data["vps"]["vpsid"], $data);
                    }
                    break;
                case "remove":
                    if(!empty($data["usb"]) && !empty($data["vps"])) {
                        $return = $kernel->usb_remove($data["vps"]["vpsid"], $data);
                    }
                    break;
            }
        } else {
            $post["data"] = $data;
            $post["action"] = $action;
            $return = $this->call($serid, "index.php?act=apidoings&do=usb_manager", 1, [], $post);
            $return = $return["result"];
        }
        return $return;
    }
    public function io_performance($serid)
    {
        if(empty($serid)) {
            $ret = io_performance();
            if(empty($ret) || !is_array($ret)) {
                $ret = 0;
            }
            return $ret;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=io_performance", 1);
        $ret = $details["result"];
        return $ret;
    }
    public function create_terminal_sess($serid, $username)
    {
        global $error;
        global $kernel;
        global $l;
        if(empty($serid)) {
            $ret = create_terminal_sess($username);
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=create_terminal_sess", 1, [], ["username" => $username]);
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
                return false;
            }
            $ret = $details["result"];
        }
        return $ret;
    }
    public function delete_terminal_sess($serid, $username, $force_del = 0)
    {
        global $error;
        global $kernel;
        global $l;
        if(empty($serid)) {
            $ret = delete_terminal_sess($username, $force_del);
        } else {
            $details = [];
            $data = ["force_del" => $force_del, "username" => $username];
            $details = $this->call($serid, "index.php?act=apidoings&do=delete_terminal_sess&\$force_del", 1, [], $data);
            if(!empty($details["error"])) {
                $this->adderror($details["error"]);
                return false;
            }
            $ret = $details["result"];
        }
        return $ret;
    }
    public function get_top10_ps($serid, $hardware)
    {
        $out = [];
        $matches = "";
        $filter_ps[] = [];
        if(empty($serid)) {
            vexec("ps -eo pid,ppid,%mem,%cpu,cmd --sort=-%" . $hardware . " | head -n 11", $out, $r);
            foreach ($out as $k => $v) {
                preg_match("/^(\\d+)\\s+(\\d+)\\s+(.*|.*\\s+\\-.*\\-)\\s+(\\d+\\.\\d+)\\s+(.*)/is", trim($v), $matches);
                if(60 < strlen($matches[5])) {
                    $matches[5] = substr($matches[5], 0, 60);
                }
                $filter_ps[$k] = $matches;
            }
            return array_filter($filter_ps);
        } else {
            $post["hardware"] = $hardware;
            $details = $this->call($serid, "index.php?act=apidoings&do=get_top10_ps", 1, [], $post);
            return $details["get_top10_ps"];
        }
    }
    public function get_disk_io($serid)
    {
        $tmp = [];
        $tmp1 = [];
        $final = [];
        $o = [];
        $disk = "";
        if(empty($serid)) {
            vexec("fdisk -l | grep '^Disk /dev/' | egrep -v '/dev/(loop|mapper|md)' ", $o, $r);
            foreach ($o as $k => $v) {
                $temp[$k] = explode(" ", $v);
                $disks[$k] = array_values(array_filter($temp[$k]));
            }
            foreach ($disks as $key => $disk) {
                vexec("iostat -p " . substr($disk[1], 0, strlen($disk[1]) - 1) . " -m ", $o, $r);
                unset($o[0]);
                unset($o[1]);
                unset($o[2]);
                unset($o[3]);
                $di[$key] = $o;
            }
            foreach ($di as $key => $value) {
                foreach ($value as $kk => $vv) {
                    $tmp[$vv] = array_values(array_filter(explode("  ", $vv)));
                    if(!preg_match("/ploop/", $tmp[$vv][0])) {
                        $tmp1[$vv] = array_values(array_filter(explode("  ", $vv)));
                    }
                }
            }
            $final = array_values(array_filter($tmp1));
            unset($final[0]);
            unset($tmp);
            unset($tmp1);
            unset($o);
            unset($disk);
            return $final;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_disk_io", 1);
            return $details["get_disk_io"];
        }
    }
    public function get_node_hypervisor($serid)
    {
        if(empty($serid)) {
            $hypervisor = "";
            $o = [];
            $temp = [];
            vexec("lscpu | grep 'Hypervisor vendor:' ", $o, $r);
            $temp = explode(":", $o[0]);
            $hypervisor = $temp[1];
            unset($o);
            unset($r);
            unset($temp);
            return $hypervisor;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_node_hypervisor");
        return $details["get_node_hypervisor"];
    }
    public function get_node_disks($serid)
    {
        if(empty($serid)) {
            $disks = [];
            $o = [];
            $temp = [];
            vexec("fdisk -l | grep '^Disk /dev/' | egrep -v '/dev/(loop|mapper|md)' ", $o, $r);
            foreach ($o as $k => $v) {
                $temp[$k] = explode(" ", $v);
                $disks[$k] = array_values(array_filter($temp[$k]));
                if($disks[$k][1]) {
                    $diskname = basename(substr($disks[$k][1], 0, strlen($disks[$k][1]) - 1));
                    vexec("cat /sys/block/" . $diskname . "/queue/rotational", $o, $r);
                    if($o[0] == 1) {
                        $disks[$k][] = "HDD";
                    } elseif($o[0] == 0) {
                        if(preg_match("/nvme/is", $diskname)) {
                            $disks[$k][] = "NVMe";
                        } else {
                            $disks[$k][] = "SSD";
                        }
                    }
                }
            }
            unset($o);
            unset($r);
            unset($temp);
            return $disks;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_node_disks", 1);
            return $details["get_node_disks"];
        }
    }
    public function get_smart_values($serid, $disks, $live = 0)
    {
        global $cluster;
        if(empty($disks)) {
            return false;
        }
        if(empty($serid)) {
            $disk_health = [];
            $o = [];
            $temp = [];
            $smart_support = $cluster->get_smart_support_os(0);
            if(empty($smart_support)) {
                $disk_health = "none";
            } else {
                foreach ($disks as $num_disk => $disk_info) {
                    $disk_info[1] = substr($disk_info[1], 0, strlen($disk_info[1]) - 1);
                    oexec("smartctl -a -j " . $disk_info[1], $o);
                    $disk_health[$num_disk] = json_decode($o, true);
                    $disk_health[$num_disk]["disk_type"] = end($disk_info);
                    array_walk_recursive($disk_health[$num_disk], "trim");
                    vexec("smartctl -t  short " . $disk_info[1]);
                }
                unset($o);
                unset($r);
                unset($temp);
            }
            return $disk_health;
        }
        $post["disks"] = $disks;
        $post["live"] = $live;
        $details = $this->call($serid, "index.php?act=apidoings&do=get_smart_values", 1, [], $post);
        $disk_health = $details["get_smart_values"];
        if($live == 1) {
        } else {
            $smartvalues["sata_version"] = "NA";
            $smartvalues["serid"] = $serid;
            $smartvalues["time"] = time();
            $smartvalues["temperature"] = "NA";
            $smartvalues["health"] = "NA";
            $smartvalues["data"] = "NA";
            if($disk_health != "none") {
                foreach ($disk_health as $disk_numer => $smartctl_values) {
                    $res1 = makequery("SELECT `model_name` FROM `smartctl_devices` WHERE serial_number= :serial_number AND serid= :serid", [":serial_number" => $smartctl_values["serial_number"], ":serid" => $serid]);
                    $smartvalues["serial_number"] = $smartctl_values["serial_number"];
                    $smartvalues["firmware_version"] = !empty($smartctl_values["firmware_version"]) ? $smartctl_values["firmware_version"] : "NA";
                    $smartvalues["disk_type"] = $smartctl_values["disk_type"];
                    if(0 < vsql_num_rows($res1)) {
                        if(array_key_exists("ata_smart_attributes", $disk_health[$disk_numer]) & !empty($smartctl_values["rotation_rate"])) {
                            foreach ($smartctl_values["ata_smart_attributes"]["table"] as $k => $v) {
                                if($v["name"] == "Temperature_Celsius") {
                                    if(3 < strlen($v["raw"]["value"])) {
                                        $smartvalues["temperature"] = $v["raw"]["string"] . "°C";
                                    } else {
                                        $smartvalues["temperature"] = $v["raw"]["value"] . "°C";
                                    }
                                    $smartvalues["health"] = $smartctl_values["smart_status"]["passed"];
                                    $smartvalues["data"] = $smartctl_values["ata_smart_attributes"]["table"];
                                }
                            }
                        }
                        if(array_key_exists("ata_smart_attributes", $disk_health[$disk_numer]) && !empty($smartctl_values["firmware_version"]) && !empty($smartctl_values["sata_version"]["string"]) && empty($smartctl_values["rotation_rate"])) {
                            $smartvalues["temperature"] = $smartctl_values["temperature"]["current"];
                            $smartvalues["health"] = $smartctl_values["smart_status"]["passed"];
                            $smartvalues["data"] = $smartctl_values["ata_smart_attributes"]["table"];
                        }
                        if(array_key_exists("nvme_smart_health_information_log", $disk_health[$disk_numer])) {
                            $smartvalues["temperature"] = $smartctl_values["temperature"]["current"];
                            $smartvalues["health"] = $smartctl_values["smart_status"]["passed"];
                            $smartvalues["data"] = $smartctl_values["nvme_smart_health_information_log"];
                        }
                        if(!empty($smartvalues["serial_number"])) {
                            makequery("UPDATE `smartctl_devices`\n\t\t\t\t\t\t\t\tSET `time` = :time,\n\t\t\t\t\t\t\t\t`temperature` = :temperature,\n\t\t\t\t\t\t\t\t`firmware_version` = :firmware_version,\n\t\t\t\t\t\t\t\t`health` = :health,\n\t\t\t\t\t\t\t\t`data` = :data\n\t\t\t\t\t\t\t\tWHERE serial_number = :serial_number", [":serial_number" => $smartvalues["serial_number"], ":time" => $smartvalues["time"], ":temperature" => $smartvalues["temperature"], ":firmware_version" => $smartvalues["firmware_version"], ":health" => $smartvalues["health"], ":data" => serialize($smartvalues["data"])]);
                        }
                    } else {
                        $smartvalues["rotation_rate"] = "NA";
                        $smartvalues["logical_block_size"] = $smartctl_values["logical_block_size"];
                        $smartvalues["sata_version"] = "NA";
                        $smartvalues["serid"] = $serid;
                        $smartvalues["time"] = time();
                        $smartvalues["firmware_version"] = "NA";
                        $smartvalues["rotation_rate"] = "NA";
                        $smartvalues["temperature"] = "NA";
                        $smartvalues["sata_version"] = "NA";
                        $smartvalues["size"] = round($smartctl_values["user_capacity"]["bytes"] / 0, 2);
                        $smartvalues["health"] = $smartctl_values["smart_status"]["passed"];
                        $smartvalues["data"] = "NA";
                        $smartvalues["model_name"] = $smartctl_values["model_name"];
                        $smartvalues["serial_number"] = $smartctl_values["serial_number"];
                        $smartvalues["devices"] = $smartctl_values["device"]["name"];
                        if(array_key_exists("ata_smart_attributes", $disk_health[$disk_numer]) & !empty($smartctl_values["rotation_rate"])) {
                            $smartvalues["rotation_rate"] = $smartctl_values["rotation_rate"];
                            $smartvalues["sata_version"] = $smartctl_values["sata_version"]["string"];
                            foreach ($smartctl_values["ata_smart_attributes"]["table"] as $k => $v) {
                                if($v["name"] == "Temperature_Celsius") {
                                    if(3 < strlen($v["raw"]["value"])) {
                                        $smartvalues["temperature"] = $v["raw"]["string"] . "°C";
                                    } else {
                                        $smartvalues["temperature"] = $v["raw"]["value"] . "°C";
                                    }
                                    $smartvalues["data"] = $smartctl_values["ata_smart_attributes"]["table"];
                                }
                            }
                        }
                        if(array_key_exists("ata_smart_attributes", $disk_health[$disk_numer]) && !empty($smartctl_values["firmware_version"]) && !empty($smartctl_values["sata_version"]["string"])) {
                            $smartvalues["sata_version"] = $smartctl_values["sata_version"]["string"];
                            $smartvalues["temperature"] = $smartctl_values["temperature"]["current"];
                            $smartvalues["data"] = $smartctl_values["ata_smart_attributes"]["table"];
                            $smartvalues["firmware_version"] = $smartctl_values["firmware_version"];
                        }
                        if(array_key_exists("nvme_smart_health_information_log", $disk_health[$disk_numer])) {
                            $smartvalues["temperature"] = $smartctl_values["temperature"]["current"];
                            $smartvalues["data"] = $smartctl_values["nvme_smart_health_information_log"];
                            $smartvalues["firmware_version"] = $smartctl_values["firmware_version"];
                        }
                        if(!empty($smartctl_values["serial_number"])) {
                            $res = insert_and_id("INSERT INTO `smartctl_devices` SET\n\t\t\t\t\t\t\t\t\t\t`serid` \t\t\t= '" . $smartvalues["serid"] . "',\n\t\t\t\t\t\t\t\t\t\t`devices` \t\t\t= '" . $smartvalues["devices"] . "',\n\t\t\t\t\t\t\t\t\t\t`time` \t\t\t\t= '" . $smartvalues["time"] . "',\n\t\t\t\t\t\t\t\t\t\t`model_name` \t\t= '" . $smartvalues["model_name"] . "',\n\t\t\t\t\t\t\t\t\t\t`serial_number` \t= '" . $smartvalues["serial_number"] . "',\n\t\t\t\t\t\t\t\t\t\t`firmware_version` \t= '" . $smartvalues["firmware_version"] . "',\n\t\t\t\t\t\t\t\t\t\t`logical_block_size`= '" . $smartvalues["logical_block_size"] . "',\n\t\t\t\t\t\t\t\t\t\t`rotation` \t\t\t= '" . $smartvalues["rotation_rate"] . "',\n\t\t\t\t\t\t\t\t\t\t`temperature` \t\t= '" . $smartvalues["temperature"] . "',\n\t\t\t\t\t\t\t\t\t\t`sata_version` \t\t= '" . $smartvalues["sata_version"] . "',\n\t\t\t\t\t\t\t\t\t\t`size` \t\t\t\t= '" . $smartvalues["size"] . "',\n\t\t\t\t\t\t\t\t\t\t`health` \t\t\t= '" . $smartvalues["health"] . "',\n\t\t\t\t\t\t\t\t\t\t`disk_type` \t\t= '" . $smartvalues["disk_type"] . "',\n\t\t\t\t\t\t\t\t\t\t`data` \t\t\t\t= '" . serialize($smartvalues["data"]) . "' ");
                        }
                    }
                }
            }
        }
    }
    public function get_smart_support_os($serid)
    {
        $supported = 1;
        if(empty($serid)) {
            vexec("smartctl -h ", $o, $r);
            if($r != 0) {
                package_install("smartmontools", V_LOG_DIR . "/smartctl_install.log");
                vexec("smartctl -h ", $o, $r);
            }
            if($r != 0) {
                $supported = 0;
            }
            return $supported;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_smart_support_os", 1);
        return $details["get_smart_support_os"];
    }
    public function get_binaries($serid)
    {
        if(empty($serid)) {
            $binaries_not_found = [];
            $binaries = ["dd", "throttle", "wget", "/usr/bin/pigz", "chntpw", "curl", "tc", "/bin/df", "iptables", "ebtables", "ssh", "lscpu", "fdisk", "du", "bash", "/bin/tar", "lsof", "/sbin/mkfs", "/bin/ln", "/sbin/e2fsck", "/usr/bin/sftp", "/sbin/gdisk", "iostat"];
            foreach ($binaries as $v) {
                vexec($v . " --help", $o, $r);
                if($r == "127") {
                    $binaries_not_found[] = $v;
                }
            }
            return $binaries_not_found;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_binaries", 1);
            return $details["get_binaries"];
        }
    }
    public function get_elapsed_time_ps($serid)
    {
        $out = "";
        $virtualizor_script_path = "/usr/local/virtualizor/scripts/";
        $process_location = ["cron.php", "cronm.php", "cronh.php", "billing_unsuspend.php", "billing.php", "restorevps_plan.php", "sync_config.php", "createtemplate.php", "databasebackups.php", "db_restore.php", "download_iso.php", "sync_media.php", "sync_backup_plans.php", "backupnow_plan.php", "vpsbackups_plan.php", "migrate2_master.php", "migrate2.php", "calculate_bandwidth.php", "deletevs.php", "rebuild.php", "powercron.php", "send_mail.php", "addvs.php"];
        $crons_key = array_values($process_location);
        sort($crons_key);
        foreach ($crons_key as $ck => $cv) {
            $crons[$cv] = 0;
            $cron_meta[$cv]["active"] = 0;
            $cron_meta[$cv]["pid"] = 0;
        }
        if(empty($serid)) {
            foreach ($process_location as $cron => $cron_location) {
                vexec("pgrep -f " . $virtualizor_script_path . $cron_location . " ", $out, $ret);
                $crons[$cron_location] = $out;
            }
            unset($out);
            unset($ret);
            foreach ($crons as $cronkey => $pid) {
                vexec("ps -p  " . $pid[0] . "  -o etimes=", $out, $ret);
                $cron_meta[$cronkey]["active"] = $out;
                $cron_meta[$cronkey]["pid"] = $pid;
            }
            return $cron_meta;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_elapsed_time_ps", 1);
            return $details["get_elapsed_time_ps"];
        }
    }
    public function get_network_speed($serid)
    {
        global $globals;
        $o = [];
        $dw = [];
        $r = "";
        $i = 0;
        if(empty($serid)) {
            vexec("netstat -i | awk '{print \$1}' ", $o, $r);
            unset($o[0]);
            unset($o[1]);
            foreach ($o as $key => $value) {
                $band_dev = $value;
                if(!preg_match("/viifv|vmec|vinfv/", $value)) {
                    $x = shell_exec("grep -w " . $band_dev . " /proc/net/dev");
                    $dw[$i][$value] = preg_split("/[\\s]+/", str_replace(":", ": ", trim($x)));
                }
            }
            $dw[$i][$value] = preg_split("/[\\s]+/", str_replace(":", ": ", trim($x)));
            if($i < 1) {
                $i++;
                sleep(1);
            } else {
                foreach ($dw[0] as $k => $v) {
                    if(empty($v[0])) {
                        unset($dw[0][$k]);
                        unset($dw[1][$k]);
                    } else {
                        $final[$k] = array_values(array_filter($dw[0][$k]));
                        $final2[$k] = array_values(array_filter($dw[1][$k]));
                    }
                }
                foreach ($final as $k1 => $v1) {
                    if($final2[$k1][1] < $final[$k1][1]) {
                        $final2[$k1][1] = $final[$k1][1];
                        $final2[$k1][4] = $final[$k1][4];
                    }
                    $ntw_speed[$k1]["upload"] = round((double) (($final2[$k1][4] - $final[$k1][4]) / 1024) / 1024, 1);
                    $ntw_speed[$k1]["download"] = round((double) (($final2[$k1][1] - $final[$k1][1]) / 1024) / 1024, 1);
                }
                return $ntw_speed;
            }
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_network_speed", 1);
            return $details["get_network_speed"];
        }
    }
    public function get_ram_specs($serid)
    {
        $final = [];
        $tmp_array = [];
        $o = [];
        if(empty($serid)) {
            vexec("dmidecode --type 17", $o, $r);
            $arr = preg_split("/Memory Device/", implode("\n", $o));
            foreach ($arr as $k => $v) {
                $tmp_exp = explode("\n", $v);
                foreach ($tmp_exp as $tk => $tv) {
                    if(preg_match("/:/", $tv)) {
                        $tmp_array = explode(":", trim($tv));
                        $final[$k][$tmp_array[0]] = $tmp_array[1];
                    }
                }
            }
            return $final;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_ram_specs", 1);
            return $details["get_ram_specs"];
        }
    }
    public function get_cpu_specs($serid)
    {
        if(empty($serid)) {
            $o = $final = $arr = [];
            vexec("lscpu", $o, $r);
            foreach ($o as $key => $values) {
                $arr[] = explode(":", $values);
                $final[$arr[$key][0]] = trim($arr[$key][1]);
            }
            return $final;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_cpu_specs", 1);
            return $details["get_cpu_specs"];
        }
    }
    public function all_performace_values($serid)
    {
        global $cluster;
        if(empty($serid)) {
            $all_performance_values = ["binaries_not_found" => array_filter($cluster->get_binaries(0)), "filter_ps_ram" => $cluster->get_top10_ps(0, "mem"), "filter_ps_cpu" => $cluster->get_top10_ps(0, "cpu"), "crons" => $cluster->get_elapsed_time_ps(0), "disk_io" => $cluster->get_disk_io(0), "cpu" => $cluster->cpu(0), "ram" => $cluster->ram(0)];
            return $all_performance_values;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=all_performace_values", 1);
        return $details["all_performace_values"];
    }
    public function pre_performace_values($serid)
    {
        global $cluster;
        global $globals;
        if(empty($serid)) {
            $disks = $cluster->get_node_disks(0);
            $pre_performance_values = ["supported" => $cluster->get_smart_support_os(0), "hypervisor" => $cluster->get_node_hypervisor(0), "disks" => $disks, "disk_health" => array_filter($cluster->get_smart_values(0, $disks, 1)), "ram_specs" => $cluster->get_ram_specs(0), "cpu_specs" => $cluster->get_cpu_specs(0), "disks_df" => $cluster->disk(0), "disks_inodes" => $cluster->inodes(0)];
            return $pre_performance_values;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=pre_performace_values", 1);
        return $details["pre_performace_values"];
    }
    public function get_raid_info($serid, $live = 0)
    {
        if(empty($serid)) {
            $o = $raid_name = [];
            $raid_info = [];
            $raid_dump = [];
            $active = [];
            $faulty = [];
            $removed = [];
            $tmp = [];
            $raid_final = [];
            function myFilter($var)
            {
                return !empty($var) || $var == "0";
            }
            vexec("cat /proc/mdstat", $o, $r);
            unset($o[0]);
            $o = array_values($o);
            if(preg_match("/unused devices: <none>/", $o[0])) {
                $raid_final = "none";
                return $raid_final;
            }
            foreach ($o as $k => $v) {
                if(preg_match("/md/", $v)) {
                    $raid_dump[] = $v;
                }
            }
            foreach ($raid_dump as $kk => $vv) {
                $matches = preg_split("/[\\s]+/", $vv);
                unset($matches[1]);
                $raid_info["/dev/" . $matches[0]] = array_values($matches);
            }
            $raid_name = array_keys($raid_info);
            foreach ($raid_name as $devicek => $devicev) {
                vexec("mdadm --detail " . $devicev, $o, $r);
                $raid_devices_info[$devicev] = array_filter($o);
            }
            foreach ($raid_devices_info as $k1 => $v1) {
                foreach ($v1 as $k2 => $v2) {
                    $tmp = explode(":", trim($v2));
                    if(preg_match("/active sync/", $v2)) {
                        $active[$k1][] = array_values(array_filter(explode(" ", $v2), "myFilter"));
                    } elseif(preg_match("/faulty/", $v2)) {
                        $faulty[$k1][] = array_values(array_filter(explode(" ", $v2), "myFilter"));
                    } elseif(preg_match("/removed/", $v2)) {
                        $removed[$k1][] = array_values(array_filter(explode(" ", $v2), "myFilter"));
                    } elseif(preg_match("/spare rebuilding/", $v2)) {
                        $spare_rebuild[$k1][] = array_values(array_filter(explode(" ", $v2), "myFilter"));
                    } else {
                        $raid_final[$k1][trim($tmp[0])] = $tmp[1];
                    }
                }
            }
            foreach ($raid_name as $k => $v) {
                if(!empty($active[$v])) {
                    $raid_final[$v]["active"] = $active[$v];
                }
                if(!empty($faulty[$v])) {
                    $raid_final[$v]["faulty"] = $faulty[$v];
                }
                if(!empty($removed[$v])) {
                    $raid_final[$v]["removed"] = $removed[$v];
                }
                if(!empty($spare_rebuild[$v])) {
                    $raid_final[$v]["spare_rebuild"] = $spare_rebuild[$v];
                }
                vexec("mdadm -Q " . $v . " | awk '{print \$2}' ", $o, $r);
                $raid_final[$v]["disk_size"] = $o[0];
            }
            return $raid_final;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_raid_info", 1);
            $raid_final = $details["get_raid_info"];
            if($live == 1) {
            }
            return $raid_final;
        }
    }
    public function check_iouring($serid)
    {
        $ret = 0;
        if(empty($serid)) {
            $qemu_details = get_qemu_details();
            if(!empty($qemu_details["libvirt_ver"]) && !empty($qemu_details["qemu_ver"]) && version_compare($qemu_details["libvirt_ver"], "6.3.0", "ge") && version_compare($qemu_details["qemu_ver"], "5.0", "ge")) {
                $ret = 1;
            }
            return $ret;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=check_iouring", 1, [], []);
        return $details["result"];
    }
    public function get_qemu_details($serid)
    {
        if(empty($serid)) {
            $ret = get_qemu_details();
            return $ret;
        }
        $details = $this->call($serid, "index.php?act=apidoings&do=get_qemu_details", 1);
        return $details["get_qemu_details"];
    }
    public function console_session_create($vpsid, $duration)
    {
        global $kernel;
        $vps = getvps($vpsid);
        if(empty($duration)) {
            $duration = 3600;
        }
        if(empty($vps["serid"])) {
            $details = $kernel->console_session_create($vpsid, $duration);
            return $details;
        }
        $post["svs"] = $vpsid;
        $post["duration"] = $duration;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=e_console_session_create", 1, [], $post);
        return $details["result"];
    }
    public function console_session_destroy($vpsid)
    {
        global $kernel;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            $details = $kernel->console_session_destroy($vpsid);
            return $details;
        }
        $post["svs"] = $vpsid;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=e_console_session_destroy", 1, [], $post);
        return $details["result"];
    }
    public function check_licensepro($serid)
    {
        global $error;
        global $globals;
        if(empty($serid)) {
            $return = check_licensepro();
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=check_licensepro", 1);
            $return = $details["result"];
        }
        return $return;
    }
    public function has_plugin_license($serid, $plugin)
    {
        global $error;
        global $globals;
        if(empty($serid)) {
            $return = has_plugin_license($plugin);
        } else {
            $post["plugin"] = $plugin;
            $details = $this->call($serid, "index.php?act=apidoings&do=has_plugin_license", 1, [], $post);
            $return = $details["result"];
        }
        return $return;
    }
    public function persistent_check_vm($serid, $vpsid)
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        if(empty($serid)) {
            $ret = [];
            $vps = getvps($vpsid);
            if(empty($vps)) {
                return false;
            }
            if(!$kernel->features("disk_hotplug", $vps["virt"])) {
                $ret["error"][] = $l["hotplug_vol_no"];
                return $ret;
            }
            vexec("virsh dominfo " . $vps["vps_name"] . " 2>&1", $output, $return);
            if($return != 0) {
                $ret["error"]["persistent_check_vm"] = $output[0];
                return $ret;
            }
            foreach ($output as $k => $v) {
                if(preg_match("/persistent(\\s*?):(.*)/is", $v) && preg_match("/no/is", $v)) {
                    $ret["error"][] = $v;
                    return $ret;
                }
                if(preg_match("/state(\\s*?):(.*)/is", $v) && !preg_match("/running/is", $v)) {
                    $ret["error"]["persistent_check_vm"] = $v;
                    return $ret;
                }
            }
        } else {
            $post["vpsid"] = $vpsid;
            $details = $this->call($serid, "index.php?act=apidoings&do=persistent_check_vm", 1, [], $post);
            $ret = $details["result"];
        }
        return $ret;
    }
    public function hotplug_disk($serid, $vpsid, $disk, $mnt = "")
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        if(empty($serid)) {
            $ret = $kernel->hotplug_disk($vpsid, $disk, $mnt);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/reverse_sync.php > " . logdir() . "reverse_sync.log 2>&1 &");
        } else {
            $post["vpsid"] = $vpsid;
            $post["disk"] = $disk;
            $post["mnt"] = $mnt;
            $details = $this->call($serid, "index.php?act=apidoings&do=hotplug_disk", 1, [], $post);
            $ret = $details["result"];
        }
        return $ret;
    }
    public function detach_disk($serid, $vpsid, $path)
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        if(empty($serid)) {
            $ret = $kernel->detach_disk($vpsid, $path);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/reverse_sync.php > " . logdir() . "reverse_sync.log 2>&1 &");
        } else {
            $post["vpsid"] = $vpsid;
            $post["path"] = $path;
            $details = $this->call($serid, "index.php?act=apidoings&do=detach_disk", 1, [], $post);
            $ret = $details["result"];
        }
        return $ret;
    }
    public function get_attachable_disk($serid, $disk)
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        if(empty($serid)) {
            if(empty($disk)) {
                return false;
            }
            if(preg_match("/file/is", $disk["type"])) {
                vexec("ls -l \"" . $disk["path"] . "\"", $o, $ret);
            }
            if(preg_match("/block/is", $disk["type"])) {
                if(preg_match("/zfs/is", $disk["type"])) {
                    vexec("zfs list \"" . $disk["path"] . "\"", $o, $ret);
                } elseif(preg_match("/ceph/is", $disk["type"])) {
                    vexec("rbd ls \"" . $disk["path"] . "\"", $o, $ret);
                } else {
                    vexec($globals["com"]["lvdisplay"] . " \"" . $disk["path"] . "\"", $o, $ret);
                }
            }
            if($ret != "0") {
                return false;
            }
            return true;
        }
        $post["disk"] = $disk;
        $details = $this->call($serid, "index.php?act=apidoings&do=get_attachable_disk", 1, [], $post);
        $ret = $details["result"];
        return $ret;
    }
    public function delete_attachable_disk($serid, $DISK)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if(empty($serid)) {
            $return = delete_attachable_disk($DISK);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/reverse_sync.php > " . logdir() . "reverse_sync.log 2>&1 &");
        } else {
            $post["DISK"] = $DISK;
            $details = $this->call($serid, "index.php?act=apidoings&do=delete_attachable_disk", 1, [], $post);
            $return = $details["result"];
        }
        return $return;
    }
    public function resize_attachable_disk($serid, $DISK, $format = "")
    {
        global $error;
        global $globals;
        if(empty($serid)) {
            $return = resize_attachable_disk($DISK, $format);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/reverse_sync.php > " . logdir() . "reverse_sync.log 2>&1 &");
        } else {
            $post["DISK"] = $DISK;
            $post["format"] = $format;
            $details = $this->call($serid, "index.php?act=apidoings&do=resize_attachable_disk", 1, [], $post);
            $return = $details["result"];
        }
        return $return;
    }
    public function vpsdisk_real_size($serid, $DISK)
    {
        if(empty($serid)) {
            $ret = vpsdisk_real_size($DISK);
            return $ret;
        }
        $post["DISK"] = $DISK;
        $details = $this->call($serid, "index.php?act=apidoings&do=vpsdisk_real_size", 1, [], $post);
        if(empty($details)) {
            $this->adderror(["[vpsdisk_real_size] API call failed"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["vpsdisk_real_size"];
    }
    public function migrate_disk($serid, $migrate_disk, $vpsid, $uid)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        if($serid == 0) {
            vexec("echo \"1 - Starting migration from source\" >> " . logdir("migrate_disk") . $vpsid . "-source.log");
            $actid = tasks_admin_process("migrate_disk2", serialize($migrate_disk), 1, $vpsid, $uid, 0, 0);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/migrate_disk2.php " . $actid . " >> " . logdir("migrate_disk") . $vpsid . "-source.log 2>&1 &");
            vexec("echo \"1.1 - Exit from cluster - Control Given to background Migrate Disk script\" >> " . logdir("migrate_disk") . $vpsid . "-source.log");
            return $actid;
        }
        $post = [];
        $post["migrate_disk"] = $migrate_disk;
        $post["vpsid"] = $vpsid;
        $post["uid"] = $uid;
        $details = $this->call($serid, "index.php?act=apidoings&do=migrate_disk", 1, [], $post);
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        if(empty($details["migrate_disk"])) {
            return false;
        }
        return $details["migrate_disk"];
    }
    public function change_disk($vpsid, $data)
    {
        global $error;
        global $globals;
        global $kernel;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps["serid"])) {
            return $kernel->change_disk($vpsid, $data);
        }
        $post["data"] = $data;
        $details = $this->call($vps["serid"], "index.php?act=apidoings&do=change_disk&vpsid=" . $vpsid, 1, [], $post);
        if(empty($details)) {
            $this->adderror($details["error"]);
            return false;
        }
        if(!empty($details["error"])) {
            $this->adderror($details["error"]);
            return false;
        }
        return $details["change_disk"];
    }
    public function slave_task_update($serid, $actid, $data, $status)
    {
        if(empty($serid)) {
            task_update($actid, $data, $status);
        } else {
            $post["actid"] = $actid;
            $post["data"] = $data;
            $post["status"] = $status;
            $details = $this->call($serid, "index.php?act=apidoings&do=slave_task_update", 1, [], $post);
            $ret = $details["result"];
        }
    }
    public function get_vps_bridge($serid, $vpsid)
    {
        global $error;
        global $globals;
        global $kernel;
        if(empty($serid)) {
            $return = $kernel->get_vps_bridge($vpsid);
        } else {
            $post["vpsid"] = $vpsid;
            $details = $this->call($serid, "index.php?act=apidoings&do=get_vps_bridge", 1, [], $post);
            $return = $details["result"];
        }
        return $return;
    }
    public function sync_api_credentials($serid, $data)
    {
        if(empty($data)) {
            return false;
        }
        if(empty($serid)) {
            $all_access = [];
            $all_access = get_all_access_acl();
            $qres = makequery("INSERT INTO `api` SET `idapi` = -1, \n\t\t\t\t\t\t\t`apikey` = :key,\n\t\t\t\t\t\t\t`apipass` = :pass,\n\t\t\t\t\t\t\t`data` = '" . json_encode($all_access) . "'\n\t\t\t\t\t\t\tON DUPLICATE KEY UPDATE \n\t\t\t\t\t\t\t`apikey` = :key,\n\t\t\t\t\t\t\t`apipass` = :pass", [":key" => $data["key"], ":pass" => $data["pass"], ":idapi" => "-1"]);
            return true;
        }
        $post["data"] = $data;
        $details = $this->call($serid, "index.php?act=apidoings&do=sync_api_credentials", 1, [], $post);
        return $details;
    }
    public function server_free_space($serid, $path = "/")
    {
        if(empty($serid)) {
            $ret = get_free_space($path);
        } else {
            $post["path"] = $path;
            $details = $this->call($serid, "index.php?act=apidoings&do=server_free_space", 1, [], $post);
            $ret = $details["result"];
        }
        return $ret;
    }
    public function club_call_adminindex($serid, $month_year, $month_year_and_month, $virt, $show)
    {
        global $cluster;
        if(empty($serid)) {
            $usage = ["bandwidth_verbose" => $cluster->bandwidth($serid, $month_year_and_month), "bandwidth" => $cluster->bandwidth($serid, $show), "disk" => $cluster->disk($serid), "inodes" => $cluster->inodes($serid), "cpu" => $cluster->cpu($serid), "ram" => $cluster->ram($serid), "resources" => $cluster->resources($serid, $virt), "uptime" => $cluster->uptime($serid), "kernel_name" => $cluster->get_kernel_version($serid), "io" => $cluster->io_performance($serid)];
            return $usage;
        }
        $post["month_year"] = $month_year;
        $post["month_year_and_month"] = $month_year_and_month;
        $post["show"] = $show;
        $post["virt"] = $virt;
        $details = $this->call($serid, "index.php?act=apidoings&do=club_call_adminindex", 1, [], $post);
        return $details["usage"];
    }
    public function club_manageserver_call($serid, $show, $virt)
    {
        global $cluster;
        if(empty($serid)) {
            $usage = ["cpu" => $cluster->cpu($serid), "ram" => $cluster->noderam($serid), "disk" => $cluster->disk($serid), "inodes" => $cluster->inodes($serid), "bandwidth" => $cluster->bandwidth($serid, $show), "io" => $cluster->io_performance($serid), "ips" => $cluster->listips($serid), "hostname" => $cluster->hostname($serid), "status" => $cluster->status($serid), "uptime" => $cluster->uptime($serid), "resources" => $cluster->resources($serid, $virt), "kernel_name" => $cluster->get_kernel_version($serid)];
            if(empty($virt)) {
                $usage["check_kernel"] = $cluster->check_kernel($serid);
            } else {
                $usage["check_kernel"] = $usage["resources"]["check_kernel"];
            }
            return $usage;
        }
        $post["show"] = $show;
        $post["virt"] = $virt;
        $details = $this->call($serid, "index.php?act=apidoings&do=club_manageserver_call", 1, [], $post);
        return $details["usage"];
    }
    public function check_file_stats($serid, $path)
    {
        if(empty($serid)) {
            if(!empty($path)) {
                $file_check = file_exists($path);
            }
            if($file_check) {
                $file_size = round(filesize($path) / pow(1024, 2), 2);
                return $file_size;
            }
            return 0;
        }
        $post["path"] = $path;
        $details = $this->call($serid, "index.php?act=apidoings&do=check_file_stats", 1, [], $post);
        return $details;
    }
    public function server_stats_collector($servs)
    {
        $usage = [];
        if($servs == 0) {
            $usage[0] = ["disk" => $this->get_storage_used(0), "cpu" => $this->cpu(0, 1), "ram" => $this->ram(0, 1), "uptime" => $this->uptime(0), "io" => $this->io_performance(0)];
            return $usage[0];
        }
        if(!is_array($servs)) {
            $details = $this->call($servs, "index.php?act=apidoings&do=server_stats_collector", 1);
            if(empty($details)) {
                $details["server_stats_collector"] = $usage;
            }
            return $details["server_stats_collector"];
        }
        foreach ($servs as $k => $v) {
            if(empty($k)) {
                $usage[$k] = ["disk" => $this->get_storage_used($k), "cpu" => $this->cpu($k, 1), "ram" => $this->ram($k, 1), "uptime" => $this->uptime($k), "io" => $this->io_performance($k)];
            } else {
                $slave_calls[$k]["path"] = "index.php?act=apidoings&do=server_stats_collector";
            }
        }
        if(!empty($slave_calls)) {
            if(!empty($globals["hidden_enable_multi_curl"])) {
                $details = $this->multi_call($slave_calls);
                foreach ($details as $s => $r) {
                    $usage[$s] = [];
                    if(!empty($r["server_stats_collector"])) {
                        $usage[$s] = $r["server_stats_collector"];
                    }
                }
            } else {
                foreach ($slave_calls as $s => $r) {
                    $details = $this->call($s, $r["path"], 1);
                    if(!empty($details["server_stats_collector"])) {
                        $usage[$s] = $details["server_stats_collector"];
                    }
                }
            }
        }
        return $usage;
    }
    public function get_storage_used($serid)
    {
        if(empty($serid)) {
            global $storages;
            foreach ($storages as $k => $v) {
                $tmp = storage_size($v["path"], $v["type"]);
                $ret["storages"][$k] = $v;
                $ret["storages"][$k]["size"] = $tmp["size"];
                $ret["storages"][$k]["free"] = $tmp["free"];
            }
            $total_space = 0;
            $free_space = 0;
            $disk = [];
            $disk["percent"] = 0;
            $disk["percent_free"] = 0;
            foreach ($ret["storages"] as $k => $v) {
                $total_space += $v["size"];
                $free_space += $v["free"];
            }
            if(!empty($total_space)) {
                $final["total_space"] = round((double) $total_space, 2);
                $final["space"] = round((double) $free_space, 2);
                $final["used"] = round((int) $total_space - $free_space);
                $disk["percent"] = round($final["used"] / $final["total_space"] * 100);
                $disk["percent_free"] = 100 - $disk["percent"];
            }
            return $disk;
        } else {
            $details = $this->call($serid, "index.php?act=apidoings&do=get_storage_used", 1);
            return $details["get_storage_used"];
        }
    }
    public function lb_save_config($serid, $lb_uuid, $config)
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->lb_save_config($lb_uuid, $config);
        }
        $post["lb_uuid"] = $lb_uuid;
        $post["config"] = base64_encode(gzcompress(serialize($config)));
        $details = $this->call($serid, "index.php?act=apidoings&do=lb_save_config", 1, [], $post);
        return $details["lb_save_config"];
    }
    public function lb_self_signed_cert($serid, $lb_uuid, $file_name)
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->lb_self_signed_cert($lb_uuid, $file_name);
        }
        $post["lb_uuid"] = $lb_uuid;
        $post["file_name"] = $file_name;
        $details = $this->call($serid, "index.php?act=apidoings&do=lb_self_signed_cert", 1, [], $post);
        return $details["lb_self_signed_cert"];
    }
    public function lb_get_logs($serid, $lb_uuid)
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->lb_get_logs($lb_uuid);
        }
        $post["lb_uuid"] = $lb_uuid;
        $details = $this->call($serid, "index.php?act=apidoings&do=lb_get_logs", 1, [], $post);
        return $details["lb_get_logs"];
    }
    public function lb_get_status($serid, $lb_uuid)
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->lb_get_status($lb_uuid);
        }
        $post["lb_uuid"] = $lb_uuid;
        $details = $this->call($serid, "index.php?act=apidoings&do=lb_get_status", 1, [], $post);
        return $details["lb_get_status"];
    }
    public function lb_get_stats($serid, $lb_uuid, $ip)
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->lb_get_stats($lb_uuid, $ip);
        }
        $post["lb_uuid"] = $lb_uuid;
        $post["ip"] = $ip;
        $details = $this->call($serid, "index.php?act=apidoings&do=lb_get_stats", 1, [], $post);
        return $details["lb_get_stats"];
    }
    public function lb_use_own_cert($serid, $lb_uuid, $keys, $file_name)
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->lb_use_own_cert($lb_uuid, $keys, $file_name);
        }
        $post["lb_uuid"] = $lb_uuid;
        $post["file_name"] = $file_name;
        $post["keys"] = base64_encode(gzcompress(serialize($keys)));
        $details = $this->call($serid, "index.php?act=apidoings&do=lb_use_own_cert", 1, [], $post);
        return $details["lb_use_own_cert"];
    }
    public function os_template_size($serid, $osid)
    {
        global $ostemplates;
        global $globals;
        if(empty($serid)) {
            if(empty($ostemplates[$osid])) {
                return false;
            }
            return round(vfilesize($globals[$ostemplates[$osid]["type"] . "os"] . "/" . $ostemplates[$osid]["filename"]) / 1024 / 1024);
        }
        $post["osid"] = $osid;
        $details = $this->call($serid, "index.php?act=apidoings&do=os_template_size", 1, [], $post);
        return $details["os_template_size"];
    }
    public function check_feature($serid, $virt, $feature)
    {
        global $kernel;
        if(empty($serid)) {
            $feature_exist = $kernel->check_feature($virt, $feature);
            return $feature_exist;
        }
        $post["feature"] = $feature;
        $post["virt"] = $virt;
        $details = $this->call($serid, "index.php?act=apidoings&do=check_feature", 1, [], $post);
        return $details["check_feature"];
    }
    public function sso($serid)
    {
        global $servers;
        global $servers_keypass;
        return $this->call($serid, "index.php?act=sso", 1);
    }
    public function passthrough_dev_properties($serid, $pci_data)
    {
        global $kernel;
        if(empty($serid)) {
            $pci_props = passthrough_dev_properties($pci_data["pci_key"], $pci_data["type"], $pci_data["action"]);
            return $pci_props;
        }
        $post["pci_data"] = serialize($pci_data);
        $details = $this->call($serid, "index.php?act=apidoings&do=passthrough_dev_properties", 1, [], $post);
        return $details["pci_data"];
    }
    public function check_is_directory($serid = 0, $dir = "")
    {
        if(empty($serid)) {
            return is_dir($dir);
        }
        $post["is_dir"] = $dir;
        $details = $this->call($serid, "index.php?act=apidoings&do=check_is_directory", 1, [], $post);
        return $details["is_dir"];
    }
    public function upload_files_between_virtualizor_servers($from_server = [], $to_server = [])
    {
        if(is_master()) {
            $tranfer_servers = [$from_server, $to_server];
            foreach ($tranfer_servers as $k => &$v) {
                $tmp_ssh_port = get_slave_settings($v["serid"], "change_ssh_port");
                $v["ssh_port"] = empty($tmp_ssh_port) ? "22" : $tmp_ssh_port;
                $tmp_ips = $this->listips($v["serid"]);
                $v["public_ip"] = $tmp_ips[0];
            }
            $this->install_ssh_keys($from_server["serid"], $to_server["serid"]);
        }
        if(empty($from_server["serid"])) {
            if(empty($from_server) || empty($to_server)) {
                return false;
            }
            $ssh_command = "ssh -oStrictHostKeyChecking=no -i /var/virtualizor/ssh-keys/id_rsa -q -p " . $to_server["ssh_port"] . " root@" . $to_server["public_ip"];
            if(!is_array($to_server["file_path"])) {
                $to_server["file_path"] = (array) $to_server["file_path"];
            }
            if(!is_array($from_server["file_path"])) {
                $from_server["file_path"] = (array) $from_server["file_path"];
            }
            foreach ($to_server["file_path"] as $index => $file) {
                $to_server_parent_directory = dirname($file);
                vexec($ssh_command . " \"ls " . $to_server_parent_directory . "\"", $o, $r);
                if($r != 0) {
                    vexec($ssh_command . " \"mkdir -p " . $to_server_parent_directory . "\"", $o, $r);
                }
                $command = "scp -r -P " . $to_server["ssh_port"] . " -i /var/virtualizor/ssh-keys/id_rsa -q " . xss($from_server["file_path"][$index]) . " root@" . $to_server["public_ip"] . ":" . xss($file) . " 2>&1";
                $ret = vexec($command, $output, $ret);
            }
            return $ret;
        } else {
            $post["from_server"] = serialize($from_server);
            $post["to_server"] = serialize($to_server);
            $details = $this->call($from_server["serid"], "index.php?act=apidoings&do=upload_files_between_virtualizor_servers", 1, [], $post);
            return $details["ret"];
        }
    }
    public function check_files_on_virtualizor_server($serid, $files)
    {
        if(empty($files)) {
            $error[] = "Files not Specified";
            return ["error" => $error];
        }
        if(!is_array($files)) {
            $files = (array) $files;
        }
        if(empty($serid)) {
            foreach ($files as $file) {
                $size = vfilesize($file);
                $fileinfo = pathinfo($file);
                $info["size"] = 0;
                $info["exists"] = false;
                $info["last_modified"] = 0;
                if(file_exists($file)) {
                    $info = ["size" => $size, "exists" => true, "last_modified" => filemtime($file)];
                    $response["found"][$file]["info"] = $info;
                }
                if(!empty($fileinfo)) {
                    $response["found"][$file]["fileinfo"] = $fileinfo;
                }
                return $response;
            }
        } else {
            $post["files"] = serialize($files);
            $details = $this->call($serid, "index.php?act=apidoings&do=check_files_on_virtualizor_server", 1, [], $post);
            return $details["response"];
        }
    }
    public function ga_change_vps_timezone($serid, $vpsid, $timezone = "UTC")
    {
        global $kernel;
        if($serid == 0) {
            return $kernel->ga_exec($vpsid, "/bin/timedatectl", ["set-timezone", $timezone]);
        }
        $post["vpsid"] = $vpsid;
        $post["timezone"] = $timezone;
        $details = $this->call($serid, "index.php?act=apidoings&do=ga_change_vps_timezone", 1, [], $post);
        return $details["result"];
    }
    public function apply_vpsfirewall_rule($serid, $vpsids = [], $admin_fwid = 0, $fwid = 0, $actid = 0)
    {
        global $globals;
        global $kernel;
        global $error;
        global $l;
        if(empty($serid)) {
            if(!check_licensepro()) {
                $error[] = $l["require_prolic"];
                return false;
            }
            if(empty($admin_fwid) && empty($fwid)) {
                $error[] = $l["no_admin_fwid_and_fwid"];
                return false;
            }
            task_start($actid);
            task_update($actid, $l["vps_fwp_update_start"], 10);
            enable_iptables_forward_chain();
            vexec("iptables -t filter -L VM_TRAFFIC_IN", $output, $return);
            if(empty($output)) {
                vexec("iptables -t filter -N VM_TRAFFIC_IN ;\n\t\t\t\t\t\tiptables -t filter -N VM_TRAFFIC_OUT ;\n\t\t\t\t\t\tiptables -t filter -N VM_TRAFFIC_FORWARD ;\n\t\t\t\t\t\tiptables -t filter -I INPUT -j VM_TRAFFIC_IN ;\n\t\t\t\t\t\tiptables -t filter -I OUTPUT -j VM_TRAFFIC_OUT ;\n\t\t\t\t\t\tiptables -t filter -I FORWARD -j VM_TRAFFIC_FORWARD ;\n\t\t\t\t\t\tiptables -t filter -P FORWARD  ACCEPT;", $o, $r);
            }
            $rules = [];
            $default_policy = "";
            $admin_default_policy = "";
            task_update($actid, $l["vps_fwp_apply_rules"] . $serid, 40, "");
            $firewall_data = get_firewall_plan([$fwid, $admin_fwid]);
            if(empty($firewall_data)) {
                $error[] = $l["no_firewall_plan"];
                return false;
            }
            if(!empty($fwid)) {
                if(empty($firewall_data[$fwid])) {
                    $error[] = $l["wrong_enduser_firewall_plan"];
                    return false;
                }
                if(!empty($firewall_data[$fwid]["is_admin"])) {
                    $error[] = $l["not_enduser_firewall"];
                    return false;
                }
                $rules = json_decode($firewall_data[$fwid]["rules"]);
                $default_policy = empty($firewall_data[$fwid]["default_policy"]) ? "DROP" : "ACCEPT";
            }
            if(!empty($admin_fwid)) {
                if(empty($firewall_data[$admin_fwid])) {
                    $error[] = $l["wrong_admin_firewall_plan"];
                    return false;
                }
                if(empty($firewall_data[$admin_fwid]["is_admin"])) {
                    $error[] = $l["not_admin_firewall"];
                    return false;
                }
                $admin_rules = json_decode($firewall_data[$admin_fwid]["rules"]);
                if(!empty($rules)) {
                    $rules = array_merge($rules, $admin_rules);
                } else {
                    $rules = $admin_rules;
                }
                $admin_default_policy = empty($firewall_data[$admin_fwid]["default_policy"]) ? "DROP" : "ACCEPT";
            }
            foreach ($vpsids as $vpsid) {
                $ips = [];
                $tmp = [];
                $tmp_rules = [];
                $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid)\n\t\t\t\t\t\t\t\tWHERE i.vpsid = :vid AND i.ipv6 = 0\n\t\t\t\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vpsid]);
                for ($i = 0; $i < vsql_num_rows($res); $i++) {
                    $tmp = vsql_fetch_assoc($res);
                    $ips[$i] = $tmp["ip"];
                }
                if(empty($ips[0])) {
                    $error[] = $l["no_ips_vps"] . $vpsid;
                    return false;
                }
                foreach ($ips as $ip) {
                    $command = "";
                    $delete_command = "";
                    if(!empty($admin_default_policy)) {
                        $command .= "iptables -A VM_TRAFFIC_FORWARD -d " . $ip . " -j " . $admin_default_policy . ";";
                        $delete_command .= "iptables -D VM_TRAFFIC_FORWARD -d " . $ip . " -j " . $admin_default_policy . ";";
                    }
                    if(!empty($default_policy)) {
                        $command .= "iptables -A VM_TRAFFIC_FORWARD -d " . $ip . " -j " . $default_policy . ";";
                        $delete_command .= "iptables -D VM_TRAFFIC_FORWARD -d " . $ip . " -j " . $default_policy . ";";
                    }
                    foreach ($rules as $rule) {
                        $command .= execute_rule($rule, "I", $ip);
                        $delete_command .= execute_rule($rule, "D", $ip);
                    }
                    $tmp_rules[$vpsid][$ip] = $delete_command;
                    $command .= "iptables-save;";
                    $iptable_rule = implode(";", array_unique(explode(";", $command)));
                    vexec($iptable_rule, $output, $ret);
                }
                writefile($globals["var"] . "/firewall_rules/" . $vpsid . ".rule", json_encode($tmp_rules), 1);
            }
            if(!empty($actid)) {
                task_update($actid, $l["vps_fwp_updated"], 99);
                task_update($actid, "", 100);
            }
            return true;
        } else {
            $post = [];
            $post["svses"] = implode(",", $vpsids);
            $post["fwid"] = $fwid;
            $post["admin_fwid"] = $admin_fwid;
            $details = $this->call($serid, "index.php?act=apidoings&do=apply_vpsfirewall_rule", 1, [], $post);
            if(!empty($details["error"])) {
                $error[] = $details["error"];
                return $details["error"];
            }
            if(empty($details["apply_vpsfirewall_rule"])) {
                return false;
            }
            return $details["apply_vpsfirewall_rule"];
        }
    }
    public function delete_vpsfirewall_rule($serid, $vpsids = [], $firewall_data = [])
    {
        global $error;
        global $globals;
        global $l;
        if(empty($vpsids) || empty($firewall_data)) {
            return false;
        }
        if(empty($serid)) {
            if(!check_licensepro()) {
                $error[] = $l["require_prolic"];
                return false;
            }
            if(empty($firewall_data)) {
                $error = $l["no_firewall_data"];
                return false;
            }
            enable_iptables_forward_chain();
            $rules = json_decode($firewall_data["rules"], 1);
            if(empty($rules)) {
                $error[] = $l["no_firewall_rules"];
                return false;
            }
            foreach ($vpsids as $vpsid) {
                if(file_exists($globals["var"] . "/firewall_rules/" . $vpsid . ".rule") && is_safe_file($globals["var"] . "/firewall_rules/" . $vpsid . ".rule")) {
                    $tmp_del_rules = file_get_contents($globals["var"] . "/firewall_rules/" . $vpsid . ".rule");
                    $tmpdelrules = json_decode($tmp_del_rules, 1);
                    foreach ($tmpdelrules[$vpsid] as $_ip => $del_rules) {
                        vexec($del_rules, $deloutput, $delret);
                    }
                }
                $ips = [];
                $tmp = [];
                $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid)\n\t\t\t\t\t\t\t\tWHERE i.vpsid = :vpsid AND i.ipv6 = 0\n\t\t\t\t\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vpsid]);
                for ($i = 0; $i < vsql_num_rows($res); $i++) {
                    $tmp = vsql_fetch_assoc($res);
                    $ips[$i] = $tmp["ip"];
                }
                if(empty($ips[0])) {
                    $error[] = $l["no_ips_vps"] . $vpsid;
                    return false;
                }
                foreach ($ips as $ip) {
                    $command = "";
                    foreach ($firewall_data["policy"] as $policy) {
                        $policy = !empty($policy) ? "ACCEPT" : "DROP";
                        $command .= "iptables -D VM_TRAFFIC_FORWARD -d " . $ip . " -j " . $policy . ";";
                    }
                    foreach ($rules as $rule) {
                        $command .= execute_rule($rule, "D", $ip);
                    }
                    $command .= "iptables-save;";
                    $iptable_rule = implode(";", array_unique(explode(";", $command)));
                    vexec($iptable_rule, $output, $ret);
                }
            }
            return true;
        } else {
            $post = [];
            $post["svses"] = implode(",", $vpsids);
            $post["firewall_data"] = base64_encode(json_encode($firewall_data));
            $details = $this->call($serid, "index.php?act=apidoings&do=delete_vpsfirewall_rule", 1, [], $post);
            if(empty($details["delete_vpsfirewall_rule"])) {
                return false;
            }
            return $details["delete_vpsfirewall_rule"];
        }
    }
    public function remove_multiple_vpsfirewall($serid, $vpses_to_be_removed = [])
    {
        global $kernel;
        global $error;
        global $l;
        if($serid == 0) {
            if(empty($vpses_to_be_removed)) {
                $error[] = $l["no_data"];
                return false;
            }
            foreach ($vpses_to_be_removed as $vpsid => $vps) {
                if(!empty($vps["firewall_data"])) {
                    $this->delete_vpsfirewall_rule(0, [$vpsid], $vps["firewall_data"]);
                }
            }
            return true;
        } else {
            $post["vpses_to_be_removed"] = json_encode($vpses_to_be_removed);
            $details = $this->call($serid, "index.php?act=apidoings&do=remove_multiple_vpsfirewall", 1, [], $post);
            return $details["result"];
        }
    }
    public function apply_multiple_vpsfirewall($serid, $vpses_to_be_applied = [])
    {
        global $kernel;
        global $error;
        global $l;
        if($serid == 0) {
            if(empty($vpses_to_be_applied)) {
                $error[] = $l["no_data"];
                return false;
            }
            foreach ($vpses_to_be_applied as $vpsid => $vps) {
                if(!empty($vps["admin_fwid"]) || !empty($vps["fwid"])) {
                    $this->apply_vpsfirewall_rule(0, [$vpsid], $vps["admin_fwid"], $vps["fwid"]);
                }
            }
            return true;
        } else {
            $post["vpses_to_be_applied"] = json_encode($vpses_to_be_applied);
            $details = $this->call($serid, "index.php?act=apidoings&do=apply_multiple_vpsfirewall", 1, [], $post);
            return $details["result"];
        }
    }
}

?>